/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     stdlib.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file for stdlib.c.
*
* Notes:        
*
******************************************************************************/

#define printf printD
#define sprintf sprintD

int isspace (int ch);
int isalnum (int ch);
int isdigit (int ch);
int isupper (int ch);
int strcasecmp (const char *s1, const char *s2);
int strncasecmp (const char *s1, const char *s2, int n);
unsigned long strtoul (char *str, char **ptr, int base);
int strlen (const char *str);
char * strcat (char *dest, const char *src);
char * strncat (char *dest, const char *src, int n);
char * strcpy (char *dest, const char *src);
char * strncpy (char *dest, const char *src, int n);
int strcmp (const char *s1, const char *s2);
int strncmp (const char *s1, const char *s2, int n);
void * memcpy (void *dest, const void *src, unsigned n);
void * memset (void *s, int c, unsigned n);

int printD (const char *fmt, ...);
int sprintD (char *s, const char *fmt, ...);
