/* ###################################################################
**     Filename    : Events.c
**     Project     : ClassD-V1_1
**     Processor   : MKV10Z32VLF7
**     Component   : Events
**     Version     : Driver 01.00
**     Compiler    : GNU C Compiler
**     Date/Time   : 2015-05-30, 11:36, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Contents    :
**         Cpu_OnNMI - void Cpu_OnNMI(void);
**
** ###################################################################*/
/*!
** @file Events.c
** @version 01.00
** @brief
**         This is user's event module.
**         Put your event handler code here.
*/         
/*!
**  @addtogroup Events_module Events module documentation
**  @{
*/         
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"
#include "Init_Config.h"
#include "PDD_Includes.h"
#include "Audio.h"

#ifdef __cplusplus
extern "C" {
#endif 


/* User includes (#include below this line is not maintained by Processor Expert) */

/*
** ===================================================================
**     Event       :  Cpu_OnNMI (module Events)
**
**     Component   :  Cpu [MKV10Z32LF7]
*/
/*!
**     @brief
**         This event is called when the Non maskable interrupt had
**         occurred. This event is automatically enabled when the [NMI
**         interrupt] property is set to 'Enabled'.
*/
/* ===================================================================*/
void Cpu_OnNMI(void)
{
  /* Write your code here ... */
}

/*
** ===================================================================
**     Event       :  AD1_OnEnd (module Events)
**
**     Component   :  AD1 [ADC]
**     Description :
**         This event is called after the measurement (which consists
**         of <1 or more conversions>) is/are finished.
**         The event is available only when the <Interrupt
**         service/event> property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void AD1_OnEnd(void)
{
	static uint16_t ADC_16_Bits;                                               //Variable to store the ADC value in 16 bit
	AD1_GetChanValue16(1, &ADC_16_Bits);                                       //Get the measured data from ADC
	Store_Audio(Audio_Expansion(ADC_16_Bits));                                 //Convert to 10 bits and store it

}

/*
** ===================================================================
**     Event       :  AD1_OnCalibrationEnd (module Events)
**
**     Component   :  AD1 [ADC]
**     Description :
**         This event is called when the calibration has been finished.
**         User should check if the calibration pass or fail by
**         Calibration status method./nThis event is enabled only if
**         the <Interrupt service/event> property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void AD1_OnCalibrationEnd(void)
{
  /* Write your code here ... */
}


/*
** ===================================================================
**     Event       :  FTM0_Timer_Overflow_ISR (module Events)
**
**     Component   :  FTM0
**     Description :
**         This event is called when an overflow occurs at FTM0 counter
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
PE_ISR(FTM0_Timer_Overflow_ISR)
{
	signed int Value_To_Update_Channels;                                              //Variable used to store the ADC value to update the channels
    int Debug_Mode = 0;           // For debug
    static int Past_ADC_Value = 0;                                             //Past measured ADC value
    static int Count  = 0;                                                     //Variable to count the amount of interrupts. to calculate the average

	PTC0_Debug_Pin_SetVal();  //for debug


	if(Debug_Mode == 0){   // if is not at debugging mode, update the FTM with sound

		AD1_MeasureChan(0, 1);					                               //Trigger for Channel 1 measure, doesn't wait for the conversion complete
		if(Get_Mute_Status() == FALSE){                                        //If not at Mute, play audio
			//	Cpu_DisableInt();						                       //Disable all interrupts as writing to PWM buffers are a critical event
			Value_To_Update_Channels = Get_Stored_Audio();                     //Get the ADC measured value

			//if(Count >= 1){                                                    //Used to make average, so every 2 interrupts the average ADC value is updated
			//	Value_To_Update_Channels = (Past_ADC_Value + Value_To_Update_Channels)/2; //averaging
				FTM0_C0V = Value_To_Update_Channels;	                       //Write to Channel values
				FTM0_C1V = Value_To_Update_Channels;
				FTM0_C2V = Value_To_Update_Channels;
				FTM0_C3V = Value_To_Update_Channels;
			//}
			//else{
			//	Past_ADC_Value = Value_To_Update_Channels;
			//	Count++;
			//}



			//	Cpu_EnableInt();						                           //Enable all masked interrupts again
		}
		else{
			Mute_Audio();
		}
	}
	else{          //If in debug mode, just set a constant 50% duty cycle

		Value_To_Update_Channels = 512;
		FTM0_C0V = Value_To_Update_Channels;	                                   //Write to Channel values
		FTM0_C2V = Value_To_Update_Channels;
	}


	FTM0_SC = FTM0_SC & ~0x00000080;		                                   //clear Timer Output Overflow Flag (TOF)
	PTC0_Debug_Pin_ClrVal(); //for debug
}

/* END Events */

#ifdef __cplusplus
}  /* extern "C" */
#endif 

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
