/* ###################################################################
**     Filename    : main.c
**     Project     : ClassD-V1_1
**     Processor   : MKV10Z32VLF7
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2015-05-30, 11:36, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.01
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Pins1.h"
#include "Enable_Push_Pull.h"
#include "BitIoLdd1.h"
#include "LED_Green.h"
#include "BitIoLdd2.h"
#include "LED_Orange.h"
#include "BitIoLdd4.h"
#include "AD1.h"
#include "AdcLdd1.h"
#include "LED_Red.h"
#include "BitIoLdd3.h"
#include "PTC0_Debug_Pin.h"
#include "BitIoLdd5.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PDD_Includes.h"
#include "Init_Config.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "Power_Supply.h"
#include "Audio.h"

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  Power_Supply_Init();                                                         //Start up the power supply

  AD1_Enable();                                                                //Enable ADC
  AD1_Calibrate(1);                                                            //Calibrate ADC
  AD1_EnableEvent();
  Audio_Init();                                                                //Initialize the Audio

  //ADC1_PG = 0xFFFF;                                                          //ADC Plus-Side Gain Register (for testing)
  //ADC1_MG = 0xFFFF;                                                          //ADC Minus-Side Gain Register (for testing)

  for(;;){

	  Mute_Check();                                                            //Check if the audio is on Mute or not

  }

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
