/*
  PDD layer implementation for peripheral type NVIC
  (C) 2013 Freescale, Inc. All rights reserved.

  This file is static and it is generated from API-Factory
*/

#if !defined(NVIC_PDD_H_)
#define NVIC_PDD_H_

/* ----------------------------------------------------------------------------
   -- Test if supported MCU is active
   ---------------------------------------------------------------------------- */

#if !defined(MCU_ACTIVE)
  // No MCU is active
  #error NVIC PDD library: No derivative is active. Place proper #include with PDD memory map before including PDD library.
#elif \
      !defined(MCU_MKE04Z1284) /* NVIC */ && \
      !defined(MCU_MKE06Z4) /* NVIC */ && \
      !defined(MCU_MKV10Z7) /* NVIC */ && \
      !defined(MCU_MKW01Z4) /* NVIC */ && \
      !defined(MCU_MKW21D5) /* NVIC */ && \
      !defined(MCU_MKW21D5WS) /* NVIC */ && \
      !defined(MCU_MKW22D5) /* NVIC */ && \
      !defined(MCU_MKW22D5WS) /* NVIC */ && \
      !defined(MCU_MKW24D5) /* NVIC */ && \
      !defined(MCU_MKW24D5WS) /* NVIC */ && \
      !defined(MCU_SKEAZ1284) /* NVIC */
  // Unsupported MCU is active
  #error NVIC PDD library: Unsupported derivative is active.
#endif

#include "PDD_Types.h"

/* ----------------------------------------------------------------------------
   -- Method symbol definitions
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKE04Z1284))
/* Interrupts' mask */
  #define NVIC_PDD_FTMRE_INTERRUPT_MASK    NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_LVD_LLW_INTERRUPT_MASK  NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_IRQ_INTERRUPT_MASK      NVIC_ISER_SETENA7_MASK /**< External Interrupt interrupt vector 23 mask. */
  #define NVIC_PDD_I2C0_INTERRUPT_MASK     NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_I2C1_INTERRUPT_MASK     NVIC_ISER_SETENA9_MASK /**< Inter-Integrated Circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_SPI0_INTERRUPT_MASK     NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_SPI1_INTERRUPT_MASK     NVIC_ISER_SETENA11_MASK /**< Serial Peripheral Interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_UART0_INTERRUPT_MASK    NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_UART1_INTERRUPT_MASK    NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_UART2_INTERRUPT_MASK    NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_ADC0_INTERRUPT_MASK     NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_ACMP0_INTERRUPT_MASK    NVIC_ISER_SETENA16_MASK /**< Analog comparator 0 interrupt interrupt vector 32 mask. */
  #define NVIC_PDD_FTM0_INTERRUPT_MASK     NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_FTM1_INTERRUPT_MASK     NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_FTM2_INTERRUPT_MASK     NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_RTC_INTERRUPT_MASK      NVIC_ISER_SETENA20_MASK /**< Real-time counter interrupt vector 36 mask. */
  #define NVIC_PDD_ACMP1_INTERRUPT_MASK    NVIC_ISER_SETENA21_MASK /**< Analog comparator 1 interrupt interrupt vector 37 mask. */
  #define NVIC_PDD_PIT_CH0_INTERRUPT_MASK  NVIC_ISER_SETENA22_MASK /**< Periodic timer overflow channel 0 interrupt vector 38 mask. */
  #define NVIC_PDD_PIT_CH1_INTERRUPT_MASK  NVIC_ISER_SETENA23_MASK /**< Periodic timer overflow channel 1 interrupt vector 39 mask. */
  #define NVIC_PDD_KBI0_INTERRUPT_MASK     NVIC_ISER_SETENA24_MASK /**< Keyboard interrupt interrupt vector 40 mask. */
  #define NVIC_PDD_KBI1_INTERRUPT_MASK     NVIC_ISER_SETENA25_MASK /**< Keyboard interrupt interrupt vector 41 mask. */
  #define NVIC_PDD_ICS_INTERRUPT_MASK      NVIC_ISER_SETENA27_MASK /**< Clock loss of lock interrupt vector 43 mask. */
  #define NVIC_PDD_WDOG_EWM_INTERRUPT_MASK NVIC_ISER_SETENA28_MASK /**< WDOG interrupt vector 44 mask. */
  #define NVIC_PDD_PWT_INTERRUPT_MASK      NVIC_ISER_SETENA29_MASK /**< Pulse width timer interrupt vector 45 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR21_MASK NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR22_MASK NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR23_MASK NVIC_ISER_SETENA7_MASK /**< External Interrupt interrupt vector 23 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR24_MASK NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR25_MASK NVIC_ISER_SETENA9_MASK /**< Inter-Integrated Circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR26_MASK NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR27_MASK NVIC_ISER_SETENA11_MASK /**< Serial Peripheral Interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR28_MASK NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR29_MASK NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR30_MASK NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR31_MASK NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR32_MASK NVIC_ISER_SETENA16_MASK /**< Analog comparator 0 interrupt interrupt vector 32 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR33_MASK NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR34_MASK NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR35_MASK NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR36_MASK NVIC_ISER_SETENA20_MASK /**< Real-time counter interrupt vector 36 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR37_MASK NVIC_ISER_SETENA21_MASK /**< Analog comparator 1 interrupt interrupt vector 37 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR38_MASK NVIC_ISER_SETENA22_MASK /**< Periodic timer overflow channel 0 interrupt vector 38 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR39_MASK NVIC_ISER_SETENA23_MASK /**< Periodic timer overflow channel 1 interrupt vector 39 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR40_MASK NVIC_ISER_SETENA24_MASK /**< Keyboard interrupt interrupt vector 40 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR41_MASK NVIC_ISER_SETENA25_MASK /**< Keyboard interrupt interrupt vector 41 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR43_MASK NVIC_ISER_SETENA27_MASK /**< Clock loss of lock interrupt vector 43 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR44_MASK NVIC_ISER_SETENA28_MASK /**< WDOG interrupt vector 44 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR45_MASK NVIC_ISER_SETENA29_MASK /**< Pulse width timer interrupt vector 45 mask. */

#elif (defined(MCU_MKV10Z7))
/* Interrupts' mask */
  #define NVIC_PDD_DMA0_INTERRUPT_MASK      NVIC_ISER_SETENA0_MASK /**< DMA channel 0 transfer complete interrupt vector 16 mask. */
  #define NVIC_PDD_DMA1_INTERRUPT_MASK      NVIC_ISER_SETENA1_MASK /**< DMA channel 1 transfer complete interrupt vector 17 mask. */
  #define NVIC_PDD_DMA2_INTERRUPT_MASK      NVIC_ISER_SETENA2_MASK /**< DMA channel 2 transfer complete interrupt vector 18 mask. */
  #define NVIC_PDD_DMA3_INTERRUPT_MASK      NVIC_ISER_SETENA3_MASK /**< DMA channel 3 transfer complete interrupt vector 19 mask. */
  #define NVIC_PDD_DMA_ERROR_INTERRUPT_MASK NVIC_ISER_SETENA4_MASK /**< DMA channel 0 1 2 3 error interrupt vector 20 mask. */
  #define NVIC_PDD_FTFA_INTERRUPT_MASK      NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_PMC_INTERRUPT_MASK       NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_LLWU_INTERRUPT_MASK      NVIC_ISER_SETENA7_MASK /**< Low Leakage Wakeup interrupt vector 23 mask. */
  #define NVIC_PDD_I2C0_INTERRUPT_MASK      NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_SPI0_INTERRUPT_MASK      NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_UART0_INTERRUPT_MASK     NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_UART1_INTERRUPT_MASK     NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_ADC0_INTERRUPT_MASK      NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_ADC1_INTERRUPT_MASK      NVIC_ISER_SETENA16_MASK /**< Analog-to-Digital Converter 1 interrupt vector 32 mask. */
  #define NVIC_PDD_FTM0_INTERRUPT_MASK      NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_FTM1_INTERRUPT_MASK      NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_FTM2_INTERRUPT_MASK      NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_CMP0_INTERRUPT_MASK      NVIC_ISER_SETENA20_MASK /**< Comparator 0 interrupt vector 36 mask. */
  #define NVIC_PDD_CMP1_INTERRUPT_MASK      NVIC_ISER_SETENA21_MASK /**< Comparator 1 interrupt vector 37 mask. */
  #define NVIC_PDD_WDOG_EWM_INTERRUPT_MASK  NVIC_ISER_SETENA23_MASK /**< WDOG and EWM interrupt vector 39 mask. */
  #define NVIC_PDD_DAC0_INTERRUPT_MASK      NVIC_ISER_SETENA25_MASK /**< Digital-to-Analog Converter 0 interrupt vector 41 mask. */
  #define NVIC_PDD_MCG_INTERRUPT_MASK       NVIC_ISER_SETENA27_MASK /**< Multipurpose Clock Generator interrupt vector 43 mask. */
  #define NVIC_PDD_LPTMR0_INTERRUPT_MASK    NVIC_ISER_SETENA28_MASK /**< Low-Power Timer interrupt vector 44 mask. */
  #define NVIC_PDD_PDB0_INTERRUPT_MASK      NVIC_ISER_SETENA29_MASK /**< Programmable Delay Block interrupt vector 45 mask. */
  #define NVIC_PDD_PORTA_INTERRUPT_MASK     NVIC_ISER_SETENA30_MASK /**< GPIOA Pin detect interrupt vector 46 mask. */
  #define NVIC_PDD_PORTBCDE_INTERRUPT_MASK  NVIC_ISER_SETENA31_MASK /**< GPIOB, GPIOC, GPIOD and GPIOE Pin detect interrupt vector 47 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR16_MASK  NVIC_ISER_SETENA0_MASK /**< DMA channel 0 transfer complete interrupt vector 16 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR17_MASK  NVIC_ISER_SETENA1_MASK /**< DMA channel 1 transfer complete interrupt vector 17 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR18_MASK  NVIC_ISER_SETENA2_MASK /**< DMA channel 2 transfer complete interrupt vector 18 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR19_MASK  NVIC_ISER_SETENA3_MASK /**< DMA channel 3 transfer complete interrupt vector 19 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR20_MASK  NVIC_ISER_SETENA4_MASK /**< DMA channel 0 1 2 3 error interrupt vector 20 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR21_MASK  NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR22_MASK  NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR23_MASK  NVIC_ISER_SETENA7_MASK /**< Low Leakage Wakeup interrupt vector 23 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR24_MASK  NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR26_MASK  NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR28_MASK  NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR29_MASK  NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR31_MASK  NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR32_MASK  NVIC_ISER_SETENA16_MASK /**< Analog-to-Digital Converter 1 interrupt vector 32 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR33_MASK  NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR34_MASK  NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR35_MASK  NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR36_MASK  NVIC_ISER_SETENA20_MASK /**< Comparator 0 interrupt vector 36 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR37_MASK  NVIC_ISER_SETENA21_MASK /**< Comparator 1 interrupt vector 37 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR39_MASK  NVIC_ISER_SETENA23_MASK /**< WDOG and EWM interrupt vector 39 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR41_MASK  NVIC_ISER_SETENA25_MASK /**< Digital-to-Analog Converter 0 interrupt vector 41 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR43_MASK  NVIC_ISER_SETENA27_MASK /**< Multipurpose Clock Generator interrupt vector 43 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR44_MASK  NVIC_ISER_SETENA28_MASK /**< Low-Power Timer interrupt vector 44 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR45_MASK  NVIC_ISER_SETENA29_MASK /**< Programmable Delay Block interrupt vector 45 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR46_MASK  NVIC_ISER_SETENA30_MASK /**< GPIOA Pin detect interrupt vector 46 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR47_MASK  NVIC_ISER_SETENA31_MASK /**< GPIOB, GPIOC, GPIOD and GPIOE Pin detect interrupt vector 47 mask. */

#elif (defined(MCU_MKW01Z4))
/* Interrupts' mask */
  #define NVIC_PDD_DMA0_INTERRUPT_MASK        NVIC_ISER_SETENA0_MASK /**< DMA channel 0 transfer complete and error interrupt vector 16 mask. */
  #define NVIC_PDD_DMA1_INTERRUPT_MASK        NVIC_ISER_SETENA1_MASK /**< DMA channel 1 transfer complete and error interrupt vector 17 mask. */
  #define NVIC_PDD_DMA2_INTERRUPT_MASK        NVIC_ISER_SETENA2_MASK /**< DMA channel 2 transfer complete and error interrupt vector 18 mask. */
  #define NVIC_PDD_DMA3_INTERRUPT_MASK        NVIC_ISER_SETENA3_MASK /**< DMA channel 3 transfer complete and error interrupt vector 19 mask. */
  #define NVIC_PDD_FTFA_INTERRUPT_MASK        NVIC_ISER_SETENA5_MASK /**< FTFA command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_LVD_LVW_INTERRUPT_MASK     NVIC_ISER_SETENA6_MASK /**< low-voltage detect and low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_LLWU_INTERRUPT_MASK        NVIC_ISER_SETENA7_MASK /**< low leakage wakeup interrupt vector 23 mask. */
  #define NVIC_PDD_I2C0_INTERRUPT_MASK        NVIC_ISER_SETENA8_MASK /**< inter-integrated circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_I2C1_INTERRUPT_MASK        NVIC_ISER_SETENA9_MASK /**< inter-integrated circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_SPI0_INTERRUPT_MASK        NVIC_ISER_SETENA10_MASK /**< serial peripheral interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_SPI1_INTERRUPT_MASK        NVIC_ISER_SETENA11_MASK /**< serial peripheral interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_UART0_INTERRUPT_MASK       NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_UART1_INTERRUPT_MASK       NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_UART2_INTERRUPT_MASK       NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_ADC0_INTERRUPT_MASK        NVIC_ISER_SETENA15_MASK /**< Analog-to-digital converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_CMP0_INTERRUPT_MASK        NVIC_ISER_SETENA16_MASK /**< Comparator 0 interrupt vector 32 mask. */
  #define NVIC_PDD_TPM0_INTERRUPT_MASK        NVIC_ISER_SETENA17_MASK /**< Timer PWM module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_TPM1_INTERRUPT_MASK        NVIC_ISER_SETENA18_MASK /**< Timer PWM module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_TPM2_INTERRUPT_MASK        NVIC_ISER_SETENA19_MASK /**< Timer PWM module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_RTC_INTERRUPT_MASK         NVIC_ISER_SETENA20_MASK /**< real time clock alarm interrupt vector 36 mask. */
  #define NVIC_PDD_RTC_SECONDS_INTERRUPT_MASK NVIC_ISER_SETENA21_MASK /**< real time clock seconds interrupt vector 37 mask. */
  #define NVIC_PDD_PIT_INTERRUPT_MASK         NVIC_ISER_SETENA22_MASK /**< periodic interrupt timer all channels interrupt vector 38 mask. */
  #define NVIC_PDD_DAC0_INTERRUPT_MASK        NVIC_ISER_SETENA25_MASK /**< digital-to-analog converter 0 interrupt vector 41 mask. */
  #define NVIC_PDD_TSI0_INTERRUPT_MASK        NVIC_ISER_SETENA26_MASK /**< touch sensing input interrupt vector 42 mask. */
  #define NVIC_PDD_MCG_INTERRUPT_MASK         NVIC_ISER_SETENA27_MASK /**< multipurpose clock generator interrupt vector 43 mask. */
  #define NVIC_PDD_LPTMR0_INTERRUPT_MASK      NVIC_ISER_SETENA28_MASK /**< Low-Power Timer interrupt vector 44 mask. */
  #define NVIC_PDD_PORTA_INTERRUPT_MASK       NVIC_ISER_SETENA30_MASK /**< PORTA pin detect interrupt vector 46 mask. */
  #define NVIC_PDD_PORTC_PORTD_INTERRUPT_MASK NVIC_ISER_SETENA31_MASK /**< PORTC and PORTD pin detect interrupt vector 47 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR16_MASK    NVIC_ISER_SETENA0_MASK /**< DMA channel 0 transfer complete and error interrupt vector 16 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR17_MASK    NVIC_ISER_SETENA1_MASK /**< DMA channel 1 transfer complete and error interrupt vector 17 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR18_MASK    NVIC_ISER_SETENA2_MASK /**< DMA channel 2 transfer complete and error interrupt vector 18 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR19_MASK    NVIC_ISER_SETENA3_MASK /**< DMA channel 3 transfer complete and error interrupt vector 19 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR21_MASK    NVIC_ISER_SETENA5_MASK /**< FTFA command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR22_MASK    NVIC_ISER_SETENA6_MASK /**< low-voltage detect and low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR23_MASK    NVIC_ISER_SETENA7_MASK /**< low leakage wakeup interrupt vector 23 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR24_MASK    NVIC_ISER_SETENA8_MASK /**< inter-integrated circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR25_MASK    NVIC_ISER_SETENA9_MASK /**< inter-integrated circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR26_MASK    NVIC_ISER_SETENA10_MASK /**< serial peripheral interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR27_MASK    NVIC_ISER_SETENA11_MASK /**< serial peripheral interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR28_MASK    NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR29_MASK    NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR30_MASK    NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR31_MASK    NVIC_ISER_SETENA15_MASK /**< Analog-to-digital converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR32_MASK    NVIC_ISER_SETENA16_MASK /**< Comparator 0 interrupt vector 32 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR33_MASK    NVIC_ISER_SETENA17_MASK /**< Timer PWM module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR34_MASK    NVIC_ISER_SETENA18_MASK /**< Timer PWM module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR35_MASK    NVIC_ISER_SETENA19_MASK /**< Timer PWM module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR36_MASK    NVIC_ISER_SETENA20_MASK /**< real time clock alarm interrupt vector 36 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR37_MASK    NVIC_ISER_SETENA21_MASK /**< real time clock seconds interrupt vector 37 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR38_MASK    NVIC_ISER_SETENA22_MASK /**< periodic interrupt timer all channels interrupt vector 38 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR41_MASK    NVIC_ISER_SETENA25_MASK /**< digital-to-analog converter 0 interrupt vector 41 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR42_MASK    NVIC_ISER_SETENA26_MASK /**< touch sensing input interrupt vector 42 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR43_MASK    NVIC_ISER_SETENA27_MASK /**< multipurpose clock generator interrupt vector 43 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR44_MASK    NVIC_ISER_SETENA28_MASK /**< Low-Power Timer interrupt vector 44 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR46_MASK    NVIC_ISER_SETENA30_MASK /**< PORTA pin detect interrupt vector 46 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR47_MASK    NVIC_ISER_SETENA31_MASK /**< PORTC and PORTD pin detect interrupt vector 47 mask. */

#else /* (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)) */
/* Interrupts' mask */
  #define NVIC_PDD_FTMRE_INTERRUPT_MASK    NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_LVD_LLW_INTERRUPT_MASK  NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_IRQ_INTERRUPT_MASK      NVIC_ISER_SETENA7_MASK /**< External Interrupt interrupt vector 23 mask. */
  #define NVIC_PDD_I2C0_INTERRUPT_MASK     NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_I2C1_INTERRUPT_MASK     NVIC_ISER_SETENA9_MASK /**< Inter-Integrated Circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_SPI0_INTERRUPT_MASK     NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_SPI1_INTERRUPT_MASK     NVIC_ISER_SETENA11_MASK /**< Serial Peripheral Interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_UART0_INTERRUPT_MASK    NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_UART1_INTERRUPT_MASK    NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_UART2_INTERRUPT_MASK    NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_ADC0_INTERRUPT_MASK     NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_ACMP0_INTERRUPT_MASK    NVIC_ISER_SETENA16_MASK /**< Analog comparator 0 interrupt interrupt vector 32 mask. */
  #define NVIC_PDD_FTM0_INTERRUPT_MASK     NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_FTM1_INTERRUPT_MASK     NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_FTM2_INTERRUPT_MASK     NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_RTC_INTERRUPT_MASK      NVIC_ISER_SETENA20_MASK /**< Real-time counter interrupt vector 36 mask. */
  #define NVIC_PDD_ACMP1_INTERRUPT_MASK    NVIC_ISER_SETENA21_MASK /**< Analog comparator 1 interrupt interrupt vector 37 mask. */
  #define NVIC_PDD_PIT_CH0_INTERRUPT_MASK  NVIC_ISER_SETENA22_MASK /**< Periodic timer overflow channel 0 interrupt vector 38 mask. */
  #define NVIC_PDD_PIT_CH1_INTERRUPT_MASK  NVIC_ISER_SETENA23_MASK /**< Periodic timer overflow channel 1 interrupt vector 39 mask. */
  #define NVIC_PDD_KBI0_INTERRUPT_MASK     NVIC_ISER_SETENA24_MASK /**< Keyboard interrupt interrupt vector 40 mask. */
  #define NVIC_PDD_KBI1_INTERRUPT_MASK     NVIC_ISER_SETENA25_MASK /**< Keyboard interrupt interrupt vector 41 mask. */
  #define NVIC_PDD_ICS_INTERRUPT_MASK      NVIC_ISER_SETENA27_MASK /**< Clock loss of lock interrupt vector 43 mask. */
  #define NVIC_PDD_WDOG_EWM_INTERRUPT_MASK NVIC_ISER_SETENA28_MASK /**< WDOG interrupt vector 44 mask. */
  #define NVIC_PDD_PWT_INTERRUPT_MASK      NVIC_ISER_SETENA29_MASK /**< Pulse width timer interrupt vector 45 mask. */
  #define NVIC_PDD_MSCAN_RX_INTERRUPT_MASK NVIC_ISER_SETENA30_MASK /**< Freescale's Scalable Controller Area Network Rx interrupt vector 46 mask. */
  #define NVIC_PDD_MSCAN_TX_INTERRUPT_MASK NVIC_ISER_SETENA31_MASK /**< Freescale's Scalable Controller Area Network Tx and error interrupt vector 47 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR21_MASK NVIC_ISER_SETENA5_MASK /**< Command complete and read collision interrupt vector 21 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR22_MASK NVIC_ISER_SETENA6_MASK /**< Low-voltage detect, low-voltage warning interrupt vector 22 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR23_MASK NVIC_ISER_SETENA7_MASK /**< External Interrupt interrupt vector 23 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR24_MASK NVIC_ISER_SETENA8_MASK /**< Inter-Integrated Circuit 0 interrupt vector 24 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR25_MASK NVIC_ISER_SETENA9_MASK /**< Inter-Integrated Circuit 1 interrupt vector 25 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR26_MASK NVIC_ISER_SETENA10_MASK /**< Serial Peripheral Interface 0 interrupt vector 26 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR27_MASK NVIC_ISER_SETENA11_MASK /**< Serial Peripheral Interface 1 interrupt vector 27 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR28_MASK NVIC_ISER_SETENA12_MASK /**< UART0 status and error interrupt vector 28 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR29_MASK NVIC_ISER_SETENA13_MASK /**< UART1 status and error interrupt vector 29 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR30_MASK NVIC_ISER_SETENA14_MASK /**< UART2 status and error interrupt vector 30 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR31_MASK NVIC_ISER_SETENA15_MASK /**< Analog-to-Digital Converter 0 interrupt vector 31 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR32_MASK NVIC_ISER_SETENA16_MASK /**< Analog comparator 0 interrupt interrupt vector 32 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR33_MASK NVIC_ISER_SETENA17_MASK /**< FlexTimer Module 0 interrupt vector 33 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR34_MASK NVIC_ISER_SETENA18_MASK /**< FlexTimer Module 1 interrupt vector 34 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR35_MASK NVIC_ISER_SETENA19_MASK /**< FlexTimer Module 2 interrupt vector 35 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR36_MASK NVIC_ISER_SETENA20_MASK /**< Real-time counter interrupt vector 36 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR37_MASK NVIC_ISER_SETENA21_MASK /**< Analog comparator 1 interrupt interrupt vector 37 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR38_MASK NVIC_ISER_SETENA22_MASK /**< Periodic timer overflow channel 0 interrupt vector 38 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR39_MASK NVIC_ISER_SETENA23_MASK /**< Periodic timer overflow channel 1 interrupt vector 39 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR40_MASK NVIC_ISER_SETENA24_MASK /**< Keyboard interrupt interrupt vector 40 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR41_MASK NVIC_ISER_SETENA25_MASK /**< Keyboard interrupt interrupt vector 41 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR43_MASK NVIC_ISER_SETENA27_MASK /**< Clock loss of lock interrupt vector 43 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR44_MASK NVIC_ISER_SETENA28_MASK /**< WDOG interrupt vector 44 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR45_MASK NVIC_ISER_SETENA29_MASK /**< Pulse width timer interrupt vector 45 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR46_MASK NVIC_ISER_SETENA30_MASK /**< Freescale's Scalable Controller Area Network Rx interrupt vector 46 mask. */
  #define NVIC_PDD_INTERRUPT_VECTOR47_MASK NVIC_ISER_SETENA31_MASK /**< Freescale's Scalable Controller Area Network Tx and error interrupt vector 47 mask. */

#endif /* (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)) */

/* ----------------------------------------------------------------------------
   -- SetFtmrePriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Command complete and read collision
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtmrePriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetFtmrePriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,1U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetPmcPriority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Low-voltage detect, low-voltage
 * warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPmcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPmcPriority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the PMC controller low-voltage detect,
 * low-voltage warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPmcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPmcPriority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,20U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetIrqPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the External Interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetIrqPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetIrqPriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,1U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetI2C0Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Inter-Integrated Circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,24U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetI2C1Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Inter-Integrated Circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,25U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetSpi0Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Serial Peripheral Interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,26U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetSpi1Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Serial Peripheral Interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,27U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetUart0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the UART0 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetUart0Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,3U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
      (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetUart1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the UART1 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetUart1Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,3U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetUart2Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the UART2 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart2Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetUart2Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,3U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetAdcPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Analog-to-Digital Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAdcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetAdcPriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,3U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetAcmp0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Analog comparator 0 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAcmp0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetAcmp0Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,4U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
      (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetFtm0Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the FlexTimer module 0 fault, overflow
 * and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm0Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,42U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetFtm1Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the FlexTimer module 1 fault, overflow
 * and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm1Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,43U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetFtm2Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm2Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm2Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the FlexTimer module 2 fault, overflow
 * and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm2Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm2Priority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,44U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetRtcPriority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the real time clock alarm interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPriority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Real-time counter interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPriority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the real time clock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPriority(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,46U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetAcmp1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Analog comparator 1 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAcmp1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetAcmp1Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,5U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetPitCh0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Periodic timer overflow channel 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPitCh0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetPitCh0Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,5U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetPitCh1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Periodic timer overflow channel 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPitCh1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetPitCh1Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,5U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetKbi0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetKbi0Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetKbi0Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,6U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
      (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetKbi1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetKbi1Priority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetKbi1Priority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,6U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetIcsPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Clock loss of lock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetIcsPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetIcsPriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,6U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetWdogPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the WDOG interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetWdogPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetWdogPriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,7U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
      (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- SetPwtPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Sets the interrupt priority of the Pulse width timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPwtPriority(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
#define NVIC_PDD_SetPwtPriority(PeripheralBase, Priority) ( \
    NVIC_IP_REG(PeripheralBase,7U) = \
     (uint32_t)(( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
      (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
  )

/* ----------------------------------------------------------------------------
   -- GetFtmrePriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Command complete and read
 * collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtmrePriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetFtmrePriority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
     8U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetPmcPriority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Low-voltage detect, low-voltage
 * warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPmcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcPriority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the PMC controller low-voltage
 * detect, low-voltage warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPmcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcPriority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,20U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetIrqPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the External Interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIrqPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIrqPriority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
     24U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetI2C0Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Priority(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Inter-Integrated Circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Priority(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetI2C0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,24U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetI2C1Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Inter-Integrated Circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetI2C1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,25U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi0Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Serial Peripheral Interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetSpi0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,26U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi1Priority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Serial Peripheral Interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetSpi1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,27U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetUart0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the UART0 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart0Priority(PeripheralBase) ( \
    (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the UART1 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart1Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
     8U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart2Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the UART2 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart2Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart2Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
     16U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetAdcPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Analog-to-Digital Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAdcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAdcPriority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
     24U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetAcmp0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Analog comparator 0 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp0Priority(PeripheralBase) ( \
    (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
  )

/* ----------------------------------------------------------------------------
   -- GetFtm0Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the FlexTimer module 0 fault,
 * overflow and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetFtm0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,42U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm1Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the FlexTimer module 1 fault,
 * overflow and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetFtm1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,43U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm2Priority
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm2Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Priority(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the FlexTimer module 2 fault,
 * overflow and channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetFtm2Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Priority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,44U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetRtcPriority
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the real time clock alarm interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPriority(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Real-time counter interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPriority(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the real time clock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetRtcPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPriority(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,46U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetAcmp1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Analog comparator 1 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp1Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
     8U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Periodic timer overflow channel
 * 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh0Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
     16U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Periodic timer overflow channel
 * 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh1Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
     24U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi0Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi0Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi0Priority(PeripheralBase) ( \
    (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi1Priority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi1Priority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi1Priority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
     8U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetIcsPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Clock loss of lock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIcsPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIcsPriority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
     24U)) \
  )

/* ----------------------------------------------------------------------------
   -- GetWdogPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the WDOG interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetWdogPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetWdogPriority(PeripheralBase) ( \
    (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
  )

/* ----------------------------------------------------------------------------
   -- GetPwtPriority
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns the interrupt priority of the Pulse width timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPwtPriority(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPwtPriority(PeripheralBase) ( \
    (uint32_t)(( \
     (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
     8U)) \
  )

/* ----------------------------------------------------------------------------
   -- SetPriorityVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the FTFA command complete and read
 * collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector21(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector21(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Command complete and read collision
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector21(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector21(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 5 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector21(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector21(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the low-voltage detect and low-voltage
 * warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector22(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector22(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Low-voltage detect, low-voltage
 * warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector22(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector22(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 6 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector22(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector22(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Low Leakage Wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector23(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector23(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the low leakage wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector23(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector23(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the External Interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector23(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector23(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,1U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 7 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector23(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector23(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,7U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector24(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector24(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Inter-Integrated Circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector24(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector24(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 8 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector24(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector24(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,8U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector25(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector25(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Inter-Integrated Circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector25(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector25(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 9 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector25(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector25(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,9U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector26(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector26(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Serial Peripheral Interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector26(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector26(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 10 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector26(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector26(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,10U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector27(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector27(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Serial Peripheral Interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector27(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector27(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,2U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 11 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector27(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector27(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,11U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the UART0 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector28(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector28(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,3U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 12 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector28(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector28(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,12U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the UART1 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector29(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector29(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,3U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 13 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector29(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector29(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,13U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the UART2 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector30(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector30(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,3U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 14 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector30(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector30(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,14U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the Analog-to-digital converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector31(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector31(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,3U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Analog-to-Digital Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector31(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector31(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,3U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 15 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector31(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector31(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,15U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Analog-to-Digital Converter 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector32(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector32(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the Comparator 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector32(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector32(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Analog comparator 0 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector32(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector32(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the DMA channel 0 - 15 error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector32(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector32(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,16U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the Timer PWM module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector33(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector33(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector33(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector33(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the MCM normal interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector33(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector33(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,17U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the Timer PWM module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector34(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector34(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector34(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector34(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the FTFL command complete interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector34(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector34(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,18U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the Timer PWM module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector35(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector35(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the FlexTimer Module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector35(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector35(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,4U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the FTFL read collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector35(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector35(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,19U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Comparator 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector36(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector36(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the real time clock alarm interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector36(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector36(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Real-time counter interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector36(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector36(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the PMC controller low-voltage detect,
 * low-voltage warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector36(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector36(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,20U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Comparator 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector37(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector37(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the real time clock seconds interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector37(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector37(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Analog comparator 1 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector37(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector37(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the low leakage wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector37(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector37(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,21U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the periodic interrupt timer all
 * channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector38(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector38(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Periodic timer overflow channel 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector38(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector38(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 16U) & NVIC_IP_PRI_2_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the single interrupt vector for  WDOG
 * and EWM interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector38(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector38(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,22U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the WDOG and EWM interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector39(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector39(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Periodic timer overflow channel 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector39(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector39(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,5U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the randon number generator interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector39(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector39(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,23U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector40(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector40(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector40(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector40(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,24U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Digital-to-Analog Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector41(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector41(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the digital-to-analog converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector41(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector41(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector41(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector41(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector41(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector41(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,25U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Multipurpose Clock Generator
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector43(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector43(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Sets the interrupt priority of the multipurpose clock generator
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector43(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector43(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Clock loss of lock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector43(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector43(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,6U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 24U) & NVIC_IP_PRI_3_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector43(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector43(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,27U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Sets the interrupt priority of the Low-Power Timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector44(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector44(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,7U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the WDOG interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector44(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector44(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,7U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK))) | ( \
        (uint32_t)((uint32_t)(Priority) & NVIC_IP_PRI_0_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the integrated interchip sound 0
 * transmit interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector44(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector44(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,28U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPriorityVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Sets the interrupt priority of the Programmable Delay Block interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector45(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector45(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,7U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Sets the interrupt priority of the Pulse width timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 192(lowest), 128, 64 and 0(highest) are valid. This parameter is a
 *        32-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector45(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector45(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,7U) = \
       (uint32_t)(( \
        (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) | ( \
        (uint32_t)((uint32_t)((uint32_t)(Priority) << 8U) & NVIC_IP_PRI_1_MASK))) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Sets the interrupt priority of the integrated interchip sound 0
 * receive interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @param Priority Parameter specifying interrupt vector priority. Only
 *        priorities 240(lowest), 224, 208, 192, 176, 160, 144, 128, 112, 96, 80, 64, 48,
 *        32, 16 and 0(highest) are valid. This parameter is a 8-bit value.
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPriorityVector45(<peripheral>_BASE_PTR, 1);
 *      @endcode
 */
  #define NVIC_PDD_SetPriorityVector45(PeripheralBase, Priority) ( \
      NVIC_IP_REG(PeripheralBase,29U) = \
       (uint8_t)(Priority) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the FTFA command complete and read
 * collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector21(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Command complete and read
 * collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector21(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 5 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector21(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,5U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the low-voltage detect and
 * low-voltage warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector22(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Low-voltage detect, low-voltage
 * warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector22(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 6 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector22(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,6U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Low Leakage Wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector23(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the low leakage wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector23(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the External Interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector23(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,1U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 7 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector23(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,7U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Inter-Integrated Circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 8 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector24(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,8U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector25(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Inter-Integrated Circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector25(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 9 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector25(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,9U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector26(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Serial Peripheral Interface 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector26(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 10 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector26(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,10U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector27(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Serial Peripheral Interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector27(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,2U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 11 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector27(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,11U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the UART0 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector28(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 12 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector28(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,12U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the UART1 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector29(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 13 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector29(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,13U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the UART2 status and error interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector30(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 14 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector30(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,14U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the Analog-to-digital converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector31(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Analog-to-Digital Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector31(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,3U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 15 transfer complete
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector31(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,15U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Analog-to-Digital Converter 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the Comparator 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Analog comparator 0 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the DMA channel 0 - 15 error
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector32(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,16U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the Timer PWM module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector33(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector33(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the MCM normal interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector33(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,17U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the Timer PWM module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector34(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector34(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the FTFL command complete interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector34(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,18U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the Timer PWM module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector35(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the FlexTimer Module 2 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector35(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,4U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the FTFL read collision interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector35(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,19U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Comparator 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the real time clock alarm interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Real-time counter interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the PMC controller low-voltage
 * detect, low-voltage warning interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector36(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,20U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Comparator 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector37(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the real time clock seconds
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector37(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Analog comparator 1 interrupt
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector37(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the low leakage wakeup interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector37(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,21U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the periodic interrupt timer all
 * channels interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector38(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Periodic timer overflow channel
 * 0 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector38(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_2_MASK))) >> ( \
       16U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the single interrupt vector for
 * WDOG and EWM interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector38(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,22U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the WDOG and EWM interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector39(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Periodic timer overflow channel
 * 1 interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector39(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,5U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the randon number generator
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector39(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,23U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector40(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector40(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,24U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Digital-to-Analog Converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector41(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the digital-to-analog converter 0
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector41(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Keyboard interrupt interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector41(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the inter-integrated circuit 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector41(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,25U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Multipurpose Clock Generator
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector43(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns the interrupt priority of the multipurpose clock generator
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector43(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Clock loss of lock interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector43(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,6U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_3_MASK))) >> ( \
       24U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the serial peripheral interface 1
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector43(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,27U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Returns the interrupt priority of the Low-Power Timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the WDOG interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_0_MASK)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the integrated interchip sound 0
 * transmit interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector44(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,28U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPriorityVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns the interrupt priority of the Programmable Delay Block
 * interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector45(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns the interrupt priority of the Pulse width timer interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPriorityVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector45(PeripheralBase) ( \
      (uint32_t)(( \
       (uint32_t)(NVIC_IP_REG(PeripheralBase,7U) & (uint32_t)(~(uint32_t)NVIC_IP_PRI_1_MASK))) >> ( \
       8U)) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns the interrupt priority of the integrated interchip sound 0
 * receive interrupt.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 8-bit value.
 * @remarks The macro accesses the following registers: IP[].
 * @par Example:
 *      @code
 *      uint8_t result = NVIC_PDD_GetPriorityVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPriorityVector45(PeripheralBase) ( \
      NVIC_IP_REG(PeripheralBase,29U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtmrePending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Command complete and read collision IRQ
 * is pending for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtmrePending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetFtmrePending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND5_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPmcPending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Low-voltage detect, low-voltage warning
 * IRQ is pending for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcPending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND6_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the PMC controller low-voltage detect,
 * low-voltage warning IRQ is pending for vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcPending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 20U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetIrqPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the External Interrupt IRQ is pending for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIrqPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIrqPending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND7_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetI2C0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * pending for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND8_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 0 IRQ is
 * pending for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND8_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * pending for vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 24U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetI2C1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * pending for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND9_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 1 IRQ is
 * pending for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND9_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * pending for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 25U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * pending for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND10_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 0 IRQ is
 * pending for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND10_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * pending for vector number 42.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 26U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * pending for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND11_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 1 IRQ is
 * pending for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND11_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * pending for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 27U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetUart0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART0 status and error IRQ is pending
 * for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart0Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND12_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART1 status and error IRQ is pending
 * for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart1Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND13_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart2Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART2 status and error IRQ is pending
 * for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart2Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND14_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetAdcPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 0 IRQ is
 * pending for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAdcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAdcPending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND15_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetAcmp0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog comparator 0 interrupt IRQ is
 * pending for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp0Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND16_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetFtm0Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 0 IRQ is pending for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND17_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 0 fault, overflow and
 * channels IRQ is pending for vector number 58.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,1U) & (uint32_t)((uint32_t)0x1U << 10U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm1Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 1 IRQ is pending for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND18_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 1 fault, overflow and
 * channels IRQ is pending for vector number 59.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,1U) & (uint32_t)((uint32_t)0x1U << 11U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm2Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 2 IRQ is pending for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND19_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 2 fault, overflow and
 * channels IRQ is pending for vector number 60.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Pending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,1U) & (uint32_t)((uint32_t)0x1U << 12U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetRtcPending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock alarm IRQ is pending for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND20_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Real-time counter IRQ is pending for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND20_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the real time clock IRQ is pending for
 * vector number 62.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcPending(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,1U) & (uint32_t)((uint32_t)0x1U << 14U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetAcmp1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog comparator 1 interrupt IRQ is
 * pending for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp1Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND21_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 0 IRQ is
 * pending for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh0Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND22_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 1 IRQ is
 * pending for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh1Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND23_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is pending for
 * vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi0Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND24_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is pending for
 * vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi1Pending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND25_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetIcsPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Clock loss of lock IRQ is pending for
 * vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIcsPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIcsPending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND27_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetWdogPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the WDOG IRQ is pending for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetWdogPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetWdogPending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND28_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPwtPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Pulse width timer IRQ is pending for
 * vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPwtPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPwtPending(PeripheralBase) ( \
    (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND29_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- SetFtmrePending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Command complete and read collision interrupt vector number 21
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtmrePending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetFtmrePending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND5_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetPmcPending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Low-voltage detect, low-voltage warning interrupt vector number
 * 22 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPmcPending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPmcPending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetIrqPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces External Interrupt interrupt vector number 23 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetIrqPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetIrqPending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND7_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetI2C0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces inter-integrated circuit 0 interrupt vector number 24 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Inter-Integrated Circuit 0 interrupt vector number 24 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces inter-integrated circuit 0 interrupt vector number 40 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetI2C1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces inter-integrated circuit 1 interrupt vector number 25 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Inter-Integrated Circuit 1 interrupt vector number 25 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces inter-integrated circuit 1 interrupt vector number 41 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetI2C1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetSpi0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces serial peripheral interface 0 interrupt vector number 26 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Serial Peripheral Interface 0 interrupt vector number 26 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces serial peripheral interface 0 interrupt vector number 42 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x4000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetSpi1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces serial peripheral interface 1 interrupt vector number 27 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Serial Peripheral Interface 1 interrupt vector number 27 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces serial peripheral interface 1 interrupt vector number 43 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetSpi1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetUart0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces UART0 status and error interrupt vector number 28 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetUart0Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND12_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetUart1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces UART1 status and error interrupt vector number 29 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetUart1Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND13_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetUart2Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces UART2 status and error interrupt vector number 30 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetUart2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetUart2Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND14_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetAdcPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Analog-to-Digital Converter 0 interrupt vector number 31 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAdcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetAdcPending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND15_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetAcmp0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Analog comparator 0 interrupt interrupt vector number 32 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAcmp0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetAcmp0Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND16_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetFtm0Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 0 interrupt vector number 33 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces FlexTimer module 0 fault, overflow and channels interrupt
 * vector number 58 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm0Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,1U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetFtm1Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 1 interrupt vector number 34 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces FlexTimer module 1 fault, overflow and channels interrupt
 * vector number 59 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm1Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,1U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetFtm2Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 2 interrupt vector number 35 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm2Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces FlexTimer module 2 fault, overflow and channels interrupt
 * vector number 60 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetFtm2Pending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,1U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetRtcPending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces real time clock alarm interrupt vector number 36 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Real-time counter interrupt vector number 36 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces real time clock interrupt vector number 62 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetRtcPending(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,1U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetAcmp1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Analog comparator 1 interrupt interrupt vector number 37 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetAcmp1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetAcmp1Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND21_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetPitCh0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Periodic timer overflow channel 0 interrupt vector number 38
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPitCh0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetPitCh0Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND22_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetPitCh1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Periodic timer overflow channel 1 interrupt vector number 39
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPitCh1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetPitCh1Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND23_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetKbi0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Keyboard interrupt interrupt vector number 40 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetKbi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetKbi0Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND24_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetKbi1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Keyboard interrupt interrupt vector number 41 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetKbi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetKbi1Pending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND25_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetIcsPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Clock loss of lock interrupt vector number 43 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetIcsPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetIcsPending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND27_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetWdogPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces WDOG interrupt vector number 44 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetWdogPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetWdogPending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND28_MASK \
  )

/* ----------------------------------------------------------------------------
   -- SetPwtPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Forces Pulse width timer interrupt vector number 45 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPwtPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_SetPwtPending(PeripheralBase) ( \
    NVIC_ISPR_REG(PeripheralBase) = \
     NVIC_ISPR_SETPEND29_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearFtmrePending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Command complete and read collision
 * interrupt vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtmrePending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearFtmrePending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND5_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearPmcPending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Low-voltage detect, low-voltage
 * warning interrupt vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPmcPending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the PMC controller low-voltage detect,
 * low-voltage warning interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPmcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPmcPending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearIrqPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the External Interrupt interrupt vector
 * number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearIrqPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearIrqPending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND7_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearI2C0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the inter-integrated circuit 0
 * interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Inter-Integrated Circuit 0
 * interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the inter-integrated circuit 0
 * interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearI2C1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the inter-integrated circuit 1
 * interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Inter-Integrated Circuit 1
 * interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the inter-integrated circuit 1
 * interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearI2C1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearI2C1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearSpi0Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the serial peripheral interface 0
 * interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Serial Peripheral Interface 0
 * interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the serial peripheral interface 0
 * interrupt vector number 42.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x4000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearSpi1Pending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the serial peripheral interface 1
 * interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Serial Peripheral Interface 1
 * interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the serial peripheral interface 1
 * interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearSpi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearSpi1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearUart0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the UART0 status and error interrupt
 * vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearUart0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearUart0Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND12_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearUart1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the UART1 status and error interrupt
 * vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearUart1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearUart1Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND13_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearUart2Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the UART2 status and error interrupt
 * vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearUart2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearUart2Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND14_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearAdcPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Analog-to-Digital Converter 0
 * interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearAdcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearAdcPending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND15_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearAcmp0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Analog comparator 0 interrupt
 * interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearAcmp0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearAcmp0Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND16_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearFtm0Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 0 interrupt vector
 * number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the FlexTimer module 0 fault, overflow
 * and channels interrupt vector number 58.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm0Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,1U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearFtm1Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 1 interrupt vector
 * number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the FlexTimer module 1 fault, overflow
 * and channels interrupt vector number 59.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm1Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,1U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearFtm2Pending
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 2 interrupt vector
 * number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm2Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the FlexTimer module 2 fault, overflow
 * and channels interrupt vector number 60.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearFtm2Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearFtm2Pending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,1U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearRtcPending
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the real time clock alarm interrupt
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearRtcPending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Real-time counter interrupt vector
 * number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearRtcPending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the real time clock interrupt vector
 * number 62.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearRtcPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearRtcPending(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,1U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearAcmp1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Analog comparator 1 interrupt
 * interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearAcmp1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearAcmp1Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND21_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearPitCh0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Periodic timer overflow channel 0
 * interrupt vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPitCh0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearPitCh0Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND22_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearPitCh1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Periodic timer overflow channel 1
 * interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPitCh1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearPitCh1Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND23_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearKbi0Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Keyboard interrupt interrupt vector
 * number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearKbi0Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearKbi0Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND24_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearKbi1Pending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Keyboard interrupt interrupt vector
 * number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearKbi1Pending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearKbi1Pending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND25_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearIcsPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Clock loss of lock interrupt vector
 * number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearIcsPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearIcsPending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND27_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearWdogPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearWdogPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearWdogPending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND28_MASK \
  )

/* ----------------------------------------------------------------------------
   -- ClearPwtPending
   ---------------------------------------------------------------------------- */

/**
 * @brief Removes the pending state from the Pulse width timer interrupt vector
 * number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR.
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPwtPending(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_ClearPwtPending(PeripheralBase) ( \
    NVIC_ICPR_REG(PeripheralBase) = \
     NVIC_ICPR_CLRPEND29_MASK \
  )

/* ----------------------------------------------------------------------------
   -- GetFtmreEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Command complete and read collision IRQ
 * is enabled for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtmreEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetFtmreEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA5_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPmcEnabled
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Low-voltage detect, low-voltage warning
 * IRQ is enabled for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPmcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcEnabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA6_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the PMC controller low-voltage detect,
 * low-voltage warning IRQ is enabled for vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPmcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPmcEnabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x100000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetIrqEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the External Interrupt IRQ is enabled for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIrqEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIrqEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA7_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetI2C0Enabled
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * enabled for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA8_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 0 IRQ is
 * enabled for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA8_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * enabled for vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x1000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetI2C1Enabled
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * enabled for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA9_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 1 IRQ is
 * enabled for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA9_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * enabled for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetI2C1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetI2C1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x2000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi0Enabled
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * enabled for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA10_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 0 IRQ is
 * enabled for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA10_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * enabled for vector number 42.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x4000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetSpi1Enabled
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * enabled for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA11_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 1 IRQ is
 * enabled for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA11_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * enabled for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetSpi1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetSpi1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x8000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetUart0Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART0 status and error IRQ is enabled
 * for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart0Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA12_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart1Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART1 status and error IRQ is enabled
 * for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart1Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA13_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetUart2Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the UART2 status and error IRQ is enabled
 * for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetUart2Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetUart2Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA14_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetAdcEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 0 IRQ is
 * enabled for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAdcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAdcEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA15_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetAcmp0Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog comparator 0 interrupt IRQ is
 * enabled for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp0Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA16_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetFtm0Enabled
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 0 IRQ is enabled for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA17_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 0 fault, overflow and
 * channels IRQ is enabled for vector number 58.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm0Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,1U) & 0x400U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm1Enabled
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 1 IRQ is enabled for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA18_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 1 fault, overflow and
 * channels IRQ is enabled for vector number 59.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm1Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,1U) & 0x800U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetFtm2Enabled
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 2 IRQ is enabled for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm2Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA19_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FlexTimer module 2 fault, overflow and
 * channels IRQ is enabled for vector number 60.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetFtm2Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetFtm2Enabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,1U) & 0x1000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetRtcEnabled
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock alarm IRQ is enabled for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcEnabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA20_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Real-time counter IRQ is enabled for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcEnabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA20_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the real time clock IRQ is enabled for
 * vector number 62.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetRtcEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetRtcEnabled(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,1U) & 0x4000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetAcmp1Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Analog comparator 1 interrupt IRQ is
 * enabled for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetAcmp1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetAcmp1Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA21_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh0Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 0 IRQ is
 * enabled for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh0Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA22_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPitCh1Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 1 IRQ is
 * enabled for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPitCh1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPitCh1Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA23_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi0Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is enabled for
 * vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi0Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi0Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA24_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetKbi1Enabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is enabled for
 * vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetKbi1Enabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetKbi1Enabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA25_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetIcsEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Clock loss of lock IRQ is enabled for
 * vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetIcsEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetIcsEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA27_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetWdogEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the WDOG IRQ is enabled for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetWdogEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetWdogEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA28_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- GetPwtEnabled
   ---------------------------------------------------------------------------- */

/**
 * @brief Returns non-zero value if the Pulse width timer IRQ is enabled for
 * vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPwtEnabled(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_GetPwtEnabled(PeripheralBase) ( \
    (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA29_MASK) \
  )

/* ----------------------------------------------------------------------------
   -- EnableFtmre
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtmre(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableFtmre(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA5_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnablePmc
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Low-voltage detect, low-voltage warning interrupt vector
 * number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnablePmc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnablePmc(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnablePmc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnablePmc(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableIrq
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the External Interrupt interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableIrq(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableIrq(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA7_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableI2C0
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the inter-integrated circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Inter-Integrated Circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the inter-integrated circuit 0 interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableI2C1
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the inter-integrated circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Inter-Integrated Circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the inter-integrated circuit 1 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableI2C1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableSpi0
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the serial peripheral interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Serial Peripheral Interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the serial peripheral interface 0 interrupt vector number 42.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x4000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableSpi1
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the serial peripheral interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Serial Peripheral Interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the serial peripheral interface 1 interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableSpi1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableUart0
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the UART0 status and error interrupt vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableUart0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableUart0(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA12_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableUart1
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the UART1 status and error interrupt vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableUart1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableUart1(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA13_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableUart2
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the UART2 status and error interrupt vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableUart2(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableUart2(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA14_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableAdc
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Analog-to-Digital Converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableAdc(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableAdc(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA15_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableAcmp0
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Analog comparator 0 interrupt interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableAcmp0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableAcmp0(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA16_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableFtm0
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the FlexTimer module 0 fault, overflow and channels interrupt
 * vector number 58.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm0(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,1U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableFtm1
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the FlexTimer module 1 fault, overflow and channels interrupt
 * vector number 59.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm1(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,1U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableFtm2
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm2(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm2(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the FlexTimer module 2 fault, overflow and channels interrupt
 * vector number 60.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableFtm2(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableFtm2(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,1U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableRtc
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the real time clock alarm interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableRtc(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Real-time counter interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableRtc(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the real time clock interrupt vector number 62.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableRtc(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,1U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableAcmp1
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Analog comparator 1 interrupt interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableAcmp1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableAcmp1(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA21_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnablePitCh0
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Periodic timer overflow channel 0 interrupt vector number
 * 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnablePitCh0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnablePitCh0(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA22_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnablePitCh1
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Periodic timer overflow channel 1 interrupt vector number
 * 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnablePitCh1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnablePitCh1(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA23_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableKbi0
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Keyboard interrupt interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableKbi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableKbi0(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA24_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableKbi1
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Keyboard interrupt interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableKbi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableKbi1(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA25_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableIcs
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Clock loss of lock interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableIcs(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableIcs(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA27_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnableWdog
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableWdog(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnableWdog(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA28_MASK \
  )

/* ----------------------------------------------------------------------------
   -- EnablePwt
   ---------------------------------------------------------------------------- */

/**
 * @brief Enables the Pulse width timer interrupt vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER.
 * @par Example:
 *      @code
 *      NVIC_PDD_EnablePwt(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_EnablePwt(PeripheralBase) ( \
    NVIC_ISER_REG(PeripheralBase) = \
     NVIC_ISER_SETENA29_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableFtmre
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtmre(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableFtmre(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA5_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisablePmc
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Low-voltage detect, low-voltage warning interrupt vector
 * number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisablePmc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisablePmc(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisablePmc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisablePmc(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableIrq
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the External Interrupt interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableIrq(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableIrq(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA7_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableI2C0
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the inter-integrated circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Inter-Integrated Circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the inter-integrated circuit 0 interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableI2C1
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the inter-integrated circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Inter-Integrated Circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the inter-integrated circuit 1 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableI2C1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableI2C1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableSpi0
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the serial peripheral interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Serial Peripheral Interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the serial peripheral interface 0 interrupt vector number 42.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x4000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableSpi1
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the serial peripheral interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Serial Peripheral Interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the serial peripheral interface 1 interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableSpi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableSpi1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableUart0
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the UART0 status and error interrupt vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableUart0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableUart0(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA12_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableUart1
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the UART1 status and error interrupt vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableUart1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableUart1(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA13_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableUart2
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the UART2 status and error interrupt vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableUart2(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableUart2(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA14_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableAdc
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Analog-to-Digital Converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableAdc(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableAdc(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA15_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableAcmp0
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Analog comparator 0 interrupt interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableAcmp0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableAcmp0(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA16_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableFtm0
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the FlexTimer module 0 fault, overflow and channels interrupt
 * vector number 58.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm0(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm0(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,1U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableFtm1
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the FlexTimer module 1 fault, overflow and channels interrupt
 * vector number 59.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm1(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm1(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,1U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableFtm2
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm2(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm2(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the FlexTimer module 2 fault, overflow and channels interrupt
 * vector number 60.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableFtm2(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableFtm2(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,1U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableRtc
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the real time clock alarm interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableRtc(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Real-time counter interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableRtc(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the real time clock interrupt vector number 62.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableRtc(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableRtc(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,1U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableAcmp1
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Analog comparator 1 interrupt interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableAcmp1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableAcmp1(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA21_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisablePitCh0
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Periodic timer overflow channel 0 interrupt vector number
 * 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisablePitCh0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisablePitCh0(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA22_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisablePitCh1
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Periodic timer overflow channel 1 interrupt vector number
 * 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisablePitCh1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisablePitCh1(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA23_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableKbi0
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Keyboard interrupt interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableKbi0(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableKbi0(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA24_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableKbi1
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Keyboard interrupt interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableKbi1(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableKbi1(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA25_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableIcs
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Clock loss of lock interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableIcs(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableIcs(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA27_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisableWdog
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableWdog(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisableWdog(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA28_MASK \
  )

/* ----------------------------------------------------------------------------
   -- DisablePwt
   ---------------------------------------------------------------------------- */

/**
 * @brief Disables the Pulse width timer interrupt vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER.
 * @par Example:
 *      @code
 *      NVIC_PDD_DisablePwt(<peripheral>_BASE_PTR);
 *      @endcode
 */
#define NVIC_PDD_DisablePwt(PeripheralBase) ( \
    NVIC_ICER_REG(PeripheralBase) = \
     NVIC_ICER_CLRENA29_MASK \
  )

/* ----------------------------------------------------------------------------
   -- GetPendingVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the FTFA command complete and read collision
 * IRQ is pending for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND5_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Command complete and read collision IRQ
 * is pending for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND5_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 5 transfer complete IRQ is
 * pending for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 5U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the low-voltage detect and low-voltage
 * warning IRQ is pending for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND6_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Low-voltage detect, low-voltage warning
 * IRQ is pending for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND6_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 6 transfer complete IRQ is
 * pending for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 6U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Low Leakage Wakeup IRQ is pending for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND7_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the low leakage wakeup IRQ is pending for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND7_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the External Interrupt IRQ is pending for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND7_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 7 transfer complete IRQ is
 * pending for vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 7U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * pending for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND8_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 0 IRQ is
 * pending for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND8_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 8 transfer complete IRQ is
 * pending for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 8U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * pending for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND9_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 1 IRQ is
 * pending for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND9_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 9 transfer complete IRQ is
 * pending for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 9U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * pending for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND10_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 0 IRQ is
 * pending for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND10_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 10 transfer complete IRQ is
 * pending for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 10U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * pending for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND11_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 1 IRQ is
 * pending for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND11_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 11 transfer complete IRQ is
 * pending for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 11U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART0 status and error IRQ is pending
 * for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector28(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND12_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 12 transfer complete IRQ is
 * pending for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector28(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 12U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART1 status and error IRQ is pending
 * for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector29(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND13_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 13 transfer complete IRQ is
 * pending for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector29(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 13U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART2 status and error IRQ is pending
 * for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector30(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND14_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 14 transfer complete IRQ is
 * pending for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector30(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 14U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Analog-to-digital converter 0 IRQ is
 * pending for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND15_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 0 IRQ is
 * pending for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND15_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 15 transfer complete IRQ is
 * pending for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 15U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 1 IRQ is
 * pending for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND16_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Comparator 0 IRQ is pending for vector
 * number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND16_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog comparator 0 interrupt IRQ is
 * pending for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND16_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 0 - 15 error IRQ is pending
 * for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 16U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 0 IRQ is pending for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND17_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 0 IRQ is pending for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND17_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the MCM normal IRQ is pending for vector
 * number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 17U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 1 IRQ is pending for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND18_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 1 IRQ is pending for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND18_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FTFL command complete IRQ is pending for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 18U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 2 IRQ is pending for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND19_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 2 IRQ is pending for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND19_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FTFL read collision IRQ is pending for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 19U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Comparator 0 IRQ is pending for vector
 * number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND20_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock alarm IRQ is pending for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND20_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Real-time counter IRQ is pending for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND20_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the PMC controller low-voltage detect,
 * low-voltage warning IRQ is pending for vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 20U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Comparator 1 IRQ is pending for vector
 * number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND21_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock seconds IRQ is pending
 * for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND21_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog comparator 1 interrupt IRQ is
 * pending for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND21_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the low leakage wakeup IRQ is pending for
 * vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 21U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the periodic interrupt timer all channels
 * IRQ is pending for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND22_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 0 IRQ is
 * pending for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND22_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the single interrupt vector for  WDOG and
 * EWM IRQ is pending for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 22U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the WDOG and EWM IRQ is pending for vector
 * number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND23_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 1 IRQ is
 * pending for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND23_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the randon number generator IRQ is pending
 * for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 23U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is pending for
 * vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector40(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND24_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * pending for vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector40(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 24U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Digital-to-Analog Converter 0 IRQ is
 * pending for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND25_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the digital-to-analog converter 0 IRQ is
 * pending for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND25_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is pending for
 * vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND25_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * pending for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 25U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Multipurpose Clock Generator IRQ is
 * pending for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND27_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the multipurpose clock generator IRQ is
 * pending for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND27_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Clock loss of lock IRQ is pending for
 * vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND27_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * pending for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 27U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Returns non-zero value if the Low-Power Timer IRQ is pending for
 * vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND28_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the WDOG IRQ is pending for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND28_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the integrated interchip sound 0 transmit
 * IRQ is pending for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 28U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetPendingVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Programmable Delay Block IRQ is pending
 * for vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND29_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Pulse width timer IRQ is pending for
 * vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase) & NVIC_ISPR_SETPEND29_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the integrated interchip sound 0 receive IRQ
 * is pending for vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetPendingVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISPR_REG(PeripheralBase,0U) & (uint32_t)((uint32_t)0x1U << 29U)) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces FTFA command complete and read collision interrupt vector
 * number 21 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector21(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND5_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Command complete and read collision interrupt vector number 21
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector21(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND5_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 5 transfer complete interrupt vector number 21 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector21(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x20U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces low-voltage detect and low-voltage warning interrupt vector
 * number 22 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector22(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND6_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Low-voltage detect, low-voltage warning interrupt vector number
 * 22 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector22(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 6 transfer complete interrupt vector number 22 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector22(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x40U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Low Leakage Wakeup interrupt vector number 23 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector23(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND7_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces low leakage wakeup interrupt vector number 23 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector23(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND7_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces External Interrupt interrupt vector number 23 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector23(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND7_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 7 transfer complete interrupt vector number 23 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector23(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x80U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces inter-integrated circuit 0 interrupt vector number 24 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector24(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Inter-Integrated Circuit 0 interrupt vector number 24 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector24(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 8 transfer complete interrupt vector number 24 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector24(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x100U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces inter-integrated circuit 1 interrupt vector number 25 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector25(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Inter-Integrated Circuit 1 interrupt vector number 25 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector25(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 9 transfer complete interrupt vector number 25 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector25(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x200U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces serial peripheral interface 0 interrupt vector number 26 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector26(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Serial Peripheral Interface 0 interrupt vector number 26 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector26(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 10 transfer complete interrupt vector number 26
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector26(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces serial peripheral interface 1 interrupt vector number 27 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector27(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Serial Peripheral Interface 1 interrupt vector number 27 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector27(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 11 transfer complete interrupt vector number 27
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector27(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces UART0 status and error interrupt vector number 28 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector28(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND12_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 12 transfer complete interrupt vector number 28
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector28(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces UART1 status and error interrupt vector number 29 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector29(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND13_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 13 transfer complete interrupt vector number 29
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector29(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x2000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces UART2 status and error interrupt vector number 30 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector30(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND14_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 14 transfer complete interrupt vector number 30
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector30(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces Analog-to-digital converter 0 interrupt vector number 31 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector31(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND15_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Analog-to-Digital Converter 0 interrupt vector number 31 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector31(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND15_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 15 transfer complete interrupt vector number 31
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector31(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x8000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Analog-to-Digital Converter 1 interrupt vector number 32 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector32(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND16_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces Comparator 0 interrupt vector number 32 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector32(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND16_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Analog comparator 0 interrupt interrupt vector number 32 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector32(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND16_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces DMA channel 0 - 15 error interrupt vector number 32 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector32(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x10000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces Timer PWM module 0 interrupt vector number 33 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector33(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND17_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 0 interrupt vector number 33 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector33(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces MCM normal interrupt vector number 33 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector33(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x20000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces Timer PWM module 1 interrupt vector number 34 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector34(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND18_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 1 interrupt vector number 34 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector34(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces FTFL command complete interrupt vector number 34 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector34(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x40000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces Timer PWM module 2 interrupt vector number 35 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector35(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND19_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces FlexTimer Module 2 interrupt vector number 35 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector35(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces FTFL read collision interrupt vector number 35 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector35(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x80000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Comparator 0 interrupt vector number 36 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector36(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND20_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces real time clock alarm interrupt vector number 36 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector36(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Real-time counter interrupt vector number 36 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector36(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector36(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Comparator 1 interrupt vector number 37 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector37(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND21_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces real time clock seconds interrupt vector number 37 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector37(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND21_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Analog comparator 1 interrupt interrupt vector number 37 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector37(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND21_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces low leakage wakeup interrupt vector number 37 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector37(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x200000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Forces periodic interrupt timer all channels interrupt vector number
 * 38 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector38(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND22_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Periodic timer overflow channel 0 interrupt vector number 38
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector38(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND22_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces single interrupt vector for  WDOG and EWM interrupt vector
 * number 38 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector38(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x400000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces WDOG and EWM interrupt vector number 39 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector39(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND23_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Periodic timer overflow channel 1 interrupt vector number 39
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector39(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND23_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces randon number generator interrupt vector number 39 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector39(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x800000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Keyboard interrupt interrupt vector number 40 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector40(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND24_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces inter-integrated circuit 0 interrupt vector number 40 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector40(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Digital-to-Analog Converter 0 interrupt vector number 41 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector41(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND25_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces digital-to-analog converter 0 interrupt vector number 41 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector41(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND25_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Keyboard interrupt interrupt vector number 41 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector41(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND25_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces inter-integrated circuit 1 interrupt vector number 41 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector41(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Multipurpose Clock Generator interrupt vector number 43 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector43(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND27_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Forces multipurpose clock generator interrupt vector number 43 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector43(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND27_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Clock loss of lock interrupt vector number 43 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector43(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND27_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces serial peripheral interface 1 interrupt vector number 43 into
 * the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector43(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Forces Low-Power Timer interrupt vector number 44 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector44(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND28_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces WDOG interrupt vector number 44 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector44(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND28_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces integrated interchip sound 0 transmit interrupt vector number
 * 44 into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector44(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x10000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- SetPendingVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Forces Programmable Delay Block interrupt vector number 45 into the
 * pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector45(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND29_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Forces Pulse width timer interrupt vector number 45 into the pending
 * state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector45(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase) = \
       NVIC_ISPR_SETPEND29_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Forces integrated interchip sound 0 receive interrupt vector number 45
 * into the pending state.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISPR, ISPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_SetPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_SetPendingVector45(PeripheralBase) ( \
      NVIC_ISPR_REG(PeripheralBase,0U) = \
       0x20000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the FTFA command complete and read
 * collision interrupt vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector21(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND5_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Command complete and read collision
 * interrupt vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector21(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND5_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 5 transfer complete
 * interrupt vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector21(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x20U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the low-voltage detect and low-voltage
 * warning interrupt vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector22(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND6_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Low-voltage detect, low-voltage
 * warning interrupt vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector22(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 6 transfer complete
 * interrupt vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector22(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x40U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Low Leakage Wakeup interrupt vector
 * number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector23(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND7_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the low leakage wakeup interrupt vector
 * number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector23(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND7_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the External Interrupt interrupt vector
 * number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector23(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND7_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 7 transfer complete
 * interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector23(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x80U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the inter-integrated circuit 0
 * interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector24(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Inter-Integrated Circuit 0
 * interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector24(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 8 transfer complete
 * interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector24(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x100U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the inter-integrated circuit 1
 * interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector25(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Inter-Integrated Circuit 1
 * interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector25(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 9 transfer complete
 * interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector25(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x200U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the serial peripheral interface 0
 * interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector26(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Serial Peripheral Interface 0
 * interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector26(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 10 transfer complete
 * interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector26(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the serial peripheral interface 1
 * interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector27(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Serial Peripheral Interface 1
 * interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector27(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 11 transfer complete
 * interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector27(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the UART0 status and error interrupt
 * vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector28(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND12_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 12 transfer complete
 * interrupt vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector28(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the UART1 status and error interrupt
 * vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector29(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND13_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 13 transfer complete
 * interrupt vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector29(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x2000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the UART2 status and error interrupt
 * vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector30(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND14_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 14 transfer complete
 * interrupt vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector30(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the Analog-to-digital converter 0
 * interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector31(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND15_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Analog-to-Digital Converter 0
 * interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector31(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND15_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 15 transfer complete
 * interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector31(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x8000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Analog-to-Digital Converter 1
 * interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector32(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND16_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the Comparator 0 interrupt vector
 * number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector32(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND16_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Analog comparator 0 interrupt
 * interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector32(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND16_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the DMA channel 0 - 15 error interrupt
 * vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector32(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x10000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the Timer PWM module 0 interrupt vector
 * number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector33(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND17_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 0 interrupt vector
 * number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector33(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the MCM normal interrupt vector number
 * 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector33(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x20000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the Timer PWM module 1 interrupt vector
 * number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector34(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND18_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 1 interrupt vector
 * number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector34(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the FTFL command complete interrupt
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector34(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x40000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the Timer PWM module 2 interrupt vector
 * number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector35(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND19_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the FlexTimer Module 2 interrupt vector
 * number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector35(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the FTFL read collision interrupt
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector35(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x80000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Comparator 0 interrupt vector
 * number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector36(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND20_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the real time clock alarm interrupt
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector36(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Real-time counter interrupt vector
 * number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector36(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the PMC controller low-voltage detect,
 * low-voltage warning interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector36(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Comparator 1 interrupt vector
 * number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector37(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND21_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the real time clock seconds interrupt
 * vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector37(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND21_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Analog comparator 1 interrupt
 * interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector37(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND21_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the low leakage wakeup interrupt vector
 * number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector37(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x200000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the periodic interrupt timer all
 * channels interrupt vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector38(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND22_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Periodic timer overflow channel 0
 * interrupt vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector38(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND22_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the single interrupt vector for  WDOG
 * and EWM interrupt vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector38(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x400000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the WDOG and EWM interrupt vector
 * number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector39(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND23_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Periodic timer overflow channel 1
 * interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector39(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND23_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the randon number generator interrupt
 * vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector39(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x800000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Keyboard interrupt interrupt vector
 * number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector40(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND24_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the inter-integrated circuit 0
 * interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector40(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Digital-to-Analog Converter 0
 * interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector41(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND25_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the digital-to-analog converter 0
 * interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector41(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND25_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Keyboard interrupt interrupt vector
 * number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector41(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND25_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the inter-integrated circuit 1
 * interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector41(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Multipurpose Clock Generator
 * interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector43(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND27_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Removes the pending state from the multipurpose clock generator
 * interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector43(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND27_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Clock loss of lock interrupt vector
 * number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector43(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND27_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the serial peripheral interface 1
 * interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector43(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Removes the pending state from the Low-Power Timer interrupt vector
 * number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector44(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND28_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector44(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND28_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the integrated interchip sound 0
 * transmit interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector44(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x10000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- ClearPendingVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Removes the pending state from the Programmable Delay Block interrupt
 * vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector45(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND29_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Removes the pending state from the Pulse width timer interrupt vector
 * number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector45(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase) = \
       NVIC_ICPR_CLRPEND29_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Removes the pending state from the integrated interchip sound 0
 * receive interrupt vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICPR, ICPR[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_ClearPendingVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_ClearPendingVector45(PeripheralBase) ( \
      NVIC_ICPR_REG(PeripheralBase,0U) = \
       0x20000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the FTFA command complete and read collision
 * IRQ is enabled for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA5_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Command complete and read collision IRQ
 * is enabled for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA5_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 5 transfer complete IRQ is
 * enabled for vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector21(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x20U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the low-voltage detect and low-voltage
 * warning IRQ is enabled for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA6_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Low-voltage detect, low-voltage warning
 * IRQ is enabled for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA6_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 6 transfer complete IRQ is
 * enabled for vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector22(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x40U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Low Leakage Wakeup IRQ is enabled for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA7_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the low leakage wakeup IRQ is enabled for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA7_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the External Interrupt IRQ is enabled for
 * vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA7_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 7 transfer complete IRQ is
 * enabled for vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector23(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x80U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * enabled for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA8_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 0 IRQ is
 * enabled for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA8_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 8 transfer complete IRQ is
 * enabled for vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector24(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x100U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * enabled for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA9_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Inter-Integrated Circuit 1 IRQ is
 * enabled for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA9_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 9 transfer complete IRQ is
 * enabled for vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector25(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x200U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 0 IRQ is
 * enabled for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA10_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 0 IRQ is
 * enabled for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA10_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 10 transfer complete IRQ is
 * enabled for vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector26(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x400U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * enabled for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA11_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Serial Peripheral Interface 1 IRQ is
 * enabled for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA11_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 11 transfer complete IRQ is
 * enabled for vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector27(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x800U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART0 status and error IRQ is enabled
 * for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector28(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA12_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 12 transfer complete IRQ is
 * enabled for vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector28(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x1000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART1 status and error IRQ is enabled
 * for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector29(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA13_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 13 transfer complete IRQ is
 * enabled for vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector29(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x2000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the UART2 status and error IRQ is enabled
 * for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector30(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA14_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 14 transfer complete IRQ is
 * enabled for vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector30(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x4000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Analog-to-digital converter 0 IRQ is
 * enabled for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA15_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 0 IRQ is
 * enabled for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA15_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 15 transfer complete IRQ is
 * enabled for vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector31(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x8000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Analog-to-Digital Converter 1 IRQ is
 * enabled for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA16_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Comparator 0 IRQ is enabled for vector
 * number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA16_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog comparator 0 interrupt IRQ is
 * enabled for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA16_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the DMA channel 0 - 15 error IRQ is enabled
 * for vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector32(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x10000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 0 IRQ is enabled for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA17_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 0 IRQ is enabled for
 * vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA17_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the MCM normal IRQ is enabled for vector
 * number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector33(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x20000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 1 IRQ is enabled for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA18_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 1 IRQ is enabled for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA18_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FTFL command complete IRQ is enabled for
 * vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector34(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x40000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the Timer PWM module 2 IRQ is enabled for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA19_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the FlexTimer Module 2 IRQ is enabled for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA19_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the FTFL read collision IRQ is enabled for
 * vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector35(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x80000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Comparator 0 IRQ is enabled for vector
 * number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA20_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock alarm IRQ is enabled for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA20_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Real-time counter IRQ is enabled for
 * vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA20_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the PMC controller low-voltage detect,
 * low-voltage warning IRQ is enabled for vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector36(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x100000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Comparator 1 IRQ is enabled for vector
 * number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA21_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the real time clock seconds IRQ is enabled
 * for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA21_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Analog comparator 1 interrupt IRQ is
 * enabled for vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA21_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the low leakage wakeup IRQ is enabled for
 * vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector37(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x200000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the periodic interrupt timer all channels
 * IRQ is enabled for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA22_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 0 IRQ is
 * enabled for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA22_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the single interrupt vector for  WDOG and
 * EWM IRQ is enabled for vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector38(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x400000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the WDOG and EWM IRQ is enabled for vector
 * number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA23_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Periodic timer overflow channel 1 IRQ is
 * enabled for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA23_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the randon number generator IRQ is enabled
 * for vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector39(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x800000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is enabled for
 * vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector40(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA24_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 0 IRQ is
 * enabled for vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector40(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x1000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Digital-to-Analog Converter 0 IRQ is
 * enabled for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA25_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the digital-to-analog converter 0 IRQ is
 * enabled for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA25_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Keyboard interrupt IRQ is enabled for
 * vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA25_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the inter-integrated circuit 1 IRQ is
 * enabled for vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector41(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x2000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Multipurpose Clock Generator IRQ is
 * enabled for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA27_MASK) \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Returns non-zero value if the multipurpose clock generator IRQ is
 * enabled for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA27_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Clock loss of lock IRQ is enabled for
 * vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA27_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the serial peripheral interface 1 IRQ is
 * enabled for vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector43(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x8000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Returns non-zero value if the Low-Power Timer IRQ is enabled for
 * vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA28_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the WDOG IRQ is enabled for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA28_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the integrated interchip sound 0 transmit
 * IRQ is enabled for vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector44(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x10000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- GetEnabledVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Returns non-zero value if the Programmable Delay Block IRQ is enabled
 * for vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA29_MASK) \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Returns non-zero value if the Pulse width timer IRQ is enabled for
 * vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase) & NVIC_ISER_SETENA29_MASK) \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Returns non-zero value if the integrated interchip sound 0 receive IRQ
 * is enabled for vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a 32-bit value.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      uint32_t result = NVIC_PDD_GetEnabledVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_GetEnabledVector45(PeripheralBase) ( \
      (uint32_t)(NVIC_ISER_REG(PeripheralBase,0U) & 0x20000000U) \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the FTFA command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector21(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA5_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector21(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA5_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 5 transfer complete interrupt vector number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector21(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x20U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the low-voltage detect and low-voltage warning interrupt
 * vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector22(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA6_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Low-voltage detect, low-voltage warning interrupt vector
 * number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector22(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 6 transfer complete interrupt vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector22(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x40U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Low Leakage Wakeup interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector23(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA7_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the low leakage wakeup interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector23(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA7_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the External Interrupt interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector23(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA7_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 7 transfer complete interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector23(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x80U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the inter-integrated circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector24(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Inter-Integrated Circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector24(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 8 transfer complete interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector24(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x100U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the inter-integrated circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector25(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Inter-Integrated Circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector25(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 9 transfer complete interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector25(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x200U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the serial peripheral interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector26(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Serial Peripheral Interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector26(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 10 transfer complete interrupt vector number
 * 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector26(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the serial peripheral interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector27(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Serial Peripheral Interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector27(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 11 transfer complete interrupt vector number
 * 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector27(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the UART0 status and error interrupt vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector28(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA12_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 12 transfer complete interrupt vector number
 * 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector28(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the UART1 status and error interrupt vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector29(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA13_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 13 transfer complete interrupt vector number
 * 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector29(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x2000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the UART2 status and error interrupt vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector30(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA14_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 14 transfer complete interrupt vector number
 * 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector30(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the Analog-to-digital converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector31(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA15_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Analog-to-Digital Converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector31(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA15_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 15 transfer complete interrupt vector number
 * 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector31(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x8000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Analog-to-Digital Converter 1 interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector32(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA16_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the Comparator 0 interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector32(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA16_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Analog comparator 0 interrupt interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector32(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA16_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the DMA channel 0 - 15 error interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector32(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x10000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the Timer PWM module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector33(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA17_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector33(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the MCM normal interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector33(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x20000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the Timer PWM module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector34(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA18_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector34(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the FTFL command complete interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector34(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x40000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the Timer PWM module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector35(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA19_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the FlexTimer Module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector35(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the FTFL read collision interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector35(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x80000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Comparator 0 interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector36(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA20_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the real time clock alarm interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector36(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Real-time counter interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector36(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector36(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Comparator 1 interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector37(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA21_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the real time clock seconds interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector37(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA21_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Analog comparator 1 interrupt interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector37(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA21_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the low leakage wakeup interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector37(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x200000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Enables the periodic interrupt timer all channels interrupt vector
 * number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector38(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA22_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Periodic timer overflow channel 0 interrupt vector number
 * 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector38(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA22_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the single interrupt vector for  WDOG and EWM interrupt vector
 * number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector38(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x400000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the WDOG and EWM interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector39(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA23_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Periodic timer overflow channel 1 interrupt vector number
 * 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector39(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA23_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the randon number generator interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector39(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x800000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Keyboard interrupt interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector40(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA24_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the inter-integrated circuit 0 interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector40(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Digital-to-Analog Converter 0 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector41(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA25_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the digital-to-analog converter 0 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector41(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA25_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Keyboard interrupt interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector41(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA25_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the inter-integrated circuit 1 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector41(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Multipurpose Clock Generator interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector43(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA27_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Enables the multipurpose clock generator interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector43(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA27_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Clock loss of lock interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector43(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA27_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the serial peripheral interface 1 interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector43(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Enables the Low-Power Timer interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector44(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA28_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector44(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA28_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the integrated interchip sound 0 transmit interrupt vector
 * number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector44(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x10000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- EnableVector45
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Enables the Programmable Delay Block interrupt vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector45(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA29_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Enables the Pulse width timer interrupt vector number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector45(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase) = \
       NVIC_ISER_SETENA29_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Enables the integrated interchip sound 0 receive interrupt vector
 * number 45.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ISER, ISER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_EnableVector45(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_EnableVector45(PeripheralBase) ( \
      NVIC_ISER_REG(PeripheralBase,0U) = \
       0x20000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector21
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the FTFA command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector21(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA5_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Command complete and read collision interrupt vector
 * number 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector21(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA5_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 5 transfer complete interrupt vector number
 * 21.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector21(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector21(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x20U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector22
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the low-voltage detect and low-voltage warning interrupt
 * vector number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector22(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA6_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Low-voltage detect, low-voltage warning interrupt vector
 * number 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector22(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA6_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 6 transfer complete interrupt vector number
 * 22.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector22(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector22(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x40U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector23
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Low Leakage Wakeup interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector23(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA7_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the low leakage wakeup interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector23(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA7_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the External Interrupt interrupt vector number 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector23(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA7_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 7 transfer complete interrupt vector number
 * 23.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector23(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector23(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x80U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector24
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the inter-integrated circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector24(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA8_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Inter-Integrated Circuit 0 interrupt vector number 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector24(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA8_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 8 transfer complete interrupt vector number
 * 24.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector24(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector24(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x100U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector25
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the inter-integrated circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector25(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA9_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Inter-Integrated Circuit 1 interrupt vector number 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector25(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA9_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 9 transfer complete interrupt vector number
 * 25.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector25(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector25(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x200U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector26
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the serial peripheral interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector26(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA10_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Serial Peripheral Interface 0 interrupt vector number 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector26(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA10_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 10 transfer complete interrupt vector number
 * 26.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector26(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector26(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x400U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector27
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the serial peripheral interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector27(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA11_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Serial Peripheral Interface 1 interrupt vector number 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector27(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA11_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 11 transfer complete interrupt vector number
 * 27.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector27(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector27(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x800U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector28
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the UART0 status and error interrupt vector number 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector28(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA12_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 12 transfer complete interrupt vector number
 * 28.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector28(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector28(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x1000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector29
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the UART1 status and error interrupt vector number 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector29(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA13_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 13 transfer complete interrupt vector number
 * 29.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector29(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector29(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x2000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector30
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKW01Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the UART2 status and error interrupt vector number 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector30(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA14_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 14 transfer complete interrupt vector number
 * 30.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector30(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector30(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x4000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector31
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the Analog-to-digital converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector31(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA15_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Analog-to-Digital Converter 0 interrupt vector number 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector31(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA15_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 15 transfer complete interrupt vector number
 * 31.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector31(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector31(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x8000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector32
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Analog-to-Digital Converter 1 interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector32(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA16_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the Comparator 0 interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector32(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA16_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Analog comparator 0 interrupt interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector32(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA16_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the DMA channel 0 - 15 error interrupt vector number 32.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector32(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector32(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x10000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector33
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the Timer PWM module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector33(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA17_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 0 interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector33(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA17_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the MCM normal interrupt vector number 33.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector33(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector33(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x20000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector34
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the Timer PWM module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector34(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA18_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 1 interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector34(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA18_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the FTFL command complete interrupt vector number 34.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector34(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector34(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x40000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector35
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the Timer PWM module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector35(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA19_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_MKV10Z7)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the FlexTimer Module 2 interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector35(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA19_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the FTFL read collision interrupt vector number 35.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector35(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector35(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x80000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector36
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Comparator 0 interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector36(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA20_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the real time clock alarm interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector36(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA20_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Real-time counter interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector36(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA20_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the PMC controller low-voltage detect, low-voltage warning
 * interrupt vector number 36.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector36(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector36(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x100000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector37
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Comparator 1 interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector37(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA21_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the real time clock seconds interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector37(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA21_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Analog comparator 1 interrupt interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector37(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA21_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the low leakage wakeup interrupt vector number 37.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector37(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector37(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x200000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector38
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKW01Z4))
/**
 * @brief Disables the periodic interrupt timer all channels interrupt vector
 * number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector38(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA22_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Periodic timer overflow channel 0 interrupt vector number
 * 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector38(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA22_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the single interrupt vector for  WDOG and EWM interrupt
 * vector number 38.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector38(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector38(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x400000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector39
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the WDOG and EWM interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector39(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA23_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Periodic timer overflow channel 1 interrupt vector number
 * 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector39(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA23_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the randon number generator interrupt vector number 39.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector39(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector39(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x800000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector40
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Keyboard interrupt interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector40(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA24_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the inter-integrated circuit 0 interrupt vector number 40.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector40(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector40(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x1000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector41
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Digital-to-Analog Converter 0 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector41(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA25_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the digital-to-analog converter 0 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector41(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA25_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Keyboard interrupt interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector41(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA25_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the inter-integrated circuit 1 interrupt vector number 41.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector41(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector41(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x2000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector43
   ---------------------------------------------------------------------------- */

#if (defined(MCU_MKV10Z7))
/**
 * @brief Disables the Multipurpose Clock Generator interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector43(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA27_MASK \
    )
#elif (defined(MCU_MKW01Z4))
/**
 * @brief Disables the multipurpose clock generator interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector43(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA27_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the Clock loss of lock interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector43(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA27_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the serial peripheral interface 1 interrupt vector number 43.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector43(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector43(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x8000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */

/* ----------------------------------------------------------------------------
   -- DisableVector44
   ---------------------------------------------------------------------------- */

#if ((defined(MCU_MKV10Z7)) || (defined(MCU_MKW01Z4)))
/**
 * @brief Disables the Low-Power Timer interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector44(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA28_MASK \
    )
#elif ((defined(MCU_MKE04Z1284)) || (defined(MCU_MKE06Z4)) || (defined(MCU_SKEAZ1284)))
/**
 * @brief Disables the WDOG interrupt vector number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector44(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase) = \
       NVIC_ICER_CLRENA28_MASK \
    )
#else /* (defined(MCU_MKW21D5)) || (defined(MCU_MKW21D5WS)) || (defined(MCU_MKW22D5)) || (defined(MCU_MKW22D5WS)) || (defined(MCU_MKW24D5)) || (defined(MCU_MKW24D5WS)) */
/**
 * @brief Disables the integrated interchip sound 0 transmit interrupt vector
 * number 44.
 * @param PeripheralBase Pointer to a peripheral registers structure (peripheral
 *        base address). You can use the constant defined in the registers
 *        definition header file (<peripheral>_BASE_PTR) or the constant defined in
 *        the peripheral initialization component header file
 *        (<component_name>_DEVICE).
 * @return Returns a value of void type.
 * @remarks The macro accesses the following registers: NVIC_ICER, ICER[]
 *          (depending on the peripheral).
 * @par Example:
 *      @code
 *      NVIC_PDD_DisableVector44(<peripheral>_BASE_PTR);
 *      @endcode
 */
  #define NVIC_PDD_DisableVector44(PeripheralBase) ( \
      NVIC_ICER_REG(PeripheralBase,0U) = \
       0x10000000U \
    )
#endif /* (defined(MCU_MKW21D5)) || (defined(MC