/*
                     MC68HC05P1  HEADER

WRITTEN:    9/21/89
REVISION:   0.9
USE FOR:    MC68HC05P1

The following header describes the memory, vectors, peripherals and special
instructions for the MC68HC05P1 microprocessor.  The information is taken from
the Motorola Data Sheet and is assumed to be correct.  It is specifically
designed to work with the Byte Craft C6805 Compiler, and is offered free for
your convenience.

I have taken most of the mnemonics directly from the Motorola literature with
the exception of those labels which could cause confusion with the compiler
or the assembler.  Please check all labels before using.

If you discover any errors or omissions, please communicate them to me through
the FREEWARE bulletin board or directly at the Motorola Detroit Sales Office
(313) 347-6800 (Before 10/15/89: 261-6200).

Mike Pauwels,  Senior FAE

******************************************************************************
*                                                                            *
* This product is distributed without charge to users via the MOTOROLA       *
* FREEWARE Bulletin Board.  The product is provided "as is" without warranty *
* of any kind either expressed or implied, including, but not limited to any *
* warranties of merchantability and fitness for a particular purpose.  All   *
* risks of using this product including the entire costs of any necessary    *
* remedies are those of the user and MOTOROLA assumes no liability of any    *
* kind.                                                                      *
*                                                                            *
******************************************************************************

*/


/*                   MEMORY MAP                                              */

#pragma memory ROMPROG  [2048]  @ 0x0100 ;
#pragma memory ROMPAGE0 [48]    @ 0x0020 ;
#pragma memory RAMPAGE0 [128]   @ 0x0080 ;


/*                   INTERRUPT VECTORS                                       */

#pragma vector __RESET @ 0x1ffe ;
#pragma vector SWI     @ 0x1ffc ;
#pragma vector IRQ     @ 0x1ffa ;
#pragma vector TIMER   @ 0x1ff8 ;


/*                   INPUT/ OUTPUT PORTS                                     */

#pragma portrw porta   @ 0x00;  /* General Purpose I/O Port                  */
#define bit0 0
#define bit1 1
#define bit2 2
#define bit3 3
#define bit4 4
#define bit5 5
#define bit6 6
#define bit7 7

#pragma portrw portb   @ 0x01;  /* i/o, i/o, i/o, 0; 0,0,0,0                 */
#pragma portrw portc   @ 0x02;  /* General Purpose I/O Port                  */
#pragma portr  portd   @ 0x03;  /* TCAP, PD5, 0, 0,; 0, 0, 0, 0              */
#define tcap 7                  /* Timer Input Capture                       */

#pragma portrw ddra    @ 0x04;  /* Data direction, Port A                    */
#pragma portrw ddrb    @ 0x05;  /* Data direction, Port B                    */
#pragma portrw ddrc    @ 0x06;  /* Data direction, Port C                    */


/*                    TIMER REGISTERS                                        */

#pragma portrw tcr     @ 0x12;  /* ICIE,OCIE,TOIE,0;0,0,IEGE,OLVL            */
#define icie   7                /* Input Capture Interrupt Enable            */
#define ocie   6                /* Output Compare Interrupt Enable           */
#define toie   5                /* Timer Overflow Interrupt Enable           */
#define iege   1                /* Input Edge                                */
#define olvl   0                /* Output Level                              */

#pragma portr  tsr     @ 0x13;  /* ICF,OCF,TOF,0; 0,0,0,0                    */
#define icf    7                /* Input Capture Flag                        */
#define ocf    6                /* Output Compare Flag                       */
#define tof    5                /* Timer Overflow Flag                       */

#pragma portr  ichr    @ 0x14;  /* Input Capture Reg High Byte               */
#pragma portr  iclr    @ 0x15;  /* Input Capture Reg Low Byte                */
#pragma portrw ochr    @ 0x16;  /* Output Compare Reg High Byte              */
#pragma portrw oclr    @ 0x17;  /* Output Compare Reg Low Byte               */
#pragma portr  tchr    @ 0x18;  /* Timer Counter Register High Byte          */
#pragma portr  tclr    @ 0x19;  /* Timer Counter Register Low Byte           */
#pragma portr  achr    @ 0x1A;  /* Alternate Count Reg High Byte             */
#pragma portr  aclr    @ 0x1B;  /* Alternate Count Reg Low Byte              */


/*                   MC68HC05 INSTRUCTIONS                                   */

#pragma has STOP ;
#pragma has WAIT ;
#pragma has MUL ;

