/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Bits1.H
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : BitsIO
**     Version   : Bean 02.098, Driver 01.19, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 4:24 PM
**     Abstract  :
**         This bean "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
**         Note: This bean is set to work in Output direction only.
**     Settings  :
**         Port name                   : GPIOA
**
**         Bit mask of the port        : 003F
**         Number of bits/pins         : 6
**         Single bit numbers          : 0 to 5
**         Values range                : 0 to 63
**
**         Initial direction           : Output (direction cannot be changed)
**         Initial output value        : 0 = 000H
**         Initial pull option         : off
**
**         Port data register          : GPIO_A_DR [F181]
**         Port control register       : GPIO_A_DDR [F182]
**         Port function register      : GPIO_A_PER [F183]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    44   |   GPIOA0_PWM0
**                    1      |    43   |   GPIOA1_PWM1
**                    2      |    35   |   GPIOA2_PWM2
**                    3      |    36   |   GPIOA3_PWM3_TXD_EXTAL
**                    4      |    33   |   GPIOA4_PWM4_FAULT1_SDA_TIN2
**                    5      |    29   |   GPIOA5_PWM5_FAULT2_EXT_SYNC_TIN3
**             ----------------------------------------------------
**
**         Optimization for            : speed
**     Contents  :
**         GetDir - bool Bits1_GetDir(void);
**         GetVal - byte Bits1_GetVal(void);
**         PutVal - void Bits1_PutVal(byte Val);
**         GetBit - bool Bits1_GetBit(byte Bit);
**         PutBit - void Bits1_PutBit(byte Bit, bool Val);
**         SetBit - void Bits1_SetBit(byte Bit);
**         ClrBit - void Bits1_ClrBit(byte Bit);
**         NegBit - void Bits1_NegBit(byte Bit);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __Bits1_H
#define __Bits1_H

/* MODULE Bits1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#include "Cpu.h"

#define Bits1_PIN_MASK          ((byte)0x3F) /* Pin mask */


/*
** ===================================================================
**     Method      :  Bits1_GetVal (bean BitsIO)
**
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**         Note: This bean is set to work in Output direction only.
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 63)
** ===================================================================
*/
#define Bits1_GetVal() ((byte)(getRegBits(GPIO_A_DR,Bits1_PIN_MASK)))
/*
** ===================================================================
**     Method      :  Bits1_PutVal (bean BitsIO)
**
**     Description :
**         This method writes the new output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 63)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_PutVal(byte Val);

/*
** ===================================================================
**     Method      :  Bits1_GetBit (bean BitsIO)
**
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**         Note: This bean is set to work in Output direction only.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 5)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Bits1_GetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bits1_PutBit (bean BitsIO)
**
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 5)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_PutBit(byte Bit, bool Val);

/*
** ===================================================================
**     Method      :  Bits1_SetBit (bean BitsIO)
**
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 5)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_SetBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bits1_ClrBit (bean BitsIO)
**
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 5)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_ClrBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bits1_NegBit (bean BitsIO)
**
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Bits1_NegBit(byte Bit);

/*
** ===================================================================
**     Method      :  Bits1_GetDir (bean BitsIO)
**
**     Description :
**         This method returns direction of the bean.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the bean (always TRUE, Output only)
**                      FALSE = Input, TRUE = Output
** ===================================================================
*/
#define Bits1_GetDir() ((bool)(getRegBits(GPIO_A_DDR,Bits1_PIN_MASK)))

/* END Bits1. */

#endif /* __Bits1_H*/
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
