/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : DFR1.C
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : DSP_Func_DFR
**     Version   : Bean 01.030, Driver 01.11, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:13 PM
**     Abstract  :
**          The DSP568xx Digital Signal Processing Function Library provides many
**          different types of signal processing algorithms. Most of these signal
**          processing algorithms, such as FFT, FIR, IIR, and correlation,
**          are general purpose. These algorithms can be used for digital filters,
**          speech coders, vector and array processing, and motor control.
**     Settings  :
**          Bean Name                      : DFR1
**          Use Assembler Files            : yes
**          Memory Management Library      : MEM1
**     Contents  :
**         dfr16FIR           - void DFR1_dfr16FIR(dfr16_tFirStruct *pFIR,Frac16 *pX,Frac16 *pZ,UInt16 n);
**         dfr16FIRCreate     - EXPORT dfr16_tFirStruct * DFR1_dfr16FIRCreate(Frac16 *pC,UInt16 n);
**         dfr16FIRHistory    - void DFR1_dfr16FIRHistory(dfr16_tFirStruct *pFIR,Frac16 *pX);
**         dfr16FIRDestroy    - void DFR1_dfr16FIRDestroy(dfr16_tFirStruct *pFIR);
**         dfr16FIRInit       - void DFR1_dfr16FIRInit(dfr16_tFirStruct *pFIR,Frac16 *pC,UInt16 n);
**         dfr16FIRs          - Frac16 DFR1_dfr16FIRs(dfr16_tFirStruct *pFIR,Frac16 x);
**         dfr16FIRInt        - UInt16 DFR1_dfr16FIRInt(dfr16_tFirIntStruct *pFIRINT,Frac16 *pX,Frac16...
**         dfr16FIRIntCreate  - EXPORT dfr16_tFirIntStruct * DFR1_dfr16FIRIntCreate(Frac16 *pC,UInt16...
**         dfr16FIRIntDestroy - void DFR1_dfr16FIRIntDestroy(dfr16_tFirIntStruct *pFIRInt);
**         dfr16FIRIntInit    - void DFR1_dfr16FIRIntInit(dfr16_tFirIntStruct *pFIRInt,Frac16 *pC,UInt16...
**         dfr16FIRDec        - UInt16 DFR1_dfr16FIRDec(dfr16_tFirDecStruct *pFIRDEC,Frac16 *pX,Frac16...
**         dfr16FIRDecCreate  - EXPORT dfr16_tFirDecStruct * DFR1_dfr16FIRDecCreate(Frac16 *pC,UInt16...
**         dfr16FIRDecDestroy - void DFR1_dfr16FIRDecDestroy(dfr16_tFirDecStruct *pFIRDec);
**         dfr16FIRDecInit    - void DFR1_dfr16FIRDecInit(dfr16_tFirDecStruct *pFIRDec,Frac16 *pC,UInt16...
**         dfr16IIR           - Result DFR1_dfr16IIR(dfr16_tIirStruct *pIIR,Frac16 *pX,Frac16 *pZ,UInt16 n);
**         dfr16IIRCreate     - EXPORT dfr16_tIirStruct * DFR1_dfr16IIRCreate(Frac16 *pC,UInt16 nbiq);
**         dfr16IIRDestroy    - void DFR1_dfr16IIRDestroy(dfr16_tIirStruct *pIIR);
**         dfr16IIRInit       - void DFR1_dfr16IIRInit(dfr16_tIirStruct *pIIR,Frac16 *pC,UInt16 nbiq);
**         dfr16AutoCorr      - Result DFR1_dfr16AutoCorr(UInt16 options,Frac16 *pX,Frac16 *pZ,UInt16...
**         dfr16Corr          - Result DFR1_dfr16Corr(UInt16 options,Frac16 *pX,Frac16 *pY,Frac16 *pZ,UInt16...
**         dfr16CFFT          - Result DFR1_dfr16CFFT(dfr16_tCFFTStruct *pCFFT,CFrac16 *pX,CFrac16 *pZ);
**         dfr16CFFTCreate    - dfr16_tCFFTStruct * DFR1_dfr16CFFTCreate(UInt16 n,UInt16 options);
**         dfr16CFFTDestroy   - void DFR1_dfr16CFFTDestroy(dfr16_tCFFTStruct *pCFFT);
**         dfr16CFFTInit      - void DFR1_dfr16CFFTInit(dfr16_tCFFTStruct *pCFFT,UInt16 n,UInt16 options);
**         dfr16CIFFT         - Result DFR1_dfr16CIFFT(dfr16_tCFFTStruct *pCIFFT,CFrac16 *pX,CFrac16 *pZ);
**         dfr16CIFFTCreate   - dfr16_tCFFTStruct * DFR1_dfr16CIFFTCreate(UInt16 n,UInt16 options);
**         dfr16CIFFTDestroy  - void DFR1_dfr16CIFFTDestroy(dfr16_tCFFTStruct *pCIFFT);
**         dfr16CIFFTInit     - void DFR1_dfr16CIFFTInit(dfr16_tCFFTStruct *pCIFFT,UInt16 n,UInt16 options);
**         dfr16RFFT          - Result DFR1_dfr16RFFT(dfr16_tRFFTStruct *pRFFT,Frac16 *pX,dfr16_sInplaceCRFFT...
**         dfr16RFFTCreate    - dfr16_tRFFTStruct * DFR1_dfr16RFFTCreate(UInt16 n,UInt16 options);
**         dfr16RFFTDestroy   - void DFR1_dfr16RFFTDestroy(dfr16_tRFFTStruct *pRFFT);
**         dfr16RFFTInit      - void DFR1_dfr16RFFTInit(dfr16_tRFFTStruct *pRFFT,UInt16 n,UInt16 options);
**         dfr16RIFFT         - Result DFR1_dfr16RIFFT(dfr16_tRFFTStruct *pRIFFT,dfr16_sInplaceCRFFT...
**         dfr16RIFFTCreate   - dfr16_tRFFTStruct * DFR1_dfr16RIFFTCreate(UInt16 n,UInt16 options);
**         dfr16RIFFTDestroy  - void DFR1_dfr16RIFFTDestroy(dfr16_tRFFTStruct *pRIFFT);
**         dfr16RIFFTInit     - void DFR1_dfr16RIFFTInit(dfr16_tRFFTStruct *pRIFFT,UInt16 n,UInt16 options);
**         dfr16Cbitrev       - Result DFR1_dfr16Cbitrev(CFrac16 *pX,CFrac16 *pZ,UInt16 n);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE DFR1. */

#include "DFR1.h"

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIR (bean DSP_Func_DFR)
**
**     Description :
**         The method computes a Finite Impulse Response, (FIR),
**         filter for a vector of fractional data values. Prior to
**         any call to fir, the FIR filter data structure referred
**         to by the first parameter pFIR must be allocated and
**         initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirStruct
**         data structure and then initializing it with a call to
**         dfr16FIRInit, or dynamically by calling dfr16FIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure
**                           containing private data for the fir
**                           filter.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**       * pZ              - Pointer to the output vector of n data
**                           elements.
**         n               - Length of the input and output vectors.
**     Returns     : Nothing
** ===================================================================
*/
/*void dfr16FIR(dfr16_tFirStruct *pFIR,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs memory allocation and initialization
**         for the fir filter function.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pC              - Pointer to a vector of FIR filter
**                           coefficients.
**         n               - Length of the vector of FIR filter
**                           coefficients pointed to by pC.
**     Returns     :
**         ---             - The function returns a pointer to the
**                           dfr16_tFirStruct data structure that it
**                           allocated if all allocations and
**                           initializations succeed. This pointer
**                           must then be passed to subsequent calls
**                           of the fir function.
** ===================================================================
*/
/*
dfr16_tFirStruct * dfr16FIRCreate(Frac16 *pC,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure(s) initially
**         allocated by firCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure created
**                           by the firCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRDestroy(dfr16_tFirStruct *pFIR)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRInit (bean DSP_Func_DFR)
**
**     Description :
**         The method initializes the fir filter function from a
**         previously allocated dfr16_tFirStruct data structure.
**         Typically, this dfr16_tFirStruct data structure is
**         allocated statically by the caller prior to the firInit
**         call. However, firCreate also uses firInit to initialize
**         the dfr16_tFirStruct that it dynamically allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a previously allocated
**                           dfr16_rFirStruct data structure.
**       * pC              - Pointer to a vector of FIR filter
**                           coefficients.
**         n               - Length of the vector of FIR filter
**                           coefficients pointed to by pC.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRInit(dfr16_tFirStruct *pFIR,Frac16 *pC,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRHistory (bean DSP_Func_DFR)
**
**     Description :
**         The method reinitializes the Finite Impulse Response,
**         (FIR), filter history buffer data values. Prior to any
**         call to firHistory, the FIR filter must be initialized
**         via a call to firCreate. The firHistory function uses the
**         private data structure established by firCreate to
**         establish the past history of data elements required by
**         the FIR filter computation. The argument pX must point to
**         n fractional data elements, where n is the number of
**         coefficients used to establish the FIR filter in the call
**         to firCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure
**                           containing private data for the fir
**                           filter; created by a call to firCreate.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRHistory(dfr16_tFirStruct *pFIR,Frac16 *pX)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRs (bean DSP_Func_DFR)
**
**     Description :
**         The method computes a Finite Impulse Response (FIR)
**         filter for a single fractional data value. Prior to any
**         call to fir, the FIR filter data structure referred to by
**         the first parameter pFIR must be allocated and
**         initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirStruct
**         data structure and then initializing it with a call to
**         dfr16FIRInit, or dynamically by calling dfr16FIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure
**                           containing private data for the fir
**                           filter.
**         x               - Input data value.
**     Returns     :
**         ---             - The FIR filter computation returns the
**                           single output value which results from
**                           the FIR calculation on the single input
**                           value.
** ===================================================================
*/
/*
Frac16 dfr16FIRs(dfr16_tFirStruct *pFIR,Frac16 x)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRInt (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an interpolating Finite Impulse
**         Response, (FIR), filter for a vector of fractional data
**         values. Prior to any call to firint, the FIR filter data
**         structure referred to by the first parameter pFIRINT must
**         be allocated and initialized. This allocation and
**         initialization can be done either statically by declaring
**         a dfr16_tFirIntStruct data structure and then
**         initializing it with a call to dfr16FIRIntInit, or
**         dynamically by calling dfr16FIRIntCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRINT         - Pointer to a data structure
**                           containing private data for the firint
**                           filter.
**       * pX              - Pointer to a vector of interpolating FIR
**                           filter coefficients.
**       * pZ              - Pointer to length of the vector of
**                           interpolating FIR filter coefficients
**                           pointed to by pC.
**         n               - The interpolation factor; the firint
**                           filter will produce f outputs for every
**                           input.
**     Returns     :
**         ---             - The firint filter computation generates
**                           (n * f) output values, which are stored
**                           in the vector pointed to by pZ, where f
**                           is the interpolation factor established
**                           in the call to firintCreate.
** ===================================================================
*/
/*
UInt16 dfr16FIRInt(dfr16_tFirIntStruct *pFIRINT,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRIntCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for the firint
**         filter function. The firintCreate function allocates and
**         initializes a data structure, dfr16_tFirIntStruct, which
**         is used by firint to preserve the filters state between
**         calls. The data structure preserves the pC pointer to the
**         vector of interpolating FIR filter coefficients. The
**         function firintCreate also allocates a buffer to save the
**         past history of n data elements required by the
**         interpolating FIR filter computation; a pointer to this
**         buffer is stored in the data structure returned by firint.
**         So that firint can achieve maximum efficiency using
**         modulo addressing, firintCreate allocates the history
**         buffer from the system heap such that its address starts
**         on a k-bit boundary, where k=log2(n).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pC              - Pointer to a vector of interpolating FIR
**                           filter coefficients.
**         n               - Length of the vector of interpolating FIR
**                           filter coefficients pointed to by pC.
**         f               - The interpolation factor; the firint
**                           filter will produce f outputs for every
**                           input.
**     Returns     :
**         ---             - If all allocations and initializations
**                           succeed, firintCreate returns the
**                           pointer to the allocated data structure
**                           dfr16_tFirIntStruct. This pointer must
**                           then be passed to subsequent calls of
**                           the firint function.
** ===================================================================
*/
/*
dfr16_tFirIntStruct * dfr16FIRIntCreate(Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRIntDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure initially
**         allocated by firintCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRInt         - Pointer to a data structure
**                           created by the firintCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRIntDestroy(dfr16_tFirIntStruct *pFIRInt)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRIntInit (bean DSP_Func_DFR)
**
**     Description :
**         The method initializes the firint filter function from a
**         previously allocated dfr16_tFirIntStruct data structure.
**         Typically, this dfr16_tFirIntStruct data structure is
**         allocated statically by the caller prior to the
**         firintInit call. However, firintCreate also uses
**         firintInit to initialize the dfr16_tFirIntStruct that it
**         dynamically allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRInt         - Pointer to a previously
**                           allocated dfr16_rFirIntStruct data
**                           structure.
**       * pC              - Pointer to a vector of firint filter
**                           coefficients.
**         n               - Length of the vector of firint filter
**                           coefficients pointed to by pC.
**         f               - The interpolation factor; the firint
**                           filter will produce f outputs for every
**                           input.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRIntInit(dfr16_tFirIntStruct *pFIRInt,Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDec (bean DSP_Func_DFR)
**
**     Description :
**         The method computes a decimating Finite Impulse Response,
**         (FIR), filter for a vector of fractional data values.
**         Prior to any call to firdec, the FIR filter data
**         structure referred to by the first parameter pFIRDEC must
**         be allocated and initialized. This allocation and
**         initialization can be done either statically by declaring
**         a dfr16_tFirDecStruct data structure and then
**         initializing it with a call to dfr16FIRDecInit, or
**         dynamically by calling dfr16FIRDecCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRDEC         - Pointer to a data structure
**                           containing private data for the firdec
**                           filter.
**       * pX              - Pointer to the input vector of nx data
**                           elements.
**       * pZ              - Pointer to the output vector of *pNZ data
**                           elements.
**         nx              - Length of the input data vector pointed
**                           to by pX.
**     Returns     :
**         ---             - The firdec filter computation generates
**                           output values which are stored in the
**                           vector pointed to by pZ. The number of
**                           output values generated is returned by
**                           the firdec function. In general, the
**                           length of the output vector is equal to
**                           nx/f, where f is the decimation factor
**                           established in the call to firdecCreate.
**                           However, if nx is not an integral
**                           multiple of f, the length of the output
**                           vector may vary; see Special Issues in
**                           this section for more information on the
**                           length of the output vector.
** ===================================================================
*/
/*
UInt16 dfr16FIRDec(dfr16_tFirDecStruct *pFIRDEC,Frac16 *pX,Frac16 *pZ,UInt16 nx)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDecCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for the firdec
**         filter function. The function firdecCreate allocates and
**         initializes a data structure, dfr16_tFirDecStruct, which
**         is used by firdec to preserve the filters state between
**         calls. The data structure preserves the pC pointer to the
**         vector of decimating FIR filter coefficients. The
**         firdecCreate function also allocates a buffer to save the
**         past history of n data elements required by the
**         decimating FIR filter computation; a pointer to this
**         buffer is stored in the data structure pointed to by
**         pFIRDEC. So firdec can achieve maximum efficiency using
**         modulo addressing, firdecCreate allocates the history
**         buffer from the system heap such that its address starts
**         on a k-bit boundary, where k=log2(n).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pC              - Pointer to a vector of decimating FIR
**                           filter coefficients.
**         n               - Length of the vector of decimating FIR
**                           filter coefficients pointed to by pC.
**         f               - The decimation factor; the firdec filter
**                           will drop every f-1 output.
**     Returns     :
**         ---             - The function returns a pointer to the
**                           dfr16_tFirDecStruct data structure if
**                           all allocations and initializations
**                           succeed. This pointer must then be
**                           passed to subsequent calls of the firdec
**                           function.
** ===================================================================
*/
/*
dfr16_tFirDecStruct * dfr16FIRDecCreate(Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDecDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure initially
**         allocated by firdecCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRDec         - Pointer to a data structure
**                           created by the firdecCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRDecDestroy(dfr16_tFirDecStruct *pFIRDec)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDecInit (bean DSP_Func_DFR)
**
**     Description :
**         The method initializes the firdec filter function from a
**         previously allocated dfr16_tFirDecStruct data structure.
**         Typically, this dfr16_tFirDecStruct data structure is
**         allocated statically by the caller prior to the
**         firdecInit call. However, firdecCreate also uses
**         firdecInit to initialize the dfr16_tFirDecStruct that it
**         dynamically allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRDec         - Pointer to a previously
**                           allocated dfr16_rFirdecStruct data
**                           structure.
**       * pC              - Pointer to a vector of firdec filter
**                           coefficients.
**         n               - Length of the vector of firdec filter
**                           coefficients pointed to by pC.
**         f               - Factor
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRDecInit(dfr16_tFirDecStruct *pFIRDec,Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIR (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an Infinite Impulse Response, (IIR),
**         filter for a vector of fractional data values using a
**         cascade filter of biquad coefficients. Prior to any call
**         to iir, the IIR filter data structure referred to by the
**         first parameter pIIR must be allocated and initialized.
**         This allocation and initialization can be done either
**         statically by declaring a dfr16_tIirStruct data structure
**         and then initializing it with a call to dfr16IIRInit, or
**         dynamically by calling dfr16IIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pIIR            - Pointer to a data structure
**                           containing private data for the iir
**                           filter.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**       * pZ              - Pointer to the output vector of n data
**                           elements.
**         n               - Length of the input and output vectors.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors,
**                           n, is greater than 8192; PASS (0):
**                           otherwise
** ===================================================================
*/
/*
Result dfr16IIR(dfr16_tIirStruct *pIIR,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIRCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for the cascade
**         iir filter function. The function iirCreate allocates and
**         initializes a data structure, which is used by iir to
**         preserve the filters state between calls. The data
**         structure preserves the pC pointer to the linearized
**         vector of n biquad IIR filter coefficients. The iirCreate
**         function also allocates a buffer to save the past history
**         of two data elements (as shown in the formula below using
**         variable w) per biquad required by the cascade IIR
**         filter computation; a pointer to this buffer is stored in
**         the private data structure. So that iir can achieve
**         maximum efficiency using modulo addressing, iirCreate
**         allocates the history buffer from the system heap such
**         that its address starts on a k-bit boundary, where: k =
**         log(2)(2 * n).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pC              - Pointer to a vector of cascaded IIR
**                           filter coefficients, organized as a
**                           linear vector of n biquads, 5
**                           coefficients per biquad.
**         nbiq            - The number of biquads for the
**                           cascaded iir filter.
**     Returns     :
**         ---             - The function returns a pointer to a
**                           private data structure, which must then
**                           be passed to subsequent calls of the iir
**                           function.
** ===================================================================
*/
/*
dfr16_tIirStruct * dfr16IIRCreate(Frac16 *pC,UInt16 nbiq)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIRDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure(s) initially
**         allocated by iirCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pIIR            - Pointer to a data structure created
**                           by the iirCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16IIRDestroy(dfr16_tIirStruct *pIIR)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIRInit (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for the cascade
**         iir filter function and initializes the function from a
**         previously-allocated dfr16_tIirStruct data structure.
**         Typically, the dfr16_tIirStruct data structure is
**         allocated statically by the caller prior to the iirInit
**         call. The iirCreate function also uses iirInit to
**         initialize the dfr16_tIirStruct that it dynamically
**         allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pIIR            - Pointer to a data structure allocated
**                           statically by the caller before iirInit
**                           is called.
**       * pC              - Pointer to a vector of cascaded IIR
**                           filter coefficients, organized as a
**                           linear vector of n biquads, 5
**                           coefficients per biquad.
**         nbiq            - The number of biquads for the
**                           cascaded iir filter.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16IIRInit(dfr16_tIirStruct *pIir,Frac16 *pC,UInt16 nbiq)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16AutoCorr (bean DSP_Func_DFR)
**
**     Description :
**         The method computes the first nz points of
**         auto-correlation of a vector of fractional data values.
**     Parameters  :
**         NAME            - DESCRIPTION
**         options         - Selects raw, biased, or
**                           unbiased auto correlation.
**       * pX              - Pointer to the input vector of nx data
**                           elements.
**       * pZ              - Pointer to the output vector of nz data
**                           elements.
**         nx              - Length of the input vector pointed to by
**                           pX.
**         nz              - Length of the output vector pointed to by
**                           pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the output vector, nz, is
**                           outside the range 0 <= nz <= min(2nx-1,
**                           8192), or if the options parameter is
**                           invalid; PASS (0): otherwise
** ===================================================================
*/
/*
Result dfr16AutoCorr(UInt16 options,Frac16 *pX,Frac16 *pZ,UInt16 nx,UInt16 nz)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16Corr (bean DSP_Func_DFR)
**
**     Description :
**         The method computes the full length correlation of two
**         vectors of fractional data values.
**     Parameters  :
**         NAME            - DESCRIPTION
**         options         - Selects between raw, biased,
**                           and unbiased correlation.
**       * pX              - Pointer to the first input vector of nx
**                           data elements.
**       * pY              - Pointer to the second input vector of ny
**                           data elements.
**       * pZ              - Pointer to the output vector of (nx + ny
**                           -1) data elements.
**         nx              - Length of the input vector pointed to by
**                           pX.
**         ny              - Length of the input vector pointed to by
**                           pY.
**     Returns     :
**         ---             - The corr computation generates (nx + ny
**                           - 1) output values which are stored in
**                           the vector pointed to by pZ.
**                           The function corr returns:
**                           - FAIL (-1): if the length of the output
**                           vector, nx + ny - 1, exceeds 8192.
**                           - PASS (0): otherwise
** ===================================================================
*/
/*
Result dfr16Corr(UInt16 options,Frac16 *px,Frac16 *py,Frac16 *pz,UInt16 nx,UInt16 ny)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFT (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, complex,
**         decimation-in-time, (DIT), forward Fast Fourier Transform
**         function for a vector of complex fractional data values.
**         Prior to any call to cfft, the CFFT data structure
**         referred to by the first parameter pCFFT must be
**         allocated and initialized. This allocation and
**         initialization can be done either statically by declaring
**         a dfr16_tCFFTStruct data structure and then initializing
**         it with a call to dfr16CFFTInit, or dynamically by
**         calling dfr16CFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCFFT           - Pointer to a data structure
**                           containing private data for the cfft
**                           function.
**       * pX              - Pointer to the input vector of n complex
**                           fractional data.
**       * pZ              - Pointer to the output structure of
**                           complex values.
**     Returns     :
**         ---             - The function returns either FAIL or
**                           the amount of scaling done: Note:
**                           Scaling/Scale down implies Right Shift;
**                           Scale up implies Left Shift. -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result
**                           was scaled down by so many times.
** ===================================================================
*/
/*
Result dfr16CFFT(dfr16_tCFFTStruct *pCFFT,CFrac16 *pX,CFrac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFTCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, cfft, using complex
**         fractional data values. The function cfftCreate allocates
**         and initializes a data structure, which is used by cfft
**         to preserve the FFT functions state between calls.
**     Parameters  :
**         NAME            - DESCRIPTION
**         n               - Length of the complex FFT input and
**                           output vectors: 8, 16, 32, 64, 128, 256,
**                           512, 1024, 2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     :
**         ---             - The function returns a pointer to a
**                           private data structure, which must then
**                           be passed to subsequent calls of the
**                           cfft function.
** ===================================================================
*/
/*
dfr16_tCFFTStruct * dfr16CFFTCreate(UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFTDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure(s) initially
**         allocated by cfftCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCFFT           - Pointer to a data structure created
**                           by the cfftCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CFFTDestroy(dfr16_tCFFTStruct *pCFFT)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFTInit (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, cfft, using complex
**         fractional data values. Initializes the function from a
**         previously-allocated dfr16_tCFFTStruct data structure.
**         Typically, the dfr16_tCFFTStruct data structure is
**         allocated statically by the caller prior to the cfftInit
**         call. The cfftCreate function also uses cfftInit to
**         initialize the dfr16_tCFFTStruct that it dynamically
**         allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCFFT           - Pointer to a data structure
**                           containing private data for the cfft
**                           function; this pointer is statically
**                           allocated by caller prior to the
**                           dfr16CFFTInit function.
**         n               - Length of the complex FFT input and
**                           output vectors: 8, 16, 32, 64, 128, 256,
**                           512, 1024, 2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CFFTInit(dfr16_tCFFTStruct *pCFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFT (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, complex,
**         decimation-in-time (DIT), inverse Fast Fourier Transform
**         function for a vector of complex fractional data values.
**         Prior to any call to cifft, the CFFT data structure
**         referred to by the first parameter pCIFFT must be
**         allocated and initialized. This allocation and
**         initialization can be done either statically by declaring
**         a dfr16_tCFFTStruct data structure and then initializing
**         it with a call to dfr16CIFFTInit, or dynamically by
**         calling dfr16CIFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCIFFT          - Pointer to a data structure
**                           containing private data for the cifft
**                           function.
**       * pX              - Pointer to the input structure of complex
**                           values.
**       * pZ              - Pointer to the output structure of
**                           complex values.
**     Returns     :
**         ---             - The function returns either FAIL or
**                           the amount of scaling done: -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result
**                           was scaled down by so many times
** ===================================================================
*/
/*
Result dfr16CIFFT(dfr16_tCFFTStruct *pCIFFT,CFrac16 *pX,CFrac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFTCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), inverse Fast
**         Fourier Transform, (IFFT), using complex fractional data
**         values. The function cifftCreate allocates and
**         initializes a data structure, which is used by cifft to
**         preserve the IFFT functions state between calls.
**     Parameters  :
**         NAME            - DESCRIPTION
**         n               - Length of the inverse complex FFT input
**                           and output vectors 8, 16, 32, 64, 128,
**                           256, 512, 1024, or 2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     :
**         ---             - The function returns a pointer to a
**                           private data structure, which must then
**                           be passed to subsequent calls of the
**                           cifft function.
** ===================================================================
*/
/*
dfr16_tCFFTStruct * dfr16CIFFTCreate(UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFTDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure (s) initially
**         allocated by cifftCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCIFFT          - Pointer to a data structure
**                           created by the cifftCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CIFFTDestroy(dfr16_tCFFTStruct *pCIFFT)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFTInit (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), inverse Fast
**         Fourier Transform, (IFFT), using complex fractional data
**         values. Initializes the function from a
**         previously-allocated dfr16_tCFFTStruct data structure.
**         Typically, the dfr16_tCFFTStruct data structure is
**         allocated statically by the caller prior to the cifftInit
**         call. The cifftCreate function also uses cifftInit to
**         initialize allocate the dfr16_tCFFTStruct dynamically.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCIFFT          - Pointer to a data structure
**                           containing private data for the cfft
**                           function; this pointer is statically
**                           allocated by caller prior to the
**                           dfr16CFFTInit function.
**         n               - Length of the complex FFT input and
**                           output vectors: 8, 16, 32, 64, 128, 256,
**                           512, 1024, 2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CIFFTInit(dfr16_tCFFTStruct *pCIFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFT (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, real,
**         decimation-in-time (DIT) forward Fast Fourier Transform
**         function for a vector of fractional data values. Prior to
**         any call to rfft, the RFFT data structure referred to by
**         the first parameter pRFFT must be allocated and
**         initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tRFFTStruct
**         data structure and then initializing it with a call to
**         dfr16RFFTInit, or dynamically by calling dfr16RFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRFFT           - Pointer to a data structure
**                           containing private data for the rfft
**                           function.
**       * pX              - Pointer to the input vector of n
**                           fractional data elements,stored in
**                           normal, as opposed to bit-reversed,
**                           order.
**       * pZ              - Pointer to the output structure of
**                           complex values.
**     Returns     :
**         ---             - The function returns either FAIL, or
**                           the number of stages of FFT scaled. -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result
**                           was scaled down by so many times
** ===================================================================
*/
/*
Result dfr16RFFT(dfr16_tRFFTStruct *pRFFT,Frac16 *pX,dfr16_sInplaceCRFFT *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFTCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, real, decimation-in-time, (DIT), forward Fast
**         Fourier Transform, (FFT), function using fractional data
**         values. The function rfftCreate allocates and initializes
**         a data structure, which is used by rfft to preserve the
**         FFT functions state between calls.
**     Parameters  :
**         NAME            - DESCRIPTION
**         n               - Length of the real FFT input vector 8,16,
**                           32, 64, 128, 256, 512, 1024, or 2048.
**         options         - Option flags to control rfft
**                           algorithm operation.
**     Returns     :
**         ---             - The function returns a pointer to a
**                           private data structure, which must then
**                           be passed to subsequent calls of the
**                           rfft function.
** ===================================================================
*/
/*
dfr16_tRFFTStruct dfr16RFFTCreate(UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFTDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure(s) initially
**         allocated by rfftCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRFFT           - Pointer to a data structure created
**                           by the rfftCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RFFTDestroy(dfr16_tRFFTStruct *pRFFT)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFTInit (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, real, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, rfft, using complex
**         fractional data values. Initializes the function from a
**         previously allocated dfr16_tRFFTStruct data structure.
**         Typically, the dfr16_tRFFTStruct data structure is
**         allocated statically by the caller prior to the rfftInit
**         call. The rfftCreate function also uses rfftInit to
**         initialize the dfr16_tRFFTStruct that it dynamically
**         allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRFFT           - Pointer to a data structure
**                           containing private data for the cfft
**                           function; this pointer is statically
**                           created by caller prior to the
**                           dfr16CFFTInit function.
**         n               - Length of the complex FFT input and
**                           output vectors: 8, 16, 32, 64, 128, 256,
**                           512, 1024, 2048.
**         options         - Option flags to control rfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RFFTInit(dfr16_tRFFTStruct *pRFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFT (bean DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2,
**         decimation-in-time, (DIT), inverse Fast Fourier Transform
**         function for a structure of complex data values. Prior to
**         any call to rifft, the RFFT data structure referred to by
**         the first parameter pRIFFT must be allocated and
**         initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tRFFTStruct
**         data structure and then initializing it with a call to
**         dfr16RIFFTInit, or dynamically by calling
**         dfr16RIFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRIFFT          - Pointer to a data structure
**                           containing private data for the rifft
**                           function.
**       * pX              - Pointer to the input structure of complex
**                           values stored in normal, rather than
**                           bit-reversed, order.
**       * pZ              - Pointer to the output vector of real
**                           values stored in normal order.
**     Returns     :
**         ---             - The function returns either FAIL or
**                           the number of stages of FFT scaled. -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result
**                           was scaled down by so many times.
** ===================================================================
*/
/*
Result dfr16RIFFT(dfr16_tRFFTStruct *pRIFFT,dfr16_sInplaceCRFFT *pX,Frac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFTCreate (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         inverse real Fast Fourier Transform, (IFFT), function
**         using fractional data values. The function rifftCreate
**         allocates and initializes a data structure, which is used
**         by rifft to preserve the FFT functions state between
**         calls.
**     Parameters  :
**         NAME            - DESCRIPTION
**         n               - Length of the inverse real FFT output
**                           vector 8,16, 32, 64, 128, 256, 512, 1024,
**                           or 2048.
**         options         - Option flags to control rifft
**                           algorithm operation.
**     Returns     :
**         ---             - The function returns a pointer to a
**                           private data structure, which must then
**                           be passed to subsequent calls of the
**                           rifft function.
** ===================================================================
*/
/*
dfr16_tRFFTStruct * dfr16RIFFTCreate(UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFTDestroy (bean DSP_Func_DFR)
**
**     Description :
**         The method deallocates the data structure(s) initially
**         allocated by rifftCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRIFFT          - Pointer to a data structure
**                           created by the rifftCreate function.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RIFFTDestroy(dfr16_tRFFTStruct *pRIFFT)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFTInit (bean DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, real, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, rifft, using complex
**         fractional data values. Initializes the function from a
**         previously allocated dfr16_tRIFFTStruct data structure.
**         Typically, the dfr16_tRIFFTStruct data structure is
**         allocated statically by the caller prior to the rifftInit
**         call. The rifftCreate function also uses rifftInit to
**         initialize the dfr16_tRIFFTStruct that it dynamically
**         allocates.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRIFFT          - Pointer to a data structure
**                           created by the rifftCreate function.
**         n               - Length of the inverse real FFT output
**                           vector 8,16, 32, 64, 128, 256, 512, 1024,
**                           or 2048.
**         options         - Option flags to control rifft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RIFFTInit(dfr16_tRFFTStruct *pRIFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16Cbitrev (bean DSP_Func_DFR)
**
**     Description :
**         The method bit-reverses the position of n complex data
**         elements in the input vector, pointed to by pX. The
**         cbitrev function is used to convert normal, (linear),
**         order complex vectors to bit-reversed complex vectors,
**         and vice-versa, for use in Fast Fourier Transform
**         functions.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pX              - Pointer to the input vector of n complex
**                           data elements.
**       * pZ              - Pointer to the output vector of n complex
**                           data elements.
**         n               - Length of the input and output vectors
**                           pointed to by pX and pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors,
**                           n, is outside the range 0 < n lt= 8192
**                           PASS (0): otherwise.
** ===================================================================
*/
/*
Result dfr16Cbitrev_(CFrac16 *pX,CFrac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CbitrevC (bean DSP_Func_DFR)
**
**     Description :
**         The method bit-reverses the position of n complex data
**         elements in the input vector, pointed to by pX. The
**         cbitrev function is used to convert normal, (linear),
**         order complex vectors to bit-reversed complex vectors,
**         and vice-versa, for use in Fast Fourier Transform
**         functions.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pX              - Pointer to the input vector of n complex
**                           data elements.
**       * pZ              - Pointer to the output vector of n complex
**                           data elements.
**         n               - Length of the input and output vectors
**                           pointed to by pX and pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors,
**                           n, is outside the range 0 < n <= 8192
**                           PASS (0): otherwise.
** ===================================================================
*/
/*
static Result dfr16CbitrevC(CFrac16 *pX,CFrac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/* END DFR1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
