/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : MEM1.H
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : DSP_MEM
**     Version   : Bean 01.035, Driver 01.10, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:13 PM
**     Abstract  :
**          General-purpose ANSI C-compliant memory pool manager
**
**          These routines manage a memory buffer that you specify, internally
**          called the pool. Blocks of memory are allocated from and returned
**          to this pool. The first UInt32 of every block is the size of the block
**          in bytes, inclusive. This value is positive if the block is free,
**          negative if the block is in use, and zero if this is the last block
**          of the pool.
**     Settings  :
**          Bean Name:               MEM1
**          No others properties defined.
**     Contents  :
**         memCallocEM        - void* MEM1_memCallocEM(size_t num, size_t size);
**         memCallocIM        - void* MEM1_memCallocIM(size_t num, size_t size);
**         memFreeEM          - void MEM1_memFreeEM(void* memblock);
**         memFreeIM          - void MEM1_memFreeIM(void* memblock);
**         memIsAligned       - bool MEM1_memIsAligned(void* memblock, size_t size);
**         memIsEM            - bool MEM1_memIsEM(void* memblock);
**         memIsIM            - bool MEM1_memIsIM(void* memblock);
**         memMallocAlignedEM - void* MEM1_memMallocAlignedEM(size_t size);
**         memMallocAlignedIM - void* MEM1_memMallocAlignedIM(size_t size);
**         memMallocEM        - void* MEM1_memMallocEM(size_t size);
**         memMallocIM        - void* MEM1_memMallocIM(size_t size);
**         memReallocEM       - void* MEM1_memReallocEM(void* memblock, size_t size);
**         memReallocIM       - void* MEM1_memReallocIM(void* memblock, size_t size);
**         memMemcpy          - void* MEM1_memMemcpy(void* dest, void* src, ssize_t count);
**         memMemset          - void* MEM1_memMemset(void* dest, int c, ssize_t count);
**         memMemsetP         - void* MEM1_memMemsetP(void* dest, int c, ssize_t count);
**         memCopyPtoX        - void* MEM1_memCopyPtoX(void* pDest, void* pSrc, ssize_t Count);
**         memCopyXtoP        - void* MEM1_memCopyXtoP(void* pDest, void* pSrc, ssize_t Count);
**         memCopyPtoP        - void* MEM1_memCopyPtoP(void* pDest, void* pSrc, ssize_t Count);
**         memReadP16         - UWord16 MEM1_memReadP16(UWord16 *pSrc);
**         memReadP32         - UWord32 MEM1_memReadP32(UWord32 *pSrc);
**         memWriteP16        - void MEM1_memWriteP16(UWord16 Data, Word16 *pDest);
**         memWriteP32        - void MEM1_memWriteP32(Word32 Data, Word32 *pDest);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __MEM1
#define __MEM1

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "mem.h"
/* Include inherited beans */

#include "Cpu.h"
/* MODULE MEM1. */



                                       /* Internal memory management routines */
#define MEM1_memMallocIM(size) memMallocIM(size)
/*
** ===================================================================
**     Method      :  MEM1_memMallocIM (bean DSP_MEM)
**
**     Description :
**         The memMallocIM function allocates dynamic memory of the
**         specified size from the memory partitions. The function
**         memMallocIM first tries to allocate the memory from the
**         internal memory partition. However, if not enough space
**         exists in the internal memory partition to satisfy the
**         dynamic memory allocation, memMallocIM then tries the
**         allocation from the external memory partition. For
**         example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - The size of the memory buffer to be
**                           allocated in internal memory
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memMallocIM returns NULL
** ===================================================================
*/

#define MEM1_memReallocIM(memblock, size) memReallocIM(memblock, size)
/*
** ===================================================================
**     Method      :  MEM1_memReallocIM (bean DSP_MEM)
**
**     Description :
**         The memReallocIM function dynamically reallocates and
**         resizes a memory buffer to the specified size from the
**         memory partitions. The function memReallocIM first tries
**         to reallocate the memory from the internal memory
**         partition. However, if not enough space exists in the
**         internal memory partition to satisfy the dynamic memory
**         allocation, memReallocIM then tries the allocation from
**         the external memory partition For example see <Typical
**         Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - The address of the existing
**                           memory block to reallocate
**         size            - The new size to allocate
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memReallocIM returns "NULL"
** ===================================================================
*/

#define MEM1_memCallocIM(num, size) memCallocIM(num, size)
/*
** ===================================================================
**     Method      :  MEM1_memCallocIM (bean DSP_MEM)
**
**     Description :
**         The memCallocIM function dynamically allocates an array
**         with elements initialized to zero. The memCallocIM
**         function first tries to reallocate the memory from the
**         internal memory partition. For example see <Typical Usage
**         > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         num             - Number of elements
**         size            - Length in bytes of each element
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memCallocIM returns NULL.
** ===================================================================
*/

#define MEM1_memMallocAlignedIM(size) memMallocAlignedIM(size)
/*
** ===================================================================
**     Method      :  MEM1_memMallocAlignedIM (bean DSP_MEM)
**
**     Description :
**         The memMallocAlignedIM function allocates dynamic memory
**         of the specified size from the memory partitions and
**         aligns the memory properly to use modulo addressing. The
**         function memMallocAlignedIM first tries to allocate the
**         memory, properly aligned, from the internal memory
**         partition. However, if not enough space exists in the
**         internal memory partition to satisfy the dynamic memory
**         allocation, or if the memory request cannot be properly
**         aligned, memMallocAlignedIM then tries the allocation
**         from the external memory partition. If memMallocAlignedIM
**         cannot allocate an aligned buffer from either partition,
**         it calls memMallocIM to try to allocate a buffer of the
**         correct size without the proper alignment. For example
**         see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - The size of the memory buffer to be
**                           allocated in internal memory and aligned
**                           for modulo addressing
**     Returns     :
**         ---             - If memory cannot be allocated in
**                           sufficient size to satisfy the request
**                           from either partition,
**                           memMallocAlignedIM returns NULL.
** ===================================================================
*/

#define MEM1_memFreeIM(memblock) memFreeIM(memblock)
/*
** ===================================================================
**     Method      :  MEM1_memFreeIM (bean DSP_MEM)
**
**     Description :
**         The memFreeIM function deallocates a memory block in
**         internal memory that previously had been dynamically
**         allocated with the routine memMallocIM. For example see
**         <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - Pointer to previously
**                           allocated array
**     Returns     : Nothing
** ===================================================================
*/

#define MEM1_memIsIM(memblock) memIsIM(memblock)
/*
** ===================================================================
**     Method      :  MEM1_memIsIM (bean DSP_MEM)
**
**     Description :
**         The memIsIM function checks the address of a memory block
**         to determine whether it is in internal memory or external
**         memory. For example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - The address of the memory
**                           block to be confirmed in internal memory
**     Returns     :
**         ---             - The function memIsIM returns true if
**                           the address is in internal memory;
**                           otherwise, it returns false.
** ===================================================================
*/

                                       /* External memory management routines */
#define MEM1_memMallocEM(size) memMallocEM(size)
/*
** ===================================================================
**     Method      :  MEM1_memMallocEM (bean DSP_MEM)
**
**     Description :
**         The memMallocEM function allocates dynamic memory of the
**         specified size from the memory partitions. The function
**         memMallocEM first tries to allocate the memory from the
**         external memory partition. However, if not enough space
**         exists in the external memory partition to satisfy the
**         dynamic memory allocation, memMallocEM then tries the
**         allocation from the internal memory partition. For
**         example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - The size of the memory buffer to be
**                           allocated in external memory
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memMallocEM returns NULL
** ===================================================================
*/

#define MEM1_memReallocEM(memblock, size) memReallocEM(memblock, size)
/*
** ===================================================================
**     Method      :  MEM1_memReallocEM (bean DSP_MEM)
**
**     Description :
**         The memReallocEM function dynamically reallocates and
**         resizes a memory buffer to the specified size from the
**         memory partitions. The function memReallocEM first tries
**         to reallocate the memory from the external memory
**         partition. However, if not enough space exists in the
**         external memory partition to satisfy the dynamic memory
**         allocation, memReallocEM then tries the allocation from
**         the internal memory partition. For example see <Typical
**         Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - The address of the existing
**                           memory block to reallocate
**         size            - The new size to allocate
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memReallocEM returns "NULL"
** ===================================================================
*/

#define MEM1_memCallocEM(num, size) memCallocEM(num, size)
/*
** ===================================================================
**     Method      :  MEM1_memCallocEM (bean DSP_MEM)
**
**     Description :
**         The memCallocEM function dynamically allocates an array
**         with elements initialized to zero. The memCallocEM
**         function first tries to reallocate the memory from the
**         external memory partition. For example see <Typical Usage
**         > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         num             - Number of elements
**         size            - Length in bytes of each element
**     Returns     :
**         ---             - If memory is insufficient to satisfy
**                           the request from either partition,
**                           memCallocEM returns NULL.
** ===================================================================
*/

#define MEM1_memMallocAlignedEM(size) memMallocAlignedEM(size)
/*
** ===================================================================
**     Method      :  MEM1_memMallocAlignedEM (bean DSP_MEM)
**
**     Description :
**         The memMallocAlignedEM function allocates dynamic memory
**         of the specified size from the memory partitions and
**         aligns the memory to use modulo addressing. The function
**         memMallocAlignedEM first tries to allocate the memory,
**         properly aligned, from the external memory partition.
**         However, if space is insufficient in the external memory
**         partition to satisfy the dynamic memory allocation, or if
**         the memory request cannot be properly aligned,
**         memMallocAlignedEM then tries the allocation from the
**         internal memory partition. If memMallocAlignedEM cannot
**         allocate an aligned buffer from either partition, it
**         calls memMallocEM to try to allocate a buffer of the
**         correct size without the proper alignment. For example
**         see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         size            - The size of the memory buffer to be
**                           allocated in external memory and aligned
**                           for modulo addressing
**     Returns     :
**         ---             - If memory cannot be allocated in
**                           sufficient size to satisfy the request
**                           from either partition,
**                           memMallocAlignedEM returns NULL
** ===================================================================
*/

#define MEM1_memFreeEM(memblock) memFreeEM(memblock)
/*
** ===================================================================
**     Method      :  MEM1_memFreeEM (bean DSP_MEM)
**
**     Description :
**         The memFreeEM function deallocates a memory block in
**         external memory that previously had been dynamically
**         allocated with the routine memMallocEM. For example see
**         <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - Pointer to previously
**                           allocated array
**     Returns     : Nothing
** ===================================================================
*/

#define MEM1_memIsEM(memblock) memIsEM(memblock)
/*
** ===================================================================
**     Method      :  MEM1_memIsEM (bean DSP_MEM)
**
**     Description :
**         The memIsEM function checks the address of a memory block
**         to determine whether it is in internal memory or external
**         memory. For example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - The address of the memory
**                           block to be confirmed in external memory
**     Returns     :
**         ---             - The function memIsEM returns true if
**                           the address is in external memory;
**                           otherwise, it returns false.
** ===================================================================
*/

                                       /* Memory management utility routines */
#define MEM1_memIsAligned( memblock, size) memIsAligned( memblock, size)
/*
** ===================================================================
**     Method      :  MEM1_memIsAligned (bean DSP_MEM)
**
**     Description :
**         The memIsAligned function checks the address of a memory
**         block to determine whether it is properly aligned to use
**         modulo addressing. For example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * memblock        - The address of the memory
**                           block to check alignment for modulo
**                           addressing
**         size            - The size to which the block should be
**                           aligned for modulo addressing
**     Returns     :
**         ---             - The function memIsAligned returns true
**                           if the address is aligned so that modulo
**                           addressing can be used; otherwise, it
**                           returns false.
** ===================================================================
*/

#define MEM1_memInitialize(pMemoryState) memInitialize(pMemoryState)
/*
** ===================================================================
**     Method      :  MEM1_memInitialize (bean DSP_MEM)
**
**     Description :
**         This function initializes the memory manager data structure 
**         (InitialState).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memInitializePool(pMemPool, pMem, Size, Protect, Assert) memInitializePool(pMemPool, pMem, Size, Protect, Assert)
/*
** ===================================================================
**     Method      :  MEM1_memInitializePool (bean DSP_MEM)
**
**     Description :
**         Initializes the memory pool to all zeroes. Brackets the pool 
**         with two blocks: The last sizeof(UInt32) bytes will be set to 
**         0 to indicate the last block of the pool. The first 
**         sizeof(UInt32) bytes of the pool will be set to the size of 
**         the remainder of the pool.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memExtendPool(pMemPool, pMem, Size) memExtendPool(pMemPool, pMem, Size)
/*
** ===================================================================
**     Method      :  MEM1_memExtendPool (bean DSP_MEM)
**
**     Description :
**         Initializes the memory pool extension to all zeroes. Extends 
**         the pool previously initialized with memInitializePool.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memValidate(pMemPool) memValidate(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memValidate (bean DSP_MEM)
**
**     Description :
**         This function validates memory pool.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memProtect(pMemPool) memProtect(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memProtect (bean DSP_MEM)
**
**     Description :
**         This function set memory protection.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memMallocWrapper(pPool, Size, pFile, Line) memMallocWrapper(pPool, Size, pFile, Line)
/*
** ===================================================================
**     Method      :  MEM1_memMallocWrapper (bean DSP_MEM)
**
**     Description :
**         This method call the base allocator.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memMalloc(pMemPool, Size) memMalloc(pMemPool, Size)
/*
** ===================================================================
**     Method      :  MEM1_memMalloc (bean DSP_MEM)
**
**     Description :
**         This function allocates dynamic memory of the specified size 
**         from the memory partitions.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memMallocAligned(pMemPool, Size) memMallocAligned(pMemPool, Size)
/*
** ===================================================================
**     Method      :  MEM1_memMallocAligned (bean DSP_MEM)
**
**     Description :
**         Allocate memory aligned so that it ends on a 2**k boundary.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memCalloc(pPool, Elements, ElementSize) memCalloc(pPool, Elements, ElementSize)
/*
** ===================================================================
**     Method      :  MEM1_memCalloc (bean DSP_MEM)
**
**     Description :
**         This function dynamically allocates an array with elements 
**         initialized to zero.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memRealloc(pMemPool, pData, SizeRequested) memRealloc(pMemPool, pData, SizeRequested)
/*
** ===================================================================
**     Method      :  MEM1_memRealloc (bean DSP_MEM)
**
**     Description :
**         This function dynamically reallocates and resizes a memory 
**         buffer to the specified size from the memory partitions.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memFree(pMemPool, pData) memFree(pMemPool, pData)
/*
** ===================================================================
**     Method      :  MEM1_memFree (bean DSP_MEM)
**
**     Description :
**         This function deallocates a memory block.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memPrintAllocatedBlocks(pMemPool) memPrintAllocatedBlocks(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memPrintAllocatedBlocks (bean DSP_MEM)
**
**     Description :
**         This function prints the allocated blocks.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memCleanUp(pMemPool) memCleanUp(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memCleanUp (bean DSP_MEM)
**
**     Description :
**         Starting from the beginning of the pool, merge blocks that are 
**         not in use. Stop at the first in-use block.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memCalculateStatistics(pMemPool) memCalculateStatistics(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memCalculateStatistics (bean DSP_MEM)
**
**     Description :
**         This function calculates memory statistics.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_memPrintStatistics(pMemPool) memPrintStatistics(pMemPool)
/*
** ===================================================================
**     Method      :  MEM1_memPrintStatistics (bean DSP_MEM)
**
**     Description :
**         This function prints memory statistics.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

                                       /* Routines for P <-> X Memory Access */
#define MEM1_memMemcpy(dest, src, count) memMemcpy(dest, src, count)
/*
** ===================================================================
**     Method      :  MEM1_memMemcpy (bean DSP_MEM)
**
**     Description :
**         The memcpy routine copies characters between memory
**         buffers For example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dest            - Pointer to the destination buffet
**                           array
**       * src             - Pointer to the source buffet array
**         count           - Size of the source buffer array
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

#define MEM1_memMemset(dest, c, count) memMemset(dest, c, count)
/*
** ===================================================================
**     Method      :  MEM1_memMemset (bean DSP_MEM)
**
**     Description :
**         The memset function sets user specified number of bytes
**         in memory to a specific character For example see
**         <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dest            - Pointer to the destination buffer
**                           array
**         c               - Value to fill
**         count           - Size of array to fill
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

#define MEM1_memMemsetP(dest, c, count) memMemsetP(dest, c, count)
/*
** ===================================================================
**     Method      :  MEM1_memMemsetP (bean DSP_MEM)
**
**     Description :
**         The memset function sets user specified number of bytes
**         in 'P' memory to a specific character
**     Parameters  :
**         NAME            - DESCRIPTION
**       * dest            - Pointer to the destination buffer
**                           array in 'P' memory
**         c               - Value to fill
**         count           - Size of array to fill
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

#define MEM1_memReadP16(pSrc) memReadP16(pSrc)
/*
** ===================================================================
**     Method      :  MEM1_memReadP16 (bean DSP_MEM)
**
**     Description :
**         The function memReadP16 reads a 16-bit word from the
**         program data (P data), address space. The memReadP16
**         executes the specific instructions to reference program P
**         data, as opposed to X data. For example see <Typical
**         Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pSrc            - The address in P memory from which to
**                           read a 16-bit word
**     Returns     :
**         ---             - Contents of program memory word (16
**                           bits)
** ===================================================================
*/

#define MEM1_memReadP32(pSrc) memReadP32(pSrc)
/*
** ===================================================================
**     Method      :  MEM1_memReadP32 (bean DSP_MEM)
**
**     Description :
**         The function memReadP32 reads a 32-bit word from the
**         program data (P data) address space. The memReadP32
**         executes the specific instructions to reference program P
**         data, as opposed to X data. For example see <Typical
**         Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pSrc            - The address in P memory from which to
**                           read a 32-bit (two word) value
**     Returns     :
**         ---             - Contents of two program memory words
**                           (32 bits)
** ===================================================================
*/

#define MEM1_memWriteP16(Data, pDest) memWriteP16(Data, pDest)
/*
** ===================================================================
**     Method      :  MEM1_memWriteP16 (bean DSP_MEM)
**
**     Description :
**         The memWriteP16 function writes a 16-bit value into the
**         program data, (P data), address space. The memWriteP16
**         executes the specific instructions required to write to
**         program (P) data, as opposed to X data. For example see
**         <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Data            - The 16-bit data to write into P memory
**       * pDest           - The address to which to write the
**                           data in P memory
**     Returns     : Nothing
** ===================================================================
*/

#define MEM1_memWriteP32(Data, pDest) memWriteP32(Data, pDest)
/*
** ===================================================================
**     Method      :  MEM1_memWriteP32 (bean DSP_MEM)
**
**     Description :
**         The memWriteP32 function writes a 32-bit value into the
**         program data, (P data), address space. The memWriteP32
**         executes specific instructions required to write to
**         program P data, as opposed to X data. For example see
**         <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Data            - The 32-bit data to write into P memory
**       * pDest           - The address to which to write the
**                           data in P memory
**     Returns     : Nothing
** ===================================================================
*/

#define MEM1_memCopyPtoP(pDest, pSrc, Count) memCopyPtoP(pDest, pSrc, Count)
/*
** ===================================================================
**     Method      :  MEM1_memCopyPtoP (bean DSP_MEM)
**
**     Description :
**         The memCopyPtoP copies a block of data from the P
**         (program) data memory to the P data memory. The
**         memCopyPtoP executes the specific instructions required
**         to read data from program P data memory.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pDest           - The destination address in P memory
**                           to which to copy the data
**       * pSrc            - The source address in P memory from
**                           which to copy the data
**         Count           - The size of the data to be copied
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

#define MEM1_memCopyPtoX(pDest, pSrc, Count) memCopyPtoX(pDest, pSrc, Count)
/*
** ===================================================================
**     Method      :  MEM1_memCopyPtoX (bean DSP_MEM)
**
**     Description :
**         The memCopyPtoX copies a block of data from the P
**         (program) data memory to the X data memory. The
**         memCopyPtoX executes the specific instructions required
**         to read data from program P data memory, as opposed to X
**         data. For example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pDest           - The destination address in X memory
**                           to which to copy the data
**       * pSrc            - The source address in P memory from
**                           which to copy the data
**         Count           - The size of the data to be copied
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

#define MEM1_memCopyXtoP(pDest, pSrc, Count) memCopyXtoP(pDest, pSrc, Count)
/*
** ===================================================================
**     Method      :  MEM1_memCopyXtoP (bean DSP_MEM)
**
**     Description :
**         The memCopyXtoP copies a block of data from the X data
**         memory to the P (program) data memory. The memCopyXtoP
**         executes the specific instructions required to write data
**         to program P data memory, as opposed to X data. For
**         example see <Typical Usage > page.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pDest           - The destination address in P memory
**                           to which to copy the data
**       * pSrc            - The source address in X memory from
**                           which to copy the data
**         Count           - The size of the data to be copied
**     Returns     :
**         ---             - *dest return value
** ===================================================================
*/

void MEM1_Init(void);
/*
** ===================================================================
**     Method      :  MEM1_Init (bean DSP_MEM)
**
**     Description :
**         This method initializes the driver.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_MergeFree(pPool, pBlock, SizeNeeded) MergeFree(pPool, pBlock, SizeNeeded)
/*
** ===================================================================
**     Method      :  MEM1_MergeFree (bean DSP_MEM)
**
**     Description :
**         Assumes that pBlock points to a block not in-use. Checks the 
**         block following to determine its state. If it is not in-use, 
**         merge it to the current block. pBlock will not change, but the 
**         size of the block to which it points may increase.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_SplitBlock(pPool, pBlock, SizeNeeded) SplitBlock(pPool, pBlock, SizeNeeded)
/*
** ===================================================================
**     Method      :  MEM1_SplitBlock (bean DSP_MEM)
**
**     Description :
**         Assumes that pBlock points to a block larger than SizeNeeded. 
**         If the block is large enough to contain SizeNeeded plus 
**         another block, the block is split. The area returned to the 
**         user is the user portion of the first block.The remainder in 
**         its entirety will be set to describe a not-in-use block.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

#define MEM1_SplitBlockRev(pPool, pBlock, SizeNeeded) SplitBlockRev(pPool, pBlock, SizeNeeded)
/*
** ===================================================================
**     Method      :  MEM1_SplitBlockRev (bean DSP_MEM)
**
**     Description :
**         Assumes that pBlock points to a block larger than SizeNeeded. 
**         If the block is large enough to contain SizeNeeded plus 
**         another block, the block is split. The area returned is the 
**         portion of the end of the block. The remainder in its entirety 
**         will be set to describe a not-in-use block.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/


/* END MEM1. */

#endif /* ifndef __MEM1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
