/** ###################################################################
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* const.c */

#include "port.h"
#include "arch.h"
#include "const.h"
#include "dspfunc.h"

/* General constants */
const char constNewline[] = "\n";

/* test.c constants */
const char testStartMsg[]  = " - Started\n";
const char testFailedMsg[] = " - !!! Failed !!! ";
const char testDashMsg[]   = " - ";
const char testPassedMsg[] = " - Passed\n";
const char testEndedMsg[]  = " - Ended\n";

    const CFrac16 dfr16CFFTTwiddleFactorTable8[8]=
    {0x7fff,0x0000,0x0000,0x7fff,0x5a82,0x5a82,0xa57e,0x5a82};

    const CFrac16 dfr16CFFTTwiddleFactorTable16[16]=
    {0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
     0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc
    };

    const CFrac16 dfr16CFFTTwiddleFactorTable32[32]=
     {0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
      0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
      0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
      0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9
      };

    const CFrac16 dfr16CFFTTwiddleFactorTable64[64]={
  0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
  0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
  0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
  0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
  0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
  0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
  0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
  0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c
  };

    const CFrac16 dfr16CFFTTwiddleFactorTable128[128]={
{0x7fff, 0x0000}, {0x0000, 0x7fff},
{0x5a82, 0x5a82}, {0xa57e, 0x5a82},
{0x7642, 0x30fc}, {0xcf04, 0x7642},
{0x30fc, 0x7642}, {0x89be, 0x30fc},
{0x7d8a, 0x18f9}, {0xe707, 0x7d8a},
{0x471d, 0x6a6e}, {0x9592, 0x471d},
{0x6a6e, 0x471d}, {0xb8e3, 0x6a6e},
{0x18f9, 0x7d8a}, {0x8276, 0x18f9},
{0x7f62, 0x0c8c}, {0xf374, 0x7f62},
{0x5134, 0x62f2}, {0x9d0e, 0x5134},
{0x70e3, 0x3c57}, {0xc3a9, 0x70e3},
{0x2528, 0x7a7d}, {0x8583, 0x2528},
{0x7a7d, 0x2528}, {0xdad8, 0x7a7d},
{0x3c57, 0x70e3}, {0x8f1d, 0x3c57},
{0x62f2, 0x5134}, {0xaecc, 0x62f2},
{0x0c8c, 0x7f62}, {0x809e, 0x0c8c},
{0x7fd9, 0x0648}, {0xf9b8, 0x7fd9},
{0x55f6, 0x5ed7}, {0xa129, 0x55f6},
{0x73b6, 0x36ba}, {0xc946, 0x73b6},
{0x2b1f, 0x7885}, {0x877b, 0x2b1f},
{0x7c2a, 0x1f1a}, {0xe0e6, 0x7c2a},
{0x41ce, 0x6dca}, {0x9236, 0x41ce},
{0x66d0, 0x4c40}, {0xb3c0, 0x66d0},
{0x12c8, 0x7e9d}, {0x8163, 0x12c8},
{0x7e9d, 0x12c8}, {0xed38, 0x7e9d},
{0x4c40, 0x66d0}, {0x9930, 0x4c40},
{0x6dca, 0x41ce}, {0xbe32, 0x6dca},
{0x1f1a, 0x7c2a}, {0x83d6, 0x1f1a},
{0x7885, 0x2b1f}, {0xd4e1, 0x7885},
{0x36ba, 0x73b6}, {0x8c4a, 0x36ba},
{0x5ed7, 0x55f6}, {0xaa0a, 0x5ed7},
{0x0648, 0x7fd9}, {0x8027, 0x0648}};

   const CFrac16 dfr16CFFTTwiddleFactorTable256[256]={
0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
};

    const CFrac16 dfr16CFFTTwiddleFactorTable512[512]={
0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
0x7ffe, 0x0192, 0xfe6e, 0x7ffe, 0x5964, 0x5b9d, 0xa463, 0x5964,
0x75a6, 0x326e, 0xcd92, 0x75a6, 0x2f87, 0x76d9, 0x8927, 0x2f87,
0x7d3a, 0x1a83, 0xe57d, 0x7d3a, 0x45cd, 0x6b4b, 0x94b5, 0x45cd,
0x698c, 0x486a, 0xb796, 0x698c, 0x176e, 0x7dd6, 0x822a, 0x176e,
0x7f38, 0x0e1c, 0xf1e4, 0x7f38, 0x4ffb, 0x63ef, 0x9c11, 0x4ffb,
0x7023, 0x3db8, 0xc248, 0x7023, 0x23a7, 0x7aef, 0x8511, 0x23a7,
0x7a06, 0x26a8, 0xd958, 0x7a06, 0x3af3, 0x719e, 0x8e62, 0x3af3,
0x61f1, 0x5269, 0xad97, 0x61f1, 0x0afb, 0x7f87, 0x8079, 0x0afb,
0x7fc2, 0x07d9, 0xf827, 0x7fc2, 0x54ca, 0x5fe4, 0xa01c, 0x54ca,
0x7308, 0x3825, 0xc7db, 0x7308, 0x29a4, 0x790a, 0x86f6, 0x29a4,
0x7bc6, 0x209f, 0xdf61, 0x7bc6, 0x4074, 0x6e97, 0x9169, 0x4074,
0x65de, 0x4d81, 0xb27f, 0x65de, 0x113a, 0x7ed6, 0x812a, 0x113a,
0x7e60, 0x1455, 0xebab, 0x7e60, 0x4afb, 0x67bd, 0x9843, 0x4afb,
0x6cf9, 0x4326, 0xbcda, 0x6cf9, 0x1d93, 0x7c89, 0x8377, 0x1d93,
0x77fb, 0x2c99, 0xd367, 0x77fb, 0x354e, 0x7460, 0x8ba0, 0x354e,
0x5dc8, 0x571e, 0xa8e2, 0x5dc8, 0x04b6, 0x7fea, 0x8016, 0x04b6,
0x7fea, 0x04b6, 0xfb4a, 0x7fea, 0x571e, 0x5dc8, 0xa238, 0x571e,
0x7460, 0x354e, 0xcab2, 0x7460, 0x2c99, 0x77fb, 0x8805, 0x2c99,
0x7c89, 0x1d93, 0xe26d, 0x7c89, 0x4326, 0x6cf9, 0x9307, 0x4326,
0x67bd, 0x4afb, 0xb505, 0x67bd, 0x1455, 0x7e60, 0x81a0, 0x1455,
0x7ed6, 0x113a, 0xeec6, 0x7ed6, 0x4d81, 0x65de, 0x9a22, 0x4d81,
0x6e97, 0x4074, 0xbf8c, 0x6e97, 0x209f, 0x7bc6, 0x843a, 0x209f,
0x790a, 0x29a4, 0xd65c, 0x790a, 0x3825, 0x7308, 0x8cf8, 0x3825,
0x5fe4, 0x54ca, 0xab36, 0x5fe4, 0x07d9, 0x7fc2, 0x803e, 0x07d9,
0x7f87, 0x0afb, 0xf505, 0x7f87, 0x5269, 0x61f1, 0x9e0f, 0x5269,
0x719e, 0x3af3, 0xc50d, 0x719e, 0x26a8, 0x7a06, 0x85fa, 0x26a8,
0x7aef, 0x23a7, 0xdc59, 0x7aef, 0x3db8, 0x7023, 0x8fdd, 0x3db8,
0x63ef, 0x4ffb, 0xb005, 0x63ef, 0x0e1c, 0x7f38, 0x80c8, 0x0e1c,
0x7dd6, 0x176e, 0xe892, 0x7dd6, 0x486a, 0x698c, 0x9674, 0x486a,
0x6b4b, 0x45cd, 0xba33, 0x6b4b, 0x1a83, 0x7d3a, 0x82c6, 0x1a83,
0x76d9, 0x2f87, 0xd079, 0x76d9, 0x326e, 0x75a6, 0x8a5a, 0x326e,
0x5b9d, 0x5964, 0xa69c, 0x5b9d, 0x0192, 0x7ffe, 0x8002, 0x0192
};

    const CFrac16 dfr16CFFTTwiddleFactorTable1024[1024]={
0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
0x7ffe, 0x0192, 0xfe6e, 0x7ffe, 0x5964, 0x5b9d, 0xa463, 0x5964,
0x75a6, 0x326e, 0xcd92, 0x75a6, 0x2f87, 0x76d9, 0x8927, 0x2f87,
0x7d3a, 0x1a83, 0xe57d, 0x7d3a, 0x45cd, 0x6b4b, 0x94b5, 0x45cd,
0x698c, 0x486a, 0xb796, 0x698c, 0x176e, 0x7dd6, 0x822a, 0x176e,
0x7f38, 0x0e1c, 0xf1e4, 0x7f38, 0x4ffb, 0x63ef, 0x9c11, 0x4ffb,
0x7023, 0x3db8, 0xc248, 0x7023, 0x23a7, 0x7aef, 0x8511, 0x23a7,
0x7a06, 0x26a8, 0xd958, 0x7a06, 0x3af3, 0x719e, 0x8e62, 0x3af3,
0x61f1, 0x5269, 0xad97, 0x61f1, 0x0afb, 0x7f87, 0x8079, 0x0afb,
0x7fc2, 0x07d9, 0xf827, 0x7fc2, 0x54ca, 0x5fe4, 0xa01c, 0x54ca,
0x7308, 0x3825, 0xc7db, 0x7308, 0x29a4, 0x790a, 0x86f6, 0x29a4,
0x7bc6, 0x209f, 0xdf61, 0x7bc6, 0x4074, 0x6e97, 0x9169, 0x4074,
0x65de, 0x4d81, 0xb27f, 0x65de, 0x113a, 0x7ed6, 0x812a, 0x113a,
0x7e60, 0x1455, 0xebab, 0x7e60, 0x4afb, 0x67bd, 0x9843, 0x4afb,
0x6cf9, 0x4326, 0xbcda, 0x6cf9, 0x1d93, 0x7c89, 0x8377, 0x1d93,
0x77fb, 0x2c99, 0xd367, 0x77fb, 0x354e, 0x7460, 0x8ba0, 0x354e,
0x5dc8, 0x571e, 0xa8e2, 0x5dc8, 0x04b6, 0x7fea, 0x8016, 0x04b6,
0x7fea, 0x04b6, 0xfb4a, 0x7fea, 0x571e, 0x5dc8, 0xa238, 0x571e,
0x7460, 0x354e, 0xcab2, 0x7460, 0x2c99, 0x77fb, 0x8805, 0x2c99,
0x7c89, 0x1d93, 0xe26d, 0x7c89, 0x4326, 0x6cf9, 0x9307, 0x4326,
0x67bd, 0x4afb, 0xb505, 0x67bd, 0x1455, 0x7e60, 0x81a0, 0x1455,
0x7ed6, 0x113a, 0xeec6, 0x7ed6, 0x4d81, 0x65de, 0x9a22, 0x4d81,
0x6e97, 0x4074, 0xbf8c, 0x6e97, 0x209f, 0x7bc6, 0x843a, 0x209f,
0x790a, 0x29a4, 0xd65c, 0x790a, 0x3825, 0x7308, 0x8cf8, 0x3825,
0x5fe4, 0x54ca, 0xab36, 0x5fe4, 0x07d9, 0x7fc2, 0x803e, 0x07d9,
0x7f87, 0x0afb, 0xf505, 0x7f87, 0x5269, 0x61f1, 0x9e0f, 0x5269,
0x719e, 0x3af3, 0xc50d, 0x719e, 0x26a8, 0x7a06, 0x85fa, 0x26a8,
0x7aef, 0x23a7, 0xdc59, 0x7aef, 0x3db8, 0x7023, 0x8fdd, 0x3db8,
0x63ef, 0x4ffb, 0xb005, 0x63ef, 0x0e1c, 0x7f38, 0x80c8, 0x0e1c,
0x7dd6, 0x176e, 0xe892, 0x7dd6, 0x486a, 0x698c, 0x9674, 0x486a,
0x6b4b, 0x45cd, 0xba33, 0x6b4b, 0x1a83, 0x7d3a, 0x82c6, 0x1a83,
0x76d9, 0x2f87, 0xd079, 0x76d9, 0x326e, 0x75a6, 0x8a5a, 0x326e,
0x5b9d, 0x5964, 0xa69c, 0x5b9d, 0x0192, 0x7ffe, 0x8002, 0x0192,
0x7fff, 0x00c9, 0xff37, 0x7fff, 0x59f4, 0x5b10, 0xa4f0, 0x59f4,
0x75f4, 0x31b5, 0xce4b, 0x75f4, 0x3042, 0x768e, 0x8972, 0x3042,
0x7d63, 0x19be, 0xe642, 0x7d63, 0x4675, 0x6add, 0x9523, 0x4675,
0x69fd, 0x47c4, 0xb83c, 0x69fd, 0x1833, 0x7db1, 0x824f, 0x1833,
0x7f4e, 0x0d54, 0xf2ac, 0x7f4e, 0x5098, 0x6371, 0x9c8f, 0x5098,
0x7083, 0x3d08, 0xc2f8, 0x7083, 0x2467, 0x7ab7, 0x8549, 0x2467,
0x7a42, 0x25e8, 0xda18, 0x7a42, 0x3ba5, 0x7141, 0x8ebf, 0x3ba5,
0x6272, 0x51cf, 0xae31, 0x6272, 0x0bc4, 0x7f75, 0x808b, 0x0bc4,
0x7fce, 0x0711, 0xf8ef, 0x7fce, 0x5560, 0x5f5e, 0xa0a2, 0x5560,
0x735f, 0x3770, 0xc890, 0x735f, 0x2a62, 0x78c8, 0x8738, 0x2a62,
0x7bf9, 0x1fdd, 0xe023, 0x7bf9, 0x4121, 0x6e31, 0x91cf, 0x4121,
0x6657, 0x4ce1, 0xb31f, 0x6657, 0x1201, 0x7eba, 0x8146, 0x1201,
0x7e7f, 0x138f, 0xec71, 0x7e7f, 0x4b9e, 0x6747, 0x98b9, 0x4b9e,
0x6d62, 0x427a, 0xbd86, 0x6d62, 0x1e57, 0x7c5a, 0x83a6, 0x1e57,
0x7840, 0x2bdc, 0xd424, 0x7840, 0x3604, 0x740b, 0x8bf5, 0x3604,
0x5e50, 0x568a, 0xa976, 0x5e50, 0x057f, 0x7fe2, 0x801e, 0x057f,
0x7ff1, 0x03ed, 0xfc13, 0x7ff1, 0x57b1, 0x5d3e, 0xa2c2, 0x57b1,
0x74b3, 0x3497, 0xcb69, 0x74b3, 0x2d55, 0x77b4, 0x884c, 0x2d55,
0x7cb7, 0x1cd0, 0xe330, 0x7cb7, 0x43d1, 0x6c8f, 0x9371, 0x43d1,
0x6832, 0x4a58, 0xb5a8, 0x6832, 0x151c, 0x7e3f, 0x81c1, 0x151c,
0x7ef0, 0x1073, 0xef8d, 0x7ef0, 0x4e21, 0x6564, 0x9a9c, 0x4e21,
0x6efb, 0x3fc6, 0xc03a, 0x6efb, 0x2162, 0x7b92, 0x846e, 0x2162,
0x794a, 0x28e5, 0xd71b, 0x794a, 0x38d9, 0x72af, 0x8d51, 0x38d9,
0x6068, 0x5433, 0xabcd, 0x6068, 0x08a2, 0x7fb5, 0x804b, 0x08a2,
0x7f98, 0x0a33, 0xf5cd, 0x7f98, 0x5303, 0x616f, 0x9e91, 0x5303,
0x71fa, 0x3a40, 0xc5c0, 0x71fa, 0x2768, 0x79c9, 0x8637, 0x2768,
0x7b27, 0x22e5, 0xdd1b, 0x7b27, 0x3e68, 0x6fc2, 0x903e, 0x3e68,
0x646c, 0x4f5e, 0xb0a2, 0x646c, 0x0ee4, 0x7f22, 0x80de, 0x0ee4,
0x7dfb, 0x16a8, 0xe958, 0x7dfb, 0x490f, 0x691a, 0x96e6, 0x490f,
0x6bb8, 0x4524, 0xbadc, 0x6bb8, 0x1b47, 0x7d0f, 0x82f1, 0x1b47,
0x7723, 0x2ecc, 0xd134, 0x7723, 0x3327, 0x7556, 0x8aaa, 0x3327,
0x5c29, 0x58d4, 0xa72c, 0x5c29, 0x025b, 0x7ffa, 0x8006, 0x025b,
0x7ffa, 0x025b, 0xfda5, 0x7ffa, 0x58d4, 0x5c29, 0xa3d7, 0x58d4,
0x7556, 0x3327, 0xccd9, 0x7556, 0x2ecc, 0x7723, 0x88dd, 0x2ecc,
0x7d0f, 0x1b47, 0xe4b9, 0x7d0f, 0x4524, 0x6bb8, 0x9448, 0x4524,
0x691a, 0x490f, 0xb6f1, 0x691a, 0x16a8, 0x7dfb, 0x8205, 0x16a8,
0x7f22, 0x0ee4, 0xf11c, 0x7f22, 0x4f5e, 0x646c, 0x9b94, 0x4f5e,
0x6fc2, 0x3e68, 0xc198, 0x6fc2, 0x22e5, 0x7b27, 0x84d9, 0x22e5,
0x79c9, 0x2768, 0xd898, 0x79c9, 0x3a40, 0x71fa, 0x8e06, 0x3a40,
0x616f, 0x5303, 0xacfd, 0x616f, 0x0a33, 0x7f98, 0x8068, 0x0a33,
0x7fb5, 0x08a2, 0xf75e, 0x7fb5, 0x5433, 0x6068, 0x9f98, 0x5433,
0x72af, 0x38d9, 0xc727, 0x72af, 0x28e5, 0x794a, 0x86b6, 0x28e5,
0x7b92, 0x2162, 0xde9e, 0x7b92, 0x3fc6, 0x6efb, 0x9105, 0x3fc6,
0x6564, 0x4e21, 0xb1df, 0x6564, 0x1073, 0x7ef0, 0x8110, 0x1073,
0x7e3f, 0x151c, 0xeae4, 0x7e3f, 0x4a58, 0x6832, 0x97ce, 0x4a58,
0x6c8f, 0x43d1, 0xbc2f, 0x6c8f, 0x1cd0, 0x7cb7, 0x8349, 0x1cd0,
0x77b4, 0x2d55, 0xd2ab, 0x77b4, 0x3497, 0x74b3, 0x8b4d, 0x3497,
0x5d3e, 0x57b1, 0xa84f, 0x5d3e, 0x03ed, 0x7ff1, 0x800f, 0x03ed,
0x7fe2, 0x057f, 0xfa81, 0x7fe2, 0x568a, 0x5e50, 0xa1b0, 0x568a,
0x740b, 0x3604, 0xc9fc, 0x740b, 0x2bdc, 0x7840, 0x87c0, 0x2bdc,
0x7c5a, 0x1e57, 0xe1a9, 0x7c5a, 0x427a, 0x6d62, 0x929e, 0x427a,
0x6747, 0x4b9e, 0xb462, 0x6747, 0x138f, 0x7e7f, 0x8181, 0x138f,
0x7eba, 0x1201, 0xedff, 0x7eba, 0x4ce1, 0x6657, 0x99a9, 0x4ce1,
0x6e31, 0x4121, 0xbedf, 0x6e31, 0x1fdd, 0x7bf9, 0x8407, 0x1fdd,
0x78c8, 0x2a62, 0xd59e, 0x78c8, 0x3770, 0x735f, 0x8ca1, 0x3770,
0x5f5e, 0x5560, 0xaaa0, 0x5f5e, 0x0711, 0x7fce, 0x8032, 0x0711,
0x7f75, 0x0bc4, 0xf43c, 0x7f75, 0x51cf, 0x6272, 0x9d8e, 0x51cf,
0x7141, 0x3ba5, 0xc45b, 0x7141, 0x25e8, 0x7a42, 0x85be, 0x25e8,
0x7ab7, 0x2467, 0xdb99, 0x7ab7, 0x3d08, 0x7083, 0x8f7d, 0x3d08,
0x6371, 0x5098, 0xaf68, 0x6371, 0x0d54, 0x7f4e, 0x80b2, 0x0d54,
0x7db1, 0x1833, 0xe7cd, 0x7db1, 0x47c4, 0x69fd, 0x9603, 0x47c4,
0x6add, 0x4675, 0xb98b, 0x6add, 0x19be, 0x7d63, 0x829d, 0x19be,
0x768e, 0x3042, 0xcfbe, 0x768e, 0x31b5, 0x75f4, 0x8a0c, 0x31b5,
0x5b10, 0x59f4, 0xa60c, 0x5b10, 0x00c9, 0x7fff, 0x8001, 0x00c9
};

   const CFrac16 dfr16CFFTTwiddleFactorTable2048[2048] = {
0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
0x7ffe, 0x0192, 0xfe6e, 0x7ffe, 0x5964, 0x5b9d, 0xa463, 0x5964,
0x75a6, 0x326e, 0xcd92, 0x75a6, 0x2f87, 0x76d9, 0x8927, 0x2f87,
0x7d3a, 0x1a83, 0xe57d, 0x7d3a, 0x45cd, 0x6b4b, 0x94b5, 0x45cd,
0x698c, 0x486a, 0xb796, 0x698c, 0x176e, 0x7dd6, 0x822a, 0x176e,
0x7f38, 0x0e1c, 0xf1e4, 0x7f38, 0x4ffb, 0x63ef, 0x9c11, 0x4ffb,
0x7023, 0x3db8, 0xc248, 0x7023, 0x23a7, 0x7aef, 0x8511, 0x23a7,
0x7a06, 0x26a8, 0xd958, 0x7a06, 0x3af3, 0x719e, 0x8e62, 0x3af3,
0x61f1, 0x5269, 0xad97, 0x61f1, 0x0afb, 0x7f87, 0x8079, 0x0afb,
0x7fc2, 0x07d9, 0xf827, 0x7fc2, 0x54ca, 0x5fe4, 0xa01c, 0x54ca,
0x7308, 0x3825, 0xc7db, 0x7308, 0x29a4, 0x790a, 0x86f6, 0x29a4,
0x7bc6, 0x209f, 0xdf61, 0x7bc6, 0x4074, 0x6e97, 0x9169, 0x4074,
0x65de, 0x4d81, 0xb27f, 0x65de, 0x113a, 0x7ed6, 0x812a, 0x113a,
0x7e60, 0x1455, 0xebab, 0x7e60, 0x4afb, 0x67bd, 0x9843, 0x4afb,
0x6cf9, 0x4326, 0xbcda, 0x6cf9, 0x1d93, 0x7c89, 0x8377, 0x1d93,
0x77fb, 0x2c99, 0xd367, 0x77fb, 0x354e, 0x7460, 0x8ba0, 0x354e,
0x5dc8, 0x571e, 0xa8e2, 0x5dc8, 0x04b6, 0x7fea, 0x8016, 0x04b6,
0x7fea, 0x04b6, 0xfb4a, 0x7fea, 0x571e, 0x5dc8, 0xa238, 0x571e,
0x7460, 0x354e, 0xcab2, 0x7460, 0x2c99, 0x77fb, 0x8805, 0x2c99,
0x7c89, 0x1d93, 0xe26d, 0x7c89, 0x4326, 0x6cf9, 0x9307, 0x4326,
0x67bd, 0x4afb, 0xb505, 0x67bd, 0x1455, 0x7e60, 0x81a0, 0x1455,
0x7ed6, 0x113a, 0xeec6, 0x7ed6, 0x4d81, 0x65de, 0x9a22, 0x4d81,
0x6e97, 0x4074, 0xbf8c, 0x6e97, 0x209f, 0x7bc6, 0x843a, 0x209f,
0x790a, 0x29a4, 0xd65c, 0x790a, 0x3825, 0x7308, 0x8cf8, 0x3825,
0x5fe4, 0x54ca, 0xab36, 0x5fe4, 0x07d9, 0x7fc2, 0x803e, 0x07d9,
0x7f87, 0x0afb, 0xf505, 0x7f87, 0x5269, 0x61f1, 0x9e0f, 0x5269,
0x719e, 0x3af3, 0xc50d, 0x719e, 0x26a8, 0x7a06, 0x85fa, 0x26a8,
0x7aef, 0x23a7, 0xdc59, 0x7aef, 0x3db8, 0x7023, 0x8fdd, 0x3db8,
0x63ef, 0x4ffb, 0xb005, 0x63ef, 0x0e1c, 0x7f38, 0x80c8, 0x0e1c,
0x7dd6, 0x176e, 0xe892, 0x7dd6, 0x486a, 0x698c, 0x9674, 0x486a,
0x6b4b, 0x45cd, 0xba33, 0x6b4b, 0x1a83, 0x7d3a, 0x82c6, 0x1a83,
0x76d9, 0x2f87, 0xd079, 0x76d9, 0x326e, 0x75a6, 0x8a5a, 0x326e,
0x5b9d, 0x5964, 0xa69c, 0x5b9d, 0x0192, 0x7ffe, 0x8002, 0x0192,
0x7fff, 0x00c9, 0xff37, 0x7fff, 0x59f4, 0x5b10, 0xa4f0, 0x59f4,
0x75f4, 0x31b5, 0xce4b, 0x75f4, 0x3042, 0x768e, 0x8972, 0x3042,
0x7d63, 0x19be, 0xe642, 0x7d63, 0x4675, 0x6add, 0x9523, 0x4675,
0x69fd, 0x47c4, 0xb83c, 0x69fd, 0x1833, 0x7db1, 0x824f, 0x1833,
0x7f4e, 0x0d54, 0xf2ac, 0x7f4e, 0x5098, 0x6371, 0x9c8f, 0x5098,
0x7083, 0x3d08, 0xc2f8, 0x7083, 0x2467, 0x7ab7, 0x8549, 0x2467,
0x7a42, 0x25e8, 0xda18, 0x7a42, 0x3ba5, 0x7141, 0x8ebf, 0x3ba5,
0x6272, 0x51cf, 0xae31, 0x6272, 0x0bc4, 0x7f75, 0x808b, 0x0bc4,
0x7fce, 0x0711, 0xf8ef, 0x7fce, 0x5560, 0x5f5e, 0xa0a2, 0x5560,
0x735f, 0x3770, 0xc890, 0x735f, 0x2a62, 0x78c8, 0x8738, 0x2a62,
0x7bf9, 0x1fdd, 0xe023, 0x7bf9, 0x4121, 0x6e31, 0x91cf, 0x4121,
0x6657, 0x4ce1, 0xb31f, 0x6657, 0x1201, 0x7eba, 0x8146, 0x1201,
0x7e7f, 0x138f, 0xec71, 0x7e7f, 0x4b9e, 0x6747, 0x98b9, 0x4b9e,
0x6d62, 0x427a, 0xbd86, 0x6d62, 0x1e57, 0x7c5a, 0x83a6, 0x1e57,
0x7840, 0x2bdc, 0xd424, 0x7840, 0x3604, 0x740b, 0x8bf5, 0x3604,
0x5e50, 0x568a, 0xa976, 0x5e50, 0x057f, 0x7fe2, 0x801e, 0x057f,
0x7ff1, 0x03ed, 0xfc13, 0x7ff1, 0x57b1, 0x5d3e, 0xa2c2, 0x57b1,
0x74b3, 0x3497, 0xcb69, 0x74b3, 0x2d55, 0x77b4, 0x884c, 0x2d55,
0x7cb7, 0x1cd0, 0xe330, 0x7cb7, 0x43d1, 0x6c8f, 0x9371, 0x43d1,
0x6832, 0x4a58, 0xb5a8, 0x6832, 0x151c, 0x7e3f, 0x81c1, 0x151c,
0x7ef0, 0x1073, 0xef8d, 0x7ef0, 0x4e21, 0x6564, 0x9a9c, 0x4e21,
0x6efb, 0x3fc6, 0xc03a, 0x6efb, 0x2162, 0x7b92, 0x846e, 0x2162,
0x794a, 0x28e5, 0xd71b, 0x794a, 0x38d9, 0x72af, 0x8d51, 0x38d9,
0x6068, 0x5433, 0xabcd, 0x6068, 0x08a2, 0x7fb5, 0x804b, 0x08a2,
0x7f98, 0x0a33, 0xf5cd, 0x7f98, 0x5303, 0x616f, 0x9e91, 0x5303,
0x71fa, 0x3a40, 0xc5c0, 0x71fa, 0x2768, 0x79c9, 0x8637, 0x2768,
0x7b27, 0x22e5, 0xdd1b, 0x7b27, 0x3e68, 0x6fc2, 0x903e, 0x3e68,
0x646c, 0x4f5e, 0xb0a2, 0x646c, 0x0ee4, 0x7f22, 0x80de, 0x0ee4,
0x7dfb, 0x16a8, 0xe958, 0x7dfb, 0x490f, 0x691a, 0x96e6, 0x490f,
0x6bb8, 0x4524, 0xbadc, 0x6bb8, 0x1b47, 0x7d0f, 0x82f1, 0x1b47,
0x7723, 0x2ecc, 0xd134, 0x7723, 0x3327, 0x7556, 0x8aaa, 0x3327,
0x5c29, 0x58d4, 0xa72c, 0x5c29, 0x025b, 0x7ffa, 0x8006, 0x025b,
0x7ffa, 0x025b, 0xfda5, 0x7ffa, 0x58d4, 0x5c29, 0xa3d7, 0x58d4,
0x7556, 0x3327, 0xccd9, 0x7556, 0x2ecc, 0x7723, 0x88dd, 0x2ecc,
0x7d0f, 0x1b47, 0xe4b9, 0x7d0f, 0x4524, 0x6bb8, 0x9448, 0x4524,
0x691a, 0x490f, 0xb6f1, 0x691a, 0x16a8, 0x7dfb, 0x8205, 0x16a8,
0x7f22, 0x0ee4, 0xf11c, 0x7f22, 0x4f5e, 0x646c, 0x9b94, 0x4f5e,
0x6fc2, 0x3e68, 0xc198, 0x6fc2, 0x22e5, 0x7b27, 0x84d9, 0x22e5,
0x79c9, 0x2768, 0xd898, 0x79c9, 0x3a40, 0x71fa, 0x8e06, 0x3a40,
0x616f, 0x5303, 0xacfd, 0x616f, 0x0a33, 0x7f98, 0x8068, 0x0a33,
0x7fb5, 0x08a2, 0xf75e, 0x7fb5, 0x5433, 0x6068, 0x9f98, 0x5433,
0x72af, 0x38d9, 0xc727, 0x72af, 0x28e5, 0x794a, 0x86b6, 0x28e5,
0x7b92, 0x2162, 0xde9e, 0x7b92, 0x3fc6, 0x6efb, 0x9105, 0x3fc6,
0x6564, 0x4e21, 0xb1df, 0x6564, 0x1073, 0x7ef0, 0x8110, 0x1073,
0x7e3f, 0x151c, 0xeae4, 0x7e3f, 0x4a58, 0x6832, 0x97ce, 0x4a58,
0x6c8f, 0x43d1, 0xbc2f, 0x6c8f, 0x1cd0, 0x7cb7, 0x8349, 0x1cd0,
0x77b4, 0x2d55, 0xd2ab, 0x77b4, 0x3497, 0x74b3, 0x8b4d, 0x3497,
0x5d3e, 0x57b1, 0xa84f, 0x5d3e, 0x03ed, 0x7ff1, 0x800f, 0x03ed,
0x7fe2, 0x057f, 0xfa81, 0x7fe2, 0x568a, 0x5e50, 0xa1b0, 0x568a,
0x740b, 0x3604, 0xc9fc, 0x740b, 0x2bdc, 0x7840, 0x87c0, 0x2bdc,
0x7c5a, 0x1e57, 0xe1a9, 0x7c5a, 0x427a, 0x6d62, 0x929e, 0x427a,
0x6747, 0x4b9e, 0xb462, 0x6747, 0x138f, 0x7e7f, 0x8181, 0x138f,
0x7eba, 0x1201, 0xedff, 0x7eba, 0x4ce1, 0x6657, 0x99a9, 0x4ce1,
0x6e31, 0x4121, 0xbedf, 0x6e31, 0x1fdd, 0x7bf9, 0x8407, 0x1fdd,
0x78c8, 0x2a62, 0xd59e, 0x78c8, 0x3770, 0x735f, 0x8ca1, 0x3770,
0x5f5e, 0x5560, 0xaaa0, 0x5f5e, 0x0711, 0x7fce, 0x8032, 0x0711,
0x7f75, 0x0bc4, 0xf43c, 0x7f75, 0x51cf, 0x6272, 0x9d8e, 0x51cf,
0x7141, 0x3ba5, 0xc45b, 0x7141, 0x25e8, 0x7a42, 0x85be, 0x25e8,
0x7ab7, 0x2467, 0xdb99, 0x7ab7, 0x3d08, 0x7083, 0x8f7d, 0x3d08,
0x6371, 0x5098, 0xaf68, 0x6371, 0x0d54, 0x7f4e, 0x80b2, 0x0d54,
0x7db1, 0x1833, 0xe7cd, 0x7db1, 0x47c4, 0x69fd, 0x9603, 0x47c4,
0x6add, 0x4675, 0xb98b, 0x6add, 0x19be, 0x7d63, 0x829d, 0x19be,
0x768e, 0x3042, 0xcfbe, 0x768e, 0x31b5, 0x75f4, 0x8a0c, 0x31b5,
0x5b10, 0x59f4, 0xa60c, 0x5b10, 0x00c9, 0x7fff, 0x8001, 0x00c9,
0x7fff, 0x0065, 0xff9b, 0x7fff, 0x5a3b, 0x5ac9, 0xa537, 0x5a3b,
0x761b, 0x3159, 0xcea7, 0x761b, 0x309f, 0x7668, 0x8998, 0x309f,
0x7d77, 0x195b, 0xe6a5, 0x7d77, 0x46c9, 0x6aa5, 0x955b, 0x46c9,
0x6a36, 0x4770, 0xb890, 0x6a36, 0x1896, 0x7d9e, 0x8262, 0x1896,
0x7f58, 0x0cf0, 0xf310, 0x7f58, 0x50e6, 0x6332, 0x9cce, 0x50e6,
0x70b3, 0x3caf, 0xc351, 0x70b3, 0x24c8, 0x7a9a, 0x8566, 0x24c8,
0x7a60, 0x2588, 0xda78, 0x7a60, 0x3bfe, 0x7112, 0x8eee, 0x3bfe,
0x62b2, 0x5181, 0xae7f, 0x62b2, 0x0c28, 0x7f6c, 0x8094, 0x0c28,
0x7fd3, 0x06ac, 0xf954, 0x7fd3, 0x55ab, 0x5f1b, 0xa0e5, 0x55ab,
0x738b, 0x3715, 0xc8eb, 0x738b, 0x2ac1, 0x78a6, 0x875a, 0x2ac1,
0x7c11, 0x1f7b, 0xe085, 0x7c11, 0x4178, 0x6dfe, 0x9202, 0x4178,
0x6693, 0x4c91, 0xb36f, 0x6693, 0x1265, 0x7eac, 0x8154, 0x1265,
0x7e8e, 0x132b, 0xecd5, 0x7e8e, 0x4bef, 0x670b, 0x98f5, 0x4bef,
0x6d96, 0x4224, 0xbddc, 0x6d96, 0x1eb8, 0x7c42, 0x83be, 0x1eb8,
0x7863, 0x2b7e, 0xd482, 0x7863, 0x365f, 0x73e1, 0x8c1f, 0x365f,
0x5e94, 0x5640, 0xa9c0, 0x5e94, 0x05e3, 0x7fdd, 0x8023, 0x05e3,
0x7ff4, 0x0389, 0xfc77, 0x7ff4, 0x57fa, 0x5cf9, 0xa307, 0x57fa,
0x74dc, 0x343b, 0xcbc5, 0x74dc, 0x2db3, 0x7790, 0x8870, 0x2db3,
0x7cce, 0x1c6e, 0xe392, 0x7cce, 0x4426, 0x6c5a, 0x93a6, 0x4426,
0x686d, 0x4a06, 0xb5fa, 0x686d, 0x157f, 0x7e2f, 0x81d1, 0x157f,
0x7efd, 0x100f, 0xeff1, 0x7efd, 0x4e71, 0x6526, 0x9ada, 0x4e71,
0x6f2d, 0x3f6f, 0xc091, 0x6f2d, 0x21c3, 0x7b78, 0x8488, 0x21c3,
0x796a, 0x2886, 0xd77a, 0x796a, 0x3933, 0x7282, 0x8d7e, 0x3933,
0x60aa, 0x53e7, 0xac19, 0x60aa, 0x0906, 0x7fae, 0x8052, 0x0906,
0x7fa0, 0x09cf, 0xf631, 0x7fa0, 0x534f, 0x612e, 0x9ed2, 0x534f,
0x7228, 0x39e7, 0xc619, 0x7228, 0x27c7, 0x79aa, 0x8656, 0x27c7,
0x7b42, 0x2284, 0xdd7c, 0x7b42, 0x3ec0, 0x6f90, 0x9070, 0x3ec0,
0x64ab, 0x4f0f, 0xb0f1, 0x64ab, 0x0f47, 0x7f16, 0x80ea, 0x0f47,
0x7e0c, 0x1645, 0xe9bb, 0x7e0c, 0x4962, 0x68e0, 0x9720, 0x4962,
0x6bee, 0x44d0, 0xbb30, 0x6bee, 0x1ba9, 0x7cfa, 0x8306, 0x1ba9,
0x7748, 0x2e6f, 0xd191, 0x7748, 0x3383, 0x752d, 0x8ad3, 0x3383,
0x5c6f, 0x588c, 0xa774, 0x5c6f, 0x02c0, 0x7ff8, 0x8008, 0x02c0,
0x7ffc, 0x01f7, 0xfe09, 0x7ffc, 0x591c, 0x5be3, 0xa41d, 0x591c,
0x757e, 0x32cb, 0xcd35, 0x757e, 0x2f2a, 0x76fe, 0x8902, 0x2f2a,
0x7d25, 0x1ae5, 0xe51b, 0x7d25, 0x4579, 0x6b82, 0x947e, 0x4579,
0x6953, 0x48bd, 0xb743, 0x6953, 0x170b, 0x7de9, 0x8217, 0x170b,
0x7f2d, 0x0e80, 0xf180, 0x7f2d, 0x4fad, 0x642e, 0x9bd2, 0x4fad,
0x6ff2, 0x3e10, 0xc1f0, 0x6ff2, 0x2346, 0x7b0b, 0x84f5, 0x2346,
0x79e7, 0x2708, 0xd8f8, 0x79e7, 0x3a9a, 0x71cc, 0x8e34, 0x3a9a,
0x61b0, 0x52b6, 0xad4a, 0x61b0, 0x0a97, 0x7f90, 0x8070, 0x0a97,
0x7fbc, 0x083e, 0xf7c2, 0x7fbc, 0x547f, 0x6026, 0x9fda, 0x547f,
0x72dc, 0x387f, 0xc781, 0x72dc, 0x2945, 0x792a, 0x86d6, 0x2945,
0x7bac, 0x2101, 0xdeff, 0x7bac, 0x401d, 0x6ec9, 0x9137, 0x401d,
0x65a1, 0x4dd1, 0xb22f, 0x65a1, 0x10d6, 0x7ee3, 0x811d, 0x10d6,
0x7e50, 0x14b9, 0xeb47, 0x7e50, 0x4aaa, 0x67f8, 0x9808, 0x4aaa,
0x6cc4, 0x437b, 0xbc85, 0x6cc4, 0x1d31, 0x7ca0, 0x8360, 0x1d31,
0x77d8, 0x2cf7, 0xd309, 0x77d8, 0x34f2, 0x7489, 0x8b77, 0x34f2,
0x5d83, 0x5767, 0xa899, 0x5d83, 0x0452, 0x7fed, 0x8013, 0x0452,
0x7fe6, 0x051b, 0xfae5, 0x7fe6, 0x56d4, 0x5e0c, 0xa1f4, 0x56d4,
0x7436, 0x35a9, 0xca57, 0x7436, 0x2c3b, 0x781e, 0x87e2, 0x2c3b,
0x7c72, 0x1df5, 0xe20b, 0x7c72, 0x42d0, 0x6d2e, 0x92d2, 0x42d0,
0x6782, 0x4b4d, 0xb4b3, 0x6782, 0x13f2, 0x7e70, 0x8190, 0x13f2,
0x7ec8, 0x119e, 0xee62, 0x7ec8, 0x4d31, 0x661b, 0x99e5, 0x4d31,
0x6e64, 0x40cb, 0xbf35, 0x6e64, 0x203e, 0x7bdf, 0x8421, 0x203e,
0x78e9, 0x2a03, 0xd5fd, 0x78e9, 0x37ca, 0x7334, 0x8ccc, 0x37ca,
0x5fa1, 0x5515, 0xaaeb, 0x5fa1, 0x0775, 0x7fc8, 0x8038, 0x0775,
0x7f7e, 0x0b60, 0xf4a0, 0x7f7e, 0x521c, 0x6232, 0x9dce, 0x521c,
0x7170, 0x3b4c, 0xc4b4, 0x7170, 0x2648, 0x7a24, 0x85dc, 0x2648,
0x7ad3, 0x2407, 0xdbf9, 0x7ad3, 0x3d60, 0x7053, 0x8fad, 0x3d60,
0x63b0, 0x504a, 0xafb6, 0x63b0, 0x0db8, 0x7f43, 0x80bd, 0x0db8,
0x7dc4, 0x17d1, 0xe82f, 0x7dc4, 0x4817, 0x69c5, 0x963b, 0x4817,
0x6b14, 0x4621, 0xb9df, 0x6b14, 0x1a20, 0x7d4e, 0x82b2, 0x1a20,
0x76b4, 0x2fe5, 0xd01b, 0x76b4, 0x3212, 0x75cd, 0x8a33, 0x3212,
0x5b57, 0x59ac, 0xa654, 0x5b57, 0x012e, 0x7fff, 0x8001, 0x012e,
0x7fff, 0x012e, 0xfed2, 0x7fff, 0x59ac, 0x5b57, 0xa4a9, 0x59ac,
0x75cd, 0x3212, 0xcdee, 0x75cd, 0x2fe5, 0x76b4, 0x894c, 0x2fe5,
0x7d4e, 0x1a20, 0xe5e0, 0x7d4e, 0x4621, 0x6b14, 0x94ec, 0x4621,
0x69c5, 0x4817, 0xb7e9, 0x69c5, 0x17d1, 0x7dc4, 0x823c, 0x17d1,
0x7f43, 0x0db8, 0xf248, 0x7f43, 0x504a, 0x63b0, 0x9c50, 0x504a,
0x7053, 0x3d60, 0xc2a0, 0x7053, 0x2407, 0x7ad3, 0x852d, 0x2407,
0x7a24, 0x2648, 0xd9b8, 0x7a24, 0x3b4c, 0x7170, 0x8e90, 0x3b4c,
0x6232, 0x521c, 0xade4, 0x6232, 0x0b60, 0x7f7e, 0x8082, 0x0b60,
0x7fc8, 0x0775, 0xf88b, 0x7fc8, 0x5515, 0x5fa1, 0xa05f, 0x5515,
0x7334, 0x37ca, 0xc836, 0x7334, 0x2a03, 0x78e9, 0x8717, 0x2a03,
0x7bdf, 0x203e, 0xdfc2, 0x7bdf, 0x40cb, 0x6e64, 0x919c, 0x40cb,
0x661b, 0x4d31, 0xb2cf, 0x661b, 0x119e, 0x7ec8, 0x8138, 0x119e,
0x7e70, 0x13f2, 0xec0e, 0x7e70, 0x4b4d, 0x6782, 0x987e, 0x4b4d,
0x6d2e, 0x42d0, 0xbd30, 0x6d2e, 0x1df5, 0x7c72, 0x838e, 0x1df5,
0x781e, 0x2c3b, 0xd3c5, 0x781e, 0x35a9, 0x7436, 0x8bca, 0x35a9,
0x5e0c, 0x56d4, 0xa92c, 0x5e0c, 0x051b, 0x7fe6, 0x801a, 0x051b,
0x7fed, 0x0452, 0xfbae, 0x7fed, 0x5767, 0x5d83, 0xa27d, 0x5767,
0x7489, 0x34f2, 0xcb0e, 0x7489, 0x2cf7, 0x77d8, 0x8828, 0x2cf7,
0x7ca0, 0x1d31, 0xe2cf, 0x7ca0, 0x437b, 0x6cc4, 0x933c, 0x437b,
0x67f8, 0x4aaa, 0xb556, 0x67f8, 0x14b9, 0x7e50, 0x81b0, 0x14b9,
0x7ee3, 0x10d6, 0xef2a, 0x7ee3, 0x4dd1, 0x65a1, 0x9a5f, 0x4dd1,
0x6ec9, 0x401d, 0xbfe3, 0x6ec9, 0x2101, 0x7bac, 0x8454, 0x2101,
0x792a, 0x2945, 0xd6bb, 0x792a, 0x387f, 0x72dc, 0x8d24, 0x387f,
0x6026, 0x547f, 0xab81, 0x6026, 0x083e, 0x7fbc, 0x8044, 0x083e,
0x7f90, 0x0a97, 0xf569, 0x7f90, 0x52b6, 0x61b0, 0x9e50, 0x52b6,
0x71cc, 0x3a9a, 0xc566, 0x71cc, 0x2708, 0x79e7, 0x8619, 0x2708,
0x7b0b, 0x2346, 0xdcba, 0x7b0b, 0x3e10, 0x6ff2, 0x900e, 0x3e10,
0x642e, 0x4fad, 0xb053, 0x642e, 0x0e80, 0x7f2d, 0x80d3, 0x0e80,
0x7de9, 0x170b, 0xe8f5, 0x7de9, 0x48bd, 0x6953, 0x96ad, 0x48bd,
0x6b82, 0x4579, 0xba87, 0x6b82, 0x1ae5, 0x7d25, 0x82db, 0x1ae5,
0x76fe, 0x2f2a, 0xd0d6, 0x76fe, 0x32cb, 0x757e, 0x8a82, 0x32cb,
0x5be3, 0x591c, 0xa6e4, 0x5be3, 0x01f7, 0x7ffc, 0x8004, 0x01f7,
0x7ff8, 0x02c0, 0xfd40, 0x7ff8, 0x588c, 0x5c6f, 0xa391, 0x588c,
0x752d, 0x3383, 0xcc7d, 0x752d, 0x2e6f, 0x7748, 0x88b8, 0x2e6f,
0x7cfa, 0x1ba9, 0xe457, 0x7cfa, 0x44d0, 0x6bee, 0x9412, 0x44d0,
0x68e0, 0x4962, 0xb69e, 0x68e0, 0x1645, 0x7e0c, 0x81f4, 0x1645,
0x7f16, 0x0f47, 0xf0b9, 0x7f16, 0x4f0f, 0x64ab, 0x9b55, 0x4f0f,
0x6f90, 0x3ec0, 0xc140, 0x6f90, 0x2284, 0x7b42, 0x84be, 0x2284,
0x79aa, 0x27c7, 0xd839, 0x79aa, 0x39e7, 0x7228, 0x8dd8, 0x39e7,
0x612e, 0x534f, 0xacb1, 0x612e, 0x09cf, 0x7fa0, 0x8060, 0x09cf,
0x7fae, 0x0906, 0xf6fa, 0x7fae, 0x53e7, 0x60aa, 0x9f56, 0x53e7,
0x7282, 0x3933, 0xc6cd, 0x7282, 0x2886, 0x796a, 0x8696, 0x2886,
0x7b78, 0x21c3, 0xde3d, 0x7b78, 0x3f6f, 0x6f2d, 0x90d3, 0x3f6f,
0x6526, 0x4e71, 0xb18f, 0x6526, 0x100f, 0x7efd, 0x8103, 0x100f,
0x7e2f, 0x157f, 0xea81, 0x7e2f, 0x4a06, 0x686d, 0x9793, 0x4a06,
0x6c5a, 0x4426, 0xbbda, 0x6c5a, 0x1c6e, 0x7cce, 0x8332, 0x1c6e,
0x7790, 0x2db3, 0xd24d, 0x7790, 0x343b, 0x74dc, 0x8b24, 0x343b,
0x5cf9, 0x57fa, 0xa806, 0x5cf9, 0x0389, 0x7ff4, 0x800c, 0x0389,
0x7fdd, 0x05e3, 0xfa1d, 0x7fdd, 0x5640, 0x5e94, 0xa16c, 0x5640,
0x73e1, 0x365f, 0xc9a1, 0x73e1, 0x2b7e, 0x7863, 0x879d, 0x2b7e,
0x7c42, 0x1eb8, 0xe148, 0x7c42, 0x4224, 0x6d96, 0x926a, 0x4224,
0x670b, 0x4bef, 0xb411, 0x670b, 0x132b, 0x7e8e, 0x8172, 0x132b,
0x7eac, 0x1265, 0xed9b, 0x7eac, 0x4c91, 0x6693, 0x996d, 0x4c91,
0x6dfe, 0x4178, 0xbe88, 0x6dfe, 0x1f7b, 0x7c11, 0x83ef, 0x1f7b,
0x78a6, 0x2ac1, 0xd53f, 0x78a6, 0x3715, 0x738b, 0x8c75, 0x3715,
0x5f1b, 0x55ab, 0xaa55, 0x5f1b, 0x06ac, 0x7fd3, 0x802d, 0x06ac,
0x7f6c, 0x0c28, 0xf3d8, 0x7f6c, 0x5181, 0x62b2, 0x9d4e, 0x5181,
0x7112, 0x3bfe, 0xc402, 0x7112, 0x2588, 0x7a60, 0x85a0, 0x2588,
0x7a9a, 0x24c8, 0xdb38, 0x7a9a, 0x3caf, 0x70b3, 0x8f4d, 0x3caf,
0x6332, 0x50e6, 0xaf1a, 0x6332, 0x0cf0, 0x7f58, 0x80a8, 0x0cf0,
0x7d9e, 0x1896, 0xe76a, 0x7d9e, 0x4770, 0x6a36, 0x95ca, 0x4770,
0x6aa5, 0x46c9, 0xb937, 0x6aa5, 0x195b, 0x7d77, 0x8289, 0x195b,
0x7668, 0x309f, 0xcf61, 0x7668, 0x3159, 0x761b, 0x89e5, 0x3159,
0x5ac9, 0x5a3b, 0xa5c5, 0x5ac9, 0x0065, 0x7fff, 0x8000, 0x0065
};

    const CFrac16 dfr16RFFTTwiddleTable8[6]={0x7fff, 0x0000, 0x5a82,
                                      0x5a82, 0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable8br[4]=
    {0x7fff, 0x0000, 0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable16[]={0x7fff, 0x0000, 0x7642, 0x30fc,
                                       0x5a82, 0x5a82, 0x30fc, 0x7642,
                                       0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable16br[8] =  { 0x7fff, 0x0000, 0x0000,
                                              0x7fff, 0x5a82, 0x5a82,
                                              0xa57e, 0x5a82};
    const CFrac16 dfr16RFFTTwiddleTable32[]={
     0x7fff, 0x0000, 0x7d8a, 0x18f9, 0x7642, 0x30fc, 0x6a6e, 0x471d,
     0x5a82, 0x5a82, 0x471d, 0x6a6e, 0x30fc, 0x7642, 0x18f9, 0x7d8a,
     0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable32br[] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc};

    const CFrac16 dfr16RFFTTwiddleTable64[]={
            0x7fff, 0x0000, 0x7f62, 0x0c8c, 0x7d8a, 0x18f9, 0x7a7d, 0x2528,
            0x7642, 0x30fc, 0x70e3, 0x3c57, 0x6a6e, 0x471d, 0x62f2, 0x5134,
            0x5a82, 0x5a82, 0x5134, 0x62f2, 0x471d, 0x6a6e, 0x3c57, 0x70e3,
            0x30fc, 0x7642, 0x2528, 0x7a7d, 0x18f9, 0x7d8a, 0x0c8c, 0x7f62,
            0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable64br[] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9};

    const CFrac16 dfr16RFFTTwiddleTable128[]={
            0x7fff, 0x0000, 0x7fd9, 0x0648, 0x7f62, 0x0c8c, 0x7e9d, 0x12c8,
            0x7d8a, 0x18f9, 0x7c2a, 0x1f1a, 0x7a7d, 0x2528, 0x7885, 0x2b1f,
            0x7642, 0x30fc, 0x73b6, 0x36ba, 0x70e3, 0x3c57, 0x6dca, 0x41ce,
            0x6a6e, 0x471d, 0x66d0, 0x4c40, 0x62f2, 0x5134, 0x5ed7, 0x55f6,
            0x5a82, 0x5a82, 0x55f6, 0x5ed7, 0x5134, 0x62f2, 0x4c40, 0x66d0,
            0x471d, 0x6a6e, 0x41ce, 0x6dca, 0x3c57, 0x70e3, 0x36ba, 0x73b6,
            0x30fc, 0x7642, 0x2b1f, 0x7885, 0x2528, 0x7a7d, 0x1f1a, 0x7c2a,
            0x18f9, 0x7d8a, 0x12c8, 0x7e9d, 0x0c8c, 0x7f62, 0x0648, 0x7fd9,
            0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable128br[] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
        0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
        0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
        0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
        0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c};

     const CFrac16 dfr16RFFTTwiddleTable256[]={
        0x7fff, 0x0000, 0x7ff6, 0x0324, 0x7fd9, 0x0648, 0x7fa7, 0x096b,
        0x7f62, 0x0c8c, 0x7f0a, 0x0fab, 0x7e9d, 0x12c8, 0x7e1e, 0x15e2,
        0x7d8a, 0x18f9, 0x7ce4, 0x1c0c, 0x7c2a, 0x1f1a, 0x7b5d, 0x2224,
        0x7a7d, 0x2528, 0x798a, 0x2827, 0x7885, 0x2b1f, 0x776c, 0x2e11,
        0x7642, 0x30fc, 0x7505, 0x33df, 0x73b6, 0x36ba, 0x7255, 0x398d,
        0x70e3, 0x3c57, 0x6f5f, 0x3f17, 0x6dca, 0x41ce, 0x6c24, 0x447b,
        0x6a6e, 0x471d, 0x68a7, 0x49b4, 0x66d0, 0x4c40, 0x64e9, 0x4ec0,
        0x62f2, 0x5134, 0x60ec, 0x539b, 0x5ed7, 0x55f6, 0x5cb4, 0x5843,
        0x5a82, 0x5a82, 0x5843, 0x5cb4, 0x55f6, 0x5ed7, 0x539b, 0x60ec,
        0x5134, 0x62f2, 0x4ec0, 0x64e9, 0x4c40, 0x66d0, 0x49b4, 0x68a7,
        0x471d, 0x6a6e, 0x447b, 0x6c24, 0x41ce, 0x6dca, 0x3f17, 0x6f5f,
        0x3c57, 0x70e3, 0x398d, 0x7255, 0x36ba, 0x73b6, 0x33df, 0x7505,
        0x30fc, 0x7642, 0x2e11, 0x776c, 0x2b1f, 0x7885, 0x2827, 0x798a,
        0x2528, 0x7a7d, 0x2224, 0x7b5d, 0x1f1a, 0x7c2a, 0x1c0c, 0x7ce4,
        0x18f9, 0x7d8a, 0x15e2, 0x7e1e, 0x12c8, 0x7e9d, 0x0fab, 0x7f0a,
        0x0c8c, 0x7f62, 0x096b, 0x7fa7, 0x0648, 0x7fd9, 0x0324, 0x7ff6,
        0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable256br[] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
        0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
        0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
        0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
        0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
        0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
        0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
        0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
        0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
        0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
        0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
        0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
        0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648};

     const CFrac16 dfr16RFFTTwiddleTable512[]={
        0x7fff, 0x0000, 0x7ffe, 0x0192, 0x7ff6, 0x0324, 0x7fea, 0x04b6,
        0x7fd9, 0x0648, 0x7fc2, 0x07d9, 0x7fa7, 0x096b, 0x7f87, 0x0afb,
        0x7f62, 0x0c8c, 0x7f38, 0x0e1c, 0x7f0a, 0x0fab, 0x7ed6, 0x113a,
        0x7e9d, 0x12c8, 0x7e60, 0x1455, 0x7e1e, 0x15e2, 0x7dd6, 0x176e,
        0x7d8a, 0x18f9, 0x7d3a, 0x1a83, 0x7ce4, 0x1c0c, 0x7c89, 0x1d93,
        0x7c2a, 0x1f1a, 0x7bc6, 0x209f, 0x7b5d, 0x2224, 0x7aef, 0x23a7,
        0x7a7d, 0x2528, 0x7a06, 0x26a8, 0x798a, 0x2827, 0x790a, 0x29a4,
        0x7885, 0x2b1f, 0x77fb, 0x2c99, 0x776c, 0x2e11, 0x76d9, 0x2f87,
        0x7642, 0x30fc, 0x75a6, 0x326e, 0x7505, 0x33df, 0x7460, 0x354e,
        0x73b6, 0x36ba, 0x7308, 0x3825, 0x7255, 0x398d, 0x719e, 0x3af3,
        0x70e3, 0x3c57, 0x7023, 0x3db8, 0x6f5f, 0x3f17, 0x6e97, 0x4074,
        0x6dca, 0x41ce, 0x6cf9, 0x4326, 0x6c24, 0x447b, 0x6b4b, 0x45cd,
        0x6a6e, 0x471d, 0x698c, 0x486a, 0x68a7, 0x49b4, 0x67bd, 0x4afb,
        0x66d0, 0x4c40, 0x65de, 0x4d81, 0x64e9, 0x4ec0, 0x63ef, 0x4ffb,
        0x62f2, 0x5134, 0x61f1, 0x5269, 0x60ec, 0x539b, 0x5fe4, 0x54ca,
        0x5ed7, 0x55f6, 0x5dc8, 0x571e, 0x5cb4, 0x5843, 0x5b9d, 0x5964,
        0x5a82, 0x5a82, 0x5964, 0x5b9d, 0x5843, 0x5cb4, 0x571e, 0x5dc8,
        0x55f6, 0x5ed7, 0x54ca, 0x5fe4, 0x539b, 0x60ec, 0x5269, 0x61f1,
        0x5134, 0x62f2, 0x4ffb, 0x63ef, 0x4ec0, 0x64e9, 0x4d81, 0x65de,
        0x4c40, 0x66d0, 0x4afb, 0x67bd, 0x49b4, 0x68a7, 0x486a, 0x698c,
        0x471d, 0x6a6e, 0x45cd, 0x6b4b, 0x447b, 0x6c24, 0x4326, 0x6cf9,
        0x41ce, 0x6dca, 0x4074, 0x6e97, 0x3f17, 0x6f5f, 0x3db8, 0x7023,
        0x3c57, 0x70e3, 0x3af3, 0x719e, 0x398d, 0x7255, 0x3825, 0x7308,
        0x36ba, 0x73b6, 0x354e, 0x7460, 0x33df, 0x7505, 0x326e, 0x75a6,
        0x30fc, 0x7642, 0x2f87, 0x76d9, 0x2e11, 0x776c, 0x2c99, 0x77fb,
        0x2b1f, 0x7885, 0x29a4, 0x790a, 0x2827, 0x798a, 0x26a8, 0x7a06,
        0x2528, 0x7a7d, 0x23a7, 0x7aef, 0x2224, 0x7b5d, 0x209f, 0x7bc6,
        0x1f1a, 0x7c2a, 0x1d93, 0x7c89, 0x1c0c, 0x7ce4, 0x1a83, 0x7d3a,
        0x18f9, 0x7d8a, 0x176e, 0x7dd6, 0x15e2, 0x7e1e, 0x1455, 0x7e60,
        0x12c8, 0x7e9d, 0x113a, 0x7ed6, 0x0fab, 0x7f0a, 0x0e1c, 0x7f38,
        0x0c8c, 0x7f62, 0x0afb, 0x7f87, 0x096b, 0x7fa7, 0x07d9, 0x7fc2,
        0x0648, 0x7fd9, 0x04b6, 0x7fea, 0x0324, 0x7ff6, 0x0192, 0x7ffe,
        0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable512br[512] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
        0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
        0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
        0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
        0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
        0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
        0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
        0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
        0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
        0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
        0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
        0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
        0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
        0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
        0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
        0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
        0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
        0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
        0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
        0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
        0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
        0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
        0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
        0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
        0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
        0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
        0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
        0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
        0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324};

     const CFrac16 dfr16RFFTTwiddleTable1024[]={
        0x7fff, 0x0000, 0x7fff, 0x00c9, 0x7ffe, 0x0192, 0x7ffa, 0x025b,
        0x7ff6, 0x0324, 0x7ff1, 0x03ed, 0x7fea, 0x04b6, 0x7fe2, 0x057f,
        0x7fd9, 0x0648, 0x7fce, 0x0711, 0x7fc2, 0x07d9, 0x7fb5, 0x08a2,
        0x7fa7, 0x096b, 0x7f98, 0x0a33, 0x7f87, 0x0afb, 0x7f75, 0x0bc4,
        0x7f62, 0x0c8c, 0x7f4e, 0x0d54, 0x7f38, 0x0e1c, 0x7f22, 0x0ee4,
        0x7f0a, 0x0fab, 0x7ef0, 0x1073, 0x7ed6, 0x113a, 0x7eba, 0x1201,
        0x7e9d, 0x12c8, 0x7e7f, 0x138f, 0x7e60, 0x1455, 0x7e3f, 0x151c,
        0x7e1e, 0x15e2, 0x7dfb, 0x16a8, 0x7dd6, 0x176e, 0x7db1, 0x1833,
        0x7d8a, 0x18f9, 0x7d63, 0x19be, 0x7d3a, 0x1a83, 0x7d0f, 0x1b47,
        0x7ce4, 0x1c0c, 0x7cb7, 0x1cd0, 0x7c89, 0x1d93, 0x7c5a, 0x1e57,
        0x7c2a, 0x1f1a, 0x7bf9, 0x1fdd, 0x7bc6, 0x209f, 0x7b92, 0x2162,
        0x7b5d, 0x2224, 0x7b27, 0x22e5, 0x7aef, 0x23a7, 0x7ab7, 0x2467,
        0x7a7d, 0x2528, 0x7a42, 0x25e8, 0x7a06, 0x26a8, 0x79c9, 0x2768,
        0x798a, 0x2827, 0x794a, 0x28e5, 0x790a, 0x29a4, 0x78c8, 0x2a62,
        0x7885, 0x2b1f, 0x7840, 0x2bdc, 0x77fb, 0x2c99, 0x77b4, 0x2d55,
        0x776c, 0x2e11, 0x7723, 0x2ecc, 0x76d9, 0x2f87, 0x768e, 0x3042,
        0x7642, 0x30fc, 0x75f4, 0x31b5, 0x75a6, 0x326e, 0x7556, 0x3327,
        0x7505, 0x33df, 0x74b3, 0x3497, 0x7460, 0x354e, 0x740b, 0x3604,
        0x73b6, 0x36ba, 0x735f, 0x3770, 0x7308, 0x3825, 0x72af, 0x38d9,
        0x7255, 0x398d, 0x71fa, 0x3a40, 0x719e, 0x3af3, 0x7141, 0x3ba5,
        0x70e3, 0x3c57, 0x7083, 0x3d08, 0x7023, 0x3db8, 0x6fc2, 0x3e68,
        0x6f5f, 0x3f17, 0x6efb, 0x3fc6, 0x6e97, 0x4074, 0x6e31, 0x4121,
        0x6dca, 0x41ce, 0x6d62, 0x427a, 0x6cf9, 0x4326, 0x6c8f, 0x43d1,
        0x6c24, 0x447b, 0x6bb8, 0x4524, 0x6b4b, 0x45cd, 0x6add, 0x4675,
        0x6a6e, 0x471d, 0x69fd, 0x47c4, 0x698c, 0x486a, 0x691a, 0x490f,
        0x68a7, 0x49b4, 0x6832, 0x4a58, 0x67bd, 0x4afb, 0x6747, 0x4b9e,
        0x66d0, 0x4c40, 0x6657, 0x4ce1, 0x65de, 0x4d81, 0x6564, 0x4e21,
        0x64e9, 0x4ec0, 0x646c, 0x4f5e, 0x63ef, 0x4ffb, 0x6371, 0x5098,
        0x62f2, 0x5134, 0x6272, 0x51cf, 0x61f1, 0x5269, 0x616f, 0x5303,
        0x60ec, 0x539b, 0x6068, 0x5433, 0x5fe4, 0x54ca, 0x5f5e, 0x5560,
        0x5ed7, 0x55f6, 0x5e50, 0x568a, 0x5dc8, 0x571e, 0x5d3e, 0x57b1,
        0x5cb4, 0x5843, 0x5c29, 0x58d4, 0x5b9d, 0x5964, 0x5b10, 0x59f4,
        0x5a82, 0x5a82, 0x59f4, 0x5b10, 0x5964, 0x5b9d, 0x58d4, 0x5c29,
        0x5843, 0x5cb4, 0x57b1, 0x5d3e, 0x571e, 0x5dc8, 0x568a, 0x5e50,
        0x55f6, 0x5ed7, 0x5560, 0x5f5e, 0x54ca, 0x5fe4, 0x5433, 0x6068,
        0x539b, 0x60ec, 0x5303, 0x616f, 0x5269, 0x61f1, 0x51cf, 0x6272,
        0x5134, 0x62f2, 0x5098, 0x6371, 0x4ffb, 0x63ef, 0x4f5e, 0x646c,
        0x4ec0, 0x64e9, 0x4e21, 0x6564, 0x4d81, 0x65de, 0x4ce1, 0x6657,
        0x4c40, 0x66d0, 0x4b9e, 0x6747, 0x4afb, 0x67bd, 0x4a58, 0x6832,
        0x49b4, 0x68a7, 0x490f, 0x691a, 0x486a, 0x698c, 0x47c4, 0x69fd,
        0x471d, 0x6a6e, 0x4675, 0x6add, 0x45cd, 0x6b4b, 0x4524, 0x6bb8,
        0x447b, 0x6c24, 0x43d1, 0x6c8f, 0x4326, 0x6cf9, 0x427a, 0x6d62,
        0x41ce, 0x6dca, 0x4121, 0x6e31, 0x4074, 0x6e97, 0x3fc6, 0x6efb,
        0x3f17, 0x6f5f, 0x3e68, 0x6fc2, 0x3db8, 0x7023, 0x3d08, 0x7083,
        0x3c57, 0x70e3, 0x3ba5, 0x7141, 0x3af3, 0x719e, 0x3a40, 0x71fa,
        0x398d, 0x7255, 0x38d9, 0x72af, 0x3825, 0x7308, 0x3770, 0x735f,
        0x36ba, 0x73b6, 0x3604, 0x740b, 0x354e, 0x7460, 0x3497, 0x74b3,
        0x33df, 0x7505, 0x3327, 0x7556, 0x326e, 0x75a6, 0x31b5, 0x75f4,
        0x30fc, 0x7642, 0x3042, 0x768e, 0x2f87, 0x76d9, 0x2ecc, 0x7723,
        0x2e11, 0x776c, 0x2d55, 0x77b4, 0x2c99, 0x77fb, 0x2bdc, 0x7840,
        0x2b1f, 0x7885, 0x2a62, 0x78c8, 0x29a4, 0x790a, 0x28e5, 0x794a,
        0x2827, 0x798a, 0x2768, 0x79c9, 0x26a8, 0x7a06, 0x25e8, 0x7a42,
        0x2528, 0x7a7d, 0x2467, 0x7ab7, 0x23a7, 0x7aef, 0x22e5, 0x7b27,
        0x2224, 0x7b5d, 0x2162, 0x7b92, 0x209f, 0x7bc6, 0x1fdd, 0x7bf9,
        0x1f1a, 0x7c2a, 0x1e57, 0x7c5a, 0x1d93, 0x7c89, 0x1cd0, 0x7cb7,
        0x1c0c, 0x7ce4, 0x1b47, 0x7d0f, 0x1a83, 0x7d3a, 0x19be, 0x7d63,
        0x18f9, 0x7d8a, 0x1833, 0x7db1, 0x176e, 0x7dd6, 0x16a8, 0x7dfb,
        0x15e2, 0x7e1e, 0x151c, 0x7e3f, 0x1455, 0x7e60, 0x138f, 0x7e7f,
        0x12c8, 0x7e9d, 0x1201, 0x7eba, 0x113a, 0x7ed6, 0x1073, 0x7ef0,
        0x0fab, 0x7f0a, 0x0ee4, 0x7f22, 0x0e1c, 0x7f38, 0x0d54, 0x7f4e,
        0x0c8c, 0x7f62, 0x0bc4, 0x7f75, 0x0afb, 0x7f87, 0x0a33, 0x7f98,
        0x096b, 0x7fa7, 0x08a2, 0x7fb5, 0x07d9, 0x7fc2, 0x0711, 0x7fce,
        0x0648, 0x7fd9, 0x057f, 0x7fe2, 0x04b6, 0x7fea, 0x03ed, 0x7ff1,
        0x0324, 0x7ff6, 0x025b, 0x7ffa, 0x0192, 0x7ffe, 0x00c9, 0x7fff,
        0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable1024br[] =
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
        0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
        0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
        0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
        0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
        0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
        0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
        0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
        0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
        0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
        0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
        0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
        0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
        0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
        0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
        0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
        0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
        0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
        0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
        0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
        0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
        0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
        0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
        0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
        0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
        0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
        0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
        0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
        0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
        0x7ffe, 0x0192, 0xfe6e, 0x7ffe, 0x5964, 0x5b9d, 0xa463, 0x5964,
        0x75a6, 0x326e, 0xcd92, 0x75a6, 0x2f87, 0x76d9, 0x8927, 0x2f87,
        0x7d3a, 0x1a83, 0xe57d, 0x7d3a, 0x45cd, 0x6b4b, 0x94b5, 0x45cd,
        0x698c, 0x486a, 0xb796, 0x698c, 0x176e, 0x7dd6, 0x822a, 0x176e,
        0x7f38, 0x0e1c, 0xf1e4, 0x7f38, 0x4ffb, 0x63ef, 0x9c11, 0x4ffb,
        0x7023, 0x3db8, 0xc248, 0x7023, 0x23a7, 0x7aef, 0x8511, 0x23a7,
        0x7a06, 0x26a8, 0xd958, 0x7a06, 0x3af3, 0x719e, 0x8e62, 0x3af3,
        0x61f1, 0x5269, 0xad97, 0x61f1, 0x0afb, 0x7f87, 0x8079, 0x0afb,
        0x7fc2, 0x07d9, 0xf827, 0x7fc2, 0x54ca, 0x5fe4, 0xa01c, 0x54ca,
        0x7308, 0x3825, 0xc7db, 0x7308, 0x29a4, 0x790a, 0x86f6, 0x29a4,
        0x7bc6, 0x209f, 0xdf61, 0x7bc6, 0x4074, 0x6e97, 0x9169, 0x4074,
        0x65de, 0x4d81, 0xb27f, 0x65de, 0x113a, 0x7ed6, 0x812a, 0x113a,
        0x7e60, 0x1455, 0xebab, 0x7e60, 0x4afb, 0x67bd, 0x9843, 0x4afb,
        0x6cf9, 0x4326, 0xbcda, 0x6cf9, 0x1d93, 0x7c89, 0x8377, 0x1d93,
        0x77fb, 0x2c99, 0xd367, 0x77fb, 0x354e, 0x7460, 0x8ba0, 0x354e,
        0x5dc8, 0x571e, 0xa8e2, 0x5dc8, 0x04b6, 0x7fea, 0x8016, 0x04b6,
        0x7fea, 0x04b6, 0xfb4a, 0x7fea, 0x571e, 0x5dc8, 0xa238, 0x571e,
        0x7460, 0x354e, 0xcab2, 0x7460, 0x2c99, 0x77fb, 0x8805, 0x2c99,
        0x7c89, 0x1d93, 0xe26d, 0x7c89, 0x4326, 0x6cf9, 0x9307, 0x4326,
        0x67bd, 0x4afb, 0xb505, 0x67bd, 0x1455, 0x7e60, 0x81a0, 0x1455,
        0x7ed6, 0x113a, 0xeec6, 0x7ed6, 0x4d81, 0x65de, 0x9a22, 0x4d81,
        0x6e97, 0x4074, 0xbf8c, 0x6e97, 0x209f, 0x7bc6, 0x843a, 0x209f,
        0x790a, 0x29a4, 0xd65c, 0x790a, 0x3825, 0x7308, 0x8cf8, 0x3825,
        0x5fe4, 0x54ca, 0xab36, 0x5fe4, 0x07d9, 0x7fc2, 0x803e, 0x07d9,
        0x7f87, 0x0afb, 0xf505, 0x7f87, 0x5269, 0x61f1, 0x9e0f, 0x5269,
        0x719e, 0x3af3, 0xc50d, 0x719e, 0x26a8, 0x7a06, 0x85fa, 0x26a8,
        0x7aef, 0x23a7, 0xdc59, 0x7aef, 0x3db8, 0x7023, 0x8fdd, 0x3db8,
        0x63ef, 0x4ffb, 0xb005, 0x63ef, 0x0e1c, 0x7f38, 0x80c8, 0x0e1c,
        0x7dd6, 0x176e, 0xe892, 0x7dd6, 0x486a, 0x698c, 0x9674, 0x486a,
        0x6b4b, 0x45cd, 0xba33, 0x6b4b, 0x1a83, 0x7d3a, 0x82c6, 0x1a83,
        0x76d9, 0x2f87, 0xd079, 0x76d9, 0x326e, 0x75a6, 0x8a5a, 0x326e,
        0x5b9d, 0x5964, 0xa69c, 0x5b9d, 0x0192, 0x7ffe, 0x8002, 0x0192};


     const CFrac16 dfr16RFFTTwiddleTable2048[]={
        0x7fff, 0x0000, 0x7fff, 0x0065, 0x7fff, 0x00c9, 0x7fff, 0x012e,
        0x7ffe, 0x0192, 0x7ffc, 0x01f7, 0x7ffa, 0x025b, 0x7ff8, 0x02c0,
        0x7ff6, 0x0324, 0x7ff4, 0x0389, 0x7ff1, 0x03ed, 0x7fed, 0x0452,
        0x7fea, 0x04b6, 0x7fe6, 0x051b, 0x7fe2, 0x057f, 0x7fdd, 0x05e3,
        0x7fd9, 0x0648, 0x7fd3, 0x06ac, 0x7fce, 0x0711, 0x7fc8, 0x0775,
        0x7fc2, 0x07d9, 0x7fbc, 0x083e, 0x7fb5, 0x08a2, 0x7fae, 0x0906,
        0x7fa7, 0x096b, 0x7fa0, 0x09cf, 0x7f98, 0x0a33, 0x7f90, 0x0a97,
        0x7f87, 0x0afb, 0x7f7e, 0x0b60, 0x7f75, 0x0bc4, 0x7f6c, 0x0c28,
        0x7f62, 0x0c8c, 0x7f58, 0x0cf0, 0x7f4e, 0x0d54, 0x7f43, 0x0db8,
        0x7f38, 0x0e1c, 0x7f2d, 0x0e80, 0x7f22, 0x0ee4, 0x7f16, 0x0f47,
        0x7f0a, 0x0fab, 0x7efd, 0x100f, 0x7ef0, 0x1073, 0x7ee3, 0x10d6,
        0x7ed6, 0x113a, 0x7ec8, 0x119e, 0x7eba, 0x1201, 0x7eac, 0x1265,
        0x7e9d, 0x12c8, 0x7e8e, 0x132b, 0x7e7f, 0x138f, 0x7e70, 0x13f2,
        0x7e60, 0x1455, 0x7e50, 0x14b9, 0x7e3f, 0x151c, 0x7e2f, 0x157f,
        0x7e1e, 0x15e2, 0x7e0c, 0x1645, 0x7dfb, 0x16a8, 0x7de9, 0x170b,
        0x7dd6, 0x176e, 0x7dc4, 0x17d1, 0x7db1, 0x1833, 0x7d9e, 0x1896,
        0x7d8a, 0x18f9, 0x7d77, 0x195b, 0x7d63, 0x19be, 0x7d4e, 0x1a20,
        0x7d3a, 0x1a83, 0x7d25, 0x1ae5, 0x7d0f, 0x1b47, 0x7cfa, 0x1ba9,
        0x7ce4, 0x1c0c, 0x7cce, 0x1c6e, 0x7cb7, 0x1cd0, 0x7ca0, 0x1d31,
        0x7c89, 0x1d93, 0x7c72, 0x1df5, 0x7c5a, 0x1e57, 0x7c42, 0x1eb8,
        0x7c2a, 0x1f1a, 0x7c11, 0x1f7b, 0x7bf9, 0x1fdd, 0x7bdf, 0x203e,
        0x7bc6, 0x209f, 0x7bac, 0x2101, 0x7b92, 0x2162, 0x7b78, 0x21c3,
        0x7b5d, 0x2224, 0x7b42, 0x2284, 0x7b27, 0x22e5, 0x7b0b, 0x2346,
        0x7aef, 0x23a7, 0x7ad3, 0x2407, 0x7ab7, 0x2467, 0x7a9a, 0x24c8,
        0x7a7d, 0x2528, 0x7a60, 0x2588, 0x7a42, 0x25e8, 0x7a24, 0x2648,
        0x7a06, 0x26a8, 0x79e7, 0x2708, 0x79c9, 0x2768, 0x79aa, 0x27c7,
        0x798a, 0x2827, 0x796a, 0x2886, 0x794a, 0x28e5, 0x792a, 0x2945,
        0x790a, 0x29a4, 0x78e9, 0x2a03, 0x78c8, 0x2a62, 0x78a6, 0x2ac1,
        0x7885, 0x2b1f, 0x7863, 0x2b7e, 0x7840, 0x2bdc, 0x781e, 0x2c3b,
        0x77fb, 0x2c99, 0x77d8, 0x2cf7, 0x77b4, 0x2d55, 0x7790, 0x2db3,
        0x776c, 0x2e11, 0x7748, 0x2e6f, 0x7723, 0x2ecc, 0x76fe, 0x2f2a,
        0x76d9, 0x2f87, 0x76b4, 0x2fe5, 0x768e, 0x3042, 0x7668, 0x309f,
        0x7642, 0x30fc, 0x761b, 0x3159, 0x75f4, 0x31b5, 0x75cd, 0x3212,
        0x75a6, 0x326e, 0x757e, 0x32cb, 0x7556, 0x3327, 0x752d, 0x3383,
        0x7505, 0x33df, 0x74dc, 0x343b, 0x74b3, 0x3497, 0x7489, 0x34f2,
        0x7460, 0x354e, 0x7436, 0x35a9, 0x740b, 0x3604, 0x73e1, 0x365f,
        0x73b6, 0x36ba, 0x738b, 0x3715, 0x735f, 0x3770, 0x7334, 0x37ca,
        0x7308, 0x3825, 0x72dc, 0x387f, 0x72af, 0x38d9, 0x7282, 0x3933,
        0x7255, 0x398d, 0x7228, 0x39e7, 0x71fa, 0x3a40, 0x71cc, 0x3a9a,
        0x719e, 0x3af3, 0x7170, 0x3b4c, 0x7141, 0x3ba5, 0x7112, 0x3bfe,
        0x70e3, 0x3c57, 0x70b3, 0x3caf, 0x7083, 0x3d08, 0x7053, 0x3d60,
        0x7023, 0x3db8, 0x6ff2, 0x3e10, 0x6fc2, 0x3e68, 0x6f90, 0x3ec0,
        0x6f5f, 0x3f17, 0x6f2d, 0x3f6f, 0x6efb, 0x3fc6, 0x6ec9, 0x401d,
        0x6e97, 0x4074, 0x6e64, 0x40cb, 0x6e31, 0x4121, 0x6dfe, 0x4178,
        0x6dca, 0x41ce, 0x6d96, 0x4224, 0x6d62, 0x427a, 0x6d2e, 0x42d0,
        0x6cf9, 0x4326, 0x6cc4, 0x437b, 0x6c8f, 0x43d1, 0x6c5a, 0x4426,
        0x6c24, 0x447b, 0x6bee, 0x44d0, 0x6bb8, 0x4524, 0x6b82, 0x4579,
        0x6b4b, 0x45cd, 0x6b14, 0x4621, 0x6add, 0x4675, 0x6aa5, 0x46c9,
        0x6a6e, 0x471d, 0x6a36, 0x4770, 0x69fd, 0x47c4, 0x69c5, 0x4817,
        0x698c, 0x486a, 0x6953, 0x48bd, 0x691a, 0x490f, 0x68e0, 0x4962,
        0x68a7, 0x49b4, 0x686d, 0x4a06, 0x6832, 0x4a58, 0x67f8, 0x4aaa,
        0x67bd, 0x4afb, 0x6782, 0x4b4d, 0x6747, 0x4b9e, 0x670b, 0x4bef,
        0x66d0, 0x4c40, 0x6693, 0x4c91, 0x6657, 0x4ce1, 0x661b, 0x4d31,
        0x65de, 0x4d81, 0x65a1, 0x4dd1, 0x6564, 0x4e21, 0x6526, 0x4e71,
        0x64e9, 0x4ec0, 0x64ab, 0x4f0f, 0x646c, 0x4f5e, 0x642e, 0x4fad,
        0x63ef, 0x4ffb, 0x63b0, 0x504a, 0x6371, 0x5098, 0x6332, 0x50e6,
        0x62f2, 0x5134, 0x62b2, 0x5181, 0x6272, 0x51cf, 0x6232, 0x521c,
        0x61f1, 0x5269, 0x61b0, 0x52b6, 0x616f, 0x5303, 0x612e, 0x534f,
        0x60ec, 0x539b, 0x60aa, 0x53e7, 0x6068, 0x5433, 0x6026, 0x547f,
        0x5fe4, 0x54ca, 0x5fa1, 0x5515, 0x5f5e, 0x5560, 0x5f1b, 0x55ab,
        0x5ed7, 0x55f6, 0x5e94, 0x5640, 0x5e50, 0x568a, 0x5e0c, 0x56d4,
        0x5dc8, 0x571e, 0x5d83, 0x5767, 0x5d3e, 0x57b1, 0x5cf9, 0x57fa,
        0x5cb4, 0x5843, 0x5c6f, 0x588c, 0x5c29, 0x58d4, 0x5be3, 0x591c,
        0x5b9d, 0x5964, 0x5b57, 0x59ac, 0x5b10, 0x59f4, 0x5ac9, 0x5a3b,
        0x5a82, 0x5a82, 0x5a3b, 0x5ac9, 0x59f4, 0x5b10, 0x59ac, 0x5b57,
        0x5964, 0x5b9d, 0x591c, 0x5be3, 0x58d4, 0x5c29, 0x588c, 0x5c6f,
        0x5843, 0x5cb4, 0x57fa, 0x5cf9, 0x57b1, 0x5d3e, 0x5767, 0x5d83,
        0x571e, 0x5dc8, 0x56d4, 0x5e0c, 0x568a, 0x5e50, 0x5640, 0x5e94,
        0x55f6, 0x5ed7, 0x55ab, 0x5f1b, 0x5560, 0x5f5e, 0x5515, 0x5fa1,
        0x54ca, 0x5fe4, 0x547f, 0x6026, 0x5433, 0x6068, 0x53e7, 0x60aa,
        0x539b, 0x60ec, 0x534f, 0x612e, 0x5303, 0x616f, 0x52b6, 0x61b0,
        0x5269, 0x61f1, 0x521c, 0x6232, 0x51cf, 0x6272, 0x5181, 0x62b2,
        0x5134, 0x62f2, 0x50e6, 0x6332, 0x5098, 0x6371, 0x504a, 0x63b0,
        0x4ffb, 0x63ef, 0x4fad, 0x642e, 0x4f5e, 0x646c, 0x4f0f, 0x64ab,
        0x4ec0, 0x64e9, 0x4e71, 0x6526, 0x4e21, 0x6564, 0x4dd1, 0x65a1,
        0x4d81, 0x65de, 0x4d31, 0x661b, 0x4ce1, 0x6657, 0x4c91, 0x6693,
        0x4c40, 0x66d0, 0x4bef, 0x670b, 0x4b9e, 0x6747, 0x4b4d, 0x6782,
        0x4afb, 0x67bd, 0x4aaa, 0x67f8, 0x4a58, 0x6832, 0x4a06, 0x686d,
        0x49b4, 0x68a7, 0x4962, 0x68e0, 0x490f, 0x691a, 0x48bd, 0x6953,
        0x486a, 0x698c, 0x4817, 0x69c5, 0x47c4, 0x69fd, 0x4770, 0x6a36,
        0x471d, 0x6a6e, 0x46c9, 0x6aa5, 0x4675, 0x6add, 0x4621, 0x6b14,
        0x45cd, 0x6b4b, 0x4579, 0x6b82, 0x4524, 0x6bb8, 0x44d0, 0x6bee,
        0x447b, 0x6c24, 0x4426, 0x6c5a, 0x43d1, 0x6c8f, 0x437b, 0x6cc4,
        0x4326, 0x6cf9, 0x42d0, 0x6d2e, 0x427a, 0x6d62, 0x4224, 0x6d96,
        0x41ce, 0x6dca, 0x4178, 0x6dfe, 0x4121, 0x6e31, 0x40cb, 0x6e64,
        0x4074, 0x6e97, 0x401d, 0x6ec9, 0x3fc6, 0x6efb, 0x3f6f, 0x6f2d,
        0x3f17, 0x6f5f, 0x3ec0, 0x6f90, 0x3e68, 0x6fc2, 0x3e10, 0x6ff2,
        0x3db8, 0x7023, 0x3d60, 0x7053, 0x3d08, 0x7083, 0x3caf, 0x70b3,
        0x3c57, 0x70e3, 0x3bfe, 0x7112, 0x3ba5, 0x7141, 0x3b4c, 0x7170,
        0x3af3, 0x719e, 0x3a9a, 0x71cc, 0x3a40, 0x71fa, 0x39e7, 0x7228,
        0x398d, 0x7255, 0x3933, 0x7282, 0x38d9, 0x72af, 0x387f, 0x72dc,
        0x3825, 0x7308, 0x37ca, 0x7334, 0x3770, 0x735f, 0x3715, 0x738b,
        0x36ba, 0x73b6, 0x365f, 0x73e1, 0x3604, 0x740b, 0x35a9, 0x7436,
        0x354e, 0x7460, 0x34f2, 0x7489, 0x3497, 0x74b3, 0x343b, 0x74dc,
        0x33df, 0x7505, 0x3383, 0x752d, 0x3327, 0x7556, 0x32cb, 0x757e,
        0x326e, 0x75a6, 0x3212, 0x75cd, 0x31b5, 0x75f4, 0x3159, 0x761b,
        0x30fc, 0x7642, 0x309f, 0x7668, 0x3042, 0x768e, 0x2fe5, 0x76b4,
        0x2f87, 0x76d9, 0x2f2a, 0x76fe, 0x2ecc, 0x7723, 0x2e6f, 0x7748,
        0x2e11, 0x776c, 0x2db3, 0x7790, 0x2d55, 0x77b4, 0x2cf7, 0x77d8,
        0x2c99, 0x77fb, 0x2c3b, 0x781e, 0x2bdc, 0x7840, 0x2b7e, 0x7863,
        0x2b1f, 0x7885, 0x2ac1, 0x78a6, 0x2a62, 0x78c8, 0x2a03, 0x78e9,
        0x29a4, 0x790a, 0x2945, 0x792a, 0x28e5, 0x794a, 0x2886, 0x796a,
        0x2827, 0x798a, 0x27c7, 0x79aa, 0x2768, 0x79c9, 0x2708, 0x79e7,
        0x26a8, 0x7a06, 0x2648, 0x7a24, 0x25e8, 0x7a42, 0x2588, 0x7a60,
        0x2528, 0x7a7d, 0x24c8, 0x7a9a, 0x2467, 0x7ab7, 0x2407, 0x7ad3,
        0x23a7, 0x7aef, 0x2346, 0x7b0b, 0x22e5, 0x7b27, 0x2284, 0x7b42,
        0x2224, 0x7b5d, 0x21c3, 0x7b78, 0x2162, 0x7b92, 0x2101, 0x7bac,
        0x209f, 0x7bc6, 0x203e, 0x7bdf, 0x1fdd, 0x7bf9, 0x1f7b, 0x7c11,
        0x1f1a, 0x7c2a, 0x1eb8, 0x7c42, 0x1e57, 0x7c5a, 0x1df5, 0x7c72,
        0x1d93, 0x7c89, 0x1d31, 0x7ca0, 0x1cd0, 0x7cb7, 0x1c6e, 0x7cce,
        0x1c0c, 0x7ce4, 0x1ba9, 0x7cfa, 0x1b47, 0x7d0f, 0x1ae5, 0x7d25,
        0x1a83, 0x7d3a, 0x1a20, 0x7d4e, 0x19be, 0x7d63, 0x195b, 0x7d77,
        0x18f9, 0x7d8a, 0x1896, 0x7d9e, 0x1833, 0x7db1, 0x17d1, 0x7dc4,
        0x176e, 0x7dd6, 0x170b, 0x7de9, 0x16a8, 0x7dfb, 0x1645, 0x7e0c,
        0x15e2, 0x7e1e, 0x157f, 0x7e2f, 0x151c, 0x7e3f, 0x14b9, 0x7e50,
        0x1455, 0x7e60, 0x13f2, 0x7e70, 0x138f, 0x7e7f, 0x132b, 0x7e8e,
        0x12c8, 0x7e9d, 0x1265, 0x7eac, 0x1201, 0x7eba, 0x119e, 0x7ec8,
        0x113a, 0x7ed6, 0x10d6, 0x7ee3, 0x1073, 0x7ef0, 0x100f, 0x7efd,
        0x0fab, 0x7f0a, 0x0f47, 0x7f16, 0x0ee4, 0x7f22, 0x0e80, 0x7f2d,
        0x0e1c, 0x7f38, 0x0db8, 0x7f43, 0x0d54, 0x7f4e, 0x0cf0, 0x7f58,
        0x0c8c, 0x7f62, 0x0c28, 0x7f6c, 0x0bc4, 0x7f75, 0x0b60, 0x7f7e,
        0x0afb, 0x7f87, 0x0a97, 0x7f90, 0x0a33, 0x7f98, 0x09cf, 0x7fa0,
        0x096b, 0x7fa7, 0x0906, 0x7fae, 0x08a2, 0x7fb5, 0x083e, 0x7fbc,
        0x07d9, 0x7fc2, 0x0775, 0x7fc8, 0x0711, 0x7fce, 0x06ac, 0x7fd3,
        0x0648, 0x7fd9, 0x05e3, 0x7fdd, 0x057f, 0x7fe2, 0x051b, 0x7fe6,
        0x04b6, 0x7fea, 0x0452, 0x7fed, 0x03ed, 0x7ff1, 0x0389, 0x7ff4,
        0x0324, 0x7ff6, 0x02c0, 0x7ff8, 0x025b, 0x7ffa, 0x01f7, 0x7ffc,
        0x0192, 0x7ffe, 0x012e, 0x7fff, 0x00c9, 0x7fff, 0x0065, 0x7fff,
        0x0000, 0x7fff};

    const CFrac16 dfr16RFFTTwiddleTable2048br[]=
    {
        0x7fff, 0x0000, 0x0000, 0x7fff, 0x5a82, 0x5a82, 0xa57e, 0x5a82,
        0x7642, 0x30fc, 0xcf04, 0x7642, 0x30fc, 0x7642, 0x89be, 0x30fc,
        0x7d8a, 0x18f9, 0xe707, 0x7d8a, 0x471d, 0x6a6e, 0x9592, 0x471d,
        0x6a6e, 0x471d, 0xb8e3, 0x6a6e, 0x18f9, 0x7d8a, 0x8276, 0x18f9,
        0x7f62, 0x0c8c, 0xf374, 0x7f62, 0x5134, 0x62f2, 0x9d0e, 0x5134,
        0x70e3, 0x3c57, 0xc3a9, 0x70e3, 0x2528, 0x7a7d, 0x8583, 0x2528,
        0x7a7d, 0x2528, 0xdad8, 0x7a7d, 0x3c57, 0x70e3, 0x8f1d, 0x3c57,
        0x62f2, 0x5134, 0xaecc, 0x62f2, 0x0c8c, 0x7f62, 0x809e, 0x0c8c,
        0x7fd9, 0x0648, 0xf9b8, 0x7fd9, 0x55f6, 0x5ed7, 0xa129, 0x55f6,
        0x73b6, 0x36ba, 0xc946, 0x73b6, 0x2b1f, 0x7885, 0x877b, 0x2b1f,
        0x7c2a, 0x1f1a, 0xe0e6, 0x7c2a, 0x41ce, 0x6dca, 0x9236, 0x41ce,
        0x66d0, 0x4c40, 0xb3c0, 0x66d0, 0x12c8, 0x7e9d, 0x8163, 0x12c8,
        0x7e9d, 0x12c8, 0xed38, 0x7e9d, 0x4c40, 0x66d0, 0x9930, 0x4c40,
        0x6dca, 0x41ce, 0xbe32, 0x6dca, 0x1f1a, 0x7c2a, 0x83d6, 0x1f1a,
        0x7885, 0x2b1f, 0xd4e1, 0x7885, 0x36ba, 0x73b6, 0x8c4a, 0x36ba,
        0x5ed7, 0x55f6, 0xaa0a, 0x5ed7, 0x0648, 0x7fd9, 0x8027, 0x0648,
        0x7ff6, 0x0324, 0xfcdc, 0x7ff6, 0x5843, 0x5cb4, 0xa34c, 0x5843,
        0x7505, 0x33df, 0xcc21, 0x7505, 0x2e11, 0x776c, 0x8894, 0x2e11,
        0x7ce4, 0x1c0c, 0xe3f4, 0x7ce4, 0x447b, 0x6c24, 0x93dc, 0x447b,
        0x68a7, 0x49b4, 0xb64c, 0x68a7, 0x15e2, 0x7e1e, 0x81e2, 0x15e2,
        0x7f0a, 0x0fab, 0xf055, 0x7f0a, 0x4ec0, 0x64e9, 0x9b17, 0x4ec0,
        0x6f5f, 0x3f17, 0xc0e9, 0x6f5f, 0x2224, 0x7b5d, 0x84a3, 0x2224,
        0x798a, 0x2827, 0xd7d9, 0x798a, 0x398d, 0x7255, 0x8dab, 0x398d,
        0x60ec, 0x539b, 0xac65, 0x60ec, 0x096b, 0x7fa7, 0x8059, 0x096b,
        0x7fa7, 0x096b, 0xf695, 0x7fa7, 0x539b, 0x60ec, 0x9f14, 0x539b,
        0x7255, 0x398d, 0xc673, 0x7255, 0x2827, 0x798a, 0x8676, 0x2827,
        0x7b5d, 0x2224, 0xdddc, 0x7b5d, 0x3f17, 0x6f5f, 0x90a1, 0x3f17,
        0x64e9, 0x4ec0, 0xb140, 0x64e9, 0x0fab, 0x7f0a, 0x80f6, 0x0fab,
        0x7e1e, 0x15e2, 0xea1e, 0x7e1e, 0x49b4, 0x68a7, 0x9759, 0x49b4,
        0x6c24, 0x447b, 0xbb85, 0x6c24, 0x1c0c, 0x7ce4, 0x831c, 0x1c0c,
        0x776c, 0x2e11, 0xd1ef, 0x776c, 0x33df, 0x7505, 0x8afb, 0x33df,
        0x5cb4, 0x5843, 0xa7bd, 0x5cb4, 0x0324, 0x7ff6, 0x800a, 0x0324,
        0x7ffe, 0x0192, 0xfe6e, 0x7ffe, 0x5964, 0x5b9d, 0xa463, 0x5964,
        0x75a6, 0x326e, 0xcd92, 0x75a6, 0x2f87, 0x76d9, 0x8927, 0x2f87,
        0x7d3a, 0x1a83, 0xe57d, 0x7d3a, 0x45cd, 0x6b4b, 0x94b5, 0x45cd,
        0x698c, 0x486a, 0xb796, 0x698c, 0x176e, 0x7dd6, 0x822a, 0x176e,
        0x7f38, 0x0e1c, 0xf1e4, 0x7f38, 0x4ffb, 0x63ef, 0x9c11, 0x4ffb,
        0x7023, 0x3db8, 0xc248, 0x7023, 0x23a7, 0x7aef, 0x8511, 0x23a7,
        0x7a06, 0x26a8, 0xd958, 0x7a06, 0x3af3, 0x719e, 0x8e62, 0x3af3,
        0x61f1, 0x5269, 0xad97, 0x61f1, 0x0afb, 0x7f87, 0x8079, 0x0afb,
        0x7fc2, 0x07d9, 0xf827, 0x7fc2, 0x54ca, 0x5fe4, 0xa01c, 0x54ca,
        0x7308, 0x3825, 0xc7db, 0x7308, 0x29a4, 0x790a, 0x86f6, 0x29a4,
        0x7bc6, 0x209f, 0xdf61, 0x7bc6, 0x4074, 0x6e97, 0x9169, 0x4074,
        0x65de, 0x4d81, 0xb27f, 0x65de, 0x113a, 0x7ed6, 0x812a, 0x113a,
        0x7e60, 0x1455, 0xebab, 0x7e60, 0x4afb, 0x67bd, 0x9843, 0x4afb,
        0x6cf9, 0x4326, 0xbcda, 0x6cf9, 0x1d93, 0x7c89, 0x8377, 0x1d93,
        0x77fb, 0x2c99, 0xd367, 0x77fb, 0x354e, 0x7460, 0x8ba0, 0x354e,
        0x5dc8, 0x571e, 0xa8e2, 0x5dc8, 0x04b6, 0x7fea, 0x8016, 0x04b6,
        0x7fea, 0x04b6, 0xfb4a, 0x7fea, 0x571e, 0x5dc8, 0xa238, 0x571e,
        0x7460, 0x354e, 0xcab2, 0x7460, 0x2c99, 0x77fb, 0x8805, 0x2c99,
        0x7c89, 0x1d93, 0xe26d, 0x7c89, 0x4326, 0x6cf9, 0x9307, 0x4326,
        0x67bd, 0x4afb, 0xb505, 0x67bd, 0x1455, 0x7e60, 0x81a0, 0x1455,
        0x7ed6, 0x113a, 0xeec6, 0x7ed6, 0x4d81, 0x65de, 0x9a22, 0x4d81,
        0x6e97, 0x4074, 0xbf8c, 0x6e97, 0x209f, 0x7bc6, 0x843a, 0x209f,
        0x790a, 0x29a4, 0xd65c, 0x790a, 0x3825, 0x7308, 0x8cf8, 0x3825,
        0x5fe4, 0x54ca, 0xab36, 0x5fe4, 0x07d9, 0x7fc2, 0x803e, 0x07d9,
        0x7f87, 0x0afb, 0xf505, 0x7f87, 0x5269, 0x61f1, 0x9e0f, 0x5269,
        0x719e, 0x3af3, 0xc50d, 0x719e, 0x26a8, 0x7a06, 0x85fa, 0x26a8,
        0x7aef, 0x23a7, 0xdc59, 0x7aef, 0x3db8, 0x7023, 0x8fdd, 0x3db8,
        0x63ef, 0x4ffb, 0xb005, 0x63ef, 0x0e1c, 0x7f38, 0x80c8, 0x0e1c,
        0x7dd6, 0x176e, 0xe892, 0x7dd6, 0x486a, 0x698c, 0x9674, 0x486a,
        0x6b4b, 0x45cd, 0xba33, 0x6b4b, 0x1a83, 0x7d3a, 0x82c6, 0x1a83,
        0x76d9, 0x2f87, 0xd079, 0x76d9, 0x326e, 0x75a6, 0x8a5a, 0x326e,
        0x5b9d, 0x5964, 0xa69c, 0x5b9d, 0x0192, 0x7ffe, 0x8002, 0x0192,
        0x7fff, 0x00c9, 0xff37, 0x7fff, 0x59f4, 0x5b10, 0xa4f0, 0x59f4,
        0x75f4, 0x31b5, 0xce4b, 0x75f4, 0x3042, 0x768e, 0x8972, 0x3042,
        0x7d63, 0x19be, 0xe642, 0x7d63, 0x4675, 0x6add, 0x9523, 0x4675,
        0x69fd, 0x47c4, 0xb83c, 0x69fd, 0x1833, 0x7db1, 0x824f, 0x1833,
        0x7f4e, 0x0d54, 0xf2ac, 0x7f4e, 0x5098, 0x6371, 0x9c8f, 0x5098,
        0x7083, 0x3d08, 0xc2f8, 0x7083, 0x2467, 0x7ab7, 0x8549, 0x2467,
        0x7a42, 0x25e8, 0xda18, 0x7a42, 0x3ba5, 0x7141, 0x8ebf, 0x3ba5,
        0x6272, 0x51cf, 0xae31, 0x6272, 0x0bc4, 0x7f75, 0x808b, 0x0bc4,
        0x7fce, 0x0711, 0xf8ef, 0x7fce, 0x5560, 0x5f5e, 0xa0a2, 0x5560,
        0x735f, 0x3770, 0xc890, 0x735f, 0x2a62, 0x78c8, 0x8738, 0x2a62,
        0x7bf9, 0x1fdd, 0xe023, 0x7bf9, 0x4121, 0x6e31, 0x91cf, 0x4121,
        0x6657, 0x4ce1, 0xb31f, 0x6657, 0x1201, 0x7eba, 0x8146, 0x1201,
        0x7e7f, 0x138f, 0xec71, 0x7e7f, 0x4b9e, 0x6747, 0x98b9, 0x4b9e,
        0x6d62, 0x427a, 0xbd86, 0x6d62, 0x1e57, 0x7c5a, 0x83a6, 0x1e57,
        0x7840, 0x2bdc, 0xd424, 0x7840, 0x3604, 0x740b, 0x8bf5, 0x3604,
        0x5e50, 0x568a, 0xa976, 0x5e50, 0x057f, 0x7fe2, 0x801e, 0x057f,
        0x7ff1, 0x03ed, 0xfc13, 0x7ff1, 0x57b1, 0x5d3e, 0xa2c2, 0x57b1,
        0x74b3, 0x3497, 0xcb69, 0x74b3, 0x2d55, 0x77b4, 0x884c, 0x2d55,
        0x7cb7, 0x1cd0, 0xe330, 0x7cb7, 0x43d1, 0x6c8f, 0x9371, 0x43d1,
        0x6832, 0x4a58, 0xb5a8, 0x6832, 0x151c, 0x7e3f, 0x81c1, 0x151c,
        0x7ef0, 0x1073, 0xef8d, 0x7ef0, 0x4e21, 0x6564, 0x9a9c, 0x4e21,
        0x6efb, 0x3fc6, 0xc03a, 0x6efb, 0x2162, 0x7b92, 0x846e, 0x2162,
        0x794a, 0x28e5, 0xd71b, 0x794a, 0x38d9, 0x72af, 0x8d51, 0x38d9,
        0x6068, 0x5433, 0xabcd, 0x6068, 0x08a2, 0x7fb5, 0x804b, 0x08a2,
        0x7f98, 0x0a33, 0xf5cd, 0x7f98, 0x5303, 0x616f, 0x9e91, 0x5303,
        0x71fa, 0x3a40, 0xc5c0, 0x71fa, 0x2768, 0x79c9, 0x8637, 0x2768,
        0x7b27, 0x22e5, 0xdd1b, 0x7b27, 0x3e68, 0x6fc2, 0x903e, 0x3e68,
        0x646c, 0x4f5e, 0xb0a2, 0x646c, 0x0ee4, 0x7f22, 0x80de, 0x0ee4,
        0x7dfb, 0x16a8, 0xe958, 0x7dfb, 0x490f, 0x691a, 0x96e6, 0x490f,
        0x6bb8, 0x4524, 0xbadc, 0x6bb8, 0x1b47, 0x7d0f, 0x82f1, 0x1b47,
        0x7723, 0x2ecc, 0xd134, 0x7723, 0x3327, 0x7556, 0x8aaa, 0x3327,
        0x5c29, 0x58d4, 0xa72c, 0x5c29, 0x025b, 0x7ffa, 0x8006, 0x025b,
        0x7ffa, 0x025b, 0xfda5, 0x7ffa, 0x58d4, 0x5c29, 0xa3d7, 0x58d4,
        0x7556, 0x3327, 0xccd9, 0x7556, 0x2ecc, 0x7723, 0x88dd, 0x2ecc,
        0x7d0f, 0x1b47, 0xe4b9, 0x7d0f, 0x4524, 0x6bb8, 0x9448, 0x4524,
        0x691a, 0x490f, 0xb6f1, 0x691a, 0x16a8, 0x7dfb, 0x8205, 0x16a8,
        0x7f22, 0x0ee4, 0xf11c, 0x7f22, 0x4f5e, 0x646c, 0x9b94, 0x4f5e,
        0x6fc2, 0x3e68, 0xc198, 0x6fc2, 0x22e5, 0x7b27, 0x84d9, 0x22e5,
        0x79c9, 0x2768, 0xd898, 0x79c9, 0x3a40, 0x71fa, 0x8e06, 0x3a40,
        0x616f, 0x5303, 0xacfd, 0x616f, 0x0a33, 0x7f98, 0x8068, 0x0a33,
        0x7fb5, 0x08a2, 0xf75e, 0x7fb5, 0x5433, 0x6068, 0x9f98, 0x5433,
        0x72af, 0x38d9, 0xc727, 0x72af, 0x28e5, 0x794a, 0x86b6, 0x28e5,
        0x7b92, 0x2162, 0xde9e, 0x7b92, 0x3fc6, 0x6efb, 0x9105, 0x3fc6,
        0x6564, 0x4e21, 0xb1df, 0x6564, 0x1073, 0x7ef0, 0x8110, 0x1073,
        0x7e3f, 0x151c, 0xeae4, 0x7e3f, 0x4a58, 0x6832, 0x97ce, 0x4a58,
        0x6c8f, 0x43d1, 0xbc2f, 0x6c8f, 0x1cd0, 0x7cb7, 0x8349, 0x1cd0,
        0x77b4, 0x2d55, 0xd2ab, 0x77b4, 0x3497, 0x74b3, 0x8b4d, 0x3497,
        0x5d3e, 0x57b1, 0xa84f, 0x5d3e, 0x03ed, 0x7ff1, 0x800f, 0x03ed,
        0x7fe2, 0x057f, 0xfa81, 0x7fe2, 0x568a, 0x5e50, 0xa1b0, 0x568a,
        0x740b, 0x3604, 0xc9fc, 0x740b, 0x2bdc, 0x7840, 0x87c0, 0x2bdc,
        0x7c5a, 0x1e57, 0xe1a9, 0x7c5a, 0x427a, 0x6d62, 0x929e, 0x427a,
        0x6747, 0x4b9e, 0xb462, 0x6747, 0x138f, 0x7e7f, 0x8181, 0x138f,
        0x7eba, 0x1201, 0xedff, 0x7eba, 0x4ce1, 0x6657, 0x99a9, 0x4ce1,
        0x6e31, 0x4121, 0xbedf, 0x6e31, 0x1fdd, 0x7bf9, 0x8407, 0x1fdd,
        0x78c8, 0x2a62, 0xd59e, 0x78c8, 0x3770, 0x735f, 0x8ca1, 0x3770,
        0x5f5e, 0x5560, 0xaaa0, 0x5f5e, 0x0711, 0x7fce, 0x8032, 0x0711,
        0x7f75, 0x0bc4, 0xf43c, 0x7f75, 0x51cf, 0x6272, 0x9d8e, 0x51cf,
        0x7141, 0x3ba5, 0xc45b, 0x7141, 0x25e8, 0x7a42, 0x85be, 0x25e8,
        0x7ab7, 0x2467, 0xdb99, 0x7ab7, 0x3d08, 0x7083, 0x8f7d, 0x3d08,
        0x6371, 0x5098, 0xaf68, 0x6371, 0x0d54, 0x7f4e, 0x80b2, 0x0d54,
        0x7db1, 0x1833, 0xe7cd, 0x7db1, 0x47c4, 0x69fd, 0x9603, 0x47c4,
        0x6add, 0x4675, 0xb98b, 0x6add, 0x19be, 0x7d63, 0x829d, 0x19be,
        0x768e, 0x3042, 0xcfbe, 0x768e, 0x31b5, 0x75f4, 0x8a0c, 0x31b5,
        0x5b10, 0x59f4, 0xa60c, 0x5b10, 0x00c9, 0x7fff, 0x8001, 0x00c9};


