/** ###################################################################
**     Filename  : freemaster_demo_48pin.C
**     Project   : freemaster_demo_48pin
**     Processor : MC56F8006_48_LQFP
**     Version   : Driver 01.13
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 14.11.2008, 10:28
**     Abstract  :
**         Main module.
**         This module contains user's application code.
**     Settings  :
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SCI1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* include FreeMASTER Serial Driver functions */
#include "freemaster.h"

/* Test variables, will be displayed in the FreeMASTER application */
volatile UWord8  var8;
volatile UWord16 var16;
volatile UWord16 var16inc = 1;
volatile UWord32 var32;
volatile UWord32 var32inc = 100;


void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
  
  /* initialize FreeMASTER */
  FMSTR_Init();

  /* Enable CPU Interrupts */
  Cpu_EnableInt();
  
  while(1)
  {
  	/*
  	 * TODO: put your main-loop code here 
  	 *
  	 */

      /* scope variables */
      var16 += var16inc;
      var32 += var32inc;

      /* This call should be placed in the timer interrupt or anywhere where
       * the recorder sampling should occur.*/
      FMSTR_Recorder();

      /* The FreeMASTER polling call must be called periodically in the main 
       * application loop to handle the communication interface and protocol. 
       * Only in LONG_INTR FreeMASTER interrupt mode, all the processing is done 
       * during the communication interrupt so the FMSTR_Poll() is not needed
       * (the function is compiled empty in this case).*/
      FMSTR_Poll();

   }
}

/* END freemaster_demo */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
