/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : 56F8006_48_LQFP
**     Version   : Bean 01.016, Driver 02.01, CPU db: 3.00.177
**     Datasheet : MC56F8006RM,Rev. 0 Draft B,09/2007
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**
**     Settings  :
**
**     Contents  :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**         SetWaitMode - void Cpu_SetWaitMode(void);
**         SetStopMode - void Cpu_SetStopMode(void);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE Cpu. */
#include "LED1.h"
#include "Inhr6.h"
#include "LED2.h"
#include "Inhr5.h"
#include "LED3.h"
#include "Inhr4.h"
#include "LED4.h"
#include "Inhr3.h"
#include "LED5.h"
#include "Inhr2.h"
#include "LED6.h"
#include "Inhr1.h"
#include "TI1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile word SR_lock = 0;             /* Lock */
volatile word SR_reg;                  /* Current value of the SR register */
/*
** ===================================================================
**     Method      :  Cpu_Interrupt (bean 56F8006_48_LQFP)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  asm(DEBUGHLT);                       /* Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (bean 56F8006_48_LQFP)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (bean 56F8006_48_LQFP)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetStopMode (bean 56F8006_48_LQFP)
**
**     Description :
**         Sets low power mode - Stop mode.
**         For more information about the stop mode see this CPU
**         documentation.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetStopMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetWaitMode (bean 56F8006_48_LQFP)
**
**     Description :
**         Sets low power mode - Wait mode.
**         For more information about the wait mode see this CPU
**         documentation.
**         Release from wait mode: Reset or interrupt
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetWaitMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (bean 56F8006_48_LQFP)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);         /* Forward declaration of external startup function declared in startup file */

/*** !!! Here you can place your own code using property "User data declarations" on the build options tab. !!! ***/

void _EntryPoint(void)
{
  #pragma constarray off

  /*** !!! Here you can place your own code before PE initialization using property "User code before PE initialization" on the build options tab. !!! ***/

  /*** ### MC56F8006_48_LQFP "Cpu" init code ... ***/
  /*** PE initialization code after reset ***/
  /* System clock initialization */
  setRegBitGroup(OCCS_OCTRL, TRIM, (word)getReg(FM_OPT1) & 0x03FF); /* Set the trim osc freq with factory programmed value */
  setRegBit(OCCS_OCTRL, CLK_MODE);     /* Select an internal oscillator mode */
  clrRegBit(OCCS_CTRL, PRECS);         /* Select an internal clock source for the CPU core */
  setReg(OCCS_CTRL, (OCCS_CTRL_LCKON_MASK | OCCS_CTRL_ZSRC0_MASK)); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_DIVBY: LORTP=2,COD=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg16(OCCS_DIVBY, 0x2000);        /* Set the clock prescalers */ 
  while(!getRegBit(OCCS_STAT, LCK0)){} /* Wait for PLL lock */
  setReg(OCCS_CTRL, (OCCS_CTRL_LCKON_MASK | OCCS_CTRL_ZSRC1_MASK)); /* Select clock source from postscaler */
  /* FM_CLKDIV: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DIVLD=0,PRDIV8=0,DIV=0x28 */
  setReg16(FM_CLKDIV, 0x28);           /* Set the flash clock prescaler */ 
  /*** End of PE initialization code after reset ***/

  /*** !!! Here you can place your own code after PE initialization using property "User code after PE initialization" on the build options tab. !!! ***/

  setRegBit(SIM_PCE, COP);             /* Enable COP peripheral clocks */
  setReg(COP_CTRL, 0);                 /* Disable COP running after reset */
  clrRegBit(SIM_PCE, COP);             /* Disble COP peripheral clocks */
  asm(JMP init_56800_);                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (bean 56F8006_48_LQFP)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* GPIO_A_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_A_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOA pins according to the CPU bean settings */ 
  /* GPIO_B_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_B_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOB pins according to the CPU bean settings */ 
  /* GPIO_C_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_C_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOC pins according to the CPU bean settings */ 
  /* GPIO_D_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_D_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOD pins according to the CPU bean settings */ 
  /* GPIO_E_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_E_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOE pins according to the CPU bean settings */ 
  /* GPIO_F_DRIVE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIO_F_DRIVE, 0x00);        /* Set High/Low drive strength on GPIOF pins according to the CPU bean settings */ 
  /* GPIO_A_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE7=0,IFE6=0,IFE5=0,IFE4=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_A_IFE, 0x00);          /* Set the input filter on GPIOA pins according to the CPU bean settings */ 
  /* GPIO_B_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE7=0,IFE6=0,IFE5=0,IFE4=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_B_IFE, 0x00);          /* Set the input filter on GPIOB pins according to the CPU bean settings */ 
  /* GPIO_C_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE7=0,IFE6=0,IFE5=0,IFE4=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_C_IFE, 0x00);          /* Set the input filter on GPIOC pins according to the CPU bean settings */ 
  /* GPIO_D_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_D_IFE, 0x00);          /* Set the input filter on GPIOD pins according to the CPU bean settings */ 
  /* GPIO_E_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE7=0,IFE6=0,IFE5=0,IFE4=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_E_IFE, 0x00);          /* Set the input filter on GPIOE pins according to the CPU bean settings */ 
  /* GPIO_F_IFE: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IFE3=0,IFE2=0,IFE1=0,IFE0=0 */
  setReg16(GPIO_F_IFE, 0x00);          /* Set the input filter on GPIOF pins according to the CPU bean settings */ 
  /* GPIO_A_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW7=1,SLEW6=1,SLEW5=1,SLEW4=1,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_A_SLEW, 0xFF);         /* Set the input filter on GPIOA pins according to the CPU bean settings */ 
  /* GPIO_B_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW7=1,SLEW6=1,SLEW5=1,SLEW4=1,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_B_SLEW, 0xFF);         /* Set the input filter on GPIOB pins according to the CPU bean settings */ 
  /* GPIO_C_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW7=1,SLEW6=1,SLEW5=1,SLEW4=1,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_C_SLEW, 0xFF);         /* Set the input filter on GPIOC pins according to the CPU bean settings */ 
  /* GPIO_D_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_D_SLEW, 0x0F);         /* Set the input filter on GPIOD pins according to the CPU bean settings */ 
  /* GPIO_E_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW7=1,SLEW6=1,SLEW5=1,SLEW4=1,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_E_SLEW, 0xFF);         /* Set the input filter on GPIOE pins according to the CPU bean settings */ 
  /* GPIO_F_SLEW: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SLEW3=1,SLEW2=1,SLEW1=1,SLEW0=1 */
  setReg16(GPIO_F_SLEW, 0x0F);         /* Set the input filter on GPIOF pins according to the CPU bean settings */ 
  /* SIM_PCR: TMR_CR=0,??=0,PWM_CR=0,SCI_CR=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg16(SIM_PCR, 0x00);             /* Set the TMR; PWM; SCI module clock rates */ 
  /* SIM_PCE: CMP2=0,CMP1=0,CMP0=0,ADC1=0,ADC0=0,PGA1=0,PGA0=0,I2C=0,SCI=0,SPI=0,PWM=0,COP=0,PDB=0,PIT=0,TA1=1,TA0=1 */
  setReg16(SIM_PCE, 0x03);             /* Set up the peripheral clock enable register */ 
  /* SIM_SDR: CMP2=0,CMP1=0,CMP0=0,ADC1=0,ADC0=0,PGA1=0,PGA0=0,I2C=0,SCI=0,SPI=0,PWM=0,COP=0,PDB=0,PIT=0,TA1=0,TA0=0 */
  setReg16(SIM_SDR, 0x00);             /* Set up the STOP disable register */ 
  /* SIM_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,ONCEEBL=0,SWRST=0,STOP_DISABLE=0,WAIT_DISABLE=0 */
  setReg16(SIM_CTRL, 0x00);            /* Set up the SIM control register */ 
  /* SIM_CLKOUT: ??=0,??=0,CLKDIS1=1,??=0,??=0,CLKOSEL1=0,??=0,??=0,CLKDIS0=1,CLKOSEL0=0 */
  setReg16(SIM_CLKOUT, 0x2020);        /* Set up the SIM clock output select register */ 
  /* PMC_SCR: OORF=0,LVDF=0,PPDF=0,PORF=0,OORIE=0,LVDIE=0,LVDRE=1,PPDE=0,LPR=0,LPRS=0,LPWUI=0,BGBE=0,LVDE=0,LVLS=0,PROT=0 */
  setReg16(PMC_SCR, 0x0200);            
  /* Common initialization of the CPU registers */
  /* GPIO_A_IENR: IEN5=0,IEN4=0,IEN3=0,IEN2=0,IEN1=0,IEN0=0 */
  clrReg16Bits(GPIO_A_IENR, 0x3F);      
  /* GPIO_A_IESR: IES5=1,IES4=1,IES3=1,IES2=1,IES1=1,IES0=1 */
  setReg16Bits(GPIO_A_IESR, 0x3F);      
  /* GPIO_A_DR: D5=0,D4=0,D3=0,D2=0,D1=0,D0=0 */
  clrReg16Bits(GPIO_A_DR, 0x3F);        
  /* GPIO_A_DDR: DD5=1,DD4=1,DD3=1,DD2=1,DD1=1,DD0=1 */
  setReg16Bits(GPIO_A_DDR, 0x3F);       
  /* GPIO_A_PER: PE5=0,PE4=0,PE3=0,PE2=0,PE1=0,PE0=0 */
  clrReg16Bits(GPIO_A_PER, 0x3F);       
  /* TMR_ENBL: ENBL&=~3 */
  clrReg16Bits(TMR_ENBL, 0x03);         
  /* ### TimerInt "TI1" init code ... */
  TI1_Init();
 /* Common peripheral initialization - ENABLE */
  /* TMR_ENBL: ENBL|=3 */
  setReg16Bits(TMR_ENBL, 0x03);         
  __EI(0);                             /* Enable interrupts of the selected priority level */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
