/** ###################################################################
**     Filename  : Events.C
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : Events
**     Version   : Driver 01.03
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         TI1_OnInterrupt - void TI1_OnInterrupt(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

int count = 0 ;   // use this count to determine what bits to toggle;
                  // increment the count and do the toggle at the isr
                  // of the timer.

/*
** ===================================================================
**     Event       :  TI1_OnInterrupt (module Events)
**
**     From bean   :  TI1 [TimerInt]
**     Description :
**         When a timer interrupt occurs this event is called (only
**         when the bean is enabled - <Enable> and the events are
**         enabled - <EnableEvent>). This event is enabled only if a
**         <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void TI1_OnInterrupt(void)
{
  /* Write your code here ... */
  if (count&1) 
   LED1_Toggle();
  if (count&2) 
   LED2_Toggle();
  if (count&4) 
   LED3_Toggle();
  if (count&8) 
   LED4_Toggle();
  if (count&16) 
   LED5_Toggle();
  if (count&32) 
   LED6_Toggle(); // try putting a breakpoint here while the program runs
  count++ ;
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
