/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : LED1.H
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : Led
**     Version   : Bean 01.007, Driver 01.05, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**          This bean provide methods for driving of LED device.
**          Methods On, Off, Set and Toggle (or only initialization code)
**          could be used to drive it. Output value, defined by Init.
**          value property, is used for initialization implicitly.
**          It is not necessary to use any method explicitly in start up.
**          Method Status return current status of the LED device.
**          LED drivers without output inverter are supported
**          via Inverted value property.
**     Settings  :
**          Output PIN                                     :GPIOA0_PWM0
**          Initialize Value                               :Off
**          Inverted Value                                 :no
**     Contents  :
**         On         - void LED1_On(void);
**         Off        - void LED1_Off(void);
**         Toggle     - void LED1_Toggle(void);
**         Set        - void LED1_Set(bool Output);
**         Status     - bool LED1_Status(void);
**         ConnectPin - void LED1_ConnectPin(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __LED1
#define __LED1

/* MODULE LED1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */
#include "Inhr6.h"

#include "Cpu.h"


#define LED1_On() Inhr6_SetVal()
/*
** ===================================================================
**     Method      :  LED1_On (bean Led)
**
**     Description :
**         Switch ON the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED1_Off() Inhr6_ClrVal()
/*
** ===================================================================
**     Method      :  LED1_Off (bean Led)
**
**     Description :
**         Switch OFF the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED1_Toggle() Inhr6_NegVal()
/*
** ===================================================================
**     Method      :  LED1_Toggle (bean Led)
**
**     Description :
**         Toggle the LED device value
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED1_Set(Output) Inhr6_PutVal(Output)
/*
** ===================================================================
**     Method      :  LED1_Set (bean Led)
**
**     Description :
**         Put the specified value to the LED
**     Parameters  :
**         NAME            - DESCRIPTION
**         Output          - Set LED status (ON/OFF) accordant
**                           with the 'Output' value
**                           TRUE - Turn the LED ON
**                           FALSE - Turn the LED OFF
**     Returns     : Nothing
** ===================================================================
*/

bool LED1_Status(void);
#define LED1_Status() Inhr6_GetVal()
/*
** ===================================================================
**     Method      :  LED1_Status (bean Led)
**
**     Description :
**         Return the last written value of the LED device
**     Parameters  : None
**     Returns     :
**         ---             - The last written value of the LED
**                           device.
**                           TRUE - The LED is ON
**                           FALSE - The LED is OFF
** ===================================================================
*/

#define LED1_ConnectPin Inhr6_ConnectPin
/*
** ===================================================================
**     Method      :  LED1_ConnectPin (bean Led)
**
**     Description :
**         This method reconnects selected pin in this bean. This
**         method is available only for CPU derivatives and
**         peripherals that support runtime pin sharing with other
**         internal on-chip peripherals.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END LED1. */

#endif /* ifndef __LED1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
