/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : LED3.H
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : Led
**     Version   : Bean 01.007, Driver 01.05, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**          This bean provide methods for driving of LED device.
**          Methods On, Off, Set and Toggle (or only initialization code)
**          could be used to drive it. Output value, defined by Init.
**          value property, is used for initialization implicitly.
**          It is not necessary to use any method explicitly in start up.
**          Method Status return current status of the LED device.
**          LED drivers without output inverter are supported
**          via Inverted value property.
**     Settings  :
**          Output PIN                                     :GPIOA2_PWM2
**          Initialize Value                               :Off
**          Inverted Value                                 :no
**     Contents  :
**         On         - void LED3_On(void);
**         Off        - void LED3_Off(void);
**         Toggle     - void LED3_Toggle(void);
**         Set        - void LED3_Set(bool Output);
**         Status     - bool LED3_Status(void);
**         ConnectPin - void LED3_ConnectPin(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __LED3
#define __LED3

/* MODULE LED3. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */
#include "Inhr4.h"

#include "Cpu.h"


#define LED3_On() Inhr4_SetVal()
/*
** ===================================================================
**     Method      :  LED3_On (bean Led)
**
**     Description :
**         Switch ON the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED3_Off() Inhr4_ClrVal()
/*
** ===================================================================
**     Method      :  LED3_Off (bean Led)
**
**     Description :
**         Switch OFF the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED3_Toggle() Inhr4_NegVal()
/*
** ===================================================================
**     Method      :  LED3_Toggle (bean Led)
**
**     Description :
**         Toggle the LED device value
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED3_Set(Output) Inhr4_PutVal(Output)
/*
** ===================================================================
**     Method      :  LED3_Set (bean Led)
**
**     Description :
**         Put the specified value to the LED
**     Parameters  :
**         NAME            - DESCRIPTION
**         Output          - Set LED status (ON/OFF) accordant
**                           with the 'Output' value
**                           TRUE - Turn the LED ON
**                           FALSE - Turn the LED OFF
**     Returns     : Nothing
** ===================================================================
*/

bool LED3_Status(void);
#define LED3_Status() Inhr4_GetVal()
/*
** ===================================================================
**     Method      :  LED3_Status (bean Led)
**
**     Description :
**         Return the last written value of the LED device
**     Parameters  : None
**     Returns     :
**         ---             - The last written value of the LED
**                           device.
**                           TRUE - The LED is ON
**                           FALSE - The LED is OFF
** ===================================================================
*/

#define LED3_ConnectPin Inhr4_ConnectPin
/*
** ===================================================================
**     Method      :  LED3_ConnectPin (bean Led)
**
**     Description :
**         This method reconnects selected pin in this bean. This
**         method is available only for CPU derivatives and
**         peripherals that support runtime pin sharing with other
**         internal on-chip peripherals.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END LED3. */

#endif /* ifndef __LED3 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
