/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : LED6.H
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : Led
**     Version   : Bean 01.007, Driver 01.05, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**          This bean provide methods for driving of LED device.
**          Methods On, Off, Set and Toggle (or only initialization code)
**          could be used to drive it. Output value, defined by Init.
**          value property, is used for initialization implicitly.
**          It is not necessary to use any method explicitly in start up.
**          Method Status return current status of the LED device.
**          LED drivers without output inverter are supported
**          via Inverted value property.
**     Settings  :
**          Output PIN                                     :GPIOA5_PWM5_FAULT2_EXT_SYNC_TIN3
**          Initialize Value                               :Off
**          Inverted Value                                 :no
**     Contents  :
**         On         - void LED6_On(void);
**         Off        - void LED6_Off(void);
**         Toggle     - void LED6_Toggle(void);
**         Set        - void LED6_Set(bool Output);
**         Status     - bool LED6_Status(void);
**         ConnectPin - void LED6_ConnectPin(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __LED6
#define __LED6

/* MODULE LED6. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */
#include "Inhr1.h"

#include "Cpu.h"


#define LED6_On() Inhr1_SetVal()
/*
** ===================================================================
**     Method      :  LED6_On (bean Led)
**
**     Description :
**         Switch ON the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED6_Off() Inhr1_ClrVal()
/*
** ===================================================================
**     Method      :  LED6_Off (bean Led)
**
**     Description :
**         Switch OFF the LED device
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED6_Toggle() Inhr1_NegVal()
/*
** ===================================================================
**     Method      :  LED6_Toggle (bean Led)
**
**     Description :
**         Toggle the LED device value
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define LED6_Set(Output) Inhr1_PutVal(Output)
/*
** ===================================================================
**     Method      :  LED6_Set (bean Led)
**
**     Description :
**         Put the specified value to the LED
**     Parameters  :
**         NAME            - DESCRIPTION
**         Output          - Set LED status (ON/OFF) accordant
**                           with the 'Output' value
**                           TRUE - Turn the LED ON
**                           FALSE - Turn the LED OFF
**     Returns     : Nothing
** ===================================================================
*/

bool LED6_Status(void);
#define LED6_Status() Inhr1_GetVal()
/*
** ===================================================================
**     Method      :  LED6_Status (bean Led)
**
**     Description :
**         Return the last written value of the LED device
**     Parameters  : None
**     Returns     :
**         ---             - The last written value of the LED
**                           device.
**                           TRUE - The LED is ON
**                           FALSE - The LED is OFF
** ===================================================================
*/

#define LED6_ConnectPin Inhr1_ConnectPin
/*
** ===================================================================
**     Method      :  LED6_ConnectPin (bean Led)
**
**     Description :
**         This method reconnects selected pin in this bean. This
**         method is available only for CPU derivatives and
**         peripherals that support runtime pin sharing with other
**         internal on-chip peripherals.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END LED6. */

#endif /* ifndef __LED6 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
