/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : TI1.C
**     Project   : MC56F8006_LED_LAB
**     Processor : MC56F8006_48_LQFP
**     Beantype  : TimerInt
**     Version   : Bean 02.157, Driver 02.00, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 1/12/2009, 1:28 PM
**     Abstract  :
**         This bean "TimerInt" implements a periodic interrupt.
**         When the bean and its events are enabled, the "OnInterrupt"
**         event is called periodically with the period that you specify.
**         TimerInt supports also changing the period in runtime.
**         The source of periodic interrupt can be timer compare or reload
**         register or timer-overflow interrupt (of free running counter).
**     Settings  :
**         Timer name                  : TMR01 (32-bit)
**         Compare name                : TMR01_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 32000000 Hz
**           Initial period/frequency
**             Xtal ticks              : 512000
**             microseconds            : 64000
**             milliseconds            : 64
**             seconds (real)          : 0.064
**             Hz                      : 16
**
**         Runtime setting             : none
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMR1_CNTR [F015]
**              Mode                   : TMR1_CTRL [F016]
**              Run                    : TMR1_CTRL [F016]
**              Prescaler              : TMR1_CTRL [F016]
**
**         Compare registers
**              Compare                : TMR1_COMP1 [F010]
**
**         Flip-flop registers
**              Mode                   : TMR1_SCTRL [F017]
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE TI1. */

#include "Events.h"
#include "TI1.h"



/* Internal method prototypes */
static void SetCV(word Val0, word Val1);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (bean TimerInt)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val0, word Val1)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMR1_CMPLD1,Val1);            /* Store given value to the compare preload registers */
  setReg(TMR0_CMPLD1,Val0);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (bean TimerInt)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setRegBitGroup(TMR0_CTRL,PCS,Val);   /* Store given value to the prescaler */
  setReg(TMR0_CNTR,0);                 /* Reset counter */
  setReg(TMR1_CNTR,0);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  TI1_Init (bean TimerInt)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TI1_Init(void)
{
  /* TMR0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,Co_INIT=0,OM=0 */
  setReg(TMR0_CTRL,0x20);              /* Stop all functions of the timer */
  /* TMR1_CTRL: CM=7,PCS=4,SCS=0,ONCE=0,LENGTH=1,DIR=0,Co_INIT=0,OM=0 */
  setReg(TMR1_CTRL,0xE820);            /* Set up cascade counter mode */
  /* TMR1_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMR1_SCTRL,0x00);
  /* TMR0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMR0_SCTRL,0x00);
  setReg(TMR1_CNTR,0x00);              /* Reset counter register */
  setReg(TMR0_CNTR,0x00);
  setReg(TMR1_LOAD,0x00);              /* Reset load register */
  setReg(TMR0_LOAD,0x00);
  setReg(TMR1_COMP1,0x1F);             /* Set up compare 1 register */
  setReg(TMR0_COMP1,0xF9FF);
  /* TMR1_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,??=0,??=0,??=0,??=0,TCF2EN=0,TCF1EN=1,TCF2=0,TCF1=0,CL2=0,CL1=1 */
  setReg(TMR1_CSCTRL,0x41);            /* Enable compare 1 interrupt */
  /* TMR0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,??=0,??=0,??=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=1 */
  setReg(TMR0_CSCTRL,0x01);
  SetCV((word)0xF9FF,(word)0x1F);      /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x08);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMR0_CTRL,CM,0x01);   /* Run counter */
}

/*
** ===================================================================
**     Method      :  TI1_Interrupt (bean TimerInt)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void TI1_Interrupt(void)
{
  clrRegBit(TMR1_CSCTRL,TCF1);         /* Reset interrupt request flag */
  TI1_OnInterrupt();                   /* Invoke user event */
}

/* END TI1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
