/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Inhr1.C
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Beantype  : AsynchroSerial
**     Version   : Bean 02.455, Driver 02.01, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/26/2008, 3:06 PM
**     Abstract  :
**         This bean "AsynchroSerial" implements an asynchronous serial
**         communication. The bean supports different settings of
**         parity, word width, stop-bit and communication speed,
**         user can select interrupt or polling handler.
**         Communication speed can be changed also in runtime.
**         The bean requires one on-chip asynchronous serial channel.
**     Settings  :
**         Serial channel              : SCI
**
**         Protocol
**             Init baud rate          : 9600baud
**             Width                   : 8 bits
**             Stop bits               : 1
**             Parity                  : none
**             Breaks                  : Disabled
**             Input buffer size       : 0
**             Output buffer size      : 0
**
**         Registers
**             Input buffer            : SCI_DATA  [F0E4]
**             Output buffer           : SCI_DATA  [F0E4]
**             Control register        : SCI_CTRL1 [F0E1]
**             Mode register           : SCI_CTRL1 [F0E1]
**             Baud setting reg.       : SCI_RATE  [F0E0]
**
**         Input interrupt
**             Vector name             : INT_SCI_Rx_Full_Over_Error
**             Priority                : 0
**
**         Output interrupt
**             Vector name             : INT_SCI_Tx_Empty_Idle
**             Priority                : 0
**
**         Used pins:
**         ----------------------------------------------------------
**           Function | On package           |    Name
**         ----------------------------------------------------------
**            Input   |     1                |  GPIOB6_ANA13_SDA_RXD_CMP0_P2_CLKIN
**            Output  |     3                |  GPIOB7_ANA11_SCL_TXD_CMP2_M3
**         ----------------------------------------------------------
**
**
**
**     Contents  :
**         RecvChar - byte Inhr1_RecvChar(Inhr1_TComData *Chr);
**         SendChar - byte Inhr1_SendChar(Inhr1_TComData Chr);
**         GetError - byte Inhr1_GetError(Inhr1_TError *Err);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE Inhr1. */

#include "Inhr1.h"
#include "PC_M1.h"


#define OVERRUN_ERR      0x01          /* Overrun error flag bit    */
#define FRAMING_ERR      0x02          /* Framing error flag bit    */
#define PARITY_ERR       0x04          /* Parity error flag bit     */
#define CHAR_IN_RX       0x08          /* Char is in RX buffer      */
#define FULL_TX          0x10          /* Full transmit buffer      */
#define RUNINT_FROM_TX   0x20          /* Interrupt is in progress  */
#define FULL_RX          0x40          /* Full receive buffer       */
#define NOISE_ERR        0x80          /* Noise erorr flag bit      */
#define IDLE_ERR         0x0100        /* Idle character flag bit   */
#define BREAK_ERR        0x0200        /* Break detect              */

static word SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Framing error */
                                       /*       2 - Parity error */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Running int from TX */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Noise error */
                                       /*       8 - Idle character  */
                                       /*       9 - Break detected  */
                                       /*      10 - Unused */
                                       /*      11 - Unused */
static word ErrFlag;                   /* Error flags mirror of SerFlag */
static Inhr1_TComData BufferRead;      /* Input char for SCI commmunication */

/*
** ===================================================================
**     Method      :  HWEnDi (bean AsynchroSerial)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  getReg(SCI_STAT);                    /* Reset interrupt request flags */
  setRegBits(SCI_CTRL1, (SCI_CTRL1_TE_MASK | SCI_CTRL1_RE_MASK | SCI_CTRL1_RFIE_MASK | SCI_CTRL1_REIE_MASK)); /* Enable device */
}

/*
** ===================================================================
**     Method      :  Inhr1_RecvChar (bean AsynchroSerial)
**
**     Description :
**         If any data is received, this method returns one
**         character, otherwise it returns an error code (it does
**         not wait for data). This method is enabled only if the
**         receiver property is enabled.
**         [Note:] Because the preferred method to handle error and
**         break exception in the interrupt mode is to use events
**         <OnError> and <OnBreak> the return value ERR_RXEMPTY has
**         higher priority than other error codes. As a consequence
**         the information about an exception in interrupt mode is
**         returned only if there is a valid character ready to be
**         read.
**         Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and
**         the receiver is configured to use DMA controller then
**         this method only sets the selected DMA channel. Then the
**         status of the DMA transfer can be checked using
**         GetCharsInRxBuf method. See an example of a typical usage
**         for details about the communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Pointer to a received character
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_BREAK - Break character is detected
**                           (only when the <Interrupt service>
**                           property is disabled and the <Break
**                           signal> property is enabled)
**                           ERR_COMMON - common error occurred (the
**                           <GetError> method can be used for error
**                           specification)
**                           Version specific information for
**                           Freescale 56800 derivatives ] 
**                           DMA mode:
**                           If DMA controller is available on the
**                           selected CPU and the receiver is
**                           configured to use DMA controller then
**                           only ERR_OK, ERR_RXEMPTY, and ERR_SPEED
**                           error code can be returned from this
**                           method.
** ===================================================================
*/
byte Inhr1_RecvChar(Inhr1_TComData *Chr)
{
  register byte Result = ERR_OK;       /* Return error code */

  if (!(SerFlag & CHAR_IN_RX)) {       /* Is any char in RX buffer? */
    return ERR_RXEMPTY;                /* If no then error */
  }
  EnterCritical();                     /* Disable global interrupts */
  *Chr = BufferRead;                   /* Received char */
  Result = (byte)((SerFlag & (OVERRUN_ERR|FRAMING_ERR|PARITY_ERR|NOISE_ERR))? ERR_COMMON : ERR_OK);
  SerFlag &= ~(OVERRUN_ERR|FRAMING_ERR|PARITY_ERR|NOISE_ERR|CHAR_IN_RX); /* Clear all errors in the status variable */
  ExitCritical();                      /* Enable global interrupts */
  return Result;                       /* Return error code */
}

/*
** ===================================================================
**     Method      :  Inhr1_SendChar (bean AsynchroSerial)
**
**     Description :
**         Sends one character to the channel. If the bean is
**         temporarily disabled (Disable method) SendChar method
**         only stores data into an output buffer. In case of a zero
**         output buffer size, only one character can be stored.
**         Enabling the bean (Enable method) starts the transmission
**         of the stored data. This method is available only if the
**         transmitter property is enabled.
**         Version specific information for Freescale 56800
**         derivatives ] 
**         DMA mode:
**         If DMA controller is available on the selected CPU and
**         the transmitter is configured to use DMA controller then
**         this method only sets selected DMA channel. Then the
**         status of the DMA transfer can be checked using
**         GetCharsInTxBuf method. See an example of a typical usage
**         for details about communication using DMA.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_TXFULL - Transmitter is full
** ===================================================================
*/
byte Inhr1_SendChar(Inhr1_TComData Chr)
{
  if (SerFlag & FULL_TX) {             /* Is any char is in TX buffer */
    return ERR_TXFULL;                 /* If yes then error */
  }
  EnterCritical();                     /* Disable global interrupts */
  getReg(SCI_STAT);                    /* Reset interrupt request flags */
  setReg(SCI_DATA, Chr);               /* Store char to transmitter register */
  setRegBit(SCI_CTRL1, TEIE);          /* Enable transmit interrupt */
  SerFlag |= FULL_TX;                  /* Set the flag "full TX buffer" */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Inhr1_GetError (bean AsynchroSerial)
**
**     Description :
**         Returns a set of errors on the channel (errors that
**         cannot be returned by given methods). The errors
**         accumulate in a set; after calling [GetError] this set is
**         returned and cleared.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Err             - Pointer to the returned set of errors
**     Returns     :
**         ---             - Error code (if GetError did not succeed),
**                           possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Inhr1_GetError(Inhr1_TError *Err)
{
  EnterCritical();                     /* Disable global interrupts */
  Err->err = 0;
  Err->errName.OverRun = ((ErrFlag & OVERRUN_ERR) != 0x00); /* Overrun error */
  Err->errName.Framing = ((ErrFlag & FRAMING_ERR ) != 0x00); /* Framing error */
  Err->errName.Parity = ((ErrFlag & PARITY_ERR) != 0x00); /* Parity error */
  Err->errName.Noise = ((ErrFlag & NOISE_ERR) != 0x00); /* Noise error */
  ErrFlag = 0;                         /* Clear error flags */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Inhr1_InterruptRx (bean AsynchroSerial)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_ERROR    1
#define ON_FULL_RX  2
#define ON_RX_CHAR  4
#pragma interrupt alignsp saveall
void Inhr1_InterruptRx(void)
{
  register Inhr1_TComData Data;        /* Temporary variable for data */
  register word OnFlags = 0x00;        /* Temporary variable for flags */
  register word StatReg = getReg(SCI_STAT); /* Read status register */

  if (StatReg & (SCI_STAT_OR_MASK|SCI_STAT_NF_MASK|SCI_STAT_FE_MASK|SCI_STAT_PF_MASK)) { /* Is any error flag set? */
    setReg(SCI_STAT, 0x00);            /* Reset error request flags */
    if (StatReg & SCI_STAT_OR_MASK) {  /* Is overrun error flag set? */
      OnFlags |= OVERRUN_ERR;          /* If yes then set the flag */
    }
    if (StatReg & SCI_STAT_NF_MASK) {  /* Is noise error flag set? */
      OnFlags |= NOISE_ERR;            /* If yes then set the flag */
    }
    if (StatReg & SCI_STAT_FE_MASK) {  /* Is framing error flag set? */
      OnFlags |= FRAMING_ERR;          /* If yes then set the flag */
    }
    if (StatReg & SCI_STAT_PF_MASK) {  /* Is parity error flag set? */
      OnFlags |= PARITY_ERR;           /* If yes then set the flag */
    }
    SerFlag |= OnFlags;                /* Copy flags status to SerFlag status variable */
    ErrFlag |= OnFlags;                /* Copy flags status to ErrFlag status variable */
    __EI(3);                           /* Enable interrupts of the selected priority level */
    Inhr1_OnError();                   /* If yes then invoke user event */
  }
  if (StatReg & SCI_STAT_RDRF_MASK) {  /* Is the receiver interrupt flag set? */
    Data = (Inhr1_TComData)getReg(SCI_DATA); /* Read data from the receiver */
    if (SerFlag & CHAR_IN_RX) {        /* Is any char already present in the receive buffer? */
      SerFlag |= OVERRUN_ERR;          /* If yes then set flag OVERRUN_ERR */
    }
    SerFlag |= CHAR_IN_RX;             /* Set flag "char in RX buffer" */
    if (!(SerFlag & OVERRUN_ERR )) {   /* Is an overrun detected? */
      BufferRead = Data;
      OnFlags |= ON_RX_CHAR;           /* Set flag "OnRxChar" */
    }
    else {
      OnFlags |= ON_ERROR;             /* Set flag "OnError" */
    }
    ErrFlag |= SerFlag;                /* Add new error flags into the ErrorFlag status variable */
    if (OnFlags & ON_ERROR) {          /* Was error flag detect? */
       __EI(3);                        /* Enable interrupts of the selected priority level */
      Inhr1_OnError();                 /* If yes then invoke user event */
    }
    else {
      if (OnFlags & ON_RX_CHAR) {      /* Is OnRxChar flag set? */
         __EI(3);                      /* Enable interrupts of the selected priority level */
        Inhr1_OnRxChar();              /* If yes then invoke user event */
      }
    }
  }
}

/*
** ===================================================================
**     Method      :  Inhr1_InterruptTx (bean AsynchroSerial)
**
**     Description :
**         The method services the receive interrupt of the selected 
**         peripheral(s) and eventually invokes the bean's event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define ON_FREE_TX  1
#define ON_TX_CHAR  2
#pragma interrupt alignsp saveall
void Inhr1_InterruptTx(void)
{
  register word OnFlags = 0x00;        /* Temporary variable for flags */

  if (SerFlag & FULL_TX) {             /* Is any char already present in the transmit buffer? */
    OnFlags |= ON_TX_CHAR;             /* Set flag "OnTxChar" */
  }
  SerFlag &= ~FULL_TX;                 /* Reset flag "full TX buffer" */
  clrRegBit(SCI_CTRL1, TEIE);          /* Disable transmit interrupt */
  ErrFlag |= SerFlag;                  /* Add new error flags into the ErrorFlag status variable */
  if (OnFlags & ON_TX_CHAR) {          /* Is flag "OnTxChar" set? */
    __EI(3);                           /* Enable interrupts of the selected priority level */
    Inhr1_OnTxChar();                  /* If yes then invoke user event */
  }
}

/*
** ===================================================================
**     Method      :  Inhr1_Init (bean AsynchroSerial)
**
**     Description :
**         Initializes the associated peripheral(s) and the bean internal 
**         variables. The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Inhr1_Init(void)
{
  SerFlag = 0x00;                      /* Reset flags */
  /* SCI_CTRL1: LOOP=0,SWAI=0,RSRC=0,M=0,WAKE=0,POL=0,PE=0,PT=0,TEIE=0,TIIE=0,RFIE=0,REIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  setReg(SCI_CTRL1, 0x00);             /* Set the SCI configuration */
  /* SCI_RATE: SBR=0xD0,FRAC_SBR=3 */
  setReg(SCI_RATE, 0x0683);            /* Set prescaler bits */
  HWEnDi();                            /* Enable/disable device according to status flags */
}


/* END Inhr1. */


/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
