/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : PC_M1.H
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Beantype  : PC_Master
**     Version   : Bean 01.036, Driver 01.15, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/26/2008, 3:06 PM
**     Abstract  :
**          The PC master software application is a software tool initially created
**          for developers of Motor Control applications but it may be extended to any
**          application development. This tool allows control of an application remotely
**          from a user-friendly graphical environment running on a PC.
**     Settings  :
**          AsynchroSerial                       : Inhr1
**
**          Initialization:
**              Recorder buffer length           : 40
**              Command buffer length            : 4
**              Data buffer size                 : 60
**              Recorder timebase                : 32816
**              Board firmware major number      : 0
**              Board firmware minor number      : 0
**              Device identification string     : PC Master communication !
**     Contents  :
**         pcmasterdrvInit - Word16 PC_M1_pcmasterdrvInit(sPCMasterComm *p_sPCMasterComm);
**         pcmasterdrvIsr  - void PC_M1_pcmasterdrvIsr(void);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __PC_M1
#define __PC_M1

/* MODULE PC_M1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited beans */
#include "Inhr1.h"
#include "Cpu.h"


/* set configuration of PC Master */
/*-----------------
  standard commands
  -----------------*/
#define PCMDRV_CMD_READMEM          0x01 /* read block of memory */
#define PCMDRV_CMD_WRITEMEM         0x02 /* write block of memory */
#define PCMDRV_CMD_WRITEMEMMASK     0x03 /* write block of memory with mask */
#define PCMDRV_CMD_READMEMEX        0x04 /* v3+ */
#define PCMDRV_CMD_WRITEMEMEX       0x05 /* v3+ */
#define PCMDRV_CMD_WRITEMEMMASKEX   0x06 /* v3+ */
#define PCMDRV_CMD_SETUPSCOPE       0x08 /* setup scope */
#define PCMDRV_CMD_SETUPREC         0x09 /* setup recorder */
#define PCMDRV_CMD_SETUPSCOPEEX     0x0A /* v3+ */
#define PCMDRV_CMD_SETUPRECEX       0x0B /* v3+ */
#define PCMDRV_CMD_CALLAPPCMD       0x10 /* call user application command */

/*-----------------
   special commands
  -----------------*/
/* no data part */
#define PCMDRV_CMD_GETINFO          0xC0 /* get system information */
#define PCMDRV_CMD_STARTREC         0xC1 /* start recorder */
#define PCMDRV_CMD_STOPREC          0xC2 /* stop recorder */
#define PCMDRV_CMD_GETRECSTS        0xC3 /* get recorder status */
#define PCMDRV_CMD_GETRECBUFF       0xC4 /* get recorder buffer information */
#define PCMDRV_CMD_READSCOPE        0xC5 /* read scope variables */
#define PCMDRV_CMD_GETAPPCMDSTS     0xC6 /* get user application command status */
#define PCMDRV_CMD_GETINFOBRIEF     0xC8 /* v2+ get brief system information */
#define PCMDRV_CMD_GETRECBUFFEX     0xC9 /* v3+ */
/* 2 bytes data part */
#define PCMDRV_CMD_READVAR8         0xD0 /* read 8-bit variable from 16-bit address */
#define PCMDRV_CMD_READVAR16        0xD1 /* read 16-bit variable from 16-bit address */
#define PCMDRV_CMD_READVAR32        0xD2 /* read 32-bit variable from 16-bit address */
/* 4 bytes data part */
#define PCMDRV_CMD_READVAR8EX       0xE0 /* read 8-bit variable from 32-bit address */
#define PCMDRV_CMD_READVAR16EX      0xE1 /* read 16-bit variable from 32-bit address */
#define PCMDRV_CMD_READVAR32EX      0xE2 /* read 32-bit variable from 32-bit address */

/*-------------
  status bytes
  -------------*/
#define PCMDRV_STC_OK               0x00 /* operation succesful */
#define PCMDRV_STC_RECRUN           0x01 /* recorder running */
#define PCMDRV_STC_RECDONE          0x02 /* recorder finished */
/* error codes */
#define PCMDRV_STC_INVCMD           0x81 /* invalid command */
#define PCMDRV_STC_CMDSERR          0x82 /* checksum error */
#define PCMDRV_STC_CMDBUFFOVF       0x83 /* command too long */
#define PCMDRV_STC_RSPBUFFOVF       0x84 /* response would be too long */
#define PCMDRV_STC_INVBUFF          0x85 /* invalid buffer length specified */
#define PCMDRV_STC_INVSIZE          0x86 /* invalid size */
#define PCMDRV_STC_SERVBUSY         0x87 /* service is busy */
#define PCMDRV_STC_NOTINIT          0x88 /* scope/recorder not configured */
#define PCMDRV_STC_UNKNOWN          0xFF /* reserved */

/* recorder trigger modes */
#define PCMDRV_REC_TRIGOFF             0 /* manual mode (trigger disabled) */
#define PCMDRV_REC_TRIGRIS             1 /* rising edge */
#define PCMDRV_REC_TRIGFAL             2 /* falling edge */

#define PCMDRV_IDT_STRING_LEN         25 /* length of identification string */

/* get info command parameters */
#define PCMDRV_PROT_VER                3 /* PC Master protocol version */
#define PCMDRV_DATABUSWDT              1 /* data bus width */
#define PCMDRV_CFG_FLAFGS         0x000C /* little endian data format + no fast writes */

/* PC Master initialization */
#define PC_MASTER_REC_BUFF_LEN        0x28 /* PC Matser Recorder buffer length */
#define PC_MASTER_APPCMD_BUFF_LEN     0x04 /* Application Command buffer length */
#define PC_MASTER_RECORDER_TIME_BASE  0x8030 /* A sampling period preset by the board application (value 0x8030 = 50us) */
#define PC_MASTER_GLOB_VERSION_MAJOR  0x00 /* Board firmware version major number */
#define PC_MASTER_GLOB_VERSION_MINOR  0x00 /* Board firmware version minor number */
#define PCMDRV_BUFFER_SIZE            0x3C /* Size of board data buffer */
#define PC_MASTER_IDT_STRING          "PC Master communication !" /* Identification string of the device */

/*------------------------------------------------------------------------------------------------------*/
/*                    structure with SCI communication settings                                         */
/*------------------------------------------------------------------------------------------------------*/
typedef struct {
        UInt8     *p_dataBuff;         /* pointer to input/output communication buffer */
        UInt8     dataBuffSize;        /* size of input/output communication buffer */
        UInt8     *p_recBuff;          /* pointer to recorder buffer */
        UWord16   recSize;             /* recorder buffer size */
        UInt8     *p_recorder;         /* structure with recorder settings and temporary variables */
        UInt8     *p_scope;            /* structure with scope settings */
        UWord16   timeBase;            /* period of Recorder Routine launch */
        UInt8     *p_appCmdBuff;       /* pointer to application command buffer */
        UInt8     appCmdSize;          /* application command buffer size */
        UInt8     globVerMajor;        /* board firmware version major number */
        UInt8     globVerMinor;        /* board firmware version minor number */
        UInt8     idtString[PCMDRV_IDT_STRING_LEN]; /* device identification string */
} sPCMasterComm;

/*------------------------------------------------------------------------------------------------------*/
/* recorder settings structure (recorder settings and temporary variables are stored in this structure) */
/*------------------------------------------------------------------------------------------------------*/
typedef struct{
        UWord16           cmd;
        UWord16           cmdLen;
        UWord16           trgMode;     /* 0x00 - manual, 0x01 - rising edge, 0x02 - falling edge   */
        UWord16           totalSmps;   /* number of samples required                               */
        UWord16           postTrigger; /* samples after trigger                                    */
        UWord16           timeDiv;     /* time div                                                 */
        UWord32           trgVarAddr[1]; /* address of trigger variable                              */
        UWord16           trgVarSize;  /* size of variable (bytes)                                 */
        UWord16           trgVarSigned; /* 0x00 - unsigned, 0x01 - signed                           */

        union{                         /* union is used to access various types of treshold        */
          UInt8           uch;         /* trgVarSize == 1                                          */
          Int8            ch;          /* trgVarSize == 1                                          */
          UWord16         uw;          /* trgVarSize == 2                                          */
          UWord32         ud;          /* trgVarSize == 2                                          */
          Word16          sw;          /* trgVarSize == 4                                          */
          Word32          sd;          /* trgVarSize == 4                                          */
        } trgThreshold;                /* trigger threshold                                        */

        UWord16           varCnt;      /* number of variables                                      */

        struct{
          UWord16         varSize;     /* size of variable                                         */
          UWord32         varAddr[1];  /* address of variable                                      */
        } varDef[8];

        UWord16           recPos;      /* position in recorder buffer - position of the next samples (incremented with RecSetLen) */
        UWord16           recSetLen;   /* length of required set of variables (in words) */
        UWord16           recToEnd;    /* position to end of buff (the variable is decremented after trigger & recorder stops at 0) */
        UWord16           recTime;     /* time div of Recorder */

        /* recorder last value (last value the triggering variable is stored after launch of Recorder routine)  */
        union{
          UInt8           uch;
          Int8            ch;
          UWord16         uw;
          UWord32         ud;
          Word16          sw;
          Word32          sd;
        } recLastVal;                  /* last value of synchronizing variable */
} pcmdrv_sRecorder;

/*------------------------------------------------------------------------------------------------------*/
/*                scope settings buffer (scope settings are stored in this structure)                   */
/*------------------------------------------------------------------------------------------------------*/
typedef struct{
        unsigned char varCnt;
        struct{
          UInt8 varSize;               /* size of scope variable */
          UInt8 addrByte[4];           /* address of scope variable */
        } varDef[8];                   /* maximum number of variables is 8 */
} pcmdrv_sScope;


#define pcmasterdrvInit(sPCMasterComm) PC_M1_pcmasterdrvInit(sPCMasterComm)
Word16 PC_M1_pcmasterdrvInit(sPCMasterComm *p_sPCMasterComm);
/*
** ===================================================================
**     Method      :  PC_M1_pcmasterdrvInit (bean PC_Master)
**
**     Description :
**         Initialization of PC Master Communication Algorithm. This
**         function must be called first, before start of
**         communication.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * p_sPCMasterComm - Pointer to
**                           structure with SCI communication
**                           settings.
**     Returns     :
**         ---             - The function returns the PASS (0).
** ===================================================================
*/

#define pcmasterdrvIsr(sPCMasterComm) PC_M1_pcmasterdrvIsr(sPCMasterComm)
void PC_M1_pcmasterdrvIsr(void);
/*
** ===================================================================
**     Method      :  PC_M1_pcmasterdrvIsr (bean PC_Master)
**
**     Description :
**         Main PC Master Communication routine which provide
**         receiving, decoding of incoming message and sending
**         response to PC.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void Inhr1_OnError(void);

void Inhr1_OnRxChar(void);

void Inhr1_OnTxChar(void);

void PC_M1_PE_Init(void);
/*
** ===================================================================
**     Method      :  PC_M1_PE_Init (bean PC_Master)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END PC_M1. */

#endif /* ifndef __PC_M1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
  #define DSP_INCLUDE_PCMASTER
