/*
 * File:		io.h
 * Purpose:		Serial Input/Output routines
 *
 */

  
#ifndef _SERIAL_H
#define _SERIAL_H

#define FSYS_08_MHz  1 
#define FSYS_12_MHz  2 
#define FSYS_16_MHz  3 
#define FSYS_32_MHz  4 
#define FSYS_40_MHz  5 
#define FSYS_64_MHz  6 

// System frequency in MHz
#define FSYS FSYS_64_MHz


#define UART_9600_BAUDRATE   1
#define UART_19200_BAUDRATE  2
#define UART_38400_BAUDRATE  3
#define UART_115200_BAUDRATE 4

// Uart baudrate
#define UART_BAUDRATE  UART_38400_BAUDRATE

#define PAD_LIN0_TXD 18
#define PAD_LIN0_RXD 19


/********************************************************************/
extern void LinFlex_0_Init(void);
extern char sci_a_getchar (void);
extern void sci_a_putchar (char);

#define out_char sci_a_putchar
#define in_char sci_a_getchar

/********************************************************************/
#endif
