	
//#include <string.h>

#include "serialio.h"
#include <stdarg.h>
//#include <stdio.h>
//#include <__mem.c>


// Rx
#define SCI_RX_BUFER_LINES			8 	// possible value 2^n ; n=0;1;2;3...
#define SCI_RX_BUFER_CHARPERLINE	81
#define CMD_END_CHAR				'\r'  
// Tx
#define SCI_TX_BUFER_LINES			8 	// possible value 2^n ; n=0;1;2;3...
#define SCI_TX_BUFER_CHARPERLINE	81 

/*
TXT_P:MPC5646C is Freesale's Solution for Automotive Security (3)
12345678901234567890123456789012345678901234567890123456789012345678901234567890
         1         2         3         4         5         6         7         8
*/	 

/* global variables */

/* Rx */
char sci_rx_buffer[SCI_RX_BUFER_LINES][SCI_RX_BUFER_CHARPERLINE];
static unsigned int scin_rx_line_index=0;
static unsigned int scin_tx_line_index=0;
/* Tx */
char sci_tx_buffer[SCI_TX_BUFER_LINES][SCI_TX_BUFER_CHARPERLINE];
static unsigned int sciout_rx_line_index=0;
static unsigned int sciout_tx_line_index=0; 
static unsigned int rx_char_index=0;

unsigned int no_transmission_on_going=1;

int echoOn = 1;



/*------------------------------------------------------------------------------
 * FUNC   : printf
 *
 * DESC   : The basic printf function. Does not need to be used in TH_Lite
 *
 * PARAMS : fmt - the classic printf format string, va's in stdarg.h
 * ---------------------------------------------------------------------------*/

int printf( const char *fmt, ... )
{
   int rv;
   va_list args;
   va_start( args, fmt );
   rv = al_printf( fmt, args );
   va_end( args );
   return rv;
}
   
/*------------------------------------------------------------------------------
 * FUNC   : al_printf
 *                                    
 * DESC   : The traditional vprintf, control output from here.
 *
 *
 * PORTING: Standard C in stdio.h, and stdargs.h
 *
 * NOTE: To convert this to a string, use vsprintf, NOT sprintf.
 * ---------------------------------------------------------------------------*/


int	al_printf(const char *fmt, va_list	args)
{	
	unsigned int dummy;
	static int not_after_reset=0;

	do			// Wait for a buffer... 
	{
		dummy = (sciout_tx_line_index+1) & (SCI_TX_BUFER_LINES-1);		
	} while (dummy==sciout_rx_line_index );
	
	vsnprintf(&sci_tx_buffer[sciout_tx_line_index][0], SCI_TX_BUFER_CHARPERLINE ,fmt, args); // max SCI_TX_BUFER_CHARPERLINE per line
	
	if ( no_transmission_on_going ) 
	{
		// send first char to init transmission, the rest will be done by interrupt handler.
		LINFLEX_0.BDRL.B.DATA0 = sci_tx_buffer[sciout_tx_line_index][0];
		rx_char_index=1; // first char already send !!
		if (not_after_reset) 
		{
			sciout_rx_line_index++;
			sciout_rx_line_index&=(SCI_TX_BUFER_LINES-1);				
		}
		else
		{
			not_after_reset=1;
		}
		
		no_transmission_on_going=0;
		
	}
	sciout_tx_line_index=dummy;

	return	0;
}

void sc_tx_handler(void)
{
	static char symbol=0;
	unsigned int dummy;
	
	symbol = sci_tx_buffer[sciout_rx_line_index][rx_char_index];
	if ( symbol == 0 )
	{
		// end of line
		dummy = (sciout_rx_line_index+1) & (SCI_TX_BUFER_LINES-1);	
		
		if ( dummy == sciout_tx_line_index)
		{
			// seems we send everything, so nothing to do
			no_transmission_on_going=1;
		}
		else
		{
			// next line has valid data , we can send 
			sciout_rx_line_index=dummy;
			rx_char_index=0;
			LINFLEX_0.BDRL.B.DATA0 = sci_tx_buffer[sciout_rx_line_index][rx_char_index++];
		}		
	}
	else
	{
		// we are not finish with the actual string, so sent it
		LINFLEX_0.BDRL.B.DATA0 = symbol;
		rx_char_index++;
	}
	LINFLEX_0.UARTSR.R = 0x00000002; 				// clear DTF bit, only
	
	INTC.SSCIR[80].R = 1;		  /* Clear channel's flag */ 
}


void resetTerm() 
{
	printf("%c%c0m", 0x1B, 0x9B);	// Reset terminal
	printf("%c[2J%c[;H",27,27);
	printf("%s\r","************************************************");
	printf("\n\r%s\r","*** Welcome to Freescale Temperature Measure ***");
	printf("\n\r%s\r","***          Press Button To Measure         ***");
	printf("\n\r%s\r","************************************************");
}

void setTermColour(enum TERM_COLOUR colour) 
{
	printf("%c%c%dm", 0x1B, 0x9B, colour);
}

