#ifndef MGT5200_CDM_H
#define MGT5200_CDM_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: cdm.h
* Description: tabasco clock distribution module header file
* Rev History: see "cvs log cdm.h"
*
* cdm.h,v 1.4 2000/10/03 02:49:48 weintrit Exp
*
*/

typedef struct cdm_register_set {
    volatile uint32 jtag_id;            /* MBAR_CDM + 0x00  reg0 read only */
    volatile uint32 rstcfg;             /* MBAR_CDM + 0x04  reg1 read only */
    volatile uint32 breadcrumb;         /* MBAR_CDM + 0x08  reg2 */

    volatile uint8  mem_clk_sel;        /* MBAR_CDM + 0x0c  reg3 byte0 */
    volatile uint8  xlb_clk_sel;        /* MBAR_CDM + 0x0d  reg3 byte1 read only */
    volatile uint8  ipg_clk_sel;        /* MBAR_CDM + 0x0e  reg3 byte2 */
    volatile uint8  pci_clk_sel;        /* MBAR_CDM + 0x0f  reg3 byte3 */

    volatile uint8  ext_48mhz_en;       /* MBAR_CDM + 0x10  reg4 byte0 */
    volatile uint8  fd_enable;          /* MBAR_CDM + 0x11  reg4 byte1 */
    volatile uint16 fd_counters;        /* MBAR_CDM + 0x12  reg4 byte2,3 */

    volatile uint32 clk_enables;        /* MBAR_CDM + 0x14  reg5 */

    volatile uint8  osc_disable;        /* MBAR_CDM + 0x18  reg6 byte0 */
    volatile uint8  reserved0[3];       /* MBAR_CDM + 0x19  reg6 byte1,2,3 */

    volatile uint8  ccs_sleep_enable;   /* MBAR_CDM + 0x1c  reg7 byte0 */
    volatile uint8  osc_sleep_enable;   /* MBAR_CDM + 0x1d  reg7 byte1 */
    volatile uint8  reserved1;          /* MBAR_CDM + 0x1e  reg7 byte2 */
    volatile uint8  ccs_qreq_test;      /* MBAR_CDM + 0x1f  reg7 byte3 */

    volatile uint8  soft_reset;         /* MBAR_CDM + 0x20  uint8 byte0 */
    volatile uint8  no_ckstp;           /* MBAR_CDM + 0x21  uint8 byte0 */
    volatile uint8  reserved2[2];       /* MBAR_CDM + 0x22  uint8 byte1,2,3 */

    volatile uint8  pll_lock;           /* MBAR_CDM + 0x24  reg9 byte0 */
    volatile uint8  pll_looselock;      /* MBAR_CDM + 0x25  reg9 byte1 */
    volatile uint8  pll_sm_lockwin;     /* MBAR_CDM + 0x26  reg9 byte2 */
    volatile uint8  reserved3;          /* MBAR_CDM + 0x27  reg9 byte3 */

    volatile uint16 reserved4;          /* MBAR_CDM + 0x28  reg10 byte0,1 */
    volatile uint16 mclken_div_psc1;    /* MBAR_CDM + 0x2a  reg10 byte2,3 */
    
    volatile uint16 reserved5;          /* MBAR_CDM + 0x2c  reg11 byte0,1 */
    volatile uint16 mclken_div_psc2;    /* MBAR_CDM + 0x2e  reg11 byte2,3 */
       
    volatile uint16 reserved6;          /* MBAR_CDM + 0x30  reg12 byte0,1 */
    volatile uint16 mclken_div_psc3;    /* MBAR_CDM + 0x32  reg12 byte2,3 */
    
    volatile uint16 reserved7;          /* MBAR_CDM + 0x34  reg13 byte0,1 */
    volatile uint16 mclken_div_psc6;    /* MBAR_CDM + 0x36  reg13 byte2,3 */
} cdm_regs;

#define CDM_EXT_48MHZ_EN_USB_EXT	0x02
#define CDM_EXT_48MHZ_EN_PSC6_EXT	0x01

#define CDM_MCLKEN_DIV_PSC_ENABLE	0x8000

#endif /* MGT5200_CDM_H */


