
/************************************************************
 * Defines the buffer descriptor structure that is supported 
 * the standard SmartDMA task code.  Using this header file
 * to define the buffer descriptor table will minimize any
 * disconnects at the task/driver interface.
 ************************************************************/

/************************************************************
 * Buffer Descriptor Table Types
 *
 * This header file generates flexible typedef definitions
 * for BD table structures that minimizes memory usage.  The
 * typedef statically defined at compile time, but provides 
 * flexibility through #define parameters.  The typedefs
 * should not be modified since this BD table structures is
 * fixed in the SmartComm task library.
 *
 * Required #defines:
 *   TYPEDEF_TABLE  Unique name for the table typedef
 *   TYPEDEF_ENTRY  Unique name for the table entry typedef
 *   NUM_BD         Number of buffer descriptor entries
 *   NUM_PTR        Number of data pointers per entries
 *
 * Notes:
 *   The required #defines are #undef'ed at the end of this
 *   file since they are only used to define the typedef.
 *
 *   BD tables should be put in SRAM for best SmartComm
 *   performance.
 *
 * Example: Single pointer with 4 BD entries
 *   #define TYPEDEF_TABLE BDT_fec
 *   #define TYPEDEF_ENTRY BDT_fec_entry
 *   #define NUM_BD        4
 *   #define NUM_PTR       1
 *   #include dmatypes.h
 *
 *   BDTableBase+0x00 BDT_fec->bd[0].Status,Length
 *   BDTableBase+0x04 BDT_fec->bd[0].DataPtr[0]
 *   BDTableBase+0x0C BDT_fec->bd[1].Status,Length
 *   BDTableBase+0x10 BDT_fec->bd[1].DataPtr[0]
 *   ...
 *   ...
 *   BDTableLast+0x00 BDT_fec->bd[3].Status,Length
 *   BDTableLast+0x04 BDT_fec->bd[3].DataPtr[0]
 *
 * Example: Double pointer with 10 BD entries
 *   #define TYPEDEF_NAME BDT_fec
 *   #define NUM_BD       10
 *   #define NUM_PTR       2
 *   #include dmatypes.h
 *
 *   BDTableBase+0x00 BDT_fec->bd[0].Status,Length
 *   BDTableBase+0x04 BDT_fec->bd[0].DataPtr[0]
 *   BDTableBase+0x08 BDT_fec->bd[0].DataPtr[1]
 *   BDTableBase+0x0C BDT_fec->bd[1].Status,Length
 *   BDTableBase+0x10 BDT_fec->bd[1].DataPtr[0]
 *   BDTableBase+0x14 BDT_fec->bd[1].DataPtr[1]
 *   ...
 *   ...
 *   BDTableLast+0x00 BDT_fec->bd[9].Status,Length
 *   BDTableLast+0x04 BDT_fec->bd[9].DataPtr[0]
 *   BDTableLast+0x08 BDT_fec->bd[9].DataPtr[1]
 *
 ***********************************************************/


typedef struct TYPEDEF_ENTRY {
   uint32 Status;
   uint32 DataPtr[NUM_PTR];
} TYPEDEF_ENTRY;

typedef struct TYPEDEF_TABLE {
   TYPEDEF_ENTRY bd[NUM_BD];
} TYPEDEF_TABLE;

#undef TYPEDEF_TABLE
#undef TYPEDEF_ENTRY
#undef NUM_BD
#undef NUM_PTR
