#ifndef MGT5200_ETHERNET_H
#define MGT5200_ETHERNET_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: ethernet.h
* Description: tabasco ethernet header file
*
*/

typedef struct ethernet_register_set {
	/* Control and status Registers (offset 000-1FF) */
	volatile uint32  fec_id;                        /* MBAR_ETH + 0x000 */
	volatile uint32  ievent;                        /* MBAR_ETH + 0x004 */
	volatile uint32  imask;                         /* MBAR_ETH + 0x008 */

	volatile uint32  RES0[1];                       /* MBAR_ETH + 0x00C */
	volatile uint32  r_des_active;                  /* MBAR_ETH + 0x010 */
	volatile uint32  x_des_active;                  /* MBAR_ETH + 0x014 */
	volatile uint32  r_des_active_cl;               /* MBAR_ETH + 0x018 */
	volatile uint32  x_des_active_cl;               /* MBAR_ETH + 0x01C */
	volatile uint32  ivent_set;                     /* MBAR_ETH + 0x020 */
	volatile uint32  ecntrl;                        /* MBAR_ETH + 0x024 */

	volatile uint32  RES1[6];                       /* MBAR_ETH + 0x028-03C */
	volatile uint32  mii_data;                      /* MBAR_ETH + 0x040 */
	volatile uint32  mii_speed;                     /* MBAR_ETH + 0x044 */
	volatile uint32  mii_status;                    /* MBAR_ETH + 0x048 */

	volatile uint32  RES2[5];                       /* MBAR_ETH + 0x04C-05C */
	volatile uint32  mib_data;                      /* MBAR_ETH + 0x060 */
	volatile uint32  mib_control;                   /* MBAR_ETH + 0x064 */

	volatile uint32  RES3[6];                       /* MBAR_ETH + 0x068-7C */
	volatile uint32  r_activate;                    /* MBAR_ETH + 0x080 */
	volatile uint32  r_cntrl;                       /* MBAR_ETH + 0x084 */
	volatile uint32  r_hash;                        /* MBAR_ETH + 0x088 */
	volatile uint32  r_data;                        /* MBAR_ETH + 0x08C */
	volatile uint32  ar_done;                       /* MBAR_ETH + 0x090 */
	volatile uint32  r_test;                        /* MBAR_ETH + 0x094 */
	volatile uint32  r_mib;                         /* MBAR_ETH + 0x098 */
	volatile uint32  r_da_low;                      /* MBAR_ETH + 0x09C */
	volatile uint32  r_da_high;                     /* MBAR_ETH + 0x0A0 */

	volatile uint32  RES4[7];                       /* MBAR_ETH + 0x0A4-0BC */
	volatile uint32  x_activate;                    /* MBAR_ETH + 0x0C0 */
	volatile uint32  x_cntrl;                       /* MBAR_ETH + 0x0C4 */
	volatile uint32  backoff;                       /* MBAR_ETH + 0x0C8 */
	volatile uint32  x_data;                        /* MBAR_ETH + 0x0CC */
	volatile uint32  x_status;                      /* MBAR_ETH + 0x0D0 */
	volatile uint32  x_mib;                         /* MBAR_ETH + 0x0D4 */
	volatile uint32  x_test;                        /* MBAR_ETH + 0x0D8 */
	volatile uint32  fdxfc_da1;                     /* MBAR_ETH + 0x0DC */
	volatile uint32  fdxfc_da2;                     /* MBAR_ETH + 0x0E0 */
	volatile uint32  paddr1;                        /* MBAR_ETH + 0x0E4 */
	volatile uint32  paddr2;                        /* MBAR_ETH + 0x0E8 */
	volatile uint32  op_pause;                      /* MBAR_ETH + 0x0EC */

	volatile uint32  RES5[4];                       /* MBAR_ETH + 0x0F0-0FC */
	volatile uint32  instr_reg;                     /* MBAR_ETH + 0x100 */
	volatile uint32  context_reg;                   /* MBAR_ETH + 0x104 */
	volatile uint32  test_cntrl;                    /* MBAR_ETH + 0x108 */
	volatile uint32  acc_reg;                       /* MBAR_ETH + 0x10C */
	volatile uint32  ones;                          /* MBAR_ETH + 0x110 */
	volatile uint32  zeros;                         /* MBAR_ETH + 0x114 */
	volatile uint32  iaddr1;                        /* MBAR_ETH + 0x118 */
	volatile uint32  iaddr2;                        /* MBAR_ETH + 0x11C */
	volatile uint32  gaddr1;                        /* MBAR_ETH + 0x120 */
	volatile uint32  gaddr2;                        /* MBAR_ETH + 0x124 */
	volatile uint32  random;                        /* MBAR_ETH + 0x128 */
	volatile uint32  rand1;                         /* MBAR_ETH + 0x12C */
	volatile uint32  tmp;                           /* MBAR_ETH + 0x130 */

	volatile uint32  RES6[3];                       /* MBAR_ETH + 0x134-13C */
	volatile uint32  fifo_id;                       /* MBAR_ETH + 0x140 */
	volatile uint32  x_wmrk;                        /* MBAR_ETH + 0x144 */
	volatile uint32  fcntrl;                        /* MBAR_ETH + 0x148 */
	volatile uint32  r_bound;                       /* MBAR_ETH + 0x14C */
	volatile uint32  r_fstart;                      /* MBAR_ETH + 0x150 */
	volatile uint32  r_count;                       /* MBAR_ETH + 0x154 */
	volatile uint32  r_lag;                         /* MBAR_ETH + 0x158 */
	volatile uint32  r_read;                        /* MBAR_ETH + 0x15C */
	volatile uint32  r_write;                       /* MBAR_ETH + 0x160 */
	volatile uint32  x_count;                       /* MBAR_ETH + 0x164 */
	volatile uint32  x_lag;                         /* MBAR_ETH + 0x168 */
	volatile uint32  x_retry;                       /* MBAR_ETH + 0x16C */
	volatile uint32  x_write;                       /* MBAR_ETH + 0x170 */
	volatile uint32  x_read;                        /* MBAR_ETH + 0x174 */

	volatile uint32  RES7[2];                       /* MBAR_ETH + 0x178-17C */
	volatile uint32  fm_cntrl;                      /* MBAR_ETH + 0x180 */
	volatile uint32  rfifo_data;                    /* MBAR_ETH + 0x184 */
	volatile uint32  rfifo_status;                  /* MBAR_ETH + 0x188 */
	volatile uint32  rfifo_cntrl;                   /* MBAR_ETH + 0x18C */
	volatile uint32  rfifo_lrf_ptr;                 /* MBAR_ETH + 0x190 */
	volatile uint32  rfifo_lwf_ptr;                 /* MBAR_ETH + 0x194 */
	volatile uint32  rfifo_alarm;                   /* MBAR_ETH + 0x198 */
	volatile uint32  rfifo_rdptr;                   /* MBAR_ETH + 0x19C */
	volatile uint32  rfifo_wrptr;                   /* MBAR_ETH + 0x1A0 */
	volatile uint32  tfifo_data;                    /* MBAR_ETH + 0x1A4 */
	volatile uint32  tfifo_status;                  /* MBAR_ETH + 0x1A8 */
	volatile uint32  tfifo_cntrl;                   /* MBAR_ETH + 0x1AC */
	volatile uint32  tfifo_lrf_ptr;                 /* MBAR_ETH + 0x1B0 */
	volatile uint32  tfifo_lwf_ptr;                 /* MBAR_ETH + 0x1B4 */
	volatile uint32  tfifo_alarm;                   /* MBAR_ETH + 0x1B8 */
	volatile uint32  tfifo_rdptr;                   /* MBAR_ETH + 0x1BC */
	volatile uint32  tfifo_wrptr;                   /* MBAR_ETH + 0x1C0 */

	volatile uint32  reset_cntrl;                   /* MBAR_ETH + 0x1C4 */
	volatile uint32  xmit_fsm;                      /* MBAR_ETH + 0x1C8 */

	volatile uint32  RES8[3];                       /* MBAR_ETH + 0x1CC-1D4 */
	volatile uint32  rdes_data0;                    /* MBAR_ETH + 0x1D8 */
	volatile uint32  rdes_data1;                    /* MBAR_ETH + 0x1DC */
	volatile uint32  r_length;                      /* MBAR_ETH + 0x1E0 */
	volatile uint32  x_length;                      /* MBAR_ETH + 0x1E4 */
	volatile uint32  x_addr;                        /* MBAR_ETH + 0x1E8 */
	volatile uint32  cdes_data;                     /* MBAR_ETH + 0x1EC */
	volatile uint32  status;                        /* MBAR_ETH + 0x1F0 */
	volatile uint32  dma_control;                   /* MBAR_ETH + 0x1F4 */
	volatile uint32  des_cmnd;                      /* MBAR_ETH + 0x1F8 */
	volatile uint32  data;                          /* MBAR_ETH + 0x1FC */

	/* MIB COUNTERS (Offset 200-2FF) */
	volatile uint32  rmon_t_drop;                   /* MBAR_ETH + 0x200 */
	volatile uint32  rmon_t_packets;                /* MBAR_ETH + 0x204 */
	volatile uint32  rmon_t_bc_pkt;                 /* MBAR_ETH + 0x208 */
	volatile uint32  rmon_t_mc_pkt;                 /* MBAR_ETH + 0x20C */
	volatile uint32  rmon_t_crc_align;              /* MBAR_ETH + 0x210 */
	volatile uint32  rmon_t_undersize;              /* MBAR_ETH + 0x214 */
	volatile uint32  rmon_t_oversize;               /* MBAR_ETH + 0x218 */
	volatile uint32  rmon_t_frag;                   /* MBAR_ETH + 0x21C */
	volatile uint32  rmon_t_jab;                    /* MBAR_ETH + 0x220 */
	volatile uint32  rmon_t_col;                    /* MBAR_ETH + 0x224 */
	volatile uint32  rmon_t_p64;                    /* MBAR_ETH + 0x228 */
	volatile uint32  rmon_t_p65to127;               /* MBAR_ETH + 0x22C */
	volatile uint32  rmon_t_p128to255;              /* MBAR_ETH + 0x230 */
	volatile uint32  rmon_t_p256to511;              /* MBAR_ETH + 0x234 */
	volatile uint32  rmon_t_p512to1023;             /* MBAR_ETH + 0x238 */
	volatile uint32  rmon_t_p1024to2047;            /* MBAR_ETH + 0x23C */
	volatile uint32  rmon_t_p_gte2048;              /* MBAR_ETH + 0x240 */
	volatile uint32  rmon_t_octets;                 /* MBAR_ETH + 0x244 */
	volatile uint32  ieee_t_drop;                   /* MBAR_ETH + 0x248 */
	volatile uint32  ieee_t_frame_ok;               /* MBAR_ETH + 0x24C */
	volatile uint32  ieee_t_1col;                   /* MBAR_ETH + 0x250 */
	volatile uint32  ieee_t_mcol;                   /* MBAR_ETH + 0x254 */
	volatile uint32  ieee_t_def;                    /* MBAR_ETH + 0x258 */
	volatile uint32  ieee_t_lcol;                   /* MBAR_ETH + 0x25C */
	volatile uint32  ieee_t_excol;                  /* MBAR_ETH + 0x260 */
	volatile uint32  ieee_t_macerr;                 /* MBAR_ETH + 0x264 */
	volatile uint32  ieee_t_cserr;                  /* MBAR_ETH + 0x268 */
	volatile uint32  ieee_t_sqe;                    /* MBAR_ETH + 0x26C */
	volatile uint32  t_fdxfc;                       /* MBAR_ETH + 0x270 */
	volatile uint32  ieee_t_octets_ok;              /* MBAR_ETH + 0x274 */

	volatile uint32  RES9[2];                       /* MBAR_ETH + 0x278-27C */
	volatile uint32  rmon_r_drop;                   /* MBAR_ETH + 0x280 */
	volatile uint32  rmon_r_packets;                /* MBAR_ETH + 0x284 */
	volatile uint32  rmon_r_bc_pkt;                 /* MBAR_ETH + 0x288 */
	volatile uint32  rmon_r_mc_pkt;                 /* MBAR_ETH + 0x28C */
	volatile uint32  rmon_r_crc_align;              /* MBAR_ETH + 0x290 */
	volatile uint32  rmon_r_undersize;              /* MBAR_ETH + 0x294 */
	volatile uint32  rmon_r_oversize;               /* MBAR_ETH + 0x298 */
	volatile uint32  rmon_r_frag;                   /* MBAR_ETH + 0x29C */
	volatile uint32  rmon_r_jab;                    /* MBAR_ETH + 0x2A0 */

	volatile uint32  rmon_r_resvd_0;                /* MBAR_ETH + 0x2A4 */

	volatile uint32  rmon_r_p64;                    /* MBAR_ETH + 0x2A8 */
	volatile uint32  rmon_r_p65to127;               /* MBAR_ETH + 0x2AC */
	volatile uint32  rmon_r_p128to255;              /* MBAR_ETH + 0x2B0 */
	volatile uint32  rmon_r_p256to511;              /* MBAR_ETH + 0x2B4 */
	volatile uint32  rmon_r_p512to1023;             /* MBAR_ETH + 0x2B8 */
	volatile uint32  rmon_r_p1024to2047;            /* MBAR_ETH + 0x2BC */
	volatile uint32  rmon_r_p_gte2048;              /* MBAR_ETH + 0x2C0 */
	volatile uint32  rmon_r_octets;                 /* MBAR_ETH + 0x2C4 */
	volatile uint32  ieee_r_drop;                   /* MBAR_ETH + 0x2C8 */
	volatile uint32  ieee_r_frame_ok;               /* MBAR_ETH + 0x2CC */
	volatile uint32  ieee_r_crc;                    /* MBAR_ETH + 0x2D0 */
	volatile uint32  ieee_r_align;                  /* MBAR_ETH + 0x2D4 */
	volatile uint32  r_macerr;                      /* MBAR_ETH + 0x2D8 */
	volatile uint32  r_fdxfc;                       /* MBAR_ETH + 0x2DC */
	volatile uint32  ieee_r_octets_ok;              /* MBAR_ETH + 0x2E0 */

	volatile uint32  RES10[7];                      /* MBAR_ETH + 0x2E4-2FC */

	volatile uint32  RES11[64];                     /* MBAR_ETH + 0x300-3FF */
} ethernet_regs;

/*
 * Bit fields for FEC interrupts, ievent and imask above.
 */
#define FEC_INTR_HBERR		0x80000000	/* heartbeat error				*/
#define FEC_INTR_BABR		0x40000000	/* babbling receive error		*/
#define FEC_INTR_BABT		0x20000000	/* babbling transmit error		*/
#define FEC_INTR_GRA		0x10000000	/* graceful stop complete		*/
#define FEC_INTR_TFINT		0x08000000	/* transmit frame interrupt		*/
/*							0x04000000	reserved						*/
/*							0x02000000	reserved						*/
/*							0x01000000	reserved						*/
#define FEC_INTR_MII		0x00800000	/* MII interrupt				*/
/*							0x00400000	reserved						*/
#define FEC_INTR_LATE_COL	0x00200000	/* late collision				*/
#define FEC_INTR_COL_RETRY	0x00100000	/* collision retry limit		*/
#define FEC_INTR_XFIFO_UN	0x00080000	/* transmit FIFO error			*/
#define FEC_INTR_XFIFO_ERR	0x00040000	/* transmit FIFO error			*/
#define FEC_INTR_RFIFO_ERR	0x00020000	/* receive FIFO error			*/
/*							0x00010000	reserved						*/
/*							0x0000ffff	reserved						*/
#define FEC_INTR_HBEEN		FEC_INTR_HBERR
#define FEC_INTR_BREN		FEC_INTR_BABR
#define FEC_INTR_BTEN		FEC_INTR_BABT
#define FEC_INTR_GRAEN		FEC_INTR_GRA
#define FEC_INTR_TFINTEN	FEC_INTR_TFINT
#define FEC_INTR_MIIEN		FEC_INTR_MII
#define FEC_INTR_LCEN		FEC_INTR_LATE_COL
#define FEC_INTR_CRLEN		FEC_INTR_COL_RETRY
#define FEC_INTR_XFUNEN		FEC_INTR_XFIFO_UN
#define FEC_INTR_XFERREN	FEC_INTR_XFIFO_ERR
#define FEC_INTR_RFERREN	FEC_INTR_RFIFO_ERR
#define FEC_INTR_CLEAR_ALL	0xffffffff	/* clear all interrupt events	*/
#define FEC_INTR_MASK_ALL	0x00000000	/* mask all interrupt events	*/

/*
 * Bit fields for FEC ethernet control, ecntrl above.
 */
#define FEC_ECNTRL_TAG		0xf0000000	/* TBUS tag bits				*/
/*							0x08000000	reserved						*/
#define FEC_ECNTRL_TESTMD	0x04000000	/* test mode					*/
/*							0x03fffff8	reserved						*/
#define FEC_ECNTRL_OE		0x00000004	/* FEC output enable			*/
#define FEC_ECNTRL_EN		0x00000002	/* ethernet enable				*/
#define FEC_ECNTRL_RESET	0x00000001	/* ethernet controller reset	*/

/*
 * Bit fields for FEC receive control, r_cntrl above.
 */
/*							0xf1000000	reserved						*/
#define FEC_RCNTRL_MAX_FL	0x07ff0000	/* maximum frame length			*/
#define FEC_RCNTRL_MAX_FL_SHIFT 16
/*							0x0000ffc0	reserved						*/
#define FEC_RCNTRL_FCE		0x00000020	/* flow control enable			*/
#define FEC_RCNTRL_BC_REJ	0x00000010	/* broadcast frame reject		*/
#define FEC_RCNTRL_PROM		0x00000008	/* promiscuous mode				*/
#define FEC_RCNTRL_MII_MODE	0x00000004	/* select 18-wire (MII) mode	*/
#define FEC_RCNTRL_DRT		0x00000002	/* disable receive on transmit	*/
#define FEC_RCNTRL_LOOP		0x00000001	/* internal loopback			*/

/*
 * Bit fields for FEC transmit control, x_cntrl above.
 */
/*							0xffffffe0	reserved						*/
#define FEC_XCNTRL_RFC_PAUS 0x00000010	/* FDX flow control pause rx	*/
#define FEC_XCNTRL_TFC_PAUS	0x00000008	/* assert a PAUSE frame			*/
#define FEC_XCNTRL_FDEN		0x00000004	/* full duplex enable			*/
#define FEC_XCNTRL_HBC		0x00000002	/* heartbeat control			*/
#define FEC_XCNTRL_GTS		0x00000001	/* graceful transmit stop		*/

/*
 * Bit fields for FEC transmit status, x_status above.
 */
/*							0xfc000000	reserved						*/
#define FEC_XSTAT_DEF		0x02000000	/* defer						*/
#define FEC_XSTAT_HB		0x01000000	/* heartbeat error				*/
#define FEC_XSTAT_LC		0x00800000	/* late collision				*/
#define FEC_XSTAT_RL		0x00400000	/* retry limit					*/
#define FEC_XSTAT_RC		0x003c0000	/* retry count					*/
#define FEC_XSTAT_UN		0x00020000	/* underrun						*/
#define FEX_XSTAT_CSL		0x00010000	/* carrier sense lost			*/
/*							0x0000ffff	reserved						*/

/*
 * Bit fields for FEC transmit FIFO watermark, x_wmrk above.
 */
#define FEC_XWMRK_64		0x00000000	/*   64 bytes written to TxFIFO	*/
#define FEC_XWMRK_128		0x00000001	/*  128 bytes written to TxFIFO	*/
#define FEC_XWMRK_192		0x00000002	/*  192 bytes written to TxFIFO	*/
#define FEC_XWMRK_256		0x00000003	/*  256 bytes written to TxFIFO	*/
#define FEC_XWMRK_320		0x00000004	/*  320 bytes written to TxFIFO	*/
#define FEC_XWMRK_384		0x00000005	/*  384 bytes written to TxFIFO	*/
#define FEC_XWMRK_448		0x00000006	/*  448 bytes written to TxFIFO	*/
#define FEC_XWMRK_512		0x00000007	/*  512 bytes written to TxFIFO	*/
#define FEC_XWMRK_576		0x00000008	/*  576 bytes written to TxFIFO	*/
#define FEC_XWMRK_640		0x00000009	/*  640 bytes written to TxFIFO	*/
#define FEC_XWMRK_704		0x0000000a	/*  704 bytes written to TxFIFO	*/
#define FEC_XWMRK_768		0x0000000b	/*  768 bytes written to TxFIFO	*/
#define FEC_XWMRK_832		0x0000000c	/*  832 bytes written to TxFIFO	*/
#define FEC_XWMRK_896		0x0000000d	/*  896 bytes written to TxFIFO	*/
#define FEC_XWMRK_960		0x0000000e	/*  960 bytes written to TxFIFO	*/
#define FEC_XWMRK_1024		0x0000000f	/* 1024 bytes written to TxFIFO	*/

/*
 * Bit fields for FEC transmit finite state machine.
 */
/*							0xfc000000	reserved						*/
#define FEC_FSM_CRC			0x02000000	/* append CRC (typical use)		*/
#define FEC_FSM_ENFSM		0x01000000	/* enable CRC FSM (typical use)	*/
/*							0x00ffffff	reserved						*/

/*
 * Bit fields for FEC FIFOs, rfifo_status, rfifo_cntrl, tfifo_status
 * and tfifo_cntrl.
 */
/*							0xf0000000	reserved						*/
#define FEC_FIFO_STAT_FRAME	0x0f000000	/* frame indicator				*/
/*							0x00800000	reserved						*/
#define FEC_FIFO_STAT_ERR	0x00400000	/* receive error condition		*/
#define FEC_FIFO_STAT_UF	0x00200000	/* underflow					*/
#define FEC_FIFO_STAT_OF	0x00100000	/* overflow						*/
#define FEC_FIFO_STAT_FR	0x00080000	/* frame ready, read-only		*/
#define FEC_FIFO_STAT_FULL	0x00040000	/* full alarm, read-only		*/
#define FEC_FIFO_STAT_ALARM	0x00020000	/* fifo alarm					*/
#define FEC_FIFO_STAT_EMPTY	0x00010000	/* empty, read-only				*/
/*							0x0000ffff	reserved						*/
#define FEC_FIFO_STAT_ERROR	( FEC_FIFO_STAT_ERR	\
							| FEC_FIFO_STAT_UF	\
							| FEC_FIFO_STAT_OF	\
							)

/*								0x80000000	reserved						*/
#define FEC_FIFO_CNTRL_WCTL		0x40000000	/* write control				*/
#define FEC_FIFO_CNTRL_WFR		0x20000000	/* write frame					*/
/*								0x10000000	reserved						*/
#define FEC_FIFO_CNTRL_FRAME	0x08000000	/* frame mode enable	*/
#define FEC_FIFO_CNTRL_GR		0x07000000	/* last transfer granularity	*/
#define FEC_FIFO_CNTRL_GR_SHIFT	24
#define FEC_FIFO_CNTRL_IP_MASK	0x00800000	/* illegal pointer mask			*/
#define FEC_FIFO_CNTRL_FAE_MASK	0x00400000	/* frame accept mask			*/
#define FEC_FIFO_CNTRL_RXW_MASK	0x00200000	/* receive wait mask			*/
#define FEC_FIFO_CNTRL_UF_MASK	0x00100000	/* underflow mask				*/
#define FEC_FIFO_CNTRL_OF_MASK	0x00080000	/* overflow mask				*/
/*								0x0007ffff	reserved						*/

#endif /* MGT5200_ETHERNET_H */
