#ifndef MGT5200_I2C_H
#define MGT5200_I2C_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: i2c.h
* Description: tabasco i2c header file
* Rev History: see "cvs log i2c.h"
*
* i2c.h,v 1.5 2001/04/23 20:39:14 weintrit Exp
*
*/

typedef struct i2c_register_set {
    volatile uint8  MADR1;          /* MBAR_I2C + 0x00 */
    volatile uint8  RES1_1[3];    
    volatile uint8  MFDR1;          /* MBAR_I2C + 0x04 */
    volatile uint8  RES2_1[3];    
    volatile uint8  MCR1;           /* MBAR_I2C + 0x08 */
    volatile uint8  RES3_1[3];
    volatile uint8  MSR1;           /* MBAR_I2C + 0x0c */
    volatile uint8  RES4_1[3];
    volatile uint8  MDR1;           /* MBAR_I2C + 0x10 */
    volatile uint8  RES5_1[3];
    volatile uint32 RES5Y[3];
    volatile uint8  special;        /* MBAR_I2C + 0x20 */
    volatile uint8  RES5X[3];
    volatile uint32 RES6_1[7];    
    volatile uint8  MADR2;          /* MBAR_I2C + 0x40 */
    volatile uint8  RES1_2[3];
    volatile uint8  MFDR2;          /* MBAR_I2C + 0x44 */
    volatile uint8  RES2_2[3];
    volatile uint8  MCR2;           /* MBAR_I2C + 0x48 */
    volatile uint8  RES3_2[3];
    volatile uint8  MSR2;           /* MBAR_I2C + 0x4c */
    volatile uint8  RES4_2[3];
    volatile uint8  MDR2;           /* MBAR_I2C + 0x50 */
    volatile uint8  RES5_2[3];
    volatile uint32 RES6_2[11];     /* MBAR_I2C + 0x54 */
} i2c_regs;

#endif /* MGT5200_I2C_H */
