#ifndef MGT5200_IPBI_H
#define MGT5200_IPBI_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: ipbi.h
* Description: tabasco ipbi header file
* Rev History: see "cvs log ipbi.h"
*
* ipbi.h,v 1.7 2001/08/06 00:03:50 weintrit Exp
*
*/

typedef struct ipbi_register_set {
	volatile uint32 ipbi_base_addr;      /* MBAR_IPBI(RST) + 0x0000 */
	volatile uint32 cs0_start_addr;      /* MBAR_IPBI(RST) + 0x0004 */
	volatile uint32 cs0_stop_addr;       /* MBAR_IPBI(RST) + 0x0008 */
	volatile uint32 cs1_start_addr;      /* MBAR_IPBI(RST) + 0x000c */
	volatile uint32 cs1_stop_addr;       /* MBAR_IPBI(RST) + 0x0010 */
	volatile uint32 cs2_start_addr;      /* MBAR_IPBI(RST) + 0x0014 */
	volatile uint32 cs2_stop_addr;       /* MBAR_IPBI(RST) + 0x0018 */
	volatile uint32 cs3_start_addr;      /* MBAR_IPBI(RST) + 0x001c */
	volatile uint32 cs3_stop_addr;       /* MBAR_IPBI(RST) + 0x0020 */
	volatile uint32 cs4_start_addr;      /* MBAR_IPBI(RST) + 0x0024 */
	volatile uint32 cs4_stop_addr;       /* MBAR_IPBI(RST) + 0x0028 */
	volatile uint32 cs5_start_addr;      /* MBAR_IPBI(RST) + 0x002c */
	volatile uint32 cs5_stop_addr;       /* MBAR_IPBI(RST) + 0x0030 */
	volatile uint32 sdram_cs0_cfg;       /* MBAR_IPBI(RST) + 0x0034 */
	volatile uint32 sdram_cs1_cfg;       /* MBAR_IPBI(RST) + 0x0038 */
	volatile uint32 rsvd0;               /* MBAR_IPBI(RST) + 0x003c */
	volatile uint32 rsvd1;               /* MBAR_IPBI(RST) + 0x0040 */
	volatile uint32 rsvd2;               /* MBAR_IPBI(RST) + 0x0044 */
	volatile uint32 rsvd3;               /* MBAR_IPBI(RST) + 0x0048 */
	volatile uint32 boot_start_addr;     /* MBAR_IPBI(RST) + 0x004c */
	volatile uint32 boot_stop_addr;      /* MBAR_IPBI(RST) + 0x0050 */
	volatile uint16 control_reg;         /* MBAR_IPBI(RST) + 0x0054 actually [11:0] */
	volatile uint16 ipbi_wait_state_en;  /* MBAR_IPBI(RST) + 0x0056 */
	volatile uint32 cs6_start_addr;      /* MBAR_IPBI(RST) + 0x0058 */
	volatile uint32 cs6_stop_addr;       /* MBAR_IPBI(RST) + 0x005C */
	volatile uint32 cs7_start_addr;      /* MBAR_IPBI(RST) + 0x0060 */
	volatile uint32 cs7_stop_addr;       /* MBAR_IPBI(RST) + 0x0064 */
} ipbi_regs;

#define CSCTRL_CS0_EN		0x0001
#define CSCTRL_CS1_EN		0x0002
#define CSCTRL_CS2_EN		0x0004
#define CSCTRL_CS3_EN		0x0008
#define CSCTRL_CS4_EN		0x0010
#define CSCTRL_CS5_EN		0x0020
#define CSCTRL_SDRAM_EN		0x0040
#define CSCTRL_PCI2_EN		0x0080
#define CSCTRL_PCI1_EN		0x0100
#define CSCTRL_BOOT_EN		0x0200
#define CSCTRL_CS6_EN		0x0400
#define CSCTRL_CS7_EN		0x0800
#define IPBI_WSEN			0x0001

#define IPBI_WAIT_STATE_EN	0x0001

#endif /* MGT5200_IPBI_H */
