#ifndef MGT5200_IR_H
#define MGT5200_IR_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: ir.h
* Description: tabasco ir header file
* Rev History: see "cvs log ir.h"
*
* ir.h,v 1.4 2001/07/24 17:50:51 weintrit Exp
*
*/

typedef struct ir_register_set {
	volatile uint8  rx_enable;            /* MBAR_IR + 0x00 */
	volatile uint8  rx_RES0[3];           /* MBAR_IR + 0x01 */
	volatile uint16 rx_datactl;           /* MBAR_IR + 0x04 */
	volatile uint16 rx_RES1;              /* MBAR_IR + 0x06 */
	volatile uint8  rx_numadddata;        /* MBAR_IR + 0x08 */
	volatile uint8  rx_numstrctl;         /* MBAR_IR + 0x09 */
	volatile uint8  rx_numpream;          /* MBAR_IR + 0x0a */
	volatile uint8  rx_RES2;              /* MBAR_IR + 0x0b */
	volatile uint8  rx_bitpre;            /* MBAR_IR + 0x0c */
	volatile uint8  rx_spkcnt;            /* MBAR_IR + 0x0d */
	volatile uint16 rx_framepre;          /* MBAR_IR + 0x0e */
	volatile uint8  rx_bitx;              /* MBAR_IR + 0x10 */
	volatile uint8  rx_bity0;             /* MBAR_IR + 0x11 */
	volatile uint8  rx_framelength;       /* MBAR_IR + 0x12 */
	volatile uint8  rx_bity1;             /* MBAR_IR + 0x13 */
	volatile uint16 rx_datacomp;          /* MBAR_IR + 0x14 */
	volatile uint16 rx_datamask;          /* MBAR_IR + 0x16 */
	volatile uint8  rx_addcomp;           /* MBAR_IR + 0x18 */
	volatile uint8  rx_addmask;           /* MBAR_IR + 0x19 */
	volatile uint16 rx_RES6;              /* MBAR_IR + 0x1a */
	volatile uint8  rx_preamlo;           /* MBAR_IR + 0x1c */
	volatile uint8  rx_preamhi;           /* MBAR_IR + 0x1d */
	volatile uint16 rx_RES7;              /* MBAR_IR + 0x1e */
	volatile uint16 rx_statuserr;         /* MBAR_IR + 0x20 */
	volatile uint16 rx_RES8;              /* MBAR_IR + 0x22 */
	volatile uint32 rx_dataout;           /* MBAR_IR + 0x24 */
	volatile uint32 rx_RES10[6];          /* MBAR_IR + 0x28 */
	/* Transmit section */
	volatile uint8  tx_enable;            /* MBAR_IR + 0x40 */
	volatile uint8  tx_RES0[3];           /* MBAR_IR + 0x41 */
	volatile uint16 tx_datactl;           /* MBAR_IR + 0x44 */
	volatile uint16 tx_carrier;           /* MBAR_IR + 0x46 */
	volatile uint8  tx_numadddata;        /* MBAR_IR + 0x48 */
	volatile uint8  tx_numstrctl;         /* MBAR_IR + 0x49 */
	volatile uint8  tx_numpream;          /* MBAR_IR + 0x4a */
	volatile uint8  tx_RES2;              /* MBAR_IR + 0x4b */
	volatile uint8  tx_bitpre;            /* MBAR_IR + 0x4c */
	volatile uint8  tx_framerpt;          /* MBAR_IR + 0x4d */
	volatile uint16 tx_framepre;          /* MBAR_IR + 0x4e */
	volatile uint8  tx_bitx;              /* MBAR_IR + 0x50 */
	volatile uint8  tx_bity0;             /* MBAR_IR + 0x51 */
	volatile uint8  tx_framelength;       /* MBAR_IR + 0x52 */
	volatile uint8  tx_bity1;             /* MBAR_IR + 0x53 */
	volatile uint8  tx_preamlo;           /* MBAR_IR + 0x54 */
	volatile uint8  tx_preamhi;           /* MBAR_IR + 0x55 */
	volatile uint16 tx_RES5;              /* MBAR_IR + 0x56 */
	volatile uint16 tx_statuserr;         /* MBAR_IR + 0x58 */
	volatile uint16 tx_RES6;              /* MBAR_IR + 0x5a */
	volatile uint32 tx_dataout;           /* MBAR_IR + 0x5c */
	volatile uint32 tx_RES10[8];          /* MBAR_IR + 0x60 */
} ir_regs;

#endif /* MGT5200_IR_H */
