#ifndef MGT5200_LPC_H
#define MGT5200_LPC_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: lpc.h
* Description: tabasco lpc header file
* Rev History: see "cvs log lpc.h"
*
* lpc.h,v 1.3 2000/06/09 13:41:13 weintrit Exp
*
*/

typedef struct lpc_register_set {
	/* Register 0 is configuration register for Chip Select 0 */
	volatile uint32 lpc_cs0;		/* MBAR_LPC + 0x00 */
	/* Register 1 is configuration register for Chip Select 1 */
	volatile uint32 lpc_cs1;		/* MBAR_LPC + 0x04 */
	/* Register 2 is configuration register for Chip Select 2 */	
	volatile uint32 lpc_cs2;		/* MBAR_LPC + 0x08 */
	/* Register 3 is configuration register for Chip Select 3 */	
	volatile uint32 lpc_cs3;		/* MBAR_LPC + 0x0C */
	/* Register 4 is configuration register for Chip Select 4 */
	volatile uint32 lpc_cs4;		/* MBAR_LPC + 0x10 */
	/* Register 5 is configuration register for Chip Select 5 */	
	volatile uint32 lpc_cs5;		/* MBAR_LPC + 0x14 */
	/* Register 6 is master control register */
	volatile uint8  lpc_ctl;		/* MBAR_LPC + 0x18 */
	volatile uint8  RES1[3];		/* MBAR_LPC + 0x19 */
	/* Register 7 is error status register */
	volatile uint8  lpc_xerr;		/* MBAR_LPC + 0x1C */
	volatile uint8  lpc_berr;		/* MBAR_LPC + 0x1D */
	volatile uint16 RES2;			/* MBAR_LPC + 0x1E */
	volatile uint32 lpc_cs6;		/* MBAR_LPC + 0x20 */
	volatile uint32 lpc_cs7;		/* MBAR_LPC + 0x24 */
	volatile uint32 burstctl;		/* MBAR_LPC + 0x28 */
	volatile uint32 deadcycle;		/* MBAR_LPC + 0x2C */
	/* Final 20 registers are reserved */
	volatile uint32 RES3[20];		/* MBAR_LPC + 0x30 */
} lpc_regs;							/* MBAR_LPC + 0x7F (end) */

#define CSCR_WAITP		0xFF000000
#define CSCR_WAITX		0x00FF0000
#define CSCR_MX			0x00008000
#define CSCR_AL			0x00004000
#define CSCR_AA			0x00002000
#define CSCR_CE			0x00001000
#define CSCR_AS			0x00000C00
#define CSCR_AS_8		0x00000000
#define CSCR_AS_16		0x00000400
#define CSCR_AS_24		0x00000800
#define CSCR_AS_25		0x00000C00
#define CSCR_DS			0x00000300
#define CSCR_DS_8		0x00000000
#define CSCR_DS_16		0x00000100
#define CSCR_DS_24		0x00000200
#define CSCR_DS_32		0x00000300
#define CSCR_BANK		0x000000C0
#define CSCR_BANK1		0x00000080
#define CSCR_WTYP		0x00000030
#define CSCR_WS			0x00000008
#define CSCR_RS			0x00000004
#define CSCR_WO			0x00000002
#define CSCR_RO			0x00000001

#define CSBCR_EN_CS0	0x00000001
#define CSBCR_EN_CS1	0x00000010
#define CSBCR_EN_CS2	0x00000100
#define CSBCR_EN_CS3	0x00001000
#define CSBCR_EN_CS4	0x00010000
#define CSBCR_EN_CS5	0x00100000
#define CSBCR_EN_CS6	0x01000000
#define CSBCR_EN_CS7	0x10000000

#define CSBCR_LB_CS0	0x00000004
#define CSBCR_LB_CS1	0x00000040
#define CSBCR_LB_CS2	0x00000400
#define CSBCR_LB_CS3	0x00004000
#define CSBCR_LB_CS4	0x00040000
#define CSBCR_LB_CS5	0x00400000
#define CSBCR_LB_CS6	0x04000000
#define CSBCR_LB_CS7	0x40000000

#define CSBCR_CDWF_CS0	0x00000008
#define CSBCR_CDWF_CS1	0x00000080
#define CSBCR_CDWF_CS2	0x00000800
#define CSBCR_CDWF_CS3	0x00008000
#define CSBCR_CDWF_CS4	0x00080000
#define CSBCR_CDWF_CS5	0x00800000
#define CSBCR_CDWF_CS6	0x08000000
#define CSBCR_CDWF_CS7	0x80000000

#define CSCTL_EBEE		0x80
#define CSCTL_IBEE		0x10
#define CSCTL_IE		0x08
#define CSCTL_ME		0x01

#endif /* MGT5200_LPC_H */
