#ifndef MGT5200_PSC_H
#define MGT5200_PSC_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: psc.h
* Description: tabasco psc header file
* Rev History: see "cvs log psc.h"
*
* psc.h,v 1.5 2000/10/06 00:32:41 rchamoun Exp
*
*/

typedef struct psc_register_set {
	volatile uint8  ModeReg;			/* MBAR_PSC + 0x00 */
	volatile uint8  RES0[3];			/* MBAR_PSC + 0x01 */
	volatile uint16 SR_CSR;				/* MBAR_PSC + 0x04 */
	volatile uint8  RES1[2];			/* MBAR_PSC + 0x06 */
	volatile uint8  CR;					/* MBAR_PSC + 0x08 */
	volatile uint8  RES1a[3];			/* MBAR_PSC + 0x09 */
	volatile uint32 RB_TB;				/* MBAR_PSC + 0x0c */
	volatile uint8  IPCR_ACR;			/* MBAR_PSC + 0x10 */
	volatile uint8  RES2[3];			/* MBAR_PSC + 0x11 */
	volatile uint16 ISR_IMR;			/* MBAR_PSC + 0x14 */
	volatile uint8  RES3[2];			/* MBAR_PSC + 0x16 */
	volatile uint8  CTUR;				/* MBAR_PSC + 0x18 */
	volatile uint8  RES4[3];			/* MBAR_PSC + 0x19 */
	volatile uint8  CTLR;				/* MBAR_PSC + 0x1c */
	volatile uint8  RES5[3];			/* MBAR_PSC + 0x1d */
	volatile uint16 BCLK_FDIV;			/* MBAR_PSC + 0x20 */
	volatile uint16 RES6[7];			/* MBAR_PSC + 0x22 */
	volatile uint8  IVR;				/* MBAR_PSC + 0x30 */
	volatile uint8  RES7[3];			/* MBAR_PSC + 0x31 */
	volatile uint8  IP;					/* MBAR_PSC + 0x34 */
	volatile uint8  RES8[3];			/* MBAR_PSC + 0x35 */
	volatile uint8  OP1;				/* MBAR_PSC + 0x38 */
	volatile uint8  RES9[3];			/* MBAR_PSC + 0x39 */
	volatile uint8  OP0;				/* MBAR_PSC + 0x3c */
	volatile uint8  RES10[3];			/* MBAR_PSC + 0x3d */
	volatile uint32 SICR;				/* MBAR_PSC + 0x40 */
	volatile uint8  IRCR1;				/* MBAR_PSC + 0x44 */
	volatile uint8  RES12[3];			/* MBAR_PSC + 0x45 */
	volatile uint8  IRCR2;				/* MBAR_PSC + 0x48 */
	volatile uint8  RES13[3];			/* MBAR_PSC + 0x49 */
	volatile uint8  IRSDR;				/* MBAR_PSC + 0x4c */
	volatile uint8  RES14[3];			/* MBAR_PSC + 0x4d */
	volatile uint8  IRMDR;				/* MBAR_PSC + 0x50 */
	volatile uint8  RES15[3];			/* MBAR_PSC + 0x51 */
	volatile uint8  IRFDR;				/* MBAR_PSC + 0x54 */
	volatile uint8  RES16[3];			/* MBAR_PSC + 0x55 */
	volatile uint16 RFNUM;				/* MBAR_PSC + 0x58 */
	volatile uint16 RES17; 				/* MBAR_PSC + 0x5a */
	volatile uint16 TFNUM;				/* MBAR_PSC + 0x5c */
	volatile uint16 RES18;				/* MBAR_PSC + 0x5e */
	volatile uint32 RFDATA;				/* MBAR_PSC + 0x60 */
	volatile uint16 RFSTAT;				/* MBAR_PSC + 0x64 */
	volatile uint16 RES20;				/* MBAR_PSC + 0x66 */
	volatile uint8  RFCNTL;				/* MBAR_PSC + 0x68 */
	volatile uint8  RES21[5];			/* MBAR_PSC + 0x69 */
	volatile uint16 RFALARM;			/* MBAR_PSC + 0x6e */
	volatile uint16 RES22;				/* MBAR_PSC + 0x70 */
	volatile uint16 RFRPTR;				/* MBAR_PSC + 0x72 */
	volatile uint16 RES23;				/* MBAR_PSC + 0x74 */
	volatile uint16 RFWPTR;				/* MBAR_PSC + 0x76 */
	volatile uint16 RES24;				/* MBAR_PSC + 0x78 */
	volatile uint16 RFLRFPTR;			/* MBAR_PSC + 0x7a */
	volatile uint16 RES25;				/* MBAR_PSC + 0x7c */
	volatile uint16 RFLWFPTR;			/* MBAR_PSC + 0x7e */
	volatile uint32 TFDATA;				/* MBAR_PSC + 0x80 */
	volatile uint16 TFSTAT;				/* MBAR_PSC + 0x84 */
	volatile uint16 RES26;				/* MBAR_PSC + 0x86 */
	volatile uint8  TFCNTL;				/* MBAR_PSC + 0x88 */
	volatile uint8  RES27[5];			/* MBAR_PSC + 0x89 */
	volatile uint16 TFALARM;			/* MBAR_PSC + 0x8e */
	volatile uint16 RES28;				/* MBAR_PSC + 0x90 */
	volatile uint16 TFRPTR;				/* MBAR_PSC + 0x92 */
	volatile uint16 RES29;				/* MBAR_PSC + 0x94 */
	volatile uint16 TFWPTR;				/* MBAR_PSC + 0x96 */
	volatile uint16 RES30;				/* MBAR_PSC + 0x98 */
	volatile uint16 TFLRFPTR;			/* MBAR_PSC + 0x9a */
	volatile uint16 RES31;				/* MBAR_PSC + 0x9c */
	volatile uint16 TFLWFPTR;			/* MBAR_PSC + 0x9e */
} psc_regs;

#define PSC_CR_NO_CMD		0x00
#define PSC_CR_RESET_MODE	0x10
#define PSC_CR_RESET_RX		0x20
#define PSC_CR_RESET_TX		0x30
#define PSC_CR_RESET_ERROR	0x40
#define PSC_CR_RESET_BREAK	0x50
#define PSC_CR_START_BREAK	0x60
#define PSC_CR_STOP_BREAK	0x70
#define PSC_CR_NO_ACTION	0x00
#define PSC_CR_ENABLE_TX	0x04
#define PSC_CR_DISABLE_TX	0x08
#define PSC_CR_ENABLE_RX	0x01
#define PSC_CR_DISABLE_RX	0x02

#endif /* MGT5200_PSC_H */
