#ifndef MGT5200_RTCLOCK_H
#define MGT5200_RTCLOCK_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: rtclock.h
* Description: tabasco real time clock header file
* Rev History: see "cvs log rtclock.h"
*
* rtclock.h,v 1.3 2000/10/19 20:05:44 druiz Exp
*
*/

typedef struct rtclock_register_set {
	/* register0 declarations  */	
	volatile uint8 	time_control; 
	volatile uint8 	hour_set; 
	volatile uint8 	minute_set; 
	volatile uint8 	second_set;
	
	/* register1 declarations  */	
	volatile uint8 	date_control; 
	volatile uint8 	month_set; 
	volatile uint8 	weekday_set; 
	volatile uint8 	day_set;
	
	/* register2 declarations  */	
	volatile uint8 write_sw;
	volatile uint8 sw_set;
	volatile uint16 year_set;
	
	/* register3 declarations  */	
	volatile uint8  alm_control;
	volatile uint8  alm_hour_set;
	volatile uint8 	alm_min_set;
	volatile uint8 	time_int_en;	
	
	/* register4 declarations  */	
	volatile uint16 hour_status;
	volatile uint8 	minute_status;
	volatile uint8 	second_status;
	
	/* register5 declarations  */	
	volatile uint8 	month_status;
	volatile uint8 	weekday_status;
	volatile uint16 year_status;

	/* register6 declarations  */
	volatile uint8 	int_alarm; 
	volatile uint8 	int_stopwatch; 
	volatile uint8 	alm_status; 
	volatile uint8 	sw_min_status;
			
	/* register7 declarations  */	
	volatile uint16 int_day; 
	volatile uint8 	int_min; 
	volatile uint8 	int_sec; 
	
	/* register8 declarations */
	volatile uint8	pterm;
	volatile uint8	eterm;	
	volatile uint16	reserved;					
} rtclock_regs;

#endif /* MGT5200_RTCLOCK_H */
