#ifndef MGT5200_SLTIMER_H
#define MGT5200_SLTIMER_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: sltimer.h
* Description: tabasco slice timer header file
* Rev History: see "cvs log sltimer.h"
*
* sltimer.h,v 1.3 2000/08/25 20:08:47 jharms Exp
*
*/

typedef struct sltimer_register_set {
	volatile uint32 slc1_tcount;      /*MBAR_SLTIMER + 0x00*/
	volatile uint8  slc1_enable;      /*MBAR_SLTIMER + 0x04*/
	volatile uint8  RES1[3];          /*MBAR_SLTIMER + 0x05*/
	volatile uint32 slc1_rcount;      /*MBAR_SLTIMER + 0x08*/
	volatile uint8  slc1_status;      /*MBAR_SLTIMER + 0x0C*/
	volatile uint8  RES2[3];          /*MBAR_SLTIMER + 0x0D*/
	volatile uint32 slc2_tcount;      /*MBAR_SLTIMER + 0x10*/
	volatile uint8  slc2_enable;      /*MBAR_SLTIMER + 0x14*/
	volatile uint8  RES3[3];          /*MBAR_SLTIMER + 0x15*/
	volatile uint32 slc2_rcount;      /*MBAR_SLTIMER + 0x18*/
	volatile uint8  slc2_status;      /*MBAR_SLTIMER + 0x1C*/
	volatile uint8  RES4[3];          /*MBAR_SLTIMER + 0x1D*/
	volatile uint32 RES5[24];		  /*MBAR_SLTIMER + 0x20*/
} sltimer_regs;						  /*MBAR_SLTIMER + 0x7F*/

#endif /* MGT5200_SLTIMER_H */
