#ifndef MGT5200_SPI_H
#define MGT5200_SPI_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: spi.h
* Description: tabasco spi header file
* Rev History: see "cvs log spi.h"
*
* spi.h,v 1.3 2001/07/24 17:50:52 weintrit Exp
*
*/

typedef struct spi_register_set {
	volatile uint8 SPICR1;			/* MBAR_SPI + 0x00 */
	volatile uint8 SPICR2;			/* MBAR_SPI + 0x01 */
	volatile uint8 RES1[2];			/* MBAR_SPI + 0x02 */
	volatile uint8 SPIBR;			/* MBAR_SPI + 0x04 */
	volatile uint8 SPISR;			/* MBAR_SPI + 0x05 */
	volatile uint8 RES2[2];			/* MBAR_SPI + 0x06 */
	volatile uint8 SPIRESERV04;		/* MBAR_SPI + 0x08 */
	volatile uint8 SPIDR;			/* MBAR_SPI + 0x09 */
	volatile uint8 RES3[2];			/* MBAR_SPI + 0x0a */
	volatile uint8 SPIPURD;			/* MBAR_SPI + 0x0c */
	volatile uint8 SPIPORT;			/* MBAR_SPI + 0x0d */
	volatile uint8 RES4[2];			/* MBAR_SPI + 0x0e */
	volatile uint8 SPIDDR;			/* MBAR_SPI + 0x10 */
	volatile uint8 SPIRESERV09;		/* MBAR_SPI + 0x11 */
	volatile uint8 RES5[2];			/* MBAR_SPI + 0x12 */
	volatile uint8 SPIRESERV0A;		/* MBAR_SPI + 0x14 */
	volatile uint8 SPIRESERV0B;		/* MBAR_SPI + 0x15 */
} spi_regs;

#define SPI_WCOL_MASK 0x40
#endif /* MGT5200_SPI_H */
