#ifndef MGT5200_XCPCI_H
#define MGT5200_XCPCI_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: xcpci.h
* Description: tabasco xcpci header file
* Rev History: see "cvs log xcpci.h"
*
* xcpci.h,v 1.5 2001/07/24 17:50:52 weintrit Exp
*
*/

typedef struct xcpci_register_set {
	/* PCI Controller Type 0 Configuration Space*/
	/* predefined by the PCI specification and located inside the DWPCI*/

	volatile uint16 dwpci_device_id;			       /* MBAR_XCPCI + 0x00 */
	volatile uint16 dwpci_vendor_id;			       /* MBAR_XCPCI + 0x02 */
	volatile uint16 dwpci_status;				       /* MBAR_XCPCI + 0x04 */
	volatile uint16 dwpci_command;				       /* MBAR_XCPCI + 0x06 */
	volatile uint32 dwpci_cfg_2;				       /* MBAR_XCPCI + 0x08 */
	volatile uint8  dwpci_bist;				           /* MBAR_XCPCI + 0x0c */
	volatile uint8  dwpci_header_type;			       /* MBAR_XCPCI + 0x0d */
	volatile uint8  dwpci_lat_timer;				   /* MBAR_XCPCI + 0x0e */
	volatile uint8  dwpci_cache_size;			       /* MBAR_XCPCI + 0x0f */
	volatile uint32 dwpci_base0;				       /* MBAR_XCPCI + 0x10 */
	volatile uint32 dwpci_base1;				       /* MBAR_XCPCI + 0x14 */
	volatile uint32 dwpci_base2;				       /* MBAR_XCPCI + 0x18 */
	volatile uint32 dwpci_base3;				       /* MBAR_XCPCI + 0x1c */
	volatile uint32 dwpci_base4;				       /* MBAR_XCPCI + 0x20 */
	volatile uint32 dwpci_base5;				       /* MBAR_XCPCI + 0x24 */
	volatile uint32 dwpci_cis;				           /* MBAR_XCPCI + 0x28 */
	volatile uint16 dwpci_subsys_id;				   /* MBAR_XCPCI + 0x2c */
	volatile uint16 dwpci_subsys_vendor_id;		       /* MBAR_XCPCI + 0x2e */
	volatile uint32 dwpci_xrom_base;			       /* MBAR_XCPCI + 0x30 */
	volatile uint32 dwpci_RES0;				       	   /* MBAR_XCPCI + 0x34 */
	volatile uint32 dwpci_RES1;				       	   /* MBAR_XCPCI + 0x38 */
	volatile uint8  dwpci_max_lat;				       /* MBAR_XCPCI + 0x3c */
	volatile uint8  dwpci_min_gnt;				       /* MBAR_XCPCI + 0x3d */
	volatile uint8  dwpci_int_pin;				       /* MBAR_XCPCI + 0x3e */
	volatile uint8  dwpci_int_lin;				       /* MBAR_XCPCI + 0x3f */
	volatile uint32 xcpci_RES0[8];		       		   /* MBAR_XCPCI + 0x40 */

	/* General Control/Status Registers*/
	/* located inside the PCI logic - xcpci_bl*/

	/* Documentation: pcigscr*/
	volatile uint32 xcpci_gscr;                        /* MBAR_XCPCI + 0x60 */

	/* Documentation: pcitbatr0   */
	volatile uint16 xcpci_tbatr0;                      /* MBAR_XCPCI + 0x64 */
	volatile uint16 xcpci_tbatr0_en;                   /* MBAR_XCPCI + 0x66 */

	/* Documentation: pcitbatr1   */
	volatile uint16 xcpci_tbatr1;                      /* MBAR_XCPCI + 0x68 */
	volatile uint16 xcpci_tbatr1_en;                   /* MBAR_XCPCI + 0x6A */

	/* Documentation: pcitcr*/
	volatile uint16 xcpci_tcr;                         /* MBAR_XCPCI + 0x6C */
	volatile uint16 xcpci_reserved_01;                 /* MBAR_XCPCI + 0x6E */

	/* Documentation: pciiw0btar*/
	volatile uint8  xcpci_w0ba;                        /* MBAR_XCPCI + 0x70 */
	volatile uint8  xcpci_w0am;                        /* MBAR_XCPCI + 0x71 */
	volatile uint8  xcpci_w0ta;                        /* MBAR_XCPCI + 0x72 */
	volatile uint8  xcpci_reserved_02;                 /* MBAR_XCPCI + 0x73 */

	/* Documentation: pciiw1btar*/
	volatile uint8  xcpci_w1ba;                        /* MBAR_XCPCI + 0x74 */
	volatile uint8  xcpci_w1am;                        /* MBAR_XCPCI + 0x75 */
	volatile uint8  xcpci_w1ta;                        /* MBAR_XCPCI + 0x76 */
	volatile uint8  xcpci_reserved_03;                 /* MBAR_XCPCI + 0x77 */

	/* Documentation: pciiw2btar*/
	volatile uint8  xcpci_w2ba;                        /* MBAR_XCPCI + 0x78 */
	volatile uint8  xcpci_w2am;                        /* MBAR_XCPCI + 0x79 */
	volatile uint8  xcpci_w2ta;                        /* MBAR_XCPCI + 0x7A */
	volatile uint8  xcpci_reserved_04;                 /* MBAR_XCPCI + 0x7B */

	/* Documentation:  reserved*/
	volatile uint8  xcpci_reserved_05[0x4];            /* MBAR_XCPCI + 0x7c */

	/* Documentation:  pciiwcr */
	volatile uint8  xcpci_w0ctrl;                      /* MBAR_XCPCI + 0x80 */
	volatile uint8  xcpci_w1ctrl;                      /* MBAR_XCPCI + 0x81 */
	volatile uint8  xcpci_w2ctrl;                      /* MBAR_XCPCI + 0x82 */
	volatile uint8  xcpci_reserved_06;                 /* MBAR_XCPCI + 0x83 */

	/* Documentation:  pciicr*/
	volatile uint8  xcpci_ctrl_en;                     /* MBAR_XCPCI + 0x84 */
	volatile uint8  xcpci_reserved_07;                 /* MBAR_XCPCI + 0x85 */
	volatile uint8  xcpci_reserved_08;                 /* MBAR_XCPCI + 0x86 */
	volatile uint8  xcpci_ctrl_retry;                  /* MBAR_XCPCI + 0x87 */

	/* Documentation: pciisr*/
	volatile uint8  xcpci_status;                      /* MBAR_XCPCI + 0x88 */
	volatile uint8  xcpci_reserved_09;                 /* MBAR_XCPCI + 0x89 */
	volatile uint16 xcpci_reserved_0A;                 /* MBAR_XCPCI + 0x8A */

	/* Documentation: reserved*/
	volatile uint8  xcpci_reserved_0B[0x6c];           /* MBAR_XCPCI + 0x8c <-> 0xf4 */

	/* Documentation: pcicar*/
	volatile uint8  xcpci_cfg_en;                      /* MBAR_XCPCI + 0xf8 */ 
	volatile uint8  xcpci_cfg_bus_number;              /* MBAR_XCPCI + 0xf9 */ 
	volatile uint8  xcpci_cfg_dev_fct_number;          /* MBAR_XCPCI + 0xfA */ 
	volatile uint8  xcpci_cfg_dword;                   /* MBAR_XCPCI + 0xfB */ 

	/* Documentation: reserved*/
	volatile uint8  xcpci_reserved_0C[0x4];            /* MBAR_XCPCI + 0xfc */
} xcpci_regs;

#define DWPCI_STATUS_PE		0x8000
#define DWPCI_STATUS_SE		0x4000
#define DWPCI_STATUS_MA		0x2000
#define DWPCI_STATUS_TR		0x1000
#define DWPCI_STATUS_TS		0x0800
#define DWPCI_STATUS_DP		0x0100
#define DWPCI_STATUS_FC		0x0080
#define DWPCI_STATUS_66M	0x0020
#define DWPCI_STATUS_C		0x0010

#define DWPCI_COMMAND_F		0x0200
#define DWPCI_COMMAND_S		0x0100
#define DWPCI_COMMAND_ST	0x0080
#define DWPCI_COMMAND_PER	0x0040
#define DWPCI_COMMAND_V		0x0020
#define DWPCI_COMMAND_MW	0x0010
#define DWPCI_COMMAND_SP	0x0008
#define DWPCI_COMMAND_B		0x0004
#define DWPCI_COMMAND_M		0x0002
#define DWPCI_COMMAND_IO	0x0001

#define XCPCI_GSCR_PE		0x20000000UL
#define XCPCI_GSCR_SE		0x10000000UL
#define XCPCI_GSCR_PEE		0x00002000UL
#define XCPCI_GSCR_SEE		0x00001000UL
#define XCPCI_GSCR_PR		0x00000001UL

#define XCPCI_TBATR0_MASK	0xFFFC0000UL
#define XCPCI_TBATR1_MASK	0xC0000000UL
#define XCPCI_TBATR_SHIFT	16
#define XCPCI_TBATR_EN		0x0001

#define XCPCI_TCR_LD		0x0100
#define XCPCI_TCR_P			0x0001

#define XPCI_WCTRL_IO		0x08
#define XPCI_WCTRL_READMULT	0x04
#define XPCI_WCTRL_READLINE 0x02
#define XPCI_WCTRL_READ		0x00
#define XPCI_WCTRL_EN		0x01

#define XPCI_CTRL_EN_RE		0x04
#define XPCI_CTRL_EN_IAE	0x02
#define XPCI_CTRL_EN_TAE	0x01

#define XCPCI_STATUS_RE		0x04
#define XCPCI_STATUS_IA		0x02
#define XCPCI_STATUS_TA		0x01

#define XCPCI_CFG_EN_ENABLE	0x80

#endif /* MGT5200_XCPCI_H */
