#ifndef MGT5200_XLB_ARB_H
#define MGT5200_XLB_ARB_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: xlb_arb.h
* Description: tabasco xlb arbiter header file
* Rev History: see "cvs log xlb_arb.h"
*
* xlb_arb.h,v 1.3 2000/10/07 00:14:56 li Exp
*
*/

typedef struct xlb_arb_register_set {
	volatile uint32 reserved0;			/* MBAR_XLB_ARB + 0x0000 reserved */
	volatile uint32 reserved1;			/* MBAR_XLB_ARB + 0x0004 reserved */
	volatile uint32 reserved2;			/* MBAR_XLB_ARB + 0x0008 reserved */
	volatile uint32 reserved3;			/* MBAR_XLB_ARB + 0x000c reserved */
	volatile uint32 reserved4;			/* MBAR_XLB_ARB + 0x0010 reserved */
	volatile uint32 reserved5;			/* MBAR_XLB_ARB + 0x0014 reserved */
	volatile uint32 reserved6;			/* MBAR_XLB_ARB + 0x0018 reserved */
	volatile uint32 reserved7;			/* MBAR_XLB_ARB + 0x001c reserved */
	volatile uint32 reserved8;			/* MBAR_XLB_ARB + 0x0020 reserved */
	volatile uint32 reserved9;			/* MBAR_XLB_ARB + 0x0024 reserved */
	volatile uint32 reserved10;			/* MBAR_XLB_ARB + 0x0028 reserved */
	volatile uint32 reserved11;			/* MBAR_XLB_ARB + 0x002c reserved */
	volatile uint32 reserved12;			/* MBAR_XLB_ARB + 0x0030 reserved */
	volatile uint32 reserved13;			/* MBAR_XLB_ARB + 0x0034 reserved */
	volatile uint32 reserved14;			/* MBAR_XLB_ARB + 0x0038 reserved */
	volatile uint32 reserved15;			/* MBAR_XLB_ARB + 0x003c reserved */

	volatile uint32 config;				/* MBAR_XLB_ARB + 0x0040 */
	volatile uint32 version;			/* MBAR_XLB_ARB + 0x0044 read only = 0x0001 */
	volatile uint32 status;				/* MBAR_XLB_ARB + 0x0048 */
	volatile uint32 int_enable;			/* MBAR_XLB_ARB + 0x004c */
	volatile uint32 add_capture;		/* MBAR_XLB_ARB + 0x0050 read only */
	volatile uint32 bus_sig_capture;	/* MBAR_XLB_ARB + 0x0054 read only */
	volatile uint32 add_time_out;		/* MBAR_XLB_ARB + 0x0058 */
	volatile uint32 data_time_out;		/* MBAR_XLB_ARB + 0x005c */
	volatile uint32 bus_time_out;		/* MBAR_XLB_ARB + 0x0060 */
	volatile uint32 priority_enable;	/* MBAR_XLB_ARB + 0x0064 */
	volatile uint32 priority;			/* MBAR_XLB_ARB + 0x0068 */
	volatile uint32 arb_base_addr2;		/* MBAR_XLB_ARB + 0x006c */
	volatile uint32 snoop_window;		/* MBAR_XLB_ARB + 0x0070 */

	volatile uint32 reserved16;			/* MBAR_XLB_ARB + 0x0074 reserved */
	volatile uint32 reserved17;			/* MBAR_XLB_ARB + 0x0078 reserved */
	volatile uint32 reserved18;			/* MBAR_XLB_ARB + 0x007c reserved */

	volatile uint32 control;			/* MBAR_XLB_ARB + 0x0080 */
	volatile uint32 init_total_count;	/* MBAR_XLB_ARB + 0x0084 */
	volatile uint32 int_total_count;	/* MBAR_XLB_ARB + 0x0088 */

	volatile uint32 reserved19;			/* MBAR_XLB_ARB + 0x008c reserved */

	volatile uint32 lower_address;		/* MBAR_XLB_ARB + 0x0090 */
	volatile uint32 higher_address;		/* MBAR_XLB_ARB + 0x0094 */
	volatile uint32 int_window_count;	/* MBAR_XLB_ARB + 0x0098 */
	volatile uint32 window_ter_count;	/* MBAR_XLB_ARB + 0x009c */
} xlb_arb_regs;

#define XLB_ARB_CONFIG_PLDIS		0x80000000UL
#define XLB_ARB_CONFIG_SE			0x00008000UL
#define XLB_ARB_CONFIG_USE_WWF		0x00004000UL
#define XLB_ARB_CONFIG_TBEN			0x00002000UL
#define XLB_ARB_CONFIG_WS			0x00000800UL
#define XLB_ARB_CONFIG_SP_MASK		0x00000700UL
#define XLB_ARB_CONFIG_SP_CORE		0x00000000UL
#define XLB_ARB_CONFIG_SP_USB		0x00000100UL
#define XLB_ARB_CONFIG_SP_BC		0x00000200UL
#define XLB_ARB_CONFIG_SP_PCI		0x00000300UL
#define XLB_ARB_CONFIG_PM_MASK		0x00000060UL
#define XLB_ARB_CONFIG_PM_NO		0x00000000UL
#define XLB_ARB_CONFIG_PM_RCNT		0x00000040UL
#define XLB_ARB_CONFIG_PM_PGM		0x00000060UL
#define XLB_ARB_CONFIG_BA			0x00000008UL
#define XLB_ARB_CONFIG_DT			0x00000004UL
#define XLB_ARB_CONFIG_AT			0x00000002UL

#define XLB_ARB_INT_STATUS_SEA		0x00000100UL
#define XLB_ARB_INT_STATUS_MM		0x00000080UL
#define XLB_ARB_INT_STATUS_TTA		0x00000040UL
#define XLB_ARB_INT_STATUS_TTR		0x00000020UL
#define XLB_ARB_INT_STATUS_ECW		0x00000010UL
#define XLB_ARB_INT_STATUS_TTM		0x00000008UL
#define XLB_ARB_INT_STATUS_BA		0x00000004UL
#define XLB_ARB_INT_STATUS_DT		0x00000002UL
#define XLB_ARB_INT_STATUS_AT		0x00000001UL

#define XLB_ARB_INT_ENABLE_SEAE		0x00000100UL
#define XLB_ARB_INT_ENABLE_MME		0x00000080UL
#define XLB_ARB_INT_ENABLE_TTAE		0x00000040UL
#define XLB_ARB_INT_ENABLE_TTRE		0x00000020UL
#define XLB_ARB_INT_ENABLE_ECWE		0x00000010UL
#define XLB_ARB_INT_ENABLE_TTME		0x00000008UL
#define XLB_ARB_INT_ENABLE_BAE		0x00000004UL
#define XLB_ARB_INT_ENABLE_DTE		0x00000002UL
#define XLB_ARB_INT_ENABLE_ATE		0x00000001UL

#endif /* TABASCO_XLB_ARB_H */
