/******************************************************************************
*
*       COPYRIGHT (c) 2001-2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
*       The code is the property of Motorola.
*
*       The copyright notice above does not evidence any
*       actual or intended publication of such source code.
*
* Filename:     $Source: /proj/cvsroot/mgt/MGT5200/apps/AC97Sample/modules/Core/core5200.h,v $
* Author:       $Author: ra6707 $
* Locker:       $Locker:  $
* State:        $State: Exp $
* Revision:     $Revision: 1.1 $
*
* Functions:    
*
* History:      Use the RCS command rlog to display revision history
*               information.
*
* Description:  
*
* Notes:                
*
******************************************************************************/

#ifndef __CORE5200_H
#define __CORE5200_H

#include "ppctypes.h"

/*! Macro to insert an eieio instruction. */
#define EIEIO	asm {eieio}

/*! Macro to insert an isync instruction. */
#define ISYNC	asm {isync}

/*! Macro to insert a sync instruction. */
#define SYNC	asm {sync}

/*--------------------------------------------------------------------------
   Macro       : setbit(v,m)
   Description : Sets the bits set to 1 in m to 1 in v.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define setbit(v,m)		((v)|=(m))

/*--------------------------------------------------------------------------
   Macro       : clrbit(v,m)
   Description : Sets the bits set to 1 in m to 0 in v.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define clrbit(v,m)		((v)&=~(m))

/*--------------------------------------------------------------------------
   Macro       : togglebit(v,m)
   Description : Inverts the bits set to 1 in m in v, i.e. toggles them.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define togglebit(r,b)	((v)^=(m))

void initDCache (int copyback);
void enableDCache (void);
void disableDCache (void);
void flushDCache (uint32 address, uint32 length);
void enableICache (void);
void disableICache (void);
void lockICache (void);
void unlockICache (void);

uint32 readMBAR (void);
uint32 writeMBAR (uint32 mbar);
uint32 readRSP (void);

uint32 readMSR (void);
void writeMSR (uint32 msr);
uint64 readTBx (void);
void writeTBx (uint32 tbu, uint32 tbl);
uint32 readDEC (void);
void writeDEC (uint32 dec);
uint32 readPVR (void);
uint32 readSVR (void);

uint32 readHID0 (void);
void writeHID0 (uint32 hid0);
uint32 readHID1 (void);
void writeHID1 (uint32 hid1);
uint32 readHID2 (void);
void writeHID2 (uint32 hid2);

uint32 readDBAT0U (void);
void writeDBAT0U (uint32 dbat0u);
uint32 readDBAT0L (void);
void writeDBAT0L (uint32 dbat0l);
uint32 readDBAT1U (void);
void writeDBAT1U (uint32 dbat1u);
uint32 readDBAT1L (void);
void writeDBAT1L (uint32 dbat1l);
uint32 readDBAT2U (void);
void writeDBAT2U (uint32 dbat2u);
uint32 readDBAT2L (void);
void writeDBAT2L (uint32 dbat2l);
uint32 readDBAT3U (void);
void writeDBAT3U (uint32 dbat3u);
uint32 readDBAT3L (void);
void writeDBAT3L (uint32 dbat3l);
uint32 readDBAT4U (void);
void writeDBAT4U (uint32 dbat4u);
uint32 readDBAT4L (void);
void writeDBAT4L (uint32 dbat4l);
uint32 readDBAT5U (void);
void writeDBAT5U (uint32 dbat5u);
uint32 readDBAT5L (void);
void writeDBAT5L (uint32 dbat5l);
uint32 readDBAT6U (void);
void writeDBAT6U (uint32 dbat6u);
uint32 readDBAT6L (void);
void writeDBAT6L (uint32 dbat6l);
uint32 readDBAT7U (void);
void writeDBAT7U (uint32 dbat7u);
uint32 readDBAT7L (void);
void writeDBAT7L (uint32 dbat7l);

uint32 readIBAT0U (void);
void writeIBAT0U (uint32 ibat0u);
uint32 readIBAT0L (void);
void writeIBAT0L (uint32 ibat0l);
uint32 readIBAT1U (void);
void writeIBAT1U (uint32 ibat1u);
uint32 readIBAT1L (void);
void writeIBAT1L (uint32 ibat1l);
uint32 readIBAT2U (void);
void writeIBAT2U (uint32 ibat2u);
uint32 readIBAT2L (void);
void writeIBAT2L (uint32 ibat2l);
uint32 readIBAT3U (void);
void writeIBAT3U (uint32 ibat3u);
uint32 readIBAT3L (void);
void writeIBAT3L (uint32 ibat3l);
uint32 readIBAT4U (void);
void writeIBAT4U (uint32 ibat4u);
uint32 readIBAT4L (void);
void writeIBAT4L (uint32 ibat4l);
uint32 readIBAT5U (void);
void writeIBAT5U (uint32 ibat5u);
uint32 readIBAT5L (void);
void writeIBAT5L (uint32 ibat5l);
uint32 readIBAT6U (void);
void writeIBAT6U (uint32 ibat6u);
uint32 readIBAT6L (void);
void writeIBAT6L (uint32 ibat6l);
uint32 readIBAT7U (void);
void writeIBAT7U (uint32 ibat7u);
uint32 readIBAT7L (void);
void writeIBAT7L (uint32 ibat7l);
void writeSRR0 (uint32 srr0);
void writeSRR1 (uint32 srr1);

#endif
