/******************************************************************************
*
*       COPYRIGHT (c) 2001-2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
*       The code is the property of Motorola.
*
*       The copyright notice above does not evidence any
*       actual or intended publication of such source code.
*
* Filename:     $Source: /proj/cvsroot/mgt/MGT5200/apps/AC97Sample/modules/Exceptions/exc5xxx.h,v $
* Author:       $Author: ra6707 $
* Locker:       $Locker:  $
* State:        $State: Exp $
* Revision:     $Revision: 1.1 $
*
* Functions:    
*
* History:      Use the RCS command rlog to display revision history
*               information.
*
* Description:  
*
* Notes:                
*
******************************************************************************/

#ifndef __EXC5100_H
#define __EXC5100_H

/*
 * Exception Vectors
 */
/*! \brief System Reset exception vector */
#define EXC_SYSTEM_RESET	0x0100
/*! \brief Machine Check exception vector */
#define EXC_MACHINE_CHECK	0x0200
/*! \brief Data Storage Interrupt exception vector */
#define EXC_DSI				0x0300
/*! \brief Instruction Storage Interrupt exception vector */
#define EXC_ISI				0x0400
/*! \brief External Interrupt exception vector */
#define EXC_EXTERNAL_INT	0x0500
/*! \brief Alignment exception vector */
#define EXC_ALIGNMENT		0x0600
/*! \brief Program exception vector */
#define EXC_PROGRAM			0x0700
/*! \brief Floating Point Unavailable exception vector */
#define EXC_FP_UNAVAILABLE	0x0800
/*! \brief Decrementer exception vector */
#define EXC_DECREMENTER		0x0900
/*! \brief Critical Interrupt exception vector */
#define EXC_CRITICAL_INT	0x0A00
/*! \brief System Call exception vector */
#define EXC_SYSTEM_CALL		0x0C00
/*! \brief Trace exception vector */
#define EXC_TRACE			0x0D00
/*! \brief Floating Point Assist exception vector */
#define EXC_FP_ASSIST		0x0E00
/*! \brief Instruction TLB Miss exception vector */
#define EXC_ITLB_MISS		0x1000
/*! \brief Data TLB Miss on Load exception vector */
#define EXC_DTLB_MISS_LOAD	0x1100
/*! \brief Data TLB Miss on Store exception vector */
#define EXC_DTLB_MISS_STORE	0x1200
/*! \brief Instruction Address Breakpoint exception vector */
#define EXC_IABREAK			0x1300
/*! \brief System Management Interrupt exception vector */
#define EXC_SMI				0x1400

int exceptionRegister (int vector, int priority, int (*handler) (void *, void *), void *arg0, void *arg1);
int exceptionRemove (int (*handler) (void *, void *));

#endif
