/******************************************************************************
*
*       COPYRIGHT (c) 2001-2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
*       The code is the property of Motorola.
*
*       The copyright notice above does not evidence any
*       actual or intended publication of such source code.
*
* Filename:     $Source: /proj/cvsroot/mgt/MGT5200/apps/AC97Sample/modules/Time/time5xxx.c,v $
* Author:       $Author: ra6707 $
* Locker:       $Locker:  $
* State:        $State: Exp $
* Revision:     $Revision: 1.1 $
*
* Functions:    
*
* History:      Use the RCS command rlog to display revision history
*               information.
*
* Description:  
*
* Notes:                
*
******************************************************************************/

#include "ppctypes.h"

#include "configure.h"

#if !((defined(MGT5100) ^ defined(MGT5200) ^ defined(MPC5200B)) & \
     !(defined(MGT5100) & defined(MGT5200) & defined(MPC5200B)))
	#error Either MGT5100, MGT5200 or MPC5200B has to be defined.
#endif

#if defined(MPC5200B)
	#include "mpc5200b/mpc5200b.h"
	#include "mpc5200b/xlb_arb.h"
#elif defined(MGT5200)
	#include "mgt5200/mgt5200.h"
	#include "mgt5200/xlb_arb.h"
#elif defined(MGT5100)
	#include "mgt5100/mgt5100.h"
	#include "mgt5100/xlb_arb.h"
#endif

#if defined(MPC5200B) || defined (MGT5200)
	#include "core5200.h"
	#include "freq5200.h"
#elif defined(MGT5100)
	#include "core5100.h"
	#include "freq5100.h"
#endif

#include "time5xxx.h"

/*! \file time5xxx.c
 * \brief Functions to measure time and to wait.
 *
 * ATTENTION: These functions will fail if the program runs for more than
 * (2^32)-1 ms (more than 8 years) without resetting the timer (timeReset ()).
 */

/*! \brief 
 * Initialize timer module.
 *
 * This function must be called before calling any other timer module function.
 */
void timeInit (void)
{
#ifdef MGT5200
	xlb_arb_regs *xlb_arb;
	
	xlb_arb = (xlb_arb_regs *) (readMBAR () + MBAR_XLB_ARB);
	
	xlb_arb->config |= 0x00002000UL; /* Enable Timebase counter */
#endif
}

/*! \brief Reset timer to zero.
 */
void timeReset (void)
{
	writeTBx (0,0);
}

/*! \brief Return time expired since last timer reset in Milliseconds.
 */
uint32 timeRead (void)
{
#ifdef XLB_FREQ
	return (uint32) (readTBx () / (XLB_FREQ / 4000));
#else			
	return (uint32) (readTBx () / (freqXLB () / 4000));
#endif
}

/*! \brief Wait for the time specified in Milliseconds.
 *
 * \param	ms	Time to wait in Milliseconds.
 */
void timeWaitms (uint32 ms)
{
	uint32 now;
	
	now = timeRead ();
	while (now + ms > timeRead ()) {};
}

void timeWaitus (uint32 us)
{
	uint64 fin;
	
#ifdef XLB_FREQ
	fin = readTBx () + ((((uint64) XLB_FREQ) * ((uint64) us)) / 4000000ULL);
#else			
	fin = readTBx () + ((((uint64) freqXLB ()) * ((uint64) us)) / 4000000ULL);
#endif
	while (readTBx () < fin) {};
}
