*-----------------------------------------------------------------------*
*   b2d -- Convert unsigned binary number in A register to a string
*          of 2 bcd digits at location pointed to by X register.
*          Number assumed to be from 0 to 99.
*          String begins with high order digit and continues upward 
*          in memory to low order digit.
*
*       1/23/87
*       D. G. Weiss
*       MCU Technical Marketing
*       Motorola Microprocessor Group
*       Oak Hill, TX
*-----------------------------------------------------------------------*

b2d     sta     z           1 4  X^ := 0
        clra                2 4
        sta     ,x          1 4
        lda     z           1 4
b2d06   inc     ,x          1 4  Repeat X^ += 1
        sub     #10         2 4     A -= {radix} Y
        bhs     b2d06       1 4     Until A < 0
        dec     ,x          1 4  X^ -= 1  {restore X^}
        add     #10         2 4  A += Y   {restore A}
        incx                1 4  X += 1
        sta     ,x          1 4  X^ := A {units}
        rts                 1 2
*                         --- ---
*                      12  15 94 -> 188 uS
*                             A assumed = 40.
*
*
