/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       M9S12XF512.h
\brief      S12XF512 peripheral definitions 
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\warning    This preliminary release does not include all S12XF512 peripheral 
            modules, verify the modules currently defined.
\date       March/09/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/
                           
#ifndef _M9S12XF512_H       /* Prevent duplicated includes */
#define _M9S12XF512_H

/* Types definition */
typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef unsigned long dlong[2];

#define REG_BASE 0x0000     /* Base address for the I/O register block */

#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */

/*This guarantee correct bitfield positions*/
#pragma OPTION ADD V30toV31Compatible "-BfaGapLimitBits4294967295"


#if (__MWERKS__)
  #pragma MESSAGE DISABLE C1106
#endif


#include "S12XMMC.h"    /* Memory Mapping Control */
#include "S12XFPIM.h"   /* Port Integration Module */
#include "S12XECRG.h"   /* Clocks and Reset Generator */          
#include "S12INT.h"     /* Interrupts */
#include "S12ECT.h"     /* Enhanced Capture Timer */
#include "S12SPI.h"     /* Serial Peripheral Interface */
#include "S12MSCAN.h"   /* Controller Area Network */
#include "S12XFRIPLL.h" /* Internal PLL */
#include "S12XFR.h"     /* FlexRay */
#include "S12XGATE.h"   /* XGATE */


#endif

/*******************************************************************************/