/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       S12XFPIM.h
\brief      S12XF512 Port Integration Module definitions 
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\date       March/09/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

#ifndef S12XFPIM_H         /*prevent duplicated includes */
#define S12XFPIM_H


/*------------------------------------------------------------------------------*/

/*** PORTAB - Port AB; 0x00000000 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTA - Port A Register; 0x00000000 ***/
    union {
      byte Byte;
      struct {
        byte PA0         :1;                                       /* Port A Bit 0 */
        byte PA1         :1;                                       /* Port A Bit 1 */
        byte PA2         :1;                                       /* Port A Bit 2 */
        byte PA3         :1;                                       /* Port A Bit 3 */
        byte PA4         :1;                                       /* Port A Bit 4 */
        byte PA5         :1;                                       /* Port A Bit 5 */
        byte PA6         :1;                                       /* Port A Bit 6 */
        byte PA7         :1;                                       /* Port A Bit 7 */
      } Bits;
    } PORTASTR;
    #define PORTA                       _PORTAB.Overlap_STR.PORTASTR.Byte
    #define PORTA_PA0                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA0
    #define PORTA_PA1                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA1
    #define PORTA_PA2                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA2
    #define PORTA_PA3                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA3
    #define PORTA_PA4                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA4
    #define PORTA_PA5                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA5
    #define PORTA_PA6                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA6
    #define PORTA_PA7                   _PORTAB.Overlap_STR.PORTASTR.Bits.PA7
    
    
    #define PORTA_PA0_MASK              1
    #define PORTA_PA1_MASK              2
    #define PORTA_PA2_MASK              4
    #define PORTA_PA3_MASK              8
    #define PORTA_PA4_MASK              16
    #define PORTA_PA5_MASK              32
    #define PORTA_PA6_MASK              64
    #define PORTA_PA7_MASK              128
    
    
    /*** PORTB - Port B Register; 0x00000001 ***/
    union {
      byte Byte;
      struct {
        byte PB0         :1;                                       /* Port B Bit 0 */
        byte PB1         :1;                                       /* Port B Bit 1 */
        byte PB2         :1;                                       /* Port B Bit 2 */
        byte PB3         :1;                                       /* Port B Bit 3 */
        byte PB4         :1;                                       /* Port B Bit 4 */
        byte PB5         :1;                                       /* Port B Bit 5 */
        byte PB6         :1;                                       /* Port B Bit 6 */
        byte PB7         :1;                                       /* Port B Bit 7 */
      } Bits;
    } PORTBSTR;
    #define PORTB                       _PORTAB.Overlap_STR.PORTBSTR.Byte
    #define PORTB_PB0                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB0
    #define PORTB_PB1                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB1
    #define PORTB_PB2                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB2
    #define PORTB_PB3                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB3
    #define PORTB_PB4                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB4
    #define PORTB_PB5                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB5
    #define PORTB_PB6                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB6
    #define PORTB_PB7                   _PORTAB.Overlap_STR.PORTBSTR.Bits.PB7
    
    
    #define PORTB_PB0_MASK              1
    #define PORTB_PB1_MASK              2
    #define PORTB_PB2_MASK              4
    #define PORTB_PB3_MASK              8
    #define PORTB_PB4_MASK              16
    #define PORTB_PB5_MASK              32
    #define PORTB_PB6_MASK              64
    #define PORTB_PB7_MASK              128

  } Overlap_STR;

  struct {
    word PB0         :1;                                       /* Port B Bit 0 */
    word PB1         :1;                                       /* Port B Bit 1 */
    word PB2         :1;                                       /* Port B Bit 2 */
    word PB3         :1;                                       /* Port B Bit 3 */
    word PB4         :1;                                       /* Port B Bit 4 */
    word PB5         :1;                                       /* Port B Bit 5 */
    word PB6         :1;                                       /* Port B Bit 6 */
    word PB7         :1;                                       /* Port B Bit 7 */
    word PA0         :1;                                       /* Port A Bit 0 */
    word PA1         :1;                                       /* Port A Bit 1 */
    word PA2         :1;                                       /* Port A Bit 2 */
    word PA3         :1;                                       /* Port A Bit 3 */
    word PA4         :1;                                       /* Port A Bit 4 */
    word PA5         :1;                                       /* Port A Bit 5 */
    word PA6         :1;                                       /* Port A Bit 6 */
    word PA7         :1;                                       /* Port A Bit 7 */
  } Bits;
  struct {
    word grpPB   :8;
    word grpPA   :8;
  } MergedBits;
} PORTABSTR;
extern volatile PORTABSTR _PORTAB @(REG_BASE + 0x00000000);
#define PORTAB                          _PORTAB.Word
#define PORTAB_PB0                      _PORTAB.Bits.PB0
#define PORTAB_PB1                      _PORTAB.Bits.PB1
#define PORTAB_PB2                      _PORTAB.Bits.PB2
#define PORTAB_PB3                      _PORTAB.Bits.PB3
#define PORTAB_PB4                      _PORTAB.Bits.PB4
#define PORTAB_PB5                      _PORTAB.Bits.PB5
#define PORTAB_PB6                      _PORTAB.Bits.PB6
#define PORTAB_PB7                      _PORTAB.Bits.PB7
#define PORTAB_PA0                      _PORTAB.Bits.PA0
#define PORTAB_PA1                      _PORTAB.Bits.PA1
#define PORTAB_PA2                      _PORTAB.Bits.PA2
#define PORTAB_PA3                      _PORTAB.Bits.PA3
#define PORTAB_PA4                      _PORTAB.Bits.PA4
#define PORTAB_PA5                      _PORTAB.Bits.PA5
#define PORTAB_PA6                      _PORTAB.Bits.PA6
#define PORTAB_PA7                      _PORTAB.Bits.PA7
#define PORTAB_PB                       _PORTAB.MergedBits.grpPB
#define PORTAB_PA                       _PORTAB.MergedBits.grpPA

#define PORTAB_PB0_MASK                 1
#define PORTAB_PB1_MASK                 2
#define PORTAB_PB2_MASK                 4
#define PORTAB_PB3_MASK                 8
#define PORTAB_PB4_MASK                 16
#define PORTAB_PB5_MASK                 32
#define PORTAB_PB6_MASK                 64
#define PORTAB_PB7_MASK                 128
#define PORTAB_PA0_MASK                 256
#define PORTAB_PA1_MASK                 512
#define PORTAB_PA2_MASK                 1024
#define PORTAB_PA3_MASK                 2048
#define PORTAB_PA4_MASK                 4096
#define PORTAB_PA5_MASK                 8192
#define PORTAB_PA6_MASK                 16384
#define PORTAB_PA7_MASK                 32768
#define PORTAB_PB_MASK                  255
#define PORTAB_PB_BITNUM                0
#define PORTAB_PA_MASK                  65280
#define PORTAB_PA_BITNUM                8


/*** DDRAB - Port AB Data Direction; 0x00000002 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRA - Port A Data Direction Register; 0x00000002 ***/
    union {
      byte Byte;
      struct {
        byte DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
        byte DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
        byte DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
        byte DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
        byte DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
        byte DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
        byte DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
        byte DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
      } Bits;
    } DDRASTR;
    #define DDRA                        _DDRAB.Overlap_STR.DDRASTR.Byte
    #define DDRA_DDRA0                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA0
    #define DDRA_DDRA1                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA1
    #define DDRA_DDRA2                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA2
    #define DDRA_DDRA3                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA3
    #define DDRA_DDRA4                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA4
    #define DDRA_DDRA5                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA5
    #define DDRA_DDRA6                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA6
    #define DDRA_DDRA7                  _DDRAB.Overlap_STR.DDRASTR.Bits.DDRA7
    
    
    #define DDRA_DDRA0_MASK             1
    #define DDRA_DDRA1_MASK             2
    #define DDRA_DDRA2_MASK             4
    #define DDRA_DDRA3_MASK             8
    #define DDRA_DDRA4_MASK             16
    #define DDRA_DDRA5_MASK             32
    #define DDRA_DDRA6_MASK             64
    #define DDRA_DDRA7_MASK             128


    /*** DDRB - Port B Data Direction Register; 0x00000003 ***/
    union {
      byte Byte;
      struct {
        byte DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
        byte DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
        byte DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
        byte DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
        byte DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
        byte DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
        byte DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
        byte DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
      } Bits;
    } DDRBSTR;
    #define DDRB                        _DDRAB.Overlap_STR.DDRBSTR.Byte
    #define DDRB_DDRB0                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB0
    #define DDRB_DDRB1                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB1
    #define DDRB_DDRB2                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB2
    #define DDRB_DDRB3                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB3
    #define DDRB_DDRB4                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB4
    #define DDRB_DDRB5                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB5
    #define DDRB_DDRB6                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB6
    #define DDRB_DDRB7                  _DDRAB.Overlap_STR.DDRBSTR.Bits.DDRB7
    
    
    #define DDRB_DDRB0_MASK             1
    #define DDRB_DDRB1_MASK             2
    #define DDRB_DDRB2_MASK             4
    #define DDRB_DDRB3_MASK             8
    #define DDRB_DDRB4_MASK             16
    #define DDRB_DDRB5_MASK             32
    #define DDRB_DDRB6_MASK             64
    #define DDRB_DDRB7_MASK             128

  } Overlap_STR;

  struct {
    word DDRB0       :1;                                       /* Data Direction Port B Bit 0 */
    word DDRB1       :1;                                       /* Data Direction Port B Bit 1 */
    word DDRB2       :1;                                       /* Data Direction Port B Bit 2 */
    word DDRB3       :1;                                       /* Data Direction Port B Bit 3 */
    word DDRB4       :1;                                       /* Data Direction Port B Bit 4 */
    word DDRB5       :1;                                       /* Data Direction Port B Bit 5 */
    word DDRB6       :1;                                       /* Data Direction Port B Bit 6 */
    word DDRB7       :1;                                       /* Data Direction Port B Bit 7 */
    word DDRA0       :1;                                       /* Data Direction Port A Bit 0 */
    word DDRA1       :1;                                       /* Data Direction Port A Bit 1 */
    word DDRA2       :1;                                       /* Data Direction Port A Bit 2 */
    word DDRA3       :1;                                       /* Data Direction Port A Bit 3 */
    word DDRA4       :1;                                       /* Data Direction Port A Bit 4 */
    word DDRA5       :1;                                       /* Data Direction Port A Bit 5 */
    word DDRA6       :1;                                       /* Data Direction Port A Bit 6 */
    word DDRA7       :1;                                       /* Data Direction Port A Bit 7 */
  } Bits;
  struct {
    word grpDDRB :8;
    word grpDDRA :8;
  } MergedBits;
} DDRABSTR;
extern volatile DDRABSTR _DDRAB @(REG_BASE + 0x00000002);
#define DDRAB                           _DDRAB.Word
#define DDRAB_DDRB0                     _DDRAB.Bits.DDRB0
#define DDRAB_DDRB1                     _DDRAB.Bits.DDRB1
#define DDRAB_DDRB2                     _DDRAB.Bits.DDRB2
#define DDRAB_DDRB3                     _DDRAB.Bits.DDRB3
#define DDRAB_DDRB4                     _DDRAB.Bits.DDRB4
#define DDRAB_DDRB5                     _DDRAB.Bits.DDRB5
#define DDRAB_DDRB6                     _DDRAB.Bits.DDRB6
#define DDRAB_DDRB7                     _DDRAB.Bits.DDRB7
#define DDRAB_DDRA0                     _DDRAB.Bits.DDRA0
#define DDRAB_DDRA1                     _DDRAB.Bits.DDRA1
#define DDRAB_DDRA2                     _DDRAB.Bits.DDRA2
#define DDRAB_DDRA3                     _DDRAB.Bits.DDRA3
#define DDRAB_DDRA4                     _DDRAB.Bits.DDRA4
#define DDRAB_DDRA5                     _DDRAB.Bits.DDRA5
#define DDRAB_DDRA6                     _DDRAB.Bits.DDRA6
#define DDRAB_DDRA7                     _DDRAB.Bits.DDRA7
#define DDRAB_DDRB                      _DDRAB.MergedBits.grpDDRB
#define DDRAB_DDRA                      _DDRAB.MergedBits.grpDDRA

#define DDRAB_DDRB0_MASK                1
#define DDRAB_DDRB1_MASK                2
#define DDRAB_DDRB2_MASK                4
#define DDRAB_DDRB3_MASK                8
#define DDRAB_DDRB4_MASK                16
#define DDRAB_DDRB5_MASK                32
#define DDRAB_DDRB6_MASK                64
#define DDRAB_DDRB7_MASK                128
#define DDRAB_DDRA0_MASK                256
#define DDRAB_DDRA1_MASK                512
#define DDRAB_DDRA2_MASK                1024
#define DDRAB_DDRA3_MASK                2048
#define DDRAB_DDRA4_MASK                4096
#define DDRAB_DDRA5_MASK                8192
#define DDRAB_DDRA6_MASK                16384
#define DDRAB_DDRA7_MASK                32768
#define DDRAB_DDRB_MASK                 255
#define DDRAB_DDRB_BITNUM               0
#define DDRAB_DDRA_MASK                 65280
#define DDRAB_DDRA_BITNUM               8



/*** PUCR - Pull-Up Control Register; 0x0000000C ***/
typedef union {
  byte Byte;
  struct {
    byte PUPAE       :1;                                       /* Pull-Up Port A Enable */
    byte PUPBE       :1;                                       /* Pull-Up Port B Enable */
    byte PUPCE       :1;                                       /* Pull-Up Port C Enable */
    byte PUPDE       :1;                                       /* Pull-Up Port D Enable */
    byte PUPEE       :1;                                       /* Pull-Up Port E Enable */
    byte             :1; 
    byte BKPUE       :1;                                       /* BKGD and VREGEN Pin Pull-up Enable */
    byte PUPKE       :1;                                       /* Pull-Up Port K Enable */
  } Bits;
} PUCRSTR;
extern volatile PUCRSTR _PUCR @(REG_BASE + 0x0000000C);
#define PUCR                            _PUCR.Byte
#define PUCR_PUPAE                      _PUCR.Bits.PUPAE
#define PUCR_PUPBE                      _PUCR.Bits.PUPBE
#define PUCR_PUPCE                      _PUCR.Bits.PUPCE
#define PUCR_PUPDE                      _PUCR.Bits.PUPDE
#define PUCR_PUPEE                      _PUCR.Bits.PUPEE
#define PUCR_BKPUE                      _PUCR.Bits.BKPUE
#define PUCR_PUPKE                      _PUCR.Bits.PUPKE

#define PUCR_PUPAE_MASK                 1
#define PUCR_PUPBE_MASK                 2
#define PUCR_PUPCE_MASK                 4
#define PUCR_PUPDE_MASK                 8
#define PUCR_PUPEE_MASK                 16
#define PUCR_BKPUE_MASK                 64
#define PUCR_PUPKE_MASK                 128


/*** RDRIV - Reduced Drive of I/O Lines; 0x0000000D ***/
typedef union {
  byte Byte;
  struct {
    byte RDPA        :1;                                       /* Reduced Drive of Port A */
    byte RDPB        :1;                                       /* Reduced Drive of Port B */
    byte RDPC        :1;                                       /* Reduced Drive of Port C */
    byte RDPD        :1;                                       /* Reduced Drive of Port D */
    byte RDPE        :1;                                       /* Reduced Drive of Port E */
    byte             :1; 
    byte             :1; 
    byte RDPK        :1;                                       /* Reduced Drive of Port K */
  } Bits;
  struct {
    byte grpRDPx :5;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} RDRIVSTR;
extern volatile RDRIVSTR _RDRIV @(REG_BASE + 0x0000000D);
#define RDRIV                           _RDRIV.Byte
#define RDRIV_RDPA                      _RDRIV.Bits.RDPA
#define RDRIV_RDPB                      _RDRIV.Bits.RDPB
#define RDRIV_RDPC                      _RDRIV.Bits.RDPC
#define RDRIV_RDPD                      _RDRIV.Bits.RDPD
#define RDRIV_RDPE                      _RDRIV.Bits.RDPE
#define RDRIV_RDPK                      _RDRIV.Bits.RDPK
#define RDRIV_RDPx                      _RDRIV.MergedBits.grpRDPx

#define RDRIV_RDPA_MASK                 1
#define RDRIV_RDPB_MASK                 2
#define RDRIV_RDPC_MASK                 4
#define RDRIV_RDPD_MASK                 8
#define RDRIV_RDPE_MASK                 16
#define RDRIV_RDPK_MASK                 128
#define RDRIV_RDPx_MASK                 31
#define RDRIV_RDPx_BITNUM               0
/*------------------------------------------------------------------------------*/

/*** PORTCD - Port CD; 0x00000004 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PORTC - Port C Register; 0x00000004 ***/
    union {
      byte Byte;
      struct {
        byte PC0         :1;                                       /* Port C Bit 0 */
        byte PC1         :1;                                       /* Port C Bit 1 */
        byte PC2         :1;                                       /* Port C Bit 2 */
        byte PC3         :1;                                       /* Port C Bit 3 */
        byte PC4         :1;                                       /* Port C Bit 4 */
        byte PC5         :1;                                       /* Port C Bit 5 */
        byte PC6         :1;                                       /* Port C Bit 6 */
        byte PC7         :1;                                       /* Port C Bit 7 */
      } Bits;
    } PORTCSTR;
    #define PORTC                       _PORTCD.Overlap_STR.PORTCSTR.Byte
    #define PORTC_PC0                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC0
    #define PORTC_PC1                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC1
    #define PORTC_PC2                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC2
    #define PORTC_PC3                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC3
    #define PORTC_PC4                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC4
    #define PORTC_PC5                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC5
    #define PORTC_PC6                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC6
    #define PORTC_PC7                   _PORTCD.Overlap_STR.PORTCSTR.Bits.PC7
    
    
    #define PORTC_PC0_MASK              1
    #define PORTC_PC1_MASK              2
    #define PORTC_PC2_MASK              4
    #define PORTC_PC3_MASK              8
    #define PORTC_PC4_MASK              16
    #define PORTC_PC5_MASK              32
    #define PORTC_PC6_MASK              64
    #define PORTC_PC7_MASK              128


    /*** PORTD - Port D Register; 0x00000005 ***/
    union {
      byte Byte;
      struct {
        byte PD0         :1;                                       /* Port D Bit 0 */
        byte PD1         :1;                                       /* Port D Bit 1 */
        byte PD2         :1;                                       /* Port D Bit 2 */
        byte PD3         :1;                                       /* Port D Bit 3 */
        byte PD4         :1;                                       /* Port D Bit 4 */
        byte PD5         :1;                                       /* Port D Bit 5 */
        byte PD6         :1;                                       /* Port D Bit 6 */
        byte PD7         :1;                                       /* Port D Bit 7 */
      } Bits;
    } PORTDSTR;
    #define PORTD                       _PORTCD.Overlap_STR.PORTDSTR.Byte
    #define PORTD_PD0                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD0
    #define PORTD_PD1                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD1
    #define PORTD_PD2                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD2
    #define PORTD_PD3                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD3
    #define PORTD_PD4                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD4
    #define PORTD_PD5                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD5
    #define PORTD_PD6                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD6
    #define PORTD_PD7                   _PORTCD.Overlap_STR.PORTDSTR.Bits.PD7
    
    
    #define PORTD_PD0_MASK              1
    #define PORTD_PD1_MASK              2
    #define PORTD_PD2_MASK              4
    #define PORTD_PD3_MASK              8
    #define PORTD_PD4_MASK              16
    #define PORTD_PD5_MASK              32
    #define PORTD_PD6_MASK              64
    #define PORTD_PD7_MASK              128

  } Overlap_STR;

  struct {
    word PD0         :1;                                       /* Port D Bit 0 */
    word PD1         :1;                                       /* Port D Bit 1 */
    word PD2         :1;                                       /* Port D Bit 2 */
    word PD3         :1;                                       /* Port D Bit 3 */
    word PD4         :1;                                       /* Port D Bit 4 */
    word PD5         :1;                                       /* Port D Bit 5 */
    word PD6         :1;                                       /* Port D Bit 6 */
    word PD7         :1;                                       /* Port D Bit 7 */
    word PC0         :1;                                       /* Port C Bit 0 */
    word PC1         :1;                                       /* Port C Bit 1 */
    word PC2         :1;                                       /* Port C Bit 2 */
    word PC3         :1;                                       /* Port C Bit 3 */
    word PC4         :1;                                       /* Port C Bit 4 */
    word PC5         :1;                                       /* Port C Bit 5 */
    word PC6         :1;                                       /* Port C Bit 6 */
    word PC7         :1;                                       /* Port C Bit 7 */
  } Bits;
  struct {
    word grpPD   :8;
    word grpPC   :8;
  } MergedBits;
} PORTCDSTR;
extern volatile PORTCDSTR _PORTCD @(REG_BASE + 0x00000004);
#define PORTCD                          _PORTCD.Word
#define PORTCD_PD0                      _PORTCD.Bits.PD0
#define PORTCD_PD1                      _PORTCD.Bits.PD1
#define PORTCD_PD2                      _PORTCD.Bits.PD2
#define PORTCD_PD3                      _PORTCD.Bits.PD3
#define PORTCD_PD4                      _PORTCD.Bits.PD4
#define PORTCD_PD5                      _PORTCD.Bits.PD5
#define PORTCD_PD6                      _PORTCD.Bits.PD6
#define PORTCD_PD7                      _PORTCD.Bits.PD7
#define PORTCD_PC0                      _PORTCD.Bits.PC0
#define PORTCD_PC1                      _PORTCD.Bits.PC1
#define PORTCD_PC2                      _PORTCD.Bits.PC2
#define PORTCD_PC3                      _PORTCD.Bits.PC3
#define PORTCD_PC4                      _PORTCD.Bits.PC4
#define PORTCD_PC5                      _PORTCD.Bits.PC5
#define PORTCD_PC6                      _PORTCD.Bits.PC6
#define PORTCD_PC7                      _PORTCD.Bits.PC7
#define PORTCD_PD                       _PORTCD.MergedBits.grpPD
#define PORTCD_PC                       _PORTCD.MergedBits.grpPC

#define PORTCD_PD0_MASK                 1
#define PORTCD_PD1_MASK                 2
#define PORTCD_PD2_MASK                 4
#define PORTCD_PD3_MASK                 8
#define PORTCD_PD4_MASK                 16
#define PORTCD_PD5_MASK                 32
#define PORTCD_PD6_MASK                 64
#define PORTCD_PD7_MASK                 128
#define PORTCD_PC0_MASK                 256
#define PORTCD_PC1_MASK                 512
#define PORTCD_PC2_MASK                 1024
#define PORTCD_PC3_MASK                 2048
#define PORTCD_PC4_MASK                 4096
#define PORTCD_PC5_MASK                 8192
#define PORTCD_PC6_MASK                 16384
#define PORTCD_PC7_MASK                 32768
#define PORTCD_PD_MASK                  255
#define PORTCD_PD_BITNUM                0
#define PORTCD_PC_MASK                  65280
#define PORTCD_PC_BITNUM                8


/*** DDRCD - Port CD Data Direction; 0x00000006 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** DDRC - Port C Data Direction Register; 0x00000006 ***/
    union {
      byte Byte;
      struct {
        byte DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
        byte DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
        byte DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
        byte DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
        byte DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
        byte DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
        byte DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
        byte DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
      } Bits;
    } DDRCSTR;
    #define DDRC                        _DDRCD.Overlap_STR.DDRCSTR.Byte
    #define DDRC_DDRC0                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC0
    #define DDRC_DDRC1                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC1
    #define DDRC_DDRC2                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC2
    #define DDRC_DDRC3                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC3
    #define DDRC_DDRC4                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC4
    #define DDRC_DDRC5                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC5
    #define DDRC_DDRC6                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC6
    #define DDRC_DDRC7                  _DDRCD.Overlap_STR.DDRCSTR.Bits.DDRC7
    
    
    #define DDRC_DDRC0_MASK             1
    #define DDRC_DDRC1_MASK             2
    #define DDRC_DDRC2_MASK             4
    #define DDRC_DDRC3_MASK             8
    #define DDRC_DDRC4_MASK             16
    #define DDRC_DDRC5_MASK             32
    #define DDRC_DDRC6_MASK             64
    #define DDRC_DDRC7_MASK             128


    /*** DDRD - Port D Data Direction Register; 0x00000007 ***/
    union {
      byte Byte;
      struct {
        byte DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
        byte DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
        byte DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
        byte DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
        byte DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
        byte DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
        byte DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
        byte DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
      } Bits;
    } DDRDSTR;
    #define DDRD                        _DDRCD.Overlap_STR.DDRDSTR.Byte
    #define DDRD_DDRD0                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD0
    #define DDRD_DDRD1                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD1
    #define DDRD_DDRD2                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD2
    #define DDRD_DDRD3                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD3
    #define DDRD_DDRD4                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD4
    #define DDRD_DDRD5                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD5
    #define DDRD_DDRD6                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD6
    #define DDRD_DDRD7                  _DDRCD.Overlap_STR.DDRDSTR.Bits.DDRD7
    
    
    #define DDRD_DDRD0_MASK             1
    #define DDRD_DDRD1_MASK             2
    #define DDRD_DDRD2_MASK             4
    #define DDRD_DDRD3_MASK             8
    #define DDRD_DDRD4_MASK             16
    #define DDRD_DDRD5_MASK             32
    #define DDRD_DDRD6_MASK             64
    #define DDRD_DDRD7_MASK             128

  } Overlap_STR;

  struct {
    word DDRD0       :1;                                       /* Data Direction Port D Bit 0 */
    word DDRD1       :1;                                       /* Data Direction Port D Bit 1 */
    word DDRD2       :1;                                       /* Data Direction Port D Bit 2 */
    word DDRD3       :1;                                       /* Data Direction Port D Bit 3 */
    word DDRD4       :1;                                       /* Data Direction Port D Bit 4 */
    word DDRD5       :1;                                       /* Data Direction Port D Bit 5 */
    word DDRD6       :1;                                       /* Data Direction Port D Bit 6 */
    word DDRD7       :1;                                       /* Data Direction Port D Bit 7 */
    word DDRC0       :1;                                       /* Data Direction Port C Bit 0 */
    word DDRC1       :1;                                       /* Data Direction Port C Bit 1 */
    word DDRC2       :1;                                       /* Data Direction Port C Bit 2 */
    word DDRC3       :1;                                       /* Data Direction Port C Bit 3 */
    word DDRC4       :1;                                       /* Data Direction Port C Bit 4 */
    word DDRC5       :1;                                       /* Data Direction Port C Bit 5 */
    word DDRC6       :1;                                       /* Data Direction Port C Bit 6 */
    word DDRC7       :1;                                       /* Data Direction Port C Bit 7 */
  } Bits;
  struct {
    word grpDDRD :8;
    word grpDDRC :8;
  } MergedBits;
} DDRCDSTR;
extern volatile DDRCDSTR _DDRCD @(REG_BASE + 0x00000006);
#define DDRCD                           _DDRCD.Word
#define DDRCD_DDRD0                     _DDRCD.Bits.DDRD0
#define DDRCD_DDRD1                     _DDRCD.Bits.DDRD1
#define DDRCD_DDRD2                     _DDRCD.Bits.DDRD2
#define DDRCD_DDRD3                     _DDRCD.Bits.DDRD3
#define DDRCD_DDRD4                     _DDRCD.Bits.DDRD4
#define DDRCD_DDRD5                     _DDRCD.Bits.DDRD5
#define DDRCD_DDRD6                     _DDRCD.Bits.DDRD6
#define DDRCD_DDRD7                     _DDRCD.Bits.DDRD7
#define DDRCD_DDRC0                     _DDRCD.Bits.DDRC0
#define DDRCD_DDRC1                     _DDRCD.Bits.DDRC1
#define DDRCD_DDRC2                     _DDRCD.Bits.DDRC2
#define DDRCD_DDRC3                     _DDRCD.Bits.DDRC3
#define DDRCD_DDRC4                     _DDRCD.Bits.DDRC4
#define DDRCD_DDRC5                     _DDRCD.Bits.DDRC5
#define DDRCD_DDRC6                     _DDRCD.Bits.DDRC6
#define DDRCD_DDRC7                     _DDRCD.Bits.DDRC7
#define DDRCD_DDRD                      _DDRCD.MergedBits.grpDDRD
#define DDRCD_DDRC                      _DDRCD.MergedBits.grpDDRC

#define DDRCD_DDRD0_MASK                1
#define DDRCD_DDRD1_MASK                2
#define DDRCD_DDRD2_MASK                4
#define DDRCD_DDRD3_MASK                8
#define DDRCD_DDRD4_MASK                16
#define DDRCD_DDRD5_MASK                32
#define DDRCD_DDRD6_MASK                64
#define DDRCD_DDRD7_MASK                128
#define DDRCD_DDRC0_MASK                256
#define DDRCD_DDRC1_MASK                512
#define DDRCD_DDRC2_MASK                1024
#define DDRCD_DDRC3_MASK                2048
#define DDRCD_DDRC4_MASK                4096
#define DDRCD_DDRC5_MASK                8192
#define DDRCD_DDRC6_MASK                16384
#define DDRCD_DDRC7_MASK                32768
#define DDRCD_DDRD_MASK                 255
#define DDRCD_DDRD_BITNUM               0
#define DDRCD_DDRC_MASK                 65280
#define DDRCD_DDRC_BITNUM               8


/*** PORTE - Port E Register; 0x00000008 ***/
typedef union {
  byte Byte;
  struct {
    byte PE0         :1;                                       /* Port E Bit 0 */
    byte PE1         :1;                                       /* Port E Bit 1 */
    byte PE2         :1;                                       /* Port E Bit 2 */
    byte PE3         :1;                                       /* Port E Bit 3 */
    byte PE4         :1;                                       /* Port E Bit 4 */
    byte PE5         :1;                                       /* Port E Bit 5 */
    byte PE6         :1;                                       /* Port E Bit 6 */
    byte PE7         :1;                                       /* Port E Bit 7 */
  } Bits;
} PORTESTR;
extern volatile PORTESTR _PORTE @(REG_BASE + 0x00000008);
#define PORTE                           _PORTE.Byte
#define PORTE_PE0                       _PORTE.Bits.PE0
#define PORTE_PE1                       _PORTE.Bits.PE1
#define PORTE_PE2                       _PORTE.Bits.PE2
#define PORTE_PE3                       _PORTE.Bits.PE3
#define PORTE_PE4                       _PORTE.Bits.PE4
#define PORTE_PE5                       _PORTE.Bits.PE5
#define PORTE_PE6                       _PORTE.Bits.PE6
#define PORTE_PE7                       _PORTE.Bits.PE7

#define PORTE_PE0_MASK                  1
#define PORTE_PE1_MASK                  2
#define PORTE_PE2_MASK                  4
#define PORTE_PE3_MASK                  8
#define PORTE_PE4_MASK                  16
#define PORTE_PE5_MASK                  32
#define PORTE_PE6_MASK                  64
#define PORTE_PE7_MASK                  128


/*** DDRE - Port E Data Direction Register; 0x00000009 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte DDRE2       :1;                                       /* Data Direction Port E Bit 2 */
    byte DDRE3       :1;                                       /* Data Direction Port E Bit 3 */
    byte DDRE4       :1;                                       /* Data Direction Port E Bit 4 */
    byte DDRE5       :1;                                       /* Data Direction Port E Bit 5 */
    byte DDRE6       :1;                                       /* Data Direction Port E Bit 6 */
    byte DDRE7       :1;                                       /* Data Direction Port E Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpDDRE_2 :6;
  } MergedBits;
} DDRESTR;
extern volatile DDRESTR _DDRE @(REG_BASE + 0x00000009);
#define DDRE                            _DDRE.Byte
#define DDRE_DDRE2                      _DDRE.Bits.DDRE2
#define DDRE_DDRE3                      _DDRE.Bits.DDRE3
#define DDRE_DDRE4                      _DDRE.Bits.DDRE4
#define DDRE_DDRE5                      _DDRE.Bits.DDRE5
#define DDRE_DDRE6                      _DDRE.Bits.DDRE6
#define DDRE_DDRE7                      _DDRE.Bits.DDRE7
#define DDRE_DDRE_2                     _DDRE.MergedBits.grpDDRE_2

#define DDRE_DDRE2_MASK                 4
#define DDRE_DDRE3_MASK                 8
#define DDRE_DDRE4_MASK                 16
#define DDRE_DDRE5_MASK                 32
#define DDRE_DDRE6_MASK                 64
#define DDRE_DDRE7_MASK                 128
#define DDRE_DDRE_2_MASK                252
#define DDRE_DDRE_2_BITNUM              2


/*** IRQCR - Interrupt Control Register; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IRQEN       :1;                                       /* External IRQ Enable */
    byte IRQE        :1;                                       /* IRQ Select Edge Sensitive Only */
  } Bits;
} IRQCRSTR;
extern volatile IRQCRSTR _IRQCR @(REG_BASE + 0x0000001E);
#define IRQCR                           _IRQCR.Byte
#define IRQCR_IRQEN                     _IRQCR.Bits.IRQEN
#define IRQCR_IRQE                      _IRQCR.Bits.IRQE

#define IRQCR_IRQEN_MASK                64
#define IRQCR_IRQE_MASK                 128


/*** PORTK - Port K Register; 0x00000032 ***/
typedef union {
  byte Byte;
  struct {
    byte PK0         :1;                                       /* Port K Bit 0 */
    byte PK1         :1;                                       /* Port K Bit 1 */
    byte PK2         :1;                                       /* Port K Bit 2 */
    byte PK3         :1;                                       /* Port K Bit 3 */
    byte PK4         :1;                                       /* Port K Bit 4 */
    byte PK5         :1;                                       /* Port K Bit 5 */
    byte PK6         :1;                                       /* Port K Bit 6 */
    byte PK7         :1;                                       /* Port K Bit 7 */
  } Bits;
} PORTKSTR;
extern volatile PORTKSTR _PORTK @(REG_BASE + 0x00000032);
#define PORTK                           _PORTK.Byte
#define PORTK_PK0                       _PORTK.Bits.PK0
#define PORTK_PK1                       _PORTK.Bits.PK1
#define PORTK_PK2                       _PORTK.Bits.PK2
#define PORTK_PK3                       _PORTK.Bits.PK3
#define PORTK_PK4                       _PORTK.Bits.PK4
#define PORTK_PK5                       _PORTK.Bits.PK5
#define PORTK_PK6                       _PORTK.Bits.PK6
#define PORTK_PK7                       _PORTK.Bits.PK7

#define PORTK_PK0_MASK                  1
#define PORTK_PK1_MASK                  2
#define PORTK_PK2_MASK                  4
#define PORTK_PK3_MASK                  8
#define PORTK_PK4_MASK                  16
#define PORTK_PK5_MASK                  32
#define PORTK_PK6_MASK                  64
#define PORTK_PK7_MASK                  128


/*** DDRK - Port K Data Direction Register; 0x00000033 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRK0       :1;                                       /* Data Direction Port K Bit 0 */
    byte DDRK1       :1;                                       /* Data Direction Port K Bit 1 */
    byte DDRK2       :1;                                       /* Data Direction Port K Bit 2 */
    byte DDRK3       :1;                                       /* Data Direction Port K Bit 3 */
    byte DDRK4       :1;                                       /* Data Direction Port K Bit 4 */
    byte DDRK5       :1;                                       /* Data Direction Port K Bit 5 */
    byte DDRK6       :1;                                       /* Data Direction Port K Bit 6 */
    byte DDRK7       :1;                                       /* Data Direction Port K Bit 7 */
  } Bits;  
} DDRKSTR;
extern volatile DDRKSTR _DDRK @(REG_BASE + 0x00000033);
#define DDRK                            _DDRK.Byte
#define DDRK_DDRK0                      _DDRK.Bits.DDRK0
#define DDRK_DDRK1                      _DDRK.Bits.DDRK1
#define DDRK_DDRK2                      _DDRK.Bits.DDRK2
#define DDRK_DDRK3                      _DDRK.Bits.DDRK3
#define DDRK_DDRK4                      _DDRK.Bits.DDRK4
#define DDRK_DDRK5                      _DDRK.Bits.DDRK5
#define DDRK_DDRK6                      _DDRK.Bits.DDRK6
#define DDRK_DDRK7                      _DDRK.Bits.DDRK7

#define DDRK_DDRK0_MASK                 1
#define DDRK_DDRK1_MASK                 2
#define DDRK_DDRK2_MASK                 4
#define DDRK_DDRK3_MASK                 8
#define DDRK_DDRK4_MASK                 16
#define DDRK_DDRK5_MASK                 32
#define DDRK_DDRK6_MASK                 64
#define DDRK_DDRK7_MASK                 128


/*** PTT - Port T I/O Register; 0x00000240 ***/
typedef union {
  byte Byte;
  struct {
    byte PTT0        :1;                                       /* Port T Bit 0 */
    byte PTT1        :1;                                       /* Port T Bit 1 */
    byte PTT2        :1;                                       /* Port T Bit 2 */
    byte PTT3        :1;                                       /* Port T Bit 3 */
    byte PTT4        :1;                                       /* Port T Bit 4 */
    byte PTT5        :1;                                       /* Port T Bit 5 */
    byte PTT6        :1;                                       /* Port T Bit 6 */
    byte PTT7        :1;                                       /* Port T Bit 7 */
  } Bits;
} PTTSTR;
extern volatile PTTSTR _PTT @(REG_BASE + 0x00000240);
#define PTT                             _PTT.Byte
#define PTT_PTT0                        _PTT.Bits.PTT0
#define PTT_PTT1                        _PTT.Bits.PTT1
#define PTT_PTT2                        _PTT.Bits.PTT2
#define PTT_PTT3                        _PTT.Bits.PTT3
#define PTT_PTT4                        _PTT.Bits.PTT4
#define PTT_PTT5                        _PTT.Bits.PTT5
#define PTT_PTT6                        _PTT.Bits.PTT6
#define PTT_PTT7                        _PTT.Bits.PTT7

#define PTT_PTT0_MASK                   1
#define PTT_PTT1_MASK                   2
#define PTT_PTT2_MASK                   4
#define PTT_PTT3_MASK                   8
#define PTT_PTT4_MASK                   16
#define PTT_PTT5_MASK                   32
#define PTT_PTT6_MASK                   64
#define PTT_PTT7_MASK                   128


/*** PTIT - Port T Input Register; 0x00000241 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIT0       :1;                                       /* Port T Bit 0 */
    byte PTIT1       :1;                                       /* Port T Bit 1 */
    byte PTIT2       :1;                                       /* Port T Bit 2 */
    byte PTIT3       :1;                                       /* Port T Bit 3 */
    byte PTIT4       :1;                                       /* Port T Bit 4 */
    byte PTIT5       :1;                                       /* Port T Bit 5 */
    byte PTIT6       :1;                                       /* Port T Bit 6 */
    byte PTIT7       :1;                                       /* Port T Bit 7 */
  } Bits;
} PTITSTR;
extern volatile PTITSTR _PTIT @(REG_BASE + 0x00000241);
#define PTIT                            _PTIT.Byte
#define PTIT_PTIT0                      _PTIT.Bits.PTIT0
#define PTIT_PTIT1                      _PTIT.Bits.PTIT1
#define PTIT_PTIT2                      _PTIT.Bits.PTIT2
#define PTIT_PTIT3                      _PTIT.Bits.PTIT3
#define PTIT_PTIT4                      _PTIT.Bits.PTIT4
#define PTIT_PTIT5                      _PTIT.Bits.PTIT5
#define PTIT_PTIT6                      _PTIT.Bits.PTIT6
#define PTIT_PTIT7                      _PTIT.Bits.PTIT7

#define PTIT_PTIT0_MASK                 1
#define PTIT_PTIT1_MASK                 2
#define PTIT_PTIT2_MASK                 4
#define PTIT_PTIT3_MASK                 8
#define PTIT_PTIT4_MASK                 16
#define PTIT_PTIT5_MASK                 32
#define PTIT_PTIT6_MASK                 64
#define PTIT_PTIT7_MASK                 128


/*** DDRT - Port T Data Direction Register; 0x00000242 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRT0       :1;                                       /* Data Direction Port T Bit 0 */
    byte DDRT1       :1;                                       /* Data Direction Port T Bit 1 */
    byte DDRT2       :1;                                       /* Data Direction Port T Bit 2 */
    byte DDRT3       :1;                                       /* Data Direction Port T Bit 3 */
    byte DDRT4       :1;                                       /* Data Direction Port T Bit 4 */
    byte DDRT5       :1;                                       /* Data Direction Port T Bit 5 */
    byte DDRT6       :1;                                       /* Data Direction Port T Bit 6 */
    byte DDRT7       :1;                                       /* Data Direction Port T Bit 7 */
  } Bits;
} DDRTSTR;
extern volatile DDRTSTR _DDRT @(REG_BASE + 0x00000242);
#define DDRT                            _DDRT.Byte
#define DDRT_DDRT0                      _DDRT.Bits.DDRT0
#define DDRT_DDRT1                      _DDRT.Bits.DDRT1
#define DDRT_DDRT2                      _DDRT.Bits.DDRT2
#define DDRT_DDRT3                      _DDRT.Bits.DDRT3
#define DDRT_DDRT4                      _DDRT.Bits.DDRT4
#define DDRT_DDRT5                      _DDRT.Bits.DDRT5
#define DDRT_DDRT6                      _DDRT.Bits.DDRT6
#define DDRT_DDRT7                      _DDRT.Bits.DDRT7

#define DDRT_DDRT0_MASK                 1
#define DDRT_DDRT1_MASK                 2
#define DDRT_DDRT2_MASK                 4
#define DDRT_DDRT3_MASK                 8
#define DDRT_DDRT4_MASK                 16
#define DDRT_DDRT5_MASK                 32
#define DDRT_DDRT6_MASK                 64
#define DDRT_DDRT7_MASK                 128


/*** RDRT - Port T Reduced Drive Register; 0x00000243 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRT0       :1;                                       /* Reduced Drive Port T Bit 0 */
    byte RDRT1       :1;                                       /* Reduced Drive Port T Bit 1 */
    byte RDRT2       :1;                                       /* Reduced Drive Port T Bit 2 */
    byte RDRT3       :1;                                       /* Reduced Drive Port T Bit 3 */
    byte RDRT4       :1;                                       /* Reduced Drive Port T Bit 4 */
    byte RDRT5       :1;                                       /* Reduced Drive Port T Bit 5 */
    byte RDRT6       :1;                                       /* Reduced Drive Port T Bit 6 */
    byte RDRT7       :1;                                       /* Reduced Drive Port T Bit 7 */
  } Bits;
} RDRTSTR;
extern volatile RDRTSTR _RDRT @(REG_BASE + 0x00000243);
#define RDRT                            _RDRT.Byte
#define RDRT_RDRT0                      _RDRT.Bits.RDRT0
#define RDRT_RDRT1                      _RDRT.Bits.RDRT1
#define RDRT_RDRT2                      _RDRT.Bits.RDRT2
#define RDRT_RDRT3                      _RDRT.Bits.RDRT3
#define RDRT_RDRT4                      _RDRT.Bits.RDRT4
#define RDRT_RDRT5                      _RDRT.Bits.RDRT5
#define RDRT_RDRT6                      _RDRT.Bits.RDRT6
#define RDRT_RDRT7                      _RDRT.Bits.RDRT7

#define RDRT_RDRT0_MASK                 1
#define RDRT_RDRT1_MASK                 2
#define RDRT_RDRT2_MASK                 4
#define RDRT_RDRT3_MASK                 8
#define RDRT_RDRT4_MASK                 16
#define RDRT_RDRT5_MASK                 32
#define RDRT_RDRT6_MASK                 64
#define RDRT_RDRT7_MASK                 128


/*** PERT - Port T Pull Device Enable Register; 0x00000244 ***/
typedef union {
  byte Byte;
  struct {
    byte PERT0       :1;                                       /* Pull Device Enable Port T Bit 0 */
    byte PERT1       :1;                                       /* Pull Device Enable Port T Bit 1 */
    byte PERT2       :1;                                       /* Pull Device Enable Port T Bit 2 */
    byte PERT3       :1;                                       /* Pull Device Enable Port T Bit 3 */
    byte PERT4       :1;                                       /* Pull Device Enable Port T Bit 4 */
    byte PERT5       :1;                                       /* Pull Device Enable Port T Bit 5 */
    byte PERT6       :1;                                       /* Pull Device Enable Port T Bit 6 */
    byte PERT7       :1;                                       /* Pull Device Enable Port T Bit 7 */
  } Bits;
} PERTSTR;
extern volatile PERTSTR _PERT @(REG_BASE + 0x00000244);
#define PERT                            _PERT.Byte
#define PERT_PERT0                      _PERT.Bits.PERT0
#define PERT_PERT1                      _PERT.Bits.PERT1
#define PERT_PERT2                      _PERT.Bits.PERT2
#define PERT_PERT3                      _PERT.Bits.PERT3
#define PERT_PERT4                      _PERT.Bits.PERT4
#define PERT_PERT5                      _PERT.Bits.PERT5
#define PERT_PERT6                      _PERT.Bits.PERT6
#define PERT_PERT7                      _PERT.Bits.PERT7

#define PERT_PERT0_MASK                 1
#define PERT_PERT1_MASK                 2
#define PERT_PERT2_MASK                 4
#define PERT_PERT3_MASK                 8
#define PERT_PERT4_MASK                 16
#define PERT_PERT5_MASK                 32
#define PERT_PERT6_MASK                 64
#define PERT_PERT7_MASK                 128


/*** PPST - Port T Polarity Select Register; 0x00000245 ***/
typedef union {
  byte Byte;
  struct {
    byte PPST0       :1;                                       /* Pull Select Port T Bit 0 */
    byte PPST1       :1;                                       /* Pull Select Port T Bit 1 */
    byte PPST2       :1;                                       /* Pull Select Port T Bit 2 */
    byte PPST3       :1;                                       /* Pull Select Port T Bit 3 */
    byte PPST4       :1;                                       /* Pull Select Port T Bit 4 */
    byte PPST5       :1;                                       /* Pull Select Port T Bit 5 */
    byte PPST6       :1;                                       /* Pull Select Port T Bit 6 */
    byte PPST7       :1;                                       /* Pull Select Port T Bit 7 */
  } Bits;
} PPSTSTR;
extern volatile PPSTSTR _PPST @(REG_BASE + 0x00000245);
#define PPST                            _PPST.Byte
#define PPST_PPST0                      _PPST.Bits.PPST0
#define PPST_PPST1                      _PPST.Bits.PPST1
#define PPST_PPST2                      _PPST.Bits.PPST2
#define PPST_PPST3                      _PPST.Bits.PPST3
#define PPST_PPST4                      _PPST.Bits.PPST4
#define PPST_PPST5                      _PPST.Bits.PPST5
#define PPST_PPST6                      _PPST.Bits.PPST6
#define PPST_PPST7                      _PPST.Bits.PPST7

#define PPST_PPST0_MASK                 1
#define PPST_PPST1_MASK                 2
#define PPST_PPST2_MASK                 4
#define PPST_PPST3_MASK                 8
#define PPST_PPST4_MASK                 16
#define PPST_PPST5_MASK                 32
#define PPST_PPST6_MASK                 64
#define PPST_PPST7_MASK                 128


/*** PTS - Port S I/O Register; 0x00000248 ***/
typedef union {
  byte Byte;
  struct {
    byte PTS0        :1;                                       /* Port S Bit 0 */
    byte PTS1        :1;                                       /* Port S Bit 1 */
    byte PTS2        :1;                                       /* Port S Bit 2 */
    byte PTS3        :1;                                       /* Port S Bit 3 */
    byte PTS4        :1;                                       /* Port S Bit 4 */
    byte PTS5        :1;                                       /* Port S Bit 5 */
    byte PTS6        :1;                                       /* Port S Bit 6 */
    byte PTS7        :1;                                       /* Port S Bit 7 */
  } Bits;
} PTSSTR;
extern volatile PTSSTR _PTS @(REG_BASE + 0x00000248);
#define PTS                             _PTS.Byte
#define PTS_PTS0                        _PTS.Bits.PTS0
#define PTS_PTS1                        _PTS.Bits.PTS1
#define PTS_PTS2                        _PTS.Bits.PTS2
#define PTS_PTS3                        _PTS.Bits.PTS3
#define PTS_PTS4                        _PTS.Bits.PTS4
#define PTS_PTS5                        _PTS.Bits.PTS5
#define PTS_PTS6                        _PTS.Bits.PTS6
#define PTS_PTS7                        _PTS.Bits.PTS7

#define PTS_PTS0_MASK                   1
#define PTS_PTS1_MASK                   2
#define PTS_PTS2_MASK                   4
#define PTS_PTS3_MASK                   8
#define PTS_PTS4_MASK                   16
#define PTS_PTS5_MASK                   32
#define PTS_PTS6_MASK                   64
#define PTS_PTS7_MASK                   128


/*** PTIS - Port S Input Register; 0x00000249 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIS0       :1;                                       /* Port S Bit 0 */
    byte PTIS1       :1;                                       /* Port S Bit 1 */
    byte PTIS2       :1;                                       /* Port S Bit 2 */
    byte PTIS3       :1;                                       /* Port S Bit 3 */
    byte PTIS4       :1;                                       /* Port S Bit 4 */
    byte PTIS5       :1;                                       /* Port S Bit 5 */
    byte PTIS6       :1;                                       /* Port S Bit 6 */
    byte PTIS7       :1;                                       /* Port S Bit 7 */
  } Bits;
} PTISSTR;
extern volatile PTISSTR _PTIS @(REG_BASE + 0x00000249);
#define PTIS                            _PTIS.Byte
#define PTIS_PTIS0                      _PTIS.Bits.PTIS0
#define PTIS_PTIS1                      _PTIS.Bits.PTIS1
#define PTIS_PTIS2                      _PTIS.Bits.PTIS2
#define PTIS_PTIS3                      _PTIS.Bits.PTIS3
#define PTIS_PTIS4                      _PTIS.Bits.PTIS4
#define PTIS_PTIS5                      _PTIS.Bits.PTIS5
#define PTIS_PTIS6                      _PTIS.Bits.PTIS6
#define PTIS_PTIS7                      _PTIS.Bits.PTIS7

#define PTIS_PTIS0_MASK                 1
#define PTIS_PTIS1_MASK                 2
#define PTIS_PTIS2_MASK                 4
#define PTIS_PTIS3_MASK                 8
#define PTIS_PTIS4_MASK                 16
#define PTIS_PTIS5_MASK                 32
#define PTIS_PTIS6_MASK                 64
#define PTIS_PTIS7_MASK                 128


/*** DDRS - Port S Data Direction Register; 0x0000024A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRS0       :1;                                       /* Data Direction Port S Bit 0 */
    byte DDRS1       :1;                                       /* Data Direction Port S Bit 1 */
    byte DDRS2       :1;                                       /* Data Direction Port S Bit 2 */
    byte DDRS3       :1;                                       /* Data Direction Port S Bit 3 */
    byte DDRS4       :1;                                       /* Data Direction Port S Bit 4 */
    byte DDRS5       :1;                                       /* Data Direction Port S Bit 5 */
    byte DDRS6       :1;                                       /* Data Direction Port S Bit 6 */
    byte DDRS7       :1;                                       /* Data Direction Port S Bit 7 */
  } Bits;
} DDRSSTR;
extern volatile DDRSSTR _DDRS @(REG_BASE + 0x0000024A);
#define DDRS                            _DDRS.Byte
#define DDRS_DDRS0                      _DDRS.Bits.DDRS0
#define DDRS_DDRS1                      _DDRS.Bits.DDRS1
#define DDRS_DDRS2                      _DDRS.Bits.DDRS2
#define DDRS_DDRS3                      _DDRS.Bits.DDRS3
#define DDRS_DDRS4                      _DDRS.Bits.DDRS4
#define DDRS_DDRS5                      _DDRS.Bits.DDRS5
#define DDRS_DDRS6                      _DDRS.Bits.DDRS6
#define DDRS_DDRS7                      _DDRS.Bits.DDRS7

#define DDRS_DDRS0_MASK                 1
#define DDRS_DDRS1_MASK                 2
#define DDRS_DDRS2_MASK                 4
#define DDRS_DDRS3_MASK                 8
#define DDRS_DDRS4_MASK                 16
#define DDRS_DDRS5_MASK                 32
#define DDRS_DDRS6_MASK                 64
#define DDRS_DDRS7_MASK                 128


/*** RDRS - Port S Reduced Drive Register; 0x0000024B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRS0       :1;                                       /* Reduced Drive Port S Bit 0 */
    byte RDRS1       :1;                                       /* Reduced Drive Port S Bit 1 */
    byte RDRS2       :1;                                       /* Reduced Drive Port S Bit 2 */
    byte RDRS3       :1;                                       /* Reduced Drive Port S Bit 3 */
    byte RDRS4       :1;                                       /* Reduced Drive Port S Bit 4 */
    byte RDRS5       :1;                                       /* Reduced Drive Port S Bit 5 */
    byte RDRS6       :1;                                       /* Reduced Drive Port S Bit 6 */
    byte RDRS7       :1;                                       /* Reduced Drive Port S Bit 7 */
  } Bits;
} RDRSSTR;
extern volatile RDRSSTR _RDRS @(REG_BASE + 0x0000024B);
#define RDRS                            _RDRS.Byte
#define RDRS_RDRS0                      _RDRS.Bits.RDRS0
#define RDRS_RDRS1                      _RDRS.Bits.RDRS1
#define RDRS_RDRS2                      _RDRS.Bits.RDRS2
#define RDRS_RDRS3                      _RDRS.Bits.RDRS3
#define RDRS_RDRS4                      _RDRS.Bits.RDRS4
#define RDRS_RDRS5                      _RDRS.Bits.RDRS5
#define RDRS_RDRS6                      _RDRS.Bits.RDRS6
#define RDRS_RDRS7                      _RDRS.Bits.RDRS7

#define RDRS_RDRS0_MASK                 1
#define RDRS_RDRS1_MASK                 2
#define RDRS_RDRS2_MASK                 4
#define RDRS_RDRS3_MASK                 8
#define RDRS_RDRS4_MASK                 16
#define RDRS_RDRS5_MASK                 32
#define RDRS_RDRS6_MASK                 64
#define RDRS_RDRS7_MASK                 128


/*** PERS - Port S Pull Device Enable Register; 0x0000024C ***/
typedef union {
  byte Byte;
  struct {
    byte PERS0       :1;                                       /* Pull Device Enable Port S Bit 0 */
    byte PERS1       :1;                                       /* Pull Device Enable Port S Bit 1 */
    byte PERS2       :1;                                       /* Pull Device Enable Port S Bit 2 */
    byte PERS3       :1;                                       /* Pull Device Enable Port S Bit 3 */
    byte PERS4       :1;                                       /* Pull Device Enable Port S Bit 4 */
    byte PERS5       :1;                                       /* Pull Device Enable Port S Bit 5 */
    byte PERS6       :1;                                       /* Pull Device Enable Port S Bit 6 */
    byte PERS7       :1;                                       /* Pull Device Enable Port S Bit 7 */
  } Bits;
} PERSSTR;
extern volatile PERSSTR _PERS @(REG_BASE + 0x0000024C);
#define PERS                            _PERS.Byte
#define PERS_PERS0                      _PERS.Bits.PERS0
#define PERS_PERS1                      _PERS.Bits.PERS1
#define PERS_PERS2                      _PERS.Bits.PERS2
#define PERS_PERS3                      _PERS.Bits.PERS3
#define PERS_PERS4                      _PERS.Bits.PERS4
#define PERS_PERS5                      _PERS.Bits.PERS5
#define PERS_PERS6                      _PERS.Bits.PERS6
#define PERS_PERS7                      _PERS.Bits.PERS7

#define PERS_PERS0_MASK                 1
#define PERS_PERS1_MASK                 2
#define PERS_PERS2_MASK                 4
#define PERS_PERS3_MASK                 8
#define PERS_PERS4_MASK                 16
#define PERS_PERS5_MASK                 32
#define PERS_PERS6_MASK                 64
#define PERS_PERS7_MASK                 128


/*** PPSS - Port S Polarity Select Register; 0x0000024D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSS0       :1;                                       /* Pull Select Port S Bit 0 */
    byte PPSS1       :1;                                       /* Pull Select Port S Bit 1 */
    byte PPSS2       :1;                                       /* Pull Select Port S Bit 2 */
    byte PPSS3       :1;                                       /* Pull Select Port S Bit 3 */
    byte PPSS4       :1;                                       /* Pull Select Port S Bit 4 */
    byte PPSS5       :1;                                       /* Pull Select Port S Bit 5 */
    byte PPSS6       :1;                                       /* Pull Select Port S Bit 6 */
    byte PPSS7       :1;                                       /* Pull Select Port S Bit 7 */
  } Bits;
} PPSSSTR;
extern volatile PPSSSTR _PPSS @(REG_BASE + 0x0000024D);
#define PPSS                            _PPSS.Byte
#define PPSS_PPSS0                      _PPSS.Bits.PPSS0
#define PPSS_PPSS1                      _PPSS.Bits.PPSS1
#define PPSS_PPSS2                      _PPSS.Bits.PPSS2
#define PPSS_PPSS3                      _PPSS.Bits.PPSS3
#define PPSS_PPSS4                      _PPSS.Bits.PPSS4
#define PPSS_PPSS5                      _PPSS.Bits.PPSS5
#define PPSS_PPSS6                      _PPSS.Bits.PPSS6
#define PPSS_PPSS7                      _PPSS.Bits.PPSS7

#define PPSS_PPSS0_MASK                 1
#define PPSS_PPSS1_MASK                 2
#define PPSS_PPSS2_MASK                 4
#define PPSS_PPSS3_MASK                 8
#define PPSS_PPSS4_MASK                 16
#define PPSS_PPSS5_MASK                 32
#define PPSS_PPSS6_MASK                 64
#define PPSS_PPSS7_MASK                 128


/*** WOMS - Port S Wired-Or Mode Register; 0x0000024E ***/
typedef union {
  byte Byte;
  struct {
    byte WOMS0       :1;                                       /* Wired-Or Mode Port S Bit 0 */
    byte WOMS1       :1;                                       /* Wired-Or Mode Port S Bit 1 */
    byte WOMS2       :1;                                       /* Wired-Or Mode Port S Bit 2 */
    byte WOMS3       :1;                                       /* Wired-Or Mode Port S Bit 3 */
    byte WOMS4       :1;                                       /* Wired-Or Mode Port S Bit 4 */
    byte WOMS5       :1;                                       /* Wired-Or Mode Port S Bit 5 */
    byte WOMS6       :1;                                       /* Wired-Or Mode Port S Bit 6 */
    byte WOMS7       :1;                                       /* Wired-Or Mode Port S Bit 7 */
  } Bits;
} WOMSSTR;
extern volatile WOMSSTR _WOMS @(REG_BASE + 0x0000024E);
#define WOMS                            _WOMS.Byte
#define WOMS_WOMS0                      _WOMS.Bits.WOMS0
#define WOMS_WOMS1                      _WOMS.Bits.WOMS1
#define WOMS_WOMS2                      _WOMS.Bits.WOMS2
#define WOMS_WOMS3                      _WOMS.Bits.WOMS3
#define WOMS_WOMS4                      _WOMS.Bits.WOMS4
#define WOMS_WOMS5                      _WOMS.Bits.WOMS5
#define WOMS_WOMS6                      _WOMS.Bits.WOMS6
#define WOMS_WOMS7                      _WOMS.Bits.WOMS7

#define WOMS_WOMS0_MASK                 1
#define WOMS_WOMS1_MASK                 2
#define WOMS_WOMS2_MASK                 4
#define WOMS_WOMS3_MASK                 8
#define WOMS_WOMS4_MASK                 16
#define WOMS_WOMS5_MASK                 32
#define WOMS_WOMS6_MASK                 64
#define WOMS_WOMS7_MASK                 128



/*** PTM - Port M I/O Register; 0x00000250 ***/
typedef union {
  byte Byte;
  struct {
    byte PTM0        :1;                                       /* Port M Bit 0 */
    byte PTM1        :1;                                       /* Port M Bit 1 */
    byte PTM2        :1;                                       /* Port M Bit 2 */
    byte PTM3        :1;                                       /* Port M Bit 3 */
    byte PTM4        :1;                                       /* Port M Bit 4 */
    byte PTM5        :1;                                       /* Port M Bit 5 */
    byte PTM6        :1;                                       /* Port M Bit 6 */
    byte PTM7        :1;                                       /* Port M Bit 7 */
  } Bits;
} PTMSTR;
extern volatile PTMSTR _PTM @(REG_BASE + 0x00000250);
#define PTM                             _PTM.Byte
#define PTM_PTM0                        _PTM.Bits.PTM0
#define PTM_PTM1                        _PTM.Bits.PTM1
#define PTM_PTM2                        _PTM.Bits.PTM2
#define PTM_PTM3                        _PTM.Bits.PTM3
#define PTM_PTM4                        _PTM.Bits.PTM4
#define PTM_PTM5                        _PTM.Bits.PTM5
#define PTM_PTM6                        _PTM.Bits.PTM6
#define PTM_PTM7                        _PTM.Bits.PTM7

#define PTM_PTM0_MASK                   1
#define PTM_PTM1_MASK                   2
#define PTM_PTM2_MASK                   4
#define PTM_PTM3_MASK                   8
#define PTM_PTM4_MASK                   16
#define PTM_PTM5_MASK                   32
#define PTM_PTM6_MASK                   64
#define PTM_PTM7_MASK                   128


/*** PTIM - Port M Input Register; 0x00000251 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIM0       :1;                                       /* Port M Bit 0 */
    byte PTIM1       :1;                                       /* Port M Bit 1 */
    byte PTIM2       :1;                                       /* Port M Bit 2 */
    byte PTIM3       :1;                                       /* Port M Bit 3 */
    byte PTIM4       :1;                                       /* Port M Bit 4 */
    byte PTIM5       :1;                                       /* Port M Bit 5 */
    byte PTIM6       :1;                                       /* Port M Bit 6 */
    byte PTIM7       :1;                                       /* Port M Bit 7 */
  } Bits;
} PTIMSTR;
extern volatile PTIMSTR _PTIM @(REG_BASE + 0x00000251);
#define PTIM                            _PTIM.Byte
#define PTIM_PTIM0                      _PTIM.Bits.PTIM0
#define PTIM_PTIM1                      _PTIM.Bits.PTIM1
#define PTIM_PTIM2                      _PTIM.Bits.PTIM2
#define PTIM_PTIM3                      _PTIM.Bits.PTIM3
#define PTIM_PTIM4                      _PTIM.Bits.PTIM4
#define PTIM_PTIM5                      _PTIM.Bits.PTIM5
#define PTIM_PTIM6                      _PTIM.Bits.PTIM6
#define PTIM_PTIM7                      _PTIM.Bits.PTIM7

#define PTIM_PTIM0_MASK                 1
#define PTIM_PTIM1_MASK                 2
#define PTIM_PTIM2_MASK                 4
#define PTIM_PTIM3_MASK                 8
#define PTIM_PTIM4_MASK                 16
#define PTIM_PTIM5_MASK                 32
#define PTIM_PTIM6_MASK                 64
#define PTIM_PTIM7_MASK                 128


/*** DDRM - Port M Data Direction Register; 0x00000252 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRM0       :1;                                       /* Data Direction Port M Bit 0 */
    byte DDRM1       :1;                                       /* Data Direction Port M Bit 1 */
    byte DDRM2       :1;                                       /* Data Direction Port M Bit 2 */
    byte DDRM3       :1;                                       /* Data Direction Port M Bit 3 */
    byte DDRM4       :1;                                       /* Data Direction Port M Bit 4 */
    byte DDRM5       :1;                                       /* Data Direction Port M Bit 5 */
    byte DDRM6       :1;                                       /* Data Direction Port M Bit 6 */
    byte DDRM7       :1;                                       /* Data Direction Port M Bit 7 */
  } Bits;
} DDRMSTR;
extern volatile DDRMSTR _DDRM @(REG_BASE + 0x00000252);
#define DDRM                            _DDRM.Byte
#define DDRM_DDRM0                      _DDRM.Bits.DDRM0
#define DDRM_DDRM1                      _DDRM.Bits.DDRM1
#define DDRM_DDRM2                      _DDRM.Bits.DDRM2
#define DDRM_DDRM3                      _DDRM.Bits.DDRM3
#define DDRM_DDRM4                      _DDRM.Bits.DDRM4
#define DDRM_DDRM5                      _DDRM.Bits.DDRM5
#define DDRM_DDRM6                      _DDRM.Bits.DDRM6
#define DDRM_DDRM7                      _DDRM.Bits.DDRM7

#define DDRM_DDRM0_MASK                 1
#define DDRM_DDRM1_MASK                 2
#define DDRM_DDRM2_MASK                 4
#define DDRM_DDRM3_MASK                 8
#define DDRM_DDRM4_MASK                 16
#define DDRM_DDRM5_MASK                 32
#define DDRM_DDRM6_MASK                 64
#define DDRM_DDRM7_MASK                 128


/*** RDRM - Port M Reduced Drive Register; 0x00000253 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRM0       :1;                                       /* Reduced Drive Port M Bit 0 */
    byte RDRM1       :1;                                       /* Reduced Drive Port M Bit 1 */
    byte RDRM2       :1;                                       /* Reduced Drive Port M Bit 2 */
    byte RDRM3       :1;                                       /* Reduced Drive Port M Bit 3 */
    byte RDRM4       :1;                                       /* Reduced Drive Port M Bit 4 */
    byte RDRM5       :1;                                       /* Reduced Drive Port M Bit 5 */
    byte RDRM6       :1;                                       /* Reduced Drive Port M Bit 6 */
    byte RDRM7       :1;                                       /* Reduced Drive Port M Bit 7 */
  } Bits;
} RDRMSTR;
extern volatile RDRMSTR _RDRM @(REG_BASE + 0x00000253);
#define RDRM                            _RDRM.Byte
#define RDRM_RDRM0                      _RDRM.Bits.RDRM0
#define RDRM_RDRM1                      _RDRM.Bits.RDRM1
#define RDRM_RDRM2                      _RDRM.Bits.RDRM2
#define RDRM_RDRM3                      _RDRM.Bits.RDRM3
#define RDRM_RDRM4                      _RDRM.Bits.RDRM4
#define RDRM_RDRM5                      _RDRM.Bits.RDRM5
#define RDRM_RDRM6                      _RDRM.Bits.RDRM6
#define RDRM_RDRM7                      _RDRM.Bits.RDRM7

#define RDRM_RDRM0_MASK                 1
#define RDRM_RDRM1_MASK                 2
#define RDRM_RDRM2_MASK                 4
#define RDRM_RDRM3_MASK                 8
#define RDRM_RDRM4_MASK                 16
#define RDRM_RDRM5_MASK                 32
#define RDRM_RDRM6_MASK                 64
#define RDRM_RDRM7_MASK                 128


/*** PERM - Port M Pull Device Enable Register; 0x00000254 ***/
typedef union {
  byte Byte;
  struct {
    byte PERM0       :1;                                       /* Pull Device Enable Port M Bit 0 */
    byte PERM1       :1;                                       /* Pull Device Enable Port M Bit 1 */
    byte PERM2       :1;                                       /* Pull Device Enable Port M Bit 2 */
    byte PERM3       :1;                                       /* Pull Device Enable Port M Bit 3 */
    byte PERM4       :1;                                       /* Pull Device Enable Port M Bit 4 */
    byte PERM5       :1;                                       /* Pull Device Enable Port M Bit 5 */
    byte PERM6       :1;                                       /* Pull Device Enable Port M Bit 6 */
    byte PERM7       :1;                                       /* Pull Device Enable Port M Bit 7 */
  } Bits;
} PERMSTR;
extern volatile PERMSTR _PERM @(REG_BASE + 0x00000254);
#define PERM                            _PERM.Byte
#define PERM_PERM0                      _PERM.Bits.PERM0
#define PERM_PERM1                      _PERM.Bits.PERM1
#define PERM_PERM2                      _PERM.Bits.PERM2
#define PERM_PERM3                      _PERM.Bits.PERM3
#define PERM_PERM4                      _PERM.Bits.PERM4
#define PERM_PERM5                      _PERM.Bits.PERM5
#define PERM_PERM6                      _PERM.Bits.PERM6
#define PERM_PERM7                      _PERM.Bits.PERM7

#define PERM_PERM0_MASK                 1
#define PERM_PERM1_MASK                 2
#define PERM_PERM2_MASK                 4
#define PERM_PERM3_MASK                 8
#define PERM_PERM4_MASK                 16
#define PERM_PERM5_MASK                 32
#define PERM_PERM6_MASK                 64
#define PERM_PERM7_MASK                 128


/*** PPSM - Port M Polarity Select Register; 0x00000255 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSM0       :1;                                       /* Pull Select Port M Bit 0 */
    byte PPSM1       :1;                                       /* Pull Select Port M Bit 1 */
    byte PPSM2       :1;                                       /* Pull Select Port M Bit 2 */
    byte PPSM3       :1;                                       /* Pull Select Port M Bit 3 */
    byte PPSM4       :1;                                       /* Pull Select Port M Bit 4 */
    byte PPSM5       :1;                                       /* Pull Select Port M Bit 5 */
    byte PPSM6       :1;                                       /* Pull Select Port M Bit 6 */
    byte PPSM7       :1;                                       /* Pull Select Port M Bit 7 */
  } Bits;
} PPSMSTR;
extern volatile PPSMSTR _PPSM @(REG_BASE + 0x00000255);
#define PPSM                            _PPSM.Byte
#define PPSM_PPSM0                      _PPSM.Bits.PPSM0
#define PPSM_PPSM1                      _PPSM.Bits.PPSM1
#define PPSM_PPSM2                      _PPSM.Bits.PPSM2
#define PPSM_PPSM3                      _PPSM.Bits.PPSM3
#define PPSM_PPSM4                      _PPSM.Bits.PPSM4
#define PPSM_PPSM5                      _PPSM.Bits.PPSM5
#define PPSM_PPSM6                      _PPSM.Bits.PPSM6
#define PPSM_PPSM7                      _PPSM.Bits.PPSM7

#define PPSM_PPSM0_MASK                 1
#define PPSM_PPSM1_MASK                 2
#define PPSM_PPSM2_MASK                 4
#define PPSM_PPSM3_MASK                 8
#define PPSM_PPSM4_MASK                 16
#define PPSM_PPSM5_MASK                 32
#define PPSM_PPSM6_MASK                 64
#define PPSM_PPSM7_MASK                 128


/*** WOMM - Port M Wired-Or Mode Register; 0x00000256 ***/
typedef union {
  byte Byte;
  struct {
    byte WOMM0       :1;                                       /* Wired-Or Mode Port M Bit 0 */
    byte WOMM1       :1;                                       /* Wired-Or Mode Port M Bit 1 */
    byte WOMM2       :1;                                       /* Wired-Or Mode Port M Bit 2 */
    byte WOMM3       :1;                                       /* Wired-Or Mode Port M Bit 3 */
    byte WOMM4       :1;                                       /* Wired-Or Mode Port M Bit 4 */
    byte WOMM5       :1;                                       /* Wired-Or Mode Port M Bit 5 */
    byte WOMM6       :1;                                       /* Wired-Or Mode Port M Bit 6 */
    byte WOMM7       :1;                                       /* Wired-Or Mode Port M Bit 7 */
  } Bits;
} WOMMSTR;
extern volatile WOMMSTR _WOMM @(REG_BASE + 0x00000256);
#define WOMM                            _WOMM.Byte
#define WOMM_WOMM0                      _WOMM.Bits.WOMM0
#define WOMM_WOMM1                      _WOMM.Bits.WOMM1
#define WOMM_WOMM2                      _WOMM.Bits.WOMM2
#define WOMM_WOMM3                      _WOMM.Bits.WOMM3
#define WOMM_WOMM4                      _WOMM.Bits.WOMM4
#define WOMM_WOMM5                      _WOMM.Bits.WOMM5
#define WOMM_WOMM6                      _WOMM.Bits.WOMM6
#define WOMM_WOMM7                      _WOMM.Bits.WOMM7

#define WOMM_WOMM0_MASK                 1
#define WOMM_WOMM1_MASK                 2
#define WOMM_WOMM2_MASK                 4
#define WOMM_WOMM3_MASK                 8
#define WOMM_WOMM4_MASK                 16
#define WOMM_WOMM5_MASK                 32
#define WOMM_WOMM6_MASK                 64
#define WOMM_WOMM7_MASK                 128


/*** PTP - Port P I/O Register; 0x00000258 ***/
typedef union {
  byte Byte;
  struct {
    byte PTP0        :1;                                       /* Port P Bit 0 */
    byte PTP1        :1;                                       /* Port P Bit 1 */
    byte PTP2        :1;                                       /* Port P Bit 2 */
    byte PTP3        :1;                                       /* Port P Bit 3 */
    byte PTP4        :1;                                       /* Port P Bit 4 */
    byte PTP5        :1;                                       /* Port P Bit 5 */
    byte PTP6        :1;                                       /* Port P Bit 6 */
    byte PTP7        :1;                                       /* Port P Bit 7 */
  } Bits;
} PTPSTR;
extern volatile PTPSTR _PTP @(REG_BASE + 0x00000258);
#define PTP                             _PTP.Byte
#define PTP_PTP0                        _PTP.Bits.PTP0
#define PTP_PTP1                        _PTP.Bits.PTP1
#define PTP_PTP2                        _PTP.Bits.PTP2
#define PTP_PTP3                        _PTP.Bits.PTP3
#define PTP_PTP4                        _PTP.Bits.PTP4
#define PTP_PTP5                        _PTP.Bits.PTP5
#define PTP_PTP6                        _PTP.Bits.PTP6
#define PTP_PTP7                        _PTP.Bits.PTP7

#define PTP_PTP0_MASK                   1
#define PTP_PTP1_MASK                   2
#define PTP_PTP2_MASK                   4
#define PTP_PTP3_MASK                   8
#define PTP_PTP4_MASK                   16
#define PTP_PTP5_MASK                   32
#define PTP_PTP6_MASK                   64
#define PTP_PTP7_MASK                   128


/*** PTIP - Port P Input Register; 0x00000259 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIP0       :1;                                       /* Port P Bit 0 */
    byte PTIP1       :1;                                       /* Port P Bit 1 */
    byte PTIP2       :1;                                       /* Port P Bit 2 */
    byte PTIP3       :1;                                       /* Port P Bit 3 */
    byte PTIP4       :1;                                       /* Port P Bit 4 */
    byte PTIP5       :1;                                       /* Port P Bit 5 */
    byte PTIP6       :1;                                       /* Port P Bit 6 */
    byte PTIP7       :1;                                       /* Port P Bit 7 */
  } Bits;
} PTIPSTR;
extern volatile PTIPSTR _PTIP @(REG_BASE + 0x00000259);
#define PTIP                            _PTIP.Byte
#define PTIP_PTIP0                      _PTIP.Bits.PTIP0
#define PTIP_PTIP1                      _PTIP.Bits.PTIP1
#define PTIP_PTIP2                      _PTIP.Bits.PTIP2
#define PTIP_PTIP3                      _PTIP.Bits.PTIP3
#define PTIP_PTIP4                      _PTIP.Bits.PTIP4
#define PTIP_PTIP5                      _PTIP.Bits.PTIP5
#define PTIP_PTIP6                      _PTIP.Bits.PTIP6
#define PTIP_PTIP7                      _PTIP.Bits.PTIP7

#define PTIP_PTIP0_MASK                 1
#define PTIP_PTIP1_MASK                 2
#define PTIP_PTIP2_MASK                 4
#define PTIP_PTIP3_MASK                 8
#define PTIP_PTIP4_MASK                 16
#define PTIP_PTIP5_MASK                 32
#define PTIP_PTIP6_MASK                 64
#define PTIP_PTIP7_MASK                 128


/*** DDRP - Port P Data Direction Register; 0x0000025A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRP0       :1;                                       /* Data Direction Port P Bit 0 */
    byte DDRP1       :1;                                       /* Data Direction Port P Bit 1 */
    byte DDRP2       :1;                                       /* Data Direction Port P Bit 2 */
    byte DDRP3       :1;                                       /* Data Direction Port P Bit 3 */
    byte DDRP4       :1;                                       /* Data Direction Port P Bit 4 */
    byte DDRP5       :1;                                       /* Data Direction Port P Bit 5 */
    byte DDRP6       :1;                                       /* Data Direction Port P Bit 6 */
    byte DDRP7       :1;                                       /* Data Direction Port P Bit 7 */
  } Bits;
} DDRPSTR;
extern volatile DDRPSTR _DDRP @(REG_BASE + 0x0000025A);
#define DDRP                            _DDRP.Byte
#define DDRP_DDRP0                      _DDRP.Bits.DDRP0
#define DDRP_DDRP1                      _DDRP.Bits.DDRP1
#define DDRP_DDRP2                      _DDRP.Bits.DDRP2
#define DDRP_DDRP3                      _DDRP.Bits.DDRP3
#define DDRP_DDRP4                      _DDRP.Bits.DDRP4
#define DDRP_DDRP5                      _DDRP.Bits.DDRP5
#define DDRP_DDRP6                      _DDRP.Bits.DDRP6
#define DDRP_DDRP7                      _DDRP.Bits.DDRP7

#define DDRP_DDRP0_MASK                 1
#define DDRP_DDRP1_MASK                 2
#define DDRP_DDRP2_MASK                 4
#define DDRP_DDRP3_MASK                 8
#define DDRP_DDRP4_MASK                 16
#define DDRP_DDRP5_MASK                 32
#define DDRP_DDRP6_MASK                 64
#define DDRP_DDRP7_MASK                 128


/*** RDRP - Port P Reduced Drive Register; 0x0000025B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRP0       :1;                                       /* Reduced Drive Port P Bit 0 */
    byte RDRP1       :1;                                       /* Reduced Drive Port P Bit 1 */
    byte RDRP2       :1;                                       /* Reduced Drive Port P Bit 2 */
    byte RDRP3       :1;                                       /* Reduced Drive Port P Bit 3 */
    byte RDRP4       :1;                                       /* Reduced Drive Port P Bit 4 */
    byte RDRP5       :1;                                       /* Reduced Drive Port P Bit 5 */
    byte RDRP6       :1;                                       /* Reduced Drive Port P Bit 6 */
    byte RDRP7       :1;                                       /* Reduced Drive Port P Bit 7 */
  } Bits;
} RDRPSTR;
extern volatile RDRPSTR _RDRP @(REG_BASE + 0x0000025B);
#define RDRP                            _RDRP.Byte
#define RDRP_RDRP0                      _RDRP.Bits.RDRP0
#define RDRP_RDRP1                      _RDRP.Bits.RDRP1
#define RDRP_RDRP2                      _RDRP.Bits.RDRP2
#define RDRP_RDRP3                      _RDRP.Bits.RDRP3
#define RDRP_RDRP4                      _RDRP.Bits.RDRP4
#define RDRP_RDRP5                      _RDRP.Bits.RDRP5
#define RDRP_RDRP6                      _RDRP.Bits.RDRP6
#define RDRP_RDRP7                      _RDRP.Bits.RDRP7

#define RDRP_RDRP0_MASK                 1
#define RDRP_RDRP1_MASK                 2
#define RDRP_RDRP2_MASK                 4
#define RDRP_RDRP3_MASK                 8
#define RDRP_RDRP4_MASK                 16
#define RDRP_RDRP5_MASK                 32
#define RDRP_RDRP6_MASK                 64
#define RDRP_RDRP7_MASK                 128


/*** PERP - Port P Pull Device Enable Register; 0x0000025C ***/
typedef union {
  byte Byte;
  struct {
    byte PERP0       :1;                                       /* Pull Device Enable Port P Bit 0 */
    byte PERP1       :1;                                       /* Pull Device Enable Port P Bit 1 */
    byte PERP2       :1;                                       /* Pull Device Enable Port P Bit 2 */
    byte PERP3       :1;                                       /* Pull Device Enable Port P Bit 3 */
    byte PERP4       :1;                                       /* Pull Device Enable Port P Bit 4 */
    byte PERP5       :1;                                       /* Pull Device Enable Port P Bit 5 */
    byte PERP6       :1;                                       /* Pull Device Enable Port P Bit 6 */
    byte PERP7       :1;                                       /* Pull Device Enable Port P Bit 7 */
  } Bits;
} PERPSTR;
extern volatile PERPSTR _PERP @(REG_BASE + 0x0000025C);
#define PERP                            _PERP.Byte
#define PERP_PERP0                      _PERP.Bits.PERP0
#define PERP_PERP1                      _PERP.Bits.PERP1
#define PERP_PERP2                      _PERP.Bits.PERP2
#define PERP_PERP3                      _PERP.Bits.PERP3
#define PERP_PERP4                      _PERP.Bits.PERP4
#define PERP_PERP5                      _PERP.Bits.PERP5
#define PERP_PERP6                      _PERP.Bits.PERP6
#define PERP_PERP7                      _PERP.Bits.PERP7

#define PERP_PERP0_MASK                 1
#define PERP_PERP1_MASK                 2
#define PERP_PERP2_MASK                 4
#define PERP_PERP3_MASK                 8
#define PERP_PERP4_MASK                 16
#define PERP_PERP5_MASK                 32
#define PERP_PERP6_MASK                 64
#define PERP_PERP7_MASK                 128


/*** PPSP - Port P Polarity Select Register; 0x0000025D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSP0       :1;                                       /* Pull Select Port P Bit 0 */
    byte PPSP1       :1;                                       /* Pull Select Port P Bit 1 */
    byte PPSP2       :1;                                       /* Pull Select Port P Bit 2 */
    byte PPSP3       :1;                                       /* Pull Select Port P Bit 3 */
    byte PPSP4       :1;                                       /* Pull Select Port P Bit 4 */
    byte PPSP5       :1;                                       /* Pull Select Port P Bit 5 */
    byte PPSP6       :1;                                       /* Pull Select Port P Bit 6 */
    byte PPSP7       :1;                                       /* Pull Select Port P Bit 7 */
  } Bits;
} PPSPSTR;
extern volatile PPSPSTR _PPSP @(REG_BASE + 0x0000025D);
#define PPSP                            _PPSP.Byte
#define PPSP_PPSP0                      _PPSP.Bits.PPSP0
#define PPSP_PPSP1                      _PPSP.Bits.PPSP1
#define PPSP_PPSP2                      _PPSP.Bits.PPSP2
#define PPSP_PPSP3                      _PPSP.Bits.PPSP3
#define PPSP_PPSP4                      _PPSP.Bits.PPSP4
#define PPSP_PPSP5                      _PPSP.Bits.PPSP5
#define PPSP_PPSP6                      _PPSP.Bits.PPSP6
#define PPSP_PPSP7                      _PPSP.Bits.PPSP7

#define PPSP_PPSP0_MASK                 1
#define PPSP_PPSP1_MASK                 2
#define PPSP_PPSP2_MASK                 4
#define PPSP_PPSP3_MASK                 8
#define PPSP_PPSP4_MASK                 16
#define PPSP_PPSP5_MASK                 32
#define PPSP_PPSP6_MASK                 64
#define PPSP_PPSP7_MASK                 128


/*** PTH - Port H I/O Register; 0x00000260 ***/
typedef union {
  byte Byte;
  struct {
    byte PTH0        :1;                                       /* Port H Bit 0 */
    byte PTH1        :1;                                       /* Port H Bit 1 */
    byte PTH2        :1;                                       /* Port H Bit 2 */
    byte PTH3        :1;                                       /* Port H Bit 3 */
    byte PTH4        :1;                                       /* Port H Bit 4 */
    byte PTH5        :1;                                       /* Port H Bit 5 */
    byte PTH6        :1;                                       /* Port H Bit 6 */
    byte PTH7        :1;                                       /* Port H Bit 7 */
  } Bits;
} PTHSTR;
extern volatile PTHSTR _PTH @(REG_BASE + 0x00000260);
#define PTH                             _PTH.Byte
#define PTH_PTH0                        _PTH.Bits.PTH0
#define PTH_PTH1                        _PTH.Bits.PTH1
#define PTH_PTH2                        _PTH.Bits.PTH2
#define PTH_PTH3                        _PTH.Bits.PTH3
#define PTH_PTH4                        _PTH.Bits.PTH4
#define PTH_PTH5                        _PTH.Bits.PTH5
#define PTH_PTH6                        _PTH.Bits.PTH6
#define PTH_PTH7                        _PTH.Bits.PTH7

#define PTH_PTH0_MASK                   1
#define PTH_PTH1_MASK                   2
#define PTH_PTH2_MASK                   4
#define PTH_PTH3_MASK                   8
#define PTH_PTH4_MASK                   16
#define PTH_PTH5_MASK                   32
#define PTH_PTH6_MASK                   64
#define PTH_PTH7_MASK                   128


/*** PTIH - Port H Input Register; 0x00000261 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIH0       :1;                                       /* Port H Bit 0 */
    byte PTIH1       :1;                                       /* Port H Bit 1 */
    byte PTIH2       :1;                                       /* Port H Bit 2 */
    byte PTIH3       :1;                                       /* Port H Bit 3 */
    byte PTIH4       :1;                                       /* Port H Bit 4 */
    byte PTIH5       :1;                                       /* Port H Bit 5 */
    byte PTIH6       :1;                                       /* Port H Bit 6 */
    byte PTIH7       :1;                                       /* Port H Bit 7 */
  } Bits;
} PTIHSTR;
extern volatile PTIHSTR _PTIH @(REG_BASE + 0x00000261);
#define PTIH                            _PTIH.Byte
#define PTIH_PTIH0                      _PTIH.Bits.PTIH0
#define PTIH_PTIH1                      _PTIH.Bits.PTIH1
#define PTIH_PTIH2                      _PTIH.Bits.PTIH2
#define PTIH_PTIH3                      _PTIH.Bits.PTIH3
#define PTIH_PTIH4                      _PTIH.Bits.PTIH4
#define PTIH_PTIH5                      _PTIH.Bits.PTIH5
#define PTIH_PTIH6                      _PTIH.Bits.PTIH6
#define PTIH_PTIH7                      _PTIH.Bits.PTIH7

#define PTIH_PTIH0_MASK                 1
#define PTIH_PTIH1_MASK                 2
#define PTIH_PTIH2_MASK                 4
#define PTIH_PTIH3_MASK                 8
#define PTIH_PTIH4_MASK                 16
#define PTIH_PTIH5_MASK                 32
#define PTIH_PTIH6_MASK                 64
#define PTIH_PTIH7_MASK                 128


/*** DDRH - Port H Data Direction Register; 0x00000262 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRH0       :1;                                       /* Data Direction Port H Bit 0 */
    byte DDRH1       :1;                                       /* Data Direction Port H Bit 1 */
    byte DDRH2       :1;                                       /* Data Direction Port H Bit 2 */
    byte DDRH3       :1;                                       /* Data Direction Port H Bit 3 */
    byte DDRH4       :1;                                       /* Data Direction Port H Bit 4 */
    byte DDRH5       :1;                                       /* Data Direction Port H Bit 5 */
    byte DDRH6       :1;                                       /* Data Direction Port H Bit 6 */
    byte DDRH7       :1;                                       /* Data Direction Port H Bit 7 */
  } Bits;
} DDRHSTR;
extern volatile DDRHSTR _DDRH @(REG_BASE + 0x00000262);
#define DDRH                            _DDRH.Byte
#define DDRH_DDRH0                      _DDRH.Bits.DDRH0
#define DDRH_DDRH1                      _DDRH.Bits.DDRH1
#define DDRH_DDRH2                      _DDRH.Bits.DDRH2
#define DDRH_DDRH3                      _DDRH.Bits.DDRH3
#define DDRH_DDRH4                      _DDRH.Bits.DDRH4
#define DDRH_DDRH5                      _DDRH.Bits.DDRH5
#define DDRH_DDRH6                      _DDRH.Bits.DDRH6
#define DDRH_DDRH7                      _DDRH.Bits.DDRH7

#define DDRH_DDRH0_MASK                 1
#define DDRH_DDRH1_MASK                 2
#define DDRH_DDRH2_MASK                 4
#define DDRH_DDRH3_MASK                 8
#define DDRH_DDRH4_MASK                 16
#define DDRH_DDRH5_MASK                 32
#define DDRH_DDRH6_MASK                 64
#define DDRH_DDRH7_MASK                 128


/*** RDRH - Port H Reduced Drive Register; 0x00000263 ***/
typedef union {
  byte Byte;
  struct {
    byte RDRH0       :1;                                       /* Reduced Drive Port H Bit 0 */
    byte RDRH1       :1;                                       /* Reduced Drive Port H Bit 1 */
    byte RDRH2       :1;                                       /* Reduced Drive Port H Bit 2 */
    byte RDRH3       :1;                                       /* Reduced Drive Port H Bit 3 */
    byte RDRH4       :1;                                       /* Reduced Drive Port H Bit 4 */
    byte RDRH5       :1;                                       /* Reduced Drive Port H Bit 5 */
    byte RDRH6       :1;                                       /* Reduced Drive Port H Bit 6 */
    byte RDRH7       :1;                                       /* Reduced Drive Port H Bit 7 */
  } Bits;
} RDRHSTR;
extern volatile RDRHSTR _RDRH @(REG_BASE + 0x00000263);
#define RDRH                            _RDRH.Byte
#define RDRH_RDRH0                      _RDRH.Bits.RDRH0
#define RDRH_RDRH1                      _RDRH.Bits.RDRH1
#define RDRH_RDRH2                      _RDRH.Bits.RDRH2
#define RDRH_RDRH3                      _RDRH.Bits.RDRH3
#define RDRH_RDRH4                      _RDRH.Bits.RDRH4
#define RDRH_RDRH5                      _RDRH.Bits.RDRH5
#define RDRH_RDRH6                      _RDRH.Bits.RDRH6
#define RDRH_RDRH7                      _RDRH.Bits.RDRH7

#define RDRH_RDRH0_MASK                 1
#define RDRH_RDRH1_MASK                 2
#define RDRH_RDRH2_MASK                 4
#define RDRH_RDRH3_MASK                 8
#define RDRH_RDRH4_MASK                 16
#define RDRH_RDRH5_MASK                 32
#define RDRH_RDRH6_MASK                 64
#define RDRH_RDRH7_MASK                 128


/*** PERH - Port H Pull Device Enable Register; 0x00000264 ***/
typedef union {
  byte Byte;
  struct {
    byte PERH0       :1;                                       /* Pull Device Enable Port H Bit 0 */
    byte PERH1       :1;                                       /* Pull Device Enable Port H Bit 1 */
    byte PERH2       :1;                                       /* Pull Device Enable Port H Bit 2 */
    byte PERH3       :1;                                       /* Pull Device Enable Port H Bit 3 */
    byte PERH4       :1;                                       /* Pull Device Enable Port H Bit 4 */
    byte PERH5       :1;                                       /* Pull Device Enable Port H Bit 5 */
    byte PERH6       :1;                                       /* Pull Device Enable Port H Bit 6 */
    byte PERH7       :1;                                       /* Pull Device Enable Port H Bit 7 */
  } Bits;
} PERHSTR;
extern volatile PERHSTR _PERH @(REG_BASE + 0x00000264);
#define PERH                            _PERH.Byte
#define PERH_PERH0                      _PERH.Bits.PERH0
#define PERH_PERH1                      _PERH.Bits.PERH1
#define PERH_PERH2                      _PERH.Bits.PERH2
#define PERH_PERH3                      _PERH.Bits.PERH3
#define PERH_PERH4                      _PERH.Bits.PERH4
#define PERH_PERH5                      _PERH.Bits.PERH5
#define PERH_PERH6                      _PERH.Bits.PERH6
#define PERH_PERH7                      _PERH.Bits.PERH7

#define PERH_PERH0_MASK                 1
#define PERH_PERH1_MASK                 2
#define PERH_PERH2_MASK                 4
#define PERH_PERH3_MASK                 8
#define PERH_PERH4_MASK                 16
#define PERH_PERH5_MASK                 32
#define PERH_PERH6_MASK                 64
#define PERH_PERH7_MASK                 128


/*** PPSH - Port H Polarity Select Register; 0x00000265 ***/
typedef union {
  byte Byte;
  struct {
    byte PPSH0       :1;                                       /* Pull Select Port H Bit 0 */
    byte PPSH1       :1;                                       /* Pull Select Port H Bit 1 */
    byte PPSH2       :1;                                       /* Pull Select Port H Bit 2 */
    byte PPSH3       :1;                                       /* Pull Select Port H Bit 3 */
    byte PPSH4       :1;                                       /* Pull Select Port H Bit 4 */
    byte PPSH5       :1;                                       /* Pull Select Port H Bit 5 */
    byte PPSH6       :1;                                       /* Pull Select Port H Bit 6 */
    byte PPSH7       :1;                                       /* Pull Select Port H Bit 7 */
  } Bits;
} PPSHSTR;
extern volatile PPSHSTR _PPSH @(REG_BASE + 0x00000265);
#define PPSH                            _PPSH.Byte
#define PPSH_PPSH0                      _PPSH.Bits.PPSH0
#define PPSH_PPSH1                      _PPSH.Bits.PPSH1
#define PPSH_PPSH2                      _PPSH.Bits.PPSH2
#define PPSH_PPSH3                      _PPSH.Bits.PPSH3
#define PPSH_PPSH4                      _PPSH.Bits.PPSH4
#define PPSH_PPSH5                      _PPSH.Bits.PPSH5
#define PPSH_PPSH6                      _PPSH.Bits.PPSH6
#define PPSH_PPSH7                      _PPSH.Bits.PPSH7

#define PPSH_PPSH0_MASK                 1
#define PPSH_PPSH1_MASK                 2
#define PPSH_PPSH2_MASK                 4
#define PPSH_PPSH3_MASK                 8
#define PPSH_PPSH4_MASK                 16
#define PPSH_PPSH5_MASK                 32
#define PPSH_PPSH6_MASK                 64
#define PPSH_PPSH7_MASK                 128


/*** PTJ - Port J I/O Register; 0x00000268 ***/
typedef union {
  byte Byte;
  struct {
    byte PTJ0        :1;                                       /* Port J Bit 0 */
    byte PTJ1        :1;                                       /* Port J Bit 1 */
    byte PTJ2        :1;                                       /* Port J Bit 2 */
    byte             :1; 
    byte PTJ4        :1;                                       /* Port J Bit 4 */
    byte PTJ5        :1;                                       /* Port J Bit 5 */
    byte PTJ6        :1;                                       /* Port J Bit 6 */
    byte PTJ7        :1;                                       /* Port J Bit 7 */
  } Bits;
  struct {
    byte grpPTJ  :3;
    byte         :1;
    byte grpPTJ_4 :4;
  } MergedBits;
} PTJSTR;
extern volatile PTJSTR _PTJ @(REG_BASE + 0x00000268);
#define PTJ                             _PTJ.Byte
#define PTJ_PTJ0                        _PTJ.Bits.PTJ0
#define PTJ_PTJ1                        _PTJ.Bits.PTJ1
#define PTJ_PTJ2                        _PTJ.Bits.PTJ2
#define PTJ_PTJ4                        _PTJ.Bits.PTJ4
#define PTJ_PTJ5                        _PTJ.Bits.PTJ5
#define PTJ_PTJ6                        _PTJ.Bits.PTJ6
#define PTJ_PTJ7                        _PTJ.Bits.PTJ7
#define PTJ_PTJ                         _PTJ.MergedBits.grpPTJ
#define PTJ_PTJ_4                       _PTJ.MergedBits.grpPTJ_4

#define PTJ_PTJ0_MASK                   1
#define PTJ_PTJ1_MASK                   2
#define PTJ_PTJ2_MASK                   4
#define PTJ_PTJ4_MASK                   16
#define PTJ_PTJ5_MASK                   32
#define PTJ_PTJ6_MASK                   64
#define PTJ_PTJ7_MASK                   128
#define PTJ_PTJ_MASK                    7
#define PTJ_PTJ_BITNUM                  0
#define PTJ_PTJ_4_MASK                  240
#define PTJ_PTJ_4_BITNUM                4


/*** PTIJ - Port J Input Register; 0x00000269 ***/
typedef union {
  byte Byte;
  struct {
    byte PTIJ0       :1;                                       /* Port J Bit 0 */
    byte PTIJ1       :1;                                       /* Port J Bit 1 */
    byte PTIJ2       :1;                                       /* Port J Bit 2 */
    byte             :1; 
    byte PTIJ4       :1;                                       /* Port J Bit 4 */
    byte PTIJ5       :1;                                       /* Port J Bit 5 */
    byte PTIJ6       :1;                                       /* Port J Bit 6 */
    byte PTIJ7       :1;                                       /* Port J Bit 7 */
  } Bits;
  struct {
    byte grpPTIJ :3;
    byte         :1;
    byte grpPTIJ_4 :4;
  } MergedBits;
} PTIJSTR;
extern volatile PTIJSTR _PTIJ @(REG_BASE + 0x00000269);
#define PTIJ                            _PTIJ.Byte
#define PTIJ_PTIJ0                      _PTIJ.Bits.PTIJ0
#define PTIJ_PTIJ1                      _PTIJ.Bits.PTIJ1
#define PTIJ_PTIJ2                      _PTIJ.Bits.PTIJ2
#define PTIJ_PTIJ4                      _PTIJ.Bits.PTIJ4
#define PTIJ_PTIJ5                      _PTIJ.Bits.PTIJ5
#define PTIJ_PTIJ6                      _PTIJ.Bits.PTIJ6
#define PTIJ_PTIJ7                      _PTIJ.Bits.PTIJ7
#define PTIJ_PTIJ                       _PTIJ.MergedBits.grpPTIJ
#define PTIJ_PTIJ_4                     _PTIJ.MergedBits.grpPTIJ_4

#define PTIJ_PTIJ0_MASK                 1
#define PTIJ_PTIJ1_MASK                 2
#define PTIJ_PTIJ2_MASK                 4
#define PTIJ_PTIJ4_MASK                 16
#define PTIJ_PTIJ5_MASK                 32
#define PTIJ_PTIJ6_MASK                 64
#define PTIJ_PTIJ7_MASK                 128
#define PTIJ_PTIJ_MASK                  7
#define PTIJ_PTIJ_BITNUM                0
#define PTIJ_PTIJ_4_MASK                240
#define PTIJ_PTIJ_4_BITNUM              4


/*** DDRJ - Port J Data Direction Register; 0x0000026A ***/
typedef union {
  byte Byte;
  struct {
    byte DDRJ0       :1;                                       /* Data Direction Port J Bit 0 */
    byte DDRJ1       :1;                                       /* Data Direction Port J Bit 1 */
    byte DDRJ2       :1;                                       /* Data Direction Port J Bit 2 */
    byte             :1; 
    byte DDRJ4       :1;                                       /* Data Direction Port J Bit 4 */
    byte DDRJ5       :1;                                       /* Data Direction Port J Bit 5 */
    byte DDRJ6       :1;                                       /* Data Direction Port J Bit 6 */
    byte DDRJ7       :1;                                       /* Data Direction Port J Bit 7 */
  } Bits;
  struct {
    byte grpDDRJ :3;
    byte         :1;
    byte grpDDRJ_4 :4;
  } MergedBits;
} DDRJSTR;
extern volatile DDRJSTR _DDRJ @(REG_BASE + 0x0000026A);
#define DDRJ                            _DDRJ.Byte
#define DDRJ_DDRJ0                      _DDRJ.Bits.DDRJ0
#define DDRJ_DDRJ1                      _DDRJ.Bits.DDRJ1
#define DDRJ_DDRJ2                      _DDRJ.Bits.DDRJ2
#define DDRJ_DDRJ4                      _DDRJ.Bits.DDRJ4
#define DDRJ_DDRJ5                      _DDRJ.Bits.DDRJ5
#define DDRJ_DDRJ6                      _DDRJ.Bits.DDRJ6
#define DDRJ_DDRJ7                      _DDRJ.Bits.DDRJ7
#define DDRJ_DDRJ                       _DDRJ.MergedBits.grpDDRJ
#define DDRJ_DDRJ_4                     _DDRJ.MergedBits.grpDDRJ_4

#define DDRJ_DDRJ0_MASK                 1
#define DDRJ_DDRJ1_MASK                 2
#define DDRJ_DDRJ2_MASK                 4
#define DDRJ_DDRJ4_MASK                 16
#define DDRJ_DDRJ5_MASK                 32
#define DDRJ_DDRJ6_MASK                 64
#define DDRJ_DDRJ7_MASK                 128
#define DDRJ_DDRJ_MASK                  7
#define DDRJ_DDRJ_BITNUM                0
#define DDRJ_DDRJ_4_MASK                240
#define DDRJ_DDRJ_4_BITNUM              4


/*** RDRJ - Port J Reduced Drive Register; 0x0000026B ***/
typedef union {
  byte Byte;
  struct {
    byte RDRJ0       :1;                                       /* Reduced Drive Port J Bit 0 */
    byte RDRJ1       :1;                                       /* Reduced Drive Port J Bit 1 */
    byte RDRJ2       :1;                                       /* Reduced Drive Port J Bit 2 */
    byte             :1; 
    byte RDRJ4       :1;                                       /* Reduced Drive Port J Bit 4 */
    byte RDRJ5       :1;                                       /* Reduced Drive Port J Bit 5 */
    byte RDRJ6       :1;                                       /* Reduced Drive Port J Bit 6 */
    byte RDRJ7       :1;                                       /* Reduced Drive Port J Bit 7 */
  } Bits;
  struct {
    byte grpRDRJ :3;
    byte         :1;
    byte grpRDRJ_4 :4;
  } MergedBits;
} RDRJSTR;
extern volatile RDRJSTR _RDRJ @(REG_BASE + 0x0000026B);
#define RDRJ                            _RDRJ.Byte
#define RDRJ_RDRJ0                      _RDRJ.Bits.RDRJ0
#define RDRJ_RDRJ1                      _RDRJ.Bits.RDRJ1
#define RDRJ_RDRJ2                      _RDRJ.Bits.RDRJ2
#define RDRJ_RDRJ4                      _RDRJ.Bits.RDRJ4
#define RDRJ_RDRJ5                      _RDRJ.Bits.RDRJ5
#define RDRJ_RDRJ6                      _RDRJ.Bits.RDRJ6
#define RDRJ_RDRJ7                      _RDRJ.Bits.RDRJ7
#define RDRJ_RDRJ                       _RDRJ.MergedBits.grpRDRJ
#define RDRJ_RDRJ_4                     _RDRJ.MergedBits.grpRDRJ_4

#define RDRJ_RDRJ0_MASK                 1
#define RDRJ_RDRJ1_MASK                 2
#define RDRJ_RDRJ2_MASK                 4
#define RDRJ_RDRJ4_MASK                 16
#define RDRJ_RDRJ5_MASK                 32
#define RDRJ_RDRJ6_MASK                 64
#define RDRJ_RDRJ7_MASK                 128
#define RDRJ_RDRJ_MASK                  7
#define RDRJ_RDRJ_BITNUM                0
#define RDRJ_RDRJ_4_MASK                240
#define RDRJ_RDRJ_4_BITNUM              4


/*** PERJ - Port J Pull Device Enable Register; 0x0000026C ***/
typedef union {
  byte Byte;
  struct {
    byte PERJ0       :1;                                       /* Pull Device Enable Port J Bit 0 */
    byte PERJ1       :1;                                       /* Pull Device Enable Port J Bit 1 */
    byte PERJ2       :1;                                       /* Pull Device Enable Port J Bit 2 */
    byte             :1; 
    byte PERJ4       :1;                                       /* Pull Device Enable Port J Bit 4 */
    byte PERJ5       :1;                                       /* Pull Device Enable Port J Bit 5 */
    byte PERJ6       :1;                                       /* Pull Device Enable Port J Bit 6 */
    byte PERJ7       :1;                                       /* Pull Device Enable Port J Bit 7 */
  } Bits;
  struct {
    byte grpPERJ :3;
    byte         :1;
    byte grpPERJ_4 :4;
  } MergedBits;
} PERJSTR;
extern volatile PERJSTR _PERJ @(REG_BASE + 0x0000026C);
#define PERJ                            _PERJ.Byte
#define PERJ_PERJ0                      _PERJ.Bits.PERJ0
#define PERJ_PERJ1                      _PERJ.Bits.PERJ1
#define PERJ_PERJ2                      _PERJ.Bits.PERJ2
#define PERJ_PERJ4                      _PERJ.Bits.PERJ4
#define PERJ_PERJ5                      _PERJ.Bits.PERJ5
#define PERJ_PERJ6                      _PERJ.Bits.PERJ6
#define PERJ_PERJ7                      _PERJ.Bits.PERJ7
#define PERJ_PERJ                       _PERJ.MergedBits.grpPERJ
#define PERJ_PERJ_4                     _PERJ.MergedBits.grpPERJ_4

#define PERJ_PERJ0_MASK                 1
#define PERJ_PERJ1_MASK                 2
#define PERJ_PERJ2_MASK                 4
#define PERJ_PERJ4_MASK                 16
#define PERJ_PERJ5_MASK                 32
#define PERJ_PERJ6_MASK                 64
#define PERJ_PERJ7_MASK                 128
#define PERJ_PERJ_MASK                  7
#define PERJ_PERJ_BITNUM                0
#define PERJ_PERJ_4_MASK                240
#define PERJ_PERJ_4_BITNUM              4


/*** PPSJ - Port J Polarity Select Register; 0x0000026D ***/
typedef union {
  byte Byte;
  struct {
    byte PPSJ0       :1;                                       /* Pull Select Port J Bit 0 */
    byte PPSJ1       :1;                                       /* Pull Select Port J Bit 1 */
    byte PPSJ2       :1;                                       /* Pull Select Port J Bit 2 */
    byte             :1; 
    byte PPSJ4       :1;                                       /* Pull Select Port J Bit 4 */
    byte PPSJ5       :1;                                       /* Pull Select Port J Bit 5 */
    byte PPSJ6       :1;                                       /* Pull Select Port J Bit 6 */
    byte PPSJ7       :1;                                       /* Pull Select Port J Bit 7 */
  } Bits;
  struct {
    byte grpPPSJ :3;
    byte         :1;
    byte grpPPSJ_4 :4;
  } MergedBits;
} PPSJSTR;
extern volatile PPSJSTR _PPSJ @(REG_BASE + 0x0000026D);
#define PPSJ                            _PPSJ.Byte
#define PPSJ_PPSJ0                      _PPSJ.Bits.PPSJ0
#define PPSJ_PPSJ1                      _PPSJ.Bits.PPSJ1
#define PPSJ_PPSJ2                      _PPSJ.Bits.PPSJ2
#define PPSJ_PPSJ4                      _PPSJ.Bits.PPSJ4
#define PPSJ_PPSJ5                      _PPSJ.Bits.PPSJ5
#define PPSJ_PPSJ6                      _PPSJ.Bits.PPSJ6
#define PPSJ_PPSJ7                      _PPSJ.Bits.PPSJ7
#define PPSJ_PPSJ                       _PPSJ.MergedBits.grpPPSJ
#define PPSJ_PPSJ_4                     _PPSJ.MergedBits.grpPPSJ_4

#define PPSJ_PPSJ0_MASK                 1
#define PPSJ_PPSJ1_MASK                 2
#define PPSJ_PPSJ2_MASK                 4
#define PPSJ_PPSJ4_MASK                 16
#define PPSJ_PPSJ5_MASK                 32
#define PPSJ_PPSJ6_MASK                 64
#define PPSJ_PPSJ7_MASK                 128
#define PPSJ_PPSJ_MASK                  7
#define PPSJ_PPSJ_BITNUM                0
#define PPSJ_PPSJ_4_MASK                240
#define PPSJ_PPSJ_4_BITNUM              4


/*** PT0AD - Port AD Data Register 1; 0x00000270 ***/
typedef union {
  byte Byte;
  struct {
    byte PT0AD8      :1;                                       /* Port AD Data Bit 8 */
    byte PT0AD9      :1;                                       /* Port AD Data Bit 9 */
    byte PT0AD10     :1;                                       /* Port AD Data Bit 10 */
    byte PT0AD11     :1;                                       /* Port AD Data Bit 11 */
    byte PT0AD12     :1;                                       /* Port AD Data Bit 12 */
    byte PT0AD13     :1;                                       /* Port AD Data Bit 13 */
    byte PT0AD14     :1;                                       /* Port AD Data Bit 14 */
    byte PT0AD15     :1;                                       /* Port AD Data Bit 15 */
  } Bits;
} PT0ADSTR;
extern volatile PT0ADSTR _PT0AD @(REG_BASE + 0x00000270);
#define PT0AD                           _PT0AD.Byte
#define PT0AD_PT0AD8                    _PT0AD.Bits.PT0AD8
#define PT0AD_PT0AD9                    _PT0AD.Bits.PT0AD9
#define PT0AD_PT0AD10                   _PT0AD.Bits.PT0AD10
#define PT0AD_PT0AD11                   _PT0AD.Bits.PT0AD11
#define PT0AD_PT0AD12                   _PT0AD.Bits.PT0AD12
#define PT0AD_PT0AD13                   _PT0AD.Bits.PT0AD13
#define PT0AD_PT0AD14                   _PT0AD.Bits.PT0AD14
#define PT0AD_PT0AD15                   _PT0AD.Bits.PT0AD15

#define PT0AD_PT0AD8_MASK               1
#define PT0AD_PT0AD9_MASK               2
#define PT0AD_PT0AD10_MASK              4
#define PT0AD_PT0AD11_MASK              8
#define PT0AD_PT0AD12_MASK              16
#define PT0AD_PT0AD13_MASK              32
#define PT0AD_PT0AD14_MASK              64
#define PT0AD_PT0AD15_MASK              128


/*** PT1AD - Port AD Data Register 1; 0x00000271 ***/
typedef union {
  byte Byte;
  struct {
    byte PT1AD0      :1;                                       /* Port AD Data Bit 0 */
    byte PT1AD1      :1;                                       /* Port AD Data Bit 1 */
    byte PT1AD2      :1;                                       /* Port AD Data Bit 2 */
    byte PT1AD3      :1;                                       /* Port AD Data Bit 3 */
    byte PT1AD4      :1;                                       /* Port AD Data Bit 4 */
    byte PT1AD5      :1;                                       /* Port AD Data Bit 5 */
    byte PT1AD6      :1;                                       /* Port AD Data Bit 6 */
    byte PT1AD7      :1;                                       /* Port AD Data Bit 7 */
  } Bits;
} PT1ADSTR;
extern volatile PT1ADSTR _PT1AD @(REG_BASE + 0x00000271);
#define PT1AD                           _PT1AD.Byte
#define PT1AD_PT1AD0                    _PT1AD.Bits.PT1AD0
#define PT1AD_PT1AD1                    _PT1AD.Bits.PT1AD1
#define PT1AD_PT1AD2                    _PT1AD.Bits.PT1AD2
#define PT1AD_PT1AD3                    _PT1AD.Bits.PT1AD3
#define PT1AD_PT1AD4                    _PT1AD.Bits.PT1AD4
#define PT1AD_PT1AD5                    _PT1AD.Bits.PT1AD5
#define PT1AD_PT1AD6                    _PT1AD.Bits.PT1AD6
#define PT1AD_PT1AD7                    _PT1AD.Bits.PT1AD7

#define PT1AD_PT1AD0_MASK               1
#define PT1AD_PT1AD1_MASK               2
#define PT1AD_PT1AD2_MASK               4
#define PT1AD_PT1AD3_MASK               8
#define PT1AD_PT1AD4_MASK               16
#define PT1AD_PT1AD5_MASK               32
#define PT1AD_PT1AD6_MASK               64
#define PT1AD_PT1AD7_MASK               128


/*** DDR0AD - Port AD Data Direction Register 0; 0x00000272 ***/
typedef union {
  byte Byte;
  struct {
    byte DDR0AD8     :1;                                       /* Port AD Data Direction Bit 8 */
    byte DDR0AD9     :1;                                       /* Port AD Data Direction Bit 9 */
    byte DDR0AD10    :1;                                       /* Port AD Data Direction Bit 10 */
    byte DDR0AD11    :1;                                       /* Port AD Data Direction Bit 11 */
    byte DDR0AD12    :1;                                       /* Port AD Data Direction Bit 12 */
    byte DDR0AD13    :1;                                       /* Port AD Data Direction Bit 13 */
    byte DDR0AD14    :1;                                       /* Port AD Data Direction Bit 14 */
    byte DDR0AD15    :1;                                       /* Port AD Data Direction Bit 15 */
  } Bits;
} DDR0ADSTR;
extern volatile DDR0ADSTR _DDR0AD @(REG_BASE + 0x00000272);
#define DDR0AD                          _DDR0AD.Byte
#define DDR0AD_DDR0AD8                  _DDR0AD.Bits.DDR0AD8
#define DDR0AD_DDR0AD9                  _DDR0AD.Bits.DDR0AD9
#define DDR0AD_DDR0AD10                 _DDR0AD.Bits.DDR0AD10
#define DDR0AD_DDR0AD11                 _DDR0AD.Bits.DDR0AD11
#define DDR0AD_DDR0AD12                 _DDR0AD.Bits.DDR0AD12
#define DDR0AD_DDR0AD13                 _DDR0AD.Bits.DDR0AD13
#define DDR0AD_DDR0AD14                 _DDR0AD.Bits.DDR0AD14
#define DDR0AD_DDR0AD15                 _DDR0AD.Bits.DDR0AD15

#define DDR0AD_DDR0AD8_MASK             1
#define DDR0AD_DDR0AD9_MASK             2
#define DDR0AD_DDR0AD10_MASK            4
#define DDR0AD_DDR0AD11_MASK            8
#define DDR0AD_DDR0AD12_MASK            16
#define DDR0AD_DDR0AD13_MASK            32
#define DDR0AD_DDR0AD14_MASK            64
#define DDR0AD_DDR0AD15_MASK            128


/*** DDR1AD - Port AD Data Direction Register 1; 0x00000273 ***/
typedef union {
  byte Byte;
  struct {
    byte DDR1AD0     :1;                                       /* Port AD Data Direction Bit 0 */
    byte DDR1AD1     :1;                                       /* Port AD Data Direction Bit 1 */
    byte DDR1AD2     :1;                                       /* Port AD Data Direction Bit 2 */
    byte DDR1AD3     :1;                                       /* Port AD Data Direction Bit 3 */
    byte DDR1AD4     :1;                                       /* Port AD Data Direction Bit 4 */
    byte DDR1AD5     :1;                                       /* Port AD Data Direction Bit 5 */
    byte DDR1AD6     :1;                                       /* Port AD Data Direction Bit 6 */
    byte DDR1AD7     :1;                                       /* Port AD Data Direction Bit 7 */
  } Bits;
} DDR1ADSTR;
extern volatile DDR1ADSTR _DDR1AD @(REG_BASE + 0x00000273);
#define DDR1AD                          _DDR1AD.Byte
#define DDR1AD_DDR1AD0                  _DDR1AD.Bits.DDR1AD0
#define DDR1AD_DDR1AD1                  _DDR1AD.Bits.DDR1AD1
#define DDR1AD_DDR1AD2                  _DDR1AD.Bits.DDR1AD2
#define DDR1AD_DDR1AD3                  _DDR1AD.Bits.DDR1AD3
#define DDR1AD_DDR1AD4                  _DDR1AD.Bits.DDR1AD4
#define DDR1AD_DDR1AD5                  _DDR1AD.Bits.DDR1AD5
#define DDR1AD_DDR1AD6                  _DDR1AD.Bits.DDR1AD6
#define DDR1AD_DDR1AD7                  _DDR1AD.Bits.DDR1AD7

#define DDR1AD_DDR1AD0_MASK             1
#define DDR1AD_DDR1AD1_MASK             2
#define DDR1AD_DDR1AD2_MASK             4
#define DDR1AD_DDR1AD3_MASK             8
#define DDR1AD_DDR1AD4_MASK             16
#define DDR1AD_DDR1AD5_MASK             32
#define DDR1AD_DDR1AD6_MASK             64
#define DDR1AD_DDR1AD7_MASK             128


/*** RDR0AD - Port AD Reduced Drive Register 0; 0x00000274 ***/
typedef union {
  byte Byte;
  struct {
    byte RDR0AD08    :1;                                       /* Port AD Reduced Drive Bit 8 */
    byte RDR0AD09    :1;                                       /* Port AD Reduced Drive Bit 9 */
    byte RDR0AD010   :1;                                       /* Port AD Reduced Drive Bit 10 */
    byte RDR0AD011   :1;                                       /* Port AD Reduced Drive Bit 11 */
    byte RDR0AD012   :1;                                       /* Port AD Reduced Drive Bit 12 */
    byte RDR0AD013   :1;                                       /* Port AD Reduced Drive Bit 13 */
    byte RDR0AD014   :1;                                       /* Port AD Reduced Drive Bit 14 */
    byte RDR0AD015   :1;                                       /* Port AD Reduced Drive Bit 15 */
  } Bits;
} RDR0ADSTR;
extern volatile RDR0ADSTR _RDR0AD @(REG_BASE + 0x00000274);
#define RDR0AD                          _RDR0AD.Byte
#define RDR0AD_RDR0AD08                 _RDR0AD.Bits.RDR0AD08
#define RDR0AD_RDR0AD09                 _RDR0AD.Bits.RDR0AD09
#define RDR0AD_RDR0AD010                _RDR0AD.Bits.RDR0AD010
#define RDR0AD_RDR0AD011                _RDR0AD.Bits.RDR0AD011
#define RDR0AD_RDR0AD012                _RDR0AD.Bits.RDR0AD012
#define RDR0AD_RDR0AD013                _RDR0AD.Bits.RDR0AD013
#define RDR0AD_RDR0AD014                _RDR0AD.Bits.RDR0AD014
#define RDR0AD_RDR0AD015                _RDR0AD.Bits.RDR0AD015

#define RDR0AD_RDR0AD08_MASK            1
#define RDR0AD_RDR0AD09_MASK            2
#define RDR0AD_RDR0AD010_MASK           4
#define RDR0AD_RDR0AD011_MASK           8
#define RDR0AD_RDR0AD012_MASK           16
#define RDR0AD_RDR0AD013_MASK           32
#define RDR0AD_RDR0AD014_MASK           64
#define RDR0AD_RDR0AD015_MASK           128


/*** RDR1AD - Port AD Reduced Drive Register 1; 0x00000275 ***/
typedef union {
  byte Byte;
  struct {
    byte RDR1AD0     :1;                                       /* Port AD Reduced Drive Bit 0 */
    byte RDR1AD1     :1;                                       /* Port AD Reduced Drive Bit 1 */
    byte RDR1AD2     :1;                                       /* Port AD Reduced Drive Bit 2 */
    byte RDR1AD3     :1;                                       /* Port AD Reduced Drive Bit 3 */
    byte RDR1AD4     :1;                                       /* Port AD Reduced Drive Bit 4 */
    byte RDR1AD5     :1;                                       /* Port AD Reduced Drive Bit 5 */
    byte RDR1AD6     :1;                                       /* Port AD Reduced Drive Bit 6 */
    byte RDR1AD7     :1;                                       /* Port AD Reduced Drive Bit 7 */
  } Bits;
} RDR1ADSTR;
extern volatile RDR1ADSTR _RDR1AD @(REG_BASE + 0x00000275);
#define RDR1AD                          _RDR1AD.Byte
#define RDR1AD_RDR1AD0                  _RDR1AD.Bits.RDR1AD0
#define RDR1AD_RDR1AD1                  _RDR1AD.Bits.RDR1AD1
#define RDR1AD_RDR1AD2                  _RDR1AD.Bits.RDR1AD2
#define RDR1AD_RDR1AD3                  _RDR1AD.Bits.RDR1AD3
#define RDR1AD_RDR1AD4                  _RDR1AD.Bits.RDR1AD4
#define RDR1AD_RDR1AD5                  _RDR1AD.Bits.RDR1AD5
#define RDR1AD_RDR1AD6                  _RDR1AD.Bits.RDR1AD6
#define RDR1AD_RDR1AD7                  _RDR1AD.Bits.RDR1AD7

#define RDR1AD_RDR1AD0_MASK             1
#define RDR1AD_RDR1AD1_MASK             2
#define RDR1AD_RDR1AD2_MASK             4
#define RDR1AD_RDR1AD3_MASK             8
#define RDR1AD_RDR1AD4_MASK             16
#define RDR1AD_RDR1AD5_MASK             32
#define RDR1AD_RDR1AD6_MASK             64
#define RDR1AD_RDR1AD7_MASK             128


/*** PER0AD - Port AD Pull Up Enable Register 0; 0x00000276 ***/
typedef union {
  byte Byte;
  struct {
    byte PER0AD08    :1;                                       /* Port AD Pull Up Enable Bit 8 */
    byte PER0AD09    :1;                                       /* Port AD Pull Up Enable Bit 9 */
    byte PER0AD010   :1;                                       /* Port AD Pull Up Enable Bit 10 */
    byte PER0AD011   :1;                                       /* Port AD Pull Up Enable Bit 11 */
    byte PER0AD012   :1;                                       /* Port AD Pull Up Enable Bit 12 */
    byte PER0AD013   :1;                                       /* Port AD Pull Up Enable Bit 13 */
    byte PER0AD014   :1;                                       /* Port AD Pull Up Enable Bit 14 */
    byte PER0AD015   :1;                                       /* Port AD Pull Up Enable Bit 15 */
  } Bits;
} PER0ADSTR;
extern volatile PER0ADSTR _PER0AD @(REG_BASE + 0x00000276);
#define PER0AD                          _PER0AD.Byte
#define PER0AD_PER0AD08                 _PER0AD.Bits.PER0AD08
#define PER0AD_PER0AD09                 _PER0AD.Bits.PER0AD09
#define PER0AD_PER0AD010                _PER0AD.Bits.PER0AD010
#define PER0AD_PER0AD011                _PER0AD.Bits.PER0AD011
#define PER0AD_PER0AD012                _PER0AD.Bits.PER0AD012
#define PER0AD_PER0AD013                _PER0AD.Bits.PER0AD013
#define PER0AD_PER0AD014                _PER0AD.Bits.PER0AD014
#define PER0AD_PER0AD015                _PER0AD.Bits.PER0AD015

#define PER0AD_PER0AD08_MASK            1
#define PER0AD_PER0AD09_MASK            2
#define PER0AD_PER0AD010_MASK           4
#define PER0AD_PER0AD011_MASK           8
#define PER0AD_PER0AD012_MASK           16
#define PER0AD_PER0AD013_MASK           32
#define PER0AD_PER0AD014_MASK           64
#define PER0AD_PER0AD015_MASK           128


/*** PER1AD - Port AD Pull Up Enable Register 1; 0x00000277 ***/
typedef union {
  byte Byte;
  struct {
    byte PER1AD0     :1;                                       /* Port AD Pull Up Enable Bit 0 */
    byte PER1AD1     :1;                                       /* Port AD Pull Up Enable Bit 1 */
    byte PER1AD2     :1;                                       /* Port AD Pull Up Enable Bit 2 */
    byte PER1AD3     :1;                                       /* Port AD Pull Up Enable Bit 3 */
    byte PER1AD4     :1;                                       /* Port AD Pull Up Enable Bit 4 */
    byte PER1AD5     :1;                                       /* Port AD Pull Up Enable Bit 5 */
    byte PER1AD6     :1;                                       /* Port AD Pull Up Enable Bit 6 */
    byte PER1AD7     :1;                                       /* Port AD Pull Up Enable Bit 7 */
  } Bits;
} PER1ADSTR;
extern volatile PER1ADSTR _PER1AD @(REG_BASE + 0x00000277);
#define PER1AD                          _PER1AD.Byte
#define PER1AD_PER1AD0                  _PER1AD.Bits.PER1AD0
#define PER1AD_PER1AD1                  _PER1AD.Bits.PER1AD1
#define PER1AD_PER1AD2                  _PER1AD.Bits.PER1AD2
#define PER1AD_PER1AD3                  _PER1AD.Bits.PER1AD3
#define PER1AD_PER1AD4                  _PER1AD.Bits.PER1AD4
#define PER1AD_PER1AD5                  _PER1AD.Bits.PER1AD5
#define PER1AD_PER1AD6                  _PER1AD.Bits.PER1AD6
#define PER1AD_PER1AD7                  _PER1AD.Bits.PER1AD7

#define PER1AD_PER1AD0_MASK             1
#define PER1AD_PER1AD1_MASK             2
#define PER1AD_PER1AD2_MASK             4
#define PER1AD_PER1AD3_MASK             8
#define PER1AD_PER1AD4_MASK             16
#define PER1AD_PER1AD5_MASK             32
#define PER1AD_PER1AD6_MASK             64
#define PER1AD_PER1AD7_MASK             128


#endif /*S12XEP512PIM_H */

/*******************************************************************************/
