/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       S12XFR.h
\brief      S12XF512 FlexRay Module definitions 
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\date       March/09/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

#ifndef S12XFR_H        /*prevent duplicated includes */
#define S12XFR_H


/* This header file needs to be compiled with option "-BfaGapLimitBits-1"  */
/* to force the compiler to use bits from LSB of words rather than LSB of bytes */

#pragma OPTION ADD "-BfaGapLimitBits-1"


/*** MVR - Module Version Register; 0x00000400 ***/
typedef union {
  word Word;
  struct {
    word PEVER       :8;                                       /* PE Version Number */
    word CHIVER      :8;                                       /* CHI Version Number */
  } Bits;
} MVRSTR;
extern volatile MVRSTR _MVR @(REG_BASE + 0x00000400);
#define MVR                             _MVR.Word
#define MVR_PEVER                       _MVR.Bits.PEVER
#define MVR_CHIVER                      _MVR.Bits.CHIVER

#define MVR_PEVER_MASK                  255
#define MVR_PEVER_BITNUM                0
#define MVR_CHIVER_MASK                 65280
#define MVR_CHIVER_BITNUM               8


/*** MCR - Module Configuration Register; 0x00000402 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word PRESCALE    :3;                                       /* Protocol Engine Clock Prescaler */
    word CLKSELbit   :1;                                       /* Protocol Engine Clock Source Select */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word SFFE        :1;                                       /* Synchronization Frame Filter Enable */
    word CHA         :1;                                       /* Channel Enable */
    word CHB         :1;                                       /* Channel Enable */
    word SCM         :1;                                       /* Single Channel Device Mode */
    word             :1; 
    word MEN         :1;                                       /* Module Enable */
  } Bits;
  struct {
    word         :1;
    word         :3;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word         :1;
    word grpCHx  :2;
    word         :1;
    word         :1;
    word         :1;
  } MergedBits;
} MCRSTR;
extern volatile MCRSTR _MCR @(REG_BASE + 0x00000402);
#define MCR                             _MCR.Word
#define MCR_PRESCALE                    _MCR.Bits.PRESCALE
#define MCR_CLKSELbit                   _MCR.Bits.CLKSELbit
#define MCR_SFFE                        _MCR.Bits.SFFE
#define MCR_CHA                         _MCR.Bits.CHA
#define MCR_CHB                         _MCR.Bits.CHB
#define MCR_SCM                         _MCR.Bits.SCM
#define MCR_MEN                         _MCR.Bits.MEN
#define MCR_CHx                         _MCR.MergedBits.grpCHx

#define MCR_PRESCALE_MASK               14
#define MCR_PRESCALE_BITNUM             1
#define MCR_CLKSELbit_MASK              16
#define MCR_SFFE_MASK                   1024
#define MCR_CHA_MASK                    2048
#define MCR_CHB_MASK                    4096
#define MCR_SCM_MASK                    8192
#define MCR_MEN_MASK                    32768
#define MCR_CHx_MASK                    6144
#define MCR_CHx_BITNUM                  11


/*** SYMBADR - System Memory Base Address Register; 0x00000404 ***/
typedef union {
  dword Dword;
   /* Overlapped registers: */
  struct {
    /*** SYMBADHR - System Memory Base Address High Register; 0x00000404 ***/
    union {
      word Word;
      struct {
        word SYS_MEM_BASE_ADDR16 :1;                               /* System Memory Base Address Bit 16 */
        word SYS_MEM_BASE_ADDR17 :1;                               /* System Memory Base Address Bit 17 */
        word SYS_MEM_BASE_ADDR18 :1;                               /* System Memory Base Address Bit 18 */
        word SYS_MEM_BASE_ADDR19 :1;                               /* System Memory Base Address Bit 19 */
        word SYS_MEM_BASE_ADDR20 :1;                               /* System Memory Base Address Bit 20 */
        word SYS_MEM_BASE_ADDR21 :1;                               /* System Memory Base Address Bit 21 */
        word SYS_MEM_BASE_ADDR22 :1;                               /* System Memory Base Address Bit 22 */
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
      } Bits;
      struct {
        word grpSYS_MEM_BASE_ADDR_16 :7;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word     :1;
      } MergedBits;
    } SYMBADHRSTR;
    #define SYMBADHR                    _SYMBADR.Overlap_STR.SYMBADHRSTR.Word
    #define SYMBADHR_SYS_MEM_BASE_ADDR16 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR16
    #define SYMBADHR_SYS_MEM_BASE_ADDR17 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR17
    #define SYMBADHR_SYS_MEM_BASE_ADDR18 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR18
    #define SYMBADHR_SYS_MEM_BASE_ADDR19 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR19
    #define SYMBADHR_SYS_MEM_BASE_ADDR20 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR20
    #define SYMBADHR_SYS_MEM_BASE_ADDR21 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR21
    #define SYMBADHR_SYS_MEM_BASE_ADDR22 _SYMBADR.Overlap_STR.SYMBADHRSTR.Bits.SYS_MEM_BASE_ADDR22
    
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16 _SYMBADR.Overlap_STR.SYMBADHRSTR.MergedBits.grpSYS_MEM_BASE_ADDR_16
    #define SYMBADHR_SYS_MEM_BASE_ADDR  SYMBADHR_SYS_MEM_BASE_ADDR_16
    
    #define SYMBADHR_SYS_MEM_BASE_ADDR16_MASK 1
    #define SYMBADHR_SYS_MEM_BASE_ADDR17_MASK 2
    #define SYMBADHR_SYS_MEM_BASE_ADDR18_MASK 4
    #define SYMBADHR_SYS_MEM_BASE_ADDR19_MASK 8
    #define SYMBADHR_SYS_MEM_BASE_ADDR20_MASK 16
    #define SYMBADHR_SYS_MEM_BASE_ADDR21_MASK 32
    #define SYMBADHR_SYS_MEM_BASE_ADDR22_MASK 64
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16_MASK 127
    #define SYMBADHR_SYS_MEM_BASE_ADDR_16_BITNUM 0


    /*** SYMBADLR - System Memory Base Address Low Register; 0x00000406 ***/
    union {
      word Word;
      struct {
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word SYS_MEM_BASE_ADDR4 :1;                                /* System Memory Base Address Bit 4 */
        word SYS_MEM_BASE_ADDR5 :1;                                /* System Memory Base Address Bit 5 */
        word SYS_MEM_BASE_ADDR6 :1;                                /* System Memory Base Address Bit 6 */
        word SYS_MEM_BASE_ADDR7 :1;                                /* System Memory Base Address Bit 7 */
        word SYS_MEM_BASE_ADDR8 :1;                                /* System Memory Base Address Bit 8 */
        word SYS_MEM_BASE_ADDR9 :1;                                /* System Memory Base Address Bit 9 */
        word SYS_MEM_BASE_ADDR10 :1;                               /* System Memory Base Address Bit 10 */
        word SYS_MEM_BASE_ADDR11 :1;                               /* System Memory Base Address Bit 11 */
        word SYS_MEM_BASE_ADDR12 :1;                               /* System Memory Base Address Bit 12 */
        word SYS_MEM_BASE_ADDR13 :1;                               /* System Memory Base Address Bit 13 */
        word SYS_MEM_BASE_ADDR14 :1;                               /* System Memory Base Address Bit 14 */
        word SYS_MEM_BASE_ADDR15 :1;                               /* System Memory Base Address Bit 15 */
      } Bits;
      struct {
        word     :1;
        word     :1;
        word     :1;
        word     :1;
        word grpSYS_MEM_BASE_ADDR_4 :12;
      } MergedBits;
    } SYMBADLRSTR;
    #define SYMBADLR                    _SYMBADR.Overlap_STR.SYMBADLRSTR.Word
    #define SYMBADLR_SYS_MEM_BASE_ADDR4 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR4
    #define SYMBADLR_SYS_MEM_BASE_ADDR5 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR5
    #define SYMBADLR_SYS_MEM_BASE_ADDR6 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR6
    #define SYMBADLR_SYS_MEM_BASE_ADDR7 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR7
    #define SYMBADLR_SYS_MEM_BASE_ADDR8 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR8
    #define SYMBADLR_SYS_MEM_BASE_ADDR9 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR9
    #define SYMBADLR_SYS_MEM_BASE_ADDR10 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR10
    #define SYMBADLR_SYS_MEM_BASE_ADDR11 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR11
    #define SYMBADLR_SYS_MEM_BASE_ADDR12 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR12
    #define SYMBADLR_SYS_MEM_BASE_ADDR13 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR13
    #define SYMBADLR_SYS_MEM_BASE_ADDR14 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR14
    #define SYMBADLR_SYS_MEM_BASE_ADDR15 _SYMBADR.Overlap_STR.SYMBADLRSTR.Bits.SYS_MEM_BASE_ADDR15
    
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4 _SYMBADR.Overlap_STR.SYMBADLRSTR.MergedBits.grpSYS_MEM_BASE_ADDR_4
    #define SYMBADLR_SYS_MEM_BASE_ADDR  SYMBADLR_SYS_MEM_BASE_ADDR_4
    
    #define SYMBADLR_SYS_MEM_BASE_ADDR4_MASK 16
    #define SYMBADLR_SYS_MEM_BASE_ADDR5_MASK 32
    #define SYMBADLR_SYS_MEM_BASE_ADDR6_MASK 64
    #define SYMBADLR_SYS_MEM_BASE_ADDR7_MASK 128
    #define SYMBADLR_SYS_MEM_BASE_ADDR8_MASK 256
    #define SYMBADLR_SYS_MEM_BASE_ADDR9_MASK 512
    #define SYMBADLR_SYS_MEM_BASE_ADDR10_MASK 1024
    #define SYMBADLR_SYS_MEM_BASE_ADDR11_MASK 2048
    #define SYMBADLR_SYS_MEM_BASE_ADDR12_MASK 4096
    #define SYMBADLR_SYS_MEM_BASE_ADDR13_MASK 8192
    #define SYMBADLR_SYS_MEM_BASE_ADDR14_MASK 16384
    #define SYMBADLR_SYS_MEM_BASE_ADDR15_MASK 32768
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4_MASK 65520
    #define SYMBADLR_SYS_MEM_BASE_ADDR_4_BITNUM 4

  } Overlap_STR;

} SYMBADRSTR;
extern volatile SYMBADRSTR _SYMBADR @(REG_BASE + 0x00000404);
#define SYMBADR                         _SYMBADR.Dword


/*** STBSCR - Strobe Signal Control Register; 0x00000408 ***/
typedef union {
  word Word;
  struct {
    word STBPSEL     :2;  
    word             :2; 
    word ENB         :1;  
    word             :3; 
    word STBSSEL     :7;
    word WMD         :1;  
  } Bits;
} STBSCRSTR;
extern volatile STBSCRSTR _STBSCR @(REG_BASE + 0x00000408);
#define STBSCR                      _STBSCR.Word
#define STBSCR_STBPSEL              _STBSCR.Bits.STBPSEL
#define STBSCR_ENB                  _STBSCR.Bits.ENB
#define STBSCR_STBSSEL              _STBSCR.Bits.STBSSEL
#define STBSCR_WMD                  _STBSCR.Bits.WMD

#define STBSCR_STBPSEL_MASK   0x0003    
#define STBSCR_ENB_MASK       0x0010
#define STBSCR_STBSSEL_MASK   0x7F00
#define STBSCR_WMD_MASK       0x8000


/*** STBPCR - Strobe Port Control Register; 0x0000040A ***/
typedef union {
  word Word;
  struct {
    word STB0EN      :1;                                       /* Strobe Port STB0 Enable */
    word STB1EN      :1;                                       /* Strobe Port STB1 Enable */
    word STB2EN      :1;                                       /* Strobe Port STB2 Enable */
    word STB3EN      :1;                                       /* Strobe Port STB3 Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} STBPCRSTR;
extern volatile STBPCRSTR _STBPCR @(REG_BASE + 0x0000040A);
#define STBPCR                          _STBPCR.Word
#define STBPCR_STB0EN                   _STBPCR.Bits.STB0EN
#define STBPCR_STB1EN                   _STBPCR.Bits.STB1EN
#define STBPCR_STB2EN                   _STBPCR.Bits.STB2EN
#define STBPCR_STB3EN                   _STBPCR.Bits.STB3EN

#define STBPCR_STB0EN_MASK              1
#define STBPCR_STB1EN_MASK              2
#define STBPCR_STB2EN_MASK              4
#define STBPCR_STB3EN_MASK              8


/*** MBDSR - Message Buffer Data Size Register; 0x0000040C ***/
typedef union {
  word Word;
  struct {
    word MBSEG1DS    :7;                                       /* Message Buffer Segment 1 Data Size */
    word             :1; 
    word MBSEG2DS    :7;                                       /* Message Buffer Segment 2 Data Size */
    word             :1; 
  } Bits;
} MBDSRSTR;
extern volatile MBDSRSTR _MBDSR @(REG_BASE + 0x0000040C);
#define MBDSR                           _MBDSR.Word
#define MBDSR_MBSEG1DS                  _MBDSR.Bits.MBSEG1DS
#define MBDSR_MBSEG2DS                  _MBDSR.Bits.MBSEG2DS

#define MBDSR_MBSEG1DS_MASK             127
#define MBDSR_MBSEG1DS_BITNUM           0
#define MBDSR_MBSEG2DS_MASK             32512
#define MBDSR_MBSEG2DS_BITNUM           8


/*** MBSSUTR - Message Buffer Segment Size and Utilization Register; 0x0000040E ***/
typedef union {
  word Word;
  struct {
    word LAST_MB_UTIL :5;                                      /* Last Message Buffer Utilized */
    word             :1; 
    word             :1; 
    word             :1; 
    word LAST_MB_SEG1 :5;                                      /* Last Message Buffer In Segment 1 */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBSSUTRSTR;
extern volatile MBSSUTRSTR _MBSSUTR @(REG_BASE + 0x0000040E);
#define MBSSUTR                         _MBSSUTR.Word
#define MBSSUTR_LAST_MB_UTIL            _MBSSUTR.Bits.LAST_MB_UTIL
#define MBSSUTR_LAST_MB_SEG1            _MBSSUTR.Bits.LAST_MB_SEG1

#define MBSSUTR_LAST_MB_UTIL_MASK       31
#define MBSSUTR_LAST_MB_UTIL_BITNUM     0
#define MBSSUTR_LAST_MB_SEG1_MASK       7936
#define MBSSUTR_LAST_MB_SEG1_BITNUM     8


/*
typedef union uPADR
  {
  tU16  word;
  struct
    {
      tU16 drd    :1;     // debug read done 
      tU16 peaddr :15;    // PE word address 
    }bit;
  }tPADR;

#define DRD       0x0001    //bit masks 
#define PEADDR    0xFFFE
*/


/*** POCR - Protocol Operation Control Register; 0x00000414 ***/
typedef union {
  word Word;
  struct {
    word POCCMD      :4;                                       /* Protocol Command */
    word             :1; 
    word             :1; 
    word             :1; 
    word BSY_WMC     :1;                                       /* Protocol Command Write Busy, Write Mode Command */
    word ERC_AP      :2;                                       /* External Rate Correction Application */
    word EOC_AP      :2;                                       /* External Offset Correction Application */
    word             :1; 
    word             :1; 
    word             :1; 
    word WME         :1;                                       /* Write Mode External Correction */
  } Bits;
} POCRSTR;
extern volatile POCRSTR _POCR @(REG_BASE + 0x00000414);
#define POCR                            _POCR.Word
#define POCR_POCCMD                     _POCR.Bits.POCCMD
#define POCR_BSY_WMC                    _POCR.Bits.BSY_WMC
#define POCR_ERC_AP                     _POCR.Bits.ERC_AP
#define POCR_EOC_AP                     _POCR.Bits.EOC_AP
#define POCR_WME                        _POCR.Bits.WME

#define POCR_POCCMD_MASK                15
#define POCR_POCCMD_BITNUM              0
#define POCR_BSY_WMC_MASK               128
#define POCR_ERC_AP_MASK                768
#define POCR_ERC_AP_BITNUM              8
#define POCR_EOC_AP_MASK                3072
#define POCR_EOC_AP_BITNUM              10
#define POCR_WME_MASK                   32768


/*** GIFER - Global Interrupt Flag and Enable Register; 0x00000416 ***/
typedef union {
  word Word;
  struct {
    word TBIE        :1;                                       /* Transmit Interrupt Enable */
    word RBIE        :1;                                       /* Receive Buffer Interrupt Enable */
    word FNEAIE      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Enable */
    word FNEBIE      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Enable */
    word WUPIE       :1;                                       /* Wakeup Interrupt Enable */
    word CHIE        :1;                                       /* CHI Interrupt Enable */
    word PRIE        :1;                                       /* Protocol Interrupt Enable */
    word MIE         :1;                                       /* Module Interrupt Enable */
    word TBIF        :1;                                       /* Transmit Buffer Interrupt Flag */
    word RBIF        :1;                                       /* Receive Message Buffer Interrupt Flag */
    word FNEAIF      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Flag */
    word FNEBIF      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Flag */
    word WUPIF       :1;                                       /* Wakeup Interrupt Flag */
    word CHIF        :1;                                       /* CHI Interrupt Flag */
    word PRIF        :1;                                       /* Protocol Interrupt Flag */
    word MIF         :1;                                       /* Module Interrupt Flag */
  } Bits;
} GIFERSTR;
extern volatile GIFERSTR _GIFER @(REG_BASE + 0x00000416);
#define GIFER                           _GIFER.Word
#define GIFER_TBIE                      _GIFER.Bits.TBIE
#define GIFER_RBIE                      _GIFER.Bits.RBIE
#define GIFER_FNEAIE                    _GIFER.Bits.FNEAIE
#define GIFER_FNEBIE                    _GIFER.Bits.FNEBIE
#define GIFER_WUPIE                     _GIFER.Bits.WUPIE
#define GIFER_CHIE                      _GIFER.Bits.CHIE
#define GIFER_PRIE                      _GIFER.Bits.PRIE
#define GIFER_MIE                       _GIFER.Bits.MIE
#define GIFER_TBIF                      _GIFER.Bits.TBIF
#define GIFER_RBIF                      _GIFER.Bits.RBIF
#define GIFER_FNEAIF                    _GIFER.Bits.FNEAIF
#define GIFER_FNEBIF                    _GIFER.Bits.FNEBIF
#define GIFER_WUPIF                     _GIFER.Bits.WUPIF
#define GIFER_CHIF                      _GIFER.Bits.CHIF
#define GIFER_PRIF                      _GIFER.Bits.PRIF
#define GIFER_MIF                       _GIFER.Bits.MIF

#define GIFER_TBIE_MASK                 1
#define GIFER_RBIE_MASK                 2
#define GIFER_FNEAIE_MASK               4
#define GIFER_FNEBIE_MASK               8
#define GIFER_WUPIE_MASK                16
#define GIFER_CHIE_MASK                 32
#define GIFER_PRIE_MASK                 64
#define GIFER_MIE_MASK                  128
#define GIFER_TBIF_MASK                 256
#define GIFER_RBIF_MASK                 512
#define GIFER_FNEAIF_MASK               1024
#define GIFER_FNEBIF_MASK               2048
#define GIFER_WUPIF_MASK                4096
#define GIFER_CHIF_MASK                 8192
#define GIFER_PRIF_MASK                 16384
#define GIFER_MIF_MASK                  32768


/*** PIFR0 - Protocol Interrupt Flag Register 0; 0x00000418 ***/
typedef union {
  word Word;
  struct {
    word CYS_IF      :1;                                       /* Cycle Start Interrupt Flag */
    word TI1_IF      :1;                                       /* Timer 1 Expired Interrupt Flag */
    word TI2_IF      :1;                                       /* Timer 2 Expired Interrupt Flag */
    word TBVA_IF     :1;                                       /* Transmission across boundary on channel A Interrupt Flag */
    word TBVB_IF     :1;                                       /* Transmission across boundary on channel B Interrupt Flag */
    word LTXA_IF     :1;                                       /* pdLatestTx Violation on Channel A Interrupt Flag */
    word LTXB_IF     :1;                                       /* pdLatestTx Violation on Channel B Interrupt Flag */
    word MTX_IF      :1;                                       /* Media Access Test Symbol Received Interrupt Flag */
    word MXS_IF      :1;                                       /* Max Sync Frames Detected Interrupt Flag */
    word CCL_IF      :1;                                       /* Clock Correction Limit Reached Interrupt Flag */
    word MOC_IF      :1;                                       /* Missing Offset Correction Interrupt Flag */
    word MRC_IF      :1;                                       /* Missing Rate Correction Interrupt Flag */
    word CSA_IF      :1;                                       /* Cold Start Abort Interrupt Flag */
    word ILCF_IF     :1;                                       /* Illegal Protocol Configuration Interrupt Flag */
    word INTL_IF     :1;                                       /* Internal Protocol Error Interrupt Flag */
    word FATL_IF     :1;                                       /* Fatal Protocol Error Interrupt Flag */
  } Bits;
} PIFR0STR;
extern volatile PIFR0STR _PIFR0 @(REG_BASE + 0x00000418);
#define PIFR0                           _PIFR0.Word
#define PIFR0_CYS_IF                    _PIFR0.Bits.CYS_IF
#define PIFR0_TI1_IF                    _PIFR0.Bits.TI1_IF
#define PIFR0_TI2_IF                    _PIFR0.Bits.TI2_IF
#define PIFR0_TBVA_IF                   _PIFR0.Bits.TBVA_IF
#define PIFR0_TBVB_IF                   _PIFR0.Bits.TBVB_IF
#define PIFR0_LTXA_IF                   _PIFR0.Bits.LTXA_IF
#define PIFR0_LTXB_IF                   _PIFR0.Bits.LTXB_IF
#define PIFR0_MTX_IF                    _PIFR0.Bits.MTX_IF
#define PIFR0_MXS_IF                    _PIFR0.Bits.MXS_IF
#define PIFR0_CCL_IF                    _PIFR0.Bits.CCL_IF
#define PIFR0_MOC_IF                    _PIFR0.Bits.MOC_IF
#define PIFR0_MRC_IF                    _PIFR0.Bits.MRC_IF
#define PIFR0_CSA_IF                    _PIFR0.Bits.CSA_IF
#define PIFR0_ILCF_IF                   _PIFR0.Bits.ILCF_IF
#define PIFR0_INTL_IF                   _PIFR0.Bits.INTL_IF
#define PIFR0_FATL_IF                   _PIFR0.Bits.FATL_IF

#define PIFR0_CYS_IF_MASK               1
#define PIFR0_TI1_IF_MASK               2
#define PIFR0_TI2_IF_MASK               4
#define PIFR0_TBVA_IF_MASK              8
#define PIFR0_TBVB_IF_MASK              16
#define PIFR0_LTXA_IF_MASK              32
#define PIFR0_LTXB_IF_MASK              64
#define PIFR0_MTX_IF_MASK               128
#define PIFR0_MXS_IF_MASK               256
#define PIFR0_CCL_IF_MASK               512
#define PIFR0_MOC_IF_MASK               1024
#define PIFR0_MRC_IF_MASK               2048
#define PIFR0_CSA_IF_MASK               4096
#define PIFR0_ILCF_IF_MASK              8192
#define PIFR0_INTL_IF_MASK              16384
#define PIFR0_FATL_IF_MASK              32768


/*** PIER0 - Protocol Interrupt Enable Register 0; 0x0000041A ***/
typedef union {
  word Word;
  union { /*Several registers at the same address */
    /*** PIER0 - Protocol Interrupt Enable Register 0; Several registers at the same address ***/
    union {
      struct {
        word CYS_EN      :1;                                       /* Cycle Start Interrupt Enable */
        word TI1_EN      :1;                                       /* Timer 1 Expired Interrupt Enable */
        word TI2_EN      :1;                                       /* Timer 2 Expired Interrupt Enable */
        word TBVA_EN     :1;                                       /* Transmission across boundary on channel A Interrupt Enable */
        word TBVB_EN     :1;                                       /* Transmission across boundary on channel B Interrupt Enable */
        word LTXA_EN     :1;                                       /* pdLatestTx Violation on Channel A Interrupt Enable */
        word LTXB_EN     :1;                                       /* pdLatestTx Violation on Channel B Interrupt Enable */
        word MTX_EN      :1;                                       /* Media Access Test Symbol Received Interrupt Enable */
        word MXS_EN      :1;                                       /* Max Sync Frames Detected Interrupt Enable */
        word CCL_EN      :1;                                       /* Clock Correction Limit Reached Interrupt Enable */
        word MOC_EN      :1;                                       /* Missing Offset Correction Interrupt Enable */
        word MRC_EN      :1;                                       /* Missing Rate Correction Interrupt Enable */
        word CSA_EN      :1;                                       /* Cold Start Abort Interrupt Enable */
        word ILCF_EN     :1;                                       /* Illegal Protocol Configuration Interrupt Enable */
        word INTL_EN     :1;                                       /* Internal Protocol Error Interrupt Enable */
        word FATL_EN     :1;                                       /* Fatal Protocol Error Interrupt Enable */
      } Bits;
    } PIER0STR;
    #define PIER0                       _PIER0.Word
    #define PIER0_CYS_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.CYS_EN
    #define PIER0_TI1_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.TI1_EN
    #define PIER0_TI2_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.TI2_EN
    #define PIER0_TBVA_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.TBVA_EN
    #define PIER0_TBVB_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.TBVB_EN
    #define PIER0_LTXA_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.LTXA_EN
    #define PIER0_LTXB_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.LTXB_EN
    #define PIER0_MTX_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.MTX_EN
    #define PIER0_MXS_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.MXS_EN
    #define PIER0_CCL_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.CCL_EN
    #define PIER0_MOC_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.MOC_EN
    #define PIER0_MRC_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.MRC_EN
    #define PIER0_CSA_EN                _PIER0.SameAddr_STR.PIER0STR.Bits.CSA_EN
    #define PIER0_ILCF_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.ILCF_EN
    #define PIER0_INTL_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.INTL_EN
    #define PIER0_FATL_EN               _PIER0.SameAddr_STR.PIER0STR.Bits.FATL_EN
    
    
    #define PIER0_CYS_EN_MASK           1
    #define PIER0_TI1_EN_MASK           2
    #define PIER0_TI2_EN_MASK           4
    #define PIER0_TBVA_EN_MASK          8
    #define PIER0_TBVB_EN_MASK          16
    #define PIER0_LTXA_EN_MASK          32
    #define PIER0_LTXB_EN_MASK          64
    #define PIER0_MTX_EN_MASK           128
    #define PIER0_MXS_EN_MASK           256
    #define PIER0_CCL_EN_MASK           512
    #define PIER0_MOC_EN_MASK           1024
    #define PIER0_MRC_EN_MASK           2048
    #define PIER0_CSA_EN_MASK           4096
    #define PIER0_ILCF_EN_MASK          8192
    #define PIER0_INTL_EN_MASK          16384
    #define PIER0_FATL_EN_MASK          32768

    /*** PIFR1 - Protocol Interrupt Flag Register 1; Several registers at the same address ***/
    union {
      struct {
        word             :1; 
        word             :1; 
        word             :1; 
        word             :1; 
        word ODT_IF      :1;                                       /* Odd Cycle Table Written Interrupt Flag */
        word EVT_IF      :1;                                       /* Even Cycle Table Written Interrupt Flag */
        word             :1; 
        word             :1; 
        word SSI0_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 0 */
        word SSI1_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 1 */
        word SSI2_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 2 */
        word SSI3_IF     :1;                                       /* Slot Status Counter Incremented Interrupt Flag Bit 3 */
        word PSC_IF      :1;                                       /* Protocol State Changed Interrupt Flag */
        word PECF_IF     :1;                                       /* Protocol Engine Communication Failure Interrupt Flag */
        word IPC_IF      :1;                                       /* Illegal Protocol Command Interrupt Flag */
        word EMC_IF      :1;                                       /* Error Mode Changed Interrupt Flag */
      } Bits;
    } PIFR1STR;
    #define PIFR1                       _PIER0.Word
    #define PIFR1_ODT_IF                _PIER0.SameAddr_STR.PIFR1STR.Bits.ODT_IF
    #define PIFR1_EVT_IF                _PIER0.SameAddr_STR.PIFR1STR.Bits.EVT_IF
    #define PIFR1_SSI0_IF               _PIER0.SameAddr_STR.PIFR1STR.Bits.SSI0_IF
    #define PIFR1_SSI1_IF               _PIER0.SameAddr_STR.PIFR1STR.Bits.SSI1_IF
    #define PIFR1_SSI2_IF               _PIER0.SameAddr_STR.PIFR1STR.Bits.SSI2_IF
    #define PIFR1_SSI3_IF               _PIER0.SameAddr_STR.PIFR1STR.Bits.SSI3_IF
    #define PIFR1_PSC_IF                _PIER0.SameAddr_STR.PIFR1STR.Bits.PSC_IF
    #define PIFR1_PECF_IF               _PIER0.SameAddr_STR.PIFR1STR.Bits.PECF_IF
    #define PIFR1_IPC_IF                _PIER0.SameAddr_STR.PIFR1STR.Bits.IPC_IF
    #define PIFR1_EMC_IF                _PIER0.SameAddr_STR.PIFR1STR.Bits.EMC_IF
    
    
    #define PIFR1_ODT_IF_MASK           16
    #define PIFR1_EVT_IF_MASK           32
    #define PIFR1_SSI0_IF_MASK          256
    #define PIFR1_SSI1_IF_MASK          512
    #define PIFR1_SSI2_IF_MASK          1024
    #define PIFR1_SSI3_IF_MASK          2048
    #define PIFR1_PSC_IF_MASK           4096
    #define PIFR1_PECF_IF_MASK          8192
    #define PIFR1_IPC_IF_MASK           16384
    #define PIFR1_EMC_IF_MASK           32768

  } SameAddr_STR; /*Several registers at the same address */

} PIER0STR;
extern volatile PIER0STR _PIER0 @(REG_BASE + 0x0000041A);



/*** PIER1 - Protocol Interrupt Enable Register 1; 0x0000041C ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word ODT_EN      :1;                                       /* Odd Cycle Table Written Interrupt Enable */
    word EVT_EN      :1;                                       /* Even Cycle Table Written Interrupt Enable */
    word             :1; 
    word             :1; 
    word SSI0_EN     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 0 */
    word SSI1_EN     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 1 */
    word SSI2_EN     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 2 */
    word SSI3_EN     :1;                                       /* Slot Status Counter Incremented Interrupt Enable Bit 3 */
    word PSC_EN      :1;                                       /* Protocol State Changed Interrupt Enable */
    word PECF_EN     :1;                                       /* Protocol Engine Communication Failure Interrupt Enable */
    word IPC_EN      :1;                                       /* Illegal Protocol Command Interrupt Enable */
    word EMC_EN      :1;                                       /* Error Mode Changed Interrupt Enable */
  } Bits;
} PIER1STR;
extern volatile PIER1STR _PIER1 @(REG_BASE + 0x0000041C);
#define PIER1                           _PIER1.Word
#define PIER1_ODT_EN                    _PIER1.Bits.ODT_EN
#define PIER1_EVT_EN                    _PIER1.Bits.EVT_EN
#define PIER1_SSI0_EN                   _PIER1.Bits.SSI0_EN
#define PIER1_SSI1_EN                   _PIER1.Bits.SSI1_EN
#define PIER1_SSI2_EN                   _PIER1.Bits.SSI2_EN
#define PIER1_SSI3_EN                   _PIER1.Bits.SSI3_EN
#define PIER1_PSC_EN                    _PIER1.Bits.PSC_EN
#define PIER1_PECF_EN                   _PIER1.Bits.PECF_EN
#define PIER1_IPC_EN                    _PIER1.Bits.IPC_EN
#define PIER1_EMC_EN                    _PIER1.Bits.EMC_EN

#define PIER1_ODT_EN_MASK               16
#define PIER1_EVT_EN_MASK               32
#define PIER1_SSI0_EN_MASK              256
#define PIER1_SSI1_EN_MASK              512
#define PIER1_SSI2_EN_MASK              1024
#define PIER1_SSI3_EN_MASK              2048
#define PIER1_PSC_EN_MASK               4096
#define PIER1_PECF_EN_MASK              8192
#define PIER1_IPC_EN_MASK               16384
#define PIER1_EMC_EN_MASK               32768


/*** CHIERFR - CHI Error Flag Register; 0x00000420 ***/
typedef union {
  word Word;
  struct {
    word ILSA_EF     :1;                                       /* Illegal System Memory Access Error Flag */
    word NMF_EF      :1;                                       /* Network Management Frame Error Flag */
    word NML_EF      :1;                                       /* Network Management Length Error Flag */
    word SPL_EF      :1;                                       /* Static Payload Length Error Flag */
    word DPL_EF      :1;                                       /* Dynamic Payload Length Error Flag */
    word FID_EF      :1;                                       /* Frame ID Error Flag */
    word SBCF_EF     :1;                                       /* System Bus Communication Failure Error Flag */
    word DBL_EF      :1;                                       /* Double Transmit Message Buffer Lock Error Flag */
    word LCK_EF      :1;                                       /* Lock Error Flag */
    word MBU_EF      :1;                                       /* Message Buffer Utilization Error Flag */
    word MBS_EF      :1;                                       /* Message Buffer Search Error Flag */
    word FOVA_EF     :1;                                       /* Receive FIFO Overrun Channel A Error Flag */
    word FOVB_EF     :1;                                       /* Receive FIFO Overrun Channel B Error Flag */
    word PCMI_EF     :1;                                       /* Protocol Command Ignored Error Flag */
    word FRLA_EF     :1;                                       /* Frame Lost Channel A Error Flag */
    word FRLB_EF     :1;                                       /* Frame Lost Channel B Error Flag */
  } Bits;
} CHIERFRSTR;
extern volatile CHIERFRSTR _CHIERFR @(REG_BASE + 0x00000420);
#define CHIERFR                         _CHIERFR.Word
#define CHIERFR_ILSA_EF                 _CHIERFR.Bits.ILSA_EF
#define CHIERFR_NMF_EF                  _CHIERFR.Bits.NMF_EF
#define CHIERFR_NML_EF                  _CHIERFR.Bits.NML_EF
#define CHIERFR_SPL_EF                  _CHIERFR.Bits.SPL_EF
#define CHIERFR_DPL_EF                  _CHIERFR.Bits.DPL_EF
#define CHIERFR_FID_EF                  _CHIERFR.Bits.FID_EF
#define CHIERFR_SBCF_EF                 _CHIERFR.Bits.SBCF_EF
#define CHIERFR_DBL_EF                  _CHIERFR.Bits.DBL_EF
#define CHIERFR_LCK_EF                  _CHIERFR.Bits.LCK_EF
#define CHIERFR_MBU_EF                  _CHIERFR.Bits.MBU_EF
#define CHIERFR_MBS_EF                  _CHIERFR.Bits.MBS_EF
#define CHIERFR_FOVA_EF                 _CHIERFR.Bits.FOVA_EF
#define CHIERFR_FOVB_EF                 _CHIERFR.Bits.FOVB_EF
#define CHIERFR_PCMI_EF                 _CHIERFR.Bits.PCMI_EF
#define CHIERFR_FRLA_EF                 _CHIERFR.Bits.FRLA_EF
#define CHIERFR_FRLB_EF                 _CHIERFR.Bits.FRLB_EF

#define CHIERFR_ILSA_EF_MASK            1
#define CHIERFR_NMF_EF_MASK             2
#define CHIERFR_NML_EF_MASK             4
#define CHIERFR_SPL_EF_MASK             8
#define CHIERFR_DPL_EF_MASK             16
#define CHIERFR_FID_EF_MASK             32
#define CHIERFR_SBCF_EF_MASK            64
#define CHIERFR_DBL_EF_MASK             128
#define CHIERFR_LCK_EF_MASK             256
#define CHIERFR_MBU_EF_MASK             512
#define CHIERFR_MBS_EF_MASK             1024
#define CHIERFR_FOVA_EF_MASK            2048
#define CHIERFR_FOVB_EF_MASK            4096
#define CHIERFR_PCMI_EF_MASK            8192
#define CHIERFR_FRLA_EF_MASK            16384
#define CHIERFR_FRLB_EF_MASK            32768


/*** MBIVEC - Message Buffer Interrupt Vector Register; 0x00000422 ***/
typedef union {
  word Word;
  struct {
    word RBIVEC      :5;                                       /* Receive Buffer Interrupt Vector */
    word             :1; 
    word             :1; 
    word             :1; 
    word TBIVEC      :5;                                       /* Transmit Buffer Interrupt Vector */
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIVECSTR;
extern volatile MBIVECSTR _MBIVEC @(REG_BASE + 0x00000422);
#define MBIVEC                          _MBIVEC.Word
#define MBIVEC_RBIVEC                   _MBIVEC.Bits.RBIVEC
#define MBIVEC_TBIVEC                   _MBIVEC.Bits.TBIVEC

#define MBIVEC_RBIVEC_MASK              31
#define MBIVEC_RBIVEC_BITNUM            0
#define MBIVEC_TBIVEC_MASK              7936
#define MBIVEC_TBIVEC_BITNUM            8


/*** CASERCR - Channel A Status Error Counter Register; 0x00000424 ***/
typedef union {
  word Word;
  struct {
    word STATUS_ERR_CNT :16;                                   /* Channel Status Error Counter */
  } Bits;
} CASERCRSTR;
extern volatile CASERCRSTR _CASERCR @(REG_BASE + 0x00000424);
#define CASERCR                         _CASERCR.Word
#define CASERCR_STATUS_ERR_CNT          _CASERCR.Bits.STATUS_ERR_CNT

#define CASERCR_STATUS_ERR_CNT_MASK     65535
#define CASERCR_STATUS_ERR_CNT_BITNUM   0


/*** CBSERCR - Channel B Status Error Counter Register; 0x00000426 ***/
typedef union {
  word Word;
  struct {
    word STATUS_ERR_CNT :16;                                   /* Channel Status Error Counter */
  } Bits;
} CBSERCRSTR;
extern volatile CBSERCRSTR _CBSERCR @(REG_BASE + 0x00000426);
#define CBSERCR                         _CBSERCR.Word
#define CBSERCR_STATUS_ERR_CNT          _CBSERCR.Bits.STATUS_ERR_CNT

#define CBSERCR_STATUS_ERR_CNT_MASK     65535
#define CBSERCR_STATUS_ERR_CNT_BITNUM   0


/*** PSR0 - Protocol Status Register 0; 0x00000428 ***/
typedef union {
  word Word;
  struct {
    word WAKEUPSTATUS :3;                                      /* Wakeup Status */
    word              :1; 
    word STARTUPSTATE :4;                                      /* Startup State */
    word PROTSTATE    :3;                                       /* Protocol State */
    word              :1; 
    word SLOTMODE     :2;                                       /* Slot Mod */
    word ERRMODE      :2;                                       /* Error Mode */
  } Bits;
} PSR0STR;
extern volatile PSR0STR _PSR0 @(REG_BASE + 0x00000428);
#define PSR0                            _PSR0.Word
#define PSR0_WAKEUPSTATUS               _PSR0.Bits.WAKEUPSTATUS
#define PSR0_STARTUPSTATE               _PSR0.Bits.STARTUPSTATE
#define PSR0_PROTSTATE                  _PSR0.Bits.PROTSTATE
#define PSR0_SLOTMODE                   _PSR0.Bits.SLOTMODE
#define PSR0_ERRMODE                    _PSR0.Bits.ERRMODE
/* PSR_ARR: Access 4 PSRx registers in an array */
#define PSR_ARR                         ((word *) &PSR0)

#define PSR0_WAKEUPSTATUS_MASK          7
#define PSR0_WAKEUPSTATUS_BITNUM        0
#define PSR0_STARTUPSTATE_MASK          240
#define PSR0_STARTUPSTATE_BITNUM        4
#define PSR0_PROTSTATE_MASK             1792
#define PSR0_PROTSTATE_BITNUM           8
#define PSR0_SLOTMODE_MASK              12288
#define PSR0_SLOTMODE_BITNUM            12
#define PSR0_ERRMODE_MASK               49152
#define PSR0_ERRMODE_BITNUM             14


/*** PSR1 - Protocol Status Register 1; 0x0000042A ***/
typedef union {
  word Word;
  struct {
    word APTAC       :5;                                       /* Allow Passive to Active Counter */
    word FRZ         :1;                                       /* Freeze Occurred */
    word HHR         :1;                                       /* Host Halt Request Pending */
    word CPN         :1;                                       /* Cold Start Path Noise */
    word REMCSAT     :5;                                       /* Remaining Coldstart Attempts */
    word             :1; 
    word CSP         :1;                                       /* Cold Start Path */
    word CSAA        :1;                                       /* Cold Start Attempt Aborted Flag */
  } Bits;
} PSR1STR;
extern volatile PSR1STR _PSR1 @(REG_BASE + 0x0000042A);
#define PSR1                            _PSR1.Word
#define PSR1_APTAC                      _PSR1.Bits.APTAC
#define PSR1_FRZ                        _PSR1.Bits.FRZ
#define PSR1_HHR                        _PSR1.Bits.HHR
#define PSR1_CPN                        _PSR1.Bits.CPN
#define PSR1_REMCSAT                    _PSR1.Bits.REMCSAT
#define PSR1_CSP                        _PSR1.Bits.CSP
#define PSR1_CSAA                       _PSR1.Bits.CSAA

#define PSR1_APTAC_MASK                 31
#define PSR1_APTAC_BITNUM               0
#define PSR1_FRZ_MASK                   32
#define PSR1_HHR_MASK                   64
#define PSR1_CPN_MASK                   128
#define PSR1_REMCSAT_MASK               7936
#define PSR1_REMCSAT_BITNUM             8
#define PSR1_CSP_MASK                   16384
#define PSR1_CSAA_MASK                  32768


/*** PSR2 - Protocol Status Register 2; 0x0000042C ***/
typedef union {
  word Word;
  struct {
    word CLKCORRFAILCNT :4;                                    /* Clock Correction Failed Counter */
    word MTA         :1;                                       /* Media Access Test Symbol MTS Received on Channel A */
    word SSEA        :1;                                       /* Symbol Window Syntax Error on Channel A */
    word SBVA        :1;                                       /* Symbol Window Boundary Violation on Channel A */
    word STCA        :1;                                       /* Symbol Window Transmit Conflict on Channel A */
    word NSEA        :1;                                       /* NIT Syntax Error on Channel A */
    word NBVA        :1;                                       /* NIT Boundary Violation on Channel A */
    word MTB         :1;                                       /* Media Access Test Symbol MTS Received on Channel B */
    word SSEB        :1;                                       /* Symbol Window Syntax Error on Channel B */
    word SBVB        :1;                                       /* Symbol Window Boundary Violation on Channel */
    word STCB        :1;                                       /* Symbol Window Transmit Conflict on Channel B */
    word NSEB        :1;                                       /* NIT Syntax Error on Channel B */
    word NBVB        :1;                                       /* NIT Boundary Violation on Channel B */
  } Bits;
} PSR2STR;
extern volatile PSR2STR _PSR2 @(REG_BASE + 0x0000042C);
#define PSR2                            _PSR2.Word
#define PSR2_CLKCORRFAILCNT             _PSR2.Bits.CLKCORRFAILCNT
#define PSR2_MTA                        _PSR2.Bits.MTA
#define PSR2_SSEA                       _PSR2.Bits.SSEA
#define PSR2_SBVA                       _PSR2.Bits.SBVA
#define PSR2_STCA                       _PSR2.Bits.STCA
#define PSR2_NSEA                       _PSR2.Bits.NSEA
#define PSR2_NBVA                       _PSR2.Bits.NBVA
#define PSR2_MTB                        _PSR2.Bits.MTB
#define PSR2_SSEB                       _PSR2.Bits.SSEB
#define PSR2_SBVB                       _PSR2.Bits.SBVB
#define PSR2_STCB                       _PSR2.Bits.STCB
#define PSR2_NSEB                       _PSR2.Bits.NSEB
#define PSR2_NBVB                       _PSR2.Bits.NBVB

#define PSR2_CLKCORRFAILCNT_MASK        15
#define PSR2_CLKCORRFAILCNT_BITNUM      0
#define PSR2_MTA_MASK                   16
#define PSR2_SSEA_MASK                  32
#define PSR2_SBVA_MASK                  64
#define PSR2_STCA_MASK                  128
#define PSR2_NSEA_MASK                  256
#define PSR2_NBVA_MASK                  512
#define PSR2_MTB_MASK                   1024
#define PSR2_SSEB_MASK                  2048
#define PSR2_SBVB_MASK                  4096
#define PSR2_STCB_MASK                  8192
#define PSR2_NSEB_MASK                  16384
#define PSR2_NBVB_MASK                  32768


/*** PSR3 - Protocol Status Register 3; 0x0000042E ***/
typedef union {
  word Word;
  struct {
    word AVFA        :1;                                       /* Aggregated Valid Frame on Channel A */
    word ASEA        :1;                                       /* Aggregated Syntax Error on Channel A */
    word ACEA        :1;                                       /* Aggregated Content Error on Channel A */
    word AACA        :1;                                       /* Aggregated Additional Communication on Channel A */
    word ABVA        :1;                                       /* Aggregated Boundary Violation on Channel A */
    word WUA         :1;                                       /* Wakeup Symbol Received on Channel A */
    word             :1; 
    word             :1; 
    word AVFB        :1;                                       /* Aggregated Valid Frame on Channel B */
    word ASEB        :1;                                       /* Aggregated Syntax Error on Channel B */
    word ACEB        :1;                                       /* Aggregated Content Error on Channel B */
    word AACB        :1;                                       /* Aggregated Additional Communication on Channel B */
    word ABVB        :1;                                       /* Aggregated Boundary Violation on Channel B */
    word WUB         :1;                                       /* Wakeup Symbol Received on Channel B */
    word             :1; 
    word             :1; 
  } Bits;
} PSR3STR;
extern volatile PSR3STR _PSR3 @(REG_BASE + 0x0000042E);
#define PSR3                            _PSR3.Word
#define PSR3_AVFA                       _PSR3.Bits.AVFA
#define PSR3_ASEA                       _PSR3.Bits.ASEA
#define PSR3_ACEA                       _PSR3.Bits.ACEA
#define PSR3_AACA                       _PSR3.Bits.AACA
#define PSR3_ABVA                       _PSR3.Bits.ABVA
#define PSR3_WUA                        _PSR3.Bits.WUA
#define PSR3_AVFB                       _PSR3.Bits.AVFB
#define PSR3_ASEB                       _PSR3.Bits.ASEB
#define PSR3_ACEB                       _PSR3.Bits.ACEB
#define PSR3_AACB                       _PSR3.Bits.AACB
#define PSR3_ABVB                       _PSR3.Bits.ABVB
#define PSR3_WUB                        _PSR3.Bits.WUB

#define PSR3_AVFA_MASK                  1
#define PSR3_ASEA_MASK                  2
#define PSR3_ACEA_MASK                  4
#define PSR3_AACA_MASK                  8
#define PSR3_ABVA_MASK                  16
#define PSR3_WUA_MASK                   32
#define PSR3_AVFB_MASK                  256
#define PSR3_ASEB_MASK                  512
#define PSR3_ACEB_MASK                  1024
#define PSR3_AACB_MASK                  2048
#define PSR3_ABVB_MASK                  4096
#define PSR3_WUB_MASK                   8192


/*** MTCTR - Macrotick Counter Register; 0x00000430 ***/
typedef union {
  word Word;
  struct {
    word MTCT        :14;                                      /* Macrotick Counter */
    word             :1; 
    word             :1; 
  } Bits;
} MTCTRSTR;
extern volatile MTCTRSTR _MTCTR @(REG_BASE + 0x00000430);
#define MTCTR                           _MTCTR.Word
#define MTCTR_MTCT                      _MTCTR.Bits.MTCT

#define MTCTR_MTCT_MASK                 16383
#define MTCTR_MTCT_BITNUM               0


/*** CYCTR - Cycle Counter Register; 0x00000432 ***/
typedef union {
  word Word;
  struct {
    word CYCCNT      :6;                                       /* Cycle Counter */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CYCTRSTR;
extern volatile CYCTRSTR _CYCTR @(REG_BASE + 0x00000432);
#define CYCTR                           _CYCTR.Word
#define CYCTR_CYCCNT                    _CYCTR.Bits.CYCCNT

#define CYCTR_CYCCNT_MASK               63
#define CYCTR_CYCCNT_BITNUM             0


/*** SLTCTAR - Slot Counter Channel A Register; 0x00000434 ***/
typedef union {
  word Word;
  struct {
    word SLOTCNTA    :11;                                      /* Slot Counter Value for Channel A */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SLTCTARSTR;
extern volatile SLTCTARSTR _SLTCTAR @(REG_BASE + 0x00000434);
#define SLTCTAR                         _SLTCTAR.Word
#define SLTCTAR_SLOTCNTA                _SLTCTAR.Bits.SLOTCNTA

#define SLTCTAR_SLOTCNTA_MASK           2047
#define SLTCTAR_SLOTCNTA_BITNUM         0


/*** SLTCTBR - Slot Counter Channel B Register; 0x00000436 ***/
typedef union {
  word Word;
  struct {
    word SLOTCNTB    :11;                                      /* Slot Counter Value for Channel B */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SLTCTBRSTR;
extern volatile SLTCTBRSTR _SLTCTBR @(REG_BASE + 0x00000436);
#define SLTCTBR                         _SLTCTBR.Word
#define SLTCTBR_SLOTCNTB                _SLTCTBR.Bits.SLOTCNTB

#define SLTCTBR_SLOTCNTB_MASK           2047
#define SLTCTBR_SLOTCNTB_BITNUM         0


/*** RTCORVR - Rate Correction Value Register; 0x00000438 ***/
typedef union {
  word Word;
  struct {
    word RATECORR    :16;                                      /* Rate Correction Value */
  } Bits;
} RTCORVRSTR;
extern volatile RTCORVRSTR _RTCORVR @(REG_BASE + 0x00000438);
#define RTCORVR                         _RTCORVR.Word
#define RTCORVR_RATECORR                _RTCORVR.Bits.RATECORR

#define RTCORVR_RATECORR_MASK           65535
#define RTCORVR_RATECORR_BITNUM         0


/*** OFCORVR - Offset Correction Value Register; 0x0000043A ***/
typedef union {
  word Word;
  struct {
    word OFFSETCORR  :16;                                      /* Offset Correction Value */
  } Bits;
} OFCORVRSTR;
extern volatile OFCORVRSTR _OFCORVR @(REG_BASE + 0x0000043A);
#define OFCORVR                         _OFCORVR.Word
#define OFCORVR_OFFSETCORR              _OFCORVR.Bits.OFFSETCORR

#define OFCORVR_OFFSETCORR_MASK         65535
#define OFCORVR_OFFSETCORR_BITNUM       0


/*** CIFRR - Combined Interrupt Flag Register; 0x0000043C ***/
typedef union {
  word Word;
  struct {
    word TBIF        :1;                                       /* Transmit Interrupt Flag */
    word RBIF        :1;                                       /* Receive Buffer Interrupt Flag */
    word FNEAIF      :1;                                       /* Receive FIFO channel A Not Empty Interrupt Flag */
    word FNEBIF      :1;                                       /* Receive FIFO channel B Not Empty Interrupt Flag */
    word WUPIF       :1;                                       /* Wakeup Interrupt Flag */
    word CHIF        :1;                                       /* CHI Interrupt Flag */
    word PRIF        :1;                                       /* Protocol Interrupt Flag */
    word MIF         :1;                                       /* Module Interrupt Flag */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} CIFRRSTR;
extern volatile CIFRRSTR _CIFRR @(REG_BASE + 0x0000043C);
#define CIFRR                           _CIFRR.Word
#define CIFRR_TBIF                      _CIFRR.Bits.TBIF
#define CIFRR_RBIF                      _CIFRR.Bits.RBIF
#define CIFRR_FNEAIF                    _CIFRR.Bits.FNEAIF
#define CIFRR_FNEBIF                    _CIFRR.Bits.FNEBIF
#define CIFRR_WUPIF                     _CIFRR.Bits.WUPIF
#define CIFRR_CHIF                      _CIFRR.Bits.CHIF
#define CIFRR_PRIF                      _CIFRR.Bits.PRIF
#define CIFRR_MIF                       _CIFRR.Bits.MIF

#define CIFRR_TBIF_MASK                 1
#define CIFRR_RBIF_MASK                 2
#define CIFRR_FNEAIF_MASK               4
#define CIFRR_FNEBIF_MASK               8
#define CIFRR_WUPIF_MASK                16
#define CIFRR_CHIF_MASK                 32
#define CIFRR_PRIF_MASK                 64
#define CIFRR_MIF_MASK                  128


/*** SFCNTR - Sync Frame Counter Register; 0x00000440 ***/
typedef union {
  word Word;
  struct {
    word SFODA       :4;                                       /* Sync Frames Channel A, odd cycle */
    word SFODB       :4;                                       /* Sync Frames Channel B, odd cycle */
    word SFEVA       :4;                                       /* Sync Frames Channel A, even cycle */
    word SFEVB       :4;                                       /* Sync Frames Channel B, even cycle */
  } Bits;
} SFCNTRSTR;
extern volatile SFCNTRSTR _SFCNTR @(REG_BASE + 0x00000440);
#define SFCNTR                          _SFCNTR.Word
#define SFCNTR_SFODA                    _SFCNTR.Bits.SFODA
#define SFCNTR_SFODB                    _SFCNTR.Bits.SFODB
#define SFCNTR_SFEVA                    _SFCNTR.Bits.SFEVA
#define SFCNTR_SFEVB                    _SFCNTR.Bits.SFEVB

#define SFCNTR_SFODA_MASK               15
#define SFCNTR_SFODA_BITNUM             0
#define SFCNTR_SFODB_MASK               240
#define SFCNTR_SFODB_BITNUM             4
#define SFCNTR_SFEVA_MASK               3840
#define SFCNTR_SFEVA_BITNUM             8
#define SFCNTR_SFEVB_MASK               61440
#define SFCNTR_SFEVB_BITNUM             12


/*** SFTOR - Sync Frame Table Offset Register; 0x00000442 ***/
typedef union {
  word Word;
  struct {
    word             :1; 
    word SFT_OFFSET1 :1;                                       /* Sync Frame Table Offset Bit 1 */
    word SFT_OFFSET2 :1;                                       /* Sync Frame Table Offset Bit 2 */
    word SFT_OFFSET3 :1;                                       /* Sync Frame Table Offset Bit 3 */
    word SFT_OFFSET4 :1;                                       /* Sync Frame Table Offset Bit 4 */
    word SFT_OFFSET5 :1;                                       /* Sync Frame Table Offset Bit 5 */
    word SFT_OFFSET6 :1;                                       /* Sync Frame Table Offset Bit 6 */
    word SFT_OFFSET7 :1;                                       /* Sync Frame Table Offset Bit 7 */
    word SFT_OFFSET8 :1;                                       /* Sync Frame Table Offset Bit 8 */
    word SFT_OFFSET9 :1;                                       /* Sync Frame Table Offset Bit 9 */
    word SFT_OFFSET10 :1;                                      /* Sync Frame Table Offset Bit 10 */
    word SFT_OFFSET11 :1;                                      /* Sync Frame Table Offset Bit 11 */
    word SFT_OFFSET12 :1;                                      /* Sync Frame Table Offset Bit 12 */
    word SFT_OFFSET13 :1;                                      /* Sync Frame Table Offset Bit 13 */
    word SFT_OFFSET14 :1;                                      /* Sync Frame Table Offset Bit 14 */
    word SFT_OFFSET15 :1;                                      /* Sync Frame Table Offset Bit 15 */
  } Bits;
  struct {
    word         :1;
    word grpSFT_OFFSET_1 :15;
  } MergedBits;
} SFTORSTR;
extern volatile SFTORSTR _SFTOR @(REG_BASE + 0x00000442);
#define SFTOR                           _SFTOR.Word
#define SFTOR_SFT_OFFSET1               _SFTOR.Bits.SFT_OFFSET1
#define SFTOR_SFT_OFFSET2               _SFTOR.Bits.SFT_OFFSET2
#define SFTOR_SFT_OFFSET3               _SFTOR.Bits.SFT_OFFSET3
#define SFTOR_SFT_OFFSET4               _SFTOR.Bits.SFT_OFFSET4
#define SFTOR_SFT_OFFSET5               _SFTOR.Bits.SFT_OFFSET5
#define SFTOR_SFT_OFFSET6               _SFTOR.Bits.SFT_OFFSET6
#define SFTOR_SFT_OFFSET7               _SFTOR.Bits.SFT_OFFSET7
#define SFTOR_SFT_OFFSET8               _SFTOR.Bits.SFT_OFFSET8
#define SFTOR_SFT_OFFSET9               _SFTOR.Bits.SFT_OFFSET9
#define SFTOR_SFT_OFFSET10              _SFTOR.Bits.SFT_OFFSET10
#define SFTOR_SFT_OFFSET11              _SFTOR.Bits.SFT_OFFSET11
#define SFTOR_SFT_OFFSET12              _SFTOR.Bits.SFT_OFFSET12
#define SFTOR_SFT_OFFSET13              _SFTOR.Bits.SFT_OFFSET13
#define SFTOR_SFT_OFFSET14              _SFTOR.Bits.SFT_OFFSET14
#define SFTOR_SFT_OFFSET15              _SFTOR.Bits.SFT_OFFSET15
#define SFTOR_SFT_OFFSET_1              _SFTOR.MergedBits.grpSFT_OFFSET_1
#define SFTOR_SFT_OFFSET                SFTOR_SFT_OFFSET_1

#define SFTOR_SFT_OFFSET1_MASK          2
#define SFTOR_SFT_OFFSET2_MASK          4
#define SFTOR_SFT_OFFSET3_MASK          8
#define SFTOR_SFT_OFFSET4_MASK          16
#define SFTOR_SFT_OFFSET5_MASK          32
#define SFTOR_SFT_OFFSET6_MASK          64
#define SFTOR_SFT_OFFSET7_MASK          128
#define SFTOR_SFT_OFFSET8_MASK          256
#define SFTOR_SFT_OFFSET9_MASK          512
#define SFTOR_SFT_OFFSET10_MASK         1024
#define SFTOR_SFT_OFFSET11_MASK         2048
#define SFTOR_SFT_OFFSET12_MASK         4096
#define SFTOR_SFT_OFFSET13_MASK         8192
#define SFTOR_SFT_OFFSET14_MASK         16384
#define SFTOR_SFT_OFFSET15_MASK         32768
#define SFTOR_SFT_OFFSET_1_MASK         65534
#define SFTOR_SFT_OFFSET_1_BITNUM       1


/*** SFTCCSR - Sync Frame Table Configuration, Control, Status Register; 0x00000444 ***/
typedef union {
  word Word;
  struct {
    word SIDEN       :1;                                       /* Sync Frame ID Table Enable */
    word SDVEN       :1;                                       /* Sync Frame Deviation Table Enable */
    word OPT         :1;                                       /* One Pair Trigger */
    word             :1; 
    word OVAL        :1;                                       /* Odd Cycle Tables Valid */
    word EVAL        :1;                                       /* Even Cycle Tables Valid */
    word OLKS        :1;                                       /* Odd Cycle Tables Lock Status */
    word ELKS        :1;                                       /* Even Cycle Tables Lock Status */
    word CYCNUM      :6;                                       /* Cycle Number */
    word OLKT        :1;                                       /* Odd Cycle Tables Lock/Unlock Trigger */
    word ELKT        :1;                                       /* Even Cycle Tables Lock/Unlock Trigger */
  } Bits;
} SFTCCSRSTR;
extern volatile SFTCCSRSTR _SFTCCSR @(REG_BASE + 0x00000444);
#define SFTCCSR                         _SFTCCSR.Word
#define SFTCCSR_SIDEN                   _SFTCCSR.Bits.SIDEN
#define SFTCCSR_SDVEN                   _SFTCCSR.Bits.SDVEN
#define SFTCCSR_OPT                     _SFTCCSR.Bits.OPT
#define SFTCCSR_OVAL                    _SFTCCSR.Bits.OVAL
#define SFTCCSR_EVAL                    _SFTCCSR.Bits.EVAL
#define SFTCCSR_OLKS                    _SFTCCSR.Bits.OLKS
#define SFTCCSR_ELKS                    _SFTCCSR.Bits.ELKS
#define SFTCCSR_CYCNUM                  _SFTCCSR.Bits.CYCNUM
#define SFTCCSR_OLKT                    _SFTCCSR.Bits.OLKT
#define SFTCCSR_ELKT                    _SFTCCSR.Bits.ELKT

#define SFTCCSR_SIDEN_MASK              1
#define SFTCCSR_SDVEN_MASK              2
#define SFTCCSR_OPT_MASK                4
#define SFTCCSR_OVAL_MASK               16
#define SFTCCSR_EVAL_MASK               32
#define SFTCCSR_OLKS_MASK               64
#define SFTCCSR_ELKS_MASK               128
#define SFTCCSR_CYCNUM_MASK             16128
#define SFTCCSR_CYCNUM_BITNUM           8
#define SFTCCSR_OLKT_MASK               16384
#define SFTCCSR_ELKT_MASK               32768


/*** SFIDRFR - Sync Frame ID Rejection Filter Register; 0x00000446 ***/
typedef union {
  word Word;
  struct {
    word SYNFRID     :10;                                      /* Sync Frame Rejection ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDRFRSTR;
extern volatile SFIDRFRSTR _SFIDRFR @(REG_BASE + 0x00000446);
#define SFIDRFR                         _SFIDRFR.Word
#define SFIDRFR_SYNFRID                 _SFIDRFR.Bits.SYNFRID

#define SFIDRFR_SYNFRID_MASK            1023
#define SFIDRFR_SYNFRID_BITNUM          0


/*** SFIDAFVR - Sync Frame ID Acceptance Filter Value Register; 0x00000448 ***/
typedef union {
  word Word;
  struct {
    word FVAL        :10;                                      /* Filter Value */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDAFVRSTR;
extern volatile SFIDAFVRSTR _SFIDAFVR @(REG_BASE + 0x00000448);
#define SFIDAFVR                        _SFIDAFVR.Word
#define SFIDAFVR_FVAL                   _SFIDAFVR.Bits.FVAL

#define SFIDAFVR_FVAL_MASK              1023
#define SFIDAFVR_FVAL_BITNUM            0


/*** SFIDAFMR - Sync Frame ID Acceptance Filter Mask Register; 0x0000044A ***/
typedef union {
  word Word;
  struct {
    word FMSK        :10;                                      /* Filter Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} SFIDAFMRSTR;
extern volatile SFIDAFMRSTR _SFIDAFMR @(REG_BASE + 0x0000044A);
#define SFIDAFMR                        _SFIDAFMR.Word
#define SFIDAFMR_FMSK                   _SFIDAFMR.Bits.FMSK

#define SFIDAFMR_FMSK_MASK              1023
#define SFIDAFMR_FMSK_BITNUM            0


/*** NMVR0 - Network Management Vector Register 0; 0x0000044C ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR0STR;
extern volatile NMVR0STR _NMVR0 @(REG_BASE + 0x0000044C);
#define NMVR0                           _NMVR0.Word
#define NMVR0_NMVP                      _NMVR0.Bits.NMVP
/* NMVR_ARR: Access 6 NMVRx registers in an array */
#define NMVR_ARR                        ((word *) &NMVR0)

#define NMVR0_NMVP_MASK                 65535
#define NMVR0_NMVP_BITNUM               0


/*** NMVR1 - Network Management Vector Register 1; 0x0000044E ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR1STR;
extern volatile NMVR1STR _NMVR1 @(REG_BASE + 0x0000044E);
#define NMVR1                           _NMVR1.Word
#define NMVR1_NMVP                      _NMVR1.Bits.NMVP

#define NMVR1_NMVP_MASK                 65535
#define NMVR1_NMVP_BITNUM               0


/*** NMVR2 - Network Management Vector Register 2; 0x00000450 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR2STR;
extern volatile NMVR2STR _NMVR2 @(REG_BASE + 0x00000450);
#define NMVR2                           _NMVR2.Word
#define NMVR2_NMVP                      _NMVR2.Bits.NMVP

#define NMVR2_NMVP_MASK                 65535
#define NMVR2_NMVP_BITNUM               0


/*** NMVR3 - Network Management Vector Register 3; 0x00000452 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR3STR;
extern volatile NMVR3STR _NMVR3 @(REG_BASE + 0x00000452);
#define NMVR3                           _NMVR3.Word
#define NMVR3_NMVP                      _NMVR3.Bits.NMVP

#define NMVR3_NMVP_MASK                 65535
#define NMVR3_NMVP_BITNUM               0


/*** NMVR4 - Network Management Vector Register 4; 0x00000454 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR4STR;
extern volatile NMVR4STR _NMVR4 @(REG_BASE + 0x00000454);
#define NMVR4                           _NMVR4.Word
#define NMVR4_NMVP                      _NMVR4.Bits.NMVP

#define NMVR4_NMVP_MASK                 65535
#define NMVR4_NMVP_BITNUM               0


/*** NMVR5 - Network Management Vector Register 5; 0x00000456 ***/
typedef union {
  word Word;
  struct {
    word NMVP        :16;                                      /* Network Management Vector */
  } Bits;
} NMVR5STR;
extern volatile NMVR5STR _NMVR5 @(REG_BASE + 0x00000456);
#define NMVR5                           _NMVR5.Word
#define NMVR5_NMVP                      _NMVR5.Bits.NMVP

#define NMVR5_NMVP_MASK                 65535
#define NMVR5_NMVP_BITNUM               0


/*** NMVLR - Network Management Vector Length Register; 0x00000458 ***/
typedef union {
  word Word;
  struct {
    word NMVL        :4;                                       /* Network Management Vector Length */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} NMVLRSTR;
extern volatile NMVLRSTR _NMVLR @(REG_BASE + 0x00000458);
#define NMVLR                           _NMVLR.Word
#define NMVLR_NMVL                      _NMVLR.Bits.NMVL

#define NMVLR_NMVL_MASK                 15
#define NMVLR_NMVL_BITNUM               0


/*** TICCR - Timer Configuration and Control Register; 0x0000045A ***/
typedef union {
  word Word;
  struct {
    word T1ST        :1;                                       /* Timer T1 State */
    word T1TR        :1;                                       /* Timer T1 Trigger */
    word T1SP        :1;                                       /* Timer T1 Stop */
    word             :1; 
    word T1_REP      :1;                                       /* Timer T1 Repetitive Mode */
    word             :1; 
    word             :1; 
    word             :1; 
    word T2ST        :1;                                       /* Timer T2 State */
    word T2TR        :1;                                       /* Timer T2 Trigger */
    word T2SP        :1;                                       /* Timer T2 Stop */
    word             :1; 
    word T2_REP      :1;                                       /* Timer T2 Repetitive Mode */
    word T2_CFG      :1;                                       /* Timer T2 Configuration */
    word             :1; 
    word             :1; 
  } Bits;
} TICCRSTR;
extern volatile TICCRSTR _TICCR @(REG_BASE + 0x0000045A);
#define TICCR                           _TICCR.Word
#define TICCR_T1ST                      _TICCR.Bits.T1ST
#define TICCR_T1TR                      _TICCR.Bits.T1TR
#define TICCR_T1SP                      _TICCR.Bits.T1SP
#define TICCR_T1_REP                    _TICCR.Bits.T1_REP
#define TICCR_T2ST                      _TICCR.Bits.T2ST
#define TICCR_T2TR                      _TICCR.Bits.T2TR
#define TICCR_T2SP                      _TICCR.Bits.T2SP
#define TICCR_T2_REP                    _TICCR.Bits.T2_REP
#define TICCR_T2_CFG                    _TICCR.Bits.T2_CFG

#define TICCR_T1ST_MASK                 1
#define TICCR_T1TR_MASK                 2
#define TICCR_T1SP_MASK                 4
#define TICCR_T1_REP_MASK               16
#define TICCR_T2ST_MASK                 256
#define TICCR_T2TR_MASK                 512
#define TICCR_T2SP_MASK                 1024
#define TICCR_T2_REP_MASK               4096
#define TICCR_T2_CFG_MASK               8192


/*** TI1CYSR - Timer 1 Cycle Set Register; 0x0000045C ***/
typedef union {
  word Word;
  struct {
    word T1_CYC_MSK  :6;                                       /* Timer T1 Cycle Filter Mask */
    word             :1; 
    word             :1; 
    word T1_CYC_VAL  :6;                                       /* Timer T1 Cycle Filter Value */
    word             :1; 
    word             :1; 
  } Bits;
} TI1CYSRSTR;
extern volatile TI1CYSRSTR _TI1CYSR @(REG_BASE + 0x0000045C);
#define TI1CYSR                         _TI1CYSR.Word
#define TI1CYSR_T1_CYC_MSK              _TI1CYSR.Bits.T1_CYC_MSK
#define TI1CYSR_T1_CYC_VAL              _TI1CYSR.Bits.T1_CYC_VAL

#define TI1CYSR_T1_CYC_MSK_MASK         63
#define TI1CYSR_T1_CYC_MSK_BITNUM       0
#define TI1CYSR_T1_CYC_VAL_MASK         16128
#define TI1CYSR_T1_CYC_VAL_BITNUM       8



/*** TI1MTOR - Timer 1 Macrotick Offset Register; 0x0000045E ***/
typedef union {
  word Word;
  struct {
    word T1_MTOFFSET :14;                                      /* Timer 1 Macrotick Offset */
    word             :1; 
    word             :1; 
  } Bits;
} TI1MTORSTR;
extern volatile TI1MTORSTR _TI1MTOR @(REG_BASE + 0x0000045E);
#define TI1MTOR                         _TI1MTOR.Word
#define TI1MTOR_T1_MTOFFSET             _TI1MTOR.Bits.T1_MTOFFSET

#define TI1MTOR_T1_MTOFFSET_MASK        16383
#define TI1MTOR_T1_MTOFFSET_BITNUM      0


/*** TI2CR0_CYC - Timer 2 Configuration Register 0; 0x00000460 ***/
typedef union {
  word Word;
  union { /*Several registers at the same address */
    /*** TI2CR0_CYC - Timer 2 Configuration Register 0; Several registers at the same address ***/
    union {
      struct {
        word T2_CYC_MSK  :6;                                       /* Timer T2 Cycle Filter Mask */
        word             :1; 
        word             :1; 
        word T2_CYC_VAL  :6;                                       /* Timer T2 Cycle Filter Value */
        word             :1; 
        word             :1; 
      } Bits;
    } TI2CR0_CYCSTR;
    #define TI2CR0_CYC                  _TI2CR0_CYC.Word
    #define TI2CR0_CYC_T2_CYC_MSK       _TI2CR0_CYC.SameAddr_STR.TI2CR0_CYCSTR.Bits.T2_CYC_MSK
    #define TI2CR0_CYC_T2_CYC_VAL       _TI2CR0_CYC.SameAddr_STR.TI2CR0_CYCSTR.Bits.T2_CYC_VAL
    
    
    #define TI2CR0_CYC_T2_CYC_MSK_MASK  63
    #define TI2CR0_CYC_T2_CYC_MSK_BITNUM 0
    #define TI2CR0_CYC_T2_CYC_VAL_MASK  16128
    #define TI2CR0_CYC_T2_CYC_VAL_BITNUM 8

    /*** TI2CR0_MTCNT - Timer 2 Configuration Register 1; Several registers at the same address ***/
    union {
      struct {
        word T2_MTCNT    :16;                                      /* Timer T2 Macrotick High Word */
      } Bits;
    } TI2CR0_MTCNTSTR;
    #define TI2CR0_MTCNT                _TI2CR0_CYC.Word
    #define TI2CR0_MTCNT_T2_MTCNT       _TI2CR0_CYC.SameAddr_STR.TI2CR0_MTCNTSTR.Bits.T2_MTCNT
    
    
    #define TI2CR0_MTCNT_T2_MTCNT_MASK  65535
    #define TI2CR0_MTCNT_T2_MTCNT_BITNUM 0

  } SameAddr_STR; /*Several registers at the same address */

} TI2CR0_CYCSTR;
extern volatile TI2CR0_CYCSTR _TI2CR0_CYC @(REG_BASE + 0x00000460);



/*** TI2CR1_MTCNT - Timer 2 Configuration Register 3; 0x00000462 ***/
typedef union {
  word Word;
  union { /*Several registers at the same address */
    /*** TI2CR1_MTCNT - Timer 2 Configuration Register 3; Several registers at the same address ***/
    union {
      struct {
        word T2_MTCNT    :16;                                      /* Timer T2 Macrotick Low Word */
      } Bits;
    } TI2CR1_MTCNTSTR;
    #define TI2CR1_MTCNT                _TI2CR1_MTCNT.Word
    #define TI2CR1_MTCNT_T2_MTCNT       _TI2CR1_MTCNT.SameAddr_STR.TI2CR1_MTCNTSTR.Bits.T2_MTCNT
    
    
    #define TI2CR1_MTCNT_T2_MTCNT_MASK  65535
    #define TI2CR1_MTCNT_T2_MTCNT_BITNUM 0

    /*** TI2CR1_MTOFFSET - Timer 2 Configuration Register 2; Several registers at the same address ***/
    union {
      struct {
        word T2_MTOFFSET :14;                                      /* Timer T2 Macrotick Offset */
        word             :1; 
        word             :1; 
      } Bits;
    } TI2CR1_MTOFFSETSTR;
    #define TI2CR1_MTOFFSET             _TI2CR1_MTCNT.Word
    #define TI2CR1_MTOFFSET_T2_MTOFFSET _TI2CR1_MTCNT.SameAddr_STR.TI2CR1_MTOFFSETSTR.Bits.T2_MTOFFSET
    
    
    #define TI2CR1_MTOFFSET_T2_MTOFFSET_MASK 16383
    #define TI2CR1_MTOFFSET_T2_MTOFFSET_BITNUM 0

  } SameAddr_STR; /*Several registers at the same address */

} TI2CR1_MTCNTSTR;
extern volatile TI2CR1_MTCNTSTR _TI2CR1_MTCNT @(REG_BASE + 0x00000462);



/*** SSSR - Slot Status Selection Register; 0x00000464 ***/
typedef union {
  word Word;
  struct {
    word SLOTNUMBER  :11;                                      /* Slot Number */
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} SSSRSTR;
extern volatile SSSRSTR _SSSR @(REG_BASE + 0x00000464);
#define SSSR                            _SSSR.Word
#define SSSR_SLOTNUMBER                 _SSSR.Bits.SLOTNUMBER
#define SSSR_SEL                        _SSSR.Bits.SEL
#define SSSR_WMD                        _SSSR.Bits.WMD

#define SSSR_SLOTNUMBER_MASK            2047
#define SSSR_SLOTNUMBER_BITNUM          0
#define SSSR_SEL_MASK                   12288
#define SSSR_SEL_BITNUM                 12
#define SSSR_WMD_MASK                   32768


/*** SSCCR - Slot Status Selection Register; 0x00000466 ***/
typedef union {
  word Word;
  struct {
    word STATUSMASK  :4;                                       /* Slot Status Mask */
    word SUF         :1;                                       /* Startup Frame Restriction */
    word NUF         :1;                                       /* Null Frame Restriction */
    word SYF         :1;                                       /* Sync Frame Restriction */
    word VFR         :1;                                       /* Valid Frame Restrictio */
    word MCY         :1;                                       /* Multi Cycle Selection */
    word CNTCFG      :2;                                       /* Counter Configuration */
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} SSCCRSTR;
extern volatile SSCCRSTR _SSCCR @(REG_BASE + 0x00000466);
#define SSCCR                           _SSCCR.Word
#define SSCCR_STATUSMASK                _SSCCR.Bits.STATUSMASK
#define SSCCR_SUF                       _SSCCR.Bits.SUF
#define SSCCR_NUF                       _SSCCR.Bits.NUF
#define SSCCR_SYF                       _SSCCR.Bits.SYF
#define SSCCR_VFR                       _SSCCR.Bits.VFR
#define SSCCR_MCY                       _SSCCR.Bits.MCY
#define SSCCR_CNTCFG                    _SSCCR.Bits.CNTCFG
#define SSCCR_SEL                       _SSCCR.Bits.SEL
#define SSCCR_WMD                       _SSCCR.Bits.WMD

#define SSCCR_STATUSMASK_MASK           15
#define SSCCR_STATUSMASK_BITNUM         0
#define SSCCR_SUF_MASK                  16
#define SSCCR_NUF_MASK                  32
#define SSCCR_SYF_MASK                  64
#define SSCCR_VFR_MASK                  128
#define SSCCR_MCY_MASK                  256
#define SSCCR_CNTCFG_MASK               1536
#define SSCCR_CNTCFG_BITNUM             9
#define SSCCR_SEL_MASK                  12288
#define SSCCR_SEL_BITNUM                12
#define SSCCR_WMD_MASK                  32768


/*** SSR0 - Slot Status Register 0; 0x00000468 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR0STR;
extern volatile SSR0STR _SSR0 @(REG_BASE + 0x00000468);
#define SSR0                            _SSR0.Word
#define SSR0_TCA                        _SSR0.Bits.TCA
#define SSR0_BVA                        _SSR0.Bits.BVA
#define SSR0_CEA                        _SSR0.Bits.CEA
#define SSR0_SEA                        _SSR0.Bits.SEA
#define SSR0_SUA                        _SSR0.Bits.SUA
#define SSR0_NFA                        _SSR0.Bits.NFA
#define SSR0_SYA                        _SSR0.Bits.SYA
#define SSR0_VFA                        _SSR0.Bits.VFA
#define SSR0_TCB                        _SSR0.Bits.TCB
#define SSR0_BVB                        _SSR0.Bits.BVB
#define SSR0_CEB                        _SSR0.Bits.CEB
#define SSR0_SEB                        _SSR0.Bits.SEB
#define SSR0_SUB                        _SSR0.Bits.SUB
#define SSR0_NFB                        _SSR0.Bits.NFB
#define SSR0_SYB                        _SSR0.Bits.SYB
#define SSR0_VFB                        _SSR0.Bits.VFB
/* SSR_ARR: Access 8 SSRx registers in an array */
#define SSR_ARR                         ((word *) &SSR0)

#define SSR0_TCA_MASK                   1
#define SSR0_BVA_MASK                   2
#define SSR0_CEA_MASK                   4
#define SSR0_SEA_MASK                   8
#define SSR0_SUA_MASK                   16
#define SSR0_NFA_MASK                   32
#define SSR0_SYA_MASK                   64
#define SSR0_VFA_MASK                   128
#define SSR0_TCB_MASK                   256
#define SSR0_BVB_MASK                   512
#define SSR0_CEB_MASK                   1024
#define SSR0_SEB_MASK                   2048
#define SSR0_SUB_MASK                   4096
#define SSR0_NFB_MASK                   8192
#define SSR0_SYB_MASK                   16384
#define SSR0_VFB_MASK                   32768


/*** SSR1 - Slot Status Register 1; 0x0000046A ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR1STR;
extern volatile SSR1STR _SSR1 @(REG_BASE + 0x0000046A);
#define SSR1                            _SSR1.Word
#define SSR1_TCA                        _SSR1.Bits.TCA
#define SSR1_BVA                        _SSR1.Bits.BVA
#define SSR1_CEA                        _SSR1.Bits.CEA
#define SSR1_SEA                        _SSR1.Bits.SEA
#define SSR1_SUA                        _SSR1.Bits.SUA
#define SSR1_NFA                        _SSR1.Bits.NFA
#define SSR1_SYA                        _SSR1.Bits.SYA
#define SSR1_VFA                        _SSR1.Bits.VFA
#define SSR1_TCB                        _SSR1.Bits.TCB
#define SSR1_BVB                        _SSR1.Bits.BVB
#define SSR1_CEB                        _SSR1.Bits.CEB
#define SSR1_SEB                        _SSR1.Bits.SEB
#define SSR1_SUB                        _SSR1.Bits.SUB
#define SSR1_NFB                        _SSR1.Bits.NFB
#define SSR1_SYB                        _SSR1.Bits.SYB
#define SSR1_VFB                        _SSR1.Bits.VFB

#define SSR1_TCA_MASK                   1
#define SSR1_BVA_MASK                   2
#define SSR1_CEA_MASK                   4
#define SSR1_SEA_MASK                   8
#define SSR1_SUA_MASK                   16
#define SSR1_NFA_MASK                   32
#define SSR1_SYA_MASK                   64
#define SSR1_VFA_MASK                   128
#define SSR1_TCB_MASK                   256
#define SSR1_BVB_MASK                   512
#define SSR1_CEB_MASK                   1024
#define SSR1_SEB_MASK                   2048
#define SSR1_SUB_MASK                   4096
#define SSR1_NFB_MASK                   8192
#define SSR1_SYB_MASK                   16384
#define SSR1_VFB_MASK                   32768


/*** SSR2 - Slot Status Register 2; 0x0000046C ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR2STR;
extern volatile SSR2STR _SSR2 @(REG_BASE + 0x0000046C);
#define SSR2                            _SSR2.Word
#define SSR2_TCA                        _SSR2.Bits.TCA
#define SSR2_BVA                        _SSR2.Bits.BVA
#define SSR2_CEA                        _SSR2.Bits.CEA
#define SSR2_SEA                        _SSR2.Bits.SEA
#define SSR2_SUA                        _SSR2.Bits.SUA
#define SSR2_NFA                        _SSR2.Bits.NFA
#define SSR2_SYA                        _SSR2.Bits.SYA
#define SSR2_VFA                        _SSR2.Bits.VFA
#define SSR2_TCB                        _SSR2.Bits.TCB
#define SSR2_BVB                        _SSR2.Bits.BVB
#define SSR2_CEB                        _SSR2.Bits.CEB
#define SSR2_SEB                        _SSR2.Bits.SEB
#define SSR2_SUB                        _SSR2.Bits.SUB
#define SSR2_NFB                        _SSR2.Bits.NFB
#define SSR2_SYB                        _SSR2.Bits.SYB
#define SSR2_VFB                        _SSR2.Bits.VFB

#define SSR2_TCA_MASK                   1
#define SSR2_BVA_MASK                   2
#define SSR2_CEA_MASK                   4
#define SSR2_SEA_MASK                   8
#define SSR2_SUA_MASK                   16
#define SSR2_NFA_MASK                   32
#define SSR2_SYA_MASK                   64
#define SSR2_VFA_MASK                   128
#define SSR2_TCB_MASK                   256
#define SSR2_BVB_MASK                   512
#define SSR2_CEB_MASK                   1024
#define SSR2_SEB_MASK                   2048
#define SSR2_SUB_MASK                   4096
#define SSR2_NFB_MASK                   8192
#define SSR2_SYB_MASK                   16384
#define SSR2_VFB_MASK                   32768


/*** SSR3 - Slot Status Register 3; 0x0000046E ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR3STR;
extern volatile SSR3STR _SSR3 @(REG_BASE + 0x0000046E);
#define SSR3                            _SSR3.Word
#define SSR3_TCA                        _SSR3.Bits.TCA
#define SSR3_BVA                        _SSR3.Bits.BVA
#define SSR3_CEA                        _SSR3.Bits.CEA
#define SSR3_SEA                        _SSR3.Bits.SEA
#define SSR3_SUA                        _SSR3.Bits.SUA
#define SSR3_NFA                        _SSR3.Bits.NFA
#define SSR3_SYA                        _SSR3.Bits.SYA
#define SSR3_VFA                        _SSR3.Bits.VFA
#define SSR3_TCB                        _SSR3.Bits.TCB
#define SSR3_BVB                        _SSR3.Bits.BVB
#define SSR3_CEB                        _SSR3.Bits.CEB
#define SSR3_SEB                        _SSR3.Bits.SEB
#define SSR3_SUB                        _SSR3.Bits.SUB
#define SSR3_NFB                        _SSR3.Bits.NFB
#define SSR3_SYB                        _SSR3.Bits.SYB
#define SSR3_VFB                        _SSR3.Bits.VFB

#define SSR3_TCA_MASK                   1
#define SSR3_BVA_MASK                   2
#define SSR3_CEA_MASK                   4
#define SSR3_SEA_MASK                   8
#define SSR3_SUA_MASK                   16
#define SSR3_NFA_MASK                   32
#define SSR3_SYA_MASK                   64
#define SSR3_VFA_MASK                   128
#define SSR3_TCB_MASK                   256
#define SSR3_BVB_MASK                   512
#define SSR3_CEB_MASK                   1024
#define SSR3_SEB_MASK                   2048
#define SSR3_SUB_MASK                   4096
#define SSR3_NFB_MASK                   8192
#define SSR3_SYB_MASK                   16384
#define SSR3_VFB_MASK                   32768


/*** SSR4 - Slot Status Register 4; 0x00000470 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR4STR;
extern volatile SSR4STR _SSR4 @(REG_BASE + 0x00000470);
#define SSR4                            _SSR4.Word
#define SSR4_TCA                        _SSR4.Bits.TCA
#define SSR4_BVA                        _SSR4.Bits.BVA
#define SSR4_CEA                        _SSR4.Bits.CEA
#define SSR4_SEA                        _SSR4.Bits.SEA
#define SSR4_SUA                        _SSR4.Bits.SUA
#define SSR4_NFA                        _SSR4.Bits.NFA
#define SSR4_SYA                        _SSR4.Bits.SYA
#define SSR4_VFA                        _SSR4.Bits.VFA
#define SSR4_TCB                        _SSR4.Bits.TCB
#define SSR4_BVB                        _SSR4.Bits.BVB
#define SSR4_CEB                        _SSR4.Bits.CEB
#define SSR4_SEB                        _SSR4.Bits.SEB
#define SSR4_SUB                        _SSR4.Bits.SUB
#define SSR4_NFB                        _SSR4.Bits.NFB
#define SSR4_SYB                        _SSR4.Bits.SYB
#define SSR4_VFB                        _SSR4.Bits.VFB

#define SSR4_TCA_MASK                   1
#define SSR4_BVA_MASK                   2
#define SSR4_CEA_MASK                   4
#define SSR4_SEA_MASK                   8
#define SSR4_SUA_MASK                   16
#define SSR4_NFA_MASK                   32
#define SSR4_SYA_MASK                   64
#define SSR4_VFA_MASK                   128
#define SSR4_TCB_MASK                   256
#define SSR4_BVB_MASK                   512
#define SSR4_CEB_MASK                   1024
#define SSR4_SEB_MASK                   2048
#define SSR4_SUB_MASK                   4096
#define SSR4_NFB_MASK                   8192
#define SSR4_SYB_MASK                   16384
#define SSR4_VFB_MASK                   32768


/*** SSR5 - Slot Status Register 5; 0x00000472 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR5STR;
extern volatile SSR5STR _SSR5 @(REG_BASE + 0x00000472);
#define SSR5                            _SSR5.Word
#define SSR5_TCA                        _SSR5.Bits.TCA
#define SSR5_BVA                        _SSR5.Bits.BVA
#define SSR5_CEA                        _SSR5.Bits.CEA
#define SSR5_SEA                        _SSR5.Bits.SEA
#define SSR5_SUA                        _SSR5.Bits.SUA
#define SSR5_NFA                        _SSR5.Bits.NFA
#define SSR5_SYA                        _SSR5.Bits.SYA
#define SSR5_VFA                        _SSR5.Bits.VFA
#define SSR5_TCB                        _SSR5.Bits.TCB
#define SSR5_BVB                        _SSR5.Bits.BVB
#define SSR5_CEB                        _SSR5.Bits.CEB
#define SSR5_SEB                        _SSR5.Bits.SEB
#define SSR5_SUB                        _SSR5.Bits.SUB
#define SSR5_NFB                        _SSR5.Bits.NFB
#define SSR5_SYB                        _SSR5.Bits.SYB
#define SSR5_VFB                        _SSR5.Bits.VFB

#define SSR5_TCA_MASK                   1
#define SSR5_BVA_MASK                   2
#define SSR5_CEA_MASK                   4
#define SSR5_SEA_MASK                   8
#define SSR5_SUA_MASK                   16
#define SSR5_NFA_MASK                   32
#define SSR5_SYA_MASK                   64
#define SSR5_VFA_MASK                   128
#define SSR5_TCB_MASK                   256
#define SSR5_BVB_MASK                   512
#define SSR5_CEB_MASK                   1024
#define SSR5_SEB_MASK                   2048
#define SSR5_SUB_MASK                   4096
#define SSR5_NFB_MASK                   8192
#define SSR5_SYB_MASK                   16384
#define SSR5_VFB_MASK                   32768


/*** SSR6 - Slot Status Register 6; 0x00000474 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR6STR;
extern volatile SSR6STR _SSR6 @(REG_BASE + 0x00000474);
#define SSR6                            _SSR6.Word
#define SSR6_TCA                        _SSR6.Bits.TCA
#define SSR6_BVA                        _SSR6.Bits.BVA
#define SSR6_CEA                        _SSR6.Bits.CEA
#define SSR6_SEA                        _SSR6.Bits.SEA
#define SSR6_SUA                        _SSR6.Bits.SUA
#define SSR6_NFA                        _SSR6.Bits.NFA
#define SSR6_SYA                        _SSR6.Bits.SYA
#define SSR6_VFA                        _SSR6.Bits.VFA
#define SSR6_TCB                        _SSR6.Bits.TCB
#define SSR6_BVB                        _SSR6.Bits.BVB
#define SSR6_CEB                        _SSR6.Bits.CEB
#define SSR6_SEB                        _SSR6.Bits.SEB
#define SSR6_SUB                        _SSR6.Bits.SUB
#define SSR6_NFB                        _SSR6.Bits.NFB
#define SSR6_SYB                        _SSR6.Bits.SYB
#define SSR6_VFB                        _SSR6.Bits.VFB

#define SSR6_TCA_MASK                   1
#define SSR6_BVA_MASK                   2
#define SSR6_CEA_MASK                   4
#define SSR6_SEA_MASK                   8
#define SSR6_SUA_MASK                   16
#define SSR6_NFA_MASK                   32
#define SSR6_SYA_MASK                   64
#define SSR6_VFA_MASK                   128
#define SSR6_TCB_MASK                   256
#define SSR6_BVB_MASK                   512
#define SSR6_CEB_MASK                   1024
#define SSR6_SEB_MASK                   2048
#define SSR6_SUB_MASK                   4096
#define SSR6_NFB_MASK                   8192
#define SSR6_SYB_MASK                   16384
#define SSR6_VFB_MASK                   32768


/*** SSR7 - Slot Status Register 7; 0x00000476 ***/
typedef union {
  word Word;
  struct {
    word TCA         :1;                                       /* Transmission Conflict on Channel A */
    word BVA         :1;                                       /* Boundary Violation on Channel A */
    word CEA         :1;                                       /* Content Error on Channel A */
    word SEA         :1;                                       /* Syntax Error on Channel A */
    word SUA         :1;                                       /* Startup Frame Indicator Channel A */
    word NFA         :1;                                       /* Null Frame Indicator Channel A */
    word SYA         :1;                                       /* Sync Frame Indicator Channel A */
    word VFA         :1;                                       /* Valid Frame on Channel A */
    word TCB         :1;                                       /* Transmission Conflict on Channel B */
    word BVB         :1;                                       /* Boundary Violation on Channel B */
    word CEB         :1;                                       /* Content Error on Channel B */
    word SEB         :1;                                       /* Syntax Error on Channel B */
    word SUB         :1;                                       /* Startup Frame Indicator Channel B */
    word NFB         :1;                                       /* Null Frame Indicator Channel B */
    word SYB         :1;                                       /* Sync Frame Indicator Channel B */
    word VFB         :1;                                       /* Valid Frame on Channel B */
  } Bits;
} SSR7STR;
extern volatile SSR7STR _SSR7 @(REG_BASE + 0x00000476);
#define SSR7                            _SSR7.Word
#define SSR7_TCA                        _SSR7.Bits.TCA
#define SSR7_BVA                        _SSR7.Bits.BVA
#define SSR7_CEA                        _SSR7.Bits.CEA
#define SSR7_SEA                        _SSR7.Bits.SEA
#define SSR7_SUA                        _SSR7.Bits.SUA
#define SSR7_NFA                        _SSR7.Bits.NFA
#define SSR7_SYA                        _SSR7.Bits.SYA
#define SSR7_VFA                        _SSR7.Bits.VFA
#define SSR7_TCB                        _SSR7.Bits.TCB
#define SSR7_BVB                        _SSR7.Bits.BVB
#define SSR7_CEB                        _SSR7.Bits.CEB
#define SSR7_SEB                        _SSR7.Bits.SEB
#define SSR7_SUB                        _SSR7.Bits.SUB
#define SSR7_NFB                        _SSR7.Bits.NFB
#define SSR7_SYB                        _SSR7.Bits.SYB
#define SSR7_VFB                        _SSR7.Bits.VFB

#define SSR7_TCA_MASK                   1
#define SSR7_BVA_MASK                   2
#define SSR7_CEA_MASK                   4
#define SSR7_SEA_MASK                   8
#define SSR7_SUA_MASK                   16
#define SSR7_NFA_MASK                   32
#define SSR7_SYA_MASK                   64
#define SSR7_VFA_MASK                   128
#define SSR7_TCB_MASK                   256
#define SSR7_BVB_MASK                   512
#define SSR7_CEB_MASK                   1024
#define SSR7_SEB_MASK                   2048
#define SSR7_SUB_MASK                   4096
#define SSR7_NFB_MASK                   8192
#define SSR7_SYB_MASK                   16384
#define SSR7_VFB_MASK                   32768


/*** SSCR0 - Slot Status Counter Register 0; 0x00000478 ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR0STR;
extern volatile SSCR0STR _SSCR0 @(REG_BASE + 0x00000478);
#define SSCR0                           _SSCR0.Word
#define SSCR0_SLOTSTATUSCNT             _SSCR0.Bits.SLOTSTATUSCNT
/* SSCR_ARR: Access 4 SSCRx registers in an array */
#define SSCR_ARR                        ((word *) &SSCR0)

#define SSCR0_SLOTSTATUSCNT_MASK        65535
#define SSCR0_SLOTSTATUSCNT_BITNUM      0


/*** SSCR1 - Slot Status Counter Register 1; 0x0000047A ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR1STR;
extern volatile SSCR1STR _SSCR1 @(REG_BASE + 0x0000047A);
#define SSCR1                           _SSCR1.Word
#define SSCR1_SLOTSTATUSCNT             _SSCR1.Bits.SLOTSTATUSCNT

#define SSCR1_SLOTSTATUSCNT_MASK        65535
#define SSCR1_SLOTSTATUSCNT_BITNUM      0


/*** SSCR2 - Slot Status Counter Register 2; 0x0000047C ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR2STR;
extern volatile SSCR2STR _SSCR2 @(REG_BASE + 0x0000047C);
#define SSCR2                           _SSCR2.Word
#define SSCR2_SLOTSTATUSCNT             _SSCR2.Bits.SLOTSTATUSCNT

#define SSCR2_SLOTSTATUSCNT_MASK        65535
#define SSCR2_SLOTSTATUSCNT_BITNUM      0


/*** SSCR3 - Slot Status Counter Register 3; 0x0000047E ***/
typedef union {
  word Word;
  struct {
    word SLOTSTATUSCNT :16;                                    /* Slot Status Counter */
  } Bits;
} SSCR3STR;
extern volatile SSCR3STR _SSCR3 @(REG_BASE + 0x0000047E);
#define SSCR3                           _SSCR3.Word
#define SSCR3_SLOTSTATUSCNT             _SSCR3.Bits.SLOTSTATUSCNT

#define SSCR3_SLOTSTATUSCNT_MASK        65535
#define SSCR3_SLOTSTATUSCNT_BITNUM      0


/*** MTSACFR - MTS A Configuration Register; 0x00000480 ***/
typedef union {
  word Word;
  struct {
    word CYCCNTVAL   :6;                                       /* Cycle Counter Value */
    word             :1; 
    word             :1; 
    word CYCCNTMSK   :6;                                       /* Cycle Counter Mask */
    word             :1; 
    word MTE         :1;                                       /* Media Access Test Symbol Transmission Enable */
  } Bits;
} MTSACFRSTR;
extern volatile MTSACFRSTR _MTSACFR @(REG_BASE + 0x00000480);
#define MTSACFR                         _MTSACFR.Word
#define MTSACFR_CYCCNTVAL               _MTSACFR.Bits.CYCCNTVAL
#define MTSACFR_CYCCNTMSK               _MTSACFR.Bits.CYCCNTMSK
#define MTSACFR_MTE                     _MTSACFR.Bits.MTE

#define MTSACFR_CYCCNTVAL_MASK          63
#define MTSACFR_CYCCNTVAL_BITNUM        0
#define MTSACFR_CYCCNTMSK_MASK          16128
#define MTSACFR_CYCCNTMSK_BITNUM        8
#define MTSACFR_MTE_MASK                32768


/*** MTSBCFR - MTS B Configuration Register; 0x00000482 ***/
typedef union {
  word Word;
  struct {
    word CYCCNTVAL   :6;                                       /* Cycle Counter Value */
    word             :1; 
    word             :1; 
    word CYCCNTMSK   :6;                                       /* Cycle Counter Mask */
    word             :1; 
    word MTE         :1;                                       /* Media Access Test Symbol Transmission Enable */
  } Bits;
} MTSBCFRSTR;
extern volatile MTSBCFRSTR _MTSBCFR @(REG_BASE + 0x00000482);
#define MTSBCFR                         _MTSBCFR.Word
#define MTSBCFR_CYCCNTVAL               _MTSBCFR.Bits.CYCCNTVAL
#define MTSBCFR_CYCCNTMSK               _MTSBCFR.Bits.CYCCNTMSK
#define MTSBCFR_MTE                     _MTSBCFR.Bits.MTE

#define MTSBCFR_CYCCNTVAL_MASK          63
#define MTSBCFR_CYCCNTVAL_BITNUM        0
#define MTSBCFR_CYCCNTMSK_MASK          16128
#define MTSBCFR_CYCCNTMSK_BITNUM        8
#define MTSBCFR_MTE_MASK                32768


/*** RSBIR - Receive Shadow Buffer Index Register; 0x00000484 ***/
typedef union {
  word Word;
  struct {
    word RSBIDX      :6;                                       /* Receive Shadow Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word SEL         :2;                                       /* Selector */
    word             :1; 
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} RSBIRSTR;
extern volatile RSBIRSTR _RSBIR @(REG_BASE + 0x00000484);
#define RSBIR                           _RSBIR.Word
#define RSBIR_RSBIDX                    _RSBIR.Bits.RSBIDX
#define RSBIR_SEL                       _RSBIR.Bits.SEL
#define RSBIR_WMD                       _RSBIR.Bits.WMD

#define RSBIR_RSBIDX_MASK               63
#define RSBIR_RSBIDX_BITNUM             0
#define RSBIR_SEL_MASK                  12288
#define RSBIR_SEL_BITNUM                12
#define RSBIR_WMD_MASK                  32768


/*** RFSR - Receive FIFO Selection Register; 0x00000486 ***/
typedef union {
  word Word;
  struct {
    word SEL         :1;                                       /* Select */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFSRSTR;
extern volatile RFSRSTR _RFSR @(REG_BASE + 0x00000486);
#define RFSR                            _RFSR.Word
#define RFSR_SEL                        _RFSR.Bits.SEL

#define RFSR_SEL_MASK                   1



/*** RFSIR - Receive FIFO Start Index Register; 0x00000488 ***/
typedef union {
  word Word;
  struct {
    word SIDX        :8;                                       /* Start Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFSIRSTR;
extern volatile RFSIRSTR _RFSIR @(REG_BASE + 0x00000488);
#define RFSIR                           _RFSIR.Word
#define RFSIR_SIDX                      _RFSIR.Bits.SIDX

#define RFSIR_SIDX_MASK                 255
#define RFSIR_SIDX_BITNUM               0



/*** RFDSR - Receive FIFO Depth and Size Register; 0x0000048A ***/
typedef union {
  word Word;
  struct {
    word ENTRY_SIZE  :7;                                       /* Entry Size */
    word             :1; 
    word FIFO_DEPTH  :8;                                       /* FIFO Depth */
  } Bits;
} RFDSRSTR;
extern volatile RFDSRSTR _RFDSR @(REG_BASE + 0x0000048A);
#define RFDSR                           _RFDSR.Word
#define RFDSR_ENTRY_SIZE                _RFDSR.Bits.ENTRY_SIZE
#define RFDSR_FIFO_DEPTH                _RFDSR.Bits.FIFO_DEPTH

#define RFDSR_ENTRY_SIZE_MASK           127
#define RFDSR_ENTRY_SIZE_BITNUM         0
#define RFDSR_FIFO_DEPTH_MASK           65280
#define RFDSR_FIFO_DEPTH_BITNUM         8



/*** RFARIR - Receive FIFO A Read Index Register; 0x0000048C ***/
typedef union {
  word Word;
  struct {
    word RDIDX       :8;                                       /* Read Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFARIRSTR;
extern volatile RFARIRSTR _RFARIR @(REG_BASE + 0x0000048C);
#define RFARIR                          _RFARIR.Word
#define RFARIR_RDIDX                    _RFARIR.Bits.RDIDX

#define RFARIR_RDIDX_MASK               255
#define RFARIR_RDIDX_BITNUM             0


/*** RFBRIR - Receive FIFO B Read Index Register; 0x0000048E ***/
typedef union {
  word Word;
  struct {
    word RDIDX       :8;                                       /* Read Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFBRIRSTR;
extern volatile RFBRIRSTR _RFBRIR @(REG_BASE + 0x0000048E);
#define RFBRIR                          _RFBRIR.Word
#define RFBRIR_RDIDX                    _RFBRIR.Bits.RDIDX

#define RFBRIR_RDIDX_MASK               255
#define RFBRIR_RDIDX_BITNUM             0


/*** RFMIDAFVR - Receive FIFO Message ID Acceptance Filter Value Register; 0x00000490 ***/
typedef union {
  word Word;
  struct {
    word MIDAFVAL    :16;                                      /* Message ID Acceptance Filter Value */
  } Bits;
} RFMIDAFVRSTR;
extern volatile RFMIDAFVRSTR _RFMIDAFVR @(REG_BASE + 0x00000490);
#define RFMIDAFVR                       _RFMIDAFVR.Word
#define RFMIDAFVR_MIDAFVAL              _RFMIDAFVR.Bits.MIDAFVAL

#define RFMIDAFVR_MIDAFVAL_MASK         65535
#define RFMIDAFVR_MIDAFVAL_BITNUM       0


/*** RFMIAFMR - Receive FIFO Message ID Acceptance Filter Mask Register; 0x00000492 ***/
typedef union {
  word Word;
  struct {
    word MIDAFMSK    :16;                                      /* Message ID Acceptance Filter Mask */
  } Bits;
} RFMIAFMRSTR;
extern volatile RFMIAFMRSTR _RFMIAFMR @(REG_BASE + 0x00000492);
#define RFMIAFMR                        _RFMIAFMR.Word
#define RFMIAFMR_MIDAFMSK               _RFMIAFMR.Bits.MIDAFMSK

#define RFMIAFMR_MIDAFMSK_MASK          65535
#define RFMIAFMR_MIDAFMSK_BITNUM        0


/*** RFFIDRFVR - Receive FIFO Frame ID Rejection Filter Value Register; 0x00000494 ***/
typedef union {
  word Word;
  struct {
    word FIDRFVAL    :11;                                      /* Frame ID Rejection Filter Value */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFFIDRFVRSTR;
extern volatile RFFIDRFVRSTR _RFFIDRFVR @(REG_BASE + 0x00000494);
#define RFFIDRFVR                       _RFFIDRFVR.Word
#define RFFIDRFVR_FIDRFVAL              _RFFIDRFVR.Bits.FIDRFVAL

#define RFFIDRFVR_FIDRFVAL_MASK         2047
#define RFFIDRFVR_FIDRFVAL_BITNUM       0


/*** RFFIDRFMR - Receive FIFO Frame ID Rejection Filter Mask Register; 0x00000496 ***/
typedef union {
  word Word;
  struct {
    word FIDRFMSK    :11;                                      /* Frame ID Rejection Filter Mask */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFFIDRFMRSTR;
extern volatile RFFIDRFMRSTR _RFFIDRFMR @(REG_BASE + 0x00000496);
#define RFFIDRFMR                       _RFFIDRFMR.Word
#define RFFIDRFMR_FIDRFMSK              _RFFIDRFMR.Bits.FIDRFMSK

#define RFFIDRFMR_FIDRFMSK_MASK         2047
#define RFFIDRFMR_FIDRFMSK_BITNUM       0


/*** RFRFCFR - Receive FIFO Range Filter Configuration Register; 0x00000498 ***/
typedef union {
  word Word;
  struct {
    word SID         :11;                                      /* Slot ID */
    word             :1; 
    word SEL         :2;                                       /* Filter Selector */
    word IBD         :1;                                       /* Interval Boundary */
    word WMD         :1;                                       /* Write Mode */
  } Bits;
} RFRFCFRSTR;
extern volatile RFRFCFRSTR _RFRFCFR @(REG_BASE + 0x00000498);
#define RFRFCFR                         _RFRFCFR.Word
#define RFRFCFR_SID                     _RFRFCFR.Bits.SID
#define RFRFCFR_SEL                     _RFRFCFR.Bits.SEL
#define RFRFCFR_IBD                     _RFRFCFR.Bits.IBD
#define RFRFCFR_WMD                     _RFRFCFR.Bits.WMD

#define RFRFCFR_SID_MASK                2047
#define RFRFCFR_SID_BITNUM              0
#define RFRFCFR_SEL_MASK                12288
#define RFRFCFR_SEL_BITNUM              12
#define RFRFCFR_IBD_MASK                16384
#define RFRFCFR_WMD_MASK                32768


/*** RFRFCTR - Receive FIFO Range Filter Control Register; 0x0000049A ***/
typedef union {
  word Word;
  struct {
    word F0EN        :1;                                       /* Range Filter 0 Enable */
    word F1EN        :1;                                       /* Range Filter 1 Enable */
    word F2EN        :1;                                       /* Range Filter 2 Enable */
    word F3EN        :1;                                       /* Range Filter 3 Enable */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word F0MD        :1;                                       /* Range Filter 0 Mode */
    word F1MD        :1;                                       /* Range Filter 1 Mode */
    word F2MD        :1;                                       /* Range Filter 2 Mode */
    word F3MD        :1;                                       /* Range Filter 3 Mode */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} RFRFCTRSTR;
extern volatile RFRFCTRSTR _RFRFCTR @(REG_BASE + 0x0000049A);
#define RFRFCTR                         _RFRFCTR.Word
#define RFRFCTR_F0EN                    _RFRFCTR.Bits.F0EN
#define RFRFCTR_F1EN                    _RFRFCTR.Bits.F1EN
#define RFRFCTR_F2EN                    _RFRFCTR.Bits.F2EN
#define RFRFCTR_F3EN                    _RFRFCTR.Bits.F3EN
#define RFRFCTR_F0MD                    _RFRFCTR.Bits.F0MD
#define RFRFCTR_F1MD                    _RFRFCTR.Bits.F1MD
#define RFRFCTR_F2MD                    _RFRFCTR.Bits.F2MD
#define RFRFCTR_F3MD                    _RFRFCTR.Bits.F3MD

#define RFRFCTR_F0EN_MASK               1
#define RFRFCTR_F1EN_MASK               2
#define RFRFCTR_F2EN_MASK               4
#define RFRFCTR_F3EN_MASK               8
#define RFRFCTR_F0MD_MASK               256
#define RFRFCTR_F1MD_MASK               512
#define RFRFCTR_F2MD_MASK               1024
#define RFRFCTR_F3MD_MASK               2048


/*** LDTXSLAR - Last Dynamic Transmit Slot Channel A Register; 0x0000049C ***/
typedef union {
  word Word;
  struct {
    word LASTDYNTXSLOTA :11;                                   /* Last Dynamic Transmission Slot Channel A */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} LDTXSLARSTR;
extern volatile LDTXSLARSTR _LDTXSLAR @(REG_BASE + 0x0000049C);
#define LDTXSLAR                        _LDTXSLAR.Word
#define LDTXSLAR_LASTDYNTXSLOTA         _LDTXSLAR.Bits.LASTDYNTXSLOTA

#define LDTXSLAR_LASTDYNTXSLOTA_MASK    2047
#define LDTXSLAR_LASTDYNTXSLOTA_BITNUM  0


/*** LDTXSLBR - Last Dynamic Transmit Slot Channel B Register; 0x0000049E ***/
typedef union {
  word Word;
  struct {
    word LASTDYNTXSLOTB :11;                                   /* Last Dynamic Transmission Slot Channel B */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} LDTXSLBRSTR;
extern volatile LDTXSLBRSTR _LDTXSLBR @(REG_BASE + 0x0000049E);
#define LDTXSLBR                        _LDTXSLBR.Word
#define LDTXSLBR_LASTDYNTXSLOTB         _LDTXSLBR.Bits.LASTDYNTXSLOTB

#define LDTXSLBR_LASTDYNTXSLOTB_MASK    2047
#define LDTXSLBR_LASTDYNTXSLOTB_BITNUM  0


/*** PCR0 - Protocol Configuration Register 0; 0x000004A0 ***/
typedef union {
  word Word;
  struct {
    word static_slot_length :10;                               /* static_slot_length */
    word action_point_offset :6;                               /* action_point_offset */
  } Bits;
} PCR0STR;
extern volatile PCR0STR _PCR0 @(REG_BASE + 0x000004A0);
#define PCR0                            _PCR0.Word
#define PCR0_static_slot_length         _PCR0.Bits.static_slot_length
#define PCR0_action_point_offset        _PCR0.Bits.action_point_offset
/* PCR_ARR: Access 31 PCRx registers in an array */
#define PCR_ARR                         ((word *) &PCR0)

#define PCR0_static_slot_length_MASK    1023
#define PCR0_static_slot_length_BITNUM  0
#define PCR0_action_point_offset_MASK   64512
#define PCR0_action_point_offset_BITNUM 10


/*** PCR1 - Protocol Configuration Register 1; 0x000004A2 ***/
typedef union {
  word Word;
  struct {
    word macro_after_first_static_slot :14;                    /* macro_after_first_static_slot */
    word filter_bypass :1;                                     /* filter_bypass */
    word             :1; 
  } Bits;
} PCR1STR;
extern volatile PCR1STR _PCR1 @(REG_BASE + 0x000004A2);
#define PCR1                            _PCR1.Word
#define PCR1_macro_after_first_static_slot _PCR1.Bits.macro_after_first_static_slot
#define PCR1_filter_bypass              _PCR1.Bits.filter_bypass

#define PCR1_macro_after_first_static_slot_MASK 16383
#define PCR1_macro_after_first_static_slot_BITNUM 0
#define PCR1_filter_bypass_MASK         16384


/*** PCR2 - Protocol Configuration Register 2; 0x000004A4 ***/
typedef union {
  word Word;
  struct {
    word number_of_static_slots :10;                           /* number_of_static_slots */
    word minislot_after_action_point :6;                       /* minislot_after_action_point */
  } Bits;
} PCR2STR;
extern volatile PCR2STR _PCR2 @(REG_BASE + 0x000004A4);
#define PCR2                            _PCR2.Word
#define PCR2_number_of_static_slots     _PCR2.Bits.number_of_static_slots
#define PCR2_minislot_after_action_point _PCR2.Bits.minislot_after_action_point

#define PCR2_number_of_static_slots_MASK 1023
#define PCR2_number_of_static_slots_BITNUM 0
#define PCR2_minislot_after_action_point_MASK 64512
#define PCR2_minislot_after_action_point_BITNUM 10


/*** PCR3 - Protocol Configuration Register 3; 0x000004A6 ***/
typedef union {
  word Word;
  struct {
    word coldstart_attempts :5;                                /* coldstart_attempts */
    word minislot_action_point_offset :5;                      /* minislot_action_point_offset[4:0] */
    word wakeup_symbol_rx_low :6;                              /* wakeup_symbol_rx_low */
  } Bits;
} PCR3STR;
extern volatile PCR3STR _PCR3 @(REG_BASE + 0x000004A6);
#define PCR3                            _PCR3.Word
#define PCR3_coldstart_attempts         _PCR3.Bits.coldstart_attempts
#define PCR3_minislot_action_point_offset _PCR3.Bits.minislot_action_point_offset
#define PCR3_wakeup_symbol_rx_low       _PCR3.Bits.wakeup_symbol_rx_low

#define PCR3_coldstart_attempts_MASK    31
#define PCR3_coldstart_attempts_BITNUM  0
#define PCR3_minislot_action_point_offset_MASK 992
#define PCR3_minislot_action_point_offset_BITNUM 5
#define PCR3_wakeup_symbol_rx_low_MASK  64512
#define PCR3_wakeup_symbol_rx_low_BITNUM 10


/*** PCR4 - Protocol Configuration Register 4; 0x000004A8 ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_rx_window :9;                           /* wakeup_symbol_rx_window */
    word cas_rx_low_max :7;                                    /* cas_rx_low_max */
  } Bits;
} PCR4STR;
extern volatile PCR4STR _PCR4 @(REG_BASE + 0x000004A8);
#define PCR4                            _PCR4.Word
#define PCR4_wakeup_symbol_rx_window    _PCR4.Bits.wakeup_symbol_rx_window
#define PCR4_cas_rx_low_max             _PCR4.Bits.cas_rx_low_max

#define PCR4_wakeup_symbol_rx_window_MASK 511
#define PCR4_wakeup_symbol_rx_window_BITNUM 0
#define PCR4_cas_rx_low_max_MASK        65024
#define PCR4_cas_rx_low_max_BITNUM      9


/*** PCR5 - Protocol Configuration Register 5; 0x000004AA ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_rx_idle :6;                             /* wakeup_symbol_rx_idle */
    word wakeup_symbol_tx_low :6;                              /* wakeup_symbol_tx_low */
    word tss_transmitter :4;                                   /* tss_transmitter */
  } Bits;
} PCR5STR;
extern volatile PCR5STR _PCR5 @(REG_BASE + 0x000004AA);
#define PCR5                            _PCR5.Word
#define PCR5_wakeup_symbol_rx_idle      _PCR5.Bits.wakeup_symbol_rx_idle
#define PCR5_wakeup_symbol_tx_low       _PCR5.Bits.wakeup_symbol_tx_low
#define PCR5_tss_transmitter            _PCR5.Bits.tss_transmitter

#define PCR5_wakeup_symbol_rx_idle_MASK 63
#define PCR5_wakeup_symbol_rx_idle_BITNUM 0
#define PCR5_wakeup_symbol_tx_low_MASK  4032
#define PCR5_wakeup_symbol_tx_low_BITNUM 6
#define PCR5_tss_transmitter_MASK       61440
#define PCR5_tss_transmitter_BITNUM     12


/*** PCR6 - Protocol Configuration Register 6; 0x000004AC ***/
typedef union {
  word Word;
  struct {
    word macro_initial_offset_a :7;                            /* macro_initial_offset_a */
    word symbol_window_after_action_point :8;                  /* symbol_window_after_action_point */
    word             :1; 
  } Bits;
} PCR6STR;
extern volatile PCR6STR _PCR6 @(REG_BASE + 0x000004AC);
#define PCR6                            _PCR6.Word
#define PCR6_macro_initial_offset_a     _PCR6.Bits.macro_initial_offset_a
#define PCR6_symbol_window_after_action_point _PCR6.Bits.symbol_window_after_action_point

#define PCR6_macro_initial_offset_a_MASK 127
#define PCR6_macro_initial_offset_a_BITNUM 0
#define PCR6_symbol_window_after_action_point_MASK 32640
#define PCR6_symbol_window_after_action_point_BITNUM 7


/*** PCR7 - Protocol Configuration Register 7; 0x000004AE ***/
typedef union {
  word Word;
  struct {
    word micro_per_macro_nom_half :7;                          /* micro_per_macro_nom_half */
    word decoding_correction_b :9;                             /* decoding_correction_b */
  } Bits;
} PCR7STR;
extern volatile PCR7STR _PCR7 @(REG_BASE + 0x000004AE);
#define PCR7                            _PCR7.Word
#define PCR7_micro_per_macro_nom_half   _PCR7.Bits.micro_per_macro_nom_half
#define PCR7_decoding_correction_b      _PCR7.Bits.decoding_correction_b

#define PCR7_micro_per_macro_nom_half_MASK 127
#define PCR7_micro_per_macro_nom_half_BITNUM 0
#define PCR7_decoding_correction_b_MASK 65408
#define PCR7_decoding_correction_b_BITNUM 7


/*** PCR8 - Protocol Configuration Register 8; 0x000004B0 ***/
typedef union {
  word Word;
  struct {
    word wakeup_symbol_tx_idle :8;                             /* wakeup_symbol_tx_idle */
    word max_without_clock_correction_passive :4;              /* max_without_clock_correction_passive */
    word max_without_clock_correction_fatal :4;                /* max_without_clock_correction_fatal */
  } Bits;
} PCR8STR;
extern volatile PCR8STR _PCR8 @(REG_BASE + 0x000004B0);
#define PCR8                            _PCR8.Word
#define PCR8_wakeup_symbol_tx_idle      _PCR8.Bits.wakeup_symbol_tx_idle
#define PCR8_max_without_clock_correction_passive _PCR8.Bits.max_without_clock_correction_passive
#define PCR8_max_without_clock_correction_fatal _PCR8.Bits.max_without_clock_correction_fatal

#define PCR8_wakeup_symbol_tx_idle_MASK 255
#define PCR8_wakeup_symbol_tx_idle_BITNUM 0
#define PCR8_max_without_clock_correction_passive_MASK 3840
#define PCR8_max_without_clock_correction_passive_BITNUM 8
#define PCR8_max_without_clock_correction_fatal_MASK 61440
#define PCR8_max_without_clock_correction_fatal_BITNUM 12


/*** PCR9 - Protocol Configuration Register 9; 0x000004B2 ***/
typedef union {
  word Word;
  struct {
    word offset_correction_out :14;                            /* offset_correction_out */
    word symbol_window_exists :1;                              /* symbol_window_exists */
    word minislot_exists :1;                                   /* minislot_exists */
  } Bits;
} PCR9STR;
extern volatile PCR9STR _PCR9 @(REG_BASE + 0x000004B2);
#define PCR9                            _PCR9.Word
#define PCR9_offset_correction_out      _PCR9.Bits.offset_correction_out
#define PCR9_symbol_window_exists       _PCR9.Bits.symbol_window_exists
#define PCR9_minislot_exists            _PCR9.Bits.minislot_exists

#define PCR9_offset_correction_out_MASK 16383
#define PCR9_offset_correction_out_BITNUM 0
#define PCR9_symbol_window_exists_MASK  16384
#define PCR9_minislot_exists_MASK       32768


/*** PCR10 - Protocol Configuration Register 10; 0x000004B4 ***/
typedef union {
  word Word;
  struct {
    word macro_per_cycle :14;                                  /* macro_per_cycle */
    word wakeup_channel :1;                                    /* wakeup_channel */
    word single_slot_enabled :1;                               /* single_slot_enabled */
  } Bits;
} PCR10STR;
extern volatile PCR10STR _PCR10 @(REG_BASE + 0x000004B4);
#define PCR10                           _PCR10.Word
#define PCR10_macro_per_cycle           _PCR10.Bits.macro_per_cycle
#define PCR10_wakeup_channel            _PCR10.Bits.wakeup_channel
#define PCR10_single_slot_enabled       _PCR10.Bits.single_slot_enabled

#define PCR10_macro_per_cycle_MASK      16383
#define PCR10_macro_per_cycle_BITNUM    0
#define PCR10_wakeup_channel_MASK       16384
#define PCR10_single_slot_enabled_MASK  32768


/*** PCR11 - Protocol Configuration Register 11; 0x000004B6 ***/
typedef union {
  word Word;
  struct {
    word offset_correction_start :14;                          /* offset_correction_start */
    word key_slot_used_for_sync :1;                            /* key_slot_used_for_sync */
    word key_slot_used_for_startup :1;                         /* key_slot_used_for_startup */
  } Bits;
} PCR11STR;
extern volatile PCR11STR _PCR11 @(REG_BASE + 0x000004B6);
#define PCR11                           _PCR11.Word
#define PCR11_offset_correction_start   _PCR11.Bits.offset_correction_start
#define PCR11_key_slot_used_for_sync    _PCR11.Bits.key_slot_used_for_sync
#define PCR11_key_slot_used_for_startup _PCR11.Bits.key_slot_used_for_startup

#define PCR11_offset_correction_start_MASK 16383
#define PCR11_offset_correction_start_BITNUM 0
#define PCR11_key_slot_used_for_sync_MASK 16384
#define PCR11_key_slot_used_for_startup_MASK 32768


/*** PCR12 - Protocol Configuration Register 12; 0x000004B8 ***/
typedef union {
  word Word;
  struct {
    word key_slot_header_crc :11;                              /* key_slot_header_crc */
    word allow_passive_to_active :5;                           /* allow_passive_to_active */
  } Bits;
} PCR12STR;
extern volatile PCR12STR _PCR12 @(REG_BASE + 0x000004B8);
#define PCR12                           _PCR12.Word
#define PCR12_key_slot_header_crc       _PCR12.Bits.key_slot_header_crc
#define PCR12_allow_passive_to_active   _PCR12.Bits.allow_passive_to_active

#define PCR12_key_slot_header_crc_MASK  2047
#define PCR12_key_slot_header_crc_BITNUM 0
#define PCR12_allow_passive_to_active_MASK 63488
#define PCR12_allow_passive_to_active_BITNUM 11


/*** PCR13 - Protocol Configuration Register 13; 0x000004BA ***/
typedef union {
  word Word;
  struct {
    word static_slot_after_action_point :10;                   /* static_slot_after_action_point */
    word first_minislot_action_point_offset :6;                /* first_minislot_action_point_offset */
  } Bits;
} PCR13STR;
extern volatile PCR13STR _PCR13 @(REG_BASE + 0x000004BA);
#define PCR13                           _PCR13.Word
#define PCR13_static_slot_after_action_point _PCR13.Bits.static_slot_after_action_point
#define PCR13_first_minislot_action_point_offset _PCR13.Bits.first_minislot_action_point_offset

#define PCR13_static_slot_after_action_point_MASK 1023
#define PCR13_static_slot_after_action_point_BITNUM 0
#define PCR13_first_minislot_action_point_offset_MASK 64512
#define PCR13_first_minislot_action_point_offset_BITNUM 10


/*** PCR14 - Protocol Configuration Register 14; 0x000004BC ***/
typedef union {
  word Word;
  struct {
    word listen_timeout :5;                                    /* listen_timeout[20:16] */
    word rate_correction_out :11;                              /* rate_correction_out */
  } Bits;
} PCR14STR;
extern volatile PCR14STR _PCR14 @(REG_BASE + 0x000004BC);
#define PCR14                           _PCR14.Word
#define PCR14_listen_timeout            _PCR14.Bits.listen_timeout
#define PCR14_rate_correction_out       _PCR14.Bits.rate_correction_out

#define PCR14_listen_timeout_MASK       31
#define PCR14_listen_timeout_BITNUM     0
#define PCR14_rate_correction_out_MASK  65504
#define PCR14_rate_correction_out_BITNUM 5


/*** PCR15 - Protocol Configuration Register 15; 0x000004BE ***/
typedef union {
  word Word;
  struct {
    word listen_timeout :16;                                   /* listen_timeout[15:0] */
  } Bits;
} PCR15STR;
extern volatile PCR15STR _PCR15 @(REG_BASE + 0x000004BE);
#define PCR15                           _PCR15.Word
#define PCR15_listen_timeout            _PCR15.Bits.listen_timeout

#define PCR15_listen_timeout_MASK       65535
#define PCR15_listen_timeout_BITNUM     0


/*** PCR16 - Protocol Configuration Register 16; 0x000004C0 ***/
typedef union {
  word Word;
  struct {
    word noise_listen_timeout :9;                              /* noise_listen_timeout[24:16] */
    word macro_initial_offset_b :7;                            /* macro_initial_offset_b */
  } Bits;
} PCR16STR;
extern volatile PCR16STR _PCR16 @(REG_BASE + 0x000004C0);
#define PCR16                           _PCR16.Word
#define PCR16_noise_listen_timeout      _PCR16.Bits.noise_listen_timeout
#define PCR16_macro_initial_offset_b    _PCR16.Bits.macro_initial_offset_b

#define PCR16_noise_listen_timeout_MASK 511
#define PCR16_noise_listen_timeout_BITNUM 0
#define PCR16_macro_initial_offset_b_MASK 65024
#define PCR16_macro_initial_offset_b_BITNUM 9


/*** PCR17 - Protocol Configuration Register 17; 0x000004C2 ***/
typedef union {
  word Word;
  struct {
    word noise_listen_timeout :16;                             /* noise_listen_timeout[15:0] */
  } Bits;
} PCR17STR;
extern volatile PCR17STR _PCR17 @(REG_BASE + 0x000004C2);
#define PCR17                           _PCR17.Word
#define PCR17_noise_listen_timeout      _PCR17.Bits.noise_listen_timeout

#define PCR17_noise_listen_timeout_MASK 65535
#define PCR17_noise_listen_timeout_BITNUM 0


/*** PCR18 - Protocol Configuration Register 18; 0x000004C4 ***/
typedef union {
  word Word;
  struct {
    word key_slot_id :10;                                      /* key_slot_id */
    word wakeup_pattern :6;                                    /* wakeup_pattern */
  } Bits;
} PCR18STR;
extern volatile PCR18STR _PCR18 @(REG_BASE + 0x000004C4);
#define PCR18                           _PCR18.Word
#define PCR18_key_slot_id               _PCR18.Bits.key_slot_id
#define PCR18_wakeup_pattern            _PCR18.Bits.wakeup_pattern

#define PCR18_key_slot_id_MASK          1023
#define PCR18_key_slot_id_BITNUM        0
#define PCR18_wakeup_pattern_MASK       64512
#define PCR18_wakeup_pattern_BITNUM     10


/*** PCR19 - Protocol Configuration Register 19; 0x000004C6 ***/
typedef union {
  word Word;
  struct {
    word payload_length_static :7;                             /* payload_length_static */
    word decoding_correction_a :9;                             /* decoding_correction_a */
  } Bits;
} PCR19STR;
extern volatile PCR19STR _PCR19 @(REG_BASE + 0x000004C6);
#define PCR19                           _PCR19.Word
#define PCR19_payload_length_static     _PCR19.Bits.payload_length_static
#define PCR19_decoding_correction_a     _PCR19.Bits.decoding_correction_a

#define PCR19_payload_length_static_MASK 127
#define PCR19_payload_length_static_BITNUM 0
#define PCR19_decoding_correction_a_MASK 65408
#define PCR19_decoding_correction_a_BITNUM 7


/*** PCR20 - Protocol Configuration Register 20; 0x000004C8 ***/
typedef union {
  word Word;
  struct {
    word micro_initial_offset_a :8;                            /* micro_initial_offset_a */
    word micro_initial_offset_b :8;                            /* micro_initial_offset_b */
  } Bits;
} PCR20STR;
extern volatile PCR20STR _PCR20 @(REG_BASE + 0x000004C8);
#define PCR20                           _PCR20.Word
#define PCR20_micro_initial_offset_a    _PCR20.Bits.micro_initial_offset_a
#define PCR20_micro_initial_offset_b    _PCR20.Bits.micro_initial_offset_b

#define PCR20_micro_initial_offset_a_MASK 255
#define PCR20_micro_initial_offset_a_BITNUM 0
#define PCR20_micro_initial_offset_b_MASK 65280
#define PCR20_micro_initial_offset_b_BITNUM 8


/*** PCR21 - Protocol Configuration Register 21; 0x000004CA ***/
typedef union {
  word Word;
  struct {
    word latest_tx   :13;                                      /* latest_tx */
    word extern_rate_correction :3;                            /* extern_rate_correction */
  } Bits;
} PCR21STR;
extern volatile PCR21STR _PCR21 @(REG_BASE + 0x000004CA);
#define PCR21                           _PCR21.Word
#define PCR21_latest_tx                 _PCR21.Bits.latest_tx
#define PCR21_extern_rate_correction    _PCR21.Bits.extern_rate_correction

#define PCR21_latest_tx_MASK            8191
#define PCR21_latest_tx_BITNUM          0
#define PCR21_extern_rate_correction_MASK 57344
#define PCR21_extern_rate_correction_BITNUM 13


/*** PCR22 - Protocol Configuration Register 22; 0x000004CC ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle :4;                                   /* micro_per_cycle[19:16] */
    word comp_accepted_startup_range_a :11;                    /* comp_accepted_startup_range_a */
    word             :1; 
  } Bits;
} PCR22STR;
extern volatile PCR22STR _PCR22 @(REG_BASE + 0x000004CC);
#define PCR22                           _PCR22.Word
#define PCR22_micro_per_cycle           _PCR22.Bits.micro_per_cycle
#define PCR22_comp_accepted_startup_range_a _PCR22.Bits.comp_accepted_startup_range_a

#define PCR22_micro_per_cycle_MASK      15
#define PCR22_micro_per_cycle_BITNUM    0
#define PCR22_comp_accepted_startup_range_a_MASK 32752
#define PCR22_comp_accepted_startup_range_a_BITNUM 4


/*** PCR23 - Protocol Configuration Register 23; 0x000004CE ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle :16;                                  /* micro_per_cycle[15:0] */
  } Bits;
} PCR23STR;
extern volatile PCR23STR _PCR23 @(REG_BASE + 0x000004CE);
#define PCR23                           _PCR23.Word
#define PCR23_micro_per_cycle           _PCR23.Bits.micro_per_cycle

#define PCR23_micro_per_cycle_MASK      65535
#define PCR23_micro_per_cycle_BITNUM    0


/*** PCR24 - Protocol Configuration Register 24; 0x000004D0 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_min :4;                               /* micro_per_cycle_min[19:16] */
    word max_payload_length_dynamic :7;                        /* max_payload_length_dynamic */
    word cluster_drift_damping :5;                             /* cluster_drift_damping */
  } Bits;
} PCR24STR;
extern volatile PCR24STR _PCR24 @(REG_BASE + 0x000004D0);
#define PCR24                           _PCR24.Word
#define PCR24_micro_per_cycle_min       _PCR24.Bits.micro_per_cycle_min
#define PCR24_max_payload_length_dynamic _PCR24.Bits.max_payload_length_dynamic
#define PCR24_cluster_drift_damping     _PCR24.Bits.cluster_drift_damping

#define PCR24_micro_per_cycle_min_MASK  15
#define PCR24_micro_per_cycle_min_BITNUM 0
#define PCR24_max_payload_length_dynamic_MASK 2032
#define PCR24_max_payload_length_dynamic_BITNUM 4
#define PCR24_cluster_drift_damping_MASK 63488
#define PCR24_cluster_drift_damping_BITNUM 11


/*** PCR25 - Protocol Configuration Register 25; 0x000004D2 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_min :16;                              /* micro_per_cycle_min[15:0] */
  } Bits;
} PCR25STR;
extern volatile PCR25STR _PCR25 @(REG_BASE + 0x000004D2);
#define PCR25                           _PCR25.Word
#define PCR25_micro_per_cycle_min       _PCR25.Bits.micro_per_cycle_min

#define PCR25_micro_per_cycle_min_MASK  65535
#define PCR25_micro_per_cycle_min_BITNUM 0


/*** PCR26 - Protocol Configuration Register 26; 0x000004D4 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_max :4;                               /* micro_per_cycle_max[19:16] */
    word comp_accepted_startup_range_b :11;                    /* comp_accepted_startup_range_b */
    word allow_halt_due_to_clock :1;                           /* allow_halt_due_to_clock */
  } Bits;
} PCR26STR;
extern volatile PCR26STR _PCR26 @(REG_BASE + 0x000004D4);
#define PCR26                           _PCR26.Word
#define PCR26_micro_per_cycle_max       _PCR26.Bits.micro_per_cycle_max
#define PCR26_comp_accepted_startup_range_b _PCR26.Bits.comp_accepted_startup_range_b
#define PCR26_allow_halt_due_to_clock   _PCR26.Bits.allow_halt_due_to_clock

#define PCR26_micro_per_cycle_max_MASK  15
#define PCR26_micro_per_cycle_max_BITNUM 0
#define PCR26_comp_accepted_startup_range_b_MASK 32752
#define PCR26_comp_accepted_startup_range_b_BITNUM 4
#define PCR26_allow_halt_due_to_clock_MASK 32768


/*** PCR27 - Protocol Configuration Register 27; 0x000004D6 ***/
typedef union {
  word Word;
  struct {
    word micro_per_cycle_max :16;                              /* micro_per_cycle_max[15:0] */
  } Bits;
} PCR27STR;
extern volatile PCR27STR _PCR27 @(REG_BASE + 0x000004D6);
#define PCR27                           _PCR27.Word
#define PCR27_micro_per_cycle_max       _PCR27.Bits.micro_per_cycle_max

#define PCR27_micro_per_cycle_max_MASK  65535
#define PCR27_micro_per_cycle_max_BITNUM 0


/*** PCR28 - Protocol Configuration Register 28; 0x000004D8 ***/
typedef union {
  word Word;
  struct {
    word macro_after_offset_correction :14;                    /* macro_after_offset_correction */
    word dynamic_slot_idle_phase :2;                           /* dynamic_slot_idle_phase */
  } Bits;
} PCR28STR;
extern volatile PCR28STR _PCR28 @(REG_BASE + 0x000004D8);
#define PCR28                           _PCR28.Word
#define PCR28_macro_after_offset_correction _PCR28.Bits.macro_after_offset_correction
#define PCR28_dynamic_slot_idle_phase   _PCR28.Bits.dynamic_slot_idle_phase

#define PCR28_macro_after_offset_correction_MASK 16383
#define PCR28_macro_after_offset_correction_BITNUM 0
#define PCR28_dynamic_slot_idle_phase_MASK 49152
#define PCR28_dynamic_slot_idle_phase_BITNUM 14


/*** PCR29 - Protocol Configuration Register 29; 0x000004DA ***/
typedef union {
  word Word;
  struct {
    word minislots_max :13;                                    /* minislots_max */
    word extern_offset_correction :3;                          /* extern_offset_correction */
  } Bits;
} PCR29STR;
extern volatile PCR29STR _PCR29 @(REG_BASE + 0x000004DA);
#define PCR29                           _PCR29.Word
#define PCR29_minislots_max             _PCR29.Bits.minislots_max
#define PCR29_extern_offset_correction  _PCR29.Bits.extern_offset_correction

#define PCR29_minislots_max_MASK        8191
#define PCR29_minislots_max_BITNUM      0
#define PCR29_extern_offset_correction_MASK 57344
#define PCR29_extern_offset_correction_BITNUM 13


/*** PCR30 - Protocol Configuration Register 30; 0x000004DC ***/
typedef union {
  word Word;
  struct {
    word sync_node_max :4;                                     /* sync_node_max */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} PCR30STR;
extern volatile PCR30STR _PCR30 @(REG_BASE + 0x000004DC);
#define PCR30                           _PCR30.Word
#define PCR30_sync_node_max             _PCR30.Bits.sync_node_max

#define PCR30_sync_node_max_MASK        15
#define PCR30_sync_node_max_BITNUM      0



/*** MBCCSR0 - Message Buffer Configuration, Control, Status Register 0; 0x00000500 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR0STR;
extern volatile MBCCSR0STR _MBCCSR0 @(REG_BASE + 0x00000500);
#define MBCCSR0                         _MBCCSR0.Word
#define MBCCSR0_MBIF                    _MBCCSR0.Bits.MBIF
#define MBCCSR0_LCKS                    _MBCCSR0.Bits.LCKS
#define MBCCSR0_EDS                     _MBCCSR0.Bits.EDS
#define MBCCSR0_DVAL                    _MBCCSR0.Bits.DVAL
#define MBCCSR0_DUP                     _MBCCSR0.Bits.DUP
#define MBCCSR0_MBIE                    _MBCCSR0.Bits.MBIE
#define MBCCSR0_LCKT                    _MBCCSR0.Bits.LCKT
#define MBCCSR0_EDT                     _MBCCSR0.Bits.EDT
#define MBCCSR0_CMT                     _MBCCSR0.Bits.CMT
#define MBCCSR0_MTD                     _MBCCSR0.Bits.MTD
#define MBCCSR0_MBT                     _MBCCSR0.Bits.MBT
#define MBCCSR0_MCM                     _MBCCSR0.Bits.MCM

#define MBCCSR0_MBIF_MASK               1
#define MBCCSR0_LCKS_MASK               2
#define MBCCSR0_EDS_MASK                4
#define MBCCSR0_DVAL_MASK               8
#define MBCCSR0_DUP_MASK                16
#define MBCCSR0_MBIE_MASK               256
#define MBCCSR0_LCKT_MASK               512
#define MBCCSR0_EDT_MASK                1024
#define MBCCSR0_CMT_MASK                2048
#define MBCCSR0_MTD_MASK                4096
#define MBCCSR0_MBT_MASK                8192
#define MBCCSR0_MCM_MASK                16384


/*** MBCCFR0 - Message Buffer Cycle Counter Filter Register 1; 0x00000502 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR0STR;
extern volatile MBCCFR0STR _MBCCFR0 @(REG_BASE + 0x00000502);
#define MBCCFR0                         _MBCCFR0.Word
#define MBCCFR0_CCFVAL                  _MBCCFR0.Bits.CCFVAL
#define MBCCFR0_CCFMSK                  _MBCCFR0.Bits.CCFMSK
#define MBCCFR0_CCFE                    _MBCCFR0.Bits.CCFE
#define MBCCFR0_CHB                     _MBCCFR0.Bits.CHB
#define MBCCFR0_CHA                     _MBCCFR0.Bits.CHA
#define MBCCFR0_MTM                     _MBCCFR0.Bits.MTM

#define MBCCFR0_CCFVAL_MASK             63
#define MBCCFR0_CCFVAL_BITNUM           0
#define MBCCFR0_CCFMSK_MASK             4032
#define MBCCFR0_CCFMSK_BITNUM           6
#define MBCCFR0_CCFE_MASK               4096
#define MBCCFR0_CHB_MASK                8192
#define MBCCFR0_CHA_MASK                16384
#define MBCCFR0_MTM_MASK                32768


/*** MBFIDR0 - Message Buffer Frame ID Registers; 0x00000504 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR0STR;
extern volatile MBFIDR0STR _MBFIDR0 @(REG_BASE + 0x00000504);
#define MBFIDR0                         _MBFIDR0.Word
#define MBFIDR0_FID                     _MBFIDR0.Bits.FID

#define MBFIDR0_FID_MASK                2047
#define MBFIDR0_FID_BITNUM              0


/*** MBIDXR0 - Message Buffer Index Register; 0x00000506 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR0STR;
extern volatile MBIDXR0STR _MBIDXR0 @(REG_BASE + 0x00000506);
#define MBIDXR0                         _MBIDXR0.Word
#define MBIDXR0_MBIDX                   _MBIDXR0.Bits.MBIDX

#define MBIDXR0_MBIDX_MASK              63
#define MBIDXR0_MBIDX_BITNUM            0


/*** MBCCSR1 - Message Buffer Configuration, Control, Status Register 1; 0x00000508 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR1STR;
extern volatile MBCCSR1STR _MBCCSR1 @(REG_BASE + 0x00000508);
#define MBCCSR1                         _MBCCSR1.Word
#define MBCCSR1_MBIF                    _MBCCSR1.Bits.MBIF
#define MBCCSR1_LCKS                    _MBCCSR1.Bits.LCKS
#define MBCCSR1_EDS                     _MBCCSR1.Bits.EDS
#define MBCCSR1_DVAL                    _MBCCSR1.Bits.DVAL
#define MBCCSR1_DUP                     _MBCCSR1.Bits.DUP
#define MBCCSR1_MBIE                    _MBCCSR1.Bits.MBIE
#define MBCCSR1_LCKT                    _MBCCSR1.Bits.LCKT
#define MBCCSR1_EDT                     _MBCCSR1.Bits.EDT
#define MBCCSR1_CMT                     _MBCCSR1.Bits.CMT
#define MBCCSR1_MTD                     _MBCCSR1.Bits.MTD
#define MBCCSR1_MBT                     _MBCCSR1.Bits.MBT
#define MBCCSR1_MCM                     _MBCCSR1.Bits.MCM

#define MBCCSR1_MBIF_MASK               1
#define MBCCSR1_LCKS_MASK               2
#define MBCCSR1_EDS_MASK                4
#define MBCCSR1_DVAL_MASK               8
#define MBCCSR1_DUP_MASK                16
#define MBCCSR1_MBIE_MASK               256
#define MBCCSR1_LCKT_MASK               512
#define MBCCSR1_EDT_MASK                1024
#define MBCCSR1_CMT_MASK                2048
#define MBCCSR1_MTD_MASK                4096
#define MBCCSR1_MBT_MASK                8192
#define MBCCSR1_MCM_MASK                16384


/*** MBCCFR1 - Message Buffer Cycle Counter Filter Register 1; 0x0000050A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR1STR;
extern volatile MBCCFR1STR _MBCCFR1 @(REG_BASE + 0x0000050A);
#define MBCCFR1                         _MBCCFR1.Word
#define MBCCFR1_CCFVAL                  _MBCCFR1.Bits.CCFVAL
#define MBCCFR1_CCFMSK                  _MBCCFR1.Bits.CCFMSK
#define MBCCFR1_CCFE                    _MBCCFR1.Bits.CCFE
#define MBCCFR1_CHB                     _MBCCFR1.Bits.CHB
#define MBCCFR1_CHA                     _MBCCFR1.Bits.CHA
#define MBCCFR1_MTM                     _MBCCFR1.Bits.MTM

#define MBCCFR1_CCFVAL_MASK             63
#define MBCCFR1_CCFVAL_BITNUM           0
#define MBCCFR1_CCFMSK_MASK             4032
#define MBCCFR1_CCFMSK_BITNUM           6
#define MBCCFR1_CCFE_MASK               4096
#define MBCCFR1_CHB_MASK                8192
#define MBCCFR1_CHA_MASK                16384
#define MBCCFR1_MTM_MASK                32768


/*** MBFIDR1 - Message Buffer Frame ID Registers; 0x0000050C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR1STR;
extern volatile MBFIDR1STR _MBFIDR1 @(REG_BASE + 0x0000050C);
#define MBFIDR1                         _MBFIDR1.Word
#define MBFIDR1_FID                     _MBFIDR1.Bits.FID

#define MBFIDR1_FID_MASK                2047
#define MBFIDR1_FID_BITNUM              0


/*** MBIDXR1 - Message Buffer Index Register; 0x0000050E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR1STR;
extern volatile MBIDXR1STR _MBIDXR1 @(REG_BASE + 0x0000050E);
#define MBIDXR1                         _MBIDXR1.Word
#define MBIDXR1_MBIDX                   _MBIDXR1.Bits.MBIDX

#define MBIDXR1_MBIDX_MASK              63
#define MBIDXR1_MBIDX_BITNUM            0


/*** MBCCSR2 - Message Buffer Configuration, Control, Status Register 2; 0x00000510 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR2STR;
extern volatile MBCCSR2STR _MBCCSR2 @(REG_BASE + 0x00000510);
#define MBCCSR2                         _MBCCSR2.Word
#define MBCCSR2_MBIF                    _MBCCSR2.Bits.MBIF
#define MBCCSR2_LCKS                    _MBCCSR2.Bits.LCKS
#define MBCCSR2_EDS                     _MBCCSR2.Bits.EDS
#define MBCCSR2_DVAL                    _MBCCSR2.Bits.DVAL
#define MBCCSR2_DUP                     _MBCCSR2.Bits.DUP
#define MBCCSR2_MBIE                    _MBCCSR2.Bits.MBIE
#define MBCCSR2_LCKT                    _MBCCSR2.Bits.LCKT
#define MBCCSR2_EDT                     _MBCCSR2.Bits.EDT
#define MBCCSR2_CMT                     _MBCCSR2.Bits.CMT
#define MBCCSR2_MTD                     _MBCCSR2.Bits.MTD
#define MBCCSR2_MBT                     _MBCCSR2.Bits.MBT
#define MBCCSR2_MCM                     _MBCCSR2.Bits.MCM

#define MBCCSR2_MBIF_MASK               1
#define MBCCSR2_LCKS_MASK               2
#define MBCCSR2_EDS_MASK                4
#define MBCCSR2_DVAL_MASK               8
#define MBCCSR2_DUP_MASK                16
#define MBCCSR2_MBIE_MASK               256
#define MBCCSR2_LCKT_MASK               512
#define MBCCSR2_EDT_MASK                1024
#define MBCCSR2_CMT_MASK                2048
#define MBCCSR2_MTD_MASK                4096
#define MBCCSR2_MBT_MASK                8192
#define MBCCSR2_MCM_MASK                16384


/*** MBCCFR2 - Message Buffer Cycle Counter Filter Register 2; 0x00000512 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR2STR;
extern volatile MBCCFR2STR _MBCCFR2 @(REG_BASE + 0x00000512);
#define MBCCFR2                         _MBCCFR2.Word
#define MBCCFR2_CCFVAL                  _MBCCFR2.Bits.CCFVAL
#define MBCCFR2_CCFMSK                  _MBCCFR2.Bits.CCFMSK
#define MBCCFR2_CCFE                    _MBCCFR2.Bits.CCFE
#define MBCCFR2_CHB                     _MBCCFR2.Bits.CHB
#define MBCCFR2_CHA                     _MBCCFR2.Bits.CHA
#define MBCCFR2_MTM                     _MBCCFR2.Bits.MTM

#define MBCCFR2_CCFVAL_MASK             63
#define MBCCFR2_CCFVAL_BITNUM           0
#define MBCCFR2_CCFMSK_MASK             4032
#define MBCCFR2_CCFMSK_BITNUM           6
#define MBCCFR2_CCFE_MASK               4096
#define MBCCFR2_CHB_MASK                8192
#define MBCCFR2_CHA_MASK                16384
#define MBCCFR2_MTM_MASK                32768


/*** MBFIDR2 - Message Buffer Frame ID Registers; 0x00000514 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR2STR;
extern volatile MBFIDR2STR _MBFIDR2 @(REG_BASE + 0x00000514);
#define MBFIDR2                         _MBFIDR2.Word
#define MBFIDR2_FID                     _MBFIDR2.Bits.FID

#define MBFIDR2_FID_MASK                2047
#define MBFIDR2_FID_BITNUM              0


/*** MBIDXR2 - Message Buffer Index Register; 0x00000516 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR2STR;
extern volatile MBIDXR2STR _MBIDXR2 @(REG_BASE + 0x00000516);
#define MBIDXR2                         _MBIDXR2.Word
#define MBIDXR2_MBIDX                   _MBIDXR2.Bits.MBIDX

#define MBIDXR2_MBIDX_MASK              63
#define MBIDXR2_MBIDX_BITNUM            0


/*** MBCCSR3 - Message Buffer Configuration, Control, Status Register 3; 0x00000518 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR3STR;
extern volatile MBCCSR3STR _MBCCSR3 @(REG_BASE + 0x00000518);
#define MBCCSR3                         _MBCCSR3.Word
#define MBCCSR3_MBIF                    _MBCCSR3.Bits.MBIF
#define MBCCSR3_LCKS                    _MBCCSR3.Bits.LCKS
#define MBCCSR3_EDS                     _MBCCSR3.Bits.EDS
#define MBCCSR3_DVAL                    _MBCCSR3.Bits.DVAL
#define MBCCSR3_DUP                     _MBCCSR3.Bits.DUP
#define MBCCSR3_MBIE                    _MBCCSR3.Bits.MBIE
#define MBCCSR3_LCKT                    _MBCCSR3.Bits.LCKT
#define MBCCSR3_EDT                     _MBCCSR3.Bits.EDT
#define MBCCSR3_CMT                     _MBCCSR3.Bits.CMT
#define MBCCSR3_MTD                     _MBCCSR3.Bits.MTD
#define MBCCSR3_MBT                     _MBCCSR3.Bits.MBT
#define MBCCSR3_MCM                     _MBCCSR3.Bits.MCM

#define MBCCSR3_MBIF_MASK               1
#define MBCCSR3_LCKS_MASK               2
#define MBCCSR3_EDS_MASK                4
#define MBCCSR3_DVAL_MASK               8
#define MBCCSR3_DUP_MASK                16
#define MBCCSR3_MBIE_MASK               256
#define MBCCSR3_LCKT_MASK               512
#define MBCCSR3_EDT_MASK                1024
#define MBCCSR3_CMT_MASK                2048
#define MBCCSR3_MTD_MASK                4096
#define MBCCSR3_MBT_MASK                8192
#define MBCCSR3_MCM_MASK                16384


/*** MBCCFR3 - Message Buffer Cycle Counter Filter Register 3; 0x0000051A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR3STR;
extern volatile MBCCFR3STR _MBCCFR3 @(REG_BASE + 0x0000051A);
#define MBCCFR3                         _MBCCFR3.Word
#define MBCCFR3_CCFVAL                  _MBCCFR3.Bits.CCFVAL
#define MBCCFR3_CCFMSK                  _MBCCFR3.Bits.CCFMSK
#define MBCCFR3_CCFE                    _MBCCFR3.Bits.CCFE
#define MBCCFR3_CHB                     _MBCCFR3.Bits.CHB
#define MBCCFR3_CHA                     _MBCCFR3.Bits.CHA
#define MBCCFR3_MTM                     _MBCCFR3.Bits.MTM

#define MBCCFR3_CCFVAL_MASK             63
#define MBCCFR3_CCFVAL_BITNUM           0
#define MBCCFR3_CCFMSK_MASK             4032
#define MBCCFR3_CCFMSK_BITNUM           6
#define MBCCFR3_CCFE_MASK               4096
#define MBCCFR3_CHB_MASK                8192
#define MBCCFR3_CHA_MASK                16384
#define MBCCFR3_MTM_MASK                32768


/*** MBFIDR3 - Message Buffer Frame ID Registers; 0x0000051C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR3STR;
extern volatile MBFIDR3STR _MBFIDR3 @(REG_BASE + 0x0000051C);
#define MBFIDR3                         _MBFIDR3.Word
#define MBFIDR3_FID                     _MBFIDR3.Bits.FID

#define MBFIDR3_FID_MASK                2047
#define MBFIDR3_FID_BITNUM              0


/*** MBIDXR3 - Message Buffer Index Register; 0x0000051E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR3STR;
extern volatile MBIDXR3STR _MBIDXR3 @(REG_BASE + 0x0000051E);
#define MBIDXR3                         _MBIDXR3.Word
#define MBIDXR3_MBIDX                   _MBIDXR3.Bits.MBIDX

#define MBIDXR3_MBIDX_MASK              63
#define MBIDXR3_MBIDX_BITNUM            0


/*** MBCCSR4 - Message Buffer Configuration, Control, Status Register 4; 0x00000520 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR4STR;
extern volatile MBCCSR4STR _MBCCSR4 @(REG_BASE + 0x00000520);
#define MBCCSR4                         _MBCCSR4.Word
#define MBCCSR4_MBIF                    _MBCCSR4.Bits.MBIF
#define MBCCSR4_LCKS                    _MBCCSR4.Bits.LCKS
#define MBCCSR4_EDS                     _MBCCSR4.Bits.EDS
#define MBCCSR4_DVAL                    _MBCCSR4.Bits.DVAL
#define MBCCSR4_DUP                     _MBCCSR4.Bits.DUP
#define MBCCSR4_MBIE                    _MBCCSR4.Bits.MBIE
#define MBCCSR4_LCKT                    _MBCCSR4.Bits.LCKT
#define MBCCSR4_EDT                     _MBCCSR4.Bits.EDT
#define MBCCSR4_CMT                     _MBCCSR4.Bits.CMT
#define MBCCSR4_MTD                     _MBCCSR4.Bits.MTD
#define MBCCSR4_MBT                     _MBCCSR4.Bits.MBT
#define MBCCSR4_MCM                     _MBCCSR4.Bits.MCM

#define MBCCSR4_MBIF_MASK               1
#define MBCCSR4_LCKS_MASK               2
#define MBCCSR4_EDS_MASK                4
#define MBCCSR4_DVAL_MASK               8
#define MBCCSR4_DUP_MASK                16
#define MBCCSR4_MBIE_MASK               256
#define MBCCSR4_LCKT_MASK               512
#define MBCCSR4_EDT_MASK                1024
#define MBCCSR4_CMT_MASK                2048
#define MBCCSR4_MTD_MASK                4096
#define MBCCSR4_MBT_MASK                8192
#define MBCCSR4_MCM_MASK                16384


/*** MBCCFR4 - Message Buffer Cycle Counter Filter Register 4; 0x00000522 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR4STR;
extern volatile MBCCFR4STR _MBCCFR4 @(REG_BASE + 0x00000522);
#define MBCCFR4                         _MBCCFR4.Word
#define MBCCFR4_CCFVAL                  _MBCCFR4.Bits.CCFVAL
#define MBCCFR4_CCFMSK                  _MBCCFR4.Bits.CCFMSK
#define MBCCFR4_CCFE                    _MBCCFR4.Bits.CCFE
#define MBCCFR4_CHB                     _MBCCFR4.Bits.CHB
#define MBCCFR4_CHA                     _MBCCFR4.Bits.CHA
#define MBCCFR4_MTM                     _MBCCFR4.Bits.MTM

#define MBCCFR4_CCFVAL_MASK             63
#define MBCCFR4_CCFVAL_BITNUM           0
#define MBCCFR4_CCFMSK_MASK             4032
#define MBCCFR4_CCFMSK_BITNUM           6
#define MBCCFR4_CCFE_MASK               4096
#define MBCCFR4_CHB_MASK                8192
#define MBCCFR4_CHA_MASK                16384
#define MBCCFR4_MTM_MASK                32768


/*** MBFIDR4 - Message Buffer Frame ID Registers; 0x00000524 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR4STR;
extern volatile MBFIDR4STR _MBFIDR4 @(REG_BASE + 0x00000524);
#define MBFIDR4                         _MBFIDR4.Word
#define MBFIDR4_FID                     _MBFIDR4.Bits.FID

#define MBFIDR4_FID_MASK                2047
#define MBFIDR4_FID_BITNUM              0


/*** MBIDXR4 - Message Buffer Index Register; 0x00000526 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR4STR;
extern volatile MBIDXR4STR _MBIDXR4 @(REG_BASE + 0x00000526);
#define MBIDXR4                         _MBIDXR4.Word
#define MBIDXR4_MBIDX                   _MBIDXR4.Bits.MBIDX

#define MBIDXR4_MBIDX_MASK              63
#define MBIDXR4_MBIDX_BITNUM            0


/*** MBCCSR5 - Message Buffer Configuration, Control, Status Register 5; 0x00000528 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR5STR;
extern volatile MBCCSR5STR _MBCCSR5 @(REG_BASE + 0x00000528);
#define MBCCSR5                         _MBCCSR5.Word
#define MBCCSR5_MBIF                    _MBCCSR5.Bits.MBIF
#define MBCCSR5_LCKS                    _MBCCSR5.Bits.LCKS
#define MBCCSR5_EDS                     _MBCCSR5.Bits.EDS
#define MBCCSR5_DVAL                    _MBCCSR5.Bits.DVAL
#define MBCCSR5_DUP                     _MBCCSR5.Bits.DUP
#define MBCCSR5_MBIE                    _MBCCSR5.Bits.MBIE
#define MBCCSR5_LCKT                    _MBCCSR5.Bits.LCKT
#define MBCCSR5_EDT                     _MBCCSR5.Bits.EDT
#define MBCCSR5_CMT                     _MBCCSR5.Bits.CMT
#define MBCCSR5_MTD                     _MBCCSR5.Bits.MTD
#define MBCCSR5_MBT                     _MBCCSR5.Bits.MBT
#define MBCCSR5_MCM                     _MBCCSR5.Bits.MCM

#define MBCCSR5_MBIF_MASK               1
#define MBCCSR5_LCKS_MASK               2
#define MBCCSR5_EDS_MASK                4
#define MBCCSR5_DVAL_MASK               8
#define MBCCSR5_DUP_MASK                16
#define MBCCSR5_MBIE_MASK               256
#define MBCCSR5_LCKT_MASK               512
#define MBCCSR5_EDT_MASK                1024
#define MBCCSR5_CMT_MASK                2048
#define MBCCSR5_MTD_MASK                4096
#define MBCCSR5_MBT_MASK                8192
#define MBCCSR5_MCM_MASK                16384


/*** MBCCFR5 - Message Buffer Cycle Counter Filter Register 5; 0x0000052A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR5STR;
extern volatile MBCCFR5STR _MBCCFR5 @(REG_BASE + 0x0000052A);
#define MBCCFR5                         _MBCCFR5.Word
#define MBCCFR5_CCFVAL                  _MBCCFR5.Bits.CCFVAL
#define MBCCFR5_CCFMSK                  _MBCCFR5.Bits.CCFMSK
#define MBCCFR5_CCFE                    _MBCCFR5.Bits.CCFE
#define MBCCFR5_CHB                     _MBCCFR5.Bits.CHB
#define MBCCFR5_CHA                     _MBCCFR5.Bits.CHA
#define MBCCFR5_MTM                     _MBCCFR5.Bits.MTM

#define MBCCFR5_CCFVAL_MASK             63
#define MBCCFR5_CCFVAL_BITNUM           0
#define MBCCFR5_CCFMSK_MASK             4032
#define MBCCFR5_CCFMSK_BITNUM           6
#define MBCCFR5_CCFE_MASK               4096
#define MBCCFR5_CHB_MASK                8192
#define MBCCFR5_CHA_MASK                16384
#define MBCCFR5_MTM_MASK                32768


/*** MBFIDR5 - Message Buffer Frame ID Registers; 0x0000052C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR5STR;
extern volatile MBFIDR5STR _MBFIDR5 @(REG_BASE + 0x0000052C);
#define MBFIDR5                         _MBFIDR5.Word
#define MBFIDR5_FID                     _MBFIDR5.Bits.FID

#define MBFIDR5_FID_MASK                2047
#define MBFIDR5_FID_BITNUM              0


/*** MBIDXR5 - Message Buffer Index Register; 0x0000052E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR5STR;
extern volatile MBIDXR5STR _MBIDXR5 @(REG_BASE + 0x0000052E);
#define MBIDXR5                         _MBIDXR5.Word
#define MBIDXR5_MBIDX                   _MBIDXR5.Bits.MBIDX

#define MBIDXR5_MBIDX_MASK              63
#define MBIDXR5_MBIDX_BITNUM            0


/*** MBCCSR6 - Message Buffer Configuration, Control, Status Register 6; 0x00000530 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR6STR;
extern volatile MBCCSR6STR _MBCCSR6 @(REG_BASE + 0x00000530);
#define MBCCSR6                         _MBCCSR6.Word
#define MBCCSR6_MBIF                    _MBCCSR6.Bits.MBIF
#define MBCCSR6_LCKS                    _MBCCSR6.Bits.LCKS
#define MBCCSR6_EDS                     _MBCCSR6.Bits.EDS
#define MBCCSR6_DVAL                    _MBCCSR6.Bits.DVAL
#define MBCCSR6_DUP                     _MBCCSR6.Bits.DUP
#define MBCCSR6_MBIE                    _MBCCSR6.Bits.MBIE
#define MBCCSR6_LCKT                    _MBCCSR6.Bits.LCKT
#define MBCCSR6_EDT                     _MBCCSR6.Bits.EDT
#define MBCCSR6_CMT                     _MBCCSR6.Bits.CMT
#define MBCCSR6_MTD                     _MBCCSR6.Bits.MTD
#define MBCCSR6_MBT                     _MBCCSR6.Bits.MBT
#define MBCCSR6_MCM                     _MBCCSR6.Bits.MCM

#define MBCCSR6_MBIF_MASK               1
#define MBCCSR6_LCKS_MASK               2
#define MBCCSR6_EDS_MASK                4
#define MBCCSR6_DVAL_MASK               8
#define MBCCSR6_DUP_MASK                16
#define MBCCSR6_MBIE_MASK               256
#define MBCCSR6_LCKT_MASK               512
#define MBCCSR6_EDT_MASK                1024
#define MBCCSR6_CMT_MASK                2048
#define MBCCSR6_MTD_MASK                4096
#define MBCCSR6_MBT_MASK                8192
#define MBCCSR6_MCM_MASK                16384


/*** MBCCFR6 - Message Buffer Cycle Counter Filter Register 6; 0x00000532 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR6STR;
extern volatile MBCCFR6STR _MBCCFR6 @(REG_BASE + 0x00000532);
#define MBCCFR6                         _MBCCFR6.Word
#define MBCCFR6_CCFVAL                  _MBCCFR6.Bits.CCFVAL
#define MBCCFR6_CCFMSK                  _MBCCFR6.Bits.CCFMSK
#define MBCCFR6_CCFE                    _MBCCFR6.Bits.CCFE
#define MBCCFR6_CHB                     _MBCCFR6.Bits.CHB
#define MBCCFR6_CHA                     _MBCCFR6.Bits.CHA
#define MBCCFR6_MTM                     _MBCCFR6.Bits.MTM

#define MBCCFR6_CCFVAL_MASK             63
#define MBCCFR6_CCFVAL_BITNUM           0
#define MBCCFR6_CCFMSK_MASK             4032
#define MBCCFR6_CCFMSK_BITNUM           6
#define MBCCFR6_CCFE_MASK               4096
#define MBCCFR6_CHB_MASK                8192
#define MBCCFR6_CHA_MASK                16384
#define MBCCFR6_MTM_MASK                32768


/*** MBFIDR6 - Message Buffer Frame ID Registers; 0x00000534 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR6STR;
extern volatile MBFIDR6STR _MBFIDR6 @(REG_BASE + 0x00000534);
#define MBFIDR6                         _MBFIDR6.Word
#define MBFIDR6_FID                     _MBFIDR6.Bits.FID

#define MBFIDR6_FID_MASK                2047
#define MBFIDR6_FID_BITNUM              0


/*** MBIDXR6 - Message Buffer Index Register; 0x00000536 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR6STR;
extern volatile MBIDXR6STR _MBIDXR6 @(REG_BASE + 0x00000536);
#define MBIDXR6                         _MBIDXR6.Word
#define MBIDXR6_MBIDX                   _MBIDXR6.Bits.MBIDX

#define MBIDXR6_MBIDX_MASK              63
#define MBIDXR6_MBIDX_BITNUM            0


/*** MBCCSR7 - Message Buffer Configuration, Control, Status Register 7; 0x00000538 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR7STR;
extern volatile MBCCSR7STR _MBCCSR7 @(REG_BASE + 0x00000538);
#define MBCCSR7                         _MBCCSR7.Word
#define MBCCSR7_MBIF                    _MBCCSR7.Bits.MBIF
#define MBCCSR7_LCKS                    _MBCCSR7.Bits.LCKS
#define MBCCSR7_EDS                     _MBCCSR7.Bits.EDS
#define MBCCSR7_DVAL                    _MBCCSR7.Bits.DVAL
#define MBCCSR7_DUP                     _MBCCSR7.Bits.DUP
#define MBCCSR7_MBIE                    _MBCCSR7.Bits.MBIE
#define MBCCSR7_LCKT                    _MBCCSR7.Bits.LCKT
#define MBCCSR7_EDT                     _MBCCSR7.Bits.EDT
#define MBCCSR7_CMT                     _MBCCSR7.Bits.CMT
#define MBCCSR7_MTD                     _MBCCSR7.Bits.MTD
#define MBCCSR7_MBT                     _MBCCSR7.Bits.MBT
#define MBCCSR7_MCM                     _MBCCSR7.Bits.MCM

#define MBCCSR7_MBIF_MASK               1
#define MBCCSR7_LCKS_MASK               2
#define MBCCSR7_EDS_MASK                4
#define MBCCSR7_DVAL_MASK               8
#define MBCCSR7_DUP_MASK                16
#define MBCCSR7_MBIE_MASK               256
#define MBCCSR7_LCKT_MASK               512
#define MBCCSR7_EDT_MASK                1024
#define MBCCSR7_CMT_MASK                2048
#define MBCCSR7_MTD_MASK                4096
#define MBCCSR7_MBT_MASK                8192
#define MBCCSR7_MCM_MASK                16384


/*** MBCCFR7 - Message Buffer Cycle Counter Filter Register 7; 0x0000053A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR7STR;
extern volatile MBCCFR7STR _MBCCFR7 @(REG_BASE + 0x0000053A);
#define MBCCFR7                         _MBCCFR7.Word
#define MBCCFR7_CCFVAL                  _MBCCFR7.Bits.CCFVAL
#define MBCCFR7_CCFMSK                  _MBCCFR7.Bits.CCFMSK
#define MBCCFR7_CCFE                    _MBCCFR7.Bits.CCFE
#define MBCCFR7_CHB                     _MBCCFR7.Bits.CHB
#define MBCCFR7_CHA                     _MBCCFR7.Bits.CHA
#define MBCCFR7_MTM                     _MBCCFR7.Bits.MTM

#define MBCCFR7_CCFVAL_MASK             63
#define MBCCFR7_CCFVAL_BITNUM           0
#define MBCCFR7_CCFMSK_MASK             4032
#define MBCCFR7_CCFMSK_BITNUM           6
#define MBCCFR7_CCFE_MASK               4096
#define MBCCFR7_CHB_MASK                8192
#define MBCCFR7_CHA_MASK                16384
#define MBCCFR7_MTM_MASK                32768


/*** MBFIDR7 - Message Buffer Frame ID Registers; 0x0000053C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR7STR;
extern volatile MBFIDR7STR _MBFIDR7 @(REG_BASE + 0x0000053C);
#define MBFIDR7                         _MBFIDR7.Word
#define MBFIDR7_FID                     _MBFIDR7.Bits.FID

#define MBFIDR7_FID_MASK                2047
#define MBFIDR7_FID_BITNUM              0


/*** MBIDXR7 - Message Buffer Index Register; 0x0000053E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR7STR;
extern volatile MBIDXR7STR _MBIDXR7 @(REG_BASE + 0x0000053E);
#define MBIDXR7                         _MBIDXR7.Word
#define MBIDXR7_MBIDX                   _MBIDXR7.Bits.MBIDX

#define MBIDXR7_MBIDX_MASK              63
#define MBIDXR7_MBIDX_BITNUM            0


/*** MBCCSR8 - Message Buffer Configuration, Control, Status Register 8; 0x00000540 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR8STR;
extern volatile MBCCSR8STR _MBCCSR8 @(REG_BASE + 0x00000540);
#define MBCCSR8                         _MBCCSR8.Word
#define MBCCSR8_MBIF                    _MBCCSR8.Bits.MBIF
#define MBCCSR8_LCKS                    _MBCCSR8.Bits.LCKS
#define MBCCSR8_EDS                     _MBCCSR8.Bits.EDS
#define MBCCSR8_DVAL                    _MBCCSR8.Bits.DVAL
#define MBCCSR8_DUP                     _MBCCSR8.Bits.DUP
#define MBCCSR8_MBIE                    _MBCCSR8.Bits.MBIE
#define MBCCSR8_LCKT                    _MBCCSR8.Bits.LCKT
#define MBCCSR8_EDT                     _MBCCSR8.Bits.EDT
#define MBCCSR8_CMT                     _MBCCSR8.Bits.CMT
#define MBCCSR8_MTD                     _MBCCSR8.Bits.MTD
#define MBCCSR8_MBT                     _MBCCSR8.Bits.MBT
#define MBCCSR8_MCM                     _MBCCSR8.Bits.MCM

#define MBCCSR8_MBIF_MASK               1
#define MBCCSR8_LCKS_MASK               2
#define MBCCSR8_EDS_MASK                4
#define MBCCSR8_DVAL_MASK               8
#define MBCCSR8_DUP_MASK                16
#define MBCCSR8_MBIE_MASK               256
#define MBCCSR8_LCKT_MASK               512
#define MBCCSR8_EDT_MASK                1024
#define MBCCSR8_CMT_MASK                2048
#define MBCCSR8_MTD_MASK                4096
#define MBCCSR8_MBT_MASK                8192
#define MBCCSR8_MCM_MASK                16384


/*** MBCCFR8 - Message Buffer Cycle Counter Filter Register 8; 0x00000542 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR8STR;
extern volatile MBCCFR8STR _MBCCFR8 @(REG_BASE + 0x00000542);
#define MBCCFR8                         _MBCCFR8.Word
#define MBCCFR8_CCFVAL                  _MBCCFR8.Bits.CCFVAL
#define MBCCFR8_CCFMSK                  _MBCCFR8.Bits.CCFMSK
#define MBCCFR8_CCFE                    _MBCCFR8.Bits.CCFE
#define MBCCFR8_CHB                     _MBCCFR8.Bits.CHB
#define MBCCFR8_CHA                     _MBCCFR8.Bits.CHA
#define MBCCFR8_MTM                     _MBCCFR8.Bits.MTM

#define MBCCFR8_CCFVAL_MASK             63
#define MBCCFR8_CCFVAL_BITNUM           0
#define MBCCFR8_CCFMSK_MASK             4032
#define MBCCFR8_CCFMSK_BITNUM           6
#define MBCCFR8_CCFE_MASK               4096
#define MBCCFR8_CHB_MASK                8192
#define MBCCFR8_CHA_MASK                16384
#define MBCCFR8_MTM_MASK                32768


/*** MBFIDR8 - Message Buffer Frame ID Registers; 0x00000544 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR8STR;
extern volatile MBFIDR8STR _MBFIDR8 @(REG_BASE + 0x00000544);
#define MBFIDR8                         _MBFIDR8.Word
#define MBFIDR8_FID                     _MBFIDR8.Bits.FID

#define MBFIDR8_FID_MASK                2047
#define MBFIDR8_FID_BITNUM              0


/*** MBIDXR8 - Message Buffer Index Register; 0x00000546 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR8STR;
extern volatile MBIDXR8STR _MBIDXR8 @(REG_BASE + 0x00000546);
#define MBIDXR8                         _MBIDXR8.Word
#define MBIDXR8_MBIDX                   _MBIDXR8.Bits.MBIDX

#define MBIDXR8_MBIDX_MASK              63
#define MBIDXR8_MBIDX_BITNUM            0


/*** MBCCSR9 - Message Buffer Configuration, Control, Status Register 9; 0x00000548 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR9STR;
extern volatile MBCCSR9STR _MBCCSR9 @(REG_BASE + 0x00000548);
#define MBCCSR9                         _MBCCSR9.Word
#define MBCCSR9_MBIF                    _MBCCSR9.Bits.MBIF
#define MBCCSR9_LCKS                    _MBCCSR9.Bits.LCKS
#define MBCCSR9_EDS                     _MBCCSR9.Bits.EDS
#define MBCCSR9_DVAL                    _MBCCSR9.Bits.DVAL
#define MBCCSR9_DUP                     _MBCCSR9.Bits.DUP
#define MBCCSR9_MBIE                    _MBCCSR9.Bits.MBIE
#define MBCCSR9_LCKT                    _MBCCSR9.Bits.LCKT
#define MBCCSR9_EDT                     _MBCCSR9.Bits.EDT
#define MBCCSR9_CMT                     _MBCCSR9.Bits.CMT
#define MBCCSR9_MTD                     _MBCCSR9.Bits.MTD
#define MBCCSR9_MBT                     _MBCCSR9.Bits.MBT
#define MBCCSR9_MCM                     _MBCCSR9.Bits.MCM

#define MBCCSR9_MBIF_MASK               1
#define MBCCSR9_LCKS_MASK               2
#define MBCCSR9_EDS_MASK                4
#define MBCCSR9_DVAL_MASK               8
#define MBCCSR9_DUP_MASK                16
#define MBCCSR9_MBIE_MASK               256
#define MBCCSR9_LCKT_MASK               512
#define MBCCSR9_EDT_MASK                1024
#define MBCCSR9_CMT_MASK                2048
#define MBCCSR9_MTD_MASK                4096
#define MBCCSR9_MBT_MASK                8192
#define MBCCSR9_MCM_MASK                16384


/*** MBCCFR9 - Message Buffer Cycle Counter Filter Register 9; 0x0000054A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR9STR;
extern volatile MBCCFR9STR _MBCCFR9 @(REG_BASE + 0x0000054A);
#define MBCCFR9                         _MBCCFR9.Word
#define MBCCFR9_CCFVAL                  _MBCCFR9.Bits.CCFVAL
#define MBCCFR9_CCFMSK                  _MBCCFR9.Bits.CCFMSK
#define MBCCFR9_CCFE                    _MBCCFR9.Bits.CCFE
#define MBCCFR9_CHB                     _MBCCFR9.Bits.CHB
#define MBCCFR9_CHA                     _MBCCFR9.Bits.CHA
#define MBCCFR9_MTM                     _MBCCFR9.Bits.MTM

#define MBCCFR9_CCFVAL_MASK             63
#define MBCCFR9_CCFVAL_BITNUM           0
#define MBCCFR9_CCFMSK_MASK             4032
#define MBCCFR9_CCFMSK_BITNUM           6
#define MBCCFR9_CCFE_MASK               4096
#define MBCCFR9_CHB_MASK                8192
#define MBCCFR9_CHA_MASK                16384
#define MBCCFR9_MTM_MASK                32768


/*** MBFIDR9 - Message Buffer Frame ID Registers; 0x0000054C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR9STR;
extern volatile MBFIDR9STR _MBFIDR9 @(REG_BASE + 0x0000054C);
#define MBFIDR9                         _MBFIDR9.Word
#define MBFIDR9_FID                     _MBFIDR9.Bits.FID

#define MBFIDR9_FID_MASK                2047
#define MBFIDR9_FID_BITNUM              0


/*** MBIDXR9 - Message Buffer Index Register; 0x0000054E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR9STR;
extern volatile MBIDXR9STR _MBIDXR9 @(REG_BASE + 0x0000054E);
#define MBIDXR9                         _MBIDXR9.Word
#define MBIDXR9_MBIDX                   _MBIDXR9.Bits.MBIDX

#define MBIDXR9_MBIDX_MASK              63
#define MBIDXR9_MBIDX_BITNUM            0


/*** MBCCSR10 - Message Buffer Configuration, Control, Status Register 10; 0x00000550 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR10STR;
extern volatile MBCCSR10STR _MBCCSR10 @(REG_BASE + 0x00000550);
#define MBCCSR10                        _MBCCSR10.Word
#define MBCCSR10_MBIF                   _MBCCSR10.Bits.MBIF
#define MBCCSR10_LCKS                   _MBCCSR10.Bits.LCKS
#define MBCCSR10_EDS                    _MBCCSR10.Bits.EDS
#define MBCCSR10_DVAL                   _MBCCSR10.Bits.DVAL
#define MBCCSR10_DUP                    _MBCCSR10.Bits.DUP
#define MBCCSR10_MBIE                   _MBCCSR10.Bits.MBIE
#define MBCCSR10_LCKT                   _MBCCSR10.Bits.LCKT
#define MBCCSR10_EDT                    _MBCCSR10.Bits.EDT
#define MBCCSR10_CMT                    _MBCCSR10.Bits.CMT
#define MBCCSR10_MTD                    _MBCCSR10.Bits.MTD
#define MBCCSR10_MBT                    _MBCCSR10.Bits.MBT
#define MBCCSR10_MCM                    _MBCCSR10.Bits.MCM

#define MBCCSR10_MBIF_MASK              1
#define MBCCSR10_LCKS_MASK              2
#define MBCCSR10_EDS_MASK               4
#define MBCCSR10_DVAL_MASK              8
#define MBCCSR10_DUP_MASK               16
#define MBCCSR10_MBIE_MASK              256
#define MBCCSR10_LCKT_MASK              512
#define MBCCSR10_EDT_MASK               1024
#define MBCCSR10_CMT_MASK               2048
#define MBCCSR10_MTD_MASK               4096
#define MBCCSR10_MBT_MASK               8192
#define MBCCSR10_MCM_MASK               16384


/*** MBCCFR10 - Message Buffer Cycle Counter Filter Register 10; 0x00000552 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR10STR;
extern volatile MBCCFR10STR _MBCCFR10 @(REG_BASE + 0x00000552);
#define MBCCFR10                        _MBCCFR10.Word
#define MBCCFR10_CCFVAL                 _MBCCFR10.Bits.CCFVAL
#define MBCCFR10_CCFMSK                 _MBCCFR10.Bits.CCFMSK
#define MBCCFR10_CCFE                   _MBCCFR10.Bits.CCFE
#define MBCCFR10_CHB                    _MBCCFR10.Bits.CHB
#define MBCCFR10_CHA                    _MBCCFR10.Bits.CHA
#define MBCCFR10_MTM                    _MBCCFR10.Bits.MTM

#define MBCCFR10_CCFVAL_MASK            63
#define MBCCFR10_CCFVAL_BITNUM          0
#define MBCCFR10_CCFMSK_MASK            4032
#define MBCCFR10_CCFMSK_BITNUM          6
#define MBCCFR10_CCFE_MASK              4096
#define MBCCFR10_CHB_MASK               8192
#define MBCCFR10_CHA_MASK               16384
#define MBCCFR10_MTM_MASK               32768


/*** MBFIDR10 - Message Buffer Frame ID Registers; 0x00000554 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR10STR;
extern volatile MBFIDR10STR _MBFIDR10 @(REG_BASE + 0x00000554);
#define MBFIDR10                        _MBFIDR10.Word
#define MBFIDR10_FID                    _MBFIDR10.Bits.FID

#define MBFIDR10_FID_MASK               2047
#define MBFIDR10_FID_BITNUM             0


/*** MBIDXR10 - Message Buffer Index Register; 0x00000556 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR10STR;
extern volatile MBIDXR10STR _MBIDXR10 @(REG_BASE + 0x00000556);
#define MBIDXR10                        _MBIDXR10.Word
#define MBIDXR10_MBIDX                  _MBIDXR10.Bits.MBIDX

#define MBIDXR10_MBIDX_MASK             63
#define MBIDXR10_MBIDX_BITNUM           0


/*** MBCCSR11 - Message Buffer Configuration, Control, Status Register 11; 0x00000558 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR11STR;
extern volatile MBCCSR11STR _MBCCSR11 @(REG_BASE + 0x00000558);
#define MBCCSR11                        _MBCCSR11.Word
#define MBCCSR11_MBIF                   _MBCCSR11.Bits.MBIF
#define MBCCSR11_LCKS                   _MBCCSR11.Bits.LCKS
#define MBCCSR11_EDS                    _MBCCSR11.Bits.EDS
#define MBCCSR11_DVAL                   _MBCCSR11.Bits.DVAL
#define MBCCSR11_DUP                    _MBCCSR11.Bits.DUP
#define MBCCSR11_MBIE                   _MBCCSR11.Bits.MBIE
#define MBCCSR11_LCKT                   _MBCCSR11.Bits.LCKT
#define MBCCSR11_EDT                    _MBCCSR11.Bits.EDT
#define MBCCSR11_CMT                    _MBCCSR11.Bits.CMT
#define MBCCSR11_MTD                    _MBCCSR11.Bits.MTD
#define MBCCSR11_MBT                    _MBCCSR11.Bits.MBT
#define MBCCSR11_MCM                    _MBCCSR11.Bits.MCM

#define MBCCSR11_MBIF_MASK              1
#define MBCCSR11_LCKS_MASK              2
#define MBCCSR11_EDS_MASK               4
#define MBCCSR11_DVAL_MASK              8
#define MBCCSR11_DUP_MASK               16
#define MBCCSR11_MBIE_MASK              256
#define MBCCSR11_LCKT_MASK              512
#define MBCCSR11_EDT_MASK               1024
#define MBCCSR11_CMT_MASK               2048
#define MBCCSR11_MTD_MASK               4096
#define MBCCSR11_MBT_MASK               8192
#define MBCCSR11_MCM_MASK               16384


/*** MBCCFR11 - Message Buffer Cycle Counter Filter Register 11; 0x0000055A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR11STR;
extern volatile MBCCFR11STR _MBCCFR11 @(REG_BASE + 0x0000055A);
#define MBCCFR11                        _MBCCFR11.Word
#define MBCCFR11_CCFVAL                 _MBCCFR11.Bits.CCFVAL
#define MBCCFR11_CCFMSK                 _MBCCFR11.Bits.CCFMSK
#define MBCCFR11_CCFE                   _MBCCFR11.Bits.CCFE
#define MBCCFR11_CHB                    _MBCCFR11.Bits.CHB
#define MBCCFR11_CHA                    _MBCCFR11.Bits.CHA
#define MBCCFR11_MTM                    _MBCCFR11.Bits.MTM

#define MBCCFR11_CCFVAL_MASK            63
#define MBCCFR11_CCFVAL_BITNUM          0
#define MBCCFR11_CCFMSK_MASK            4032
#define MBCCFR11_CCFMSK_BITNUM          6
#define MBCCFR11_CCFE_MASK              4096
#define MBCCFR11_CHB_MASK               8192
#define MBCCFR11_CHA_MASK               16384
#define MBCCFR11_MTM_MASK               32768


/*** MBFIDR11 - Message Buffer Frame ID Registers; 0x0000055C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR11STR;
extern volatile MBFIDR11STR _MBFIDR11 @(REG_BASE + 0x0000055C);
#define MBFIDR11                        _MBFIDR11.Word
#define MBFIDR11_FID                    _MBFIDR11.Bits.FID

#define MBFIDR11_FID_MASK               2047
#define MBFIDR11_FID_BITNUM             0


/*** MBIDXR11 - Message Buffer Index Register; 0x0000055E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR11STR;
extern volatile MBIDXR11STR _MBIDXR11 @(REG_BASE + 0x0000055E);
#define MBIDXR11                        _MBIDXR11.Word
#define MBIDXR11_MBIDX                  _MBIDXR11.Bits.MBIDX

#define MBIDXR11_MBIDX_MASK             63
#define MBIDXR11_MBIDX_BITNUM           0


/*** MBCCSR12 - Message Buffer Configuration, Control, Status Register 12; 0x00000560 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR12STR;
extern volatile MBCCSR12STR _MBCCSR12 @(REG_BASE + 0x00000560);
#define MBCCSR12                        _MBCCSR12.Word
#define MBCCSR12_MBIF                   _MBCCSR12.Bits.MBIF
#define MBCCSR12_LCKS                   _MBCCSR12.Bits.LCKS
#define MBCCSR12_EDS                    _MBCCSR12.Bits.EDS
#define MBCCSR12_DVAL                   _MBCCSR12.Bits.DVAL
#define MBCCSR12_DUP                    _MBCCSR12.Bits.DUP
#define MBCCSR12_MBIE                   _MBCCSR12.Bits.MBIE
#define MBCCSR12_LCKT                   _MBCCSR12.Bits.LCKT
#define MBCCSR12_EDT                    _MBCCSR12.Bits.EDT
#define MBCCSR12_CMT                    _MBCCSR12.Bits.CMT
#define MBCCSR12_MTD                    _MBCCSR12.Bits.MTD
#define MBCCSR12_MBT                    _MBCCSR12.Bits.MBT
#define MBCCSR12_MCM                    _MBCCSR12.Bits.MCM

#define MBCCSR12_MBIF_MASK              1
#define MBCCSR12_LCKS_MASK              2
#define MBCCSR12_EDS_MASK               4
#define MBCCSR12_DVAL_MASK              8
#define MBCCSR12_DUP_MASK               16
#define MBCCSR12_MBIE_MASK              256
#define MBCCSR12_LCKT_MASK              512
#define MBCCSR12_EDT_MASK               1024
#define MBCCSR12_CMT_MASK               2048
#define MBCCSR12_MTD_MASK               4096
#define MBCCSR12_MBT_MASK               8192
#define MBCCSR12_MCM_MASK               16384


/*** MBCCFR12 - Message Buffer Cycle Counter Filter Register 12; 0x00000562 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR12STR;
extern volatile MBCCFR12STR _MBCCFR12 @(REG_BASE + 0x00000562);
#define MBCCFR12                        _MBCCFR12.Word
#define MBCCFR12_CCFVAL                 _MBCCFR12.Bits.CCFVAL
#define MBCCFR12_CCFMSK                 _MBCCFR12.Bits.CCFMSK
#define MBCCFR12_CCFE                   _MBCCFR12.Bits.CCFE
#define MBCCFR12_CHB                    _MBCCFR12.Bits.CHB
#define MBCCFR12_CHA                    _MBCCFR12.Bits.CHA
#define MBCCFR12_MTM                    _MBCCFR12.Bits.MTM

#define MBCCFR12_CCFVAL_MASK            63
#define MBCCFR12_CCFVAL_BITNUM          0
#define MBCCFR12_CCFMSK_MASK            4032
#define MBCCFR12_CCFMSK_BITNUM          6
#define MBCCFR12_CCFE_MASK              4096
#define MBCCFR12_CHB_MASK               8192
#define MBCCFR12_CHA_MASK               16384
#define MBCCFR12_MTM_MASK               32768


/*** MBFIDR12 - Message Buffer Frame ID Registers; 0x00000564 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR12STR;
extern volatile MBFIDR12STR _MBFIDR12 @(REG_BASE + 0x00000564);
#define MBFIDR12                        _MBFIDR12.Word
#define MBFIDR12_FID                    _MBFIDR12.Bits.FID

#define MBFIDR12_FID_MASK               2047
#define MBFIDR12_FID_BITNUM             0


/*** MBIDXR12 - Message Buffer Index Register; 0x00000566 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR12STR;
extern volatile MBIDXR12STR _MBIDXR12 @(REG_BASE + 0x00000566);
#define MBIDXR12                        _MBIDXR12.Word
#define MBIDXR12_MBIDX                  _MBIDXR12.Bits.MBIDX

#define MBIDXR12_MBIDX_MASK             63
#define MBIDXR12_MBIDX_BITNUM           0


/*** MBCCSR13 - Message Buffer Configuration, Control, Status Register 13; 0x00000568 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR13STR;
extern volatile MBCCSR13STR _MBCCSR13 @(REG_BASE + 0x00000568);
#define MBCCSR13                        _MBCCSR13.Word
#define MBCCSR13_MBIF                   _MBCCSR13.Bits.MBIF
#define MBCCSR13_LCKS                   _MBCCSR13.Bits.LCKS
#define MBCCSR13_EDS                    _MBCCSR13.Bits.EDS
#define MBCCSR13_DVAL                   _MBCCSR13.Bits.DVAL
#define MBCCSR13_DUP                    _MBCCSR13.Bits.DUP
#define MBCCSR13_MBIE                   _MBCCSR13.Bits.MBIE
#define MBCCSR13_LCKT                   _MBCCSR13.Bits.LCKT
#define MBCCSR13_EDT                    _MBCCSR13.Bits.EDT
#define MBCCSR13_CMT                    _MBCCSR13.Bits.CMT
#define MBCCSR13_MTD                    _MBCCSR13.Bits.MTD
#define MBCCSR13_MBT                    _MBCCSR13.Bits.MBT
#define MBCCSR13_MCM                    _MBCCSR13.Bits.MCM

#define MBCCSR13_MBIF_MASK              1
#define MBCCSR13_LCKS_MASK              2
#define MBCCSR13_EDS_MASK               4
#define MBCCSR13_DVAL_MASK              8
#define MBCCSR13_DUP_MASK               16
#define MBCCSR13_MBIE_MASK              256
#define MBCCSR13_LCKT_MASK              512
#define MBCCSR13_EDT_MASK               1024
#define MBCCSR13_CMT_MASK               2048
#define MBCCSR13_MTD_MASK               4096
#define MBCCSR13_MBT_MASK               8192
#define MBCCSR13_MCM_MASK               16384


/*** MBCCFR13 - Message Buffer Cycle Counter Filter Register 13; 0x0000056A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR13STR;
extern volatile MBCCFR13STR _MBCCFR13 @(REG_BASE + 0x0000056A);
#define MBCCFR13                        _MBCCFR13.Word
#define MBCCFR13_CCFVAL                 _MBCCFR13.Bits.CCFVAL
#define MBCCFR13_CCFMSK                 _MBCCFR13.Bits.CCFMSK
#define MBCCFR13_CCFE                   _MBCCFR13.Bits.CCFE
#define MBCCFR13_CHB                    _MBCCFR13.Bits.CHB
#define MBCCFR13_CHA                    _MBCCFR13.Bits.CHA
#define MBCCFR13_MTM                    _MBCCFR13.Bits.MTM

#define MBCCFR13_CCFVAL_MASK            63
#define MBCCFR13_CCFVAL_BITNUM          0
#define MBCCFR13_CCFMSK_MASK            4032
#define MBCCFR13_CCFMSK_BITNUM          6
#define MBCCFR13_CCFE_MASK              4096
#define MBCCFR13_CHB_MASK               8192
#define MBCCFR13_CHA_MASK               16384
#define MBCCFR13_MTM_MASK               32768


/*** MBFIDR13 - Message Buffer Frame ID Registers; 0x0000056C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR13STR;
extern volatile MBFIDR13STR _MBFIDR13 @(REG_BASE + 0x0000056C);
#define MBFIDR13                        _MBFIDR13.Word
#define MBFIDR13_FID                    _MBFIDR13.Bits.FID

#define MBFIDR13_FID_MASK               2047
#define MBFIDR13_FID_BITNUM             0


/*** MBIDXR13 - Message Buffer Index Register; 0x0000056E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR13STR;
extern volatile MBIDXR13STR _MBIDXR13 @(REG_BASE + 0x0000056E);
#define MBIDXR13                        _MBIDXR13.Word
#define MBIDXR13_MBIDX                  _MBIDXR13.Bits.MBIDX

#define MBIDXR13_MBIDX_MASK             63
#define MBIDXR13_MBIDX_BITNUM           0


/*** MBCCSR14 - Message Buffer Configuration, Control, Status Register 14; 0x00000570 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR14STR;
extern volatile MBCCSR14STR _MBCCSR14 @(REG_BASE + 0x00000570);
#define MBCCSR14                        _MBCCSR14.Word
#define MBCCSR14_MBIF                   _MBCCSR14.Bits.MBIF
#define MBCCSR14_LCKS                   _MBCCSR14.Bits.LCKS
#define MBCCSR14_EDS                    _MBCCSR14.Bits.EDS
#define MBCCSR14_DVAL                   _MBCCSR14.Bits.DVAL
#define MBCCSR14_DUP                    _MBCCSR14.Bits.DUP
#define MBCCSR14_MBIE                   _MBCCSR14.Bits.MBIE
#define MBCCSR14_LCKT                   _MBCCSR14.Bits.LCKT
#define MBCCSR14_EDT                    _MBCCSR14.Bits.EDT
#define MBCCSR14_CMT                    _MBCCSR14.Bits.CMT
#define MBCCSR14_MTD                    _MBCCSR14.Bits.MTD
#define MBCCSR14_MBT                    _MBCCSR14.Bits.MBT
#define MBCCSR14_MCM                    _MBCCSR14.Bits.MCM

#define MBCCSR14_MBIF_MASK              1
#define MBCCSR14_LCKS_MASK              2
#define MBCCSR14_EDS_MASK               4
#define MBCCSR14_DVAL_MASK              8
#define MBCCSR14_DUP_MASK               16
#define MBCCSR14_MBIE_MASK              256
#define MBCCSR14_LCKT_MASK              512
#define MBCCSR14_EDT_MASK               1024
#define MBCCSR14_CMT_MASK               2048
#define MBCCSR14_MTD_MASK               4096
#define MBCCSR14_MBT_MASK               8192
#define MBCCSR14_MCM_MASK               16384


/*** MBCCFR14 - Message Buffer Cycle Counter Filter Register 14; 0x00000572 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR14STR;
extern volatile MBCCFR14STR _MBCCFR14 @(REG_BASE + 0x00000572);
#define MBCCFR14                        _MBCCFR14.Word
#define MBCCFR14_CCFVAL                 _MBCCFR14.Bits.CCFVAL
#define MBCCFR14_CCFMSK                 _MBCCFR14.Bits.CCFMSK
#define MBCCFR14_CCFE                   _MBCCFR14.Bits.CCFE
#define MBCCFR14_CHB                    _MBCCFR14.Bits.CHB
#define MBCCFR14_CHA                    _MBCCFR14.Bits.CHA
#define MBCCFR14_MTM                    _MBCCFR14.Bits.MTM

#define MBCCFR14_CCFVAL_MASK            63
#define MBCCFR14_CCFVAL_BITNUM          0
#define MBCCFR14_CCFMSK_MASK            4032
#define MBCCFR14_CCFMSK_BITNUM          6
#define MBCCFR14_CCFE_MASK              4096
#define MBCCFR14_CHB_MASK               8192
#define MBCCFR14_CHA_MASK               16384
#define MBCCFR14_MTM_MASK               32768


/*** MBFIDR14 - Message Buffer Frame ID Registers; 0x00000574 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR14STR;
extern volatile MBFIDR14STR _MBFIDR14 @(REG_BASE + 0x00000574);
#define MBFIDR14                        _MBFIDR14.Word
#define MBFIDR14_FID                    _MBFIDR14.Bits.FID

#define MBFIDR14_FID_MASK               2047
#define MBFIDR14_FID_BITNUM             0


/*** MBIDXR14 - Message Buffer Index Register; 0x00000576 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR14STR;
extern volatile MBIDXR14STR _MBIDXR14 @(REG_BASE + 0x00000576);
#define MBIDXR14                        _MBIDXR14.Word
#define MBIDXR14_MBIDX                  _MBIDXR14.Bits.MBIDX

#define MBIDXR14_MBIDX_MASK             63
#define MBIDXR14_MBIDX_BITNUM           0


/*** MBCCSR15 - Message Buffer Configuration, Control, Status Register 15; 0x00000578 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR15STR;
extern volatile MBCCSR15STR _MBCCSR15 @(REG_BASE + 0x00000578);
#define MBCCSR15                        _MBCCSR15.Word
#define MBCCSR15_MBIF                   _MBCCSR15.Bits.MBIF
#define MBCCSR15_LCKS                   _MBCCSR15.Bits.LCKS
#define MBCCSR15_EDS                    _MBCCSR15.Bits.EDS
#define MBCCSR15_DVAL                   _MBCCSR15.Bits.DVAL
#define MBCCSR15_DUP                    _MBCCSR15.Bits.DUP
#define MBCCSR15_MBIE                   _MBCCSR15.Bits.MBIE
#define MBCCSR15_LCKT                   _MBCCSR15.Bits.LCKT
#define MBCCSR15_EDT                    _MBCCSR15.Bits.EDT
#define MBCCSR15_CMT                    _MBCCSR15.Bits.CMT
#define MBCCSR15_MTD                    _MBCCSR15.Bits.MTD
#define MBCCSR15_MBT                    _MBCCSR15.Bits.MBT
#define MBCCSR15_MCM                    _MBCCSR15.Bits.MCM

#define MBCCSR15_MBIF_MASK              1
#define MBCCSR15_LCKS_MASK              2
#define MBCCSR15_EDS_MASK               4
#define MBCCSR15_DVAL_MASK              8
#define MBCCSR15_DUP_MASK               16
#define MBCCSR15_MBIE_MASK              256
#define MBCCSR15_LCKT_MASK              512
#define MBCCSR15_EDT_MASK               1024
#define MBCCSR15_CMT_MASK               2048
#define MBCCSR15_MTD_MASK               4096
#define MBCCSR15_MBT_MASK               8192
#define MBCCSR15_MCM_MASK               16384


/*** MBCCFR15 - Message Buffer Cycle Counter Filter Register 15; 0x0000057A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR15STR;
extern volatile MBCCFR15STR _MBCCFR15 @(REG_BASE + 0x0000057A);
#define MBCCFR15                        _MBCCFR15.Word
#define MBCCFR15_CCFVAL                 _MBCCFR15.Bits.CCFVAL
#define MBCCFR15_CCFMSK                 _MBCCFR15.Bits.CCFMSK
#define MBCCFR15_CCFE                   _MBCCFR15.Bits.CCFE
#define MBCCFR15_CHB                    _MBCCFR15.Bits.CHB
#define MBCCFR15_CHA                    _MBCCFR15.Bits.CHA
#define MBCCFR15_MTM                    _MBCCFR15.Bits.MTM

#define MBCCFR15_CCFVAL_MASK            63
#define MBCCFR15_CCFVAL_BITNUM          0
#define MBCCFR15_CCFMSK_MASK            4032
#define MBCCFR15_CCFMSK_BITNUM          6
#define MBCCFR15_CCFE_MASK              4096
#define MBCCFR15_CHB_MASK               8192
#define MBCCFR15_CHA_MASK               16384
#define MBCCFR15_MTM_MASK               32768


/*** MBFIDR15 - Message Buffer Frame ID Registers; 0x0000057C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR15STR;
extern volatile MBFIDR15STR _MBFIDR15 @(REG_BASE + 0x0000057C);
#define MBFIDR15                        _MBFIDR15.Word
#define MBFIDR15_FID                    _MBFIDR15.Bits.FID

#define MBFIDR15_FID_MASK               2047
#define MBFIDR15_FID_BITNUM             0


/*** MBIDXR15 - Message Buffer Index Register; 0x0000057E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR15STR;
extern volatile MBIDXR15STR _MBIDXR15 @(REG_BASE + 0x0000057E);
#define MBIDXR15                        _MBIDXR15.Word
#define MBIDXR15_MBIDX                  _MBIDXR15.Bits.MBIDX

#define MBIDXR15_MBIDX_MASK             63
#define MBIDXR15_MBIDX_BITNUM           0


/*** MBCCSR16 - Message Buffer Configuration, Control, Status Register 16; 0x00000580 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR16STR;
extern volatile MBCCSR16STR _MBCCSR16 @(REG_BASE + 0x00000580);
#define MBCCSR16                        _MBCCSR16.Word
#define MBCCSR16_MBIF                   _MBCCSR16.Bits.MBIF
#define MBCCSR16_LCKS                   _MBCCSR16.Bits.LCKS
#define MBCCSR16_EDS                    _MBCCSR16.Bits.EDS
#define MBCCSR16_DVAL                   _MBCCSR16.Bits.DVAL
#define MBCCSR16_DUP                    _MBCCSR16.Bits.DUP
#define MBCCSR16_MBIE                   _MBCCSR16.Bits.MBIE
#define MBCCSR16_LCKT                   _MBCCSR16.Bits.LCKT
#define MBCCSR16_EDT                    _MBCCSR16.Bits.EDT
#define MBCCSR16_CMT                    _MBCCSR16.Bits.CMT
#define MBCCSR16_MTD                    _MBCCSR16.Bits.MTD
#define MBCCSR16_MBT                    _MBCCSR16.Bits.MBT
#define MBCCSR16_MCM                    _MBCCSR16.Bits.MCM

#define MBCCSR16_MBIF_MASK              1
#define MBCCSR16_LCKS_MASK              2
#define MBCCSR16_EDS_MASK               4
#define MBCCSR16_DVAL_MASK              8
#define MBCCSR16_DUP_MASK               16
#define MBCCSR16_MBIE_MASK              256
#define MBCCSR16_LCKT_MASK              512
#define MBCCSR16_EDT_MASK               1024
#define MBCCSR16_CMT_MASK               2048
#define MBCCSR16_MTD_MASK               4096
#define MBCCSR16_MBT_MASK               8192
#define MBCCSR16_MCM_MASK               16384


/*** MBCCFR16 - Message Buffer Cycle Counter Filter Register 16; 0x00000582 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR16STR;
extern volatile MBCCFR16STR _MBCCFR16 @(REG_BASE + 0x00000582);
#define MBCCFR16                        _MBCCFR16.Word
#define MBCCFR16_CCFVAL                 _MBCCFR16.Bits.CCFVAL
#define MBCCFR16_CCFMSK                 _MBCCFR16.Bits.CCFMSK
#define MBCCFR16_CCFE                   _MBCCFR16.Bits.CCFE
#define MBCCFR16_CHB                    _MBCCFR16.Bits.CHB
#define MBCCFR16_CHA                    _MBCCFR16.Bits.CHA
#define MBCCFR16_MTM                    _MBCCFR16.Bits.MTM

#define MBCCFR16_CCFVAL_MASK            63
#define MBCCFR16_CCFVAL_BITNUM          0
#define MBCCFR16_CCFMSK_MASK            4032
#define MBCCFR16_CCFMSK_BITNUM          6
#define MBCCFR16_CCFE_MASK              4096
#define MBCCFR16_CHB_MASK               8192
#define MBCCFR16_CHA_MASK               16384
#define MBCCFR16_MTM_MASK               32768


/*** MBFIDR16 - Message Buffer Frame ID Registers; 0x00000584 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR16STR;
extern volatile MBFIDR16STR _MBFIDR16 @(REG_BASE + 0x00000584);
#define MBFIDR16                        _MBFIDR16.Word
#define MBFIDR16_FID                    _MBFIDR16.Bits.FID

#define MBFIDR16_FID_MASK               2047
#define MBFIDR16_FID_BITNUM             0


/*** MBIDXR16 - Message Buffer Index Register; 0x00000586 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR16STR;
extern volatile MBIDXR16STR _MBIDXR16 @(REG_BASE + 0x00000586);
#define MBIDXR16                        _MBIDXR16.Word
#define MBIDXR16_MBIDX                  _MBIDXR16.Bits.MBIDX

#define MBIDXR16_MBIDX_MASK             63
#define MBIDXR16_MBIDX_BITNUM           0


/*** MBCCSR17 - Message Buffer Configuration, Control, Status Register 17; 0x00000588 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR17STR;
extern volatile MBCCSR17STR _MBCCSR17 @(REG_BASE + 0x00000588);
#define MBCCSR17                        _MBCCSR17.Word
#define MBCCSR17_MBIF                   _MBCCSR17.Bits.MBIF
#define MBCCSR17_LCKS                   _MBCCSR17.Bits.LCKS
#define MBCCSR17_EDS                    _MBCCSR17.Bits.EDS
#define MBCCSR17_DVAL                   _MBCCSR17.Bits.DVAL
#define MBCCSR17_DUP                    _MBCCSR17.Bits.DUP
#define MBCCSR17_MBIE                   _MBCCSR17.Bits.MBIE
#define MBCCSR17_LCKT                   _MBCCSR17.Bits.LCKT
#define MBCCSR17_EDT                    _MBCCSR17.Bits.EDT
#define MBCCSR17_CMT                    _MBCCSR17.Bits.CMT
#define MBCCSR17_MTD                    _MBCCSR17.Bits.MTD
#define MBCCSR17_MBT                    _MBCCSR17.Bits.MBT
#define MBCCSR17_MCM                    _MBCCSR17.Bits.MCM

#define MBCCSR17_MBIF_MASK              1
#define MBCCSR17_LCKS_MASK              2
#define MBCCSR17_EDS_MASK               4
#define MBCCSR17_DVAL_MASK              8
#define MBCCSR17_DUP_MASK               16
#define MBCCSR17_MBIE_MASK              256
#define MBCCSR17_LCKT_MASK              512
#define MBCCSR17_EDT_MASK               1024
#define MBCCSR17_CMT_MASK               2048
#define MBCCSR17_MTD_MASK               4096
#define MBCCSR17_MBT_MASK               8192
#define MBCCSR17_MCM_MASK               16384


/*** MBCCFR17 - Message Buffer Cycle Counter Filter Register 17; 0x0000058A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR17STR;
extern volatile MBCCFR17STR _MBCCFR17 @(REG_BASE + 0x0000058A);
#define MBCCFR17                        _MBCCFR17.Word
#define MBCCFR17_CCFVAL                 _MBCCFR17.Bits.CCFVAL
#define MBCCFR17_CCFMSK                 _MBCCFR17.Bits.CCFMSK
#define MBCCFR17_CCFE                   _MBCCFR17.Bits.CCFE
#define MBCCFR17_CHB                    _MBCCFR17.Bits.CHB
#define MBCCFR17_CHA                    _MBCCFR17.Bits.CHA
#define MBCCFR17_MTM                    _MBCCFR17.Bits.MTM

#define MBCCFR17_CCFVAL_MASK            63
#define MBCCFR17_CCFVAL_BITNUM          0
#define MBCCFR17_CCFMSK_MASK            4032
#define MBCCFR17_CCFMSK_BITNUM          6
#define MBCCFR17_CCFE_MASK              4096
#define MBCCFR17_CHB_MASK               8192
#define MBCCFR17_CHA_MASK               16384
#define MBCCFR17_MTM_MASK               32768


/*** MBFIDR17 - Message Buffer Frame ID Registers; 0x0000058C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR17STR;
extern volatile MBFIDR17STR _MBFIDR17 @(REG_BASE + 0x0000058C);
#define MBFIDR17                        _MBFIDR17.Word
#define MBFIDR17_FID                    _MBFIDR17.Bits.FID

#define MBFIDR17_FID_MASK               2047
#define MBFIDR17_FID_BITNUM             0


/*** MBIDXR17 - Message Buffer Index Register; 0x0000058E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR17STR;
extern volatile MBIDXR17STR _MBIDXR17 @(REG_BASE + 0x0000058E);
#define MBIDXR17                        _MBIDXR17.Word
#define MBIDXR17_MBIDX                  _MBIDXR17.Bits.MBIDX

#define MBIDXR17_MBIDX_MASK             63
#define MBIDXR17_MBIDX_BITNUM           0


/*** MBCCSR18 - Message Buffer Configuration, Control, Status Register 18; 0x00000590 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR18STR;
extern volatile MBCCSR18STR _MBCCSR18 @(REG_BASE + 0x00000590);
#define MBCCSR18                        _MBCCSR18.Word
#define MBCCSR18_MBIF                   _MBCCSR18.Bits.MBIF
#define MBCCSR18_LCKS                   _MBCCSR18.Bits.LCKS
#define MBCCSR18_EDS                    _MBCCSR18.Bits.EDS
#define MBCCSR18_DVAL                   _MBCCSR18.Bits.DVAL
#define MBCCSR18_DUP                    _MBCCSR18.Bits.DUP
#define MBCCSR18_MBIE                   _MBCCSR18.Bits.MBIE
#define MBCCSR18_LCKT                   _MBCCSR18.Bits.LCKT
#define MBCCSR18_EDT                    _MBCCSR18.Bits.EDT
#define MBCCSR18_CMT                    _MBCCSR18.Bits.CMT
#define MBCCSR18_MTD                    _MBCCSR18.Bits.MTD
#define MBCCSR18_MBT                    _MBCCSR18.Bits.MBT
#define MBCCSR18_MCM                    _MBCCSR18.Bits.MCM

#define MBCCSR18_MBIF_MASK              1
#define MBCCSR18_LCKS_MASK              2
#define MBCCSR18_EDS_MASK               4
#define MBCCSR18_DVAL_MASK              8
#define MBCCSR18_DUP_MASK               16
#define MBCCSR18_MBIE_MASK              256
#define MBCCSR18_LCKT_MASK              512
#define MBCCSR18_EDT_MASK               1024
#define MBCCSR18_CMT_MASK               2048
#define MBCCSR18_MTD_MASK               4096
#define MBCCSR18_MBT_MASK               8192
#define MBCCSR18_MCM_MASK               16384


/*** MBCCFR18 - Message Buffer Cycle Counter Filter Register 18; 0x00000592 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR18STR;
extern volatile MBCCFR18STR _MBCCFR18 @(REG_BASE + 0x00000592);
#define MBCCFR18                        _MBCCFR18.Word
#define MBCCFR18_CCFVAL                 _MBCCFR18.Bits.CCFVAL
#define MBCCFR18_CCFMSK                 _MBCCFR18.Bits.CCFMSK
#define MBCCFR18_CCFE                   _MBCCFR18.Bits.CCFE
#define MBCCFR18_CHB                    _MBCCFR18.Bits.CHB
#define MBCCFR18_CHA                    _MBCCFR18.Bits.CHA
#define MBCCFR18_MTM                    _MBCCFR18.Bits.MTM

#define MBCCFR18_CCFVAL_MASK            63
#define MBCCFR18_CCFVAL_BITNUM          0
#define MBCCFR18_CCFMSK_MASK            4032
#define MBCCFR18_CCFMSK_BITNUM          6
#define MBCCFR18_CCFE_MASK              4096
#define MBCCFR18_CHB_MASK               8192
#define MBCCFR18_CHA_MASK               16384
#define MBCCFR18_MTM_MASK               32768


/*** MBFIDR18 - Message Buffer Frame ID Registers; 0x00000594 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR18STR;
extern volatile MBFIDR18STR _MBFIDR18 @(REG_BASE + 0x00000594);
#define MBFIDR18                        _MBFIDR18.Word
#define MBFIDR18_FID                    _MBFIDR18.Bits.FID

#define MBFIDR18_FID_MASK               2047
#define MBFIDR18_FID_BITNUM             0


/*** MBIDXR18 - Message Buffer Index Register; 0x00000596 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR18STR;
extern volatile MBIDXR18STR _MBIDXR18 @(REG_BASE + 0x00000596);
#define MBIDXR18                        _MBIDXR18.Word
#define MBIDXR18_MBIDX                  _MBIDXR18.Bits.MBIDX

#define MBIDXR18_MBIDX_MASK             63
#define MBIDXR18_MBIDX_BITNUM           0


/*** MBCCSR19 - Message Buffer Configuration, Control, Status Register 19; 0x00000598 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR19STR;
extern volatile MBCCSR19STR _MBCCSR19 @(REG_BASE + 0x00000598);
#define MBCCSR19                        _MBCCSR19.Word
#define MBCCSR19_MBIF                   _MBCCSR19.Bits.MBIF
#define MBCCSR19_LCKS                   _MBCCSR19.Bits.LCKS
#define MBCCSR19_EDS                    _MBCCSR19.Bits.EDS
#define MBCCSR19_DVAL                   _MBCCSR19.Bits.DVAL
#define MBCCSR19_DUP                    _MBCCSR19.Bits.DUP
#define MBCCSR19_MBIE                   _MBCCSR19.Bits.MBIE
#define MBCCSR19_LCKT                   _MBCCSR19.Bits.LCKT
#define MBCCSR19_EDT                    _MBCCSR19.Bits.EDT
#define MBCCSR19_CMT                    _MBCCSR19.Bits.CMT
#define MBCCSR19_MTD                    _MBCCSR19.Bits.MTD
#define MBCCSR19_MBT                    _MBCCSR19.Bits.MBT
#define MBCCSR19_MCM                    _MBCCSR19.Bits.MCM

#define MBCCSR19_MBIF_MASK              1
#define MBCCSR19_LCKS_MASK              2
#define MBCCSR19_EDS_MASK               4
#define MBCCSR19_DVAL_MASK              8
#define MBCCSR19_DUP_MASK               16
#define MBCCSR19_MBIE_MASK              256
#define MBCCSR19_LCKT_MASK              512
#define MBCCSR19_EDT_MASK               1024
#define MBCCSR19_CMT_MASK               2048
#define MBCCSR19_MTD_MASK               4096
#define MBCCSR19_MBT_MASK               8192
#define MBCCSR19_MCM_MASK               16384


/*** MBCCFR19 - Message Buffer Cycle Counter Filter Register 19; 0x0000059A ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR19STR;
extern volatile MBCCFR19STR _MBCCFR19 @(REG_BASE + 0x0000059A);
#define MBCCFR19                        _MBCCFR19.Word
#define MBCCFR19_CCFVAL                 _MBCCFR19.Bits.CCFVAL
#define MBCCFR19_CCFMSK                 _MBCCFR19.Bits.CCFMSK
#define MBCCFR19_CCFE                   _MBCCFR19.Bits.CCFE
#define MBCCFR19_CHB                    _MBCCFR19.Bits.CHB
#define MBCCFR19_CHA                    _MBCCFR19.Bits.CHA
#define MBCCFR19_MTM                    _MBCCFR19.Bits.MTM

#define MBCCFR19_CCFVAL_MASK            63
#define MBCCFR19_CCFVAL_BITNUM          0
#define MBCCFR19_CCFMSK_MASK            4032
#define MBCCFR19_CCFMSK_BITNUM          6
#define MBCCFR19_CCFE_MASK              4096
#define MBCCFR19_CHB_MASK               8192
#define MBCCFR19_CHA_MASK               16384
#define MBCCFR19_MTM_MASK               32768


/*** MBFIDR19 - Message Buffer Frame ID Registers; 0x0000059C ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR19STR;
extern volatile MBFIDR19STR _MBFIDR19 @(REG_BASE + 0x0000059C);
#define MBFIDR19                        _MBFIDR19.Word
#define MBFIDR19_FID                    _MBFIDR19.Bits.FID

#define MBFIDR19_FID_MASK               2047
#define MBFIDR19_FID_BITNUM             0


/*** MBIDXR19 - Message Buffer Index Register; 0x0000059E ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR19STR;
extern volatile MBIDXR19STR _MBIDXR19 @(REG_BASE + 0x0000059E);
#define MBIDXR19                        _MBIDXR19.Word
#define MBIDXR19_MBIDX                  _MBIDXR19.Bits.MBIDX

#define MBIDXR19_MBIDX_MASK             63
#define MBIDXR19_MBIDX_BITNUM           0


/*** MBCCSR20 - Message Buffer Configuration, Control, Status Register 20; 0x000005A0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR20STR;
extern volatile MBCCSR20STR _MBCCSR20 @(REG_BASE + 0x000005A0);
#define MBCCSR20                        _MBCCSR20.Word
#define MBCCSR20_MBIF                   _MBCCSR20.Bits.MBIF
#define MBCCSR20_LCKS                   _MBCCSR20.Bits.LCKS
#define MBCCSR20_EDS                    _MBCCSR20.Bits.EDS
#define MBCCSR20_DVAL                   _MBCCSR20.Bits.DVAL
#define MBCCSR20_DUP                    _MBCCSR20.Bits.DUP
#define MBCCSR20_MBIE                   _MBCCSR20.Bits.MBIE
#define MBCCSR20_LCKT                   _MBCCSR20.Bits.LCKT
#define MBCCSR20_EDT                    _MBCCSR20.Bits.EDT
#define MBCCSR20_CMT                    _MBCCSR20.Bits.CMT
#define MBCCSR20_MTD                    _MBCCSR20.Bits.MTD
#define MBCCSR20_MBT                    _MBCCSR20.Bits.MBT
#define MBCCSR20_MCM                    _MBCCSR20.Bits.MCM

#define MBCCSR20_MBIF_MASK              1
#define MBCCSR20_LCKS_MASK              2
#define MBCCSR20_EDS_MASK               4
#define MBCCSR20_DVAL_MASK              8
#define MBCCSR20_DUP_MASK               16
#define MBCCSR20_MBIE_MASK              256
#define MBCCSR20_LCKT_MASK              512
#define MBCCSR20_EDT_MASK               1024
#define MBCCSR20_CMT_MASK               2048
#define MBCCSR20_MTD_MASK               4096
#define MBCCSR20_MBT_MASK               8192
#define MBCCSR20_MCM_MASK               16384


/*** MBCCFR20 - Message Buffer Cycle Counter Filter Register 20; 0x000005A2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR20STR;
extern volatile MBCCFR20STR _MBCCFR20 @(REG_BASE + 0x000005A2);
#define MBCCFR20                        _MBCCFR20.Word
#define MBCCFR20_CCFVAL                 _MBCCFR20.Bits.CCFVAL
#define MBCCFR20_CCFMSK                 _MBCCFR20.Bits.CCFMSK
#define MBCCFR20_CCFE                   _MBCCFR20.Bits.CCFE
#define MBCCFR20_CHB                    _MBCCFR20.Bits.CHB
#define MBCCFR20_CHA                    _MBCCFR20.Bits.CHA
#define MBCCFR20_MTM                    _MBCCFR20.Bits.MTM

#define MBCCFR20_CCFVAL_MASK            63
#define MBCCFR20_CCFVAL_BITNUM          0
#define MBCCFR20_CCFMSK_MASK            4032
#define MBCCFR20_CCFMSK_BITNUM          6
#define MBCCFR20_CCFE_MASK              4096
#define MBCCFR20_CHB_MASK               8192
#define MBCCFR20_CHA_MASK               16384
#define MBCCFR20_MTM_MASK               32768


/*** MBFIDR20 - Message Buffer Frame ID Registers; 0x000005A4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR20STR;
extern volatile MBFIDR20STR _MBFIDR20 @(REG_BASE + 0x000005A4);
#define MBFIDR20                        _MBFIDR20.Word
#define MBFIDR20_FID                    _MBFIDR20.Bits.FID

#define MBFIDR20_FID_MASK               2047
#define MBFIDR20_FID_BITNUM             0


/*** MBIDXR20 - Message Buffer Index Register; 0x000005A6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR20STR;
extern volatile MBIDXR20STR _MBIDXR20 @(REG_BASE + 0x000005A6);
#define MBIDXR20                        _MBIDXR20.Word
#define MBIDXR20_MBIDX                  _MBIDXR20.Bits.MBIDX

#define MBIDXR20_MBIDX_MASK             63
#define MBIDXR20_MBIDX_BITNUM           0


/*** MBCCSR21 - Message Buffer Configuration, Control, Status Register 21; 0x000005A8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR21STR;
extern volatile MBCCSR21STR _MBCCSR21 @(REG_BASE + 0x000005A8);
#define MBCCSR21                        _MBCCSR21.Word
#define MBCCSR21_MBIF                   _MBCCSR21.Bits.MBIF
#define MBCCSR21_LCKS                   _MBCCSR21.Bits.LCKS
#define MBCCSR21_EDS                    _MBCCSR21.Bits.EDS
#define MBCCSR21_DVAL                   _MBCCSR21.Bits.DVAL
#define MBCCSR21_DUP                    _MBCCSR21.Bits.DUP
#define MBCCSR21_MBIE                   _MBCCSR21.Bits.MBIE
#define MBCCSR21_LCKT                   _MBCCSR21.Bits.LCKT
#define MBCCSR21_EDT                    _MBCCSR21.Bits.EDT
#define MBCCSR21_CMT                    _MBCCSR21.Bits.CMT
#define MBCCSR21_MTD                    _MBCCSR21.Bits.MTD
#define MBCCSR21_MBT                    _MBCCSR21.Bits.MBT
#define MBCCSR21_MCM                    _MBCCSR21.Bits.MCM

#define MBCCSR21_MBIF_MASK              1
#define MBCCSR21_LCKS_MASK              2
#define MBCCSR21_EDS_MASK               4
#define MBCCSR21_DVAL_MASK              8
#define MBCCSR21_DUP_MASK               16
#define MBCCSR21_MBIE_MASK              256
#define MBCCSR21_LCKT_MASK              512
#define MBCCSR21_EDT_MASK               1024
#define MBCCSR21_CMT_MASK               2048
#define MBCCSR21_MTD_MASK               4096
#define MBCCSR21_MBT_MASK               8192
#define MBCCSR21_MCM_MASK               16384


/*** MBCCFR21 - Message Buffer Cycle Counter Filter Register 21; 0x000005AA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR21STR;
extern volatile MBCCFR21STR _MBCCFR21 @(REG_BASE + 0x000005AA);
#define MBCCFR21                        _MBCCFR21.Word
#define MBCCFR21_CCFVAL                 _MBCCFR21.Bits.CCFVAL
#define MBCCFR21_CCFMSK                 _MBCCFR21.Bits.CCFMSK
#define MBCCFR21_CCFE                   _MBCCFR21.Bits.CCFE
#define MBCCFR21_CHB                    _MBCCFR21.Bits.CHB
#define MBCCFR21_CHA                    _MBCCFR21.Bits.CHA
#define MBCCFR21_MTM                    _MBCCFR21.Bits.MTM

#define MBCCFR21_CCFVAL_MASK            63
#define MBCCFR21_CCFVAL_BITNUM          0
#define MBCCFR21_CCFMSK_MASK            4032
#define MBCCFR21_CCFMSK_BITNUM          6
#define MBCCFR21_CCFE_MASK              4096
#define MBCCFR21_CHB_MASK               8192
#define MBCCFR21_CHA_MASK               16384
#define MBCCFR21_MTM_MASK               32768


/*** MBFIDR21 - Message Buffer Frame ID Registers; 0x000005AC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR21STR;
extern volatile MBFIDR21STR _MBFIDR21 @(REG_BASE + 0x000005AC);
#define MBFIDR21                        _MBFIDR21.Word
#define MBFIDR21_FID                    _MBFIDR21.Bits.FID

#define MBFIDR21_FID_MASK               2047
#define MBFIDR21_FID_BITNUM             0


/*** MBIDXR21 - Message Buffer Index Register; 0x000005AE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR21STR;
extern volatile MBIDXR21STR _MBIDXR21 @(REG_BASE + 0x000005AE);
#define MBIDXR21                        _MBIDXR21.Word
#define MBIDXR21_MBIDX                  _MBIDXR21.Bits.MBIDX

#define MBIDXR21_MBIDX_MASK             63
#define MBIDXR21_MBIDX_BITNUM           0


/*** MBCCSR22 - Message Buffer Configuration, Control, Status Register 22; 0x000005B0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR22STR;
extern volatile MBCCSR22STR _MBCCSR22 @(REG_BASE + 0x000005B0);
#define MBCCSR22                        _MBCCSR22.Word
#define MBCCSR22_MBIF                   _MBCCSR22.Bits.MBIF
#define MBCCSR22_LCKS                   _MBCCSR22.Bits.LCKS
#define MBCCSR22_EDS                    _MBCCSR22.Bits.EDS
#define MBCCSR22_DVAL                   _MBCCSR22.Bits.DVAL
#define MBCCSR22_DUP                    _MBCCSR22.Bits.DUP
#define MBCCSR22_MBIE                   _MBCCSR22.Bits.MBIE
#define MBCCSR22_LCKT                   _MBCCSR22.Bits.LCKT
#define MBCCSR22_EDT                    _MBCCSR22.Bits.EDT
#define MBCCSR22_CMT                    _MBCCSR22.Bits.CMT
#define MBCCSR22_MTD                    _MBCCSR22.Bits.MTD
#define MBCCSR22_MBT                    _MBCCSR22.Bits.MBT
#define MBCCSR22_MCM                    _MBCCSR22.Bits.MCM

#define MBCCSR22_MBIF_MASK              1
#define MBCCSR22_LCKS_MASK              2
#define MBCCSR22_EDS_MASK               4
#define MBCCSR22_DVAL_MASK              8
#define MBCCSR22_DUP_MASK               16
#define MBCCSR22_MBIE_MASK              256
#define MBCCSR22_LCKT_MASK              512
#define MBCCSR22_EDT_MASK               1024
#define MBCCSR22_CMT_MASK               2048
#define MBCCSR22_MTD_MASK               4096
#define MBCCSR22_MBT_MASK               8192
#define MBCCSR22_MCM_MASK               16384


/*** MBCCFR22 - Message Buffer Cycle Counter Filter Register 22; 0x000005B2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR22STR;
extern volatile MBCCFR22STR _MBCCFR22 @(REG_BASE + 0x000005B2);
#define MBCCFR22                        _MBCCFR22.Word
#define MBCCFR22_CCFVAL                 _MBCCFR22.Bits.CCFVAL
#define MBCCFR22_CCFMSK                 _MBCCFR22.Bits.CCFMSK
#define MBCCFR22_CCFE                   _MBCCFR22.Bits.CCFE
#define MBCCFR22_CHB                    _MBCCFR22.Bits.CHB
#define MBCCFR22_CHA                    _MBCCFR22.Bits.CHA
#define MBCCFR22_MTM                    _MBCCFR22.Bits.MTM

#define MBCCFR22_CCFVAL_MASK            63
#define MBCCFR22_CCFVAL_BITNUM          0
#define MBCCFR22_CCFMSK_MASK            4032
#define MBCCFR22_CCFMSK_BITNUM          6
#define MBCCFR22_CCFE_MASK              4096
#define MBCCFR22_CHB_MASK               8192
#define MBCCFR22_CHA_MASK               16384
#define MBCCFR22_MTM_MASK               32768


/*** MBFIDR22 - Message Buffer Frame ID Registers; 0x000005B4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR22STR;
extern volatile MBFIDR22STR _MBFIDR22 @(REG_BASE + 0x000005B4);
#define MBFIDR22                        _MBFIDR22.Word
#define MBFIDR22_FID                    _MBFIDR22.Bits.FID

#define MBFIDR22_FID_MASK               2047
#define MBFIDR22_FID_BITNUM             0


/*** MBIDXR22 - Message Buffer Index Register; 0x000005B6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR22STR;
extern volatile MBIDXR22STR _MBIDXR22 @(REG_BASE + 0x000005B6);
#define MBIDXR22                        _MBIDXR22.Word
#define MBIDXR22_MBIDX                  _MBIDXR22.Bits.MBIDX

#define MBIDXR22_MBIDX_MASK             63
#define MBIDXR22_MBIDX_BITNUM           0


/*** MBCCSR23 - Message Buffer Configuration, Control, Status Register 23; 0x000005B8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR23STR;
extern volatile MBCCSR23STR _MBCCSR23 @(REG_BASE + 0x000005B8);
#define MBCCSR23                        _MBCCSR23.Word
#define MBCCSR23_MBIF                   _MBCCSR23.Bits.MBIF
#define MBCCSR23_LCKS                   _MBCCSR23.Bits.LCKS
#define MBCCSR23_EDS                    _MBCCSR23.Bits.EDS
#define MBCCSR23_DVAL                   _MBCCSR23.Bits.DVAL
#define MBCCSR23_DUP                    _MBCCSR23.Bits.DUP
#define MBCCSR23_MBIE                   _MBCCSR23.Bits.MBIE
#define MBCCSR23_LCKT                   _MBCCSR23.Bits.LCKT
#define MBCCSR23_EDT                    _MBCCSR23.Bits.EDT
#define MBCCSR23_CMT                    _MBCCSR23.Bits.CMT
#define MBCCSR23_MTD                    _MBCCSR23.Bits.MTD
#define MBCCSR23_MBT                    _MBCCSR23.Bits.MBT
#define MBCCSR23_MCM                    _MBCCSR23.Bits.MCM

#define MBCCSR23_MBIF_MASK              1
#define MBCCSR23_LCKS_MASK              2
#define MBCCSR23_EDS_MASK               4
#define MBCCSR23_DVAL_MASK              8
#define MBCCSR23_DUP_MASK               16
#define MBCCSR23_MBIE_MASK              256
#define MBCCSR23_LCKT_MASK              512
#define MBCCSR23_EDT_MASK               1024
#define MBCCSR23_CMT_MASK               2048
#define MBCCSR23_MTD_MASK               4096
#define MBCCSR23_MBT_MASK               8192
#define MBCCSR23_MCM_MASK               16384


/*** MBCCFR23 - Message Buffer Cycle Counter Filter Register 23; 0x000005BA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR23STR;
extern volatile MBCCFR23STR _MBCCFR23 @(REG_BASE + 0x000005BA);
#define MBCCFR23                        _MBCCFR23.Word
#define MBCCFR23_CCFVAL                 _MBCCFR23.Bits.CCFVAL
#define MBCCFR23_CCFMSK                 _MBCCFR23.Bits.CCFMSK
#define MBCCFR23_CCFE                   _MBCCFR23.Bits.CCFE
#define MBCCFR23_CHB                    _MBCCFR23.Bits.CHB
#define MBCCFR23_CHA                    _MBCCFR23.Bits.CHA
#define MBCCFR23_MTM                    _MBCCFR23.Bits.MTM

#define MBCCFR23_CCFVAL_MASK            63
#define MBCCFR23_CCFVAL_BITNUM          0
#define MBCCFR23_CCFMSK_MASK            4032
#define MBCCFR23_CCFMSK_BITNUM          6
#define MBCCFR23_CCFE_MASK              4096
#define MBCCFR23_CHB_MASK               8192
#define MBCCFR23_CHA_MASK               16384
#define MBCCFR23_MTM_MASK               32768


/*** MBFIDR23 - Message Buffer Frame ID Registers; 0x000005BC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR23STR;
extern volatile MBFIDR23STR _MBFIDR23 @(REG_BASE + 0x000005BC);
#define MBFIDR23                        _MBFIDR23.Word
#define MBFIDR23_FID                    _MBFIDR23.Bits.FID

#define MBFIDR23_FID_MASK               2047
#define MBFIDR23_FID_BITNUM             0


/*** MBIDXR23 - Message Buffer Index Register; 0x000005BE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR23STR;
extern volatile MBIDXR23STR _MBIDXR23 @(REG_BASE + 0x000005BE);
#define MBIDXR23                        _MBIDXR23.Word
#define MBIDXR23_MBIDX                  _MBIDXR23.Bits.MBIDX

#define MBIDXR23_MBIDX_MASK             63
#define MBIDXR23_MBIDX_BITNUM           0


/*** MBCCSR24 - Message Buffer Configuration, Control, Status Register 24; 0x000005C0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR24STR;
extern volatile MBCCSR24STR _MBCCSR24 @(REG_BASE + 0x000005C0);
#define MBCCSR24                        _MBCCSR24.Word
#define MBCCSR24_MBIF                   _MBCCSR24.Bits.MBIF
#define MBCCSR24_LCKS                   _MBCCSR24.Bits.LCKS
#define MBCCSR24_EDS                    _MBCCSR24.Bits.EDS
#define MBCCSR24_DVAL                   _MBCCSR24.Bits.DVAL
#define MBCCSR24_DUP                    _MBCCSR24.Bits.DUP
#define MBCCSR24_MBIE                   _MBCCSR24.Bits.MBIE
#define MBCCSR24_LCKT                   _MBCCSR24.Bits.LCKT
#define MBCCSR24_EDT                    _MBCCSR24.Bits.EDT
#define MBCCSR24_CMT                    _MBCCSR24.Bits.CMT
#define MBCCSR24_MTD                    _MBCCSR24.Bits.MTD
#define MBCCSR24_MBT                    _MBCCSR24.Bits.MBT
#define MBCCSR24_MCM                    _MBCCSR24.Bits.MCM

#define MBCCSR24_MBIF_MASK              1
#define MBCCSR24_LCKS_MASK              2
#define MBCCSR24_EDS_MASK               4
#define MBCCSR24_DVAL_MASK              8
#define MBCCSR24_DUP_MASK               16
#define MBCCSR24_MBIE_MASK              256
#define MBCCSR24_LCKT_MASK              512
#define MBCCSR24_EDT_MASK               1024
#define MBCCSR24_CMT_MASK               2048
#define MBCCSR24_MTD_MASK               4096
#define MBCCSR24_MBT_MASK               8192
#define MBCCSR24_MCM_MASK               16384


/*** MBCCFR24 - Message Buffer Cycle Counter Filter Register 24; 0x000005C2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR24STR;
extern volatile MBCCFR24STR _MBCCFR24 @(REG_BASE + 0x000005C2);
#define MBCCFR24                        _MBCCFR24.Word
#define MBCCFR24_CCFVAL                 _MBCCFR24.Bits.CCFVAL
#define MBCCFR24_CCFMSK                 _MBCCFR24.Bits.CCFMSK
#define MBCCFR24_CCFE                   _MBCCFR24.Bits.CCFE
#define MBCCFR24_CHB                    _MBCCFR24.Bits.CHB
#define MBCCFR24_CHA                    _MBCCFR24.Bits.CHA
#define MBCCFR24_MTM                    _MBCCFR24.Bits.MTM

#define MBCCFR24_CCFVAL_MASK            63
#define MBCCFR24_CCFVAL_BITNUM          0
#define MBCCFR24_CCFMSK_MASK            4032
#define MBCCFR24_CCFMSK_BITNUM          6
#define MBCCFR24_CCFE_MASK              4096
#define MBCCFR24_CHB_MASK               8192
#define MBCCFR24_CHA_MASK               16384
#define MBCCFR24_MTM_MASK               32768


/*** MBFIDR24 - Message Buffer Frame ID Registers; 0x000005C4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR24STR;
extern volatile MBFIDR24STR _MBFIDR24 @(REG_BASE + 0x000005C4);
#define MBFIDR24                        _MBFIDR24.Word
#define MBFIDR24_FID                    _MBFIDR24.Bits.FID

#define MBFIDR24_FID_MASK               2047
#define MBFIDR24_FID_BITNUM             0


/*** MBIDXR24 - Message Buffer Index Register; 0x000005C6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR24STR;
extern volatile MBIDXR24STR _MBIDXR24 @(REG_BASE + 0x000005C6);
#define MBIDXR24                        _MBIDXR24.Word
#define MBIDXR24_MBIDX                  _MBIDXR24.Bits.MBIDX

#define MBIDXR24_MBIDX_MASK             63
#define MBIDXR24_MBIDX_BITNUM           0


/*** MBCCSR25 - Message Buffer Configuration, Control, Status Register 25; 0x000005C8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR25STR;
extern volatile MBCCSR25STR _MBCCSR25 @(REG_BASE + 0x000005C8);
#define MBCCSR25                        _MBCCSR25.Word
#define MBCCSR25_MBIF                   _MBCCSR25.Bits.MBIF
#define MBCCSR25_LCKS                   _MBCCSR25.Bits.LCKS
#define MBCCSR25_EDS                    _MBCCSR25.Bits.EDS
#define MBCCSR25_DVAL                   _MBCCSR25.Bits.DVAL
#define MBCCSR25_DUP                    _MBCCSR25.Bits.DUP
#define MBCCSR25_MBIE                   _MBCCSR25.Bits.MBIE
#define MBCCSR25_LCKT                   _MBCCSR25.Bits.LCKT
#define MBCCSR25_EDT                    _MBCCSR25.Bits.EDT
#define MBCCSR25_CMT                    _MBCCSR25.Bits.CMT
#define MBCCSR25_MTD                    _MBCCSR25.Bits.MTD
#define MBCCSR25_MBT                    _MBCCSR25.Bits.MBT
#define MBCCSR25_MCM                    _MBCCSR25.Bits.MCM

#define MBCCSR25_MBIF_MASK              1
#define MBCCSR25_LCKS_MASK              2
#define MBCCSR25_EDS_MASK               4
#define MBCCSR25_DVAL_MASK              8
#define MBCCSR25_DUP_MASK               16
#define MBCCSR25_MBIE_MASK              256
#define MBCCSR25_LCKT_MASK              512
#define MBCCSR25_EDT_MASK               1024
#define MBCCSR25_CMT_MASK               2048
#define MBCCSR25_MTD_MASK               4096
#define MBCCSR25_MBT_MASK               8192
#define MBCCSR25_MCM_MASK               16384


/*** MBCCFR25 - Message Buffer Cycle Counter Filter Register 25; 0x000005CA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR25STR;
extern volatile MBCCFR25STR _MBCCFR25 @(REG_BASE + 0x000005CA);
#define MBCCFR25                        _MBCCFR25.Word
#define MBCCFR25_CCFVAL                 _MBCCFR25.Bits.CCFVAL
#define MBCCFR25_CCFMSK                 _MBCCFR25.Bits.CCFMSK
#define MBCCFR25_CCFE                   _MBCCFR25.Bits.CCFE
#define MBCCFR25_CHB                    _MBCCFR25.Bits.CHB
#define MBCCFR25_CHA                    _MBCCFR25.Bits.CHA
#define MBCCFR25_MTM                    _MBCCFR25.Bits.MTM

#define MBCCFR25_CCFVAL_MASK            63
#define MBCCFR25_CCFVAL_BITNUM          0
#define MBCCFR25_CCFMSK_MASK            4032
#define MBCCFR25_CCFMSK_BITNUM          6
#define MBCCFR25_CCFE_MASK              4096
#define MBCCFR25_CHB_MASK               8192
#define MBCCFR25_CHA_MASK               16384
#define MBCCFR25_MTM_MASK               32768


/*** MBFIDR25 - Message Buffer Frame ID Registers; 0x000005CC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR25STR;
extern volatile MBFIDR25STR _MBFIDR25 @(REG_BASE + 0x000005CC);
#define MBFIDR25                        _MBFIDR25.Word
#define MBFIDR25_FID                    _MBFIDR25.Bits.FID

#define MBFIDR25_FID_MASK               2047
#define MBFIDR25_FID_BITNUM             0


/*** MBIDXR25 - Message Buffer Index Register; 0x000005CE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR25STR;
extern volatile MBIDXR25STR _MBIDXR25 @(REG_BASE + 0x000005CE);
#define MBIDXR25                        _MBIDXR25.Word
#define MBIDXR25_MBIDX                  _MBIDXR25.Bits.MBIDX

#define MBIDXR25_MBIDX_MASK             63
#define MBIDXR25_MBIDX_BITNUM           0


/*** MBCCSR26 - Message Buffer Configuration, Control, Status Register 26; 0x000005D0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR26STR;
extern volatile MBCCSR26STR _MBCCSR26 @(REG_BASE + 0x000005D0);
#define MBCCSR26                        _MBCCSR26.Word
#define MBCCSR26_MBIF                   _MBCCSR26.Bits.MBIF
#define MBCCSR26_LCKS                   _MBCCSR26.Bits.LCKS
#define MBCCSR26_EDS                    _MBCCSR26.Bits.EDS
#define MBCCSR26_DVAL                   _MBCCSR26.Bits.DVAL
#define MBCCSR26_DUP                    _MBCCSR26.Bits.DUP
#define MBCCSR26_MBIE                   _MBCCSR26.Bits.MBIE
#define MBCCSR26_LCKT                   _MBCCSR26.Bits.LCKT
#define MBCCSR26_EDT                    _MBCCSR26.Bits.EDT
#define MBCCSR26_CMT                    _MBCCSR26.Bits.CMT
#define MBCCSR26_MTD                    _MBCCSR26.Bits.MTD
#define MBCCSR26_MBT                    _MBCCSR26.Bits.MBT
#define MBCCSR26_MCM                    _MBCCSR26.Bits.MCM

#define MBCCSR26_MBIF_MASK              1
#define MBCCSR26_LCKS_MASK              2
#define MBCCSR26_EDS_MASK               4
#define MBCCSR26_DVAL_MASK              8
#define MBCCSR26_DUP_MASK               16
#define MBCCSR26_MBIE_MASK              256
#define MBCCSR26_LCKT_MASK              512
#define MBCCSR26_EDT_MASK               1024
#define MBCCSR26_CMT_MASK               2048
#define MBCCSR26_MTD_MASK               4096
#define MBCCSR26_MBT_MASK               8192
#define MBCCSR26_MCM_MASK               16384


/*** MBCCFR26 - Message Buffer Cycle Counter Filter Register 26; 0x000005D2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR26STR;
extern volatile MBCCFR26STR _MBCCFR26 @(REG_BASE + 0x000005D2);
#define MBCCFR26                        _MBCCFR26.Word
#define MBCCFR26_CCFVAL                 _MBCCFR26.Bits.CCFVAL
#define MBCCFR26_CCFMSK                 _MBCCFR26.Bits.CCFMSK
#define MBCCFR26_CCFE                   _MBCCFR26.Bits.CCFE
#define MBCCFR26_CHB                    _MBCCFR26.Bits.CHB
#define MBCCFR26_CHA                    _MBCCFR26.Bits.CHA
#define MBCCFR26_MTM                    _MBCCFR26.Bits.MTM

#define MBCCFR26_CCFVAL_MASK            63
#define MBCCFR26_CCFVAL_BITNUM          0
#define MBCCFR26_CCFMSK_MASK            4032
#define MBCCFR26_CCFMSK_BITNUM          6
#define MBCCFR26_CCFE_MASK              4096
#define MBCCFR26_CHB_MASK               8192
#define MBCCFR26_CHA_MASK               16384
#define MBCCFR26_MTM_MASK               32768


/*** MBFIDR26 - Message Buffer Frame ID Registers; 0x000005D4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR26STR;
extern volatile MBFIDR26STR _MBFIDR26 @(REG_BASE + 0x000005D4);
#define MBFIDR26                        _MBFIDR26.Word
#define MBFIDR26_FID                    _MBFIDR26.Bits.FID

#define MBFIDR26_FID_MASK               2047
#define MBFIDR26_FID_BITNUM             0


/*** MBIDXR26 - Message Buffer Index Register; 0x000005D6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR26STR;
extern volatile MBIDXR26STR _MBIDXR26 @(REG_BASE + 0x000005D6);
#define MBIDXR26                        _MBIDXR26.Word
#define MBIDXR26_MBIDX                  _MBIDXR26.Bits.MBIDX

#define MBIDXR26_MBIDX_MASK             63
#define MBIDXR26_MBIDX_BITNUM           0


/*** MBCCSR27 - Message Buffer Configuration, Control, Status Register 27; 0x000005D8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR27STR;
extern volatile MBCCSR27STR _MBCCSR27 @(REG_BASE + 0x000005D8);
#define MBCCSR27                        _MBCCSR27.Word
#define MBCCSR27_MBIF                   _MBCCSR27.Bits.MBIF
#define MBCCSR27_LCKS                   _MBCCSR27.Bits.LCKS
#define MBCCSR27_EDS                    _MBCCSR27.Bits.EDS
#define MBCCSR27_DVAL                   _MBCCSR27.Bits.DVAL
#define MBCCSR27_DUP                    _MBCCSR27.Bits.DUP
#define MBCCSR27_MBIE                   _MBCCSR27.Bits.MBIE
#define MBCCSR27_LCKT                   _MBCCSR27.Bits.LCKT
#define MBCCSR27_EDT                    _MBCCSR27.Bits.EDT
#define MBCCSR27_CMT                    _MBCCSR27.Bits.CMT
#define MBCCSR27_MTD                    _MBCCSR27.Bits.MTD
#define MBCCSR27_MBT                    _MBCCSR27.Bits.MBT
#define MBCCSR27_MCM                    _MBCCSR27.Bits.MCM

#define MBCCSR27_MBIF_MASK              1
#define MBCCSR27_LCKS_MASK              2
#define MBCCSR27_EDS_MASK               4
#define MBCCSR27_DVAL_MASK              8
#define MBCCSR27_DUP_MASK               16
#define MBCCSR27_MBIE_MASK              256
#define MBCCSR27_LCKT_MASK              512
#define MBCCSR27_EDT_MASK               1024
#define MBCCSR27_CMT_MASK               2048
#define MBCCSR27_MTD_MASK               4096
#define MBCCSR27_MBT_MASK               8192
#define MBCCSR27_MCM_MASK               16384


/*** MBCCFR27 - Message Buffer Cycle Counter Filter Register 27; 0x000005DA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR27STR;
extern volatile MBCCFR27STR _MBCCFR27 @(REG_BASE + 0x000005DA);
#define MBCCFR27                        _MBCCFR27.Word
#define MBCCFR27_CCFVAL                 _MBCCFR27.Bits.CCFVAL
#define MBCCFR27_CCFMSK                 _MBCCFR27.Bits.CCFMSK
#define MBCCFR27_CCFE                   _MBCCFR27.Bits.CCFE
#define MBCCFR27_CHB                    _MBCCFR27.Bits.CHB
#define MBCCFR27_CHA                    _MBCCFR27.Bits.CHA
#define MBCCFR27_MTM                    _MBCCFR27.Bits.MTM

#define MBCCFR27_CCFVAL_MASK            63
#define MBCCFR27_CCFVAL_BITNUM          0
#define MBCCFR27_CCFMSK_MASK            4032
#define MBCCFR27_CCFMSK_BITNUM          6
#define MBCCFR27_CCFE_MASK              4096
#define MBCCFR27_CHB_MASK               8192
#define MBCCFR27_CHA_MASK               16384
#define MBCCFR27_MTM_MASK               32768


/*** MBFIDR27 - Message Buffer Frame ID Registers; 0x000005DC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR27STR;
extern volatile MBFIDR27STR _MBFIDR27 @(REG_BASE + 0x000005DC);
#define MBFIDR27                        _MBFIDR27.Word
#define MBFIDR27_FID                    _MBFIDR27.Bits.FID

#define MBFIDR27_FID_MASK               2047
#define MBFIDR27_FID_BITNUM             0


/*** MBIDXR27 - Message Buffer Index Register; 0x000005DE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR27STR;
extern volatile MBIDXR27STR _MBIDXR27 @(REG_BASE + 0x000005DE);
#define MBIDXR27                        _MBIDXR27.Word
#define MBIDXR27_MBIDX                  _MBIDXR27.Bits.MBIDX

#define MBIDXR27_MBIDX_MASK             63
#define MBIDXR27_MBIDX_BITNUM           0


/*** MBCCSR28 - Message Buffer Configuration, Control, Status Register 28; 0x000005E0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR28STR;
extern volatile MBCCSR28STR _MBCCSR28 @(REG_BASE + 0x000005E0);
#define MBCCSR28                        _MBCCSR28.Word
#define MBCCSR28_MBIF                   _MBCCSR28.Bits.MBIF
#define MBCCSR28_LCKS                   _MBCCSR28.Bits.LCKS
#define MBCCSR28_EDS                    _MBCCSR28.Bits.EDS
#define MBCCSR28_DVAL                   _MBCCSR28.Bits.DVAL
#define MBCCSR28_DUP                    _MBCCSR28.Bits.DUP
#define MBCCSR28_MBIE                   _MBCCSR28.Bits.MBIE
#define MBCCSR28_LCKT                   _MBCCSR28.Bits.LCKT
#define MBCCSR28_EDT                    _MBCCSR28.Bits.EDT
#define MBCCSR28_CMT                    _MBCCSR28.Bits.CMT
#define MBCCSR28_MTD                    _MBCCSR28.Bits.MTD
#define MBCCSR28_MBT                    _MBCCSR28.Bits.MBT
#define MBCCSR28_MCM                    _MBCCSR28.Bits.MCM

#define MBCCSR28_MBIF_MASK              1
#define MBCCSR28_LCKS_MASK              2
#define MBCCSR28_EDS_MASK               4
#define MBCCSR28_DVAL_MASK              8
#define MBCCSR28_DUP_MASK               16
#define MBCCSR28_MBIE_MASK              256
#define MBCCSR28_LCKT_MASK              512
#define MBCCSR28_EDT_MASK               1024
#define MBCCSR28_CMT_MASK               2048
#define MBCCSR28_MTD_MASK               4096
#define MBCCSR28_MBT_MASK               8192
#define MBCCSR28_MCM_MASK               16384


/*** MBCCFR28 - Message Buffer Cycle Counter Filter Register 28; 0x000005E2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR28STR;
extern volatile MBCCFR28STR _MBCCFR28 @(REG_BASE + 0x000005E2);
#define MBCCFR28                        _MBCCFR28.Word
#define MBCCFR28_CCFVAL                 _MBCCFR28.Bits.CCFVAL
#define MBCCFR28_CCFMSK                 _MBCCFR28.Bits.CCFMSK
#define MBCCFR28_CCFE                   _MBCCFR28.Bits.CCFE
#define MBCCFR28_CHB                    _MBCCFR28.Bits.CHB
#define MBCCFR28_CHA                    _MBCCFR28.Bits.CHA
#define MBCCFR28_MTM                    _MBCCFR28.Bits.MTM

#define MBCCFR28_CCFVAL_MASK            63
#define MBCCFR28_CCFVAL_BITNUM          0
#define MBCCFR28_CCFMSK_MASK            4032
#define MBCCFR28_CCFMSK_BITNUM          6
#define MBCCFR28_CCFE_MASK              4096
#define MBCCFR28_CHB_MASK               8192
#define MBCCFR28_CHA_MASK               16384
#define MBCCFR28_MTM_MASK               32768


/*** MBFIDR28 - Message Buffer Frame ID Registers; 0x000005E4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR28STR;
extern volatile MBFIDR28STR _MBFIDR28 @(REG_BASE + 0x000005E4);
#define MBFIDR28                        _MBFIDR28.Word
#define MBFIDR28_FID                    _MBFIDR28.Bits.FID

#define MBFIDR28_FID_MASK               2047
#define MBFIDR28_FID_BITNUM             0


/*** MBIDXR28 - Message Buffer Index Register; 0x000005E6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR28STR;
extern volatile MBIDXR28STR _MBIDXR28 @(REG_BASE + 0x000005E6);
#define MBIDXR28                        _MBIDXR28.Word
#define MBIDXR28_MBIDX                  _MBIDXR28.Bits.MBIDX

#define MBIDXR28_MBIDX_MASK             63
#define MBIDXR28_MBIDX_BITNUM           0


/*** MBCCSR29 - Message Buffer Configuration, Control, Status Register 29; 0x000005E8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR29STR;
extern volatile MBCCSR29STR _MBCCSR29 @(REG_BASE + 0x000005E8);
#define MBCCSR29                        _MBCCSR29.Word
#define MBCCSR29_MBIF                   _MBCCSR29.Bits.MBIF
#define MBCCSR29_LCKS                   _MBCCSR29.Bits.LCKS
#define MBCCSR29_EDS                    _MBCCSR29.Bits.EDS
#define MBCCSR29_DVAL                   _MBCCSR29.Bits.DVAL
#define MBCCSR29_DUP                    _MBCCSR29.Bits.DUP
#define MBCCSR29_MBIE                   _MBCCSR29.Bits.MBIE
#define MBCCSR29_LCKT                   _MBCCSR29.Bits.LCKT
#define MBCCSR29_EDT                    _MBCCSR29.Bits.EDT
#define MBCCSR29_CMT                    _MBCCSR29.Bits.CMT
#define MBCCSR29_MTD                    _MBCCSR29.Bits.MTD
#define MBCCSR29_MBT                    _MBCCSR29.Bits.MBT
#define MBCCSR29_MCM                    _MBCCSR29.Bits.MCM

#define MBCCSR29_MBIF_MASK              1
#define MBCCSR29_LCKS_MASK              2
#define MBCCSR29_EDS_MASK               4
#define MBCCSR29_DVAL_MASK              8
#define MBCCSR29_DUP_MASK               16
#define MBCCSR29_MBIE_MASK              256
#define MBCCSR29_LCKT_MASK              512
#define MBCCSR29_EDT_MASK               1024
#define MBCCSR29_CMT_MASK               2048
#define MBCCSR29_MTD_MASK               4096
#define MBCCSR29_MBT_MASK               8192
#define MBCCSR29_MCM_MASK               16384


/*** MBCCFR29 - Message Buffer Cycle Counter Filter Register 29; 0x000005EA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR29STR;
extern volatile MBCCFR29STR _MBCCFR29 @(REG_BASE + 0x000005EA);
#define MBCCFR29                        _MBCCFR29.Word
#define MBCCFR29_CCFVAL                 _MBCCFR29.Bits.CCFVAL
#define MBCCFR29_CCFMSK                 _MBCCFR29.Bits.CCFMSK
#define MBCCFR29_CCFE                   _MBCCFR29.Bits.CCFE
#define MBCCFR29_CHB                    _MBCCFR29.Bits.CHB
#define MBCCFR29_CHA                    _MBCCFR29.Bits.CHA
#define MBCCFR29_MTM                    _MBCCFR29.Bits.MTM

#define MBCCFR29_CCFVAL_MASK            63
#define MBCCFR29_CCFVAL_BITNUM          0
#define MBCCFR29_CCFMSK_MASK            4032
#define MBCCFR29_CCFMSK_BITNUM          6
#define MBCCFR29_CCFE_MASK              4096
#define MBCCFR29_CHB_MASK               8192
#define MBCCFR29_CHA_MASK               16384
#define MBCCFR29_MTM_MASK               32768


/*** MBFIDR29 - Message Buffer Frame ID Registers; 0x000005EC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR29STR;
extern volatile MBFIDR29STR _MBFIDR29 @(REG_BASE + 0x000005EC);
#define MBFIDR29                        _MBFIDR29.Word
#define MBFIDR29_FID                    _MBFIDR29.Bits.FID

#define MBFIDR29_FID_MASK               2047
#define MBFIDR29_FID_BITNUM             0


/*** MBIDXR29 - Message Buffer Index Register; 0x000005EE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR29STR;
extern volatile MBIDXR29STR _MBIDXR29 @(REG_BASE + 0x000005EE);
#define MBIDXR29                        _MBIDXR29.Word
#define MBIDXR29_MBIDX                  _MBIDXR29.Bits.MBIDX

#define MBIDXR29_MBIDX_MASK             63
#define MBIDXR29_MBIDX_BITNUM           0


/*** MBCCSR30 - Message Buffer Configuration, Control, Status Register 30; 0x000005F0 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR30STR;
extern volatile MBCCSR30STR _MBCCSR30 @(REG_BASE + 0x000005F0);
#define MBCCSR30                        _MBCCSR30.Word
#define MBCCSR30_MBIF                   _MBCCSR30.Bits.MBIF
#define MBCCSR30_LCKS                   _MBCCSR30.Bits.LCKS
#define MBCCSR30_EDS                    _MBCCSR30.Bits.EDS
#define MBCCSR30_DVAL                   _MBCCSR30.Bits.DVAL
#define MBCCSR30_DUP                    _MBCCSR30.Bits.DUP
#define MBCCSR30_MBIE                   _MBCCSR30.Bits.MBIE
#define MBCCSR30_LCKT                   _MBCCSR30.Bits.LCKT
#define MBCCSR30_EDT                    _MBCCSR30.Bits.EDT
#define MBCCSR30_CMT                    _MBCCSR30.Bits.CMT
#define MBCCSR30_MTD                    _MBCCSR30.Bits.MTD
#define MBCCSR30_MBT                    _MBCCSR30.Bits.MBT
#define MBCCSR30_MCM                    _MBCCSR30.Bits.MCM

#define MBCCSR30_MBIF_MASK              1
#define MBCCSR30_LCKS_MASK              2
#define MBCCSR30_EDS_MASK               4
#define MBCCSR30_DVAL_MASK              8
#define MBCCSR30_DUP_MASK               16
#define MBCCSR30_MBIE_MASK              256
#define MBCCSR30_LCKT_MASK              512
#define MBCCSR30_EDT_MASK               1024
#define MBCCSR30_CMT_MASK               2048
#define MBCCSR30_MTD_MASK               4096
#define MBCCSR30_MBT_MASK               8192
#define MBCCSR30_MCM_MASK               16384


/*** MBCCFR30 - Message Buffer Cycle Counter Filter Register 30; 0x000005F2 ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR30STR;
extern volatile MBCCFR30STR _MBCCFR30 @(REG_BASE + 0x000005F2);
#define MBCCFR30                        _MBCCFR30.Word
#define MBCCFR30_CCFVAL                 _MBCCFR30.Bits.CCFVAL
#define MBCCFR30_CCFMSK                 _MBCCFR30.Bits.CCFMSK
#define MBCCFR30_CCFE                   _MBCCFR30.Bits.CCFE
#define MBCCFR30_CHB                    _MBCCFR30.Bits.CHB
#define MBCCFR30_CHA                    _MBCCFR30.Bits.CHA
#define MBCCFR30_MTM                    _MBCCFR30.Bits.MTM

#define MBCCFR30_CCFVAL_MASK            63
#define MBCCFR30_CCFVAL_BITNUM          0
#define MBCCFR30_CCFMSK_MASK            4032
#define MBCCFR30_CCFMSK_BITNUM          6
#define MBCCFR30_CCFE_MASK              4096
#define MBCCFR30_CHB_MASK               8192
#define MBCCFR30_CHA_MASK               16384
#define MBCCFR30_MTM_MASK               32768


/*** MBFIDR30 - Message Buffer Frame ID Registers; 0x000005F4 ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR30STR;
extern volatile MBFIDR30STR _MBFIDR30 @(REG_BASE + 0x000005F4);
#define MBFIDR30                        _MBFIDR30.Word
#define MBFIDR30_FID                    _MBFIDR30.Bits.FID

#define MBFIDR30_FID_MASK               2047
#define MBFIDR30_FID_BITNUM             0


/*** MBIDXR30 - Message Buffer Index Register; 0x000005F6 ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR30STR;
extern volatile MBIDXR30STR _MBIDXR30 @(REG_BASE + 0x000005F6);
#define MBIDXR30                        _MBIDXR30.Word
#define MBIDXR30_MBIDX                  _MBIDXR30.Bits.MBIDX

#define MBIDXR30_MBIDX_MASK             63
#define MBIDXR30_MBIDX_BITNUM           0


/*** MBCCSR31 - Message Buffer Configuration, Control, Status Register 31; 0x000005F8 ***/
typedef union {
  word Word;
  struct {
    word MBIF        :1;                                       /* Message Buffer Interrupt Flag */
    word LCKS        :1;                                       /* Lock Status */
    word EDS         :1;                                       /* Enable/Disable Status */
    word DVAL        :1;                                       /* Data Valid */
    word DUP         :1;                                       /* Data Updated */
    word             :1; 
    word             :1; 
    word             :1; 
    word MBIE        :1;                                       /* Message Buffer Interrupt Enable */
    word LCKT        :1;                                       /* Lock/Unlock Trigger */
    word EDT         :1;                                       /* Enable/Disable Trigger */
    word CMT         :1;                                       /* Commit for Transmission */
    word MTD         :1;                                       /* Message Buffer Transfer Direction */
    word MBT         :1;                                       /* Message Buffer Type */
    word MCM         :1;                                       /* Message Buffer Commit Mode */
    word             :1; 
  } Bits;
} MBCCSR31STR;
extern volatile MBCCSR31STR _MBCCSR31 @(REG_BASE + 0x000005F8);
#define MBCCSR31                        _MBCCSR31.Word
#define MBCCSR31_MBIF                   _MBCCSR31.Bits.MBIF
#define MBCCSR31_LCKS                   _MBCCSR31.Bits.LCKS
#define MBCCSR31_EDS                    _MBCCSR31.Bits.EDS
#define MBCCSR31_DVAL                   _MBCCSR31.Bits.DVAL
#define MBCCSR31_DUP                    _MBCCSR31.Bits.DUP
#define MBCCSR31_MBIE                   _MBCCSR31.Bits.MBIE
#define MBCCSR31_LCKT                   _MBCCSR31.Bits.LCKT
#define MBCCSR31_EDT                    _MBCCSR31.Bits.EDT
#define MBCCSR31_CMT                    _MBCCSR31.Bits.CMT
#define MBCCSR31_MTD                    _MBCCSR31.Bits.MTD
#define MBCCSR31_MBT                    _MBCCSR31.Bits.MBT
#define MBCCSR31_MCM                    _MBCCSR31.Bits.MCM

#define MBCCSR31_MBIF_MASK              1
#define MBCCSR31_LCKS_MASK              2
#define MBCCSR31_EDS_MASK               4
#define MBCCSR31_DVAL_MASK              8
#define MBCCSR31_DUP_MASK               16
#define MBCCSR31_MBIE_MASK              256
#define MBCCSR31_LCKT_MASK              512
#define MBCCSR31_EDT_MASK               1024
#define MBCCSR31_CMT_MASK               2048
#define MBCCSR31_MTD_MASK               4096
#define MBCCSR31_MBT_MASK               8192
#define MBCCSR31_MCM_MASK               16384


/*** MBCCFR31 - Message Buffer Cycle Counter Filter Register 31; 0x000005FA ***/
typedef union {
  word Word;
  struct {
    word CCFVAL      :6;                                       /* Cycle Counter Filter Value */
    word CCFMSK      :6;                                       /* Cycle Counter Filter Mask */
    word CCFE        :1;                                       /* Cycle Counter Filter Enable */
    word CHB         :1;                                       /* Channel Assignment */
    word CHA         :1;                                       /* Channel Assignment */
    word MTM         :1;                                       /* Message Buffer Transmission Mode */
  } Bits;
} MBCCFR31STR;
extern volatile MBCCFR31STR _MBCCFR31 @(REG_BASE + 0x000005FA);
#define MBCCFR31                        _MBCCFR31.Word
#define MBCCFR31_CCFVAL                 _MBCCFR31.Bits.CCFVAL
#define MBCCFR31_CCFMSK                 _MBCCFR31.Bits.CCFMSK
#define MBCCFR31_CCFE                   _MBCCFR31.Bits.CCFE
#define MBCCFR31_CHB                    _MBCCFR31.Bits.CHB
#define MBCCFR31_CHA                    _MBCCFR31.Bits.CHA
#define MBCCFR31_MTM                    _MBCCFR31.Bits.MTM

#define MBCCFR31_CCFVAL_MASK            63
#define MBCCFR31_CCFVAL_BITNUM          0
#define MBCCFR31_CCFMSK_MASK            4032
#define MBCCFR31_CCFMSK_BITNUM          6
#define MBCCFR31_CCFE_MASK              4096
#define MBCCFR31_CHB_MASK               8192
#define MBCCFR31_CHA_MASK               16384
#define MBCCFR31_MTM_MASK               32768


/*** MBFIDR31 - Message Buffer Frame ID Registers; 0x000005FC ***/
typedef union {
  word Word;
  struct {
    word FID         :11;                                      /* Frame ID */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBFIDR31STR;
extern volatile MBFIDR31STR _MBFIDR31 @(REG_BASE + 0x000005FC);
#define MBFIDR31                        _MBFIDR31.Word
#define MBFIDR31_FID                    _MBFIDR31.Bits.FID

#define MBFIDR31_FID_MASK               2047
#define MBFIDR31_FID_BITNUM             0


/*** MBIDXR31 - Message Buffer Index Register; 0x000005FE ***/
typedef union {
  word Word;
  struct {
    word MBIDX       :6;                                       /* Message Buffer Index */
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
    word             :1; 
  } Bits;
} MBIDXR31STR;
extern volatile MBIDXR31STR _MBIDXR31 @(REG_BASE + 0x000005FE);
#define MBIDXR31                        _MBIDXR31.Word
#define MBIDXR31_MBIDX                  _MBIDXR31.Bits.MBIDX

#define MBIDXR31_MBIDX_MASK             63
#define MBIDXR31_MBIDX_BITNUM           0


#endif /*S12XFR_H */

/*******************************************************************************/	
  


