/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       typedefs.h
\brief      Variable types and common macros
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version
\date        /Jan/2007
\warning (If needed)
* History:
*/
/*******************************************************************************/

typedef unsigned char   UINT8;  /*unsigned 8 bit definition */
typedef unsigned short  UINT16; /*unsigned 16 bit definition*/
typedef unsigned long   UINT32; /*unsigned 32 bit definition*/
typedef signed char     INT8;   /*signed 8 bit definition */
typedef short           INT16;  /*signed 16 bit definition*/
typedef long int        INT32;  /*signed 32 bit definition*/

/*
 * Common Bit masks
 */
#define ENABLE_INTERRUPTS()  {__asm CLI; XGMCTL_XGIE = 1;}        /*interrupts enabled        */
#define DISABLE_INTERRUPTS() {__asm SEI; XGMCTL_XGIE = 0;}        /*interrupts disabled       */
#define XIRQ_ENABLE()        {asm andcc #0xBF;}  /*XIRQ enabled              */
#define WAIT()               {asm wait;}         /*enter wait mode           */
#define STOP_ENABLE()        {asm andcc #0x7F;}  /*stop mode enabled         */
#define STOP()               {asm stop;}         /*enter stop mode           */
#define NOP()                {asm nop;}          /*enter NOP asm instruction */

/* 
 *  Common Constants
 */
#define ON 1            
#define OFF 0           
#define TRUE 1          
#define FALSE 0         
#define PASS 0u
#define FAIL 1u
#define SET 1u
#define CLEAR 0u

