/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       S12XMMC.h
\brief      S12XF512 Memory Mapping Control module definitions 
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.0
\date       March/09/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/


#ifndef S12XMMC_H        /*prevent duplicated includes */
#define S12XMMC_H


typedef union {
  byte Byte;
  struct {
    byte CS0E        :1;                                       /* Chip Select Enable 0 */
    byte CS1E        :1;                                       /* Chip Select Enable 1 */
    byte CS2E        :1;                                       /* Chip Select Enable 2 */
    byte CS3E        :1;                                       /* Chip Select Enable 3 */
    byte CS0E1       :1; 
    byte CS1E1       :1; 
    byte CS2E1       :1; 
    byte CS3E1       :1; 
  } Bits;
} MMCCTL0STR;
extern volatile MMCCTL0STR _MMCCTL0 @(REG_BASE + 0x0000000A);
#define MMCCTL0                         _MMCCTL0.Byte
#define MMCCTL0_CS0E                    _MMCCTL0.Bits.CS0E
#define MMCCTL0_CS1E                    _MMCCTL0.Bits.CS1E
#define MMCCTL0_CS2E                    _MMCCTL0.Bits.CS2E
#define MMCCTL0_CS3E                    _MMCCTL0.Bits.CS3E
#define MMCCTL0_CS0E1                   _MMCCTL0.Bits.CS0E1
#define MMCCTL0_CS1E1                   _MMCCTL0.Bits.CS1E1
#define MMCCTL0_CS2E1                   _MMCCTL0.Bits.CS2E1
#define MMCCTL0_CS3E1                   _MMCCTL0.Bits.CS3E1

#define MMCCTL0_CS0E_MASK               1
#define MMCCTL0_CS1E_MASK               2
#define MMCCTL0_CS2E_MASK               4
#define MMCCTL0_CS3E_MASK               8
#define MMCCTL0_CS0E1_MASK              16
#define MMCCTL0_CS1E1_MASK              32
#define MMCCTL0_CS2E1_MASK              64
#define MMCCTL0_CS3E1_MASK              128


/*** MODE - Mode Register; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte MODA        :1;                                       /* Mode Select Bit A */
    byte MODB        :1;                                       /* Mode Select Bit B */
    byte MODC        :1;                                       /* Mode Select Bit C */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpMODx :3;
  } MergedBits;
} MODESTR;
extern volatile MODESTR _MODE @(REG_BASE + 0x0000000B);
#define MODE                            _MODE.Byte
#define MODE_MODA                       _MODE.Bits.MODA
#define MODE_MODB                       _MODE.Bits.MODB
#define MODE_MODC                       _MODE.Bits.MODC
#define MODE_MODx                       _MODE.MergedBits.grpMODx

#define MODE_MODA_MASK                  32
#define MODE_MODB_MASK                  64
#define MODE_MODC_MASK                  128
#define MODE_MODx_MASK                  224
#define MODE_MODx_BITNUM                5


/*** GPAGE - Global Page Index Register; 0x00000010 ***/
typedef union {
  byte Byte;
  struct {
    byte GP0         :1;                                       /* Global Page Index Bit 0 */
    byte GP1         :1;                                       /* Global Page Index Bit 1 */
    byte GP2         :1;                                       /* Global Page Index Bit 2 */
    byte GP3         :1;                                       /* Global Page Index Bit 3 */
    byte GP4         :1;                                       /* Global Page Index Bit 4 */
    byte GP5         :1;                                       /* Global Page Index Bit 5 */
    byte GP6         :1;                                       /* Global Page Index Bit 6 */
    byte             :1; 
  } Bits;
  struct {
    byte grpGP   :7;
    byte         :1;
  } MergedBits;
} GPAGESTR;
extern volatile GPAGESTR _GPAGE @(REG_BASE + 0x00000010);
#define GPAGE                           _GPAGE.Byte
#define GPAGE_GP0                       _GPAGE.Bits.GP0
#define GPAGE_GP1                       _GPAGE.Bits.GP1
#define GPAGE_GP2                       _GPAGE.Bits.GP2
#define GPAGE_GP3                       _GPAGE.Bits.GP3
#define GPAGE_GP4                       _GPAGE.Bits.GP4
#define GPAGE_GP5                       _GPAGE.Bits.GP5
#define GPAGE_GP6                       _GPAGE.Bits.GP6
#define GPAGE_GP                        _GPAGE.MergedBits.grpGP

#define GPAGE_GP0_MASK                  1
#define GPAGE_GP1_MASK                  2
#define GPAGE_GP2_MASK                  4
#define GPAGE_GP3_MASK                  8
#define GPAGE_GP4_MASK                  16
#define GPAGE_GP5_MASK                  32
#define GPAGE_GP6_MASK                  64
#define GPAGE_GP_MASK                   127
#define GPAGE_GP_BITNUM                 0


/*** DIRECT - Direct Page Register; 0x00000011 ***/
typedef union {
  byte Byte;
  struct {
    byte DP8         :1;                                       /* Direct Page Bit 8 */
    byte DP9         :1;                                       /* Direct Page Bit 9 */
    byte DP10        :1;                                       /* Direct Page Bit 10 */
    byte DP11        :1;                                       /* Direct Page Bit 11 */
    byte DP12        :1;                                       /* Direct Page Bit 12 */
    byte DP13        :1;                                       /* Direct Page Bit 13 */
    byte DP14        :1;                                       /* Direct Page Bit 14 */
    byte DP15        :1;                                       /* Direct Page Bit 15 */
  } Bits;
} DIRECTSTR;
extern volatile DIRECTSTR _DIRECT @(REG_BASE + 0x00000011);
#define DIRECT                          _DIRECT.Byte
#define DIRECT_DP8                      _DIRECT.Bits.DP8
#define DIRECT_DP9                      _DIRECT.Bits.DP9
#define DIRECT_DP10                     _DIRECT.Bits.DP10
#define DIRECT_DP11                     _DIRECT.Bits.DP11
#define DIRECT_DP12                     _DIRECT.Bits.DP12
#define DIRECT_DP13                     _DIRECT.Bits.DP13
#define DIRECT_DP14                     _DIRECT.Bits.DP14
#define DIRECT_DP15                     _DIRECT.Bits.DP15

#define DIRECT_DP8_MASK                 1
#define DIRECT_DP9_MASK                 2
#define DIRECT_DP10_MASK                4
#define DIRECT_DP11_MASK                8
#define DIRECT_DP12_MASK                16
#define DIRECT_DP13_MASK                32
#define DIRECT_DP14_MASK                64
#define DIRECT_DP15_MASK                128



/*** MMCCTL1 - S12X_MMC Control Register 1; 0x00000013 ***/
typedef union {
  byte Byte;
  struct {
    byte ROMON       :1;                                       /* Enable FLASH or ROM in the memory map */
    byte ROMHM       :1;                                       /* FLASH or ROM only in higher Half of Memory Map */
    byte EROMON      :1;                                       /* Enables emulated FLASH or ROM memory in the memory map. */
    byte RAMHM       :1; 
    byte PGMIFRON    :1; 
    byte EEIFRON     :1; 
    byte MGROMON     :1; 
    byte TMGRAMON    :1; 
  } Bits;
} MMCCTL1STR;
extern volatile MMCCTL1STR _MMCCTL1 @(REG_BASE + 0x00000013);
#define MMCCTL1                         _MMCCTL1.Byte
#define MMCCTL1_ROMON                   _MMCCTL1.Bits.ROMON
#define MMCCTL1_ROMHM                   _MMCCTL1.Bits.ROMHM
#define MMCCTL1_EROMON                  _MMCCTL1.Bits.EROMON

#define MMCCTL1_ROMON_MASK              1
#define MMCCTL1_ROMHM_MASK              2
#define MMCCTL1_EROMON_MASK             4


/*** PPAGE - Program Page Index Register; 0x00000015 ***/
typedef union {
  byte Byte;
  struct {
    byte PIX0        :1;                                       /* Program Page Index Bit 0 */
    byte PIX1        :1;                                       /* Program Page Index Bit 1 */
    byte PIX2        :1;                                       /* Program Page Index Bit 2 */
    byte PIX3        :1;                                       /* Program Page Index Bit 3 */
    byte PIX4        :1;                                       /* Program Page Index Bit 4 */
    byte PIX5        :1;                                       /* Program Page Index Bit 5 */
    byte PIX6        :1;                                       /* Program Page Index Bit 6 */
    byte PIX7        :1;                                       /* Program Page Index Bit 7 */
  } Bits;
} PPAGESTR;
extern volatile PPAGESTR _PPAGE @(REG_BASE + 0x00000015);
#define PPAGE                           _PPAGE.Byte
#define PPAGE_PIX0                      _PPAGE.Bits.PIX0
#define PPAGE_PIX1                      _PPAGE.Bits.PIX1
#define PPAGE_PIX2                      _PPAGE.Bits.PIX2
#define PPAGE_PIX3                      _PPAGE.Bits.PIX3
#define PPAGE_PIX4                      _PPAGE.Bits.PIX4
#define PPAGE_PIX5                      _PPAGE.Bits.PIX5
#define PPAGE_PIX6                      _PPAGE.Bits.PIX6
#define PPAGE_PIX7                      _PPAGE.Bits.PIX7

#define PPAGE_PIX0_MASK                 1
#define PPAGE_PIX1_MASK                 2
#define PPAGE_PIX2_MASK                 4
#define PPAGE_PIX3_MASK                 8
#define PPAGE_PIX4_MASK                 16
#define PPAGE_PIX5_MASK                 32
#define PPAGE_PIX6_MASK                 64
#define PPAGE_PIX7_MASK                 128


/*** RPAGE - RAM Page Index Register; 0x00000016 ***/
typedef union {
  byte Byte;
  struct {
    byte RP0         :1;                                       /* RAM Page Index Bit 0 */
    byte RP1         :1;                                       /* RAM Page Index Bit 1 */
    byte RP2         :1;                                       /* RAM Page Index Bit 2 */
    byte RP3         :1;                                       /* RAM Page Index Bit 3 */
    byte RP4         :1;                                       /* RAM Page Index Bit 4 */
    byte RP5         :1;                                       /* RAM Page Index Bit 5 */
    byte RP6         :1;                                       /* RAM Page Index Bit 6 */
    byte RP7         :1;                                       /* RAM Page Index Bit 7 */
  } Bits;
} RPAGESTR;
extern volatile RPAGESTR _RPAGE @(REG_BASE + 0x00000016);
#define RPAGE                           _RPAGE.Byte
#define RPAGE_RP0                       _RPAGE.Bits.RP0
#define RPAGE_RP1                       _RPAGE.Bits.RP1
#define RPAGE_RP2                       _RPAGE.Bits.RP2
#define RPAGE_RP3                       _RPAGE.Bits.RP3
#define RPAGE_RP4                       _RPAGE.Bits.RP4
#define RPAGE_RP5                       _RPAGE.Bits.RP5
#define RPAGE_RP6                       _RPAGE.Bits.RP6
#define RPAGE_RP7                       _RPAGE.Bits.RP7

#define RPAGE_RP0_MASK                  1
#define RPAGE_RP1_MASK                  2
#define RPAGE_RP2_MASK                  4
#define RPAGE_RP3_MASK                  8
#define RPAGE_RP4_MASK                  16
#define RPAGE_RP5_MASK                  32
#define RPAGE_RP6_MASK                  64
#define RPAGE_RP7_MASK                  128


/*** EPAGE - EEPROM Page Index Register; 0x00000017 ***/
typedef union {
  byte Byte;
  struct {
    byte EP0         :1;                                       /* EEPROM Page Index Bit 0 */
    byte EP1         :1;                                       /* EEPROM Page Index Bit 1 */
    byte EP2         :1;                                       /* EEPROM Page Index Bit 2 */
    byte EP3         :1;                                       /* EEPROM Page Index Bit 3 */
    byte EP4         :1;                                       /* EEPROM Page Index Bit 4 */
    byte EP5         :1;                                       /* EEPROM Page Index Bit 5 */
    byte EP6         :1;                                       /* EEPROM Page Index Bit 6 */
    byte EP7         :1;                                       /* EEPROM Page Index Bit 7 */
  } Bits;
} EPAGESTR;
extern volatile EPAGESTR _EPAGE @(REG_BASE + 0x00000017);
#define EPAGE                           _EPAGE.Byte
#define EPAGE_EP0                       _EPAGE.Bits.EP0
#define EPAGE_EP1                       _EPAGE.Bits.EP1
#define EPAGE_EP2                       _EPAGE.Bits.EP2
#define EPAGE_EP3                       _EPAGE.Bits.EP3
#define EPAGE_EP4                       _EPAGE.Bits.EP4
#define EPAGE_EP5                       _EPAGE.Bits.EP5
#define EPAGE_EP6                       _EPAGE.Bits.EP6
#define EPAGE_EP7                       _EPAGE.Bits.EP7

#define EPAGE_EP0_MASK                  1
#define EPAGE_EP1_MASK                  2
#define EPAGE_EP2_MASK                  4
#define EPAGE_EP3_MASK                  8
#define EPAGE_EP4_MASK                  16
#define EPAGE_EP5_MASK                  32
#define EPAGE_EP6_MASK                  64
#define EPAGE_EP7_MASK                  128


/*** RAMFRL - RAM FLEXRAY Lower Boundary Register; 0x00000018 ***/
typedef union {
  byte Byte;
  struct {
    byte FRL0        :1;                                       /* FLEXRAY Region Lower Boundary Bit 0 */
    byte FRL1        :1;                                       /* FLEXRAY Region Lower Boundary Bit 1 */
    byte FRL2        :1;                                       /* FLEXRAY Region Lower Boundary Bit 2 */
    byte FRL3        :1;                                       /* FLEXRAY Region Lower Boundary Bit 3 */
    byte FRL4        :1;                                       /* FLEXRAY Region Lower Boundary Bit 4 */
    byte FRL5        :1;                                       /* FLEXRAY Region Lower Boundary Bit 5 */
    byte FRL6        :1;                                       /* FLEXRAY Region Lower Boundary Bit 6 */
    byte FRL7        :1;                                       /* FLEXRAY Region Lower Boundary Bit 7 */
  } Bits;
} RAMFRLSTR;
extern volatile RAMFRLSTR _RAMFRL @(REG_BASE + 0x00000018);
#define RAMFRL                          _RAMFRL.Byte
#define RAMFRL_FRL0                     _RAMFRL.Bits.FRL0
#define RAMFRL_FRL1                     _RAMFRL.Bits.FRL1
#define RAMFRL_FRL2                     _RAMFRL.Bits.FRL2
#define RAMFRL_FRL3                     _RAMFRL.Bits.FRL3
#define RAMFRL_FRL4                     _RAMFRL.Bits.FRL4
#define RAMFRL_FRL5                     _RAMFRL.Bits.FRL5
#define RAMFRL_FRL6                     _RAMFRL.Bits.FRL6
#define RAMFRL_FRL7                     _RAMFRL.Bits.FRL7

#define RAMFRL_FRL0_MASK                1
#define RAMFRL_FRL1_MASK                2
#define RAMFRL_FRL2_MASK                4
#define RAMFRL_FRL3_MASK                8
#define RAMFRL_FRL4_MASK                16
#define RAMFRL_FRL5_MASK                32
#define RAMFRL_FRL6_MASK                64
#define RAMFRL_FRL7_MASK                128


/*** RAMFRU - RAM FLEXRAY Upper Boundary Register; 0x00000019 ***/
typedef union {
  byte Byte;
  struct {
    byte FRU0        :1;                                       /* XGATE Region Upper Boundary Bit 0 */
    byte FRU1        :1;                                       /* XGATE Region Upper Boundary Bit 1 */
    byte FRU2        :1;                                       /* XGATE Region Upper Boundary Bit 2 */
    byte FRU3        :1;                                       /* XGATE Region Upper Boundary Bit 3 */
    byte FRU4        :1;                                       /* XGATE Region Upper Boundary Bit 4 */
    byte FRU5        :1;                                       /* XGATE Region Upper Boundary Bit 5 */
    byte FRU6        :1;                                       /* XGATE Region Upper Boundary Bit 6 */
    byte FRU7        :1;                                       /* XGATE Region Upper Boundary Bit 7 */
  } Bits;
} RAMFRUSTR;
extern volatile RAMFRUSTR _RAMFRU @(REG_BASE + 0x00000019);
#define RAMFRU                          _RAMFRU.Byte
#define RAMFRU_FRU0                     _RAMFRU.Bits.FRU0
#define RAMFRU_FRU1                     _RAMFRU.Bits.FRU1
#define RAMFRU_FRU2                     _RAMFRU.Bits.FRU2
#define RAMFRU_FRU3                     _RAMFRU.Bits.FRU3
#define RAMFRU_FRU4                     _RAMFRU.Bits.FRU4
#define RAMFRU_FRU5                     _RAMFRU.Bits.FRU5
#define RAMFRU_FRU6                     _RAMFRU.Bits.FRU6
#define RAMFRU_FRU7                     _RAMFRU.Bits.FRU7

#define RAMFRU_FRU0_MASK                1
#define RAMFRU_FRU1_MASK                2
#define RAMFRU_FRU2_MASK                4
#define RAMFRU_FRU3_MASK                8
#define RAMFRU_FRU4_MASK                16
#define RAMFRU_FRU5_MASK                32
#define RAMFRU_FRU6_MASK                64
#define RAMFRU_FRU7_MASK                128


/*** PARTID - Part ID Register; 0x0000001A ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** PARTIDH - Part ID Register High; 0x0000001A ***/
    union {
      byte Byte;
      struct {
        byte ID8         :1;                                       /* Part ID Register Bit 8 */
        byte ID9         :1;                                       /* Part ID Register Bit 9 */
        byte ID10        :1;                                       /* Part ID Register Bit 10 */
        byte ID11        :1;                                       /* Part ID Register Bit 11 */
        byte ID12        :1;                                       /* Part ID Register Bit 12 */
        byte ID13        :1;                                       /* Part ID Register Bit 13 */
        byte ID14        :1;                                       /* Part ID Register Bit 14 */
        byte ID15        :1;                                       /* Part ID Register Bit 15 */
      } Bits;
    } PARTIDHSTR;
    #define PARTIDH                     _PARTID.Overlap_STR.PARTIDHSTR.Byte
    #define PARTIDH_ID8                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID8
    #define PARTIDH_ID9                 _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID9
    #define PARTIDH_ID10                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID10
    #define PARTIDH_ID11                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID11
    #define PARTIDH_ID12                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID12
    #define PARTIDH_ID13                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID13
    #define PARTIDH_ID14                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID14
    #define PARTIDH_ID15                _PARTID.Overlap_STR.PARTIDHSTR.Bits.ID15
    
    
    #define PARTIDH_ID8_MASK            1
    #define PARTIDH_ID9_MASK            2
    #define PARTIDH_ID10_MASK           4
    #define PARTIDH_ID11_MASK           8
    #define PARTIDH_ID12_MASK           16
    #define PARTIDH_ID13_MASK           32
    #define PARTIDH_ID14_MASK           64
    #define PARTIDH_ID15_MASK           128


    /*** PARTIDL - Part ID Register Low; 0x0000001B ***/
    union {
      byte Byte;
      struct {
        byte ID0         :1;                                       /* Part ID Register Bit 0 */
        byte ID1         :1;                                       /* Part ID Register Bit 1 */
        byte ID2         :1;                                       /* Part ID Register Bit 2 */
        byte ID3         :1;                                       /* Part ID Register Bit 3 */
        byte ID4         :1;                                       /* Part ID Register Bit 4 */
        byte ID5         :1;                                       /* Part ID Register Bit 5 */
        byte ID6         :1;                                       /* Part ID Register Bit 6 */
        byte ID7         :1;                                       /* Part ID Register Bit 7 */
      } Bits;
    } PARTIDLSTR;
    #define PARTIDL                     _PARTID.Overlap_STR.PARTIDLSTR.Byte
    #define PARTIDL_ID0                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID0
    #define PARTIDL_ID1                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID1
    #define PARTIDL_ID2                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID2
    #define PARTIDL_ID3                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID3
    #define PARTIDL_ID4                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID4
    #define PARTIDL_ID5                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID5
    #define PARTIDL_ID6                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID6
    #define PARTIDL_ID7                 _PARTID.Overlap_STR.PARTIDLSTR.Bits.ID7
    
    
    #define PARTIDL_ID0_MASK            1
    #define PARTIDL_ID1_MASK            2
    #define PARTIDL_ID2_MASK            4
    #define PARTIDL_ID3_MASK            8
    #define PARTIDL_ID4_MASK            16
    #define PARTIDL_ID5_MASK            32
    #define PARTIDL_ID6_MASK            64
    #define PARTIDL_ID7_MASK            128

  } Overlap_STR;

  struct {
    word ID0         :1;                                       /* Part ID Register Bit 0 */
    word ID1         :1;                                       /* Part ID Register Bit 1 */
    word ID2         :1;                                       /* Part ID Register Bit 2 */
    word ID3         :1;                                       /* Part ID Register Bit 3 */
    word ID4         :1;                                       /* Part ID Register Bit 4 */
    word ID5         :1;                                       /* Part ID Register Bit 5 */
    word ID6         :1;                                       /* Part ID Register Bit 6 */
    word ID7         :1;                                       /* Part ID Register Bit 7 */
    word ID8         :1;                                       /* Part ID Register Bit 8 */
    word ID9         :1;                                       /* Part ID Register Bit 9 */
    word ID10        :1;                                       /* Part ID Register Bit 10 */
    word ID11        :1;                                       /* Part ID Register Bit 11 */
    word ID12        :1;                                       /* Part ID Register Bit 12 */
    word ID13        :1;                                       /* Part ID Register Bit 13 */
    word ID14        :1;                                       /* Part ID Register Bit 14 */
    word ID15        :1;                                       /* Part ID Register Bit 15 */
  } Bits;
} PARTIDSTR;
extern volatile PARTIDSTR _PARTID @(REG_BASE + 0x0000001A);
#define PARTID                          _PARTID.Word
#define PARTID_ID0                      _PARTID.Bits.ID0
#define PARTID_ID1                      _PARTID.Bits.ID1
#define PARTID_ID2                      _PARTID.Bits.ID2
#define PARTID_ID3                      _PARTID.Bits.ID3
#define PARTID_ID4                      _PARTID.Bits.ID4
#define PARTID_ID5                      _PARTID.Bits.ID5
#define PARTID_ID6                      _PARTID.Bits.ID6
#define PARTID_ID7                      _PARTID.Bits.ID7
#define PARTID_ID8                      _PARTID.Bits.ID8
#define PARTID_ID9                      _PARTID.Bits.ID9
#define PARTID_ID10                     _PARTID.Bits.ID10
#define PARTID_ID11                     _PARTID.Bits.ID11
#define PARTID_ID12                     _PARTID.Bits.ID12
#define PARTID_ID13                     _PARTID.Bits.ID13
#define PARTID_ID14                     _PARTID.Bits.ID14
#define PARTID_ID15                     _PARTID.Bits.ID15

#define PARTID_ID0_MASK                 1
#define PARTID_ID1_MASK                 2
#define PARTID_ID2_MASK                 4
#define PARTID_ID3_MASK                 8
#define PARTID_ID4_MASK                 16
#define PARTID_ID5_MASK                 32
#define PARTID_ID6_MASK                 64
#define PARTID_ID7_MASK                 128
#define PARTID_ID8_MASK                 256
#define PARTID_ID9_MASK                 512
#define PARTID_ID10_MASK                1024
#define PARTID_ID11_MASK                2048
#define PARTID_ID12_MASK                4096
#define PARTID_ID13_MASK                8192
#define PARTID_ID14_MASK                16384
#define PARTID_ID15_MASK                32768



#endif /*S12XMMC_H */

/*******************************************************************************/