/*
                     MC68HC05J1  HEADER

WRITTEN:    9/21/89
REVISION:   0.9
USE FOR:    MC68HC05J1

The following header describes the memory, vectors, peripherals and special
instructions for the MC68HC05J1 microprocessor.  The information is taken from
the Motorola Data Sheet and is assumed to be correct.  It is specifically
designed to work with the Byte Craft C6805 Compiler, and is offered free for
your convenience.

I have taken most of the mnemonics directly from the Motorola literature with
the exception of those labels which could cause confusion with the compiler
or the assembler.  Please check all labels before using.

If you discover any errors or omissions, please communicate them to me through
the FREEWARE bulletin board or directly at the Motorola Detroit Sales Office
(313) 261-6200.

Mike Pauwels,  Senior FAE

******************************************************************************
*                                                                            *
* This product is distributed without charge to users via the MOTOROLA       *
* FREEWARE Bulletin Board.  The product is provided "as is" without warranty *
* of any kind either expressed or implied, including, but not limited to any *
* warranties of merchantability and fitness for a particular purpose.  All   *
* risks of using this product including the entire costs of any necessary    *
* remedies are those of the user and MOTOROLA assumes no liability of any    *
* kind.                                                                      *
*                                                                            *
******************************************************************************

*/


/*                   MEMORY MAP                                              */

#pragma memory ROMPROG  [1024]  @ 0x0300 ;
#pragma memory RAMPAGE0 [64]    @ 0x00c0 ;


/*                   INTERRUPT VECTORS                                       */

#pragma vector __RESET @ 0x07fe ;
#pragma vector SWI     @ 0x07fc ;
#pragma vector IRQ     @ 0x07fa ;
#pragma vector TIMER   @ 0x07f8 ;


/*                   INPUT/ OUTPUT PORTS                                     */

#pragma portrw porta   @ 0x00;  /* 8 - bit General Purpose I/O Port          */
#pragma portrw portb   @ 0x01;  /* 6 - bit General Purpose I/O Port          */
#pragma portrw ddra    @ 0x04;  /* Data direction, Port A                    */
#pragma portrw ddrb    @ 0x05;  /* 0, 0, Data direction, Port B              */


/*                    TIMER/WATCHDOG REGISTERS                               */

#pragma portrw tcsr   @ 0x08;  /* TOF,RTIF,TOFE,RTIE,0,0,RT1,RT0             */
#define tof    7                /* Timer Overflow Flag                       */
#define rtif   6                /* Real Time Interrupt Flag                  */
#define tofe   5                /* Timer Overflow Enable                     */
#define rtie   4                /* Real Time Interrupt Enable                */
#define rt1    1                /* Real Time Interrupt Rate Select 1         */
#define rt0    0                /* Real Time Interrupt Rate Select 0         */

/*
              RT1:RT0   RTI RATE    MIN. COP RESET
             --------------------------------------
             |  00    |  8.2 ms.  |     57.4 ms.  |
             |  01    | 16.4 ms.  |    114.8 ms.  |
             |  10    | 32.8 ms.  |    229.6 ms.  |
             |  11    | 65.5 ms.  |    458.5 ms.  |
             ______________________________________
*/
#pragma portrw tcr    @ 0x09;        /* Timer Counter Register               */
#pragma portw watchdog @ 0x07f0 ;    /* Watchdog Register                    */



/*                   MC68HC05 INSTRUCTIONS                                   */

#pragma has STOP ;
#pragma has WAIT ;
#pragma has MUL ;




