/* (C) MOTOROLA, INC., 1993
 *
 * FILENAME: hc11d3.h
 *
 * DESCRIPTION: Register and bit macro definitions for the MC68HC11D3,
 * MC68HC711D3, and MC68HC11D0 microcontrollers.
 *
 * CREATED: 11/20/93
 *
 * REVISION HISTORY:
 *
 * 12/16/93 - Acknowledgements section added.
 *
 * 12/02/93 - Disclaimer added.
 *
 * ACKNOWLEDGEMENTS:
 *
 * Developed with ideas from Ted Van Sickle's "Programming
 * Microcontrollers in C" class and G. J. Lipovski's "Object-Oriented 
 * Interfacing to 16-bit Microcontrollers" book.
 *
 * by John Bodnar
 *
 * Motorola Inc.
 * AMCU Applications, Mail Drop OE39
 * 6501 William Cannon Drive West
 * Austin, TX 78735-8598
 *
 * Internet: r16292@email.sps.mot.com
 *
 * NOTE: Your comments, suggestions, and corrections are requested and
 * greatly appreciated.
 *
 * DISCLAIMER: Motorola reserves the right to make changes without
 * further notice to any products herein.  Motorola makes no warranty,
 * representation or guarantee regarding the suitability of its
 * products for any particular purpose, nor does Motorola assume any
 * liability arising out of the application or use of any product or
 * circuit, and specifically disclaims any and all liability, including
 * without limitation consequential or incidental damages.  "Typical"
 * parameters can and do vary in different applications.  All operating
 * parameters, including "Typicals" must be validated for each customer
 * application by customer's technical experts.  Motorola does not
 * convey any license under its patent rights nor the rights of others.
 * Motorola products are not designed, intended, or authorized for use
 * as components in systems intended for surgical implant into the
 * body, or other applications intended to support or sustain life, or
 * for any other application in which the failure of the Motorola
 * product could create a situation where personal injury or death may
 * occur.  Should Buyer purchase or use Motorola products for any such
 * unintended or unauthorized application, Buyer shall indemnify and
 * hold Motorola and its officers, employees, subsidiaries, affiliates,
 * and distributors harmless against all claims, costs, damages, and
 * expenses, and reasonable attorney fees arising out of, directly or
 * indirectly, any claim of personal injury or death associated with
 * such unintended or unauthorized use, even if such claim alleges
 * that Motorola was negligent regarding the design or manufacture of
 * the part.  Motorola is a registered trademark of Motorola, Inc.
 * Motorola, Inc. is an Equal Opportunity/Affirmative Action Employer.
 */

#define REGISTER unsigned char

#define REG_BASE 0x0000

#define PORTA   (*(volatile REGISTER *)(REG_BASE + 0x00))
#define PIOC    (*(volatile REGISTER *)(REG_BASE + 0x02))
#define PORTC   (*(volatile REGISTER *)(REG_BASE + 0x03))
#define PORTB   (*(REGISTER *)(REG_BASE + 0x04))
#define DDRB    (*(REGISTER *)(REG_BASE + 0x06))
#define DDRC    (*(REGISTER *)(REG_BASE + 0x07))
#define PORTD   (*(volatile REGISTER *)(REG_BASE + 0x08))
#define DDRD    (*(REGISTER *)(REG_BASE + 0x09))
#define CFORC   (*(REGISTER *)(REG_BASE + 0x0B))
#define OC1M    (*(REGISTER *)(REG_BASE + 0x0C))
#define OC1D    (*(REGISTER *)(REG_BASE + 0x0D))
#define TCNT    (*(volatile unsigned int *)(REG_BASE + 0x0E))
#define TIC1    (*(volatile unsigned int *)(REG_BASE + 0x10))
#define TIC2    (*(volatile unsigned int *)(REG_BASE + 0x12))
#define TIC3    (*(volatile unsigned int *)(REG_BASE + 0x14))
#define TOC1    (*(unsigned int *)(REG_BASE + 0x16))
#define TOC2    (*(unsigned int *)(REG_BASE + 0x18))
#define TOC3    (*(unsigned int *)(REG_BASE + 0x1A))
#define TOC4    (*(unsigned int *)(REG_BASE + 0x1C))
#define TI4O5   (*(volatile unsigned int *)(REG_BASE + 0x1E))
#define TCTL1   (*(REGISTER *)(REG_BASE + 0x20))
#define TCTL2   (*(REGISTER *)(REG_BASE + 0x21))
#define TMSK1   (*(REGISTER *)(REG_BASE + 0x22))
#define TFLG1   (*(volatile REGISTER *)(REG_BASE + 0x23))
#define TMSK2   (*(REGISTER *)(REG_BASE + 0x24))
#define TFLG2   (*(volatile REGISTER *)(REG_BASE + 0x25))
#define PACTL   (*(REGISTER *)(REG_BASE + 0x26))
#define PACNT   (*(volatile REGISTER *)(REG_BASE + 0x27))
#define SPCR    (*(REGISTER *)(REG_BASE + 0x28))
#define SPSR    (*(volatile REGISTER *)(REG_BASE + 0x29))
#define SPDR    (*(volatile REGISTER *)(REG_BASE + 0x2A))
#define BAUD    (*(REGISTER *)(REG_BASE + 0x2B))
#define SCCR1   (*(volatile REGISTER *)(REG_BASE + 0x2C))
#define SCCR2   (*(REGISTER *)(REG_BASE + 0x2D))
#define SCSR    (*(volatile REGISTER *)(REG_BASE + 0x2E))
#define SCDR    (*(volatile REGISTER *)(REG_BASE + 0x2F))
#define OPTION  (*(REGISTER *)(REG_BASE + 0x39))
#define COPRST  (*(REGISTER *)(REG_BASE + 0x3A))
#define PPROG   (*(REGISTER *)(REG_BASE + 0x3B))
#define HPRIO   (*(REGISTER *)(REG_BASE + 0x3C))
#define INIT    (*(REGISTER *)(REG_BASE + 0x3D))
#define TEST1   (*(REGISTER *)(REG_BASE + 0x3E))
#define CONFIG  (*(REGISTER *)(REG_BASE + 0x3F))

/* Bit names for general use */
#define bit7    0x80
#define bit6    0x40
#define bit5    0x20
#define bit4    0x10
#define bit3    0x08
#define bit2    0x04
#define bit1    0x02
#define bit0    0x01

/* PORTA bit definitions 0x00 */
#define PA7     bit7
#define PA6     bit6
#define PA5     bit5
#define PA4     bit4
#define PA3     bit3
#define PA2     bit2
#define PA1     bit1
#define PA0     bit0

/* PIOC bit definitions 0x02 */
#define CWOM    bit5

/* PORTC bit definitions 0x03 */
#define PC7     bit7
#define PC6     bit6
#define PC5     bit5
#define PC4     bit4
#define PC3     bit3
#define PC2     bit2
#define PC1     bit1
#define PC0     bit0

/* PORTB bit definitions 0x04 */
#define PB7     bit7
#define PB6     bit6
#define PB5     bit5
#define PB4     bit4
#define PB3     bit3
#define PB2     bit2
#define PB1     bit1
#define PB0     bit0

/* DDRB bit definitions 0x06 */
#define DDB7    bit7
#define DDB6    bit6
#define DDB5    bit5
#define DDB4    bit4
#define DDB3    bit3
#define DDB2    bit2
#define DDB1    bit1
#define DDB0    bit0

/* DDRC bit definitions 0x07 */
#define DDC7    bit7
#define DDC6    bit6
#define DDC5    bit5
#define DDC4    bit4
#define DDC3    bit3
#define DDC2    bit2
#define DDC1    bit1
#define DDC0    bit0

/* PORTD bit definitions 0x08 */
#define PD7     bit7
#define PD6     bit6
#define PD5     bit5
#define PD4     bit4
#define PD3     bit3
#define PD2     bit2
#define PD1     bit1
#define PD0     bit0

/* DDRD bit definitions 0x09 */
#define DDD7    bit7
#define DDD6    bit6
#define DDD5    bit5
#define DDD4    bit4
#define DDD3    bit3
#define DDD2    bit2
#define DDD1    bit1
#define DDD0    bit0

/* CFORC bit definitions 0x0B */
#define FOC1    bit7
#define FOC2    bit6
#define FOC3    bit5
#define FOC4    bit4
#define FOC5    bit3

/* OC1M bit definitions 0x0C */
#define OC1M7   bit7
#define OC1M6   bit6
#define OC1M5   bit5
#define OC1M4   bit4
#define OC1M3   bit3

/* OC1D bit definitions 0x0D */
#define OC1D7   bit7
#define OC1D6   bit6
#define OC1D5   bit5
#define OC1D4   bit4
#define OC1D3   bit3

/* TCTL1 bit definition 0x20 */
#define OM2     bit7
#define OL2     bit6
#define OM3     bit5
#define OL3     bit4
#define OM4     bit3
#define OL4     bit2
#define OM5     bit1
#define OL5     bit0

/* TCTL2 bit definitions 0x21 */
#define EDG4B   bit7
#define EDG4A   bit6
#define EDG1B   bit5
#define EDG1A   bit4
#define EDG2B   bit3
#define EDG2A   bit2
#define EDG3B   bit1
#define EDG3A   bit0

/* TMSK1 bit definitions 0x22 */
#define OC1I    bit7
#define OC2I    bit6
#define OC3I    bit5
#define OC4I    bit4
#define I4O5I   bit3
#define IC1I    bit2
#define IC2I    bit1
#define IC3I    bit0

/* TFLG1 bit definitions 0x23 */
#define OC1F    bit7
#define OC2F    bit6
#define OC3F    bit5
#define OC4F    bit4
#define I4O5F   bit3
#define IC1F    bit2
#define IC2F    bit1
#define IC3F    bit0

/* TMSK2 bit definitions 0x24 */
#define TOI     bit7
#define RTII    bit6
#define PAOVI   bit5
#define PAII    bit4
#define PR1     bit1
#define PR0     bit0

/* TFLG2 bit definitions 0x25 */
#define TOF     bit7
#define RTIF    bit6
#define PAOVF   bit5
#define PAIF    bit4

/* PACTL bit definitions 0x26 */
#define DDRA7   bit7
#define PAEN    bit6
#define PAMOD   bit5
#define PEDGE   bit4
#define DDRA3   bit3
#define I4O5    bit2
#define RTR1    bit1
#define RTR0    bit0

/* SPCR bit definitions 0x28 */
#define SPIE    bit7
#define SPE     bit6
#define DWOM    bit5
#define MSTR    bit4
#define CPOL    bit3
#define CPHA    bit2
#define SPR1    bit1
#define SPR0    bit0

/* SPSR bit definitions 0x29 */
#define SPIF    bit7
#define WCOL    bit6
#define MODF    bit4

/* BAUD bit definitions 0x2B */
#define TCLR    bit7
#define SCP1    bit5
#define SCP0    bit4
#define RCKB    bit3
#define SCR2    bit2
#define SCR1    bit1
#define SCR0    bit0

/* SCCR1 bit definition 0x2C */
#define R8      bit7
#define T8      bit6
#define M       bit4
#define WAKE    bit3

/* SCCR2 bit definitions 0x2D */
#define TIE     bit7
#define TCIE    bit6
#define RIE     bit5
#define ILIE    bit4
#define TE      bit3
#define RE      bit2
#define RWU     bit1
#define SBK     bit0

/* SCSR  bit definitions 0x2E */
#define TDRE    bit7
#define TC      bit6
#define RDRF    bit5
#define IDLE    bit4
#define OR      bit3
#define NF      bit2
#define FE      bit1

/* SCDR bit definitions 0x2F */
#define R7T7    bit7
#define R6T6    bit6
#define R5T5    bit5
#define R4T4    bit4
#define R3T3    bit3
#define R2T2    bit2
#define R1T1    bit1
#define R0T0    bit0

/* OPTION bit definitions 0x39 */
#define IRQE    bit5
#define DLY     bit4
#define CME     bit3
#define CR1     bit1
#define CR0     bit0

/* PPROG bit definitions 0x3B
 * MC68HC711D3 only
 */
#define MBE     bit7
#define ELAT    bit5
#define EXCOL   bit4
#define EXROW   bit3
#define PGM     bit0

/* HPRIO bit definitions 0x3C */
#define RBOOT   bit7
#define SMOD    bit6
#define MDA     bit5
#define IRVNE   bit4
#define PSEL3   bit3
#define PSEL2   bit2
#define PSEL1   bit1
#define PSEL0   bit0

/* INIT  bit definitions 0x3D */
#define RAM3    bit7
#define RAM2    bit6
#define RAM1    bit5
#define RAM0    bit4
#define REG3    bit3
#define REG2    bit2
#define REG1    bit1
#define REG0    bit0

/* TEST1 bit definitions 0x3E */
#define TILOP   bit7
#define OCCR    bit5
#define CBYP    bit4
#define DISR    bit3
#define FCM     bit2
#define FCOP    bit1
#define TCON    bit0

/* CONFIG bit definitions 0x3F */
#define NOCOP   bit2
#define ROMON   bit1    /* MC68HC11D3 only */
#define EPON    bit1    /* MC68HC711D3 only */
