/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_iMX6SL_REGISTERS_H__
#define __HW_iMX6SL_REGISTERS_H__

#include "fsl_bitaccess.h"

/*
 * iMX6SL AIPSTZ
 *
 * AIPSTZ Control Registers
 *
 * Registers defined in this header file:
 * - HW_AIPSTZ_MPR - Master Priviledge Registers
 * - HW_AIPSTZ_OPACR - Off-Platform Peripheral Access Control Registers
 * - HW_AIPSTZ_OPACR1 - Off-Platform Peripheral Access Control Registers
 * - HW_AIPSTZ_OPACR2 - Off-Platform Peripheral Access Control Registers
 * - HW_AIPSTZ_OPACR3 - Off-Platform Peripheral Access Control Registers
 * - HW_AIPSTZ_OPACR4 - Off-Platform Peripheral Access Control Registers
 *
 * - hw_aipstz_t - Struct containing all module registers.
 */

#define HW_AIPSTZ_INSTANCE_COUNT (2U) /*!< Number of instances of the AIPSTZ module. */
#define HW_AIPSTZ1 (0U) /*!< Instance number for AIPSTZ1. */
#define HW_AIPSTZ2 (1U) /*!< Instance number for AIPSTZ2. */
#define AIPSTZ1_BASE          (0x2000000U) /*!< Base address for AIPSTZ1. */
#define AIPSTZ2_BASE          (0x2100000U) /*!< Base address for AIPSTZ2. */
/*! Array initializer of AIPSTZ base addresses. */
#define AIPSTZ_BASE_ADDRS     { AIPSTZ1_BASE, AIPSTZ2_BASE }

/*******************************************************************************
 * HW_AIPSTZ_MPR - Master Priviledge Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_MPR - Master Priviledge Registers (RW)
 *
 * Reset value: 0x0496ED40U
 *
 * Each AIPSTZ_MPR specifies 16 4-bit fields defining the access privilege level
 * associated with a bus master in the platform, as well as specifying whether
 * write accesses from this master are bufferable shown in #at039431 The registers
 * provide one field per bus master, where field 15 corresponds to master 15,
 * field 14 to master 14,... field 0 to master 0 (typically the processor core).
 * The master index allocation is shown in #at039432. MPROT Field Bit Field
 * Description 3 MBW Master Buffer Writes - This bit determines whether the AIPSTZ is
 * enabled to buffer writes from this master. 2 MTR Master Trusted for Reads - This
 * bit determines whether the master is trusted for read accesses. 1 MTW Master
 * Trusted for Writes - This bit determines whether the master is trusted for
 * write accesses. 0 MPL Master Privilege Level - This bit determines how the
 * privilege level of the master is determined. The reset value is set to
 * 0000_0000_7700_0000, which makes master 0 and master 1 (ARM CORE) the trusted masters.
 * Trusted software can change the settings after reset. Master Index Allocation
 * Master Index Master Name Comments Master 0 All masters excluding ARM core and SDMA
 * Share the same number allocation. Master 1 ARM CORE Master 2 Reserved Master
 * 3 SDMA Master 4-15 Reserved
 */
typedef union _hw_aipstz_mpr
{
    uint32_t U;
    struct _hw_aipstz_mpr_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t MPROT3 : 4;           /*!< [19:16]  */
        uint32_t RESERVED1 : 4;        /*!< [23:20]  */
        uint32_t MPROT1 : 4;           /*!< [27:24]  */
        uint32_t MPROT0 : 4;           /*!< [31:28]  */
    } B;
} hw_aipstz_mpr_t;

/*!
 * @name Constants and macros for entire AIPSTZ_MPR register
 */
/*@{*/
#define HW_AIPSTZ_MPR_ADDR(x)    ((uintptr_t)(x) + 0x0U)

#define HW_AIPSTZ_MPR(x)         (*(__IO hw_aipstz_mpr_t *) HW_AIPSTZ_MPR_ADDR(x))
#define HW_AIPSTZ_MPR_RD(x)      (HW_AIPSTZ_MPR(x).U)
#define HW_AIPSTZ_MPR_WR(x, v)   (HW_AIPSTZ_MPR(x).U = (v))
#define HW_AIPSTZ_MPR_SET(x, v)  (HW_AIPSTZ_MPR_WR(x, HW_AIPSTZ_MPR_RD(x) |  (v)))
#define HW_AIPSTZ_MPR_CLR(x, v)  (HW_AIPSTZ_MPR_WR(x, HW_AIPSTZ_MPR_RD(x) & ~(v)))
#define HW_AIPSTZ_MPR_TOG(x, v)  (HW_AIPSTZ_MPR_WR(x, HW_AIPSTZ_MPR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_MPR bitfields
 */

/*!
 * @name Register AIPSTZ_MPR, field MPROT3[19:16] (RW)
 *
 * Master 3 Priviledge, Buffer, Read, Write Control.
 *
 * Values:
 * - xxx0 - Accesses from this master are forced to user-mode
 *     (ips_supervisor_access is forced to zero) regardless of the hprot[1] access attribute.
 * - xxx1 - Accesses from this master are not forced to user-mode. The hprot[1]
 *     access attribute is used directly to determine ips_supervisor_access.
 * - xx0x - This master is not trusted for write accesses.
 * - xx1x - This master is trusted for write accesses.
 * - x0xx - This master is not trusted for read accesses.
 * - x1xx - This master is trusted for read accesses.
 * - 1xxx - Write accesses from this master are allowed to be buffered
 */
/*@{*/
#define BP_AIPSTZ_MPR_MPROT3 (16U)         /*!< Bit position for AIPSTZ_MPR_MPROT3. */
#define BM_AIPSTZ_MPR_MPROT3 (0x000F0000U) /*!< Bit mask for AIPSTZ_MPR_MPROT3. */
#define BS_AIPSTZ_MPR_MPROT3 (4U)          /*!< Bit field size in bits for AIPSTZ_MPR_MPROT3. */

/*! @brief Read current value of the AIPSTZ_MPR_MPROT3 field. */
#define BR_AIPSTZ_MPR_MPROT3(x) (HW_AIPSTZ_MPR(x).B.MPROT3)

/*! @brief Format value for bitfield AIPSTZ_MPR_MPROT3. */
#define BF_AIPSTZ_MPR_MPROT3(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_MPR_MPROT3) & BM_AIPSTZ_MPR_MPROT3)

/*! @brief Set the MPROT3 field to a new value. */
#define BW_AIPSTZ_MPR_MPROT3(x, v) (HW_AIPSTZ_MPR_WR(x, (HW_AIPSTZ_MPR_RD(x) & ~BM_AIPSTZ_MPR_MPROT3) | BF_AIPSTZ_MPR_MPROT3(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_MPR, field MPROT1[27:24] (RW)
 *
 * Master 1 Priviledge, Buffer, Read, Write Control
 *
 * Values:
 * - xxx0 - Accesses from this master are forced to user-mode
 *     (ips_supervisor_access is forced to zero) regardless of the hprot[1] access attribute.
 * - xxx1 - Accesses from this master are not forced to user-mode. The hprot[1]
 *     access attribute is used directly to determine ips_supervisor_access.
 * - xx0x - This master is not trusted for write accesses.
 * - xx1x - This master is trusted for write accesses.
 * - x0xx - This master is not trusted for read accesses.
 * - x1xx - This master is trusted for read accesses.
 * - 1xxx - Write accesses from this master are allowed to be buffered
 */
/*@{*/
#define BP_AIPSTZ_MPR_MPROT1 (24U)         /*!< Bit position for AIPSTZ_MPR_MPROT1. */
#define BM_AIPSTZ_MPR_MPROT1 (0x0F000000U) /*!< Bit mask for AIPSTZ_MPR_MPROT1. */
#define BS_AIPSTZ_MPR_MPROT1 (4U)          /*!< Bit field size in bits for AIPSTZ_MPR_MPROT1. */

/*! @brief Read current value of the AIPSTZ_MPR_MPROT1 field. */
#define BR_AIPSTZ_MPR_MPROT1(x) (HW_AIPSTZ_MPR(x).B.MPROT1)

/*! @brief Format value for bitfield AIPSTZ_MPR_MPROT1. */
#define BF_AIPSTZ_MPR_MPROT1(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_MPR_MPROT1) & BM_AIPSTZ_MPR_MPROT1)

/*! @brief Set the MPROT1 field to a new value. */
#define BW_AIPSTZ_MPR_MPROT1(x, v) (HW_AIPSTZ_MPR_WR(x, (HW_AIPSTZ_MPR_RD(x) & ~BM_AIPSTZ_MPR_MPROT1) | BF_AIPSTZ_MPR_MPROT1(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_MPR, field MPROT0[31:28] (RW)
 *
 * Master 0 Priviledge, Buffer, Read, Write Control
 *
 * Values:
 * - xxx0 - Accesses from this master are forced to user-mode
 *     (ips_supervisor_access is forced to zero) regardless of the hprot[1] access attribute.
 * - xxx1 - Accesses from this master are not forced to user-mode. The hprot[1]
 *     access attribute is used directly to determine ips_supervisor_access.
 * - xx0x - This master is not trusted for write accesses.
 * - xx1x - This master is trusted for write accesses.
 * - x0xx - This master is not trusted for read accesses.
 * - x1xx - This master is trusted for read accesses.
 * - 1xxx - Write accesses from this master are allowed to be buffered
 */
/*@{*/
#define BP_AIPSTZ_MPR_MPROT0 (28U)         /*!< Bit position for AIPSTZ_MPR_MPROT0. */
#define BM_AIPSTZ_MPR_MPROT0 (0xF0000000U) /*!< Bit mask for AIPSTZ_MPR_MPROT0. */
#define BS_AIPSTZ_MPR_MPROT0 (4U)          /*!< Bit field size in bits for AIPSTZ_MPR_MPROT0. */

/*! @brief Read current value of the AIPSTZ_MPR_MPROT0 field. */
#define BR_AIPSTZ_MPR_MPROT0(x) (HW_AIPSTZ_MPR(x).B.MPROT0)

/*! @brief Format value for bitfield AIPSTZ_MPR_MPROT0. */
#define BF_AIPSTZ_MPR_MPROT0(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_MPR_MPROT0) & BM_AIPSTZ_MPR_MPROT0)

/*! @brief Set the MPROT0 field to a new value. */
#define BW_AIPSTZ_MPR_MPROT0(x, v) (HW_AIPSTZ_MPR_WR(x, (HW_AIPSTZ_MPR_RD(x) & ~BM_AIPSTZ_MPR_MPROT0) | BF_AIPSTZ_MPR_MPROT0(v)))
/*@}*/

/*******************************************************************************
 * HW_AIPSTZ_OPACR - Off-Platform Peripheral Access Control Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_OPACR - Off-Platform Peripheral Access Control Registers (RW)
 *
 * Reset value: 0x44444444U
 *
 * Each of the off-platform peripherals have an Off-platform Peripheral Access
 * Control Register (AIPSTZ_OPACR) which defines the access levels supported by
 * the given block. Each AIPSTZ_OPACR has the following format shown in #at039434
 * OPAC Field Bit Field Description 3 BW Buffer Writes - This bit determines
 * whether write accesses to this peripheral are allowed to be buffered.Buffered
 * writes are not available for AIPSTZ. This bit should be set to '0'. 2 SP Supervisor
 * Protect - This bit determines whether the peripheral requires supervisor
 * privilege level for access. 1 WP Write Protect - This bit determines whether the
 * peripheral allows write accesses. 0 TP Trusted Protect - This bit determines
 * whether the peripheral allows accesses from an untrusted master.
 */
typedef union _hw_aipstz_opacr
{
    uint32_t U;
    struct _hw_aipstz_opacr_bitfields
    {
        uint32_t OPAC7 : 4;            /*!< [3:0]  */
        uint32_t OPAC6 : 4;            /*!< [7:4]  */
        uint32_t OPAC5 : 4;            /*!< [11:8]  */
        uint32_t OPAC4 : 4;            /*!< [15:12]  */
        uint32_t OPAC3 : 4;            /*!< [19:16]  */
        uint32_t OPAC2 : 4;            /*!< [23:20]  */
        uint32_t OPAC1 : 4;            /*!< [27:24]  */
        uint32_t OPAC0 : 4;            /*!< [31:28]  */
    } B;
} hw_aipstz_opacr_t;

/*!
 * @name Constants and macros for entire AIPSTZ_OPACR register
 */
/*@{*/
#define HW_AIPSTZ_OPACR_ADDR(x)  ((uintptr_t)(x) + 0x40U)

#define HW_AIPSTZ_OPACR(x)       (*(__IO hw_aipstz_opacr_t *) HW_AIPSTZ_OPACR_ADDR(x))
#define HW_AIPSTZ_OPACR_RD(x)    (HW_AIPSTZ_OPACR(x).U)
#define HW_AIPSTZ_OPACR_WR(x, v) (HW_AIPSTZ_OPACR(x).U = (v))
#define HW_AIPSTZ_OPACR_SET(x, v) (HW_AIPSTZ_OPACR_WR(x, HW_AIPSTZ_OPACR_RD(x) |  (v)))
#define HW_AIPSTZ_OPACR_CLR(x, v) (HW_AIPSTZ_OPACR_WR(x, HW_AIPSTZ_OPACR_RD(x) & ~(v)))
#define HW_AIPSTZ_OPACR_TOG(x, v) (HW_AIPSTZ_OPACR_WR(x, HW_AIPSTZ_OPACR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_OPACR bitfields
 */

/*!
 * @name Register AIPSTZ_OPACR, field OPAC7[3:0] (RW)
 *
 * Off-platform Peripheral Access Control 7
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC7 (0U)         /*!< Bit position for AIPSTZ_OPACR_OPAC7. */
#define BM_AIPSTZ_OPACR_OPAC7 (0x0000000FU) /*!< Bit mask for AIPSTZ_OPACR_OPAC7. */
#define BS_AIPSTZ_OPACR_OPAC7 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC7. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC7 field. */
#define BR_AIPSTZ_OPACR_OPAC7(x) (HW_AIPSTZ_OPACR(x).B.OPAC7)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC7. */
#define BF_AIPSTZ_OPACR_OPAC7(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC7) & BM_AIPSTZ_OPACR_OPAC7)

/*! @brief Set the OPAC7 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC7(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC7) | BF_AIPSTZ_OPACR_OPAC7(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC6[7:4] (RW)
 *
 * Off-platform Peripheral Access Control 6
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC6 (4U)         /*!< Bit position for AIPSTZ_OPACR_OPAC6. */
#define BM_AIPSTZ_OPACR_OPAC6 (0x000000F0U) /*!< Bit mask for AIPSTZ_OPACR_OPAC6. */
#define BS_AIPSTZ_OPACR_OPAC6 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC6. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC6 field. */
#define BR_AIPSTZ_OPACR_OPAC6(x) (HW_AIPSTZ_OPACR(x).B.OPAC6)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC6. */
#define BF_AIPSTZ_OPACR_OPAC6(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC6) & BM_AIPSTZ_OPACR_OPAC6)

/*! @brief Set the OPAC6 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC6(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC6) | BF_AIPSTZ_OPACR_OPAC6(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC5[11:8] (RW)
 *
 * Off-platform Peripheral Access Control 5
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC5 (8U)         /*!< Bit position for AIPSTZ_OPACR_OPAC5. */
#define BM_AIPSTZ_OPACR_OPAC5 (0x00000F00U) /*!< Bit mask for AIPSTZ_OPACR_OPAC5. */
#define BS_AIPSTZ_OPACR_OPAC5 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC5. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC5 field. */
#define BR_AIPSTZ_OPACR_OPAC5(x) (HW_AIPSTZ_OPACR(x).B.OPAC5)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC5. */
#define BF_AIPSTZ_OPACR_OPAC5(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC5) & BM_AIPSTZ_OPACR_OPAC5)

/*! @brief Set the OPAC5 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC5(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC5) | BF_AIPSTZ_OPACR_OPAC5(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC4[15:12] (RW)
 *
 * Off-platform Peripheral Access Control 4
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC4 (12U)        /*!< Bit position for AIPSTZ_OPACR_OPAC4. */
#define BM_AIPSTZ_OPACR_OPAC4 (0x0000F000U) /*!< Bit mask for AIPSTZ_OPACR_OPAC4. */
#define BS_AIPSTZ_OPACR_OPAC4 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC4. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC4 field. */
#define BR_AIPSTZ_OPACR_OPAC4(x) (HW_AIPSTZ_OPACR(x).B.OPAC4)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC4. */
#define BF_AIPSTZ_OPACR_OPAC4(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC4) & BM_AIPSTZ_OPACR_OPAC4)

/*! @brief Set the OPAC4 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC4(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC4) | BF_AIPSTZ_OPACR_OPAC4(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC3[19:16] (RW)
 *
 * Off-platform Peripheral Access Control 3
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC3 (16U)        /*!< Bit position for AIPSTZ_OPACR_OPAC3. */
#define BM_AIPSTZ_OPACR_OPAC3 (0x000F0000U) /*!< Bit mask for AIPSTZ_OPACR_OPAC3. */
#define BS_AIPSTZ_OPACR_OPAC3 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC3. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC3 field. */
#define BR_AIPSTZ_OPACR_OPAC3(x) (HW_AIPSTZ_OPACR(x).B.OPAC3)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC3. */
#define BF_AIPSTZ_OPACR_OPAC3(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC3) & BM_AIPSTZ_OPACR_OPAC3)

/*! @brief Set the OPAC3 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC3(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC3) | BF_AIPSTZ_OPACR_OPAC3(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC2[23:20] (RW)
 *
 * Off-platform Peripheral Access Control 2
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC2 (20U)        /*!< Bit position for AIPSTZ_OPACR_OPAC2. */
#define BM_AIPSTZ_OPACR_OPAC2 (0x00F00000U) /*!< Bit mask for AIPSTZ_OPACR_OPAC2. */
#define BS_AIPSTZ_OPACR_OPAC2 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC2. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC2 field. */
#define BR_AIPSTZ_OPACR_OPAC2(x) (HW_AIPSTZ_OPACR(x).B.OPAC2)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC2. */
#define BF_AIPSTZ_OPACR_OPAC2(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC2) & BM_AIPSTZ_OPACR_OPAC2)

/*! @brief Set the OPAC2 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC2(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC2) | BF_AIPSTZ_OPACR_OPAC2(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC1[27:24] (RW)
 *
 * Off-platform Peripheral Access Control 1
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC1 (24U)        /*!< Bit position for AIPSTZ_OPACR_OPAC1. */
#define BM_AIPSTZ_OPACR_OPAC1 (0x0F000000U) /*!< Bit mask for AIPSTZ_OPACR_OPAC1. */
#define BS_AIPSTZ_OPACR_OPAC1 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC1. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC1 field. */
#define BR_AIPSTZ_OPACR_OPAC1(x) (HW_AIPSTZ_OPACR(x).B.OPAC1)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC1. */
#define BF_AIPSTZ_OPACR_OPAC1(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC1) & BM_AIPSTZ_OPACR_OPAC1)

/*! @brief Set the OPAC1 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC1(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC1) | BF_AIPSTZ_OPACR_OPAC1(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR, field OPAC0[31:28] (RW)
 *
 * Off-platform Peripheral Access Control 0
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR_OPAC0 (28U)        /*!< Bit position for AIPSTZ_OPACR_OPAC0. */
#define BM_AIPSTZ_OPACR_OPAC0 (0xF0000000U) /*!< Bit mask for AIPSTZ_OPACR_OPAC0. */
#define BS_AIPSTZ_OPACR_OPAC0 (4U)         /*!< Bit field size in bits for AIPSTZ_OPACR_OPAC0. */

/*! @brief Read current value of the AIPSTZ_OPACR_OPAC0 field. */
#define BR_AIPSTZ_OPACR_OPAC0(x) (HW_AIPSTZ_OPACR(x).B.OPAC0)

/*! @brief Format value for bitfield AIPSTZ_OPACR_OPAC0. */
#define BF_AIPSTZ_OPACR_OPAC0(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR_OPAC0) & BM_AIPSTZ_OPACR_OPAC0)

/*! @brief Set the OPAC0 field to a new value. */
#define BW_AIPSTZ_OPACR_OPAC0(x, v) (HW_AIPSTZ_OPACR_WR(x, (HW_AIPSTZ_OPACR_RD(x) & ~BM_AIPSTZ_OPACR_OPAC0) | BF_AIPSTZ_OPACR_OPAC0(v)))
/*@}*/

/*******************************************************************************
 * HW_AIPSTZ_OPACR1 - Off-Platform Peripheral Access Control Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_OPACR1 - Off-Platform Peripheral Access Control Registers (RW)
 *
 * Reset value: 0x44444444U
 *
 * Each of the off-platform peripherals have an Off-platform Peripheral Access
 * Control Register (AIPSTZ_OPACR) which defines the access levels supported by
 * the given block. Each AIPSTZ_OPACR has the following format shown in #at039434
 */
typedef union _hw_aipstz_opacr1
{
    uint32_t U;
    struct _hw_aipstz_opacr1_bitfields
    {
        uint32_t OPAC15 : 4;           /*!< [3:0]  */
        uint32_t OPAC14 : 4;           /*!< [7:4]  */
        uint32_t OPAC13 : 4;           /*!< [11:8]  */
        uint32_t OPAC12 : 4;           /*!< [15:12]  */
        uint32_t OPAC11 : 4;           /*!< [19:16]  */
        uint32_t OPAC10 : 4;           /*!< [23:20]  */
        uint32_t OPAC9 : 4;            /*!< [27:24]  */
        uint32_t OPAC8 : 4;            /*!< [31:28]  */
    } B;
} hw_aipstz_opacr1_t;

/*!
 * @name Constants and macros for entire AIPSTZ_OPACR1 register
 */
/*@{*/
#define HW_AIPSTZ_OPACR1_ADDR(x) ((uintptr_t)(x) + 0x44U)

#define HW_AIPSTZ_OPACR1(x)      (*(__IO hw_aipstz_opacr1_t *) HW_AIPSTZ_OPACR1_ADDR(x))
#define HW_AIPSTZ_OPACR1_RD(x)   (HW_AIPSTZ_OPACR1(x).U)
#define HW_AIPSTZ_OPACR1_WR(x, v) (HW_AIPSTZ_OPACR1(x).U = (v))
#define HW_AIPSTZ_OPACR1_SET(x, v) (HW_AIPSTZ_OPACR1_WR(x, HW_AIPSTZ_OPACR1_RD(x) |  (v)))
#define HW_AIPSTZ_OPACR1_CLR(x, v) (HW_AIPSTZ_OPACR1_WR(x, HW_AIPSTZ_OPACR1_RD(x) & ~(v)))
#define HW_AIPSTZ_OPACR1_TOG(x, v) (HW_AIPSTZ_OPACR1_WR(x, HW_AIPSTZ_OPACR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_OPACR1 bitfields
 */

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC15[3:0] (RW)
 *
 * Off-platform Peripheral Access Control 15
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC15 (0U)       /*!< Bit position for AIPSTZ_OPACR1_OPAC15. */
#define BM_AIPSTZ_OPACR1_OPAC15 (0x0000000FU) /*!< Bit mask for AIPSTZ_OPACR1_OPAC15. */
#define BS_AIPSTZ_OPACR1_OPAC15 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC15. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC15 field. */
#define BR_AIPSTZ_OPACR1_OPAC15(x) (HW_AIPSTZ_OPACR1(x).B.OPAC15)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC15. */
#define BF_AIPSTZ_OPACR1_OPAC15(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC15) & BM_AIPSTZ_OPACR1_OPAC15)

/*! @brief Set the OPAC15 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC15(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC15) | BF_AIPSTZ_OPACR1_OPAC15(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC14[7:4] (RW)
 *
 * Off-platform Peripheral Access Control 14
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC14 (4U)       /*!< Bit position for AIPSTZ_OPACR1_OPAC14. */
#define BM_AIPSTZ_OPACR1_OPAC14 (0x000000F0U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC14. */
#define BS_AIPSTZ_OPACR1_OPAC14 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC14. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC14 field. */
#define BR_AIPSTZ_OPACR1_OPAC14(x) (HW_AIPSTZ_OPACR1(x).B.OPAC14)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC14. */
#define BF_AIPSTZ_OPACR1_OPAC14(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC14) & BM_AIPSTZ_OPACR1_OPAC14)

/*! @brief Set the OPAC14 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC14(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC14) | BF_AIPSTZ_OPACR1_OPAC14(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC13[11:8] (RW)
 *
 * Off-platform Peripheral Access Control 13
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC13 (8U)       /*!< Bit position for AIPSTZ_OPACR1_OPAC13. */
#define BM_AIPSTZ_OPACR1_OPAC13 (0x00000F00U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC13. */
#define BS_AIPSTZ_OPACR1_OPAC13 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC13. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC13 field. */
#define BR_AIPSTZ_OPACR1_OPAC13(x) (HW_AIPSTZ_OPACR1(x).B.OPAC13)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC13. */
#define BF_AIPSTZ_OPACR1_OPAC13(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC13) & BM_AIPSTZ_OPACR1_OPAC13)

/*! @brief Set the OPAC13 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC13(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC13) | BF_AIPSTZ_OPACR1_OPAC13(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC12[15:12] (RW)
 *
 * Off-platform Peripheral Access Control 12
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC12 (12U)      /*!< Bit position for AIPSTZ_OPACR1_OPAC12. */
#define BM_AIPSTZ_OPACR1_OPAC12 (0x0000F000U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC12. */
#define BS_AIPSTZ_OPACR1_OPAC12 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC12. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC12 field. */
#define BR_AIPSTZ_OPACR1_OPAC12(x) (HW_AIPSTZ_OPACR1(x).B.OPAC12)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC12. */
#define BF_AIPSTZ_OPACR1_OPAC12(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC12) & BM_AIPSTZ_OPACR1_OPAC12)

/*! @brief Set the OPAC12 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC12(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC12) | BF_AIPSTZ_OPACR1_OPAC12(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC11[19:16] (RW)
 *
 * Off-platform Peripheral Access Control 11
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC11 (16U)      /*!< Bit position for AIPSTZ_OPACR1_OPAC11. */
#define BM_AIPSTZ_OPACR1_OPAC11 (0x000F0000U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC11. */
#define BS_AIPSTZ_OPACR1_OPAC11 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC11. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC11 field. */
#define BR_AIPSTZ_OPACR1_OPAC11(x) (HW_AIPSTZ_OPACR1(x).B.OPAC11)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC11. */
#define BF_AIPSTZ_OPACR1_OPAC11(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC11) & BM_AIPSTZ_OPACR1_OPAC11)

/*! @brief Set the OPAC11 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC11(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC11) | BF_AIPSTZ_OPACR1_OPAC11(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC10[23:20] (RW)
 *
 * Off-platform Peripheral Access Control 10
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC10 (20U)      /*!< Bit position for AIPSTZ_OPACR1_OPAC10. */
#define BM_AIPSTZ_OPACR1_OPAC10 (0x00F00000U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC10. */
#define BS_AIPSTZ_OPACR1_OPAC10 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC10. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC10 field. */
#define BR_AIPSTZ_OPACR1_OPAC10(x) (HW_AIPSTZ_OPACR1(x).B.OPAC10)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC10. */
#define BF_AIPSTZ_OPACR1_OPAC10(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC10) & BM_AIPSTZ_OPACR1_OPAC10)

/*! @brief Set the OPAC10 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC10(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC10) | BF_AIPSTZ_OPACR1_OPAC10(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC9[27:24] (RW)
 *
 * Off-platform Peripheral Access Control 9
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC9 (24U)       /*!< Bit position for AIPSTZ_OPACR1_OPAC9. */
#define BM_AIPSTZ_OPACR1_OPAC9 (0x0F000000U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC9. */
#define BS_AIPSTZ_OPACR1_OPAC9 (4U)        /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC9. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC9 field. */
#define BR_AIPSTZ_OPACR1_OPAC9(x) (HW_AIPSTZ_OPACR1(x).B.OPAC9)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC9. */
#define BF_AIPSTZ_OPACR1_OPAC9(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC9) & BM_AIPSTZ_OPACR1_OPAC9)

/*! @brief Set the OPAC9 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC9(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC9) | BF_AIPSTZ_OPACR1_OPAC9(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR1, field OPAC8[31:28] (RW)
 *
 * Off-platform Peripheral Access Control 8
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR1_OPAC8 (28U)       /*!< Bit position for AIPSTZ_OPACR1_OPAC8. */
#define BM_AIPSTZ_OPACR1_OPAC8 (0xF0000000U) /*!< Bit mask for AIPSTZ_OPACR1_OPAC8. */
#define BS_AIPSTZ_OPACR1_OPAC8 (4U)        /*!< Bit field size in bits for AIPSTZ_OPACR1_OPAC8. */

/*! @brief Read current value of the AIPSTZ_OPACR1_OPAC8 field. */
#define BR_AIPSTZ_OPACR1_OPAC8(x) (HW_AIPSTZ_OPACR1(x).B.OPAC8)

/*! @brief Format value for bitfield AIPSTZ_OPACR1_OPAC8. */
#define BF_AIPSTZ_OPACR1_OPAC8(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR1_OPAC8) & BM_AIPSTZ_OPACR1_OPAC8)

/*! @brief Set the OPAC8 field to a new value. */
#define BW_AIPSTZ_OPACR1_OPAC8(x, v) (HW_AIPSTZ_OPACR1_WR(x, (HW_AIPSTZ_OPACR1_RD(x) & ~BM_AIPSTZ_OPACR1_OPAC8) | BF_AIPSTZ_OPACR1_OPAC8(v)))
/*@}*/

/*******************************************************************************
 * HW_AIPSTZ_OPACR2 - Off-Platform Peripheral Access Control Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_OPACR2 - Off-Platform Peripheral Access Control Registers (RW)
 *
 * Reset value: 0x44444444U
 *
 * Each of the off-platform peripherals have an Off-platform Peripheral Access
 * Control Register (AIPSTZ_OPACR) which defines the access levels supported by
 * the given block. Each AIPSTZ_OPACR has the following format shown in #at039434
 */
typedef union _hw_aipstz_opacr2
{
    uint32_t U;
    struct _hw_aipstz_opacr2_bitfields
    {
        uint32_t OPAC23 : 4;           /*!< [3:0]  */
        uint32_t OPAC22 : 4;           /*!< [7:4]  */
        uint32_t OPAC21 : 4;           /*!< [11:8]  */
        uint32_t OPAC20 : 4;           /*!< [15:12]  */
        uint32_t OPAC19 : 4;           /*!< [19:16]  */
        uint32_t OPAC18 : 4;           /*!< [23:20]  */
        uint32_t OPAC17 : 4;           /*!< [27:24]  */
        uint32_t OPAC16 : 4;           /*!< [31:28]  */
    } B;
} hw_aipstz_opacr2_t;

/*!
 * @name Constants and macros for entire AIPSTZ_OPACR2 register
 */
/*@{*/
#define HW_AIPSTZ_OPACR2_ADDR(x) ((uintptr_t)(x) + 0x48U)

#define HW_AIPSTZ_OPACR2(x)      (*(__IO hw_aipstz_opacr2_t *) HW_AIPSTZ_OPACR2_ADDR(x))
#define HW_AIPSTZ_OPACR2_RD(x)   (HW_AIPSTZ_OPACR2(x).U)
#define HW_AIPSTZ_OPACR2_WR(x, v) (HW_AIPSTZ_OPACR2(x).U = (v))
#define HW_AIPSTZ_OPACR2_SET(x, v) (HW_AIPSTZ_OPACR2_WR(x, HW_AIPSTZ_OPACR2_RD(x) |  (v)))
#define HW_AIPSTZ_OPACR2_CLR(x, v) (HW_AIPSTZ_OPACR2_WR(x, HW_AIPSTZ_OPACR2_RD(x) & ~(v)))
#define HW_AIPSTZ_OPACR2_TOG(x, v) (HW_AIPSTZ_OPACR2_WR(x, HW_AIPSTZ_OPACR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_OPACR2 bitfields
 */

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC23[3:0] (RW)
 *
 * Off-platform Peripheral Access Control 23
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC23 (0U)       /*!< Bit position for AIPSTZ_OPACR2_OPAC23. */
#define BM_AIPSTZ_OPACR2_OPAC23 (0x0000000FU) /*!< Bit mask for AIPSTZ_OPACR2_OPAC23. */
#define BS_AIPSTZ_OPACR2_OPAC23 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC23. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC23 field. */
#define BR_AIPSTZ_OPACR2_OPAC23(x) (HW_AIPSTZ_OPACR2(x).B.OPAC23)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC23. */
#define BF_AIPSTZ_OPACR2_OPAC23(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC23) & BM_AIPSTZ_OPACR2_OPAC23)

/*! @brief Set the OPAC23 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC23(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC23) | BF_AIPSTZ_OPACR2_OPAC23(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC22[7:4] (RW)
 *
 * Off-platform Peripheral Access Control 22
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC22 (4U)       /*!< Bit position for AIPSTZ_OPACR2_OPAC22. */
#define BM_AIPSTZ_OPACR2_OPAC22 (0x000000F0U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC22. */
#define BS_AIPSTZ_OPACR2_OPAC22 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC22. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC22 field. */
#define BR_AIPSTZ_OPACR2_OPAC22(x) (HW_AIPSTZ_OPACR2(x).B.OPAC22)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC22. */
#define BF_AIPSTZ_OPACR2_OPAC22(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC22) & BM_AIPSTZ_OPACR2_OPAC22)

/*! @brief Set the OPAC22 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC22(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC22) | BF_AIPSTZ_OPACR2_OPAC22(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC21[11:8] (RW)
 *
 * Off-platform Peripheral Access Control 21
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC21 (8U)       /*!< Bit position for AIPSTZ_OPACR2_OPAC21. */
#define BM_AIPSTZ_OPACR2_OPAC21 (0x00000F00U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC21. */
#define BS_AIPSTZ_OPACR2_OPAC21 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC21. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC21 field. */
#define BR_AIPSTZ_OPACR2_OPAC21(x) (HW_AIPSTZ_OPACR2(x).B.OPAC21)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC21. */
#define BF_AIPSTZ_OPACR2_OPAC21(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC21) & BM_AIPSTZ_OPACR2_OPAC21)

/*! @brief Set the OPAC21 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC21(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC21) | BF_AIPSTZ_OPACR2_OPAC21(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC20[15:12] (RW)
 *
 * Off-platform Peripheral Access Control 20
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC20 (12U)      /*!< Bit position for AIPSTZ_OPACR2_OPAC20. */
#define BM_AIPSTZ_OPACR2_OPAC20 (0x0000F000U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC20. */
#define BS_AIPSTZ_OPACR2_OPAC20 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC20. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC20 field. */
#define BR_AIPSTZ_OPACR2_OPAC20(x) (HW_AIPSTZ_OPACR2(x).B.OPAC20)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC20. */
#define BF_AIPSTZ_OPACR2_OPAC20(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC20) & BM_AIPSTZ_OPACR2_OPAC20)

/*! @brief Set the OPAC20 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC20(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC20) | BF_AIPSTZ_OPACR2_OPAC20(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC19[19:16] (RW)
 *
 * Off-platform Peripheral Access Control 19
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC19 (16U)      /*!< Bit position for AIPSTZ_OPACR2_OPAC19. */
#define BM_AIPSTZ_OPACR2_OPAC19 (0x000F0000U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC19. */
#define BS_AIPSTZ_OPACR2_OPAC19 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC19. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC19 field. */
#define BR_AIPSTZ_OPACR2_OPAC19(x) (HW_AIPSTZ_OPACR2(x).B.OPAC19)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC19. */
#define BF_AIPSTZ_OPACR2_OPAC19(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC19) & BM_AIPSTZ_OPACR2_OPAC19)

/*! @brief Set the OPAC19 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC19(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC19) | BF_AIPSTZ_OPACR2_OPAC19(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC18[23:20] (RW)
 *
 * Off-platform Peripheral Access Control 18
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC18 (20U)      /*!< Bit position for AIPSTZ_OPACR2_OPAC18. */
#define BM_AIPSTZ_OPACR2_OPAC18 (0x00F00000U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC18. */
#define BS_AIPSTZ_OPACR2_OPAC18 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC18. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC18 field. */
#define BR_AIPSTZ_OPACR2_OPAC18(x) (HW_AIPSTZ_OPACR2(x).B.OPAC18)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC18. */
#define BF_AIPSTZ_OPACR2_OPAC18(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC18) & BM_AIPSTZ_OPACR2_OPAC18)

/*! @brief Set the OPAC18 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC18(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC18) | BF_AIPSTZ_OPACR2_OPAC18(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC17[27:24] (RW)
 *
 * Off-platform Peripheral Access Control 17
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC17 (24U)      /*!< Bit position for AIPSTZ_OPACR2_OPAC17. */
#define BM_AIPSTZ_OPACR2_OPAC17 (0x0F000000U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC17. */
#define BS_AIPSTZ_OPACR2_OPAC17 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC17. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC17 field. */
#define BR_AIPSTZ_OPACR2_OPAC17(x) (HW_AIPSTZ_OPACR2(x).B.OPAC17)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC17. */
#define BF_AIPSTZ_OPACR2_OPAC17(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC17) & BM_AIPSTZ_OPACR2_OPAC17)

/*! @brief Set the OPAC17 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC17(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC17) | BF_AIPSTZ_OPACR2_OPAC17(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR2, field OPAC16[31:28] (RW)
 *
 * Off-platform Peripheral Access Control 16
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR2_OPAC16 (28U)      /*!< Bit position for AIPSTZ_OPACR2_OPAC16. */
#define BM_AIPSTZ_OPACR2_OPAC16 (0xF0000000U) /*!< Bit mask for AIPSTZ_OPACR2_OPAC16. */
#define BS_AIPSTZ_OPACR2_OPAC16 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR2_OPAC16. */

/*! @brief Read current value of the AIPSTZ_OPACR2_OPAC16 field. */
#define BR_AIPSTZ_OPACR2_OPAC16(x) (HW_AIPSTZ_OPACR2(x).B.OPAC16)

/*! @brief Format value for bitfield AIPSTZ_OPACR2_OPAC16. */
#define BF_AIPSTZ_OPACR2_OPAC16(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR2_OPAC16) & BM_AIPSTZ_OPACR2_OPAC16)

/*! @brief Set the OPAC16 field to a new value. */
#define BW_AIPSTZ_OPACR2_OPAC16(x, v) (HW_AIPSTZ_OPACR2_WR(x, (HW_AIPSTZ_OPACR2_RD(x) & ~BM_AIPSTZ_OPACR2_OPAC16) | BF_AIPSTZ_OPACR2_OPAC16(v)))
/*@}*/

/*******************************************************************************
 * HW_AIPSTZ_OPACR3 - Off-Platform Peripheral Access Control Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_OPACR3 - Off-Platform Peripheral Access Control Registers (RW)
 *
 * Reset value: 0x44444444U
 *
 * Each of the off-platform peripherals have an Off-platform Peripheral Access
 * Control Register (AIPSTZ_OPACR) which defines the access levels supported by
 * the given block. Each AIPSTZ_OPACR has the following format shown in #at039434
 */
typedef union _hw_aipstz_opacr3
{
    uint32_t U;
    struct _hw_aipstz_opacr3_bitfields
    {
        uint32_t OPAC31 : 4;           /*!< [3:0]  */
        uint32_t OPAC30 : 4;           /*!< [7:4]  */
        uint32_t OPAC29 : 4;           /*!< [11:8]  */
        uint32_t OPAC28 : 4;           /*!< [15:12]  */
        uint32_t OPAC27 : 4;           /*!< [19:16]  */
        uint32_t OPAC26 : 4;           /*!< [23:20]  */
        uint32_t OPAC25 : 4;           /*!< [27:24]  */
        uint32_t OPAC24 : 4;           /*!< [31:28]  */
    } B;
} hw_aipstz_opacr3_t;

/*!
 * @name Constants and macros for entire AIPSTZ_OPACR3 register
 */
/*@{*/
#define HW_AIPSTZ_OPACR3_ADDR(x) ((uintptr_t)(x) + 0x4CU)

#define HW_AIPSTZ_OPACR3(x)      (*(__IO hw_aipstz_opacr3_t *) HW_AIPSTZ_OPACR3_ADDR(x))
#define HW_AIPSTZ_OPACR3_RD(x)   (HW_AIPSTZ_OPACR3(x).U)
#define HW_AIPSTZ_OPACR3_WR(x, v) (HW_AIPSTZ_OPACR3(x).U = (v))
#define HW_AIPSTZ_OPACR3_SET(x, v) (HW_AIPSTZ_OPACR3_WR(x, HW_AIPSTZ_OPACR3_RD(x) |  (v)))
#define HW_AIPSTZ_OPACR3_CLR(x, v) (HW_AIPSTZ_OPACR3_WR(x, HW_AIPSTZ_OPACR3_RD(x) & ~(v)))
#define HW_AIPSTZ_OPACR3_TOG(x, v) (HW_AIPSTZ_OPACR3_WR(x, HW_AIPSTZ_OPACR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_OPACR3 bitfields
 */

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC31[3:0] (RW)
 *
 * Off-platform Peripheral Access Control 31
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC31 (0U)       /*!< Bit position for AIPSTZ_OPACR3_OPAC31. */
#define BM_AIPSTZ_OPACR3_OPAC31 (0x0000000FU) /*!< Bit mask for AIPSTZ_OPACR3_OPAC31. */
#define BS_AIPSTZ_OPACR3_OPAC31 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC31. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC31 field. */
#define BR_AIPSTZ_OPACR3_OPAC31(x) (HW_AIPSTZ_OPACR3(x).B.OPAC31)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC31. */
#define BF_AIPSTZ_OPACR3_OPAC31(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC31) & BM_AIPSTZ_OPACR3_OPAC31)

/*! @brief Set the OPAC31 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC31(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC31) | BF_AIPSTZ_OPACR3_OPAC31(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC30[7:4] (RW)
 *
 * Off-platform Peripheral Access Control 30
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC30 (4U)       /*!< Bit position for AIPSTZ_OPACR3_OPAC30. */
#define BM_AIPSTZ_OPACR3_OPAC30 (0x000000F0U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC30. */
#define BS_AIPSTZ_OPACR3_OPAC30 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC30. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC30 field. */
#define BR_AIPSTZ_OPACR3_OPAC30(x) (HW_AIPSTZ_OPACR3(x).B.OPAC30)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC30. */
#define BF_AIPSTZ_OPACR3_OPAC30(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC30) & BM_AIPSTZ_OPACR3_OPAC30)

/*! @brief Set the OPAC30 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC30(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC30) | BF_AIPSTZ_OPACR3_OPAC30(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC29[11:8] (RW)
 *
 * Off-platform Peripheral Access Control 29
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC29 (8U)       /*!< Bit position for AIPSTZ_OPACR3_OPAC29. */
#define BM_AIPSTZ_OPACR3_OPAC29 (0x00000F00U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC29. */
#define BS_AIPSTZ_OPACR3_OPAC29 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC29. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC29 field. */
#define BR_AIPSTZ_OPACR3_OPAC29(x) (HW_AIPSTZ_OPACR3(x).B.OPAC29)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC29. */
#define BF_AIPSTZ_OPACR3_OPAC29(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC29) & BM_AIPSTZ_OPACR3_OPAC29)

/*! @brief Set the OPAC29 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC29(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC29) | BF_AIPSTZ_OPACR3_OPAC29(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC28[15:12] (RW)
 *
 * Off-platform Peripheral Access Control 28
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC28 (12U)      /*!< Bit position for AIPSTZ_OPACR3_OPAC28. */
#define BM_AIPSTZ_OPACR3_OPAC28 (0x0000F000U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC28. */
#define BS_AIPSTZ_OPACR3_OPAC28 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC28. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC28 field. */
#define BR_AIPSTZ_OPACR3_OPAC28(x) (HW_AIPSTZ_OPACR3(x).B.OPAC28)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC28. */
#define BF_AIPSTZ_OPACR3_OPAC28(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC28) & BM_AIPSTZ_OPACR3_OPAC28)

/*! @brief Set the OPAC28 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC28(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC28) | BF_AIPSTZ_OPACR3_OPAC28(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC27[19:16] (RW)
 *
 * Off-platform Peripheral Access Control 27
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC27 (16U)      /*!< Bit position for AIPSTZ_OPACR3_OPAC27. */
#define BM_AIPSTZ_OPACR3_OPAC27 (0x000F0000U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC27. */
#define BS_AIPSTZ_OPACR3_OPAC27 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC27. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC27 field. */
#define BR_AIPSTZ_OPACR3_OPAC27(x) (HW_AIPSTZ_OPACR3(x).B.OPAC27)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC27. */
#define BF_AIPSTZ_OPACR3_OPAC27(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC27) & BM_AIPSTZ_OPACR3_OPAC27)

/*! @brief Set the OPAC27 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC27(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC27) | BF_AIPSTZ_OPACR3_OPAC27(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC26[23:20] (RW)
 *
 * Off-platform Peripheral Access Control 26
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC26 (20U)      /*!< Bit position for AIPSTZ_OPACR3_OPAC26. */
#define BM_AIPSTZ_OPACR3_OPAC26 (0x00F00000U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC26. */
#define BS_AIPSTZ_OPACR3_OPAC26 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC26. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC26 field. */
#define BR_AIPSTZ_OPACR3_OPAC26(x) (HW_AIPSTZ_OPACR3(x).B.OPAC26)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC26. */
#define BF_AIPSTZ_OPACR3_OPAC26(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC26) & BM_AIPSTZ_OPACR3_OPAC26)

/*! @brief Set the OPAC26 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC26(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC26) | BF_AIPSTZ_OPACR3_OPAC26(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC25[27:24] (RW)
 *
 * Off-platform Peripheral Access Control 25
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC25 (24U)      /*!< Bit position for AIPSTZ_OPACR3_OPAC25. */
#define BM_AIPSTZ_OPACR3_OPAC25 (0x0F000000U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC25. */
#define BS_AIPSTZ_OPACR3_OPAC25 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC25. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC25 field. */
#define BR_AIPSTZ_OPACR3_OPAC25(x) (HW_AIPSTZ_OPACR3(x).B.OPAC25)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC25. */
#define BF_AIPSTZ_OPACR3_OPAC25(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC25) & BM_AIPSTZ_OPACR3_OPAC25)

/*! @brief Set the OPAC25 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC25(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC25) | BF_AIPSTZ_OPACR3_OPAC25(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR3, field OPAC24[31:28] (RW)
 *
 * Off-platform Peripheral Access Control 24
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR3_OPAC24 (28U)      /*!< Bit position for AIPSTZ_OPACR3_OPAC24. */
#define BM_AIPSTZ_OPACR3_OPAC24 (0xF0000000U) /*!< Bit mask for AIPSTZ_OPACR3_OPAC24. */
#define BS_AIPSTZ_OPACR3_OPAC24 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR3_OPAC24. */

/*! @brief Read current value of the AIPSTZ_OPACR3_OPAC24 field. */
#define BR_AIPSTZ_OPACR3_OPAC24(x) (HW_AIPSTZ_OPACR3(x).B.OPAC24)

/*! @brief Format value for bitfield AIPSTZ_OPACR3_OPAC24. */
#define BF_AIPSTZ_OPACR3_OPAC24(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR3_OPAC24) & BM_AIPSTZ_OPACR3_OPAC24)

/*! @brief Set the OPAC24 field to a new value. */
#define BW_AIPSTZ_OPACR3_OPAC24(x, v) (HW_AIPSTZ_OPACR3_WR(x, (HW_AIPSTZ_OPACR3_RD(x) & ~BM_AIPSTZ_OPACR3_OPAC24) | BF_AIPSTZ_OPACR3_OPAC24(v)))
/*@}*/

/*******************************************************************************
 * HW_AIPSTZ_OPACR4 - Off-Platform Peripheral Access Control Registers
 ******************************************************************************/

/*!
 * @brief HW_AIPSTZ_OPACR4 - Off-Platform Peripheral Access Control Registers (RW)
 *
 * Reset value: 0x44444444U
 *
 * Each of the off-platform peripherals have an Off-platform Peripheral Access
 * Control Register (AIPSTZ_OPACR) which defines the access levels supported by
 * the given block. Each AIPSTZ_OPACR has the following format shown in #at039434
 */
typedef union _hw_aipstz_opacr4
{
    uint32_t U;
    struct _hw_aipstz_opacr4_bitfields
    {
        uint32_t RESERVED0 : 24;       /*!< [23:0]  */
        uint32_t OPAC33 : 4;           /*!< [27:24]  */
        uint32_t OPAC32 : 4;           /*!< [31:28]  */
    } B;
} hw_aipstz_opacr4_t;

/*!
 * @name Constants and macros for entire AIPSTZ_OPACR4 register
 */
/*@{*/
#define HW_AIPSTZ_OPACR4_ADDR(x) ((uintptr_t)(x) + 0x50U)

#define HW_AIPSTZ_OPACR4(x)      (*(__IO hw_aipstz_opacr4_t *) HW_AIPSTZ_OPACR4_ADDR(x))
#define HW_AIPSTZ_OPACR4_RD(x)   (HW_AIPSTZ_OPACR4(x).U)
#define HW_AIPSTZ_OPACR4_WR(x, v) (HW_AIPSTZ_OPACR4(x).U = (v))
#define HW_AIPSTZ_OPACR4_SET(x, v) (HW_AIPSTZ_OPACR4_WR(x, HW_AIPSTZ_OPACR4_RD(x) |  (v)))
#define HW_AIPSTZ_OPACR4_CLR(x, v) (HW_AIPSTZ_OPACR4_WR(x, HW_AIPSTZ_OPACR4_RD(x) & ~(v)))
#define HW_AIPSTZ_OPACR4_TOG(x, v) (HW_AIPSTZ_OPACR4_WR(x, HW_AIPSTZ_OPACR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AIPSTZ_OPACR4 bitfields
 */

/*!
 * @name Register AIPSTZ_OPACR4, field OPAC33[27:24] (RW)
 *
 * Off-platform Peripheral Access Control 33
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR4_OPAC33 (24U)      /*!< Bit position for AIPSTZ_OPACR4_OPAC33. */
#define BM_AIPSTZ_OPACR4_OPAC33 (0x0F000000U) /*!< Bit mask for AIPSTZ_OPACR4_OPAC33. */
#define BS_AIPSTZ_OPACR4_OPAC33 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR4_OPAC33. */

/*! @brief Read current value of the AIPSTZ_OPACR4_OPAC33 field. */
#define BR_AIPSTZ_OPACR4_OPAC33(x) (HW_AIPSTZ_OPACR4(x).B.OPAC33)

/*! @brief Format value for bitfield AIPSTZ_OPACR4_OPAC33. */
#define BF_AIPSTZ_OPACR4_OPAC33(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR4_OPAC33) & BM_AIPSTZ_OPACR4_OPAC33)

/*! @brief Set the OPAC33 field to a new value. */
#define BW_AIPSTZ_OPACR4_OPAC33(x, v) (HW_AIPSTZ_OPACR4_WR(x, (HW_AIPSTZ_OPACR4_RD(x) & ~BM_AIPSTZ_OPACR4_OPAC33) | BF_AIPSTZ_OPACR4_OPAC33(v)))
/*@}*/

/*!
 * @name Register AIPSTZ_OPACR4, field OPAC32[31:28] (RW)
 *
 * Off-platform Peripheral Access Control 32
 *
 * Values:
 * - xxx0 - Accesses from an untrusted master are allowed.
 * - xxx1 - Accesses from an untrusted master are not allowed. If an access is
 *     attempted by an untrusted master, the access is terminated with an error
 *     response and no peripheral access is initiated on the IPS bus.
 * - xx0x - This peripheral allows write accesses.
 * - xx1x - This peripheral is write protected. If a write access is attempted,
 *     the access is terminated with an error response and no peripheral access
 *     is initiated on the IPS bus.
 * - x0xx - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - x1xx - This peripheral requires supervisor privilege level for accesses.
 *     The master privilege level must indicate supervisor via the hprot[1] access
 *     attribute, and the MPROTx[MPL] control bit for the master must be set. If
 *     not, the access is terminated with an error response and no peripheral
 *     access is initiated on the IPS bus.
 * - 1xxx - Write accesses to this peripheral are allowed to be buffered by the
 *     AIPSTZ.
 */
/*@{*/
#define BP_AIPSTZ_OPACR4_OPAC32 (28U)      /*!< Bit position for AIPSTZ_OPACR4_OPAC32. */
#define BM_AIPSTZ_OPACR4_OPAC32 (0xF0000000U) /*!< Bit mask for AIPSTZ_OPACR4_OPAC32. */
#define BS_AIPSTZ_OPACR4_OPAC32 (4U)       /*!< Bit field size in bits for AIPSTZ_OPACR4_OPAC32. */

/*! @brief Read current value of the AIPSTZ_OPACR4_OPAC32 field. */
#define BR_AIPSTZ_OPACR4_OPAC32(x) (HW_AIPSTZ_OPACR4(x).B.OPAC32)

/*! @brief Format value for bitfield AIPSTZ_OPACR4_OPAC32. */
#define BF_AIPSTZ_OPACR4_OPAC32(v) ((uint32_t)((uint32_t)(v) << BP_AIPSTZ_OPACR4_OPAC32) & BM_AIPSTZ_OPACR4_OPAC32)

/*! @brief Set the OPAC32 field to a new value. */
#define BW_AIPSTZ_OPACR4_OPAC32(x, v) (HW_AIPSTZ_OPACR4_WR(x, (HW_AIPSTZ_OPACR4_RD(x) & ~BM_AIPSTZ_OPACR4_OPAC32) | BF_AIPSTZ_OPACR4_OPAC32(v)))
/*@}*/

/*******************************************************************************
 * hw_aipstz_t - module struct
 ******************************************************************************/
/*!
 * @brief All AIPSTZ module registers.
 */
#pragma pack(1)
typedef struct _hw_aipstz
{
    __IO hw_aipstz_mpr_t MPR;              /*!< [0x0] Master Priviledge Registers */
    uint8_t _reserved0[60];
    __IO hw_aipstz_opacr_t OPACR;          /*!< [0x40] Off-Platform Peripheral Access Control Registers */
    __IO hw_aipstz_opacr1_t OPACR1;        /*!< [0x44] Off-Platform Peripheral Access Control Registers */
    __IO hw_aipstz_opacr2_t OPACR2;        /*!< [0x48] Off-Platform Peripheral Access Control Registers */
    __IO hw_aipstz_opacr3_t OPACR3;        /*!< [0x4C] Off-Platform Peripheral Access Control Registers */
    __IO hw_aipstz_opacr4_t OPACR4;        /*!< [0x50] Off-Platform Peripheral Access Control Registers */
} hw_aipstz_t;
#pragma pack()

/*! @brief Macro to access all AIPSTZ registers. */
/*! @param x AIPSTZ module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_AIPSTZ_REGS(AIPSTZ1_BASE)</code>. */
#define HW_AIPSTZ_REGS(x) (*(hw_aipstz_t *)(x))

/*
 * iMX6SL ARMGLOBALTIMER
 *
 * ARM Cortex-A9 Global Timer
 *
 * Registers defined in this header file:
 * - HW_ARMGLOBALTIMER_COUNTERn - Global Timer Counter Registers
 * - HW_ARMGLOBALTIMER_CONTROL - Global Timer Control Register
 * - HW_ARMGLOBALTIMER_IRQSTATUS - Global Timer Interrupt Status Register
 * - HW_ARMGLOBALTIMER_COMPARATORn - Global Timer Comparator Value Registers
 * - HW_ARMGLOBALTIMER_AUTOINCREMENT - Global Timer Auto-increment Register
 *
 * - hw_armglobaltimer_t - Struct containing all module registers.
 */

#define HW_ARMGLOBALTIMER_INSTANCE_COUNT (1U) /*!< Number of instances of the ARMGLOBALTIMER module. */
#define HW_ARMGLOBALTIMER (0U) /*!< Instance number for ARMGLOBALTIMER. */
#define ARMGLOBALTIMER_BASE   (0xA00000U) /*!< Base address for ARMGLOBALTIMER. */
/*! Array initializer of ARMGLOBALTIMER base addresses. */
#define ARMGLOBALTIMER_BASE_ADDRS { ARMGLOBALTIMER_BASE }

/*******************************************************************************
 * HW_ARMGLOBALTIMER_COUNTERn - Global Timer Counter Registers
 ******************************************************************************/

/*!
 * @brief HW_ARMGLOBALTIMER_COUNTERn - Global Timer Counter Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * There are two timer counter registers. They are the lower 32-bit timer
 * counter at offset 0x00 and the upper 32-bit timer counter at offset 0x04.
 */
typedef union _hw_armglobaltimer_countern
{
    uint32_t U;
    struct _hw_armglobaltimer_countern_bitfields
    {
        uint32_t VALUE : 32;           /*!< [31:0]  */
    } B;
} hw_armglobaltimer_countern_t;

/*!
 * @name Constants and macros for entire ARMGLOBALTIMER_COUNTERn register
 */
/*@{*/
#define HW_ARMGLOBALTIMER_COUNTERn_COUNT (2U)

#define HW_ARMGLOBALTIMER_COUNTERn_ADDR(x, n) ((uintptr_t)(x) + 0x200U + (0x4U * (n)))

#define HW_ARMGLOBALTIMER_COUNTERn(x, n) (*(__IO hw_armglobaltimer_countern_t *) HW_ARMGLOBALTIMER_COUNTERn_ADDR(x, n))
#define HW_ARMGLOBALTIMER_COUNTERn_RD(x, n) (HW_ARMGLOBALTIMER_COUNTERn(x, n).U)
#define HW_ARMGLOBALTIMER_COUNTERn_WR(x, n, v) (HW_ARMGLOBALTIMER_COUNTERn(x, n).U = (v))
#define HW_ARMGLOBALTIMER_COUNTERn_SET(x, n, v) (HW_ARMGLOBALTIMER_COUNTERn_WR(x, n, HW_ARMGLOBALTIMER_COUNTERn_RD(x, n) |  (v)))
#define HW_ARMGLOBALTIMER_COUNTERn_CLR(x, n, v) (HW_ARMGLOBALTIMER_COUNTERn_WR(x, n, HW_ARMGLOBALTIMER_COUNTERn_RD(x, n) & ~(v)))
#define HW_ARMGLOBALTIMER_COUNTERn_TOG(x, n, v) (HW_ARMGLOBALTIMER_COUNTERn_WR(x, n, HW_ARMGLOBALTIMER_COUNTERn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ARMGLOBALTIMER_COUNTERn bitfields
 */

/*!
 * @name Register ARMGLOBALTIMER_COUNTERn, field VALUE[31:0] (RW)
 *
 * 32-bits of the counter value.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_COUNTERn_VALUE (0U) /*!< Bit position for ARMGLOBALTIMER_COUNTERn_VALUE. */
#define BM_ARMGLOBALTIMER_COUNTERn_VALUE (0xFFFFFFFFU) /*!< Bit mask for ARMGLOBALTIMER_COUNTERn_VALUE. */
#define BS_ARMGLOBALTIMER_COUNTERn_VALUE (32U) /*!< Bit field size in bits for ARMGLOBALTIMER_COUNTERn_VALUE. */

/*! @brief Read current value of the ARMGLOBALTIMER_COUNTERn_VALUE field. */
#define BR_ARMGLOBALTIMER_COUNTERn_VALUE(x, n) (HW_ARMGLOBALTIMER_COUNTERn(x, n).U)

/*! @brief Format value for bitfield ARMGLOBALTIMER_COUNTERn_VALUE. */
#define BF_ARMGLOBALTIMER_COUNTERn_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_COUNTERn_VALUE) & BM_ARMGLOBALTIMER_COUNTERn_VALUE)

/*! @brief Set the VALUE field to a new value. */
#define BW_ARMGLOBALTIMER_COUNTERn_VALUE(x, n, v) (HW_ARMGLOBALTIMER_COUNTERn_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_ARMGLOBALTIMER_CONTROL - Global Timer Control Register
 ******************************************************************************/

/*!
 * @brief HW_ARMGLOBALTIMER_CONTROL - Global Timer Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Configuration and control of the Global Timer.
 */
typedef union _hw_armglobaltimer_control
{
    uint32_t U;
    struct _hw_armglobaltimer_control_bitfields
    {
        uint32_t TIMER_ENABLE : 1;     /*!< [0]  */
        uint32_t COMP_ENABLE : 1;      /*!< [1]  */
        uint32_t IRQ_ENABLE : 1;       /*!< [2]  */
        uint32_t AUTO_INCREMENT : 1;   /*!< [3]  */
        uint32_t RESERVED0 : 4;        /*!< [7:4]  */
        uint32_t PRESCALER : 8;        /*!< [15:8]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_armglobaltimer_control_t;

/*!
 * @name Constants and macros for entire ARMGLOBALTIMER_CONTROL register
 */
/*@{*/
#define HW_ARMGLOBALTIMER_CONTROL_ADDR(x) ((uintptr_t)(x) + 0x208U)

#define HW_ARMGLOBALTIMER_CONTROL(x) (*(__IO hw_armglobaltimer_control_t *) HW_ARMGLOBALTIMER_CONTROL_ADDR(x))
#define HW_ARMGLOBALTIMER_CONTROL_RD(x) (HW_ARMGLOBALTIMER_CONTROL(x).U)
#define HW_ARMGLOBALTIMER_CONTROL_WR(x, v) (HW_ARMGLOBALTIMER_CONTROL(x).U = (v))
#define HW_ARMGLOBALTIMER_CONTROL_SET(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, HW_ARMGLOBALTIMER_CONTROL_RD(x) |  (v)))
#define HW_ARMGLOBALTIMER_CONTROL_CLR(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~(v)))
#define HW_ARMGLOBALTIMER_CONTROL_TOG(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, HW_ARMGLOBALTIMER_CONTROL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ARMGLOBALTIMER_CONTROL bitfields
 */

/*!
 * @name Register ARMGLOBALTIMER_CONTROL, field TIMER_ENABLE[0] (RW)
 *
 * Timer enable.
 *
 * Values:
 * - 0 - Timer is disabled and the counter does not increment. All registers can
 *     still be read and written.
 * - 1 - Timer is enabled and the counter increments normally.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE (0U) /*!< Bit position for ARMGLOBALTIMER_CONTROL_TIMER_ENABLE. */
#define BM_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE (0x00000001U) /*!< Bit mask for ARMGLOBALTIMER_CONTROL_TIMER_ENABLE. */
#define BS_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE (1U) /*!< Bit field size in bits for ARMGLOBALTIMER_CONTROL_TIMER_ENABLE. */

#define BV_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE_DISABLED (0U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_TIMER_ENABLE: Timer is disabled and the counter does not increment. All registers can still be read and written. */
#define BV_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE_ENABLED (0x1U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_TIMER_ENABLE: Timer is enabled and the counter increments normally. */

/*! @brief Read current value of the ARMGLOBALTIMER_CONTROL_TIMER_ENABLE field. */
#define BR_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE(x) (HW_ARMGLOBALTIMER_CONTROL(x).B.TIMER_ENABLE)

/*! @brief Format value for bitfield ARMGLOBALTIMER_CONTROL_TIMER_ENABLE. */
#define BF_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE) & BM_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE)

/*! @brief Set the TIMER_ENABLE field to a new value. */
#define BW_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, (HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~BM_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE) | BF_ARMGLOBALTIMER_CONTROL_TIMER_ENABLE(v)))
/*@}*/

/*!
 * @name Register ARMGLOBALTIMER_CONTROL, field COMP_ENABLE[1] (RW)
 *
 * This bit is banked per Cortex-A9 processor. If set, it enables the comparison
 * between the 64-bit Timer Counter and the related 64-bit Comparator Register.
 * When the Auto-increment and Comp enable bits are set, an IRQ is generated
 * every auto-increment register value.
 *
 * Values:
 * - 0 - Comparison is disabled.
 * - 1 - Comparison is enabled.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_CONTROL_COMP_ENABLE (1U) /*!< Bit position for ARMGLOBALTIMER_CONTROL_COMP_ENABLE. */
#define BM_ARMGLOBALTIMER_CONTROL_COMP_ENABLE (0x00000002U) /*!< Bit mask for ARMGLOBALTIMER_CONTROL_COMP_ENABLE. */
#define BS_ARMGLOBALTIMER_CONTROL_COMP_ENABLE (1U) /*!< Bit field size in bits for ARMGLOBALTIMER_CONTROL_COMP_ENABLE. */

#define BV_ARMGLOBALTIMER_CONTROL_COMP_ENABLE_DISABLED (0U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_COMP_ENABLE: Comparison is disabled. */
#define BV_ARMGLOBALTIMER_CONTROL_COMP_ENABLE_ENABLED (0x1U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_COMP_ENABLE: Comparison is enabled. */

/*! @brief Read current value of the ARMGLOBALTIMER_CONTROL_COMP_ENABLE field. */
#define BR_ARMGLOBALTIMER_CONTROL_COMP_ENABLE(x) (HW_ARMGLOBALTIMER_CONTROL(x).B.COMP_ENABLE)

/*! @brief Format value for bitfield ARMGLOBALTIMER_CONTROL_COMP_ENABLE. */
#define BF_ARMGLOBALTIMER_CONTROL_COMP_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_CONTROL_COMP_ENABLE) & BM_ARMGLOBALTIMER_CONTROL_COMP_ENABLE)

/*! @brief Set the COMP_ENABLE field to a new value. */
#define BW_ARMGLOBALTIMER_CONTROL_COMP_ENABLE(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, (HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~BM_ARMGLOBALTIMER_CONTROL_COMP_ENABLE) | BF_ARMGLOBALTIMER_CONTROL_COMP_ENABLE(v)))
/*@}*/

/*!
 * @name Register ARMGLOBALTIMER_CONTROL, field IRQ_ENABLE[2] (RW)
 *
 * This bit is banked per Cortex-A9 processor. If set, the interrupt ID 27 is
 * set as pending in the Interrupt Distributor when the event flag is set in the
 * Timer Status Register.
 *
 * Values:
 * - 0 - Interrupts are disabled.
 * - 1 - Interrupts are enabled.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE (2U) /*!< Bit position for ARMGLOBALTIMER_CONTROL_IRQ_ENABLE. */
#define BM_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE (0x00000004U) /*!< Bit mask for ARMGLOBALTIMER_CONTROL_IRQ_ENABLE. */
#define BS_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE (1U) /*!< Bit field size in bits for ARMGLOBALTIMER_CONTROL_IRQ_ENABLE. */

#define BV_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE_DISABLED (0U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_IRQ_ENABLE: Interrupts are disabled. */
#define BV_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE_ENABLED (0x1U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_IRQ_ENABLE: Interrupts are enabled. */

/*! @brief Read current value of the ARMGLOBALTIMER_CONTROL_IRQ_ENABLE field. */
#define BR_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE(x) (HW_ARMGLOBALTIMER_CONTROL(x).B.IRQ_ENABLE)

/*! @brief Format value for bitfield ARMGLOBALTIMER_CONTROL_IRQ_ENABLE. */
#define BF_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE) & BM_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE)

/*! @brief Set the IRQ_ENABLE field to a new value. */
#define BW_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, (HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~BM_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE) | BF_ARMGLOBALTIMER_CONTROL_IRQ_ENABLE(v)))
/*@}*/

/*!
 * @name Register ARMGLOBALTIMER_CONTROL, field AUTO_INCREMENT[3] (RW)
 *
 * This bit is banked per Cortex-A9 processor.
 *
 * Values:
 * - 0 - When the counter reaches the comparator value, sets the event flag. It
 *     is the responsibility of software to update the comparator value to get
 *     more events.
 * - 1 - Each time the counter reaches the comparator value, the comparator
 *     register is incremented with the auto-increment register, so that more events
 *     can be set periodically without any software updates.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT (3U) /*!< Bit position for ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT. */
#define BM_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT (0x00000008U) /*!< Bit mask for ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT. */
#define BS_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT (1U) /*!< Bit field size in bits for ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT. */

#define BV_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT_SINGLE_SHOT_MODE (0U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT: When the counter reaches the comparator value, sets the event flag. It is the responsibility of software to update the comparator value to get more events. */
#define BV_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT_AUTO_INCREMENT_MODE (0x1U) /*!< Bit field value for ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT: Each time the counter reaches the comparator value, the comparator register is incremented with the auto-increment register, so that more events can be set periodically without any software updates. */

/*! @brief Read current value of the ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT field. */
#define BR_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT(x) (HW_ARMGLOBALTIMER_CONTROL(x).B.AUTO_INCREMENT)

/*! @brief Format value for bitfield ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT. */
#define BF_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT) & BM_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT)

/*! @brief Set the AUTO_INCREMENT field to a new value. */
#define BW_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, (HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~BM_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT) | BF_ARMGLOBALTIMER_CONTROL_AUTO_INCREMENT(v)))
/*@}*/

/*!
 * @name Register ARMGLOBALTIMER_CONTROL, field PRESCALER[15:8] (RW)
 *
 * The prescaler modifies the clock period for the decrementing event for the
 * Counter Register.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_CONTROL_PRESCALER (8U) /*!< Bit position for ARMGLOBALTIMER_CONTROL_PRESCALER. */
#define BM_ARMGLOBALTIMER_CONTROL_PRESCALER (0x0000FF00U) /*!< Bit mask for ARMGLOBALTIMER_CONTROL_PRESCALER. */
#define BS_ARMGLOBALTIMER_CONTROL_PRESCALER (8U) /*!< Bit field size in bits for ARMGLOBALTIMER_CONTROL_PRESCALER. */

/*! @brief Read current value of the ARMGLOBALTIMER_CONTROL_PRESCALER field. */
#define BR_ARMGLOBALTIMER_CONTROL_PRESCALER(x) (HW_ARMGLOBALTIMER_CONTROL(x).B.PRESCALER)

/*! @brief Format value for bitfield ARMGLOBALTIMER_CONTROL_PRESCALER. */
#define BF_ARMGLOBALTIMER_CONTROL_PRESCALER(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_CONTROL_PRESCALER) & BM_ARMGLOBALTIMER_CONTROL_PRESCALER)

/*! @brief Set the PRESCALER field to a new value. */
#define BW_ARMGLOBALTIMER_CONTROL_PRESCALER(x, v) (HW_ARMGLOBALTIMER_CONTROL_WR(x, (HW_ARMGLOBALTIMER_CONTROL_RD(x) & ~BM_ARMGLOBALTIMER_CONTROL_PRESCALER) | BF_ARMGLOBALTIMER_CONTROL_PRESCALER(v)))
/*@}*/

/*******************************************************************************
 * HW_ARMGLOBALTIMER_IRQSTATUS - Global Timer Interrupt Status Register
 ******************************************************************************/

/*!
 * @brief HW_ARMGLOBALTIMER_IRQSTATUS - Global Timer Interrupt Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This is a banked register for all Cortex-A9 processors present.
 */
typedef union _hw_armglobaltimer_irqstatus
{
    uint32_t U;
    struct _hw_armglobaltimer_irqstatus_bitfields
    {
        uint32_t EVENT_FLAG : 1;       /*!< [0]  */
        uint32_t RESERVED0 : 31;       /*!< [31:1]  */
    } B;
} hw_armglobaltimer_irqstatus_t;

/*!
 * @name Constants and macros for entire ARMGLOBALTIMER_IRQSTATUS register
 */
/*@{*/
#define HW_ARMGLOBALTIMER_IRQSTATUS_ADDR(x) ((uintptr_t)(x) + 0x20CU)

#define HW_ARMGLOBALTIMER_IRQSTATUS(x) (*(__IO hw_armglobaltimer_irqstatus_t *) HW_ARMGLOBALTIMER_IRQSTATUS_ADDR(x))
#define HW_ARMGLOBALTIMER_IRQSTATUS_RD(x) (HW_ARMGLOBALTIMER_IRQSTATUS(x).U)
#define HW_ARMGLOBALTIMER_IRQSTATUS_WR(x, v) (HW_ARMGLOBALTIMER_IRQSTATUS(x).U = (v))
#define HW_ARMGLOBALTIMER_IRQSTATUS_SET(x, v) (HW_ARMGLOBALTIMER_IRQSTATUS_WR(x, HW_ARMGLOBALTIMER_IRQSTATUS_RD(x) |  (v)))
#define HW_ARMGLOBALTIMER_IRQSTATUS_CLR(x, v) (HW_ARMGLOBALTIMER_IRQSTATUS_WR(x, HW_ARMGLOBALTIMER_IRQSTATUS_RD(x) & ~(v)))
#define HW_ARMGLOBALTIMER_IRQSTATUS_TOG(x, v) (HW_ARMGLOBALTIMER_IRQSTATUS_WR(x, HW_ARMGLOBALTIMER_IRQSTATUS_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ARMGLOBALTIMER_IRQSTATUS bitfields
 */

/*!
 * @name Register ARMGLOBALTIMER_IRQSTATUS, field EVENT_FLAG[0] (W1C)
 *
 * The event flag is a sticky bit that is automatically set when the Counter
 * Register reaches the Comparator Register value. If the timer interrupt is
 * enabled, Interrupt ID 27 is set as pending in the Interrupt Distributor after the
 * event flag is set. The event flag is cleared when written to 1.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG (0U) /*!< Bit position for ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG. */
#define BM_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG (0x00000001U) /*!< Bit mask for ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG. */
#define BS_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG (1U) /*!< Bit field size in bits for ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG. */

/*! @brief Read current value of the ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG field. */
#define BR_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG(x) (HW_ARMGLOBALTIMER_IRQSTATUS(x).B.EVENT_FLAG)

/*! @brief Format value for bitfield ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG. */
#define BF_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG) & BM_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG)

/*! @brief Set the EVENT_FLAG field to a new value. */
#define BW_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG(x, v) (HW_ARMGLOBALTIMER_IRQSTATUS_WR(x, (HW_ARMGLOBALTIMER_IRQSTATUS_RD(x) & ~BM_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG) | BF_ARMGLOBALTIMER_IRQSTATUS_EVENT_FLAG(v)))
/*@}*/

/*******************************************************************************
 * HW_ARMGLOBALTIMER_COMPARATORn - Global Timer Comparator Value Registers
 ******************************************************************************/

/*!
 * @brief HW_ARMGLOBALTIMER_COMPARATORn - Global Timer Comparator Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * There are two timer counter registers. They are the lower 32-bit timer
 * counter at offset 0x00 and the upper 32-bit timer counter at offset 0x04.
 */
typedef union _hw_armglobaltimer_comparatorn
{
    uint32_t U;
    struct _hw_armglobaltimer_comparatorn_bitfields
    {
        uint32_t VALUE : 32;           /*!< [31:0]  */
    } B;
} hw_armglobaltimer_comparatorn_t;

/*!
 * @name Constants and macros for entire ARMGLOBALTIMER_COMPARATORn register
 */
/*@{*/
#define HW_ARMGLOBALTIMER_COMPARATORn_COUNT (2U)

#define HW_ARMGLOBALTIMER_COMPARATORn_ADDR(x, n) ((uintptr_t)(x) + 0x210U + (0x4U * (n)))

#define HW_ARMGLOBALTIMER_COMPARATORn(x, n) (*(__IO hw_armglobaltimer_comparatorn_t *) HW_ARMGLOBALTIMER_COMPARATORn_ADDR(x, n))
#define HW_ARMGLOBALTIMER_COMPARATORn_RD(x, n) (HW_ARMGLOBALTIMER_COMPARATORn(x, n).U)
#define HW_ARMGLOBALTIMER_COMPARATORn_WR(x, n, v) (HW_ARMGLOBALTIMER_COMPARATORn(x, n).U = (v))
#define HW_ARMGLOBALTIMER_COMPARATORn_SET(x, n, v) (HW_ARMGLOBALTIMER_COMPARATORn_WR(x, n, HW_ARMGLOBALTIMER_COMPARATORn_RD(x, n) |  (v)))
#define HW_ARMGLOBALTIMER_COMPARATORn_CLR(x, n, v) (HW_ARMGLOBALTIMER_COMPARATORn_WR(x, n, HW_ARMGLOBALTIMER_COMPARATORn_RD(x, n) & ~(v)))
#define HW_ARMGLOBALTIMER_COMPARATORn_TOG(x, n, v) (HW_ARMGLOBALTIMER_COMPARATORn_WR(x, n, HW_ARMGLOBALTIMER_COMPARATORn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ARMGLOBALTIMER_COMPARATORn bitfields
 */

/*!
 * @name Register ARMGLOBALTIMER_COMPARATORn, field VALUE[31:0] (RW)
 *
 * 32-bits of the comparator value.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_COMPARATORn_VALUE (0U) /*!< Bit position for ARMGLOBALTIMER_COMPARATORn_VALUE. */
#define BM_ARMGLOBALTIMER_COMPARATORn_VALUE (0xFFFFFFFFU) /*!< Bit mask for ARMGLOBALTIMER_COMPARATORn_VALUE. */
#define BS_ARMGLOBALTIMER_COMPARATORn_VALUE (32U) /*!< Bit field size in bits for ARMGLOBALTIMER_COMPARATORn_VALUE. */

/*! @brief Read current value of the ARMGLOBALTIMER_COMPARATORn_VALUE field. */
#define BR_ARMGLOBALTIMER_COMPARATORn_VALUE(x, n) (HW_ARMGLOBALTIMER_COMPARATORn(x, n).U)

/*! @brief Format value for bitfield ARMGLOBALTIMER_COMPARATORn_VALUE. */
#define BF_ARMGLOBALTIMER_COMPARATORn_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_COMPARATORn_VALUE) & BM_ARMGLOBALTIMER_COMPARATORn_VALUE)

/*! @brief Set the VALUE field to a new value. */
#define BW_ARMGLOBALTIMER_COMPARATORn_VALUE(x, n, v) (HW_ARMGLOBALTIMER_COMPARATORn_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_ARMGLOBALTIMER_AUTOINCREMENT - Global Timer Auto-increment Register
 ******************************************************************************/

/*!
 * @brief HW_ARMGLOBALTIMER_AUTOINCREMENT - Global Timer Auto-increment Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This 32-bit register gives the increment value of the Comparator Register
 * when the Auto-increment bit is set in the Timer Control Register. Each Cortex-A9
 * processor present has its own Auto-increment Register. If the comp enable and
 * auto-increment bits are set when the global counter reaches the Comparator
 * Register value, the comparator is incremented by the auto-increment value, so
 * that a new event can be set periodically. The global timer is not affected and
 * goes on incrementing.
 */
typedef union _hw_armglobaltimer_autoincrement
{
    uint32_t U;
    struct _hw_armglobaltimer_autoincrement_bitfields
    {
        uint32_t VALUE : 32;           /*!< [31:0]  */
    } B;
} hw_armglobaltimer_autoincrement_t;

/*!
 * @name Constants and macros for entire ARMGLOBALTIMER_AUTOINCREMENT register
 */
/*@{*/
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_ADDR(x) ((uintptr_t)(x) + 0x218U)

#define HW_ARMGLOBALTIMER_AUTOINCREMENT(x) (*(__IO hw_armglobaltimer_autoincrement_t *) HW_ARMGLOBALTIMER_AUTOINCREMENT_ADDR(x))
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_RD(x) (HW_ARMGLOBALTIMER_AUTOINCREMENT(x).U)
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_WR(x, v) (HW_ARMGLOBALTIMER_AUTOINCREMENT(x).U = (v))
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_SET(x, v) (HW_ARMGLOBALTIMER_AUTOINCREMENT_WR(x, HW_ARMGLOBALTIMER_AUTOINCREMENT_RD(x) |  (v)))
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_CLR(x, v) (HW_ARMGLOBALTIMER_AUTOINCREMENT_WR(x, HW_ARMGLOBALTIMER_AUTOINCREMENT_RD(x) & ~(v)))
#define HW_ARMGLOBALTIMER_AUTOINCREMENT_TOG(x, v) (HW_ARMGLOBALTIMER_AUTOINCREMENT_WR(x, HW_ARMGLOBALTIMER_AUTOINCREMENT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ARMGLOBALTIMER_AUTOINCREMENT bitfields
 */

/*!
 * @name Register ARMGLOBALTIMER_AUTOINCREMENT, field VALUE[31:0] (RW)
 *
 * 32-bit auto-increment value.
 */
/*@{*/
#define BP_ARMGLOBALTIMER_AUTOINCREMENT_VALUE (0U) /*!< Bit position for ARMGLOBALTIMER_AUTOINCREMENT_VALUE. */
#define BM_ARMGLOBALTIMER_AUTOINCREMENT_VALUE (0xFFFFFFFFU) /*!< Bit mask for ARMGLOBALTIMER_AUTOINCREMENT_VALUE. */
#define BS_ARMGLOBALTIMER_AUTOINCREMENT_VALUE (32U) /*!< Bit field size in bits for ARMGLOBALTIMER_AUTOINCREMENT_VALUE. */

/*! @brief Read current value of the ARMGLOBALTIMER_AUTOINCREMENT_VALUE field. */
#define BR_ARMGLOBALTIMER_AUTOINCREMENT_VALUE(x) (HW_ARMGLOBALTIMER_AUTOINCREMENT(x).U)

/*! @brief Format value for bitfield ARMGLOBALTIMER_AUTOINCREMENT_VALUE. */
#define BF_ARMGLOBALTIMER_AUTOINCREMENT_VALUE(v) ((uint32_t)((uint32_t)(v) << BP_ARMGLOBALTIMER_AUTOINCREMENT_VALUE) & BM_ARMGLOBALTIMER_AUTOINCREMENT_VALUE)

/*! @brief Set the VALUE field to a new value. */
#define BW_ARMGLOBALTIMER_AUTOINCREMENT_VALUE(x, v) (HW_ARMGLOBALTIMER_AUTOINCREMENT_WR(x, v))
/*@}*/

/*******************************************************************************
 * hw_armglobaltimer_t - module struct
 ******************************************************************************/
/*!
 * @brief All ARMGLOBALTIMER module registers.
 */
#pragma pack(1)
typedef struct _hw_armglobaltimer
{
    uint8_t _reserved0[512];
    __IO hw_armglobaltimer_countern_t COUNTERn[2]; /*!< [0x200] Global Timer Counter Registers */
    __IO hw_armglobaltimer_control_t CONTROL; /*!< [0x208] Global Timer Control Register */
    __IO hw_armglobaltimer_irqstatus_t IRQSTATUS; /*!< [0x20C] Global Timer Interrupt Status Register */
    __IO hw_armglobaltimer_comparatorn_t COMPARATORn[2]; /*!< [0x210] Global Timer Comparator Value Registers */
    __IO hw_armglobaltimer_autoincrement_t AUTOINCREMENT; /*!< [0x218] Global Timer Auto-increment Register */
} hw_armglobaltimer_t;
#pragma pack()

/*! @brief Macro to access all ARMGLOBALTIMER registers. */
/*! @param x ARMGLOBALTIMER module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_ARMGLOBALTIMER_REGS(ARMGLOBALTIMER_BASE)</code>. */
#define HW_ARMGLOBALTIMER_REGS(x) (*(hw_armglobaltimer_t *)(x))

/*
 * iMX6SL AUDMUX
 *
 * AUDMUX Registers
 *
 * Registers defined in this header file:
 * - HW_AUDMUX_PTCR1 - Port Timing Control Register 1
 * - HW_AUDMUX_PDCR1 - Port Data Control Register 1
 * - HW_AUDMUX_PTCR2 - Port Timing Control Register 2
 * - HW_AUDMUX_PDCR2 - Port Data Control Register 2
 * - HW_AUDMUX_PTCR3 - Port Timing Control Register 3
 * - HW_AUDMUX_PDCR3 - Port Data Control Register 3
 * - HW_AUDMUX_PTCR4 - Port Timing Control Register 4
 * - HW_AUDMUX_PDCR4 - Port Data Control Register 4
 * - HW_AUDMUX_PTCR5 - Port Timing Control Register 5
 * - HW_AUDMUX_PDCR5 - Port Data Control Register 5
 * - HW_AUDMUX_PTCR6 - Port Timing Control Register 6
 * - HW_AUDMUX_PDCR6 - Port Data Control Register 6
 * - HW_AUDMUX_PTCR7 - Port Timing Control Register 7
 * - HW_AUDMUX_PDCR7 - Port Data Control Register 7
 *
 * - hw_audmux_t - Struct containing all module registers.
 */

#define HW_AUDMUX_INSTANCE_COUNT (1U) /*!< Number of instances of the AUDMUX module. */
#define HW_AUDMUX (0U) /*!< Instance number for AUDMUX. */
#define AUDMUX_BASE           (0x21D8000U) /*!< Base address for AUDMUX. */
/*! Array initializer of AUDMUX base addresses. */
#define AUDMUX_BASE_ADDRS     { AUDMUX_BASE }

/*******************************************************************************
 * HW_AUDMUX_PTCR1 - Port Timing Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR1 - Port Timing Control Register 1 (RW)
 *
 * Reset value: 0xAD400800U
 *
 * PTCR1 is the Port Timing Control Register for Port 1.
 */
typedef union _hw_audmux_ptcr1
{
    uint32_t U;
    struct _hw_audmux_ptcr1_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr1_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR1 register
 */
/*@{*/
#define HW_AUDMUX_PTCR1_ADDR(x)  ((uintptr_t)(x) + 0x0U)

#define HW_AUDMUX_PTCR1(x)       (*(__IO hw_audmux_ptcr1_t *) HW_AUDMUX_PTCR1_ADDR(x))
#define HW_AUDMUX_PTCR1_RD(x)    (HW_AUDMUX_PTCR1(x).U)
#define HW_AUDMUX_PTCR1_WR(x, v) (HW_AUDMUX_PTCR1(x).U = (v))
#define HW_AUDMUX_PTCR1_SET(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) |  (v)))
#define HW_AUDMUX_PTCR1_CLR(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR1_TOG(x, v) (HW_AUDMUX_PTCR1_WR(x, HW_AUDMUX_PTCR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR1 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR1, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR1_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR1_SYN. */
#define BM_AUDMUX_PTCR1_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR1_SYN. */
#define BS_AUDMUX_PTCR1_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR1_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR1_SYN field. */
#define BR_AUDMUX_PTCR1_SYN(x) (HW_AUDMUX_PTCR1(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR1_SYN. */
#define BF_AUDMUX_PTCR1_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_SYN) & BM_AUDMUX_PTCR1_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR1_SYN(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_SYN) | BF_AUDMUX_PTCR1_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR1_RCSEL. */
#define BM_AUDMUX_PTCR1_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR1_RCSEL. */
#define BS_AUDMUX_PTCR1_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_RCSEL field. */
#define BR_AUDMUX_PTCR1_RCSEL(x) (HW_AUDMUX_PTCR1(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RCSEL. */
#define BF_AUDMUX_PTCR1_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RCSEL) & BM_AUDMUX_PTCR1_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR1_RCSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RCSEL) | BF_AUDMUX_PTCR1_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR1_RCLKDIR. */
#define BM_AUDMUX_PTCR1_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR1_RCLKDIR. */
#define BS_AUDMUX_PTCR1_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_RCLKDIR field. */
#define BR_AUDMUX_PTCR1_RCLKDIR(x) (HW_AUDMUX_PTCR1(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RCLKDIR. */
#define BF_AUDMUX_PTCR1_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RCLKDIR) & BM_AUDMUX_PTCR1_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR1_RCLKDIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RCLKDIR) | BF_AUDMUX_PTCR1_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR1_RFSEL. */
#define BM_AUDMUX_PTCR1_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR1_RFSEL. */
#define BS_AUDMUX_PTCR1_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_RFSEL field. */
#define BR_AUDMUX_PTCR1_RFSEL(x) (HW_AUDMUX_PTCR1(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RFSEL. */
#define BF_AUDMUX_PTCR1_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RFSEL) & BM_AUDMUX_PTCR1_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR1_RFSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RFSEL) | BF_AUDMUX_PTCR1_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR1_RFS_DIR. */
#define BM_AUDMUX_PTCR1_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR1_RFS_DIR. */
#define BS_AUDMUX_PTCR1_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_RFS_DIR field. */
#define BR_AUDMUX_PTCR1_RFS_DIR(x) (HW_AUDMUX_PTCR1(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_RFS_DIR. */
#define BF_AUDMUX_PTCR1_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_RFS_DIR) & BM_AUDMUX_PTCR1_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR1_RFS_DIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_RFS_DIR) | BF_AUDMUX_PTCR1_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR1_TCSEL. */
#define BM_AUDMUX_PTCR1_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR1_TCSEL. */
#define BS_AUDMUX_PTCR1_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_TCSEL field. */
#define BR_AUDMUX_PTCR1_TCSEL(x) (HW_AUDMUX_PTCR1(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TCSEL. */
#define BF_AUDMUX_PTCR1_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TCSEL) & BM_AUDMUX_PTCR1_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR1_TCSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TCSEL) | BF_AUDMUX_PTCR1_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR1_TCLKDIR. */
#define BM_AUDMUX_PTCR1_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR1_TCLKDIR. */
#define BS_AUDMUX_PTCR1_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_TCLKDIR field. */
#define BR_AUDMUX_PTCR1_TCLKDIR(x) (HW_AUDMUX_PTCR1(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TCLKDIR. */
#define BF_AUDMUX_PTCR1_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TCLKDIR) & BM_AUDMUX_PTCR1_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR1_TCLKDIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TCLKDIR) | BF_AUDMUX_PTCR1_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR1_TFSEL. */
#define BM_AUDMUX_PTCR1_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR1_TFSEL. */
#define BS_AUDMUX_PTCR1_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR1_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR1_TFSEL field. */
#define BR_AUDMUX_PTCR1_TFSEL(x) (HW_AUDMUX_PTCR1(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TFSEL. */
#define BF_AUDMUX_PTCR1_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TFSEL) & BM_AUDMUX_PTCR1_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR1_TFSEL(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TFSEL) | BF_AUDMUX_PTCR1_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR1, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR1_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR1_TFS_DIR. */
#define BM_AUDMUX_PTCR1_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR1_TFS_DIR. */
#define BS_AUDMUX_PTCR1_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR1_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR1_TFS_DIR field. */
#define BR_AUDMUX_PTCR1_TFS_DIR(x) (HW_AUDMUX_PTCR1(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR1_TFS_DIR. */
#define BF_AUDMUX_PTCR1_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR1_TFS_DIR) & BM_AUDMUX_PTCR1_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR1_TFS_DIR(x, v) (HW_AUDMUX_PTCR1_WR(x, (HW_AUDMUX_PTCR1_RD(x) & ~BM_AUDMUX_PTCR1_TFS_DIR) | BF_AUDMUX_PTCR1_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR1 - Port Data Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR1 - Port Data Control Register 1 (RW)
 *
 * Reset value: 0x0000A000U
 *
 * PDCR1 is the Port Data Control Register for Port 1.
 */
typedef union _hw_audmux_pdcr1
{
    uint32_t U;
    struct _hw_audmux_pdcr1_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr1_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR1 register
 */
/*@{*/
#define HW_AUDMUX_PDCR1_ADDR(x)  ((uintptr_t)(x) + 0x4U)

#define HW_AUDMUX_PDCR1(x)       (*(__IO hw_audmux_pdcr1_t *) HW_AUDMUX_PDCR1_ADDR(x))
#define HW_AUDMUX_PDCR1_RD(x)    (HW_AUDMUX_PDCR1(x).U)
#define HW_AUDMUX_PDCR1_WR(x, v) (HW_AUDMUX_PDCR1(x).U = (v))
#define HW_AUDMUX_PDCR1_SET(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) |  (v)))
#define HW_AUDMUX_PDCR1_CLR(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR1_TOG(x, v) (HW_AUDMUX_PDCR1_WR(x, HW_AUDMUX_PDCR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR1 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR1, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR1_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR1_INMMASK. */
#define BM_AUDMUX_PDCR1_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR1_INMMASK. */
#define BS_AUDMUX_PDCR1_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR1_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR1_INMMASK field. */
#define BR_AUDMUX_PDCR1_INMMASK(x) (HW_AUDMUX_PDCR1(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR1_INMMASK. */
#define BF_AUDMUX_PDCR1_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_INMMASK) & BM_AUDMUX_PDCR1_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR1_INMMASK(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_INMMASK) | BF_AUDMUX_PDCR1_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR1_MODE (8U)          /*!< Bit position for AUDMUX_PDCR1_MODE. */
#define BM_AUDMUX_PDCR1_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR1_MODE. */
#define BS_AUDMUX_PDCR1_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR1_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR1_MODE field. */
#define BR_AUDMUX_PDCR1_MODE(x) (HW_AUDMUX_PDCR1(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR1_MODE. */
#define BF_AUDMUX_PDCR1_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_MODE) & BM_AUDMUX_PDCR1_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR1_MODE(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_MODE) | BF_AUDMUX_PDCR1_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR1_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR1_TXRXEN. */
#define BM_AUDMUX_PDCR1_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR1_TXRXEN. */
#define BS_AUDMUX_PDCR1_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR1_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR1_TXRXEN field. */
#define BR_AUDMUX_PDCR1_TXRXEN(x) (HW_AUDMUX_PDCR1(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR1_TXRXEN. */
#define BF_AUDMUX_PDCR1_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_TXRXEN) & BM_AUDMUX_PDCR1_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR1_TXRXEN(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_TXRXEN) | BF_AUDMUX_PDCR1_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR1, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR1_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR1_RXDSEL. */
#define BM_AUDMUX_PDCR1_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR1_RXDSEL. */
#define BS_AUDMUX_PDCR1_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR1_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR1_RXDSEL field. */
#define BR_AUDMUX_PDCR1_RXDSEL(x) (HW_AUDMUX_PDCR1(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR1_RXDSEL. */
#define BF_AUDMUX_PDCR1_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR1_RXDSEL) & BM_AUDMUX_PDCR1_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR1_RXDSEL(x, v) (HW_AUDMUX_PDCR1_WR(x, (HW_AUDMUX_PDCR1_RD(x) & ~BM_AUDMUX_PDCR1_RXDSEL) | BF_AUDMUX_PDCR1_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR2 - Port Timing Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR2 - Port Timing Control Register 2 (RW)
 *
 * Reset value: 0xA5000800U
 *
 * PTCR2 is the Port Timing Control Register for Port 2.
 */
typedef union _hw_audmux_ptcr2
{
    uint32_t U;
    struct _hw_audmux_ptcr2_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr2_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR2 register
 */
/*@{*/
#define HW_AUDMUX_PTCR2_ADDR(x)  ((uintptr_t)(x) + 0x8U)

#define HW_AUDMUX_PTCR2(x)       (*(__IO hw_audmux_ptcr2_t *) HW_AUDMUX_PTCR2_ADDR(x))
#define HW_AUDMUX_PTCR2_RD(x)    (HW_AUDMUX_PTCR2(x).U)
#define HW_AUDMUX_PTCR2_WR(x, v) (HW_AUDMUX_PTCR2(x).U = (v))
#define HW_AUDMUX_PTCR2_SET(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) |  (v)))
#define HW_AUDMUX_PTCR2_CLR(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR2_TOG(x, v) (HW_AUDMUX_PTCR2_WR(x, HW_AUDMUX_PTCR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR2 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR2, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR2_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR2_SYN. */
#define BM_AUDMUX_PTCR2_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR2_SYN. */
#define BS_AUDMUX_PTCR2_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR2_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR2_SYN field. */
#define BR_AUDMUX_PTCR2_SYN(x) (HW_AUDMUX_PTCR2(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR2_SYN. */
#define BF_AUDMUX_PTCR2_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_SYN) & BM_AUDMUX_PTCR2_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR2_SYN(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_SYN) | BF_AUDMUX_PTCR2_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR2_RCSEL. */
#define BM_AUDMUX_PTCR2_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR2_RCSEL. */
#define BS_AUDMUX_PTCR2_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_RCSEL field. */
#define BR_AUDMUX_PTCR2_RCSEL(x) (HW_AUDMUX_PTCR2(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RCSEL. */
#define BF_AUDMUX_PTCR2_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RCSEL) & BM_AUDMUX_PTCR2_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR2_RCSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RCSEL) | BF_AUDMUX_PTCR2_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR2_RCLKDIR. */
#define BM_AUDMUX_PTCR2_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR2_RCLKDIR. */
#define BS_AUDMUX_PTCR2_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_RCLKDIR field. */
#define BR_AUDMUX_PTCR2_RCLKDIR(x) (HW_AUDMUX_PTCR2(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RCLKDIR. */
#define BF_AUDMUX_PTCR2_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RCLKDIR) & BM_AUDMUX_PTCR2_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR2_RCLKDIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RCLKDIR) | BF_AUDMUX_PTCR2_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR2_RFSEL. */
#define BM_AUDMUX_PTCR2_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR2_RFSEL. */
#define BS_AUDMUX_PTCR2_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_RFSEL field. */
#define BR_AUDMUX_PTCR2_RFSEL(x) (HW_AUDMUX_PTCR2(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RFSEL. */
#define BF_AUDMUX_PTCR2_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RFSEL) & BM_AUDMUX_PTCR2_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR2_RFSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RFSEL) | BF_AUDMUX_PTCR2_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR2_RFS_DIR. */
#define BM_AUDMUX_PTCR2_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR2_RFS_DIR. */
#define BS_AUDMUX_PTCR2_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_RFS_DIR field. */
#define BR_AUDMUX_PTCR2_RFS_DIR(x) (HW_AUDMUX_PTCR2(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_RFS_DIR. */
#define BF_AUDMUX_PTCR2_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_RFS_DIR) & BM_AUDMUX_PTCR2_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR2_RFS_DIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_RFS_DIR) | BF_AUDMUX_PTCR2_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR2_TCSEL. */
#define BM_AUDMUX_PTCR2_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR2_TCSEL. */
#define BS_AUDMUX_PTCR2_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_TCSEL field. */
#define BR_AUDMUX_PTCR2_TCSEL(x) (HW_AUDMUX_PTCR2(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TCSEL. */
#define BF_AUDMUX_PTCR2_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TCSEL) & BM_AUDMUX_PTCR2_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR2_TCSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TCSEL) | BF_AUDMUX_PTCR2_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR2_TCLKDIR. */
#define BM_AUDMUX_PTCR2_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR2_TCLKDIR. */
#define BS_AUDMUX_PTCR2_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_TCLKDIR field. */
#define BR_AUDMUX_PTCR2_TCLKDIR(x) (HW_AUDMUX_PTCR2(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TCLKDIR. */
#define BF_AUDMUX_PTCR2_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TCLKDIR) & BM_AUDMUX_PTCR2_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR2_TCLKDIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TCLKDIR) | BF_AUDMUX_PTCR2_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR2_TFSEL. */
#define BM_AUDMUX_PTCR2_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR2_TFSEL. */
#define BS_AUDMUX_PTCR2_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR2_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR2_TFSEL field. */
#define BR_AUDMUX_PTCR2_TFSEL(x) (HW_AUDMUX_PTCR2(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TFSEL. */
#define BF_AUDMUX_PTCR2_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TFSEL) & BM_AUDMUX_PTCR2_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR2_TFSEL(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TFSEL) | BF_AUDMUX_PTCR2_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR2, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR2_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR2_TFS_DIR. */
#define BM_AUDMUX_PTCR2_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR2_TFS_DIR. */
#define BS_AUDMUX_PTCR2_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR2_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR2_TFS_DIR field. */
#define BR_AUDMUX_PTCR2_TFS_DIR(x) (HW_AUDMUX_PTCR2(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR2_TFS_DIR. */
#define BF_AUDMUX_PTCR2_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR2_TFS_DIR) & BM_AUDMUX_PTCR2_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR2_TFS_DIR(x, v) (HW_AUDMUX_PTCR2_WR(x, (HW_AUDMUX_PTCR2_RD(x) & ~BM_AUDMUX_PTCR2_TFS_DIR) | BF_AUDMUX_PTCR2_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR2 - Port Data Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR2 - Port Data Control Register 2 (RW)
 *
 * Reset value: 0x00008000U
 *
 * PDCR2 is the Port Data Control Register for Port 2.
 */
typedef union _hw_audmux_pdcr2
{
    uint32_t U;
    struct _hw_audmux_pdcr2_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr2_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR2 register
 */
/*@{*/
#define HW_AUDMUX_PDCR2_ADDR(x)  ((uintptr_t)(x) + 0xCU)

#define HW_AUDMUX_PDCR2(x)       (*(__IO hw_audmux_pdcr2_t *) HW_AUDMUX_PDCR2_ADDR(x))
#define HW_AUDMUX_PDCR2_RD(x)    (HW_AUDMUX_PDCR2(x).U)
#define HW_AUDMUX_PDCR2_WR(x, v) (HW_AUDMUX_PDCR2(x).U = (v))
#define HW_AUDMUX_PDCR2_SET(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) |  (v)))
#define HW_AUDMUX_PDCR2_CLR(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR2_TOG(x, v) (HW_AUDMUX_PDCR2_WR(x, HW_AUDMUX_PDCR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR2 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR2, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR2_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR2_INMMASK. */
#define BM_AUDMUX_PDCR2_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR2_INMMASK. */
#define BS_AUDMUX_PDCR2_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR2_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR2_INMMASK field. */
#define BR_AUDMUX_PDCR2_INMMASK(x) (HW_AUDMUX_PDCR2(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR2_INMMASK. */
#define BF_AUDMUX_PDCR2_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_INMMASK) & BM_AUDMUX_PDCR2_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR2_INMMASK(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_INMMASK) | BF_AUDMUX_PDCR2_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR2_MODE (8U)          /*!< Bit position for AUDMUX_PDCR2_MODE. */
#define BM_AUDMUX_PDCR2_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR2_MODE. */
#define BS_AUDMUX_PDCR2_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR2_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR2_MODE field. */
#define BR_AUDMUX_PDCR2_MODE(x) (HW_AUDMUX_PDCR2(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR2_MODE. */
#define BF_AUDMUX_PDCR2_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_MODE) & BM_AUDMUX_PDCR2_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR2_MODE(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_MODE) | BF_AUDMUX_PDCR2_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR2_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR2_TXRXEN. */
#define BM_AUDMUX_PDCR2_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR2_TXRXEN. */
#define BS_AUDMUX_PDCR2_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR2_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR2_TXRXEN field. */
#define BR_AUDMUX_PDCR2_TXRXEN(x) (HW_AUDMUX_PDCR2(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR2_TXRXEN. */
#define BF_AUDMUX_PDCR2_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_TXRXEN) & BM_AUDMUX_PDCR2_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR2_TXRXEN(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_TXRXEN) | BF_AUDMUX_PDCR2_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR2, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR2_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR2_RXDSEL. */
#define BM_AUDMUX_PDCR2_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR2_RXDSEL. */
#define BS_AUDMUX_PDCR2_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR2_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR2_RXDSEL field. */
#define BR_AUDMUX_PDCR2_RXDSEL(x) (HW_AUDMUX_PDCR2(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR2_RXDSEL. */
#define BF_AUDMUX_PDCR2_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR2_RXDSEL) & BM_AUDMUX_PDCR2_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR2_RXDSEL(x, v) (HW_AUDMUX_PDCR2_WR(x, (HW_AUDMUX_PDCR2_RD(x) & ~BM_AUDMUX_PDCR2_RXDSEL) | BF_AUDMUX_PDCR2_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR3 - Port Timing Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR3 - Port Timing Control Register 3 (RW)
 *
 * Reset value: 0x9CC00800U
 *
 * PTCR3 is the Port Timing Control Register for Port 3.
 */
typedef union _hw_audmux_ptcr3
{
    uint32_t U;
    struct _hw_audmux_ptcr3_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr3_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR3 register
 */
/*@{*/
#define HW_AUDMUX_PTCR3_ADDR(x)  ((uintptr_t)(x) + 0x10U)

#define HW_AUDMUX_PTCR3(x)       (*(__IO hw_audmux_ptcr3_t *) HW_AUDMUX_PTCR3_ADDR(x))
#define HW_AUDMUX_PTCR3_RD(x)    (HW_AUDMUX_PTCR3(x).U)
#define HW_AUDMUX_PTCR3_WR(x, v) (HW_AUDMUX_PTCR3(x).U = (v))
#define HW_AUDMUX_PTCR3_SET(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) |  (v)))
#define HW_AUDMUX_PTCR3_CLR(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR3_TOG(x, v) (HW_AUDMUX_PTCR3_WR(x, HW_AUDMUX_PTCR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR3 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR3, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR3_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR3_SYN. */
#define BM_AUDMUX_PTCR3_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR3_SYN. */
#define BS_AUDMUX_PTCR3_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR3_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR3_SYN field. */
#define BR_AUDMUX_PTCR3_SYN(x) (HW_AUDMUX_PTCR3(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR3_SYN. */
#define BF_AUDMUX_PTCR3_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_SYN) & BM_AUDMUX_PTCR3_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR3_SYN(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_SYN) | BF_AUDMUX_PTCR3_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR3_RCSEL. */
#define BM_AUDMUX_PTCR3_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR3_RCSEL. */
#define BS_AUDMUX_PTCR3_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_RCSEL field. */
#define BR_AUDMUX_PTCR3_RCSEL(x) (HW_AUDMUX_PTCR3(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RCSEL. */
#define BF_AUDMUX_PTCR3_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RCSEL) & BM_AUDMUX_PTCR3_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR3_RCSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RCSEL) | BF_AUDMUX_PTCR3_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR3_RCLKDIR. */
#define BM_AUDMUX_PTCR3_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR3_RCLKDIR. */
#define BS_AUDMUX_PTCR3_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_RCLKDIR field. */
#define BR_AUDMUX_PTCR3_RCLKDIR(x) (HW_AUDMUX_PTCR3(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RCLKDIR. */
#define BF_AUDMUX_PTCR3_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RCLKDIR) & BM_AUDMUX_PTCR3_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR3_RCLKDIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RCLKDIR) | BF_AUDMUX_PTCR3_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR3_RFSEL. */
#define BM_AUDMUX_PTCR3_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR3_RFSEL. */
#define BS_AUDMUX_PTCR3_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_RFSEL field. */
#define BR_AUDMUX_PTCR3_RFSEL(x) (HW_AUDMUX_PTCR3(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RFSEL. */
#define BF_AUDMUX_PTCR3_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RFSEL) & BM_AUDMUX_PTCR3_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR3_RFSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RFSEL) | BF_AUDMUX_PTCR3_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR3_RFS_DIR. */
#define BM_AUDMUX_PTCR3_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR3_RFS_DIR. */
#define BS_AUDMUX_PTCR3_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_RFS_DIR field. */
#define BR_AUDMUX_PTCR3_RFS_DIR(x) (HW_AUDMUX_PTCR3(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_RFS_DIR. */
#define BF_AUDMUX_PTCR3_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_RFS_DIR) & BM_AUDMUX_PTCR3_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR3_RFS_DIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_RFS_DIR) | BF_AUDMUX_PTCR3_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR3_TCSEL. */
#define BM_AUDMUX_PTCR3_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR3_TCSEL. */
#define BS_AUDMUX_PTCR3_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_TCSEL field. */
#define BR_AUDMUX_PTCR3_TCSEL(x) (HW_AUDMUX_PTCR3(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TCSEL. */
#define BF_AUDMUX_PTCR3_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TCSEL) & BM_AUDMUX_PTCR3_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR3_TCSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TCSEL) | BF_AUDMUX_PTCR3_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR3_TCLKDIR. */
#define BM_AUDMUX_PTCR3_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR3_TCLKDIR. */
#define BS_AUDMUX_PTCR3_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_TCLKDIR field. */
#define BR_AUDMUX_PTCR3_TCLKDIR(x) (HW_AUDMUX_PTCR3(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TCLKDIR. */
#define BF_AUDMUX_PTCR3_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TCLKDIR) & BM_AUDMUX_PTCR3_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR3_TCLKDIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TCLKDIR) | BF_AUDMUX_PTCR3_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR3_TFSEL. */
#define BM_AUDMUX_PTCR3_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR3_TFSEL. */
#define BS_AUDMUX_PTCR3_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR3_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR3_TFSEL field. */
#define BR_AUDMUX_PTCR3_TFSEL(x) (HW_AUDMUX_PTCR3(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TFSEL. */
#define BF_AUDMUX_PTCR3_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TFSEL) & BM_AUDMUX_PTCR3_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR3_TFSEL(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TFSEL) | BF_AUDMUX_PTCR3_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR3, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR3_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR3_TFS_DIR. */
#define BM_AUDMUX_PTCR3_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR3_TFS_DIR. */
#define BS_AUDMUX_PTCR3_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR3_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR3_TFS_DIR field. */
#define BR_AUDMUX_PTCR3_TFS_DIR(x) (HW_AUDMUX_PTCR3(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR3_TFS_DIR. */
#define BF_AUDMUX_PTCR3_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR3_TFS_DIR) & BM_AUDMUX_PTCR3_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR3_TFS_DIR(x, v) (HW_AUDMUX_PTCR3_WR(x, (HW_AUDMUX_PTCR3_RD(x) & ~BM_AUDMUX_PTCR3_TFS_DIR) | BF_AUDMUX_PTCR3_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR3 - Port Data Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR3 - Port Data Control Register 3 (RW)
 *
 * Reset value: 0x00006000U
 *
 * PDCR3 is the Port Data Control Register for Port 3.
 */
typedef union _hw_audmux_pdcr3
{
    uint32_t U;
    struct _hw_audmux_pdcr3_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr3_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR3 register
 */
/*@{*/
#define HW_AUDMUX_PDCR3_ADDR(x)  ((uintptr_t)(x) + 0x14U)

#define HW_AUDMUX_PDCR3(x)       (*(__IO hw_audmux_pdcr3_t *) HW_AUDMUX_PDCR3_ADDR(x))
#define HW_AUDMUX_PDCR3_RD(x)    (HW_AUDMUX_PDCR3(x).U)
#define HW_AUDMUX_PDCR3_WR(x, v) (HW_AUDMUX_PDCR3(x).U = (v))
#define HW_AUDMUX_PDCR3_SET(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) |  (v)))
#define HW_AUDMUX_PDCR3_CLR(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR3_TOG(x, v) (HW_AUDMUX_PDCR3_WR(x, HW_AUDMUX_PDCR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR3 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR3, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR3_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR3_INMMASK. */
#define BM_AUDMUX_PDCR3_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR3_INMMASK. */
#define BS_AUDMUX_PDCR3_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR3_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR3_INMMASK field. */
#define BR_AUDMUX_PDCR3_INMMASK(x) (HW_AUDMUX_PDCR3(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR3_INMMASK. */
#define BF_AUDMUX_PDCR3_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_INMMASK) & BM_AUDMUX_PDCR3_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR3_INMMASK(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_INMMASK) | BF_AUDMUX_PDCR3_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR3_MODE (8U)          /*!< Bit position for AUDMUX_PDCR3_MODE. */
#define BM_AUDMUX_PDCR3_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR3_MODE. */
#define BS_AUDMUX_PDCR3_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR3_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR3_MODE field. */
#define BR_AUDMUX_PDCR3_MODE(x) (HW_AUDMUX_PDCR3(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR3_MODE. */
#define BF_AUDMUX_PDCR3_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_MODE) & BM_AUDMUX_PDCR3_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR3_MODE(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_MODE) | BF_AUDMUX_PDCR3_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR3_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR3_TXRXEN. */
#define BM_AUDMUX_PDCR3_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR3_TXRXEN. */
#define BS_AUDMUX_PDCR3_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR3_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR3_TXRXEN field. */
#define BR_AUDMUX_PDCR3_TXRXEN(x) (HW_AUDMUX_PDCR3(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR3_TXRXEN. */
#define BF_AUDMUX_PDCR3_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_TXRXEN) & BM_AUDMUX_PDCR3_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR3_TXRXEN(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_TXRXEN) | BF_AUDMUX_PDCR3_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR3, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR3_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR3_RXDSEL. */
#define BM_AUDMUX_PDCR3_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR3_RXDSEL. */
#define BS_AUDMUX_PDCR3_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR3_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR3_RXDSEL field. */
#define BR_AUDMUX_PDCR3_RXDSEL(x) (HW_AUDMUX_PDCR3(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR3_RXDSEL. */
#define BF_AUDMUX_PDCR3_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR3_RXDSEL) & BM_AUDMUX_PDCR3_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR3_RXDSEL(x, v) (HW_AUDMUX_PDCR3_WR(x, (HW_AUDMUX_PDCR3_RD(x) & ~BM_AUDMUX_PDCR3_RXDSEL) | BF_AUDMUX_PDCR3_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR4 - Port Timing Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR4 - Port Timing Control Register 4 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 4
 */
typedef union _hw_audmux_ptcr4
{
    uint32_t U;
    struct _hw_audmux_ptcr4_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr4_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR4 register
 */
/*@{*/
#define HW_AUDMUX_PTCR4_ADDR(x)  ((uintptr_t)(x) + 0x18U)

#define HW_AUDMUX_PTCR4(x)       (*(__IO hw_audmux_ptcr4_t *) HW_AUDMUX_PTCR4_ADDR(x))
#define HW_AUDMUX_PTCR4_RD(x)    (HW_AUDMUX_PTCR4(x).U)
#define HW_AUDMUX_PTCR4_WR(x, v) (HW_AUDMUX_PTCR4(x).U = (v))
#define HW_AUDMUX_PTCR4_SET(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) |  (v)))
#define HW_AUDMUX_PTCR4_CLR(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR4_TOG(x, v) (HW_AUDMUX_PTCR4_WR(x, HW_AUDMUX_PTCR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR4 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR4, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR4_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR4_SYN. */
#define BM_AUDMUX_PTCR4_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR4_SYN. */
#define BS_AUDMUX_PTCR4_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR4_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR4_SYN field. */
#define BR_AUDMUX_PTCR4_SYN(x) (HW_AUDMUX_PTCR4(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR4_SYN. */
#define BF_AUDMUX_PTCR4_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_SYN) & BM_AUDMUX_PTCR4_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR4_SYN(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_SYN) | BF_AUDMUX_PTCR4_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR4_RCSEL. */
#define BM_AUDMUX_PTCR4_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR4_RCSEL. */
#define BS_AUDMUX_PTCR4_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_RCSEL field. */
#define BR_AUDMUX_PTCR4_RCSEL(x) (HW_AUDMUX_PTCR4(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RCSEL. */
#define BF_AUDMUX_PTCR4_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RCSEL) & BM_AUDMUX_PTCR4_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR4_RCSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RCSEL) | BF_AUDMUX_PTCR4_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR4_RCLKDIR. */
#define BM_AUDMUX_PTCR4_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR4_RCLKDIR. */
#define BS_AUDMUX_PTCR4_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_RCLKDIR field. */
#define BR_AUDMUX_PTCR4_RCLKDIR(x) (HW_AUDMUX_PTCR4(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RCLKDIR. */
#define BF_AUDMUX_PTCR4_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RCLKDIR) & BM_AUDMUX_PTCR4_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR4_RCLKDIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RCLKDIR) | BF_AUDMUX_PTCR4_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR4_RFSEL. */
#define BM_AUDMUX_PTCR4_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR4_RFSEL. */
#define BS_AUDMUX_PTCR4_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_RFSEL field. */
#define BR_AUDMUX_PTCR4_RFSEL(x) (HW_AUDMUX_PTCR4(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RFSEL. */
#define BF_AUDMUX_PTCR4_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RFSEL) & BM_AUDMUX_PTCR4_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR4_RFSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RFSEL) | BF_AUDMUX_PTCR4_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR4_RFS_DIR. */
#define BM_AUDMUX_PTCR4_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR4_RFS_DIR. */
#define BS_AUDMUX_PTCR4_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_RFS_DIR field. */
#define BR_AUDMUX_PTCR4_RFS_DIR(x) (HW_AUDMUX_PTCR4(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_RFS_DIR. */
#define BF_AUDMUX_PTCR4_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_RFS_DIR) & BM_AUDMUX_PTCR4_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR4_RFS_DIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_RFS_DIR) | BF_AUDMUX_PTCR4_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR4_TCSEL. */
#define BM_AUDMUX_PTCR4_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR4_TCSEL. */
#define BS_AUDMUX_PTCR4_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_TCSEL field. */
#define BR_AUDMUX_PTCR4_TCSEL(x) (HW_AUDMUX_PTCR4(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TCSEL. */
#define BF_AUDMUX_PTCR4_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TCSEL) & BM_AUDMUX_PTCR4_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR4_TCSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TCSEL) | BF_AUDMUX_PTCR4_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR4_TCLKDIR. */
#define BM_AUDMUX_PTCR4_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR4_TCLKDIR. */
#define BS_AUDMUX_PTCR4_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_TCLKDIR field. */
#define BR_AUDMUX_PTCR4_TCLKDIR(x) (HW_AUDMUX_PTCR4(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TCLKDIR. */
#define BF_AUDMUX_PTCR4_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TCLKDIR) & BM_AUDMUX_PTCR4_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR4_TCLKDIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TCLKDIR) | BF_AUDMUX_PTCR4_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR4_TFSEL. */
#define BM_AUDMUX_PTCR4_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR4_TFSEL. */
#define BS_AUDMUX_PTCR4_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR4_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR4_TFSEL field. */
#define BR_AUDMUX_PTCR4_TFSEL(x) (HW_AUDMUX_PTCR4(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TFSEL. */
#define BF_AUDMUX_PTCR4_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TFSEL) & BM_AUDMUX_PTCR4_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR4_TFSEL(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TFSEL) | BF_AUDMUX_PTCR4_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR4, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR4_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR4_TFS_DIR. */
#define BM_AUDMUX_PTCR4_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR4_TFS_DIR. */
#define BS_AUDMUX_PTCR4_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR4_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR4_TFS_DIR field. */
#define BR_AUDMUX_PTCR4_TFS_DIR(x) (HW_AUDMUX_PTCR4(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR4_TFS_DIR. */
#define BF_AUDMUX_PTCR4_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR4_TFS_DIR) & BM_AUDMUX_PTCR4_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR4_TFS_DIR(x, v) (HW_AUDMUX_PTCR4_WR(x, (HW_AUDMUX_PTCR4_RD(x) & ~BM_AUDMUX_PTCR4_TFS_DIR) | BF_AUDMUX_PTCR4_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR4 - Port Data Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR4 - Port Data Control Register 4 (RW)
 *
 * Reset value: 0x00004000U
 *
 * PDCR4 is the Port Data Control Register for Port 4.
 */
typedef union _hw_audmux_pdcr4
{
    uint32_t U;
    struct _hw_audmux_pdcr4_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr4_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR4 register
 */
/*@{*/
#define HW_AUDMUX_PDCR4_ADDR(x)  ((uintptr_t)(x) + 0x1CU)

#define HW_AUDMUX_PDCR4(x)       (*(__IO hw_audmux_pdcr4_t *) HW_AUDMUX_PDCR4_ADDR(x))
#define HW_AUDMUX_PDCR4_RD(x)    (HW_AUDMUX_PDCR4(x).U)
#define HW_AUDMUX_PDCR4_WR(x, v) (HW_AUDMUX_PDCR4(x).U = (v))
#define HW_AUDMUX_PDCR4_SET(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) |  (v)))
#define HW_AUDMUX_PDCR4_CLR(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR4_TOG(x, v) (HW_AUDMUX_PDCR4_WR(x, HW_AUDMUX_PDCR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR4 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR4, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR4_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR4_INMMASK. */
#define BM_AUDMUX_PDCR4_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR4_INMMASK. */
#define BS_AUDMUX_PDCR4_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR4_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR4_INMMASK field. */
#define BR_AUDMUX_PDCR4_INMMASK(x) (HW_AUDMUX_PDCR4(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR4_INMMASK. */
#define BF_AUDMUX_PDCR4_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_INMMASK) & BM_AUDMUX_PDCR4_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR4_INMMASK(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_INMMASK) | BF_AUDMUX_PDCR4_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR4_MODE (8U)          /*!< Bit position for AUDMUX_PDCR4_MODE. */
#define BM_AUDMUX_PDCR4_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR4_MODE. */
#define BS_AUDMUX_PDCR4_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR4_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR4_MODE field. */
#define BR_AUDMUX_PDCR4_MODE(x) (HW_AUDMUX_PDCR4(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR4_MODE. */
#define BF_AUDMUX_PDCR4_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_MODE) & BM_AUDMUX_PDCR4_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR4_MODE(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_MODE) | BF_AUDMUX_PDCR4_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR4_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR4_TXRXEN. */
#define BM_AUDMUX_PDCR4_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR4_TXRXEN. */
#define BS_AUDMUX_PDCR4_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR4_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR4_TXRXEN field. */
#define BR_AUDMUX_PDCR4_TXRXEN(x) (HW_AUDMUX_PDCR4(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR4_TXRXEN. */
#define BF_AUDMUX_PDCR4_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_TXRXEN) & BM_AUDMUX_PDCR4_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR4_TXRXEN(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_TXRXEN) | BF_AUDMUX_PDCR4_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR4, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR4_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR4_RXDSEL. */
#define BM_AUDMUX_PDCR4_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR4_RXDSEL. */
#define BS_AUDMUX_PDCR4_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR4_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR4_RXDSEL field. */
#define BR_AUDMUX_PDCR4_RXDSEL(x) (HW_AUDMUX_PDCR4(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR4_RXDSEL. */
#define BF_AUDMUX_PDCR4_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR4_RXDSEL) & BM_AUDMUX_PDCR4_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR4_RXDSEL(x, v) (HW_AUDMUX_PDCR4_WR(x, (HW_AUDMUX_PDCR4_RD(x) & ~BM_AUDMUX_PDCR4_RXDSEL) | BF_AUDMUX_PDCR4_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR5 - Port Timing Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR5 - Port Timing Control Register 5 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 5
 */
typedef union _hw_audmux_ptcr5
{
    uint32_t U;
    struct _hw_audmux_ptcr5_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr5_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR5 register
 */
/*@{*/
#define HW_AUDMUX_PTCR5_ADDR(x)  ((uintptr_t)(x) + 0x20U)

#define HW_AUDMUX_PTCR5(x)       (*(__IO hw_audmux_ptcr5_t *) HW_AUDMUX_PTCR5_ADDR(x))
#define HW_AUDMUX_PTCR5_RD(x)    (HW_AUDMUX_PTCR5(x).U)
#define HW_AUDMUX_PTCR5_WR(x, v) (HW_AUDMUX_PTCR5(x).U = (v))
#define HW_AUDMUX_PTCR5_SET(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) |  (v)))
#define HW_AUDMUX_PTCR5_CLR(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR5_TOG(x, v) (HW_AUDMUX_PTCR5_WR(x, HW_AUDMUX_PTCR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR5 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR5, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR5_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR5_SYN. */
#define BM_AUDMUX_PTCR5_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR5_SYN. */
#define BS_AUDMUX_PTCR5_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR5_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR5_SYN field. */
#define BR_AUDMUX_PTCR5_SYN(x) (HW_AUDMUX_PTCR5(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR5_SYN. */
#define BF_AUDMUX_PTCR5_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_SYN) & BM_AUDMUX_PTCR5_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR5_SYN(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_SYN) | BF_AUDMUX_PTCR5_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR5_RCSEL. */
#define BM_AUDMUX_PTCR5_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR5_RCSEL. */
#define BS_AUDMUX_PTCR5_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_RCSEL field. */
#define BR_AUDMUX_PTCR5_RCSEL(x) (HW_AUDMUX_PTCR5(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RCSEL. */
#define BF_AUDMUX_PTCR5_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RCSEL) & BM_AUDMUX_PTCR5_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR5_RCSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RCSEL) | BF_AUDMUX_PTCR5_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR5_RCLKDIR. */
#define BM_AUDMUX_PTCR5_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR5_RCLKDIR. */
#define BS_AUDMUX_PTCR5_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_RCLKDIR field. */
#define BR_AUDMUX_PTCR5_RCLKDIR(x) (HW_AUDMUX_PTCR5(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RCLKDIR. */
#define BF_AUDMUX_PTCR5_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RCLKDIR) & BM_AUDMUX_PTCR5_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR5_RCLKDIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RCLKDIR) | BF_AUDMUX_PTCR5_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR5_RFSEL. */
#define BM_AUDMUX_PTCR5_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR5_RFSEL. */
#define BS_AUDMUX_PTCR5_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_RFSEL field. */
#define BR_AUDMUX_PTCR5_RFSEL(x) (HW_AUDMUX_PTCR5(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RFSEL. */
#define BF_AUDMUX_PTCR5_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RFSEL) & BM_AUDMUX_PTCR5_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR5_RFSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RFSEL) | BF_AUDMUX_PTCR5_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR5_RFS_DIR. */
#define BM_AUDMUX_PTCR5_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR5_RFS_DIR. */
#define BS_AUDMUX_PTCR5_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_RFS_DIR field. */
#define BR_AUDMUX_PTCR5_RFS_DIR(x) (HW_AUDMUX_PTCR5(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_RFS_DIR. */
#define BF_AUDMUX_PTCR5_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_RFS_DIR) & BM_AUDMUX_PTCR5_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR5_RFS_DIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_RFS_DIR) | BF_AUDMUX_PTCR5_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR5_TCSEL. */
#define BM_AUDMUX_PTCR5_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR5_TCSEL. */
#define BS_AUDMUX_PTCR5_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_TCSEL field. */
#define BR_AUDMUX_PTCR5_TCSEL(x) (HW_AUDMUX_PTCR5(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TCSEL. */
#define BF_AUDMUX_PTCR5_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TCSEL) & BM_AUDMUX_PTCR5_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR5_TCSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TCSEL) | BF_AUDMUX_PTCR5_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR5_TCLKDIR. */
#define BM_AUDMUX_PTCR5_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR5_TCLKDIR. */
#define BS_AUDMUX_PTCR5_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_TCLKDIR field. */
#define BR_AUDMUX_PTCR5_TCLKDIR(x) (HW_AUDMUX_PTCR5(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TCLKDIR. */
#define BF_AUDMUX_PTCR5_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TCLKDIR) & BM_AUDMUX_PTCR5_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR5_TCLKDIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TCLKDIR) | BF_AUDMUX_PTCR5_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR5_TFSEL. */
#define BM_AUDMUX_PTCR5_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR5_TFSEL. */
#define BS_AUDMUX_PTCR5_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR5_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR5_TFSEL field. */
#define BR_AUDMUX_PTCR5_TFSEL(x) (HW_AUDMUX_PTCR5(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TFSEL. */
#define BF_AUDMUX_PTCR5_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TFSEL) & BM_AUDMUX_PTCR5_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR5_TFSEL(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TFSEL) | BF_AUDMUX_PTCR5_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR5, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR5_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR5_TFS_DIR. */
#define BM_AUDMUX_PTCR5_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR5_TFS_DIR. */
#define BS_AUDMUX_PTCR5_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR5_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR5_TFS_DIR field. */
#define BR_AUDMUX_PTCR5_TFS_DIR(x) (HW_AUDMUX_PTCR5(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR5_TFS_DIR. */
#define BF_AUDMUX_PTCR5_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR5_TFS_DIR) & BM_AUDMUX_PTCR5_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR5_TFS_DIR(x, v) (HW_AUDMUX_PTCR5_WR(x, (HW_AUDMUX_PTCR5_RD(x) & ~BM_AUDMUX_PTCR5_TFS_DIR) | BF_AUDMUX_PTCR5_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR5 - Port Data Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR5 - Port Data Control Register 5 (RW)
 *
 * Reset value: 0x00002000U
 *
 * PDCR5 is the Port Data Control Register for Port 5.
 */
typedef union _hw_audmux_pdcr5
{
    uint32_t U;
    struct _hw_audmux_pdcr5_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr5_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR5 register
 */
/*@{*/
#define HW_AUDMUX_PDCR5_ADDR(x)  ((uintptr_t)(x) + 0x24U)

#define HW_AUDMUX_PDCR5(x)       (*(__IO hw_audmux_pdcr5_t *) HW_AUDMUX_PDCR5_ADDR(x))
#define HW_AUDMUX_PDCR5_RD(x)    (HW_AUDMUX_PDCR5(x).U)
#define HW_AUDMUX_PDCR5_WR(x, v) (HW_AUDMUX_PDCR5(x).U = (v))
#define HW_AUDMUX_PDCR5_SET(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) |  (v)))
#define HW_AUDMUX_PDCR5_CLR(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR5_TOG(x, v) (HW_AUDMUX_PDCR5_WR(x, HW_AUDMUX_PDCR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR5 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR5, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR5_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR5_INMMASK. */
#define BM_AUDMUX_PDCR5_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR5_INMMASK. */
#define BS_AUDMUX_PDCR5_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR5_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR5_INMMASK field. */
#define BR_AUDMUX_PDCR5_INMMASK(x) (HW_AUDMUX_PDCR5(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR5_INMMASK. */
#define BF_AUDMUX_PDCR5_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_INMMASK) & BM_AUDMUX_PDCR5_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR5_INMMASK(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_INMMASK) | BF_AUDMUX_PDCR5_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR5_MODE (8U)          /*!< Bit position for AUDMUX_PDCR5_MODE. */
#define BM_AUDMUX_PDCR5_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR5_MODE. */
#define BS_AUDMUX_PDCR5_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR5_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR5_MODE field. */
#define BR_AUDMUX_PDCR5_MODE(x) (HW_AUDMUX_PDCR5(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR5_MODE. */
#define BF_AUDMUX_PDCR5_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_MODE) & BM_AUDMUX_PDCR5_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR5_MODE(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_MODE) | BF_AUDMUX_PDCR5_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR5_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR5_TXRXEN. */
#define BM_AUDMUX_PDCR5_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR5_TXRXEN. */
#define BS_AUDMUX_PDCR5_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR5_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR5_TXRXEN field. */
#define BR_AUDMUX_PDCR5_TXRXEN(x) (HW_AUDMUX_PDCR5(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR5_TXRXEN. */
#define BF_AUDMUX_PDCR5_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_TXRXEN) & BM_AUDMUX_PDCR5_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR5_TXRXEN(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_TXRXEN) | BF_AUDMUX_PDCR5_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR5, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR5_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR5_RXDSEL. */
#define BM_AUDMUX_PDCR5_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR5_RXDSEL. */
#define BS_AUDMUX_PDCR5_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR5_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR5_RXDSEL field. */
#define BR_AUDMUX_PDCR5_RXDSEL(x) (HW_AUDMUX_PDCR5(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR5_RXDSEL. */
#define BF_AUDMUX_PDCR5_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR5_RXDSEL) & BM_AUDMUX_PDCR5_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR5_RXDSEL(x, v) (HW_AUDMUX_PDCR5_WR(x, (HW_AUDMUX_PDCR5_RD(x) & ~BM_AUDMUX_PDCR5_RXDSEL) | BF_AUDMUX_PDCR5_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR6 - Port Timing Control Register 6
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR6 - Port Timing Control Register 6 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 6
 */
typedef union _hw_audmux_ptcr6
{
    uint32_t U;
    struct _hw_audmux_ptcr6_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr6_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR6 register
 */
/*@{*/
#define HW_AUDMUX_PTCR6_ADDR(x)  ((uintptr_t)(x) + 0x28U)

#define HW_AUDMUX_PTCR6(x)       (*(__IO hw_audmux_ptcr6_t *) HW_AUDMUX_PTCR6_ADDR(x))
#define HW_AUDMUX_PTCR6_RD(x)    (HW_AUDMUX_PTCR6(x).U)
#define HW_AUDMUX_PTCR6_WR(x, v) (HW_AUDMUX_PTCR6(x).U = (v))
#define HW_AUDMUX_PTCR6_SET(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) |  (v)))
#define HW_AUDMUX_PTCR6_CLR(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR6_TOG(x, v) (HW_AUDMUX_PTCR6_WR(x, HW_AUDMUX_PTCR6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR6 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR6, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR6_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR6_SYN. */
#define BM_AUDMUX_PTCR6_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR6_SYN. */
#define BS_AUDMUX_PTCR6_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR6_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR6_SYN field. */
#define BR_AUDMUX_PTCR6_SYN(x) (HW_AUDMUX_PTCR6(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR6_SYN. */
#define BF_AUDMUX_PTCR6_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_SYN) & BM_AUDMUX_PTCR6_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR6_SYN(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_SYN) | BF_AUDMUX_PTCR6_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR6_RCSEL. */
#define BM_AUDMUX_PTCR6_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR6_RCSEL. */
#define BS_AUDMUX_PTCR6_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_RCSEL field. */
#define BR_AUDMUX_PTCR6_RCSEL(x) (HW_AUDMUX_PTCR6(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RCSEL. */
#define BF_AUDMUX_PTCR6_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RCSEL) & BM_AUDMUX_PTCR6_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR6_RCSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RCSEL) | BF_AUDMUX_PTCR6_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR6_RCLKDIR. */
#define BM_AUDMUX_PTCR6_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR6_RCLKDIR. */
#define BS_AUDMUX_PTCR6_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_RCLKDIR field. */
#define BR_AUDMUX_PTCR6_RCLKDIR(x) (HW_AUDMUX_PTCR6(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RCLKDIR. */
#define BF_AUDMUX_PTCR6_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RCLKDIR) & BM_AUDMUX_PTCR6_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR6_RCLKDIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RCLKDIR) | BF_AUDMUX_PTCR6_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR6_RFSEL. */
#define BM_AUDMUX_PTCR6_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR6_RFSEL. */
#define BS_AUDMUX_PTCR6_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_RFSEL field. */
#define BR_AUDMUX_PTCR6_RFSEL(x) (HW_AUDMUX_PTCR6(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RFSEL. */
#define BF_AUDMUX_PTCR6_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RFSEL) & BM_AUDMUX_PTCR6_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR6_RFSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RFSEL) | BF_AUDMUX_PTCR6_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR6_RFS_DIR. */
#define BM_AUDMUX_PTCR6_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR6_RFS_DIR. */
#define BS_AUDMUX_PTCR6_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_RFS_DIR field. */
#define BR_AUDMUX_PTCR6_RFS_DIR(x) (HW_AUDMUX_PTCR6(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_RFS_DIR. */
#define BF_AUDMUX_PTCR6_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_RFS_DIR) & BM_AUDMUX_PTCR6_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR6_RFS_DIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_RFS_DIR) | BF_AUDMUX_PTCR6_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR6_TCSEL. */
#define BM_AUDMUX_PTCR6_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR6_TCSEL. */
#define BS_AUDMUX_PTCR6_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_TCSEL field. */
#define BR_AUDMUX_PTCR6_TCSEL(x) (HW_AUDMUX_PTCR6(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TCSEL. */
#define BF_AUDMUX_PTCR6_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TCSEL) & BM_AUDMUX_PTCR6_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR6_TCSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TCSEL) | BF_AUDMUX_PTCR6_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR6_TCLKDIR. */
#define BM_AUDMUX_PTCR6_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR6_TCLKDIR. */
#define BS_AUDMUX_PTCR6_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_TCLKDIR field. */
#define BR_AUDMUX_PTCR6_TCLKDIR(x) (HW_AUDMUX_PTCR6(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TCLKDIR. */
#define BF_AUDMUX_PTCR6_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TCLKDIR) & BM_AUDMUX_PTCR6_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR6_TCLKDIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TCLKDIR) | BF_AUDMUX_PTCR6_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR6_TFSEL. */
#define BM_AUDMUX_PTCR6_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR6_TFSEL. */
#define BS_AUDMUX_PTCR6_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR6_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR6_TFSEL field. */
#define BR_AUDMUX_PTCR6_TFSEL(x) (HW_AUDMUX_PTCR6(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TFSEL. */
#define BF_AUDMUX_PTCR6_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TFSEL) & BM_AUDMUX_PTCR6_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR6_TFSEL(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TFSEL) | BF_AUDMUX_PTCR6_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR6, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR6_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR6_TFS_DIR. */
#define BM_AUDMUX_PTCR6_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR6_TFS_DIR. */
#define BS_AUDMUX_PTCR6_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR6_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR6_TFS_DIR field. */
#define BR_AUDMUX_PTCR6_TFS_DIR(x) (HW_AUDMUX_PTCR6(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR6_TFS_DIR. */
#define BF_AUDMUX_PTCR6_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR6_TFS_DIR) & BM_AUDMUX_PTCR6_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR6_TFS_DIR(x, v) (HW_AUDMUX_PTCR6_WR(x, (HW_AUDMUX_PTCR6_RD(x) & ~BM_AUDMUX_PTCR6_TFS_DIR) | BF_AUDMUX_PTCR6_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR6 - Port Data Control Register 6
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR6 - Port Data Control Register 6 (RW)
 *
 * Reset value: 0x00000000U
 *
 * PDCR6 is the Port Data Control Register for Port 6.
 */
typedef union _hw_audmux_pdcr6
{
    uint32_t U;
    struct _hw_audmux_pdcr6_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr6_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR6 register
 */
/*@{*/
#define HW_AUDMUX_PDCR6_ADDR(x)  ((uintptr_t)(x) + 0x2CU)

#define HW_AUDMUX_PDCR6(x)       (*(__IO hw_audmux_pdcr6_t *) HW_AUDMUX_PDCR6_ADDR(x))
#define HW_AUDMUX_PDCR6_RD(x)    (HW_AUDMUX_PDCR6(x).U)
#define HW_AUDMUX_PDCR6_WR(x, v) (HW_AUDMUX_PDCR6(x).U = (v))
#define HW_AUDMUX_PDCR6_SET(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) |  (v)))
#define HW_AUDMUX_PDCR6_CLR(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR6_TOG(x, v) (HW_AUDMUX_PDCR6_WR(x, HW_AUDMUX_PDCR6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR6 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR6, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR6_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR6_INMMASK. */
#define BM_AUDMUX_PDCR6_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR6_INMMASK. */
#define BS_AUDMUX_PDCR6_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR6_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR6_INMMASK field. */
#define BR_AUDMUX_PDCR6_INMMASK(x) (HW_AUDMUX_PDCR6(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR6_INMMASK. */
#define BF_AUDMUX_PDCR6_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_INMMASK) & BM_AUDMUX_PDCR6_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR6_INMMASK(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_INMMASK) | BF_AUDMUX_PDCR6_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR6_MODE (8U)          /*!< Bit position for AUDMUX_PDCR6_MODE. */
#define BM_AUDMUX_PDCR6_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR6_MODE. */
#define BS_AUDMUX_PDCR6_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR6_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR6_MODE field. */
#define BR_AUDMUX_PDCR6_MODE(x) (HW_AUDMUX_PDCR6(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR6_MODE. */
#define BF_AUDMUX_PDCR6_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_MODE) & BM_AUDMUX_PDCR6_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR6_MODE(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_MODE) | BF_AUDMUX_PDCR6_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR6_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR6_TXRXEN. */
#define BM_AUDMUX_PDCR6_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR6_TXRXEN. */
#define BS_AUDMUX_PDCR6_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR6_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR6_TXRXEN field. */
#define BR_AUDMUX_PDCR6_TXRXEN(x) (HW_AUDMUX_PDCR6(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR6_TXRXEN. */
#define BF_AUDMUX_PDCR6_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_TXRXEN) & BM_AUDMUX_PDCR6_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR6_TXRXEN(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_TXRXEN) | BF_AUDMUX_PDCR6_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR6, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR6_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR6_RXDSEL. */
#define BM_AUDMUX_PDCR6_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR6_RXDSEL. */
#define BS_AUDMUX_PDCR6_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR6_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR6_RXDSEL field. */
#define BR_AUDMUX_PDCR6_RXDSEL(x) (HW_AUDMUX_PDCR6(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR6_RXDSEL. */
#define BF_AUDMUX_PDCR6_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR6_RXDSEL) & BM_AUDMUX_PDCR6_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR6_RXDSEL(x, v) (HW_AUDMUX_PDCR6_WR(x, (HW_AUDMUX_PDCR6_RD(x) & ~BM_AUDMUX_PDCR6_RXDSEL) | BF_AUDMUX_PDCR6_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PTCR7 - Port Timing Control Register 7
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PTCR7 - Port Timing Control Register 7 (RW)
 *
 * Reset value: 0x00000800U
 *
 * Port Timing Control Register for Port 7
 */
typedef union _hw_audmux_ptcr7
{
    uint32_t U;
    struct _hw_audmux_ptcr7_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t SYN : 1;              /*!< [11]  */
        uint32_t RCSEL : 4;            /*!< [15:12]  */
        uint32_t RCLKDIR : 1;          /*!< [16]  */
        uint32_t RFSEL : 4;            /*!< [20:17]  */
        uint32_t RFS_DIR : 1;          /*!< [21]  */
        uint32_t TCSEL : 4;            /*!< [25:22]  */
        uint32_t TCLKDIR : 1;          /*!< [26]  */
        uint32_t TFSEL : 4;            /*!< [30:27]  */
        uint32_t TFS_DIR : 1;          /*!< [31]  */
    } B;
} hw_audmux_ptcr7_t;

/*!
 * @name Constants and macros for entire AUDMUX_PTCR7 register
 */
/*@{*/
#define HW_AUDMUX_PTCR7_ADDR(x)  ((uintptr_t)(x) + 0x30U)

#define HW_AUDMUX_PTCR7(x)       (*(__IO hw_audmux_ptcr7_t *) HW_AUDMUX_PTCR7_ADDR(x))
#define HW_AUDMUX_PTCR7_RD(x)    (HW_AUDMUX_PTCR7(x).U)
#define HW_AUDMUX_PTCR7_WR(x, v) (HW_AUDMUX_PTCR7(x).U = (v))
#define HW_AUDMUX_PTCR7_SET(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) |  (v)))
#define HW_AUDMUX_PTCR7_CLR(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) & ~(v)))
#define HW_AUDMUX_PTCR7_TOG(x, v) (HW_AUDMUX_PTCR7_WR(x, HW_AUDMUX_PTCR7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PTCR7 bitfields
 */

/*!
 * @name Register AUDMUX_PTCR7, field SYN[11] (RW)
 *
 * Synchronous/Asynchronous Select. When SYN is set, synchronous mode is chosen
 * and the transmit and receive sections use common clock and frame sync signals
 * (that is, the port is a 4-wire interface). When SYN is cleared, asynchronous
 * mode is chosen and separate clock and frame sync signals are used for the
 * transmit and receive sections (that is, the port is a 6-wire interface). RCLKDIR
 * and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - Asynchronous mode
 * - 1 - Synchronous mode (default)
 */
/*@{*/
#define BP_AUDMUX_PTCR7_SYN  (11U)         /*!< Bit position for AUDMUX_PTCR7_SYN. */
#define BM_AUDMUX_PTCR7_SYN  (0x00000800U) /*!< Bit mask for AUDMUX_PTCR7_SYN. */
#define BS_AUDMUX_PTCR7_SYN  (1U)          /*!< Bit field size in bits for AUDMUX_PTCR7_SYN. */

/*! @brief Read current value of the AUDMUX_PTCR7_SYN field. */
#define BR_AUDMUX_PTCR7_SYN(x) (HW_AUDMUX_PTCR7(x).B.SYN)

/*! @brief Format value for bitfield AUDMUX_PTCR7_SYN. */
#define BF_AUDMUX_PTCR7_SYN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_SYN) & BM_AUDMUX_PTCR7_SYN)

/*! @brief Set the SYN field to a new value. */
#define BW_AUDMUX_PTCR7_SYN(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_SYN) | BF_AUDMUX_PTCR7_SYN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RCSEL[15:12] (RW)
 *
 * Receive Clock Select. Selects the source port from which RXC is sourced. RXC
 * can be sourced from TXC and RXC from other ports.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RCSEL (12U)        /*!< Bit position for AUDMUX_PTCR7_RCSEL. */
#define BM_AUDMUX_PTCR7_RCSEL (0x0000F000U) /*!< Bit mask for AUDMUX_PTCR7_RCSEL. */
#define BS_AUDMUX_PTCR7_RCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_RCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_RCSEL field. */
#define BR_AUDMUX_PTCR7_RCSEL(x) (HW_AUDMUX_PTCR7(x).B.RCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RCSEL. */
#define BF_AUDMUX_PTCR7_RCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RCSEL) & BM_AUDMUX_PTCR7_RCSEL)

/*! @brief Set the RCSEL field to a new value. */
#define BW_AUDMUX_PTCR7_RCSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RCSEL) | BF_AUDMUX_PTCR7_RCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RCLKDIR[16] (RW)
 *
 * Receive Clock Direction Control. This bit sets the direction of the RXC pin
 * of the interface as an output or input. When set as an input, the RCSEL
 * settings are ignored. When set as an output, the RCSEL settings determine the source
 * port of the clock. RCLKDIR and SYN should not be changed at the same time.
 *
 * Values:
 * - 0 - RXC is an input.
 * - 1 - RXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RCLKDIR (16U)      /*!< Bit position for AUDMUX_PTCR7_RCLKDIR. */
#define BM_AUDMUX_PTCR7_RCLKDIR (0x00010000U) /*!< Bit mask for AUDMUX_PTCR7_RCLKDIR. */
#define BS_AUDMUX_PTCR7_RCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_RCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_RCLKDIR field. */
#define BR_AUDMUX_PTCR7_RCLKDIR(x) (HW_AUDMUX_PTCR7(x).B.RCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RCLKDIR. */
#define BF_AUDMUX_PTCR7_RCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RCLKDIR) & BM_AUDMUX_PTCR7_RCLKDIR)

/*! @brief Set the RCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR7_RCLKDIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RCLKDIR) | BF_AUDMUX_PTCR7_RCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RFSEL[20:17] (RW)
 *
 * Receive Frame Sync Select. Selects the source port from which RXFS is
 * sourced. RXFS can be sourced from TXFS and RXFS from other ports.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RFSEL (17U)        /*!< Bit position for AUDMUX_PTCR7_RFSEL. */
#define BM_AUDMUX_PTCR7_RFSEL (0x001E0000U) /*!< Bit mask for AUDMUX_PTCR7_RFSEL. */
#define BS_AUDMUX_PTCR7_RFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_RFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_RFSEL field. */
#define BR_AUDMUX_PTCR7_RFSEL(x) (HW_AUDMUX_PTCR7(x).B.RFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RFSEL. */
#define BF_AUDMUX_PTCR7_RFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RFSEL) & BM_AUDMUX_PTCR7_RFSEL)

/*! @brief Set the RFSEL field to a new value. */
#define BW_AUDMUX_PTCR7_RFSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RFSEL) | BF_AUDMUX_PTCR7_RFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field RFS_DIR[21] (RW)
 *
 * Receive Frame Sync Direction Control. This bit sets the direction of the RXFS
 * pin of the interface as an output or input. When set as an input, the RFSEL
 * settings are ignored. When set as an output, the RFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - RXFS is an input.
 * - 1 - RXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_RFS_DIR (21U)      /*!< Bit position for AUDMUX_PTCR7_RFS_DIR. */
#define BM_AUDMUX_PTCR7_RFS_DIR (0x00200000U) /*!< Bit mask for AUDMUX_PTCR7_RFS_DIR. */
#define BS_AUDMUX_PTCR7_RFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_RFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_RFS_DIR field. */
#define BR_AUDMUX_PTCR7_RFS_DIR(x) (HW_AUDMUX_PTCR7(x).B.RFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_RFS_DIR. */
#define BF_AUDMUX_PTCR7_RFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_RFS_DIR) & BM_AUDMUX_PTCR7_RFS_DIR)

/*! @brief Set the RFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR7_RFS_DIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_RFS_DIR) | BF_AUDMUX_PTCR7_RFS_DIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TCSEL[25:22] (RW)
 *
 * Transmit Clock Select. Selects the source port from which TXC is sourced.
 *
 * Values:
 * - 1xxx - Selects RXC from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TCSEL (22U)        /*!< Bit position for AUDMUX_PTCR7_TCSEL. */
#define BM_AUDMUX_PTCR7_TCSEL (0x03C00000U) /*!< Bit mask for AUDMUX_PTCR7_TCSEL. */
#define BS_AUDMUX_PTCR7_TCSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_TCSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_TCSEL field. */
#define BR_AUDMUX_PTCR7_TCSEL(x) (HW_AUDMUX_PTCR7(x).B.TCSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TCSEL. */
#define BF_AUDMUX_PTCR7_TCSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TCSEL) & BM_AUDMUX_PTCR7_TCSEL)

/*! @brief Set the TCSEL field to a new value. */
#define BW_AUDMUX_PTCR7_TCSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TCSEL) | BF_AUDMUX_PTCR7_TCSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TCLKDIR[26] (RW)
 *
 * Transmit Clock Direction Control. This bit sets the direction of the TXC pin
 * of the interface as an output or input. When set as an input, the TCSEL
 * settings are ignored. When set as an output, the TCSEL settings determine the source
 * port of the clock.
 *
 * Values:
 * - 0 - TXC is an input.
 * - 1 - TXC is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TCLKDIR (26U)      /*!< Bit position for AUDMUX_PTCR7_TCLKDIR. */
#define BM_AUDMUX_PTCR7_TCLKDIR (0x04000000U) /*!< Bit mask for AUDMUX_PTCR7_TCLKDIR. */
#define BS_AUDMUX_PTCR7_TCLKDIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_TCLKDIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_TCLKDIR field. */
#define BR_AUDMUX_PTCR7_TCLKDIR(x) (HW_AUDMUX_PTCR7(x).B.TCLKDIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TCLKDIR. */
#define BF_AUDMUX_PTCR7_TCLKDIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TCLKDIR) & BM_AUDMUX_PTCR7_TCLKDIR)

/*! @brief Set the TCLKDIR field to a new value. */
#define BW_AUDMUX_PTCR7_TCLKDIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TCLKDIR) | BF_AUDMUX_PTCR7_TCLKDIR(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TFSEL[30:27] (RW)
 *
 * Transmit Frame Sync Select. Selects the source port from which TXFS is
 * sourced.
 *
 * Values:
 * - 1xxx - Selects RXFS from port.
 * - x000 - Port 1
 * - x110 - Port 7
 * - x111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TFSEL (27U)        /*!< Bit position for AUDMUX_PTCR7_TFSEL. */
#define BM_AUDMUX_PTCR7_TFSEL (0x78000000U) /*!< Bit mask for AUDMUX_PTCR7_TFSEL. */
#define BS_AUDMUX_PTCR7_TFSEL (4U)         /*!< Bit field size in bits for AUDMUX_PTCR7_TFSEL. */

/*! @brief Read current value of the AUDMUX_PTCR7_TFSEL field. */
#define BR_AUDMUX_PTCR7_TFSEL(x) (HW_AUDMUX_PTCR7(x).B.TFSEL)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TFSEL. */
#define BF_AUDMUX_PTCR7_TFSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TFSEL) & BM_AUDMUX_PTCR7_TFSEL)

/*! @brief Set the TFSEL field to a new value. */
#define BW_AUDMUX_PTCR7_TFSEL(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TFSEL) | BF_AUDMUX_PTCR7_TFSEL(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PTCR7, field TFS_DIR[31] (RW)
 *
 * Transmit Frame Sync Direction Control. This bit sets the direction of the
 * TXFS pin of the interface as an output or input. When set as an input, the TFSEL
 * settings are ignored. When set as an output, the TFSEL settings determine the
 * source port of the frame sync.
 *
 * Values:
 * - 0 - TXFS is an input.
 * - 1 - TXFS is an output.
 */
/*@{*/
#define BP_AUDMUX_PTCR7_TFS_DIR (31U)      /*!< Bit position for AUDMUX_PTCR7_TFS_DIR. */
#define BM_AUDMUX_PTCR7_TFS_DIR (0x80000000U) /*!< Bit mask for AUDMUX_PTCR7_TFS_DIR. */
#define BS_AUDMUX_PTCR7_TFS_DIR (1U)       /*!< Bit field size in bits for AUDMUX_PTCR7_TFS_DIR. */

/*! @brief Read current value of the AUDMUX_PTCR7_TFS_DIR field. */
#define BR_AUDMUX_PTCR7_TFS_DIR(x) (HW_AUDMUX_PTCR7(x).B.TFS_DIR)

/*! @brief Format value for bitfield AUDMUX_PTCR7_TFS_DIR. */
#define BF_AUDMUX_PTCR7_TFS_DIR(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PTCR7_TFS_DIR) & BM_AUDMUX_PTCR7_TFS_DIR)

/*! @brief Set the TFS_DIR field to a new value. */
#define BW_AUDMUX_PTCR7_TFS_DIR(x, v) (HW_AUDMUX_PTCR7_WR(x, (HW_AUDMUX_PTCR7_RD(x) & ~BM_AUDMUX_PTCR7_TFS_DIR) | BF_AUDMUX_PTCR7_TFS_DIR(v)))
/*@}*/

/*******************************************************************************
 * HW_AUDMUX_PDCR7 - Port Data Control Register 7
 ******************************************************************************/

/*!
 * @brief HW_AUDMUX_PDCR7 - Port Data Control Register 7 (RW)
 *
 * Reset value: 0x0000C000U
 *
 * PDCR7 is the Port Data Control Register for Port 7.
 */
typedef union _hw_audmux_pdcr7
{
    uint32_t U;
    struct _hw_audmux_pdcr7_bitfields
    {
        uint32_t INMMASK : 8;          /*!< [7:0]  */
        uint32_t MODE : 1;             /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t TXRXEN : 1;           /*!< [12]  */
        uint32_t RXDSEL : 3;           /*!< [15:13]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_audmux_pdcr7_t;

/*!
 * @name Constants and macros for entire AUDMUX_PDCR7 register
 */
/*@{*/
#define HW_AUDMUX_PDCR7_ADDR(x)  ((uintptr_t)(x) + 0x34U)

#define HW_AUDMUX_PDCR7(x)       (*(__IO hw_audmux_pdcr7_t *) HW_AUDMUX_PDCR7_ADDR(x))
#define HW_AUDMUX_PDCR7_RD(x)    (HW_AUDMUX_PDCR7(x).U)
#define HW_AUDMUX_PDCR7_WR(x, v) (HW_AUDMUX_PDCR7(x).U = (v))
#define HW_AUDMUX_PDCR7_SET(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) |  (v)))
#define HW_AUDMUX_PDCR7_CLR(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) & ~(v)))
#define HW_AUDMUX_PDCR7_TOG(x, v) (HW_AUDMUX_PDCR7_WR(x, HW_AUDMUX_PDCR7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual AUDMUX_PDCR7 bitfields
 */

/*!
 * @name Register AUDMUX_PDCR7, field INMMASK[7:0] (RW)
 *
 * Internal Network Mode Mask. Bit mask that selects the ports from which the
 * RXD signals are to be ANDed together for internal network mode. Bit 6 represents
 * RXD from Port 7 and bit0 represents RXD from Port 1.
 *
 * Values:
 * - 0 - Includes RXDn for ANDing
 * - 1 - Excludes RXDn from ANDing
 */
/*@{*/
#define BP_AUDMUX_PDCR7_INMMASK (0U)       /*!< Bit position for AUDMUX_PDCR7_INMMASK. */
#define BM_AUDMUX_PDCR7_INMMASK (0x000000FFU) /*!< Bit mask for AUDMUX_PDCR7_INMMASK. */
#define BS_AUDMUX_PDCR7_INMMASK (8U)       /*!< Bit field size in bits for AUDMUX_PDCR7_INMMASK. */

/*! @brief Read current value of the AUDMUX_PDCR7_INMMASK field. */
#define BR_AUDMUX_PDCR7_INMMASK(x) (HW_AUDMUX_PDCR7(x).B.INMMASK)

/*! @brief Format value for bitfield AUDMUX_PDCR7_INMMASK. */
#define BF_AUDMUX_PDCR7_INMMASK(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_INMMASK) & BM_AUDMUX_PDCR7_INMMASK)

/*! @brief Set the INMMASK field to a new value. */
#define BW_AUDMUX_PDCR7_INMMASK(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_INMMASK) | BF_AUDMUX_PDCR7_INMMASK(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field MODE[8] (RW)
 *
 * Mode Select. This field selects the mode in which the port is to operate. The
 * modes of operation include the following: Normal mode, in which the RXD from
 * the port selected by RXDSEL is routed to the port. Internal Network mode in
 * which RXD from other ports are ANDed together. RXDSEL is ignored. INMMASK
 * determines which RXD signals are ANDed together.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Internal Network mode
 */
/*@{*/
#define BP_AUDMUX_PDCR7_MODE (8U)          /*!< Bit position for AUDMUX_PDCR7_MODE. */
#define BM_AUDMUX_PDCR7_MODE (0x00000100U) /*!< Bit mask for AUDMUX_PDCR7_MODE. */
#define BS_AUDMUX_PDCR7_MODE (1U)          /*!< Bit field size in bits for AUDMUX_PDCR7_MODE. */

/*! @brief Read current value of the AUDMUX_PDCR7_MODE field. */
#define BR_AUDMUX_PDCR7_MODE(x) (HW_AUDMUX_PDCR7(x).B.MODE)

/*! @brief Format value for bitfield AUDMUX_PDCR7_MODE. */
#define BF_AUDMUX_PDCR7_MODE(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_MODE) & BM_AUDMUX_PDCR7_MODE)

/*! @brief Set the MODE field to a new value. */
#define BW_AUDMUX_PDCR7_MODE(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_MODE) | BF_AUDMUX_PDCR7_MODE(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field TXRXEN[12] (RW)
 *
 * Transmit/Receive Switch Enable. Swaps the transmit and receive signals.
 *
 * Values:
 * - 0 - No switch (Transmit Pin = Transmit, Receive Pin = Receive)
 * - 1 - Switch (Transmit Pin = Receive, Receive Pin = Transmit)
 */
/*@{*/
#define BP_AUDMUX_PDCR7_TXRXEN (12U)       /*!< Bit position for AUDMUX_PDCR7_TXRXEN. */
#define BM_AUDMUX_PDCR7_TXRXEN (0x00001000U) /*!< Bit mask for AUDMUX_PDCR7_TXRXEN. */
#define BS_AUDMUX_PDCR7_TXRXEN (1U)        /*!< Bit field size in bits for AUDMUX_PDCR7_TXRXEN. */

/*! @brief Read current value of the AUDMUX_PDCR7_TXRXEN field. */
#define BR_AUDMUX_PDCR7_TXRXEN(x) (HW_AUDMUX_PDCR7(x).B.TXRXEN)

/*! @brief Format value for bitfield AUDMUX_PDCR7_TXRXEN. */
#define BF_AUDMUX_PDCR7_TXRXEN(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_TXRXEN) & BM_AUDMUX_PDCR7_TXRXEN)

/*! @brief Set the TXRXEN field to a new value. */
#define BW_AUDMUX_PDCR7_TXRXEN(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_TXRXEN) | BF_AUDMUX_PDCR7_TXRXEN(v)))
/*@}*/

/*!
 * @name Register AUDMUX_PDCR7, field RXDSEL[15:13] (RW)
 *
 * Receive Data Select. Selects the source port for the RXD data. RXDSEL is
 * ignored if MODE = 1 (that is, Internal Network Mode is enabled).
 *
 * Values:
 * - xxx - Port number for RXD
 * - 000 - Port 1
 * - 110 - Port 7
 * - 111 - Reserved
 */
/*@{*/
#define BP_AUDMUX_PDCR7_RXDSEL (13U)       /*!< Bit position for AUDMUX_PDCR7_RXDSEL. */
#define BM_AUDMUX_PDCR7_RXDSEL (0x0000E000U) /*!< Bit mask for AUDMUX_PDCR7_RXDSEL. */
#define BS_AUDMUX_PDCR7_RXDSEL (3U)        /*!< Bit field size in bits for AUDMUX_PDCR7_RXDSEL. */

/*! @brief Read current value of the AUDMUX_PDCR7_RXDSEL field. */
#define BR_AUDMUX_PDCR7_RXDSEL(x) (HW_AUDMUX_PDCR7(x).B.RXDSEL)

/*! @brief Format value for bitfield AUDMUX_PDCR7_RXDSEL. */
#define BF_AUDMUX_PDCR7_RXDSEL(v) ((uint32_t)((uint32_t)(v) << BP_AUDMUX_PDCR7_RXDSEL) & BM_AUDMUX_PDCR7_RXDSEL)

/*! @brief Set the RXDSEL field to a new value. */
#define BW_AUDMUX_PDCR7_RXDSEL(x, v) (HW_AUDMUX_PDCR7_WR(x, (HW_AUDMUX_PDCR7_RD(x) & ~BM_AUDMUX_PDCR7_RXDSEL) | BF_AUDMUX_PDCR7_RXDSEL(v)))
/*@}*/

/*******************************************************************************
 * hw_audmux_t - module struct
 ******************************************************************************/
/*!
 * @brief All AUDMUX module registers.
 */
#pragma pack(1)
typedef struct _hw_audmux
{
    __IO hw_audmux_ptcr1_t PTCR1;          /*!< [0x0] Port Timing Control Register 1 */
    __IO hw_audmux_pdcr1_t PDCR1;          /*!< [0x4] Port Data Control Register 1 */
    __IO hw_audmux_ptcr2_t PTCR2;          /*!< [0x8] Port Timing Control Register 2 */
    __IO hw_audmux_pdcr2_t PDCR2;          /*!< [0xC] Port Data Control Register 2 */
    __IO hw_audmux_ptcr3_t PTCR3;          /*!< [0x10] Port Timing Control Register 3 */
    __IO hw_audmux_pdcr3_t PDCR3;          /*!< [0x14] Port Data Control Register 3 */
    __IO hw_audmux_ptcr4_t PTCR4;          /*!< [0x18] Port Timing Control Register 4 */
    __IO hw_audmux_pdcr4_t PDCR4;          /*!< [0x1C] Port Data Control Register 4 */
    __IO hw_audmux_ptcr5_t PTCR5;          /*!< [0x20] Port Timing Control Register 5 */
    __IO hw_audmux_pdcr5_t PDCR5;          /*!< [0x24] Port Data Control Register 5 */
    __IO hw_audmux_ptcr6_t PTCR6;          /*!< [0x28] Port Timing Control Register 6 */
    __IO hw_audmux_pdcr6_t PDCR6;          /*!< [0x2C] Port Data Control Register 6 */
    __IO hw_audmux_ptcr7_t PTCR7;          /*!< [0x30] Port Timing Control Register 7 */
    __IO hw_audmux_pdcr7_t PDCR7;          /*!< [0x34] Port Data Control Register 7 */
} hw_audmux_t;
#pragma pack()

/*! @brief Macro to access all AUDMUX registers. */
/*! @param x AUDMUX module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_AUDMUX_REGS(AUDMUX_BASE)</code>. */
#define HW_AUDMUX_REGS(x) (*(hw_audmux_t *)(x))

/*
 * iMX6SL CCM
 *
 * CCM
 *
 * Registers defined in this header file:
 * - HW_CCM_CCR - CCM Control Register
 * - HW_CCM_CCDR - CCM Control Divider Register
 * - HW_CCM_CSR - CCM Status Register
 * - HW_CCM_CCSR - CCM Clock Swither Register
 * - HW_CCM_CACRR - CCM Arm Clock Root Register
 * - HW_CCM_CBCDR - CCM Bus Clock Divider Register
 * - HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register
 * - HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1
 * - HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2
 * - HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1
 * - HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register
 * - HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register
 * - HW_CCM_CDCDR - CCM D1 Clock Divider Register
 * - HW_CCM_CHSCCDR - CCM HSC Clock Divider Register
 * - HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2
 * - HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3
 * - HW_CCM_CWDR - CCM Wakeup Detector Register
 * - HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register
 * - HW_CCM_CLPCR - CCM Low Power Control Register
 * - HW_CCM_CISR - CCM Interrupt Status Register
 * - HW_CCM_CIMR - CCM Interrupt Mask Register
 * - HW_CCM_CCOSR - CCM Clock Output Source Register
 * - HW_CCM_CGPR - CCM General Purpose Register
 * - HW_CCM_CCGR0 - CCM Clock Gating Register 0
 * - HW_CCM_CCGR1 - CCM Clock Gating Register 1
 * - HW_CCM_CCGR2 - CCM Clock Gating Register 2
 * - HW_CCM_CCGR3 - CCM Clock Gating Register 3
 * - HW_CCM_CCGR4 - CCM Clock Gating Register 4
 * - HW_CCM_CCGR5 - CCM Clock Gating Register 5
 * - HW_CCM_CCGR6 - CCM Clock Gating Register 6
 * - HW_CCM_CMEOR - CCM Module Enable Overide Register
 *
 * - hw_ccm_t - Struct containing all module registers.
 */

#define HW_CCM_INSTANCE_COUNT (1U) /*!< Number of instances of the CCM module. */
#define HW_CCM (0U) /*!< Instance number for CCM. */
#define CCM_BASE              (0x20C4000U) /*!< Base address for CCM. */
/*! Array initializer of CCM base addresses. */
#define CCM_BASE_ADDRS        { CCM_BASE }

/*******************************************************************************
 * HW_CCM_CCR - CCM Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCR - CCM Control Register (RW)
 *
 * Reset value: 0x040116FFU
 *
 * The figure below represents the CCM Control Register (CCR), which contains
 * bits to control general operation of CCM. The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_ccr
{
    uint32_t U;
    struct _hw_ccm_ccr_bitfields
    {
        uint32_t OSCNT : 8;            /*!< [7:0]  */
        uint32_t RESERVED0 : 4;        /*!< [11:8]  */
        uint32_t COSC_EN : 1;          /*!< [12]  */
        uint32_t RESERVED1 : 3;        /*!< [15:13]  */
        uint32_t WB_COUNT : 3;         /*!< [18:16]  */
        uint32_t RESERVED2 : 2;        /*!< [20:19]  */
        uint32_t REG_BYPASS_COUNT : 6; /*!< [26:21]  */
        uint32_t RBC_EN : 1;           /*!< [27]  */
        uint32_t RESERVED3 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_ccr_t;

/*!
 * @name Constants and macros for entire CCM_CCR register
 */
/*@{*/
#define HW_CCM_CCR_ADDR(x)       ((uintptr_t)(x) + 0x0U)

#define HW_CCM_CCR(x)            (*(__IO hw_ccm_ccr_t *) HW_CCM_CCR_ADDR(x))
#define HW_CCM_CCR_RD(x)         (HW_CCM_CCR(x).U)
#define HW_CCM_CCR_WR(x, v)      (HW_CCM_CCR(x).U = (v))
#define HW_CCM_CCR_SET(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) |  (v)))
#define HW_CCM_CCR_CLR(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) & ~(v)))
#define HW_CCM_CCR_TOG(x, v)     (HW_CCM_CCR_WR(x, HW_CCM_CCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCR bitfields
 */

/*!
 * @name Register CCM_CCR, field OSCNT[7:0] (RW)
 *
 * Oscillator ready counter value. These bits define value of 32KHz counter,
 * that serve as counter for oscillator lock time. This is used for oscillator lock
 * time. Current estimation is ~5ms. This counter will be used in ignition
 * sequence and in wake from stop sequence if sbyos bit was defined, to notify that on
 * chip oscillator output is ready for the dpll_ip to use and only then the gate
 * in dpll_ip can be opened.
 *
 * Values:
 * - 00000000 - count 1 ckil
 * - 11111111 - count 256 ckil's (default)
 */
/*@{*/
#define BP_CCM_CCR_OSCNT     (0U)          /*!< Bit position for CCM_CCR_OSCNT. */
#define BM_CCM_CCR_OSCNT     (0x000000FFU) /*!< Bit mask for CCM_CCR_OSCNT. */
#define BS_CCM_CCR_OSCNT     (8U)          /*!< Bit field size in bits for CCM_CCR_OSCNT. */

/*! @brief Read current value of the CCM_CCR_OSCNT field. */
#define BR_CCM_CCR_OSCNT(x)  (HW_CCM_CCR(x).B.OSCNT)

/*! @brief Format value for bitfield CCM_CCR_OSCNT. */
#define BF_CCM_CCR_OSCNT(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_OSCNT) & BM_CCM_CCR_OSCNT)

/*! @brief Set the OSCNT field to a new value. */
#define BW_CCM_CCR_OSCNT(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_OSCNT) | BF_CCM_CCR_OSCNT(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field COSC_EN[12] (RW)
 *
 * On chip oscillator enable bit - this bit value is reflected on the output
 * cosc_en. The system will start with on chip oscillator enabled to supply source
 * for the PLLs. Software can change this bit if a transition to the bypass PLL
 * clocks was performed for all the PLLs. In cases that this bit is changed from
 * '0' to '1' then CCM will enable the on chip oscillator and after counting oscnt
 * ckil clock cycles it will notify that on chip oscillator is ready by a
 * interrupt cosc_ready and by status bit cosc_ready. The cosc_en bit should be changed
 * only when on chip oscillator is not chosen as the clock source.
 *
 * Values:
 * - 0 - disable on chip oscillator
 * - 1 - enable on chip oscillator
 */
/*@{*/
#define BP_CCM_CCR_COSC_EN   (12U)         /*!< Bit position for CCM_CCR_COSC_EN. */
#define BM_CCM_CCR_COSC_EN   (0x00001000U) /*!< Bit mask for CCM_CCR_COSC_EN. */
#define BS_CCM_CCR_COSC_EN   (1U)          /*!< Bit field size in bits for CCM_CCR_COSC_EN. */

/*! @brief Read current value of the CCM_CCR_COSC_EN field. */
#define BR_CCM_CCR_COSC_EN(x) (HW_CCM_CCR(x).B.COSC_EN)

/*! @brief Format value for bitfield CCM_CCR_COSC_EN. */
#define BF_CCM_CCR_COSC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_COSC_EN) & BM_CCM_CCR_COSC_EN)

/*! @brief Set the COSC_EN field to a new value. */
#define BW_CCM_CCR_COSC_EN(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_COSC_EN) | BF_CCM_CCR_COSC_EN(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field WB_COUNT[18:16] (RW)
 *
 * Well Bias counter. Delay, defined by this value, counted by CKIL clock will
 * be applied till well bias is enabled at exit from wait or stop low power mode.
 * Counter will be used if wb_core_at_lpm or wb_per_at_lpm bits are set. Should
 * be zeroed and reconfigured after exit from low power mode.
 *
 * Values:
 * - 000 - no delay
 * - 001 - 1 CKIL clock delay
 * - 111 - 7 CKIL clocks delay
 */
/*@{*/
#define BP_CCM_CCR_WB_COUNT  (16U)         /*!< Bit position for CCM_CCR_WB_COUNT. */
#define BM_CCM_CCR_WB_COUNT  (0x00070000U) /*!< Bit mask for CCM_CCR_WB_COUNT. */
#define BS_CCM_CCR_WB_COUNT  (3U)          /*!< Bit field size in bits for CCM_CCR_WB_COUNT. */

/*! @brief Read current value of the CCM_CCR_WB_COUNT field. */
#define BR_CCM_CCR_WB_COUNT(x) (HW_CCM_CCR(x).B.WB_COUNT)

/*! @brief Format value for bitfield CCM_CCR_WB_COUNT. */
#define BF_CCM_CCR_WB_COUNT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_WB_COUNT) & BM_CCM_CCR_WB_COUNT)

/*! @brief Set the WB_COUNT field to a new value. */
#define BW_CCM_CCR_WB_COUNT(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_WB_COUNT) | BF_CCM_CCR_WB_COUNT(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field REG_BYPASS_COUNT[26:21] (RW)
 *
 * Counter for analog_reg_bypass signal assertion after standby voltage request
 * by pmic_vstby_req. Should be zeroed and reconfigured after exit from low power
 * mode. REG_BYPASS_COUNT can also be used for holding off interrupts when the
 * PGC unit is sending signals to power gate the core.
 *
 * Values:
 * - 000000 - no delay
 * - 000001 - 1 CKIL clock period delay
 * - 111111 - 63 CKIL clock periods delay
 */
/*@{*/
#define BP_CCM_CCR_REG_BYPASS_COUNT (21U)  /*!< Bit position for CCM_CCR_REG_BYPASS_COUNT. */
#define BM_CCM_CCR_REG_BYPASS_COUNT (0x07E00000U) /*!< Bit mask for CCM_CCR_REG_BYPASS_COUNT. */
#define BS_CCM_CCR_REG_BYPASS_COUNT (6U)   /*!< Bit field size in bits for CCM_CCR_REG_BYPASS_COUNT. */

/*! @brief Read current value of the CCM_CCR_REG_BYPASS_COUNT field. */
#define BR_CCM_CCR_REG_BYPASS_COUNT(x) (HW_CCM_CCR(x).B.REG_BYPASS_COUNT)

/*! @brief Format value for bitfield CCM_CCR_REG_BYPASS_COUNT. */
#define BF_CCM_CCR_REG_BYPASS_COUNT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_REG_BYPASS_COUNT) & BM_CCM_CCR_REG_BYPASS_COUNT)

/*! @brief Set the REG_BYPASS_COUNT field to a new value. */
#define BW_CCM_CCR_REG_BYPASS_COUNT(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_REG_BYPASS_COUNT) | BF_CCM_CCR_REG_BYPASS_COUNT(v)))
/*@}*/

/*!
 * @name Register CCM_CCR, field RBC_EN[27] (RW)
 *
 * Enable for REG_BYPASS_COUNTER. If enabled, analog_reg_bypass signal will be
 * asserted after REG_BYPASS_COUNT clocks of CKIL, after standby voltage is
 * requested. If standby voltage is not requested analog_reg_bypass won't be asserted,
 * event if counter is enabled.
 *
 * Values:
 * - 1 - REG_BYPASS_COUNTER enabled.
 * - 0 - REG_BYPASS_COUNTER disabled
 */
/*@{*/
#define BP_CCM_CCR_RBC_EN    (27U)         /*!< Bit position for CCM_CCR_RBC_EN. */
#define BM_CCM_CCR_RBC_EN    (0x08000000U) /*!< Bit mask for CCM_CCR_RBC_EN. */
#define BS_CCM_CCR_RBC_EN    (1U)          /*!< Bit field size in bits for CCM_CCR_RBC_EN. */

/*! @brief Read current value of the CCM_CCR_RBC_EN field. */
#define BR_CCM_CCR_RBC_EN(x) (HW_CCM_CCR(x).B.RBC_EN)

/*! @brief Format value for bitfield CCM_CCR_RBC_EN. */
#define BF_CCM_CCR_RBC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCR_RBC_EN) & BM_CCM_CCR_RBC_EN)

/*! @brief Set the RBC_EN field to a new value. */
#define BW_CCM_CCR_RBC_EN(x, v) (HW_CCM_CCR_WR(x, (HW_CCM_CCR_RD(x) & ~BM_CCM_CCR_RBC_EN) | BF_CCM_CCR_RBC_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCDR - CCM Control Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCDR - CCM Control Divider Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Control Divider Register (CCDR), which
 * contains bits that control the loading of the dividers that need handshake with
 * the modules they affect. The table below provides its field descriptions.
 */
typedef union _hw_ccm_ccdr
{
    uint32_t U;
    struct _hw_ccm_ccdr_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t mmdc_root_mask : 1;   /*!< [16]  */
        uint32_t mmdc_ch0_mask : 1;    /*!< [17]  */
        uint32_t RESERVED1 : 14;       /*!< [31:18]  */
    } B;
} hw_ccm_ccdr_t;

/*!
 * @name Constants and macros for entire CCM_CCDR register
 */
/*@{*/
#define HW_CCM_CCDR_ADDR(x)      ((uintptr_t)(x) + 0x4U)

#define HW_CCM_CCDR(x)           (*(__IO hw_ccm_ccdr_t *) HW_CCM_CCDR_ADDR(x))
#define HW_CCM_CCDR_RD(x)        (HW_CCM_CCDR(x).U)
#define HW_CCM_CCDR_WR(x, v)     (HW_CCM_CCDR(x).U = (v))
#define HW_CCM_CCDR_SET(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) |  (v)))
#define HW_CCM_CCDR_CLR(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) & ~(v)))
#define HW_CCM_CCDR_TOG(x, v)    (HW_CCM_CCDR_WR(x, HW_CCM_CCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCDR bitfields
 */

/*!
 * @name Register CCM_CCDR, field mmdc_root_mask[16] (RW)
 *
 * During divider ratio mmdc_root_axi_podf change or sync mux periph2_clk_sel
 * change (but not jtag) or SRC request during warm reset, mask handshake with
 * mmdc_root module.
 *
 * Values:
 * - 0 - allow handshake with mmdc_root module
 * - 1 - mask handshake with mmdc_root. Request signal will not be generated.
 */
/*@{*/
#define BP_CCM_CCDR_mmdc_root_mask (16U)   /*!< Bit position for CCM_CCDR_mmdc_root_mask. */
#define BM_CCM_CCDR_mmdc_root_mask (0x00010000U) /*!< Bit mask for CCM_CCDR_mmdc_root_mask. */
#define BS_CCM_CCDR_mmdc_root_mask (1U)    /*!< Bit field size in bits for CCM_CCDR_mmdc_root_mask. */

/*! @brief Read current value of the CCM_CCDR_mmdc_root_mask field. */
#define BR_CCM_CCDR_mmdc_root_mask(x) (HW_CCM_CCDR(x).B.mmdc_root_mask)

/*! @brief Format value for bitfield CCM_CCDR_mmdc_root_mask. */
#define BF_CCM_CCDR_mmdc_root_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCDR_mmdc_root_mask) & BM_CCM_CCDR_mmdc_root_mask)

/*! @brief Set the mmdc_root_mask field to a new value. */
#define BW_CCM_CCDR_mmdc_root_mask(x, v) (HW_CCM_CCDR_WR(x, (HW_CCM_CCDR_RD(x) & ~BM_CCM_CCDR_mmdc_root_mask) | BF_CCM_CCDR_mmdc_root_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCDR, field mmdc_ch0_mask[17] (RW)
 *
 * During divider ratio mmdc_ch0_axi_podf change or sync mux periph_clk_sel
 * change (but not jtag) or SRC request during warm reset, mask handshake with
 * mmdc_ch0 module.
 *
 * Values:
 * - 0 - allow handshake with mmdc_ch0 module
 * - 1 - mask handshake with mmdc_ch0. Request signal will not be generated.
 */
/*@{*/
#define BP_CCM_CCDR_mmdc_ch0_mask (17U)    /*!< Bit position for CCM_CCDR_mmdc_ch0_mask. */
#define BM_CCM_CCDR_mmdc_ch0_mask (0x00020000U) /*!< Bit mask for CCM_CCDR_mmdc_ch0_mask. */
#define BS_CCM_CCDR_mmdc_ch0_mask (1U)     /*!< Bit field size in bits for CCM_CCDR_mmdc_ch0_mask. */

/*! @brief Read current value of the CCM_CCDR_mmdc_ch0_mask field. */
#define BR_CCM_CCDR_mmdc_ch0_mask(x) (HW_CCM_CCDR(x).B.mmdc_ch0_mask)

/*! @brief Format value for bitfield CCM_CCDR_mmdc_ch0_mask. */
#define BF_CCM_CCDR_mmdc_ch0_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCDR_mmdc_ch0_mask) & BM_CCM_CCDR_mmdc_ch0_mask)

/*! @brief Set the mmdc_ch0_mask field to a new value. */
#define BW_CCM_CCDR_mmdc_ch0_mask(x, v) (HW_CCM_CCDR_WR(x, (HW_CCM_CCDR_RD(x) & ~BM_CCM_CCDR_mmdc_ch0_mask) | BF_CCM_CCDR_mmdc_ch0_mask(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSR - CCM Status Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSR - CCM Status Register (RO)
 *
 * Reset value: 0x00000010U
 *
 * The figure below represents the CCM status Register (CSR). The status bits
 * are read-only bits. The table below provides its field descriptions.
 */
typedef union _hw_ccm_csr
{
    uint32_t U;
    struct _hw_ccm_csr_bitfields
    {
        uint32_t REF_EN_B : 1;         /*!< [0]  */
        uint32_t RESERVED0 : 4;        /*!< [4:1]  */
        uint32_t cosc_ready : 1;       /*!< [5]  */
        uint32_t RESERVED1 : 26;       /*!< [31:6]  */
    } B;
} hw_ccm_csr_t;

/*!
 * @name Constants and macros for entire CCM_CSR register
 */
/*@{*/
#define HW_CCM_CSR_ADDR(x)       ((uintptr_t)(x) + 0x8U)

#define HW_CCM_CSR(x)            (*(__I hw_ccm_csr_t *) HW_CCM_CSR_ADDR(x))
#define HW_CCM_CSR_RD(x)         (HW_CCM_CSR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CSR bitfields
 */

/*!
 * @name Register CCM_CSR, field REF_EN_B[0] (RO)
 *
 * Status of the value of CCM_REF_EN_B output of ccm
 *
 * Values:
 * - 0 - value of CCM_REF_EN_B is '0'
 * - 1 - value of CCM_REF_EN_B is '1'
 */
/*@{*/
#define BP_CCM_CSR_REF_EN_B  (0U)          /*!< Bit position for CCM_CSR_REF_EN_B. */
#define BM_CCM_CSR_REF_EN_B  (0x00000001U) /*!< Bit mask for CCM_CSR_REF_EN_B. */
#define BS_CCM_CSR_REF_EN_B  (1U)          /*!< Bit field size in bits for CCM_CSR_REF_EN_B. */

/*! @brief Read current value of the CCM_CSR_REF_EN_B field. */
#define BR_CCM_CSR_REF_EN_B(x) (HW_CCM_CSR(x).B.REF_EN_B)
/*@}*/

/*!
 * @name Register CCM_CSR, field cosc_ready[5] (RO)
 *
 * Status indication of on board oscillator. This bit will be asserted if on
 * chip oscillator is enabled and on chip oscillator is not powered down, and if
 * oscnt counter has finished counting.
 *
 * Values:
 * - 0 - on board oscillator is not ready.
 * - 1 - on board oscillator is ready.
 */
/*@{*/
#define BP_CCM_CSR_cosc_ready (5U)         /*!< Bit position for CCM_CSR_cosc_ready. */
#define BM_CCM_CSR_cosc_ready (0x00000020U) /*!< Bit mask for CCM_CSR_cosc_ready. */
#define BS_CCM_CSR_cosc_ready (1U)         /*!< Bit field size in bits for CCM_CSR_cosc_ready. */

/*! @brief Read current value of the CCM_CSR_cosc_ready field. */
#define BR_CCM_CSR_cosc_ready(x) (HW_CCM_CSR(x).B.cosc_ready)
/*@}*/

/*******************************************************************************
 * HW_CCM_CCSR - CCM Clock Swither Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCSR - CCM Clock Swither Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * The figure below represents the CCM Clock Switcher register (CCSR). The CCSR
 * register contains bits to control the switcher sub-module dividers and
 * multiplexers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_ccsr
{
    uint32_t U;
    struct _hw_ccm_ccsr_bitfields
    {
        uint32_t pll3_sw_clk_sel : 1;  /*!< [0]  */
        uint32_t pll2_sw_clk_sel : 1;  /*!< [1]  */
        uint32_t pll1_sw_clk_sel : 1;  /*!< [2]  */
        uint32_t RESERVED0 : 5;        /*!< [7:3]  */
        uint32_t step_sel : 1;         /*!< [8]  */
        uint32_t pfd_396m_dis_mask : 1; /*!< [9]  */
        uint32_t pfd_352m_dis_mask : 1; /*!< [10]  */
        uint32_t pfd_594m_dis_mask : 1; /*!< [11]  */
        uint32_t pfd_508m_dis_mask : 1; /*!< [12]  */
        uint32_t pfd_454m_dis_mask : 1; /*!< [13]  */
        uint32_t pfd_720m_dis_mask : 1; /*!< [14]  */
        uint32_t pfd_540m_dis_mask : 1; /*!< [15]  */
        uint32_t RESERVED1 : 16;       /*!< [31:16]  */
    } B;
} hw_ccm_ccsr_t;

/*!
 * @name Constants and macros for entire CCM_CCSR register
 */
/*@{*/
#define HW_CCM_CCSR_ADDR(x)      ((uintptr_t)(x) + 0xCU)

#define HW_CCM_CCSR(x)           (*(__IO hw_ccm_ccsr_t *) HW_CCM_CCSR_ADDR(x))
#define HW_CCM_CCSR_RD(x)        (HW_CCM_CCSR(x).U)
#define HW_CCM_CCSR_WR(x, v)     (HW_CCM_CCSR(x).U = (v))
#define HW_CCM_CCSR_SET(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) |  (v)))
#define HW_CCM_CCSR_CLR(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) & ~(v)))
#define HW_CCM_CCSR_TOG(x, v)    (HW_CCM_CCSR_WR(x, HW_CCM_CCSR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCSR bitfields
 */

/*!
 * @name Register CCM_CCSR, field pll3_sw_clk_sel[0] (RW)
 *
 * Selects source to generate pll3_sw_clk. This bit should only be used for
 * testing purposes.
 *
 * Values:
 * - 0 - pll3_main_clk(default)
 * - 1 - pll3 bypass clock
 */
/*@{*/
#define BP_CCM_CCSR_pll3_sw_clk_sel (0U)   /*!< Bit position for CCM_CCSR_pll3_sw_clk_sel. */
#define BM_CCM_CCSR_pll3_sw_clk_sel (0x00000001U) /*!< Bit mask for CCM_CCSR_pll3_sw_clk_sel. */
#define BS_CCM_CCSR_pll3_sw_clk_sel (1U)   /*!< Bit field size in bits for CCM_CCSR_pll3_sw_clk_sel. */

/*! @brief Read current value of the CCM_CCSR_pll3_sw_clk_sel field. */
#define BR_CCM_CCSR_pll3_sw_clk_sel(x) (HW_CCM_CCSR(x).B.pll3_sw_clk_sel)

/*! @brief Format value for bitfield CCM_CCSR_pll3_sw_clk_sel. */
#define BF_CCM_CCSR_pll3_sw_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pll3_sw_clk_sel) & BM_CCM_CCSR_pll3_sw_clk_sel)

/*! @brief Set the pll3_sw_clk_sel field to a new value. */
#define BW_CCM_CCSR_pll3_sw_clk_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pll3_sw_clk_sel) | BF_CCM_CCSR_pll3_sw_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pll2_sw_clk_sel[1] (RW)
 *
 * Selects source to generate pll2_sw_clk. This bit should only be used for
 * testing purposes.
 *
 * Values:
 * - 0 - pll2_main_clk(default)
 * - 1 - pll2 bypass clock
 */
/*@{*/
#define BP_CCM_CCSR_pll2_sw_clk_sel (1U)   /*!< Bit position for CCM_CCSR_pll2_sw_clk_sel. */
#define BM_CCM_CCSR_pll2_sw_clk_sel (0x00000002U) /*!< Bit mask for CCM_CCSR_pll2_sw_clk_sel. */
#define BS_CCM_CCSR_pll2_sw_clk_sel (1U)   /*!< Bit field size in bits for CCM_CCSR_pll2_sw_clk_sel. */

/*! @brief Read current value of the CCM_CCSR_pll2_sw_clk_sel field. */
#define BR_CCM_CCSR_pll2_sw_clk_sel(x) (HW_CCM_CCSR(x).B.pll2_sw_clk_sel)

/*! @brief Format value for bitfield CCM_CCSR_pll2_sw_clk_sel. */
#define BF_CCM_CCSR_pll2_sw_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pll2_sw_clk_sel) & BM_CCM_CCSR_pll2_sw_clk_sel)

/*! @brief Set the pll2_sw_clk_sel field to a new value. */
#define BW_CCM_CCSR_pll2_sw_clk_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pll2_sw_clk_sel) | BF_CCM_CCSR_pll2_sw_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pll1_sw_clk_sel[2] (RW)
 *
 * Selects source to generate pll1_sw_clk.
 *
 * Values:
 * - 0 - pll1_main_clk(default)
 * - 1 - step_clk
 */
/*@{*/
#define BP_CCM_CCSR_pll1_sw_clk_sel (2U)   /*!< Bit position for CCM_CCSR_pll1_sw_clk_sel. */
#define BM_CCM_CCSR_pll1_sw_clk_sel (0x00000004U) /*!< Bit mask for CCM_CCSR_pll1_sw_clk_sel. */
#define BS_CCM_CCSR_pll1_sw_clk_sel (1U)   /*!< Bit field size in bits for CCM_CCSR_pll1_sw_clk_sel. */

/*! @brief Read current value of the CCM_CCSR_pll1_sw_clk_sel field. */
#define BR_CCM_CCSR_pll1_sw_clk_sel(x) (HW_CCM_CCSR(x).B.pll1_sw_clk_sel)

/*! @brief Format value for bitfield CCM_CCSR_pll1_sw_clk_sel. */
#define BF_CCM_CCSR_pll1_sw_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pll1_sw_clk_sel) & BM_CCM_CCSR_pll1_sw_clk_sel)

/*! @brief Set the pll1_sw_clk_sel field to a new value. */
#define BW_CCM_CCSR_pll1_sw_clk_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pll1_sw_clk_sel) | BF_CCM_CCSR_pll1_sw_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field step_sel[8] (RW)
 *
 * Selects the option to be chosen for the step frequency when shifting ARM
 * frequency. This will control the step_clk. This mux is allowed to be changed only
 * if its output is not used, i.e. ARM uses the output of pll1, and step_clk is
 * not used.
 *
 * Values:
 * - 0 - osc_clk (24M) - source for lp_apm. (default)
 * - 1 - pll2 PFD clock
 */
/*@{*/
#define BP_CCM_CCSR_step_sel (8U)          /*!< Bit position for CCM_CCSR_step_sel. */
#define BM_CCM_CCSR_step_sel (0x00000100U) /*!< Bit mask for CCM_CCSR_step_sel. */
#define BS_CCM_CCSR_step_sel (1U)          /*!< Bit field size in bits for CCM_CCSR_step_sel. */

/*! @brief Read current value of the CCM_CCSR_step_sel field. */
#define BR_CCM_CCSR_step_sel(x) (HW_CCM_CCSR(x).B.step_sel)

/*! @brief Format value for bitfield CCM_CCSR_step_sel. */
#define BF_CCM_CCSR_step_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_step_sel) & BM_CCM_CCSR_step_sel)

/*! @brief Set the step_sel field to a new value. */
#define BW_CCM_CCSR_step_sel(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_step_sel) | BF_CCM_CCSR_step_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_396m_dis_mask[9] (RW)
 *
 * Mask of 396M PFD auto-disable.
 *
 * Values:
 * - 0 - 396M PFD disable=0 (PFD always on)
 * - 1 - 396M PFD disable is managed by associated dividers disable. If all
 *     396M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_396m_dis_mask (9U) /*!< Bit position for CCM_CCSR_pfd_396m_dis_mask. */
#define BM_CCM_CCSR_pfd_396m_dis_mask (0x00000200U) /*!< Bit mask for CCM_CCSR_pfd_396m_dis_mask. */
#define BS_CCM_CCSR_pfd_396m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_396m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_396m_dis_mask field. */
#define BR_CCM_CCSR_pfd_396m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_396m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_396m_dis_mask. */
#define BF_CCM_CCSR_pfd_396m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_396m_dis_mask) & BM_CCM_CCSR_pfd_396m_dis_mask)

/*! @brief Set the pfd_396m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_396m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_396m_dis_mask) | BF_CCM_CCSR_pfd_396m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_352m_dis_mask[10] (RW)
 *
 * Mask of 352M PFD auto-disable.
 *
 * Values:
 * - 0 - 352M PFD disable=0 (PFD always on)
 * - 1 - 352M PFD disable is managed by associated dividers disable. If all
 *     352M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_352m_dis_mask (10U) /*!< Bit position for CCM_CCSR_pfd_352m_dis_mask. */
#define BM_CCM_CCSR_pfd_352m_dis_mask (0x00000400U) /*!< Bit mask for CCM_CCSR_pfd_352m_dis_mask. */
#define BS_CCM_CCSR_pfd_352m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_352m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_352m_dis_mask field. */
#define BR_CCM_CCSR_pfd_352m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_352m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_352m_dis_mask. */
#define BF_CCM_CCSR_pfd_352m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_352m_dis_mask) & BM_CCM_CCSR_pfd_352m_dis_mask)

/*! @brief Set the pfd_352m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_352m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_352m_dis_mask) | BF_CCM_CCSR_pfd_352m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_594m_dis_mask[11] (RW)
 *
 * Mask of 594M PFD auto-disable.
 *
 * Values:
 * - 0 - 594M PFD disable=0 (PFD always on)
 * - 1 - 594M PFD disable is managed by associated dividers disable. If all
 *     594M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_594m_dis_mask (11U) /*!< Bit position for CCM_CCSR_pfd_594m_dis_mask. */
#define BM_CCM_CCSR_pfd_594m_dis_mask (0x00000800U) /*!< Bit mask for CCM_CCSR_pfd_594m_dis_mask. */
#define BS_CCM_CCSR_pfd_594m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_594m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_594m_dis_mask field. */
#define BR_CCM_CCSR_pfd_594m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_594m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_594m_dis_mask. */
#define BF_CCM_CCSR_pfd_594m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_594m_dis_mask) & BM_CCM_CCSR_pfd_594m_dis_mask)

/*! @brief Set the pfd_594m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_594m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_594m_dis_mask) | BF_CCM_CCSR_pfd_594m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_508m_dis_mask[12] (RW)
 *
 * Mask of 508M PFD auto-disable.
 *
 * Values:
 * - 0 - 508M PFD disable=0 (PFD always on)
 * - 1 - 508M PFD disable is managed by associated dividers disable. If all
 *     508M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_508m_dis_mask (12U) /*!< Bit position for CCM_CCSR_pfd_508m_dis_mask. */
#define BM_CCM_CCSR_pfd_508m_dis_mask (0x00001000U) /*!< Bit mask for CCM_CCSR_pfd_508m_dis_mask. */
#define BS_CCM_CCSR_pfd_508m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_508m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_508m_dis_mask field. */
#define BR_CCM_CCSR_pfd_508m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_508m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_508m_dis_mask. */
#define BF_CCM_CCSR_pfd_508m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_508m_dis_mask) & BM_CCM_CCSR_pfd_508m_dis_mask)

/*! @brief Set the pfd_508m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_508m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_508m_dis_mask) | BF_CCM_CCSR_pfd_508m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_454m_dis_mask[13] (RW)
 *
 * Mask of 454M PFD auto-disable.
 *
 * Values:
 * - 0 - 454M PFD disable=0 (PFD always on)
 * - 1 - 454M PFD disable is managed by associated dividers disable. If all
 *     454M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_454m_dis_mask (13U) /*!< Bit position for CCM_CCSR_pfd_454m_dis_mask. */
#define BM_CCM_CCSR_pfd_454m_dis_mask (0x00002000U) /*!< Bit mask for CCM_CCSR_pfd_454m_dis_mask. */
#define BS_CCM_CCSR_pfd_454m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_454m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_454m_dis_mask field. */
#define BR_CCM_CCSR_pfd_454m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_454m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_454m_dis_mask. */
#define BF_CCM_CCSR_pfd_454m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_454m_dis_mask) & BM_CCM_CCSR_pfd_454m_dis_mask)

/*! @brief Set the pfd_454m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_454m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_454m_dis_mask) | BF_CCM_CCSR_pfd_454m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_720m_dis_mask[14] (RW)
 *
 * Mask of 720M PFD auto-disable.
 *
 * Values:
 * - 0 - 720M PFD disable=0 (PFD always on)
 * - 1 - 720M PFD disable is managed by associated dividers disable. If all
 *     720M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_720m_dis_mask (14U) /*!< Bit position for CCM_CCSR_pfd_720m_dis_mask. */
#define BM_CCM_CCSR_pfd_720m_dis_mask (0x00004000U) /*!< Bit mask for CCM_CCSR_pfd_720m_dis_mask. */
#define BS_CCM_CCSR_pfd_720m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_720m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_720m_dis_mask field. */
#define BR_CCM_CCSR_pfd_720m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_720m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_720m_dis_mask. */
#define BF_CCM_CCSR_pfd_720m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_720m_dis_mask) & BM_CCM_CCSR_pfd_720m_dis_mask)

/*! @brief Set the pfd_720m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_720m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_720m_dis_mask) | BF_CCM_CCSR_pfd_720m_dis_mask(v)))
/*@}*/

/*!
 * @name Register CCM_CCSR, field pfd_540m_dis_mask[15] (RW)
 *
 * Mask of 540M PFD auto-disable.
 *
 * Values:
 * - 0 - - 540M PFD disable=0 (PFD always on)
 * - 1 - 540M PFD disable is managed by associated dividers disable. If all
 *     540M-driven dividers are closed, PFD is disabled.
 */
/*@{*/
#define BP_CCM_CCSR_pfd_540m_dis_mask (15U) /*!< Bit position for CCM_CCSR_pfd_540m_dis_mask. */
#define BM_CCM_CCSR_pfd_540m_dis_mask (0x00008000U) /*!< Bit mask for CCM_CCSR_pfd_540m_dis_mask. */
#define BS_CCM_CCSR_pfd_540m_dis_mask (1U) /*!< Bit field size in bits for CCM_CCSR_pfd_540m_dis_mask. */

/*! @brief Read current value of the CCM_CCSR_pfd_540m_dis_mask field. */
#define BR_CCM_CCSR_pfd_540m_dis_mask(x) (HW_CCM_CCSR(x).B.pfd_540m_dis_mask)

/*! @brief Format value for bitfield CCM_CCSR_pfd_540m_dis_mask. */
#define BF_CCM_CCSR_pfd_540m_dis_mask(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCSR_pfd_540m_dis_mask) & BM_CCM_CCSR_pfd_540m_dis_mask)

/*! @brief Set the pfd_540m_dis_mask field to a new value. */
#define BW_CCM_CCSR_pfd_540m_dis_mask(x, v) (HW_CCM_CCSR_WR(x, (HW_CCM_CCSR_RD(x) & ~BM_CCM_CCSR_pfd_540m_dis_mask) | BF_CCM_CCSR_pfd_540m_dis_mask(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CACRR - CCM Arm Clock Root Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CACRR - CCM Arm Clock Root Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Arm Clock Root register (CACRR). The
 * CACRR register contains bits to control the ARM clock root generation. The table
 * below provides its field descriptions.
 */
typedef union _hw_ccm_cacrr
{
    uint32_t U;
    struct _hw_ccm_cacrr_bitfields
    {
        uint32_t arm_podf : 3;         /*!< [2:0]  */
        uint32_t RESERVED0 : 29;       /*!< [31:3]  */
    } B;
} hw_ccm_cacrr_t;

/*!
 * @name Constants and macros for entire CCM_CACRR register
 */
/*@{*/
#define HW_CCM_CACRR_ADDR(x)     ((uintptr_t)(x) + 0x10U)

#define HW_CCM_CACRR(x)          (*(__IO hw_ccm_cacrr_t *) HW_CCM_CACRR_ADDR(x))
#define HW_CCM_CACRR_RD(x)       (HW_CCM_CACRR(x).U)
#define HW_CCM_CACRR_WR(x, v)    (HW_CCM_CACRR(x).U = (v))
#define HW_CCM_CACRR_SET(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) |  (v)))
#define HW_CCM_CACRR_CLR(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) & ~(v)))
#define HW_CCM_CACRR_TOG(x, v)   (HW_CCM_CACRR_WR(x, HW_CCM_CACRR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CACRR bitfields
 */

/*!
 * @name Register CCM_CACRR, field arm_podf[2:0] (RW)
 *
 * Divider for ARM clock root. If arm_freq_shift_divider is set to '1' then any
 * new write to arm_podf will be held until arm_clk_switch_req signal is asserted.
 *
 * Values:
 * - 000 - divide by 1(default)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CACRR_arm_podf (0U)         /*!< Bit position for CCM_CACRR_arm_podf. */
#define BM_CCM_CACRR_arm_podf (0x00000007U) /*!< Bit mask for CCM_CACRR_arm_podf. */
#define BS_CCM_CACRR_arm_podf (3U)         /*!< Bit field size in bits for CCM_CACRR_arm_podf. */

/*! @brief Read current value of the CCM_CACRR_arm_podf field. */
#define BR_CCM_CACRR_arm_podf(x) (HW_CCM_CACRR(x).B.arm_podf)

/*! @brief Format value for bitfield CCM_CACRR_arm_podf. */
#define BF_CCM_CACRR_arm_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CACRR_arm_podf) & BM_CCM_CACRR_arm_podf)

/*! @brief Set the arm_podf field to a new value. */
#define BW_CCM_CACRR_arm_podf(x, v) (HW_CCM_CACRR_WR(x, (HW_CCM_CACRR_RD(x) & ~BM_CCM_CACRR_arm_podf) | BF_CCM_CACRR_arm_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CBCDR - CCM Bus Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CBCDR - CCM Bus Clock Divider Register (RW)
 *
 * Reset value: 0x00018D00U
 *
 * The figure below represents the CCM Bus Clock Divider Register (CBCDR). The
 * CBCDR register contains bits to control the clock generation sub module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cbcdr
{
    uint32_t U;
    struct _hw_ccm_cbcdr_bitfields
    {
        uint32_t periph2_clk2_podf : 3; /*!< [2:0]  */
        uint32_t fabric_mmdc_podf : 3; /*!< [5:3]  */
        uint32_t ocram_clk_sel : 1;    /*!< [6]  */
        uint32_t ocram_alt_clk_sel : 1; /*!< [7]  */
        uint32_t ipg_podf : 2;         /*!< [9:8]  */
        uint32_t ahb_podf : 3;         /*!< [12:10]  */
        uint32_t RESERVED0 : 3;        /*!< [15:13]  */
        uint32_t ocram_podf : 3;       /*!< [18:16]  */
        uint32_t RESERVED1 : 6;        /*!< [24:19]  */
        uint32_t periph_clk_sel : 1;   /*!< [25]  */
        uint32_t periph2_clk_sel : 1;  /*!< [26]  */
        uint32_t periph_clk2_podf : 3; /*!< [29:27]  */
        uint32_t RESERVED2 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_cbcdr_t;

/*!
 * @name Constants and macros for entire CCM_CBCDR register
 */
/*@{*/
#define HW_CCM_CBCDR_ADDR(x)     ((uintptr_t)(x) + 0x14U)

#define HW_CCM_CBCDR(x)          (*(__IO hw_ccm_cbcdr_t *) HW_CCM_CBCDR_ADDR(x))
#define HW_CCM_CBCDR_RD(x)       (HW_CCM_CBCDR(x).U)
#define HW_CCM_CBCDR_WR(x, v)    (HW_CCM_CBCDR(x).U = (v))
#define HW_CCM_CBCDR_SET(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) |  (v)))
#define HW_CCM_CBCDR_CLR(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) & ~(v)))
#define HW_CCM_CBCDR_TOG(x, v)   (HW_CCM_CBCDR_WR(x, HW_CCM_CBCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CBCDR bitfields
 */

/*!
 * @name Register CCM_CBCDR, field periph2_clk2_podf[2:0] (RW)
 *
 * Divider for periph2_clk2 podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_periph2_clk2_podf (0U) /*!< Bit position for CCM_CBCDR_periph2_clk2_podf. */
#define BM_CCM_CBCDR_periph2_clk2_podf (0x00000007U) /*!< Bit mask for CCM_CBCDR_periph2_clk2_podf. */
#define BS_CCM_CBCDR_periph2_clk2_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_periph2_clk2_podf. */

/*! @brief Read current value of the CCM_CBCDR_periph2_clk2_podf field. */
#define BR_CCM_CBCDR_periph2_clk2_podf(x) (HW_CCM_CBCDR(x).B.periph2_clk2_podf)

/*! @brief Format value for bitfield CCM_CBCDR_periph2_clk2_podf. */
#define BF_CCM_CBCDR_periph2_clk2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph2_clk2_podf) & BM_CCM_CBCDR_periph2_clk2_podf)

/*! @brief Set the periph2_clk2_podf field to a new value. */
#define BW_CCM_CBCDR_periph2_clk2_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph2_clk2_podf) | BF_CCM_CBCDR_periph2_clk2_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field fabric_mmdc_podf[5:3] (RW)
 *
 * Post divider for fabric_mmdc clock. This design implementation does not use
 * MMDC_ROOT_AXI_CLK_ROOT as a clock source to the MMDC. Only
 * MMDC_CH0_AXI_CLK_ROOT is used.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_fabric_mmdc_podf (3U) /*!< Bit position for CCM_CBCDR_fabric_mmdc_podf. */
#define BM_CCM_CBCDR_fabric_mmdc_podf (0x00000038U) /*!< Bit mask for CCM_CBCDR_fabric_mmdc_podf. */
#define BS_CCM_CBCDR_fabric_mmdc_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_fabric_mmdc_podf. */

/*! @brief Read current value of the CCM_CBCDR_fabric_mmdc_podf field. */
#define BR_CCM_CBCDR_fabric_mmdc_podf(x) (HW_CCM_CBCDR(x).B.fabric_mmdc_podf)

/*! @brief Format value for bitfield CCM_CBCDR_fabric_mmdc_podf. */
#define BF_CCM_CBCDR_fabric_mmdc_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_fabric_mmdc_podf) & BM_CCM_CBCDR_fabric_mmdc_podf)

/*! @brief Set the fabric_mmdc_podf field to a new value. */
#define BW_CCM_CBCDR_fabric_mmdc_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_fabric_mmdc_podf) | BF_CCM_CBCDR_fabric_mmdc_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_clk_sel[6] (RW)
 *
 * OCRAM clock source select
 *
 * Values:
 * - 0 - Periph_clk output will be used as OCRAM clock root
 * - 1 - AXI alternative clock will be used as OCRAM clock root
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_clk_sel (6U)    /*!< Bit position for CCM_CBCDR_ocram_clk_sel. */
#define BM_CCM_CBCDR_ocram_clk_sel (0x00000040U) /*!< Bit mask for CCM_CBCDR_ocram_clk_sel. */
#define BS_CCM_CBCDR_ocram_clk_sel (1U)    /*!< Bit field size in bits for CCM_CBCDR_ocram_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_ocram_clk_sel field. */
#define BR_CCM_CBCDR_ocram_clk_sel(x) (HW_CCM_CBCDR(x).B.ocram_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_clk_sel. */
#define BF_CCM_CBCDR_ocram_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_clk_sel) & BM_CCM_CBCDR_ocram_clk_sel)

/*! @brief Set the ocram_clk_sel field to a new value. */
#define BW_CCM_CBCDR_ocram_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_clk_sel) | BF_CCM_CBCDR_ocram_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_alt_clk_sel[7] (RW)
 *
 * OCRAM alternative clock select
 *
 * Values:
 * - 0 - pll2 396MHz PFD will be selected as alternative clock for OCRAM root
 *     clock
 * - 1 - pll3 540MHz PFD will be selected as alternative clock for OCRAM root
 *     clock
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_alt_clk_sel (7U) /*!< Bit position for CCM_CBCDR_ocram_alt_clk_sel. */
#define BM_CCM_CBCDR_ocram_alt_clk_sel (0x00000080U) /*!< Bit mask for CCM_CBCDR_ocram_alt_clk_sel. */
#define BS_CCM_CBCDR_ocram_alt_clk_sel (1U) /*!< Bit field size in bits for CCM_CBCDR_ocram_alt_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_ocram_alt_clk_sel field. */
#define BR_CCM_CBCDR_ocram_alt_clk_sel(x) (HW_CCM_CBCDR(x).B.ocram_alt_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_alt_clk_sel. */
#define BF_CCM_CBCDR_ocram_alt_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_alt_clk_sel) & BM_CCM_CBCDR_ocram_alt_clk_sel)

/*! @brief Set the ocram_alt_clk_sel field to a new value. */
#define BW_CCM_CBCDR_ocram_alt_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_alt_clk_sel) | BF_CCM_CBCDR_ocram_alt_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ipg_podf[9:8] (RW)
 *
 * Divider for ipg podf. IEEE_RTC module will not support ratio of 1:3 for
 * ahb_clk:ipg_clk. In case IEEE_RTC is used, then those ratios should not be used.
 * SDMA module will not support ratio of 1:3 and 1:4 for ahb_clk:ipg_clk. In case
 * SDMA is used, then those ratios should not be used.
 *
 * Values:
 * - 00 - divide by 1
 * - 01 - divide by 2
 * - 10 - divide by 3
 * - 11 - divide by 4
 */
/*@{*/
#define BP_CCM_CBCDR_ipg_podf (8U)         /*!< Bit position for CCM_CBCDR_ipg_podf. */
#define BM_CCM_CBCDR_ipg_podf (0x00000300U) /*!< Bit mask for CCM_CBCDR_ipg_podf. */
#define BS_CCM_CBCDR_ipg_podf (2U)         /*!< Bit field size in bits for CCM_CBCDR_ipg_podf. */

/*! @brief Read current value of the CCM_CBCDR_ipg_podf field. */
#define BR_CCM_CBCDR_ipg_podf(x) (HW_CCM_CBCDR(x).B.ipg_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ipg_podf. */
#define BF_CCM_CBCDR_ipg_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ipg_podf) & BM_CCM_CBCDR_ipg_podf)

/*! @brief Set the ipg_podf field to a new value. */
#define BW_CCM_CBCDR_ipg_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ipg_podf) | BF_CCM_CBCDR_ipg_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ahb_podf[12:10] (RW)
 *
 * Divider for AHB PODF. Any change of this divider might involve handshake with
 * EMI. See CDHIPR register for the handshake busy bits.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_ahb_podf (10U)        /*!< Bit position for CCM_CBCDR_ahb_podf. */
#define BM_CCM_CBCDR_ahb_podf (0x00001C00U) /*!< Bit mask for CCM_CBCDR_ahb_podf. */
#define BS_CCM_CBCDR_ahb_podf (3U)         /*!< Bit field size in bits for CCM_CBCDR_ahb_podf. */

/*! @brief Read current value of the CCM_CBCDR_ahb_podf field. */
#define BR_CCM_CBCDR_ahb_podf(x) (HW_CCM_CBCDR(x).B.ahb_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ahb_podf. */
#define BF_CCM_CBCDR_ahb_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ahb_podf) & BM_CCM_CBCDR_ahb_podf)

/*! @brief Set the ahb_podf field to a new value. */
#define BW_CCM_CBCDR_ahb_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ahb_podf) | BF_CCM_CBCDR_ahb_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field ocram_podf[18:16] (RW)
 *
 * Post divider for ocram clock. Any change of this divider might involve
 * handshake with EMI. See CDHIPR register for the handshake busy bits.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_ocram_podf (16U)      /*!< Bit position for CCM_CBCDR_ocram_podf. */
#define BM_CCM_CBCDR_ocram_podf (0x00070000U) /*!< Bit mask for CCM_CBCDR_ocram_podf. */
#define BS_CCM_CBCDR_ocram_podf (3U)       /*!< Bit field size in bits for CCM_CBCDR_ocram_podf. */

/*! @brief Read current value of the CCM_CBCDR_ocram_podf field. */
#define BR_CCM_CBCDR_ocram_podf(x) (HW_CCM_CBCDR(x).B.ocram_podf)

/*! @brief Format value for bitfield CCM_CBCDR_ocram_podf. */
#define BF_CCM_CBCDR_ocram_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_ocram_podf) & BM_CCM_CBCDR_ocram_podf)

/*! @brief Set the ocram_podf field to a new value. */
#define BW_CCM_CBCDR_ocram_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_ocram_podf) | BF_CCM_CBCDR_ocram_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph_clk_sel[25] (RW)
 *
 * Selector for peripheral main clock (source of mmdc_ch0_axi_clk_root).
 * Alternative clock source should be used when PLL is relocked. For PLL relock
 * procedure pls refer PLL chapter.
 *
 * Values:
 * - 0 - derive clock from pll2_sw_clk muxed clock source.
 * - 1 - derive clock from periph_clk2_clk clock source.
 */
/*@{*/
#define BP_CCM_CBCDR_periph_clk_sel (25U)  /*!< Bit position for CCM_CBCDR_periph_clk_sel. */
#define BM_CCM_CBCDR_periph_clk_sel (0x02000000U) /*!< Bit mask for CCM_CBCDR_periph_clk_sel. */
#define BS_CCM_CBCDR_periph_clk_sel (1U)   /*!< Bit field size in bits for CCM_CBCDR_periph_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_periph_clk_sel field. */
#define BR_CCM_CBCDR_periph_clk_sel(x) (HW_CCM_CBCDR(x).B.periph_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_periph_clk_sel. */
#define BF_CCM_CBCDR_periph_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph_clk_sel) & BM_CCM_CBCDR_periph_clk_sel)

/*! @brief Set the periph_clk_sel field to a new value. */
#define BW_CCM_CBCDR_periph_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph_clk_sel) | BF_CCM_CBCDR_periph_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph2_clk_sel[26] (RW)
 *
 * Selector for peripheral2 main clock (source of mmdc_root_axi_clk_root ).
 *
 * Values:
 * - 0 - derive clock from pll2_sw_clk muxed clock source.
 * - 1 - derive clock from periph_clk2_clk clock source.
 */
/*@{*/
#define BP_CCM_CBCDR_periph2_clk_sel (26U) /*!< Bit position for CCM_CBCDR_periph2_clk_sel. */
#define BM_CCM_CBCDR_periph2_clk_sel (0x04000000U) /*!< Bit mask for CCM_CBCDR_periph2_clk_sel. */
#define BS_CCM_CBCDR_periph2_clk_sel (1U)  /*!< Bit field size in bits for CCM_CBCDR_periph2_clk_sel. */

/*! @brief Read current value of the CCM_CBCDR_periph2_clk_sel field. */
#define BR_CCM_CBCDR_periph2_clk_sel(x) (HW_CCM_CBCDR(x).B.periph2_clk_sel)

/*! @brief Format value for bitfield CCM_CBCDR_periph2_clk_sel. */
#define BF_CCM_CBCDR_periph2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph2_clk_sel) & BM_CCM_CBCDR_periph2_clk_sel)

/*! @brief Set the periph2_clk_sel field to a new value. */
#define BW_CCM_CBCDR_periph2_clk_sel(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph2_clk_sel) | BF_CCM_CBCDR_periph2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCDR, field periph_clk2_podf[29:27] (RW)
 *
 * Divider for periph2 clock podf.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCDR_periph_clk2_podf (27U) /*!< Bit position for CCM_CBCDR_periph_clk2_podf. */
#define BM_CCM_CBCDR_periph_clk2_podf (0x38000000U) /*!< Bit mask for CCM_CBCDR_periph_clk2_podf. */
#define BS_CCM_CBCDR_periph_clk2_podf (3U) /*!< Bit field size in bits for CCM_CBCDR_periph_clk2_podf. */

/*! @brief Read current value of the CCM_CBCDR_periph_clk2_podf field. */
#define BR_CCM_CBCDR_periph_clk2_podf(x) (HW_CCM_CBCDR(x).B.periph_clk2_podf)

/*! @brief Format value for bitfield CCM_CBCDR_periph_clk2_podf. */
#define BF_CCM_CBCDR_periph_clk2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCDR_periph_clk2_podf) & BM_CCM_CBCDR_periph_clk2_podf)

/*! @brief Set the periph_clk2_podf field to a new value. */
#define BW_CCM_CBCDR_periph_clk2_podf(x, v) (HW_CCM_CBCDR_WR(x, (HW_CCM_CBCDR_RD(x) & ~BM_CCM_CBCDR_periph_clk2_podf) | BF_CCM_CBCDR_periph_clk2_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CBCMR - CCM Bus Clock Multiplexer Register (RW)
 *
 * Reset value: 0x00820324U
 *
 * The figure below represents the CCM Bus Clock Multiplexer Register (CBCMR).
 * The CBCMR register contains bits to control the multiplexers that generate the
 * bus clocks. The table below provides its field descriptions. Any change on the
 * above multiplexer will have to be done while the module that its clock is
 * affected is not functional and the respective clock is gated in LPCG. If the
 * change will be done during operation of the module, then it is not guaranteed that
 * the modules operation will not be harmed. The change for arm_clk_sel should
 * be done through sdma so that ARM will not use this clock during the change and
 * the clock will be gated in LPCG.
 */
typedef union _hw_ccm_cbcmr
{
    uint32_t U;
    struct _hw_ccm_cbcmr_bitfields
    {
        uint32_t RESERVED0 : 4;        /*!< [3:0]  */
        uint32_t gpu2d_ovg_core_clk_sel : 2; /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t gpu2d_core_clk_sel : 2; /*!< [9:8]  */
        uint32_t RESERVED2 : 1;        /*!< [10]  */
        uint32_t vdoaxi_clk_sel : 1;   /*!< [11]  */
        uint32_t periph_clk2_sel : 2;  /*!< [13:12]  */
        uint32_t RESERVED3 : 4;        /*!< [17:14]  */
        uint32_t pre_periph_clk_sel : 2; /*!< [19:18]  */
        uint32_t periph2_clk2_sel : 1; /*!< [20]  */
        uint32_t pre_periph2_clk_sel : 2; /*!< [22:21]  */
        uint32_t epdc_pix_podf : 3;    /*!< [25:23]  */
        uint32_t gpu2d_ovg_core_podf : 3; /*!< [28:26]  */
        uint32_t gpu2d_core_podf : 3;  /*!< [31:29]  */
    } B;
} hw_ccm_cbcmr_t;

/*!
 * @name Constants and macros for entire CCM_CBCMR register
 */
/*@{*/
#define HW_CCM_CBCMR_ADDR(x)     ((uintptr_t)(x) + 0x18U)

#define HW_CCM_CBCMR(x)          (*(__IO hw_ccm_cbcmr_t *) HW_CCM_CBCMR_ADDR(x))
#define HW_CCM_CBCMR_RD(x)       (HW_CCM_CBCMR(x).U)
#define HW_CCM_CBCMR_WR(x, v)    (HW_CCM_CBCMR(x).U = (v))
#define HW_CCM_CBCMR_SET(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) |  (v)))
#define HW_CCM_CBCMR_CLR(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) & ~(v)))
#define HW_CCM_CBCMR_TOG(x, v)   (HW_CCM_CBCMR_WR(x, HW_CCM_CBCMR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CBCMR bitfields
 */

/*!
 * @name Register CCM_CBCMR, field gpu2d_ovg_core_clk_sel[5:4] (RW)
 *
 * Selector for gpu2d_ovg_core clock multiplexer
 */
/*@{*/
#define BP_CCM_CBCMR_gpu2d_ovg_core_clk_sel (4U) /*!< Bit position for CCM_CBCMR_gpu2d_ovg_core_clk_sel. */
#define BM_CCM_CBCMR_gpu2d_ovg_core_clk_sel (0x00000030U) /*!< Bit mask for CCM_CBCMR_gpu2d_ovg_core_clk_sel. */
#define BS_CCM_CBCMR_gpu2d_ovg_core_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_gpu2d_ovg_core_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_gpu2d_ovg_core_clk_sel field. */
#define BR_CCM_CBCMR_gpu2d_ovg_core_clk_sel(x) (HW_CCM_CBCMR(x).B.gpu2d_ovg_core_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_gpu2d_ovg_core_clk_sel. */
#define BF_CCM_CBCMR_gpu2d_ovg_core_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu2d_ovg_core_clk_sel) & BM_CCM_CBCMR_gpu2d_ovg_core_clk_sel)

/*! @brief Set the gpu2d_ovg_core_clk_sel field to a new value. */
#define BW_CCM_CBCMR_gpu2d_ovg_core_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu2d_ovg_core_clk_sel) | BF_CCM_CBCMR_gpu2d_ovg_core_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu2d_core_clk_sel[9:8] (RW)
 *
 * Selector for gpu2d_core clock multiplexer
 *
 * Values:
 * - 00 - derive clock from mmdc_ch0 clk
 * - 01 - derive clock from pll3
 * - 10 - derive clock from 594M PFD
 * - 11 - derive clock from 720M PFD
 */
/*@{*/
#define BP_CCM_CBCMR_gpu2d_core_clk_sel (8U) /*!< Bit position for CCM_CBCMR_gpu2d_core_clk_sel. */
#define BM_CCM_CBCMR_gpu2d_core_clk_sel (0x00000300U) /*!< Bit mask for CCM_CBCMR_gpu2d_core_clk_sel. */
#define BS_CCM_CBCMR_gpu2d_core_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_gpu2d_core_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_gpu2d_core_clk_sel field. */
#define BR_CCM_CBCMR_gpu2d_core_clk_sel(x) (HW_CCM_CBCMR(x).B.gpu2d_core_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_gpu2d_core_clk_sel. */
#define BF_CCM_CBCMR_gpu2d_core_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu2d_core_clk_sel) & BM_CCM_CBCMR_gpu2d_core_clk_sel)

/*! @brief Set the gpu2d_core_clk_sel field to a new value. */
#define BW_CCM_CBCMR_gpu2d_core_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu2d_core_clk_sel) | BF_CCM_CBCMR_gpu2d_core_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field vdoaxi_clk_sel[11] (RW)
 *
 * Selector for vdoaxi clock multiplexer
 *
 * Values:
 * - 0 - derive clock from axi clk
 * - 1 - derive clock from 132M clock
 */
/*@{*/
#define BP_CCM_CBCMR_vdoaxi_clk_sel (11U)  /*!< Bit position for CCM_CBCMR_vdoaxi_clk_sel. */
#define BM_CCM_CBCMR_vdoaxi_clk_sel (0x00000800U) /*!< Bit mask for CCM_CBCMR_vdoaxi_clk_sel. */
#define BS_CCM_CBCMR_vdoaxi_clk_sel (1U)   /*!< Bit field size in bits for CCM_CBCMR_vdoaxi_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_vdoaxi_clk_sel field. */
#define BR_CCM_CBCMR_vdoaxi_clk_sel(x) (HW_CCM_CBCMR(x).B.vdoaxi_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_vdoaxi_clk_sel. */
#define BF_CCM_CBCMR_vdoaxi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_vdoaxi_clk_sel) & BM_CCM_CBCMR_vdoaxi_clk_sel)

/*! @brief Set the vdoaxi_clk_sel field to a new value. */
#define BW_CCM_CBCMR_vdoaxi_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_vdoaxi_clk_sel) | BF_CCM_CBCMR_vdoaxi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field periph_clk2_sel[13:12] (RW)
 *
 * Selector for peripheral clk2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll3_sw_clk
 * - 01 - derive clock from pll1_ref_clk
 * - 10 - derive clock from pll2_burn_in_clk
 * - 11 - reserved
 */
/*@{*/
#define BP_CCM_CBCMR_periph_clk2_sel (12U) /*!< Bit position for CCM_CBCMR_periph_clk2_sel. */
#define BM_CCM_CBCMR_periph_clk2_sel (0x00003000U) /*!< Bit mask for CCM_CBCMR_periph_clk2_sel. */
#define BS_CCM_CBCMR_periph_clk2_sel (2U)  /*!< Bit field size in bits for CCM_CBCMR_periph_clk2_sel. */

/*! @brief Read current value of the CCM_CBCMR_periph_clk2_sel field. */
#define BR_CCM_CBCMR_periph_clk2_sel(x) (HW_CCM_CBCMR(x).B.periph_clk2_sel)

/*! @brief Format value for bitfield CCM_CBCMR_periph_clk2_sel. */
#define BF_CCM_CBCMR_periph_clk2_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_periph_clk2_sel) & BM_CCM_CBCMR_periph_clk2_sel)

/*! @brief Set the periph_clk2_sel field to a new value. */
#define BW_CCM_CBCMR_periph_clk2_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_periph_clk2_sel) | BF_CCM_CBCMR_periph_clk2_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field pre_periph_clk_sel[19:18] (RW)
 *
 * Selector for pre_periph clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2 main 528MHz clock
 * - 01 - derive clock from 396MHz PLL2 PFD
 * - 10 - derive clock from 352M PFD
 * - 11 - derive clock from 198MHz clock (divided 396MHz PLL2 PFD)
 */
/*@{*/
#define BP_CCM_CBCMR_pre_periph_clk_sel (18U) /*!< Bit position for CCM_CBCMR_pre_periph_clk_sel. */
#define BM_CCM_CBCMR_pre_periph_clk_sel (0x000C0000U) /*!< Bit mask for CCM_CBCMR_pre_periph_clk_sel. */
#define BS_CCM_CBCMR_pre_periph_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_pre_periph_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_pre_periph_clk_sel field. */
#define BR_CCM_CBCMR_pre_periph_clk_sel(x) (HW_CCM_CBCMR(x).B.pre_periph_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_pre_periph_clk_sel. */
#define BF_CCM_CBCMR_pre_periph_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_pre_periph_clk_sel) & BM_CCM_CBCMR_pre_periph_clk_sel)

/*! @brief Set the pre_periph_clk_sel field to a new value. */
#define BW_CCM_CBCMR_pre_periph_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_pre_periph_clk_sel) | BF_CCM_CBCMR_pre_periph_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field periph2_clk2_sel[20] (RW)
 *
 * Selector for periph2_clk2 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from pll3_sw_clk
 * - 1 - derive clock from PLL2 Main
 */
/*@{*/
#define BP_CCM_CBCMR_periph2_clk2_sel (20U) /*!< Bit position for CCM_CBCMR_periph2_clk2_sel. */
#define BM_CCM_CBCMR_periph2_clk2_sel (0x00100000U) /*!< Bit mask for CCM_CBCMR_periph2_clk2_sel. */
#define BS_CCM_CBCMR_periph2_clk2_sel (1U) /*!< Bit field size in bits for CCM_CBCMR_periph2_clk2_sel. */

/*! @brief Read current value of the CCM_CBCMR_periph2_clk2_sel field. */
#define BR_CCM_CBCMR_periph2_clk2_sel(x) (HW_CCM_CBCMR(x).B.periph2_clk2_sel)

/*! @brief Format value for bitfield CCM_CBCMR_periph2_clk2_sel. */
#define BF_CCM_CBCMR_periph2_clk2_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_periph2_clk2_sel) & BM_CCM_CBCMR_periph2_clk2_sel)

/*! @brief Set the periph2_clk2_sel field to a new value. */
#define BW_CCM_CBCMR_periph2_clk2_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_periph2_clk2_sel) | BF_CCM_CBCMR_periph2_clk2_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field pre_periph2_clk_sel[22:21] (RW)
 *
 * Selector for pre_periph2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from PLL2 main 528MHz clock
 * - 01 - derive clock from 396MHz PLL2 PFD
 * - 10 - derive clock from 352M PFD
 * - 11 - derive clock from 198MHz clock (divided 396MHz PLL2 PFD)
 */
/*@{*/
#define BP_CCM_CBCMR_pre_periph2_clk_sel (21U) /*!< Bit position for CCM_CBCMR_pre_periph2_clk_sel. */
#define BM_CCM_CBCMR_pre_periph2_clk_sel (0x00600000U) /*!< Bit mask for CCM_CBCMR_pre_periph2_clk_sel. */
#define BS_CCM_CBCMR_pre_periph2_clk_sel (2U) /*!< Bit field size in bits for CCM_CBCMR_pre_periph2_clk_sel. */

/*! @brief Read current value of the CCM_CBCMR_pre_periph2_clk_sel field. */
#define BR_CCM_CBCMR_pre_periph2_clk_sel(x) (HW_CCM_CBCMR(x).B.pre_periph2_clk_sel)

/*! @brief Format value for bitfield CCM_CBCMR_pre_periph2_clk_sel. */
#define BF_CCM_CBCMR_pre_periph2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_pre_periph2_clk_sel) & BM_CCM_CBCMR_pre_periph2_clk_sel)

/*! @brief Set the pre_periph2_clk_sel field to a new value. */
#define BW_CCM_CBCMR_pre_periph2_clk_sel(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_pre_periph2_clk_sel) | BF_CCM_CBCMR_pre_periph2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field epdc_pix_podf[25:23] (RW)
 *
 * Post divider for EPDC_PIX. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_epdc_pix_podf (23U)   /*!< Bit position for CCM_CBCMR_epdc_pix_podf. */
#define BM_CCM_CBCMR_epdc_pix_podf (0x03800000U) /*!< Bit mask for CCM_CBCMR_epdc_pix_podf. */
#define BS_CCM_CBCMR_epdc_pix_podf (3U)    /*!< Bit field size in bits for CCM_CBCMR_epdc_pix_podf. */

/*! @brief Read current value of the CCM_CBCMR_epdc_pix_podf field. */
#define BR_CCM_CBCMR_epdc_pix_podf(x) (HW_CCM_CBCMR(x).B.epdc_pix_podf)

/*! @brief Format value for bitfield CCM_CBCMR_epdc_pix_podf. */
#define BF_CCM_CBCMR_epdc_pix_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_epdc_pix_podf) & BM_CCM_CBCMR_epdc_pix_podf)

/*! @brief Set the epdc_pix_podf field to a new value. */
#define BW_CCM_CBCMR_epdc_pix_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_epdc_pix_podf) | BF_CCM_CBCMR_epdc_pix_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu2d_ovg_core_podf[28:26] (RW)
 *
 * Divider for gpu3d_core clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_gpu2d_ovg_core_podf (26U) /*!< Bit position for CCM_CBCMR_gpu2d_ovg_core_podf. */
#define BM_CCM_CBCMR_gpu2d_ovg_core_podf (0x1C000000U) /*!< Bit mask for CCM_CBCMR_gpu2d_ovg_core_podf. */
#define BS_CCM_CBCMR_gpu2d_ovg_core_podf (3U) /*!< Bit field size in bits for CCM_CBCMR_gpu2d_ovg_core_podf. */

/*! @brief Read current value of the CCM_CBCMR_gpu2d_ovg_core_podf field. */
#define BR_CCM_CBCMR_gpu2d_ovg_core_podf(x) (HW_CCM_CBCMR(x).B.gpu2d_ovg_core_podf)

/*! @brief Format value for bitfield CCM_CBCMR_gpu2d_ovg_core_podf. */
#define BF_CCM_CBCMR_gpu2d_ovg_core_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu2d_ovg_core_podf) & BM_CCM_CBCMR_gpu2d_ovg_core_podf)

/*! @brief Set the gpu2d_ovg_core_podf field to a new value. */
#define BW_CCM_CBCMR_gpu2d_ovg_core_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu2d_ovg_core_podf) | BF_CCM_CBCMR_gpu2d_ovg_core_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CBCMR, field gpu2d_core_podf[31:29] (RW)
 *
 * Post divider for gpu2d_core clock. Divider should be updated when output
 * clock is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CBCMR_gpu2d_core_podf (29U) /*!< Bit position for CCM_CBCMR_gpu2d_core_podf. */
#define BM_CCM_CBCMR_gpu2d_core_podf (0xE0000000U) /*!< Bit mask for CCM_CBCMR_gpu2d_core_podf. */
#define BS_CCM_CBCMR_gpu2d_core_podf (3U)  /*!< Bit field size in bits for CCM_CBCMR_gpu2d_core_podf. */

/*! @brief Read current value of the CCM_CBCMR_gpu2d_core_podf field. */
#define BR_CCM_CBCMR_gpu2d_core_podf(x) (HW_CCM_CBCMR(x).B.gpu2d_core_podf)

/*! @brief Format value for bitfield CCM_CBCMR_gpu2d_core_podf. */
#define BF_CCM_CBCMR_gpu2d_core_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CBCMR_gpu2d_core_podf) & BM_CCM_CBCMR_gpu2d_core_podf)

/*! @brief Set the gpu2d_core_podf field to a new value. */
#define BW_CCM_CBCMR_gpu2d_core_podf(x, v) (HW_CCM_CBCMR_WR(x, (HW_CCM_CBCMR_RD(x) & ~BM_CCM_CBCMR_gpu2d_core_podf) | BF_CCM_CBCMR_gpu2d_core_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCMR1 - CCM Serial Clock Multiplexer Register 1 (RW)
 *
 * Reset value: 0x00F00000U
 *
 * The figure below represents the CCM Serial Clock Multiplexer Register 1
 * (CSCMR1). The CSCMR1 register contains bits to control the multiplexers that
 * generate the serial clocks. The table below provides its field descriptions. Any
 * change on the above multiplexer will have to be done while the module that its
 * clock is affected is not functional and the clock is gated. If the change will
 * be done during operation of the module, then it is not guaranteed that the
 * modules operation will not be harmed.
 */
typedef union _hw_ccm_cscmr1
{
    uint32_t U;
    struct _hw_ccm_cscmr1_bitfields
    {
        uint32_t perclk_podf : 6;      /*!< [5:0]  */
        uint32_t perclk_clk_sel : 1;   /*!< [6]  */
        uint32_t RESERVED0 : 3;        /*!< [9:7]  */
        uint32_t ssi1_clk_sel : 2;     /*!< [11:10]  */
        uint32_t ssi2_clk_sel : 2;     /*!< [13:12]  */
        uint32_t ssi3_clk_sel : 2;     /*!< [15:14]  */
        uint32_t usdhc1_clk_sel : 1;   /*!< [16]  */
        uint32_t usdhc2_clk_sel : 1;   /*!< [17]  */
        uint32_t usdhc3_clk_sel : 1;   /*!< [18]  */
        uint32_t usdhc4_clk_sel : 1;   /*!< [19]  */
        uint32_t lcdif_pix_podf : 3;   /*!< [22:20]  */
        uint32_t aclk_eim_slow_podf : 3; /*!< [25:23]  */
        uint32_t RESERVED1 : 3;        /*!< [28:26]  */
        uint32_t aclk_eim_slow_sel : 2; /*!< [30:29]  */
        uint32_t RESERVED2 : 1;        /*!< [31]  */
    } B;
} hw_ccm_cscmr1_t;

/*!
 * @name Constants and macros for entire CCM_CSCMR1 register
 */
/*@{*/
#define HW_CCM_CSCMR1_ADDR(x)    ((uintptr_t)(x) + 0x1CU)

#define HW_CCM_CSCMR1(x)         (*(__IO hw_ccm_cscmr1_t *) HW_CCM_CSCMR1_ADDR(x))
#define HW_CCM_CSCMR1_RD(x)      (HW_CCM_CSCMR1(x).U)
#define HW_CCM_CSCMR1_WR(x, v)   (HW_CCM_CSCMR1(x).U = (v))
#define HW_CCM_CSCMR1_SET(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) |  (v)))
#define HW_CCM_CSCMR1_CLR(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) & ~(v)))
#define HW_CCM_CSCMR1_TOG(x, v)  (HW_CCM_CSCMR1_WR(x, HW_CCM_CSCMR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCMR1 bitfields
 */

/*!
 * @name Register CCM_CSCMR1, field perclk_podf[5:0] (RW)
 *
 * Divider for perclk podf.
 *
 * Values:
 * - 000 - divide by 1 (default)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_perclk_podf (0U)     /*!< Bit position for CCM_CSCMR1_perclk_podf. */
#define BM_CCM_CSCMR1_perclk_podf (0x0000003FU) /*!< Bit mask for CCM_CSCMR1_perclk_podf. */
#define BS_CCM_CSCMR1_perclk_podf (6U)     /*!< Bit field size in bits for CCM_CSCMR1_perclk_podf. */

/*! @brief Read current value of the CCM_CSCMR1_perclk_podf field. */
#define BR_CCM_CSCMR1_perclk_podf(x) (HW_CCM_CSCMR1(x).B.perclk_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_perclk_podf. */
#define BF_CCM_CSCMR1_perclk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_perclk_podf) & BM_CCM_CSCMR1_perclk_podf)

/*! @brief Set the perclk_podf field to a new value. */
#define BW_CCM_CSCMR1_perclk_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_perclk_podf) | BF_CCM_CSCMR1_perclk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field perclk_clk_sel[6] (RW)
 *
 * Selector for the perclk clock multiplexor
 *
 * Values:
 * - 0 - ipg clk root
 * - 1 - OSC clock
 */
/*@{*/
#define BP_CCM_CSCMR1_perclk_clk_sel (6U)  /*!< Bit position for CCM_CSCMR1_perclk_clk_sel. */
#define BM_CCM_CSCMR1_perclk_clk_sel (0x00000040U) /*!< Bit mask for CCM_CSCMR1_perclk_clk_sel. */
#define BS_CCM_CSCMR1_perclk_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_perclk_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_perclk_clk_sel field. */
#define BR_CCM_CSCMR1_perclk_clk_sel(x) (HW_CCM_CSCMR1(x).B.perclk_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_perclk_clk_sel. */
#define BF_CCM_CSCMR1_perclk_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_perclk_clk_sel) & BM_CCM_CSCMR1_perclk_clk_sel)

/*! @brief Set the perclk_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_perclk_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_perclk_clk_sel) | BF_CCM_CSCMR1_perclk_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi1_clk_sel[11:10] (RW)
 *
 * Selector for ssi1 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from 508.2M PFD (default)
 * - 01 - derive clock from 454.7M PFD
 * - 10 - derive clock from pll4
 * - 11 - Restricted
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi1_clk_sel (10U)   /*!< Bit position for CCM_CSCMR1_ssi1_clk_sel. */
#define BM_CCM_CSCMR1_ssi1_clk_sel (0x00000C00U) /*!< Bit mask for CCM_CSCMR1_ssi1_clk_sel. */
#define BS_CCM_CSCMR1_ssi1_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi1_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi1_clk_sel field. */
#define BR_CCM_CSCMR1_ssi1_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi1_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi1_clk_sel. */
#define BF_CCM_CSCMR1_ssi1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi1_clk_sel) & BM_CCM_CSCMR1_ssi1_clk_sel)

/*! @brief Set the ssi1_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi1_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi1_clk_sel) | BF_CCM_CSCMR1_ssi1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi2_clk_sel[13:12] (RW)
 *
 * Selector for ssi2 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from 508.2M PFD (default)
 * - 01 - derive clock from 454.7M PFD
 * - 10 - derive clock from pll4
 * - 11 - Restricted
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi2_clk_sel (12U)   /*!< Bit position for CCM_CSCMR1_ssi2_clk_sel. */
#define BM_CCM_CSCMR1_ssi2_clk_sel (0x00003000U) /*!< Bit mask for CCM_CSCMR1_ssi2_clk_sel. */
#define BS_CCM_CSCMR1_ssi2_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi2_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi2_clk_sel field. */
#define BR_CCM_CSCMR1_ssi2_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi2_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi2_clk_sel. */
#define BF_CCM_CSCMR1_ssi2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi2_clk_sel) & BM_CCM_CSCMR1_ssi2_clk_sel)

/*! @brief Set the ssi2_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi2_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi2_clk_sel) | BF_CCM_CSCMR1_ssi2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field ssi3_clk_sel[15:14] (RW)
 *
 * Selector for ssi3 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from 508.2M PFD (default)
 * - 01 - derive clock from 454.7M PFD
 * - 10 - derive clock from pll4
 * - 11 - Restricted
 */
/*@{*/
#define BP_CCM_CSCMR1_ssi3_clk_sel (14U)   /*!< Bit position for CCM_CSCMR1_ssi3_clk_sel. */
#define BM_CCM_CSCMR1_ssi3_clk_sel (0x0000C000U) /*!< Bit mask for CCM_CSCMR1_ssi3_clk_sel. */
#define BS_CCM_CSCMR1_ssi3_clk_sel (2U)    /*!< Bit field size in bits for CCM_CSCMR1_ssi3_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_ssi3_clk_sel field. */
#define BR_CCM_CSCMR1_ssi3_clk_sel(x) (HW_CCM_CSCMR1(x).B.ssi3_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_ssi3_clk_sel. */
#define BF_CCM_CSCMR1_ssi3_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_ssi3_clk_sel) & BM_CCM_CSCMR1_ssi3_clk_sel)

/*! @brief Set the ssi3_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_ssi3_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_ssi3_clk_sel) | BF_CCM_CSCMR1_ssi3_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc1_clk_sel[16] (RW)
 *
 * Selector for usdhc1 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from 396M PFD
 * - 1 - derive clock from 352M PFD
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc1_clk_sel (16U) /*!< Bit position for CCM_CSCMR1_usdhc1_clk_sel. */
#define BM_CCM_CSCMR1_usdhc1_clk_sel (0x00010000U) /*!< Bit mask for CCM_CSCMR1_usdhc1_clk_sel. */
#define BS_CCM_CSCMR1_usdhc1_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc1_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc1_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc1_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc1_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc1_clk_sel. */
#define BF_CCM_CSCMR1_usdhc1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc1_clk_sel) & BM_CCM_CSCMR1_usdhc1_clk_sel)

/*! @brief Set the usdhc1_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc1_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc1_clk_sel) | BF_CCM_CSCMR1_usdhc1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc2_clk_sel[17] (RW)
 *
 * Selector for usdhc2 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from 396M PFD
 * - 1 - derive clock from 352M PFD
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc2_clk_sel (17U) /*!< Bit position for CCM_CSCMR1_usdhc2_clk_sel. */
#define BM_CCM_CSCMR1_usdhc2_clk_sel (0x00020000U) /*!< Bit mask for CCM_CSCMR1_usdhc2_clk_sel. */
#define BS_CCM_CSCMR1_usdhc2_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc2_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc2_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc2_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc2_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc2_clk_sel. */
#define BF_CCM_CSCMR1_usdhc2_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc2_clk_sel) & BM_CCM_CSCMR1_usdhc2_clk_sel)

/*! @brief Set the usdhc2_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc2_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc2_clk_sel) | BF_CCM_CSCMR1_usdhc2_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc3_clk_sel[18] (RW)
 *
 * Selector for usdhc3 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from 396M PFD
 * - 1 - derive clock from 352M PFD
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc3_clk_sel (18U) /*!< Bit position for CCM_CSCMR1_usdhc3_clk_sel. */
#define BM_CCM_CSCMR1_usdhc3_clk_sel (0x00040000U) /*!< Bit mask for CCM_CSCMR1_usdhc3_clk_sel. */
#define BS_CCM_CSCMR1_usdhc3_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc3_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc3_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc3_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc3_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc3_clk_sel. */
#define BF_CCM_CSCMR1_usdhc3_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc3_clk_sel) & BM_CCM_CSCMR1_usdhc3_clk_sel)

/*! @brief Set the usdhc3_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc3_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc3_clk_sel) | BF_CCM_CSCMR1_usdhc3_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field usdhc4_clk_sel[19] (RW)
 *
 * Selector for usdhc4 clock multiplexer
 *
 * Values:
 * - 0 - derive clock from 396M PFD
 * - 1 - derive clock from 352M PFD
 */
/*@{*/
#define BP_CCM_CSCMR1_usdhc4_clk_sel (19U) /*!< Bit position for CCM_CSCMR1_usdhc4_clk_sel. */
#define BM_CCM_CSCMR1_usdhc4_clk_sel (0x00080000U) /*!< Bit mask for CCM_CSCMR1_usdhc4_clk_sel. */
#define BS_CCM_CSCMR1_usdhc4_clk_sel (1U)  /*!< Bit field size in bits for CCM_CSCMR1_usdhc4_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR1_usdhc4_clk_sel field. */
#define BR_CCM_CSCMR1_usdhc4_clk_sel(x) (HW_CCM_CSCMR1(x).B.usdhc4_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_usdhc4_clk_sel. */
#define BF_CCM_CSCMR1_usdhc4_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_usdhc4_clk_sel) & BM_CCM_CSCMR1_usdhc4_clk_sel)

/*! @brief Set the usdhc4_clk_sel field to a new value. */
#define BW_CCM_CSCMR1_usdhc4_clk_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_usdhc4_clk_sel) | BF_CCM_CSCMR1_usdhc4_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field lcdif_pix_podf[22:20] (RW)
 *
 * Post divider for LCDIF_PIX. These bits are inverted between R/W and are not
 * sequential.
 *
 * Values:
 * - 000 - divide by 7 (Read value 110)
 * - 001 - divide by 8 (Read value 111)
 * - 010 - divide by 5 (Read value 100)
 * - 011 - divide by 6 (Read value 101)
 * - 100 - divide by 3 (Read value 010)
 * - 101 - divide by 4 (Read value 011)
 * - 110 - divide by 1 (Read value 000)
 * - 111 - divide by 2 (default) (Read value 001)
 */
/*@{*/
#define BP_CCM_CSCMR1_lcdif_pix_podf (20U) /*!< Bit position for CCM_CSCMR1_lcdif_pix_podf. */
#define BM_CCM_CSCMR1_lcdif_pix_podf (0x00700000U) /*!< Bit mask for CCM_CSCMR1_lcdif_pix_podf. */
#define BS_CCM_CSCMR1_lcdif_pix_podf (3U)  /*!< Bit field size in bits for CCM_CSCMR1_lcdif_pix_podf. */

/*! @brief Read current value of the CCM_CSCMR1_lcdif_pix_podf field. */
#define BR_CCM_CSCMR1_lcdif_pix_podf(x) (HW_CCM_CSCMR1(x).B.lcdif_pix_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_lcdif_pix_podf. */
#define BF_CCM_CSCMR1_lcdif_pix_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_lcdif_pix_podf) & BM_CCM_CSCMR1_lcdif_pix_podf)

/*! @brief Set the lcdif_pix_podf field to a new value. */
#define BW_CCM_CSCMR1_lcdif_pix_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_lcdif_pix_podf) | BF_CCM_CSCMR1_lcdif_pix_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field aclk_eim_slow_podf[25:23] (RW)
 *
 * Divider for aclk_eim_slow clock root.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCMR1_aclk_eim_slow_podf (23U) /*!< Bit position for CCM_CSCMR1_aclk_eim_slow_podf. */
#define BM_CCM_CSCMR1_aclk_eim_slow_podf (0x03800000U) /*!< Bit mask for CCM_CSCMR1_aclk_eim_slow_podf. */
#define BS_CCM_CSCMR1_aclk_eim_slow_podf (3U) /*!< Bit field size in bits for CCM_CSCMR1_aclk_eim_slow_podf. */

/*! @brief Read current value of the CCM_CSCMR1_aclk_eim_slow_podf field. */
#define BR_CCM_CSCMR1_aclk_eim_slow_podf(x) (HW_CCM_CSCMR1(x).B.aclk_eim_slow_podf)

/*! @brief Format value for bitfield CCM_CSCMR1_aclk_eim_slow_podf. */
#define BF_CCM_CSCMR1_aclk_eim_slow_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_aclk_eim_slow_podf) & BM_CCM_CSCMR1_aclk_eim_slow_podf)

/*! @brief Set the aclk_eim_slow_podf field to a new value. */
#define BW_CCM_CSCMR1_aclk_eim_slow_podf(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_aclk_eim_slow_podf) | BF_CCM_CSCMR1_aclk_eim_slow_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCMR1, field aclk_eim_slow_sel[30:29] (RW)
 *
 * Selector for aclk_eim_slow root clock multiplexer
 *
 * Values:
 * - 00 - derive clock from AXI clk root (default)
 * - 01 - derive clock from PLL3
 * - 10 - derive clock from 396M PFD
 * - 11 - derive clock from 352M PFD
 */
/*@{*/
#define BP_CCM_CSCMR1_aclk_eim_slow_sel (29U) /*!< Bit position for CCM_CSCMR1_aclk_eim_slow_sel. */
#define BM_CCM_CSCMR1_aclk_eim_slow_sel (0x60000000U) /*!< Bit mask for CCM_CSCMR1_aclk_eim_slow_sel. */
#define BS_CCM_CSCMR1_aclk_eim_slow_sel (2U) /*!< Bit field size in bits for CCM_CSCMR1_aclk_eim_slow_sel. */

/*! @brief Read current value of the CCM_CSCMR1_aclk_eim_slow_sel field. */
#define BR_CCM_CSCMR1_aclk_eim_slow_sel(x) (HW_CCM_CSCMR1(x).B.aclk_eim_slow_sel)

/*! @brief Format value for bitfield CCM_CSCMR1_aclk_eim_slow_sel. */
#define BF_CCM_CSCMR1_aclk_eim_slow_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR1_aclk_eim_slow_sel) & BM_CCM_CSCMR1_aclk_eim_slow_sel)

/*! @brief Set the aclk_eim_slow_sel field to a new value. */
#define BW_CCM_CSCMR1_aclk_eim_slow_sel(x, v) (HW_CCM_CSCMR1_WR(x, (HW_CCM_CSCMR1_RD(x) & ~BM_CCM_CSCMR1_aclk_eim_slow_sel) | BF_CCM_CSCMR1_aclk_eim_slow_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCMR2 - CCM Serial Clock Multiplexer Register 2 (RW)
 *
 * Reset value: 0x02B92F06U
 *
 * The figure below represents the CCM Serial Clock Multiplexer Register 2
 * (CSCMR2). The CSCMR2 register contains bits to control the multiplexers that
 * generate the serial clocks. The table below provides its field descriptions. Any
 * change on the above multiplexer will have to be done while the module that its
 * clock is affected is not functional and the clock is gated. If the change will
 * be done during operation of the module, then it is not guaranteed that the
 * modules operation will not be harmed.
 */
typedef union _hw_ccm_cscmr2
{
    uint32_t U;
    struct _hw_ccm_cscmr2_bitfields
    {
        uint32_t RESERVED0 : 19;       /*!< [18:0]  */
        uint32_t extern_audio_clk_sel : 2; /*!< [20:19]  */
        uint32_t RESERVED1 : 11;       /*!< [31:21]  */
    } B;
} hw_ccm_cscmr2_t;

/*!
 * @name Constants and macros for entire CCM_CSCMR2 register
 */
/*@{*/
#define HW_CCM_CSCMR2_ADDR(x)    ((uintptr_t)(x) + 0x20U)

#define HW_CCM_CSCMR2(x)         (*(__IO hw_ccm_cscmr2_t *) HW_CCM_CSCMR2_ADDR(x))
#define HW_CCM_CSCMR2_RD(x)      (HW_CCM_CSCMR2(x).U)
#define HW_CCM_CSCMR2_WR(x, v)   (HW_CCM_CSCMR2(x).U = (v))
#define HW_CCM_CSCMR2_SET(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) |  (v)))
#define HW_CCM_CSCMR2_CLR(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) & ~(v)))
#define HW_CCM_CSCMR2_TOG(x, v)  (HW_CCM_CSCMR2_WR(x, HW_CCM_CSCMR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCMR2 bitfields
 */

/*!
 * @name Register CCM_CSCMR2, field extern_audio_clk_sel[20:19] (RW)
 *
 * Selector for external audio clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll4 divided clock
 * - 01 - derive clock from 508M PFD clock
 * - 10 - derive clock from 454M PFD clock
 * - 11 - derive clock from pll3 clock
 */
/*@{*/
#define BP_CCM_CSCMR2_extern_audio_clk_sel (19U) /*!< Bit position for CCM_CSCMR2_extern_audio_clk_sel. */
#define BM_CCM_CSCMR2_extern_audio_clk_sel (0x00180000U) /*!< Bit mask for CCM_CSCMR2_extern_audio_clk_sel. */
#define BS_CCM_CSCMR2_extern_audio_clk_sel (2U) /*!< Bit field size in bits for CCM_CSCMR2_extern_audio_clk_sel. */

/*! @brief Read current value of the CCM_CSCMR2_extern_audio_clk_sel field. */
#define BR_CCM_CSCMR2_extern_audio_clk_sel(x) (HW_CCM_CSCMR2(x).B.extern_audio_clk_sel)

/*! @brief Format value for bitfield CCM_CSCMR2_extern_audio_clk_sel. */
#define BF_CCM_CSCMR2_extern_audio_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCMR2_extern_audio_clk_sel) & BM_CCM_CSCMR2_extern_audio_clk_sel)

/*! @brief Set the extern_audio_clk_sel field to a new value. */
#define BW_CCM_CSCMR2_extern_audio_clk_sel(x, v) (HW_CCM_CSCMR2_WR(x, (HW_CCM_CSCMR2_RD(x) & ~BM_CCM_CSCMR2_extern_audio_clk_sel) | BF_CCM_CSCMR2_extern_audio_clk_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR1 - CCM Serial Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00490B00U
 *
 * The figure below represents the CCM Serial Clock Divider Register 1 (CSCDR1).
 * The CSCDR1 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions. Any change on the
 * above dividers will have to be done while the module that its clock is affected
 * is not functional and the affected clock is gated. If the change will be done
 * during operation of the module, then it is not guaranteed that the modules
 * operation will not be harmed.
 */
typedef union _hw_ccm_cscdr1
{
    uint32_t U;
    struct _hw_ccm_cscdr1_bitfields
    {
        uint32_t uart_clk_podf : 6;    /*!< [5:0]  */
        uint32_t uart_clk_sel : 1;     /*!< [6]  */
        uint32_t RESERVED0 : 4;        /*!< [10:7]  */
        uint32_t usdhc1_podf : 3;      /*!< [13:11]  */
        uint32_t RESERVED1 : 2;        /*!< [15:14]  */
        uint32_t usdhc2_podf : 3;      /*!< [18:16]  */
        uint32_t usdhc3_podf : 3;      /*!< [21:19]  */
        uint32_t usdhc4_podf : 3;      /*!< [24:22]  */
        uint32_t RESERVED2 : 7;        /*!< [31:25]  */
    } B;
} hw_ccm_cscdr1_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR1 register
 */
/*@{*/
#define HW_CCM_CSCDR1_ADDR(x)    ((uintptr_t)(x) + 0x24U)

#define HW_CCM_CSCDR1(x)         (*(__IO hw_ccm_cscdr1_t *) HW_CCM_CSCDR1_ADDR(x))
#define HW_CCM_CSCDR1_RD(x)      (HW_CCM_CSCDR1(x).U)
#define HW_CCM_CSCDR1_WR(x, v)   (HW_CCM_CSCDR1(x).U = (v))
#define HW_CCM_CSCDR1_SET(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) |  (v)))
#define HW_CCM_CSCDR1_CLR(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) & ~(v)))
#define HW_CCM_CSCDR1_TOG(x, v)  (HW_CCM_CSCDR1_WR(x, HW_CCM_CSCDR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR1 bitfields
 */

/*!
 * @name Register CCM_CSCDR1, field uart_clk_podf[5:0] (RW)
 *
 * Divider for uart clock podf.
 *
 * Values:
 * - 000000 - divide by 1 (default)
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CSCDR1_uart_clk_podf (0U)   /*!< Bit position for CCM_CSCDR1_uart_clk_podf. */
#define BM_CCM_CSCDR1_uart_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CSCDR1_uart_clk_podf. */
#define BS_CCM_CSCDR1_uart_clk_podf (6U)   /*!< Bit field size in bits for CCM_CSCDR1_uart_clk_podf. */

/*! @brief Read current value of the CCM_CSCDR1_uart_clk_podf field. */
#define BR_CCM_CSCDR1_uart_clk_podf(x) (HW_CCM_CSCDR1(x).B.uart_clk_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_uart_clk_podf. */
#define BF_CCM_CSCDR1_uart_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_uart_clk_podf) & BM_CCM_CSCDR1_uart_clk_podf)

/*! @brief Set the uart_clk_podf field to a new value. */
#define BW_CCM_CSCDR1_uart_clk_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_uart_clk_podf) | BF_CCM_CSCDR1_uart_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field uart_clk_sel[6] (RW)
 *
 * Selector for the UART clock multiplexor
 *
 * Values:
 * - 0 - pll3_80m
 * - 1 - OSC clk
 */
/*@{*/
#define BP_CCM_CSCDR1_uart_clk_sel (6U)    /*!< Bit position for CCM_CSCDR1_uart_clk_sel. */
#define BM_CCM_CSCDR1_uart_clk_sel (0x00000040U) /*!< Bit mask for CCM_CSCDR1_uart_clk_sel. */
#define BS_CCM_CSCDR1_uart_clk_sel (1U)    /*!< Bit field size in bits for CCM_CSCDR1_uart_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR1_uart_clk_sel field. */
#define BR_CCM_CSCDR1_uart_clk_sel(x) (HW_CCM_CSCDR1(x).B.uart_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR1_uart_clk_sel. */
#define BF_CCM_CSCDR1_uart_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_uart_clk_sel) & BM_CCM_CSCDR1_uart_clk_sel)

/*! @brief Set the uart_clk_sel field to a new value. */
#define BW_CCM_CSCDR1_uart_clk_sel(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_uart_clk_sel) | BF_CCM_CSCDR1_uart_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc1_podf[13:11] (RW)
 *
 * Divider for usdhc1 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc1_podf (11U)    /*!< Bit position for CCM_CSCDR1_usdhc1_podf. */
#define BM_CCM_CSCDR1_usdhc1_podf (0x00003800U) /*!< Bit mask for CCM_CSCDR1_usdhc1_podf. */
#define BS_CCM_CSCDR1_usdhc1_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc1_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc1_podf field. */
#define BR_CCM_CSCDR1_usdhc1_podf(x) (HW_CCM_CSCDR1(x).B.usdhc1_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc1_podf. */
#define BF_CCM_CSCDR1_usdhc1_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc1_podf) & BM_CCM_CSCDR1_usdhc1_podf)

/*! @brief Set the usdhc1_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc1_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc1_podf) | BF_CCM_CSCDR1_usdhc1_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc2_podf[18:16] (RW)
 *
 * Divider for usdhc2 clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc2_podf (16U)    /*!< Bit position for CCM_CSCDR1_usdhc2_podf. */
#define BM_CCM_CSCDR1_usdhc2_podf (0x00070000U) /*!< Bit mask for CCM_CSCDR1_usdhc2_podf. */
#define BS_CCM_CSCDR1_usdhc2_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc2_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc2_podf field. */
#define BR_CCM_CSCDR1_usdhc2_podf(x) (HW_CCM_CSCDR1(x).B.usdhc2_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc2_podf. */
#define BF_CCM_CSCDR1_usdhc2_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc2_podf) & BM_CCM_CSCDR1_usdhc2_podf)

/*! @brief Set the usdhc2_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc2_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc2_podf) | BF_CCM_CSCDR1_usdhc2_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc3_podf[21:19] (RW)
 *
 * Divider for usdhc3 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc3_podf (19U)    /*!< Bit position for CCM_CSCDR1_usdhc3_podf. */
#define BM_CCM_CSCDR1_usdhc3_podf (0x00380000U) /*!< Bit mask for CCM_CSCDR1_usdhc3_podf. */
#define BS_CCM_CSCDR1_usdhc3_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc3_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc3_podf field. */
#define BR_CCM_CSCDR1_usdhc3_podf(x) (HW_CCM_CSCDR1(x).B.usdhc3_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc3_podf. */
#define BF_CCM_CSCDR1_usdhc3_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc3_podf) & BM_CCM_CSCDR1_usdhc3_podf)

/*! @brief Set the usdhc3_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc3_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc3_podf) | BF_CCM_CSCDR1_usdhc3_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR1, field usdhc4_podf[24:22] (RW)
 *
 * Divider for esdhc4 clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR1_usdhc4_podf (22U)    /*!< Bit position for CCM_CSCDR1_usdhc4_podf. */
#define BM_CCM_CSCDR1_usdhc4_podf (0x01C00000U) /*!< Bit mask for CCM_CSCDR1_usdhc4_podf. */
#define BS_CCM_CSCDR1_usdhc4_podf (3U)     /*!< Bit field size in bits for CCM_CSCDR1_usdhc4_podf. */

/*! @brief Read current value of the CCM_CSCDR1_usdhc4_podf field. */
#define BR_CCM_CSCDR1_usdhc4_podf(x) (HW_CCM_CSCDR1(x).B.usdhc4_podf)

/*! @brief Format value for bitfield CCM_CSCDR1_usdhc4_podf. */
#define BF_CCM_CSCDR1_usdhc4_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR1_usdhc4_podf) & BM_CCM_CSCDR1_usdhc4_podf)

/*! @brief Set the usdhc4_podf field to a new value. */
#define BW_CCM_CSCDR1_usdhc4_podf(x, v) (HW_CCM_CSCDR1_WR(x, (HW_CCM_CSCDR1_RD(x) & ~BM_CCM_CSCDR1_usdhc4_podf) | BF_CCM_CSCDR1_usdhc4_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CS1CDR - CCM SSI1 Clock Divider Register (RW)
 *
 * Reset value: 0x0EC102C1U
 *
 * The figure below represents the CCM SSI1, SSI3, ESAI Clock Divider Register
 * (CS1CDR). The CS1CDR register contains bits to control the ssi1 clock
 * generation dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cs1cdr
{
    uint32_t U;
    struct _hw_ccm_cs1cdr_bitfields
    {
        uint32_t ssi1_clk_podf : 6;    /*!< [5:0]  */
        uint32_t ssi1_clk_pred : 3;    /*!< [8:6]  */
        uint32_t extern_audio_clk_pred : 3; /*!< [11:9]  */
        uint32_t RESERVED0 : 4;        /*!< [15:12]  */
        uint32_t ssi3_clk_podf : 6;    /*!< [21:16]  */
        uint32_t ssi3_clk_pred : 3;    /*!< [24:22]  */
        uint32_t extern_audio_clk_podf : 3; /*!< [27:25]  */
        uint32_t RESERVED1 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_cs1cdr_t;

/*!
 * @name Constants and macros for entire CCM_CS1CDR register
 */
/*@{*/
#define HW_CCM_CS1CDR_ADDR(x)    ((uintptr_t)(x) + 0x28U)

#define HW_CCM_CS1CDR(x)         (*(__IO hw_ccm_cs1cdr_t *) HW_CCM_CS1CDR_ADDR(x))
#define HW_CCM_CS1CDR_RD(x)      (HW_CCM_CS1CDR(x).U)
#define HW_CCM_CS1CDR_WR(x, v)   (HW_CCM_CS1CDR(x).U = (v))
#define HW_CCM_CS1CDR_SET(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) |  (v)))
#define HW_CCM_CS1CDR_CLR(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) & ~(v)))
#define HW_CCM_CS1CDR_TOG(x, v)  (HW_CCM_CS1CDR_WR(x, HW_CCM_CS1CDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CS1CDR bitfields
 */

/*!
 * @name Register CCM_CS1CDR, field ssi1_clk_podf[5:0] (RW)
 *
 * Divider for ssi1 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi1_clk_podf (0U)   /*!< Bit position for CCM_CS1CDR_ssi1_clk_podf. */
#define BM_CCM_CS1CDR_ssi1_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CS1CDR_ssi1_clk_podf. */
#define BS_CCM_CS1CDR_ssi1_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi1_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_ssi1_clk_podf field. */
#define BR_CCM_CS1CDR_ssi1_clk_podf(x) (HW_CCM_CS1CDR(x).B.ssi1_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi1_clk_podf. */
#define BF_CCM_CS1CDR_ssi1_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi1_clk_podf) & BM_CCM_CS1CDR_ssi1_clk_podf)

/*! @brief Set the ssi1_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_ssi1_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi1_clk_podf) | BF_CCM_CS1CDR_ssi1_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi1_clk_pred[8:6] (RW)
 *
 * Divider for ssi1 clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi1_clk_pred (6U)   /*!< Bit position for CCM_CS1CDR_ssi1_clk_pred. */
#define BM_CCM_CS1CDR_ssi1_clk_pred (0x000001C0U) /*!< Bit mask for CCM_CS1CDR_ssi1_clk_pred. */
#define BS_CCM_CS1CDR_ssi1_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi1_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_ssi1_clk_pred field. */
#define BR_CCM_CS1CDR_ssi1_clk_pred(x) (HW_CCM_CS1CDR(x).B.ssi1_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi1_clk_pred. */
#define BF_CCM_CS1CDR_ssi1_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi1_clk_pred) & BM_CCM_CS1CDR_ssi1_clk_pred)

/*! @brief Set the ssi1_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_ssi1_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi1_clk_pred) | BF_CCM_CS1CDR_ssi1_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field extern_audio_clk_pred[11:9] (RW)
 *
 * Divider for external audio clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_extern_audio_clk_pred (9U) /*!< Bit position for CCM_CS1CDR_extern_audio_clk_pred. */
#define BM_CCM_CS1CDR_extern_audio_clk_pred (0x00000E00U) /*!< Bit mask for CCM_CS1CDR_extern_audio_clk_pred. */
#define BS_CCM_CS1CDR_extern_audio_clk_pred (3U) /*!< Bit field size in bits for CCM_CS1CDR_extern_audio_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_extern_audio_clk_pred field. */
#define BR_CCM_CS1CDR_extern_audio_clk_pred(x) (HW_CCM_CS1CDR(x).B.extern_audio_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_extern_audio_clk_pred. */
#define BF_CCM_CS1CDR_extern_audio_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_extern_audio_clk_pred) & BM_CCM_CS1CDR_extern_audio_clk_pred)

/*! @brief Set the extern_audio_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_extern_audio_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_extern_audio_clk_pred) | BF_CCM_CS1CDR_extern_audio_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi3_clk_podf[21:16] (RW)
 *
 * Divider for ssi3 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi3_clk_podf (16U)  /*!< Bit position for CCM_CS1CDR_ssi3_clk_podf. */
#define BM_CCM_CS1CDR_ssi3_clk_podf (0x003F0000U) /*!< Bit mask for CCM_CS1CDR_ssi3_clk_podf. */
#define BS_CCM_CS1CDR_ssi3_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi3_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_ssi3_clk_podf field. */
#define BR_CCM_CS1CDR_ssi3_clk_podf(x) (HW_CCM_CS1CDR(x).B.ssi3_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi3_clk_podf. */
#define BF_CCM_CS1CDR_ssi3_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi3_clk_podf) & BM_CCM_CS1CDR_ssi3_clk_podf)

/*! @brief Set the ssi3_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_ssi3_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi3_clk_podf) | BF_CCM_CS1CDR_ssi3_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field ssi3_clk_pred[24:22] (RW)
 *
 * Divider for ssi3 clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_ssi3_clk_pred (22U)  /*!< Bit position for CCM_CS1CDR_ssi3_clk_pred. */
#define BM_CCM_CS1CDR_ssi3_clk_pred (0x01C00000U) /*!< Bit mask for CCM_CS1CDR_ssi3_clk_pred. */
#define BS_CCM_CS1CDR_ssi3_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS1CDR_ssi3_clk_pred. */

/*! @brief Read current value of the CCM_CS1CDR_ssi3_clk_pred field. */
#define BR_CCM_CS1CDR_ssi3_clk_pred(x) (HW_CCM_CS1CDR(x).B.ssi3_clk_pred)

/*! @brief Format value for bitfield CCM_CS1CDR_ssi3_clk_pred. */
#define BF_CCM_CS1CDR_ssi3_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_ssi3_clk_pred) & BM_CCM_CS1CDR_ssi3_clk_pred)

/*! @brief Set the ssi3_clk_pred field to a new value. */
#define BW_CCM_CS1CDR_ssi3_clk_pred(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_ssi3_clk_pred) | BF_CCM_CS1CDR_ssi3_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS1CDR, field extern_audio_clk_podf[27:25] (RW)
 *
 * Divider for external audio clock podf.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS1CDR_extern_audio_clk_podf (25U) /*!< Bit position for CCM_CS1CDR_extern_audio_clk_podf. */
#define BM_CCM_CS1CDR_extern_audio_clk_podf (0x0E000000U) /*!< Bit mask for CCM_CS1CDR_extern_audio_clk_podf. */
#define BS_CCM_CS1CDR_extern_audio_clk_podf (3U) /*!< Bit field size in bits for CCM_CS1CDR_extern_audio_clk_podf. */

/*! @brief Read current value of the CCM_CS1CDR_extern_audio_clk_podf field. */
#define BR_CCM_CS1CDR_extern_audio_clk_podf(x) (HW_CCM_CS1CDR(x).B.extern_audio_clk_podf)

/*! @brief Format value for bitfield CCM_CS1CDR_extern_audio_clk_podf. */
#define BF_CCM_CS1CDR_extern_audio_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS1CDR_extern_audio_clk_podf) & BM_CCM_CS1CDR_extern_audio_clk_podf)

/*! @brief Set the extern_audio_clk_podf field to a new value. */
#define BW_CCM_CS1CDR_extern_audio_clk_podf(x, v) (HW_CCM_CS1CDR_WR(x, (HW_CCM_CS1CDR_RD(x) & ~BM_CCM_CS1CDR_extern_audio_clk_podf) | BF_CCM_CS1CDR_extern_audio_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CS2CDR - CCM SSI2 Clock Divider Register (RW)
 *
 * Reset value: 0x000736C1U
 *
 * The figure below represents the CCM SSI2, LDB Clock Divider Register
 * (CS2CDR). The CS2CDR register contains bits to control the ssi2 clock generation
 * dividers, and ldb serial clocks select. The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_cs2cdr
{
    uint32_t U;
    struct _hw_ccm_cs2cdr_bitfields
    {
        uint32_t ssi2_clk_podf : 6;    /*!< [5:0]  */
        uint32_t ssi2_clk_pred : 3;    /*!< [8:6]  */
        uint32_t ldb_di0_clk_sel : 3;  /*!< [11:9]  */
        uint32_t ldb_di1_clk_sel : 3;  /*!< [14:12]  */
        uint32_t RESERVED0 : 17;       /*!< [31:15]  */
    } B;
} hw_ccm_cs2cdr_t;

/*!
 * @name Constants and macros for entire CCM_CS2CDR register
 */
/*@{*/
#define HW_CCM_CS2CDR_ADDR(x)    ((uintptr_t)(x) + 0x2CU)

#define HW_CCM_CS2CDR(x)         (*(__IO hw_ccm_cs2cdr_t *) HW_CCM_CS2CDR_ADDR(x))
#define HW_CCM_CS2CDR_RD(x)      (HW_CCM_CS2CDR(x).U)
#define HW_CCM_CS2CDR_WR(x, v)   (HW_CCM_CS2CDR(x).U = (v))
#define HW_CCM_CS2CDR_SET(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) |  (v)))
#define HW_CCM_CS2CDR_CLR(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) & ~(v)))
#define HW_CCM_CS2CDR_TOG(x, v)  (HW_CCM_CS2CDR_WR(x, HW_CCM_CS2CDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CS2CDR bitfields
 */

/*!
 * @name Register CCM_CS2CDR, field ssi2_clk_podf[5:0] (RW)
 *
 * Divider for ssi2 clock podf. The input clock to this divider should be lower
 * than 300Mhz, the predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CS2CDR_ssi2_clk_podf (0U)   /*!< Bit position for CCM_CS2CDR_ssi2_clk_podf. */
#define BM_CCM_CS2CDR_ssi2_clk_podf (0x0000003FU) /*!< Bit mask for CCM_CS2CDR_ssi2_clk_podf. */
#define BS_CCM_CS2CDR_ssi2_clk_podf (6U)   /*!< Bit field size in bits for CCM_CS2CDR_ssi2_clk_podf. */

/*! @brief Read current value of the CCM_CS2CDR_ssi2_clk_podf field. */
#define BR_CCM_CS2CDR_ssi2_clk_podf(x) (HW_CCM_CS2CDR(x).B.ssi2_clk_podf)

/*! @brief Format value for bitfield CCM_CS2CDR_ssi2_clk_podf. */
#define BF_CCM_CS2CDR_ssi2_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ssi2_clk_podf) & BM_CCM_CS2CDR_ssi2_clk_podf)

/*! @brief Set the ssi2_clk_podf field to a new value. */
#define BW_CCM_CS2CDR_ssi2_clk_podf(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ssi2_clk_podf) | BF_CCM_CS2CDR_ssi2_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ssi2_clk_pred[8:6] (RW)
 *
 * Divider for ssi2 clock pred.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CS2CDR_ssi2_clk_pred (6U)   /*!< Bit position for CCM_CS2CDR_ssi2_clk_pred. */
#define BM_CCM_CS2CDR_ssi2_clk_pred (0x000001C0U) /*!< Bit mask for CCM_CS2CDR_ssi2_clk_pred. */
#define BS_CCM_CS2CDR_ssi2_clk_pred (3U)   /*!< Bit field size in bits for CCM_CS2CDR_ssi2_clk_pred. */

/*! @brief Read current value of the CCM_CS2CDR_ssi2_clk_pred field. */
#define BR_CCM_CS2CDR_ssi2_clk_pred(x) (HW_CCM_CS2CDR(x).B.ssi2_clk_pred)

/*! @brief Format value for bitfield CCM_CS2CDR_ssi2_clk_pred. */
#define BF_CCM_CS2CDR_ssi2_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ssi2_clk_pred) & BM_CCM_CS2CDR_ssi2_clk_pred)

/*! @brief Set the ssi2_clk_pred field to a new value. */
#define BW_CCM_CS2CDR_ssi2_clk_pred(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ssi2_clk_pred) | BF_CCM_CS2CDR_ssi2_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ldb_di0_clk_sel[11:9] (RW)
 *
 * Selector for ldb_di1 clock multiplexer
 *
 * Values:
 * - 000 - pll5 clock
 * - 001 - pll2 352M PFD (default)
 * - 010 - pll2 396M PFD
 * - 011 - MMDC_ROOT clock
 * - 100 - pll3 clock
 * - 101 - 111 Resrticted
 */
/*@{*/
#define BP_CCM_CS2CDR_ldb_di0_clk_sel (9U) /*!< Bit position for CCM_CS2CDR_ldb_di0_clk_sel. */
#define BM_CCM_CS2CDR_ldb_di0_clk_sel (0x00000E00U) /*!< Bit mask for CCM_CS2CDR_ldb_di0_clk_sel. */
#define BS_CCM_CS2CDR_ldb_di0_clk_sel (3U) /*!< Bit field size in bits for CCM_CS2CDR_ldb_di0_clk_sel. */

/*! @brief Read current value of the CCM_CS2CDR_ldb_di0_clk_sel field. */
#define BR_CCM_CS2CDR_ldb_di0_clk_sel(x) (HW_CCM_CS2CDR(x).B.ldb_di0_clk_sel)

/*! @brief Format value for bitfield CCM_CS2CDR_ldb_di0_clk_sel. */
#define BF_CCM_CS2CDR_ldb_di0_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ldb_di0_clk_sel) & BM_CCM_CS2CDR_ldb_di0_clk_sel)

/*! @brief Set the ldb_di0_clk_sel field to a new value. */
#define BW_CCM_CS2CDR_ldb_di0_clk_sel(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ldb_di0_clk_sel) | BF_CCM_CS2CDR_ldb_di0_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CS2CDR, field ldb_di1_clk_sel[14:12] (RW)
 *
 * Selector for ldb_di1 clock multiplexer
 *
 * Values:
 * - 000 - pll5 clock
 * - 001 - pll2 352M PFD (default)
 * - 010 - pll2 396M PFD
 * - 011 - MMDC_ROOT clock
 * - 100 - pll3 clock
 * - 101 - 111 Resrticted
 */
/*@{*/
#define BP_CCM_CS2CDR_ldb_di1_clk_sel (12U) /*!< Bit position for CCM_CS2CDR_ldb_di1_clk_sel. */
#define BM_CCM_CS2CDR_ldb_di1_clk_sel (0x00007000U) /*!< Bit mask for CCM_CS2CDR_ldb_di1_clk_sel. */
#define BS_CCM_CS2CDR_ldb_di1_clk_sel (3U) /*!< Bit field size in bits for CCM_CS2CDR_ldb_di1_clk_sel. */

/*! @brief Read current value of the CCM_CS2CDR_ldb_di1_clk_sel field. */
#define BR_CCM_CS2CDR_ldb_di1_clk_sel(x) (HW_CCM_CS2CDR(x).B.ldb_di1_clk_sel)

/*! @brief Format value for bitfield CCM_CS2CDR_ldb_di1_clk_sel. */
#define BF_CCM_CS2CDR_ldb_di1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CS2CDR_ldb_di1_clk_sel) & BM_CCM_CS2CDR_ldb_di1_clk_sel)

/*! @brief Set the ldb_di1_clk_sel field to a new value. */
#define BW_CCM_CS2CDR_ldb_di1_clk_sel(x, v) (HW_CCM_CS2CDR_WR(x, (HW_CCM_CS2CDR_RD(x) & ~BM_CCM_CS2CDR_ldb_di1_clk_sel) | BF_CCM_CS2CDR_ldb_di1_clk_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CDCDR - CCM D1 Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CDCDR - CCM D1 Clock Divider Register (RW)
 *
 * Reset value: 0x33F71F92U
 *
 * The figure below represents the CCM DI Clock Divider Register (CDCDR). The
 * table below provides its field descriptions.
 */
typedef union _hw_ccm_cdcdr
{
    uint32_t U;
    struct _hw_ccm_cdcdr_bitfields
    {
        uint32_t RESERVED0 : 7;        /*!< [6:0]  */
        uint32_t spdif1_clk_sel : 2;   /*!< [8:7]  */
        uint32_t spdif1_clk_podf : 3;  /*!< [11:9]  */
        uint32_t spdif1_clk_pred : 3;  /*!< [14:12]  */
        uint32_t RESERVED1 : 5;        /*!< [19:15]  */
        uint32_t spdif0_clk_sel : 2;   /*!< [21:20]  */
        uint32_t spdif0_clk_podf : 3;  /*!< [24:22]  */
        uint32_t spdif0_clk_pred : 3;  /*!< [27:25]  */
        uint32_t RESERVED2 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_cdcdr_t;

/*!
 * @name Constants and macros for entire CCM_CDCDR register
 */
/*@{*/
#define HW_CCM_CDCDR_ADDR(x)     ((uintptr_t)(x) + 0x30U)

#define HW_CCM_CDCDR(x)          (*(__IO hw_ccm_cdcdr_t *) HW_CCM_CDCDR_ADDR(x))
#define HW_CCM_CDCDR_RD(x)       (HW_CCM_CDCDR(x).U)
#define HW_CCM_CDCDR_WR(x, v)    (HW_CCM_CDCDR(x).U = (v))
#define HW_CCM_CDCDR_SET(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) |  (v)))
#define HW_CCM_CDCDR_CLR(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) & ~(v)))
#define HW_CCM_CDCDR_TOG(x, v)   (HW_CCM_CDCDR_WR(x, HW_CCM_CDCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CDCDR bitfields
 */

/*!
 * @name Register CCM_CDCDR, field spdif1_clk_sel[8:7] (RW)
 *
 * Selector for spdif1 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll4 divided clock
 * - 01 - derive clock from 508M PFD clock
 * - 10 - derive clock from 454M PFD clock
 * - 11 - derive clock from pll3 clock
 */
/*@{*/
#define BP_CCM_CDCDR_spdif1_clk_sel (7U)   /*!< Bit position for CCM_CDCDR_spdif1_clk_sel. */
#define BM_CCM_CDCDR_spdif1_clk_sel (0x00000180U) /*!< Bit mask for CCM_CDCDR_spdif1_clk_sel. */
#define BS_CCM_CDCDR_spdif1_clk_sel (2U)   /*!< Bit field size in bits for CCM_CDCDR_spdif1_clk_sel. */

/*! @brief Read current value of the CCM_CDCDR_spdif1_clk_sel field. */
#define BR_CCM_CDCDR_spdif1_clk_sel(x) (HW_CCM_CDCDR(x).B.spdif1_clk_sel)

/*! @brief Format value for bitfield CCM_CDCDR_spdif1_clk_sel. */
#define BF_CCM_CDCDR_spdif1_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif1_clk_sel) & BM_CCM_CDCDR_spdif1_clk_sel)

/*! @brief Set the spdif1_clk_sel field to a new value. */
#define BW_CCM_CDCDR_spdif1_clk_sel(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif1_clk_sel) | BF_CCM_CDCDR_spdif1_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif1_clk_podf[11:9] (RW)
 *
 * Divider for spdif1 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif1_clk_podf (9U)  /*!< Bit position for CCM_CDCDR_spdif1_clk_podf. */
#define BM_CCM_CDCDR_spdif1_clk_podf (0x00000E00U) /*!< Bit mask for CCM_CDCDR_spdif1_clk_podf. */
#define BS_CCM_CDCDR_spdif1_clk_podf (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif1_clk_podf. */

/*! @brief Read current value of the CCM_CDCDR_spdif1_clk_podf field. */
#define BR_CCM_CDCDR_spdif1_clk_podf(x) (HW_CCM_CDCDR(x).B.spdif1_clk_podf)

/*! @brief Format value for bitfield CCM_CDCDR_spdif1_clk_podf. */
#define BF_CCM_CDCDR_spdif1_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif1_clk_podf) & BM_CCM_CDCDR_spdif1_clk_podf)

/*! @brief Set the spdif1_clk_podf field to a new value. */
#define BW_CCM_CDCDR_spdif1_clk_podf(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif1_clk_podf) | BF_CCM_CDCDR_spdif1_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif1_clk_pred[14:12] (RW)
 *
 * Divider for spdif1 clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1 (do not use with high input frequencies)
 * - 001 - divide by 2
 * - 010 - divide by 3 (default)
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif1_clk_pred (12U) /*!< Bit position for CCM_CDCDR_spdif1_clk_pred. */
#define BM_CCM_CDCDR_spdif1_clk_pred (0x00007000U) /*!< Bit mask for CCM_CDCDR_spdif1_clk_pred. */
#define BS_CCM_CDCDR_spdif1_clk_pred (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif1_clk_pred. */

/*! @brief Read current value of the CCM_CDCDR_spdif1_clk_pred field. */
#define BR_CCM_CDCDR_spdif1_clk_pred(x) (HW_CCM_CDCDR(x).B.spdif1_clk_pred)

/*! @brief Format value for bitfield CCM_CDCDR_spdif1_clk_pred. */
#define BF_CCM_CDCDR_spdif1_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif1_clk_pred) & BM_CCM_CDCDR_spdif1_clk_pred)

/*! @brief Set the spdif1_clk_pred field to a new value. */
#define BW_CCM_CDCDR_spdif1_clk_pred(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif1_clk_pred) | BF_CCM_CDCDR_spdif1_clk_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_sel[21:20] (RW)
 *
 * Selector for spdif0 clock multiplexer
 *
 * Values:
 * - 00 - derive clock from pll4 divided clock
 * - 01 - derive clock from 508M PFD clock
 * - 10 - derive clock from 454M PFD clock
 * - 11 - derive clock from pll3 clock
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_sel (20U)  /*!< Bit position for CCM_CDCDR_spdif0_clk_sel. */
#define BM_CCM_CDCDR_spdif0_clk_sel (0x00300000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_sel. */
#define BS_CCM_CDCDR_spdif0_clk_sel (2U)   /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_sel. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_sel field. */
#define BR_CCM_CDCDR_spdif0_clk_sel(x) (HW_CCM_CDCDR(x).B.spdif0_clk_sel)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_sel. */
#define BF_CCM_CDCDR_spdif0_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_sel) & BM_CCM_CDCDR_spdif0_clk_sel)

/*! @brief Set the spdif0_clk_sel field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_sel(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_sel) | BF_CCM_CDCDR_spdif0_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_podf[24:22] (RW)
 *
 * Divider for spdif0 clock podf. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_podf (22U) /*!< Bit position for CCM_CDCDR_spdif0_clk_podf. */
#define BM_CCM_CDCDR_spdif0_clk_podf (0x01C00000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_podf. */
#define BS_CCM_CDCDR_spdif0_clk_podf (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_podf. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_podf field. */
#define BR_CCM_CDCDR_spdif0_clk_podf(x) (HW_CCM_CDCDR(x).B.spdif0_clk_podf)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_podf. */
#define BF_CCM_CDCDR_spdif0_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_podf) & BM_CCM_CDCDR_spdif0_clk_podf)

/*! @brief Set the spdif0_clk_podf field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_podf(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_podf) | BF_CCM_CDCDR_spdif0_clk_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CDCDR, field spdif0_clk_pred[27:25] (RW)
 *
 * Divider for spdif0 clock pred. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1 (do not use with high input frequencies)
 * - 001 - divide by 2
 * - 010 - divide by 3 (default)
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CDCDR_spdif0_clk_pred (25U) /*!< Bit position for CCM_CDCDR_spdif0_clk_pred. */
#define BM_CCM_CDCDR_spdif0_clk_pred (0x0E000000U) /*!< Bit mask for CCM_CDCDR_spdif0_clk_pred. */
#define BS_CCM_CDCDR_spdif0_clk_pred (3U)  /*!< Bit field size in bits for CCM_CDCDR_spdif0_clk_pred. */

/*! @brief Read current value of the CCM_CDCDR_spdif0_clk_pred field. */
#define BR_CCM_CDCDR_spdif0_clk_pred(x) (HW_CCM_CDCDR(x).B.spdif0_clk_pred)

/*! @brief Format value for bitfield CCM_CDCDR_spdif0_clk_pred. */
#define BF_CCM_CDCDR_spdif0_clk_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CDCDR_spdif0_clk_pred) & BM_CCM_CDCDR_spdif0_clk_pred)

/*! @brief Set the spdif0_clk_pred field to a new value. */
#define BW_CCM_CDCDR_spdif0_clk_pred(x, v) (HW_CCM_CDCDR_WR(x, (HW_CCM_CDCDR_RD(x) & ~BM_CCM_CDCDR_spdif0_clk_pred) | BF_CCM_CDCDR_spdif0_clk_pred(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CHSCCDR - CCM HSC Clock Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CHSCCDR - CCM HSC Clock Divider Register (RW)
 *
 * Reset value: 0x0002A150U
 *
 * The figure below represents the CCM HSC Clock Divider Register (CHSCCDR). The
 * CHSCCDR register contains bits to control the EPDC (SiPix) and PXP clock
 * generation dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_chsccdr
{
    uint32_t U;
    struct _hw_ccm_chsccdr_bitfields
    {
        uint32_t RESERVED0 : 3;        /*!< [2:0]  */
        uint32_t pxp_axi_podf : 3;     /*!< [5:3]  */
        uint32_t pxp_axi_clk_sel : 3;  /*!< [8:6]  */
        uint32_t RESERVED1 : 3;        /*!< [11:9]  */
        uint32_t epdc_axi_podf : 3;    /*!< [14:12]  */
        uint32_t epdc_axi_clk_sel : 3; /*!< [17:15]  */
        uint32_t RESERVED2 : 14;       /*!< [31:18]  */
    } B;
} hw_ccm_chsccdr_t;

/*!
 * @name Constants and macros for entire CCM_CHSCCDR register
 */
/*@{*/
#define HW_CCM_CHSCCDR_ADDR(x)   ((uintptr_t)(x) + 0x34U)

#define HW_CCM_CHSCCDR(x)        (*(__IO hw_ccm_chsccdr_t *) HW_CCM_CHSCCDR_ADDR(x))
#define HW_CCM_CHSCCDR_RD(x)     (HW_CCM_CHSCCDR(x).U)
#define HW_CCM_CHSCCDR_WR(x, v)  (HW_CCM_CHSCCDR(x).U = (v))
#define HW_CCM_CHSCCDR_SET(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) |  (v)))
#define HW_CCM_CHSCCDR_CLR(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) & ~(v)))
#define HW_CCM_CHSCCDR_TOG(x, v) (HW_CCM_CHSCCDR_WR(x, HW_CCM_CHSCCDR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CHSCCDR bitfields
 */

/*!
 * @name Register CCM_CHSCCDR, field pxp_axi_podf[5:3] (RW)
 *
 * Divider for pxp_axi clock divider. Divider should be updated when output
 * clock is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3 (default)
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CHSCCDR_pxp_axi_podf (3U)   /*!< Bit position for CCM_CHSCCDR_pxp_axi_podf. */
#define BM_CCM_CHSCCDR_pxp_axi_podf (0x00000038U) /*!< Bit mask for CCM_CHSCCDR_pxp_axi_podf. */
#define BS_CCM_CHSCCDR_pxp_axi_podf (3U)   /*!< Bit field size in bits for CCM_CHSCCDR_pxp_axi_podf. */

/*! @brief Read current value of the CCM_CHSCCDR_pxp_axi_podf field. */
#define BR_CCM_CHSCCDR_pxp_axi_podf(x) (HW_CCM_CHSCCDR(x).B.pxp_axi_podf)

/*! @brief Format value for bitfield CCM_CHSCCDR_pxp_axi_podf. */
#define BF_CCM_CHSCCDR_pxp_axi_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_pxp_axi_podf) & BM_CCM_CHSCCDR_pxp_axi_podf)

/*! @brief Set the pxp_axi_podf field to a new value. */
#define BW_CCM_CHSCCDR_pxp_axi_podf(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_pxp_axi_podf) | BF_CCM_CHSCCDR_pxp_axi_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field pxp_axi_clk_sel[8:6] (RW)
 *
 * Selector for pxp_axi root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from mmdc_ch0 clock
 * - 001 - derive clock from pll3
 * - 010 - derive clock from pll5
 * - 011 - derive clock from 352M PFD
 * - 100 - derive clock from 396M PFD
 * - 101 - derive clock from 540M PFD
 */
/*@{*/
#define BP_CCM_CHSCCDR_pxp_axi_clk_sel (6U) /*!< Bit position for CCM_CHSCCDR_pxp_axi_clk_sel. */
#define BM_CCM_CHSCCDR_pxp_axi_clk_sel (0x000001C0U) /*!< Bit mask for CCM_CHSCCDR_pxp_axi_clk_sel. */
#define BS_CCM_CHSCCDR_pxp_axi_clk_sel (3U) /*!< Bit field size in bits for CCM_CHSCCDR_pxp_axi_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_pxp_axi_clk_sel field. */
#define BR_CCM_CHSCCDR_pxp_axi_clk_sel(x) (HW_CCM_CHSCCDR(x).B.pxp_axi_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_pxp_axi_clk_sel. */
#define BF_CCM_CHSCCDR_pxp_axi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_pxp_axi_clk_sel) & BM_CCM_CHSCCDR_pxp_axi_clk_sel)

/*! @brief Set the pxp_axi_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_pxp_axi_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_pxp_axi_clk_sel) | BF_CCM_CHSCCDR_pxp_axi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field epdc_axi_podf[14:12] (RW)
 *
 * Divider for epdc_axi (SiPix) clock divider. Divider should be updated when
 * output clock is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3 (default)
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CHSCCDR_epdc_axi_podf (12U) /*!< Bit position for CCM_CHSCCDR_epdc_axi_podf. */
#define BM_CCM_CHSCCDR_epdc_axi_podf (0x00007000U) /*!< Bit mask for CCM_CHSCCDR_epdc_axi_podf. */
#define BS_CCM_CHSCCDR_epdc_axi_podf (3U)  /*!< Bit field size in bits for CCM_CHSCCDR_epdc_axi_podf. */

/*! @brief Read current value of the CCM_CHSCCDR_epdc_axi_podf field. */
#define BR_CCM_CHSCCDR_epdc_axi_podf(x) (HW_CCM_CHSCCDR(x).B.epdc_axi_podf)

/*! @brief Format value for bitfield CCM_CHSCCDR_epdc_axi_podf. */
#define BF_CCM_CHSCCDR_epdc_axi_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_epdc_axi_podf) & BM_CCM_CHSCCDR_epdc_axi_podf)

/*! @brief Set the epdc_axi_podf field to a new value. */
#define BW_CCM_CHSCCDR_epdc_axi_podf(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_epdc_axi_podf) | BF_CCM_CHSCCDR_epdc_axi_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CHSCCDR, field epdc_axi_clk_sel[17:15] (RW)
 *
 * Selector for epdc_axi (SiPix) root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from mmdc_ch0 clock
 * - 001 - derive clock from pll3
 * - 010 - derive clock from pll5
 * - 011 - derive clock from 352M PFD
 * - 100 - derive clock from 396M PFD
 * - 101 - derive clock from 540M PFD
 */
/*@{*/
#define BP_CCM_CHSCCDR_epdc_axi_clk_sel (15U) /*!< Bit position for CCM_CHSCCDR_epdc_axi_clk_sel. */
#define BM_CCM_CHSCCDR_epdc_axi_clk_sel (0x00038000U) /*!< Bit mask for CCM_CHSCCDR_epdc_axi_clk_sel. */
#define BS_CCM_CHSCCDR_epdc_axi_clk_sel (3U) /*!< Bit field size in bits for CCM_CHSCCDR_epdc_axi_clk_sel. */

/*! @brief Read current value of the CCM_CHSCCDR_epdc_axi_clk_sel field. */
#define BR_CCM_CHSCCDR_epdc_axi_clk_sel(x) (HW_CCM_CHSCCDR(x).B.epdc_axi_clk_sel)

/*! @brief Format value for bitfield CCM_CHSCCDR_epdc_axi_clk_sel. */
#define BF_CCM_CHSCCDR_epdc_axi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CHSCCDR_epdc_axi_clk_sel) & BM_CCM_CHSCCDR_epdc_axi_clk_sel)

/*! @brief Set the epdc_axi_clk_sel field to a new value. */
#define BW_CCM_CHSCCDR_epdc_axi_clk_sel(x, v) (HW_CCM_CHSCCDR_WR(x, (HW_CCM_CHSCCDR_RD(x) & ~BM_CCM_CHSCCDR_epdc_axi_clk_sel) | BF_CCM_CHSCCDR_epdc_axi_clk_sel(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR2 - CCM Serial Clock Divider Register 2 (RW)
 *
 * Reset value: 0x00029B48U
 *
 * The figure below represents the CCM Serial Clock Divider Register 2(CSCDR2).
 * The CSCDR2 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cscdr2
{
    uint32_t U;
    struct _hw_ccm_cscdr2_bitfields
    {
        uint32_t RESERVED0 : 3;        /*!< [2:0]  */
        uint32_t lcdif_pix_pred : 3;   /*!< [5:3]  */
        uint32_t lcdif_pix_clk_sel : 3; /*!< [8:6]  */
        uint32_t RESERVED1 : 3;        /*!< [11:9]  */
        uint32_t epdc_pix_pred : 3;    /*!< [14:12]  */
        uint32_t epdc_pix_clk_sel : 3; /*!< [17:15]  */
        uint32_t ecspi_clk_sel : 1;    /*!< [18]  */
        uint32_t ecspi_clk_podf : 6;   /*!< [24:19]  */
        uint32_t RESERVED2 : 7;        /*!< [31:25]  */
    } B;
} hw_ccm_cscdr2_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR2 register
 */
/*@{*/
#define HW_CCM_CSCDR2_ADDR(x)    ((uintptr_t)(x) + 0x38U)

#define HW_CCM_CSCDR2(x)         (*(__IO hw_ccm_cscdr2_t *) HW_CCM_CSCDR2_ADDR(x))
#define HW_CCM_CSCDR2_RD(x)      (HW_CCM_CSCDR2(x).U)
#define HW_CCM_CSCDR2_WR(x, v)   (HW_CCM_CSCDR2(x).U = (v))
#define HW_CCM_CSCDR2_SET(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) |  (v)))
#define HW_CCM_CSCDR2_CLR(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) & ~(v)))
#define HW_CCM_CSCDR2_TOG(x, v)  (HW_CCM_CSCDR2_WR(x, HW_CCM_CSCDR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR2 bitfields
 */

/*!
 * @name Register CCM_CSCDR2, field lcdif_pix_pred[5:3] (RW)
 *
 * Divider for lcdif_pix clock divider. Divider should be updated when output
 * clock is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8 (default)
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif_pix_pred (3U)  /*!< Bit position for CCM_CSCDR2_lcdif_pix_pred. */
#define BM_CCM_CSCDR2_lcdif_pix_pred (0x00000038U) /*!< Bit mask for CCM_CSCDR2_lcdif_pix_pred. */
#define BS_CCM_CSCDR2_lcdif_pix_pred (3U)  /*!< Bit field size in bits for CCM_CSCDR2_lcdif_pix_pred. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif_pix_pred field. */
#define BR_CCM_CSCDR2_lcdif_pix_pred(x) (HW_CCM_CSCDR2(x).B.lcdif_pix_pred)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif_pix_pred. */
#define BF_CCM_CSCDR2_lcdif_pix_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif_pix_pred) & BM_CCM_CSCDR2_lcdif_pix_pred)

/*! @brief Set the lcdif_pix_pred field to a new value. */
#define BW_CCM_CSCDR2_lcdif_pix_pred(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif_pix_pred) | BF_CCM_CSCDR2_lcdif_pix_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field lcdif_pix_clk_sel[8:6] (RW)
 *
 * Selector for lcdif_pix root clock multiplexer
 *
 * Values:
 * - 000 - derive clock from mmdc_ch0 clock (default)
 * - 001 - derive clock from pll3
 * - 010 - derive clock from pll5
 * - 011 - derive clock from 352M PFD
 * - 100 - derive clock from 396M PFD
 * - 101 - derive clock from 540M PFD
 */
/*@{*/
#define BP_CCM_CSCDR2_lcdif_pix_clk_sel (6U) /*!< Bit position for CCM_CSCDR2_lcdif_pix_clk_sel. */
#define BM_CCM_CSCDR2_lcdif_pix_clk_sel (0x000001C0U) /*!< Bit mask for CCM_CSCDR2_lcdif_pix_clk_sel. */
#define BS_CCM_CSCDR2_lcdif_pix_clk_sel (3U) /*!< Bit field size in bits for CCM_CSCDR2_lcdif_pix_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_lcdif_pix_clk_sel field. */
#define BR_CCM_CSCDR2_lcdif_pix_clk_sel(x) (HW_CCM_CSCDR2(x).B.lcdif_pix_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_lcdif_pix_clk_sel. */
#define BF_CCM_CSCDR2_lcdif_pix_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_lcdif_pix_clk_sel) & BM_CCM_CSCDR2_lcdif_pix_clk_sel)

/*! @brief Set the lcdif_pix_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_lcdif_pix_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_lcdif_pix_clk_sel) | BF_CCM_CSCDR2_lcdif_pix_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field epdc_pix_pred[14:12] (RW)
 *
 * Divider for epdc_pix clock divider. Divider should be updated when output
 * clock is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR2_epdc_pix_pred (12U)  /*!< Bit position for CCM_CSCDR2_epdc_pix_pred. */
#define BM_CCM_CSCDR2_epdc_pix_pred (0x00007000U) /*!< Bit mask for CCM_CSCDR2_epdc_pix_pred. */
#define BS_CCM_CSCDR2_epdc_pix_pred (3U)   /*!< Bit field size in bits for CCM_CSCDR2_epdc_pix_pred. */

/*! @brief Read current value of the CCM_CSCDR2_epdc_pix_pred field. */
#define BR_CCM_CSCDR2_epdc_pix_pred(x) (HW_CCM_CSCDR2(x).B.epdc_pix_pred)

/*! @brief Format value for bitfield CCM_CSCDR2_epdc_pix_pred. */
#define BF_CCM_CSCDR2_epdc_pix_pred(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_epdc_pix_pred) & BM_CCM_CSCDR2_epdc_pix_pred)

/*! @brief Set the epdc_pix_pred field to a new value. */
#define BW_CCM_CSCDR2_epdc_pix_pred(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_epdc_pix_pred) | BF_CCM_CSCDR2_epdc_pix_pred(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field epdc_pix_clk_sel[17:15] (RW)
 *
 * Selector for epdc_pix root clock pre-multiplexer
 *
 * Values:
 * - 000 - derive clock from mmdc_ch0 clock
 * - 001 - derive clock from pll3
 * - 010 - derive clock from pll5
 * - 011 - derive clock from 352M PFD
 * - 100 - derive clock from 396M PFD
 * - 101 - derive clock from 540M PFD (default)
 */
/*@{*/
#define BP_CCM_CSCDR2_epdc_pix_clk_sel (15U) /*!< Bit position for CCM_CSCDR2_epdc_pix_clk_sel. */
#define BM_CCM_CSCDR2_epdc_pix_clk_sel (0x00038000U) /*!< Bit mask for CCM_CSCDR2_epdc_pix_clk_sel. */
#define BS_CCM_CSCDR2_epdc_pix_clk_sel (3U) /*!< Bit field size in bits for CCM_CSCDR2_epdc_pix_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_epdc_pix_clk_sel field. */
#define BR_CCM_CSCDR2_epdc_pix_clk_sel(x) (HW_CCM_CSCDR2(x).B.epdc_pix_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_epdc_pix_clk_sel. */
#define BF_CCM_CSCDR2_epdc_pix_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_epdc_pix_clk_sel) & BM_CCM_CSCDR2_epdc_pix_clk_sel)

/*! @brief Set the epdc_pix_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_epdc_pix_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_epdc_pix_clk_sel) | BF_CCM_CSCDR2_epdc_pix_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field ecspi_clk_sel[18] (RW)
 *
 * Selector for the ECSPI clock multiplexor
 *
 * Values:
 * - 0 - pll3_60m
 * - 1 - OSC clk
 */
/*@{*/
#define BP_CCM_CSCDR2_ecspi_clk_sel (18U)  /*!< Bit position for CCM_CSCDR2_ecspi_clk_sel. */
#define BM_CCM_CSCDR2_ecspi_clk_sel (0x00040000U) /*!< Bit mask for CCM_CSCDR2_ecspi_clk_sel. */
#define BS_CCM_CSCDR2_ecspi_clk_sel (1U)   /*!< Bit field size in bits for CCM_CSCDR2_ecspi_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR2_ecspi_clk_sel field. */
#define BR_CCM_CSCDR2_ecspi_clk_sel(x) (HW_CCM_CSCDR2(x).B.ecspi_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR2_ecspi_clk_sel. */
#define BF_CCM_CSCDR2_ecspi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_ecspi_clk_sel) & BM_CCM_CSCDR2_ecspi_clk_sel)

/*! @brief Set the ecspi_clk_sel field to a new value. */
#define BW_CCM_CSCDR2_ecspi_clk_sel(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_ecspi_clk_sel) | BF_CCM_CSCDR2_ecspi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR2, field ecspi_clk_podf[24:19] (RW)
 *
 * Divider for ecspi clock podf. Divider should be updated when output clock is
 * gated. The input clock to this divider should be lower than 300Mhz, the
 * predivider can be used to achieve this.
 *
 * Values:
 * - 000000 - divide by 1
 * - 111111 - divide by 2^6
 */
/*@{*/
#define BP_CCM_CSCDR2_ecspi_clk_podf (19U) /*!< Bit position for CCM_CSCDR2_ecspi_clk_podf. */
#define BM_CCM_CSCDR2_ecspi_clk_podf (0x01F80000U) /*!< Bit mask for CCM_CSCDR2_ecspi_clk_podf. */
#define BS_CCM_CSCDR2_ecspi_clk_podf (6U)  /*!< Bit field size in bits for CCM_CSCDR2_ecspi_clk_podf. */

/*! @brief Read current value of the CCM_CSCDR2_ecspi_clk_podf field. */
#define BR_CCM_CSCDR2_ecspi_clk_podf(x) (HW_CCM_CSCDR2(x).B.ecspi_clk_podf)

/*! @brief Format value for bitfield CCM_CSCDR2_ecspi_clk_podf. */
#define BF_CCM_CSCDR2_ecspi_clk_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR2_ecspi_clk_podf) & BM_CCM_CSCDR2_ecspi_clk_podf)

/*! @brief Set the ecspi_clk_podf field to a new value. */
#define BW_CCM_CSCDR2_ecspi_clk_podf(x, v) (HW_CCM_CSCDR2_WR(x, (HW_CCM_CSCDR2_RD(x) & ~BM_CCM_CSCDR2_ecspi_clk_podf) | BF_CCM_CSCDR2_ecspi_clk_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3
 ******************************************************************************/

/*!
 * @brief HW_CCM_CSCDR3 - CCM Serial Clock Divider Register 3 (RW)
 *
 * Reset value: 0x00014841U
 *
 * The figure below represents the CCM Serial Clock Divider Register 3(CSCDR3).
 * The CSCDR3 register contains bits to control the clock generation sub-module
 * dividers. The table below provides its field descriptions.
 */
typedef union _hw_ccm_cscdr3
{
    uint32_t U;
    struct _hw_ccm_cscdr3_bitfields
    {
        uint32_t RESERVED0 : 9;        /*!< [8:0]  */
        uint32_t csi_core_clk_sel : 2; /*!< [10:9]  */
        uint32_t csi_core_podf : 3;    /*!< [13:11]  */
        uint32_t lcdif_axi_clk_sel : 2; /*!< [15:14]  */
        uint32_t lcdif_axi_podf : 3;   /*!< [18:16]  */
        uint32_t RESERVED1 : 13;       /*!< [31:19]  */
    } B;
} hw_ccm_cscdr3_t;

/*!
 * @name Constants and macros for entire CCM_CSCDR3 register
 */
/*@{*/
#define HW_CCM_CSCDR3_ADDR(x)    ((uintptr_t)(x) + 0x3CU)

#define HW_CCM_CSCDR3(x)         (*(__IO hw_ccm_cscdr3_t *) HW_CCM_CSCDR3_ADDR(x))
#define HW_CCM_CSCDR3_RD(x)      (HW_CCM_CSCDR3(x).U)
#define HW_CCM_CSCDR3_WR(x, v)   (HW_CCM_CSCDR3(x).U = (v))
#define HW_CCM_CSCDR3_SET(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) |  (v)))
#define HW_CCM_CSCDR3_CLR(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) & ~(v)))
#define HW_CCM_CSCDR3_TOG(x, v)  (HW_CCM_CSCDR3_WR(x, HW_CCM_CSCDR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CSCDR3 bitfields
 */

/*!
 * @name Register CCM_CSCDR3, field csi_core_clk_sel[10:9] (RW)
 *
 * Selector for csi_core clock multiplexer
 *
 * Values:
 * - 00 - derive clock from mmdc_ch0 clock (default)
 * - 01 - derive clock from 396M PFD
 * - 10 - derive clock from 120M
 * - 11 - derive clock from 540M PFD
 */
/*@{*/
#define BP_CCM_CSCDR3_csi_core_clk_sel (9U) /*!< Bit position for CCM_CSCDR3_csi_core_clk_sel. */
#define BM_CCM_CSCDR3_csi_core_clk_sel (0x00000600U) /*!< Bit mask for CCM_CSCDR3_csi_core_clk_sel. */
#define BS_CCM_CSCDR3_csi_core_clk_sel (2U) /*!< Bit field size in bits for CCM_CSCDR3_csi_core_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR3_csi_core_clk_sel field. */
#define BR_CCM_CSCDR3_csi_core_clk_sel(x) (HW_CCM_CSCDR3(x).B.csi_core_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR3_csi_core_clk_sel. */
#define BF_CCM_CSCDR3_csi_core_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_csi_core_clk_sel) & BM_CCM_CSCDR3_csi_core_clk_sel)

/*! @brief Set the csi_core_clk_sel field to a new value. */
#define BW_CCM_CSCDR3_csi_core_clk_sel(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_csi_core_clk_sel) | BF_CCM_CSCDR3_csi_core_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field csi_core_podf[13:11] (RW)
 *
 * Post divider for csi_core clock. Divider should be updated when output clock
 * is gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR3_csi_core_podf (11U)  /*!< Bit position for CCM_CSCDR3_csi_core_podf. */
#define BM_CCM_CSCDR3_csi_core_podf (0x00003800U) /*!< Bit mask for CCM_CSCDR3_csi_core_podf. */
#define BS_CCM_CSCDR3_csi_core_podf (3U)   /*!< Bit field size in bits for CCM_CSCDR3_csi_core_podf. */

/*! @brief Read current value of the CCM_CSCDR3_csi_core_podf field. */
#define BR_CCM_CSCDR3_csi_core_podf(x) (HW_CCM_CSCDR3(x).B.csi_core_podf)

/*! @brief Format value for bitfield CCM_CSCDR3_csi_core_podf. */
#define BF_CCM_CSCDR3_csi_core_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_csi_core_podf) & BM_CCM_CSCDR3_csi_core_podf)

/*! @brief Set the csi_core_podf field to a new value. */
#define BW_CCM_CSCDR3_csi_core_podf(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_csi_core_podf) | BF_CCM_CSCDR3_csi_core_podf(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field lcdif_axi_clk_sel[15:14] (RW)
 *
 * Selector for lcdif_axi clock multiplexer
 *
 * Values:
 * - 00 - derive clock from mmdc_ch0 clock (default)
 * - 01 - derive clock from 396M PFD
 * - 10 - derive clock from 120M
 * - 11 - derive clock from 540M PFD
 */
/*@{*/
#define BP_CCM_CSCDR3_lcdif_axi_clk_sel (14U) /*!< Bit position for CCM_CSCDR3_lcdif_axi_clk_sel. */
#define BM_CCM_CSCDR3_lcdif_axi_clk_sel (0x0000C000U) /*!< Bit mask for CCM_CSCDR3_lcdif_axi_clk_sel. */
#define BS_CCM_CSCDR3_lcdif_axi_clk_sel (2U) /*!< Bit field size in bits for CCM_CSCDR3_lcdif_axi_clk_sel. */

/*! @brief Read current value of the CCM_CSCDR3_lcdif_axi_clk_sel field. */
#define BR_CCM_CSCDR3_lcdif_axi_clk_sel(x) (HW_CCM_CSCDR3(x).B.lcdif_axi_clk_sel)

/*! @brief Format value for bitfield CCM_CSCDR3_lcdif_axi_clk_sel. */
#define BF_CCM_CSCDR3_lcdif_axi_clk_sel(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_lcdif_axi_clk_sel) & BM_CCM_CSCDR3_lcdif_axi_clk_sel)

/*! @brief Set the lcdif_axi_clk_sel field to a new value. */
#define BW_CCM_CSCDR3_lcdif_axi_clk_sel(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_lcdif_axi_clk_sel) | BF_CCM_CSCDR3_lcdif_axi_clk_sel(v)))
/*@}*/

/*!
 * @name Register CCM_CSCDR3, field lcdif_axi_podf[18:16] (RW)
 *
 * Divider for lcdif_axi clock. Divider should be updated when output clock is
 * gated.
 *
 * Values:
 * - 000 - divide by 1
 * - 001 - divide by 2 (default)
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CSCDR3_lcdif_axi_podf (16U) /*!< Bit position for CCM_CSCDR3_lcdif_axi_podf. */
#define BM_CCM_CSCDR3_lcdif_axi_podf (0x00070000U) /*!< Bit mask for CCM_CSCDR3_lcdif_axi_podf. */
#define BS_CCM_CSCDR3_lcdif_axi_podf (3U)  /*!< Bit field size in bits for CCM_CSCDR3_lcdif_axi_podf. */

/*! @brief Read current value of the CCM_CSCDR3_lcdif_axi_podf field. */
#define BR_CCM_CSCDR3_lcdif_axi_podf(x) (HW_CCM_CSCDR3(x).B.lcdif_axi_podf)

/*! @brief Format value for bitfield CCM_CSCDR3_lcdif_axi_podf. */
#define BF_CCM_CSCDR3_lcdif_axi_podf(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CSCDR3_lcdif_axi_podf) & BM_CCM_CSCDR3_lcdif_axi_podf)

/*! @brief Set the lcdif_axi_podf field to a new value. */
#define BW_CCM_CSCDR3_lcdif_axi_podf(x, v) (HW_CCM_CSCDR3_WR(x, (HW_CCM_CSCDR3_RD(x) & ~BM_CCM_CSCDR3_lcdif_axi_podf) | BF_CCM_CSCDR3_lcdif_axi_podf(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CWDR - CCM Wakeup Detector Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CWDR - CCM Wakeup Detector Register (ROZ)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Wakeup Detector Register (CWDR). The CWDR
 * register contains reserved, read-only bits.The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_cwdr
{
    uint32_t U;
    struct _hw_ccm_cwdr_bitfields
    {
        uint32_t RESERVED0 : 32;       /*!< [31:0]  */
    } B;
} hw_ccm_cwdr_t;

/*!
 * @name Constants and macros for entire CCM_CWDR register
 */
/*@{*/
#define HW_CCM_CWDR_ADDR(x)      ((uintptr_t)(x) + 0x44U)

#define HW_CCM_CWDR(x)           (*(__I hw_ccm_cwdr_t *) HW_CCM_CWDR_ADDR(x))
#define HW_CCM_CWDR_RD(x)        (HW_CCM_CWDR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CWDR bitfields
 */

/*******************************************************************************
 * HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CDHIPR - CCM Divider Handshake In-Process Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Divider Handshake In-Process Register
 * (CDHIPR). The CDHIPR register contains read-only bits that indicate that CCM is
 * in the process of updating dividers or muxes that might need handshake with
 * modules.
 */
typedef union _hw_ccm_cdhipr
{
    uint32_t U;
    struct _hw_ccm_cdhipr_bitfields
    {
        uint32_t axi_podf_busy : 1;    /*!< [0]  */
        uint32_t ahb_podf_busy : 1;    /*!< [1]  */
        uint32_t mmdc_root_podf_busy : 1; /*!< [2]  */
        uint32_t periph2_clk_sel_busy : 1; /*!< [3]  */
        uint32_t mmdc_ch0_podf_busy : 1; /*!< [4]  */
        uint32_t periph_clk_sel_busy : 1; /*!< [5]  */
        uint32_t RESERVED0 : 10;       /*!< [15:6]  */
        uint32_t arm_podf_busy : 1;    /*!< [16]  */
        uint32_t RESERVED1 : 15;       /*!< [31:17]  */
    } B;
} hw_ccm_cdhipr_t;

/*!
 * @name Constants and macros for entire CCM_CDHIPR register
 */
/*@{*/
#define HW_CCM_CDHIPR_ADDR(x)    ((uintptr_t)(x) + 0x48U)

#define HW_CCM_CDHIPR(x)         (*(__I hw_ccm_cdhipr_t *) HW_CCM_CDHIPR_ADDR(x))
#define HW_CCM_CDHIPR_RD(x)      (HW_CCM_CDHIPR(x).U)
/*@}*/

/*
 * Constants & macros for individual CCM_CDHIPR bitfields
 */

/*!
 * @name Register CCM_CDHIPR, field axi_podf_busy[0] (RO)
 *
 * Busy indicator for axi_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value odivision factor, and after the
 *     handshake the written value of the axi_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_axi_podf_busy (0U)   /*!< Bit position for CCM_CDHIPR_axi_podf_busy. */
#define BM_CCM_CDHIPR_axi_podf_busy (0x00000001U) /*!< Bit mask for CCM_CDHIPR_axi_podf_busy. */
#define BS_CCM_CDHIPR_axi_podf_busy (1U)   /*!< Bit field size in bits for CCM_CDHIPR_axi_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_axi_podf_busy field. */
#define BR_CCM_CDHIPR_axi_podf_busy(x) (HW_CCM_CDHIPR(x).B.axi_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field ahb_podf_busy[1] (RO)
 *
 * Busy indicator for ahb_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value odivision factor, and after the
 *     handshake the written value of the ahb_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_ahb_podf_busy (1U)   /*!< Bit position for CCM_CDHIPR_ahb_podf_busy. */
#define BM_CCM_CDHIPR_ahb_podf_busy (0x00000002U) /*!< Bit mask for CCM_CDHIPR_ahb_podf_busy. */
#define BS_CCM_CDHIPR_ahb_podf_busy (1U)   /*!< Bit field size in bits for CCM_CDHIPR_ahb_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_ahb_podf_busy field. */
#define BR_CCM_CDHIPR_ahb_podf_busy(x) (HW_CCM_CDHIPR(x).B.ahb_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field mmdc_root_podf_busy[2] (RO)
 *
 * Busy indicator for mmdc_root_axi_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value odivision factor, and after the
 *     handshake the written value of the mmdc_root_axi_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_mmdc_root_podf_busy (2U) /*!< Bit position for CCM_CDHIPR_mmdc_root_podf_busy. */
#define BM_CCM_CDHIPR_mmdc_root_podf_busy (0x00000004U) /*!< Bit mask for CCM_CDHIPR_mmdc_root_podf_busy. */
#define BS_CCM_CDHIPR_mmdc_root_podf_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_mmdc_root_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_mmdc_root_podf_busy field. */
#define BR_CCM_CDHIPR_mmdc_root_podf_busy(x) (HW_CCM_CDHIPR(x).B.mmdc_root_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field periph2_clk_sel_busy[3] (RO)
 *
 * Busy indicator for periph2_clk_sel mux control.
 *
 * Values:
 * - 0 - mux is not busy and its value represents the actual division.
 * - 1 - mux is busy with handshake process with module. The value read in the
 *     periph2_clk_sel represents the previous value of select, and after the
 *     handshake periph2_clk_sel value will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_periph2_clk_sel_busy (3U) /*!< Bit position for CCM_CDHIPR_periph2_clk_sel_busy. */
#define BM_CCM_CDHIPR_periph2_clk_sel_busy (0x00000008U) /*!< Bit mask for CCM_CDHIPR_periph2_clk_sel_busy. */
#define BS_CCM_CDHIPR_periph2_clk_sel_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_periph2_clk_sel_busy. */

/*! @brief Read current value of the CCM_CDHIPR_periph2_clk_sel_busy field. */
#define BR_CCM_CDHIPR_periph2_clk_sel_busy(x) (HW_CCM_CDHIPR(x).B.periph2_clk_sel_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field mmdc_ch0_podf_busy[4] (RO)
 *
 * Busy indicator for mmdc_ch0_axi_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value odivision factor, and after the
 *     handshake the written value of the mmdc_ch0_axi_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_mmdc_ch0_podf_busy (4U) /*!< Bit position for CCM_CDHIPR_mmdc_ch0_podf_busy. */
#define BM_CCM_CDHIPR_mmdc_ch0_podf_busy (0x00000010U) /*!< Bit mask for CCM_CDHIPR_mmdc_ch0_podf_busy. */
#define BS_CCM_CDHIPR_mmdc_ch0_podf_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_mmdc_ch0_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_mmdc_ch0_podf_busy field. */
#define BR_CCM_CDHIPR_mmdc_ch0_podf_busy(x) (HW_CCM_CDHIPR(x).B.mmdc_ch0_podf_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field periph_clk_sel_busy[5] (RO)
 *
 * Busy indicator for periph_clk_sel mux control.
 *
 * Values:
 * - 0 - mux is not busy and its value represents the actual division.
 * - 1 - mux is busy with handshake process with module. The value read in the
 *     periph_clk_sel represents the previous value of select, and after the
 *     handshake periph_clk_sel value will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_periph_clk_sel_busy (5U) /*!< Bit position for CCM_CDHIPR_periph_clk_sel_busy. */
#define BM_CCM_CDHIPR_periph_clk_sel_busy (0x00000020U) /*!< Bit mask for CCM_CDHIPR_periph_clk_sel_busy. */
#define BS_CCM_CDHIPR_periph_clk_sel_busy (1U) /*!< Bit field size in bits for CCM_CDHIPR_periph_clk_sel_busy. */

/*! @brief Read current value of the CCM_CDHIPR_periph_clk_sel_busy field. */
#define BR_CCM_CDHIPR_periph_clk_sel_busy(x) (HW_CCM_CDHIPR(x).B.periph_clk_sel_busy)
/*@}*/

/*!
 * @name Register CCM_CDHIPR, field arm_podf_busy[16] (RO)
 *
 * Busy indicator for arm_podf.
 *
 * Values:
 * - 0 - divider is not busy and its value represents the actual division.
 * - 1 - divider is busy with handshake process with module. The value read in
 *     the divider represents the previous value odivision factor, and after the
 *     handshake the written value of the arm_podf will be applied.
 */
/*@{*/
#define BP_CCM_CDHIPR_arm_podf_busy (16U)  /*!< Bit position for CCM_CDHIPR_arm_podf_busy. */
#define BM_CCM_CDHIPR_arm_podf_busy (0x00010000U) /*!< Bit mask for CCM_CDHIPR_arm_podf_busy. */
#define BS_CCM_CDHIPR_arm_podf_busy (1U)   /*!< Bit field size in bits for CCM_CDHIPR_arm_podf_busy. */

/*! @brief Read current value of the CCM_CDHIPR_arm_podf_busy field. */
#define BR_CCM_CDHIPR_arm_podf_busy(x) (HW_CCM_CDHIPR(x).B.arm_podf_busy)
/*@}*/

/*******************************************************************************
 * HW_CCM_CLPCR - CCM Low Power Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CLPCR - CCM Low Power Control Register (RW)
 *
 * Reset value: 0x00000079U
 *
 * The figure below represents the CCM Low Power Control Register (CLPCR). The
 * CLPCR register contains bits to control the low power modes operation.The table
 * below provides its field descriptions.
 */
typedef union _hw_ccm_clpcr
{
    uint32_t U;
    struct _hw_ccm_clpcr_bitfields
    {
        uint32_t LPM : 2;              /*!< [1:0]  */
        uint32_t bypass_pmic_ready : 1; /*!< [2]  */
        uint32_t RESERVED0 : 2;        /*!< [4:3]  */
        uint32_t ARM_clk_dis_on_lpm : 1; /*!< [5]  */
        uint32_t SBYOS : 1;            /*!< [6]  */
        uint32_t dis_ref_osc : 1;      /*!< [7]  */
        uint32_t VSTBY : 1;            /*!< [8]  */
        uint32_t stby_count : 2;       /*!< [10:9]  */
        uint32_t cosc_pwrdown : 1;     /*!< [11]  */
        uint32_t RESERVED1 : 4;        /*!< [15:12]  */
        uint32_t wb_per_at_lpm : 1;    /*!< [16]  */
        uint32_t RESERVED2 : 2;        /*!< [18:17]  */
        uint32_t bypass_mmdc_ch0_lpm_hs : 1; /*!< [19]  */
        uint32_t RESERVED3 : 1;        /*!< [20]  */
        uint32_t bypass_mmdc_root_lpm_hs : 1; /*!< [21]  */
        uint32_t mask_core0_wfi : 1;   /*!< [22]  */
        uint32_t RESERVED4 : 3;        /*!< [25:23]  */
        uint32_t mask_scu_idle : 1;    /*!< [26]  */
        uint32_t mask_l2cc_idle : 1;   /*!< [27]  */
        uint32_t RESERVED5 : 4;        /*!< [31:28]  */
    } B;
} hw_ccm_clpcr_t;

/*!
 * @name Constants and macros for entire CCM_CLPCR register
 */
/*@{*/
#define HW_CCM_CLPCR_ADDR(x)     ((uintptr_t)(x) + 0x54U)

#define HW_CCM_CLPCR(x)          (*(__IO hw_ccm_clpcr_t *) HW_CCM_CLPCR_ADDR(x))
#define HW_CCM_CLPCR_RD(x)       (HW_CCM_CLPCR(x).U)
#define HW_CCM_CLPCR_WR(x, v)    (HW_CCM_CLPCR(x).U = (v))
#define HW_CCM_CLPCR_SET(x, v)   (HW_CCM_CLPCR_WR(x, HW_CCM_CLPCR_RD(x) |  (v)))
#define HW_CCM_CLPCR_CLR(x, v)   (HW_CCM_CLPCR_WR(x, HW_CCM_CLPCR_RD(x) & ~(v)))
#define HW_CCM_CLPCR_TOG(x, v)   (HW_CCM_CLPCR_WR(x, HW_CCM_CLPCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CLPCR bitfields
 */

/*!
 * @name Register CCM_CLPCR, field LPM[1:0] (RW)
 *
 * Setting the low power mode that system will enter on next assertion of
 * dsm_request signal.
 *
 * Values:
 * - 00 - Remain in run mode
 * - 01 - Transfer to wait mode
 * - 10 - Transfer to stop mode
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_CLPCR_LPM     (0U)          /*!< Bit position for CCM_CLPCR_LPM. */
#define BM_CCM_CLPCR_LPM     (0x00000003U) /*!< Bit mask for CCM_CLPCR_LPM. */
#define BS_CCM_CLPCR_LPM     (2U)          /*!< Bit field size in bits for CCM_CLPCR_LPM. */

/*! @brief Read current value of the CCM_CLPCR_LPM field. */
#define BR_CCM_CLPCR_LPM(x)  (HW_CCM_CLPCR(x).B.LPM)

/*! @brief Format value for bitfield CCM_CLPCR_LPM. */
#define BF_CCM_CLPCR_LPM(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_LPM) & BM_CCM_CLPCR_LPM)

/*! @brief Set the LPM field to a new value. */
#define BW_CCM_CLPCR_LPM(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_LPM) | BF_CCM_CLPCR_LPM(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field bypass_pmic_ready[2] (RW)
 *
 * By asserting this bit CCM will bypass waiting for CCM_PMIC_READY signal when
 * coming out of STOP mode. This should be used for PMIC's that don't support the
 * CCM_PMIC_READY signal.
 *
 * Values:
 * - 0 - Don't bypass the CCM_PMIC_READY signal - CCM will wait for it's
 *     assertion during exit of low power mode if standby voltage was enabled.
 * - 1 - bypass the CCM_PMIC_READY signal - CCM will not wait for it's assertion
 *     during exit of low power mode if standby voltage was enabled.
 */
/*@{*/
#define BP_CCM_CLPCR_bypass_pmic_ready (2U) /*!< Bit position for CCM_CLPCR_bypass_pmic_ready. */
#define BM_CCM_CLPCR_bypass_pmic_ready (0x00000004U) /*!< Bit mask for CCM_CLPCR_bypass_pmic_ready. */
#define BS_CCM_CLPCR_bypass_pmic_ready (1U) /*!< Bit field size in bits for CCM_CLPCR_bypass_pmic_ready. */

/*! @brief Read current value of the CCM_CLPCR_bypass_pmic_ready field. */
#define BR_CCM_CLPCR_bypass_pmic_ready(x) (HW_CCM_CLPCR(x).B.bypass_pmic_ready)

/*! @brief Format value for bitfield CCM_CLPCR_bypass_pmic_ready. */
#define BF_CCM_CLPCR_bypass_pmic_ready(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_bypass_pmic_ready) & BM_CCM_CLPCR_bypass_pmic_ready)

/*! @brief Set the bypass_pmic_ready field to a new value. */
#define BW_CCM_CLPCR_bypass_pmic_ready(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_bypass_pmic_ready) | BF_CCM_CLPCR_bypass_pmic_ready(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field ARM_clk_dis_on_lpm[5] (RW)
 *
 * Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_wrck)
 * will be disabled on wait mode. This is useful for debug mode, when the user
 * still wants to simulate entering wait mode and still keep ARM clock functioning.
 * Software should not enable ARM power gating in wait mode if this bit is cleared.
 *
 * Values:
 * - 0 - ARM clock enabled on wait mode.
 * - 1 - ARM clock disabled on wait mode. (default).
 */
/*@{*/
#define BP_CCM_CLPCR_ARM_clk_dis_on_lpm (5U) /*!< Bit position for CCM_CLPCR_ARM_clk_dis_on_lpm. */
#define BM_CCM_CLPCR_ARM_clk_dis_on_lpm (0x00000020U) /*!< Bit mask for CCM_CLPCR_ARM_clk_dis_on_lpm. */
#define BS_CCM_CLPCR_ARM_clk_dis_on_lpm (1U) /*!< Bit field size in bits for CCM_CLPCR_ARM_clk_dis_on_lpm. */

/*! @brief Read current value of the CCM_CLPCR_ARM_clk_dis_on_lpm field. */
#define BR_CCM_CLPCR_ARM_clk_dis_on_lpm(x) (HW_CCM_CLPCR(x).B.ARM_clk_dis_on_lpm)

/*! @brief Format value for bitfield CCM_CLPCR_ARM_clk_dis_on_lpm. */
#define BF_CCM_CLPCR_ARM_clk_dis_on_lpm(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_ARM_clk_dis_on_lpm) & BM_CCM_CLPCR_ARM_clk_dis_on_lpm)

/*! @brief Set the ARM_clk_dis_on_lpm field to a new value. */
#define BW_CCM_CLPCR_ARM_clk_dis_on_lpm(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_ARM_clk_dis_on_lpm) | BF_CCM_CLPCR_ARM_clk_dis_on_lpm(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field SBYOS[6] (RW)
 *
 * Standby clock oscillator bit. This bit defines if cosc_pwrdown, which power
 * down the on chip oscillator, will be asserted in STOP mode. This bit is
 * discarded if cosc_pwrdown='1' for the on chip oscillator.
 *
 * Values:
 * - 0 - On-chip oscillator will not be powered down, after next entrance to
 *     STOP mode. (CCM_REF_EN_B will remain asserted - '0' and cosc_pwrdown will
 *     remain de asserted - '0')
 * - 1 - On-chip oscillator will be powered down, after next entrance to STOP
 *     mode. (CCM_REF_EN_B will be deasserted - '1' and cosc_pwrdown will be
 *     asserted - '1'). (Default.) When returning from STOP mode, external oscillator
 *     will be enabled again, on-chip oscillator will return to oscillator mode,
 *     and after oscnt count, CCM will continue with the exit from the STOP mode
 *     process.
 */
/*@{*/
#define BP_CCM_CLPCR_SBYOS   (6U)          /*!< Bit position for CCM_CLPCR_SBYOS. */
#define BM_CCM_CLPCR_SBYOS   (0x00000040U) /*!< Bit mask for CCM_CLPCR_SBYOS. */
#define BS_CCM_CLPCR_SBYOS   (1U)          /*!< Bit field size in bits for CCM_CLPCR_SBYOS. */

/*! @brief Read current value of the CCM_CLPCR_SBYOS field. */
#define BR_CCM_CLPCR_SBYOS(x) (HW_CCM_CLPCR(x).B.SBYOS)

/*! @brief Format value for bitfield CCM_CLPCR_SBYOS. */
#define BF_CCM_CLPCR_SBYOS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_SBYOS) & BM_CCM_CLPCR_SBYOS)

/*! @brief Set the SBYOS field to a new value. */
#define BW_CCM_CLPCR_SBYOS(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_SBYOS) | BF_CCM_CLPCR_SBYOS(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field dis_ref_osc[7] (RW)
 *
 * dis_ref_osc - in run mode, software can manually control closing of external
 * reference oscillator clock, i.e. generating '1' on CCM_REF_EN_B signal. If
 * software closed manually the external reference clock, then sbyos functionality
 * will be bypassed. The manual closing of external reference oscilator should be
 * performed only in case the reference oscilator is not the source of any clock
 * generation. When returning from stop mode, the PMIC_VSTBY_REQ will be
 * deasserted (if it was asserted when entering stop mode), and CCM will wait for
 * indication that functional voltage is ready (by sampling the assertion of
 * pmic_vfuncional_ready) before continuing the process of exiting from stop mode. See
 * stby_count bits.
 *
 * Values:
 * - 0 - external high frequency oscillator will be enabled, i.e. CCM_REF_EN_B =
 *     '0'.(default)
 * - 1 - external high frequency oscillator will be disabled, i.e. CCM_REF_EN_B
 *     = '1'
 */
/*@{*/
#define BP_CCM_CLPCR_dis_ref_osc (7U)      /*!< Bit position for CCM_CLPCR_dis_ref_osc. */
#define BM_CCM_CLPCR_dis_ref_osc (0x00000080U) /*!< Bit mask for CCM_CLPCR_dis_ref_osc. */
#define BS_CCM_CLPCR_dis_ref_osc (1U)      /*!< Bit field size in bits for CCM_CLPCR_dis_ref_osc. */

/*! @brief Read current value of the CCM_CLPCR_dis_ref_osc field. */
#define BR_CCM_CLPCR_dis_ref_osc(x) (HW_CCM_CLPCR(x).B.dis_ref_osc)

/*! @brief Format value for bitfield CCM_CLPCR_dis_ref_osc. */
#define BF_CCM_CLPCR_dis_ref_osc(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_dis_ref_osc) & BM_CCM_CLPCR_dis_ref_osc)

/*! @brief Set the dis_ref_osc field to a new value. */
#define BW_CCM_CLPCR_dis_ref_osc(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_dis_ref_osc) | BF_CCM_CLPCR_dis_ref_osc(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field VSTBY[8] (RW)
 *
 * Voltage standby request bit. This bit defines if PMIC_VSTBY_REQ pin, which
 * notifies external power management IC to move from functional voltage to standby
 * voltage, will be asserted in STOP mode.
 *
 * Values:
 * - 0 - Voltage will not be changed to standby voltage after next entrance to
 *     STOP mode. ( PMIC_VSTBY_REQ will remain negated - '0')
 * - 1 - Voltage will be requested to change to standby voltage after next
 *     entrance to stop mode. ( PMIC_VSTBY_REQ will be asserted - '1').
 */
/*@{*/
#define BP_CCM_CLPCR_VSTBY   (8U)          /*!< Bit position for CCM_CLPCR_VSTBY. */
#define BM_CCM_CLPCR_VSTBY   (0x00000100U) /*!< Bit mask for CCM_CLPCR_VSTBY. */
#define BS_CCM_CLPCR_VSTBY   (1U)          /*!< Bit field size in bits for CCM_CLPCR_VSTBY. */

/*! @brief Read current value of the CCM_CLPCR_VSTBY field. */
#define BR_CCM_CLPCR_VSTBY(x) (HW_CCM_CLPCR(x).B.VSTBY)

/*! @brief Format value for bitfield CCM_CLPCR_VSTBY. */
#define BF_CCM_CLPCR_VSTBY(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_VSTBY) & BM_CCM_CLPCR_VSTBY)

/*! @brief Set the VSTBY field to a new value. */
#define BW_CCM_CLPCR_VSTBY(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_VSTBY) | BF_CCM_CLPCR_VSTBY(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field stby_count[10:9] (RW)
 *
 * Standby counter definition. These two bits define, in the case of stop exit
 * (if vstby bit was set), the amount of time CCM will wait between PMIC_VSTBY_REQ
 * negation and the check of assertion of CCM_PMIC_READY . Clock cycles ratio
 * depends on pmic_delay_scaler, defined by CGPR[0] bit.
 *
 * Values:
 * - 00 - CCM will wait (1*pmic_delay_scaler)+1 ckil clock cycles
 * - 01 - CCM will wait (3*pmic_delay_scaler)+1 ckil clock cycles
 * - 10 - CCM will wait (7*pmic_delay_scaler)+1 ckil clock cycles
 * - 11 - CCM will wait (15*pmic_delay_scaler)+1 ckil clock cycles
 */
/*@{*/
#define BP_CCM_CLPCR_stby_count (9U)       /*!< Bit position for CCM_CLPCR_stby_count. */
#define BM_CCM_CLPCR_stby_count (0x00000600U) /*!< Bit mask for CCM_CLPCR_stby_count. */
#define BS_CCM_CLPCR_stby_count (2U)       /*!< Bit field size in bits for CCM_CLPCR_stby_count. */

/*! @brief Read current value of the CCM_CLPCR_stby_count field. */
#define BR_CCM_CLPCR_stby_count(x) (HW_CCM_CLPCR(x).B.stby_count)

/*! @brief Format value for bitfield CCM_CLPCR_stby_count. */
#define BF_CCM_CLPCR_stby_count(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_stby_count) & BM_CCM_CLPCR_stby_count)

/*! @brief Set the stby_count field to a new value. */
#define BW_CCM_CLPCR_stby_count(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_stby_count) | BF_CCM_CLPCR_stby_count(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field cosc_pwrdown[11] (RW)
 *
 * In run mode, software can manually control powering down of on chip
 * oscillator, i.e. generating '1' on cosc_pwrdown signal. If software manually powered
 * down the on chip oscillator, then sbyos functionality for on chip oscillator
 * will be bypassed. The manual closing of onchip oscillator should be performed
 * only in case the reference oscilator is not the source of all the clocks
 * generation.
 *
 * Values:
 * - 0 - On chip oscillator will not be powered down, i.e. cosc_pwrdown =
 *     '0'.(default)
 * - 1 - On chip oscillator will be powered down, i.e. cosc_pwrdown = '1'.
 */
/*@{*/
#define BP_CCM_CLPCR_cosc_pwrdown (11U)    /*!< Bit position for CCM_CLPCR_cosc_pwrdown. */
#define BM_CCM_CLPCR_cosc_pwrdown (0x00000800U) /*!< Bit mask for CCM_CLPCR_cosc_pwrdown. */
#define BS_CCM_CLPCR_cosc_pwrdown (1U)     /*!< Bit field size in bits for CCM_CLPCR_cosc_pwrdown. */

/*! @brief Read current value of the CCM_CLPCR_cosc_pwrdown field. */
#define BR_CCM_CLPCR_cosc_pwrdown(x) (HW_CCM_CLPCR(x).B.cosc_pwrdown)

/*! @brief Format value for bitfield CCM_CLPCR_cosc_pwrdown. */
#define BF_CCM_CLPCR_cosc_pwrdown(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_cosc_pwrdown) & BM_CCM_CLPCR_cosc_pwrdown)

/*! @brief Set the cosc_pwrdown field to a new value. */
#define BW_CCM_CLPCR_cosc_pwrdown(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_cosc_pwrdown) | BF_CCM_CLPCR_cosc_pwrdown(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field wb_per_at_lpm[16] (RW)
 *
 * Enable periphery charge pump for well biasing at low power mode (stop or wait)
 *
 * Values:
 * - 0 - Periphery charge pump won't be enabled at STOP or WAIT low power modes
 * - 1 - Periphery charge pump will be enabled at STOP or WAIT low power modes
 */
/*@{*/
#define BP_CCM_CLPCR_wb_per_at_lpm (16U)   /*!< Bit position for CCM_CLPCR_wb_per_at_lpm. */
#define BM_CCM_CLPCR_wb_per_at_lpm (0x00010000U) /*!< Bit mask for CCM_CLPCR_wb_per_at_lpm. */
#define BS_CCM_CLPCR_wb_per_at_lpm (1U)    /*!< Bit field size in bits for CCM_CLPCR_wb_per_at_lpm. */

/*! @brief Read current value of the CCM_CLPCR_wb_per_at_lpm field. */
#define BR_CCM_CLPCR_wb_per_at_lpm(x) (HW_CCM_CLPCR(x).B.wb_per_at_lpm)

/*! @brief Format value for bitfield CCM_CLPCR_wb_per_at_lpm. */
#define BF_CCM_CLPCR_wb_per_at_lpm(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_wb_per_at_lpm) & BM_CCM_CLPCR_wb_per_at_lpm)

/*! @brief Set the wb_per_at_lpm field to a new value. */
#define BW_CCM_CLPCR_wb_per_at_lpm(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_wb_per_at_lpm) | BF_CCM_CLPCR_wb_per_at_lpm(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field bypass_mmdc_ch0_lpm_hs[19] (RW)
 *
 * Bypass handshake with mmdc_ch0 on next entrance to low power mode (STOP or
 * WAIT). CCM doesn't wait for the module's acknowledge. Handshake will also be
 * bypassed, if CGR3 CG10 is set to gate fast mmdc_ch0 clock.
 *
 * Values:
 * - 0 - Handshake with mmdc_ch0 on next entrance to low power mode will be
 *     performed. (default).
 * - 1 - Handshake with mmdc_ch0 on next entrance to low power mode will be
 *     bypassed.
 */
/*@{*/
#define BP_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs (19U) /*!< Bit position for CCM_CLPCR_bypass_mmdc_ch0_lpm_hs. */
#define BM_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs (0x00080000U) /*!< Bit mask for CCM_CLPCR_bypass_mmdc_ch0_lpm_hs. */
#define BS_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs (1U) /*!< Bit field size in bits for CCM_CLPCR_bypass_mmdc_ch0_lpm_hs. */

/*! @brief Read current value of the CCM_CLPCR_bypass_mmdc_ch0_lpm_hs field. */
#define BR_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs(x) (HW_CCM_CLPCR(x).B.bypass_mmdc_ch0_lpm_hs)

/*! @brief Format value for bitfield CCM_CLPCR_bypass_mmdc_ch0_lpm_hs. */
#define BF_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs) & BM_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs)

/*! @brief Set the bypass_mmdc_ch0_lpm_hs field to a new value. */
#define BW_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs) | BF_CCM_CLPCR_bypass_mmdc_ch0_lpm_hs(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field bypass_mmdc_root_lpm_hs[21] (RW)
 *
 * Bypass handshake with mmdc_root on next entrance to low power mode (STOP or
 * WAIT). CCM doesn't wait for the module's acknowledge. Handshake also will be
 * bypassed, if CGR3 CG10 is set to gate fast mmdc_root clock.
 *
 * Values:
 * - 0 - handshake with mmdc_root on next entrance to low power mode will be
 *     performed. (default).
 * - 1 - handshake with mmdc_root on next entrance to low power mode will be
 *     bypassed.
 */
/*@{*/
#define BP_CCM_CLPCR_bypass_mmdc_root_lpm_hs (21U) /*!< Bit position for CCM_CLPCR_bypass_mmdc_root_lpm_hs. */
#define BM_CCM_CLPCR_bypass_mmdc_root_lpm_hs (0x00200000U) /*!< Bit mask for CCM_CLPCR_bypass_mmdc_root_lpm_hs. */
#define BS_CCM_CLPCR_bypass_mmdc_root_lpm_hs (1U) /*!< Bit field size in bits for CCM_CLPCR_bypass_mmdc_root_lpm_hs. */

/*! @brief Read current value of the CCM_CLPCR_bypass_mmdc_root_lpm_hs field. */
#define BR_CCM_CLPCR_bypass_mmdc_root_lpm_hs(x) (HW_CCM_CLPCR(x).B.bypass_mmdc_root_lpm_hs)

/*! @brief Format value for bitfield CCM_CLPCR_bypass_mmdc_root_lpm_hs. */
#define BF_CCM_CLPCR_bypass_mmdc_root_lpm_hs(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_bypass_mmdc_root_lpm_hs) & BM_CCM_CLPCR_bypass_mmdc_root_lpm_hs)

/*! @brief Set the bypass_mmdc_root_lpm_hs field to a new value. */
#define BW_CCM_CLPCR_bypass_mmdc_root_lpm_hs(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_bypass_mmdc_root_lpm_hs) | BF_CCM_CLPCR_bypass_mmdc_root_lpm_hs(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field mask_core0_wfi[22] (RW)
 *
 * Mask WFI of core0 for entering low power mode Assertion of all bits[27:22]
 * will generate low power mode request
 *
 * Values:
 * - 0 - WFI of core0 is not masked
 * - 1 - WFI of core0 is masked
 */
/*@{*/
#define BP_CCM_CLPCR_mask_core0_wfi (22U)  /*!< Bit position for CCM_CLPCR_mask_core0_wfi. */
#define BM_CCM_CLPCR_mask_core0_wfi (0x00400000U) /*!< Bit mask for CCM_CLPCR_mask_core0_wfi. */
#define BS_CCM_CLPCR_mask_core0_wfi (1U)   /*!< Bit field size in bits for CCM_CLPCR_mask_core0_wfi. */

/*! @brief Read current value of the CCM_CLPCR_mask_core0_wfi field. */
#define BR_CCM_CLPCR_mask_core0_wfi(x) (HW_CCM_CLPCR(x).B.mask_core0_wfi)

/*! @brief Format value for bitfield CCM_CLPCR_mask_core0_wfi. */
#define BF_CCM_CLPCR_mask_core0_wfi(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_mask_core0_wfi) & BM_CCM_CLPCR_mask_core0_wfi)

/*! @brief Set the mask_core0_wfi field to a new value. */
#define BW_CCM_CLPCR_mask_core0_wfi(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_mask_core0_wfi) | BF_CCM_CLPCR_mask_core0_wfi(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field mask_scu_idle[26] (RW)
 *
 * Mask SCU IDLE for entering low power mode Assertion of all bits[27:22] will
 * generate low power mode request
 *
 * Values:
 * - 1 - SCU IDLE is masked
 * - 0 - SCU IDLE is not masked
 */
/*@{*/
#define BP_CCM_CLPCR_mask_scu_idle (26U)   /*!< Bit position for CCM_CLPCR_mask_scu_idle. */
#define BM_CCM_CLPCR_mask_scu_idle (0x04000000U) /*!< Bit mask for CCM_CLPCR_mask_scu_idle. */
#define BS_CCM_CLPCR_mask_scu_idle (1U)    /*!< Bit field size in bits for CCM_CLPCR_mask_scu_idle. */

/*! @brief Read current value of the CCM_CLPCR_mask_scu_idle field. */
#define BR_CCM_CLPCR_mask_scu_idle(x) (HW_CCM_CLPCR(x).B.mask_scu_idle)

/*! @brief Format value for bitfield CCM_CLPCR_mask_scu_idle. */
#define BF_CCM_CLPCR_mask_scu_idle(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_mask_scu_idle) & BM_CCM_CLPCR_mask_scu_idle)

/*! @brief Set the mask_scu_idle field to a new value. */
#define BW_CCM_CLPCR_mask_scu_idle(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_mask_scu_idle) | BF_CCM_CLPCR_mask_scu_idle(v)))
/*@}*/

/*!
 * @name Register CCM_CLPCR, field mask_l2cc_idle[27] (RW)
 *
 * Mask L2CC IDLE for entering low power mode. Assertion of all bits[27:22] will
 * generate low power mode request
 *
 * Values:
 * - 1 - L2CC IDLE is masked
 * - 0 - L2CC IDLE is not masked
 */
/*@{*/
#define BP_CCM_CLPCR_mask_l2cc_idle (27U)  /*!< Bit position for CCM_CLPCR_mask_l2cc_idle. */
#define BM_CCM_CLPCR_mask_l2cc_idle (0x08000000U) /*!< Bit mask for CCM_CLPCR_mask_l2cc_idle. */
#define BS_CCM_CLPCR_mask_l2cc_idle (1U)   /*!< Bit field size in bits for CCM_CLPCR_mask_l2cc_idle. */

/*! @brief Read current value of the CCM_CLPCR_mask_l2cc_idle field. */
#define BR_CCM_CLPCR_mask_l2cc_idle(x) (HW_CCM_CLPCR(x).B.mask_l2cc_idle)

/*! @brief Format value for bitfield CCM_CLPCR_mask_l2cc_idle. */
#define BF_CCM_CLPCR_mask_l2cc_idle(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CLPCR_mask_l2cc_idle) & BM_CCM_CLPCR_mask_l2cc_idle)

/*! @brief Set the mask_l2cc_idle field to a new value. */
#define BW_CCM_CLPCR_mask_l2cc_idle(x, v) (HW_CCM_CLPCR_WR(x, (HW_CCM_CLPCR_RD(x) & ~BM_CCM_CLPCR_mask_l2cc_idle) | BF_CCM_CLPCR_mask_l2cc_idle(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CISR - CCM Interrupt Status Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CISR - CCM Interrupt Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The figure below represents the CCM Interrupt Status Register (CISR). This is
 * a write one to clear register. Once a interrupt is generated, software should
 * write one to clear it. The table below provides its field descriptions. CCM
 * interrupt request 1 can be masked by CCM interrupt request 1 mask bit. CCM
 * interrupt request 2 can be masked by CCM interrupt request 2 mask bit.
 */
typedef union _hw_ccm_cisr
{
    uint32_t U;
    struct _hw_ccm_cisr_bitfields
    {
        uint32_t lrf_pll : 1;          /*!< [0]  */
        uint32_t RESERVED0 : 5;        /*!< [5:1]  */
        uint32_t cosc_ready : 1;       /*!< [6]  */
        uint32_t RESERVED1 : 10;       /*!< [16:7]  */
        uint32_t axi_podf_loaded : 1;  /*!< [17]  */
        uint32_t mmdc_ch0_axi_podf_loaded : 1; /*!< [18]  */
        uint32_t periph2_clk_sel_loaded : 1; /*!< [19]  */
        uint32_t ahb_podf_loaded : 1;  /*!< [20]  */
        uint32_t mmdc_root_podf_loaded : 1; /*!< [21]  */
        uint32_t periph_clk_sel_loaded : 1; /*!< [22]  */
        uint32_t mmdc_ch0_podf_loaded : 1; /*!< [23]  */
        uint32_t RESERVED2 : 2;        /*!< [25:24]  */
        uint32_t arm_podf_loaded : 1;  /*!< [26]  */
        uint32_t RESERVED3 : 5;        /*!< [31:27]  */
    } B;
} hw_ccm_cisr_t;

/*!
 * @name Constants and macros for entire CCM_CISR register
 */
/*@{*/
#define HW_CCM_CISR_ADDR(x)      ((uintptr_t)(x) + 0x58U)

#define HW_CCM_CISR(x)           (*(__IO hw_ccm_cisr_t *) HW_CCM_CISR_ADDR(x))
#define HW_CCM_CISR_RD(x)        (HW_CCM_CISR(x).U)
#define HW_CCM_CISR_WR(x, v)     (HW_CCM_CISR(x).U = (v))
#define HW_CCM_CISR_SET(x, v)    (HW_CCM_CISR_WR(x, HW_CCM_CISR_RD(x) |  (v)))
#define HW_CCM_CISR_CLR(x, v)    (HW_CCM_CISR_WR(x, HW_CCM_CISR_RD(x) & ~(v)))
#define HW_CCM_CISR_TOG(x, v)    (HW_CCM_CISR_WR(x, HW_CCM_CISR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CISR bitfields
 */

/*!
 * @name Register CCM_CISR, field lrf_pll[0] (W1C)
 *
 * CCM interrupt request 2 generated due to lock of all enabled and not bypaseed
 * PLLs
 *
 * Values:
 * - 0 - interrupt is not genrerated due to lock ready of all enabled and not
 *     bypaseed PLLs
 * - 1 - interrupt genrerated due to lock ready of all enabled and not bypaseed
 *     PLLs
 */
/*@{*/
#define BP_CCM_CISR_lrf_pll  (0U)          /*!< Bit position for CCM_CISR_lrf_pll. */
#define BM_CCM_CISR_lrf_pll  (0x00000001U) /*!< Bit mask for CCM_CISR_lrf_pll. */
#define BS_CCM_CISR_lrf_pll  (1U)          /*!< Bit field size in bits for CCM_CISR_lrf_pll. */

/*! @brief Read current value of the CCM_CISR_lrf_pll field. */
#define BR_CCM_CISR_lrf_pll(x) (HW_CCM_CISR(x).B.lrf_pll)

/*! @brief Format value for bitfield CCM_CISR_lrf_pll. */
#define BF_CCM_CISR_lrf_pll(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_lrf_pll) & BM_CCM_CISR_lrf_pll)

/*! @brief Set the lrf_pll field to a new value. */
#define BW_CCM_CISR_lrf_pll(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_lrf_pll) | BF_CCM_CISR_lrf_pll(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field cosc_ready[6] (W1C)
 *
 * CCM interrupt request 2 generated due to on board oscillator ready, i.e.
 * oscnt has finished counting.
 *
 * Values:
 * - 0 - interrupt is not genrerated due to on board oscillator ready
 * - 1 - interrupt genrerated due to on board oscillator ready
 */
/*@{*/
#define BP_CCM_CISR_cosc_ready (6U)        /*!< Bit position for CCM_CISR_cosc_ready. */
#define BM_CCM_CISR_cosc_ready (0x00000040U) /*!< Bit mask for CCM_CISR_cosc_ready. */
#define BS_CCM_CISR_cosc_ready (1U)        /*!< Bit field size in bits for CCM_CISR_cosc_ready. */

/*! @brief Read current value of the CCM_CISR_cosc_ready field. */
#define BR_CCM_CISR_cosc_ready(x) (HW_CCM_CISR(x).B.cosc_ready)

/*! @brief Format value for bitfield CCM_CISR_cosc_ready. */
#define BF_CCM_CISR_cosc_ready(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_cosc_ready) & BM_CCM_CISR_cosc_ready)

/*! @brief Set the cosc_ready field to a new value. */
#define BW_CCM_CISR_cosc_ready(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_cosc_ready) | BF_CCM_CISR_cosc_ready(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field axi_podf_loaded[17] (W1C)
 *
 * CCM interrupt request 1 generated due to frequency change of axi_podf
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of axi_podf
 * - 1 - interrupt genrerated due to frequency change of axi_podf
 */
/*@{*/
#define BP_CCM_CISR_axi_podf_loaded (17U)  /*!< Bit position for CCM_CISR_axi_podf_loaded. */
#define BM_CCM_CISR_axi_podf_loaded (0x00020000U) /*!< Bit mask for CCM_CISR_axi_podf_loaded. */
#define BS_CCM_CISR_axi_podf_loaded (1U)   /*!< Bit field size in bits for CCM_CISR_axi_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_axi_podf_loaded field. */
#define BR_CCM_CISR_axi_podf_loaded(x) (HW_CCM_CISR(x).B.axi_podf_loaded)

/*! @brief Format value for bitfield CCM_CISR_axi_podf_loaded. */
#define BF_CCM_CISR_axi_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_axi_podf_loaded) & BM_CCM_CISR_axi_podf_loaded)

/*! @brief Set the axi_podf_loaded field to a new value. */
#define BW_CCM_CISR_axi_podf_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_axi_podf_loaded) | BF_CCM_CISR_axi_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field mmdc_ch0_axi_podf_loaded[18] (ROZ)
 *
 * CCM interrupt request 1 generated due to frequency change of mmdc_ch0_axi_podf
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of mmdc_ch0_axi_podf
 * - 1 - interrupt genrerated due to frequency change of mmdc_ch0_axi_podf
 */
/*@{*/
#define BP_CCM_CISR_mmdc_ch0_axi_podf_loaded (18U) /*!< Bit position for CCM_CISR_mmdc_ch0_axi_podf_loaded. */
#define BM_CCM_CISR_mmdc_ch0_axi_podf_loaded (0x00040000U) /*!< Bit mask for CCM_CISR_mmdc_ch0_axi_podf_loaded. */
#define BS_CCM_CISR_mmdc_ch0_axi_podf_loaded (1U) /*!< Bit field size in bits for CCM_CISR_mmdc_ch0_axi_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_mmdc_ch0_axi_podf_loaded field. */
#define BR_CCM_CISR_mmdc_ch0_axi_podf_loaded(x) (HW_CCM_CISR(x).B.mmdc_ch0_axi_podf_loaded)
/*@}*/

/*!
 * @name Register CCM_CISR, field periph2_clk_sel_loaded[19] (W1C)
 *
 * CCM interrupt request 1 generated due to frequency change of periph2_clk_sel
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of periph2_clk_sel
 * - 1 - interrupt genrerated due to frequency change of periph2_clk_sel
 */
/*@{*/
#define BP_CCM_CISR_periph2_clk_sel_loaded (19U) /*!< Bit position for CCM_CISR_periph2_clk_sel_loaded. */
#define BM_CCM_CISR_periph2_clk_sel_loaded (0x00080000U) /*!< Bit mask for CCM_CISR_periph2_clk_sel_loaded. */
#define BS_CCM_CISR_periph2_clk_sel_loaded (1U) /*!< Bit field size in bits for CCM_CISR_periph2_clk_sel_loaded. */

/*! @brief Read current value of the CCM_CISR_periph2_clk_sel_loaded field. */
#define BR_CCM_CISR_periph2_clk_sel_loaded(x) (HW_CCM_CISR(x).B.periph2_clk_sel_loaded)

/*! @brief Format value for bitfield CCM_CISR_periph2_clk_sel_loaded. */
#define BF_CCM_CISR_periph2_clk_sel_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_periph2_clk_sel_loaded) & BM_CCM_CISR_periph2_clk_sel_loaded)

/*! @brief Set the periph2_clk_sel_loaded field to a new value. */
#define BW_CCM_CISR_periph2_clk_sel_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_periph2_clk_sel_loaded) | BF_CCM_CISR_periph2_clk_sel_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field ahb_podf_loaded[20] (W1C)
 *
 * CCM interrupt request 1 generated due to frequency change of ahb_podf
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of ahb_podf
 * - 1 - interrupt genrerated due to frequency change of ahb_podf
 */
/*@{*/
#define BP_CCM_CISR_ahb_podf_loaded (20U)  /*!< Bit position for CCM_CISR_ahb_podf_loaded. */
#define BM_CCM_CISR_ahb_podf_loaded (0x00100000U) /*!< Bit mask for CCM_CISR_ahb_podf_loaded. */
#define BS_CCM_CISR_ahb_podf_loaded (1U)   /*!< Bit field size in bits for CCM_CISR_ahb_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_ahb_podf_loaded field. */
#define BR_CCM_CISR_ahb_podf_loaded(x) (HW_CCM_CISR(x).B.ahb_podf_loaded)

/*! @brief Format value for bitfield CCM_CISR_ahb_podf_loaded. */
#define BF_CCM_CISR_ahb_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_ahb_podf_loaded) & BM_CCM_CISR_ahb_podf_loaded)

/*! @brief Set the ahb_podf_loaded field to a new value. */
#define BW_CCM_CISR_ahb_podf_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_ahb_podf_loaded) | BF_CCM_CISR_ahb_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field mmdc_root_podf_loaded[21] (W1C)
 *
 * CCM interrupt request 1 generated due to frequency change of mmdc_ch0_podf_
 * loaded
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of mmdc_ch0_podf_
 *     loaded
 * - 1 - interrupt genrerated due to frequency change of mmdc_ch0_podf_ loaded
 */
/*@{*/
#define BP_CCM_CISR_mmdc_root_podf_loaded (21U) /*!< Bit position for CCM_CISR_mmdc_root_podf_loaded. */
#define BM_CCM_CISR_mmdc_root_podf_loaded (0x00200000U) /*!< Bit mask for CCM_CISR_mmdc_root_podf_loaded. */
#define BS_CCM_CISR_mmdc_root_podf_loaded (1U) /*!< Bit field size in bits for CCM_CISR_mmdc_root_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_mmdc_root_podf_loaded field. */
#define BR_CCM_CISR_mmdc_root_podf_loaded(x) (HW_CCM_CISR(x).B.mmdc_root_podf_loaded)

/*! @brief Format value for bitfield CCM_CISR_mmdc_root_podf_loaded. */
#define BF_CCM_CISR_mmdc_root_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_mmdc_root_podf_loaded) & BM_CCM_CISR_mmdc_root_podf_loaded)

/*! @brief Set the mmdc_root_podf_loaded field to a new value. */
#define BW_CCM_CISR_mmdc_root_podf_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_mmdc_root_podf_loaded) | BF_CCM_CISR_mmdc_root_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field periph_clk_sel_loaded[22] (W1C)
 *
 * CCM interrupt request 1 generated due to update of periph_clk_sel.
 *
 * Values:
 * - 0 - interrupt is not genrerated due to update of periph_clk_sel.
 * - 1 - interrupt genrerated due to update of periph_clk_sel.
 */
/*@{*/
#define BP_CCM_CISR_periph_clk_sel_loaded (22U) /*!< Bit position for CCM_CISR_periph_clk_sel_loaded. */
#define BM_CCM_CISR_periph_clk_sel_loaded (0x00400000U) /*!< Bit mask for CCM_CISR_periph_clk_sel_loaded. */
#define BS_CCM_CISR_periph_clk_sel_loaded (1U) /*!< Bit field size in bits for CCM_CISR_periph_clk_sel_loaded. */

/*! @brief Read current value of the CCM_CISR_periph_clk_sel_loaded field. */
#define BR_CCM_CISR_periph_clk_sel_loaded(x) (HW_CCM_CISR(x).B.periph_clk_sel_loaded)

/*! @brief Format value for bitfield CCM_CISR_periph_clk_sel_loaded. */
#define BF_CCM_CISR_periph_clk_sel_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_periph_clk_sel_loaded) & BM_CCM_CISR_periph_clk_sel_loaded)

/*! @brief Set the periph_clk_sel_loaded field to a new value. */
#define BW_CCM_CISR_periph_clk_sel_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_periph_clk_sel_loaded) | BF_CCM_CISR_periph_clk_sel_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field mmdc_ch0_podf_loaded[23] (W1C)
 *
 * CCM interrupt request 1 generated due to update of mmdc_ch0_axi_podf.
 *
 * Values:
 * - 0 - interrupt is not genrerated due to update of mmdc_ch0_axi_podf.
 * - 1 - interrupt genrerated due to update of mmdc_ch0_axi_podf*
 */
/*@{*/
#define BP_CCM_CISR_mmdc_ch0_podf_loaded (23U) /*!< Bit position for CCM_CISR_mmdc_ch0_podf_loaded. */
#define BM_CCM_CISR_mmdc_ch0_podf_loaded (0x00800000U) /*!< Bit mask for CCM_CISR_mmdc_ch0_podf_loaded. */
#define BS_CCM_CISR_mmdc_ch0_podf_loaded (1U) /*!< Bit field size in bits for CCM_CISR_mmdc_ch0_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_mmdc_ch0_podf_loaded field. */
#define BR_CCM_CISR_mmdc_ch0_podf_loaded(x) (HW_CCM_CISR(x).B.mmdc_ch0_podf_loaded)

/*! @brief Format value for bitfield CCM_CISR_mmdc_ch0_podf_loaded. */
#define BF_CCM_CISR_mmdc_ch0_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_mmdc_ch0_podf_loaded) & BM_CCM_CISR_mmdc_ch0_podf_loaded)

/*! @brief Set the mmdc_ch0_podf_loaded field to a new value. */
#define BW_CCM_CISR_mmdc_ch0_podf_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_mmdc_ch0_podf_loaded) | BF_CCM_CISR_mmdc_ch0_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CISR, field arm_podf_loaded[26] (W1C)
 *
 * CCM interrupt request 1 generated due to frequency change of arm_podf. The
 * interrupt will commence only if arm_podf is loaded during a arm dvfs operation.
 *
 * Values:
 * - 0 - interrupt is not genrerated due to frequency change of arm_podf
 * - 1 - interrupt genrerated due to frequency change of arm_podf
 */
/*@{*/
#define BP_CCM_CISR_arm_podf_loaded (26U)  /*!< Bit position for CCM_CISR_arm_podf_loaded. */
#define BM_CCM_CISR_arm_podf_loaded (0x04000000U) /*!< Bit mask for CCM_CISR_arm_podf_loaded. */
#define BS_CCM_CISR_arm_podf_loaded (1U)   /*!< Bit field size in bits for CCM_CISR_arm_podf_loaded. */

/*! @brief Read current value of the CCM_CISR_arm_podf_loaded field. */
#define BR_CCM_CISR_arm_podf_loaded(x) (HW_CCM_CISR(x).B.arm_podf_loaded)

/*! @brief Format value for bitfield CCM_CISR_arm_podf_loaded. */
#define BF_CCM_CISR_arm_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CISR_arm_podf_loaded) & BM_CCM_CISR_arm_podf_loaded)

/*! @brief Set the arm_podf_loaded field to a new value. */
#define BW_CCM_CISR_arm_podf_loaded(x, v) (HW_CCM_CISR_WR(x, (HW_CCM_CISR_RD(x) & ~BM_CCM_CISR_arm_podf_loaded) | BF_CCM_CISR_arm_podf_loaded(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CIMR - CCM Interrupt Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CIMR - CCM Interrupt Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Interrupt Mask Register (CIMR). The table
 * below provides its field descriptions.
 */
typedef union _hw_ccm_cimr
{
    uint32_t U;
    struct _hw_ccm_cimr_bitfields
    {
        uint32_t mask_lrf_pll : 1;     /*!< [0]  */
        uint32_t RESERVED0 : 5;        /*!< [5:1]  */
        uint32_t mask_cosc_ready : 1;  /*!< [6]  */
        uint32_t RESERVED1 : 10;       /*!< [16:7]  */
        uint32_t mask_axi_podf_loaded : 1; /*!< [17]  */
        uint32_t mask_mmdc_ch0_axi_podf_loaded : 1; /*!< [18]  */
        uint32_t mask_periph2_clk_sel_loaded : 1; /*!< [19]  */
        uint32_t mask_ahb_podf_loaded : 1; /*!< [20]  */
        uint32_t mask_mmdc_root_podf_loaded : 1; /*!< [21]  */
        uint32_t mask_periph_clk_sel_loaded : 1; /*!< [22]  */
        uint32_t mask_mmdc_ch0_podf_loaded : 1; /*!< [23]  */
        uint32_t RESERVED2 : 2;        /*!< [25:24]  */
        uint32_t arm_podf_loaded : 1;  /*!< [26]  */
        uint32_t RESERVED3 : 5;        /*!< [31:27]  */
    } B;
} hw_ccm_cimr_t;

/*!
 * @name Constants and macros for entire CCM_CIMR register
 */
/*@{*/
#define HW_CCM_CIMR_ADDR(x)      ((uintptr_t)(x) + 0x5CU)

#define HW_CCM_CIMR(x)           (*(__IO hw_ccm_cimr_t *) HW_CCM_CIMR_ADDR(x))
#define HW_CCM_CIMR_RD(x)        (HW_CCM_CIMR(x).U)
#define HW_CCM_CIMR_WR(x, v)     (HW_CCM_CIMR(x).U = (v))
#define HW_CCM_CIMR_SET(x, v)    (HW_CCM_CIMR_WR(x, HW_CCM_CIMR_RD(x) |  (v)))
#define HW_CCM_CIMR_CLR(x, v)    (HW_CCM_CIMR_WR(x, HW_CCM_CIMR_RD(x) & ~(v)))
#define HW_CCM_CIMR_TOG(x, v)    (HW_CCM_CIMR_WR(x, HW_CCM_CIMR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CIMR bitfields
 */

/*!
 * @name Register CCM_CIMR, field mask_lrf_pll[0] (RW)
 *
 * mask interrupt generation due to lrf of PLLs
 *
 * Values:
 * - 0 - don't mask interrupt due to lrf of PLLs - interrupt will be created
 * - 1 - mask interrupt due to lrf of PLLs
 */
/*@{*/
#define BP_CCM_CIMR_mask_lrf_pll (0U)      /*!< Bit position for CCM_CIMR_mask_lrf_pll. */
#define BM_CCM_CIMR_mask_lrf_pll (0x00000001U) /*!< Bit mask for CCM_CIMR_mask_lrf_pll. */
#define BS_CCM_CIMR_mask_lrf_pll (1U)      /*!< Bit field size in bits for CCM_CIMR_mask_lrf_pll. */

/*! @brief Read current value of the CCM_CIMR_mask_lrf_pll field. */
#define BR_CCM_CIMR_mask_lrf_pll(x) (HW_CCM_CIMR(x).B.mask_lrf_pll)

/*! @brief Format value for bitfield CCM_CIMR_mask_lrf_pll. */
#define BF_CCM_CIMR_mask_lrf_pll(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_lrf_pll) & BM_CCM_CIMR_mask_lrf_pll)

/*! @brief Set the mask_lrf_pll field to a new value. */
#define BW_CCM_CIMR_mask_lrf_pll(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_lrf_pll) | BF_CCM_CIMR_mask_lrf_pll(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_cosc_ready[6] (RW)
 *
 * mask interrupt generation due to on board oscillator ready
 *
 * Values:
 * - 0 - don't mask interrupt due to on board oscillator ready - interrupt will
 *     be created
 * - 1 - mask interrupt due to on board oscillator ready
 */
/*@{*/
#define BP_CCM_CIMR_mask_cosc_ready (6U)   /*!< Bit position for CCM_CIMR_mask_cosc_ready. */
#define BM_CCM_CIMR_mask_cosc_ready (0x00000040U) /*!< Bit mask for CCM_CIMR_mask_cosc_ready. */
#define BS_CCM_CIMR_mask_cosc_ready (1U)   /*!< Bit field size in bits for CCM_CIMR_mask_cosc_ready. */

/*! @brief Read current value of the CCM_CIMR_mask_cosc_ready field. */
#define BR_CCM_CIMR_mask_cosc_ready(x) (HW_CCM_CIMR(x).B.mask_cosc_ready)

/*! @brief Format value for bitfield CCM_CIMR_mask_cosc_ready. */
#define BF_CCM_CIMR_mask_cosc_ready(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_cosc_ready) & BM_CCM_CIMR_mask_cosc_ready)

/*! @brief Set the mask_cosc_ready field to a new value. */
#define BW_CCM_CIMR_mask_cosc_ready(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_cosc_ready) | BF_CCM_CIMR_mask_cosc_ready(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_axi_podf_loaded[17] (RW)
 *
 * mask interrupt generation due to frequency change of axi_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to frequency change of axi_podf - interrupt
 *     will be created
 * - 1 - mask interrupt due to frequency change of axi_podf
 */
/*@{*/
#define BP_CCM_CIMR_mask_axi_podf_loaded (17U) /*!< Bit position for CCM_CIMR_mask_axi_podf_loaded. */
#define BM_CCM_CIMR_mask_axi_podf_loaded (0x00020000U) /*!< Bit mask for CCM_CIMR_mask_axi_podf_loaded. */
#define BS_CCM_CIMR_mask_axi_podf_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_axi_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_axi_podf_loaded field. */
#define BR_CCM_CIMR_mask_axi_podf_loaded(x) (HW_CCM_CIMR(x).B.mask_axi_podf_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_axi_podf_loaded. */
#define BF_CCM_CIMR_mask_axi_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_axi_podf_loaded) & BM_CCM_CIMR_mask_axi_podf_loaded)

/*! @brief Set the mask_axi_podf_loaded field to a new value. */
#define BW_CCM_CIMR_mask_axi_podf_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_axi_podf_loaded) | BF_CCM_CIMR_mask_axi_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_mmdc_ch0_axi_podf_loaded[18] (RO)
 *
 * mask interrupt generation due to frequency change of mmdc_ch0_axi_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to frequency change of mmdc_ch0_axi_podf -
 *     interrupt will be created
 * - 1 - mask interrupt due to frequency change of mmdc_ch0_axi_podf
 */
/*@{*/
#define BP_CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded (18U) /*!< Bit position for CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded. */
#define BM_CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded (0x00040000U) /*!< Bit mask for CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded. */
#define BS_CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded field. */
#define BR_CCM_CIMR_mask_mmdc_ch0_axi_podf_loaded(x) (HW_CCM_CIMR(x).B.mask_mmdc_ch0_axi_podf_loaded)
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_periph2_clk_sel_loaded[19] (RW)
 *
 * mask interrupt generation due to update of periph2_clk_sel.
 *
 * Values:
 * - 0 - don't mask interrupt due to update of periph2_clk_sel - interrupt will
 *     be created
 * - 1 - mask interrupt due to update of periph2_clk_sel
 */
/*@{*/
#define BP_CCM_CIMR_mask_periph2_clk_sel_loaded (19U) /*!< Bit position for CCM_CIMR_mask_periph2_clk_sel_loaded. */
#define BM_CCM_CIMR_mask_periph2_clk_sel_loaded (0x00080000U) /*!< Bit mask for CCM_CIMR_mask_periph2_clk_sel_loaded. */
#define BS_CCM_CIMR_mask_periph2_clk_sel_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_periph2_clk_sel_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_periph2_clk_sel_loaded field. */
#define BR_CCM_CIMR_mask_periph2_clk_sel_loaded(x) (HW_CCM_CIMR(x).B.mask_periph2_clk_sel_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_periph2_clk_sel_loaded. */
#define BF_CCM_CIMR_mask_periph2_clk_sel_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_periph2_clk_sel_loaded) & BM_CCM_CIMR_mask_periph2_clk_sel_loaded)

/*! @brief Set the mask_periph2_clk_sel_loaded field to a new value. */
#define BW_CCM_CIMR_mask_periph2_clk_sel_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_periph2_clk_sel_loaded) | BF_CCM_CIMR_mask_periph2_clk_sel_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_ahb_podf_loaded[20] (RW)
 *
 * mask interrupt generation due to frequency change of ahb_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to frequency change of ahb_podf - interrupt
 *     will be created
 * - 1 - mask interrupt due to frequency change of ahb_podf
 */
/*@{*/
#define BP_CCM_CIMR_mask_ahb_podf_loaded (20U) /*!< Bit position for CCM_CIMR_mask_ahb_podf_loaded. */
#define BM_CCM_CIMR_mask_ahb_podf_loaded (0x00100000U) /*!< Bit mask for CCM_CIMR_mask_ahb_podf_loaded. */
#define BS_CCM_CIMR_mask_ahb_podf_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_ahb_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_ahb_podf_loaded field. */
#define BR_CCM_CIMR_mask_ahb_podf_loaded(x) (HW_CCM_CIMR(x).B.mask_ahb_podf_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_ahb_podf_loaded. */
#define BF_CCM_CIMR_mask_ahb_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_ahb_podf_loaded) & BM_CCM_CIMR_mask_ahb_podf_loaded)

/*! @brief Set the mask_ahb_podf_loaded field to a new value. */
#define BW_CCM_CIMR_mask_ahb_podf_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_ahb_podf_loaded) | BF_CCM_CIMR_mask_ahb_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_mmdc_root_podf_loaded[21] (RW)
 *
 * mask interrupt generation due to update of mask_mmdc_root_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to update of mask_mmdc_root_podf - interrupt
 *     will be created
 * - 1 - mask interrupt due to update of mask_mmdc_root_podf
 */
/*@{*/
#define BP_CCM_CIMR_mask_mmdc_root_podf_loaded (21U) /*!< Bit position for CCM_CIMR_mask_mmdc_root_podf_loaded. */
#define BM_CCM_CIMR_mask_mmdc_root_podf_loaded (0x00200000U) /*!< Bit mask for CCM_CIMR_mask_mmdc_root_podf_loaded. */
#define BS_CCM_CIMR_mask_mmdc_root_podf_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_mmdc_root_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_mmdc_root_podf_loaded field. */
#define BR_CCM_CIMR_mask_mmdc_root_podf_loaded(x) (HW_CCM_CIMR(x).B.mask_mmdc_root_podf_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_mmdc_root_podf_loaded. */
#define BF_CCM_CIMR_mask_mmdc_root_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_mmdc_root_podf_loaded) & BM_CCM_CIMR_mask_mmdc_root_podf_loaded)

/*! @brief Set the mask_mmdc_root_podf_loaded field to a new value. */
#define BW_CCM_CIMR_mask_mmdc_root_podf_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_mmdc_root_podf_loaded) | BF_CCM_CIMR_mask_mmdc_root_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_periph_clk_sel_loaded[22] (RW)
 *
 * mask interrupt generation due to update of periph_clk_sel.
 *
 * Values:
 * - 0 - don't mask interrupt due to update of periph_clk_sel - interrupt will
 *     be created
 * - 1 - mask interrupt due to update of periph_clk_sel
 */
/*@{*/
#define BP_CCM_CIMR_mask_periph_clk_sel_loaded (22U) /*!< Bit position for CCM_CIMR_mask_periph_clk_sel_loaded. */
#define BM_CCM_CIMR_mask_periph_clk_sel_loaded (0x00400000U) /*!< Bit mask for CCM_CIMR_mask_periph_clk_sel_loaded. */
#define BS_CCM_CIMR_mask_periph_clk_sel_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_periph_clk_sel_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_periph_clk_sel_loaded field. */
#define BR_CCM_CIMR_mask_periph_clk_sel_loaded(x) (HW_CCM_CIMR(x).B.mask_periph_clk_sel_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_periph_clk_sel_loaded. */
#define BF_CCM_CIMR_mask_periph_clk_sel_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_periph_clk_sel_loaded) & BM_CCM_CIMR_mask_periph_clk_sel_loaded)

/*! @brief Set the mask_periph_clk_sel_loaded field to a new value. */
#define BW_CCM_CIMR_mask_periph_clk_sel_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_periph_clk_sel_loaded) | BF_CCM_CIMR_mask_periph_clk_sel_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field mask_mmdc_ch0_podf_loaded[23] (RW)
 *
 * mask interrupt generation due to update of mask_mmdc_ch0_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to update of mask_mmdc_ch0_podf - interrupt
 *     will be created
 * - 1 - mask interrupt due to update of mask_mmdc_ch0_podf
 */
/*@{*/
#define BP_CCM_CIMR_mask_mmdc_ch0_podf_loaded (23U) /*!< Bit position for CCM_CIMR_mask_mmdc_ch0_podf_loaded. */
#define BM_CCM_CIMR_mask_mmdc_ch0_podf_loaded (0x00800000U) /*!< Bit mask for CCM_CIMR_mask_mmdc_ch0_podf_loaded. */
#define BS_CCM_CIMR_mask_mmdc_ch0_podf_loaded (1U) /*!< Bit field size in bits for CCM_CIMR_mask_mmdc_ch0_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_mask_mmdc_ch0_podf_loaded field. */
#define BR_CCM_CIMR_mask_mmdc_ch0_podf_loaded(x) (HW_CCM_CIMR(x).B.mask_mmdc_ch0_podf_loaded)

/*! @brief Format value for bitfield CCM_CIMR_mask_mmdc_ch0_podf_loaded. */
#define BF_CCM_CIMR_mask_mmdc_ch0_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_mask_mmdc_ch0_podf_loaded) & BM_CCM_CIMR_mask_mmdc_ch0_podf_loaded)

/*! @brief Set the mask_mmdc_ch0_podf_loaded field to a new value. */
#define BW_CCM_CIMR_mask_mmdc_ch0_podf_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_mask_mmdc_ch0_podf_loaded) | BF_CCM_CIMR_mask_mmdc_ch0_podf_loaded(v)))
/*@}*/

/*!
 * @name Register CCM_CIMR, field arm_podf_loaded[26] (RW)
 *
 * mask interrupt generation due to frequency change of arm_podf
 *
 * Values:
 * - 0 - don't mask interrupt due to frequency change of arm_podf - interrupt
 *     will be created
 * - 1 - mask interrupt due to frequency change of arm_podf
 */
/*@{*/
#define BP_CCM_CIMR_arm_podf_loaded (26U)  /*!< Bit position for CCM_CIMR_arm_podf_loaded. */
#define BM_CCM_CIMR_arm_podf_loaded (0x04000000U) /*!< Bit mask for CCM_CIMR_arm_podf_loaded. */
#define BS_CCM_CIMR_arm_podf_loaded (1U)   /*!< Bit field size in bits for CCM_CIMR_arm_podf_loaded. */

/*! @brief Read current value of the CCM_CIMR_arm_podf_loaded field. */
#define BR_CCM_CIMR_arm_podf_loaded(x) (HW_CCM_CIMR(x).B.arm_podf_loaded)

/*! @brief Format value for bitfield CCM_CIMR_arm_podf_loaded. */
#define BF_CCM_CIMR_arm_podf_loaded(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CIMR_arm_podf_loaded) & BM_CCM_CIMR_arm_podf_loaded)

/*! @brief Set the arm_podf_loaded field to a new value. */
#define BW_CCM_CIMR_arm_podf_loaded(x, v) (HW_CCM_CIMR_WR(x, (HW_CCM_CIMR_RD(x) & ~BM_CCM_CIMR_arm_podf_loaded) | BF_CCM_CIMR_arm_podf_loaded(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCOSR - CCM Clock Output Source Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCOSR - CCM Clock Output Source Register (RW)
 *
 * Reset value: 0x000A0001U
 *
 * The figure below represents the CCM Clock Output Source Register (CCOSR). The
 * CCOSR register contains bits to control the clock that will be generated on
 * the output ipp_do_clko1 (CCM_CLKO).The table below provides its field
 * descriptions.
 */
typedef union _hw_ccm_ccosr
{
    uint32_t U;
    struct _hw_ccm_ccosr_bitfields
    {
        uint32_t CLKO_SEL : 4;         /*!< [3:0]  */
        uint32_t CLKO1_DIV : 3;        /*!< [6:4]  */
        uint32_t CLKO1_EN : 1;         /*!< [7]  */
        uint32_t CLK_OUT_SEL : 1;      /*!< [8]  */
        uint32_t RESERVED0 : 7;        /*!< [15:9]  */
        uint32_t CLKO2_SEL : 5;        /*!< [20:16]  */
        uint32_t CLKO2_DIV : 3;        /*!< [23:21]  */
        uint32_t CLKO2_EN : 1;         /*!< [24]  */
        uint32_t RESERVED1 : 7;        /*!< [31:25]  */
    } B;
} hw_ccm_ccosr_t;

/*!
 * @name Constants and macros for entire CCM_CCOSR register
 */
/*@{*/
#define HW_CCM_CCOSR_ADDR(x)     ((uintptr_t)(x) + 0x60U)

#define HW_CCM_CCOSR(x)          (*(__IO hw_ccm_ccosr_t *) HW_CCM_CCOSR_ADDR(x))
#define HW_CCM_CCOSR_RD(x)       (HW_CCM_CCOSR(x).U)
#define HW_CCM_CCOSR_WR(x, v)    (HW_CCM_CCOSR(x).U = (v))
#define HW_CCM_CCOSR_SET(x, v)   (HW_CCM_CCOSR_WR(x, HW_CCM_CCOSR_RD(x) |  (v)))
#define HW_CCM_CCOSR_CLR(x, v)   (HW_CCM_CCOSR_WR(x, HW_CCM_CCOSR_RD(x) & ~(v)))
#define HW_CCM_CCOSR_TOG(x, v)   (HW_CCM_CCOSR_WR(x, HW_CCM_CCOSR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCOSR bitfields
 */

/*!
 * @name Register CCM_CCOSR, field CLKO_SEL[3:0] (RW)
 *
 * Selection of the clock to be generated on CCM_CLKO1
 *
 * Values:
 * - 0000 - pll3_sw_clk (this inputs has additional constant division /2)
 * - 0001 - pll2_main_clk (default) (this inputs has additional constant
 *     division /2)
 * - 0010 - pll1_main_clk (this inputs has additional constant division /2)
 * - 0011 - pll5_main_clk (this inputs has additional constant division /2)
 * - 0101 - ocram_clk_root
 * - 0111 - pxp_axi_clk_root
 * - 1000 - epdc_axi_clk_root
 * - 1001 - lcdif_pix_clk_root
 * - 1010 - epdc_pix_clk_root
 * - 1011 - ahb_clk_root
 * - 1100 - ipg_clk_root
 * - 1101 - perclk_root
 * - 1110 - ckil_sync_clk_root
 * - 1111 - pll4_main_clk
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO_SEL (0U)         /*!< Bit position for CCM_CCOSR_CLKO_SEL. */
#define BM_CCM_CCOSR_CLKO_SEL (0x0000000FU) /*!< Bit mask for CCM_CCOSR_CLKO_SEL. */
#define BS_CCM_CCOSR_CLKO_SEL (4U)         /*!< Bit field size in bits for CCM_CCOSR_CLKO_SEL. */

/*! @brief Read current value of the CCM_CCOSR_CLKO_SEL field. */
#define BR_CCM_CCOSR_CLKO_SEL(x) (HW_CCM_CCOSR(x).B.CLKO_SEL)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO_SEL. */
#define BF_CCM_CCOSR_CLKO_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO_SEL) & BM_CCM_CCOSR_CLKO_SEL)

/*! @brief Set the CLKO_SEL field to a new value. */
#define BW_CCM_CCOSR_CLKO_SEL(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO_SEL) | BF_CCM_CCOSR_CLKO_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLKO1_DIV[6:4] (RW)
 *
 * Setting the divider of CCM_CLKO1
 *
 * Values:
 * - 000 - divide by 1(default)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO1_DIV (4U)        /*!< Bit position for CCM_CCOSR_CLKO1_DIV. */
#define BM_CCM_CCOSR_CLKO1_DIV (0x00000070U) /*!< Bit mask for CCM_CCOSR_CLKO1_DIV. */
#define BS_CCM_CCOSR_CLKO1_DIV (3U)        /*!< Bit field size in bits for CCM_CCOSR_CLKO1_DIV. */

/*! @brief Read current value of the CCM_CCOSR_CLKO1_DIV field. */
#define BR_CCM_CCOSR_CLKO1_DIV(x) (HW_CCM_CCOSR(x).B.CLKO1_DIV)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO1_DIV. */
#define BF_CCM_CCOSR_CLKO1_DIV(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO1_DIV) & BM_CCM_CCOSR_CLKO1_DIV)

/*! @brief Set the CLKO1_DIV field to a new value. */
#define BW_CCM_CCOSR_CLKO1_DIV(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO1_DIV) | BF_CCM_CCOSR_CLKO1_DIV(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLKO1_EN[7] (RW)
 *
 * Enable of CCM_CLKO1 clock
 *
 * Values:
 * - 0 - CCM_CLKO1 disabled.
 * - 1 - CCM_CLKO1 enabled.
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO1_EN (7U)         /*!< Bit position for CCM_CCOSR_CLKO1_EN. */
#define BM_CCM_CCOSR_CLKO1_EN (0x00000080U) /*!< Bit mask for CCM_CCOSR_CLKO1_EN. */
#define BS_CCM_CCOSR_CLKO1_EN (1U)         /*!< Bit field size in bits for CCM_CCOSR_CLKO1_EN. */

/*! @brief Read current value of the CCM_CCOSR_CLKO1_EN field. */
#define BR_CCM_CCOSR_CLKO1_EN(x) (HW_CCM_CCOSR(x).B.CLKO1_EN)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO1_EN. */
#define BF_CCM_CCOSR_CLKO1_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO1_EN) & BM_CCM_CCOSR_CLKO1_EN)

/*! @brief Set the CLKO1_EN field to a new value. */
#define BW_CCM_CCOSR_CLKO1_EN(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO1_EN) | BF_CCM_CCOSR_CLKO1_EN(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLK_OUT_SEL[8] (RW)
 *
 * CCM_CLKO1 output to reflect CCM_CLKO1 or CCM_CLKO2 clocks
 *
 * Values:
 * - 0 - CCM_CLKO1 output drives CCM_CLKO1 clock
 * - 1 - CCM_CLKO1 output drives CCM_CLKO2 clock
 */
/*@{*/
#define BP_CCM_CCOSR_CLK_OUT_SEL (8U)      /*!< Bit position for CCM_CCOSR_CLK_OUT_SEL. */
#define BM_CCM_CCOSR_CLK_OUT_SEL (0x00000100U) /*!< Bit mask for CCM_CCOSR_CLK_OUT_SEL. */
#define BS_CCM_CCOSR_CLK_OUT_SEL (1U)      /*!< Bit field size in bits for CCM_CCOSR_CLK_OUT_SEL. */

/*! @brief Read current value of the CCM_CCOSR_CLK_OUT_SEL field. */
#define BR_CCM_CCOSR_CLK_OUT_SEL(x) (HW_CCM_CCOSR(x).B.CLK_OUT_SEL)

/*! @brief Format value for bitfield CCM_CCOSR_CLK_OUT_SEL. */
#define BF_CCM_CCOSR_CLK_OUT_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLK_OUT_SEL) & BM_CCM_CCOSR_CLK_OUT_SEL)

/*! @brief Set the CLK_OUT_SEL field to a new value. */
#define BW_CCM_CCOSR_CLK_OUT_SEL(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLK_OUT_SEL) | BF_CCM_CCOSR_CLK_OUT_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLKO2_SEL[20:16] (RW)
 *
 * Selection of the clock to be generated on CCM_CLKO2
 *
 * Values:
 * - 00000 - mmdc_ch0_axi_clk_root
 * - 00001 - mmdc_root_axi_clk_root
 * - 00010 - usdhc4_clk_root
 * - 00011 - usdhc1_clk_root
 * - 00101 - wrck_clk_root
 * - 00110 - ecspi_clk_root
 * - 01000 - usdhc3_clk_root
 * - 01001 - pcie_clk_root
 * - 01010 - arm_clk_root (default)
 * - 01011 - csi_core
 * - 01100 - lcdif_axi
 * - 01110 - osc_clk
 * - 10000 - gpu2d_ovg_core_clk_root
 * - 10001 - usdhc2_clk_root
 * - 10010 - ssi1_clk_root
 * - 10011 - ssi2_clk_root
 * - 10100 - ssi3_clk_root
 * - 10101 - gpu2d_core_clk_root
 * - 11010 - extern_audio_clk_root
 * - 11011 - aclk_eim_slow_clk_root
 * - 11100 - uart_clk_root
 * - 11101 - spdif0_clk_root
 * - 11110 - spdif1_clk_root
 * - 11111 - Reserved
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO2_SEL (16U)       /*!< Bit position for CCM_CCOSR_CLKO2_SEL. */
#define BM_CCM_CCOSR_CLKO2_SEL (0x001F0000U) /*!< Bit mask for CCM_CCOSR_CLKO2_SEL. */
#define BS_CCM_CCOSR_CLKO2_SEL (5U)        /*!< Bit field size in bits for CCM_CCOSR_CLKO2_SEL. */

/*! @brief Read current value of the CCM_CCOSR_CLKO2_SEL field. */
#define BR_CCM_CCOSR_CLKO2_SEL(x) (HW_CCM_CCOSR(x).B.CLKO2_SEL)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO2_SEL. */
#define BF_CCM_CCOSR_CLKO2_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO2_SEL) & BM_CCM_CCOSR_CLKO2_SEL)

/*! @brief Set the CLKO2_SEL field to a new value. */
#define BW_CCM_CCOSR_CLKO2_SEL(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO2_SEL) | BF_CCM_CCOSR_CLKO2_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLKO2_DIV[23:21] (RW)
 *
 * Setting the divider of CCM_CLKO2
 *
 * Values:
 * - 000 - divide by 1 (default)
 * - 001 - divide by 2
 * - 010 - divide by 3
 * - 011 - divide by 4
 * - 100 - divide by 5
 * - 101 - divide by 6
 * - 110 - divide by 7
 * - 111 - divide by 8
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO2_DIV (21U)       /*!< Bit position for CCM_CCOSR_CLKO2_DIV. */
#define BM_CCM_CCOSR_CLKO2_DIV (0x00E00000U) /*!< Bit mask for CCM_CCOSR_CLKO2_DIV. */
#define BS_CCM_CCOSR_CLKO2_DIV (3U)        /*!< Bit field size in bits for CCM_CCOSR_CLKO2_DIV. */

/*! @brief Read current value of the CCM_CCOSR_CLKO2_DIV field. */
#define BR_CCM_CCOSR_CLKO2_DIV(x) (HW_CCM_CCOSR(x).B.CLKO2_DIV)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO2_DIV. */
#define BF_CCM_CCOSR_CLKO2_DIV(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO2_DIV) & BM_CCM_CCOSR_CLKO2_DIV)

/*! @brief Set the CLKO2_DIV field to a new value. */
#define BW_CCM_CCOSR_CLKO2_DIV(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO2_DIV) | BF_CCM_CCOSR_CLKO2_DIV(v)))
/*@}*/

/*!
 * @name Register CCM_CCOSR, field CLKO2_EN[24] (RW)
 *
 * Enable of CCM_CLKO2 clock
 *
 * Values:
 * - 0 - CCM_CLKO2 disabled.
 * - 1 - CCM_CLKO2 enabled.
 */
/*@{*/
#define BP_CCM_CCOSR_CLKO2_EN (24U)        /*!< Bit position for CCM_CCOSR_CLKO2_EN. */
#define BM_CCM_CCOSR_CLKO2_EN (0x01000000U) /*!< Bit mask for CCM_CCOSR_CLKO2_EN. */
#define BS_CCM_CCOSR_CLKO2_EN (1U)         /*!< Bit field size in bits for CCM_CCOSR_CLKO2_EN. */

/*! @brief Read current value of the CCM_CCOSR_CLKO2_EN field. */
#define BR_CCM_CCOSR_CLKO2_EN(x) (HW_CCM_CCOSR(x).B.CLKO2_EN)

/*! @brief Format value for bitfield CCM_CCOSR_CLKO2_EN. */
#define BF_CCM_CCOSR_CLKO2_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCOSR_CLKO2_EN) & BM_CCM_CCOSR_CLKO2_EN)

/*! @brief Set the CLKO2_EN field to a new value. */
#define BW_CCM_CCOSR_CLKO2_EN(x, v) (HW_CCM_CCOSR_WR(x, (HW_CCM_CCOSR_RD(x) & ~BM_CCM_CCOSR_CLKO2_EN) | BF_CCM_CCOSR_CLKO2_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CGPR - CCM General Purpose Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CGPR - CCM General Purpose Register (RW)
 *
 * Reset value: 0x0000FE62U
 *
 * Fast PLL enable. Can be used to engage PLL faster after STOP mode, if 24MHz
 * OSC was active
 */
typedef union _hw_ccm_cgpr
{
    uint32_t U;
    struct _hw_ccm_cgpr_bitfields
    {
        uint32_t pmic_delay_scaler : 1; /*!< [0]  */
        uint32_t RESERVED0 : 1;        /*!< [1]  */
        uint32_t mmdc_ext_clk_dis : 1; /*!< [2]  */
        uint32_t RESERVED1 : 1;        /*!< [3]  */
        uint32_t efuse_prog_supply_gate : 1; /*!< [4]  */
        uint32_t RESERVED2 : 11;       /*!< [15:5]  */
        uint32_t FPL : 1;              /*!< [16] Fast PLL enable. */
        uint32_t RESERVED3 : 15;       /*!< [31:17]  */
    } B;
} hw_ccm_cgpr_t;

/*!
 * @name Constants and macros for entire CCM_CGPR register
 */
/*@{*/
#define HW_CCM_CGPR_ADDR(x)      ((uintptr_t)(x) + 0x64U)

#define HW_CCM_CGPR(x)           (*(__IO hw_ccm_cgpr_t *) HW_CCM_CGPR_ADDR(x))
#define HW_CCM_CGPR_RD(x)        (HW_CCM_CGPR(x).U)
#define HW_CCM_CGPR_WR(x, v)     (HW_CCM_CGPR(x).U = (v))
#define HW_CCM_CGPR_SET(x, v)    (HW_CCM_CGPR_WR(x, HW_CCM_CGPR_RD(x) |  (v)))
#define HW_CCM_CGPR_CLR(x, v)    (HW_CCM_CGPR_WR(x, HW_CCM_CGPR_RD(x) & ~(v)))
#define HW_CCM_CGPR_TOG(x, v)    (HW_CCM_CGPR_WR(x, HW_CCM_CGPR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CGPR bitfields
 */

/*!
 * @name Register CCM_CGPR, field pmic_delay_scaler[0] (RW)
 *
 * Defines clock dividion of clock for stby_count (pmic delay counter)
 *
 * Values:
 * - 0 - clock is not divided
 * - 1 - clock is divided /8
 */
/*@{*/
#define BP_CCM_CGPR_pmic_delay_scaler (0U) /*!< Bit position for CCM_CGPR_pmic_delay_scaler. */
#define BM_CCM_CGPR_pmic_delay_scaler (0x00000001U) /*!< Bit mask for CCM_CGPR_pmic_delay_scaler. */
#define BS_CCM_CGPR_pmic_delay_scaler (1U) /*!< Bit field size in bits for CCM_CGPR_pmic_delay_scaler. */

/*! @brief Read current value of the CCM_CGPR_pmic_delay_scaler field. */
#define BR_CCM_CGPR_pmic_delay_scaler(x) (HW_CCM_CGPR(x).B.pmic_delay_scaler)

/*! @brief Format value for bitfield CCM_CGPR_pmic_delay_scaler. */
#define BF_CCM_CGPR_pmic_delay_scaler(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CGPR_pmic_delay_scaler) & BM_CCM_CGPR_pmic_delay_scaler)

/*! @brief Set the pmic_delay_scaler field to a new value. */
#define BW_CCM_CGPR_pmic_delay_scaler(x, v) (HW_CCM_CGPR_WR(x, (HW_CCM_CGPR_RD(x) & ~BM_CCM_CGPR_pmic_delay_scaler) | BF_CCM_CGPR_pmic_delay_scaler(v)))
/*@}*/

/*!
 * @name Register CCM_CGPR, field mmdc_ext_clk_dis[2] (RW)
 *
 * Disable external clock driver of MMDC during STOP mode
 *
 * Values:
 * - 1 - disable during stop mode
 * - 0 - don't disable during stop mode.
 */
/*@{*/
#define BP_CCM_CGPR_mmdc_ext_clk_dis (2U)  /*!< Bit position for CCM_CGPR_mmdc_ext_clk_dis. */
#define BM_CCM_CGPR_mmdc_ext_clk_dis (0x00000004U) /*!< Bit mask for CCM_CGPR_mmdc_ext_clk_dis. */
#define BS_CCM_CGPR_mmdc_ext_clk_dis (1U)  /*!< Bit field size in bits for CCM_CGPR_mmdc_ext_clk_dis. */

/*! @brief Read current value of the CCM_CGPR_mmdc_ext_clk_dis field. */
#define BR_CCM_CGPR_mmdc_ext_clk_dis(x) (HW_CCM_CGPR(x).B.mmdc_ext_clk_dis)

/*! @brief Format value for bitfield CCM_CGPR_mmdc_ext_clk_dis. */
#define BF_CCM_CGPR_mmdc_ext_clk_dis(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CGPR_mmdc_ext_clk_dis) & BM_CCM_CGPR_mmdc_ext_clk_dis)

/*! @brief Set the mmdc_ext_clk_dis field to a new value. */
#define BW_CCM_CGPR_mmdc_ext_clk_dis(x, v) (HW_CCM_CGPR_WR(x, (HW_CCM_CGPR_RD(x) & ~BM_CCM_CGPR_mmdc_ext_clk_dis) | BF_CCM_CGPR_mmdc_ext_clk_dis(v)))
/*@}*/

/*!
 * @name Register CCM_CGPR, field efuse_prog_supply_gate[4] (RW)
 *
 * Defines the value of the output signal cgpr_dout[4]. Gate of program supply
 * for efuse programing
 *
 * Values:
 * - 0 - fuse programing supply voltage is gated off to the efuse module
 * - 1 - allow fuse programing.
 */
/*@{*/
#define BP_CCM_CGPR_efuse_prog_supply_gate (4U) /*!< Bit position for CCM_CGPR_efuse_prog_supply_gate. */
#define BM_CCM_CGPR_efuse_prog_supply_gate (0x00000010U) /*!< Bit mask for CCM_CGPR_efuse_prog_supply_gate. */
#define BS_CCM_CGPR_efuse_prog_supply_gate (1U) /*!< Bit field size in bits for CCM_CGPR_efuse_prog_supply_gate. */

/*! @brief Read current value of the CCM_CGPR_efuse_prog_supply_gate field. */
#define BR_CCM_CGPR_efuse_prog_supply_gate(x) (HW_CCM_CGPR(x).B.efuse_prog_supply_gate)

/*! @brief Format value for bitfield CCM_CGPR_efuse_prog_supply_gate. */
#define BF_CCM_CGPR_efuse_prog_supply_gate(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CGPR_efuse_prog_supply_gate) & BM_CCM_CGPR_efuse_prog_supply_gate)

/*! @brief Set the efuse_prog_supply_gate field to a new value. */
#define BW_CCM_CGPR_efuse_prog_supply_gate(x, v) (HW_CCM_CGPR_WR(x, (HW_CCM_CGPR_RD(x) & ~BM_CCM_CGPR_efuse_prog_supply_gate) | BF_CCM_CGPR_efuse_prog_supply_gate(v)))
/*@}*/

/*!
 * @name Register CCM_CGPR, field FPL[16] (RW)
 *
 * Values:
 * - 0 - Engage PLL enable default way.
 * - 1 - Engage PLL enable 3 CKIL clocks earlier at exiting low power mode
 *     (STOP). Should be used only if 24MHz OSC was active in low power mode.
 */
/*@{*/
#define BP_CCM_CGPR_FPL      (16U)         /*!< Bit position for CCM_CGPR_FPL. */
#define BM_CCM_CGPR_FPL      (0x00010000U) /*!< Bit mask for CCM_CGPR_FPL. */
#define BS_CCM_CGPR_FPL      (1U)          /*!< Bit field size in bits for CCM_CGPR_FPL. */

/*! @brief Read current value of the CCM_CGPR_FPL field. */
#define BR_CCM_CGPR_FPL(x)   (HW_CCM_CGPR(x).B.FPL)

/*! @brief Format value for bitfield CCM_CGPR_FPL. */
#define BF_CCM_CGPR_FPL(v)   ((uint32_t)((uint32_t)(v) << BP_CCM_CGPR_FPL) & BM_CCM_CGPR_FPL)

/*! @brief Set the FPL field to a new value. */
#define BW_CCM_CGPR_FPL(x, v) (HW_CCM_CGPR_WR(x, (HW_CCM_CGPR_RD(x) & ~BM_CCM_CGPR_FPL) | BF_CCM_CGPR_FPL(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR0 - CCM Clock Gating Register 0
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR0 - CCM Clock Gating Register 0 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * CG(i) bits CCGR 0-6 These bits are used to turn on/off the clock to each
 * module independently. The following table details the possible clock activity
 * conditions for each module. CGR value Clock Activity Description 00 Clock is off
 * during all modes. Stop enter hardware handshake is disabled. 01 Clock is on in
 * run mode, but off in WAIT and STOP modes 10 Not applicable (Reserved). 11
 * Clock is on during all modes, except STOP mode. Module should be stopped, before
 * set its bits to "0"; clocks to the module will be stopped immediately. The
 * tables above show the register mapings for the different CGRs. The clock
 * connectivity table should be used to match the "CCM output affected" to the actual
 * clocks going into the modules. The figure below represents the CCM Clock Gating
 * Register 0 (CCM_CCGR0). The clock gating Registers define the clock gating for
 * power reduction of each clock (CG(i) bits). There are 7 CGR registers. The
 * number of registers required is according to the number of peripherals in the
 * system.
 */
typedef union _hw_ccm_ccgr0
{
    uint32_t U;
    struct _hw_ccm_ccgr0_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr0_t;

/*!
 * @name Constants and macros for entire CCM_CCGR0 register
 */
/*@{*/
#define HW_CCM_CCGR0_ADDR(x)     ((uintptr_t)(x) + 0x68U)

#define HW_CCM_CCGR0(x)          (*(__IO hw_ccm_ccgr0_t *) HW_CCM_CCGR0_ADDR(x))
#define HW_CCM_CCGR0_RD(x)       (HW_CCM_CCGR0(x).U)
#define HW_CCM_CCGR0_WR(x, v)    (HW_CCM_CCGR0(x).U = (v))
#define HW_CCM_CCGR0_SET(x, v)   (HW_CCM_CCGR0_WR(x, HW_CCM_CCGR0_RD(x) |  (v)))
#define HW_CCM_CCGR0_CLR(x, v)   (HW_CCM_CCGR0_WR(x, HW_CCM_CCGR0_RD(x) & ~(v)))
#define HW_CCM_CCGR0_TOG(x, v)   (HW_CCM_CCGR0_WR(x, HW_CCM_CCGR0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR0 bitfields
 */

/*!
 * @name Register CCM_CCGR0, field CG0[1:0] (RW)
 *
 * aips_tz1 clocks (aips_tz1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR0_CG0     (0U)          /*!< Bit position for CCM_CCGR0_CG0. */
#define BM_CCM_CCGR0_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR0_CG0. */
#define BS_CCM_CCGR0_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG0. */

/*! @brief Read current value of the CCM_CCGR0_CG0 field. */
#define BR_CCM_CCGR0_CG0(x)  (HW_CCM_CCGR0(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR0_CG0. */
#define BF_CCM_CCGR0_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG0) & BM_CCM_CCGR0_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR0_CG0(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG0) | BF_CCM_CCGR0_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG1[3:2] (RW)
 *
 * aips_tz2 clocks (aips_tz2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR0_CG1     (2U)          /*!< Bit position for CCM_CCGR0_CG1. */
#define BM_CCM_CCGR0_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR0_CG1. */
#define BS_CCM_CCGR0_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG1. */

/*! @brief Read current value of the CCM_CCGR0_CG1 field. */
#define BR_CCM_CCGR0_CG1(x)  (HW_CCM_CCGR0(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR0_CG1. */
#define BF_CCM_CCGR0_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG1) & BM_CCM_CCGR0_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR0_CG1(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG1) | BF_CCM_CCGR0_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG2[5:4] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG2     (4U)          /*!< Bit position for CCM_CCGR0_CG2. */
#define BM_CCM_CCGR0_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR0_CG2. */
#define BS_CCM_CCGR0_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG2. */

/*! @brief Read current value of the CCM_CCGR0_CG2 field. */
#define BR_CCM_CCGR0_CG2(x)  (HW_CCM_CCGR0(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR0_CG2. */
#define BF_CCM_CCGR0_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG2) & BM_CCM_CCGR0_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR0_CG2(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG2) | BF_CCM_CCGR0_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG3[7:6] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG3     (6U)          /*!< Bit position for CCM_CCGR0_CG3. */
#define BM_CCM_CCGR0_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR0_CG3. */
#define BS_CCM_CCGR0_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG3. */

/*! @brief Read current value of the CCM_CCGR0_CG3 field. */
#define BR_CCM_CCGR0_CG3(x)  (HW_CCM_CCGR0(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR0_CG3. */
#define BF_CCM_CCGR0_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG3) & BM_CCM_CCGR0_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR0_CG3(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG3) | BF_CCM_CCGR0_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG4[9:8] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG4     (8U)          /*!< Bit position for CCM_CCGR0_CG4. */
#define BM_CCM_CCGR0_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR0_CG4. */
#define BS_CCM_CCGR0_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG4. */

/*! @brief Read current value of the CCM_CCGR0_CG4 field. */
#define BR_CCM_CCGR0_CG4(x)  (HW_CCM_CCGR0(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR0_CG4. */
#define BF_CCM_CCGR0_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG4) & BM_CCM_CCGR0_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR0_CG4(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG4) | BF_CCM_CCGR0_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG5[11:10] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG5     (10U)         /*!< Bit position for CCM_CCGR0_CG5. */
#define BM_CCM_CCGR0_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR0_CG5. */
#define BS_CCM_CCGR0_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG5. */

/*! @brief Read current value of the CCM_CCGR0_CG5 field. */
#define BR_CCM_CCGR0_CG5(x)  (HW_CCM_CCGR0(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR0_CG5. */
#define BF_CCM_CCGR0_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG5) & BM_CCM_CCGR0_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR0_CG5(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG5) | BF_CCM_CCGR0_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG6[13:12] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG6     (12U)         /*!< Bit position for CCM_CCGR0_CG6. */
#define BM_CCM_CCGR0_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR0_CG6. */
#define BS_CCM_CCGR0_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG6. */

/*! @brief Read current value of the CCM_CCGR0_CG6 field. */
#define BR_CCM_CCGR0_CG6(x)  (HW_CCM_CCGR0(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR0_CG6. */
#define BF_CCM_CCGR0_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG6) & BM_CCM_CCGR0_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR0_CG6(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG6) | BF_CCM_CCGR0_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG7[15:14] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG7     (14U)         /*!< Bit position for CCM_CCGR0_CG7. */
#define BM_CCM_CCGR0_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR0_CG7. */
#define BS_CCM_CCGR0_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG7. */

/*! @brief Read current value of the CCM_CCGR0_CG7 field. */
#define BR_CCM_CCGR0_CG7(x)  (HW_CCM_CCGR0(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR0_CG7. */
#define BF_CCM_CCGR0_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG7) & BM_CCM_CCGR0_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR0_CG7(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG7) | BF_CCM_CCGR0_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG8[17:16] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG8     (16U)         /*!< Bit position for CCM_CCGR0_CG8. */
#define BM_CCM_CCGR0_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR0_CG8. */
#define BS_CCM_CCGR0_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG8. */

/*! @brief Read current value of the CCM_CCGR0_CG8 field. */
#define BR_CCM_CCGR0_CG8(x)  (HW_CCM_CCGR0(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR0_CG8. */
#define BF_CCM_CCGR0_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG8) & BM_CCM_CCGR0_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR0_CG8(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG8) | BF_CCM_CCGR0_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG9[19:18] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG9     (18U)         /*!< Bit position for CCM_CCGR0_CG9. */
#define BM_CCM_CCGR0_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR0_CG9. */
#define BS_CCM_CCGR0_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG9. */

/*! @brief Read current value of the CCM_CCGR0_CG9 field. */
#define BR_CCM_CCGR0_CG9(x)  (HW_CCM_CCGR0(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR0_CG9. */
#define BF_CCM_CCGR0_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG9) & BM_CCM_CCGR0_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR0_CG9(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG9) | BF_CCM_CCGR0_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG10[21:20] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG10    (20U)         /*!< Bit position for CCM_CCGR0_CG10. */
#define BM_CCM_CCGR0_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR0_CG10. */
#define BS_CCM_CCGR0_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG10. */

/*! @brief Read current value of the CCM_CCGR0_CG10 field. */
#define BR_CCM_CCGR0_CG10(x) (HW_CCM_CCGR0(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR0_CG10. */
#define BF_CCM_CCGR0_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG10) & BM_CCM_CCGR0_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR0_CG10(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG10) | BF_CCM_CCGR0_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG11[23:22] (RW)
 *
 * CPU debug clocks (arm_dbg_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR0_CG11    (22U)         /*!< Bit position for CCM_CCGR0_CG11. */
#define BM_CCM_CCGR0_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR0_CG11. */
#define BS_CCM_CCGR0_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG11. */

/*! @brief Read current value of the CCM_CCGR0_CG11 field. */
#define BR_CCM_CCGR0_CG11(x) (HW_CCM_CCGR0(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR0_CG11. */
#define BF_CCM_CCGR0_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG11) & BM_CCM_CCGR0_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR0_CG11(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG11) | BF_CCM_CCGR0_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG12[25:24] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG12    (24U)         /*!< Bit position for CCM_CCGR0_CG12. */
#define BM_CCM_CCGR0_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR0_CG12. */
#define BS_CCM_CCGR0_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG12. */

/*! @brief Read current value of the CCM_CCGR0_CG12 field. */
#define BR_CCM_CCGR0_CG12(x) (HW_CCM_CCGR0(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR0_CG12. */
#define BF_CCM_CCGR0_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG12) & BM_CCM_CCGR0_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR0_CG12(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG12) | BF_CCM_CCGR0_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG13[27:26] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG13    (26U)         /*!< Bit position for CCM_CCGR0_CG13. */
#define BM_CCM_CCGR0_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR0_CG13. */
#define BS_CCM_CCGR0_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG13. */

/*! @brief Read current value of the CCM_CCGR0_CG13 field. */
#define BR_CCM_CCGR0_CG13(x) (HW_CCM_CCGR0(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR0_CG13. */
#define BF_CCM_CCGR0_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG13) & BM_CCM_CCGR0_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR0_CG13(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG13) | BF_CCM_CCGR0_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG14[29:28] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG14    (28U)         /*!< Bit position for CCM_CCGR0_CG14. */
#define BM_CCM_CCGR0_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR0_CG14. */
#define BS_CCM_CCGR0_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG14. */

/*! @brief Read current value of the CCM_CCGR0_CG14 field. */
#define BR_CCM_CCGR0_CG14(x) (HW_CCM_CCGR0(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR0_CG14. */
#define BF_CCM_CCGR0_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG14) & BM_CCM_CCGR0_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR0_CG14(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG14) | BF_CCM_CCGR0_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR0_CG15    (30U)         /*!< Bit position for CCM_CCGR0_CG15. */
#define BM_CCM_CCGR0_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR0_CG15. */
#define BS_CCM_CCGR0_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR0_CG15. */

/*! @brief Read current value of the CCM_CCGR0_CG15 field. */
#define BR_CCM_CCGR0_CG15(x) (HW_CCM_CCGR0(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR0_CG15. */
#define BF_CCM_CCGR0_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_CG15) & BM_CCM_CCGR0_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR0_CG15(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_CG15) | BF_CCM_CCGR0_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR1 - CCM Clock Gating Register 1
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR1 - CCM Clock Gating Register 1 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1). The
 * clock gating registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required is
 * determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr1
{
    uint32_t U;
    struct _hw_ccm_ccgr1_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr1_t;

/*!
 * @name Constants and macros for entire CCM_CCGR1 register
 */
/*@{*/
#define HW_CCM_CCGR1_ADDR(x)     ((uintptr_t)(x) + 0x6CU)

#define HW_CCM_CCGR1(x)          (*(__IO hw_ccm_ccgr1_t *) HW_CCM_CCGR1_ADDR(x))
#define HW_CCM_CCGR1_RD(x)       (HW_CCM_CCGR1(x).U)
#define HW_CCM_CCGR1_WR(x, v)    (HW_CCM_CCGR1(x).U = (v))
#define HW_CCM_CCGR1_SET(x, v)   (HW_CCM_CCGR1_WR(x, HW_CCM_CCGR1_RD(x) |  (v)))
#define HW_CCM_CCGR1_CLR(x, v)   (HW_CCM_CCGR1_WR(x, HW_CCM_CCGR1_RD(x) & ~(v)))
#define HW_CCM_CCGR1_TOG(x, v)   (HW_CCM_CCGR1_WR(x, HW_CCM_CCGR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR1 bitfields
 */

/*!
 * @name Register CCM_CCGR1, field CG0[1:0] (RW)
 *
 * ecspi1 clocks (ecspi1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG0     (0U)          /*!< Bit position for CCM_CCGR1_CG0. */
#define BM_CCM_CCGR1_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR1_CG0. */
#define BS_CCM_CCGR1_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG0. */

/*! @brief Read current value of the CCM_CCGR1_CG0 field. */
#define BR_CCM_CCGR1_CG0(x)  (HW_CCM_CCGR1(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR1_CG0. */
#define BF_CCM_CCGR1_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG0) & BM_CCM_CCGR1_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR1_CG0(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG0) | BF_CCM_CCGR1_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG1[3:2] (RW)
 *
 * ecspi2 clocks (ecspi2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG1     (2U)          /*!< Bit position for CCM_CCGR1_CG1. */
#define BM_CCM_CCGR1_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR1_CG1. */
#define BS_CCM_CCGR1_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG1. */

/*! @brief Read current value of the CCM_CCGR1_CG1 field. */
#define BR_CCM_CCGR1_CG1(x)  (HW_CCM_CCGR1(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR1_CG1. */
#define BF_CCM_CCGR1_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG1) & BM_CCM_CCGR1_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR1_CG1(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG1) | BF_CCM_CCGR1_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG2[5:4] (RW)
 *
 * ecspi3 clocks (ecspi3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG2     (4U)          /*!< Bit position for CCM_CCGR1_CG2. */
#define BM_CCM_CCGR1_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR1_CG2. */
#define BS_CCM_CCGR1_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG2. */

/*! @brief Read current value of the CCM_CCGR1_CG2 field. */
#define BR_CCM_CCGR1_CG2(x)  (HW_CCM_CCGR1(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR1_CG2. */
#define BF_CCM_CCGR1_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG2) & BM_CCM_CCGR1_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR1_CG2(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG2) | BF_CCM_CCGR1_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG3[7:6] (RW)
 *
 * ecspi4 clocks (ecspi4_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG3     (6U)          /*!< Bit position for CCM_CCGR1_CG3. */
#define BM_CCM_CCGR1_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR1_CG3. */
#define BS_CCM_CCGR1_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG3. */

/*! @brief Read current value of the CCM_CCGR1_CG3 field. */
#define BR_CCM_CCGR1_CG3(x)  (HW_CCM_CCGR1(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR1_CG3. */
#define BF_CCM_CCGR1_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG3) & BM_CCM_CCGR1_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR1_CG3(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG3) | BF_CCM_CCGR1_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG4[9:8] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG4     (8U)          /*!< Bit position for CCM_CCGR1_CG4. */
#define BM_CCM_CCGR1_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR1_CG4. */
#define BS_CCM_CCGR1_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG4. */

/*! @brief Read current value of the CCM_CCGR1_CG4 field. */
#define BR_CCM_CCGR1_CG4(x)  (HW_CCM_CCGR1(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR1_CG4. */
#define BF_CCM_CCGR1_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG4) & BM_CCM_CCGR1_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR1_CG4(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG4) | BF_CCM_CCGR1_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG5[11:10] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG5     (10U)         /*!< Bit position for CCM_CCGR1_CG5. */
#define BM_CCM_CCGR1_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR1_CG5. */
#define BS_CCM_CCGR1_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG5. */

/*! @brief Read current value of the CCM_CCGR1_CG5 field. */
#define BR_CCM_CCGR1_CG5(x)  (HW_CCM_CCGR1(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR1_CG5. */
#define BF_CCM_CCGR1_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG5) & BM_CCM_CCGR1_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR1_CG5(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG5) | BF_CCM_CCGR1_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG6[13:12] (RW)
 *
 * epit1 clocks (epit1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG6     (12U)         /*!< Bit position for CCM_CCGR1_CG6. */
#define BM_CCM_CCGR1_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR1_CG6. */
#define BS_CCM_CCGR1_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG6. */

/*! @brief Read current value of the CCM_CCGR1_CG6 field. */
#define BR_CCM_CCGR1_CG6(x)  (HW_CCM_CCGR1(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR1_CG6. */
#define BF_CCM_CCGR1_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG6) & BM_CCM_CCGR1_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR1_CG6(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG6) | BF_CCM_CCGR1_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG7[15:14] (RW)
 *
 * epit2 clocks (epit2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG7     (14U)         /*!< Bit position for CCM_CCGR1_CG7. */
#define BM_CCM_CCGR1_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR1_CG7. */
#define BS_CCM_CCGR1_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG7. */

/*! @brief Read current value of the CCM_CCGR1_CG7 field. */
#define BR_CCM_CCGR1_CG7(x)  (HW_CCM_CCGR1(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR1_CG7. */
#define BF_CCM_CCGR1_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG7) & BM_CCM_CCGR1_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR1_CG7(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG7) | BF_CCM_CCGR1_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG8[17:16] (RW)
 *
 * esai clocks (extern_audio_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG8     (16U)         /*!< Bit position for CCM_CCGR1_CG8. */
#define BM_CCM_CCGR1_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR1_CG8. */
#define BS_CCM_CCGR1_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG8. */

/*! @brief Read current value of the CCM_CCGR1_CG8 field. */
#define BR_CCM_CCGR1_CG8(x)  (HW_CCM_CCGR1(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR1_CG8. */
#define BF_CCM_CCGR1_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG8) & BM_CCM_CCGR1_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR1_CG8(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG8) | BF_CCM_CCGR1_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG9[19:18] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG9     (18U)         /*!< Bit position for CCM_CCGR1_CG9. */
#define BM_CCM_CCGR1_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR1_CG9. */
#define BS_CCM_CCGR1_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG9. */

/*! @brief Read current value of the CCM_CCGR1_CG9 field. */
#define BR_CCM_CCGR1_CG9(x)  (HW_CCM_CCGR1(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR1_CG9. */
#define BF_CCM_CCGR1_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG9) & BM_CCM_CCGR1_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR1_CG9(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG9) | BF_CCM_CCGR1_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG10[21:20] (RW)
 *
 * gpt bus clock (gpt_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG10    (20U)         /*!< Bit position for CCM_CCGR1_CG10. */
#define BM_CCM_CCGR1_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR1_CG10. */
#define BS_CCM_CCGR1_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG10. */

/*! @brief Read current value of the CCM_CCGR1_CG10 field. */
#define BR_CCM_CCGR1_CG10(x) (HW_CCM_CCGR1(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR1_CG10. */
#define BF_CCM_CCGR1_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG10) & BM_CCM_CCGR1_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR1_CG10(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG10) | BF_CCM_CCGR1_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG11[23:22] (RW)
 *
 * gpt serial clock (gpt_serial_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG11    (22U)         /*!< Bit position for CCM_CCGR1_CG11. */
#define BM_CCM_CCGR1_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR1_CG11. */
#define BS_CCM_CCGR1_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG11. */

/*! @brief Read current value of the CCM_CCGR1_CG11 field. */
#define BR_CCM_CCGR1_CG11(x) (HW_CCM_CCGR1(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR1_CG11. */
#define BF_CCM_CCGR1_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG11) & BM_CCM_CCGR1_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR1_CG11(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG11) | BF_CCM_CCGR1_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG12[25:24] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG12    (24U)         /*!< Bit position for CCM_CCGR1_CG12. */
#define BM_CCM_CCGR1_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR1_CG12. */
#define BS_CCM_CCGR1_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG12. */

/*! @brief Read current value of the CCM_CCGR1_CG12 field. */
#define BR_CCM_CCGR1_CG12(x) (HW_CCM_CCGR1(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR1_CG12. */
#define BF_CCM_CCGR1_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG12) & BM_CCM_CCGR1_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR1_CG12(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG12) | BF_CCM_CCGR1_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG13[27:26] (RW)
 *
 * gpu2d ovg clock (gpu2d_ovg_core_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR1_CG13    (26U)         /*!< Bit position for CCM_CCGR1_CG13. */
#define BM_CCM_CCGR1_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR1_CG13. */
#define BS_CCM_CCGR1_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG13. */

/*! @brief Read current value of the CCM_CCGR1_CG13 field. */
#define BR_CCM_CCGR1_CG13(x) (HW_CCM_CCGR1(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR1_CG13. */
#define BF_CCM_CCGR1_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG13) & BM_CCM_CCGR1_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR1_CG13(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG13) | BF_CCM_CCGR1_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG14[29:28] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG14    (28U)         /*!< Bit position for CCM_CCGR1_CG14. */
#define BM_CCM_CCGR1_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR1_CG14. */
#define BS_CCM_CCGR1_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG14. */

/*! @brief Read current value of the CCM_CCGR1_CG14 field. */
#define BR_CCM_CCGR1_CG14(x) (HW_CCM_CCGR1(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR1_CG14. */
#define BF_CCM_CCGR1_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG14) & BM_CCM_CCGR1_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR1_CG14(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG14) | BF_CCM_CCGR1_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR1_CG15    (30U)         /*!< Bit position for CCM_CCGR1_CG15. */
#define BM_CCM_CCGR1_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR1_CG15. */
#define BS_CCM_CCGR1_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR1_CG15. */

/*! @brief Read current value of the CCM_CCGR1_CG15 field. */
#define BR_CCM_CCGR1_CG15(x) (HW_CCM_CCGR1(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR1_CG15. */
#define BF_CCM_CCGR1_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_CG15) & BM_CCM_CCGR1_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR1_CG15(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_CG15) | BF_CCM_CCGR1_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR2 - CCM Clock Gating Register 2
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR2 - CCM Clock Gating Register 2 (RW)
 *
 * Reset value: 0xFC3FFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2). The
 * clock gating registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required
 * is determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr2
{
    uint32_t U;
    struct _hw_ccm_ccgr2_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr2_t;

/*!
 * @name Constants and macros for entire CCM_CCGR2 register
 */
/*@{*/
#define HW_CCM_CCGR2_ADDR(x)     ((uintptr_t)(x) + 0x70U)

#define HW_CCM_CCGR2(x)          (*(__IO hw_ccm_ccgr2_t *) HW_CCM_CCGR2_ADDR(x))
#define HW_CCM_CCGR2_RD(x)       (HW_CCM_CCGR2(x).U)
#define HW_CCM_CCGR2_WR(x, v)    (HW_CCM_CCGR2(x).U = (v))
#define HW_CCM_CCGR2_SET(x, v)   (HW_CCM_CCGR2_WR(x, HW_CCM_CCGR2_RD(x) |  (v)))
#define HW_CCM_CCGR2_CLR(x, v)   (HW_CCM_CCGR2_WR(x, HW_CCM_CCGR2_RD(x) & ~(v)))
#define HW_CCM_CCGR2_TOG(x, v)   (HW_CCM_CCGR2_WR(x, HW_CCM_CCGR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR2 bitfields
 */

/*!
 * @name Register CCM_CCGR2, field CG0[1:0] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG0     (0U)          /*!< Bit position for CCM_CCGR2_CG0. */
#define BM_CCM_CCGR2_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR2_CG0. */
#define BS_CCM_CCGR2_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG0. */

/*! @brief Read current value of the CCM_CCGR2_CG0 field. */
#define BR_CCM_CCGR2_CG0(x)  (HW_CCM_CCGR2(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR2_CG0. */
#define BF_CCM_CCGR2_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG0) & BM_CCM_CCGR2_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR2_CG0(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG0) | BF_CCM_CCGR2_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG1[3:2] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG1     (2U)          /*!< Bit position for CCM_CCGR2_CG1. */
#define BM_CCM_CCGR2_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR2_CG1. */
#define BS_CCM_CCGR2_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG1. */

/*! @brief Read current value of the CCM_CCGR2_CG1 field. */
#define BR_CCM_CCGR2_CG1(x)  (HW_CCM_CCGR2(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR2_CG1. */
#define BF_CCM_CCGR2_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG1) & BM_CCM_CCGR2_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR2_CG1(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG1) | BF_CCM_CCGR2_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG2[5:4] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG2     (4U)          /*!< Bit position for CCM_CCGR2_CG2. */
#define BM_CCM_CCGR2_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR2_CG2. */
#define BS_CCM_CCGR2_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG2. */

/*! @brief Read current value of the CCM_CCGR2_CG2 field. */
#define BR_CCM_CCGR2_CG2(x)  (HW_CCM_CCGR2(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR2_CG2. */
#define BF_CCM_CCGR2_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG2) & BM_CCM_CCGR2_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR2_CG2(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG2) | BF_CCM_CCGR2_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG3[7:6] (RW)
 *
 * i2c1_serial clock (i2c1_serial_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG3     (6U)          /*!< Bit position for CCM_CCGR2_CG3. */
#define BM_CCM_CCGR2_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR2_CG3. */
#define BS_CCM_CCGR2_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG3. */

/*! @brief Read current value of the CCM_CCGR2_CG3 field. */
#define BR_CCM_CCGR2_CG3(x)  (HW_CCM_CCGR2(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR2_CG3. */
#define BF_CCM_CCGR2_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG3) & BM_CCM_CCGR2_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR2_CG3(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG3) | BF_CCM_CCGR2_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG4[9:8] (RW)
 *
 * i2c2_serial clock (i2c2_serial_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG4     (8U)          /*!< Bit position for CCM_CCGR2_CG4. */
#define BM_CCM_CCGR2_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR2_CG4. */
#define BS_CCM_CCGR2_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG4. */

/*! @brief Read current value of the CCM_CCGR2_CG4 field. */
#define BR_CCM_CCGR2_CG4(x)  (HW_CCM_CCGR2(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR2_CG4. */
#define BF_CCM_CCGR2_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG4) & BM_CCM_CCGR2_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR2_CG4(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG4) | BF_CCM_CCGR2_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG5[11:10] (RW)
 *
 * i2c3_serial clock (i2c3_serial_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG5     (10U)         /*!< Bit position for CCM_CCGR2_CG5. */
#define BM_CCM_CCGR2_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR2_CG5. */
#define BS_CCM_CCGR2_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG5. */

/*! @brief Read current value of the CCM_CCGR2_CG5 field. */
#define BR_CCM_CCGR2_CG5(x)  (HW_CCM_CCGR2(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR2_CG5. */
#define BF_CCM_CCGR2_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG5) & BM_CCM_CCGR2_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR2_CG5(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG5) | BF_CCM_CCGR2_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG6[13:12] (RW)
 *
 * OCOTP_CTRL clock (iim_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG6     (12U)         /*!< Bit position for CCM_CCGR2_CG6. */
#define BM_CCM_CCGR2_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR2_CG6. */
#define BS_CCM_CCGR2_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG6. */

/*! @brief Read current value of the CCM_CCGR2_CG6 field. */
#define BR_CCM_CCGR2_CG6(x)  (HW_CCM_CCGR2(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR2_CG6. */
#define BF_CCM_CCGR2_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG6) & BM_CCM_CCGR2_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR2_CG6(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG6) | BF_CCM_CCGR2_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG7[15:14] (RW)
 *
 * iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG7     (14U)         /*!< Bit position for CCM_CCGR2_CG7. */
#define BM_CCM_CCGR2_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR2_CG7. */
#define BS_CCM_CCGR2_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG7. */

/*! @brief Read current value of the CCM_CCGR2_CG7 field. */
#define BR_CCM_CCGR2_CG7(x)  (HW_CCM_CCGR2(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR2_CG7. */
#define BF_CCM_CCGR2_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG7) & BM_CCM_CCGR2_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR2_CG7(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG7) | BF_CCM_CCGR2_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG8[17:16] (RW)
 *
 * ipmux1 clock (ipmux1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG8     (16U)         /*!< Bit position for CCM_CCGR2_CG8. */
#define BM_CCM_CCGR2_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR2_CG8. */
#define BS_CCM_CCGR2_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG8. */

/*! @brief Read current value of the CCM_CCGR2_CG8 field. */
#define BR_CCM_CCGR2_CG8(x)  (HW_CCM_CCGR2(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR2_CG8. */
#define BF_CCM_CCGR2_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG8) & BM_CCM_CCGR2_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR2_CG8(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG8) | BF_CCM_CCGR2_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG9[19:18] (RW)
 *
 * ipmux2 clock (ipmux2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG9     (18U)         /*!< Bit position for CCM_CCGR2_CG9. */
#define BM_CCM_CCGR2_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR2_CG9. */
#define BS_CCM_CCGR2_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG9. */

/*! @brief Read current value of the CCM_CCGR2_CG9 field. */
#define BR_CCM_CCGR2_CG9(x)  (HW_CCM_CCGR2(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR2_CG9. */
#define BF_CCM_CCGR2_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG9) & BM_CCM_CCGR2_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR2_CG9(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG9) | BF_CCM_CCGR2_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG10[21:20] (RW)
 *
 * ipmux3 clock (ipmux3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG10    (20U)         /*!< Bit position for CCM_CCGR2_CG10. */
#define BM_CCM_CCGR2_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR2_CG10. */
#define BS_CCM_CCGR2_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG10. */

/*! @brief Read current value of the CCM_CCGR2_CG10 field. */
#define BR_CCM_CCGR2_CG10(x) (HW_CCM_CCGR2(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR2_CG10. */
#define BF_CCM_CCGR2_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG10) & BM_CCM_CCGR2_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR2_CG10(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG10) | BF_CCM_CCGR2_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG11[23:22] (RW)
 *
 * ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG11    (22U)         /*!< Bit position for CCM_CCGR2_CG11. */
#define BM_CCM_CCGR2_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR2_CG11. */
#define BS_CCM_CCGR2_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG11. */

/*! @brief Read current value of the CCM_CCGR2_CG11 field. */
#define BR_CCM_CCGR2_CG11(x) (HW_CCM_CCGR2(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR2_CG11. */
#define BF_CCM_CCGR2_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG11) & BM_CCM_CCGR2_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR2_CG11(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG11) | BF_CCM_CCGR2_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG12[25:24] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG12    (24U)         /*!< Bit position for CCM_CCGR2_CG12. */
#define BM_CCM_CCGR2_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR2_CG12. */
#define BS_CCM_CCGR2_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG12. */

/*! @brief Read current value of the CCM_CCGR2_CG12 field. */
#define BR_CCM_CCGR2_CG12(x) (HW_CCM_CCGR2(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR2_CG12. */
#define BF_CCM_CCGR2_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG12) & BM_CCM_CCGR2_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR2_CG12(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG12) | BF_CCM_CCGR2_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG13[27:26] (RW)
 *
 * ipsync_vdoa_ipg clocks (ipsync_vdoa_ipg_master_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR2_CG13    (26U)         /*!< Bit position for CCM_CCGR2_CG13. */
#define BM_CCM_CCGR2_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR2_CG13. */
#define BS_CCM_CCGR2_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG13. */

/*! @brief Read current value of the CCM_CCGR2_CG13 field. */
#define BR_CCM_CCGR2_CG13(x) (HW_CCM_CCGR2(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR2_CG13. */
#define BF_CCM_CCGR2_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG13) & BM_CCM_CCGR2_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR2_CG13(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG13) | BF_CCM_CCGR2_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG14[29:28] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG14    (28U)         /*!< Bit position for CCM_CCGR2_CG14. */
#define BM_CCM_CCGR2_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR2_CG14. */
#define BS_CCM_CCGR2_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG14. */

/*! @brief Read current value of the CCM_CCGR2_CG14 field. */
#define BR_CCM_CCGR2_CG14(x) (HW_CCM_CCGR2(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR2_CG14. */
#define BF_CCM_CCGR2_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG14) & BM_CCM_CCGR2_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR2_CG14(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG14) | BF_CCM_CCGR2_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR2_CG15    (30U)         /*!< Bit position for CCM_CCGR2_CG15. */
#define BM_CCM_CCGR2_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR2_CG15. */
#define BS_CCM_CCGR2_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR2_CG15. */

/*! @brief Read current value of the CCM_CCGR2_CG15 field. */
#define BR_CCM_CCGR2_CG15(x) (HW_CCM_CCGR2(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR2_CG15. */
#define BF_CCM_CCGR2_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_CG15) & BM_CCM_CCGR2_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR2_CG15(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_CG15) | BF_CCM_CCGR2_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR3 - CCM Clock Gating Register 3
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR3 - CCM Clock Gating Register 3 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3). The
 * clock gating Registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required
 * is determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr3
{
    uint32_t U;
    struct _hw_ccm_ccgr3_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr3_t;

/*!
 * @name Constants and macros for entire CCM_CCGR3 register
 */
/*@{*/
#define HW_CCM_CCGR3_ADDR(x)     ((uintptr_t)(x) + 0x74U)

#define HW_CCM_CCGR3(x)          (*(__IO hw_ccm_ccgr3_t *) HW_CCM_CCGR3_ADDR(x))
#define HW_CCM_CCGR3_RD(x)       (HW_CCM_CCGR3(x).U)
#define HW_CCM_CCGR3_WR(x, v)    (HW_CCM_CCGR3(x).U = (v))
#define HW_CCM_CCGR3_SET(x, v)   (HW_CCM_CCGR3_WR(x, HW_CCM_CCGR3_RD(x) |  (v)))
#define HW_CCM_CCGR3_CLR(x, v)   (HW_CCM_CCGR3_WR(x, HW_CCM_CCGR3_RD(x) & ~(v)))
#define HW_CCM_CCGR3_TOG(x, v)   (HW_CCM_CCGR3_WR(x, HW_CCM_CCGR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR3 bitfields
 */

/*!
 * @name Register CCM_CCGR3, field CG0[1:0] (RW)
 *
 * csi core clock (csi_core_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG0     (0U)          /*!< Bit position for CCM_CCGR3_CG0. */
#define BM_CCM_CCGR3_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR3_CG0. */
#define BS_CCM_CCGR3_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG0. */

/*! @brief Read current value of the CCM_CCGR3_CG0 field. */
#define BR_CCM_CCGR3_CG0(x)  (HW_CCM_CCGR3(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR3_CG0. */
#define BF_CCM_CCGR3_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG0) & BM_CCM_CCGR3_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR3_CG0(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG0) | BF_CCM_CCGR3_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG1[3:2] (RW)
 *
 * pxp axi clock (pxp_axi_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG1     (2U)          /*!< Bit position for CCM_CCGR3_CG1. */
#define BM_CCM_CCGR3_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR3_CG1. */
#define BS_CCM_CCGR3_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG1. */

/*! @brief Read current value of the CCM_CCGR3_CG1 field. */
#define BR_CCM_CCGR3_CG1(x)  (HW_CCM_CCGR3(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR3_CG1. */
#define BF_CCM_CCGR3_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG1) & BM_CCM_CCGR3_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR3_CG1(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG1) | BF_CCM_CCGR3_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG2[5:4] (RW)
 *
 * epdc axi clock (epdc_axi_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG2     (4U)          /*!< Bit position for CCM_CCGR3_CG2. */
#define BM_CCM_CCGR3_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR3_CG2. */
#define BS_CCM_CCGR3_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG2. */

/*! @brief Read current value of the CCM_CCGR3_CG2 field. */
#define BR_CCM_CCGR3_CG2(x)  (HW_CCM_CCGR3(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR3_CG2. */
#define BF_CCM_CCGR3_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG2) & BM_CCM_CCGR3_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR3_CG2(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG2) | BF_CCM_CCGR3_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG3[7:6] (RW)
 *
 * lcdif axi clock (lcdif_axi_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG3     (6U)          /*!< Bit position for CCM_CCGR3_CG3. */
#define BM_CCM_CCGR3_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR3_CG3. */
#define BS_CCM_CCGR3_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG3. */

/*! @brief Read current value of the CCM_CCGR3_CG3 field. */
#define BR_CCM_CCGR3_CG3(x)  (HW_CCM_CCGR3(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR3_CG3. */
#define BF_CCM_CCGR3_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG3) & BM_CCM_CCGR3_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR3_CG3(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG3) | BF_CCM_CCGR3_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG4[9:8] (RW)
 *
 * lcdif_pix clock (lcdif_pix_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG4     (8U)          /*!< Bit position for CCM_CCGR3_CG4. */
#define BM_CCM_CCGR3_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR3_CG4. */
#define BS_CCM_CCGR3_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG4. */

/*! @brief Read current value of the CCM_CCGR3_CG4 field. */
#define BR_CCM_CCGR3_CG4(x)  (HW_CCM_CCGR3(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR3_CG4. */
#define BF_CCM_CCGR3_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG4) & BM_CCM_CCGR3_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR3_CG4(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG4) | BF_CCM_CCGR3_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG5[11:10] (RW)
 *
 * epdc_pix clock (epdc_pix_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG5     (10U)         /*!< Bit position for CCM_CCGR3_CG5. */
#define BM_CCM_CCGR3_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR3_CG5. */
#define BS_CCM_CCGR3_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG5. */

/*! @brief Read current value of the CCM_CCGR3_CG5 field. */
#define BR_CCM_CCGR3_CG5(x)  (HW_CCM_CCGR3(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR3_CG5. */
#define BF_CCM_CCGR3_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG5) & BM_CCM_CCGR3_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR3_CG5(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG5) | BF_CCM_CCGR3_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG6[13:12] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG6     (12U)         /*!< Bit position for CCM_CCGR3_CG6. */
#define BM_CCM_CCGR3_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR3_CG6. */
#define BS_CCM_CCGR3_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG6. */

/*! @brief Read current value of the CCM_CCGR3_CG6 field. */
#define BR_CCM_CCGR3_CG6(x)  (HW_CCM_CCGR3(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR3_CG6. */
#define BF_CCM_CCGR3_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG6) & BM_CCM_CCGR3_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR3_CG6(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG6) | BF_CCM_CCGR3_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG7[15:14] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG7     (14U)         /*!< Bit position for CCM_CCGR3_CG7. */
#define BM_CCM_CCGR3_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR3_CG7. */
#define BS_CCM_CCGR3_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG7. */

/*! @brief Read current value of the CCM_CCGR3_CG7 field. */
#define BR_CCM_CCGR3_CG7(x)  (HW_CCM_CCGR3(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR3_CG7. */
#define BF_CCM_CCGR3_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG7) & BM_CCM_CCGR3_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR3_CG7(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG7) | BF_CCM_CCGR3_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG8[17:16] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG8     (16U)         /*!< Bit position for CCM_CCGR3_CG8. */
#define BM_CCM_CCGR3_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR3_CG8. */
#define BS_CCM_CCGR3_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG8. */

/*! @brief Read current value of the CCM_CCGR3_CG8 field. */
#define BR_CCM_CCGR3_CG8(x)  (HW_CCM_CCGR3(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR3_CG8. */
#define BF_CCM_CCGR3_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG8) & BM_CCM_CCGR3_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR3_CG8(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG8) | BF_CCM_CCGR3_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG9[19:18] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG9     (18U)         /*!< Bit position for CCM_CCGR3_CG9. */
#define BM_CCM_CCGR3_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR3_CG9. */
#define BS_CCM_CCGR3_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG9. */

/*! @brief Read current value of the CCM_CCGR3_CG9 field. */
#define BR_CCM_CCGR3_CG9(x)  (HW_CCM_CCGR3(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR3_CG9. */
#define BF_CCM_CCGR3_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG9) & BM_CCM_CCGR3_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR3_CG9(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG9) | BF_CCM_CCGR3_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG10[21:20] (RW)
 *
 * mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG10    (20U)         /*!< Bit position for CCM_CCGR3_CG10. */
#define BM_CCM_CCGR3_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR3_CG10. */
#define BS_CCM_CCGR3_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG10. */

/*! @brief Read current value of the CCM_CCGR3_CG10 field. */
#define BR_CCM_CCGR3_CG10(x) (HW_CCM_CCGR3(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR3_CG10. */
#define BF_CCM_CCGR3_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG10) & BM_CCM_CCGR3_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR3_CG10(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG10) | BF_CCM_CCGR3_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG11[23:22] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG11    (22U)         /*!< Bit position for CCM_CCGR3_CG11. */
#define BM_CCM_CCGR3_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR3_CG11. */
#define BS_CCM_CCGR3_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG11. */

/*! @brief Read current value of the CCM_CCGR3_CG11 field. */
#define BR_CCM_CCGR3_CG11(x) (HW_CCM_CCGR3(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR3_CG11. */
#define BF_CCM_CCGR3_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG11) & BM_CCM_CCGR3_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR3_CG11(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG11) | BF_CCM_CCGR3_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG12[25:24] (RW)
 *
 * mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG12    (24U)         /*!< Bit position for CCM_CCGR3_CG12. */
#define BM_CCM_CCGR3_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR3_CG12. */
#define BS_CCM_CCGR3_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG12. */

/*! @brief Read current value of the CCM_CCGR3_CG12 field. */
#define BR_CCM_CCGR3_CG12(x) (HW_CCM_CCGR3(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR3_CG12. */
#define BF_CCM_CCGR3_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG12) & BM_CCM_CCGR3_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR3_CG12(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG12) | BF_CCM_CCGR3_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG13[27:26] (RW)
 *
 * mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG13    (26U)         /*!< Bit position for CCM_CCGR3_CG13. */
#define BM_CCM_CCGR3_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR3_CG13. */
#define BS_CCM_CCGR3_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG13. */

/*! @brief Read current value of the CCM_CCGR3_CG13 field. */
#define BR_CCM_CCGR3_CG13(x) (HW_CCM_CCGR3(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR3_CG13. */
#define BF_CCM_CCGR3_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG13) & BM_CCM_CCGR3_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR3_CG13(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG13) | BF_CCM_CCGR3_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG14[29:28] (RW)
 *
 * ocram clock (ocram_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR3_CG14    (28U)         /*!< Bit position for CCM_CCGR3_CG14. */
#define BM_CCM_CCGR3_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR3_CG14. */
#define BS_CCM_CCGR3_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG14. */

/*! @brief Read current value of the CCM_CCGR3_CG14 field. */
#define BR_CCM_CCGR3_CG14(x) (HW_CCM_CCGR3(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR3_CG14. */
#define BF_CCM_CCGR3_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG14) & BM_CCM_CCGR3_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR3_CG14(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG14) | BF_CCM_CCGR3_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR3_CG15    (30U)         /*!< Bit position for CCM_CCGR3_CG15. */
#define BM_CCM_CCGR3_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR3_CG15. */
#define BS_CCM_CCGR3_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR3_CG15. */

/*! @brief Read current value of the CCM_CCGR3_CG15 field. */
#define BR_CCM_CCGR3_CG15(x) (HW_CCM_CCGR3(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR3_CG15. */
#define BF_CCM_CCGR3_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_CG15) & BM_CCM_CCGR3_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR3_CG15(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_CG15) | BF_CCM_CCGR3_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR4 - CCM Clock Gating Register 4
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR4 - CCM Clock Gating Register 4 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4). The
 * clock gating Registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required
 * is determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr4
{
    uint32_t U;
    struct _hw_ccm_ccgr4_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr4_t;

/*!
 * @name Constants and macros for entire CCM_CCGR4 register
 */
/*@{*/
#define HW_CCM_CCGR4_ADDR(x)     ((uintptr_t)(x) + 0x78U)

#define HW_CCM_CCGR4(x)          (*(__IO hw_ccm_ccgr4_t *) HW_CCM_CCGR4_ADDR(x))
#define HW_CCM_CCGR4_RD(x)       (HW_CCM_CCGR4(x).U)
#define HW_CCM_CCGR4_WR(x, v)    (HW_CCM_CCGR4(x).U = (v))
#define HW_CCM_CCGR4_SET(x, v)   (HW_CCM_CCGR4_WR(x, HW_CCM_CCGR4_RD(x) |  (v)))
#define HW_CCM_CCGR4_CLR(x, v)   (HW_CCM_CCGR4_WR(x, HW_CCM_CCGR4_RD(x) & ~(v)))
#define HW_CCM_CCGR4_TOG(x, v)   (HW_CCM_CCGR4_WR(x, HW_CCM_CCGR4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR4 bitfields
 */

/*!
 * @name Register CCM_CCGR4, field CG0[1:0] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR4_CG0     (0U)          /*!< Bit position for CCM_CCGR4_CG0. */
#define BM_CCM_CCGR4_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR4_CG0. */
#define BS_CCM_CCGR4_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG0. */

/*! @brief Read current value of the CCM_CCGR4_CG0 field. */
#define BR_CCM_CCGR4_CG0(x)  (HW_CCM_CCGR4(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR4_CG0. */
#define BF_CCM_CCGR4_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG0) & BM_CCM_CCGR4_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR4_CG0(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG0) | BF_CCM_CCGR4_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG1[3:2] (RW)
 *
 * Reserved.
 */
/*@{*/
#define BP_CCM_CCGR4_CG1     (2U)          /*!< Bit position for CCM_CCGR4_CG1. */
#define BM_CCM_CCGR4_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR4_CG1. */
#define BS_CCM_CCGR4_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG1. */

/*! @brief Read current value of the CCM_CCGR4_CG1 field. */
#define BR_CCM_CCGR4_CG1(x)  (HW_CCM_CCGR4(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR4_CG1. */
#define BF_CCM_CCGR4_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG1) & BM_CCM_CCGR4_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR4_CG1(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG1) | BF_CCM_CCGR4_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG2[5:4] (RW)
 *
 * Reserved.
 */
/*@{*/
#define BP_CCM_CCGR4_CG2     (4U)          /*!< Bit position for CCM_CCGR4_CG2. */
#define BM_CCM_CCGR4_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR4_CG2. */
#define BS_CCM_CCGR4_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG2. */

/*! @brief Read current value of the CCM_CCGR4_CG2 field. */
#define BR_CCM_CCGR4_CG2(x)  (HW_CCM_CCGR4(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR4_CG2. */
#define BF_CCM_CCGR4_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG2) & BM_CCM_CCGR4_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR4_CG2(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG2) | BF_CCM_CCGR4_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG3[7:6] (RW)
 *
 * Reserved.
 */
/*@{*/
#define BP_CCM_CCGR4_CG3     (6U)          /*!< Bit position for CCM_CCGR4_CG3. */
#define BM_CCM_CCGR4_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR4_CG3. */
#define BS_CCM_CCGR4_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG3. */

/*! @brief Read current value of the CCM_CCGR4_CG3 field. */
#define BR_CCM_CCGR4_CG3(x)  (HW_CCM_CCGR4(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR4_CG3. */
#define BF_CCM_CCGR4_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG3) & BM_CCM_CCGR4_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR4_CG3(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG3) | BF_CCM_CCGR4_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG4[9:8] (RW)
 *
 * pl301_mx6qfast1_s133 clock (pl301_mx6qfast1_s133clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG4     (8U)          /*!< Bit position for CCM_CCGR4_CG4. */
#define BM_CCM_CCGR4_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR4_CG4. */
#define BS_CCM_CCGR4_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG4. */

/*! @brief Read current value of the CCM_CCGR4_CG4 field. */
#define BR_CCM_CCGR4_CG4(x)  (HW_CCM_CCGR4(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR4_CG4. */
#define BF_CCM_CCGR4_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG4) & BM_CCM_CCGR4_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR4_CG4(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG4) | BF_CCM_CCGR4_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG5[11:10] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR4_CG5     (10U)         /*!< Bit position for CCM_CCGR4_CG5. */
#define BM_CCM_CCGR4_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR4_CG5. */
#define BS_CCM_CCGR4_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG5. */

/*! @brief Read current value of the CCM_CCGR4_CG5 field. */
#define BR_CCM_CCGR4_CG5(x)  (HW_CCM_CCGR4(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR4_CG5. */
#define BF_CCM_CCGR4_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG5) & BM_CCM_CCGR4_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR4_CG5(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG5) | BF_CCM_CCGR4_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG6[13:12] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR4_CG6     (12U)         /*!< Bit position for CCM_CCGR4_CG6. */
#define BM_CCM_CCGR4_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR4_CG6. */
#define BS_CCM_CCGR4_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG6. */

/*! @brief Read current value of the CCM_CCGR4_CG6 field. */
#define BR_CCM_CCGR4_CG6(x)  (HW_CCM_CCGR4(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR4_CG6. */
#define BF_CCM_CCGR4_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG6) & BM_CCM_CCGR4_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR4_CG6(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG6) | BF_CCM_CCGR4_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG7[15:14] (RW)
 *
 * pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG7     (14U)         /*!< Bit position for CCM_CCGR4_CG7. */
#define BM_CCM_CCGR4_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR4_CG7. */
#define BS_CCM_CCGR4_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG7. */

/*! @brief Read current value of the CCM_CCGR4_CG7 field. */
#define BR_CCM_CCGR4_CG7(x)  (HW_CCM_CCGR4(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR4_CG7. */
#define BF_CCM_CCGR4_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG7) & BM_CCM_CCGR4_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR4_CG7(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG7) | BF_CCM_CCGR4_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG8[17:16] (RW)
 *
 * pwm1 clocks (pwm1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG8     (16U)         /*!< Bit position for CCM_CCGR4_CG8. */
#define BM_CCM_CCGR4_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR4_CG8. */
#define BS_CCM_CCGR4_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG8. */

/*! @brief Read current value of the CCM_CCGR4_CG8 field. */
#define BR_CCM_CCGR4_CG8(x)  (HW_CCM_CCGR4(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR4_CG8. */
#define BF_CCM_CCGR4_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG8) & BM_CCM_CCGR4_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR4_CG8(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG8) | BF_CCM_CCGR4_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG9[19:18] (RW)
 *
 * pwm2 clocks (pwm2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG9     (18U)         /*!< Bit position for CCM_CCGR4_CG9. */
#define BM_CCM_CCGR4_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR4_CG9. */
#define BS_CCM_CCGR4_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG9. */

/*! @brief Read current value of the CCM_CCGR4_CG9 field. */
#define BR_CCM_CCGR4_CG9(x)  (HW_CCM_CCGR4(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR4_CG9. */
#define BF_CCM_CCGR4_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG9) & BM_CCM_CCGR4_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR4_CG9(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG9) | BF_CCM_CCGR4_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG10[21:20] (RW)
 *
 * pwm3 clocks (pwm3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG10    (20U)         /*!< Bit position for CCM_CCGR4_CG10. */
#define BM_CCM_CCGR4_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR4_CG10. */
#define BS_CCM_CCGR4_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG10. */

/*! @brief Read current value of the CCM_CCGR4_CG10 field. */
#define BR_CCM_CCGR4_CG10(x) (HW_CCM_CCGR4(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR4_CG10. */
#define BF_CCM_CCGR4_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG10) & BM_CCM_CCGR4_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR4_CG10(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG10) | BF_CCM_CCGR4_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG11[23:22] (RW)
 *
 * pwm4 clocks (pwm4_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG11    (22U)         /*!< Bit position for CCM_CCGR4_CG11. */
#define BM_CCM_CCGR4_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR4_CG11. */
#define BS_CCM_CCGR4_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG11. */

/*! @brief Read current value of the CCM_CCGR4_CG11 field. */
#define BR_CCM_CCGR4_CG11(x) (HW_CCM_CCGR4(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR4_CG11. */
#define BF_CCM_CCGR4_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG11) & BM_CCM_CCGR4_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR4_CG11(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG11) | BF_CCM_CCGR4_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG12[25:24] (RW)
 *
 * rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG12    (24U)         /*!< Bit position for CCM_CCGR4_CG12. */
#define BM_CCM_CCGR4_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR4_CG12. */
#define BS_CCM_CCGR4_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG12. */

/*! @brief Read current value of the CCM_CCGR4_CG12 field. */
#define BR_CCM_CCGR4_CG12(x) (HW_CCM_CCGR4(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR4_CG12. */
#define BF_CCM_CCGR4_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG12) & BM_CCM_CCGR4_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR4_CG12(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG12) | BF_CCM_CCGR4_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG13[27:26] (RW)
 *
 * rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG13    (26U)         /*!< Bit position for CCM_CCGR4_CG13. */
#define BM_CCM_CCGR4_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR4_CG13. */
#define BS_CCM_CCGR4_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG13. */

/*! @brief Read current value of the CCM_CCGR4_CG13 field. */
#define BR_CCM_CCGR4_CG13(x) (HW_CCM_CCGR4(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR4_CG13. */
#define BF_CCM_CCGR4_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG13) & BM_CCM_CCGR4_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR4_CG13(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG13) | BF_CCM_CCGR4_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG14[29:28] (RW)
 *
 * rawnand_u_gpmi_bch_input_gpmi_io clock
 * (rawnand_u_gpmi_bch_input_gpmi_io_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG14    (28U)         /*!< Bit position for CCM_CCGR4_CG14. */
#define BM_CCM_CCGR4_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR4_CG14. */
#define BS_CCM_CCGR4_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG14. */

/*! @brief Read current value of the CCM_CCGR4_CG14 field. */
#define BR_CCM_CCGR4_CG14(x) (HW_CCM_CCGR4(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR4_CG14. */
#define BF_CCM_CCGR4_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG14) & BM_CCM_CCGR4_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR4_CG14(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG14) | BF_CCM_CCGR4_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field CG15[31:30] (RW)
 *
 * rawnand_u_gpmi_input_apb clock rawnand_u_gpmi_input_apb_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR4_CG15    (30U)         /*!< Bit position for CCM_CCGR4_CG15. */
#define BM_CCM_CCGR4_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR4_CG15. */
#define BS_CCM_CCGR4_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR4_CG15. */

/*! @brief Read current value of the CCM_CCGR4_CG15 field. */
#define BR_CCM_CCGR4_CG15(x) (HW_CCM_CCGR4(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR4_CG15. */
#define BF_CCM_CCGR4_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_CG15) & BM_CCM_CCGR4_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR4_CG15(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_CG15) | BF_CCM_CCGR4_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR5 - CCM Clock Gating Register 5
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR5 - CCM Clock Gating Register 5 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5). The
 * clock gating Registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required
 * is determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr5
{
    uint32_t U;
    struct _hw_ccm_ccgr5_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr5_t;

/*!
 * @name Constants and macros for entire CCM_CCGR5 register
 */
/*@{*/
#define HW_CCM_CCGR5_ADDR(x)     ((uintptr_t)(x) + 0x7CU)

#define HW_CCM_CCGR5(x)          (*(__IO hw_ccm_ccgr5_t *) HW_CCM_CCGR5_ADDR(x))
#define HW_CCM_CCGR5_RD(x)       (HW_CCM_CCGR5(x).U)
#define HW_CCM_CCGR5_WR(x, v)    (HW_CCM_CCGR5(x).U = (v))
#define HW_CCM_CCGR5_SET(x, v)   (HW_CCM_CCGR5_WR(x, HW_CCM_CCGR5_RD(x) |  (v)))
#define HW_CCM_CCGR5_CLR(x, v)   (HW_CCM_CCGR5_WR(x, HW_CCM_CCGR5_RD(x) & ~(v)))
#define HW_CCM_CCGR5_TOG(x, v)   (HW_CCM_CCGR5_WR(x, HW_CCM_CCGR5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR5 bitfields
 */

/*!
 * @name Register CCM_CCGR5, field CG0[1:0] (RW)
 *
 * rom clock (rom_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG0     (0U)          /*!< Bit position for CCM_CCGR5_CG0. */
#define BM_CCM_CCGR5_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR5_CG0. */
#define BS_CCM_CCGR5_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG0. */

/*! @brief Read current value of the CCM_CCGR5_CG0 field. */
#define BR_CCM_CCGR5_CG0(x)  (HW_CCM_CCGR5(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR5_CG0. */
#define BF_CCM_CCGR5_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG0) & BM_CCM_CCGR5_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR5_CG0(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG0) | BF_CCM_CCGR5_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG1[3:2] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG1     (2U)          /*!< Bit position for CCM_CCGR5_CG1. */
#define BM_CCM_CCGR5_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR5_CG1. */
#define BS_CCM_CCGR5_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG1. */

/*! @brief Read current value of the CCM_CCGR5_CG1 field. */
#define BR_CCM_CCGR5_CG1(x)  (HW_CCM_CCGR5(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR5_CG1. */
#define BF_CCM_CCGR5_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG1) & BM_CCM_CCGR5_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR5_CG1(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG1) | BF_CCM_CCGR5_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG2[5:4] (RW)
 *
 * 100M clock (100M_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG2     (4U)          /*!< Bit position for CCM_CCGR5_CG2. */
#define BM_CCM_CCGR5_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR5_CG2. */
#define BS_CCM_CCGR5_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG2. */

/*! @brief Read current value of the CCM_CCGR5_CG2 field. */
#define BR_CCM_CCGR5_CG2(x)  (HW_CCM_CCGR5(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR5_CG2. */
#define BF_CCM_CCGR5_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG2) & BM_CCM_CCGR5_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR5_CG2(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG2) | BF_CCM_CCGR5_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG3[7:6] (RW)
 *
 * sdma clock (sdma_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG3     (6U)          /*!< Bit position for CCM_CCGR5_CG3. */
#define BM_CCM_CCGR5_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR5_CG3. */
#define BS_CCM_CCGR5_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG3. */

/*! @brief Read current value of the CCM_CCGR5_CG3 field. */
#define BR_CCM_CCGR5_CG3(x)  (HW_CCM_CCGR5(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR5_CG3. */
#define BF_CCM_CCGR5_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG3) & BM_CCM_CCGR5_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR5_CG3(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG3) | BF_CCM_CCGR5_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG4[9:8] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG4     (8U)          /*!< Bit position for CCM_CCGR5_CG4. */
#define BM_CCM_CCGR5_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR5_CG4. */
#define BS_CCM_CCGR5_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG4. */

/*! @brief Read current value of the CCM_CCGR5_CG4 field. */
#define BR_CCM_CCGR5_CG4(x)  (HW_CCM_CCGR5(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR5_CG4. */
#define BF_CCM_CCGR5_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG4) & BM_CCM_CCGR5_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR5_CG4(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG4) | BF_CCM_CCGR5_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG5[11:10] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG5     (10U)         /*!< Bit position for CCM_CCGR5_CG5. */
#define BM_CCM_CCGR5_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR5_CG5. */
#define BS_CCM_CCGR5_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG5. */

/*! @brief Read current value of the CCM_CCGR5_CG5 field. */
#define BR_CCM_CCGR5_CG5(x)  (HW_CCM_CCGR5(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR5_CG5. */
#define BF_CCM_CCGR5_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG5) & BM_CCM_CCGR5_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR5_CG5(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG5) | BF_CCM_CCGR5_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG6[13:12] (RW)
 *
 * spba clock (spba_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG6     (12U)         /*!< Bit position for CCM_CCGR5_CG6. */
#define BM_CCM_CCGR5_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR5_CG6. */
#define BS_CCM_CCGR5_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG6. */

/*! @brief Read current value of the CCM_CCGR5_CG6 field. */
#define BR_CCM_CCGR5_CG6(x)  (HW_CCM_CCGR5(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR5_CG6. */
#define BF_CCM_CCGR5_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG6) & BM_CCM_CCGR5_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR5_CG6(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG6) | BF_CCM_CCGR5_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG7[15:14] (RW)
 *
 * spdif clock (spdif_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG7     (14U)         /*!< Bit position for CCM_CCGR5_CG7. */
#define BM_CCM_CCGR5_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR5_CG7. */
#define BS_CCM_CCGR5_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG7. */

/*! @brief Read current value of the CCM_CCGR5_CG7 field. */
#define BR_CCM_CCGR5_CG7(x)  (HW_CCM_CCGR5(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR5_CG7. */
#define BF_CCM_CCGR5_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG7) & BM_CCM_CCGR5_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR5_CG7(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG7) | BF_CCM_CCGR5_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG8[17:16] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG8     (16U)         /*!< Bit position for CCM_CCGR5_CG8. */
#define BM_CCM_CCGR5_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR5_CG8. */
#define BS_CCM_CCGR5_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG8. */

/*! @brief Read current value of the CCM_CCGR5_CG8 field. */
#define BR_CCM_CCGR5_CG8(x)  (HW_CCM_CCGR5(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR5_CG8. */
#define BF_CCM_CCGR5_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG8) & BM_CCM_CCGR5_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR5_CG8(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG8) | BF_CCM_CCGR5_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG9[19:18] (RW)
 *
 * ssi1 clocks (ssi1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG9     (18U)         /*!< Bit position for CCM_CCGR5_CG9. */
#define BM_CCM_CCGR5_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR5_CG9. */
#define BS_CCM_CCGR5_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG9. */

/*! @brief Read current value of the CCM_CCGR5_CG9 field. */
#define BR_CCM_CCGR5_CG9(x)  (HW_CCM_CCGR5(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR5_CG9. */
#define BF_CCM_CCGR5_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG9) & BM_CCM_CCGR5_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR5_CG9(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG9) | BF_CCM_CCGR5_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG10[21:20] (RW)
 *
 * ssi2 clocks (ssi2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG10    (20U)         /*!< Bit position for CCM_CCGR5_CG10. */
#define BM_CCM_CCGR5_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR5_CG10. */
#define BS_CCM_CCGR5_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG10. */

/*! @brief Read current value of the CCM_CCGR5_CG10 field. */
#define BR_CCM_CCGR5_CG10(x) (HW_CCM_CCGR5(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR5_CG10. */
#define BF_CCM_CCGR5_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG10) & BM_CCM_CCGR5_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR5_CG10(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG10) | BF_CCM_CCGR5_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG11[23:22] (RW)
 *
 * ssi3 clocks (ssi3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG11    (22U)         /*!< Bit position for CCM_CCGR5_CG11. */
#define BM_CCM_CCGR5_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR5_CG11. */
#define BS_CCM_CCGR5_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG11. */

/*! @brief Read current value of the CCM_CCGR5_CG11 field. */
#define BR_CCM_CCGR5_CG11(x) (HW_CCM_CCGR5(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR5_CG11. */
#define BF_CCM_CCGR5_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG11) & BM_CCM_CCGR5_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR5_CG11(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG11) | BF_CCM_CCGR5_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG12[25:24] (RW)
 *
 * uart clock (uart_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG12    (24U)         /*!< Bit position for CCM_CCGR5_CG12. */
#define BM_CCM_CCGR5_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR5_CG12. */
#define BS_CCM_CCGR5_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG12. */

/*! @brief Read current value of the CCM_CCGR5_CG12 field. */
#define BR_CCM_CCGR5_CG12(x) (HW_CCM_CCGR5(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR5_CG12. */
#define BF_CCM_CCGR5_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG12) & BM_CCM_CCGR5_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR5_CG12(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG12) | BF_CCM_CCGR5_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG13[27:26] (RW)
 *
 * uart_serial clock (uart_serial_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR5_CG13    (26U)         /*!< Bit position for CCM_CCGR5_CG13. */
#define BM_CCM_CCGR5_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR5_CG13. */
#define BS_CCM_CCGR5_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG13. */

/*! @brief Read current value of the CCM_CCGR5_CG13 field. */
#define BR_CCM_CCGR5_CG13(x) (HW_CCM_CCGR5(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR5_CG13. */
#define BF_CCM_CCGR5_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG13) & BM_CCM_CCGR5_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR5_CG13(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG13) | BF_CCM_CCGR5_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG14[29:28] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG14    (28U)         /*!< Bit position for CCM_CCGR5_CG14. */
#define BM_CCM_CCGR5_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR5_CG14. */
#define BS_CCM_CCGR5_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG14. */

/*! @brief Read current value of the CCM_CCGR5_CG14 field. */
#define BR_CCM_CCGR5_CG14(x) (HW_CCM_CCGR5(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR5_CG14. */
#define BF_CCM_CCGR5_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG14) & BM_CCM_CCGR5_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR5_CG14(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG14) | BF_CCM_CCGR5_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR5_CG15    (30U)         /*!< Bit position for CCM_CCGR5_CG15. */
#define BM_CCM_CCGR5_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR5_CG15. */
#define BS_CCM_CCGR5_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR5_CG15. */

/*! @brief Read current value of the CCM_CCGR5_CG15 field. */
#define BR_CCM_CCGR5_CG15(x) (HW_CCM_CCGR5(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR5_CG15. */
#define BF_CCM_CCGR5_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_CG15) & BM_CCM_CCGR5_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR5_CG15(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_CG15) | BF_CCM_CCGR5_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR6 - CCM Clock Gating Register 6
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR6 - CCM Clock Gating Register 6 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6). The
 * clock gating Registers define the clock gating for power reduction of each
 * clock (CG(i) bits). There are 8 CGR registers. The number of registers required
 * is determined by the number of peripherals in the system.
 */
typedef union _hw_ccm_ccgr6
{
    uint32_t U;
    struct _hw_ccm_ccgr6_bitfields
    {
        uint32_t CG0 : 2;              /*!< [1:0]  */
        uint32_t CG1 : 2;              /*!< [3:2]  */
        uint32_t CG2 : 2;              /*!< [5:4]  */
        uint32_t CG3 : 2;              /*!< [7:6]  */
        uint32_t CG4 : 2;              /*!< [9:8]  */
        uint32_t CG5 : 2;              /*!< [11:10]  */
        uint32_t CG6 : 2;              /*!< [13:12]  */
        uint32_t CG7 : 2;              /*!< [15:14]  */
        uint32_t CG8 : 2;              /*!< [17:16]  */
        uint32_t CG9 : 2;              /*!< [19:18]  */
        uint32_t CG10 : 2;             /*!< [21:20]  */
        uint32_t CG11 : 2;             /*!< [23:22]  */
        uint32_t CG12 : 2;             /*!< [25:24]  */
        uint32_t CG13 : 2;             /*!< [27:26]  */
        uint32_t CG14 : 2;             /*!< [29:28]  */
        uint32_t CG15 : 2;             /*!< [31:30]  */
    } B;
} hw_ccm_ccgr6_t;

/*!
 * @name Constants and macros for entire CCM_CCGR6 register
 */
/*@{*/
#define HW_CCM_CCGR6_ADDR(x)     ((uintptr_t)(x) + 0x80U)

#define HW_CCM_CCGR6(x)          (*(__IO hw_ccm_ccgr6_t *) HW_CCM_CCGR6_ADDR(x))
#define HW_CCM_CCGR6_RD(x)       (HW_CCM_CCGR6(x).U)
#define HW_CCM_CCGR6_WR(x, v)    (HW_CCM_CCGR6(x).U = (v))
#define HW_CCM_CCGR6_SET(x, v)   (HW_CCM_CCGR6_WR(x, HW_CCM_CCGR6_RD(x) |  (v)))
#define HW_CCM_CCGR6_CLR(x, v)   (HW_CCM_CCGR6_WR(x, HW_CCM_CCGR6_RD(x) & ~(v)))
#define HW_CCM_CCGR6_TOG(x, v)   (HW_CCM_CCGR6_WR(x, HW_CCM_CCGR6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR6 bitfields
 */

/*!
 * @name Register CCM_CCGR6, field CG0[1:0] (RW)
 *
 * usboh3 clock (usboh3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG0     (0U)          /*!< Bit position for CCM_CCGR6_CG0. */
#define BM_CCM_CCGR6_CG0     (0x00000003U) /*!< Bit mask for CCM_CCGR6_CG0. */
#define BS_CCM_CCGR6_CG0     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG0. */

/*! @brief Read current value of the CCM_CCGR6_CG0 field. */
#define BR_CCM_CCGR6_CG0(x)  (HW_CCM_CCGR6(x).B.CG0)

/*! @brief Format value for bitfield CCM_CCGR6_CG0. */
#define BF_CCM_CCGR6_CG0(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG0) & BM_CCM_CCGR6_CG0)

/*! @brief Set the CG0 field to a new value. */
#define BW_CCM_CCGR6_CG0(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG0) | BF_CCM_CCGR6_CG0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG1[3:2] (RW)
 *
 * usdhc1 clocks (usdhc1_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG1     (2U)          /*!< Bit position for CCM_CCGR6_CG1. */
#define BM_CCM_CCGR6_CG1     (0x0000000CU) /*!< Bit mask for CCM_CCGR6_CG1. */
#define BS_CCM_CCGR6_CG1     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG1. */

/*! @brief Read current value of the CCM_CCGR6_CG1 field. */
#define BR_CCM_CCGR6_CG1(x)  (HW_CCM_CCGR6(x).B.CG1)

/*! @brief Format value for bitfield CCM_CCGR6_CG1. */
#define BF_CCM_CCGR6_CG1(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG1) & BM_CCM_CCGR6_CG1)

/*! @brief Set the CG1 field to a new value. */
#define BW_CCM_CCGR6_CG1(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG1) | BF_CCM_CCGR6_CG1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG2[5:4] (RW)
 *
 * usdhc2 clocks (usdhc2_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG2     (4U)          /*!< Bit position for CCM_CCGR6_CG2. */
#define BM_CCM_CCGR6_CG2     (0x00000030U) /*!< Bit mask for CCM_CCGR6_CG2. */
#define BS_CCM_CCGR6_CG2     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG2. */

/*! @brief Read current value of the CCM_CCGR6_CG2 field. */
#define BR_CCM_CCGR6_CG2(x)  (HW_CCM_CCGR6(x).B.CG2)

/*! @brief Format value for bitfield CCM_CCGR6_CG2. */
#define BF_CCM_CCGR6_CG2(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG2) & BM_CCM_CCGR6_CG2)

/*! @brief Set the CG2 field to a new value. */
#define BW_CCM_CCGR6_CG2(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG2) | BF_CCM_CCGR6_CG2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG3[7:6] (RW)
 *
 * usdhc3 clocks (usdhc3_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG3     (6U)          /*!< Bit position for CCM_CCGR6_CG3. */
#define BM_CCM_CCGR6_CG3     (0x000000C0U) /*!< Bit mask for CCM_CCGR6_CG3. */
#define BS_CCM_CCGR6_CG3     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG3. */

/*! @brief Read current value of the CCM_CCGR6_CG3 field. */
#define BR_CCM_CCGR6_CG3(x)  (HW_CCM_CCGR6(x).B.CG3)

/*! @brief Format value for bitfield CCM_CCGR6_CG3. */
#define BF_CCM_CCGR6_CG3(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG3) & BM_CCM_CCGR6_CG3)

/*! @brief Set the CG3 field to a new value. */
#define BW_CCM_CCGR6_CG3(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG3) | BF_CCM_CCGR6_CG3(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG4[9:8] (RW)
 *
 * usdhc4 clocks (usdhc4_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG4     (8U)          /*!< Bit position for CCM_CCGR6_CG4. */
#define BM_CCM_CCGR6_CG4     (0x00000300U) /*!< Bit mask for CCM_CCGR6_CG4. */
#define BS_CCM_CCGR6_CG4     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG4. */

/*! @brief Read current value of the CCM_CCGR6_CG4 field. */
#define BR_CCM_CCGR6_CG4(x)  (HW_CCM_CCGR6(x).B.CG4)

/*! @brief Format value for bitfield CCM_CCGR6_CG4. */
#define BF_CCM_CCGR6_CG4(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG4) & BM_CCM_CCGR6_CG4)

/*! @brief Set the CG4 field to a new value. */
#define BW_CCM_CCGR6_CG4(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG4) | BF_CCM_CCGR6_CG4(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG5[11:10] (RW)
 *
 * eim_slow clocks (eim_slow_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG5     (10U)         /*!< Bit position for CCM_CCGR6_CG5. */
#define BM_CCM_CCGR6_CG5     (0x00000C00U) /*!< Bit mask for CCM_CCGR6_CG5. */
#define BS_CCM_CCGR6_CG5     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG5. */

/*! @brief Read current value of the CCM_CCGR6_CG5 field. */
#define BR_CCM_CCGR6_CG5(x)  (HW_CCM_CCGR6(x).B.CG5)

/*! @brief Format value for bitfield CCM_CCGR6_CG5. */
#define BF_CCM_CCGR6_CG5(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG5) & BM_CCM_CCGR6_CG5)

/*! @brief Set the CG5 field to a new value. */
#define BW_CCM_CCGR6_CG5(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG5) | BF_CCM_CCGR6_CG5(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG6[13:12] (RW)
 *
 * vdoaxiclk root clock (vdoaxiclk_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG6     (12U)         /*!< Bit position for CCM_CCGR6_CG6. */
#define BM_CCM_CCGR6_CG6     (0x00003000U) /*!< Bit mask for CCM_CCGR6_CG6. */
#define BS_CCM_CCGR6_CG6     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG6. */

/*! @brief Read current value of the CCM_CCGR6_CG6 field. */
#define BR_CCM_CCGR6_CG6(x)  (HW_CCM_CCGR6(x).B.CG6)

/*! @brief Format value for bitfield CCM_CCGR6_CG6. */
#define BF_CCM_CCGR6_CG6(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG6) & BM_CCM_CCGR6_CG6)

/*! @brief Set the CG6 field to a new value. */
#define BW_CCM_CCGR6_CG6(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG6) | BF_CCM_CCGR6_CG6(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG7[15:14] (RW)
 *
 * vpu clocks (vpu_clk_enable)
 */
/*@{*/
#define BP_CCM_CCGR6_CG7     (14U)         /*!< Bit position for CCM_CCGR6_CG7. */
#define BM_CCM_CCGR6_CG7     (0x0000C000U) /*!< Bit mask for CCM_CCGR6_CG7. */
#define BS_CCM_CCGR6_CG7     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG7. */

/*! @brief Read current value of the CCM_CCGR6_CG7 field. */
#define BR_CCM_CCGR6_CG7(x)  (HW_CCM_CCGR6(x).B.CG7)

/*! @brief Format value for bitfield CCM_CCGR6_CG7. */
#define BF_CCM_CCGR6_CG7(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG7) & BM_CCM_CCGR6_CG7)

/*! @brief Set the CG7 field to a new value. */
#define BW_CCM_CCGR6_CG7(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG7) | BF_CCM_CCGR6_CG7(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG8[17:16] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG8     (16U)         /*!< Bit position for CCM_CCGR6_CG8. */
#define BM_CCM_CCGR6_CG8     (0x00030000U) /*!< Bit mask for CCM_CCGR6_CG8. */
#define BS_CCM_CCGR6_CG8     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG8. */

/*! @brief Read current value of the CCM_CCGR6_CG8 field. */
#define BR_CCM_CCGR6_CG8(x)  (HW_CCM_CCGR6(x).B.CG8)

/*! @brief Format value for bitfield CCM_CCGR6_CG8. */
#define BF_CCM_CCGR6_CG8(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG8) & BM_CCM_CCGR6_CG8)

/*! @brief Set the CG8 field to a new value. */
#define BW_CCM_CCGR6_CG8(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG8) | BF_CCM_CCGR6_CG8(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG9[19:18] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG9     (18U)         /*!< Bit position for CCM_CCGR6_CG9. */
#define BM_CCM_CCGR6_CG9     (0x000C0000U) /*!< Bit mask for CCM_CCGR6_CG9. */
#define BS_CCM_CCGR6_CG9     (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG9. */

/*! @brief Read current value of the CCM_CCGR6_CG9 field. */
#define BR_CCM_CCGR6_CG9(x)  (HW_CCM_CCGR6(x).B.CG9)

/*! @brief Format value for bitfield CCM_CCGR6_CG9. */
#define BF_CCM_CCGR6_CG9(v)  ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG9) & BM_CCM_CCGR6_CG9)

/*! @brief Set the CG9 field to a new value. */
#define BW_CCM_CCGR6_CG9(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG9) | BF_CCM_CCGR6_CG9(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG10[21:20] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG10    (20U)         /*!< Bit position for CCM_CCGR6_CG10. */
#define BM_CCM_CCGR6_CG10    (0x00300000U) /*!< Bit mask for CCM_CCGR6_CG10. */
#define BS_CCM_CCGR6_CG10    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG10. */

/*! @brief Read current value of the CCM_CCGR6_CG10 field. */
#define BR_CCM_CCGR6_CG10(x) (HW_CCM_CCGR6(x).B.CG10)

/*! @brief Format value for bitfield CCM_CCGR6_CG10. */
#define BF_CCM_CCGR6_CG10(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG10) & BM_CCM_CCGR6_CG10)

/*! @brief Set the CG10 field to a new value. */
#define BW_CCM_CCGR6_CG10(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG10) | BF_CCM_CCGR6_CG10(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG11[23:22] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG11    (22U)         /*!< Bit position for CCM_CCGR6_CG11. */
#define BM_CCM_CCGR6_CG11    (0x00C00000U) /*!< Bit mask for CCM_CCGR6_CG11. */
#define BS_CCM_CCGR6_CG11    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG11. */

/*! @brief Read current value of the CCM_CCGR6_CG11 field. */
#define BR_CCM_CCGR6_CG11(x) (HW_CCM_CCGR6(x).B.CG11)

/*! @brief Format value for bitfield CCM_CCGR6_CG11. */
#define BF_CCM_CCGR6_CG11(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG11) & BM_CCM_CCGR6_CG11)

/*! @brief Set the CG11 field to a new value. */
#define BW_CCM_CCGR6_CG11(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG11) | BF_CCM_CCGR6_CG11(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG12[25:24] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG12    (24U)         /*!< Bit position for CCM_CCGR6_CG12. */
#define BM_CCM_CCGR6_CG12    (0x03000000U) /*!< Bit mask for CCM_CCGR6_CG12. */
#define BS_CCM_CCGR6_CG12    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG12. */

/*! @brief Read current value of the CCM_CCGR6_CG12 field. */
#define BR_CCM_CCGR6_CG12(x) (HW_CCM_CCGR6(x).B.CG12)

/*! @brief Format value for bitfield CCM_CCGR6_CG12. */
#define BF_CCM_CCGR6_CG12(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG12) & BM_CCM_CCGR6_CG12)

/*! @brief Set the CG12 field to a new value. */
#define BW_CCM_CCGR6_CG12(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG12) | BF_CCM_CCGR6_CG12(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG13[27:26] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG13    (26U)         /*!< Bit position for CCM_CCGR6_CG13. */
#define BM_CCM_CCGR6_CG13    (0x0C000000U) /*!< Bit mask for CCM_CCGR6_CG13. */
#define BS_CCM_CCGR6_CG13    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG13. */

/*! @brief Read current value of the CCM_CCGR6_CG13 field. */
#define BR_CCM_CCGR6_CG13(x) (HW_CCM_CCGR6(x).B.CG13)

/*! @brief Format value for bitfield CCM_CCGR6_CG13. */
#define BF_CCM_CCGR6_CG13(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG13) & BM_CCM_CCGR6_CG13)

/*! @brief Set the CG13 field to a new value. */
#define BW_CCM_CCGR6_CG13(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG13) | BF_CCM_CCGR6_CG13(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG14[29:28] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG14    (28U)         /*!< Bit position for CCM_CCGR6_CG14. */
#define BM_CCM_CCGR6_CG14    (0x30000000U) /*!< Bit mask for CCM_CCGR6_CG14. */
#define BS_CCM_CCGR6_CG14    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG14. */

/*! @brief Read current value of the CCM_CCGR6_CG14 field. */
#define BR_CCM_CCGR6_CG14(x) (HW_CCM_CCGR6(x).B.CG14)

/*! @brief Format value for bitfield CCM_CCGR6_CG14. */
#define BF_CCM_CCGR6_CG14(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG14) & BM_CCM_CCGR6_CG14)

/*! @brief Set the CG14 field to a new value. */
#define BW_CCM_CCGR6_CG14(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG14) | BF_CCM_CCGR6_CG14(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field CG15[31:30] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_CCGR6_CG15    (30U)         /*!< Bit position for CCM_CCGR6_CG15. */
#define BM_CCM_CCGR6_CG15    (0xC0000000U) /*!< Bit mask for CCM_CCGR6_CG15. */
#define BS_CCM_CCGR6_CG15    (2U)          /*!< Bit field size in bits for CCM_CCGR6_CG15. */

/*! @brief Read current value of the CCM_CCGR6_CG15 field. */
#define BR_CCM_CCGR6_CG15(x) (HW_CCM_CCGR6(x).B.CG15)

/*! @brief Format value for bitfield CCM_CCGR6_CG15. */
#define BF_CCM_CCGR6_CG15(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_CG15) & BM_CCM_CCGR6_CG15)

/*! @brief Set the CG15 field to a new value. */
#define BW_CCM_CCGR6_CG15(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_CG15) | BF_CCM_CCGR6_CG15(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CMEOR - CCM Module Enable Overide Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CMEOR - CCM Module Enable Overide Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The follow figure represents the CCM Module Enable Override Register (CMEOR).
 * The CMEOR register contains bits to override the clock enable signal from the
 * module. This bit will be applicable only for modules whose clock enable
 * signals are used. The following table provides its field descriptions.
 */
typedef union _hw_ccm_cmeor
{
    uint32_t U;
    struct _hw_ccm_cmeor_bitfields
    {
        uint32_t RESERVED0 : 5;        /*!< [4:0]  */
        uint32_t mod_en_ov_gpt : 1;    /*!< [5]  */
        uint32_t mod_en_ov_epit : 1;   /*!< [6]  */
        uint32_t mod_en_usdhc : 1;     /*!< [7]  */
        uint32_t RESERVED1 : 2;        /*!< [9:8]  */
        uint32_t mod_en_ov_gpu2d : 1;  /*!< [10]  */
        uint32_t RESERVED2 : 21;       /*!< [31:11]  */
    } B;
} hw_ccm_cmeor_t;

/*!
 * @name Constants and macros for entire CCM_CMEOR register
 */
/*@{*/
#define HW_CCM_CMEOR_ADDR(x)     ((uintptr_t)(x) + 0x88U)

#define HW_CCM_CMEOR(x)          (*(__IO hw_ccm_cmeor_t *) HW_CCM_CMEOR_ADDR(x))
#define HW_CCM_CMEOR_RD(x)       (HW_CCM_CMEOR(x).U)
#define HW_CCM_CMEOR_WR(x, v)    (HW_CCM_CMEOR(x).U = (v))
#define HW_CCM_CMEOR_SET(x, v)   (HW_CCM_CMEOR_WR(x, HW_CCM_CMEOR_RD(x) |  (v)))
#define HW_CCM_CMEOR_CLR(x, v)   (HW_CCM_CMEOR_WR(x, HW_CCM_CMEOR_RD(x) & ~(v)))
#define HW_CCM_CMEOR_TOG(x, v)   (HW_CCM_CMEOR_WR(x, HW_CCM_CMEOR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_CMEOR bitfields
 */

/*!
 * @name Register CCM_CMEOR, field mod_en_ov_gpt[5] (RW)
 *
 * Overide clock enable signal from GPT - clock will not be gated based on GPT's
 * signal 'ipg_enable_clk' .
 *
 * Values:
 * - 0 - don't override module enable signal
 * - 1 - override module enable signal
 */
/*@{*/
#define BP_CCM_CMEOR_mod_en_ov_gpt (5U)    /*!< Bit position for CCM_CMEOR_mod_en_ov_gpt. */
#define BM_CCM_CMEOR_mod_en_ov_gpt (0x00000020U) /*!< Bit mask for CCM_CMEOR_mod_en_ov_gpt. */
#define BS_CCM_CMEOR_mod_en_ov_gpt (1U)    /*!< Bit field size in bits for CCM_CMEOR_mod_en_ov_gpt. */

/*! @brief Read current value of the CCM_CMEOR_mod_en_ov_gpt field. */
#define BR_CCM_CMEOR_mod_en_ov_gpt(x) (HW_CCM_CMEOR(x).B.mod_en_ov_gpt)

/*! @brief Format value for bitfield CCM_CMEOR_mod_en_ov_gpt. */
#define BF_CCM_CMEOR_mod_en_ov_gpt(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CMEOR_mod_en_ov_gpt) & BM_CCM_CMEOR_mod_en_ov_gpt)

/*! @brief Set the mod_en_ov_gpt field to a new value. */
#define BW_CCM_CMEOR_mod_en_ov_gpt(x, v) (HW_CCM_CMEOR_WR(x, (HW_CCM_CMEOR_RD(x) & ~BM_CCM_CMEOR_mod_en_ov_gpt) | BF_CCM_CMEOR_mod_en_ov_gpt(v)))
/*@}*/

/*!
 * @name Register CCM_CMEOR, field mod_en_ov_epit[6] (RW)
 *
 * Overide clock enable signal from EPIT - clock will not be gated based on
 * EPIT's signal 'ipg_enable_clk' .
 *
 * Values:
 * - 0 - don't override module enable signal
 * - 1 - override module enable signal
 */
/*@{*/
#define BP_CCM_CMEOR_mod_en_ov_epit (6U)   /*!< Bit position for CCM_CMEOR_mod_en_ov_epit. */
#define BM_CCM_CMEOR_mod_en_ov_epit (0x00000040U) /*!< Bit mask for CCM_CMEOR_mod_en_ov_epit. */
#define BS_CCM_CMEOR_mod_en_ov_epit (1U)   /*!< Bit field size in bits for CCM_CMEOR_mod_en_ov_epit. */

/*! @brief Read current value of the CCM_CMEOR_mod_en_ov_epit field. */
#define BR_CCM_CMEOR_mod_en_ov_epit(x) (HW_CCM_CMEOR(x).B.mod_en_ov_epit)

/*! @brief Format value for bitfield CCM_CMEOR_mod_en_ov_epit. */
#define BF_CCM_CMEOR_mod_en_ov_epit(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CMEOR_mod_en_ov_epit) & BM_CCM_CMEOR_mod_en_ov_epit)

/*! @brief Set the mod_en_ov_epit field to a new value. */
#define BW_CCM_CMEOR_mod_en_ov_epit(x, v) (HW_CCM_CMEOR_WR(x, (HW_CCM_CMEOR_RD(x) & ~BM_CCM_CMEOR_mod_en_ov_epit) | BF_CCM_CMEOR_mod_en_ov_epit(v)))
/*@}*/

/*!
 * @name Register CCM_CMEOR, field mod_en_usdhc[7] (RW)
 *
 * overide clock enable signal from USDHC.
 *
 * Values:
 * - 0 - don't override module enable signal
 * - 1 - override module enable signal
 */
/*@{*/
#define BP_CCM_CMEOR_mod_en_usdhc (7U)     /*!< Bit position for CCM_CMEOR_mod_en_usdhc. */
#define BM_CCM_CMEOR_mod_en_usdhc (0x00000080U) /*!< Bit mask for CCM_CMEOR_mod_en_usdhc. */
#define BS_CCM_CMEOR_mod_en_usdhc (1U)     /*!< Bit field size in bits for CCM_CMEOR_mod_en_usdhc. */

/*! @brief Read current value of the CCM_CMEOR_mod_en_usdhc field. */
#define BR_CCM_CMEOR_mod_en_usdhc(x) (HW_CCM_CMEOR(x).B.mod_en_usdhc)

/*! @brief Format value for bitfield CCM_CMEOR_mod_en_usdhc. */
#define BF_CCM_CMEOR_mod_en_usdhc(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CMEOR_mod_en_usdhc) & BM_CCM_CMEOR_mod_en_usdhc)

/*! @brief Set the mod_en_usdhc field to a new value. */
#define BW_CCM_CMEOR_mod_en_usdhc(x, v) (HW_CCM_CMEOR_WR(x, (HW_CCM_CMEOR_RD(x) & ~BM_CCM_CMEOR_mod_en_usdhc) | BF_CCM_CMEOR_mod_en_usdhc(v)))
/*@}*/

/*!
 * @name Register CCM_CMEOR, field mod_en_ov_gpu2d[10] (RW)
 *
 * Overide clock enable signal from GPU2D - clock will not be gated based on
 * GPU2D's signal 'gpu2d_busy' .
 *
 * Values:
 * - 0 - don't override module enable signal
 * - 1 - override module enable signal
 */
/*@{*/
#define BP_CCM_CMEOR_mod_en_ov_gpu2d (10U) /*!< Bit position for CCM_CMEOR_mod_en_ov_gpu2d. */
#define BM_CCM_CMEOR_mod_en_ov_gpu2d (0x00000400U) /*!< Bit mask for CCM_CMEOR_mod_en_ov_gpu2d. */
#define BS_CCM_CMEOR_mod_en_ov_gpu2d (1U)  /*!< Bit field size in bits for CCM_CMEOR_mod_en_ov_gpu2d. */

/*! @brief Read current value of the CCM_CMEOR_mod_en_ov_gpu2d field. */
#define BR_CCM_CMEOR_mod_en_ov_gpu2d(x) (HW_CCM_CMEOR(x).B.mod_en_ov_gpu2d)

/*! @brief Format value for bitfield CCM_CMEOR_mod_en_ov_gpu2d. */
#define BF_CCM_CMEOR_mod_en_ov_gpu2d(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CMEOR_mod_en_ov_gpu2d) & BM_CCM_CMEOR_mod_en_ov_gpu2d)

/*! @brief Set the mod_en_ov_gpu2d field to a new value. */
#define BW_CCM_CMEOR_mod_en_ov_gpu2d(x, v) (HW_CCM_CMEOR_WR(x, (HW_CCM_CMEOR_RD(x) & ~BM_CCM_CMEOR_mod_en_ov_gpu2d) | BF_CCM_CMEOR_mod_en_ov_gpu2d(v)))
/*@}*/

/*******************************************************************************
 * hw_ccm_t - module struct
 ******************************************************************************/
/*!
 * @brief All CCM module registers.
 */
#pragma pack(1)
typedef struct _hw_ccm
{
    __IO hw_ccm_ccr_t CCR;                 /*!< [0x0] CCM Control Register */
    __IO hw_ccm_ccdr_t CCDR;               /*!< [0x4] CCM Control Divider Register */
    __I hw_ccm_csr_t CSR;                  /*!< [0x8] CCM Status Register */
    __IO hw_ccm_ccsr_t CCSR;               /*!< [0xC] CCM Clock Swither Register */
    __IO hw_ccm_cacrr_t CACRR;             /*!< [0x10] CCM Arm Clock Root Register */
    __IO hw_ccm_cbcdr_t CBCDR;             /*!< [0x14] CCM Bus Clock Divider Register */
    __IO hw_ccm_cbcmr_t CBCMR;             /*!< [0x18] CCM Bus Clock Multiplexer Register */
    __IO hw_ccm_cscmr1_t CSCMR1;           /*!< [0x1C] CCM Serial Clock Multiplexer Register 1 */
    __IO hw_ccm_cscmr2_t CSCMR2;           /*!< [0x20] CCM Serial Clock Multiplexer Register 2 */
    __IO hw_ccm_cscdr1_t CSCDR1;           /*!< [0x24] CCM Serial Clock Divider Register 1 */
    __IO hw_ccm_cs1cdr_t CS1CDR;           /*!< [0x28] CCM SSI1 Clock Divider Register */
    __IO hw_ccm_cs2cdr_t CS2CDR;           /*!< [0x2C] CCM SSI2 Clock Divider Register */
    __IO hw_ccm_cdcdr_t CDCDR;             /*!< [0x30] CCM D1 Clock Divider Register */
    __IO hw_ccm_chsccdr_t CHSCCDR;         /*!< [0x34] CCM HSC Clock Divider Register */
    __IO hw_ccm_cscdr2_t CSCDR2;           /*!< [0x38] CCM Serial Clock Divider Register 2 */
    __IO hw_ccm_cscdr3_t CSCDR3;           /*!< [0x3C] CCM Serial Clock Divider Register 3 */
    uint8_t _reserved0[4];
    __I hw_ccm_cwdr_t CWDR;                /*!< [0x44] CCM Wakeup Detector Register */
    __I hw_ccm_cdhipr_t CDHIPR;            /*!< [0x48] CCM Divider Handshake In-Process Register */
    uint8_t _reserved1[8];
    __IO hw_ccm_clpcr_t CLPCR;             /*!< [0x54] CCM Low Power Control Register */
    __IO hw_ccm_cisr_t CISR;               /*!< [0x58] CCM Interrupt Status Register */
    __IO hw_ccm_cimr_t CIMR;               /*!< [0x5C] CCM Interrupt Mask Register */
    __IO hw_ccm_ccosr_t CCOSR;             /*!< [0x60] CCM Clock Output Source Register */
    __IO hw_ccm_cgpr_t CGPR;               /*!< [0x64] CCM General Purpose Register */
    __IO hw_ccm_ccgr0_t CCGR0;             /*!< [0x68] CCM Clock Gating Register 0 */
    __IO hw_ccm_ccgr1_t CCGR1;             /*!< [0x6C] CCM Clock Gating Register 1 */
    __IO hw_ccm_ccgr2_t CCGR2;             /*!< [0x70] CCM Clock Gating Register 2 */
    __IO hw_ccm_ccgr3_t CCGR3;             /*!< [0x74] CCM Clock Gating Register 3 */
    __IO hw_ccm_ccgr4_t CCGR4;             /*!< [0x78] CCM Clock Gating Register 4 */
    __IO hw_ccm_ccgr5_t CCGR5;             /*!< [0x7C] CCM Clock Gating Register 5 */
    __IO hw_ccm_ccgr6_t CCGR6;             /*!< [0x80] CCM Clock Gating Register 6 */
    uint8_t _reserved2[4];
    __IO hw_ccm_cmeor_t CMEOR;             /*!< [0x88] CCM Module Enable Overide Register */
} hw_ccm_t;
#pragma pack()

/*! @brief Macro to access all CCM registers. */
/*! @param x CCM module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CCM_REGS(CCM_BASE)</code>. */
#define HW_CCM_REGS(x) (*(hw_ccm_t *)(x))

/*
 * iMX6SL CCM_ANALOG
 *
 * CCM_ANALOG
 *
 * Registers defined in this header file:
 * - HW_CCM_ANALOG_PLL_ARM - Analog ARM PLL control Register
 * - HW_CCM_ANALOG_PLL_USB1 - Analog USB1 480MHz PLL Control Register
 * - HW_CCM_ANALOG_PLL_USB2 - Analog USB2 480MHz PLL Control Register
 * - HW_CCM_ANALOG_PLL_SYS - Analog System PLL Control Register
 * - HW_CCM_ANALOG_PLL_AUDIO - Analog Audio PLL control Register
 * - HW_CCM_ANALOG_PLL_AUDIO_NUM - Numerator of Audio PLL Fractional Loop Divider Register
 * - HW_CCM_ANALOG_PLL_AUDIO_DENOM - Denominator of Audio PLL Fractional Loop Divider Register
 * - HW_CCM_ANALOG_PLL_VIDEO - Analog Video PLL control Register
 * - HW_CCM_ANALOG_PLL_VIDEO_NUM - Numerator of Video PLL Fractional Loop Divider Register
 * - HW_CCM_ANALOG_PLL_VIDEO_DENOM - Denominator of Video PLL Fractional Loop Divider Register
 * - HW_CCM_ANALOG_PLL_ENET - Analog ENET PLL Control Register
 * - HW_CCM_ANALOG_PFD_480 - 480MHz Clock (from PLL_USB2) Phase Fractional Divider Control Register
 * - HW_CCM_ANALOG_PFD_528 - 528MHz Clock (From PLL_SYS) Phase Fractional Divider Control Register
 * - HW_CCM_ANALOG_MISC0 - Miscellaneous Control Register
 * - HW_CCM_ANALOG_MISC2 - Miscellaneous Control Register
 *
 * - hw_ccm_analog_t - Struct containing all module registers.
 */

#define HW_CCM_ANALOG_INSTANCE_COUNT (1U) /*!< Number of instances of the CCM_ANALOG module. */
#define HW_CCM_ANALOG (0U) /*!< Instance number for CCM_ANALOG. */
#define CCM_ANALOG_BASE       (0x20C8000U) /*!< Base address for CCM_ANALOG. */
/*! Array initializer of CCM_ANALOG base addresses. */
#define CCM_ANALOG_BASE_ADDRS { CCM_ANALOG_BASE }

/*******************************************************************************
 * HW_CCM_ANALOG_PLL_ARM - Analog ARM PLL control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_ARM - Analog ARM PLL control Register (RW)
 *
 * Reset value: 0x00013042U
 *
 * The control register provides control for the system PLL.
 */
typedef union _hw_ccm_analog_pll_arm
{
    uint32_t U;
    struct _hw_ccm_analog_pll_arm_bitfields
    {
        uint32_t DIV_SELECT : 7;       /*!< [6:0]  */
        uint32_t RESERVED0 : 5;        /*!< [11:7]  */
        uint32_t POWERDOWN : 1;        /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t LVDS_SEL : 1;         /*!< [17]  */
        uint32_t LVDS_24MHZ_SEL : 1;   /*!< [18]  */
        uint32_t PLL_SEL : 1;          /*!< [19]  */
        uint32_t RESERVED1 : 11;       /*!< [30:20]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_arm_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_ARM register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_ARM_ADDR(x) ((uintptr_t)(x) + 0x0U)
#define HW_CCM_ANALOG_PLL_ARM_SET_ADDR(x) (HW_CCM_ANALOG_PLL_ARM_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_ARM_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_ARM_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_ARM_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_ARM_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_ARM(x) (*(__IO hw_ccm_analog_pll_arm_t *) HW_CCM_ANALOG_PLL_ARM_ADDR(x))
#define HW_CCM_ANALOG_PLL_ARM_RD(x) (HW_CCM_ANALOG_PLL_ARM(x).U)
#define HW_CCM_ANALOG_PLL_ARM_WR(x, v) (HW_CCM_ANALOG_PLL_ARM(x).U = (v))
#define HW_CCM_ANALOG_PLL_ARM_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ARM_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_ARM_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ARM_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_ARM_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ARM_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_ARM bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field DIV_SELECT[6:0] (RW)
 *
 * This field controls the pll loop divider. Valid range for divider value:
 * 54-108. Fout = Fin * div_select/2.0.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_ARM_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_ARM_DIV_SELECT (0x0000007FU) /*!< Bit mask for CCM_ANALOG_PLL_ARM_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_ARM_DIV_SELECT (7U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_ARM_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_ARM(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_ARM_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_DIV_SELECT) & BM_CCM_ANALOG_PLL_ARM_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_DIV_SELECT) | BF_CCM_ANALOG_PLL_ARM_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field POWERDOWN[12] (RW)
 *
 * Powers down the PLL.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_POWERDOWN (12U) /*!< Bit position for CCM_ANALOG_PLL_ARM_POWERDOWN. */
#define BM_CCM_ANALOG_PLL_ARM_POWERDOWN (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_POWERDOWN. */
#define BS_CCM_ANALOG_PLL_ARM_POWERDOWN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_POWERDOWN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_POWERDOWN field. */
#define BR_CCM_ANALOG_PLL_ARM_POWERDOWN(x) (HW_CCM_ANALOG_PLL_ARM(x).B.POWERDOWN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_POWERDOWN. */
#define BF_CCM_ANALOG_PLL_ARM_POWERDOWN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_POWERDOWN) & BM_CCM_ANALOG_PLL_ARM_POWERDOWN)

/*! @brief Set the POWERDOWN field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_POWERDOWN(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_POWERDOWN) | BF_CCM_ANALOG_PLL_ARM_POWERDOWN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field ENABLE[13] (RW)
 *
 * Enable the clock output.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_ARM_ENABLE. */
#define BM_CCM_ANALOG_PLL_ARM_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_ENABLE. */
#define BS_CCM_ANALOG_PLL_ARM_ENABLE (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_ENABLE field. */
#define BR_CCM_ANALOG_PLL_ARM_ENABLE(x) (HW_CCM_ANALOG_PLL_ARM(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_ENABLE. */
#define BF_CCM_ANALOG_PLL_ARM_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_ENABLE) & BM_CCM_ANALOG_PLL_ARM_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_ENABLE(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_ENABLE) | BF_CCM_ANALOG_PLL_ARM_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC_Reserved (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_ARM(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_ARM_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_ARM_BYPASS. */
#define BM_CCM_ANALOG_PLL_ARM_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_BYPASS. */
#define BS_CCM_ANALOG_PLL_ARM_BYPASS (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_BYPASS field. */
#define BR_CCM_ANALOG_PLL_ARM_BYPASS(x) (HW_CCM_ANALOG_PLL_ARM(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_BYPASS. */
#define BF_CCM_ANALOG_PLL_ARM_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_BYPASS) & BM_CCM_ANALOG_PLL_ARM_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_BYPASS(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_BYPASS) | BF_CCM_ANALOG_PLL_ARM_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field LVDS_SEL[17] (RW)
 *
 * Analog Debug Bit
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_LVDS_SEL (17U) /*!< Bit position for CCM_ANALOG_PLL_ARM_LVDS_SEL. */
#define BM_CCM_ANALOG_PLL_ARM_LVDS_SEL (0x00020000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_LVDS_SEL. */
#define BS_CCM_ANALOG_PLL_ARM_LVDS_SEL (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_LVDS_SEL. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_LVDS_SEL field. */
#define BR_CCM_ANALOG_PLL_ARM_LVDS_SEL(x) (HW_CCM_ANALOG_PLL_ARM(x).B.LVDS_SEL)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_LVDS_SEL. */
#define BF_CCM_ANALOG_PLL_ARM_LVDS_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_LVDS_SEL) & BM_CCM_ANALOG_PLL_ARM_LVDS_SEL)

/*! @brief Set the LVDS_SEL field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_LVDS_SEL(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_LVDS_SEL) | BF_CCM_ANALOG_PLL_ARM_LVDS_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field LVDS_24MHZ_SEL[18] (RW)
 *
 * Analog Debug Bit
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL (18U) /*!< Bit position for CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL. */
#define BM_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL (0x00040000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL. */
#define BS_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL field. */
#define BR_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL(x) (HW_CCM_ANALOG_PLL_ARM(x).B.LVDS_24MHZ_SEL)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL. */
#define BF_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL) & BM_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL)

/*! @brief Set the LVDS_24MHZ_SEL field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL) | BF_CCM_ANALOG_PLL_ARM_LVDS_24MHZ_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field PLL_SEL[19] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_PLL_SEL (19U) /*!< Bit position for CCM_ANALOG_PLL_ARM_PLL_SEL. */
#define BM_CCM_ANALOG_PLL_ARM_PLL_SEL (0x00080000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_PLL_SEL. */
#define BS_CCM_ANALOG_PLL_ARM_PLL_SEL (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_PLL_SEL. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_PLL_SEL field. */
#define BR_CCM_ANALOG_PLL_ARM_PLL_SEL(x) (HW_CCM_ANALOG_PLL_ARM(x).B.PLL_SEL)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ARM_PLL_SEL. */
#define BF_CCM_ANALOG_PLL_ARM_PLL_SEL(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ARM_PLL_SEL) & BM_CCM_ANALOG_PLL_ARM_PLL_SEL)

/*! @brief Set the PLL_SEL field to a new value. */
#define BW_CCM_ANALOG_PLL_ARM_PLL_SEL(x, v) (HW_CCM_ANALOG_PLL_ARM_WR(x, (HW_CCM_ANALOG_PLL_ARM_RD(x) & ~BM_CCM_ANALOG_PLL_ARM_PLL_SEL) | BF_CCM_ANALOG_PLL_ARM_PLL_SEL(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ARM, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked. 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ARM_LOCK (31U)   /*!< Bit position for CCM_ANALOG_PLL_ARM_LOCK. */
#define BM_CCM_ANALOG_PLL_ARM_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_ARM_LOCK. */
#define BS_CCM_ANALOG_PLL_ARM_LOCK (1U)    /*!< Bit field size in bits for CCM_ANALOG_PLL_ARM_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ARM_LOCK field. */
#define BR_CCM_ANALOG_PLL_ARM_LOCK(x) (HW_CCM_ANALOG_PLL_ARM(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_USB1 - Analog USB1 480MHz PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_USB1 - Analog USB1 480MHz PLL Control Register (RW)
 *
 * Reset value: 0x00012000U
 *
 * The control register provides control for USBPHY0 480MHz PLL.
 */
typedef union _hw_ccm_analog_pll_usb1
{
    uint32_t U;
    struct _hw_ccm_analog_pll_usb1_bitfields
    {
        uint32_t DIV_SELECT : 2;       /*!< [1:0]  */
        uint32_t RESERVED0 : 4;        /*!< [5:2]  */
        uint32_t EN_USB_CLKS : 1;      /*!< [6]  */
        uint32_t RESERVED1 : 5;        /*!< [11:7]  */
        uint32_t POWER : 1;            /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED2 : 14;       /*!< [30:17]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_usb1_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_USB1 register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_USB1_ADDR(x) ((uintptr_t)(x) + 0x10U)
#define HW_CCM_ANALOG_PLL_USB1_SET_ADDR(x) (HW_CCM_ANALOG_PLL_USB1_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_USB1_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_USB1_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_USB1_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_USB1_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_USB1(x) (*(__IO hw_ccm_analog_pll_usb1_t *) HW_CCM_ANALOG_PLL_USB1_ADDR(x))
#define HW_CCM_ANALOG_PLL_USB1_RD(x) (HW_CCM_ANALOG_PLL_USB1(x).U)
#define HW_CCM_ANALOG_PLL_USB1_WR(x, v) (HW_CCM_ANALOG_PLL_USB1(x).U = (v))
#define HW_CCM_ANALOG_PLL_USB1_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB1_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_USB1_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB1_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_USB1_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_USB1 bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field DIV_SELECT[1:0] (RW)
 *
 * This field controls the pll loop divider. 0 - Fout=Fref*20; 1 - Fout=Fref*22.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_USB1_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_USB1_DIV_SELECT (0x00000003U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_USB1_DIV_SELECT (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_USB1_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_USB1(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_USB1_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_DIV_SELECT) & BM_CCM_ANALOG_PLL_USB1_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_DIV_SELECT) | BF_CCM_ANALOG_PLL_USB1_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field EN_USB_CLKS[6] (RW)
 *
 * Powers the 9-phase PLL outputs for USBPHYn. Additionally, the UTMI clock gate
 * must be deasserted in the USBPHYn to enable USBn operation (clear CLKGATE bit
 * in USBPHYn_CTRL). This bit will be set automatically when USBPHYn remote
 * wakeup event occurs.
 *
 * Values:
 * - 0 - PLL outputs for USBPHYn off.
 * - 1 - PLL outputs for USBPHYn on.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_EN_USB_CLKS (6U) /*!< Bit position for CCM_ANALOG_PLL_USB1_EN_USB_CLKS. */
#define BM_CCM_ANALOG_PLL_USB1_EN_USB_CLKS (0x00000040U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_EN_USB_CLKS. */
#define BS_CCM_ANALOG_PLL_USB1_EN_USB_CLKS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_EN_USB_CLKS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_EN_USB_CLKS field. */
#define BR_CCM_ANALOG_PLL_USB1_EN_USB_CLKS(x) (HW_CCM_ANALOG_PLL_USB1(x).B.EN_USB_CLKS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_EN_USB_CLKS. */
#define BF_CCM_ANALOG_PLL_USB1_EN_USB_CLKS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_EN_USB_CLKS) & BM_CCM_ANALOG_PLL_USB1_EN_USB_CLKS)

/*! @brief Set the EN_USB_CLKS field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_EN_USB_CLKS(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_EN_USB_CLKS) | BF_CCM_ANALOG_PLL_USB1_EN_USB_CLKS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field POWER[12] (RW)
 *
 * Powers up the PLL. This bit will be set automatically when USBPHY0 remote
 * wakeup event happens.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_POWER (12U) /*!< Bit position for CCM_ANALOG_PLL_USB1_POWER. */
#define BM_CCM_ANALOG_PLL_USB1_POWER (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_POWER. */
#define BS_CCM_ANALOG_PLL_USB1_POWER (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_POWER. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_POWER field. */
#define BR_CCM_ANALOG_PLL_USB1_POWER(x) (HW_CCM_ANALOG_PLL_USB1(x).B.POWER)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_POWER. */
#define BF_CCM_ANALOG_PLL_USB1_POWER(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_POWER) & BM_CCM_ANALOG_PLL_USB1_POWER)

/*! @brief Set the POWER field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_POWER(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_POWER) | BF_CCM_ANALOG_PLL_USB1_POWER(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field ENABLE[13] (RW)
 *
 * Enable the PLL clock output.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_USB1_ENABLE. */
#define BM_CCM_ANALOG_PLL_USB1_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_ENABLE. */
#define BS_CCM_ANALOG_PLL_USB1_ENABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_ENABLE field. */
#define BR_CCM_ANALOG_PLL_USB1_ENABLE(x) (HW_CCM_ANALOG_PLL_USB1(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_ENABLE. */
#define BF_CCM_ANALOG_PLL_USB1_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_ENABLE) & BM_CCM_ANALOG_PLL_USB1_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_ENABLE(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_ENABLE) | BF_CCM_ANALOG_PLL_USB1_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_GPANAIO (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC:  */
#define BV_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC_CHRG_DET_B (0x3U) /*!< Bit field value for CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_USB1(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_USB1_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_USB1_BYPASS. */
#define BM_CCM_ANALOG_PLL_USB1_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_BYPASS. */
#define BS_CCM_ANALOG_PLL_USB1_BYPASS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_BYPASS field. */
#define BR_CCM_ANALOG_PLL_USB1_BYPASS(x) (HW_CCM_ANALOG_PLL_USB1(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB1_BYPASS. */
#define BF_CCM_ANALOG_PLL_USB1_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB1_BYPASS) & BM_CCM_ANALOG_PLL_USB1_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_USB1_BYPASS(x, v) (HW_CCM_ANALOG_PLL_USB1_WR(x, (HW_CCM_ANALOG_PLL_USB1_RD(x) & ~BM_CCM_ANALOG_PLL_USB1_BYPASS) | BF_CCM_ANALOG_PLL_USB1_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB1, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked. 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB1_LOCK (31U)  /*!< Bit position for CCM_ANALOG_PLL_USB1_LOCK. */
#define BM_CCM_ANALOG_PLL_USB1_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_USB1_LOCK. */
#define BS_CCM_ANALOG_PLL_USB1_LOCK (1U)   /*!< Bit field size in bits for CCM_ANALOG_PLL_USB1_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB1_LOCK field. */
#define BR_CCM_ANALOG_PLL_USB1_LOCK(x) (HW_CCM_ANALOG_PLL_USB1(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_USB2 - Analog USB2 480MHz PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_USB2 - Analog USB2 480MHz PLL Control Register (RW)
 *
 * Reset value: 0x00012000U
 *
 * The control register provides control for USBPHY1 480MHz PLL.
 */
typedef union _hw_ccm_analog_pll_usb2
{
    uint32_t U;
    struct _hw_ccm_analog_pll_usb2_bitfields
    {
        uint32_t DIV_SELECT : 2;       /*!< [1:0]  */
        uint32_t RESERVED0 : 4;        /*!< [5:2]  */
        uint32_t EN_USB_CLKS : 1;      /*!< [6]  */
        uint32_t RESERVED1 : 5;        /*!< [11:7]  */
        uint32_t POWER : 1;            /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED2 : 14;       /*!< [30:17]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_usb2_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_USB2 register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_USB2_ADDR(x) ((uintptr_t)(x) + 0x20U)
#define HW_CCM_ANALOG_PLL_USB2_SET_ADDR(x) (HW_CCM_ANALOG_PLL_USB2_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_USB2_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_USB2_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_USB2_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_USB2_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_USB2(x) (*(__IO hw_ccm_analog_pll_usb2_t *) HW_CCM_ANALOG_PLL_USB2_ADDR(x))
#define HW_CCM_ANALOG_PLL_USB2_RD(x) (HW_CCM_ANALOG_PLL_USB2(x).U)
#define HW_CCM_ANALOG_PLL_USB2_WR(x, v) (HW_CCM_ANALOG_PLL_USB2(x).U = (v))
#define HW_CCM_ANALOG_PLL_USB2_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB2_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_USB2_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB2_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_USB2_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_USB2_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_USB2 bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field DIV_SELECT[1:0] (RW)
 *
 * This field controls the pll loop divider. 0 - Fout=Fref*20; 1 - Fout=Fref*22.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_USB2_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_USB2_DIV_SELECT (0x00000003U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_USB2_DIV_SELECT (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_USB2_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_USB2(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_USB2_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_DIV_SELECT) & BM_CCM_ANALOG_PLL_USB2_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_DIV_SELECT) | BF_CCM_ANALOG_PLL_USB2_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field EN_USB_CLKS[6] (RW)
 *
 * 0: 8-phase PLL outputs for USBPHY1 are powered down. If set to 1, 8-phase PLL
 * outputs for USBPHY1 are powered up. Additionally, the utmi clock gate must be
 * deasserted in the USBPHY1 to enable USB0 operation (clear CLKGATE bit in
 * USBPHY1_CTRL).This bit will be set automatically when USBPHY1 remote wakeup event
 * happens.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_EN_USB_CLKS (6U) /*!< Bit position for CCM_ANALOG_PLL_USB2_EN_USB_CLKS. */
#define BM_CCM_ANALOG_PLL_USB2_EN_USB_CLKS (0x00000040U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_EN_USB_CLKS. */
#define BS_CCM_ANALOG_PLL_USB2_EN_USB_CLKS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_EN_USB_CLKS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_EN_USB_CLKS field. */
#define BR_CCM_ANALOG_PLL_USB2_EN_USB_CLKS(x) (HW_CCM_ANALOG_PLL_USB2(x).B.EN_USB_CLKS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_EN_USB_CLKS. */
#define BF_CCM_ANALOG_PLL_USB2_EN_USB_CLKS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_EN_USB_CLKS) & BM_CCM_ANALOG_PLL_USB2_EN_USB_CLKS)

/*! @brief Set the EN_USB_CLKS field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_EN_USB_CLKS(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_EN_USB_CLKS) | BF_CCM_ANALOG_PLL_USB2_EN_USB_CLKS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field POWER[12] (RW)
 *
 * Powers up the PLL. This bit will be set automatically when USBPHY1 remote
 * wakeup event happens.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_POWER (12U) /*!< Bit position for CCM_ANALOG_PLL_USB2_POWER. */
#define BM_CCM_ANALOG_PLL_USB2_POWER (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_POWER. */
#define BS_CCM_ANALOG_PLL_USB2_POWER (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_POWER. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_POWER field. */
#define BR_CCM_ANALOG_PLL_USB2_POWER(x) (HW_CCM_ANALOG_PLL_USB2(x).B.POWER)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_POWER. */
#define BF_CCM_ANALOG_PLL_USB2_POWER(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_POWER) & BM_CCM_ANALOG_PLL_USB2_POWER)

/*! @brief Set the POWER field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_POWER(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_POWER) | BF_CCM_ANALOG_PLL_USB2_POWER(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field ENABLE[13] (RW)
 *
 * Enable the PLL clock output.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_USB2_ENABLE. */
#define BM_CCM_ANALOG_PLL_USB2_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_ENABLE. */
#define BS_CCM_ANALOG_PLL_USB2_ENABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_ENABLE field. */
#define BR_CCM_ANALOG_PLL_USB2_ENABLE(x) (HW_CCM_ANALOG_PLL_USB2(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_ENABLE. */
#define BF_CCM_ANALOG_PLL_USB2_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_ENABLE) & BM_CCM_ANALOG_PLL_USB2_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_ENABLE(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_ENABLE) | BF_CCM_ANALOG_PLL_USB2_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC_Reserved (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_USB2(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_USB2_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_USB2_BYPASS. */
#define BM_CCM_ANALOG_PLL_USB2_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_BYPASS. */
#define BS_CCM_ANALOG_PLL_USB2_BYPASS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_BYPASS field. */
#define BR_CCM_ANALOG_PLL_USB2_BYPASS(x) (HW_CCM_ANALOG_PLL_USB2(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_USB2_BYPASS. */
#define BF_CCM_ANALOG_PLL_USB2_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_USB2_BYPASS) & BM_CCM_ANALOG_PLL_USB2_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_USB2_BYPASS(x, v) (HW_CCM_ANALOG_PLL_USB2_WR(x, (HW_CCM_ANALOG_PLL_USB2_RD(x) & ~BM_CCM_ANALOG_PLL_USB2_BYPASS) | BF_CCM_ANALOG_PLL_USB2_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_USB2, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked. 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_USB2_LOCK (31U)  /*!< Bit position for CCM_ANALOG_PLL_USB2_LOCK. */
#define BM_CCM_ANALOG_PLL_USB2_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_USB2_LOCK. */
#define BS_CCM_ANALOG_PLL_USB2_LOCK (1U)   /*!< Bit field size in bits for CCM_ANALOG_PLL_USB2_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_USB2_LOCK field. */
#define BR_CCM_ANALOG_PLL_USB2_LOCK(x) (HW_CCM_ANALOG_PLL_USB2(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_SYS - Analog System PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_SYS - Analog System PLL Control Register (RW)
 *
 * Reset value: 0x00013001U
 *
 * The control register provides control for the 528MHz PLL.
 */
typedef union _hw_ccm_analog_pll_sys
{
    uint32_t U;
    struct _hw_ccm_analog_pll_sys_bitfields
    {
        uint32_t DIV_SELECT : 1;       /*!< [0]  */
        uint32_t RESERVED0 : 11;       /*!< [11:1]  */
        uint32_t POWERDOWN : 1;        /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED1 : 1;        /*!< [17]  */
        uint32_t PFD_OFFSET_EN : 1;    /*!< [18]  */
        uint32_t RESERVED2 : 12;       /*!< [30:19]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_sys_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_SYS register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_SYS_ADDR(x) ((uintptr_t)(x) + 0x30U)
#define HW_CCM_ANALOG_PLL_SYS_SET_ADDR(x) (HW_CCM_ANALOG_PLL_SYS_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_SYS_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_SYS_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_SYS_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_SYS_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_SYS(x) (*(__IO hw_ccm_analog_pll_sys_t *) HW_CCM_ANALOG_PLL_SYS_ADDR(x))
#define HW_CCM_ANALOG_PLL_SYS_RD(x) (HW_CCM_ANALOG_PLL_SYS(x).U)
#define HW_CCM_ANALOG_PLL_SYS_WR(x, v) (HW_CCM_ANALOG_PLL_SYS(x).U = (v))
#define HW_CCM_ANALOG_PLL_SYS_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_SYS_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_SYS_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_SYS_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_SYS_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_SYS_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_SYS bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field DIV_SELECT[0] (RW)
 *
 * This field controls the pll loop divider. 0 - Fout=Fref*20; 1 - Fout=Fref*22.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_SYS_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_SYS_DIV_SELECT (0x00000001U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_SYS_DIV_SELECT (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_SYS_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_SYS(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_SYS_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_DIV_SELECT) & BM_CCM_ANALOG_PLL_SYS_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_DIV_SELECT) | BF_CCM_ANALOG_PLL_SYS_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field POWERDOWN[12] (RW)
 *
 * Powers down the PLL.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_POWERDOWN (12U) /*!< Bit position for CCM_ANALOG_PLL_SYS_POWERDOWN. */
#define BM_CCM_ANALOG_PLL_SYS_POWERDOWN (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_POWERDOWN. */
#define BS_CCM_ANALOG_PLL_SYS_POWERDOWN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_POWERDOWN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_POWERDOWN field. */
#define BR_CCM_ANALOG_PLL_SYS_POWERDOWN(x) (HW_CCM_ANALOG_PLL_SYS(x).B.POWERDOWN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_POWERDOWN. */
#define BF_CCM_ANALOG_PLL_SYS_POWERDOWN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_POWERDOWN) & BM_CCM_ANALOG_PLL_SYS_POWERDOWN)

/*! @brief Set the POWERDOWN field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_POWERDOWN(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_POWERDOWN) | BF_CCM_ANALOG_PLL_SYS_POWERDOWN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field ENABLE[13] (RW)
 *
 * Enable PLL output
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_SYS_ENABLE. */
#define BM_CCM_ANALOG_PLL_SYS_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_ENABLE. */
#define BS_CCM_ANALOG_PLL_SYS_ENABLE (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_ENABLE field. */
#define BR_CCM_ANALOG_PLL_SYS_ENABLE(x) (HW_CCM_ANALOG_PLL_SYS(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_ENABLE. */
#define BF_CCM_ANALOG_PLL_SYS_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_ENABLE) & BM_CCM_ANALOG_PLL_SYS_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_ENABLE(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_ENABLE) | BF_CCM_ANALOG_PLL_SYS_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_GPANAIO (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC:  */
#define BV_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC_CHRG_DET_B (0x3U) /*!< Bit field value for CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_SYS(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_SYS_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_SYS_BYPASS. */
#define BM_CCM_ANALOG_PLL_SYS_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_BYPASS. */
#define BS_CCM_ANALOG_PLL_SYS_BYPASS (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_BYPASS field. */
#define BR_CCM_ANALOG_PLL_SYS_BYPASS(x) (HW_CCM_ANALOG_PLL_SYS(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_BYPASS. */
#define BF_CCM_ANALOG_PLL_SYS_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_BYPASS) & BM_CCM_ANALOG_PLL_SYS_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_BYPASS(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_BYPASS) | BF_CCM_ANALOG_PLL_SYS_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field PFD_OFFSET_EN[18] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN (18U) /*!< Bit position for CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN. */
#define BM_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN (0x00040000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN. */
#define BS_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN field. */
#define BR_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN(x) (HW_CCM_ANALOG_PLL_SYS(x).B.PFD_OFFSET_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN. */
#define BF_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN) & BM_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN)

/*! @brief Set the PFD_OFFSET_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN(x, v) (HW_CCM_ANALOG_PLL_SYS_WR(x, (HW_CCM_ANALOG_PLL_SYS_RD(x) & ~BM_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN) | BF_CCM_ANALOG_PLL_SYS_PFD_OFFSET_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_SYS, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked; 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_SYS_LOCK (31U)   /*!< Bit position for CCM_ANALOG_PLL_SYS_LOCK. */
#define BM_CCM_ANALOG_PLL_SYS_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_SYS_LOCK. */
#define BS_CCM_ANALOG_PLL_SYS_LOCK (1U)    /*!< Bit field size in bits for CCM_ANALOG_PLL_SYS_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_SYS_LOCK field. */
#define BR_CCM_ANALOG_PLL_SYS_LOCK(x) (HW_CCM_ANALOG_PLL_SYS(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_AUDIO - Analog Audio PLL control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_AUDIO - Analog Audio PLL control Register (RW)
 *
 * Reset value: 0x00011006U
 *
 * The control register provides control for the audio PLL.
 */
typedef union _hw_ccm_analog_pll_audio
{
    uint32_t U;
    struct _hw_ccm_analog_pll_audio_bitfields
    {
        uint32_t DIV_SELECT : 7;       /*!< [6:0]  */
        uint32_t RESERVED0 : 5;        /*!< [11:7]  */
        uint32_t POWERDOWN : 1;        /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED1 : 1;        /*!< [17]  */
        uint32_t PFD_OFFSET_EN : 1;    /*!< [18]  */
        uint32_t POST_DIV_SELECT : 2;  /*!< [20:19]  */
        uint32_t SSC_EN : 1;           /*!< [21]  */
        uint32_t RESERVED2 : 9;        /*!< [30:22]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_audio_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_AUDIO register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_AUDIO_ADDR(x) ((uintptr_t)(x) + 0x70U)
#define HW_CCM_ANALOG_PLL_AUDIO_SET_ADDR(x) (HW_CCM_ANALOG_PLL_AUDIO_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_AUDIO_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_AUDIO_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_AUDIO_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_AUDIO_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_AUDIO(x) (*(__IO hw_ccm_analog_pll_audio_t *) HW_CCM_ANALOG_PLL_AUDIO_ADDR(x))
#define HW_CCM_ANALOG_PLL_AUDIO_RD(x) (HW_CCM_ANALOG_PLL_AUDIO(x).U)
#define HW_CCM_ANALOG_PLL_AUDIO_WR(x, v) (HW_CCM_ANALOG_PLL_AUDIO(x).U = (v))
#define HW_CCM_ANALOG_PLL_AUDIO_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_AUDIO_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_AUDIO_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_AUDIO_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_AUDIO_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_AUDIO_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_AUDIO bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field DIV_SELECT[6:0] (RW)
 *
 * This field controls the pll loop divider. Valid range for DIV_SELECT divider
 * value: 27~54.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_AUDIO_DIV_SELECT (0x0000007FU) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_AUDIO_DIV_SELECT (7U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_AUDIO_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_AUDIO_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_DIV_SELECT) & BM_CCM_ANALOG_PLL_AUDIO_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_DIV_SELECT) | BF_CCM_ANALOG_PLL_AUDIO_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field POWERDOWN[12] (RW)
 *
 * Powers down the PLL.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_POWERDOWN (12U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_POWERDOWN. */
#define BM_CCM_ANALOG_PLL_AUDIO_POWERDOWN (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_POWERDOWN. */
#define BS_CCM_ANALOG_PLL_AUDIO_POWERDOWN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_POWERDOWN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_POWERDOWN field. */
#define BR_CCM_ANALOG_PLL_AUDIO_POWERDOWN(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.POWERDOWN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_POWERDOWN. */
#define BF_CCM_ANALOG_PLL_AUDIO_POWERDOWN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_POWERDOWN) & BM_CCM_ANALOG_PLL_AUDIO_POWERDOWN)

/*! @brief Set the POWERDOWN field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_POWERDOWN(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_POWERDOWN) | BF_CCM_ANALOG_PLL_AUDIO_POWERDOWN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field ENABLE[13] (RW)
 *
 * Enable PLL output
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_ENABLE. */
#define BM_CCM_ANALOG_PLL_AUDIO_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_ENABLE. */
#define BS_CCM_ANALOG_PLL_AUDIO_ENABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_ENABLE field. */
#define BR_CCM_ANALOG_PLL_AUDIO_ENABLE(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_ENABLE. */
#define BF_CCM_ANALOG_PLL_AUDIO_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_ENABLE) & BM_CCM_ANALOG_PLL_AUDIO_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_ENABLE(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_ENABLE) | BF_CCM_ANALOG_PLL_AUDIO_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC_Reserved (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_AUDIO_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_BYPASS. */
#define BM_CCM_ANALOG_PLL_AUDIO_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_BYPASS. */
#define BS_CCM_ANALOG_PLL_AUDIO_BYPASS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_BYPASS field. */
#define BR_CCM_ANALOG_PLL_AUDIO_BYPASS(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_BYPASS. */
#define BF_CCM_ANALOG_PLL_AUDIO_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_BYPASS) & BM_CCM_ANALOG_PLL_AUDIO_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_BYPASS(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_BYPASS) | BF_CCM_ANALOG_PLL_AUDIO_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field PFD_OFFSET_EN[18] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN (18U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN. */
#define BM_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN (0x00040000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN. */
#define BS_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN field. */
#define BR_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.PFD_OFFSET_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN. */
#define BF_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN) & BM_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN)

/*! @brief Set the PFD_OFFSET_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN) | BF_CCM_ANALOG_PLL_AUDIO_PFD_OFFSET_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field POST_DIV_SELECT[20:19] (RW)
 *
 * These bits implement a divider after the PLL, but before the enable and
 * bypass mux.
 *
 * Values:
 * - 00 - Divide by 4.
 * - 01 - Divide by 2.
 * - 10 - Divide by 1.
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT (19U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT (0x00180000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.POST_DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT) & BM_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT)

/*! @brief Set the POST_DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT) | BF_CCM_ANALOG_PLL_AUDIO_POST_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field SSC_EN[21] (RW)
 *
 * Reserved Bit
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_SSC_EN (21U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_SSC_EN. */
#define BM_CCM_ANALOG_PLL_AUDIO_SSC_EN (0x00200000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_SSC_EN. */
#define BS_CCM_ANALOG_PLL_AUDIO_SSC_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_SSC_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_SSC_EN field. */
#define BR_CCM_ANALOG_PLL_AUDIO_SSC_EN(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.SSC_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_SSC_EN. */
#define BF_CCM_ANALOG_PLL_AUDIO_SSC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_SSC_EN) & BM_CCM_ANALOG_PLL_AUDIO_SSC_EN)

/*! @brief Set the SSC_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_SSC_EN(x, v) (HW_CCM_ANALOG_PLL_AUDIO_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_SSC_EN) | BF_CCM_ANALOG_PLL_AUDIO_SSC_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked. 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_LOCK (31U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_LOCK. */
#define BM_CCM_ANALOG_PLL_AUDIO_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_LOCK. */
#define BS_CCM_ANALOG_PLL_AUDIO_LOCK (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_LOCK field. */
#define BR_CCM_ANALOG_PLL_AUDIO_LOCK(x) (HW_CCM_ANALOG_PLL_AUDIO(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_AUDIO_NUM - Numerator of Audio PLL Fractional Loop Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_AUDIO_NUM - Numerator of Audio PLL Fractional Loop Divider Register (RW)
 *
 * Reset value: 0x05F5E100U
 *
 * This register contains the numerator (A) of Audio PLL fractional loop
 * divider.(Signed number), absolute value should be less than denominator Absolute
 * value should be less than denominator
 */
typedef union _hw_ccm_analog_pll_audio_num
{
    uint32_t U;
    struct _hw_ccm_analog_pll_audio_num_bitfields
    {
        uint32_t A : 30;               /*!< [29:0]  */
        uint32_t RESERVED0 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_analog_pll_audio_num_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_AUDIO_NUM register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_ADDR(x) ((uintptr_t)(x) + 0x80U)

#define HW_CCM_ANALOG_PLL_AUDIO_NUM(x) (*(__IO hw_ccm_analog_pll_audio_num_t *) HW_CCM_ANALOG_PLL_AUDIO_NUM_ADDR(x))
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_RD(x) (HW_CCM_ANALOG_PLL_AUDIO_NUM(x).U)
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_WR(x, v) (HW_CCM_ANALOG_PLL_AUDIO_NUM(x).U = (v))
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_SET(x, v) (HW_CCM_ANALOG_PLL_AUDIO_NUM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_NUM_RD(x) |  (v)))
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_CLR(x, v) (HW_CCM_ANALOG_PLL_AUDIO_NUM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_NUM_RD(x) & ~(v)))
#define HW_CCM_ANALOG_PLL_AUDIO_NUM_TOG(x, v) (HW_CCM_ANALOG_PLL_AUDIO_NUM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_NUM_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_AUDIO_NUM bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO_NUM, field A[29:0] (RW)
 *
 * 30 bit numerator of fractional loop divider.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_NUM_A (0U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_NUM_A. */
#define BM_CCM_ANALOG_PLL_AUDIO_NUM_A (0x3FFFFFFFU) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_NUM_A. */
#define BS_CCM_ANALOG_PLL_AUDIO_NUM_A (30U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_NUM_A. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_NUM_A field. */
#define BR_CCM_ANALOG_PLL_AUDIO_NUM_A(x) (HW_CCM_ANALOG_PLL_AUDIO_NUM(x).B.A)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_NUM_A. */
#define BF_CCM_ANALOG_PLL_AUDIO_NUM_A(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_NUM_A) & BM_CCM_ANALOG_PLL_AUDIO_NUM_A)

/*! @brief Set the A field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_NUM_A(x, v) (HW_CCM_ANALOG_PLL_AUDIO_NUM_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_NUM_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_NUM_A) | BF_CCM_ANALOG_PLL_AUDIO_NUM_A(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_ANALOG_PLL_AUDIO_DENOM - Denominator of Audio PLL Fractional Loop Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_AUDIO_DENOM - Denominator of Audio PLL Fractional Loop Divider Register (RW)
 *
 * Reset value: 0x2964619CU
 *
 * This register contains the Denominator (B) of Audio PLL fractional loop
 * divider.(unsigned number)
 */
typedef union _hw_ccm_analog_pll_audio_denom
{
    uint32_t U;
    struct _hw_ccm_analog_pll_audio_denom_bitfields
    {
        uint32_t B : 30;               /*!< [29:0]  */
        uint32_t RESERVED0 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_analog_pll_audio_denom_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_AUDIO_DENOM register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_ADDR(x) ((uintptr_t)(x) + 0x90U)

#define HW_CCM_ANALOG_PLL_AUDIO_DENOM(x) (*(__IO hw_ccm_analog_pll_audio_denom_t *) HW_CCM_ANALOG_PLL_AUDIO_DENOM_ADDR(x))
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_RD(x) (HW_CCM_ANALOG_PLL_AUDIO_DENOM(x).U)
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_WR(x, v) (HW_CCM_ANALOG_PLL_AUDIO_DENOM(x).U = (v))
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_SET(x, v) (HW_CCM_ANALOG_PLL_AUDIO_DENOM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_DENOM_RD(x) |  (v)))
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_CLR(x, v) (HW_CCM_ANALOG_PLL_AUDIO_DENOM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_DENOM_RD(x) & ~(v)))
#define HW_CCM_ANALOG_PLL_AUDIO_DENOM_TOG(x, v) (HW_CCM_ANALOG_PLL_AUDIO_DENOM_WR(x, HW_CCM_ANALOG_PLL_AUDIO_DENOM_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_AUDIO_DENOM bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_AUDIO_DENOM, field B[29:0] (RW)
 *
 * 30 bit Denominator of fractional loop divider.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_AUDIO_DENOM_B (0U) /*!< Bit position for CCM_ANALOG_PLL_AUDIO_DENOM_B. */
#define BM_CCM_ANALOG_PLL_AUDIO_DENOM_B (0x3FFFFFFFU) /*!< Bit mask for CCM_ANALOG_PLL_AUDIO_DENOM_B. */
#define BS_CCM_ANALOG_PLL_AUDIO_DENOM_B (30U) /*!< Bit field size in bits for CCM_ANALOG_PLL_AUDIO_DENOM_B. */

/*! @brief Read current value of the CCM_ANALOG_PLL_AUDIO_DENOM_B field. */
#define BR_CCM_ANALOG_PLL_AUDIO_DENOM_B(x) (HW_CCM_ANALOG_PLL_AUDIO_DENOM(x).B.B)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_AUDIO_DENOM_B. */
#define BF_CCM_ANALOG_PLL_AUDIO_DENOM_B(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_AUDIO_DENOM_B) & BM_CCM_ANALOG_PLL_AUDIO_DENOM_B)

/*! @brief Set the B field to a new value. */
#define BW_CCM_ANALOG_PLL_AUDIO_DENOM_B(x, v) (HW_CCM_ANALOG_PLL_AUDIO_DENOM_WR(x, (HW_CCM_ANALOG_PLL_AUDIO_DENOM_RD(x) & ~BM_CCM_ANALOG_PLL_AUDIO_DENOM_B) | BF_CCM_ANALOG_PLL_AUDIO_DENOM_B(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_ANALOG_PLL_VIDEO - Analog Video PLL control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_VIDEO - Analog Video PLL control Register (RW)
 *
 * Reset value: 0x0001100CU
 *
 * The control register provides control for the Video PLL.
 */
typedef union _hw_ccm_analog_pll_video
{
    uint32_t U;
    struct _hw_ccm_analog_pll_video_bitfields
    {
        uint32_t DIV_SELECT : 7;       /*!< [6:0]  */
        uint32_t RESERVED0 : 5;        /*!< [11:7]  */
        uint32_t POWERDOWN : 1;        /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED1 : 1;        /*!< [17]  */
        uint32_t PFD_OFFSET_EN : 1;    /*!< [18]  */
        uint32_t POST_DIV_SELECT : 2;  /*!< [20:19]  */
        uint32_t SSC_EN : 1;           /*!< [21]  */
        uint32_t RESERVED2 : 9;        /*!< [30:22]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_video_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_VIDEO register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_VIDEO_ADDR(x) ((uintptr_t)(x) + 0xA0U)
#define HW_CCM_ANALOG_PLL_VIDEO_SET_ADDR(x) (HW_CCM_ANALOG_PLL_VIDEO_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_VIDEO_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_VIDEO_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_VIDEO_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_VIDEO_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_VIDEO(x) (*(__IO hw_ccm_analog_pll_video_t *) HW_CCM_ANALOG_PLL_VIDEO_ADDR(x))
#define HW_CCM_ANALOG_PLL_VIDEO_RD(x) (HW_CCM_ANALOG_PLL_VIDEO(x).U)
#define HW_CCM_ANALOG_PLL_VIDEO_WR(x, v) (HW_CCM_ANALOG_PLL_VIDEO(x).U = (v))
#define HW_CCM_ANALOG_PLL_VIDEO_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_VIDEO_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_VIDEO_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_VIDEO_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_VIDEO_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_VIDEO_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_VIDEO bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field DIV_SELECT[6:0] (RW)
 *
 * This field controls the pll loop divider. Valid range for DIV_SELECT divider
 * value: 27~54.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_VIDEO_DIV_SELECT (0x0000007FU) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_VIDEO_DIV_SELECT (7U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_VIDEO_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_VIDEO_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_DIV_SELECT) & BM_CCM_ANALOG_PLL_VIDEO_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_DIV_SELECT) | BF_CCM_ANALOG_PLL_VIDEO_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field POWERDOWN[12] (RW)
 *
 * Powers down the PLL.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_POWERDOWN (12U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_POWERDOWN. */
#define BM_CCM_ANALOG_PLL_VIDEO_POWERDOWN (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_POWERDOWN. */
#define BS_CCM_ANALOG_PLL_VIDEO_POWERDOWN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_POWERDOWN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_POWERDOWN field. */
#define BR_CCM_ANALOG_PLL_VIDEO_POWERDOWN(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.POWERDOWN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_POWERDOWN. */
#define BF_CCM_ANALOG_PLL_VIDEO_POWERDOWN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_POWERDOWN) & BM_CCM_ANALOG_PLL_VIDEO_POWERDOWN)

/*! @brief Set the POWERDOWN field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_POWERDOWN(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_POWERDOWN) | BF_CCM_ANALOG_PLL_VIDEO_POWERDOWN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field ENABLE[13] (RW)
 *
 * Enalbe PLL output
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_ENABLE. */
#define BM_CCM_ANALOG_PLL_VIDEO_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_ENABLE. */
#define BS_CCM_ANALOG_PLL_VIDEO_ENABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_ENABLE field. */
#define BR_CCM_ANALOG_PLL_VIDEO_ENABLE(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_ENABLE. */
#define BF_CCM_ANALOG_PLL_VIDEO_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_ENABLE) & BM_CCM_ANALOG_PLL_VIDEO_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_ENABLE(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_ENABLE) | BF_CCM_ANALOG_PLL_VIDEO_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC_Reserved (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_VIDEO_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_BYPASS. */
#define BM_CCM_ANALOG_PLL_VIDEO_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_BYPASS. */
#define BS_CCM_ANALOG_PLL_VIDEO_BYPASS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_BYPASS field. */
#define BR_CCM_ANALOG_PLL_VIDEO_BYPASS(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_BYPASS. */
#define BF_CCM_ANALOG_PLL_VIDEO_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_BYPASS) & BM_CCM_ANALOG_PLL_VIDEO_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_BYPASS(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_BYPASS) | BF_CCM_ANALOG_PLL_VIDEO_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field PFD_OFFSET_EN[18] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN (18U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN. */
#define BM_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN (0x00040000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN. */
#define BS_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN field. */
#define BR_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.PFD_OFFSET_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN. */
#define BF_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN) & BM_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN)

/*! @brief Set the PFD_OFFSET_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN) | BF_CCM_ANALOG_PLL_VIDEO_PFD_OFFSET_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field POST_DIV_SELECT[20:19] (RW)
 *
 * These bits implement a divider after the PLL, but before the enable and
 * bypass mux.
 *
 * Values:
 * - 00 - Divide by 4.
 * - 01 - Divide by 2.
 * - 10 - Divide by 1.
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT (19U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT (0x00180000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.POST_DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT) & BM_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT)

/*! @brief Set the POST_DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT) | BF_CCM_ANALOG_PLL_VIDEO_POST_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field SSC_EN[21] (RW)
 *
 * Revserved BIt
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_SSC_EN (21U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_SSC_EN. */
#define BM_CCM_ANALOG_PLL_VIDEO_SSC_EN (0x00200000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_SSC_EN. */
#define BS_CCM_ANALOG_PLL_VIDEO_SSC_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_SSC_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_SSC_EN field. */
#define BR_CCM_ANALOG_PLL_VIDEO_SSC_EN(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.SSC_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_SSC_EN. */
#define BF_CCM_ANALOG_PLL_VIDEO_SSC_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_SSC_EN) & BM_CCM_ANALOG_PLL_VIDEO_SSC_EN)

/*! @brief Set the SSC_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_SSC_EN(x, v) (HW_CCM_ANALOG_PLL_VIDEO_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_SSC_EN) | BF_CCM_ANALOG_PLL_VIDEO_SSC_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked; 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_LOCK (31U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_LOCK. */
#define BM_CCM_ANALOG_PLL_VIDEO_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_LOCK. */
#define BS_CCM_ANALOG_PLL_VIDEO_LOCK (1U)  /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_LOCK field. */
#define BR_CCM_ANALOG_PLL_VIDEO_LOCK(x) (HW_CCM_ANALOG_PLL_VIDEO(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PLL_VIDEO_NUM - Numerator of Video PLL Fractional Loop Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_VIDEO_NUM - Numerator of Video PLL Fractional Loop Divider Register (RW)
 *
 * Reset value: 0x05F5E100U
 *
 * This register contains the numerator (A) of Video PLL fractional loop
 * divider.(Signed number) Absolute value should be less than denominator
 */
typedef union _hw_ccm_analog_pll_video_num
{
    uint32_t U;
    struct _hw_ccm_analog_pll_video_num_bitfields
    {
        uint32_t A : 30;               /*!< [29:0]  */
        uint32_t RESERVED0 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_analog_pll_video_num_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_VIDEO_NUM register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_ADDR(x) ((uintptr_t)(x) + 0xB0U)

#define HW_CCM_ANALOG_PLL_VIDEO_NUM(x) (*(__IO hw_ccm_analog_pll_video_num_t *) HW_CCM_ANALOG_PLL_VIDEO_NUM_ADDR(x))
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_RD(x) (HW_CCM_ANALOG_PLL_VIDEO_NUM(x).U)
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_WR(x, v) (HW_CCM_ANALOG_PLL_VIDEO_NUM(x).U = (v))
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_SET(x, v) (HW_CCM_ANALOG_PLL_VIDEO_NUM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_NUM_RD(x) |  (v)))
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_CLR(x, v) (HW_CCM_ANALOG_PLL_VIDEO_NUM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_NUM_RD(x) & ~(v)))
#define HW_CCM_ANALOG_PLL_VIDEO_NUM_TOG(x, v) (HW_CCM_ANALOG_PLL_VIDEO_NUM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_NUM_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_VIDEO_NUM bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO_NUM, field A[29:0] (RW)
 *
 * 30 bit numerator of fractional loop divider(Signed number), absolute value
 * should be less than denominator
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_NUM_A (0U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_NUM_A. */
#define BM_CCM_ANALOG_PLL_VIDEO_NUM_A (0x3FFFFFFFU) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_NUM_A. */
#define BS_CCM_ANALOG_PLL_VIDEO_NUM_A (30U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_NUM_A. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_NUM_A field. */
#define BR_CCM_ANALOG_PLL_VIDEO_NUM_A(x) (HW_CCM_ANALOG_PLL_VIDEO_NUM(x).B.A)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_NUM_A. */
#define BF_CCM_ANALOG_PLL_VIDEO_NUM_A(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_NUM_A) & BM_CCM_ANALOG_PLL_VIDEO_NUM_A)

/*! @brief Set the A field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_NUM_A(x, v) (HW_CCM_ANALOG_PLL_VIDEO_NUM_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_NUM_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_NUM_A) | BF_CCM_ANALOG_PLL_VIDEO_NUM_A(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_ANALOG_PLL_VIDEO_DENOM - Denominator of Video PLL Fractional Loop Divider Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_VIDEO_DENOM - Denominator of Video PLL Fractional Loop Divider Register (RW)
 *
 * Reset value: 0x10A24447U
 *
 * This register contains the Denominator (B) of Video PLL fractional loop
 * divider.(Unsigned number)
 */
typedef union _hw_ccm_analog_pll_video_denom
{
    uint32_t U;
    struct _hw_ccm_analog_pll_video_denom_bitfields
    {
        uint32_t B : 30;               /*!< [29:0]  */
        uint32_t RESERVED0 : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_analog_pll_video_denom_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_VIDEO_DENOM register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_ADDR(x) ((uintptr_t)(x) + 0xC0U)

#define HW_CCM_ANALOG_PLL_VIDEO_DENOM(x) (*(__IO hw_ccm_analog_pll_video_denom_t *) HW_CCM_ANALOG_PLL_VIDEO_DENOM_ADDR(x))
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_RD(x) (HW_CCM_ANALOG_PLL_VIDEO_DENOM(x).U)
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_WR(x, v) (HW_CCM_ANALOG_PLL_VIDEO_DENOM(x).U = (v))
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_SET(x, v) (HW_CCM_ANALOG_PLL_VIDEO_DENOM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_DENOM_RD(x) |  (v)))
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_CLR(x, v) (HW_CCM_ANALOG_PLL_VIDEO_DENOM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_DENOM_RD(x) & ~(v)))
#define HW_CCM_ANALOG_PLL_VIDEO_DENOM_TOG(x, v) (HW_CCM_ANALOG_PLL_VIDEO_DENOM_WR(x, HW_CCM_ANALOG_PLL_VIDEO_DENOM_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_VIDEO_DENOM bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_VIDEO_DENOM, field B[29:0] (RW)
 *
 * 30 bit Denominator of fractional loop divider.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_VIDEO_DENOM_B (0U) /*!< Bit position for CCM_ANALOG_PLL_VIDEO_DENOM_B. */
#define BM_CCM_ANALOG_PLL_VIDEO_DENOM_B (0x3FFFFFFFU) /*!< Bit mask for CCM_ANALOG_PLL_VIDEO_DENOM_B. */
#define BS_CCM_ANALOG_PLL_VIDEO_DENOM_B (30U) /*!< Bit field size in bits for CCM_ANALOG_PLL_VIDEO_DENOM_B. */

/*! @brief Read current value of the CCM_ANALOG_PLL_VIDEO_DENOM_B field. */
#define BR_CCM_ANALOG_PLL_VIDEO_DENOM_B(x) (HW_CCM_ANALOG_PLL_VIDEO_DENOM(x).B.B)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_VIDEO_DENOM_B. */
#define BF_CCM_ANALOG_PLL_VIDEO_DENOM_B(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_VIDEO_DENOM_B) & BM_CCM_ANALOG_PLL_VIDEO_DENOM_B)

/*! @brief Set the B field to a new value. */
#define BW_CCM_ANALOG_PLL_VIDEO_DENOM_B(x, v) (HW_CCM_ANALOG_PLL_VIDEO_DENOM_WR(x, (HW_CCM_ANALOG_PLL_VIDEO_DENOM_RD(x) & ~BM_CCM_ANALOG_PLL_VIDEO_DENOM_B) | BF_CCM_ANALOG_PLL_VIDEO_DENOM_B(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_ANALOG_PLL_ENET - Analog ENET PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PLL_ENET - Analog ENET PLL Control Register (RW)
 *
 * Reset value: 0x00011001U
 *
 * The control register provides control for the ENET PLL.
 */
typedef union _hw_ccm_analog_pll_enet
{
    uint32_t U;
    struct _hw_ccm_analog_pll_enet_bitfields
    {
        uint32_t DIV_SELECT : 2;       /*!< [1:0]  */
        uint32_t RESERVED0 : 10;       /*!< [11:2]  */
        uint32_t POWERDOWN : 1;        /*!< [12]  */
        uint32_t ENABLE : 1;           /*!< [13]  */
        uint32_t BYPASS_CLK_SRC : 2;   /*!< [15:14]  */
        uint32_t BYPASS : 1;           /*!< [16]  */
        uint32_t RESERVED1 : 1;        /*!< [17]  */
        uint32_t PFD_OFFSET_EN : 1;    /*!< [18]  */
        uint32_t ENABLE_125M : 1;      /*!< [19]  */
        uint32_t ENABLE_100M : 1;      /*!< [20]  */
        uint32_t RESERVED2 : 10;       /*!< [30:21]  */
        uint32_t LOCK : 1;             /*!< [31]  */
    } B;
} hw_ccm_analog_pll_enet_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PLL_ENET register
 */
/*@{*/
#define HW_CCM_ANALOG_PLL_ENET_ADDR(x) ((uintptr_t)(x) + 0xE0U)
#define HW_CCM_ANALOG_PLL_ENET_SET_ADDR(x) (HW_CCM_ANALOG_PLL_ENET_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PLL_ENET_CLR_ADDR(x) (HW_CCM_ANALOG_PLL_ENET_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PLL_ENET_TOG_ADDR(x) (HW_CCM_ANALOG_PLL_ENET_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PLL_ENET(x) (*(__IO hw_ccm_analog_pll_enet_t *) HW_CCM_ANALOG_PLL_ENET_ADDR(x))
#define HW_CCM_ANALOG_PLL_ENET_RD(x) (HW_CCM_ANALOG_PLL_ENET(x).U)
#define HW_CCM_ANALOG_PLL_ENET_WR(x, v) (HW_CCM_ANALOG_PLL_ENET(x).U = (v))
#define HW_CCM_ANALOG_PLL_ENET_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ENET_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_ENET_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ENET_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PLL_ENET_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PLL_ENET_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PLL_ENET bitfields
 */

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field DIV_SELECT[1:0] (RW)
 *
 * Controls the frequency of the ethernet reference clock.00 - 25MHz; 01 -
 * 50MHz; 10 - 100MHz (not 50% duty cycle); 11 - 125MHz;
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_DIV_SELECT (0U) /*!< Bit position for CCM_ANALOG_PLL_ENET_DIV_SELECT. */
#define BM_CCM_ANALOG_PLL_ENET_DIV_SELECT (0x00000003U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_DIV_SELECT. */
#define BS_CCM_ANALOG_PLL_ENET_DIV_SELECT (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_DIV_SELECT. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_DIV_SELECT field. */
#define BR_CCM_ANALOG_PLL_ENET_DIV_SELECT(x) (HW_CCM_ANALOG_PLL_ENET(x).B.DIV_SELECT)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_DIV_SELECT. */
#define BF_CCM_ANALOG_PLL_ENET_DIV_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_DIV_SELECT) & BM_CCM_ANALOG_PLL_ENET_DIV_SELECT)

/*! @brief Set the DIV_SELECT field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_DIV_SELECT(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_DIV_SELECT) | BF_CCM_ANALOG_PLL_ENET_DIV_SELECT(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field POWERDOWN[12] (RW)
 *
 * Powers down the PLL.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_POWERDOWN (12U) /*!< Bit position for CCM_ANALOG_PLL_ENET_POWERDOWN. */
#define BM_CCM_ANALOG_PLL_ENET_POWERDOWN (0x00001000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_POWERDOWN. */
#define BS_CCM_ANALOG_PLL_ENET_POWERDOWN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_POWERDOWN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_POWERDOWN field. */
#define BR_CCM_ANALOG_PLL_ENET_POWERDOWN(x) (HW_CCM_ANALOG_PLL_ENET(x).B.POWERDOWN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_POWERDOWN. */
#define BF_CCM_ANALOG_PLL_ENET_POWERDOWN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_POWERDOWN) & BM_CCM_ANALOG_PLL_ENET_POWERDOWN)

/*! @brief Set the POWERDOWN field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_POWERDOWN(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_POWERDOWN) | BF_CCM_ANALOG_PLL_ENET_POWERDOWN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field ENABLE[13] (RW)
 *
 * Enable the ethernet clock output.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_ENABLE (13U) /*!< Bit position for CCM_ANALOG_PLL_ENET_ENABLE. */
#define BM_CCM_ANALOG_PLL_ENET_ENABLE (0x00002000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_ENABLE. */
#define BS_CCM_ANALOG_PLL_ENET_ENABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_ENABLE. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_ENABLE field. */
#define BR_CCM_ANALOG_PLL_ENET_ENABLE(x) (HW_CCM_ANALOG_PLL_ENET(x).B.ENABLE)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_ENABLE. */
#define BF_CCM_ANALOG_PLL_ENET_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_ENABLE) & BM_CCM_ANALOG_PLL_ENET_ENABLE)

/*! @brief Set the ENABLE field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_ENABLE(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_ENABLE) | BF_CCM_ANALOG_PLL_ENET_ENABLE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field BYPASS_CLK_SRC[15:14] (RW)
 *
 * Determines the bypass source.
 *
 * Values:
 * - 0 - Select the 24MHz oscillator as source.
 * - 1 - Select the CLK1_N / CLK1_P as source.
 * - 10 -
 * - 11 -
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC (14U) /*!< Bit position for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC. */
#define BM_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC (0x0000C000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC. */
#define BS_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC (2U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC. */

#define BV_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_REF_CLK_24M (0U) /*!< Bit field value for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC: Select the 24MHz oscillator as source. */
#define BV_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_CLK1 (0x1U) /*!< Bit field value for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC: Select the CLK1_N / CLK1_P as source. */
#define BV_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC_Reserved (0x2U) /*!< Bit field value for CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC:  */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC field. */
#define BR_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(x) (HW_CCM_ANALOG_PLL_ENET(x).B.BYPASS_CLK_SRC)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC. */
#define BF_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC) & BM_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC)

/*! @brief Set the BYPASS_CLK_SRC field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC) | BF_CCM_ANALOG_PLL_ENET_BYPASS_CLK_SRC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field BYPASS[16] (RW)
 *
 * Bypass the pll.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_BYPASS (16U) /*!< Bit position for CCM_ANALOG_PLL_ENET_BYPASS. */
#define BM_CCM_ANALOG_PLL_ENET_BYPASS (0x00010000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_BYPASS. */
#define BS_CCM_ANALOG_PLL_ENET_BYPASS (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_BYPASS. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_BYPASS field. */
#define BR_CCM_ANALOG_PLL_ENET_BYPASS(x) (HW_CCM_ANALOG_PLL_ENET(x).B.BYPASS)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_BYPASS. */
#define BF_CCM_ANALOG_PLL_ENET_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_BYPASS) & BM_CCM_ANALOG_PLL_ENET_BYPASS)

/*! @brief Set the BYPASS field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_BYPASS(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_BYPASS) | BF_CCM_ANALOG_PLL_ENET_BYPASS(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field PFD_OFFSET_EN[18] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN (18U) /*!< Bit position for CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN. */
#define BM_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN (0x00040000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN. */
#define BS_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN field. */
#define BR_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN(x) (HW_CCM_ANALOG_PLL_ENET(x).B.PFD_OFFSET_EN)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN. */
#define BF_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN) & BM_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN)

/*! @brief Set the PFD_OFFSET_EN field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN) | BF_CCM_ANALOG_PLL_ENET_PFD_OFFSET_EN(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field ENABLE_125M[19] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_ENABLE_125M (19U) /*!< Bit position for CCM_ANALOG_PLL_ENET_ENABLE_125M. */
#define BM_CCM_ANALOG_PLL_ENET_ENABLE_125M (0x00080000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_ENABLE_125M. */
#define BS_CCM_ANALOG_PLL_ENET_ENABLE_125M (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_ENABLE_125M. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_ENABLE_125M field. */
#define BR_CCM_ANALOG_PLL_ENET_ENABLE_125M(x) (HW_CCM_ANALOG_PLL_ENET(x).B.ENABLE_125M)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_ENABLE_125M. */
#define BF_CCM_ANALOG_PLL_ENET_ENABLE_125M(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_ENABLE_125M) & BM_CCM_ANALOG_PLL_ENET_ENABLE_125M)

/*! @brief Set the ENABLE_125M field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_ENABLE_125M(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_ENABLE_125M) | BF_CCM_ANALOG_PLL_ENET_ENABLE_125M(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field ENABLE_100M[20] (RW)
 *
 * Enables an offset in the phase frequency detector.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_ENABLE_100M (20U) /*!< Bit position for CCM_ANALOG_PLL_ENET_ENABLE_100M. */
#define BM_CCM_ANALOG_PLL_ENET_ENABLE_100M (0x00100000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_ENABLE_100M. */
#define BS_CCM_ANALOG_PLL_ENET_ENABLE_100M (1U) /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_ENABLE_100M. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_ENABLE_100M field. */
#define BR_CCM_ANALOG_PLL_ENET_ENABLE_100M(x) (HW_CCM_ANALOG_PLL_ENET(x).B.ENABLE_100M)

/*! @brief Format value for bitfield CCM_ANALOG_PLL_ENET_ENABLE_100M. */
#define BF_CCM_ANALOG_PLL_ENET_ENABLE_100M(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PLL_ENET_ENABLE_100M) & BM_CCM_ANALOG_PLL_ENET_ENABLE_100M)

/*! @brief Set the ENABLE_100M field to a new value. */
#define BW_CCM_ANALOG_PLL_ENET_ENABLE_100M(x, v) (HW_CCM_ANALOG_PLL_ENET_WR(x, (HW_CCM_ANALOG_PLL_ENET_RD(x) & ~BM_CCM_ANALOG_PLL_ENET_ENABLE_100M) | BF_CCM_ANALOG_PLL_ENET_ENABLE_100M(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PLL_ENET, field LOCK[31] (RO)
 *
 * 1 - PLL is currently locked; 0 - PLL is not currently locked.
 */
/*@{*/
#define BP_CCM_ANALOG_PLL_ENET_LOCK (31U)  /*!< Bit position for CCM_ANALOG_PLL_ENET_LOCK. */
#define BM_CCM_ANALOG_PLL_ENET_LOCK (0x80000000U) /*!< Bit mask for CCM_ANALOG_PLL_ENET_LOCK. */
#define BS_CCM_ANALOG_PLL_ENET_LOCK (1U)   /*!< Bit field size in bits for CCM_ANALOG_PLL_ENET_LOCK. */

/*! @brief Read current value of the CCM_ANALOG_PLL_ENET_LOCK field. */
#define BR_CCM_ANALOG_PLL_ENET_LOCK(x) (HW_CCM_ANALOG_PLL_ENET(x).B.LOCK)
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PFD_480 - 480MHz Clock (from PLL_USB2) Phase Fractional Divider Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PFD_480 - 480MHz Clock (from PLL_USB2) Phase Fractional Divider Control Register (RW)
 *
 * Reset value: 0x1311100CU
 *
 * The PFD_480 control register provides control for PFD clock generation. This
 * register controls the 4-phase fractional clock dividers. The fractional clock
 * frequencies are a product of the values in these registers.
 */
typedef union _hw_ccm_analog_pfd_480
{
    uint32_t U;
    struct _hw_ccm_analog_pfd_480_bitfields
    {
        uint32_t PFD0_FRAC : 6;        /*!< [5:0]  */
        uint32_t PFD0_STABLE : 1;      /*!< [6]  */
        uint32_t PFD0_CLKGATE : 1;     /*!< [7]  */
        uint32_t PFD1_FRAC : 6;        /*!< [13:8]  */
        uint32_t PFD1_STABLE : 1;      /*!< [14]  */
        uint32_t PFD1_CLKGATE : 1;     /*!< [15]  */
        uint32_t PFD2_FRAC : 6;        /*!< [21:16]  */
        uint32_t PFD2_STABLE : 1;      /*!< [22]  */
        uint32_t PFD2_CLKGATE : 1;     /*!< [23]  */
        uint32_t PFD3_FRAC : 6;        /*!< [29:24]  */
        uint32_t PFD3_STABLE : 1;      /*!< [30]  */
        uint32_t PFD3_CLKGATE : 1;     /*!< [31]  */
    } B;
} hw_ccm_analog_pfd_480_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PFD_480 register
 */
/*@{*/
#define HW_CCM_ANALOG_PFD_480_ADDR(x) ((uintptr_t)(x) + 0xF0U)
#define HW_CCM_ANALOG_PFD_480_SET_ADDR(x) (HW_CCM_ANALOG_PFD_480_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PFD_480_CLR_ADDR(x) (HW_CCM_ANALOG_PFD_480_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PFD_480_TOG_ADDR(x) (HW_CCM_ANALOG_PFD_480_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PFD_480(x) (*(__IO hw_ccm_analog_pfd_480_t *) HW_CCM_ANALOG_PFD_480_ADDR(x))
#define HW_CCM_ANALOG_PFD_480_RD(x) (HW_CCM_ANALOG_PFD_480(x).U)
#define HW_CCM_ANALOG_PFD_480_WR(x, v) (HW_CCM_ANALOG_PFD_480(x).U = (v))
#define HW_CCM_ANALOG_PFD_480_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_480_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PFD_480_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_480_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PFD_480_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_480_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PFD_480 bitfields
 */

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD0_FRAC[5:0] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 480*18/PFD0_FRAC where PFD0_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD0_FRAC (0U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD0_FRAC. */
#define BM_CCM_ANALOG_PFD_480_PFD0_FRAC (0x0000003FU) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD0_FRAC. */
#define BS_CCM_ANALOG_PFD_480_PFD0_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD0_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD0_FRAC field. */
#define BR_CCM_ANALOG_PFD_480_PFD0_FRAC(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD0_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD0_FRAC. */
#define BF_CCM_ANALOG_PFD_480_PFD0_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD0_FRAC) & BM_CCM_ANALOG_PFD_480_PFD0_FRAC)

/*! @brief Set the PFD0_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD0_FRAC(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD0_FRAC) | BF_CCM_ANALOG_PFD_480_PFD0_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD0_STABLE[6] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD0_STABLE (6U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD0_STABLE. */
#define BM_CCM_ANALOG_PFD_480_PFD0_STABLE (0x00000040U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD0_STABLE. */
#define BS_CCM_ANALOG_PFD_480_PFD0_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD0_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD0_STABLE field. */
#define BR_CCM_ANALOG_PFD_480_PFD0_STABLE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD0_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD0_CLKGATE[7] (RW)
 *
 * If set to 1, the IO fractional divider clock (reference ref_pfd0) is off
 * (power savings). 0: ref_pfd0 fractional divider clock is enabled. Need to assert
 * this bit before PLL is powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD0_CLKGATE (7U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD0_CLKGATE. */
#define BM_CCM_ANALOG_PFD_480_PFD0_CLKGATE (0x00000080U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD0_CLKGATE. */
#define BS_CCM_ANALOG_PFD_480_PFD0_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD0_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD0_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_480_PFD0_CLKGATE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD0_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD0_CLKGATE. */
#define BF_CCM_ANALOG_PFD_480_PFD0_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD0_CLKGATE) & BM_CCM_ANALOG_PFD_480_PFD0_CLKGATE)

/*! @brief Set the PFD0_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD0_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD0_CLKGATE) | BF_CCM_ANALOG_PFD_480_PFD0_CLKGATE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD1_FRAC[13:8] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 480*18/PFD1_FRAC where PFD1_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD1_FRAC (8U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD1_FRAC. */
#define BM_CCM_ANALOG_PFD_480_PFD1_FRAC (0x00003F00U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD1_FRAC. */
#define BS_CCM_ANALOG_PFD_480_PFD1_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD1_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD1_FRAC field. */
#define BR_CCM_ANALOG_PFD_480_PFD1_FRAC(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD1_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD1_FRAC. */
#define BF_CCM_ANALOG_PFD_480_PFD1_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD1_FRAC) & BM_CCM_ANALOG_PFD_480_PFD1_FRAC)

/*! @brief Set the PFD1_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD1_FRAC(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD1_FRAC) | BF_CCM_ANALOG_PFD_480_PFD1_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD1_STABLE[14] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD1_STABLE (14U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD1_STABLE. */
#define BM_CCM_ANALOG_PFD_480_PFD1_STABLE (0x00004000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD1_STABLE. */
#define BS_CCM_ANALOG_PFD_480_PFD1_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD1_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD1_STABLE field. */
#define BR_CCM_ANALOG_PFD_480_PFD1_STABLE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD1_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD1_CLKGATE[15] (RW)
 *
 * IO Clock Gate. If set to 1, the IO fractional divider clock (reference
 * ref_pfd1) is off (power savings). 0: ref_pfd1 fractional divider clock is enabled.
 * Need to assert this bit before PLL is powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD1_CLKGATE (15U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD1_CLKGATE. */
#define BM_CCM_ANALOG_PFD_480_PFD1_CLKGATE (0x00008000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD1_CLKGATE. */
#define BS_CCM_ANALOG_PFD_480_PFD1_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD1_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD1_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_480_PFD1_CLKGATE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD1_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD1_CLKGATE. */
#define BF_CCM_ANALOG_PFD_480_PFD1_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD1_CLKGATE) & BM_CCM_ANALOG_PFD_480_PFD1_CLKGATE)

/*! @brief Set the PFD1_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD1_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD1_CLKGATE) | BF_CCM_ANALOG_PFD_480_PFD1_CLKGATE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD2_FRAC[21:16] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 480*18/PFD2_FRAC where PFD2_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD2_FRAC (16U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD2_FRAC. */
#define BM_CCM_ANALOG_PFD_480_PFD2_FRAC (0x003F0000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD2_FRAC. */
#define BS_CCM_ANALOG_PFD_480_PFD2_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD2_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD2_FRAC field. */
#define BR_CCM_ANALOG_PFD_480_PFD2_FRAC(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD2_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD2_FRAC. */
#define BF_CCM_ANALOG_PFD_480_PFD2_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD2_FRAC) & BM_CCM_ANALOG_PFD_480_PFD2_FRAC)

/*! @brief Set the PFD2_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD2_FRAC(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD2_FRAC) | BF_CCM_ANALOG_PFD_480_PFD2_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD2_STABLE[22] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD2_STABLE (22U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD2_STABLE. */
#define BM_CCM_ANALOG_PFD_480_PFD2_STABLE (0x00400000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD2_STABLE. */
#define BS_CCM_ANALOG_PFD_480_PFD2_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD2_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD2_STABLE field. */
#define BR_CCM_ANALOG_PFD_480_PFD2_STABLE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD2_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD2_CLKGATE[23] (RW)
 *
 * IO Clock Gate. If set to 1, the IO fractional divider clock (reference
 * ref_pfd2) is off (power savings). 0: ref_pfd2 fractional divider clock is enabled.
 * Need to assert this bit before PLL is powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD2_CLKGATE (23U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD2_CLKGATE. */
#define BM_CCM_ANALOG_PFD_480_PFD2_CLKGATE (0x00800000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD2_CLKGATE. */
#define BS_CCM_ANALOG_PFD_480_PFD2_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD2_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD2_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_480_PFD2_CLKGATE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD2_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD2_CLKGATE. */
#define BF_CCM_ANALOG_PFD_480_PFD2_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD2_CLKGATE) & BM_CCM_ANALOG_PFD_480_PFD2_CLKGATE)

/*! @brief Set the PFD2_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD2_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD2_CLKGATE) | BF_CCM_ANALOG_PFD_480_PFD2_CLKGATE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD3_FRAC[29:24] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 480*18/PFD3_FRAC where PFD3_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD3_FRAC (24U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD3_FRAC. */
#define BM_CCM_ANALOG_PFD_480_PFD3_FRAC (0x3F000000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD3_FRAC. */
#define BS_CCM_ANALOG_PFD_480_PFD3_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD3_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD3_FRAC field. */
#define BR_CCM_ANALOG_PFD_480_PFD3_FRAC(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD3_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD3_FRAC. */
#define BF_CCM_ANALOG_PFD_480_PFD3_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD3_FRAC) & BM_CCM_ANALOG_PFD_480_PFD3_FRAC)

/*! @brief Set the PFD3_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD3_FRAC(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD3_FRAC) | BF_CCM_ANALOG_PFD_480_PFD3_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD3_STABLE[30] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD3_STABLE (30U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD3_STABLE. */
#define BM_CCM_ANALOG_PFD_480_PFD3_STABLE (0x40000000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD3_STABLE. */
#define BS_CCM_ANALOG_PFD_480_PFD3_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD3_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD3_STABLE field. */
#define BR_CCM_ANALOG_PFD_480_PFD3_STABLE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD3_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_480, field PFD3_CLKGATE[31] (RW)
 *
 * IO Clock Gate. If set to 1, the 3rd fractional divider clock (reference
 * ref_pfd3) is off (power savings). 0: ref_pfd3 fractional divider clock is enabled.
 * Need to assert this bit before PLL is powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_480_PFD3_CLKGATE (31U) /*!< Bit position for CCM_ANALOG_PFD_480_PFD3_CLKGATE. */
#define BM_CCM_ANALOG_PFD_480_PFD3_CLKGATE (0x80000000U) /*!< Bit mask for CCM_ANALOG_PFD_480_PFD3_CLKGATE. */
#define BS_CCM_ANALOG_PFD_480_PFD3_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_480_PFD3_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_480_PFD3_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_480_PFD3_CLKGATE(x) (HW_CCM_ANALOG_PFD_480(x).B.PFD3_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_480_PFD3_CLKGATE. */
#define BF_CCM_ANALOG_PFD_480_PFD3_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_480_PFD3_CLKGATE) & BM_CCM_ANALOG_PFD_480_PFD3_CLKGATE)

/*! @brief Set the PFD3_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_480_PFD3_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_480_WR(x, (HW_CCM_ANALOG_PFD_480_RD(x) & ~BM_CCM_ANALOG_PFD_480_PFD3_CLKGATE) | BF_CCM_ANALOG_PFD_480_PFD3_CLKGATE(v)))
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_PFD_528 - 528MHz Clock (From PLL_SYS) Phase Fractional Divider Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_PFD_528 - 528MHz Clock (From PLL_SYS) Phase Fractional Divider Control Register (RW)
 *
 * Reset value: 0x1018101BU
 *
 * The PFD_528 control register provides control for PFD clock generation. This
 * register controls the 3-phase fractional clock dividers. The fractional clock
 * frequencies are a product of the values in these registers.
 */
typedef union _hw_ccm_analog_pfd_528
{
    uint32_t U;
    struct _hw_ccm_analog_pfd_528_bitfields
    {
        uint32_t PFD0_FRAC : 6;        /*!< [5:0]  */
        uint32_t PFD0_STABLE : 1;      /*!< [6]  */
        uint32_t PFD0_CLKGATE : 1;     /*!< [7]  */
        uint32_t PFD1_FRAC : 6;        /*!< [13:8]  */
        uint32_t PFD1_STABLE : 1;      /*!< [14]  */
        uint32_t PFD1_CLKGATE : 1;     /*!< [15]  */
        uint32_t PFD2_FRAC : 6;        /*!< [21:16]  */
        uint32_t PFD2_STABLE : 1;      /*!< [22]  */
        uint32_t PFD2_CLKGATE : 1;     /*!< [23]  */
        uint32_t RESERVED0 : 8;        /*!< [31:24]  */
    } B;
} hw_ccm_analog_pfd_528_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_PFD_528 register
 */
/*@{*/
#define HW_CCM_ANALOG_PFD_528_ADDR(x) ((uintptr_t)(x) + 0x100U)
#define HW_CCM_ANALOG_PFD_528_SET_ADDR(x) (HW_CCM_ANALOG_PFD_528_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_PFD_528_CLR_ADDR(x) (HW_CCM_ANALOG_PFD_528_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_PFD_528_TOG_ADDR(x) (HW_CCM_ANALOG_PFD_528_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_PFD_528(x) (*(__IO hw_ccm_analog_pfd_528_t *) HW_CCM_ANALOG_PFD_528_ADDR(x))
#define HW_CCM_ANALOG_PFD_528_RD(x) (HW_CCM_ANALOG_PFD_528(x).U)
#define HW_CCM_ANALOG_PFD_528_WR(x, v) (HW_CCM_ANALOG_PFD_528(x).U = (v))
#define HW_CCM_ANALOG_PFD_528_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_528_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PFD_528_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_528_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_PFD_528_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_PFD_528_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_PFD_528 bitfields
 */

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD0_FRAC[5:0] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 528*18/PFD0_FRAC where PFD0_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD0_FRAC (0U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD0_FRAC. */
#define BM_CCM_ANALOG_PFD_528_PFD0_FRAC (0x0000003FU) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD0_FRAC. */
#define BS_CCM_ANALOG_PFD_528_PFD0_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD0_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD0_FRAC field. */
#define BR_CCM_ANALOG_PFD_528_PFD0_FRAC(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD0_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD0_FRAC. */
#define BF_CCM_ANALOG_PFD_528_PFD0_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD0_FRAC) & BM_CCM_ANALOG_PFD_528_PFD0_FRAC)

/*! @brief Set the PFD0_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD0_FRAC(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD0_FRAC) | BF_CCM_ANALOG_PFD_528_PFD0_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD0_STABLE[6] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD0_STABLE (6U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD0_STABLE. */
#define BM_CCM_ANALOG_PFD_528_PFD0_STABLE (0x00000040U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD0_STABLE. */
#define BS_CCM_ANALOG_PFD_528_PFD0_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD0_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD0_STABLE field. */
#define BR_CCM_ANALOG_PFD_528_PFD0_STABLE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD0_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD0_CLKGATE[7] (RW)
 *
 * If set to 1, the IO fractional divider clock (reference ref_pfd0) is off
 * (power savings). 0: ref_pfd0 fractional divider clock is enabled. Need to assert
 * this bit before PLL powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD0_CLKGATE (7U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD0_CLKGATE. */
#define BM_CCM_ANALOG_PFD_528_PFD0_CLKGATE (0x00000080U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD0_CLKGATE. */
#define BS_CCM_ANALOG_PFD_528_PFD0_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD0_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD0_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_528_PFD0_CLKGATE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD0_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD0_CLKGATE. */
#define BF_CCM_ANALOG_PFD_528_PFD0_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD0_CLKGATE) & BM_CCM_ANALOG_PFD_528_PFD0_CLKGATE)

/*! @brief Set the PFD0_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD0_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD0_CLKGATE) | BF_CCM_ANALOG_PFD_528_PFD0_CLKGATE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD1_FRAC[13:8] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 528*18/PFD1_FRAC where PFD1_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD1_FRAC (8U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD1_FRAC. */
#define BM_CCM_ANALOG_PFD_528_PFD1_FRAC (0x00003F00U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD1_FRAC. */
#define BS_CCM_ANALOG_PFD_528_PFD1_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD1_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD1_FRAC field. */
#define BR_CCM_ANALOG_PFD_528_PFD1_FRAC(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD1_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD1_FRAC. */
#define BF_CCM_ANALOG_PFD_528_PFD1_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD1_FRAC) & BM_CCM_ANALOG_PFD_528_PFD1_FRAC)

/*! @brief Set the PFD1_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD1_FRAC(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD1_FRAC) | BF_CCM_ANALOG_PFD_528_PFD1_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD1_STABLE[14] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD1_STABLE (14U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD1_STABLE. */
#define BM_CCM_ANALOG_PFD_528_PFD1_STABLE (0x00004000U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD1_STABLE. */
#define BS_CCM_ANALOG_PFD_528_PFD1_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD1_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD1_STABLE field. */
#define BR_CCM_ANALOG_PFD_528_PFD1_STABLE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD1_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD1_CLKGATE[15] (RW)
 *
 * IO Clock Gate. If set to 1, the IO fractional divider clock (reference
 * ref_pfd1) is off (power savings). 0: ref_pfd1 fractional divider clock is enabled.
 * Need to assert this bit before PLL powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD1_CLKGATE (15U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD1_CLKGATE. */
#define BM_CCM_ANALOG_PFD_528_PFD1_CLKGATE (0x00008000U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD1_CLKGATE. */
#define BS_CCM_ANALOG_PFD_528_PFD1_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD1_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD1_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_528_PFD1_CLKGATE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD1_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD1_CLKGATE. */
#define BF_CCM_ANALOG_PFD_528_PFD1_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD1_CLKGATE) & BM_CCM_ANALOG_PFD_528_PFD1_CLKGATE)

/*! @brief Set the PFD1_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD1_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD1_CLKGATE) | BF_CCM_ANALOG_PFD_528_PFD1_CLKGATE(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD2_FRAC[21:16] (RW)
 *
 * This field controls the fractional divide value. The resulting frequency
 * shall be 528*18/PFD2_FRAC where PFD2_FRAC is in the range 12-35.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD2_FRAC (16U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD2_FRAC. */
#define BM_CCM_ANALOG_PFD_528_PFD2_FRAC (0x003F0000U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD2_FRAC. */
#define BS_CCM_ANALOG_PFD_528_PFD2_FRAC (6U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD2_FRAC. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD2_FRAC field. */
#define BR_CCM_ANALOG_PFD_528_PFD2_FRAC(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD2_FRAC)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD2_FRAC. */
#define BF_CCM_ANALOG_PFD_528_PFD2_FRAC(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD2_FRAC) & BM_CCM_ANALOG_PFD_528_PFD2_FRAC)

/*! @brief Set the PFD2_FRAC field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD2_FRAC(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD2_FRAC) | BF_CCM_ANALOG_PFD_528_PFD2_FRAC(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD2_STABLE[22] (RO)
 *
 * This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the fractional
 * divider should become stable quickly enough that this field will never need to
 * be used by either device driver or application code. The value inverts when
 * the new programmed fractional divide value has taken effect. Read this bit,
 * program the new value, and when this bit inverts, the phase divider clock output
 * is stable. Note that the value will not invert when the fractional divider is
 * taken out of or placed into clock-gated state.
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD2_STABLE (22U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD2_STABLE. */
#define BM_CCM_ANALOG_PFD_528_PFD2_STABLE (0x00400000U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD2_STABLE. */
#define BS_CCM_ANALOG_PFD_528_PFD2_STABLE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD2_STABLE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD2_STABLE field. */
#define BR_CCM_ANALOG_PFD_528_PFD2_STABLE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD2_STABLE)
/*@}*/

/*!
 * @name Register CCM_ANALOG_PFD_528, field PFD2_CLKGATE[23] (RW)
 *
 * IO Clock Gate. If set to 1, the IO fractional divider clock (reference
 * ref_pfd2) is off (power savings). 0: ref_pfd2 fractional divider clock is enabled.
 * Need to assert this bit before PLL powered down
 */
/*@{*/
#define BP_CCM_ANALOG_PFD_528_PFD2_CLKGATE (23U) /*!< Bit position for CCM_ANALOG_PFD_528_PFD2_CLKGATE. */
#define BM_CCM_ANALOG_PFD_528_PFD2_CLKGATE (0x00800000U) /*!< Bit mask for CCM_ANALOG_PFD_528_PFD2_CLKGATE. */
#define BS_CCM_ANALOG_PFD_528_PFD2_CLKGATE (1U) /*!< Bit field size in bits for CCM_ANALOG_PFD_528_PFD2_CLKGATE. */

/*! @brief Read current value of the CCM_ANALOG_PFD_528_PFD2_CLKGATE field. */
#define BR_CCM_ANALOG_PFD_528_PFD2_CLKGATE(x) (HW_CCM_ANALOG_PFD_528(x).B.PFD2_CLKGATE)

/*! @brief Format value for bitfield CCM_ANALOG_PFD_528_PFD2_CLKGATE. */
#define BF_CCM_ANALOG_PFD_528_PFD2_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_PFD_528_PFD2_CLKGATE) & BM_CCM_ANALOG_PFD_528_PFD2_CLKGATE)

/*! @brief Set the PFD2_CLKGATE field to a new value. */
#define BW_CCM_ANALOG_PFD_528_PFD2_CLKGATE(x, v) (HW_CCM_ANALOG_PFD_528_WR(x, (HW_CCM_ANALOG_PFD_528_RD(x) & ~BM_CCM_ANALOG_PFD_528_PFD2_CLKGATE) | BF_CCM_ANALOG_PFD_528_PFD2_CLKGATE(v)))
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_MISC0 - Miscellaneous Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_MISC0 - Miscellaneous Control Register (RW)
 *
 * Reset value: 0x02000000U
 *
 * This register defines the control for miscellaneous CCM Analog blocks.
 */
typedef union _hw_ccm_analog_misc0
{
    uint32_t U;
    struct _hw_ccm_analog_misc0_bitfields
    {
        uint32_t RESERVED0 : 11;       /*!< [10:0]  */
        uint32_t STOP_MODE_CONFIG : 2; /*!< [12:11]  */
        uint32_t RESERVED1 : 19;       /*!< [31:13]  */
    } B;
} hw_ccm_analog_misc0_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_MISC0 register
 */
/*@{*/
#define HW_CCM_ANALOG_MISC0_ADDR(x) ((uintptr_t)(x) + 0x150U)
#define HW_CCM_ANALOG_MISC0_SET_ADDR(x) (HW_CCM_ANALOG_MISC0_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_MISC0_CLR_ADDR(x) (HW_CCM_ANALOG_MISC0_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_MISC0_TOG_ADDR(x) (HW_CCM_ANALOG_MISC0_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_MISC0(x)   (*(__IO hw_ccm_analog_misc0_t *) HW_CCM_ANALOG_MISC0_ADDR(x))
#define HW_CCM_ANALOG_MISC0_RD(x) (HW_CCM_ANALOG_MISC0(x).U)
#define HW_CCM_ANALOG_MISC0_WR(x, v) (HW_CCM_ANALOG_MISC0(x).U = (v))
#define HW_CCM_ANALOG_MISC0_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC0_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_MISC0_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC0_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_MISC0_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_MISC0 bitfields
 */

/*!
 * @name Register CCM_ANALOG_MISC0, field STOP_MODE_CONFIG[12:11] (RW)
 *
 * Configure the analog behavior in stop mode.
 *
 * Values:
 * - 00 - All the analog domain except the RTC is powered down on STOP mode
 *     assertion
 * - 01 - All the analog domain except the LDO_1P1 and LDO_2P5 regulators are
 *     powered down on STOP mode assertion. If required the CCM can be configured
 *     to not power down the oscillator (XTALOSC)
 * - 10 - Reserved
 * - 11 - Reserved
 */
/*@{*/
#define BP_CCM_ANALOG_MISC0_STOP_MODE_CONFIG (11U) /*!< Bit position for CCM_ANALOG_MISC0_STOP_MODE_CONFIG. */
#define BM_CCM_ANALOG_MISC0_STOP_MODE_CONFIG (0x00001800U) /*!< Bit mask for CCM_ANALOG_MISC0_STOP_MODE_CONFIG. */
#define BS_CCM_ANALOG_MISC0_STOP_MODE_CONFIG (2U) /*!< Bit field size in bits for CCM_ANALOG_MISC0_STOP_MODE_CONFIG. */

/*! @brief Read current value of the CCM_ANALOG_MISC0_STOP_MODE_CONFIG field. */
#define BR_CCM_ANALOG_MISC0_STOP_MODE_CONFIG(x) (HW_CCM_ANALOG_MISC0(x).B.STOP_MODE_CONFIG)

/*! @brief Format value for bitfield CCM_ANALOG_MISC0_STOP_MODE_CONFIG. */
#define BF_CCM_ANALOG_MISC0_STOP_MODE_CONFIG(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC0_STOP_MODE_CONFIG) & BM_CCM_ANALOG_MISC0_STOP_MODE_CONFIG)

/*! @brief Set the STOP_MODE_CONFIG field to a new value. */
#define BW_CCM_ANALOG_MISC0_STOP_MODE_CONFIG(x, v) (HW_CCM_ANALOG_MISC0_WR(x, (HW_CCM_ANALOG_MISC0_RD(x) & ~BM_CCM_ANALOG_MISC0_STOP_MODE_CONFIG) | BF_CCM_ANALOG_MISC0_STOP_MODE_CONFIG(v)))
/*@}*/




/*******************************************************************************
 * HW_CCM_ANALOG_MISC2 - Miscellaneous Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_ANALOG_MISC2 - Miscellaneous Control Register (RW)
 *
 * Reset value: 0x00272727U
 *
 * This register defines the control for miscellaneous CCM Analog blocks. This
 * register is shared with PMU.
 */
typedef union _hw_ccm_analog_misc2
{
    uint32_t U;
    struct _hw_ccm_analog_misc2_bitfields
    {
        uint32_t REG0_BO_OFFSET : 3;   /*!< [2:0]  */
        uint32_t REG0_BO_STATUS : 1;   /*!< [3]  */
        uint32_t RESERVED0 : 1;        /*!< [4]  */
        uint32_t REG0_ENABLE_BO : 1;   /*!< [5]  */
        uint32_t RESERVED1 : 1;        /*!< [6]  */
        uint32_t PLL3_disable : 1;     /*!< [7]  */
        uint32_t REG1_BO_OFFSET : 3;   /*!< [10:8]  */
        uint32_t REG1_BO_STATUS : 1;   /*!< [11]  */
        uint32_t RESERVED2 : 1;        /*!< [12]  */
        uint32_t REG1_ENABLE_BO : 1;   /*!< [13]  */
        uint32_t RESERVED3 : 1;        /*!< [14]  */
        uint32_t AUDIO_DIV_LSB : 1;    /*!< [15]  */
        uint32_t REG2_BO_OFFSET : 3;   /*!< [18:16]  */
        uint32_t REG2_BO_STATUS : 1;   /*!< [19]  */
        uint32_t RESERVED4 : 1;        /*!< [20]  */
        uint32_t REG2_ENABLE_BO : 1;   /*!< [21]  */
        uint32_t REG2_OK : 1;          /*!< [22]  */
        uint32_t AUDIO_DIV_MSB : 1;    /*!< [23]  */
        uint32_t REG0_STEP_TIME : 2;   /*!< [25:24]  */
        uint32_t REG1_STEP_TIME : 2;   /*!< [27:26]  */
        uint32_t REG2_STEP_TIME : 2;   /*!< [29:28]  */
        uint32_t VIDEO_DIV : 2;        /*!< [31:30]  */
    } B;
} hw_ccm_analog_misc2_t;

/*!
 * @name Constants and macros for entire CCM_ANALOG_MISC2 register
 */
/*@{*/
#define HW_CCM_ANALOG_MISC2_ADDR(x) ((uintptr_t)(x) + 0x170U)
#define HW_CCM_ANALOG_MISC2_SET_ADDR(x) (HW_CCM_ANALOG_MISC2_ADDR(x) + 0x4U)
#define HW_CCM_ANALOG_MISC2_CLR_ADDR(x) (HW_CCM_ANALOG_MISC2_ADDR(x) + 0x8U)
#define HW_CCM_ANALOG_MISC2_TOG_ADDR(x) (HW_CCM_ANALOG_MISC2_ADDR(x) + 0xCU)

#define HW_CCM_ANALOG_MISC2(x)   (*(__IO hw_ccm_analog_misc2_t *) HW_CCM_ANALOG_MISC2_ADDR(x))
#define HW_CCM_ANALOG_MISC2_RD(x) (HW_CCM_ANALOG_MISC2(x).U)
#define HW_CCM_ANALOG_MISC2_WR(x, v) (HW_CCM_ANALOG_MISC2(x).U = (v))
#define HW_CCM_ANALOG_MISC2_SET(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC2_SET_ADDR(x)) = (v))
#define HW_CCM_ANALOG_MISC2_CLR(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC2_CLR_ADDR(x)) = (v))
#define HW_CCM_ANALOG_MISC2_TOG(x, v) ((*(uint32_t *) HW_CCM_ANALOG_MISC2_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_ANALOG_MISC2 bitfields
 */

/*!
 * @name Register CCM_ANALOG_MISC2, field REG0_BO_OFFSET[2:0] (RO)
 *
 * This field defines the brown out voltage offset for the CORE power domain.
 * IRQ_DIG_BO is also asserted. Single-bit increments reflect 25mV brownout voltage
 * steps. Some steps may be irrelevant because of input supply limitations or
 * load operation. Not related to CCM. See Power Management Unit (PMU) for more
 * information.
 *
 * Values:
 * - 100 - Brownout offset = 0.100V
 * - 111 - Brownout offset = 0.175V
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG0_BO_OFFSET (0U) /*!< Bit position for CCM_ANALOG_MISC2_REG0_BO_OFFSET. */
#define BM_CCM_ANALOG_MISC2_REG0_BO_OFFSET (0x00000007U) /*!< Bit mask for CCM_ANALOG_MISC2_REG0_BO_OFFSET. */
#define BS_CCM_ANALOG_MISC2_REG0_BO_OFFSET (3U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG0_BO_OFFSET. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG0_BO_OFFSET field. */
#define BR_CCM_ANALOG_MISC2_REG0_BO_OFFSET(x) (HW_CCM_ANALOG_MISC2(x).B.REG0_BO_OFFSET)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG0_BO_STATUS[3] (RO)
 *
 * Reg0 brownout status bit. Not related to CCM. See Power Management Unit (PMU)
 * for more information.
 *
 * Values:
 * - 1 - Brownout, supply is below target minus brownout offset.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG0_BO_STATUS (3U) /*!< Bit position for CCM_ANALOG_MISC2_REG0_BO_STATUS. */
#define BM_CCM_ANALOG_MISC2_REG0_BO_STATUS (0x00000008U) /*!< Bit mask for CCM_ANALOG_MISC2_REG0_BO_STATUS. */
#define BS_CCM_ANALOG_MISC2_REG0_BO_STATUS (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG0_BO_STATUS. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG0_BO_STATUS field. */
#define BR_CCM_ANALOG_MISC2_REG0_BO_STATUS(x) (HW_CCM_ANALOG_MISC2(x).B.REG0_BO_STATUS)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG0_ENABLE_BO[5] (RW)
 *
 * Enables the brownout detection. Not related to CCM. See Power Management Unit
 * (PMU) for more information.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG0_ENABLE_BO (5U) /*!< Bit position for CCM_ANALOG_MISC2_REG0_ENABLE_BO. */
#define BM_CCM_ANALOG_MISC2_REG0_ENABLE_BO (0x00000020U) /*!< Bit mask for CCM_ANALOG_MISC2_REG0_ENABLE_BO. */
#define BS_CCM_ANALOG_MISC2_REG0_ENABLE_BO (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG0_ENABLE_BO. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG0_ENABLE_BO field. */
#define BR_CCM_ANALOG_MISC2_REG0_ENABLE_BO(x) (HW_CCM_ANALOG_MISC2(x).B.REG0_ENABLE_BO)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG0_ENABLE_BO. */
#define BF_CCM_ANALOG_MISC2_REG0_ENABLE_BO(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG0_ENABLE_BO) & BM_CCM_ANALOG_MISC2_REG0_ENABLE_BO)

/*! @brief Set the REG0_ENABLE_BO field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG0_ENABLE_BO(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG0_ENABLE_BO) | BF_CCM_ANALOG_MISC2_REG0_ENABLE_BO(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field PLL3_disable[7] (RW)
 *
 * Default value of "0". Should be set to "1" to turn off the USB-PLL(PLL3) in
 * run mode.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_PLL3_disable (7U) /*!< Bit position for CCM_ANALOG_MISC2_PLL3_disable. */
#define BM_CCM_ANALOG_MISC2_PLL3_disable (0x00000080U) /*!< Bit mask for CCM_ANALOG_MISC2_PLL3_disable. */
#define BS_CCM_ANALOG_MISC2_PLL3_disable (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_PLL3_disable. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_PLL3_disable field. */
#define BR_CCM_ANALOG_MISC2_PLL3_disable(x) (HW_CCM_ANALOG_MISC2(x).B.PLL3_disable)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_PLL3_disable. */
#define BF_CCM_ANALOG_MISC2_PLL3_disable(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_PLL3_disable) & BM_CCM_ANALOG_MISC2_PLL3_disable)

/*! @brief Set the PLL3_disable field to a new value. */
#define BW_CCM_ANALOG_MISC2_PLL3_disable(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_PLL3_disable) | BF_CCM_ANALOG_MISC2_PLL3_disable(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG1_BO_OFFSET[10:8] (RO)
 *
 * This field defines the brown out voltage offset for the xPU power domain.
 * IRQ_DIG_BO is also asserted. Single-bit increments reflect 25mV brownout voltage
 * steps. The reset brown-offset is 175mV below the programmed target code.
 * Brownout target = OUTPUT_TRG - BO_OFFSET. Some steps may be irrelevant because of
 * input supply limitations or load operation. Not related to CCM. See Power
 * Management Unit (PMU) for more information.
 *
 * Values:
 * - 100 - Brownout offset = 0.100V
 * - 111 - Brownout offset = 0.175V
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG1_BO_OFFSET (8U) /*!< Bit position for CCM_ANALOG_MISC2_REG1_BO_OFFSET. */
#define BM_CCM_ANALOG_MISC2_REG1_BO_OFFSET (0x00000700U) /*!< Bit mask for CCM_ANALOG_MISC2_REG1_BO_OFFSET. */
#define BS_CCM_ANALOG_MISC2_REG1_BO_OFFSET (3U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG1_BO_OFFSET. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG1_BO_OFFSET field. */
#define BR_CCM_ANALOG_MISC2_REG1_BO_OFFSET(x) (HW_CCM_ANALOG_MISC2(x).B.REG1_BO_OFFSET)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG1_BO_STATUS[11] (RO)
 *
 * Reg1 brownout status bit. Not related to CCM. See Power Management Unit (PMU)
 * for more information.
 *
 * Values:
 * - 1 - Brownout, supply is below target minus brownout offset.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG1_BO_STATUS (11U) /*!< Bit position for CCM_ANALOG_MISC2_REG1_BO_STATUS. */
#define BM_CCM_ANALOG_MISC2_REG1_BO_STATUS (0x00000800U) /*!< Bit mask for CCM_ANALOG_MISC2_REG1_BO_STATUS. */
#define BS_CCM_ANALOG_MISC2_REG1_BO_STATUS (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG1_BO_STATUS. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG1_BO_STATUS field. */
#define BR_CCM_ANALOG_MISC2_REG1_BO_STATUS(x) (HW_CCM_ANALOG_MISC2(x).B.REG1_BO_STATUS)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG1_ENABLE_BO[13] (RW)
 *
 * Enables the brownout detection. Not related to CCM. See Power Management Unit
 * (PMU) for more information.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG1_ENABLE_BO (13U) /*!< Bit position for CCM_ANALOG_MISC2_REG1_ENABLE_BO. */
#define BM_CCM_ANALOG_MISC2_REG1_ENABLE_BO (0x00002000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG1_ENABLE_BO. */
#define BS_CCM_ANALOG_MISC2_REG1_ENABLE_BO (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG1_ENABLE_BO. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG1_ENABLE_BO field. */
#define BR_CCM_ANALOG_MISC2_REG1_ENABLE_BO(x) (HW_CCM_ANALOG_MISC2(x).B.REG1_ENABLE_BO)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG1_ENABLE_BO. */
#define BF_CCM_ANALOG_MISC2_REG1_ENABLE_BO(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG1_ENABLE_BO) & BM_CCM_ANALOG_MISC2_REG1_ENABLE_BO)

/*! @brief Set the REG1_ENABLE_BO field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG1_ENABLE_BO(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG1_ENABLE_BO) | BF_CCM_ANALOG_MISC2_REG1_ENABLE_BO(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field AUDIO_DIV_LSB[15] (RW)
 *
 * LSB of Post-divider for Audio PLL. The output clock of the video PLL should
 * be gated prior to changing this divider to prevent glitches. This divider is
 * feed by PLL_AUDIOn[POST_DIV_SELECT] to achieve division ratios of /1, /2, /4,
 * /8, and /16. LSB bit value pertains to the last bit, please program the MSB bit
 * (bit 23) as well, to change divider value
 *
 * Values:
 * - 00 - divide by 1 (Default)
 * - 01 - divide by 2
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_AUDIO_DIV_LSB (15U) /*!< Bit position for CCM_ANALOG_MISC2_AUDIO_DIV_LSB. */
#define BM_CCM_ANALOG_MISC2_AUDIO_DIV_LSB (0x00008000U) /*!< Bit mask for CCM_ANALOG_MISC2_AUDIO_DIV_LSB. */
#define BS_CCM_ANALOG_MISC2_AUDIO_DIV_LSB (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_AUDIO_DIV_LSB. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_AUDIO_DIV_LSB field. */
#define BR_CCM_ANALOG_MISC2_AUDIO_DIV_LSB(x) (HW_CCM_ANALOG_MISC2(x).B.AUDIO_DIV_LSB)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_AUDIO_DIV_LSB. */
#define BF_CCM_ANALOG_MISC2_AUDIO_DIV_LSB(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_AUDIO_DIV_LSB) & BM_CCM_ANALOG_MISC2_AUDIO_DIV_LSB)

/*! @brief Set the AUDIO_DIV_LSB field to a new value. */
#define BW_CCM_ANALOG_MISC2_AUDIO_DIV_LSB(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_AUDIO_DIV_LSB) | BF_CCM_ANALOG_MISC2_AUDIO_DIV_LSB(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG2_BO_OFFSET[18:16] (RO)
 *
 * This field defines the brown out voltage offset for the xPU power domain.
 * IRQ_DIG_BO is also asserted. Single-bit increments reflect 25mV brownout voltage
 * steps. The reset brown-offset is 175mV below the programmed target code.
 * Brownout target = OUTPUT_TRG - BO_OFFSET. Some steps may be irrelevant because of
 * input supply limitations or load operation. Not related to CCM. See Power
 * Management Unit (PMU) for more information.
 *
 * Values:
 * - 100 - Brownout offset = 0.100V
 * - 111 - Brownout offset = 0.175V
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG2_BO_OFFSET (16U) /*!< Bit position for CCM_ANALOG_MISC2_REG2_BO_OFFSET. */
#define BM_CCM_ANALOG_MISC2_REG2_BO_OFFSET (0x00070000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG2_BO_OFFSET. */
#define BS_CCM_ANALOG_MISC2_REG2_BO_OFFSET (3U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG2_BO_OFFSET. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG2_BO_OFFSET field. */
#define BR_CCM_ANALOG_MISC2_REG2_BO_OFFSET(x) (HW_CCM_ANALOG_MISC2(x).B.REG2_BO_OFFSET)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG2_BO_STATUS[19] (RO)
 *
 * Reg2 brownout status bit. Not related to CCM. See Power Management Unit (PMU)
 * for more information.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG2_BO_STATUS (19U) /*!< Bit position for CCM_ANALOG_MISC2_REG2_BO_STATUS. */
#define BM_CCM_ANALOG_MISC2_REG2_BO_STATUS (0x00080000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG2_BO_STATUS. */
#define BS_CCM_ANALOG_MISC2_REG2_BO_STATUS (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG2_BO_STATUS. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG2_BO_STATUS field. */
#define BR_CCM_ANALOG_MISC2_REG2_BO_STATUS(x) (HW_CCM_ANALOG_MISC2(x).B.REG2_BO_STATUS)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG2_ENABLE_BO[21] (RW)
 *
 * Enables the brownout detection. Not related to CCM. See Power Management Unit
 * (PMU) for more information.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG2_ENABLE_BO (21U) /*!< Bit position for CCM_ANALOG_MISC2_REG2_ENABLE_BO. */
#define BM_CCM_ANALOG_MISC2_REG2_ENABLE_BO (0x00200000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG2_ENABLE_BO. */
#define BS_CCM_ANALOG_MISC2_REG2_ENABLE_BO (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG2_ENABLE_BO. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG2_ENABLE_BO field. */
#define BR_CCM_ANALOG_MISC2_REG2_ENABLE_BO(x) (HW_CCM_ANALOG_MISC2(x).B.REG2_ENABLE_BO)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG2_ENABLE_BO. */
#define BF_CCM_ANALOG_MISC2_REG2_ENABLE_BO(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG2_ENABLE_BO) & BM_CCM_ANALOG_MISC2_REG2_ENABLE_BO)

/*! @brief Set the REG2_ENABLE_BO field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG2_ENABLE_BO(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG2_ENABLE_BO) | BF_CCM_ANALOG_MISC2_REG2_ENABLE_BO(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG2_OK[22] (RO)
 *
 * Signals that the voltage is above the brownout level for the SOC supply. 1 =
 * regulator output > brownout_target Not related to CCM. See Power Management
 * Unit (PMU) for more information.
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG2_OK (22U)  /*!< Bit position for CCM_ANALOG_MISC2_REG2_OK. */
#define BM_CCM_ANALOG_MISC2_REG2_OK (0x00400000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG2_OK. */
#define BS_CCM_ANALOG_MISC2_REG2_OK (1U)   /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG2_OK. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG2_OK field. */
#define BR_CCM_ANALOG_MISC2_REG2_OK(x) (HW_CCM_ANALOG_MISC2(x).B.REG2_OK)
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field AUDIO_DIV_MSB[23] (RW)
 *
 * MSB of Post-divider for Audio PLL. The output clock of the video PLL should
 * be gated prior to changing this divider to prevent glitches. This divider is
 * feed by PLL_AUDIOn[POST_DIV_SELECT] to achieve division ratios of /1, /2, /4,
 * /8, and /16. MSB bit value pertains to the first bit, please program the LSB bit
 * (bit 15) as well to change divider value
 *
 * Values:
 * - 00 - divide by 1 (Default)
 * - 01 - divide by 2
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_AUDIO_DIV_MSB (23U) /*!< Bit position for CCM_ANALOG_MISC2_AUDIO_DIV_MSB. */
#define BM_CCM_ANALOG_MISC2_AUDIO_DIV_MSB (0x00800000U) /*!< Bit mask for CCM_ANALOG_MISC2_AUDIO_DIV_MSB. */
#define BS_CCM_ANALOG_MISC2_AUDIO_DIV_MSB (1U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_AUDIO_DIV_MSB. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_AUDIO_DIV_MSB field. */
#define BR_CCM_ANALOG_MISC2_AUDIO_DIV_MSB(x) (HW_CCM_ANALOG_MISC2(x).B.AUDIO_DIV_MSB)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_AUDIO_DIV_MSB. */
#define BF_CCM_ANALOG_MISC2_AUDIO_DIV_MSB(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_AUDIO_DIV_MSB) & BM_CCM_ANALOG_MISC2_AUDIO_DIV_MSB)

/*! @brief Set the AUDIO_DIV_MSB field to a new value. */
#define BW_CCM_ANALOG_MISC2_AUDIO_DIV_MSB(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_AUDIO_DIV_MSB) | BF_CCM_ANALOG_MISC2_AUDIO_DIV_MSB(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG0_STEP_TIME[25:24] (RW)
 *
 * Number of clock periods (24MHz clock). Not related to CCM. See Power
 * Management Unit (PMU) for more information.
 *
 * Values:
 * - 00 - 64
 * - 01 - 128
 * - 10 - 256
 * - 11 - 512
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG0_STEP_TIME (24U) /*!< Bit position for CCM_ANALOG_MISC2_REG0_STEP_TIME. */
#define BM_CCM_ANALOG_MISC2_REG0_STEP_TIME (0x03000000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG0_STEP_TIME. */
#define BS_CCM_ANALOG_MISC2_REG0_STEP_TIME (2U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG0_STEP_TIME. */

#define BV_CCM_ANALOG_MISC2_REG0_STEP_TIME_64_CLOCKS (0U) /*!< Bit field value for CCM_ANALOG_MISC2_REG0_STEP_TIME: 64 */
#define BV_CCM_ANALOG_MISC2_REG0_STEP_TIME_128_CLOCKS (0x1U) /*!< Bit field value for CCM_ANALOG_MISC2_REG0_STEP_TIME: 128 */
#define BV_CCM_ANALOG_MISC2_REG0_STEP_TIME_256_CLOCKS (0x2U) /*!< Bit field value for CCM_ANALOG_MISC2_REG0_STEP_TIME: 256 */
#define BV_CCM_ANALOG_MISC2_REG0_STEP_TIME_512_CLOCKS (0x3U) /*!< Bit field value for CCM_ANALOG_MISC2_REG0_STEP_TIME: 512 */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG0_STEP_TIME field. */
#define BR_CCM_ANALOG_MISC2_REG0_STEP_TIME(x) (HW_CCM_ANALOG_MISC2(x).B.REG0_STEP_TIME)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG0_STEP_TIME. */
#define BF_CCM_ANALOG_MISC2_REG0_STEP_TIME(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG0_STEP_TIME) & BM_CCM_ANALOG_MISC2_REG0_STEP_TIME)

/*! @brief Set the REG0_STEP_TIME field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG0_STEP_TIME(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG0_STEP_TIME) | BF_CCM_ANALOG_MISC2_REG0_STEP_TIME(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG1_STEP_TIME[27:26] (RW)
 *
 * Number of clock periods (24MHz clock). Not related to CCM. See Power
 * Management Unit (PMU) for more information.
 *
 * Values:
 * - 00 - 64
 * - 01 - 128
 * - 10 - 256
 * - 11 - 512
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG1_STEP_TIME (26U) /*!< Bit position for CCM_ANALOG_MISC2_REG1_STEP_TIME. */
#define BM_CCM_ANALOG_MISC2_REG1_STEP_TIME (0x0C000000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG1_STEP_TIME. */
#define BS_CCM_ANALOG_MISC2_REG1_STEP_TIME (2U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG1_STEP_TIME. */

#define BV_CCM_ANALOG_MISC2_REG1_STEP_TIME_64_CLOCKS (0U) /*!< Bit field value for CCM_ANALOG_MISC2_REG1_STEP_TIME: 64 */
#define BV_CCM_ANALOG_MISC2_REG1_STEP_TIME_128_CLOCKS (0x1U) /*!< Bit field value for CCM_ANALOG_MISC2_REG1_STEP_TIME: 128 */
#define BV_CCM_ANALOG_MISC2_REG1_STEP_TIME_256_CLOCKS (0x2U) /*!< Bit field value for CCM_ANALOG_MISC2_REG1_STEP_TIME: 256 */
#define BV_CCM_ANALOG_MISC2_REG1_STEP_TIME_512_CLOCKS (0x3U) /*!< Bit field value for CCM_ANALOG_MISC2_REG1_STEP_TIME: 512 */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG1_STEP_TIME field. */
#define BR_CCM_ANALOG_MISC2_REG1_STEP_TIME(x) (HW_CCM_ANALOG_MISC2(x).B.REG1_STEP_TIME)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG1_STEP_TIME. */
#define BF_CCM_ANALOG_MISC2_REG1_STEP_TIME(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG1_STEP_TIME) & BM_CCM_ANALOG_MISC2_REG1_STEP_TIME)

/*! @brief Set the REG1_STEP_TIME field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG1_STEP_TIME(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG1_STEP_TIME) | BF_CCM_ANALOG_MISC2_REG1_STEP_TIME(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field REG2_STEP_TIME[29:28] (RW)
 *
 * Number of clock periods (24MHz clock). Not related to CCM. See Power
 * Management Unit (PMU) for more information.
 *
 * Values:
 * - 00 - 64
 * - 01 - 128
 * - 10 - 256
 * - 11 - 512
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_REG2_STEP_TIME (28U) /*!< Bit position for CCM_ANALOG_MISC2_REG2_STEP_TIME. */
#define BM_CCM_ANALOG_MISC2_REG2_STEP_TIME (0x30000000U) /*!< Bit mask for CCM_ANALOG_MISC2_REG2_STEP_TIME. */
#define BS_CCM_ANALOG_MISC2_REG2_STEP_TIME (2U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_REG2_STEP_TIME. */

#define BV_CCM_ANALOG_MISC2_REG2_STEP_TIME_64_CLOCKS (0U) /*!< Bit field value for CCM_ANALOG_MISC2_REG2_STEP_TIME: 64 */
#define BV_CCM_ANALOG_MISC2_REG2_STEP_TIME_128_CLOCKS (0x1U) /*!< Bit field value for CCM_ANALOG_MISC2_REG2_STEP_TIME: 128 */
#define BV_CCM_ANALOG_MISC2_REG2_STEP_TIME_256_CLOCKS (0x2U) /*!< Bit field value for CCM_ANALOG_MISC2_REG2_STEP_TIME: 256 */
#define BV_CCM_ANALOG_MISC2_REG2_STEP_TIME_512_CLOCKS (0x3U) /*!< Bit field value for CCM_ANALOG_MISC2_REG2_STEP_TIME: 512 */

/*! @brief Read current value of the CCM_ANALOG_MISC2_REG2_STEP_TIME field. */
#define BR_CCM_ANALOG_MISC2_REG2_STEP_TIME(x) (HW_CCM_ANALOG_MISC2(x).B.REG2_STEP_TIME)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_REG2_STEP_TIME. */
#define BF_CCM_ANALOG_MISC2_REG2_STEP_TIME(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_REG2_STEP_TIME) & BM_CCM_ANALOG_MISC2_REG2_STEP_TIME)

/*! @brief Set the REG2_STEP_TIME field to a new value. */
#define BW_CCM_ANALOG_MISC2_REG2_STEP_TIME(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_REG2_STEP_TIME) | BF_CCM_ANALOG_MISC2_REG2_STEP_TIME(v)))
/*@}*/

/*!
 * @name Register CCM_ANALOG_MISC2, field VIDEO_DIV[31:30] (RW)
 *
 * Post-divider for video. The output clock of the video PLL should be gated
 * prior to changing this divider to prevent glitches. This divider is feed by
 * PLL_VIDEOn[POST_DIV_SELECT] to achieve division ratios of /1, /2, /4, /8, and /16.
 *
 * Values:
 * - 00 - divide by 1 (Default)
 * - 01 - divide by 2
 * - 10 - divide by 1
 * - 11 - divide by 4
 */
/*@{*/
#define BP_CCM_ANALOG_MISC2_VIDEO_DIV (30U) /*!< Bit position for CCM_ANALOG_MISC2_VIDEO_DIV. */
#define BM_CCM_ANALOG_MISC2_VIDEO_DIV (0xC0000000U) /*!< Bit mask for CCM_ANALOG_MISC2_VIDEO_DIV. */
#define BS_CCM_ANALOG_MISC2_VIDEO_DIV (2U) /*!< Bit field size in bits for CCM_ANALOG_MISC2_VIDEO_DIV. */

/*! @brief Read current value of the CCM_ANALOG_MISC2_VIDEO_DIV field. */
#define BR_CCM_ANALOG_MISC2_VIDEO_DIV(x) (HW_CCM_ANALOG_MISC2(x).B.VIDEO_DIV)

/*! @brief Format value for bitfield CCM_ANALOG_MISC2_VIDEO_DIV. */
#define BF_CCM_ANALOG_MISC2_VIDEO_DIV(v) ((uint32_t)((uint32_t)(v) << BP_CCM_ANALOG_MISC2_VIDEO_DIV) & BM_CCM_ANALOG_MISC2_VIDEO_DIV)

/*! @brief Set the VIDEO_DIV field to a new value. */
#define BW_CCM_ANALOG_MISC2_VIDEO_DIV(x, v) (HW_CCM_ANALOG_MISC2_WR(x, (HW_CCM_ANALOG_MISC2_RD(x) & ~BM_CCM_ANALOG_MISC2_VIDEO_DIV) | BF_CCM_ANALOG_MISC2_VIDEO_DIV(v)))
/*@}*/




/*******************************************************************************
 * hw_ccm_analog_t - module struct
 ******************************************************************************/
/*!
 * @brief All CCM_ANALOG module registers.
 */
#pragma pack(1)
typedef struct _hw_ccm_analog
{
    __IO hw_ccm_analog_pll_arm_t PLL_ARM;  /*!< [0x0] Analog ARM PLL control Register */
    uint8_t _reserved0[12];
    __IO hw_ccm_analog_pll_usb1_t PLL_USB1; /*!< [0x10] Analog USB1 480MHz PLL Control Register */
    uint8_t _reserved1[12];
    __IO hw_ccm_analog_pll_usb2_t PLL_USB2; /*!< [0x20] Analog USB2 480MHz PLL Control Register */
    uint8_t _reserved2[12];
    __IO hw_ccm_analog_pll_sys_t PLL_SYS;  /*!< [0x30] Analog System PLL Control Register */
    uint8_t _reserved3[60];
    __IO hw_ccm_analog_pll_audio_t PLL_AUDIO; /*!< [0x70] Analog Audio PLL control Register */
    uint8_t _reserved4[12];
    __IO hw_ccm_analog_pll_audio_num_t PLL_AUDIO_NUM; /*!< [0x80] Numerator of Audio PLL Fractional Loop Divider Register */
    uint8_t _reserved5[12];
    __IO hw_ccm_analog_pll_audio_denom_t PLL_AUDIO_DENOM; /*!< [0x90] Denominator of Audio PLL Fractional Loop Divider Register */
    uint8_t _reserved6[12];
    __IO hw_ccm_analog_pll_video_t PLL_VIDEO; /*!< [0xA0] Analog Video PLL control Register */
    uint8_t _reserved7[12];
    __IO hw_ccm_analog_pll_video_num_t PLL_VIDEO_NUM; /*!< [0xB0] Numerator of Video PLL Fractional Loop Divider Register */
    uint8_t _reserved8[12];
    __IO hw_ccm_analog_pll_video_denom_t PLL_VIDEO_DENOM; /*!< [0xC0] Denominator of Video PLL Fractional Loop Divider Register */
    uint8_t _reserved9[28];
    __IO hw_ccm_analog_pll_enet_t PLL_ENET; /*!< [0xE0] Analog ENET PLL Control Register */
    uint8_t _reserved10[12];
    __IO hw_ccm_analog_pfd_480_t PFD_480;  /*!< [0xF0] 480MHz Clock (from PLL_USB2) Phase Fractional Divider Control Register */
    uint8_t _reserved11[12];
    __IO hw_ccm_analog_pfd_528_t PFD_528;  /*!< [0x100] 528MHz Clock (From PLL_SYS) Phase Fractional Divider Control Register */
    uint8_t _reserved12[76];
    __IO hw_ccm_analog_misc0_t MISC0;      /*!< [0x150] Miscellaneous Control Register */
    uint8_t _reserved13[28];
    __IO hw_ccm_analog_misc2_t MISC2;      /*!< [0x170] Miscellaneous Control Register */
} hw_ccm_analog_t;
#pragma pack()

/*! @brief Macro to access all CCM_ANALOG registers. */
/*! @param x CCM_ANALOG module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CCM_ANALOG_REGS(CCM_ANALOG_BASE)</code>. */
#define HW_CCM_ANALOG_REGS(x) (*(hw_ccm_analog_t *)(x))

/*
 * iMX6SL CSI
 *
 * CSI
 *
 * Registers defined in this header file:
 * - HW_CSI_CSICR1 - CSI Control Register 1
 * - HW_CSI_CSICR2 - CSI Control Register 2
 * - HW_CSI_CSICR3 - CSI Control Register 3
 * - HW_CSI_CSISTATFIFO - CSI Statistic FIFO Register
 * - HW_CSI_CSIRFIFO - CSI RX FIFO Register
 * - HW_CSI_CSIRXCNT - CSI RX Count Register
 * - HW_CSI_CSISR - CSI Status Register
 * - HW_CSI_CSIDMASA_STATFIFO - CSI DMA Start Address Register - for STATFIFO
 * - HW_CSI_CSIDMATS_STATFIFO - CSI DMA Transfer Size Register - for STATFIFO
 * - HW_CSI_CSIDMASA_FB1 - CSI DMA Start Address Register - for Frame Buffer1
 * - HW_CSI_CSIDMASA_FB2 - CSI DMA Transfer Size Register - for Frame Buffer2
 * - HW_CSI_CSIFBUF_PARA - CSI Frame Buffer Parameter Register
 * - HW_CSI_CSIIMAG_PARA - CSI Image Parameter Register
 *
 * - hw_csi_t - Struct containing all module registers.
 */

#define HW_CSI_INSTANCE_COUNT (1U) /*!< Number of instances of the CSI module. */
#define HW_CSI (0U) /*!< Instance number for CSI. */
#define CSI_BASE              (0x20E4000U) /*!< Base address for CSI. */
/*! Array initializer of CSI base addresses. */
#define CSI_BASE_ADDRS        { CSI_BASE }

/*******************************************************************************
 * HW_CSI_CSICR1 - CSI Control Register 1
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSICR1 - CSI Control Register 1 (RW)
 *
 * Reset value: 0x40000800U
 *
 * This register controls the sensor interface timing and interrupt generation.
 * The interrupt enable bits in this register control the interrupt signals and
 * the status bits. That means status bits will only function when the
 * corresponding interrupt bits are enabled.
 */
typedef union _hw_csi_csicr1
{
    uint32_t U;
    struct _hw_csi_csicr1_bitfields
    {
        uint32_t PIXEL_BIT : 1;        /*!< [0]  */
        uint32_t REDGE : 1;            /*!< [1]  */
        uint32_t INV_PCLK : 1;         /*!< [2]  */
        uint32_t INV_DATA : 1;         /*!< [3]  */
        uint32_t GCLK_MODE : 1;        /*!< [4]  */
        uint32_t CLR_RXFIFO : 1;       /*!< [5]  */
        uint32_t CLR_STATFIFO : 1;     /*!< [6]  */
        uint32_t PACK_DIR : 1;         /*!< [7]  */
        uint32_t FCC : 1;              /*!< [8]  */
        uint32_t RESERVED0 : 1;        /*!< [9]  */
        uint32_t CCIR_EN : 1;          /*!< [10]  */
        uint32_t HSYNC_POL : 1;        /*!< [11]  */
        uint32_t RESERVED1 : 4;        /*!< [15:12]  */
        uint32_t SOF_INTEN : 1;        /*!< [16]  */
        uint32_t SOF_POL : 1;          /*!< [17]  */
        uint32_t RXFF_INTEN : 1;       /*!< [18]  */
        uint32_t FB1_DMA_DONE_INTEN : 1; /*!< [19]  */
        uint32_t FB2_DMA_DONE_INTEN : 1; /*!< [20]  */
        uint32_t STATFF_INTEN : 1;     /*!< [21]  */
        uint32_t SFF_DMA_DONE_INTEN : 1; /*!< [22]  */
        uint32_t RESERVED2 : 1;        /*!< [23]  */
        uint32_t RF_OR_INTEN : 1;      /*!< [24]  */
        uint32_t SF_OR_INTEN : 1;      /*!< [25]  */
        uint32_t COF_INT_EN : 1;       /*!< [26]  */
        uint32_t CCIR_MODE : 1;        /*!< [27]  */
        uint32_t PrP_IF_EN : 1;        /*!< [28]  */
        uint32_t EOF_INT_EN : 1;       /*!< [29]  */
        uint32_t EXT_VSYNC : 1;        /*!< [30]  */
        uint32_t SWAP16_EN : 1;        /*!< [31]  */
    } B;
} hw_csi_csicr1_t;

/*!
 * @name Constants and macros for entire CSI_CSICR1 register
 */
/*@{*/
#define HW_CSI_CSICR1_ADDR(x)    ((uintptr_t)(x) + 0x0U)

#define HW_CSI_CSICR1(x)         (*(__IO hw_csi_csicr1_t *) HW_CSI_CSICR1_ADDR(x))
#define HW_CSI_CSICR1_RD(x)      (HW_CSI_CSICR1(x).U)
#define HW_CSI_CSICR1_WR(x, v)   (HW_CSI_CSICR1(x).U = (v))
#define HW_CSI_CSICR1_SET(x, v)  (HW_CSI_CSICR1_WR(x, HW_CSI_CSICR1_RD(x) |  (v)))
#define HW_CSI_CSICR1_CLR(x, v)  (HW_CSI_CSICR1_WR(x, HW_CSI_CSICR1_RD(x) & ~(v)))
#define HW_CSI_CSICR1_TOG(x, v)  (HW_CSI_CSICR1_WR(x, HW_CSI_CSICR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSICR1 bitfields
 */

/*!
 * @name Register CSI_CSICR1, field PIXEL_BIT[0] (RW)
 *
 * Pixel Bit. This bit indicates the bayer data width for each pixel. This bit
 * should be configured before activating or re-starting the embedded DMA
 * controller.
 *
 * Values:
 * - 0 - 8-bit data for each pixel
 * - 1 - 10-bit data for each pixel
 */
/*@{*/
#define BP_CSI_CSICR1_PIXEL_BIT (0U)       /*!< Bit position for CSI_CSICR1_PIXEL_BIT. */
#define BM_CSI_CSICR1_PIXEL_BIT (0x00000001U) /*!< Bit mask for CSI_CSICR1_PIXEL_BIT. */
#define BS_CSI_CSICR1_PIXEL_BIT (1U)       /*!< Bit field size in bits for CSI_CSICR1_PIXEL_BIT. */

/*! @brief Read current value of the CSI_CSICR1_PIXEL_BIT field. */
#define BR_CSI_CSICR1_PIXEL_BIT(x) (HW_CSI_CSICR1(x).B.PIXEL_BIT)

/*! @brief Format value for bitfield CSI_CSICR1_PIXEL_BIT. */
#define BF_CSI_CSICR1_PIXEL_BIT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_PIXEL_BIT) & BM_CSI_CSICR1_PIXEL_BIT)

/*! @brief Set the PIXEL_BIT field to a new value. */
#define BW_CSI_CSICR1_PIXEL_BIT(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_PIXEL_BIT) | BF_CSI_CSICR1_PIXEL_BIT(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field REDGE[1] (RW)
 *
 * Valid Pixel Clock Edge Select. Selects which edge of the CSI_PIXCLK is used
 * to latch the pixel data.
 *
 * Values:
 * - 0 - Pixel data is latched at the falling edge of CSI_PIXCLK
 * - 1 - Pixel data is latched at the rising edge of CSI_PIXCLK
 */
/*@{*/
#define BP_CSI_CSICR1_REDGE  (1U)          /*!< Bit position for CSI_CSICR1_REDGE. */
#define BM_CSI_CSICR1_REDGE  (0x00000002U) /*!< Bit mask for CSI_CSICR1_REDGE. */
#define BS_CSI_CSICR1_REDGE  (1U)          /*!< Bit field size in bits for CSI_CSICR1_REDGE. */

/*! @brief Read current value of the CSI_CSICR1_REDGE field. */
#define BR_CSI_CSICR1_REDGE(x) (HW_CSI_CSICR1(x).B.REDGE)

/*! @brief Format value for bitfield CSI_CSICR1_REDGE. */
#define BF_CSI_CSICR1_REDGE(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_REDGE) & BM_CSI_CSICR1_REDGE)

/*! @brief Set the REDGE field to a new value. */
#define BW_CSI_CSICR1_REDGE(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_REDGE) | BF_CSI_CSICR1_REDGE(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field INV_PCLK[2] (RW)
 *
 * Invert Pixel Clock Input. This bit determines if the Pixel Clock (CSI_PIXCLK)
 * is inverted before it is applied to the CSI module.
 *
 * Values:
 * - 0 - CSI_PIXCLK is directly applied to internal circuitry
 * - 1 - CSI_PIXCLK is inverted before applied to internal circuitry
 */
/*@{*/
#define BP_CSI_CSICR1_INV_PCLK (2U)        /*!< Bit position for CSI_CSICR1_INV_PCLK. */
#define BM_CSI_CSICR1_INV_PCLK (0x00000004U) /*!< Bit mask for CSI_CSICR1_INV_PCLK. */
#define BS_CSI_CSICR1_INV_PCLK (1U)        /*!< Bit field size in bits for CSI_CSICR1_INV_PCLK. */

/*! @brief Read current value of the CSI_CSICR1_INV_PCLK field. */
#define BR_CSI_CSICR1_INV_PCLK(x) (HW_CSI_CSICR1(x).B.INV_PCLK)

/*! @brief Format value for bitfield CSI_CSICR1_INV_PCLK. */
#define BF_CSI_CSICR1_INV_PCLK(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_INV_PCLK) & BM_CSI_CSICR1_INV_PCLK)

/*! @brief Set the INV_PCLK field to a new value. */
#define BW_CSI_CSICR1_INV_PCLK(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_INV_PCLK) | BF_CSI_CSICR1_INV_PCLK(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field INV_DATA[3] (RW)
 *
 * Invert Data Input. This bit enables or disables internal inverters on the
 * data lines.
 *
 * Values:
 * - 0 - CSI_D[7:0] data lines are directly applied to internal circuitry
 * - 1 - CSI_D[7:0] data lines are inverted before applied to internal circuitry
 */
/*@{*/
#define BP_CSI_CSICR1_INV_DATA (3U)        /*!< Bit position for CSI_CSICR1_INV_DATA. */
#define BM_CSI_CSICR1_INV_DATA (0x00000008U) /*!< Bit mask for CSI_CSICR1_INV_DATA. */
#define BS_CSI_CSICR1_INV_DATA (1U)        /*!< Bit field size in bits for CSI_CSICR1_INV_DATA. */

/*! @brief Read current value of the CSI_CSICR1_INV_DATA field. */
#define BR_CSI_CSICR1_INV_DATA(x) (HW_CSI_CSICR1(x).B.INV_DATA)

/*! @brief Format value for bitfield CSI_CSICR1_INV_DATA. */
#define BF_CSI_CSICR1_INV_DATA(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_INV_DATA) & BM_CSI_CSICR1_INV_DATA)

/*! @brief Set the INV_DATA field to a new value. */
#define BW_CSI_CSICR1_INV_DATA(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_INV_DATA) | BF_CSI_CSICR1_INV_DATA(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field GCLK_MODE[4] (RW)
 *
 * Gated Clock Mode Enable. Controls if CSI is working in gated or non-gated
 * mode. This bit works only in traditional mode-that is, CCIR_EN = 0. Otherwise
 * this bit is ignored.
 *
 * Values:
 * - 0 - Non-gated clock mode. All incoming pixel clocks are valid. HSYNC is
 *     ignored.
 * - 1 - Gated clock mode. Pixel clock signal is valid only when HSYNC is active.
 */
/*@{*/
#define BP_CSI_CSICR1_GCLK_MODE (4U)       /*!< Bit position for CSI_CSICR1_GCLK_MODE. */
#define BM_CSI_CSICR1_GCLK_MODE (0x00000010U) /*!< Bit mask for CSI_CSICR1_GCLK_MODE. */
#define BS_CSI_CSICR1_GCLK_MODE (1U)       /*!< Bit field size in bits for CSI_CSICR1_GCLK_MODE. */

/*! @brief Read current value of the CSI_CSICR1_GCLK_MODE field. */
#define BR_CSI_CSICR1_GCLK_MODE(x) (HW_CSI_CSICR1(x).B.GCLK_MODE)

/*! @brief Format value for bitfield CSI_CSICR1_GCLK_MODE. */
#define BF_CSI_CSICR1_GCLK_MODE(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_GCLK_MODE) & BM_CSI_CSICR1_GCLK_MODE)

/*! @brief Set the GCLK_MODE field to a new value. */
#define BW_CSI_CSICR1_GCLK_MODE(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_GCLK_MODE) | BF_CSI_CSICR1_GCLK_MODE(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field CLR_RXFIFO[5] (RW)
 *
 * Asynchronous RXFIFO Clear. This bit clears the RXFIFO. This bit works only in
 * async FIFO clear mode-that is, FCC = 0. Otherwise this bit is ignored.
 * Writing 1 clears the RXFIFO immediately, RXFIFO restarts immediately after that. The
 * bit is restored to 0 automatically after finish. Normally reads 0.
 */
/*@{*/
#define BP_CSI_CSICR1_CLR_RXFIFO (5U)      /*!< Bit position for CSI_CSICR1_CLR_RXFIFO. */
#define BM_CSI_CSICR1_CLR_RXFIFO (0x00000020U) /*!< Bit mask for CSI_CSICR1_CLR_RXFIFO. */
#define BS_CSI_CSICR1_CLR_RXFIFO (1U)      /*!< Bit field size in bits for CSI_CSICR1_CLR_RXFIFO. */

/*! @brief Read current value of the CSI_CSICR1_CLR_RXFIFO field. */
#define BR_CSI_CSICR1_CLR_RXFIFO(x) (HW_CSI_CSICR1(x).B.CLR_RXFIFO)

/*! @brief Format value for bitfield CSI_CSICR1_CLR_RXFIFO. */
#define BF_CSI_CSICR1_CLR_RXFIFO(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_CLR_RXFIFO) & BM_CSI_CSICR1_CLR_RXFIFO)

/*! @brief Set the CLR_RXFIFO field to a new value. */
#define BW_CSI_CSICR1_CLR_RXFIFO(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_CLR_RXFIFO) | BF_CSI_CSICR1_CLR_RXFIFO(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field CLR_STATFIFO[6] (RW)
 *
 * Asynchronous STATFIFO Clear. This bit clears the STATFIFO and Reset STAT
 * block. This bit works only in async FIFO clear mode-that is, FCC = 0. Otherwise
 * this bit is ignored. Writing 1 will clear STATFIFO and reset STAT block
 * immediately, STATFIFO and STAT block then wait and restart after the arrival of next
 * SOF. The bit is restored to 0 automatically after finish. Normally reads 0.
 */
/*@{*/
#define BP_CSI_CSICR1_CLR_STATFIFO (6U)    /*!< Bit position for CSI_CSICR1_CLR_STATFIFO. */
#define BM_CSI_CSICR1_CLR_STATFIFO (0x00000040U) /*!< Bit mask for CSI_CSICR1_CLR_STATFIFO. */
#define BS_CSI_CSICR1_CLR_STATFIFO (1U)    /*!< Bit field size in bits for CSI_CSICR1_CLR_STATFIFO. */

/*! @brief Read current value of the CSI_CSICR1_CLR_STATFIFO field. */
#define BR_CSI_CSICR1_CLR_STATFIFO(x) (HW_CSI_CSICR1(x).B.CLR_STATFIFO)

/*! @brief Format value for bitfield CSI_CSICR1_CLR_STATFIFO. */
#define BF_CSI_CSICR1_CLR_STATFIFO(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_CLR_STATFIFO) & BM_CSI_CSICR1_CLR_STATFIFO)

/*! @brief Set the CLR_STATFIFO field to a new value. */
#define BW_CSI_CSICR1_CLR_STATFIFO(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_CLR_STATFIFO) | BF_CSI_CSICR1_CLR_STATFIFO(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field PACK_DIR[7] (RW)
 *
 * Data Packing Direction. This bit Controls how 8-bit/10-bit image data is
 * packed into 32-bit RX FIFO, and how 16-bit statistical data is packed into 32-bit
 * STAT FIFO.
 *
 * Values:
 * - 0 - Pack from LSB first. For image data, 0x11, 0x22, 0x33, 0x44, it will
 *     appear as 0x44332211 in RX FIFO. For stat data, 0xAAAA, 0xBBBB, it will
 *     appear as 0xBBBBAAAA in STAT FIFO.
 * - 1 - Pack from MSB first. For image data, 0x11, 0x22, 0x33, 0x44, it will
 *     appear as 0x11223344 in RX FIFO. For stat data, 0xAAAA, 0xBBBB, it will
 *     appear as 0xAAAABBBB in STAT FIFO.
 */
/*@{*/
#define BP_CSI_CSICR1_PACK_DIR (7U)        /*!< Bit position for CSI_CSICR1_PACK_DIR. */
#define BM_CSI_CSICR1_PACK_DIR (0x00000080U) /*!< Bit mask for CSI_CSICR1_PACK_DIR. */
#define BS_CSI_CSICR1_PACK_DIR (1U)        /*!< Bit field size in bits for CSI_CSICR1_PACK_DIR. */

/*! @brief Read current value of the CSI_CSICR1_PACK_DIR field. */
#define BR_CSI_CSICR1_PACK_DIR(x) (HW_CSI_CSICR1(x).B.PACK_DIR)

/*! @brief Format value for bitfield CSI_CSICR1_PACK_DIR. */
#define BF_CSI_CSICR1_PACK_DIR(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_PACK_DIR) & BM_CSI_CSICR1_PACK_DIR)

/*! @brief Set the PACK_DIR field to a new value. */
#define BW_CSI_CSICR1_PACK_DIR(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_PACK_DIR) | BF_CSI_CSICR1_PACK_DIR(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field FCC[8] (RW)
 *
 * FIFO Clear Control. This bit determines how the RXFIFO and STATFIFO are
 * cleared. When Synchronous FIFO clear is selected the RXFIFO and STATFIFO are
 * cleared, and STAT block is reset, on every SOF. FIFOs and STAT block restarts
 * immediately after reset. For information on the operation when Asynchronous FIFO
 * clear is selected, refer to the descriptions for the CLR_RXFIFO and CLR_STATFIFO
 * bits.
 *
 * Values:
 * - 0 - Asynchronous FIFO clear is selected.
 * - 1 - Synchronous FIFO clear is selected.
 */
/*@{*/
#define BP_CSI_CSICR1_FCC    (8U)          /*!< Bit position for CSI_CSICR1_FCC. */
#define BM_CSI_CSICR1_FCC    (0x00000100U) /*!< Bit mask for CSI_CSICR1_FCC. */
#define BS_CSI_CSICR1_FCC    (1U)          /*!< Bit field size in bits for CSI_CSICR1_FCC. */

/*! @brief Read current value of the CSI_CSICR1_FCC field. */
#define BR_CSI_CSICR1_FCC(x) (HW_CSI_CSICR1(x).B.FCC)

/*! @brief Format value for bitfield CSI_CSICR1_FCC. */
#define BF_CSI_CSICR1_FCC(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_FCC) & BM_CSI_CSICR1_FCC)

/*! @brief Set the FCC field to a new value. */
#define BW_CSI_CSICR1_FCC(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_FCC) | BF_CSI_CSICR1_FCC(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field CCIR_EN[10] (RW)
 *
 * CCIR656 Interface Enable. This bit selects the type of interface used. When
 * the CCIR656 timing decoder is enabled, it replaces the function of timing
 * interface logic.
 *
 * Values:
 * - 0 - Traditional interface is selected. Timing interface logic is used to
 *     latch data.
 * - 1 - CCIR656 interface is selected.
 */
/*@{*/
#define BP_CSI_CSICR1_CCIR_EN (10U)        /*!< Bit position for CSI_CSICR1_CCIR_EN. */
#define BM_CSI_CSICR1_CCIR_EN (0x00000400U) /*!< Bit mask for CSI_CSICR1_CCIR_EN. */
#define BS_CSI_CSICR1_CCIR_EN (1U)         /*!< Bit field size in bits for CSI_CSICR1_CCIR_EN. */

/*! @brief Read current value of the CSI_CSICR1_CCIR_EN field. */
#define BR_CSI_CSICR1_CCIR_EN(x) (HW_CSI_CSICR1(x).B.CCIR_EN)

/*! @brief Format value for bitfield CSI_CSICR1_CCIR_EN. */
#define BF_CSI_CSICR1_CCIR_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_CCIR_EN) & BM_CSI_CSICR1_CCIR_EN)

/*! @brief Set the CCIR_EN field to a new value. */
#define BW_CSI_CSICR1_CCIR_EN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_CCIR_EN) | BF_CSI_CSICR1_CCIR_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field HSYNC_POL[11] (RW)
 *
 * HSYNC Polarity Select. This bit controls the polarity of HSYNC. This bit only
 * works in gated-clock-that is, GCLK_MODE = 1 and CCIR_EN = 0.
 *
 * Values:
 * - 0 - HSYNC is active low
 * - 1 - HSYNC is active high
 */
/*@{*/
#define BP_CSI_CSICR1_HSYNC_POL (11U)      /*!< Bit position for CSI_CSICR1_HSYNC_POL. */
#define BM_CSI_CSICR1_HSYNC_POL (0x00000800U) /*!< Bit mask for CSI_CSICR1_HSYNC_POL. */
#define BS_CSI_CSICR1_HSYNC_POL (1U)       /*!< Bit field size in bits for CSI_CSICR1_HSYNC_POL. */

/*! @brief Read current value of the CSI_CSICR1_HSYNC_POL field. */
#define BR_CSI_CSICR1_HSYNC_POL(x) (HW_CSI_CSICR1(x).B.HSYNC_POL)

/*! @brief Format value for bitfield CSI_CSICR1_HSYNC_POL. */
#define BF_CSI_CSICR1_HSYNC_POL(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_HSYNC_POL) & BM_CSI_CSICR1_HSYNC_POL)

/*! @brief Set the HSYNC_POL field to a new value. */
#define BW_CSI_CSICR1_HSYNC_POL(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_HSYNC_POL) | BF_CSI_CSICR1_HSYNC_POL(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field SOF_INTEN[16] (RW)
 *
 * Start Of Frame (SOF) Interrupt Enable. This bit enables the SOF interrupt.
 *
 * Values:
 * - 0 - SOF interrupt disable
 * - 1 - SOF interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_SOF_INTEN (16U)      /*!< Bit position for CSI_CSICR1_SOF_INTEN. */
#define BM_CSI_CSICR1_SOF_INTEN (0x00010000U) /*!< Bit mask for CSI_CSICR1_SOF_INTEN. */
#define BS_CSI_CSICR1_SOF_INTEN (1U)       /*!< Bit field size in bits for CSI_CSICR1_SOF_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_SOF_INTEN field. */
#define BR_CSI_CSICR1_SOF_INTEN(x) (HW_CSI_CSICR1(x).B.SOF_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_SOF_INTEN. */
#define BF_CSI_CSICR1_SOF_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_SOF_INTEN) & BM_CSI_CSICR1_SOF_INTEN)

/*! @brief Set the SOF_INTEN field to a new value. */
#define BW_CSI_CSICR1_SOF_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_SOF_INTEN) | BF_CSI_CSICR1_SOF_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field SOF_POL[17] (RW)
 *
 * SOF Interrupt Polarity. This bit controls the condition that generates an SOF
 * interrupt.
 *
 * Values:
 * - 0 - SOF interrupt is generated on SOF falling edge
 * - 1 - SOF interrupt is generated on SOF rising edge
 */
/*@{*/
#define BP_CSI_CSICR1_SOF_POL (17U)        /*!< Bit position for CSI_CSICR1_SOF_POL. */
#define BM_CSI_CSICR1_SOF_POL (0x00020000U) /*!< Bit mask for CSI_CSICR1_SOF_POL. */
#define BS_CSI_CSICR1_SOF_POL (1U)         /*!< Bit field size in bits for CSI_CSICR1_SOF_POL. */

/*! @brief Read current value of the CSI_CSICR1_SOF_POL field. */
#define BR_CSI_CSICR1_SOF_POL(x) (HW_CSI_CSICR1(x).B.SOF_POL)

/*! @brief Format value for bitfield CSI_CSICR1_SOF_POL. */
#define BF_CSI_CSICR1_SOF_POL(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_SOF_POL) & BM_CSI_CSICR1_SOF_POL)

/*! @brief Set the SOF_POL field to a new value. */
#define BW_CSI_CSICR1_SOF_POL(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_SOF_POL) | BF_CSI_CSICR1_SOF_POL(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field RXFF_INTEN[18] (RW)
 *
 * RxFIFO Full Interrupt Enable. This bit enables the RxFIFO full interrupt.
 *
 * Values:
 * - 0 - RxFIFO full interrupt disable
 * - 1 - RxFIFO full interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_RXFF_INTEN (18U)     /*!< Bit position for CSI_CSICR1_RXFF_INTEN. */
#define BM_CSI_CSICR1_RXFF_INTEN (0x00040000U) /*!< Bit mask for CSI_CSICR1_RXFF_INTEN. */
#define BS_CSI_CSICR1_RXFF_INTEN (1U)      /*!< Bit field size in bits for CSI_CSICR1_RXFF_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_RXFF_INTEN field. */
#define BR_CSI_CSICR1_RXFF_INTEN(x) (HW_CSI_CSICR1(x).B.RXFF_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_RXFF_INTEN. */
#define BF_CSI_CSICR1_RXFF_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_RXFF_INTEN) & BM_CSI_CSICR1_RXFF_INTEN)

/*! @brief Set the RXFF_INTEN field to a new value. */
#define BW_CSI_CSICR1_RXFF_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_RXFF_INTEN) | BF_CSI_CSICR1_RXFF_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field FB1_DMA_DONE_INTEN[19] (RW)
 *
 * Frame Buffer1 DMA Transfer Done Interrupt Enable. This bit enables the
 * interrupt of Frame Buffer1 DMA transfer done.
 *
 * Values:
 * - 0 - Frame Buffer1 DMA Transfer Done interrupt disable
 * - 1 - Frame Buffer1 DMA Transfer Done interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_FB1_DMA_DONE_INTEN (19U) /*!< Bit position for CSI_CSICR1_FB1_DMA_DONE_INTEN. */
#define BM_CSI_CSICR1_FB1_DMA_DONE_INTEN (0x00080000U) /*!< Bit mask for CSI_CSICR1_FB1_DMA_DONE_INTEN. */
#define BS_CSI_CSICR1_FB1_DMA_DONE_INTEN (1U) /*!< Bit field size in bits for CSI_CSICR1_FB1_DMA_DONE_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_FB1_DMA_DONE_INTEN field. */
#define BR_CSI_CSICR1_FB1_DMA_DONE_INTEN(x) (HW_CSI_CSICR1(x).B.FB1_DMA_DONE_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_FB1_DMA_DONE_INTEN. */
#define BF_CSI_CSICR1_FB1_DMA_DONE_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_FB1_DMA_DONE_INTEN) & BM_CSI_CSICR1_FB1_DMA_DONE_INTEN)

/*! @brief Set the FB1_DMA_DONE_INTEN field to a new value. */
#define BW_CSI_CSICR1_FB1_DMA_DONE_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_FB1_DMA_DONE_INTEN) | BF_CSI_CSICR1_FB1_DMA_DONE_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field FB2_DMA_DONE_INTEN[20] (RW)
 *
 * Frame Buffer2 DMA Transfer Done Interrupt Enable. This bit enables the
 * interrupt of Frame Buffer2 DMA transfer done.
 *
 * Values:
 * - 0 - Frame Buffer2 DMA Transfer Done interrupt disable
 * - 1 - Frame Buffer2 DMA Transfer Done interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_FB2_DMA_DONE_INTEN (20U) /*!< Bit position for CSI_CSICR1_FB2_DMA_DONE_INTEN. */
#define BM_CSI_CSICR1_FB2_DMA_DONE_INTEN (0x00100000U) /*!< Bit mask for CSI_CSICR1_FB2_DMA_DONE_INTEN. */
#define BS_CSI_CSICR1_FB2_DMA_DONE_INTEN (1U) /*!< Bit field size in bits for CSI_CSICR1_FB2_DMA_DONE_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_FB2_DMA_DONE_INTEN field. */
#define BR_CSI_CSICR1_FB2_DMA_DONE_INTEN(x) (HW_CSI_CSICR1(x).B.FB2_DMA_DONE_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_FB2_DMA_DONE_INTEN. */
#define BF_CSI_CSICR1_FB2_DMA_DONE_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_FB2_DMA_DONE_INTEN) & BM_CSI_CSICR1_FB2_DMA_DONE_INTEN)

/*! @brief Set the FB2_DMA_DONE_INTEN field to a new value. */
#define BW_CSI_CSICR1_FB2_DMA_DONE_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_FB2_DMA_DONE_INTEN) | BF_CSI_CSICR1_FB2_DMA_DONE_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field STATFF_INTEN[21] (RW)
 *
 * STATFIFO Full Interrupt Enable. This bit enables the STAT FIFO interrupt.
 *
 * Values:
 * - 0 - STATFIFO full interrupt disable
 * - 1 - STATFIFO full interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_STATFF_INTEN (21U)   /*!< Bit position for CSI_CSICR1_STATFF_INTEN. */
#define BM_CSI_CSICR1_STATFF_INTEN (0x00200000U) /*!< Bit mask for CSI_CSICR1_STATFF_INTEN. */
#define BS_CSI_CSICR1_STATFF_INTEN (1U)    /*!< Bit field size in bits for CSI_CSICR1_STATFF_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_STATFF_INTEN field. */
#define BR_CSI_CSICR1_STATFF_INTEN(x) (HW_CSI_CSICR1(x).B.STATFF_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_STATFF_INTEN. */
#define BF_CSI_CSICR1_STATFF_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_STATFF_INTEN) & BM_CSI_CSICR1_STATFF_INTEN)

/*! @brief Set the STATFF_INTEN field to a new value. */
#define BW_CSI_CSICR1_STATFF_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_STATFF_INTEN) | BF_CSI_CSICR1_STATFF_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field SFF_DMA_DONE_INTEN[22] (RW)
 *
 * STATFIFO DMA Transfer Done Interrupt Enable. This bit enables the interrupt
 * of STATFIFO DMA transfer done.
 *
 * Values:
 * - 0 - STATFIFO DMA Transfer Done interrupt disable
 * - 1 - STATFIFO DMA Transfer Done interrupt enable
 */
/*@{*/
#define BP_CSI_CSICR1_SFF_DMA_DONE_INTEN (22U) /*!< Bit position for CSI_CSICR1_SFF_DMA_DONE_INTEN. */
#define BM_CSI_CSICR1_SFF_DMA_DONE_INTEN (0x00400000U) /*!< Bit mask for CSI_CSICR1_SFF_DMA_DONE_INTEN. */
#define BS_CSI_CSICR1_SFF_DMA_DONE_INTEN (1U) /*!< Bit field size in bits for CSI_CSICR1_SFF_DMA_DONE_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_SFF_DMA_DONE_INTEN field. */
#define BR_CSI_CSICR1_SFF_DMA_DONE_INTEN(x) (HW_CSI_CSICR1(x).B.SFF_DMA_DONE_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_SFF_DMA_DONE_INTEN. */
#define BF_CSI_CSICR1_SFF_DMA_DONE_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_SFF_DMA_DONE_INTEN) & BM_CSI_CSICR1_SFF_DMA_DONE_INTEN)

/*! @brief Set the SFF_DMA_DONE_INTEN field to a new value. */
#define BW_CSI_CSICR1_SFF_DMA_DONE_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_SFF_DMA_DONE_INTEN) | BF_CSI_CSICR1_SFF_DMA_DONE_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field RF_OR_INTEN[24] (RW)
 *
 * RxFIFO Overrun Interrupt Enable. This bit enables the RX FIFO overrun
 * interrupt.
 *
 * Values:
 * - 0 - RxFIFO overrun interrupt is disabled
 * - 1 - RxFIFO overrun interrupt is enabled
 */
/*@{*/
#define BP_CSI_CSICR1_RF_OR_INTEN (24U)    /*!< Bit position for CSI_CSICR1_RF_OR_INTEN. */
#define BM_CSI_CSICR1_RF_OR_INTEN (0x01000000U) /*!< Bit mask for CSI_CSICR1_RF_OR_INTEN. */
#define BS_CSI_CSICR1_RF_OR_INTEN (1U)     /*!< Bit field size in bits for CSI_CSICR1_RF_OR_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_RF_OR_INTEN field. */
#define BR_CSI_CSICR1_RF_OR_INTEN(x) (HW_CSI_CSICR1(x).B.RF_OR_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_RF_OR_INTEN. */
#define BF_CSI_CSICR1_RF_OR_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_RF_OR_INTEN) & BM_CSI_CSICR1_RF_OR_INTEN)

/*! @brief Set the RF_OR_INTEN field to a new value. */
#define BW_CSI_CSICR1_RF_OR_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_RF_OR_INTEN) | BF_CSI_CSICR1_RF_OR_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field SF_OR_INTEN[25] (RW)
 *
 * STAT FIFO Overrun Interrupt Enable. This bit enables the STATFIFO overrun
 * interrupt.
 *
 * Values:
 * - 0 - STATFIFO overrun interrupt is disabled
 * - 1 - STATFIFO overrun interrupt is enabled
 */
/*@{*/
#define BP_CSI_CSICR1_SF_OR_INTEN (25U)    /*!< Bit position for CSI_CSICR1_SF_OR_INTEN. */
#define BM_CSI_CSICR1_SF_OR_INTEN (0x02000000U) /*!< Bit mask for CSI_CSICR1_SF_OR_INTEN. */
#define BS_CSI_CSICR1_SF_OR_INTEN (1U)     /*!< Bit field size in bits for CSI_CSICR1_SF_OR_INTEN. */

/*! @brief Read current value of the CSI_CSICR1_SF_OR_INTEN field. */
#define BR_CSI_CSICR1_SF_OR_INTEN(x) (HW_CSI_CSICR1(x).B.SF_OR_INTEN)

/*! @brief Format value for bitfield CSI_CSICR1_SF_OR_INTEN. */
#define BF_CSI_CSICR1_SF_OR_INTEN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_SF_OR_INTEN) & BM_CSI_CSICR1_SF_OR_INTEN)

/*! @brief Set the SF_OR_INTEN field to a new value. */
#define BW_CSI_CSICR1_SF_OR_INTEN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_SF_OR_INTEN) | BF_CSI_CSICR1_SF_OR_INTEN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field COF_INT_EN[26] (RW)
 *
 * Change Of Image Field (COF) Interrupt Enable. This bit enables the COF
 * interrupt. This bit works only in CCIR interlace mode which is when CCIR_EN = 1 and
 * CCIR_MODE = 1.
 *
 * Values:
 * - 0 - COF interrupt is disabled
 * - 1 - COF interrupt is enabled
 */
/*@{*/
#define BP_CSI_CSICR1_COF_INT_EN (26U)     /*!< Bit position for CSI_CSICR1_COF_INT_EN. */
#define BM_CSI_CSICR1_COF_INT_EN (0x04000000U) /*!< Bit mask for CSI_CSICR1_COF_INT_EN. */
#define BS_CSI_CSICR1_COF_INT_EN (1U)      /*!< Bit field size in bits for CSI_CSICR1_COF_INT_EN. */

/*! @brief Read current value of the CSI_CSICR1_COF_INT_EN field. */
#define BR_CSI_CSICR1_COF_INT_EN(x) (HW_CSI_CSICR1(x).B.COF_INT_EN)

/*! @brief Format value for bitfield CSI_CSICR1_COF_INT_EN. */
#define BF_CSI_CSICR1_COF_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_COF_INT_EN) & BM_CSI_CSICR1_COF_INT_EN)

/*! @brief Set the COF_INT_EN field to a new value. */
#define BW_CSI_CSICR1_COF_INT_EN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_COF_INT_EN) | BF_CSI_CSICR1_COF_INT_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field CCIR_MODE[27] (RW)
 *
 * CCIR Mode Select. This bit controls the CCIR mode of operation. This bit only
 * works in CCIR interface mode.
 *
 * Values:
 * - 0 - Progressive mode is selected
 * - 1 - Interlace mode is selected
 */
/*@{*/
#define BP_CSI_CSICR1_CCIR_MODE (27U)      /*!< Bit position for CSI_CSICR1_CCIR_MODE. */
#define BM_CSI_CSICR1_CCIR_MODE (0x08000000U) /*!< Bit mask for CSI_CSICR1_CCIR_MODE. */
#define BS_CSI_CSICR1_CCIR_MODE (1U)       /*!< Bit field size in bits for CSI_CSICR1_CCIR_MODE. */

/*! @brief Read current value of the CSI_CSICR1_CCIR_MODE field. */
#define BR_CSI_CSICR1_CCIR_MODE(x) (HW_CSI_CSICR1(x).B.CCIR_MODE)

/*! @brief Format value for bitfield CSI_CSICR1_CCIR_MODE. */
#define BF_CSI_CSICR1_CCIR_MODE(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_CCIR_MODE) & BM_CSI_CSICR1_CCIR_MODE)

/*! @brief Set the CCIR_MODE field to a new value. */
#define BW_CSI_CSICR1_CCIR_MODE(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_CCIR_MODE) | BF_CSI_CSICR1_CCIR_MODE(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field PrP_IF_EN[28] (RW)
 *
 * CSI-PrP Interface Enable. This bit controls the CSI to PrP bus. When enabled
 * the RxFIFO is detached from the AHB bus and connected to PrP. All CPU reads or
 * DMA accesses to the RxFIFO register are ignored. All CSI interrupts are also
 * masked.
 *
 * Values:
 * - 0 - CSI to PrP bus is disabled
 * - 1 - CSI to PrP bus is enabled
 */
/*@{*/
#define BP_CSI_CSICR1_PrP_IF_EN (28U)      /*!< Bit position for CSI_CSICR1_PrP_IF_EN. */
#define BM_CSI_CSICR1_PrP_IF_EN (0x10000000U) /*!< Bit mask for CSI_CSICR1_PrP_IF_EN. */
#define BS_CSI_CSICR1_PrP_IF_EN (1U)       /*!< Bit field size in bits for CSI_CSICR1_PrP_IF_EN. */

/*! @brief Read current value of the CSI_CSICR1_PrP_IF_EN field. */
#define BR_CSI_CSICR1_PrP_IF_EN(x) (HW_CSI_CSICR1(x).B.PrP_IF_EN)

/*! @brief Format value for bitfield CSI_CSICR1_PrP_IF_EN. */
#define BF_CSI_CSICR1_PrP_IF_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_PrP_IF_EN) & BM_CSI_CSICR1_PrP_IF_EN)

/*! @brief Set the PrP_IF_EN field to a new value. */
#define BW_CSI_CSICR1_PrP_IF_EN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_PrP_IF_EN) | BF_CSI_CSICR1_PrP_IF_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field EOF_INT_EN[29] (RW)
 *
 * End-of-Frame Interrupt Enable. This bit enables and disables the EOF
 * interrupt.
 *
 * Values:
 * - 0 - EOF interrupt is disabled.
 * - 1 - EOF interrupt is generated when RX count value is reached.
 */
/*@{*/
#define BP_CSI_CSICR1_EOF_INT_EN (29U)     /*!< Bit position for CSI_CSICR1_EOF_INT_EN. */
#define BM_CSI_CSICR1_EOF_INT_EN (0x20000000U) /*!< Bit mask for CSI_CSICR1_EOF_INT_EN. */
#define BS_CSI_CSICR1_EOF_INT_EN (1U)      /*!< Bit field size in bits for CSI_CSICR1_EOF_INT_EN. */

/*! @brief Read current value of the CSI_CSICR1_EOF_INT_EN field. */
#define BR_CSI_CSICR1_EOF_INT_EN(x) (HW_CSI_CSICR1(x).B.EOF_INT_EN)

/*! @brief Format value for bitfield CSI_CSICR1_EOF_INT_EN. */
#define BF_CSI_CSICR1_EOF_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_EOF_INT_EN) & BM_CSI_CSICR1_EOF_INT_EN)

/*! @brief Set the EOF_INT_EN field to a new value. */
#define BW_CSI_CSICR1_EOF_INT_EN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_EOF_INT_EN) | BF_CSI_CSICR1_EOF_INT_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field EXT_VSYNC[30] (RW)
 *
 * External VSYNC Enable. This bit controls the operational VSYNC mode. This
 * only works when the CSI is in CCIR progressive mode.
 *
 * Values:
 * - 0 - Internal VSYNC mode
 * - 1 - External VSYNC mode
 */
/*@{*/
#define BP_CSI_CSICR1_EXT_VSYNC (30U)      /*!< Bit position for CSI_CSICR1_EXT_VSYNC. */
#define BM_CSI_CSICR1_EXT_VSYNC (0x40000000U) /*!< Bit mask for CSI_CSICR1_EXT_VSYNC. */
#define BS_CSI_CSICR1_EXT_VSYNC (1U)       /*!< Bit field size in bits for CSI_CSICR1_EXT_VSYNC. */

/*! @brief Read current value of the CSI_CSICR1_EXT_VSYNC field. */
#define BR_CSI_CSICR1_EXT_VSYNC(x) (HW_CSI_CSICR1(x).B.EXT_VSYNC)

/*! @brief Format value for bitfield CSI_CSICR1_EXT_VSYNC. */
#define BF_CSI_CSICR1_EXT_VSYNC(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_EXT_VSYNC) & BM_CSI_CSICR1_EXT_VSYNC)

/*! @brief Set the EXT_VSYNC field to a new value. */
#define BW_CSI_CSICR1_EXT_VSYNC(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_EXT_VSYNC) | BF_CSI_CSICR1_EXT_VSYNC(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR1, field SWAP16_EN[31] (RW)
 *
 * SWAP 16-Bit Enable. This bit enables the swapping of 16-bit data. Data is
 * packed from 8-bit or 10-bit to 32-bit first (according to the setting of
 * PACK_DIR) and then swapped as 16-bit words before being put into the RX FIFO. The
 * action of the bit only affects the RX FIFO and has no affect on the STAT FIFO.
 * Example of swapping enabled: Data input to FIFO = 0x11223344 Data in RX FIFO = 0x
 * 33441122 Example of swapping disabled: Data input to FIFO = 0x11223344 Data
 * in RX FIFO = 0x11223344
 *
 * Values:
 * - 0 - Disable swapping
 * - 1 - Enable swapping
 */
/*@{*/
#define BP_CSI_CSICR1_SWAP16_EN (31U)      /*!< Bit position for CSI_CSICR1_SWAP16_EN. */
#define BM_CSI_CSICR1_SWAP16_EN (0x80000000U) /*!< Bit mask for CSI_CSICR1_SWAP16_EN. */
#define BS_CSI_CSICR1_SWAP16_EN (1U)       /*!< Bit field size in bits for CSI_CSICR1_SWAP16_EN. */

/*! @brief Read current value of the CSI_CSICR1_SWAP16_EN field. */
#define BR_CSI_CSICR1_SWAP16_EN(x) (HW_CSI_CSICR1(x).B.SWAP16_EN)

/*! @brief Format value for bitfield CSI_CSICR1_SWAP16_EN. */
#define BF_CSI_CSICR1_SWAP16_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR1_SWAP16_EN) & BM_CSI_CSICR1_SWAP16_EN)

/*! @brief Set the SWAP16_EN field to a new value. */
#define BW_CSI_CSICR1_SWAP16_EN(x, v) (HW_CSI_CSICR1_WR(x, (HW_CSI_CSICR1_RD(x) & ~BM_CSI_CSICR1_SWAP16_EN) | BF_CSI_CSICR1_SWAP16_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSICR2 - CSI Control Register 2
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSICR2 - CSI Control Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the statistic block with data about which live view
 * resolution is being used, and the starting sensor pixel of the Bayer pattern. It
 * also contains the horizontal and vertical count used to determine the number
 * of pixels to skip between the 64 x 64 blocks of statistics when generating
 * statistics on live view image that are greater than 512 x 384.
 */
typedef union _hw_csi_csicr2
{
    uint32_t U;
    struct _hw_csi_csicr2_bitfields
    {
        uint32_t HSC : 8;              /*!< [7:0]  */
        uint32_t VSC : 8;              /*!< [15:8]  */
        uint32_t LVRM : 3;             /*!< [18:16]  */
        uint32_t BTS : 2;              /*!< [20:19]  */
        uint32_t RESERVED0 : 2;        /*!< [22:21]  */
        uint32_t SCE : 1;              /*!< [23]  */
        uint32_t AFS : 2;              /*!< [25:24]  */
        uint32_t DRM : 1;              /*!< [26]  */
        uint32_t RESERVED1 : 1;        /*!< [27]  */
        uint32_t DMA_BURST_TYPE_SFF : 2; /*!< [29:28]  */
        uint32_t DMA_BURST_TYPE_RFF : 2; /*!< [31:30]  */
    } B;
} hw_csi_csicr2_t;

/*!
 * @name Constants and macros for entire CSI_CSICR2 register
 */
/*@{*/
#define HW_CSI_CSICR2_ADDR(x)    ((uintptr_t)(x) + 0x4U)

#define HW_CSI_CSICR2(x)         (*(__IO hw_csi_csicr2_t *) HW_CSI_CSICR2_ADDR(x))
#define HW_CSI_CSICR2_RD(x)      (HW_CSI_CSICR2(x).U)
#define HW_CSI_CSICR2_WR(x, v)   (HW_CSI_CSICR2(x).U = (v))
#define HW_CSI_CSICR2_SET(x, v)  (HW_CSI_CSICR2_WR(x, HW_CSI_CSICR2_RD(x) |  (v)))
#define HW_CSI_CSICR2_CLR(x, v)  (HW_CSI_CSICR2_WR(x, HW_CSI_CSICR2_RD(x) & ~(v)))
#define HW_CSI_CSICR2_TOG(x, v)  (HW_CSI_CSICR2_WR(x, HW_CSI_CSICR2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSICR2 bitfields
 */

/*!
 * @name Register CSI_CSICR2, field HSC[7:0] (RW)
 *
 * Horizontal Skip Count. Contains the number of pixels to skip. SCE must be 1,
 * otherwise HSC is ignored.
 */
/*@{*/
#define BP_CSI_CSICR2_HSC    (0U)          /*!< Bit position for CSI_CSICR2_HSC. */
#define BM_CSI_CSICR2_HSC    (0x000000FFU) /*!< Bit mask for CSI_CSICR2_HSC. */
#define BS_CSI_CSICR2_HSC    (8U)          /*!< Bit field size in bits for CSI_CSICR2_HSC. */

/*! @brief Read current value of the CSI_CSICR2_HSC field. */
#define BR_CSI_CSICR2_HSC(x) (HW_CSI_CSICR2(x).B.HSC)

/*! @brief Format value for bitfield CSI_CSICR2_HSC. */
#define BF_CSI_CSICR2_HSC(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_HSC) & BM_CSI_CSICR2_HSC)

/*! @brief Set the HSC field to a new value. */
#define BW_CSI_CSICR2_HSC(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_HSC) | BF_CSI_CSICR2_HSC(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field VSC[15:8] (RW)
 *
 * Vertical Skip Count. Contains the number of rows to skip. SCE must be 1,
 * otherwise VSC is ignored.
 */
/*@{*/
#define BP_CSI_CSICR2_VSC    (8U)          /*!< Bit position for CSI_CSICR2_VSC. */
#define BM_CSI_CSICR2_VSC    (0x0000FF00U) /*!< Bit mask for CSI_CSICR2_VSC. */
#define BS_CSI_CSICR2_VSC    (8U)          /*!< Bit field size in bits for CSI_CSICR2_VSC. */

/*! @brief Read current value of the CSI_CSICR2_VSC field. */
#define BR_CSI_CSICR2_VSC(x) (HW_CSI_CSICR2(x).B.VSC)

/*! @brief Format value for bitfield CSI_CSICR2_VSC. */
#define BF_CSI_CSICR2_VSC(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_VSC) & BM_CSI_CSICR2_VSC)

/*! @brief Set the VSC field to a new value. */
#define BW_CSI_CSICR2_VSC(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_VSC) | BF_CSI_CSICR2_VSC(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field LVRM[18:16] (RW)
 *
 * Live View Resolution Mode. Selects the grid size used for live view
 * resolution.
 *
 * Values:
 * - 0 - 512 x 384
 * - 1 - 448 x 336
 */
/*@{*/
#define BP_CSI_CSICR2_LVRM   (16U)         /*!< Bit position for CSI_CSICR2_LVRM. */
#define BM_CSI_CSICR2_LVRM   (0x00070000U) /*!< Bit mask for CSI_CSICR2_LVRM. */
#define BS_CSI_CSICR2_LVRM   (3U)          /*!< Bit field size in bits for CSI_CSICR2_LVRM. */

/*! @brief Read current value of the CSI_CSICR2_LVRM field. */
#define BR_CSI_CSICR2_LVRM(x) (HW_CSI_CSICR2(x).B.LVRM)

/*! @brief Format value for bitfield CSI_CSICR2_LVRM. */
#define BF_CSI_CSICR2_LVRM(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_LVRM) & BM_CSI_CSICR2_LVRM)

/*! @brief Set the LVRM field to a new value. */
#define BW_CSI_CSICR2_LVRM(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_LVRM) | BF_CSI_CSICR2_LVRM(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field BTS[20:19] (RW)
 *
 * Bayer Tile Start. Controls the Bayer pattern starting point.
 *
 * Values:
 * - 00 - GR
 * - 01 - RG
 * - 10 - BG
 * - 11 - GB
 */
/*@{*/
#define BP_CSI_CSICR2_BTS    (19U)         /*!< Bit position for CSI_CSICR2_BTS. */
#define BM_CSI_CSICR2_BTS    (0x00180000U) /*!< Bit mask for CSI_CSICR2_BTS. */
#define BS_CSI_CSICR2_BTS    (2U)          /*!< Bit field size in bits for CSI_CSICR2_BTS. */

/*! @brief Read current value of the CSI_CSICR2_BTS field. */
#define BR_CSI_CSICR2_BTS(x) (HW_CSI_CSICR2(x).B.BTS)

/*! @brief Format value for bitfield CSI_CSICR2_BTS. */
#define BF_CSI_CSICR2_BTS(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_BTS) & BM_CSI_CSICR2_BTS)

/*! @brief Set the BTS field to a new value. */
#define BW_CSI_CSICR2_BTS(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_BTS) | BF_CSI_CSICR2_BTS(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field SCE[23] (RW)
 *
 * Skip Count Enable. Enables or disables the skip count feature.
 *
 * Values:
 * - 0 - Skip count disable
 * - 1 - Skip count enable
 */
/*@{*/
#define BP_CSI_CSICR2_SCE    (23U)         /*!< Bit position for CSI_CSICR2_SCE. */
#define BM_CSI_CSICR2_SCE    (0x00800000U) /*!< Bit mask for CSI_CSICR2_SCE. */
#define BS_CSI_CSICR2_SCE    (1U)          /*!< Bit field size in bits for CSI_CSICR2_SCE. */

/*! @brief Read current value of the CSI_CSICR2_SCE field. */
#define BR_CSI_CSICR2_SCE(x) (HW_CSI_CSICR2(x).B.SCE)

/*! @brief Format value for bitfield CSI_CSICR2_SCE. */
#define BF_CSI_CSICR2_SCE(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_SCE) & BM_CSI_CSICR2_SCE)

/*! @brief Set the SCE field to a new value. */
#define BW_CSI_CSICR2_SCE(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_SCE) | BF_CSI_CSICR2_SCE(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field AFS[25:24] (RW)
 *
 * Auto Focus Spread. Selects which green pixels are used for auto-focus.
 *
 * Values:
 * - 00 - Abs Diff on consecutive green pixels
 * - 01 - Abs Diff on every third green pixels
 * - 1x - Abs Diff on every four green pixels
 */
/*@{*/
#define BP_CSI_CSICR2_AFS    (24U)         /*!< Bit position for CSI_CSICR2_AFS. */
#define BM_CSI_CSICR2_AFS    (0x03000000U) /*!< Bit mask for CSI_CSICR2_AFS. */
#define BS_CSI_CSICR2_AFS    (2U)          /*!< Bit field size in bits for CSI_CSICR2_AFS. */

/*! @brief Read current value of the CSI_CSICR2_AFS field. */
#define BR_CSI_CSICR2_AFS(x) (HW_CSI_CSICR2(x).B.AFS)

/*! @brief Format value for bitfield CSI_CSICR2_AFS. */
#define BF_CSI_CSICR2_AFS(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_AFS) & BM_CSI_CSICR2_AFS)

/*! @brief Set the AFS field to a new value. */
#define BW_CSI_CSICR2_AFS(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_AFS) | BF_CSI_CSICR2_AFS(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field DRM[26] (RW)
 *
 * Double Resolution Mode. Controls size of statistics grid.
 *
 * Values:
 * - 0 - Stats grid of 8 x 6
 * - 1 - Stats grid of 8 x 12
 */
/*@{*/
#define BP_CSI_CSICR2_DRM    (26U)         /*!< Bit position for CSI_CSICR2_DRM. */
#define BM_CSI_CSICR2_DRM    (0x04000000U) /*!< Bit mask for CSI_CSICR2_DRM. */
#define BS_CSI_CSICR2_DRM    (1U)          /*!< Bit field size in bits for CSI_CSICR2_DRM. */

/*! @brief Read current value of the CSI_CSICR2_DRM field. */
#define BR_CSI_CSICR2_DRM(x) (HW_CSI_CSICR2(x).B.DRM)

/*! @brief Format value for bitfield CSI_CSICR2_DRM. */
#define BF_CSI_CSICR2_DRM(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_DRM) & BM_CSI_CSICR2_DRM)

/*! @brief Set the DRM field to a new value. */
#define BW_CSI_CSICR2_DRM(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_DRM) | BF_CSI_CSICR2_DRM(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field DMA_BURST_TYPE_SFF[29:28] (RW)
 *
 * Burst Type of DMA Transfer from STATFIFO. Selects the burst type of DMA
 * transfer from STATFIFO.
 *
 * Values:
 * - 01 - INCR4
 * - 11 - INCR16
 */
/*@{*/
#define BP_CSI_CSICR2_DMA_BURST_TYPE_SFF (28U) /*!< Bit position for CSI_CSICR2_DMA_BURST_TYPE_SFF. */
#define BM_CSI_CSICR2_DMA_BURST_TYPE_SFF (0x30000000U) /*!< Bit mask for CSI_CSICR2_DMA_BURST_TYPE_SFF. */
#define BS_CSI_CSICR2_DMA_BURST_TYPE_SFF (2U) /*!< Bit field size in bits for CSI_CSICR2_DMA_BURST_TYPE_SFF. */

/*! @brief Read current value of the CSI_CSICR2_DMA_BURST_TYPE_SFF field. */
#define BR_CSI_CSICR2_DMA_BURST_TYPE_SFF(x) (HW_CSI_CSICR2(x).B.DMA_BURST_TYPE_SFF)

/*! @brief Format value for bitfield CSI_CSICR2_DMA_BURST_TYPE_SFF. */
#define BF_CSI_CSICR2_DMA_BURST_TYPE_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_DMA_BURST_TYPE_SFF) & BM_CSI_CSICR2_DMA_BURST_TYPE_SFF)

/*! @brief Set the DMA_BURST_TYPE_SFF field to a new value. */
#define BW_CSI_CSICR2_DMA_BURST_TYPE_SFF(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_DMA_BURST_TYPE_SFF) | BF_CSI_CSICR2_DMA_BURST_TYPE_SFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR2, field DMA_BURST_TYPE_RFF[31:30] (RW)
 *
 * Burst Type of DMA Transfer from RxFIFO. Selects the burst type of DMA
 * transfer from RxFIFO.
 *
 * Values:
 * - 01 - INCR4
 * - 11 - INCR16
 */
/*@{*/
#define BP_CSI_CSICR2_DMA_BURST_TYPE_RFF (30U) /*!< Bit position for CSI_CSICR2_DMA_BURST_TYPE_RFF. */
#define BM_CSI_CSICR2_DMA_BURST_TYPE_RFF (0xC0000000U) /*!< Bit mask for CSI_CSICR2_DMA_BURST_TYPE_RFF. */
#define BS_CSI_CSICR2_DMA_BURST_TYPE_RFF (2U) /*!< Bit field size in bits for CSI_CSICR2_DMA_BURST_TYPE_RFF. */

/*! @brief Read current value of the CSI_CSICR2_DMA_BURST_TYPE_RFF field. */
#define BR_CSI_CSICR2_DMA_BURST_TYPE_RFF(x) (HW_CSI_CSICR2(x).B.DMA_BURST_TYPE_RFF)

/*! @brief Format value for bitfield CSI_CSICR2_DMA_BURST_TYPE_RFF. */
#define BF_CSI_CSICR2_DMA_BURST_TYPE_RFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR2_DMA_BURST_TYPE_RFF) & BM_CSI_CSICR2_DMA_BURST_TYPE_RFF)

/*! @brief Set the DMA_BURST_TYPE_RFF field to a new value. */
#define BW_CSI_CSICR2_DMA_BURST_TYPE_RFF(x, v) (HW_CSI_CSICR2_WR(x, (HW_CSI_CSICR2_RD(x) & ~BM_CSI_CSICR2_DMA_BURST_TYPE_RFF) | BF_CSI_CSICR2_DMA_BURST_TYPE_RFF(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSICR3 - CSI Control Register 3
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSICR3 - CSI Control Register 3 (RW)
 *
 * Reset value: 0x00000000U
 *
 * This read/write register acts as an extension of the functionality of the CSI
 * Control register 1, adding additional control and features.
 */
typedef union _hw_csi_csicr3
{
    uint32_t U;
    struct _hw_csi_csicr3_bitfields
    {
        uint32_t ECC_AUTO_EN : 1;      /*!< [0]  */
        uint32_t ECC_INT_EN : 1;       /*!< [1]  */
        uint32_t ZERO_PACK_EN : 1;     /*!< [2]  */
        uint32_t TWO_8BIT_SENSOR : 1;  /*!< [3]  */
        uint32_t RxFF_LEVEL : 3;       /*!< [6:4]  */
        uint32_t HRESP_ERR_EN : 1;     /*!< [7]  */
        uint32_t STATFF_LEVEL : 3;     /*!< [10:8]  */
        uint32_t DMA_REQ_EN_SFF : 1;   /*!< [11]  */
        uint32_t DMA_REQ_EN_RFF : 1;   /*!< [12]  */
        uint32_t DMA_REFLASH_SFF : 1;  /*!< [13]  */
        uint32_t DMA_REFLASH_RFF : 1;  /*!< [14]  */
        uint32_t FRMCNT_RST : 1;       /*!< [15]  */
        uint32_t FRMCNT : 16;          /*!< [31:16]  */
    } B;
} hw_csi_csicr3_t;

/*!
 * @name Constants and macros for entire CSI_CSICR3 register
 */
/*@{*/
#define HW_CSI_CSICR3_ADDR(x)    ((uintptr_t)(x) + 0x8U)

#define HW_CSI_CSICR3(x)         (*(__IO hw_csi_csicr3_t *) HW_CSI_CSICR3_ADDR(x))
#define HW_CSI_CSICR3_RD(x)      (HW_CSI_CSICR3(x).U)
#define HW_CSI_CSICR3_WR(x, v)   (HW_CSI_CSICR3(x).U = (v))
#define HW_CSI_CSICR3_SET(x, v)  (HW_CSI_CSICR3_WR(x, HW_CSI_CSICR3_RD(x) |  (v)))
#define HW_CSI_CSICR3_CLR(x, v)  (HW_CSI_CSICR3_WR(x, HW_CSI_CSICR3_RD(x) & ~(v)))
#define HW_CSI_CSICR3_TOG(x, v)  (HW_CSI_CSICR3_WR(x, HW_CSI_CSICR3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSICR3 bitfields
 */

/*!
 * @name Register CSI_CSICR3, field ECC_AUTO_EN[0] (RW)
 *
 * Automatic Error Correction Enable. This bit enables and disables the
 * automatic error correction. If an error occurs and error correction is disabled only
 * the ECC_INT status bit is set. This feature only works in CCIR interlace mode.
 *
 * Values:
 * - 0 - Auto Error correction is disabled.
 * - 1 - Auto Error correction is enabled.
 */
/*@{*/
#define BP_CSI_CSICR3_ECC_AUTO_EN (0U)     /*!< Bit position for CSI_CSICR3_ECC_AUTO_EN. */
#define BM_CSI_CSICR3_ECC_AUTO_EN (0x00000001U) /*!< Bit mask for CSI_CSICR3_ECC_AUTO_EN. */
#define BS_CSI_CSICR3_ECC_AUTO_EN (1U)     /*!< Bit field size in bits for CSI_CSICR3_ECC_AUTO_EN. */

/*! @brief Read current value of the CSI_CSICR3_ECC_AUTO_EN field. */
#define BR_CSI_CSICR3_ECC_AUTO_EN(x) (HW_CSI_CSICR3(x).B.ECC_AUTO_EN)

/*! @brief Format value for bitfield CSI_CSICR3_ECC_AUTO_EN. */
#define BF_CSI_CSICR3_ECC_AUTO_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_ECC_AUTO_EN) & BM_CSI_CSICR3_ECC_AUTO_EN)

/*! @brief Set the ECC_AUTO_EN field to a new value. */
#define BW_CSI_CSICR3_ECC_AUTO_EN(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_ECC_AUTO_EN) | BF_CSI_CSICR3_ECC_AUTO_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field ECC_INT_EN[1] (RW)
 *
 * Error Detection Interrupt Enable. This bit enables and disables the error
 * detection interrupt. This feature only works in CCIR interlace mode.
 *
 * Values:
 * - 0 - No interrupt is generated when error is detected. Only the status bit
 *     ECC_INT is set.
 * - 1 - Interrupt is generated when error is detected.
 */
/*@{*/
#define BP_CSI_CSICR3_ECC_INT_EN (1U)      /*!< Bit position for CSI_CSICR3_ECC_INT_EN. */
#define BM_CSI_CSICR3_ECC_INT_EN (0x00000002U) /*!< Bit mask for CSI_CSICR3_ECC_INT_EN. */
#define BS_CSI_CSICR3_ECC_INT_EN (1U)      /*!< Bit field size in bits for CSI_CSICR3_ECC_INT_EN. */

/*! @brief Read current value of the CSI_CSICR3_ECC_INT_EN field. */
#define BR_CSI_CSICR3_ECC_INT_EN(x) (HW_CSI_CSICR3(x).B.ECC_INT_EN)

/*! @brief Format value for bitfield CSI_CSICR3_ECC_INT_EN. */
#define BF_CSI_CSICR3_ECC_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_ECC_INT_EN) & BM_CSI_CSICR3_ECC_INT_EN)

/*! @brief Set the ECC_INT_EN field to a new value. */
#define BW_CSI_CSICR3_ECC_INT_EN(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_ECC_INT_EN) | BF_CSI_CSICR3_ECC_INT_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field ZERO_PACK_EN[2] (RW)
 *
 * Dummy Zero Packing Enable. This bit causes a dummy zero to be packed with
 * every 3 incoming bytes, forming a 32-bit word. The dummy zero is always packed to
 * the LSB position. This packing function is only available in 8-bit/pixel mode.
 *
 * Values:
 * - 0 - Zero packing disabled
 * - 1 - Zero packing enabled
 */
/*@{*/
#define BP_CSI_CSICR3_ZERO_PACK_EN (2U)    /*!< Bit position for CSI_CSICR3_ZERO_PACK_EN. */
#define BM_CSI_CSICR3_ZERO_PACK_EN (0x00000004U) /*!< Bit mask for CSI_CSICR3_ZERO_PACK_EN. */
#define BS_CSI_CSICR3_ZERO_PACK_EN (1U)    /*!< Bit field size in bits for CSI_CSICR3_ZERO_PACK_EN. */

/*! @brief Read current value of the CSI_CSICR3_ZERO_PACK_EN field. */
#define BR_CSI_CSICR3_ZERO_PACK_EN(x) (HW_CSI_CSICR3(x).B.ZERO_PACK_EN)

/*! @brief Format value for bitfield CSI_CSICR3_ZERO_PACK_EN. */
#define BF_CSI_CSICR3_ZERO_PACK_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_ZERO_PACK_EN) & BM_CSI_CSICR3_ZERO_PACK_EN)

/*! @brief Set the ZERO_PACK_EN field to a new value. */
#define BW_CSI_CSICR3_ZERO_PACK_EN(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_ZERO_PACK_EN) | BF_CSI_CSICR3_ZERO_PACK_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field TWO_8BIT_SENSOR[3] (RW)
 *
 * Two 8-bit Sensor Mode. This bit indicates one 16-bit sensor or two 8-bit
 * sensors are connected to the 16-bit data ports. This bit should be set if there is
 * one 16-bit sensor or two 8-bit sensors are connected. This bit should be
 * configured before activating or restarting the embedded DMA controller.
 *
 * Values:
 * - 0 - Only one sensor is connected.
 * - 1 - Two 8-bit sensors are connected or one 16-bit sensor is connected.
 */
/*@{*/
#define BP_CSI_CSICR3_TWO_8BIT_SENSOR (3U) /*!< Bit position for CSI_CSICR3_TWO_8BIT_SENSOR. */
#define BM_CSI_CSICR3_TWO_8BIT_SENSOR (0x00000008U) /*!< Bit mask for CSI_CSICR3_TWO_8BIT_SENSOR. */
#define BS_CSI_CSICR3_TWO_8BIT_SENSOR (1U) /*!< Bit field size in bits for CSI_CSICR3_TWO_8BIT_SENSOR. */

/*! @brief Read current value of the CSI_CSICR3_TWO_8BIT_SENSOR field. */
#define BR_CSI_CSICR3_TWO_8BIT_SENSOR(x) (HW_CSI_CSICR3(x).B.TWO_8BIT_SENSOR)

/*! @brief Format value for bitfield CSI_CSICR3_TWO_8BIT_SENSOR. */
#define BF_CSI_CSICR3_TWO_8BIT_SENSOR(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_TWO_8BIT_SENSOR) & BM_CSI_CSICR3_TWO_8BIT_SENSOR)

/*! @brief Set the TWO_8BIT_SENSOR field to a new value. */
#define BW_CSI_CSICR3_TWO_8BIT_SENSOR(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_TWO_8BIT_SENSOR) | BF_CSI_CSICR3_TWO_8BIT_SENSOR(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field RxFF_LEVEL[6:4] (RW)
 *
 * RxFIFO Full Level. When the number of data in RxFIFO reaches this level, a
 * RxFIFO full interrupt is generated, or an RXFIFO DMA request is sent.
 *
 * Values:
 * - 000 - 4 Words
 * - 001 - 8 Words
 * - 010 - 16 Words
 * - 011 - 24 Words
 * - 100 - 32 Words
 * - 101 - 4 8 Words
 * - 110 - 64 Words
 * - 111 - 96 Words
 */
/*@{*/
#define BP_CSI_CSICR3_RxFF_LEVEL (4U)      /*!< Bit position for CSI_CSICR3_RxFF_LEVEL. */
#define BM_CSI_CSICR3_RxFF_LEVEL (0x00000070U) /*!< Bit mask for CSI_CSICR3_RxFF_LEVEL. */
#define BS_CSI_CSICR3_RxFF_LEVEL (3U)      /*!< Bit field size in bits for CSI_CSICR3_RxFF_LEVEL. */

/*! @brief Read current value of the CSI_CSICR3_RxFF_LEVEL field. */
#define BR_CSI_CSICR3_RxFF_LEVEL(x) (HW_CSI_CSICR3(x).B.RxFF_LEVEL)

/*! @brief Format value for bitfield CSI_CSICR3_RxFF_LEVEL. */
#define BF_CSI_CSICR3_RxFF_LEVEL(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_RxFF_LEVEL) & BM_CSI_CSICR3_RxFF_LEVEL)

/*! @brief Set the RxFF_LEVEL field to a new value. */
#define BW_CSI_CSICR3_RxFF_LEVEL(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_RxFF_LEVEL) | BF_CSI_CSICR3_RxFF_LEVEL(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field HRESP_ERR_EN[7] (RW)
 *
 * Hresponse Error Enable. This bit enables the hresponse error interrupt.
 *
 * Values:
 * - 0 - Disable hresponse error interrupt
 * - 1 - Enable hresponse error interrupt
 */
/*@{*/
#define BP_CSI_CSICR3_HRESP_ERR_EN (7U)    /*!< Bit position for CSI_CSICR3_HRESP_ERR_EN. */
#define BM_CSI_CSICR3_HRESP_ERR_EN (0x00000080U) /*!< Bit mask for CSI_CSICR3_HRESP_ERR_EN. */
#define BS_CSI_CSICR3_HRESP_ERR_EN (1U)    /*!< Bit field size in bits for CSI_CSICR3_HRESP_ERR_EN. */

/*! @brief Read current value of the CSI_CSICR3_HRESP_ERR_EN field. */
#define BR_CSI_CSICR3_HRESP_ERR_EN(x) (HW_CSI_CSICR3(x).B.HRESP_ERR_EN)

/*! @brief Format value for bitfield CSI_CSICR3_HRESP_ERR_EN. */
#define BF_CSI_CSICR3_HRESP_ERR_EN(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_HRESP_ERR_EN) & BM_CSI_CSICR3_HRESP_ERR_EN)

/*! @brief Set the HRESP_ERR_EN field to a new value. */
#define BW_CSI_CSICR3_HRESP_ERR_EN(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_HRESP_ERR_EN) | BF_CSI_CSICR3_HRESP_ERR_EN(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field STATFF_LEVEL[10:8] (RW)
 *
 * STATFIFO Full Level. When the number of data in STATFIFO reach this level,
 * STATFIFO full interrupt is generated, or STATFIFO DMA request is sent.
 *
 * Values:
 * - 000 - 4 Words
 * - 001 - 8 Words
 * - 010 - 12 Words
 * - 011 - 16 Words
 * - 100 - 24 Words
 * - 101 - 32 Words
 * - 110 - 48 Words
 * - 111 - 64 Words
 */
/*@{*/
#define BP_CSI_CSICR3_STATFF_LEVEL (8U)    /*!< Bit position for CSI_CSICR3_STATFF_LEVEL. */
#define BM_CSI_CSICR3_STATFF_LEVEL (0x00000700U) /*!< Bit mask for CSI_CSICR3_STATFF_LEVEL. */
#define BS_CSI_CSICR3_STATFF_LEVEL (3U)    /*!< Bit field size in bits for CSI_CSICR3_STATFF_LEVEL. */

/*! @brief Read current value of the CSI_CSICR3_STATFF_LEVEL field. */
#define BR_CSI_CSICR3_STATFF_LEVEL(x) (HW_CSI_CSICR3(x).B.STATFF_LEVEL)

/*! @brief Format value for bitfield CSI_CSICR3_STATFF_LEVEL. */
#define BF_CSI_CSICR3_STATFF_LEVEL(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_STATFF_LEVEL) & BM_CSI_CSICR3_STATFF_LEVEL)

/*! @brief Set the STATFF_LEVEL field to a new value. */
#define BW_CSI_CSICR3_STATFF_LEVEL(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_STATFF_LEVEL) | BF_CSI_CSICR3_STATFF_LEVEL(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field DMA_REQ_EN_SFF[11] (RW)
 *
 * DMA Request Enable for STATFIFO. This bit enables the dma request from
 * STATFIFO to the embedded DMA controller.
 *
 * Values:
 * - 0 - Disable the dma request
 * - 1 - Enable the dma request
 */
/*@{*/
#define BP_CSI_CSICR3_DMA_REQ_EN_SFF (11U) /*!< Bit position for CSI_CSICR3_DMA_REQ_EN_SFF. */
#define BM_CSI_CSICR3_DMA_REQ_EN_SFF (0x00000800U) /*!< Bit mask for CSI_CSICR3_DMA_REQ_EN_SFF. */
#define BS_CSI_CSICR3_DMA_REQ_EN_SFF (1U)  /*!< Bit field size in bits for CSI_CSICR3_DMA_REQ_EN_SFF. */

/*! @brief Read current value of the CSI_CSICR3_DMA_REQ_EN_SFF field. */
#define BR_CSI_CSICR3_DMA_REQ_EN_SFF(x) (HW_CSI_CSICR3(x).B.DMA_REQ_EN_SFF)

/*! @brief Format value for bitfield CSI_CSICR3_DMA_REQ_EN_SFF. */
#define BF_CSI_CSICR3_DMA_REQ_EN_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_DMA_REQ_EN_SFF) & BM_CSI_CSICR3_DMA_REQ_EN_SFF)

/*! @brief Set the DMA_REQ_EN_SFF field to a new value. */
#define BW_CSI_CSICR3_DMA_REQ_EN_SFF(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_DMA_REQ_EN_SFF) | BF_CSI_CSICR3_DMA_REQ_EN_SFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field DMA_REQ_EN_RFF[12] (RW)
 *
 * DMA Request Enable for RxFIFO. This bit enables the dma request from RxFIFO
 * to the embedded DMA controller.
 *
 * Values:
 * - 0 - Disable the dma request
 * - 1 - Enable the dma request
 */
/*@{*/
#define BP_CSI_CSICR3_DMA_REQ_EN_RFF (12U) /*!< Bit position for CSI_CSICR3_DMA_REQ_EN_RFF. */
#define BM_CSI_CSICR3_DMA_REQ_EN_RFF (0x00001000U) /*!< Bit mask for CSI_CSICR3_DMA_REQ_EN_RFF. */
#define BS_CSI_CSICR3_DMA_REQ_EN_RFF (1U)  /*!< Bit field size in bits for CSI_CSICR3_DMA_REQ_EN_RFF. */

/*! @brief Read current value of the CSI_CSICR3_DMA_REQ_EN_RFF field. */
#define BR_CSI_CSICR3_DMA_REQ_EN_RFF(x) (HW_CSI_CSICR3(x).B.DMA_REQ_EN_RFF)

/*! @brief Format value for bitfield CSI_CSICR3_DMA_REQ_EN_RFF. */
#define BF_CSI_CSICR3_DMA_REQ_EN_RFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_DMA_REQ_EN_RFF) & BM_CSI_CSICR3_DMA_REQ_EN_RFF)

/*! @brief Set the DMA_REQ_EN_RFF field to a new value. */
#define BW_CSI_CSICR3_DMA_REQ_EN_RFF(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_DMA_REQ_EN_RFF) | BF_CSI_CSICR3_DMA_REQ_EN_RFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field DMA_REFLASH_SFF[13] (RW)
 *
 * Reflash DMA Controller for STATFIFO. This bit reflash the embedded DMA
 * controller for STATFIFO. It should be reflashed before the embedded DMA controller
 * starts to work. (Cleared automatically after reflashing is done)
 *
 * Values:
 * - 0 - No reflashing
 * - 1 - Reflash the embedded DMA controller
 */
/*@{*/
#define BP_CSI_CSICR3_DMA_REFLASH_SFF (13U) /*!< Bit position for CSI_CSICR3_DMA_REFLASH_SFF. */
#define BM_CSI_CSICR3_DMA_REFLASH_SFF (0x00002000U) /*!< Bit mask for CSI_CSICR3_DMA_REFLASH_SFF. */
#define BS_CSI_CSICR3_DMA_REFLASH_SFF (1U) /*!< Bit field size in bits for CSI_CSICR3_DMA_REFLASH_SFF. */

/*! @brief Read current value of the CSI_CSICR3_DMA_REFLASH_SFF field. */
#define BR_CSI_CSICR3_DMA_REFLASH_SFF(x) (HW_CSI_CSICR3(x).B.DMA_REFLASH_SFF)

/*! @brief Format value for bitfield CSI_CSICR3_DMA_REFLASH_SFF. */
#define BF_CSI_CSICR3_DMA_REFLASH_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_DMA_REFLASH_SFF) & BM_CSI_CSICR3_DMA_REFLASH_SFF)

/*! @brief Set the DMA_REFLASH_SFF field to a new value. */
#define BW_CSI_CSICR3_DMA_REFLASH_SFF(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_DMA_REFLASH_SFF) | BF_CSI_CSICR3_DMA_REFLASH_SFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field DMA_REFLASH_RFF[14] (RW)
 *
 * Reflash DMA Controller for RxFIFO. This bit reflash the embedded DMA
 * controller for RxFIFO. It should be reflashed before the embedded DMA controller
 * starts to work. (Cleared automatically after reflashing is done)
 *
 * Values:
 * - 0 - No reflashing
 * - 1 - Reflash the embedded DMA controller
 */
/*@{*/
#define BP_CSI_CSICR3_DMA_REFLASH_RFF (14U) /*!< Bit position for CSI_CSICR3_DMA_REFLASH_RFF. */
#define BM_CSI_CSICR3_DMA_REFLASH_RFF (0x00004000U) /*!< Bit mask for CSI_CSICR3_DMA_REFLASH_RFF. */
#define BS_CSI_CSICR3_DMA_REFLASH_RFF (1U) /*!< Bit field size in bits for CSI_CSICR3_DMA_REFLASH_RFF. */

/*! @brief Read current value of the CSI_CSICR3_DMA_REFLASH_RFF field. */
#define BR_CSI_CSICR3_DMA_REFLASH_RFF(x) (HW_CSI_CSICR3(x).B.DMA_REFLASH_RFF)

/*! @brief Format value for bitfield CSI_CSICR3_DMA_REFLASH_RFF. */
#define BF_CSI_CSICR3_DMA_REFLASH_RFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_DMA_REFLASH_RFF) & BM_CSI_CSICR3_DMA_REFLASH_RFF)

/*! @brief Set the DMA_REFLASH_RFF field to a new value. */
#define BW_CSI_CSICR3_DMA_REFLASH_RFF(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_DMA_REFLASH_RFF) | BF_CSI_CSICR3_DMA_REFLASH_RFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field FRMCNT_RST[15] (RW)
 *
 * Frame Count Reset. Resets the Frame Counter. (Cleared automatically after
 * reset is done)
 *
 * Values:
 * - 0 - Do not reset
 * - 1 - Reset frame counter immediately
 */
/*@{*/
#define BP_CSI_CSICR3_FRMCNT_RST (15U)     /*!< Bit position for CSI_CSICR3_FRMCNT_RST. */
#define BM_CSI_CSICR3_FRMCNT_RST (0x00008000U) /*!< Bit mask for CSI_CSICR3_FRMCNT_RST. */
#define BS_CSI_CSICR3_FRMCNT_RST (1U)      /*!< Bit field size in bits for CSI_CSICR3_FRMCNT_RST. */

/*! @brief Read current value of the CSI_CSICR3_FRMCNT_RST field. */
#define BR_CSI_CSICR3_FRMCNT_RST(x) (HW_CSI_CSICR3(x).B.FRMCNT_RST)

/*! @brief Format value for bitfield CSI_CSICR3_FRMCNT_RST. */
#define BF_CSI_CSICR3_FRMCNT_RST(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_FRMCNT_RST) & BM_CSI_CSICR3_FRMCNT_RST)

/*! @brief Set the FRMCNT_RST field to a new value. */
#define BW_CSI_CSICR3_FRMCNT_RST(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_FRMCNT_RST) | BF_CSI_CSICR3_FRMCNT_RST(v)))
/*@}*/

/*!
 * @name Register CSI_CSICR3, field FRMCNT[31:16] (RW)
 *
 * Frame Counter. This is a 16-bit Frame Counter (Wraps around automatically
 * after reaching the maximum)
 */
/*@{*/
#define BP_CSI_CSICR3_FRMCNT (16U)         /*!< Bit position for CSI_CSICR3_FRMCNT. */
#define BM_CSI_CSICR3_FRMCNT (0xFFFF0000U) /*!< Bit mask for CSI_CSICR3_FRMCNT. */
#define BS_CSI_CSICR3_FRMCNT (16U)         /*!< Bit field size in bits for CSI_CSICR3_FRMCNT. */

/*! @brief Read current value of the CSI_CSICR3_FRMCNT field. */
#define BR_CSI_CSICR3_FRMCNT(x) (HW_CSI_CSICR3(x).B.FRMCNT)

/*! @brief Format value for bitfield CSI_CSICR3_FRMCNT. */
#define BF_CSI_CSICR3_FRMCNT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSICR3_FRMCNT) & BM_CSI_CSICR3_FRMCNT)

/*! @brief Set the FRMCNT field to a new value. */
#define BW_CSI_CSICR3_FRMCNT(x, v) (HW_CSI_CSICR3_WR(x, (HW_CSI_CSICR3_RD(x) & ~BM_CSI_CSICR3_FRMCNT) | BF_CSI_CSICR3_FRMCNT(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSISTATFIFO - CSI Statistic FIFO Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSISTATFIFO - CSI Statistic FIFO Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The StatFIFO is a read-only register containing statistic data from the
 * sensor. Writing to this register has no effect.
 */
typedef union _hw_csi_csistatfifo
{
    uint32_t U;
    struct _hw_csi_csistatfifo_bitfields
    {
        uint32_t STAT : 32;            /*!< [31:0]  */
    } B;
} hw_csi_csistatfifo_t;

/*!
 * @name Constants and macros for entire CSI_CSISTATFIFO register
 */
/*@{*/
#define HW_CSI_CSISTATFIFO_ADDR(x) ((uintptr_t)(x) + 0xCU)

#define HW_CSI_CSISTATFIFO(x)    (*(__I hw_csi_csistatfifo_t *) HW_CSI_CSISTATFIFO_ADDR(x))
#define HW_CSI_CSISTATFIFO_RD(x) (HW_CSI_CSISTATFIFO(x).U)
/*@}*/

/*
 * Constants & macros for individual CSI_CSISTATFIFO bitfields
 */

/*!
 * @name Register CSI_CSISTATFIFO, field STAT[31:0] (RO)
 *
 * Static data from sensor
 */
/*@{*/
#define BP_CSI_CSISTATFIFO_STAT (0U)       /*!< Bit position for CSI_CSISTATFIFO_STAT. */
#define BM_CSI_CSISTATFIFO_STAT (0xFFFFFFFFU) /*!< Bit mask for CSI_CSISTATFIFO_STAT. */
#define BS_CSI_CSISTATFIFO_STAT (32U)      /*!< Bit field size in bits for CSI_CSISTATFIFO_STAT. */

/*! @brief Read current value of the CSI_CSISTATFIFO_STAT field. */
#define BR_CSI_CSISTATFIFO_STAT(x) (HW_CSI_CSISTATFIFO(x).U)
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIRFIFO - CSI RX FIFO Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIRFIFO - CSI RX FIFO Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This read-only register contains received image data. Writing to this
 * register has no effect.
 */
typedef union _hw_csi_csirfifo
{
    uint32_t U;
    struct _hw_csi_csirfifo_bitfields
    {
        uint32_t IMAGE : 32;           /*!< [31:0]  */
    } B;
} hw_csi_csirfifo_t;

/*!
 * @name Constants and macros for entire CSI_CSIRFIFO register
 */
/*@{*/
#define HW_CSI_CSIRFIFO_ADDR(x)  ((uintptr_t)(x) + 0x10U)

#define HW_CSI_CSIRFIFO(x)       (*(__I hw_csi_csirfifo_t *) HW_CSI_CSIRFIFO_ADDR(x))
#define HW_CSI_CSIRFIFO_RD(x)    (HW_CSI_CSIRFIFO(x).U)
/*@}*/

/*
 * Constants & macros for individual CSI_CSIRFIFO bitfields
 */

/*!
 * @name Register CSI_CSIRFIFO, field IMAGE[31:0] (RO)
 *
 * Received image data
 */
/*@{*/
#define BP_CSI_CSIRFIFO_IMAGE (0U)         /*!< Bit position for CSI_CSIRFIFO_IMAGE. */
#define BM_CSI_CSIRFIFO_IMAGE (0xFFFFFFFFU) /*!< Bit mask for CSI_CSIRFIFO_IMAGE. */
#define BS_CSI_CSIRFIFO_IMAGE (32U)        /*!< Bit field size in bits for CSI_CSIRFIFO_IMAGE. */

/*! @brief Read current value of the CSI_CSIRFIFO_IMAGE field. */
#define BR_CSI_CSIRFIFO_IMAGE(x) (HW_CSI_CSIRFIFO(x).U)
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIRXCNT - CSI RX Count Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIRXCNT - CSI RX Count Register (RW)
 *
 * Reset value: 0x00009600U
 *
 * This register works for EOF interrupt generation. It should be set to the
 * number of words to receive that would generate an EOF interrupt. There is an
 * internal counter that counts the number of words read from the RX FIFO. Whenever
 * the RX FIFO is being read, by either the CPU or the embedded DMA controller,
 * the counter value is updated and compared with this register. If the values
 * match, then an EOF interrupt is triggered.
 */
typedef union _hw_csi_csirxcnt
{
    uint32_t U;
    struct _hw_csi_csirxcnt_bitfields
    {
        uint32_t RXCNT : 22;           /*!< [21:0]  */
        uint32_t RESERVED0 : 10;       /*!< [31:22]  */
    } B;
} hw_csi_csirxcnt_t;

/*!
 * @name Constants and macros for entire CSI_CSIRXCNT register
 */
/*@{*/
#define HW_CSI_CSIRXCNT_ADDR(x)  ((uintptr_t)(x) + 0x14U)

#define HW_CSI_CSIRXCNT(x)       (*(__IO hw_csi_csirxcnt_t *) HW_CSI_CSIRXCNT_ADDR(x))
#define HW_CSI_CSIRXCNT_RD(x)    (HW_CSI_CSIRXCNT(x).U)
#define HW_CSI_CSIRXCNT_WR(x, v) (HW_CSI_CSIRXCNT(x).U = (v))
#define HW_CSI_CSIRXCNT_SET(x, v) (HW_CSI_CSIRXCNT_WR(x, HW_CSI_CSIRXCNT_RD(x) |  (v)))
#define HW_CSI_CSIRXCNT_CLR(x, v) (HW_CSI_CSIRXCNT_WR(x, HW_CSI_CSIRXCNT_RD(x) & ~(v)))
#define HW_CSI_CSIRXCNT_TOG(x, v) (HW_CSI_CSIRXCNT_WR(x, HW_CSI_CSIRXCNT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIRXCNT bitfields
 */

/*!
 * @name Register CSI_CSIRXCNT, field RXCNT[21:0] (RW)
 *
 * RxFIFO Count. This 22-bit counter for RXFIFO is updated each time the RXFIFO
 * is read by CPU or DMA.This counter should be set to the expected number of
 * words to receive that would generate an EOF interrupt.
 */
/*@{*/
#define BP_CSI_CSIRXCNT_RXCNT (0U)         /*!< Bit position for CSI_CSIRXCNT_RXCNT. */
#define BM_CSI_CSIRXCNT_RXCNT (0x003FFFFFU) /*!< Bit mask for CSI_CSIRXCNT_RXCNT. */
#define BS_CSI_CSIRXCNT_RXCNT (22U)        /*!< Bit field size in bits for CSI_CSIRXCNT_RXCNT. */

/*! @brief Read current value of the CSI_CSIRXCNT_RXCNT field. */
#define BR_CSI_CSIRXCNT_RXCNT(x) (HW_CSI_CSIRXCNT(x).B.RXCNT)

/*! @brief Format value for bitfield CSI_CSIRXCNT_RXCNT. */
#define BF_CSI_CSIRXCNT_RXCNT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIRXCNT_RXCNT) & BM_CSI_CSIRXCNT_RXCNT)

/*! @brief Set the RXCNT field to a new value. */
#define BW_CSI_CSIRXCNT_RXCNT(x, v) (HW_CSI_CSIRXCNT_WR(x, (HW_CSI_CSIRXCNT_RD(x) & ~BM_CSI_CSIRXCNT_RXCNT) | BF_CSI_CSIRXCNT_RXCNT(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSISR - CSI Status Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSISR - CSI Status Register (RW)
 *
 * Reset value: 0x00004000U
 *
 * This read/write register shows sensor interface status, and which kind of
 * interrupt is being generated. The corresponding interrupt bits must be set for
 * the status bit to function. Status bits should function normally even if the
 * corresponding interrupt enable bits are not enabled.
 */
typedef union _hw_csi_csisr
{
    uint32_t U;
    struct _hw_csi_csisr_bitfields
    {
        uint32_t DRDY : 1;             /*!< [0]  */
        uint32_t ECC_INT : 1;          /*!< [1]  */
        uint32_t RESERVED0 : 5;        /*!< [6:2]  */
        uint32_t HRESP_ERR_INT : 1;    /*!< [7]  */
        uint32_t RESERVED1 : 5;        /*!< [12:8]  */
        uint32_t COF_INT : 1;          /*!< [13]  */
        uint32_t F1_INT : 1;           /*!< [14]  */
        uint32_t F2_INT : 1;           /*!< [15]  */
        uint32_t SOF_INT : 1;          /*!< [16]  */
        uint32_t EOF_INT : 1;          /*!< [17]  */
        uint32_t RxFF_INT : 1;         /*!< [18]  */
        uint32_t DMA_TSF_DONE_FB1 : 1; /*!< [19]  */
        uint32_t DMA_TSF_DONE_FB2 : 1; /*!< [20]  */
        uint32_t STATFF_INT : 1;       /*!< [21]  */
        uint32_t DMA_TSF_DONE_SFF : 1; /*!< [22]  */
        uint32_t RESERVED2 : 1;        /*!< [23]  */
        uint32_t RF_OR_INT : 1;        /*!< [24]  */
        uint32_t SF_OR_INT : 1;        /*!< [25]  */
        uint32_t RESERVED3 : 6;        /*!< [31:26]  */
    } B;
} hw_csi_csisr_t;

/*!
 * @name Constants and macros for entire CSI_CSISR register
 */
/*@{*/
#define HW_CSI_CSISR_ADDR(x)     ((uintptr_t)(x) + 0x18U)

#define HW_CSI_CSISR(x)          (*(__IO hw_csi_csisr_t *) HW_CSI_CSISR_ADDR(x))
#define HW_CSI_CSISR_RD(x)       (HW_CSI_CSISR(x).U)
#define HW_CSI_CSISR_WR(x, v)    (HW_CSI_CSISR(x).U = (v))
#define HW_CSI_CSISR_SET(x, v)   (HW_CSI_CSISR_WR(x, HW_CSI_CSISR_RD(x) |  (v)))
#define HW_CSI_CSISR_CLR(x, v)   (HW_CSI_CSISR_WR(x, HW_CSI_CSISR_RD(x) & ~(v)))
#define HW_CSI_CSISR_TOG(x, v)   (HW_CSI_CSISR_WR(x, HW_CSI_CSISR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSISR bitfields
 */

/*!
 * @name Register CSI_CSISR, field DRDY[0] (RW)
 *
 * RXFIFO Data Ready. Indicates the presence of data that is ready for transfer
 * in the RxFIFO. (Cleared automatically by reading FIFO)
 *
 * Values:
 * - 0 - No data (word) is ready
 * - 1 - At least 1 datum (word) is ready in RXFIFO.
 */
/*@{*/
#define BP_CSI_CSISR_DRDY    (0U)          /*!< Bit position for CSI_CSISR_DRDY. */
#define BM_CSI_CSISR_DRDY    (0x00000001U) /*!< Bit mask for CSI_CSISR_DRDY. */
#define BS_CSI_CSISR_DRDY    (1U)          /*!< Bit field size in bits for CSI_CSISR_DRDY. */

/*! @brief Read current value of the CSI_CSISR_DRDY field. */
#define BR_CSI_CSISR_DRDY(x) (HW_CSI_CSISR(x).B.DRDY)

/*! @brief Format value for bitfield CSI_CSISR_DRDY. */
#define BF_CSI_CSISR_DRDY(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_DRDY) & BM_CSI_CSISR_DRDY)

/*! @brief Set the DRDY field to a new value. */
#define BW_CSI_CSISR_DRDY(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_DRDY) | BF_CSI_CSISR_DRDY(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field ECC_INT[1] (RW)
 *
 * CCIR Error Interrupt. This bit indicates an error has occurred. This only
 * works in CCIR Interlace mode. (Cleared by writing 1)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - Error is detected in CCIR coding
 */
/*@{*/
#define BP_CSI_CSISR_ECC_INT (1U)          /*!< Bit position for CSI_CSISR_ECC_INT. */
#define BM_CSI_CSISR_ECC_INT (0x00000002U) /*!< Bit mask for CSI_CSISR_ECC_INT. */
#define BS_CSI_CSISR_ECC_INT (1U)          /*!< Bit field size in bits for CSI_CSISR_ECC_INT. */

/*! @brief Read current value of the CSI_CSISR_ECC_INT field. */
#define BR_CSI_CSISR_ECC_INT(x) (HW_CSI_CSISR(x).B.ECC_INT)

/*! @brief Format value for bitfield CSI_CSISR_ECC_INT. */
#define BF_CSI_CSISR_ECC_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_ECC_INT) & BM_CSI_CSISR_ECC_INT)

/*! @brief Set the ECC_INT field to a new value. */
#define BW_CSI_CSISR_ECC_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_ECC_INT) | BF_CSI_CSISR_ECC_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field HRESP_ERR_INT[7] (RW)
 *
 * Hresponse Error Interrupt Status. Indicates that a hresponse error has been
 * detected. (Cleared by writing 1)
 *
 * Values:
 * - 0 - No hresponse error.
 * - 1 - Hresponse error is detected.
 */
/*@{*/
#define BP_CSI_CSISR_HRESP_ERR_INT (7U)    /*!< Bit position for CSI_CSISR_HRESP_ERR_INT. */
#define BM_CSI_CSISR_HRESP_ERR_INT (0x00000080U) /*!< Bit mask for CSI_CSISR_HRESP_ERR_INT. */
#define BS_CSI_CSISR_HRESP_ERR_INT (1U)    /*!< Bit field size in bits for CSI_CSISR_HRESP_ERR_INT. */

/*! @brief Read current value of the CSI_CSISR_HRESP_ERR_INT field. */
#define BR_CSI_CSISR_HRESP_ERR_INT(x) (HW_CSI_CSISR(x).B.HRESP_ERR_INT)

/*! @brief Format value for bitfield CSI_CSISR_HRESP_ERR_INT. */
#define BF_CSI_CSISR_HRESP_ERR_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_HRESP_ERR_INT) & BM_CSI_CSISR_HRESP_ERR_INT)

/*! @brief Set the HRESP_ERR_INT field to a new value. */
#define BW_CSI_CSISR_HRESP_ERR_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_HRESP_ERR_INT) | BF_CSI_CSISR_HRESP_ERR_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field COF_INT[13] (RW)
 *
 * Change Of Field Interrupt Status. Indicates that a change of the video field
 * has been detected. Only works in CCIR Interlace mode. Software should read
 * this bit first and then dispatch the new field from F1_INT and F2_INT. (Cleared
 * by writing 1)
 *
 * Values:
 * - 0 - Video field has no change.
 * - 1 - Change of video field is detected.
 */
/*@{*/
#define BP_CSI_CSISR_COF_INT (13U)         /*!< Bit position for CSI_CSISR_COF_INT. */
#define BM_CSI_CSISR_COF_INT (0x00002000U) /*!< Bit mask for CSI_CSISR_COF_INT. */
#define BS_CSI_CSISR_COF_INT (1U)          /*!< Bit field size in bits for CSI_CSISR_COF_INT. */

/*! @brief Read current value of the CSI_CSISR_COF_INT field. */
#define BR_CSI_CSISR_COF_INT(x) (HW_CSI_CSISR(x).B.COF_INT)

/*! @brief Format value for bitfield CSI_CSISR_COF_INT. */
#define BF_CSI_CSISR_COF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_COF_INT) & BM_CSI_CSISR_COF_INT)

/*! @brief Set the COF_INT field to a new value. */
#define BW_CSI_CSISR_COF_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_COF_INT) | BF_CSI_CSISR_COF_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field F1_INT[14] (RW)
 *
 * CCIR Field 1 Interrupt Status. Indicates the presence of field 1 of video in
 * CCIR mode. (Cleared automatically when current field does not match) Only
 * works in CCIR Interlace mode.
 *
 * Values:
 * - 0 - Field 1 of video is not detected.
 * - 1 - Field 1 of video is about to start.
 */
/*@{*/
#define BP_CSI_CSISR_F1_INT  (14U)         /*!< Bit position for CSI_CSISR_F1_INT. */
#define BM_CSI_CSISR_F1_INT  (0x00004000U) /*!< Bit mask for CSI_CSISR_F1_INT. */
#define BS_CSI_CSISR_F1_INT  (1U)          /*!< Bit field size in bits for CSI_CSISR_F1_INT. */

/*! @brief Read current value of the CSI_CSISR_F1_INT field. */
#define BR_CSI_CSISR_F1_INT(x) (HW_CSI_CSISR(x).B.F1_INT)

/*! @brief Format value for bitfield CSI_CSISR_F1_INT. */
#define BF_CSI_CSISR_F1_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_F1_INT) & BM_CSI_CSISR_F1_INT)

/*! @brief Set the F1_INT field to a new value. */
#define BW_CSI_CSISR_F1_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_F1_INT) | BF_CSI_CSISR_F1_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field F2_INT[15] (RW)
 *
 * CCIR Field 2 Interrupt Status. Indicates the presence of field 2 of video in
 * CCIR mode. (Cleared automatically when current field does not match) Only
 * works in CCIR Interlace mode.
 *
 * Values:
 * - 0 - Field 2 of video is not detected
 * - 1 - Field 2 of video is about to start
 */
/*@{*/
#define BP_CSI_CSISR_F2_INT  (15U)         /*!< Bit position for CSI_CSISR_F2_INT. */
#define BM_CSI_CSISR_F2_INT  (0x00008000U) /*!< Bit mask for CSI_CSISR_F2_INT. */
#define BS_CSI_CSISR_F2_INT  (1U)          /*!< Bit field size in bits for CSI_CSISR_F2_INT. */

/*! @brief Read current value of the CSI_CSISR_F2_INT field. */
#define BR_CSI_CSISR_F2_INT(x) (HW_CSI_CSISR(x).B.F2_INT)

/*! @brief Format value for bitfield CSI_CSISR_F2_INT. */
#define BF_CSI_CSISR_F2_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_F2_INT) & BM_CSI_CSISR_F2_INT)

/*! @brief Set the F2_INT field to a new value. */
#define BW_CSI_CSISR_F2_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_F2_INT) | BF_CSI_CSISR_F2_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field SOF_INT[16] (RW)
 *
 * Start of Frame Interrupt Status. Indicates when SOF is detected. (Cleared by
 * writing 1)
 *
 * Values:
 * - 0 - SOF is not detected.
 * - 1 - SOF is detected.
 */
/*@{*/
#define BP_CSI_CSISR_SOF_INT (16U)         /*!< Bit position for CSI_CSISR_SOF_INT. */
#define BM_CSI_CSISR_SOF_INT (0x00010000U) /*!< Bit mask for CSI_CSISR_SOF_INT. */
#define BS_CSI_CSISR_SOF_INT (1U)          /*!< Bit field size in bits for CSI_CSISR_SOF_INT. */

/*! @brief Read current value of the CSI_CSISR_SOF_INT field. */
#define BR_CSI_CSISR_SOF_INT(x) (HW_CSI_CSISR(x).B.SOF_INT)

/*! @brief Format value for bitfield CSI_CSISR_SOF_INT. */
#define BF_CSI_CSISR_SOF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_SOF_INT) & BM_CSI_CSISR_SOF_INT)

/*! @brief Set the SOF_INT field to a new value. */
#define BW_CSI_CSISR_SOF_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_SOF_INT) | BF_CSI_CSISR_SOF_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field EOF_INT[17] (RW)
 *
 * End of Frame (EOF) Interrupt Status. Indicates when EOF is detected. (Cleared
 * by writing 1)
 *
 * Values:
 * - 0 - EOF is not detected.
 * - 1 - EOF is detected.
 */
/*@{*/
#define BP_CSI_CSISR_EOF_INT (17U)         /*!< Bit position for CSI_CSISR_EOF_INT. */
#define BM_CSI_CSISR_EOF_INT (0x00020000U) /*!< Bit mask for CSI_CSISR_EOF_INT. */
#define BS_CSI_CSISR_EOF_INT (1U)          /*!< Bit field size in bits for CSI_CSISR_EOF_INT. */

/*! @brief Read current value of the CSI_CSISR_EOF_INT field. */
#define BR_CSI_CSISR_EOF_INT(x) (HW_CSI_CSISR(x).B.EOF_INT)

/*! @brief Format value for bitfield CSI_CSISR_EOF_INT. */
#define BF_CSI_CSISR_EOF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_EOF_INT) & BM_CSI_CSISR_EOF_INT)

/*! @brief Set the EOF_INT field to a new value. */
#define BW_CSI_CSISR_EOF_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_EOF_INT) | BF_CSI_CSISR_EOF_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field RxFF_INT[18] (RW)
 *
 * RXFIFO Full Interrupt Status. Indicates the number of data in the RxFIFO
 * reaches the trigger level. (this bit is cleared automatically by reading the
 * RxFIFO)
 *
 * Values:
 * - 0 - RxFIFO is not full.
 * - 1 - RxFIFO is full.
 */
/*@{*/
#define BP_CSI_CSISR_RxFF_INT (18U)        /*!< Bit position for CSI_CSISR_RxFF_INT. */
#define BM_CSI_CSISR_RxFF_INT (0x00040000U) /*!< Bit mask for CSI_CSISR_RxFF_INT. */
#define BS_CSI_CSISR_RxFF_INT (1U)         /*!< Bit field size in bits for CSI_CSISR_RxFF_INT. */

/*! @brief Read current value of the CSI_CSISR_RxFF_INT field. */
#define BR_CSI_CSISR_RxFF_INT(x) (HW_CSI_CSISR(x).B.RxFF_INT)

/*! @brief Format value for bitfield CSI_CSISR_RxFF_INT. */
#define BF_CSI_CSISR_RxFF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_RxFF_INT) & BM_CSI_CSISR_RxFF_INT)

/*! @brief Set the RxFF_INT field to a new value. */
#define BW_CSI_CSISR_RxFF_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_RxFF_INT) | BF_CSI_CSISR_RxFF_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field DMA_TSF_DONE_FB1[19] (RW)
 *
 * DMA Transfer Done in Frame Buffer1. Indicates that the DMA transfer from
 * RxFIFO to Frame Buffer1 is completed. It can trigger an interrupt if the
 * corresponding enable bit is set in CSICR1. This bit can be cleared by by writting 1 or
 * reflashing the RxFIFO dma controller in CSICR3. (Cleared by writing 1)
 *
 * Values:
 * - 0 - DMA transfer is not completed.
 * - 1 - DMA transfer is completed.
 */
/*@{*/
#define BP_CSI_CSISR_DMA_TSF_DONE_FB1 (19U) /*!< Bit position for CSI_CSISR_DMA_TSF_DONE_FB1. */
#define BM_CSI_CSISR_DMA_TSF_DONE_FB1 (0x00080000U) /*!< Bit mask for CSI_CSISR_DMA_TSF_DONE_FB1. */
#define BS_CSI_CSISR_DMA_TSF_DONE_FB1 (1U) /*!< Bit field size in bits for CSI_CSISR_DMA_TSF_DONE_FB1. */

/*! @brief Read current value of the CSI_CSISR_DMA_TSF_DONE_FB1 field. */
#define BR_CSI_CSISR_DMA_TSF_DONE_FB1(x) (HW_CSI_CSISR(x).B.DMA_TSF_DONE_FB1)

/*! @brief Format value for bitfield CSI_CSISR_DMA_TSF_DONE_FB1. */
#define BF_CSI_CSISR_DMA_TSF_DONE_FB1(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_DMA_TSF_DONE_FB1) & BM_CSI_CSISR_DMA_TSF_DONE_FB1)

/*! @brief Set the DMA_TSF_DONE_FB1 field to a new value. */
#define BW_CSI_CSISR_DMA_TSF_DONE_FB1(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_DMA_TSF_DONE_FB1) | BF_CSI_CSISR_DMA_TSF_DONE_FB1(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field DMA_TSF_DONE_FB2[20] (RW)
 *
 * DMA Transfer Done in Frame Buffer2. Indicates that the DMA transfer from
 * RxFIFO to Frame Buffer2 is completed. It can trigger an interrupt if the
 * corresponding enable bit is set in CSICR1. This bit can be cleared by by writting 1 or
 * reflashing the RxFIFO dma controller in CSICR3. (Cleared by writing 1)
 *
 * Values:
 * - 0 - DMA transfer is not completed.
 * - 1 - DMA transfer is completed.
 */
/*@{*/
#define BP_CSI_CSISR_DMA_TSF_DONE_FB2 (20U) /*!< Bit position for CSI_CSISR_DMA_TSF_DONE_FB2. */
#define BM_CSI_CSISR_DMA_TSF_DONE_FB2 (0x00100000U) /*!< Bit mask for CSI_CSISR_DMA_TSF_DONE_FB2. */
#define BS_CSI_CSISR_DMA_TSF_DONE_FB2 (1U) /*!< Bit field size in bits for CSI_CSISR_DMA_TSF_DONE_FB2. */

/*! @brief Read current value of the CSI_CSISR_DMA_TSF_DONE_FB2 field. */
#define BR_CSI_CSISR_DMA_TSF_DONE_FB2(x) (HW_CSI_CSISR(x).B.DMA_TSF_DONE_FB2)

/*! @brief Format value for bitfield CSI_CSISR_DMA_TSF_DONE_FB2. */
#define BF_CSI_CSISR_DMA_TSF_DONE_FB2(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_DMA_TSF_DONE_FB2) & BM_CSI_CSISR_DMA_TSF_DONE_FB2)

/*! @brief Set the DMA_TSF_DONE_FB2 field to a new value. */
#define BW_CSI_CSISR_DMA_TSF_DONE_FB2(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_DMA_TSF_DONE_FB2) | BF_CSI_CSISR_DMA_TSF_DONE_FB2(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field STATFF_INT[21] (RW)
 *
 * STATFIFO Full Interrupt Status. Indicates the number of data in the STATFIFO
 * reaches the trigger level. (this bit is cleared automatically by reading the
 * STATFIFO)
 *
 * Values:
 * - 0 - STATFIFO is not full.
 * - 1 - STATFIFO is full.
 */
/*@{*/
#define BP_CSI_CSISR_STATFF_INT (21U)      /*!< Bit position for CSI_CSISR_STATFF_INT. */
#define BM_CSI_CSISR_STATFF_INT (0x00200000U) /*!< Bit mask for CSI_CSISR_STATFF_INT. */
#define BS_CSI_CSISR_STATFF_INT (1U)       /*!< Bit field size in bits for CSI_CSISR_STATFF_INT. */

/*! @brief Read current value of the CSI_CSISR_STATFF_INT field. */
#define BR_CSI_CSISR_STATFF_INT(x) (HW_CSI_CSISR(x).B.STATFF_INT)

/*! @brief Format value for bitfield CSI_CSISR_STATFF_INT. */
#define BF_CSI_CSISR_STATFF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_STATFF_INT) & BM_CSI_CSISR_STATFF_INT)

/*! @brief Set the STATFF_INT field to a new value. */
#define BW_CSI_CSISR_STATFF_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_STATFF_INT) | BF_CSI_CSISR_STATFF_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field DMA_TSF_DONE_SFF[22] (RW)
 *
 * DMA Transfer Done from StatFIFO. Indicates that the dma transfer from
 * StatFIFO is completed. It can trigger an interrupt if the corresponding enable bit is
 * set in CSICR1. This bit can be cleared by writting 1 or reflashing the
 * StatFIFO dma controller in CSICR3.(Cleared by writing 1)
 *
 * Values:
 * - 0 - DMA transfer is not completed.
 * - 1 - DMA transfer is completed.
 */
/*@{*/
#define BP_CSI_CSISR_DMA_TSF_DONE_SFF (22U) /*!< Bit position for CSI_CSISR_DMA_TSF_DONE_SFF. */
#define BM_CSI_CSISR_DMA_TSF_DONE_SFF (0x00400000U) /*!< Bit mask for CSI_CSISR_DMA_TSF_DONE_SFF. */
#define BS_CSI_CSISR_DMA_TSF_DONE_SFF (1U) /*!< Bit field size in bits for CSI_CSISR_DMA_TSF_DONE_SFF. */

/*! @brief Read current value of the CSI_CSISR_DMA_TSF_DONE_SFF field. */
#define BR_CSI_CSISR_DMA_TSF_DONE_SFF(x) (HW_CSI_CSISR(x).B.DMA_TSF_DONE_SFF)

/*! @brief Format value for bitfield CSI_CSISR_DMA_TSF_DONE_SFF. */
#define BF_CSI_CSISR_DMA_TSF_DONE_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_DMA_TSF_DONE_SFF) & BM_CSI_CSISR_DMA_TSF_DONE_SFF)

/*! @brief Set the DMA_TSF_DONE_SFF field to a new value. */
#define BW_CSI_CSISR_DMA_TSF_DONE_SFF(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_DMA_TSF_DONE_SFF) | BF_CSI_CSISR_DMA_TSF_DONE_SFF(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field RF_OR_INT[24] (RW)
 *
 * RxFIFO Overrun Interrupt Status. Indicates the overflow status of the RxFIFO
 * register. (Cleared by writing 1)
 *
 * Values:
 * - 0 - RXFIFO has not overflowed.
 * - 1 - RXFIFO has overflowed.
 */
/*@{*/
#define BP_CSI_CSISR_RF_OR_INT (24U)       /*!< Bit position for CSI_CSISR_RF_OR_INT. */
#define BM_CSI_CSISR_RF_OR_INT (0x01000000U) /*!< Bit mask for CSI_CSISR_RF_OR_INT. */
#define BS_CSI_CSISR_RF_OR_INT (1U)        /*!< Bit field size in bits for CSI_CSISR_RF_OR_INT. */

/*! @brief Read current value of the CSI_CSISR_RF_OR_INT field. */
#define BR_CSI_CSISR_RF_OR_INT(x) (HW_CSI_CSISR(x).B.RF_OR_INT)

/*! @brief Format value for bitfield CSI_CSISR_RF_OR_INT. */
#define BF_CSI_CSISR_RF_OR_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_RF_OR_INT) & BM_CSI_CSISR_RF_OR_INT)

/*! @brief Set the RF_OR_INT field to a new value. */
#define BW_CSI_CSISR_RF_OR_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_RF_OR_INT) | BF_CSI_CSISR_RF_OR_INT(v)))
/*@}*/

/*!
 * @name Register CSI_CSISR, field SF_OR_INT[25] (RW)
 *
 * STATFIFO Overrun Interrupt Status. Indicates the overflow status of the
 * STATFIFO register. (Cleared by writing 1)
 *
 * Values:
 * - 0 - STATFIFO has not overflowed.
 * - 1 - STATFIFO has overflowed.
 */
/*@{*/
#define BP_CSI_CSISR_SF_OR_INT (25U)       /*!< Bit position for CSI_CSISR_SF_OR_INT. */
#define BM_CSI_CSISR_SF_OR_INT (0x02000000U) /*!< Bit mask for CSI_CSISR_SF_OR_INT. */
#define BS_CSI_CSISR_SF_OR_INT (1U)        /*!< Bit field size in bits for CSI_CSISR_SF_OR_INT. */

/*! @brief Read current value of the CSI_CSISR_SF_OR_INT field. */
#define BR_CSI_CSISR_SF_OR_INT(x) (HW_CSI_CSISR(x).B.SF_OR_INT)

/*! @brief Format value for bitfield CSI_CSISR_SF_OR_INT. */
#define BF_CSI_CSISR_SF_OR_INT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSISR_SF_OR_INT) & BM_CSI_CSISR_SF_OR_INT)

/*! @brief Set the SF_OR_INT field to a new value. */
#define BW_CSI_CSISR_SF_OR_INT(x, v) (HW_CSI_CSISR_WR(x, (HW_CSI_CSISR_RD(x) & ~BM_CSI_CSISR_SF_OR_INT) | BF_CSI_CSISR_SF_OR_INT(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIDMASA_STATFIFO - CSI DMA Start Address Register - for STATFIFO
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIDMASA_STATFIFO - CSI DMA Start Address Register - for STATFIFO (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the start address for the embedded DMA controller of
 * STATFIFO. The embedded DMA controller will read data from STATFIFO and write it
 * to the external memory from the start address. This register should be
 * configured before activating or restarting the embedded DMA controller.
 */
typedef union _hw_csi_csidmasa_statfifo
{
    uint32_t U;
    struct _hw_csi_csidmasa_statfifo_bitfields
    {
        uint32_t RESERVED0 : 2;        /*!< [1:0]  */
        uint32_t DMA_START_ADDR_SFF : 30; /*!< [31:2]  */
    } B;
} hw_csi_csidmasa_statfifo_t;

/*!
 * @name Constants and macros for entire CSI_CSIDMASA_STATFIFO register
 */
/*@{*/
#define HW_CSI_CSIDMASA_STATFIFO_ADDR(x) ((uintptr_t)(x) + 0x20U)

#define HW_CSI_CSIDMASA_STATFIFO(x) (*(__IO hw_csi_csidmasa_statfifo_t *) HW_CSI_CSIDMASA_STATFIFO_ADDR(x))
#define HW_CSI_CSIDMASA_STATFIFO_RD(x) (HW_CSI_CSIDMASA_STATFIFO(x).U)
#define HW_CSI_CSIDMASA_STATFIFO_WR(x, v) (HW_CSI_CSIDMASA_STATFIFO(x).U = (v))
#define HW_CSI_CSIDMASA_STATFIFO_SET(x, v) (HW_CSI_CSIDMASA_STATFIFO_WR(x, HW_CSI_CSIDMASA_STATFIFO_RD(x) |  (v)))
#define HW_CSI_CSIDMASA_STATFIFO_CLR(x, v) (HW_CSI_CSIDMASA_STATFIFO_WR(x, HW_CSI_CSIDMASA_STATFIFO_RD(x) & ~(v)))
#define HW_CSI_CSIDMASA_STATFIFO_TOG(x, v) (HW_CSI_CSIDMASA_STATFIFO_WR(x, HW_CSI_CSIDMASA_STATFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIDMASA_STATFIFO bitfields
 */

/*!
 * @name Register CSI_CSIDMASA_STATFIFO, field DMA_START_ADDR_SFF[31:2] (RW)
 *
 * DMA Start Address for STATFIFO. Indicates the start address to write data.
 * The embedded DMA controller will read data from STATFIFO and write it from this
 * address through AHB bus. The address should be word aligned.
 */
/*@{*/
#define BP_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF (2U) /*!< Bit position for CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF. */
#define BM_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF (0xFFFFFFFCU) /*!< Bit mask for CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF. */
#define BS_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF (30U) /*!< Bit field size in bits for CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF. */

/*! @brief Read current value of the CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF field. */
#define BR_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(x) (HW_CSI_CSIDMASA_STATFIFO(x).B.DMA_START_ADDR_SFF)

/*! @brief Format value for bitfield CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF. */
#define BF_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF) & BM_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF)

/*! @brief Set the DMA_START_ADDR_SFF field to a new value. */
#define BW_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(x, v) (HW_CSI_CSIDMASA_STATFIFO_WR(x, (HW_CSI_CSIDMASA_STATFIFO_RD(x) & ~BM_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF) | BF_CSI_CSIDMASA_STATFIFO_DMA_START_ADDR_SFF(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIDMATS_STATFIFO - CSI DMA Transfer Size Register - for STATFIFO
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIDMATS_STATFIFO - CSI DMA Transfer Size Register - for STATFIFO (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the total transfer size for the embedded DMA
 * controller of STATFIFO. This register should be configured before activating or
 * restarting the embedded DMA controller.
 */
typedef union _hw_csi_csidmats_statfifo
{
    uint32_t U;
    struct _hw_csi_csidmats_statfifo_bitfields
    {
        uint32_t DMA_TSF_SIZE_SFF : 32; /*!< [31:0]  */
    } B;
} hw_csi_csidmats_statfifo_t;

/*!
 * @name Constants and macros for entire CSI_CSIDMATS_STATFIFO register
 */
/*@{*/
#define HW_CSI_CSIDMATS_STATFIFO_ADDR(x) ((uintptr_t)(x) + 0x24U)

#define HW_CSI_CSIDMATS_STATFIFO(x) (*(__IO hw_csi_csidmats_statfifo_t *) HW_CSI_CSIDMATS_STATFIFO_ADDR(x))
#define HW_CSI_CSIDMATS_STATFIFO_RD(x) (HW_CSI_CSIDMATS_STATFIFO(x).U)
#define HW_CSI_CSIDMATS_STATFIFO_WR(x, v) (HW_CSI_CSIDMATS_STATFIFO(x).U = (v))
#define HW_CSI_CSIDMATS_STATFIFO_SET(x, v) (HW_CSI_CSIDMATS_STATFIFO_WR(x, HW_CSI_CSIDMATS_STATFIFO_RD(x) |  (v)))
#define HW_CSI_CSIDMATS_STATFIFO_CLR(x, v) (HW_CSI_CSIDMATS_STATFIFO_WR(x, HW_CSI_CSIDMATS_STATFIFO_RD(x) & ~(v)))
#define HW_CSI_CSIDMATS_STATFIFO_TOG(x, v) (HW_CSI_CSIDMATS_STATFIFO_WR(x, HW_CSI_CSIDMATS_STATFIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIDMATS_STATFIFO bitfields
 */

/*!
 * @name Register CSI_CSIDMATS_STATFIFO, field DMA_TSF_SIZE_SFF[31:0] (RW)
 *
 * DMA Transfer Size for STATFIFO. Indicates how many words to be transfered by
 * the embedded DMA controller. The size should be word aligned.
 */
/*@{*/
#define BP_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF (0U) /*!< Bit position for CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF. */
#define BM_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF (0xFFFFFFFFU) /*!< Bit mask for CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF. */
#define BS_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF (32U) /*!< Bit field size in bits for CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF. */

/*! @brief Read current value of the CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF field. */
#define BR_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF(x) (HW_CSI_CSIDMATS_STATFIFO(x).U)

/*! @brief Format value for bitfield CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF. */
#define BF_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF) & BM_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF)

/*! @brief Set the DMA_TSF_SIZE_SFF field to a new value. */
#define BW_CSI_CSIDMATS_STATFIFO_DMA_TSF_SIZE_SFF(x, v) (HW_CSI_CSIDMATS_STATFIFO_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIDMASA_FB1 - CSI DMA Start Address Register - for Frame Buffer1
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIDMASA_FB1 - CSI DMA Start Address Register - for Frame Buffer1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the start address in the frame buffer1 for the
 * embedded DMA controller of RxFIFO. The embedded DMA controller will read data from
 * RxFIFO and write it to the frame buffer1 from the start address. This register
 * should be configured before activating or restarting the embedded DMA
 * controller.
 */
typedef union _hw_csi_csidmasa_fb1
{
    uint32_t U;
    struct _hw_csi_csidmasa_fb1_bitfields
    {
        uint32_t RESERVED0 : 2;        /*!< [1:0]  */
        uint32_t DMA_START_ADDR_FB1 : 30; /*!< [31:2]  */
    } B;
} hw_csi_csidmasa_fb1_t;

/*!
 * @name Constants and macros for entire CSI_CSIDMASA_FB1 register
 */
/*@{*/
#define HW_CSI_CSIDMASA_FB1_ADDR(x) ((uintptr_t)(x) + 0x28U)

#define HW_CSI_CSIDMASA_FB1(x)   (*(__IO hw_csi_csidmasa_fb1_t *) HW_CSI_CSIDMASA_FB1_ADDR(x))
#define HW_CSI_CSIDMASA_FB1_RD(x) (HW_CSI_CSIDMASA_FB1(x).U)
#define HW_CSI_CSIDMASA_FB1_WR(x, v) (HW_CSI_CSIDMASA_FB1(x).U = (v))
#define HW_CSI_CSIDMASA_FB1_SET(x, v) (HW_CSI_CSIDMASA_FB1_WR(x, HW_CSI_CSIDMASA_FB1_RD(x) |  (v)))
#define HW_CSI_CSIDMASA_FB1_CLR(x, v) (HW_CSI_CSIDMASA_FB1_WR(x, HW_CSI_CSIDMASA_FB1_RD(x) & ~(v)))
#define HW_CSI_CSIDMASA_FB1_TOG(x, v) (HW_CSI_CSIDMASA_FB1_WR(x, HW_CSI_CSIDMASA_FB1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIDMASA_FB1 bitfields
 */

/*!
 * @name Register CSI_CSIDMASA_FB1, field DMA_START_ADDR_FB1[31:2] (RW)
 *
 * DMA Start Address in Frame Buffer1. Indicates the start address to write
 * data. The embedded DMA controller will read data from RxFIFO and write it from
 * this address through AHB bus. The address should be word aligned.
 */
/*@{*/
#define BP_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1 (2U) /*!< Bit position for CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1. */
#define BM_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1 (0xFFFFFFFCU) /*!< Bit mask for CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1. */
#define BS_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1 (30U) /*!< Bit field size in bits for CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1. */

/*! @brief Read current value of the CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1 field. */
#define BR_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(x) (HW_CSI_CSIDMASA_FB1(x).B.DMA_START_ADDR_FB1)

/*! @brief Format value for bitfield CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1. */
#define BF_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1) & BM_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1)

/*! @brief Set the DMA_START_ADDR_FB1 field to a new value. */
#define BW_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(x, v) (HW_CSI_CSIDMASA_FB1_WR(x, (HW_CSI_CSIDMASA_FB1_RD(x) & ~BM_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1) | BF_CSI_CSIDMASA_FB1_DMA_START_ADDR_FB1(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIDMASA_FB2 - CSI DMA Transfer Size Register - for Frame Buffer2
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIDMASA_FB2 - CSI DMA Transfer Size Register - for Frame Buffer2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the start address in the frame buffer2 for the
 * embedded DMA controller of RxFIFO. The embedded DMA controller will read data from
 * RxFIFO and write it to the frame buffer2 from the start address. This register
 * should be configured before activating or restarting the embedded DMA
 * controller.
 */
typedef union _hw_csi_csidmasa_fb2
{
    uint32_t U;
    struct _hw_csi_csidmasa_fb2_bitfields
    {
        uint32_t RESERVED0 : 2;        /*!< [1:0]  */
        uint32_t DMA_START_ADDR_FB2 : 30; /*!< [31:2]  */
    } B;
} hw_csi_csidmasa_fb2_t;

/*!
 * @name Constants and macros for entire CSI_CSIDMASA_FB2 register
 */
/*@{*/
#define HW_CSI_CSIDMASA_FB2_ADDR(x) ((uintptr_t)(x) + 0x2CU)

#define HW_CSI_CSIDMASA_FB2(x)   (*(__IO hw_csi_csidmasa_fb2_t *) HW_CSI_CSIDMASA_FB2_ADDR(x))
#define HW_CSI_CSIDMASA_FB2_RD(x) (HW_CSI_CSIDMASA_FB2(x).U)
#define HW_CSI_CSIDMASA_FB2_WR(x, v) (HW_CSI_CSIDMASA_FB2(x).U = (v))
#define HW_CSI_CSIDMASA_FB2_SET(x, v) (HW_CSI_CSIDMASA_FB2_WR(x, HW_CSI_CSIDMASA_FB2_RD(x) |  (v)))
#define HW_CSI_CSIDMASA_FB2_CLR(x, v) (HW_CSI_CSIDMASA_FB2_WR(x, HW_CSI_CSIDMASA_FB2_RD(x) & ~(v)))
#define HW_CSI_CSIDMASA_FB2_TOG(x, v) (HW_CSI_CSIDMASA_FB2_WR(x, HW_CSI_CSIDMASA_FB2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIDMASA_FB2 bitfields
 */

/*!
 * @name Register CSI_CSIDMASA_FB2, field DMA_START_ADDR_FB2[31:2] (RW)
 *
 * DMA Start Address in Frame Buffer2. Indicates the start address to write
 * data. The embedded DMA controller will read data from RxFIFO and write it from
 * this address through AHB bus. The address should be word aligned.
 */
/*@{*/
#define BP_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2 (2U) /*!< Bit position for CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2. */
#define BM_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2 (0xFFFFFFFCU) /*!< Bit mask for CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2. */
#define BS_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2 (30U) /*!< Bit field size in bits for CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2. */

/*! @brief Read current value of the CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2 field. */
#define BR_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(x) (HW_CSI_CSIDMASA_FB2(x).B.DMA_START_ADDR_FB2)

/*! @brief Format value for bitfield CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2. */
#define BF_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2) & BM_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2)

/*! @brief Set the DMA_START_ADDR_FB2 field to a new value. */
#define BW_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(x, v) (HW_CSI_CSIDMASA_FB2_WR(x, (HW_CSI_CSIDMASA_FB2_RD(x) & ~BM_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2) | BF_CSI_CSIDMASA_FB2_DMA_START_ADDR_FB2(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIFBUF_PARA - CSI Frame Buffer Parameter Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIFBUF_PARA - CSI Frame Buffer Parameter Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the stride of the frame buffer to show how many words
 * to skip before starting to write the next row of the image. The width of the
 * frame buffer minus the width of the image is the stride. This register should
 * be configured before activating or restarting the embedded DMA controller.
 */
typedef union _hw_csi_csifbuf_para
{
    uint32_t U;
    struct _hw_csi_csifbuf_para_bitfields
    {
        uint32_t FBUF_STRIDE : 16;     /*!< [15:0]  */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_csi_csifbuf_para_t;

/*!
 * @name Constants and macros for entire CSI_CSIFBUF_PARA register
 */
/*@{*/
#define HW_CSI_CSIFBUF_PARA_ADDR(x) ((uintptr_t)(x) + 0x30U)

#define HW_CSI_CSIFBUF_PARA(x)   (*(__IO hw_csi_csifbuf_para_t *) HW_CSI_CSIFBUF_PARA_ADDR(x))
#define HW_CSI_CSIFBUF_PARA_RD(x) (HW_CSI_CSIFBUF_PARA(x).U)
#define HW_CSI_CSIFBUF_PARA_WR(x, v) (HW_CSI_CSIFBUF_PARA(x).U = (v))
#define HW_CSI_CSIFBUF_PARA_SET(x, v) (HW_CSI_CSIFBUF_PARA_WR(x, HW_CSI_CSIFBUF_PARA_RD(x) |  (v)))
#define HW_CSI_CSIFBUF_PARA_CLR(x, v) (HW_CSI_CSIFBUF_PARA_WR(x, HW_CSI_CSIFBUF_PARA_RD(x) & ~(v)))
#define HW_CSI_CSIFBUF_PARA_TOG(x, v) (HW_CSI_CSIFBUF_PARA_WR(x, HW_CSI_CSIFBUF_PARA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIFBUF_PARA bitfields
 */

/*!
 * @name Register CSI_CSIFBUF_PARA, field FBUF_STRIDE[15:0] (RW)
 *
 * Frame Buffer Parameter. Indicates the stride of the frame buffer. The width
 * of the frame buffer(in word) minus the width of the image(in word) is the
 * stride. The stride should be word aligned. The embedded DMA controller will skip
 * the stride before starting to write the next row of the image.
 */
/*@{*/
#define BP_CSI_CSIFBUF_PARA_FBUF_STRIDE (0U) /*!< Bit position for CSI_CSIFBUF_PARA_FBUF_STRIDE. */
#define BM_CSI_CSIFBUF_PARA_FBUF_STRIDE (0x0000FFFFU) /*!< Bit mask for CSI_CSIFBUF_PARA_FBUF_STRIDE. */
#define BS_CSI_CSIFBUF_PARA_FBUF_STRIDE (16U) /*!< Bit field size in bits for CSI_CSIFBUF_PARA_FBUF_STRIDE. */

/*! @brief Read current value of the CSI_CSIFBUF_PARA_FBUF_STRIDE field. */
#define BR_CSI_CSIFBUF_PARA_FBUF_STRIDE(x) (HW_CSI_CSIFBUF_PARA(x).B.FBUF_STRIDE)

/*! @brief Format value for bitfield CSI_CSIFBUF_PARA_FBUF_STRIDE. */
#define BF_CSI_CSIFBUF_PARA_FBUF_STRIDE(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIFBUF_PARA_FBUF_STRIDE) & BM_CSI_CSIFBUF_PARA_FBUF_STRIDE)

/*! @brief Set the FBUF_STRIDE field to a new value. */
#define BW_CSI_CSIFBUF_PARA_FBUF_STRIDE(x, v) (HW_CSI_CSIFBUF_PARA_WR(x, (HW_CSI_CSIFBUF_PARA_RD(x) & ~BM_CSI_CSIFBUF_PARA_FBUF_STRIDE) | BF_CSI_CSIFBUF_PARA_FBUF_STRIDE(v)))
/*@}*/

/*******************************************************************************
 * HW_CSI_CSIIMAG_PARA - CSI Image Parameter Register
 ******************************************************************************/

/*!
 * @brief HW_CSI_CSIIMAG_PARA - CSI Image Parameter Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides the width and the height of the image from the sensor.
 * The width and height should be aligned in pixel. The width of the image
 * multiplied by the height is the total pixel size that will be transfered in a frame
 * by the embedded DMA controller. This register should be configured before
 * activating or restarting the embedded DMA controller.
 */
typedef union _hw_csi_csiimag_para
{
    uint32_t U;
    struct _hw_csi_csiimag_para_bitfields
    {
        uint32_t IMAGE_HEIGHT : 16;    /*!< [15:0]  */
        uint32_t IMAGE_WIDTH : 16;     /*!< [31:16]  */
    } B;
} hw_csi_csiimag_para_t;

/*!
 * @name Constants and macros for entire CSI_CSIIMAG_PARA register
 */
/*@{*/
#define HW_CSI_CSIIMAG_PARA_ADDR(x) ((uintptr_t)(x) + 0x34U)

#define HW_CSI_CSIIMAG_PARA(x)   (*(__IO hw_csi_csiimag_para_t *) HW_CSI_CSIIMAG_PARA_ADDR(x))
#define HW_CSI_CSIIMAG_PARA_RD(x) (HW_CSI_CSIIMAG_PARA(x).U)
#define HW_CSI_CSIIMAG_PARA_WR(x, v) (HW_CSI_CSIIMAG_PARA(x).U = (v))
#define HW_CSI_CSIIMAG_PARA_SET(x, v) (HW_CSI_CSIIMAG_PARA_WR(x, HW_CSI_CSIIMAG_PARA_RD(x) |  (v)))
#define HW_CSI_CSIIMAG_PARA_CLR(x, v) (HW_CSI_CSIIMAG_PARA_WR(x, HW_CSI_CSIIMAG_PARA_RD(x) & ~(v)))
#define HW_CSI_CSIIMAG_PARA_TOG(x, v) (HW_CSI_CSIIMAG_PARA_WR(x, HW_CSI_CSIIMAG_PARA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CSI_CSIIMAG_PARA bitfields
 */

/*!
 * @name Register CSI_CSIIMAG_PARA, field IMAGE_HEIGHT[15:0] (RW)
 *
 * Image Height. Indicates how many pixels in a column of the image from the
 * sensor.
 */
/*@{*/
#define BP_CSI_CSIIMAG_PARA_IMAGE_HEIGHT (0U) /*!< Bit position for CSI_CSIIMAG_PARA_IMAGE_HEIGHT. */
#define BM_CSI_CSIIMAG_PARA_IMAGE_HEIGHT (0x0000FFFFU) /*!< Bit mask for CSI_CSIIMAG_PARA_IMAGE_HEIGHT. */
#define BS_CSI_CSIIMAG_PARA_IMAGE_HEIGHT (16U) /*!< Bit field size in bits for CSI_CSIIMAG_PARA_IMAGE_HEIGHT. */

/*! @brief Read current value of the CSI_CSIIMAG_PARA_IMAGE_HEIGHT field. */
#define BR_CSI_CSIIMAG_PARA_IMAGE_HEIGHT(x) (HW_CSI_CSIIMAG_PARA(x).B.IMAGE_HEIGHT)

/*! @brief Format value for bitfield CSI_CSIIMAG_PARA_IMAGE_HEIGHT. */
#define BF_CSI_CSIIMAG_PARA_IMAGE_HEIGHT(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIIMAG_PARA_IMAGE_HEIGHT) & BM_CSI_CSIIMAG_PARA_IMAGE_HEIGHT)

/*! @brief Set the IMAGE_HEIGHT field to a new value. */
#define BW_CSI_CSIIMAG_PARA_IMAGE_HEIGHT(x, v) (HW_CSI_CSIIMAG_PARA_WR(x, (HW_CSI_CSIIMAG_PARA_RD(x) & ~BM_CSI_CSIIMAG_PARA_IMAGE_HEIGHT) | BF_CSI_CSIIMAG_PARA_IMAGE_HEIGHT(v)))
/*@}*/

/*!
 * @name Register CSI_CSIIMAG_PARA, field IMAGE_WIDTH[31:16] (RW)
 *
 * Image Width. Indicates how many pixels in a line of the image from the
 * sensor. If the input data from the sensor is 8-bit/pixel format, the IMAGE_WIDTH
 * should be a multiple of 4 pixels. If the input data from the sensor is
 * 10-bit/pixel or 16-bit/pixel format, the IMAGE_WIDTH should be a multiple of 2 pixels.
 */
/*@{*/
#define BP_CSI_CSIIMAG_PARA_IMAGE_WIDTH (16U) /*!< Bit position for CSI_CSIIMAG_PARA_IMAGE_WIDTH. */
#define BM_CSI_CSIIMAG_PARA_IMAGE_WIDTH (0xFFFF0000U) /*!< Bit mask for CSI_CSIIMAG_PARA_IMAGE_WIDTH. */
#define BS_CSI_CSIIMAG_PARA_IMAGE_WIDTH (16U) /*!< Bit field size in bits for CSI_CSIIMAG_PARA_IMAGE_WIDTH. */

/*! @brief Read current value of the CSI_CSIIMAG_PARA_IMAGE_WIDTH field. */
#define BR_CSI_CSIIMAG_PARA_IMAGE_WIDTH(x) (HW_CSI_CSIIMAG_PARA(x).B.IMAGE_WIDTH)

/*! @brief Format value for bitfield CSI_CSIIMAG_PARA_IMAGE_WIDTH. */
#define BF_CSI_CSIIMAG_PARA_IMAGE_WIDTH(v) ((uint32_t)((uint32_t)(v) << BP_CSI_CSIIMAG_PARA_IMAGE_WIDTH) & BM_CSI_CSIIMAG_PARA_IMAGE_WIDTH)

/*! @brief Set the IMAGE_WIDTH field to a new value. */
#define BW_CSI_CSIIMAG_PARA_IMAGE_WIDTH(x, v) (HW_CSI_CSIIMAG_PARA_WR(x, (HW_CSI_CSIIMAG_PARA_RD(x) & ~BM_CSI_CSIIMAG_PARA_IMAGE_WIDTH) | BF_CSI_CSIIMAG_PARA_IMAGE_WIDTH(v)))
/*@}*/

/*******************************************************************************
 * hw_csi_t - module struct
 ******************************************************************************/
/*!
 * @brief All CSI module registers.
 */
#pragma pack(1)
typedef struct _hw_csi
{
    __IO hw_csi_csicr1_t CSICR1;           /*!< [0x0] CSI Control Register 1 */
    __IO hw_csi_csicr2_t CSICR2;           /*!< [0x4] CSI Control Register 2 */
    __IO hw_csi_csicr3_t CSICR3;           /*!< [0x8] CSI Control Register 3 */
    __I hw_csi_csistatfifo_t CSISTATFIFO;  /*!< [0xC] CSI Statistic FIFO Register */
    __I hw_csi_csirfifo_t CSIRFIFO;        /*!< [0x10] CSI RX FIFO Register */
    __IO hw_csi_csirxcnt_t CSIRXCNT;       /*!< [0x14] CSI RX Count Register */
    __IO hw_csi_csisr_t CSISR;             /*!< [0x18] CSI Status Register */
    uint8_t _reserved0[4];
    __IO hw_csi_csidmasa_statfifo_t CSIDMASA_STATFIFO; /*!< [0x20] CSI DMA Start Address Register - for STATFIFO */
    __IO hw_csi_csidmats_statfifo_t CSIDMATS_STATFIFO; /*!< [0x24] CSI DMA Transfer Size Register - for STATFIFO */
    __IO hw_csi_csidmasa_fb1_t CSIDMASA_FB1; /*!< [0x28] CSI DMA Start Address Register - for Frame Buffer1 */
    __IO hw_csi_csidmasa_fb2_t CSIDMASA_FB2; /*!< [0x2C] CSI DMA Transfer Size Register - for Frame Buffer2 */
    __IO hw_csi_csifbuf_para_t CSIFBUF_PARA; /*!< [0x30] CSI Frame Buffer Parameter Register */
    __IO hw_csi_csiimag_para_t CSIIMAG_PARA; /*!< [0x34] CSI Image Parameter Register */
} hw_csi_t;
#pragma pack()

/*! @brief Macro to access all CSI registers. */
/*! @param x CSI module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CSI_REGS(CSI_BASE)</code>. */
#define HW_CSI_REGS(x) (*(hw_csi_t *)(x))

/*
 * iMX6SL DBGMON
 *
 * DBGMON
 *
 * Registers defined in this header file:
 * - HW_DBGMON_HW_DBGMON_CTRL - HW_DBGMON_CTRL
 * - HW_DBGMON_HW_DBGMON_MASTER_EN - HW_DBGMON_MASTER_EN
 * - HW_DBGMON_HW_DBGMON_IRQ - HW_DBGMON_IRQ
 * - HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW - HW_DBGMON_TRAP_ADDR_LOW
 * - HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH - HW_DBGMON_TRAP_ADDR_HIGH
 * - HW_DBGMON_HW_DBGMON_TRAP_ID - HW_DBGMON_TRAP_ID
 * - HW_DBGMON_HW_DBGMON_SNVS_ADDR - HW_DBGMON_SNVS_ADDR
 * - HW_DBGMON_HW_DBGMON_SNVS_DATA - HW_DBGMON_SNVS_DATA
 * - HW_DBGMON_HW_DBGMON_SNVS_INFO - HW_DBGMON_SNVS_INFO
 * - HW_DBGMON_HW_DBGMON_VERSION - HW_DBGMON_VERSION
 *
 * - hw_dbgmon_t - Struct containing all module registers.
 */

#define HW_DBGMON_INSTANCE_COUNT (1U) /*!< Number of instances of the DBGMON module. */
#define HW_DBGMON (0U) /*!< Instance number for DBGMON. */
#define DBGMON_BASE           (0x2090000U) /*!< Base address for DBGMON. */
/*! Array initializer of DBGMON base addresses. */
#define DBGMON_BASE_ADDRS     { DBGMON_BASE }

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_CTRL - HW_DBGMON_CTRL
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_CTRL - HW_DBGMON_CTRL (RW)
 *
 * Reset value: 0xC0000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_ctrl
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_ctrl_bitfields
    {
        uint32_t RUN : 1;              /*!< [0]  */
        uint32_t SNAP : 1;             /*!< [1]  */
        uint32_t CLR : 1;              /*!< [2]  */
        uint32_t CLR_SNVS : 1;         /*!< [3]  */
        uint32_t ADDR_TRAPMODE : 1;    /*!< [4]  */
        uint32_t ID_TRAPMODE : 1;      /*!< [5]  */
        uint32_t RSVD0 : 2;            /*!< [7:6]  */
        uint32_t REQSEL : 2;           /*!< [9:8]  */
        uint32_t RSVD1 : 6;            /*!< [15:10]  */
        uint32_t WORKMODE : 1;         /*!< [16]  */
        uint32_t RSVD2 : 3;            /*!< [19:17]  */
        uint32_t ADDR_MASKEN : 1;      /*!< [20]  */
        uint32_t RSVD3 : 3;            /*!< [23:21]  */
        uint32_t WDOG_IRQ_SEL : 1;     /*!< [24]  */
        uint32_t RSVD4 : 5;            /*!< [29:25]  */
        uint32_t CLKGATE : 1;          /*!< [30]  */
        uint32_t SFTRST : 1;           /*!< [31]  */
    } B;
} hw_dbgmon_hw_dbgmon_ctrl_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_CTRL register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_CTRL_ADDR(x) ((uintptr_t)(x) + 0x2090000U)

#define HW_DBGMON_HW_DBGMON_CTRL(x) (*(__IO hw_dbgmon_hw_dbgmon_ctrl_t *) HW_DBGMON_HW_DBGMON_CTRL_ADDR(x))
#define HW_DBGMON_HW_DBGMON_CTRL_RD(x) (HW_DBGMON_HW_DBGMON_CTRL(x).U)
#define HW_DBGMON_HW_DBGMON_CTRL_WR(x, v) (HW_DBGMON_HW_DBGMON_CTRL(x).U = (v))
#define HW_DBGMON_HW_DBGMON_CTRL_SET(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, HW_DBGMON_HW_DBGMON_CTRL_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_CTRL_CLR(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_CTRL_TOG(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, HW_DBGMON_HW_DBGMON_CTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_CTRL bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RUN[0] (RW)
 *
 * Set this bit to one to enable the DBGMON operation
 *
 * Values:
 * - 0 - HALT, DBGMON is in halt status
 * - 1 - RUN, DBGMON is in working status
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RUN (0U)  /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RUN. */
#define BM_DBGMON_HW_DBGMON_CTRL_RUN (0x00000001U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RUN. */
#define BS_DBGMON_HW_DBGMON_CTRL_RUN (1U)  /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RUN. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RUN field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RUN(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RUN)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RUN. */
#define BF_DBGMON_HW_DBGMON_CTRL_RUN(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RUN) & BM_DBGMON_HW_DBGMON_CTRL_RUN)

/*! @brief Set the RUN field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RUN(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RUN) | BF_DBGMON_HW_DBGMON_CTRL_RUN(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field SNAP[1] (RW)
 *
 * Set this bit to snapshot the registers selected by REQSEL to SNVS domain
 * registers
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_SNAP (1U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_SNAP. */
#define BM_DBGMON_HW_DBGMON_CTRL_SNAP (0x00000002U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_SNAP. */
#define BS_DBGMON_HW_DBGMON_CTRL_SNAP (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_SNAP. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_SNAP field. */
#define BR_DBGMON_HW_DBGMON_CTRL_SNAP(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.SNAP)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_SNAP. */
#define BF_DBGMON_HW_DBGMON_CTRL_SNAP(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_SNAP) & BM_DBGMON_HW_DBGMON_CTRL_SNAP)

/*! @brief Set the SNAP field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_SNAP(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_SNAP) | BF_DBGMON_HW_DBGMON_CTRL_SNAP(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field CLR[2] (RW)
 *
 * Set this bit to clear the registers in SOC domain. This bit will be
 * automatically set to 0 once the clear process is done
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_CLR (2U)  /*!< Bit position for DBGMON_HW_DBGMON_CTRL_CLR. */
#define BM_DBGMON_HW_DBGMON_CTRL_CLR (0x00000004U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_CLR. */
#define BS_DBGMON_HW_DBGMON_CTRL_CLR (1U)  /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_CLR. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_CLR field. */
#define BR_DBGMON_HW_DBGMON_CTRL_CLR(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.CLR)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_CLR. */
#define BF_DBGMON_HW_DBGMON_CTRL_CLR(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_CLR) & BM_DBGMON_HW_DBGMON_CTRL_CLR)

/*! @brief Set the CLR field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_CLR(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_CLR) | BF_DBGMON_HW_DBGMON_CTRL_CLR(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field CLR_SNVS[3] (RW)
 *
 * Set this bit to clear the registers in SNVS domain
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_CLR_SNVS (3U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_CLR_SNVS. */
#define BM_DBGMON_HW_DBGMON_CTRL_CLR_SNVS (0x00000008U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_CLR_SNVS. */
#define BS_DBGMON_HW_DBGMON_CTRL_CLR_SNVS (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_CLR_SNVS. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_CLR_SNVS field. */
#define BR_DBGMON_HW_DBGMON_CTRL_CLR_SNVS(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.CLR_SNVS)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_CLR_SNVS. */
#define BF_DBGMON_HW_DBGMON_CTRL_CLR_SNVS(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_CLR_SNVS) & BM_DBGMON_HW_DBGMON_CTRL_CLR_SNVS)

/*! @brief Set the CLR_SNVS field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_CLR_SNVS(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_CLR_SNVS) | BF_DBGMON_HW_DBGMON_CTRL_CLR_SNVS(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field ADDR_TRAPMODE[4] (RW)
 *
 * The bit defines the address trap function.
 *
 * Values:
 * - 0 - Address trap function is disabled
 * - 1 - Address trap function is enabled
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE (4U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE. */
#define BM_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE (0x00000010U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE. */
#define BS_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE field. */
#define BR_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.ADDR_TRAPMODE)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE. */
#define BF_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE) & BM_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE)

/*! @brief Set the ADDR_TRAPMODE field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE) | BF_DBGMON_HW_DBGMON_CTRL_ADDR_TRAPMODE(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field ID_TRAPMODE[5] (RW)
 *
 * The bit defines the ID trap function.
 *
 * Values:
 * - 0 - ID trap function is disabled
 * - 1 - ID trap function is enabled
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE (5U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE. */
#define BM_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE (0x00000020U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE. */
#define BS_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE field. */
#define BR_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.ID_TRAPMODE)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE. */
#define BF_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE) & BM_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE)

/*! @brief Set the ID_TRAPMODE field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE) | BF_DBGMON_HW_DBGMON_CTRL_ID_TRAPMODE(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RSVD0[7:6] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RSVD0 (6U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RSVD0. */
#define BM_DBGMON_HW_DBGMON_CTRL_RSVD0 (0x000000C0U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RSVD0. */
#define BS_DBGMON_HW_DBGMON_CTRL_RSVD0 (2U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RSVD0. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RSVD0 field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RSVD0(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RSVD0)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RSVD0. */
#define BF_DBGMON_HW_DBGMON_CTRL_RSVD0(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RSVD0) & BM_DBGMON_HW_DBGMON_CTRL_RSVD0)

/*! @brief Set the RSVD0 field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RSVD0(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RSVD0) | BF_DBGMON_HW_DBGMON_CTRL_RSVD0(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field REQSEL[9:8] (RW)
 *
 * This field defines which sets of AXI transaction will be snaped to SNVS
 * domain registers. Assume (N-3), (N-2), (N-1), N represent four continous most
 * recent AXI transactions, N is the latest transactions
 *
 * Values:
 * - 00 - The information of the latest transaction will be snapped to SNVS
 *     domain registers
 * - 01 - (N-1) transaction will be snapped to SNVS domain registers
 * - 10 - (N-2) transaction will be snapped to SNVS domain registers
 * - 11 - (N-3) transaction will be snapped to SNVS domain registers
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_REQSEL (8U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_REQSEL. */
#define BM_DBGMON_HW_DBGMON_CTRL_REQSEL (0x00000300U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_REQSEL. */
#define BS_DBGMON_HW_DBGMON_CTRL_REQSEL (2U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_REQSEL. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_REQSEL field. */
#define BR_DBGMON_HW_DBGMON_CTRL_REQSEL(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.REQSEL)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_REQSEL. */
#define BF_DBGMON_HW_DBGMON_CTRL_REQSEL(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_REQSEL) & BM_DBGMON_HW_DBGMON_CTRL_REQSEL)

/*! @brief Set the REQSEL field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_REQSEL(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_REQSEL) | BF_DBGMON_HW_DBGMON_CTRL_REQSEL(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RSVD1[15:10] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RSVD1 (10U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RSVD1. */
#define BM_DBGMON_HW_DBGMON_CTRL_RSVD1 (0x0000FC00U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RSVD1. */
#define BS_DBGMON_HW_DBGMON_CTRL_RSVD1 (6U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RSVD1. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RSVD1 field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RSVD1(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RSVD1)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RSVD1. */
#define BF_DBGMON_HW_DBGMON_CTRL_RSVD1(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RSVD1) & BM_DBGMON_HW_DBGMON_CTRL_RSVD1)

/*! @brief Set the RSVD1 field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RSVD1(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RSVD1) | BF_DBGMON_HW_DBGMON_CTRL_RSVD1(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field WORKMODE[16] (RW)
 *
 * This field defines whether ignore the transaction in IRQ
 *
 * Values:
 * - 0 - The axi transaction in interrupt status will be monitored
 * - 1 - The axi transaction in interrupt status will be ignored
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_WORKMODE (16U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_WORKMODE. */
#define BM_DBGMON_HW_DBGMON_CTRL_WORKMODE (0x00010000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_WORKMODE. */
#define BS_DBGMON_HW_DBGMON_CTRL_WORKMODE (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_WORKMODE. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_WORKMODE field. */
#define BR_DBGMON_HW_DBGMON_CTRL_WORKMODE(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.WORKMODE)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_WORKMODE. */
#define BF_DBGMON_HW_DBGMON_CTRL_WORKMODE(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_WORKMODE) & BM_DBGMON_HW_DBGMON_CTRL_WORKMODE)

/*! @brief Set the WORKMODE field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_WORKMODE(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_WORKMODE) | BF_DBGMON_HW_DBGMON_CTRL_WORKMODE(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RSVD2[19:17] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RSVD2 (17U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RSVD2. */
#define BM_DBGMON_HW_DBGMON_CTRL_RSVD2 (0x000E0000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RSVD2. */
#define BS_DBGMON_HW_DBGMON_CTRL_RSVD2 (3U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RSVD2. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RSVD2 field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RSVD2(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RSVD2)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RSVD2. */
#define BF_DBGMON_HW_DBGMON_CTRL_RSVD2(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RSVD2) & BM_DBGMON_HW_DBGMON_CTRL_RSVD2)

/*! @brief Set the RSVD2 field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RSVD2(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RSVD2) | BF_DBGMON_HW_DBGMON_CTRL_RSVD2(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field ADDR_MASKEN[20] (RW)
 *
 * This field control the address mask function,
 *
 * Values:
 * - 0 - Address mask is disabled, all address range will be monitored
 * - 1 - Address mask is enabled, address within the range defined by ADDR_HIGH,
 *     ADDR_LOW will be monitored
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN (20U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN. */
#define BM_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN (0x00100000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN. */
#define BS_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN field. */
#define BR_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.ADDR_MASKEN)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN. */
#define BF_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN) & BM_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN)

/*! @brief Set the ADDR_MASKEN field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN) | BF_DBGMON_HW_DBGMON_CTRL_ADDR_MASKEN(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RSVD3[23:21] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RSVD3 (21U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RSVD3. */
#define BM_DBGMON_HW_DBGMON_CTRL_RSVD3 (0x00E00000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RSVD3. */
#define BS_DBGMON_HW_DBGMON_CTRL_RSVD3 (3U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RSVD3. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RSVD3 field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RSVD3(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RSVD3)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RSVD3. */
#define BF_DBGMON_HW_DBGMON_CTRL_RSVD3(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RSVD3) & BM_DBGMON_HW_DBGMON_CTRL_RSVD3)

/*! @brief Set the RSVD3 field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RSVD3(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RSVD3) | BF_DBGMON_HW_DBGMON_CTRL_RSVD3(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field WDOG_IRQ_SEL[24] (RW)
 *
 * Select the source of WDOG IRQ.
 *
 * Values:
 * - 0 - Select WDOG1 as WDOG IRQ source
 * - 1 - Select WDOG2 as WDOG IRQ source
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL (24U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL. */
#define BM_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL (0x01000000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL. */
#define BS_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL field. */
#define BR_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.WDOG_IRQ_SEL)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL. */
#define BF_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL) & BM_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL)

/*! @brief Set the WDOG_IRQ_SEL field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL) | BF_DBGMON_HW_DBGMON_CTRL_WDOG_IRQ_SEL(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field RSVD4[29:25] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_RSVD4 (25U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_RSVD4. */
#define BM_DBGMON_HW_DBGMON_CTRL_RSVD4 (0x3E000000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_RSVD4. */
#define BS_DBGMON_HW_DBGMON_CTRL_RSVD4 (5U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_RSVD4. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_RSVD4 field. */
#define BR_DBGMON_HW_DBGMON_CTRL_RSVD4(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.RSVD4)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_RSVD4. */
#define BF_DBGMON_HW_DBGMON_CTRL_RSVD4(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_RSVD4) & BM_DBGMON_HW_DBGMON_CTRL_RSVD4)

/*! @brief Set the RSVD4 field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_RSVD4(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_RSVD4) | BF_DBGMON_HW_DBGMON_CTRL_RSVD4(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field CLKGATE[30] (RW)
 *
 * This bit must be set to zero for normal oepration. When set to one it gates
 * off the clock to the block.
 *
 * Values:
 * - 0 - Allow DBGMON to operate normally
 * - 1 - Gating off the clock of DBGMON in order to minimize the power
 *     consumption.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_CLKGATE (30U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_CLKGATE. */
#define BM_DBGMON_HW_DBGMON_CTRL_CLKGATE (0x40000000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_CLKGATE. */
#define BS_DBGMON_HW_DBGMON_CTRL_CLKGATE (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_CLKGATE. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_CLKGATE field. */
#define BR_DBGMON_HW_DBGMON_CTRL_CLKGATE(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.CLKGATE)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_CLKGATE. */
#define BF_DBGMON_HW_DBGMON_CTRL_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_CLKGATE) & BM_DBGMON_HW_DBGMON_CTRL_CLKGATE)

/*! @brief Set the CLKGATE field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_CLKGATE(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_CLKGATE) | BF_DBGMON_HW_DBGMON_CTRL_CLKGATE(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_CTRL, field SFTRST[31] (RW)
 *
 * Set to zero for normal operation. When this bit is set to one(default), then
 * the entire block is held in its reset state
 *
 * Values:
 * - 0 - Allow DBGMON to operate normally
 * - 1 - Hold DBGMON in reset
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_CTRL_SFTRST (31U) /*!< Bit position for DBGMON_HW_DBGMON_CTRL_SFTRST. */
#define BM_DBGMON_HW_DBGMON_CTRL_SFTRST (0x80000000U) /*!< Bit mask for DBGMON_HW_DBGMON_CTRL_SFTRST. */
#define BS_DBGMON_HW_DBGMON_CTRL_SFTRST (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_CTRL_SFTRST. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_CTRL_SFTRST field. */
#define BR_DBGMON_HW_DBGMON_CTRL_SFTRST(x) (HW_DBGMON_HW_DBGMON_CTRL(x).B.SFTRST)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_CTRL_SFTRST. */
#define BF_DBGMON_HW_DBGMON_CTRL_SFTRST(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_CTRL_SFTRST) & BM_DBGMON_HW_DBGMON_CTRL_SFTRST)

/*! @brief Set the SFTRST field to a new value. */
#define BW_DBGMON_HW_DBGMON_CTRL_SFTRST(x, v) (HW_DBGMON_HW_DBGMON_CTRL_WR(x, (HW_DBGMON_HW_DBGMON_CTRL_RD(x) & ~BM_DBGMON_HW_DBGMON_CTRL_SFTRST) | BF_DBGMON_HW_DBGMON_CTRL_SFTRST(v)))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_MASTER_EN - HW_DBGMON_MASTER_EN
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_MASTER_EN - HW_DBGMON_MASTER_EN (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_master_en
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_master_en_bitfields
    {
        uint32_t MID0 : 1;             /*!< [0]  */
        uint32_t MID1 : 1;             /*!< [1]  */
        uint32_t MID2 : 1;             /*!< [2]  */
        uint32_t MID3 : 1;             /*!< [3]  */
        uint32_t MID4 : 1;             /*!< [4]  */
        uint32_t MID5 : 1;             /*!< [5]  */
        uint32_t MID6 : 1;             /*!< [6]  */
        uint32_t MID7 : 1;             /*!< [7]  */
        uint32_t MID8 : 1;             /*!< [8]  */
        uint32_t MID9 : 1;             /*!< [9]  */
        uint32_t MID10 : 1;            /*!< [10]  */
        uint32_t MID11 : 1;            /*!< [11]  */
        uint32_t MID12 : 1;            /*!< [12]  */
        uint32_t MID13 : 1;            /*!< [13]  */
        uint32_t MID14 : 1;            /*!< [14]  */
        uint32_t MID15 : 1;            /*!< [15]  */
        uint32_t RSVD : 16;            /*!< [31:16]  */
    } B;
} hw_dbgmon_hw_dbgmon_master_en_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_MASTER_EN register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_MASTER_EN_ADDR(x) ((uintptr_t)(x) + 0x2090010U)

#define HW_DBGMON_HW_DBGMON_MASTER_EN(x) (*(__IO hw_dbgmon_hw_dbgmon_master_en_t *) HW_DBGMON_HW_DBGMON_MASTER_EN_ADDR(x))
#define HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).U)
#define HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).U = (v))
#define HW_DBGMON_HW_DBGMON_MASTER_EN_SET(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_MASTER_EN_CLR(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_MASTER_EN_TOG(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_MASTER_EN bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID0[0] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 0.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID0 (0U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID0. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID0 (0x00000001U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID0. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID0 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID0. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID0 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID0(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID0)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID0. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID0(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID0) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID0)

/*! @brief Set the MID0 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID0(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID0) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID0(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID1[1] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 1.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID1 (1U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID1. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID1 (0x00000002U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID1. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID1 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID1. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID1 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID1(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID1)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID1. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID1(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID1) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID1)

/*! @brief Set the MID1 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID1(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID1) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID1(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID2[2] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 2.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID2 (2U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID2. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID2 (0x00000004U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID2. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID2 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID2. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID2 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID2(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID2)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID2. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID2(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID2) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID2)

/*! @brief Set the MID2 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID2(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID2) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID2(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID3[3] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 3.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID3 (3U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID3. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID3 (0x00000008U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID3. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID3 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID3. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID3 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID3(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID3)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID3. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID3(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID3) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID3)

/*! @brief Set the MID3 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID3(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID3) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID3(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID4[4] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 4.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID4 (4U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID4. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID4 (0x00000010U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID4. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID4 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID4. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID4 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID4(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID4)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID4. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID4(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID4) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID4)

/*! @brief Set the MID4 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID4(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID4) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID4(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID5[5] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 5
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID5 (5U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID5. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID5 (0x00000020U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID5. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID5 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID5. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID5 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID5(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID5)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID5. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID5(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID5) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID5)

/*! @brief Set the MID5 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID5(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID5) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID5(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID6[6] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 6.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID6 (6U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID6. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID6 (0x00000040U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID6. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID6 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID6. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID6 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID6(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID6)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID6. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID6(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID6) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID6)

/*! @brief Set the MID6 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID6(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID6) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID6(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID7[7] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 7.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID7 (7U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID7. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID7 (0x00000080U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID7. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID7 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID7. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID7 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID7(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID7)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID7. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID7(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID7) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID7)

/*! @brief Set the MID7 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID7(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID7) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID7(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID8[8] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 8.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID8 (8U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID8. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID8 (0x00000100U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID8. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID8 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID8. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID8 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID8(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID8)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID8. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID8(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID8) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID8)

/*! @brief Set the MID8 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID8(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID8) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID8(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID9[9] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 9.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID9 (9U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID9. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID9 (0x00000200U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID9. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID9 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID9. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID9 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID9(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID9)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID9. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID9(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID9) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID9)

/*! @brief Set the MID9 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID9(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID9) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID9(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID10[10] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 10.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID10 (10U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID10. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID10 (0x00000400U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID10. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID10 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID10. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID10 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID10(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID10)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID10. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID10(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID10) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID10)

/*! @brief Set the MID10 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID10(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID10) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID10(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID11[11] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 11.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID11 (11U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID11. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID11 (0x00000800U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID11. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID11 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID11. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID11 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID11(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID11)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID11. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID11(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID11) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID11)

/*! @brief Set the MID11 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID11(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID11) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID11(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID12[12] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 12.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID12 (12U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID12. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID12 (0x00001000U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID12. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID12 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID12. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID12 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID12(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID12)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID12. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID12(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID12) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID12)

/*! @brief Set the MID12 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID12(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID12) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID12(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID13[13] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 13.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID13 (13U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID13. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID13 (0x00002000U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID13. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID13 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID13. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID13 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID13(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID13)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID13. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID13(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID13) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID13)

/*! @brief Set the MID13 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID13(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID13) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID13(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID14[14] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 14.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID14 (14U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID14. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID14 (0x00004000U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID14. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID14 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID14. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID14 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID14(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID14)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID14. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID14(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID14) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID14)

/*! @brief Set the MID14 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID14(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID14) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID14(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field MID15[15] (RW)
 *
 * Set to 1 to enable monitoring on MasterID 15.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_MID15 (15U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_MID15. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_MID15 (0x00008000U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_MID15. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_MID15 (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_MID15. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_MID15 field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_MID15(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.MID15)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_MID15. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_MID15(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_MID15) & BM_DBGMON_HW_DBGMON_MASTER_EN_MID15)

/*! @brief Set the MID15 field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_MID15(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_MID15) | BF_DBGMON_HW_DBGMON_MASTER_EN_MID15(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_MASTER_EN, field RSVD[31:16] (RW)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_MASTER_EN_RSVD (16U) /*!< Bit position for DBGMON_HW_DBGMON_MASTER_EN_RSVD. */
#define BM_DBGMON_HW_DBGMON_MASTER_EN_RSVD (0xFFFF0000U) /*!< Bit mask for DBGMON_HW_DBGMON_MASTER_EN_RSVD. */
#define BS_DBGMON_HW_DBGMON_MASTER_EN_RSVD (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_MASTER_EN_RSVD. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_MASTER_EN_RSVD field. */
#define BR_DBGMON_HW_DBGMON_MASTER_EN_RSVD(x) (HW_DBGMON_HW_DBGMON_MASTER_EN(x).B.RSVD)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_MASTER_EN_RSVD. */
#define BF_DBGMON_HW_DBGMON_MASTER_EN_RSVD(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_MASTER_EN_RSVD) & BM_DBGMON_HW_DBGMON_MASTER_EN_RSVD)

/*! @brief Set the RSVD field to a new value. */
#define BW_DBGMON_HW_DBGMON_MASTER_EN_RSVD(x, v) (HW_DBGMON_HW_DBGMON_MASTER_EN_WR(x, (HW_DBGMON_HW_DBGMON_MASTER_EN_RD(x) & ~BM_DBGMON_HW_DBGMON_MASTER_EN_RSVD) | BF_DBGMON_HW_DBGMON_MASTER_EN_RSVD(v)))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_IRQ - HW_DBGMON_IRQ
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_IRQ - HW_DBGMON_IRQ (RW)
 *
 * Reset value: 0x0000FFFFU
 */
typedef union _hw_dbgmon_hw_dbgmon_irq
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_irq_bitfields
    {
        uint32_t ADDR_TRAP_IRQEN : 1;  /*!< [0]  */
        uint32_t ID_TRAP_IRQEN : 1;    /*!< [1]  */
        uint32_t ADDR_TRAP_IRQ : 1;    /*!< [2]  */
        uint32_t ID_TRAP_IRQ : 1;      /*!< [3]  */
        uint32_t RSVD : 12;            /*!< [15:4]  */
        uint32_t IRQ_MID : 16;         /*!< [31:16]  */
    } B;
} hw_dbgmon_hw_dbgmon_irq_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_IRQ register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_IRQ_ADDR(x) ((uintptr_t)(x) + 0x2090020U)

#define HW_DBGMON_HW_DBGMON_IRQ(x) (*(__IO hw_dbgmon_hw_dbgmon_irq_t *) HW_DBGMON_HW_DBGMON_IRQ_ADDR(x))
#define HW_DBGMON_HW_DBGMON_IRQ_RD(x) (HW_DBGMON_HW_DBGMON_IRQ(x).U)
#define HW_DBGMON_HW_DBGMON_IRQ_WR(x, v) (HW_DBGMON_HW_DBGMON_IRQ(x).U = (v))
#define HW_DBGMON_HW_DBGMON_IRQ_SET(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, HW_DBGMON_HW_DBGMON_IRQ_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_IRQ_CLR(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_IRQ_TOG(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, HW_DBGMON_HW_DBGMON_IRQ_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_IRQ bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field ADDR_TRAP_IRQEN[0] (RW)
 *
 * Address trap interrupt control.
 *
 * Values:
 * - 0 - Address trap interrupt is disabled
 * - 1 - Address trap interrupt is enabled
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN (0U) /*!< Bit position for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN. */
#define BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN (0x00000001U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN. */
#define BS_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN field. */
#define BR_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.ADDR_TRAP_IRQEN)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN. */
#define BF_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN) & BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN)

/*! @brief Set the ADDR_TRAP_IRQEN field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN) | BF_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQEN(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field ID_TRAP_IRQEN[1] (RW)
 *
 * ID trap interrupt control.
 *
 * Values:
 * - 0 - ID trap interrupt is disabled
 * - 1 - ID trap interrupt is enabled
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN (1U) /*!< Bit position for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN. */
#define BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN (0x00000002U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN. */
#define BS_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN field. */
#define BR_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.ID_TRAP_IRQEN)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN. */
#define BF_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN) & BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN)

/*! @brief Set the ID_TRAP_IRQEN field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN) | BF_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQEN(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field ADDR_TRAP_IRQ[2] (RW)
 *
 * This bit indicates the Address trap interrupt is happening. Write to 1 to SCT
 * address(offset = 0x28) to clear it.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ (2U) /*!< Bit position for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ. */
#define BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ (0x00000004U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ. */
#define BS_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ field. */
#define BR_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.ADDR_TRAP_IRQ)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ. */
#define BF_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ) & BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ)

/*! @brief Set the ADDR_TRAP_IRQ field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ) | BF_DBGMON_HW_DBGMON_IRQ_ADDR_TRAP_IRQ(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field ID_TRAP_IRQ[3] (RW)
 *
 * This bit indicates the ID trap interrupt is happening. Write to 1 to SCT
 * address(offset = 0x28) to clear it.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ (3U) /*!< Bit position for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ. */
#define BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ (0x00000008U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ. */
#define BS_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ field. */
#define BR_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.ID_TRAP_IRQ)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ. */
#define BF_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ) & BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ)

/*! @brief Set the ID_TRAP_IRQ field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ) | BF_DBGMON_HW_DBGMON_IRQ_ID_TRAP_IRQ(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field RSVD[15:4] (RW)
 *
 * Reserved.
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_RSVD (4U)  /*!< Bit position for DBGMON_HW_DBGMON_IRQ_RSVD. */
#define BM_DBGMON_HW_DBGMON_IRQ_RSVD (0x0000FFF0U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_RSVD. */
#define BS_DBGMON_HW_DBGMON_IRQ_RSVD (12U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_RSVD. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_RSVD field. */
#define BR_DBGMON_HW_DBGMON_IRQ_RSVD(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.RSVD)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_RSVD. */
#define BF_DBGMON_HW_DBGMON_IRQ_RSVD(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_RSVD) & BM_DBGMON_HW_DBGMON_IRQ_RSVD)

/*! @brief Set the RSVD field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_RSVD(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_RSVD) | BF_DBGMON_HW_DBGMON_IRQ_RSVD(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_IRQ, field IRQ_MID[31:16] (RW)
 *
 * This field indicate which master sends the interrupt, will not update until
 * all interrupts are cleared. each bit represents one master. IRQ_MID[16]
 * represents Master 0 IRQ_MID[17] represents Master 1, and so on
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_IRQ_IRQ_MID (16U) /*!< Bit position for DBGMON_HW_DBGMON_IRQ_IRQ_MID. */
#define BM_DBGMON_HW_DBGMON_IRQ_IRQ_MID (0xFFFF0000U) /*!< Bit mask for DBGMON_HW_DBGMON_IRQ_IRQ_MID. */
#define BS_DBGMON_HW_DBGMON_IRQ_IRQ_MID (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_IRQ_IRQ_MID. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_IRQ_IRQ_MID field. */
#define BR_DBGMON_HW_DBGMON_IRQ_IRQ_MID(x) (HW_DBGMON_HW_DBGMON_IRQ(x).B.IRQ_MID)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_IRQ_IRQ_MID. */
#define BF_DBGMON_HW_DBGMON_IRQ_IRQ_MID(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_IRQ_IRQ_MID) & BM_DBGMON_HW_DBGMON_IRQ_IRQ_MID)

/*! @brief Set the IRQ_MID field to a new value. */
#define BW_DBGMON_HW_DBGMON_IRQ_IRQ_MID(x, v) (HW_DBGMON_HW_DBGMON_IRQ_WR(x, (HW_DBGMON_HW_DBGMON_IRQ_RD(x) & ~BM_DBGMON_HW_DBGMON_IRQ_IRQ_MID) | BF_DBGMON_HW_DBGMON_IRQ_IRQ_MID(v)))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW - HW_DBGMON_TRAP_ADDR_LOW
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW - HW_DBGMON_TRAP_ADDR_LOW (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_trap_addr_low
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_trap_addr_low_bitfields
    {
        uint32_t Address : 32;         /*!< [31:0]  */
    } B;
} hw_dbgmon_hw_dbgmon_trap_addr_low_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_TRAP_ADDR_LOW register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_ADDR(x) ((uintptr_t)(x) + 0x2090030U)

#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW(x) (*(__IO hw_dbgmon_hw_dbgmon_trap_addr_low_t *) HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_ADDR(x))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_RD(x) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW(x).U)
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_WR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW(x).U = (v))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_SET(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_CLR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_TOG(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_TRAP_ADDR_LOW bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_TRAP_ADDR_LOW, field Address[31:0] (RW)
 *
 * This field contains 32-bit low address for the address trap range
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address (0U) /*!< Bit position for DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address. */
#define BM_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address (0xFFFFFFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address. */
#define BS_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address (32U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address field. */
#define BR_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address(x) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW(x).U)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address. */
#define BF_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address) & BM_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address)

/*! @brief Set the Address field to a new value. */
#define BW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_Address(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_LOW_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH - HW_DBGMON_TRAP_ADDR_HIGH
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH - HW_DBGMON_TRAP_ADDR_HIGH (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_trap_addr_high
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_trap_addr_high_bitfields
    {
        uint32_t Address : 32;         /*!< [31:0]  */
    } B;
} hw_dbgmon_hw_dbgmon_trap_addr_high_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_TRAP_ADDR_HIGH register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_ADDR(x) ((uintptr_t)(x) + 0x2090040U)

#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH(x) (*(__IO hw_dbgmon_hw_dbgmon_trap_addr_high_t *) HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_ADDR(x))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_RD(x) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH(x).U)
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_WR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH(x).U = (v))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_SET(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_CLR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_TOG(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_TRAP_ADDR_HIGH bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_TRAP_ADDR_HIGH, field Address[31:0] (RW)
 *
 * This field contains 32-bit high address for the address trap range
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address (0U) /*!< Bit position for DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address. */
#define BM_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address (0xFFFFFFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address. */
#define BS_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address (32U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address field. */
#define BR_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address(x) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH(x).U)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address. */
#define BF_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address) & BM_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address)

/*! @brief Set the Address field to a new value. */
#define BW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_Address(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ADDR_HIGH_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_TRAP_ID - HW_DBGMON_TRAP_ID
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_TRAP_ID - HW_DBGMON_TRAP_ID (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_trap_id
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_trap_id_bitfields
    {
        uint32_t TRAP_ID_LOW : 16;     /*!< [15:0]  */
        uint32_t TRAP_ID_HIGH : 16;    /*!< [31:16]  */
    } B;
} hw_dbgmon_hw_dbgmon_trap_id_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_TRAP_ID register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_TRAP_ID_ADDR(x) ((uintptr_t)(x) + 0x2090050U)

#define HW_DBGMON_HW_DBGMON_TRAP_ID(x) (*(__IO hw_dbgmon_hw_dbgmon_trap_id_t *) HW_DBGMON_HW_DBGMON_TRAP_ID_ADDR(x))
#define HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) (HW_DBGMON_HW_DBGMON_TRAP_ID(x).U)
#define HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID(x).U = (v))
#define HW_DBGMON_HW_DBGMON_TRAP_ID_SET(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) |  (v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ID_CLR(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) & ~(v)))
#define HW_DBGMON_HW_DBGMON_TRAP_ID_TOG(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_TRAP_ID bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_TRAP_ID, field TRAP_ID_LOW[15:0] (RW)
 *
 * This field contains 16-bit low ID for ID trap range
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW (0U) /*!< Bit position for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW. */
#define BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW (0x0000FFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW. */
#define BS_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW field. */
#define BR_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW(x) (HW_DBGMON_HW_DBGMON_TRAP_ID(x).B.TRAP_ID_LOW)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW. */
#define BF_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW) & BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW)

/*! @brief Set the TRAP_ID_LOW field to a new value. */
#define BW_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, (HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) & ~BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW) | BF_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_LOW(v)))
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_TRAP_ID, field TRAP_ID_HIGH[31:16] (RW)
 *
 * This field contains 16-bit high ID for ID trap range
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH (16U) /*!< Bit position for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH. */
#define BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH (0xFFFF0000U) /*!< Bit mask for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH. */
#define BS_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH field. */
#define BR_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH(x) (HW_DBGMON_HW_DBGMON_TRAP_ID(x).B.TRAP_ID_HIGH)

/*! @brief Format value for bitfield DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH. */
#define BF_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH(v) ((uint32_t)((uint32_t)(v) << BP_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH) & BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH)

/*! @brief Set the TRAP_ID_HIGH field to a new value. */
#define BW_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH(x, v) (HW_DBGMON_HW_DBGMON_TRAP_ID_WR(x, (HW_DBGMON_HW_DBGMON_TRAP_ID_RD(x) & ~BM_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH) | BF_DBGMON_HW_DBGMON_TRAP_ID_TRAP_ID_HIGH(v)))
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_SNVS_ADDR - HW_DBGMON_SNVS_ADDR
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_SNVS_ADDR - HW_DBGMON_SNVS_ADDR (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_snvs_addr
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_snvs_addr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dbgmon_hw_dbgmon_snvs_addr_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_SNVS_ADDR register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR(x) ((uintptr_t)(x) + 0x2090060U)

#define HW_DBGMON_HW_DBGMON_SNVS_ADDR(x) (*(__I hw_dbgmon_hw_dbgmon_snvs_addr_t *) HW_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR(x))
#define HW_DBGMON_HW_DBGMON_SNVS_ADDR_RD(x) (HW_DBGMON_HW_DBGMON_SNVS_ADDR(x).U)
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_SNVS_ADDR bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_ADDR, field ADDR[31:0] (RO)
 *
 * This field contains 32-bit Address in SNVS domain register
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR (0U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_ADDR_ADDR. */
#define BM_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR (0xFFFFFFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_ADDR_ADDR. */
#define BS_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR (32U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_ADDR_ADDR. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_ADDR_ADDR field. */
#define BR_DBGMON_HW_DBGMON_SNVS_ADDR_ADDR(x) (HW_DBGMON_HW_DBGMON_SNVS_ADDR(x).U)
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_SNVS_DATA - HW_DBGMON_SNVS_DATA
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_SNVS_DATA - HW_DBGMON_SNVS_DATA (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_snvs_data
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_snvs_data_bitfields
    {
        uint32_t DATA : 32;            /*!< [31:0]  */
    } B;
} hw_dbgmon_hw_dbgmon_snvs_data_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_SNVS_DATA register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_SNVS_DATA_ADDR(x) ((uintptr_t)(x) + 0x2090070U)

#define HW_DBGMON_HW_DBGMON_SNVS_DATA(x) (*(__I hw_dbgmon_hw_dbgmon_snvs_data_t *) HW_DBGMON_HW_DBGMON_SNVS_DATA_ADDR(x))
#define HW_DBGMON_HW_DBGMON_SNVS_DATA_RD(x) (HW_DBGMON_HW_DBGMON_SNVS_DATA(x).U)
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_SNVS_DATA bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_DATA, field DATA[31:0] (RO)
 *
 * This field contains 32-bit Data of AXI transaction in SNVS domain register
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_DATA_DATA (0U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_DATA_DATA. */
#define BM_DBGMON_HW_DBGMON_SNVS_DATA_DATA (0xFFFFFFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_DATA_DATA. */
#define BS_DBGMON_HW_DBGMON_SNVS_DATA_DATA (32U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_DATA_DATA. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_DATA_DATA field. */
#define BR_DBGMON_HW_DBGMON_SNVS_DATA_DATA(x) (HW_DBGMON_HW_DBGMON_SNVS_DATA(x).U)
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_SNVS_INFO - HW_DBGMON_SNVS_INFO
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_SNVS_INFO - HW_DBGMON_SNVS_INFO (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dbgmon_hw_dbgmon_snvs_info
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_snvs_info_bitfields
    {
        uint32_t COMPLETE : 1;         /*!< [0]  */
        uint32_t RDWR : 1;             /*!< [1]  */
        uint32_t RSVD : 14;            /*!< [15:2]  */
        uint32_t ID : 16;              /*!< [31:16]  */
    } B;
} hw_dbgmon_hw_dbgmon_snvs_info_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_SNVS_INFO register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_SNVS_INFO_ADDR(x) ((uintptr_t)(x) + 0x2090080U)

#define HW_DBGMON_HW_DBGMON_SNVS_INFO(x) (*(__I hw_dbgmon_hw_dbgmon_snvs_info_t *) HW_DBGMON_HW_DBGMON_SNVS_INFO_ADDR(x))
#define HW_DBGMON_HW_DBGMON_SNVS_INFO_RD(x) (HW_DBGMON_HW_DBGMON_SNVS_INFO(x).U)
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_SNVS_INFO bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_INFO, field COMPLETE[0] (RO)
 *
 * The field indicates whether the AXI transaction in SNVS domain complete. 0:
 * not complete, 1: Complete
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE (0U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE. */
#define BM_DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE (0x00000001U) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE. */
#define BS_DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE field. */
#define BR_DBGMON_HW_DBGMON_SNVS_INFO_COMPLETE(x) (HW_DBGMON_HW_DBGMON_SNVS_INFO(x).B.COMPLETE)
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_INFO, field RDWR[1] (RO)
 *
 * The field indicates the read/write attribute of AXI transaction in SNVS
 * domain. 0: read, 1: Write
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_INFO_RDWR (1U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_INFO_RDWR. */
#define BM_DBGMON_HW_DBGMON_SNVS_INFO_RDWR (0x00000002U) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_INFO_RDWR. */
#define BS_DBGMON_HW_DBGMON_SNVS_INFO_RDWR (1U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_INFO_RDWR. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_INFO_RDWR field. */
#define BR_DBGMON_HW_DBGMON_SNVS_INFO_RDWR(x) (HW_DBGMON_HW_DBGMON_SNVS_INFO(x).B.RDWR)
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_INFO, field RSVD[15:2] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_INFO_RSVD (2U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_INFO_RSVD. */
#define BM_DBGMON_HW_DBGMON_SNVS_INFO_RSVD (0x0000FFFCU) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_INFO_RSVD. */
#define BS_DBGMON_HW_DBGMON_SNVS_INFO_RSVD (14U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_INFO_RSVD. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_INFO_RSVD field. */
#define BR_DBGMON_HW_DBGMON_SNVS_INFO_RSVD(x) (HW_DBGMON_HW_DBGMON_SNVS_INFO(x).B.RSVD)
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_SNVS_INFO, field ID[31:16] (RO)
 *
 * The field contain the ID of the AXI transaction in SNVS domain
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_SNVS_INFO_ID (16U) /*!< Bit position for DBGMON_HW_DBGMON_SNVS_INFO_ID. */
#define BM_DBGMON_HW_DBGMON_SNVS_INFO_ID (0xFFFF0000U) /*!< Bit mask for DBGMON_HW_DBGMON_SNVS_INFO_ID. */
#define BS_DBGMON_HW_DBGMON_SNVS_INFO_ID (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_SNVS_INFO_ID. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_SNVS_INFO_ID field. */
#define BR_DBGMON_HW_DBGMON_SNVS_INFO_ID(x) (HW_DBGMON_HW_DBGMON_SNVS_INFO(x).B.ID)
/*@}*/

/*******************************************************************************
 * HW_DBGMON_HW_DBGMON_VERSION - HW_DBGMON_VERSION
 ******************************************************************************/

/*!
 * @brief HW_DBGMON_HW_DBGMON_VERSION - HW_DBGMON_VERSION (RO)
 *
 * Reset value: 0x01010000U
 */
typedef union _hw_dbgmon_hw_dbgmon_version
{
    uint32_t U;
    struct _hw_dbgmon_hw_dbgmon_version_bitfields
    {
        uint32_t STEP : 16;            /*!< [15:0]  */
        uint32_t MINOR : 8;            /*!< [23:16]  */
        uint32_t MAJOR : 8;            /*!< [31:24]  */
    } B;
} hw_dbgmon_hw_dbgmon_version_t;

/*!
 * @name Constants and macros for entire DBGMON_HW_DBGMON_VERSION register
 */
/*@{*/
#define HW_DBGMON_HW_DBGMON_VERSION_ADDR(x) ((uintptr_t)(x) + 0x2090090U)

#define HW_DBGMON_HW_DBGMON_VERSION(x) (*(__I hw_dbgmon_hw_dbgmon_version_t *) HW_DBGMON_HW_DBGMON_VERSION_ADDR(x))
#define HW_DBGMON_HW_DBGMON_VERSION_RD(x) (HW_DBGMON_HW_DBGMON_VERSION(x).U)
/*@}*/

/*
 * Constants & macros for individual DBGMON_HW_DBGMON_VERSION bitfields
 */

/*!
 * @name Register DBGMON_HW_DBGMON_VERSION, field STEP[15:0] (RO)
 *
 * Fixed read-only value reflecting the stepping of the RTL version
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_VERSION_STEP (0U) /*!< Bit position for DBGMON_HW_DBGMON_VERSION_STEP. */
#define BM_DBGMON_HW_DBGMON_VERSION_STEP (0x0000FFFFU) /*!< Bit mask for DBGMON_HW_DBGMON_VERSION_STEP. */
#define BS_DBGMON_HW_DBGMON_VERSION_STEP (16U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_VERSION_STEP. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_VERSION_STEP field. */
#define BR_DBGMON_HW_DBGMON_VERSION_STEP(x) (HW_DBGMON_HW_DBGMON_VERSION(x).B.STEP)
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_VERSION, field MINOR[23:16] (RO)
 *
 * Fixed read-only value reflecting the MINOR field of the RTL version
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_VERSION_MINOR (16U) /*!< Bit position for DBGMON_HW_DBGMON_VERSION_MINOR. */
#define BM_DBGMON_HW_DBGMON_VERSION_MINOR (0x00FF0000U) /*!< Bit mask for DBGMON_HW_DBGMON_VERSION_MINOR. */
#define BS_DBGMON_HW_DBGMON_VERSION_MINOR (8U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_VERSION_MINOR. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_VERSION_MINOR field. */
#define BR_DBGMON_HW_DBGMON_VERSION_MINOR(x) (HW_DBGMON_HW_DBGMON_VERSION(x).B.MINOR)
/*@}*/

/*!
 * @name Register DBGMON_HW_DBGMON_VERSION, field MAJOR[31:24] (RO)
 *
 * Fixed read-only value reflecting the MAJOR field of the RTL version
 */
/*@{*/
#define BP_DBGMON_HW_DBGMON_VERSION_MAJOR (24U) /*!< Bit position for DBGMON_HW_DBGMON_VERSION_MAJOR. */
#define BM_DBGMON_HW_DBGMON_VERSION_MAJOR (0xFF000000U) /*!< Bit mask for DBGMON_HW_DBGMON_VERSION_MAJOR. */
#define BS_DBGMON_HW_DBGMON_VERSION_MAJOR (8U) /*!< Bit field size in bits for DBGMON_HW_DBGMON_VERSION_MAJOR. */

/*! @brief Read current value of the DBGMON_HW_DBGMON_VERSION_MAJOR field. */
#define BR_DBGMON_HW_DBGMON_VERSION_MAJOR(x) (HW_DBGMON_HW_DBGMON_VERSION(x).B.MAJOR)
/*@}*/

/*******************************************************************************
 * hw_dbgmon_t - module struct
 ******************************************************************************/
/*!
 * @brief All DBGMON module registers.
 */
#pragma pack(1)
typedef struct _hw_dbgmon
{
    uint8_t _reserved0[34144256];
    __IO hw_dbgmon_hw_dbgmon_ctrl_t HW_DBGMON_CTRL; /*!< [0x2090000] HW_DBGMON_CTRL */
    uint8_t _reserved1[12];
    __IO hw_dbgmon_hw_dbgmon_master_en_t HW_DBGMON_MASTER_EN; /*!< [0x2090010] HW_DBGMON_MASTER_EN */
    uint8_t _reserved2[12];
    __IO hw_dbgmon_hw_dbgmon_irq_t HW_DBGMON_IRQ; /*!< [0x2090020] HW_DBGMON_IRQ */
    uint8_t _reserved3[12];
    __IO hw_dbgmon_hw_dbgmon_trap_addr_low_t HW_DBGMON_TRAP_ADDR_LOW; /*!< [0x2090030] HW_DBGMON_TRAP_ADDR_LOW */
    uint8_t _reserved4[12];
    __IO hw_dbgmon_hw_dbgmon_trap_addr_high_t HW_DBGMON_TRAP_ADDR_HIGH; /*!< [0x2090040] HW_DBGMON_TRAP_ADDR_HIGH */
    uint8_t _reserved5[12];
    __IO hw_dbgmon_hw_dbgmon_trap_id_t HW_DBGMON_TRAP_ID; /*!< [0x2090050] HW_DBGMON_TRAP_ID */
    uint8_t _reserved6[12];
    __I hw_dbgmon_hw_dbgmon_snvs_addr_t HW_DBGMON_SNVS_ADDR; /*!< [0x2090060] HW_DBGMON_SNVS_ADDR */
    uint8_t _reserved7[12];
    __I hw_dbgmon_hw_dbgmon_snvs_data_t HW_DBGMON_SNVS_DATA; /*!< [0x2090070] HW_DBGMON_SNVS_DATA */
    uint8_t _reserved8[12];
    __I hw_dbgmon_hw_dbgmon_snvs_info_t HW_DBGMON_SNVS_INFO; /*!< [0x2090080] HW_DBGMON_SNVS_INFO */
    uint8_t _reserved9[12];
    __I hw_dbgmon_hw_dbgmon_version_t HW_DBGMON_VERSION; /*!< [0x2090090] HW_DBGMON_VERSION */
} hw_dbgmon_t;
#pragma pack()

/*! @brief Macro to access all DBGMON registers. */
/*! @param x DBGMON module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_DBGMON_REGS(DBGMON_BASE)</code>. */
#define HW_DBGMON_REGS(x) (*(hw_dbgmon_t *)(x))

/*
 * iMX6SL DCP
 *
 * DCP Register Reference Index
 *
 * Registers defined in this header file:
 * - HW_DCP_CTRL - DCP Control Register 0
 * - HW_DCP_STAT - DCP Status Register
 * - HW_DCP_CHANNELCTRL - DCP Channel Control Register
 * - HW_DCP_CAPABILITY0 - DCP Capability 0 Register
 * - HW_DCP_CAPABILITY1 - DCP Capability 1 Register
 * - HW_DCP_CONTEXT - DCP Context Buffer Pointer
 * - HW_DCP_KEY - DCP Key Index
 * - HW_DCP_KEYDATA - DCP Key Data
 * - HW_DCP_PACKET0 - DCP Work Packet 0 Status Register
 * - HW_DCP_PACKET1 - DCP Work Packet 1 Status Register
 * - HW_DCP_PACKET2 - DCP Work Packet 2 Status Register
 * - HW_DCP_PACKET3 - DCP Work Packet 3 Status Register
 * - HW_DCP_PACKET4 - DCP Work Packet 4 Status Register
 * - HW_DCP_PACKET5 - DCP Work Packet 5 Status Register
 * - HW_DCP_PACKET6 - DCP Work Packet 6 Status Register
 * - HW_DCP_CH0CMDPTR - DCP Channel 0 Command Pointer Address Register
 * - HW_DCP_CH0SEMA - DCP Channel 0 Semaphore Register
 * - HW_DCP_CH0STAT - DCP Channel 0 Status Register
 * - HW_DCP_CH0OPTS - DCP Channel 0 Options Register
 * - HW_DCP_CH1CMDPTR - DCP Channel 1 Command Pointer Address Register
 * - HW_DCP_CH1SEMA - DCP Channel 1 Semaphore Register
 * - HW_DCP_CH1STAT - DCP Channel 1 Status Register
 * - HW_DCP_CH1OPTS - DCP Channel 1 Options Register
 * - HW_DCP_CH2CMDPTR - DCP Channel 2 Command Pointer Address Register
 * - HW_DCP_CH2SEMA - DCP Channel 2 Semaphore Register
 * - HW_DCP_CH2STAT - DCP Channel 2 Status Register
 * - HW_DCP_CH2OPTS - DCP Channel 2 Options Register
 * - HW_DCP_CH3CMDPTR - DCP Channel 3 Command Pointer Address Register
 * - HW_DCP_CH3SEMA - DCP Channel 3 Semaphore Register
 * - HW_DCP_CH3STAT - DCP Channel 3 Status Register
 * - HW_DCP_CH3OPTS - DCP Channel 3 Options Register
 * - HW_DCP_DBGSELECT - DCP Debug Select Register
 * - HW_DCP_DBGDATA - DCP Debug Data Register
 * - HW_DCP_PAGETABLE - DCP Page Table Register
 * - HW_DCP_VERSION - DCP Version Register
 *
 * - hw_dcp_t - Struct containing all module registers.
 */

#define HW_DCP_INSTANCE_COUNT (1U) /*!< Number of instances of the DCP module. */
#define HW_DCP (0U) /*!< Instance number for DCP. */
#define DCP_BASE              (0x20FC000U) /*!< Base address for DCP. */
/*! Array initializer of DCP base addresses. */
#define DCP_BASE_ADDRS        { DCP_BASE }

/*******************************************************************************
 * HW_DCP_CTRL - DCP Control Register 0
 ******************************************************************************/

/*!
 * @brief HW_DCP_CTRL - DCP Control Register 0 (RW)
 *
 * Reset value: 0xF0800000U
 *
 * The CTRL register contains controls for the DCP module. CTRL: 0x000 CTRL_SET:
 * 0x004 CTRL_CLR: 0x008 CTRL_TOG: 0x00C The Control register contains the
 * primary controls for the DCP block. The present bits indicate which of the
 * sub-features of the block are present in the hardware. The context control bits
 * control how the DCP utilizes it's context buffer and the gather residual writes bit
 * controls how the master handles writing misaligned data to the bus. Each
 * channel and the color-space converter contains an independent interrupt enable.
 * EXAMPLE DCP_CTRL_SET(BM_DCP_CTRL_SFTRST); DCP_CTRL_CLR(BM_DCP_CTRL_SFTRST |
 * BM_DCP_CTRL_CLKGATE);
 */
typedef union _hw_dcp_ctrl
{
    uint32_t U;
    struct _hw_dcp_ctrl_bitfields
    {
        uint32_t CHANNEL_INTERRUPT_ENABLE : 8; /*!< [7:0]  */
        uint32_t RSVD_CSC_INTERRUPT_ENABLE : 1; /*!< [8]  */
        uint32_t RESERVED0 : 12;       /*!< [20:9]  */
        uint32_t ENABLE_CONTEXT_SWITCHING : 1; /*!< [21]  */
        uint32_t ENABLE_CONTEXT_CACHING : 1; /*!< [22]  */
        uint32_t GATHER_RESIDUAL_WRITES : 1; /*!< [23]  */
        uint32_t RESERVED1 : 4;        /*!< [27:24]  */
        uint32_t PRESENT_SHA : 1;      /*!< [28]  */
        uint32_t PRESENT_CRYPTO : 1;   /*!< [29]  */
        uint32_t CLKGATE : 1;          /*!< [30]  */
        uint32_t SFTRST : 1;           /*!< [31]  */
    } B;
} hw_dcp_ctrl_t;

/*!
 * @name Constants and macros for entire DCP_CTRL register
 */
/*@{*/
#define HW_DCP_CTRL_ADDR(x)      ((uintptr_t)(x) + 0x0U)

#define HW_DCP_CTRL(x)           (*(__IO hw_dcp_ctrl_t *) HW_DCP_CTRL_ADDR(x))
#define HW_DCP_CTRL_RD(x)        (HW_DCP_CTRL(x).U)
#define HW_DCP_CTRL_WR(x, v)     (HW_DCP_CTRL(x).U = (v))
#define HW_DCP_CTRL_SET(x, v)    (HW_DCP_CTRL_WR(x, HW_DCP_CTRL_RD(x) |  (v)))
#define HW_DCP_CTRL_CLR(x, v)    (HW_DCP_CTRL_WR(x, HW_DCP_CTRL_RD(x) & ~(v)))
#define HW_DCP_CTRL_TOG(x, v)    (HW_DCP_CTRL_WR(x, HW_DCP_CTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CTRL bitfields
 */

/*!
 * @name Register DCP_CTRL, field CHANNEL_INTERRUPT_ENABLE[7:0] (RW)
 *
 * Per-channel interrupt enable bit. When set, the channel's interrupt will get
 * routed to the interrupt controller. Channel 0 is routed to the dcp_vmi_irq
 * signal and the other channels are combined (along with the CRC interrupt) into
 * the dcp_irq signal.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 */
/*@{*/
#define BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE (0U) /*!< Bit position for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE. */
#define BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE (0x000000FFU) /*!< Bit mask for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE. */
#define BS_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE (8U) /*!< Bit field size in bits for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE. */

#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_CH0 (0x1U) /*!< Bit field value for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE:  */
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_CH1 (0x2U) /*!< Bit field value for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE:  */
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_CH2 (0x4U) /*!< Bit field value for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE:  */
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE_CH3 (0x8U) /*!< Bit field value for DCP_CTRL_CHANNEL_INTERRUPT_ENABLE:  */

/*! @brief Read current value of the DCP_CTRL_CHANNEL_INTERRUPT_ENABLE field. */
#define BR_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(x) (HW_DCP_CTRL(x).B.CHANNEL_INTERRUPT_ENABLE)

/*! @brief Format value for bitfield DCP_CTRL_CHANNEL_INTERRUPT_ENABLE. */
#define BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE) & BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE)

/*! @brief Set the CHANNEL_INTERRUPT_ENABLE field to a new value. */
#define BW_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE) | BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)))
/*@}*/

/*!
 * @name Register DCP_CTRL, field RSVD_CSC_INTERRUPT_ENABLE[8] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE (8U) /*!< Bit position for DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE. */
#define BM_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE (0x00000100U) /*!< Bit mask for DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE. */
#define BS_DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE (1U) /*!< Bit field size in bits for DCP_CTRL_RSVD_CSC_INTERRUPT_ENABLE. */
/*@}*/

/*!
 * @name Register DCP_CTRL, field ENABLE_CONTEXT_SWITCHING[21] (RW)
 *
 * Enable automatic context switching for the channels. Software should set this
 * bit if more than one channel is doing hashing or cipher operations that
 * require context to be saved (for instance, when CBC mode is enabled). By disabling
 * context switching, software can save the 208 bytes used for the context buffer.
 */
/*@{*/
#define BP_DCP_CTRL_ENABLE_CONTEXT_SWITCHING (21U) /*!< Bit position for DCP_CTRL_ENABLE_CONTEXT_SWITCHING. */
#define BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING (0x00200000U) /*!< Bit mask for DCP_CTRL_ENABLE_CONTEXT_SWITCHING. */
#define BS_DCP_CTRL_ENABLE_CONTEXT_SWITCHING (1U) /*!< Bit field size in bits for DCP_CTRL_ENABLE_CONTEXT_SWITCHING. */

/*! @brief Read current value of the DCP_CTRL_ENABLE_CONTEXT_SWITCHING field. */
#define BR_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(x) (HW_DCP_CTRL(x).B.ENABLE_CONTEXT_SWITCHING)

/*! @brief Format value for bitfield DCP_CTRL_ENABLE_CONTEXT_SWITCHING. */
#define BF_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_ENABLE_CONTEXT_SWITCHING) & BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING)

/*! @brief Set the ENABLE_CONTEXT_SWITCHING field to a new value. */
#define BW_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING) | BF_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v)))
/*@}*/

/*!
 * @name Register DCP_CTRL, field ENABLE_CONTEXT_CACHING[22] (RW)
 *
 * Software should set this bit to enable caching of contexts between
 * operations. If only a single channel is used for encryption/hashing, enabling caching
 * causes the context to not be reloaded if the channel was the last to be used.
 */
/*@{*/
#define BP_DCP_CTRL_ENABLE_CONTEXT_CACHING (22U) /*!< Bit position for DCP_CTRL_ENABLE_CONTEXT_CACHING. */
#define BM_DCP_CTRL_ENABLE_CONTEXT_CACHING (0x00400000U) /*!< Bit mask for DCP_CTRL_ENABLE_CONTEXT_CACHING. */
#define BS_DCP_CTRL_ENABLE_CONTEXT_CACHING (1U) /*!< Bit field size in bits for DCP_CTRL_ENABLE_CONTEXT_CACHING. */

/*! @brief Read current value of the DCP_CTRL_ENABLE_CONTEXT_CACHING field. */
#define BR_DCP_CTRL_ENABLE_CONTEXT_CACHING(x) (HW_DCP_CTRL(x).B.ENABLE_CONTEXT_CACHING)

/*! @brief Format value for bitfield DCP_CTRL_ENABLE_CONTEXT_CACHING. */
#define BF_DCP_CTRL_ENABLE_CONTEXT_CACHING(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_ENABLE_CONTEXT_CACHING) & BM_DCP_CTRL_ENABLE_CONTEXT_CACHING)

/*! @brief Set the ENABLE_CONTEXT_CACHING field to a new value. */
#define BW_DCP_CTRL_ENABLE_CONTEXT_CACHING(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_ENABLE_CONTEXT_CACHING) | BF_DCP_CTRL_ENABLE_CONTEXT_CACHING(v)))
/*@}*/

/*!
 * @name Register DCP_CTRL, field GATHER_RESIDUAL_WRITES[23] (RW)
 *
 * Software should set this bit to enable ragged writes to unaligned buffers to
 * be gathered between multiple write operations. This improves performance by
 * removing several byte operations between write bursts. Trailing byte writes are
 * held in a residual write data buffer and combined with a subsequent write to
 * the buffer to form a word write.
 */
/*@{*/
#define BP_DCP_CTRL_GATHER_RESIDUAL_WRITES (23U) /*!< Bit position for DCP_CTRL_GATHER_RESIDUAL_WRITES. */
#define BM_DCP_CTRL_GATHER_RESIDUAL_WRITES (0x00800000U) /*!< Bit mask for DCP_CTRL_GATHER_RESIDUAL_WRITES. */
#define BS_DCP_CTRL_GATHER_RESIDUAL_WRITES (1U) /*!< Bit field size in bits for DCP_CTRL_GATHER_RESIDUAL_WRITES. */

/*! @brief Read current value of the DCP_CTRL_GATHER_RESIDUAL_WRITES field. */
#define BR_DCP_CTRL_GATHER_RESIDUAL_WRITES(x) (HW_DCP_CTRL(x).B.GATHER_RESIDUAL_WRITES)

/*! @brief Format value for bitfield DCP_CTRL_GATHER_RESIDUAL_WRITES. */
#define BF_DCP_CTRL_GATHER_RESIDUAL_WRITES(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_GATHER_RESIDUAL_WRITES) & BM_DCP_CTRL_GATHER_RESIDUAL_WRITES)

/*! @brief Set the GATHER_RESIDUAL_WRITES field to a new value. */
#define BW_DCP_CTRL_GATHER_RESIDUAL_WRITES(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_GATHER_RESIDUAL_WRITES) | BF_DCP_CTRL_GATHER_RESIDUAL_WRITES(v)))
/*@}*/

/*!
 * @name Register DCP_CTRL, field PRESENT_SHA[28] (RO)
 *
 * Indicates whether the SHA1/SHA2 functions are present.
 *
 * Values:
 * - 1 -
 * - 0 -
 */
/*@{*/
#define BP_DCP_CTRL_PRESENT_SHA (28U)      /*!< Bit position for DCP_CTRL_PRESENT_SHA. */
#define BM_DCP_CTRL_PRESENT_SHA (0x10000000U) /*!< Bit mask for DCP_CTRL_PRESENT_SHA. */
#define BS_DCP_CTRL_PRESENT_SHA (1U)       /*!< Bit field size in bits for DCP_CTRL_PRESENT_SHA. */

#define BV_DCP_CTRL_PRESENT_SHA_Present (0x1U)       /*!< Bit field value for DCP_CTRL_PRESENT_SHA:  */
#define BV_DCP_CTRL_PRESENT_SHA_Absent (0U)          /*!< Bit field value for DCP_CTRL_PRESENT_SHA:  */

/*! @brief Read current value of the DCP_CTRL_PRESENT_SHA field. */
#define BR_DCP_CTRL_PRESENT_SHA(x) (HW_DCP_CTRL(x).B.PRESENT_SHA)
/*@}*/

/*!
 * @name Register DCP_CTRL, field PRESENT_CRYPTO[29] (RO)
 *
 * Indicates whether the crypto (Cipher/Hash) functions are present.
 *
 * Values:
 * - 1 -
 * - 0 -
 */
/*@{*/
#define BP_DCP_CTRL_PRESENT_CRYPTO (29U)   /*!< Bit position for DCP_CTRL_PRESENT_CRYPTO. */
#define BM_DCP_CTRL_PRESENT_CRYPTO (0x20000000U) /*!< Bit mask for DCP_CTRL_PRESENT_CRYPTO. */
#define BS_DCP_CTRL_PRESENT_CRYPTO (1U)    /*!< Bit field size in bits for DCP_CTRL_PRESENT_CRYPTO. */

#define BV_DCP_CTRL_PRESENT_CRYPTO_Present (0x1U)    /*!< Bit field value for DCP_CTRL_PRESENT_CRYPTO:  */
#define BV_DCP_CTRL_PRESENT_CRYPTO_Absent (0U)       /*!< Bit field value for DCP_CTRL_PRESENT_CRYPTO:  */

/*! @brief Read current value of the DCP_CTRL_PRESENT_CRYPTO field. */
#define BR_DCP_CTRL_PRESENT_CRYPTO(x) (HW_DCP_CTRL(x).B.PRESENT_CRYPTO)
/*@}*/

/*!
 * @name Register DCP_CTRL, field CLKGATE[30] (RW)
 *
 * This bit must be set to zero for normal operation. When set to one it gates
 * off the clocks to the block.
 */
/*@{*/
#define BP_DCP_CTRL_CLKGATE  (30U)         /*!< Bit position for DCP_CTRL_CLKGATE. */
#define BM_DCP_CTRL_CLKGATE  (0x40000000U) /*!< Bit mask for DCP_CTRL_CLKGATE. */
#define BS_DCP_CTRL_CLKGATE  (1U)          /*!< Bit field size in bits for DCP_CTRL_CLKGATE. */

/*! @brief Read current value of the DCP_CTRL_CLKGATE field. */
#define BR_DCP_CTRL_CLKGATE(x) (HW_DCP_CTRL(x).B.CLKGATE)

/*! @brief Format value for bitfield DCP_CTRL_CLKGATE. */
#define BF_DCP_CTRL_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_CLKGATE) & BM_DCP_CTRL_CLKGATE)

/*! @brief Set the CLKGATE field to a new value. */
#define BW_DCP_CTRL_CLKGATE(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_CLKGATE) | BF_DCP_CTRL_CLKGATE(v)))
/*@}*/

/*!
 * @name Register DCP_CTRL, field SFTRST[31] (RW)
 *
 * Set this bit to zero to enable normal DCP operation. Set this bit to one
 * (default) to disable clocking with the DCP and hold it in its reset (lowest power)
 * state. This bit can be turned on and then off to reset the DCP block to its
 * default state.
 */
/*@{*/
#define BP_DCP_CTRL_SFTRST   (31U)         /*!< Bit position for DCP_CTRL_SFTRST. */
#define BM_DCP_CTRL_SFTRST   (0x80000000U) /*!< Bit mask for DCP_CTRL_SFTRST. */
#define BS_DCP_CTRL_SFTRST   (1U)          /*!< Bit field size in bits for DCP_CTRL_SFTRST. */

/*! @brief Read current value of the DCP_CTRL_SFTRST field. */
#define BR_DCP_CTRL_SFTRST(x) (HW_DCP_CTRL(x).B.SFTRST)

/*! @brief Format value for bitfield DCP_CTRL_SFTRST. */
#define BF_DCP_CTRL_SFTRST(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CTRL_SFTRST) & BM_DCP_CTRL_SFTRST)

/*! @brief Set the SFTRST field to a new value. */
#define BW_DCP_CTRL_SFTRST(x, v) (HW_DCP_CTRL_WR(x, (HW_DCP_CTRL_RD(x) & ~BM_DCP_CTRL_SFTRST) | BF_DCP_CTRL_SFTRST(v)))
/*@}*/

/*******************************************************************************
 * HW_DCP_STAT - DCP Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_STAT - DCP Status Register (RW)
 *
 * Reset value: 0x10000000U
 *
 * The DCP Interrupt Status register provides channel interrupt status
 * information. STAT: 0x010 STAT_SET: 0x014 STAT_CLR: 0x018 STAT_TOG: 0x01C This register
 * provides status feedback indicating the channel currently performing an
 * operation and which channels have pending operations. EXAMPLE
 */
typedef union _hw_dcp_stat
{
    uint32_t U;
    struct _hw_dcp_stat_bitfields
    {
        uint32_t IRQ : 4;              /*!< [3:0]  */
        uint32_t RESERVED0 : 4;        /*!< [7:4]  */
        uint32_t RSVD_IRQ : 1;         /*!< [8]  */
        uint32_t RESERVED1 : 7;        /*!< [15:9]  */
        uint32_t READY_CHANNELS : 8;   /*!< [23:16]  */
        uint32_t CUR_CHANNEL : 4;      /*!< [27:24]  */
        uint32_t OTP_KEY_READY : 1;    /*!< [28]  */
        uint32_t RESERVED2 : 3;        /*!< [31:29]  */
    } B;
} hw_dcp_stat_t;

/*!
 * @name Constants and macros for entire DCP_STAT register
 */
/*@{*/
#define HW_DCP_STAT_ADDR(x)      ((uintptr_t)(x) + 0x10U)

#define HW_DCP_STAT(x)           (*(__IO hw_dcp_stat_t *) HW_DCP_STAT_ADDR(x))
#define HW_DCP_STAT_RD(x)        (HW_DCP_STAT(x).U)
#define HW_DCP_STAT_WR(x, v)     (HW_DCP_STAT(x).U = (v))
#define HW_DCP_STAT_SET(x, v)    (HW_DCP_STAT_WR(x, HW_DCP_STAT_RD(x) |  (v)))
#define HW_DCP_STAT_CLR(x, v)    (HW_DCP_STAT_WR(x, HW_DCP_STAT_RD(x) & ~(v)))
#define HW_DCP_STAT_TOG(x, v)    (HW_DCP_STAT_WR(x, HW_DCP_STAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_STAT bitfields
 */

/*!
 * @name Register DCP_STAT, field IRQ[3:0] (RW)
 *
 * Indicates which channels have pending interrupt requests. Channel 0's
 * interrupt is routed through the dcp_vmi_irq and the other interrupt bits are routed
 * through the dcp_irq.
 */
/*@{*/
#define BP_DCP_STAT_IRQ      (0U)          /*!< Bit position for DCP_STAT_IRQ. */
#define BM_DCP_STAT_IRQ      (0x0000000FU) /*!< Bit mask for DCP_STAT_IRQ. */
#define BS_DCP_STAT_IRQ      (4U)          /*!< Bit field size in bits for DCP_STAT_IRQ. */

/*! @brief Read current value of the DCP_STAT_IRQ field. */
#define BR_DCP_STAT_IRQ(x)   (HW_DCP_STAT(x).B.IRQ)

/*! @brief Format value for bitfield DCP_STAT_IRQ. */
#define BF_DCP_STAT_IRQ(v)   ((uint32_t)((uint32_t)(v) << BP_DCP_STAT_IRQ) & BM_DCP_STAT_IRQ)

/*! @brief Set the IRQ field to a new value. */
#define BW_DCP_STAT_IRQ(x, v) (HW_DCP_STAT_WR(x, (HW_DCP_STAT_RD(x) & ~BM_DCP_STAT_IRQ) | BF_DCP_STAT_IRQ(v)))
/*@}*/

/*!
 * @name Register DCP_STAT, field RSVD_IRQ[8] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_STAT_RSVD_IRQ (8U)          /*!< Bit position for DCP_STAT_RSVD_IRQ. */
#define BM_DCP_STAT_RSVD_IRQ (0x00000100U) /*!< Bit mask for DCP_STAT_RSVD_IRQ. */
#define BS_DCP_STAT_RSVD_IRQ (1U)          /*!< Bit field size in bits for DCP_STAT_RSVD_IRQ. */
/*@}*/

/*!
 * @name Register DCP_STAT, field READY_CHANNELS[23:16] (RO)
 *
 * Indicates which channels are ready to proceed with a transfer (active channel
 * also included). Each bit is a one-hot indicating the request status for the
 * associated channel.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 */
/*@{*/
#define BP_DCP_STAT_READY_CHANNELS (16U)   /*!< Bit position for DCP_STAT_READY_CHANNELS. */
#define BM_DCP_STAT_READY_CHANNELS (0x00FF0000U) /*!< Bit mask for DCP_STAT_READY_CHANNELS. */
#define BS_DCP_STAT_READY_CHANNELS (8U)    /*!< Bit field size in bits for DCP_STAT_READY_CHANNELS. */

#define BV_DCP_STAT_READY_CHANNELS_CH0 (0x1U)        /*!< Bit field value for DCP_STAT_READY_CHANNELS:  */
#define BV_DCP_STAT_READY_CHANNELS_CH1 (0x2U)        /*!< Bit field value for DCP_STAT_READY_CHANNELS:  */
#define BV_DCP_STAT_READY_CHANNELS_CH2 (0x4U)        /*!< Bit field value for DCP_STAT_READY_CHANNELS:  */
#define BV_DCP_STAT_READY_CHANNELS_CH3 (0x8U)        /*!< Bit field value for DCP_STAT_READY_CHANNELS:  */

/*! @brief Read current value of the DCP_STAT_READY_CHANNELS field. */
#define BR_DCP_STAT_READY_CHANNELS(x) (HW_DCP_STAT(x).B.READY_CHANNELS)
/*@}*/

/*!
 * @name Register DCP_STAT, field CUR_CHANNEL[27:24] (RO)
 *
 * Current (active) channel (encoded).
 *
 * Values:
 * - 0 -
 * - 1 -
 * - 10 -
 * - 11 -
 * - 100 -
 */
/*@{*/
#define BP_DCP_STAT_CUR_CHANNEL (24U)      /*!< Bit position for DCP_STAT_CUR_CHANNEL. */
#define BM_DCP_STAT_CUR_CHANNEL (0x0F000000U) /*!< Bit mask for DCP_STAT_CUR_CHANNEL. */
#define BS_DCP_STAT_CUR_CHANNEL (4U)       /*!< Bit field size in bits for DCP_STAT_CUR_CHANNEL. */

#define BV_DCP_STAT_CUR_CHANNEL_None   (0U)          /*!< Bit field value for DCP_STAT_CUR_CHANNEL:  */
#define BV_DCP_STAT_CUR_CHANNEL_CH0    (0x1U)        /*!< Bit field value for DCP_STAT_CUR_CHANNEL:  */
#define BV_DCP_STAT_CUR_CHANNEL_CH1    (0x2U)        /*!< Bit field value for DCP_STAT_CUR_CHANNEL:  */
#define BV_DCP_STAT_CUR_CHANNEL_CH2    (0x3U)        /*!< Bit field value for DCP_STAT_CUR_CHANNEL:  */
#define BV_DCP_STAT_CUR_CHANNEL_CH3    (0x4U)        /*!< Bit field value for DCP_STAT_CUR_CHANNEL:  */

/*! @brief Read current value of the DCP_STAT_CUR_CHANNEL field. */
#define BR_DCP_STAT_CUR_CHANNEL(x) (HW_DCP_STAT(x).B.CUR_CHANNEL)
/*@}*/

/*!
 * @name Register DCP_STAT, field OTP_KEY_READY[28] (RO)
 *
 * When set, indicates that the OTP key has been shifted from the fuse block and
 * is ready for use.
 */
/*@{*/
#define BP_DCP_STAT_OTP_KEY_READY (28U)    /*!< Bit position for DCP_STAT_OTP_KEY_READY. */
#define BM_DCP_STAT_OTP_KEY_READY (0x10000000U) /*!< Bit mask for DCP_STAT_OTP_KEY_READY. */
#define BS_DCP_STAT_OTP_KEY_READY (1U)     /*!< Bit field size in bits for DCP_STAT_OTP_KEY_READY. */

/*! @brief Read current value of the DCP_STAT_OTP_KEY_READY field. */
#define BR_DCP_STAT_OTP_KEY_READY(x) (HW_DCP_STAT(x).B.OTP_KEY_READY)
/*@}*/

/*******************************************************************************
 * HW_DCP_CHANNELCTRL - DCP Channel Control Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CHANNELCTRL - DCP Channel Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The DCP Channel Control register provides controls for channel arbitration
 * and channel enables. CHANNELCTRL: 0x020 CHANNELCTRL_SET: 0x024 CHANNELCTRL_CLR:
 * 0x028 CHANNELCTRL_TOG: 0x02C This register provides status feedback indicating
 * the channel currently performing an operation and which channels have pending
 * operations. EXAMPLE
 * BW_DCP_CHANNELCTRL_ENABLE_CHANNEL(BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH0); // enable channel 0
 */
typedef union _hw_dcp_channelctrl
{
    uint32_t U;
    struct _hw_dcp_channelctrl_bitfields
    {
        uint32_t ENABLE_CHANNEL : 8;   /*!< [7:0]  */
        uint32_t HIGH_PRIORITY_CHANNEL : 8; /*!< [15:8]  */
        uint32_t CH0_IRQ_MERGED : 1;   /*!< [16]  */
        uint32_t RSVD : 15;            /*!< [31:17]  */
    } B;
} hw_dcp_channelctrl_t;

/*!
 * @name Constants and macros for entire DCP_CHANNELCTRL register
 */
/*@{*/
#define HW_DCP_CHANNELCTRL_ADDR(x) ((uintptr_t)(x) + 0x20U)

#define HW_DCP_CHANNELCTRL(x)    (*(__IO hw_dcp_channelctrl_t *) HW_DCP_CHANNELCTRL_ADDR(x))
#define HW_DCP_CHANNELCTRL_RD(x) (HW_DCP_CHANNELCTRL(x).U)
#define HW_DCP_CHANNELCTRL_WR(x, v) (HW_DCP_CHANNELCTRL(x).U = (v))
#define HW_DCP_CHANNELCTRL_SET(x, v) (HW_DCP_CHANNELCTRL_WR(x, HW_DCP_CHANNELCTRL_RD(x) |  (v)))
#define HW_DCP_CHANNELCTRL_CLR(x, v) (HW_DCP_CHANNELCTRL_WR(x, HW_DCP_CHANNELCTRL_RD(x) & ~(v)))
#define HW_DCP_CHANNELCTRL_TOG(x, v) (HW_DCP_CHANNELCTRL_WR(x, HW_DCP_CHANNELCTRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CHANNELCTRL bitfields
 */

/*!
 * @name Register DCP_CHANNELCTRL, field ENABLE_CHANNEL[7:0] (RW)
 *
 * Setting a bit in this field will enabled the DMA channel associated with it.
 * This field is a direct input to the DMA channel arbiter. When not enabled, the
 * channel is denied access to the central DMA resources.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 */
/*@{*/
#define BP_DCP_CHANNELCTRL_ENABLE_CHANNEL (0U) /*!< Bit position for DCP_CHANNELCTRL_ENABLE_CHANNEL. */
#define BM_DCP_CHANNELCTRL_ENABLE_CHANNEL (0x000000FFU) /*!< Bit mask for DCP_CHANNELCTRL_ENABLE_CHANNEL. */
#define BS_DCP_CHANNELCTRL_ENABLE_CHANNEL (8U) /*!< Bit field size in bits for DCP_CHANNELCTRL_ENABLE_CHANNEL. */

#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL_CH0 (0x1U) /*!< Bit field value for DCP_CHANNELCTRL_ENABLE_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL_CH1 (0x2U) /*!< Bit field value for DCP_CHANNELCTRL_ENABLE_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL_CH2 (0x4U) /*!< Bit field value for DCP_CHANNELCTRL_ENABLE_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL_CH3 (0x8U) /*!< Bit field value for DCP_CHANNELCTRL_ENABLE_CHANNEL:  */

/*! @brief Read current value of the DCP_CHANNELCTRL_ENABLE_CHANNEL field. */
#define BR_DCP_CHANNELCTRL_ENABLE_CHANNEL(x) (HW_DCP_CHANNELCTRL(x).B.ENABLE_CHANNEL)

/*! @brief Format value for bitfield DCP_CHANNELCTRL_ENABLE_CHANNEL. */
#define BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CHANNELCTRL_ENABLE_CHANNEL) & BM_DCP_CHANNELCTRL_ENABLE_CHANNEL)

/*! @brief Set the ENABLE_CHANNEL field to a new value. */
#define BW_DCP_CHANNELCTRL_ENABLE_CHANNEL(x, v) (HW_DCP_CHANNELCTRL_WR(x, (HW_DCP_CHANNELCTRL_RD(x) & ~BM_DCP_CHANNELCTRL_ENABLE_CHANNEL) | BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)))
/*@}*/

/*!
 * @name Register DCP_CHANNELCTRL, field HIGH_PRIORITY_CHANNEL[15:8] (RW)
 *
 * Setting a bit in this field causes the corresponding channel to have
 * high-priority arbitration. High priority channels will be arbitrated round-robin and
 * will take precedence over other channels that are not marked as high priority.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 */
/*@{*/
#define BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL (8U) /*!< Bit position for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL. */
#define BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL (0x0000FF00U) /*!< Bit mask for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL. */
#define BS_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL (8U) /*!< Bit field size in bits for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL. */

#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_CH0 (0x1U) /*!< Bit field value for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_CH1 (0x2U) /*!< Bit field value for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_CH2 (0x4U) /*!< Bit field value for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL:  */
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL_CH3 (0x8U) /*!< Bit field value for DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL:  */

/*! @brief Read current value of the DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL field. */
#define BR_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(x) (HW_DCP_CHANNELCTRL(x).B.HIGH_PRIORITY_CHANNEL)

/*! @brief Format value for bitfield DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL. */
#define BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL) & BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL)

/*! @brief Set the HIGH_PRIORITY_CHANNEL field to a new value. */
#define BW_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(x, v) (HW_DCP_CHANNELCTRL_WR(x, (HW_DCP_CHANNELCTRL_RD(x) & ~BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL) | BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)))
/*@}*/

/*!
 * @name Register DCP_CHANNELCTRL, field CH0_IRQ_MERGED[16] (RW)
 *
 * Indicates that the interrupt for channel 0 should be merged with the other
 * interrupts on the shared dcp_irq interrupt. When set to 0, channel 0's interrupt
 * will be routed to the separate dcp_vmi_irq. When set to 1, the interrupt will
 * be routed to the shared DCP interrupt.
 */
/*@{*/
#define BP_DCP_CHANNELCTRL_CH0_IRQ_MERGED (16U) /*!< Bit position for DCP_CHANNELCTRL_CH0_IRQ_MERGED. */
#define BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED (0x00010000U) /*!< Bit mask for DCP_CHANNELCTRL_CH0_IRQ_MERGED. */
#define BS_DCP_CHANNELCTRL_CH0_IRQ_MERGED (1U) /*!< Bit field size in bits for DCP_CHANNELCTRL_CH0_IRQ_MERGED. */

/*! @brief Read current value of the DCP_CHANNELCTRL_CH0_IRQ_MERGED field. */
#define BR_DCP_CHANNELCTRL_CH0_IRQ_MERGED(x) (HW_DCP_CHANNELCTRL(x).B.CH0_IRQ_MERGED)

/*! @brief Format value for bitfield DCP_CHANNELCTRL_CH0_IRQ_MERGED. */
#define BF_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CHANNELCTRL_CH0_IRQ_MERGED) & BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED)

/*! @brief Set the CH0_IRQ_MERGED field to a new value. */
#define BW_DCP_CHANNELCTRL_CH0_IRQ_MERGED(x, v) (HW_DCP_CHANNELCTRL_WR(x, (HW_DCP_CHANNELCTRL_RD(x) & ~BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED) | BF_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v)))
/*@}*/

/*!
 * @name Register DCP_CHANNELCTRL, field RSVD[31:17] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_CHANNELCTRL_RSVD (17U)      /*!< Bit position for DCP_CHANNELCTRL_RSVD. */
#define BM_DCP_CHANNELCTRL_RSVD (0xFFFE0000U) /*!< Bit mask for DCP_CHANNELCTRL_RSVD. */
#define BS_DCP_CHANNELCTRL_RSVD (15U)      /*!< Bit field size in bits for DCP_CHANNELCTRL_RSVD. */
/*@}*/

/*******************************************************************************
 * HW_DCP_CAPABILITY0 - DCP Capability 0 Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CAPABILITY0 - DCP Capability 0 Register (RW)
 *
 * Reset value: 0x00000404U
 *
 * This register contains additional information about the DCP module
 * implementation parameters. This register provides capability information for the DCP
 * block. It indicates the number of channels implemented as well as the number of
 * key storage locations available for software use.
 */
typedef union _hw_dcp_capability0
{
    uint32_t U;
    struct _hw_dcp_capability0_bitfields
    {
        uint32_t NUM_KEYS : 8;         /*!< [7:0]  */
        uint32_t NUM_CHANNELS : 4;     /*!< [11:8]  */
        uint32_t RSVD : 17;            /*!< [28:12]  */
        uint32_t DISABLE_UNIQUE_KEY : 1; /*!< [29]  */
        uint32_t RESERVED0 : 1;        /*!< [30]  */
        uint32_t DISABLE_DECRYPT : 1;  /*!< [31]  */
    } B;
} hw_dcp_capability0_t;

/*!
 * @name Constants and macros for entire DCP_CAPABILITY0 register
 */
/*@{*/
#define HW_DCP_CAPABILITY0_ADDR(x) ((uintptr_t)(x) + 0x30U)

#define HW_DCP_CAPABILITY0(x)    (*(__IO hw_dcp_capability0_t *) HW_DCP_CAPABILITY0_ADDR(x))
#define HW_DCP_CAPABILITY0_RD(x) (HW_DCP_CAPABILITY0(x).U)
#define HW_DCP_CAPABILITY0_WR(x, v) (HW_DCP_CAPABILITY0(x).U = (v))
#define HW_DCP_CAPABILITY0_SET(x, v) (HW_DCP_CAPABILITY0_WR(x, HW_DCP_CAPABILITY0_RD(x) |  (v)))
#define HW_DCP_CAPABILITY0_CLR(x, v) (HW_DCP_CAPABILITY0_WR(x, HW_DCP_CAPABILITY0_RD(x) & ~(v)))
#define HW_DCP_CAPABILITY0_TOG(x, v) (HW_DCP_CAPABILITY0_WR(x, HW_DCP_CAPABILITY0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CAPABILITY0 bitfields
 */

/*!
 * @name Register DCP_CAPABILITY0, field NUM_KEYS[7:0] (RO)
 *
 * Encoded value indicating the number of key storage locations implemented in
 * the design.
 */
/*@{*/
#define BP_DCP_CAPABILITY0_NUM_KEYS (0U)   /*!< Bit position for DCP_CAPABILITY0_NUM_KEYS. */
#define BM_DCP_CAPABILITY0_NUM_KEYS (0x000000FFU) /*!< Bit mask for DCP_CAPABILITY0_NUM_KEYS. */
#define BS_DCP_CAPABILITY0_NUM_KEYS (8U)   /*!< Bit field size in bits for DCP_CAPABILITY0_NUM_KEYS. */

/*! @brief Read current value of the DCP_CAPABILITY0_NUM_KEYS field. */
#define BR_DCP_CAPABILITY0_NUM_KEYS(x) (HW_DCP_CAPABILITY0(x).B.NUM_KEYS)
/*@}*/

/*!
 * @name Register DCP_CAPABILITY0, field NUM_CHANNELS[11:8] (RO)
 *
 * Encoded value indicating the number of channels implemented in the design.
 */
/*@{*/
#define BP_DCP_CAPABILITY0_NUM_CHANNELS (8U) /*!< Bit position for DCP_CAPABILITY0_NUM_CHANNELS. */
#define BM_DCP_CAPABILITY0_NUM_CHANNELS (0x00000F00U) /*!< Bit mask for DCP_CAPABILITY0_NUM_CHANNELS. */
#define BS_DCP_CAPABILITY0_NUM_CHANNELS (4U) /*!< Bit field size in bits for DCP_CAPABILITY0_NUM_CHANNELS. */

/*! @brief Read current value of the DCP_CAPABILITY0_NUM_CHANNELS field. */
#define BR_DCP_CAPABILITY0_NUM_CHANNELS(x) (HW_DCP_CAPABILITY0(x).B.NUM_CHANNELS)
/*@}*/

/*!
 * @name Register DCP_CAPABILITY0, field RSVD[28:12] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_CAPABILITY0_RSVD (12U)      /*!< Bit position for DCP_CAPABILITY0_RSVD. */
#define BM_DCP_CAPABILITY0_RSVD (0x1FFFF000U) /*!< Bit mask for DCP_CAPABILITY0_RSVD. */
#define BS_DCP_CAPABILITY0_RSVD (17U)      /*!< Bit field size in bits for DCP_CAPABILITY0_RSVD. */
/*@}*/

/*!
 * @name Register DCP_CAPABILITY0, field DISABLE_UNIQUE_KEY[29] (RW)
 *
 * Write to a 1 disable the per-device unique key. The device-specific hardware
 * key may be selected by using a value of 0xFE in the key select field.
 */
/*@{*/
#define BP_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY (29U) /*!< Bit position for DCP_CAPABILITY0_DISABLE_UNIQUE_KEY. */
#define BM_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY (0x20000000U) /*!< Bit mask for DCP_CAPABILITY0_DISABLE_UNIQUE_KEY. */
#define BS_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY (1U) /*!< Bit field size in bits for DCP_CAPABILITY0_DISABLE_UNIQUE_KEY. */

/*! @brief Read current value of the DCP_CAPABILITY0_DISABLE_UNIQUE_KEY field. */
#define BR_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(x) (HW_DCP_CAPABILITY0(x).B.DISABLE_UNIQUE_KEY)

/*! @brief Format value for bitfield DCP_CAPABILITY0_DISABLE_UNIQUE_KEY. */
#define BF_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY) & BM_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY)

/*! @brief Set the DISABLE_UNIQUE_KEY field to a new value. */
#define BW_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(x, v) (HW_DCP_CAPABILITY0_WR(x, (HW_DCP_CAPABILITY0_RD(x) & ~BM_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY) | BF_DCP_CAPABILITY0_DISABLE_UNIQUE_KEY(v)))
/*@}*/

/*!
 * @name Register DCP_CAPABILITY0, field DISABLE_DECRYPT[31] (RW)
 *
 * Write to a 1 to disable decryption. This bit can only be written by secure
 * software and the value can only be cleared by a reset.
 */
/*@{*/
#define BP_DCP_CAPABILITY0_DISABLE_DECRYPT (31U) /*!< Bit position for DCP_CAPABILITY0_DISABLE_DECRYPT. */
#define BM_DCP_CAPABILITY0_DISABLE_DECRYPT (0x80000000U) /*!< Bit mask for DCP_CAPABILITY0_DISABLE_DECRYPT. */
#define BS_DCP_CAPABILITY0_DISABLE_DECRYPT (1U) /*!< Bit field size in bits for DCP_CAPABILITY0_DISABLE_DECRYPT. */

/*! @brief Read current value of the DCP_CAPABILITY0_DISABLE_DECRYPT field. */
#define BR_DCP_CAPABILITY0_DISABLE_DECRYPT(x) (HW_DCP_CAPABILITY0(x).B.DISABLE_DECRYPT)

/*! @brief Format value for bitfield DCP_CAPABILITY0_DISABLE_DECRYPT. */
#define BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CAPABILITY0_DISABLE_DECRYPT) & BM_DCP_CAPABILITY0_DISABLE_DECRYPT)

/*! @brief Set the DISABLE_DECRYPT field to a new value. */
#define BW_DCP_CAPABILITY0_DISABLE_DECRYPT(x, v) (HW_DCP_CAPABILITY0_WR(x, (HW_DCP_CAPABILITY0_RD(x) & ~BM_DCP_CAPABILITY0_DISABLE_DECRYPT) | BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v)))
/*@}*/

/*******************************************************************************
 * HW_DCP_CAPABILITY1 - DCP Capability 1 Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CAPABILITY1 - DCP Capability 1 Register (RO)
 *
 * Reset value: 0x00070001U
 *
 * This register contains information about the algorithms available on the
 * implementation. This register provides capability information for the DCP block.
 * It contains two fields indicating which encryption and hashing algorithms are
 * present in the design. Each bit set indicates that support for the associated
 * function is present.
 */
typedef union _hw_dcp_capability1
{
    uint32_t U;
    struct _hw_dcp_capability1_bitfields
    {
        uint32_t CIPHER_ALGORITHMS : 16; /*!< [15:0]  */
        uint32_t HASH_ALGORITHMS : 16; /*!< [31:16]  */
    } B;
} hw_dcp_capability1_t;

/*!
 * @name Constants and macros for entire DCP_CAPABILITY1 register
 */
/*@{*/
#define HW_DCP_CAPABILITY1_ADDR(x) ((uintptr_t)(x) + 0x40U)

#define HW_DCP_CAPABILITY1(x)    (*(__I hw_dcp_capability1_t *) HW_DCP_CAPABILITY1_ADDR(x))
#define HW_DCP_CAPABILITY1_RD(x) (HW_DCP_CAPABILITY1(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_CAPABILITY1 bitfields
 */

/*!
 * @name Register DCP_CAPABILITY1, field CIPHER_ALGORITHMS[15:0] (RO)
 *
 * One-hot field indicating which cipher algorithms are available.
 *
 * Values:
 * - 1 -
 */
/*@{*/
#define BP_DCP_CAPABILITY1_CIPHER_ALGORITHMS (0U) /*!< Bit position for DCP_CAPABILITY1_CIPHER_ALGORITHMS. */
#define BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS (0x0000FFFFU) /*!< Bit mask for DCP_CAPABILITY1_CIPHER_ALGORITHMS. */
#define BS_DCP_CAPABILITY1_CIPHER_ALGORITHMS (16U) /*!< Bit field size in bits for DCP_CAPABILITY1_CIPHER_ALGORITHMS. */

#define BV_DCP_CAPABILITY1_CIPHER_ALGORITHMS_AES128 (0x1U) /*!< Bit field value for DCP_CAPABILITY1_CIPHER_ALGORITHMS:  */

/*! @brief Read current value of the DCP_CAPABILITY1_CIPHER_ALGORITHMS field. */
#define BR_DCP_CAPABILITY1_CIPHER_ALGORITHMS(x) (HW_DCP_CAPABILITY1(x).B.CIPHER_ALGORITHMS)
/*@}*/

/*!
 * @name Register DCP_CAPABILITY1, field HASH_ALGORITHMS[31:16] (RO)
 *
 * One-hot field indicating which hashing features are implemented in HW.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 */
/*@{*/
#define BP_DCP_CAPABILITY1_HASH_ALGORITHMS (16U) /*!< Bit position for DCP_CAPABILITY1_HASH_ALGORITHMS. */
#define BM_DCP_CAPABILITY1_HASH_ALGORITHMS (0xFFFF0000U) /*!< Bit mask for DCP_CAPABILITY1_HASH_ALGORITHMS. */
#define BS_DCP_CAPABILITY1_HASH_ALGORITHMS (16U) /*!< Bit field size in bits for DCP_CAPABILITY1_HASH_ALGORITHMS. */

#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS_SHA1 (0x1U) /*!< Bit field value for DCP_CAPABILITY1_HASH_ALGORITHMS:  */
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS_CRC32 (0x2U) /*!< Bit field value for DCP_CAPABILITY1_HASH_ALGORITHMS:  */
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS_SHA256 (0x4U) /*!< Bit field value for DCP_CAPABILITY1_HASH_ALGORITHMS:  */

/*! @brief Read current value of the DCP_CAPABILITY1_HASH_ALGORITHMS field. */
#define BR_DCP_CAPABILITY1_HASH_ALGORITHMS(x) (HW_DCP_CAPABILITY1(x).B.HASH_ALGORITHMS)
/*@}*/

/*******************************************************************************
 * HW_DCP_CONTEXT - DCP Context Buffer Pointer
 ******************************************************************************/

/*!
 * @brief HW_DCP_CONTEXT - DCP Context Buffer Pointer (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains a pointer to the memory region to be used for DCP
 * context swap operations. This register contains a pointer to the start of the
 * context pointer memory in on-chip SRAM or off-chip SDRAM. This buffer will be used
 * to store state information when the DCP module changes from one channel to
 * another.
 */
typedef union _hw_dcp_context
{
    uint32_t U;
    struct _hw_dcp_context_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_context_t;

/*!
 * @name Constants and macros for entire DCP_CONTEXT register
 */
/*@{*/
#define HW_DCP_CONTEXT_ADDR(x)   ((uintptr_t)(x) + 0x50U)

#define HW_DCP_CONTEXT(x)        (*(__IO hw_dcp_context_t *) HW_DCP_CONTEXT_ADDR(x))
#define HW_DCP_CONTEXT_RD(x)     (HW_DCP_CONTEXT(x).U)
#define HW_DCP_CONTEXT_WR(x, v)  (HW_DCP_CONTEXT(x).U = (v))
#define HW_DCP_CONTEXT_SET(x, v) (HW_DCP_CONTEXT_WR(x, HW_DCP_CONTEXT_RD(x) |  (v)))
#define HW_DCP_CONTEXT_CLR(x, v) (HW_DCP_CONTEXT_WR(x, HW_DCP_CONTEXT_RD(x) & ~(v)))
#define HW_DCP_CONTEXT_TOG(x, v) (HW_DCP_CONTEXT_WR(x, HW_DCP_CONTEXT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CONTEXT bitfields
 */

/*!
 * @name Register DCP_CONTEXT, field ADDR[31:0] (RW)
 *
 * Context pointer address. Address should be located in system RAM and should
 * be word-aligned for optimal performance.
 */
/*@{*/
#define BP_DCP_CONTEXT_ADDR  (0U)          /*!< Bit position for DCP_CONTEXT_ADDR. */
#define BM_DCP_CONTEXT_ADDR  (0xFFFFFFFFU) /*!< Bit mask for DCP_CONTEXT_ADDR. */
#define BS_DCP_CONTEXT_ADDR  (32U)         /*!< Bit field size in bits for DCP_CONTEXT_ADDR. */

/*! @brief Read current value of the DCP_CONTEXT_ADDR field. */
#define BR_DCP_CONTEXT_ADDR(x) (HW_DCP_CONTEXT(x).U)

/*! @brief Format value for bitfield DCP_CONTEXT_ADDR. */
#define BF_DCP_CONTEXT_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CONTEXT_ADDR) & BM_DCP_CONTEXT_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_DCP_CONTEXT_ADDR(x, v) (HW_DCP_CONTEXT_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_DCP_KEY - DCP Key Index
 ******************************************************************************/

/*!
 * @brief HW_DCP_KEY - DCP Key Index (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains a pointer to the key location to be written. The DCP
 * module maintains a set of write-only keys that may be used by software. To
 * write a key, software must first write the desired key index/subword to this
 * register and then write the key values to the key registers (below). After each
 * write to the key data register, the SUBWORD field will increment to allow
 * software to write the subsequent key to be written without having to rewrite the key
 * index. EXAMPLE // write key 0 to 0x00112233_44556677_8899aabb_ccddeeff
 * DCP_KEY_WR(BF_DCP_KEY_INDEX(0) | BF_DCP_KEY_SUBWORD(0)); // set key index to key 0,
 * subword 0 DCP_KEYDATA_WR(0xccddeeff); // write key values (subword 0)
 * DCP_KEYDATA_WR(0x8899aabb); // write key values (subword 1) DCP_KEYDATA_WR(0x44556677);
 * // write key values (subword 2) DCP_KEYDATA_WR(0x00112233); // write key
 * values (subword 3)
 */
typedef union _hw_dcp_key
{
    uint32_t U;
    struct _hw_dcp_key_bitfields
    {
        uint32_t SUBWORD : 2;          /*!< [1:0]  */
        uint32_t RSVD_SUBWORD : 2;     /*!< [3:2]  */
        uint32_t INDEX : 2;            /*!< [5:4]  */
        uint32_t RSVD_INDEX : 2;       /*!< [7:6]  */
        uint32_t RSVD : 24;            /*!< [31:8]  */
    } B;
} hw_dcp_key_t;

/*!
 * @name Constants and macros for entire DCP_KEY register
 */
/*@{*/
#define HW_DCP_KEY_ADDR(x)       ((uintptr_t)(x) + 0x60U)

#define HW_DCP_KEY(x)            (*(__IO hw_dcp_key_t *) HW_DCP_KEY_ADDR(x))
#define HW_DCP_KEY_RD(x)         (HW_DCP_KEY(x).U)
#define HW_DCP_KEY_WR(x, v)      (HW_DCP_KEY(x).U = (v))
#define HW_DCP_KEY_SET(x, v)     (HW_DCP_KEY_WR(x, HW_DCP_KEY_RD(x) |  (v)))
#define HW_DCP_KEY_CLR(x, v)     (HW_DCP_KEY_WR(x, HW_DCP_KEY_RD(x) & ~(v)))
#define HW_DCP_KEY_TOG(x, v)     (HW_DCP_KEY_WR(x, HW_DCP_KEY_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_KEY bitfields
 */

/*!
 * @name Register DCP_KEY, field SUBWORD[1:0] (RW)
 *
 * Key subword pointer. Valid indices are 0-3. After each write to the key data
 * register, this field will increment.
 */
/*@{*/
#define BP_DCP_KEY_SUBWORD   (0U)          /*!< Bit position for DCP_KEY_SUBWORD. */
#define BM_DCP_KEY_SUBWORD   (0x00000003U) /*!< Bit mask for DCP_KEY_SUBWORD. */
#define BS_DCP_KEY_SUBWORD   (2U)          /*!< Bit field size in bits for DCP_KEY_SUBWORD. */

/*! @brief Read current value of the DCP_KEY_SUBWORD field. */
#define BR_DCP_KEY_SUBWORD(x) (HW_DCP_KEY(x).B.SUBWORD)

/*! @brief Format value for bitfield DCP_KEY_SUBWORD. */
#define BF_DCP_KEY_SUBWORD(v) ((uint32_t)((uint32_t)(v) << BP_DCP_KEY_SUBWORD) & BM_DCP_KEY_SUBWORD)

/*! @brief Set the SUBWORD field to a new value. */
#define BW_DCP_KEY_SUBWORD(x, v) (HW_DCP_KEY_WR(x, (HW_DCP_KEY_RD(x) & ~BM_DCP_KEY_SUBWORD) | BF_DCP_KEY_SUBWORD(v)))
/*@}*/

/*!
 * @name Register DCP_KEY, field RSVD_SUBWORD[3:2] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_KEY_RSVD_SUBWORD (2U)       /*!< Bit position for DCP_KEY_RSVD_SUBWORD. */
#define BM_DCP_KEY_RSVD_SUBWORD (0x0000000CU) /*!< Bit mask for DCP_KEY_RSVD_SUBWORD. */
#define BS_DCP_KEY_RSVD_SUBWORD (2U)       /*!< Bit field size in bits for DCP_KEY_RSVD_SUBWORD. */
/*@}*/

/*!
 * @name Register DCP_KEY, field INDEX[5:4] (RW)
 *
 * Key index pointer. Valid indices are 0-[number_keys].
 */
/*@{*/
#define BP_DCP_KEY_INDEX     (4U)          /*!< Bit position for DCP_KEY_INDEX. */
#define BM_DCP_KEY_INDEX     (0x00000030U) /*!< Bit mask for DCP_KEY_INDEX. */
#define BS_DCP_KEY_INDEX     (2U)          /*!< Bit field size in bits for DCP_KEY_INDEX. */

/*! @brief Read current value of the DCP_KEY_INDEX field. */
#define BR_DCP_KEY_INDEX(x)  (HW_DCP_KEY(x).B.INDEX)

/*! @brief Format value for bitfield DCP_KEY_INDEX. */
#define BF_DCP_KEY_INDEX(v)  ((uint32_t)((uint32_t)(v) << BP_DCP_KEY_INDEX) & BM_DCP_KEY_INDEX)

/*! @brief Set the INDEX field to a new value. */
#define BW_DCP_KEY_INDEX(x, v) (HW_DCP_KEY_WR(x, (HW_DCP_KEY_RD(x) & ~BM_DCP_KEY_INDEX) | BF_DCP_KEY_INDEX(v)))
/*@}*/

/*!
 * @name Register DCP_KEY, field RSVD_INDEX[7:6] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_KEY_RSVD_INDEX (6U)         /*!< Bit position for DCP_KEY_RSVD_INDEX. */
#define BM_DCP_KEY_RSVD_INDEX (0x000000C0U) /*!< Bit mask for DCP_KEY_RSVD_INDEX. */
#define BS_DCP_KEY_RSVD_INDEX (2U)         /*!< Bit field size in bits for DCP_KEY_RSVD_INDEX. */
/*@}*/

/*!
 * @name Register DCP_KEY, field RSVD[31:8] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_KEY_RSVD      (8U)          /*!< Bit position for DCP_KEY_RSVD. */
#define BM_DCP_KEY_RSVD      (0xFFFFFF00U) /*!< Bit mask for DCP_KEY_RSVD. */
#define BS_DCP_KEY_RSVD      (24U)         /*!< Bit field size in bits for DCP_KEY_RSVD. */
/*@}*/

/*******************************************************************************
 * HW_DCP_KEYDATA - DCP Key Data
 ******************************************************************************/

/*!
 * @brief HW_DCP_KEYDATA - DCP Key Data (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register provides write access to the key/key subword specified by the
 * Key Index Register. Writing this location updates the selected subword for the
 * key located at the index specified by the Key Index Register. A write also
 * triggers the SUBWORD field of the KEY register to increment to the next higher
 * word in the key. EXAMPLE // write key 0 to 0x00112233_44556677_8899aabb_ccddeeff
 * DCP_KEY_WR(BF_DCP_KEY_INDEX(0) | BF_DCP_KEY_SUBWORD(0)); // set key index to
 * key 0, subword 0 DCP_KEYDATA_WR(0xccddeeff); // write key values (subword 0)
 * DCP_KEYDATA_WR(0x8899aabb); // write key values (subword 1)
 * DCP_KEYDATA_WR(0x44556677); // write key values (subword 2) DCP_KEYDATA_WR(0x00112233); // write
 * key values (subword 3)
 */
typedef union _hw_dcp_keydata
{
    uint32_t U;
    struct _hw_dcp_keydata_bitfields
    {
        uint32_t DATA : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_keydata_t;

/*!
 * @name Constants and macros for entire DCP_KEYDATA register
 */
/*@{*/
#define HW_DCP_KEYDATA_ADDR(x)   ((uintptr_t)(x) + 0x70U)

#define HW_DCP_KEYDATA(x)        (*(__IO hw_dcp_keydata_t *) HW_DCP_KEYDATA_ADDR(x))
#define HW_DCP_KEYDATA_RD(x)     (HW_DCP_KEYDATA(x).U)
#define HW_DCP_KEYDATA_WR(x, v)  (HW_DCP_KEYDATA(x).U = (v))
#define HW_DCP_KEYDATA_SET(x, v) (HW_DCP_KEYDATA_WR(x, HW_DCP_KEYDATA_RD(x) |  (v)))
#define HW_DCP_KEYDATA_CLR(x, v) (HW_DCP_KEYDATA_WR(x, HW_DCP_KEYDATA_RD(x) & ~(v)))
#define HW_DCP_KEYDATA_TOG(x, v) (HW_DCP_KEYDATA_WR(x, HW_DCP_KEYDATA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_KEYDATA bitfields
 */

/*!
 * @name Register DCP_KEYDATA, field DATA[31:0] (RW)
 *
 * Word 0 data for key. This is the least-significant word.
 */
/*@{*/
#define BP_DCP_KEYDATA_DATA  (0U)          /*!< Bit position for DCP_KEYDATA_DATA. */
#define BM_DCP_KEYDATA_DATA  (0xFFFFFFFFU) /*!< Bit mask for DCP_KEYDATA_DATA. */
#define BS_DCP_KEYDATA_DATA  (32U)         /*!< Bit field size in bits for DCP_KEYDATA_DATA. */

/*! @brief Read current value of the DCP_KEYDATA_DATA field. */
#define BR_DCP_KEYDATA_DATA(x) (HW_DCP_KEYDATA(x).U)

/*! @brief Format value for bitfield DCP_KEYDATA_DATA. */
#define BF_DCP_KEYDATA_DATA(v) ((uint32_t)((uint32_t)(v) << BP_DCP_KEYDATA_DATA) & BM_DCP_KEYDATA_DATA)

/*! @brief Set the DATA field to a new value. */
#define BW_DCP_KEYDATA_DATA(x, v) (HW_DCP_KEYDATA_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET0 - DCP Work Packet 0 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET0 - DCP Work Packet 0 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x00
 * (Next Command) field. The Work Packet Status Registers show the contents of the
 * currently executing packet. When the channels are inactive, the packet status
 * register return 0. The register bits are fully documented here to document the
 * packet structure in memory.
 */
typedef union _hw_dcp_packet0
{
    uint32_t U;
    struct _hw_dcp_packet0_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_packet0_t;

/*!
 * @name Constants and macros for entire DCP_PACKET0 register
 */
/*@{*/
#define HW_DCP_PACKET0_ADDR(x)   ((uintptr_t)(x) + 0x80U)

#define HW_DCP_PACKET0(x)        (*(__I hw_dcp_packet0_t *) HW_DCP_PACKET0_ADDR(x))
#define HW_DCP_PACKET0_RD(x)     (HW_DCP_PACKET0(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET0 bitfields
 */

/*!
 * @name Register DCP_PACKET0, field ADDR[31:0] (RO)
 *
 * Next Pointer Register,
 */
/*@{*/
#define BP_DCP_PACKET0_ADDR  (0U)          /*!< Bit position for DCP_PACKET0_ADDR. */
#define BM_DCP_PACKET0_ADDR  (0xFFFFFFFFU) /*!< Bit mask for DCP_PACKET0_ADDR. */
#define BS_DCP_PACKET0_ADDR  (32U)         /*!< Bit field size in bits for DCP_PACKET0_ADDR. */

/*! @brief Read current value of the DCP_PACKET0_ADDR field. */
#define BR_DCP_PACKET0_ADDR(x) (HW_DCP_PACKET0(x).U)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET1 - DCP Work Packet 1 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET1 - DCP Work Packet 1 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x04
 * (control) field. This register shows the contents of the Control0 register from
 * the packet being processed.
 */
typedef union _hw_dcp_packet1
{
    uint32_t U;
    struct _hw_dcp_packet1_bitfields
    {
        uint32_t INTERRUPT : 1;        /*!< [0]  */
        uint32_t DECR_SEMAPHORE : 1;   /*!< [1]  */
        uint32_t CHAIN : 1;            /*!< [2]  */
        uint32_t CHAIN_CONTIGUOUS : 1; /*!< [3]  */
        uint32_t ENABLE_MEMCOPY : 1;   /*!< [4]  */
        uint32_t ENABLE_CIPHER : 1;    /*!< [5]  */
        uint32_t ENABLE_HASH : 1;      /*!< [6]  */
        uint32_t ENABLE_BLIT : 1;      /*!< [7]  */
        uint32_t CIPHER_ENCRYPT : 1;   /*!< [8]  */
        uint32_t CIPHER_INIT : 1;      /*!< [9]  */
        uint32_t OTP_KEY : 1;          /*!< [10]  */
        uint32_t PAYLOAD_KEY : 1;      /*!< [11]  */
        uint32_t HASH_INIT : 1;        /*!< [12]  */
        uint32_t HASH_TERM : 1;        /*!< [13]  */
        uint32_t CHECK_HASH : 1;       /*!< [14]  */
        uint32_t HASH_OUTPUT : 1;      /*!< [15]  */
        uint32_t CONSTANT_FILL : 1;    /*!< [16]  */
        uint32_t TEST_SEMA_IRQ : 1;    /*!< [17]  */
        uint32_t KEY_BYTESWAP : 1;     /*!< [18]  */
        uint32_t KEY_WORDSWAP : 1;     /*!< [19]  */
        uint32_t INPUT_BYTESWAP : 1;   /*!< [20]  */
        uint32_t INPUT_WORDSWAP : 1;   /*!< [21]  */
        uint32_t OUTPUT_BYTESWAP : 1;  /*!< [22]  */
        uint32_t OUTPUT_WORDSWAP : 1;  /*!< [23]  */
        uint32_t TAG : 8;              /*!< [31:24]  */
    } B;
} hw_dcp_packet1_t;

/*!
 * @name Constants and macros for entire DCP_PACKET1 register
 */
/*@{*/
#define HW_DCP_PACKET1_ADDR(x)   ((uintptr_t)(x) + 0x90U)

#define HW_DCP_PACKET1(x)        (*(__I hw_dcp_packet1_t *) HW_DCP_PACKET1_ADDR(x))
#define HW_DCP_PACKET1_RD(x)     (HW_DCP_PACKET1(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET1 bitfields
 */

/*!
 * @name Register DCP_PACKET1, field INTERRUPT[0] (RO)
 *
 * Reflects whether the channel should issue an interrupt upon completion of the
 * packet.
 */
/*@{*/
#define BP_DCP_PACKET1_INTERRUPT (0U)      /*!< Bit position for DCP_PACKET1_INTERRUPT. */
#define BM_DCP_PACKET1_INTERRUPT (0x00000001U) /*!< Bit mask for DCP_PACKET1_INTERRUPT. */
#define BS_DCP_PACKET1_INTERRUPT (1U)      /*!< Bit field size in bits for DCP_PACKET1_INTERRUPT. */

/*! @brief Read current value of the DCP_PACKET1_INTERRUPT field. */
#define BR_DCP_PACKET1_INTERRUPT(x) (HW_DCP_PACKET1(x).B.INTERRUPT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field DECR_SEMAPHORE[1] (RO)
 *
 * Reflects whether the channel's semaphore should be decremented at the end of
 * the current operation. When the semaphore reaches a value of zero, no more
 * operations will be issued from the channel.
 */
/*@{*/
#define BP_DCP_PACKET1_DECR_SEMAPHORE (1U) /*!< Bit position for DCP_PACKET1_DECR_SEMAPHORE. */
#define BM_DCP_PACKET1_DECR_SEMAPHORE (0x00000002U) /*!< Bit mask for DCP_PACKET1_DECR_SEMAPHORE. */
#define BS_DCP_PACKET1_DECR_SEMAPHORE (1U) /*!< Bit field size in bits for DCP_PACKET1_DECR_SEMAPHORE. */

/*! @brief Read current value of the DCP_PACKET1_DECR_SEMAPHORE field. */
#define BR_DCP_PACKET1_DECR_SEMAPHORE(x) (HW_DCP_PACKET1(x).B.DECR_SEMAPHORE)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CHAIN[2] (RO)
 *
 * Reflects whether the next command pointer register should be loaded into the
 * channel's current descriptor pointer.
 */
/*@{*/
#define BP_DCP_PACKET1_CHAIN (2U)          /*!< Bit position for DCP_PACKET1_CHAIN. */
#define BM_DCP_PACKET1_CHAIN (0x00000004U) /*!< Bit mask for DCP_PACKET1_CHAIN. */
#define BS_DCP_PACKET1_CHAIN (1U)          /*!< Bit field size in bits for DCP_PACKET1_CHAIN. */

/*! @brief Read current value of the DCP_PACKET1_CHAIN field. */
#define BR_DCP_PACKET1_CHAIN(x) (HW_DCP_PACKET1(x).B.CHAIN)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CHAIN_CONTIGUOUS[3] (RO)
 *
 * Reflects whether the next packet's address is located following this packet's
 * payload.
 */
/*@{*/
#define BP_DCP_PACKET1_CHAIN_CONTIGUOUS (3U) /*!< Bit position for DCP_PACKET1_CHAIN_CONTIGUOUS. */
#define BM_DCP_PACKET1_CHAIN_CONTIGUOUS (0x00000008U) /*!< Bit mask for DCP_PACKET1_CHAIN_CONTIGUOUS. */
#define BS_DCP_PACKET1_CHAIN_CONTIGUOUS (1U) /*!< Bit field size in bits for DCP_PACKET1_CHAIN_CONTIGUOUS. */

/*! @brief Read current value of the DCP_PACKET1_CHAIN_CONTIGUOUS field. */
#define BR_DCP_PACKET1_CHAIN_CONTIGUOUS(x) (HW_DCP_PACKET1(x).B.CHAIN_CONTIGUOUS)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field ENABLE_MEMCOPY[4] (RO)
 *
 * Reflects whether the selected hashing function should be enabled for this
 * operation.
 */
/*@{*/
#define BP_DCP_PACKET1_ENABLE_MEMCOPY (4U) /*!< Bit position for DCP_PACKET1_ENABLE_MEMCOPY. */
#define BM_DCP_PACKET1_ENABLE_MEMCOPY (0x00000010U) /*!< Bit mask for DCP_PACKET1_ENABLE_MEMCOPY. */
#define BS_DCP_PACKET1_ENABLE_MEMCOPY (1U) /*!< Bit field size in bits for DCP_PACKET1_ENABLE_MEMCOPY. */

/*! @brief Read current value of the DCP_PACKET1_ENABLE_MEMCOPY field. */
#define BR_DCP_PACKET1_ENABLE_MEMCOPY(x) (HW_DCP_PACKET1(x).B.ENABLE_MEMCOPY)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field ENABLE_CIPHER[5] (RO)
 *
 * Reflects whether the selected cipher function should be enabled for this
 * operation.
 */
/*@{*/
#define BP_DCP_PACKET1_ENABLE_CIPHER (5U)  /*!< Bit position for DCP_PACKET1_ENABLE_CIPHER. */
#define BM_DCP_PACKET1_ENABLE_CIPHER (0x00000020U) /*!< Bit mask for DCP_PACKET1_ENABLE_CIPHER. */
#define BS_DCP_PACKET1_ENABLE_CIPHER (1U)  /*!< Bit field size in bits for DCP_PACKET1_ENABLE_CIPHER. */

/*! @brief Read current value of the DCP_PACKET1_ENABLE_CIPHER field. */
#define BR_DCP_PACKET1_ENABLE_CIPHER(x) (HW_DCP_PACKET1(x).B.ENABLE_CIPHER)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field ENABLE_HASH[6] (RO)
 *
 * Reflects whether the selected hashing function should be enabled for this
 * operation.
 */
/*@{*/
#define BP_DCP_PACKET1_ENABLE_HASH (6U)    /*!< Bit position for DCP_PACKET1_ENABLE_HASH. */
#define BM_DCP_PACKET1_ENABLE_HASH (0x00000040U) /*!< Bit mask for DCP_PACKET1_ENABLE_HASH. */
#define BS_DCP_PACKET1_ENABLE_HASH (1U)    /*!< Bit field size in bits for DCP_PACKET1_ENABLE_HASH. */

/*! @brief Read current value of the DCP_PACKET1_ENABLE_HASH field. */
#define BR_DCP_PACKET1_ENABLE_HASH(x) (HW_DCP_PACKET1(x).B.ENABLE_HASH)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field ENABLE_BLIT[7] (RO)
 *
 * Reflects whether the DCP should perform a blit operation. Source data is
 * always continuous and the destination buffer is written in run/stride format. When
 * set, the BUFFER_SIZE field is treated as two 16-bit values for the X-Y
 * extents of the blit operation.
 */
/*@{*/
#define BP_DCP_PACKET1_ENABLE_BLIT (7U)    /*!< Bit position for DCP_PACKET1_ENABLE_BLIT. */
#define BM_DCP_PACKET1_ENABLE_BLIT (0x00000080U) /*!< Bit mask for DCP_PACKET1_ENABLE_BLIT. */
#define BS_DCP_PACKET1_ENABLE_BLIT (1U)    /*!< Bit field size in bits for DCP_PACKET1_ENABLE_BLIT. */

/*! @brief Read current value of the DCP_PACKET1_ENABLE_BLIT field. */
#define BR_DCP_PACKET1_ENABLE_BLIT(x) (HW_DCP_PACKET1(x).B.ENABLE_BLIT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CIPHER_ENCRYPT[8] (RO)
 *
 * When the cipher block is enabled, this bit indicates whether the operation is
 * encryption or decryption.
 *
 * Values:
 * - 1 -
 * - 0 -
 */
/*@{*/
#define BP_DCP_PACKET1_CIPHER_ENCRYPT (8U) /*!< Bit position for DCP_PACKET1_CIPHER_ENCRYPT. */
#define BM_DCP_PACKET1_CIPHER_ENCRYPT (0x00000100U) /*!< Bit mask for DCP_PACKET1_CIPHER_ENCRYPT. */
#define BS_DCP_PACKET1_CIPHER_ENCRYPT (1U) /*!< Bit field size in bits for DCP_PACKET1_CIPHER_ENCRYPT. */

#define BV_DCP_PACKET1_CIPHER_ENCRYPT_ENCRYPT (0x1U) /*!< Bit field value for DCP_PACKET1_CIPHER_ENCRYPT:  */
#define BV_DCP_PACKET1_CIPHER_ENCRYPT_DECRYPT (0U)   /*!< Bit field value for DCP_PACKET1_CIPHER_ENCRYPT:  */

/*! @brief Read current value of the DCP_PACKET1_CIPHER_ENCRYPT field. */
#define BR_DCP_PACKET1_CIPHER_ENCRYPT(x) (HW_DCP_PACKET1(x).B.CIPHER_ENCRYPT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CIPHER_INIT[9] (RO)
 *
 * Reflects whether the cipher block should load the initialization vector from
 * the payload for this operation.
 */
/*@{*/
#define BP_DCP_PACKET1_CIPHER_INIT (9U)    /*!< Bit position for DCP_PACKET1_CIPHER_INIT. */
#define BM_DCP_PACKET1_CIPHER_INIT (0x00000200U) /*!< Bit mask for DCP_PACKET1_CIPHER_INIT. */
#define BS_DCP_PACKET1_CIPHER_INIT (1U)    /*!< Bit field size in bits for DCP_PACKET1_CIPHER_INIT. */

/*! @brief Read current value of the DCP_PACKET1_CIPHER_INIT field. */
#define BR_DCP_PACKET1_CIPHER_INIT(x) (HW_DCP_PACKET1(x).B.CIPHER_INIT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field OTP_KEY[10] (RO)
 *
 * Reflects whether a hardware-based key should be used. The KEY_SELECT field
 * from the Control1 field is used to select from multiple hardware keys. The
 * PAYLOAD_KEY bit takes precedence over the OTP_KEY bit.
 */
/*@{*/
#define BP_DCP_PACKET1_OTP_KEY (10U)       /*!< Bit position for DCP_PACKET1_OTP_KEY. */
#define BM_DCP_PACKET1_OTP_KEY (0x00000400U) /*!< Bit mask for DCP_PACKET1_OTP_KEY. */
#define BS_DCP_PACKET1_OTP_KEY (1U)        /*!< Bit field size in bits for DCP_PACKET1_OTP_KEY. */

/*! @brief Read current value of the DCP_PACKET1_OTP_KEY field. */
#define BR_DCP_PACKET1_OTP_KEY(x) (HW_DCP_PACKET1(x).B.OTP_KEY)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field PAYLOAD_KEY[11] (RO)
 *
 * When set, indicates the payload contains the key. This bit takes precedence
 * over the OTP_KEY control
 */
/*@{*/
#define BP_DCP_PACKET1_PAYLOAD_KEY (11U)   /*!< Bit position for DCP_PACKET1_PAYLOAD_KEY. */
#define BM_DCP_PACKET1_PAYLOAD_KEY (0x00000800U) /*!< Bit mask for DCP_PACKET1_PAYLOAD_KEY. */
#define BS_DCP_PACKET1_PAYLOAD_KEY (1U)    /*!< Bit field size in bits for DCP_PACKET1_PAYLOAD_KEY. */

/*! @brief Read current value of the DCP_PACKET1_PAYLOAD_KEY field. */
#define BR_DCP_PACKET1_PAYLOAD_KEY(x) (HW_DCP_PACKET1(x).B.PAYLOAD_KEY)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field HASH_INIT[12] (RO)
 *
 * Reflects whether the current hashing block is the initial block in the
 * hashing operation, so the hash registers should be initialized before the operation.
 */
/*@{*/
#define BP_DCP_PACKET1_HASH_INIT (12U)     /*!< Bit position for DCP_PACKET1_HASH_INIT. */
#define BM_DCP_PACKET1_HASH_INIT (0x00001000U) /*!< Bit mask for DCP_PACKET1_HASH_INIT. */
#define BS_DCP_PACKET1_HASH_INIT (1U)      /*!< Bit field size in bits for DCP_PACKET1_HASH_INIT. */

/*! @brief Read current value of the DCP_PACKET1_HASH_INIT field. */
#define BR_DCP_PACKET1_HASH_INIT(x) (HW_DCP_PACKET1(x).B.HASH_INIT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field HASH_TERM[13] (RO)
 *
 * Reflects whether the current hashing block is the final block in the hashing
 * operation, so the hash padding should be applied by hardware.
 */
/*@{*/
#define BP_DCP_PACKET1_HASH_TERM (13U)     /*!< Bit position for DCP_PACKET1_HASH_TERM. */
#define BM_DCP_PACKET1_HASH_TERM (0x00002000U) /*!< Bit mask for DCP_PACKET1_HASH_TERM. */
#define BS_DCP_PACKET1_HASH_TERM (1U)      /*!< Bit field size in bits for DCP_PACKET1_HASH_TERM. */

/*! @brief Read current value of the DCP_PACKET1_HASH_TERM field. */
#define BR_DCP_PACKET1_HASH_TERM(x) (HW_DCP_PACKET1(x).B.HASH_TERM)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CHECK_HASH[14] (RO)
 *
 * Reflects whether the calculated hash value should be compared against the
 * hash provided in the payload.
 */
/*@{*/
#define BP_DCP_PACKET1_CHECK_HASH (14U)    /*!< Bit position for DCP_PACKET1_CHECK_HASH. */
#define BM_DCP_PACKET1_CHECK_HASH (0x00004000U) /*!< Bit mask for DCP_PACKET1_CHECK_HASH. */
#define BS_DCP_PACKET1_CHECK_HASH (1U)     /*!< Bit field size in bits for DCP_PACKET1_CHECK_HASH. */

/*! @brief Read current value of the DCP_PACKET1_CHECK_HASH field. */
#define BR_DCP_PACKET1_CHECK_HASH(x) (HW_DCP_PACKET1(x).B.CHECK_HASH)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field HASH_OUTPUT[15] (RO)
 *
 * When hashing is enabled, this bit controls whether the input or output data
 * is hashed.
 *
 * Values:
 * - 0 -
 * - 1 -
 */
/*@{*/
#define BP_DCP_PACKET1_HASH_OUTPUT (15U)   /*!< Bit position for DCP_PACKET1_HASH_OUTPUT. */
#define BM_DCP_PACKET1_HASH_OUTPUT (0x00008000U) /*!< Bit mask for DCP_PACKET1_HASH_OUTPUT. */
#define BS_DCP_PACKET1_HASH_OUTPUT (1U)    /*!< Bit field size in bits for DCP_PACKET1_HASH_OUTPUT. */

#define BV_DCP_PACKET1_HASH_OUTPUT_INPUT (0U)        /*!< Bit field value for DCP_PACKET1_HASH_OUTPUT:  */
#define BV_DCP_PACKET1_HASH_OUTPUT_OUTPUT (0x1U)     /*!< Bit field value for DCP_PACKET1_HASH_OUTPUT:  */

/*! @brief Read current value of the DCP_PACKET1_HASH_OUTPUT field. */
#define BR_DCP_PACKET1_HASH_OUTPUT(x) (HW_DCP_PACKET1(x).B.HASH_OUTPUT)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field CONSTANT_FILL[16] (RO)
 *
 * When this bit is set (MEMCOPY and BLIT modes only), the DCP will simply fill
 * the destination buffer with the value found in the Source Address field.
 */
/*@{*/
#define BP_DCP_PACKET1_CONSTANT_FILL (16U) /*!< Bit position for DCP_PACKET1_CONSTANT_FILL. */
#define BM_DCP_PACKET1_CONSTANT_FILL (0x00010000U) /*!< Bit mask for DCP_PACKET1_CONSTANT_FILL. */
#define BS_DCP_PACKET1_CONSTANT_FILL (1U)  /*!< Bit field size in bits for DCP_PACKET1_CONSTANT_FILL. */

/*! @brief Read current value of the DCP_PACKET1_CONSTANT_FILL field. */
#define BR_DCP_PACKET1_CONSTANT_FILL(x) (HW_DCP_PACKET1(x).B.CONSTANT_FILL)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field TEST_SEMA_IRQ[17] (RO)
 *
 * This bit is used to test the channel semaphore transition to 0. FOR TEST USE
 * ONLY!
 */
/*@{*/
#define BP_DCP_PACKET1_TEST_SEMA_IRQ (17U) /*!< Bit position for DCP_PACKET1_TEST_SEMA_IRQ. */
#define BM_DCP_PACKET1_TEST_SEMA_IRQ (0x00020000U) /*!< Bit mask for DCP_PACKET1_TEST_SEMA_IRQ. */
#define BS_DCP_PACKET1_TEST_SEMA_IRQ (1U)  /*!< Bit field size in bits for DCP_PACKET1_TEST_SEMA_IRQ. */

/*! @brief Read current value of the DCP_PACKET1_TEST_SEMA_IRQ field. */
#define BR_DCP_PACKET1_TEST_SEMA_IRQ(x) (HW_DCP_PACKET1(x).B.TEST_SEMA_IRQ)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field KEY_BYTESWAP[18] (RO)
 *
 * Reflects whether the DCP engine will swap key bytes (big-endian key).
 */
/*@{*/
#define BP_DCP_PACKET1_KEY_BYTESWAP (18U)  /*!< Bit position for DCP_PACKET1_KEY_BYTESWAP. */
#define BM_DCP_PACKET1_KEY_BYTESWAP (0x00040000U) /*!< Bit mask for DCP_PACKET1_KEY_BYTESWAP. */
#define BS_DCP_PACKET1_KEY_BYTESWAP (1U)   /*!< Bit field size in bits for DCP_PACKET1_KEY_BYTESWAP. */

/*! @brief Read current value of the DCP_PACKET1_KEY_BYTESWAP field. */
#define BR_DCP_PACKET1_KEY_BYTESWAP(x) (HW_DCP_PACKET1(x).B.KEY_BYTESWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field KEY_WORDSWAP[19] (RO)
 *
 * Reflects whether the DCP engine will swap key words (big-endian key).
 */
/*@{*/
#define BP_DCP_PACKET1_KEY_WORDSWAP (19U)  /*!< Bit position for DCP_PACKET1_KEY_WORDSWAP. */
#define BM_DCP_PACKET1_KEY_WORDSWAP (0x00080000U) /*!< Bit mask for DCP_PACKET1_KEY_WORDSWAP. */
#define BS_DCP_PACKET1_KEY_WORDSWAP (1U)   /*!< Bit field size in bits for DCP_PACKET1_KEY_WORDSWAP. */

/*! @brief Read current value of the DCP_PACKET1_KEY_WORDSWAP field. */
#define BR_DCP_PACKET1_KEY_WORDSWAP(x) (HW_DCP_PACKET1(x).B.KEY_WORDSWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field INPUT_BYTESWAP[20] (RO)
 *
 * Reflects whether the DCP engine will byteswap input data (big-endian data).
 */
/*@{*/
#define BP_DCP_PACKET1_INPUT_BYTESWAP (20U) /*!< Bit position for DCP_PACKET1_INPUT_BYTESWAP. */
#define BM_DCP_PACKET1_INPUT_BYTESWAP (0x00100000U) /*!< Bit mask for DCP_PACKET1_INPUT_BYTESWAP. */
#define BS_DCP_PACKET1_INPUT_BYTESWAP (1U) /*!< Bit field size in bits for DCP_PACKET1_INPUT_BYTESWAP. */

/*! @brief Read current value of the DCP_PACKET1_INPUT_BYTESWAP field. */
#define BR_DCP_PACKET1_INPUT_BYTESWAP(x) (HW_DCP_PACKET1(x).B.INPUT_BYTESWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field INPUT_WORDSWAP[21] (RO)
 *
 * Reflects whether the DCP engine will wordswap input data (big-endian data).
 */
/*@{*/
#define BP_DCP_PACKET1_INPUT_WORDSWAP (21U) /*!< Bit position for DCP_PACKET1_INPUT_WORDSWAP. */
#define BM_DCP_PACKET1_INPUT_WORDSWAP (0x00200000U) /*!< Bit mask for DCP_PACKET1_INPUT_WORDSWAP. */
#define BS_DCP_PACKET1_INPUT_WORDSWAP (1U) /*!< Bit field size in bits for DCP_PACKET1_INPUT_WORDSWAP. */

/*! @brief Read current value of the DCP_PACKET1_INPUT_WORDSWAP field. */
#define BR_DCP_PACKET1_INPUT_WORDSWAP(x) (HW_DCP_PACKET1(x).B.INPUT_WORDSWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field OUTPUT_BYTESWAP[22] (RO)
 *
 * Reflects whether the DCP engine will byteswap output data (big-endian data).
 */
/*@{*/
#define BP_DCP_PACKET1_OUTPUT_BYTESWAP (22U) /*!< Bit position for DCP_PACKET1_OUTPUT_BYTESWAP. */
#define BM_DCP_PACKET1_OUTPUT_BYTESWAP (0x00400000U) /*!< Bit mask for DCP_PACKET1_OUTPUT_BYTESWAP. */
#define BS_DCP_PACKET1_OUTPUT_BYTESWAP (1U) /*!< Bit field size in bits for DCP_PACKET1_OUTPUT_BYTESWAP. */

/*! @brief Read current value of the DCP_PACKET1_OUTPUT_BYTESWAP field. */
#define BR_DCP_PACKET1_OUTPUT_BYTESWAP(x) (HW_DCP_PACKET1(x).B.OUTPUT_BYTESWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field OUTPUT_WORDSWAP[23] (RO)
 *
 * Reflects whether the DCP engine will wordswap output data (big-endian data).
 */
/*@{*/
#define BP_DCP_PACKET1_OUTPUT_WORDSWAP (23U) /*!< Bit position for DCP_PACKET1_OUTPUT_WORDSWAP. */
#define BM_DCP_PACKET1_OUTPUT_WORDSWAP (0x00800000U) /*!< Bit mask for DCP_PACKET1_OUTPUT_WORDSWAP. */
#define BS_DCP_PACKET1_OUTPUT_WORDSWAP (1U) /*!< Bit field size in bits for DCP_PACKET1_OUTPUT_WORDSWAP. */

/*! @brief Read current value of the DCP_PACKET1_OUTPUT_WORDSWAP field. */
#define BR_DCP_PACKET1_OUTPUT_WORDSWAP(x) (HW_DCP_PACKET1(x).B.OUTPUT_WORDSWAP)
/*@}*/

/*!
 * @name Register DCP_PACKET1, field TAG[31:24] (RO)
 *
 * Packet Tag
 */
/*@{*/
#define BP_DCP_PACKET1_TAG   (24U)         /*!< Bit position for DCP_PACKET1_TAG. */
#define BM_DCP_PACKET1_TAG   (0xFF000000U) /*!< Bit mask for DCP_PACKET1_TAG. */
#define BS_DCP_PACKET1_TAG   (8U)          /*!< Bit field size in bits for DCP_PACKET1_TAG. */

/*! @brief Read current value of the DCP_PACKET1_TAG field. */
#define BR_DCP_PACKET1_TAG(x) (HW_DCP_PACKET1(x).B.TAG)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET2 - DCP Work Packet 2 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET2 - DCP Work Packet 2 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x08
 * (Control1) field. This register shows the contents of the Control0 register from
 * the packet being processed.
 */
typedef union _hw_dcp_packet2
{
    uint32_t U;
    struct _hw_dcp_packet2_bitfields
    {
        uint32_t CIPHER_SELECT : 4;    /*!< [3:0]  */
        uint32_t CIPHER_MODE : 4;      /*!< [7:4]  */
        uint32_t KEY_SELECT : 8;       /*!< [15:8]  */
        uint32_t HASH_SELECT : 4;      /*!< [19:16]  */
        uint32_t RSVD : 4;             /*!< [23:20]  */
        uint32_t CIPHER_CFG : 8;       /*!< [31:24]  */
    } B;
} hw_dcp_packet2_t;

/*!
 * @name Constants and macros for entire DCP_PACKET2 register
 */
/*@{*/
#define HW_DCP_PACKET2_ADDR(x)   ((uintptr_t)(x) + 0xA0U)

#define HW_DCP_PACKET2(x)        (*(__I hw_dcp_packet2_t *) HW_DCP_PACKET2_ADDR(x))
#define HW_DCP_PACKET2_RD(x)     (HW_DCP_PACKET2(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET2 bitfields
 */

/*!
 * @name Register DCP_PACKET2, field CIPHER_SELECT[3:0] (RO)
 *
 * Cipher Selection Field
 *
 * Values:
 * - 0 -
 */
/*@{*/
#define BP_DCP_PACKET2_CIPHER_SELECT (0U)  /*!< Bit position for DCP_PACKET2_CIPHER_SELECT. */
#define BM_DCP_PACKET2_CIPHER_SELECT (0x0000000FU) /*!< Bit mask for DCP_PACKET2_CIPHER_SELECT. */
#define BS_DCP_PACKET2_CIPHER_SELECT (4U)  /*!< Bit field size in bits for DCP_PACKET2_CIPHER_SELECT. */

#define BV_DCP_PACKET2_CIPHER_SELECT_AES128 (0U)     /*!< Bit field value for DCP_PACKET2_CIPHER_SELECT:  */

/*! @brief Read current value of the DCP_PACKET2_CIPHER_SELECT field. */
#define BR_DCP_PACKET2_CIPHER_SELECT(x) (HW_DCP_PACKET2(x).B.CIPHER_SELECT)
/*@}*/

/*!
 * @name Register DCP_PACKET2, field CIPHER_MODE[7:4] (RO)
 *
 * Cipher Mode Selection Field. Reflects the mode of operation for cipher
 * operations.
 *
 * Values:
 * - 0 -
 * - 1 -
 */
/*@{*/
#define BP_DCP_PACKET2_CIPHER_MODE (4U)    /*!< Bit position for DCP_PACKET2_CIPHER_MODE. */
#define BM_DCP_PACKET2_CIPHER_MODE (0x000000F0U) /*!< Bit mask for DCP_PACKET2_CIPHER_MODE. */
#define BS_DCP_PACKET2_CIPHER_MODE (4U)    /*!< Bit field size in bits for DCP_PACKET2_CIPHER_MODE. */

#define BV_DCP_PACKET2_CIPHER_MODE_ECB (0U)          /*!< Bit field value for DCP_PACKET2_CIPHER_MODE:  */
#define BV_DCP_PACKET2_CIPHER_MODE_CBC (0x1U)        /*!< Bit field value for DCP_PACKET2_CIPHER_MODE:  */

/*! @brief Read current value of the DCP_PACKET2_CIPHER_MODE field. */
#define BR_DCP_PACKET2_CIPHER_MODE(x) (HW_DCP_PACKET2(x).B.CIPHER_MODE)
/*@}*/

/*!
 * @name Register DCP_PACKET2, field KEY_SELECT[15:8] (RO)
 *
 * Key Selection Field. The value here reflects the key index for the cipher
 * operation. Values 0-3 refer to the software keys that can be written to the key
 * RAM. The OTP key or the unique device-specific key may also be selected with a
 * value of 0xFF (OTP key) or 0xFE (unique key).
 *
 * Values:
 * - 0 -
 * - 1 -
 * - 10 -
 * - 11 -
 * - 11111110 -
 * - 11111111 -
 */
/*@{*/
#define BP_DCP_PACKET2_KEY_SELECT (8U)     /*!< Bit position for DCP_PACKET2_KEY_SELECT. */
#define BM_DCP_PACKET2_KEY_SELECT (0x0000FF00U) /*!< Bit mask for DCP_PACKET2_KEY_SELECT. */
#define BS_DCP_PACKET2_KEY_SELECT (8U)     /*!< Bit field size in bits for DCP_PACKET2_KEY_SELECT. */

#define BV_DCP_PACKET2_KEY_SELECT_KEY0 (0U)          /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */
#define BV_DCP_PACKET2_KEY_SELECT_KEY1 (0x1U)        /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */
#define BV_DCP_PACKET2_KEY_SELECT_KEY2 (0x2U)        /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */
#define BV_DCP_PACKET2_KEY_SELECT_KEY3 (0x3U)        /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */
#define BV_DCP_PACKET2_KEY_SELECT_UNIQUE_KEY (0xFEU) /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */
#define BV_DCP_PACKET2_KEY_SELECT_OTP_KEY (0xFFU)    /*!< Bit field value for DCP_PACKET2_KEY_SELECT:  */

/*! @brief Read current value of the DCP_PACKET2_KEY_SELECT field. */
#define BR_DCP_PACKET2_KEY_SELECT(x) (HW_DCP_PACKET2(x).B.KEY_SELECT)
/*@}*/

/*!
 * @name Register DCP_PACKET2, field HASH_SELECT[19:16] (RO)
 *
 * Hash Selection Field
 *
 * Values:
 * - 0 -
 * - 1 -
 * - 10 -
 */
/*@{*/
#define BP_DCP_PACKET2_HASH_SELECT (16U)   /*!< Bit position for DCP_PACKET2_HASH_SELECT. */
#define BM_DCP_PACKET2_HASH_SELECT (0x000F0000U) /*!< Bit mask for DCP_PACKET2_HASH_SELECT. */
#define BS_DCP_PACKET2_HASH_SELECT (4U)    /*!< Bit field size in bits for DCP_PACKET2_HASH_SELECT. */

#define BV_DCP_PACKET2_HASH_SELECT_SHA1 (0U)         /*!< Bit field value for DCP_PACKET2_HASH_SELECT:  */
#define BV_DCP_PACKET2_HASH_SELECT_CRC32 (0x1U)      /*!< Bit field value for DCP_PACKET2_HASH_SELECT:  */
#define BV_DCP_PACKET2_HASH_SELECT_SHA256 (0x2U)     /*!< Bit field value for DCP_PACKET2_HASH_SELECT:  */

/*! @brief Read current value of the DCP_PACKET2_HASH_SELECT field. */
#define BR_DCP_PACKET2_HASH_SELECT(x) (HW_DCP_PACKET2(x).B.HASH_SELECT)
/*@}*/

/*!
 * @name Register DCP_PACKET2, field RSVD[23:20] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_DCP_PACKET2_RSVD  (20U)         /*!< Bit position for DCP_PACKET2_RSVD. */
#define BM_DCP_PACKET2_RSVD  (0x00F00000U) /*!< Bit mask for DCP_PACKET2_RSVD. */
#define BS_DCP_PACKET2_RSVD  (4U)          /*!< Bit field size in bits for DCP_PACKET2_RSVD. */
/*@}*/

/*!
 * @name Register DCP_PACKET2, field CIPHER_CFG[31:24] (RO)
 *
 * Cipher configuration bits. Optional configuration bits required for ciphers
 */
/*@{*/
#define BP_DCP_PACKET2_CIPHER_CFG (24U)    /*!< Bit position for DCP_PACKET2_CIPHER_CFG. */
#define BM_DCP_PACKET2_CIPHER_CFG (0xFF000000U) /*!< Bit mask for DCP_PACKET2_CIPHER_CFG. */
#define BS_DCP_PACKET2_CIPHER_CFG (8U)     /*!< Bit field size in bits for DCP_PACKET2_CIPHER_CFG. */

/*! @brief Read current value of the DCP_PACKET2_CIPHER_CFG field. */
#define BR_DCP_PACKET2_CIPHER_CFG(x) (HW_DCP_PACKET2(x).B.CIPHER_CFG)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET3 - DCP Work Packet 3 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET3 - DCP Work Packet 3 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x0C
 * (Source Address) field. This register shows the contents of the Source Address
 * register from the packet being processed. When the CONSTANT_FILL bit in the
 * Control 0 field is set, this field contains the data written to the destination
 * buffer.
 */
typedef union _hw_dcp_packet3
{
    uint32_t U;
    struct _hw_dcp_packet3_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_packet3_t;

/*!
 * @name Constants and macros for entire DCP_PACKET3 register
 */
/*@{*/
#define HW_DCP_PACKET3_ADDR(x)   ((uintptr_t)(x) + 0xB0U)

#define HW_DCP_PACKET3(x)        (*(__I hw_dcp_packet3_t *) HW_DCP_PACKET3_ADDR(x))
#define HW_DCP_PACKET3_RD(x)     (HW_DCP_PACKET3(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET3 bitfields
 */

/*!
 * @name Register DCP_PACKET3, field ADDR[31:0] (RO)
 *
 * Source Buffer Address Pointer. This value is the working value and will
 * update as the operation proceeds.
 */
/*@{*/
#define BP_DCP_PACKET3_ADDR  (0U)          /*!< Bit position for DCP_PACKET3_ADDR. */
#define BM_DCP_PACKET3_ADDR  (0xFFFFFFFFU) /*!< Bit mask for DCP_PACKET3_ADDR. */
#define BS_DCP_PACKET3_ADDR  (32U)         /*!< Bit field size in bits for DCP_PACKET3_ADDR. */

/*! @brief Read current value of the DCP_PACKET3_ADDR field. */
#define BR_DCP_PACKET3_ADDR(x) (HW_DCP_PACKET3(x).U)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET4 - DCP Work Packet 4 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET4 - DCP Work Packet 4 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x10
 * (Destination Address) field. This register shows the contents of the Destination
 * Address register from the packet being processed.
 */
typedef union _hw_dcp_packet4
{
    uint32_t U;
    struct _hw_dcp_packet4_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_packet4_t;

/*!
 * @name Constants and macros for entire DCP_PACKET4 register
 */
/*@{*/
#define HW_DCP_PACKET4_ADDR(x)   ((uintptr_t)(x) + 0xC0U)

#define HW_DCP_PACKET4(x)        (*(__I hw_dcp_packet4_t *) HW_DCP_PACKET4_ADDR(x))
#define HW_DCP_PACKET4_RD(x)     (HW_DCP_PACKET4(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET4 bitfields
 */

/*!
 * @name Register DCP_PACKET4, field ADDR[31:0] (RO)
 *
 * Destination Buffer Address Pointer. This value is the working value and will
 * update as the operation proceeds.
 */
/*@{*/
#define BP_DCP_PACKET4_ADDR  (0U)          /*!< Bit position for DCP_PACKET4_ADDR. */
#define BM_DCP_PACKET4_ADDR  (0xFFFFFFFFU) /*!< Bit mask for DCP_PACKET4_ADDR. */
#define BS_DCP_PACKET4_ADDR  (32U)         /*!< Bit field size in bits for DCP_PACKET4_ADDR. */

/*! @brief Read current value of the DCP_PACKET4_ADDR field. */
#define BR_DCP_PACKET4_ADDR(x) (HW_DCP_PACKET4(x).U)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET5 - DCP Work Packet 5 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET5 - DCP Work Packet 5 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x14
 * (Buffer Size) field. This register shows the contents of the bytecount register
 * from the packet being processed. The field can be considered either a byte
 * count or a buffer size. The logic treats this as a decrmenting count of bytes from
 * the buffer size programmed into the field. As the transaction proceeds, the
 * logic will decrement the bytecount as data is written to the destination
 * buffer. For blit operations, the top 16-bits of this field represents the number of
 * lines (y size) in the blit and the lower 16-bits represent the number of bytes
 * in a line (x size).
 */
typedef union _hw_dcp_packet5
{
    uint32_t U;
    struct _hw_dcp_packet5_bitfields
    {
        uint32_t COUNT : 32;           /*!< [31:0]  */
    } B;
} hw_dcp_packet5_t;

/*!
 * @name Constants and macros for entire DCP_PACKET5 register
 */
/*@{*/
#define HW_DCP_PACKET5_ADDR(x)   ((uintptr_t)(x) + 0xD0U)

#define HW_DCP_PACKET5(x)        (*(__I hw_dcp_packet5_t *) HW_DCP_PACKET5_ADDR(x))
#define HW_DCP_PACKET5_RD(x)     (HW_DCP_PACKET5(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET5 bitfields
 */

/*!
 * @name Register DCP_PACKET5, field COUNT[31:0] (RO)
 *
 * Byte Count register. This value is the working value and will update as the
 * operation proceeds.
 */
/*@{*/
#define BP_DCP_PACKET5_COUNT (0U)          /*!< Bit position for DCP_PACKET5_COUNT. */
#define BM_DCP_PACKET5_COUNT (0xFFFFFFFFU) /*!< Bit mask for DCP_PACKET5_COUNT. */
#define BS_DCP_PACKET5_COUNT (32U)         /*!< Bit field size in bits for DCP_PACKET5_COUNT. */

/*! @brief Read current value of the DCP_PACKET5_COUNT field. */
#define BR_DCP_PACKET5_COUNT(x) (HW_DCP_PACKET5(x).U)
/*@}*/

/*******************************************************************************
 * HW_DCP_PACKET6 - DCP Work Packet 6 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_PACKET6 - DCP Work Packet 6 Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register displays the values for the current work packet offset 0x1C
 * (Payload Pointer) field. This register shows the contents of the payload pointer
 * fieldr from the packet being processed.
 */
typedef union _hw_dcp_packet6
{
    uint32_t U;
    struct _hw_dcp_packet6_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_packet6_t;

/*!
 * @name Constants and macros for entire DCP_PACKET6 register
 */
/*@{*/
#define HW_DCP_PACKET6_ADDR(x)   ((uintptr_t)(x) + 0xE0U)

#define HW_DCP_PACKET6(x)        (*(__I hw_dcp_packet6_t *) HW_DCP_PACKET6_ADDR(x))
#define HW_DCP_PACKET6_RD(x)     (HW_DCP_PACKET6(x).U)
/*@}*/

/*
 * Constants & macros for individual DCP_PACKET6 bitfields
 */

/*!
 * @name Register DCP_PACKET6, field ADDR[31:0] (RO)
 *
 * This regiser reflects the payload pointer for the current control packet.
 */
/*@{*/
#define BP_DCP_PACKET6_ADDR  (0U)          /*!< Bit position for DCP_PACKET6_ADDR. */
#define BM_DCP_PACKET6_ADDR  (0xFFFFFFFFU) /*!< Bit mask for DCP_PACKET6_ADDR. */
#define BS_DCP_PACKET6_ADDR  (32U)         /*!< Bit field size in bits for DCP_PACKET6_ADDR. */

/*! @brief Read current value of the DCP_PACKET6_ADDR field. */
#define BR_DCP_PACKET6_ADDR(x) (HW_DCP_PACKET6(x).U)
/*@}*/

/*******************************************************************************
 * HW_DCP_CH0CMDPTR - DCP Channel 0 Command Pointer Address Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CH0CMDPTR - DCP Channel 0 Command Pointer Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The DCP channel 0 current command address register points to the multiword
 * descriptor that is to be executed (or currently being executed). The channel may
 * be activated by writing the command pointer address to a valid descriptor in
 * memory and then updating the semaphore to a non-zero value. After the engine
 * completes processing of a descriptor, the "next_ptr" field from the descriptor
 * is moved into this register to enable processing of the next descriptor. All
 * channels with a non-zero semaphore value will arbitrate for access to the
 * engine for the subsequent operation. DCP Channel 0 is controlled by a variable
 * sized command structure. This register points to the command structure to be
 * executed. EXAMPLE DCP_CHnCMDPTR_WR(0, v); // Write channel 0 command pointer
 * pCurptr = (DCP_chncmdptr_t *) DCP_CHnCMDPTR_RD(0); // Read current command pointer
 */
typedef union _hw_dcp_ch0cmdptr
{
    uint32_t U;
    struct _hw_dcp_ch0cmdptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_dcp_ch0cmdptr_t;

/*!
 * @name Constants and macros for entire DCP_CH0CMDPTR register
 */
/*@{*/
#define HW_DCP_CH0CMDPTR_ADDR(x) ((uintptr_t)(x) + 0x100U)

#define HW_DCP_CH0CMDPTR(x)      (*(__IO hw_dcp_ch0cmdptr_t *) HW_DCP_CH0CMDPTR_ADDR(x))
#define HW_DCP_CH0CMDPTR_RD(x)   (HW_DCP_CH0CMDPTR(x).U)
#define HW_DCP_CH0CMDPTR_WR(x, v) (HW_DCP_CH0CMDPTR(x).U = (v))
#define HW_DCP_CH0CMDPTR_SET(x, v) (HW_DCP_CH0CMDPTR_WR(x, HW_DCP_CH0CMDPTR_RD(x) |  (v)))
#define HW_DCP_CH0CMDPTR_CLR(x, v) (HW_DCP_CH0CMDPTR_WR(x, HW_DCP_CH0CMDPTR_RD(x) & ~(v)))
#define HW_DCP_CH0CMDPTR_TOG(x, v) (HW_DCP_CH0CMDPTR_WR(x, HW_DCP_CH0CMDPTR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CH0CMDPTR bitfields
 */

/*!
 * @name Register DCP_CH0CMDPTR, field ADDR[31:0] (RW)
 *
 * Pointer to descriptor structure to be processed for channel 0.
 */
/*@{*/
#define BP_DCP_CH0CMDPTR_ADDR (0U)         /*!< Bit position for DCP_CH0CMDPTR_ADDR. */
#define BM_DCP_CH0CMDPTR_ADDR (0xFFFFFFFFU) /*!< Bit mask for DCP_CH0CMDPTR_ADDR. */
#define BS_DCP_CH0CMDPTR_ADDR (32U)        /*!< Bit field size in bits for DCP_CH0CMDPTR_ADDR. */

/*! @brief Read current value of the DCP_CH0CMDPTR_ADDR field. */
#define BR_DCP_CH0CMDPTR_ADDR(x) (HW_DCP_CH0CMDPTR(x).U)

/*! @brief Format value for bitfield DCP_CH0CMDPTR_ADDR. */
#define BF_DCP_CH0CMDPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CH0CMDPTR_ADDR) & BM_DCP_CH0CMDPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_DCP_CH0CMDPTR_ADDR(x, v) (HW_DCP_CH0CMDPTR_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_DCP_CH0SEMA - DCP Channel 0 Semaphore Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CH0SEMA - DCP Channel 0 Semaphore Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The DCP Channel 0 semaphore register is used to synchronize the ARM platform
 * instruction stream and the DMA chain processing state. After a command chain
 * has been generated in memory, software should write the address of the first
 * command descriptor to the CMDPTR register and then write a non-zero value to the
 * semaphore register to indicate that the channel is active. Each command
 * packet has a chaining bit which indicates that another descriptor should be loaded
 * into the channel upon completion of the current descriptor. If the chaining
 * bit is not set, the next address will not be loaded into the CMDPTR register.
 * Each packet also contains a "decrement semaphore" bit, which indicates that the
 * counting semaphore should be decremented after the operation. A channel is
 * considered active when the semaphore is a non-zero value. When programming a
 * series operations, software must properly program the semaphore values in
 * conjuction with the "decrement_semaphore" bits in the control packets to ensure that
 * the proper number of descriptors are activated. A semaphore may be cleared by
 * software by writing 0xFF to the DCP_CHnSEMA_CLR register. The logic will also
 * clear the semaphore if an error has occurred. Each DCP channel has an 8 bit
 * counting semaphore that is used to synchronize between the program stream and and
 * the DCP chain processing. After processing each control packet, the DCP
 * decrements the semaphore if it is non-zero. The channel will continue processing
 * packets as long as the semaphore contains a non-zero value and the CHAIN or
 * CHAIN_CONTIGOUS control bits in the Control0 field are set.
 */
typedef union _hw_dcp_ch0sema
{
    uint32_t U;
    struct _hw_dcp_ch0sema_bitfields
    {
        uint32_t INCREMENT : 8;        /*!< [7:0]  */
        uint32_t RESERVED0 : 8;        /*!< [15:8]  */
        uint32_t VALUE : 8;            /*!< [23:16]  */
        uint32_t RESERVED1 : 8;        /*!< [31:24]  */
    } B;
} hw_dcp_ch0sema_t;

/*!
 * @name Constants and macros for entire DCP_CH0SEMA register
 */
/*@{*/
#define HW_DCP_CH0SEMA_ADDR(x)   ((uintptr_t)(x) + 0x110U)

#define HW_DCP_CH0SEMA(x)        (*(__IO hw_dcp_ch0sema_t *) HW_DCP_CH0SEMA_ADDR(x))
#define HW_DCP_CH0SEMA_RD(x)     (HW_DCP_CH0SEMA(x).U)
#define HW_DCP_CH0SEMA_WR(x, v)  (HW_DCP_CH0SEMA(x).U = (v))
#define HW_DCP_CH0SEMA_SET(x, v) (HW_DCP_CH0SEMA_WR(x, HW_DCP_CH0SEMA_RD(x) |  (v)))
#define HW_DCP_CH0SEMA_CLR(x, v) (HW_DCP_CH0SEMA_WR(x, HW_DCP_CH0SEMA_RD(x) & ~(v)))
#define HW_DCP_CH0SEMA_TOG(x, v) (HW_DCP_CH0SEMA_WR(x, HW_DCP_CH0SEMA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CH0SEMA bitfields
 */

/*!
 * @name Register DCP_CH0SEMA, field INCREMENT[7:0] (RW)
 *
 * The value written to this field is added to the semaphore count in an atomic
 * way such that simultaneous software adds and DCP hardware substracts happening
 * on the same clock are protected. This bit field reads back a value of 0x00.
 * Writing a value of 0x02 increments the semaphore count by two, unless the DCP
 * channel decrements the count on the same clock, then the count is incremented
 * by a net one. The semaphore may be cleared by writing 0xFF to the
 * DCP_CHnSEMA_CLR register.
 */
/*@{*/
#define BP_DCP_CH0SEMA_INCREMENT (0U)      /*!< Bit position for DCP_CH0SEMA_INCREMENT. */
#define BM_DCP_CH0SEMA_INCREMENT (0x000000FFU) /*!< Bit mask for DCP_CH0SEMA_INCREMENT. */
#define BS_DCP_CH0SEMA_INCREMENT (8U)      /*!< Bit field size in bits for DCP_CH0SEMA_INCREMENT. */

/*! @brief Read current value of the DCP_CH0SEMA_INCREMENT field. */
#define BR_DCP_CH0SEMA_INCREMENT(x) (HW_DCP_CH0SEMA(x).B.INCREMENT)

/*! @brief Format value for bitfield DCP_CH0SEMA_INCREMENT. */
#define BF_DCP_CH0SEMA_INCREMENT(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CH0SEMA_INCREMENT) & BM_DCP_CH0SEMA_INCREMENT)

/*! @brief Set the INCREMENT field to a new value. */
#define BW_DCP_CH0SEMA_INCREMENT(x, v) (HW_DCP_CH0SEMA_WR(x, (HW_DCP_CH0SEMA_RD(x) & ~BM_DCP_CH0SEMA_INCREMENT) | BF_DCP_CH0SEMA_INCREMENT(v)))
/*@}*/

/*!
 * @name Register DCP_CH0SEMA, field VALUE[23:16] (RO)
 *
 * This read-only field shows the current (instantaneous) value of the semaphore
 * counter.
 */
/*@{*/
#define BP_DCP_CH0SEMA_VALUE (16U)         /*!< Bit position for DCP_CH0SEMA_VALUE. */
#define BM_DCP_CH0SEMA_VALUE (0x00FF0000U) /*!< Bit mask for DCP_CH0SEMA_VALUE. */
#define BS_DCP_CH0SEMA_VALUE (8U)          /*!< Bit field size in bits for DCP_CH0SEMA_VALUE. */

/*! @brief Read current value of the DCP_CH0SEMA_VALUE field. */
#define BR_DCP_CH0SEMA_VALUE(x) (HW_DCP_CH0SEMA(x).B.VALUE)
/*@}*/

/*******************************************************************************
 * HW_DCP_CH0STAT - DCP Channel 0 Status Register
 ******************************************************************************/

/*!
 * @brief HW_DCP_CH0STAT - DCP Channel 0 Status Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The DCP Channel 0 Interrupt Status register contains the interrupt status bit
 * and the tag of the last completed operation from the command chain. If an
 * error occurs during processing, the ERROR bit is set and an interrupt is
 * generated. DCP_CH0STAT: 0x120 CH0STAT_SET: 0x124 CH0STAT_CLR: 0x128 CH0STAT_TOG: 0x12C
 * The interrupt status register is updated at the end of each work packet. If
 * the interrupt bit is set in the command packet's command field, an interrupt
 * will be generated once the packet has completed. In addition, the tag value from
 * the command is stored in the TAG field so that software can identify which
 * command structure was the last to complete. If an error occurs, the ERROR bit is
 * set and processing of the command chain is halted.
 */
typedef union _hw_dcp_ch0stat
{
    uint32_t U;
    struct _hw_dcp_ch0stat_bitfields
    {
        uint32_t RSVD_COMPLETE : 1;    /*!< [0]  */
        uint32_t HASH_MISMATCH : 1;    /*!< [1]  */
        uint32_t ERROR_SETUP : 1;      /*!< [2]  */
        uint32_t ERROR_PACKET : 1;     /*!< [3]  */
        uint32_t ERROR_SRC : 1;        /*!< [4]  */
        uint32_t ERROR_DST : 1;        /*!< [5]  */
        uint32_t ERROR_PAGEFAULT : 1;  /*!< [6]  */
        uint32_t RESERVED0 : 9;        /*!< [15:7]  */
        uint32_t ERROR_CODE : 8;       /*!< [23:16]  */
        uint32_t TAG : 8;              /*!< [31:24]  */
    } B;
} hw_dcp_ch0stat_t;

/*!
 * @name Constants and macros for entire DCP_CH0STAT register
 */
/*@{*/
#define HW_DCP_CH0STAT_ADDR(x)   ((uintptr_t)(x) + 0x120U)

#define HW_DCP_CH0STAT(x)        (*(__IO hw_dcp_ch0stat_t *) HW_DCP_CH0STAT_ADDR(x))
#define HW_DCP_CH0STAT_RD(x)     (HW_DCP_CH0STAT(x).U)
#define HW_DCP_CH0STAT_WR(x, v)  (HW_DCP_CH0STAT(x).U = (v))
#define HW_DCP_CH0STAT_SET(x, v) (HW_DCP_CH0STAT_WR(x, HW_DCP_CH0STAT_RD(x) |  (v)))
#define HW_DCP_CH0STAT_CLR(x, v) (HW_DCP_CH0STAT_WR(x, HW_DCP_CH0STAT_RD(x) & ~(v)))
#define HW_DCP_CH0STAT_TOG(x, v) (HW_DCP_CH0STAT_WR(x, HW_DCP_CH0STAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DCP_CH0STAT bitfields
 */

/*!
 * @name Register DCP_CH0STAT, field RSVD_COMPLETE[0] (RU)
 *
 * This bit will always read 0 in the status register, but will be set to 1 in
 * the packet status field after processing of the packet has completed. This was
 * done so that software can verify that each packet completed properly in a
 * chain of commands for cases when an interrupt is issued only for the last item in
 * a packet. The completion bit for the channel is effectively the channel
 * interrupt status bit.
 */
/*@{*/
#define BP_DCP_CH0STAT_RSVD_COMPLETE (0U)  /*!< Bit position for DCP_CH0STAT_RSVD_COMPLETE. */
#define BM_DCP_CH0STAT_RSVD_COMPLETE (0x00000001U) /*!< Bit mask for DCP_CH0STAT_RSVD_COMPLETE. */
#define BS_DCP_CH0STAT_RSVD_COMPLETE (1U)  /*!< Bit field size in bits for DCP_CH0STAT_RSVD_COMPLETE. */
/*@}*/

/*!
 * @name Register DCP_CH0STAT, field HASH_MISMATCH[1] (RW)
 *
 * The bit indicates that a hashing check operation mismatched for control
 * packets that enable the HASH_CHECK bit. When an error is detected, the channel's
 * processing will stop until the error is handled by software.
 */
/*@{*/
#define BP_DCP_CH0STAT_HASH_MISMATCH (1U)  /*!< Bit position for DCP_CH0STAT_HASH_MISMATCH. */
#define BM_DCP_CH0STAT_HASH_MISMATCH (0x00000002U) /*!< Bit mask for DCP_CH0STAT_HASH_MISMATCH. */
#define BS_DCP_CH0STAT_HASH_MISMATCH (1U)  /*!< Bit field size in bits for DCP_CH0STAT_HASH_MISMATCH. */

/*! @brief Read current value of the DCP_CH0STAT_HASH_MISMATCH field. */
#define BR_DCP_CH0STAT_HASH_MISMATCH(x) (HW_DCP_CH0STAT(x).B.HASH_MISMATCH)

/*! @brief Format value for bitfield DCP_CH0STAT_HASH_MISMATCH. */
#define BF_DCP_CH0STAT_HASH_MISMATCH(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CH0STAT_HASH_MISMATCH) & BM_DCP_CH0STAT_HASH_MISMATCH)

/*! @brief Set the HASH_MISMATCH field to a new value. */
#define BW_DCP_CH0STAT_HASH_MISMATCH(x, v) (HW_DCP_CH0STAT_WR(x, (HW_DCP_CH0STAT_RD(x) & ~BM_DCP_CH0STAT_HASH_MISMATCH) | BF_DCP_CH0STAT_HASH_MISMATCH(v)))
/*@}*/

/*!
 * @name Register DCP_CH0STAT, field ERROR_SETUP[2] (RW)
 *
 * This bit indicates that the hardware has detected an invalid programming
 * configuration such as a buffer length that is not a multiple of the natural data
 * size for the operation. When an error is detected, the channel's processing
 * will stop until the error is handled by software.
 */
/*@{*/
#define BP_DCP_CH0STAT_ERROR_SETUP (2U)    /*!< Bit position for DCP_CH0STAT_ERROR_SETUP. */
#define BM_DCP_CH0STAT_ERROR_SETUP (0x00000004U) /*!< Bit mask for DCP_CH0STAT_ERROR_SETUP. */
#define BS_DCP_CH0STAT_ERROR_SETUP (1U)    /*!< Bit field size in bits for DCP_CH0STAT_ERROR_SETUP. */

/*! @brief Read current value of the DCP_CH0STAT_ERROR_SETUP field. */
#define BR_DCP_CH0STAT_ERROR_SETUP(x) (HW_DCP_CH0STAT(x).B.ERROR_SETUP)

/*! @brief Format value for bitfield DCP_CH0STAT_ERROR_SETUP. */
#define BF_DCP_CH0STAT_ERROR_SETUP(v) ((uint32_t)((uint32_t)(v) << BP_DCP_CH0STAT_ERROR_SETUP) & BM_DCP_CH0STAT_ERROR_SETUP)

/*! @brief Set the ERROR_SETUP field to a new value. */
#define BW_DCP_CH0STAT_ERROR_SETUP(x, v) (HW_DCP_CH0STAT_WR(x, (HW_DCP_CH0STAT_RD(x) & ~BM_DCP_CH0STAT_ERROR_SETUP) | BF_DCP_CH0STAT_ERROR_SETUP(v)))
/*@}*/

/*!
 * @name Register DCP_CH0STAT, field ERROR_PACKET[3] (RW)
