/*
 * Copyright (c) 2014 - 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_iMX7S_REGISTERS_H__
#define __HW_iMX7S_REGISTERS_H__

#include "fsl_bitaccess.h"

/*
 * iMX7S ADC
 *
 * ADC
 *
 * Registers defined in this header file:
 * - HW_ADC_CH_A_CFG1 - Channel A configuration 1
 * - HW_ADC_CH_A_CFG2 - Channel A configuration 2
 * - HW_ADC_CH_B_CFG1 -
 * - HW_ADC_CH_B_CFG2 - Channel B Configuration 2
 * - HW_ADC_CH_C_CFG1 - Channel C Configuration 1
 * - HW_ADC_CH_C_CFG2 - Channel C Configuration 2
 * - HW_ADC_CH_D_CFG1 - Channel D Configuration 1
 * - HW_ADC_CH_D_CFG2 - Channel D Configuration 2
 * - HW_ADC_CH_SW_CFG - Channel Software Configuration
 * - HW_ADC_TIMER_UNIT - Timer Unit
 * - HW_ADC_DMA_FIFO - DMA FIFO
 * - HW_ADC_FIFO_STATUS - FIFO Status
 * - HW_ADC_INT_SIG_EN -
 * - HW_ADC_INT_EN - Interrupt Enable
 * - HW_ADC_INT_STATUS -
 * - HW_ADC_CHA_B_CNV_RSLT - Channel A and B Conversion Result
 * - HW_ADC_CHC_D_CNV_RSLT - Channel C and D Conversion Result
 * - HW_ADC_CH_SW_CNV_RSLT - Channel Software Conversion Result
 * - HW_ADC_DMA_FIFO_DAT - DMA FIFO Data
 * - HW_ADC_ADC_CFG - ADC Configuration
 *
 * - hw_adc_t - Struct containing all module registers.
 */

#define HW_ADC_INSTANCE_COUNT (2U) /*!< Number of instances of the ADC module. */
#define HW_ADC1 (0U) /*!< Instance number for ADC1. */
#define HW_ADC2 (1U) /*!< Instance number for ADC2. */
#define ADC1_BASE             (0x30610000U) /*!< Base address for ADC1. */
#define ADC2_BASE             (0x30620000U) /*!< Base address for ADC2. */
/*! Array initializer of ADC base addresses. */
#define ADC_BASE_ADDRS        { ADC1_BASE, ADC2_BASE }

/*******************************************************************************
 * HW_ADC_CH_A_CFG1 - Channel A configuration 1
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_A_CFG1 - Channel A configuration 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * CH_A_CFG1 defines the functions of channel A. Channel A has the highest
 * priority of all four channels.
 */
typedef union _hw_adc_ch_a_cfg1
{
    uint32_t U;
    struct _hw_adc_ch_a_cfg1_bitfields
    {
        uint32_t CHA_TIMER : 24;       /*!< [23:0] Channel A Timer */
        uint32_t CHA_SEL : 4;          /*!< [27:24] Channel A Select */
        uint32_t RESERVED0 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHA_AVG_EN : 1;       /*!< [29] Channel A Average Enable */
        uint32_t CHA_SINGLE : 1;       /*!< [30] Channel A Signal Conversion */
        uint32_t CHA_EN : 1;           /*!< [31] Channel A Enable */
    } B;
} hw_adc_ch_a_cfg1_t;

/*!
 * @name Constants and macros for entire ADC_CH_A_CFG1 register
 */
/*@{*/
#define HW_ADC_CH_A_CFG1_ADDR(x) ((uintptr_t)(x) + 0x0U)

#define HW_ADC_CH_A_CFG1(x)      (*(__IO hw_adc_ch_a_cfg1_t *) HW_ADC_CH_A_CFG1_ADDR(x))
#define HW_ADC_CH_A_CFG1_RD(x)   (HW_ADC_CH_A_CFG1(x).U)
#define HW_ADC_CH_A_CFG1_WR(x, v) (HW_ADC_CH_A_CFG1(x).U = (v))
#define HW_ADC_CH_A_CFG1_SET(x, v) (HW_ADC_CH_A_CFG1_WR(x, HW_ADC_CH_A_CFG1_RD(x) |  (v)))
#define HW_ADC_CH_A_CFG1_CLR(x, v) (HW_ADC_CH_A_CFG1_WR(x, HW_ADC_CH_A_CFG1_RD(x) & ~(v)))
#define HW_ADC_CH_A_CFG1_TOG(x, v) (HW_ADC_CH_A_CFG1_WR(x, HW_ADC_CH_A_CFG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_A_CFG1 bitfields
 */

/*!
 * @name Register ADC_CH_A_CFG1, field CHA_TIMER[23:0] (RW)
 *
 * This timer is for continuous conversion. The conversion rate = (CHA_TIMER +
 * 1) times sample rate. 0x000 to 0xFFF timer value, every CHA_TIMER + 1 times
 * sample rate, the ADC converts one data.
 */
/*@{*/
#define BP_ADC_CH_A_CFG1_CHA_TIMER (0U)    /*!< Bit position for ADC_CH_A_CFG1_CHA_TIMER. */
#define BM_ADC_CH_A_CFG1_CHA_TIMER (0x00FFFFFFU) /*!< Bit mask for ADC_CH_A_CFG1_CHA_TIMER. */
#define BS_ADC_CH_A_CFG1_CHA_TIMER (24U)   /*!< Bit field size in bits for ADC_CH_A_CFG1_CHA_TIMER. */

/*! @brief Read current value of the ADC_CH_A_CFG1_CHA_TIMER field. */
#define BR_ADC_CH_A_CFG1_CHA_TIMER(x) (HW_ADC_CH_A_CFG1(x).B.CHA_TIMER)

/*! @brief Format value for bitfield ADC_CH_A_CFG1_CHA_TIMER. */
#define BF_ADC_CH_A_CFG1_CHA_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG1_CHA_TIMER) & BM_ADC_CH_A_CFG1_CHA_TIMER)

/*! @brief Set the CHA_TIMER field to a new value. */
#define BW_ADC_CH_A_CFG1_CHA_TIMER(x, v) (HW_ADC_CH_A_CFG1_WR(x, (HW_ADC_CH_A_CFG1_RD(x) & ~BM_ADC_CH_A_CFG1_CHA_TIMER) | BF_ADC_CH_A_CFG1_CHA_TIMER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG1, field CHA_SEL[27:24] (RW)
 *
 * Select input channel (from 16 channels) for the logical channel A.
 *
 * Values:
 * - 0000 - Channel 0
 * - 0001 - Channel 1
 * - 0010 - Channel 2
 * - 0011 - Channel 3
 * - 0100 - Channel 4
 * - 0101 - Channel 5
 * - 0110 - Channel 6
 * - 0111 - Channel 7
 * - 1000 - Channel 8
 * - 1001 - Channel 9
 * - 1010 - Channel 10
 * - 1011 - Channel 11
 * - 1100 - Channel 12
 * - 1101 - Channel 13
 * - 1110 - Channel 14
 * - 1111 - Channel 15
 */
/*@{*/
#define BP_ADC_CH_A_CFG1_CHA_SEL (24U)     /*!< Bit position for ADC_CH_A_CFG1_CHA_SEL. */
#define BM_ADC_CH_A_CFG1_CHA_SEL (0x0F000000U) /*!< Bit mask for ADC_CH_A_CFG1_CHA_SEL. */
#define BS_ADC_CH_A_CFG1_CHA_SEL (4U)      /*!< Bit field size in bits for ADC_CH_A_CFG1_CHA_SEL. */

/*! @brief Read current value of the ADC_CH_A_CFG1_CHA_SEL field. */
#define BR_ADC_CH_A_CFG1_CHA_SEL(x) (HW_ADC_CH_A_CFG1(x).B.CHA_SEL)

/*! @brief Format value for bitfield ADC_CH_A_CFG1_CHA_SEL. */
#define BF_ADC_CH_A_CFG1_CHA_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG1_CHA_SEL) & BM_ADC_CH_A_CFG1_CHA_SEL)

/*! @brief Set the CHA_SEL field to a new value. */
#define BW_ADC_CH_A_CFG1_CHA_SEL(x, v) (HW_ADC_CH_A_CFG1_WR(x, (HW_ADC_CH_A_CFG1_RD(x) & ~BM_ADC_CH_A_CFG1_CHA_SEL) | BF_ADC_CH_A_CFG1_CHA_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG1, field CHA_AVG_EN[29] (RW)
 *
 * If enable this bit, channel A will do average for each conversion.
 *
 * Values:
 * - 1 - Enable average function.
 * - 0 - Disable average function.
 */
/*@{*/
#define BP_ADC_CH_A_CFG1_CHA_AVG_EN (29U)  /*!< Bit position for ADC_CH_A_CFG1_CHA_AVG_EN. */
#define BM_ADC_CH_A_CFG1_CHA_AVG_EN (0x20000000U) /*!< Bit mask for ADC_CH_A_CFG1_CHA_AVG_EN. */
#define BS_ADC_CH_A_CFG1_CHA_AVG_EN (1U)   /*!< Bit field size in bits for ADC_CH_A_CFG1_CHA_AVG_EN. */

/*! @brief Read current value of the ADC_CH_A_CFG1_CHA_AVG_EN field. */
#define BR_ADC_CH_A_CFG1_CHA_AVG_EN(x) (HW_ADC_CH_A_CFG1(x).B.CHA_AVG_EN)

/*! @brief Format value for bitfield ADC_CH_A_CFG1_CHA_AVG_EN. */
#define BF_ADC_CH_A_CFG1_CHA_AVG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG1_CHA_AVG_EN) & BM_ADC_CH_A_CFG1_CHA_AVG_EN)

/*! @brief Set the CHA_AVG_EN field to a new value. */
#define BW_ADC_CH_A_CFG1_CHA_AVG_EN(x, v) (HW_ADC_CH_A_CFG1_WR(x, (HW_ADC_CH_A_CFG1_RD(x) & ~BM_ADC_CH_A_CFG1_CHA_AVG_EN) | BF_ADC_CH_A_CFG1_CHA_AVG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG1, field CHA_SINGLE[30] (RW)
 *
 * Start a single conversion from logical channel A. Switch between single and
 * continuous conversion, it must disable CHA_EN first. When both CHA_EN and
 * CHA_SINGLE are enabled, CHA_SIGNAL set CHA_EN to 0 and reset itself to 0.
 *
 * Values:
 * - 1 - Start a single conversion. Continuous conversion must stop.
 * - 0 - No single conversion. Continuous conversion can start.
 */
/*@{*/
#define BP_ADC_CH_A_CFG1_CHA_SINGLE (30U)  /*!< Bit position for ADC_CH_A_CFG1_CHA_SINGLE. */
#define BM_ADC_CH_A_CFG1_CHA_SINGLE (0x40000000U) /*!< Bit mask for ADC_CH_A_CFG1_CHA_SINGLE. */
#define BS_ADC_CH_A_CFG1_CHA_SINGLE (1U)   /*!< Bit field size in bits for ADC_CH_A_CFG1_CHA_SINGLE. */

/*! @brief Read current value of the ADC_CH_A_CFG1_CHA_SINGLE field. */
#define BR_ADC_CH_A_CFG1_CHA_SINGLE(x) (HW_ADC_CH_A_CFG1(x).B.CHA_SINGLE)

/*! @brief Format value for bitfield ADC_CH_A_CFG1_CHA_SINGLE. */
#define BF_ADC_CH_A_CFG1_CHA_SINGLE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG1_CHA_SINGLE) & BM_ADC_CH_A_CFG1_CHA_SINGLE)

/*! @brief Set the CHA_SINGLE field to a new value. */
#define BW_ADC_CH_A_CFG1_CHA_SINGLE(x, v) (HW_ADC_CH_A_CFG1_WR(x, (HW_ADC_CH_A_CFG1_RD(x) & ~BM_ADC_CH_A_CFG1_CHA_SINGLE) | BF_ADC_CH_A_CFG1_CHA_SINGLE(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG1, field CHA_EN[31] (RW)
 *
 * This bit controls the working mode of logical channel A.
 *
 * Values:
 * - 1 - Enable logical channel A. Logical channel A will work.
 * - 0 - Disable logical channel A. Prevent logical channel A from working.
 */
/*@{*/
#define BP_ADC_CH_A_CFG1_CHA_EN (31U)      /*!< Bit position for ADC_CH_A_CFG1_CHA_EN. */
#define BM_ADC_CH_A_CFG1_CHA_EN (0x80000000U) /*!< Bit mask for ADC_CH_A_CFG1_CHA_EN. */
#define BS_ADC_CH_A_CFG1_CHA_EN (1U)       /*!< Bit field size in bits for ADC_CH_A_CFG1_CHA_EN. */

/*! @brief Read current value of the ADC_CH_A_CFG1_CHA_EN field. */
#define BR_ADC_CH_A_CFG1_CHA_EN(x) (HW_ADC_CH_A_CFG1(x).B.CHA_EN)

/*! @brief Format value for bitfield ADC_CH_A_CFG1_CHA_EN. */
#define BF_ADC_CH_A_CFG1_CHA_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG1_CHA_EN) & BM_ADC_CH_A_CFG1_CHA_EN)

/*! @brief Set the CHA_EN field to a new value. */
#define BW_ADC_CH_A_CFG1_CHA_EN(x, v) (HW_ADC_CH_A_CFG1_WR(x, (HW_ADC_CH_A_CFG1_RD(x) & ~BM_ADC_CH_A_CFG1_CHA_EN) | BF_ADC_CH_A_CFG1_CHA_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_A_CFG2 - Channel A configuration 2
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_A_CFG2 - Channel A configuration 2 (RW)
 *
 * Reset value: 0x00008000U
 *
 * CH_A_CFG2 defines the function of channel A. Channel A has the highest
 * priority of all four channels.
 */
typedef union _hw_adc_ch_a_cfg2
{
    uint32_t U;
    struct _hw_adc_ch_a_cfg2_bitfields
    {
        uint32_t CHA_LOW_THRES : 12;   /*!< [11:0] Channel A Low Threshold
                                        * Value */
        uint32_t CHA_AVG_NUMBER : 2;   /*!< [13:12] Channel A Average Number */
        uint32_t RESERVED0 : 1;        /*!< [14] This field is reserved. */
        uint32_t CHA_AUTO_DIS : 1;     /*!< [15] Channel A Auto Disable */
        uint32_t CHA_HIGH_THRES : 12;  /*!< [27:16] Channel A High Threshold
                                        * Value */
        uint32_t RESERVED1 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHA_CMP_MODE : 3;     /*!< [31:29] Channel A Compare Mode */
    } B;
} hw_adc_ch_a_cfg2_t;

/*!
 * @name Constants and macros for entire ADC_CH_A_CFG2 register
 */
/*@{*/
#define HW_ADC_CH_A_CFG2_ADDR(x) ((uintptr_t)(x) + 0x10U)

#define HW_ADC_CH_A_CFG2(x)      (*(__IO hw_adc_ch_a_cfg2_t *) HW_ADC_CH_A_CFG2_ADDR(x))
#define HW_ADC_CH_A_CFG2_RD(x)   (HW_ADC_CH_A_CFG2(x).U)
#define HW_ADC_CH_A_CFG2_WR(x, v) (HW_ADC_CH_A_CFG2(x).U = (v))
#define HW_ADC_CH_A_CFG2_SET(x, v) (HW_ADC_CH_A_CFG2_WR(x, HW_ADC_CH_A_CFG2_RD(x) |  (v)))
#define HW_ADC_CH_A_CFG2_CLR(x, v) (HW_ADC_CH_A_CFG2_WR(x, HW_ADC_CH_A_CFG2_RD(x) & ~(v)))
#define HW_ADC_CH_A_CFG2_TOG(x, v) (HW_ADC_CH_A_CFG2_WR(x, HW_ADC_CH_A_CFG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_A_CFG2 bitfields
 */

/*!
 * @name Register ADC_CH_A_CFG2, field CHA_LOW_THRES[11:0] (RW)
 *
 * Contains the lower compare value to compare with the conversion result when a
 * compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_A_CFG2_CHA_LOW_THRES (0U) /*!< Bit position for ADC_CH_A_CFG2_CHA_LOW_THRES. */
#define BM_ADC_CH_A_CFG2_CHA_LOW_THRES (0x00000FFFU) /*!< Bit mask for ADC_CH_A_CFG2_CHA_LOW_THRES. */
#define BS_ADC_CH_A_CFG2_CHA_LOW_THRES (12U) /*!< Bit field size in bits for ADC_CH_A_CFG2_CHA_LOW_THRES. */

/*! @brief Read current value of the ADC_CH_A_CFG2_CHA_LOW_THRES field. */
#define BR_ADC_CH_A_CFG2_CHA_LOW_THRES(x) (HW_ADC_CH_A_CFG2(x).B.CHA_LOW_THRES)

/*! @brief Format value for bitfield ADC_CH_A_CFG2_CHA_LOW_THRES. */
#define BF_ADC_CH_A_CFG2_CHA_LOW_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG2_CHA_LOW_THRES) & BM_ADC_CH_A_CFG2_CHA_LOW_THRES)

/*! @brief Set the CHA_LOW_THRES field to a new value. */
#define BW_ADC_CH_A_CFG2_CHA_LOW_THRES(x, v) (HW_ADC_CH_A_CFG2_WR(x, (HW_ADC_CH_A_CFG2_RD(x) & ~BM_ADC_CH_A_CFG2_CHA_LOW_THRES) | BF_ADC_CH_A_CFG2_CHA_LOW_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG2, field CHA_AVG_NUMBER[13:12] (RW)
 *
 * If enable average function, this bit contains channel A average number.
 *
 * Values:
 * - 00 - Average number = 4
 * - 01 - Average number = 8
 * - 10 - Average number = 16
 * - 11 - Average number = 32
 */
/*@{*/
#define BP_ADC_CH_A_CFG2_CHA_AVG_NUMBER (12U) /*!< Bit position for ADC_CH_A_CFG2_CHA_AVG_NUMBER. */
#define BM_ADC_CH_A_CFG2_CHA_AVG_NUMBER (0x00003000U) /*!< Bit mask for ADC_CH_A_CFG2_CHA_AVG_NUMBER. */
#define BS_ADC_CH_A_CFG2_CHA_AVG_NUMBER (2U) /*!< Bit field size in bits for ADC_CH_A_CFG2_CHA_AVG_NUMBER. */

/*! @brief Read current value of the ADC_CH_A_CFG2_CHA_AVG_NUMBER field. */
#define BR_ADC_CH_A_CFG2_CHA_AVG_NUMBER(x) (HW_ADC_CH_A_CFG2(x).B.CHA_AVG_NUMBER)

/*! @brief Format value for bitfield ADC_CH_A_CFG2_CHA_AVG_NUMBER. */
#define BF_ADC_CH_A_CFG2_CHA_AVG_NUMBER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG2_CHA_AVG_NUMBER) & BM_ADC_CH_A_CFG2_CHA_AVG_NUMBER)

/*! @brief Set the CHA_AVG_NUMBER field to a new value. */
#define BW_ADC_CH_A_CFG2_CHA_AVG_NUMBER(x, v) (HW_ADC_CH_A_CFG2_WR(x, (HW_ADC_CH_A_CFG2_RD(x) & ~BM_ADC_CH_A_CFG2_CHA_AVG_NUMBER) | BF_ADC_CH_A_CFG2_CHA_AVG_NUMBER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG2, field CHA_AUTO_DIS[15] (RW)
 *
 * During continuous conversion, if compare match a converted result, the ADC
 * checks this bit. If CHA_AUTO_DIS = 1, then channel A stops continuous
 * conversion, if CHA_AUTO_DIS = 0, then channel A keeps continuous working, and the
 * conversion result overwrites the result registers. The default value is 1.
 */
/*@{*/
#define BP_ADC_CH_A_CFG2_CHA_AUTO_DIS (15U) /*!< Bit position for ADC_CH_A_CFG2_CHA_AUTO_DIS. */
#define BM_ADC_CH_A_CFG2_CHA_AUTO_DIS (0x00008000U) /*!< Bit mask for ADC_CH_A_CFG2_CHA_AUTO_DIS. */
#define BS_ADC_CH_A_CFG2_CHA_AUTO_DIS (1U) /*!< Bit field size in bits for ADC_CH_A_CFG2_CHA_AUTO_DIS. */

/*! @brief Read current value of the ADC_CH_A_CFG2_CHA_AUTO_DIS field. */
#define BR_ADC_CH_A_CFG2_CHA_AUTO_DIS(x) (HW_ADC_CH_A_CFG2(x).B.CHA_AUTO_DIS)

/*! @brief Format value for bitfield ADC_CH_A_CFG2_CHA_AUTO_DIS. */
#define BF_ADC_CH_A_CFG2_CHA_AUTO_DIS(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG2_CHA_AUTO_DIS) & BM_ADC_CH_A_CFG2_CHA_AUTO_DIS)

/*! @brief Set the CHA_AUTO_DIS field to a new value. */
#define BW_ADC_CH_A_CFG2_CHA_AUTO_DIS(x, v) (HW_ADC_CH_A_CFG2_WR(x, (HW_ADC_CH_A_CFG2_RD(x) & ~BM_ADC_CH_A_CFG2_CHA_AUTO_DIS) | BF_ADC_CH_A_CFG2_CHA_AUTO_DIS(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG2, field CHA_HIGH_THRES[27:16] (RW)
 *
 * Contains the high compare value to compare with the conversion result when a
 * compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_A_CFG2_CHA_HIGH_THRES (16U) /*!< Bit position for ADC_CH_A_CFG2_CHA_HIGH_THRES. */
#define BM_ADC_CH_A_CFG2_CHA_HIGH_THRES (0x0FFF0000U) /*!< Bit mask for ADC_CH_A_CFG2_CHA_HIGH_THRES. */
#define BS_ADC_CH_A_CFG2_CHA_HIGH_THRES (12U) /*!< Bit field size in bits for ADC_CH_A_CFG2_CHA_HIGH_THRES. */

/*! @brief Read current value of the ADC_CH_A_CFG2_CHA_HIGH_THRES field. */
#define BR_ADC_CH_A_CFG2_CHA_HIGH_THRES(x) (HW_ADC_CH_A_CFG2(x).B.CHA_HIGH_THRES)

/*! @brief Format value for bitfield ADC_CH_A_CFG2_CHA_HIGH_THRES. */
#define BF_ADC_CH_A_CFG2_CHA_HIGH_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG2_CHA_HIGH_THRES) & BM_ADC_CH_A_CFG2_CHA_HIGH_THRES)

/*! @brief Set the CHA_HIGH_THRES field to a new value. */
#define BW_ADC_CH_A_CFG2_CHA_HIGH_THRES(x, v) (HW_ADC_CH_A_CFG2_WR(x, (HW_ADC_CH_A_CFG2_RD(x) & ~BM_ADC_CH_A_CFG2_CHA_HIGH_THRES) | BF_ADC_CH_A_CFG2_CHA_HIGH_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_A_CFG2, field CHA_CMP_MODE[31:29] (RW)
 *
 * Select which compare mode the conversion result will take for channel A.
 *
 * Values:
 * - 001 - If channel A conversion result is greater than CHA_LOW_THRES, then an
 *     interrupt will be generated and the channel A flag will be set if they
 *     are enabled.
 * - 010 - If channel A conversion result is less than or equal to
 *     CHA_LOW_THRES, then an interrupt will be generated and channel A flag will be set if
 *     they are enabled.
 * - 011 - If channel A conversion result is greater than CHA_LOW_THRES and less
 *     than CHA_HIGH_THRES, then an interrupt will be generated and channel A
 *     flag will be set if they are enabled.
 * - 101 - If channel A conversion result is greater than or equal to
 *     CHA_HIGH_THRES, then an interrupt will be generated and channel A flag will be set
 *     if they are enabled.
 * - 110 - If channel A conversion result is less than CHA_HIGH_THRES, then an
 *     interrupt will be generated and channel A flag will be set if they are
 *     enabled.
 * - 111 - If channel A conversion result is less than or equal to
 *     CHA_LOW_THRES, and at the same time, greater than or equal to CHA_HIGH_THRES, then an
 *     interrupt will be generated and channel A flag will be set if they are
 *     enabled.
 */
/*@{*/
#define BP_ADC_CH_A_CFG2_CHA_CMP_MODE (29U) /*!< Bit position for ADC_CH_A_CFG2_CHA_CMP_MODE. */
#define BM_ADC_CH_A_CFG2_CHA_CMP_MODE (0xE0000000U) /*!< Bit mask for ADC_CH_A_CFG2_CHA_CMP_MODE. */
#define BS_ADC_CH_A_CFG2_CHA_CMP_MODE (3U) /*!< Bit field size in bits for ADC_CH_A_CFG2_CHA_CMP_MODE. */

/*! @brief Read current value of the ADC_CH_A_CFG2_CHA_CMP_MODE field. */
#define BR_ADC_CH_A_CFG2_CHA_CMP_MODE(x) (HW_ADC_CH_A_CFG2(x).B.CHA_CMP_MODE)

/*! @brief Format value for bitfield ADC_CH_A_CFG2_CHA_CMP_MODE. */
#define BF_ADC_CH_A_CFG2_CHA_CMP_MODE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_A_CFG2_CHA_CMP_MODE) & BM_ADC_CH_A_CFG2_CHA_CMP_MODE)

/*! @brief Set the CHA_CMP_MODE field to a new value. */
#define BW_ADC_CH_A_CFG2_CHA_CMP_MODE(x, v) (HW_ADC_CH_A_CFG2_WR(x, (HW_ADC_CH_A_CFG2_RD(x) & ~BM_ADC_CH_A_CFG2_CHA_CMP_MODE) | BF_ADC_CH_A_CFG2_CHA_CMP_MODE(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_B_CFG1 -
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_B_CFG1 -  (RW)
 *
 * Reset value: 0x00000000U
 *
 * CH_B_CFG1 defines the functions of channel B. Channel B has the second
 * highest priority of all four channels.
 */
typedef union _hw_adc_ch_b_cfg1
{
    uint32_t U;
    struct _hw_adc_ch_b_cfg1_bitfields
    {
        uint32_t CHB_TIMER : 24;       /*!< [23:0] Channel B Timer */
        uint32_t CHB_SEL : 4;          /*!< [27:24] Channel B Select */
        uint32_t RESERVED0 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHB_AVG_EN : 1;       /*!< [29] Channel B Average Enable */
        uint32_t CHB_SINGLE : 1;       /*!< [30] Channel B Single Conversion */
        uint32_t CHB_EN : 1;           /*!< [31] Channel B Enable */
    } B;
} hw_adc_ch_b_cfg1_t;

/*!
 * @name Constants and macros for entire ADC_CH_B_CFG1 register
 */
/*@{*/
#define HW_ADC_CH_B_CFG1_ADDR(x) ((uintptr_t)(x) + 0x20U)

#define HW_ADC_CH_B_CFG1(x)      (*(__IO hw_adc_ch_b_cfg1_t *) HW_ADC_CH_B_CFG1_ADDR(x))
#define HW_ADC_CH_B_CFG1_RD(x)   (HW_ADC_CH_B_CFG1(x).U)
#define HW_ADC_CH_B_CFG1_WR(x, v) (HW_ADC_CH_B_CFG1(x).U = (v))
#define HW_ADC_CH_B_CFG1_SET(x, v) (HW_ADC_CH_B_CFG1_WR(x, HW_ADC_CH_B_CFG1_RD(x) |  (v)))
#define HW_ADC_CH_B_CFG1_CLR(x, v) (HW_ADC_CH_B_CFG1_WR(x, HW_ADC_CH_B_CFG1_RD(x) & ~(v)))
#define HW_ADC_CH_B_CFG1_TOG(x, v) (HW_ADC_CH_B_CFG1_WR(x, HW_ADC_CH_B_CFG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_B_CFG1 bitfields
 */

/*!
 * @name Register ADC_CH_B_CFG1, field CHB_TIMER[23:0] (RW)
 *
 * This timer is for continuous conversion. The conversion rate = (CHB_TIMER +
 * 1) times sample rate + offset. Offset is due to channel B obtains lower
 * priority than channel A. In worst condition, all channel B's conversions are blocked
 * by channel A's. 0x000 to 0xFFF timer value, every CHB_TIMER + 1 times sample
 * rate + offset, the ADC converts one data.
 */
/*@{*/
#define BP_ADC_CH_B_CFG1_CHB_TIMER (0U)    /*!< Bit position for ADC_CH_B_CFG1_CHB_TIMER. */
#define BM_ADC_CH_B_CFG1_CHB_TIMER (0x00FFFFFFU) /*!< Bit mask for ADC_CH_B_CFG1_CHB_TIMER. */
#define BS_ADC_CH_B_CFG1_CHB_TIMER (24U)   /*!< Bit field size in bits for ADC_CH_B_CFG1_CHB_TIMER. */

/*! @brief Read current value of the ADC_CH_B_CFG1_CHB_TIMER field. */
#define BR_ADC_CH_B_CFG1_CHB_TIMER(x) (HW_ADC_CH_B_CFG1(x).B.CHB_TIMER)

/*! @brief Format value for bitfield ADC_CH_B_CFG1_CHB_TIMER. */
#define BF_ADC_CH_B_CFG1_CHB_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG1_CHB_TIMER) & BM_ADC_CH_B_CFG1_CHB_TIMER)

/*! @brief Set the CHB_TIMER field to a new value. */
#define BW_ADC_CH_B_CFG1_CHB_TIMER(x, v) (HW_ADC_CH_B_CFG1_WR(x, (HW_ADC_CH_B_CFG1_RD(x) & ~BM_ADC_CH_B_CFG1_CHB_TIMER) | BF_ADC_CH_B_CFG1_CHB_TIMER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG1, field CHB_SEL[27:24] (RW)
 *
 * Select input channel (from 16 channels) for the logical channel B.
 *
 * Values:
 * - 0000 - Channel 0
 * - 0001 - Channel 1
 * - 0010 - Channel 2
 * - 0011 - Channel 3
 * - 0100 - Channel 4
 * - 0101 - Channel 5
 * - 0110 - Channel 6
 * - 0111 - Channel 7
 * - 1000 - Channel 8
 * - 1001 - Channel 9
 * - 1010 - Channel 10
 * - 1011 - Channel 11
 * - 1100 - Channel 12
 * - 1101 - Channel 13
 * - 1110 - Channel 14
 * - 1111 - Channel 15
 */
/*@{*/
#define BP_ADC_CH_B_CFG1_CHB_SEL (24U)     /*!< Bit position for ADC_CH_B_CFG1_CHB_SEL. */
#define BM_ADC_CH_B_CFG1_CHB_SEL (0x0F000000U) /*!< Bit mask for ADC_CH_B_CFG1_CHB_SEL. */
#define BS_ADC_CH_B_CFG1_CHB_SEL (4U)      /*!< Bit field size in bits for ADC_CH_B_CFG1_CHB_SEL. */

/*! @brief Read current value of the ADC_CH_B_CFG1_CHB_SEL field. */
#define BR_ADC_CH_B_CFG1_CHB_SEL(x) (HW_ADC_CH_B_CFG1(x).B.CHB_SEL)

/*! @brief Format value for bitfield ADC_CH_B_CFG1_CHB_SEL. */
#define BF_ADC_CH_B_CFG1_CHB_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG1_CHB_SEL) & BM_ADC_CH_B_CFG1_CHB_SEL)

/*! @brief Set the CHB_SEL field to a new value. */
#define BW_ADC_CH_B_CFG1_CHB_SEL(x, v) (HW_ADC_CH_B_CFG1_WR(x, (HW_ADC_CH_B_CFG1_RD(x) & ~BM_ADC_CH_B_CFG1_CHB_SEL) | BF_ADC_CH_B_CFG1_CHB_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG1, field CHB_AVG_EN[29] (RW)
 *
 * If enable this bit, channel B will do average for each conversion.
 *
 * Values:
 * - 1 - Enable average function.
 * - 0 - Disable average function.
 */
/*@{*/
#define BP_ADC_CH_B_CFG1_CHB_AVG_EN (29U)  /*!< Bit position for ADC_CH_B_CFG1_CHB_AVG_EN. */
#define BM_ADC_CH_B_CFG1_CHB_AVG_EN (0x20000000U) /*!< Bit mask for ADC_CH_B_CFG1_CHB_AVG_EN. */
#define BS_ADC_CH_B_CFG1_CHB_AVG_EN (1U)   /*!< Bit field size in bits for ADC_CH_B_CFG1_CHB_AVG_EN. */

/*! @brief Read current value of the ADC_CH_B_CFG1_CHB_AVG_EN field. */
#define BR_ADC_CH_B_CFG1_CHB_AVG_EN(x) (HW_ADC_CH_B_CFG1(x).B.CHB_AVG_EN)

/*! @brief Format value for bitfield ADC_CH_B_CFG1_CHB_AVG_EN. */
#define BF_ADC_CH_B_CFG1_CHB_AVG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG1_CHB_AVG_EN) & BM_ADC_CH_B_CFG1_CHB_AVG_EN)

/*! @brief Set the CHB_AVG_EN field to a new value. */
#define BW_ADC_CH_B_CFG1_CHB_AVG_EN(x, v) (HW_ADC_CH_B_CFG1_WR(x, (HW_ADC_CH_B_CFG1_RD(x) & ~BM_ADC_CH_B_CFG1_CHB_AVG_EN) | BF_ADC_CH_B_CFG1_CHB_AVG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG1, field CHB_SINGLE[30] (RW)
 *
 * Start a single conversion from logical channel B. Switch between single and
 * continuous conversion, it must disable CHB_EN first. When both CHB_EN and
 * CHB_SINGLE are enabled, CHB_SIGNAL set CHB_EN to 0 and reset itself to 0.
 *
 * Values:
 * - 1 - Start a single conversion. Continuous conversion must stop.
 * - 0 - No single conversion. Continuous conversion can start.
 */
/*@{*/
#define BP_ADC_CH_B_CFG1_CHB_SINGLE (30U)  /*!< Bit position for ADC_CH_B_CFG1_CHB_SINGLE. */
#define BM_ADC_CH_B_CFG1_CHB_SINGLE (0x40000000U) /*!< Bit mask for ADC_CH_B_CFG1_CHB_SINGLE. */
#define BS_ADC_CH_B_CFG1_CHB_SINGLE (1U)   /*!< Bit field size in bits for ADC_CH_B_CFG1_CHB_SINGLE. */

/*! @brief Read current value of the ADC_CH_B_CFG1_CHB_SINGLE field. */
#define BR_ADC_CH_B_CFG1_CHB_SINGLE(x) (HW_ADC_CH_B_CFG1(x).B.CHB_SINGLE)

/*! @brief Format value for bitfield ADC_CH_B_CFG1_CHB_SINGLE. */
#define BF_ADC_CH_B_CFG1_CHB_SINGLE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG1_CHB_SINGLE) & BM_ADC_CH_B_CFG1_CHB_SINGLE)

/*! @brief Set the CHB_SINGLE field to a new value. */
#define BW_ADC_CH_B_CFG1_CHB_SINGLE(x, v) (HW_ADC_CH_B_CFG1_WR(x, (HW_ADC_CH_B_CFG1_RD(x) & ~BM_ADC_CH_B_CFG1_CHB_SINGLE) | BF_ADC_CH_B_CFG1_CHB_SINGLE(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG1, field CHB_EN[31] (RW)
 *
 * Controls the usable of logical channel B.
 *
 * Values:
 * - 1 - Enable logical channel B. Logical channel B will work.
 * - 0 - Disable logical channel B. Prevent logical channel B from working.
 */
/*@{*/
#define BP_ADC_CH_B_CFG1_CHB_EN (31U)      /*!< Bit position for ADC_CH_B_CFG1_CHB_EN. */
#define BM_ADC_CH_B_CFG1_CHB_EN (0x80000000U) /*!< Bit mask for ADC_CH_B_CFG1_CHB_EN. */
#define BS_ADC_CH_B_CFG1_CHB_EN (1U)       /*!< Bit field size in bits for ADC_CH_B_CFG1_CHB_EN. */

/*! @brief Read current value of the ADC_CH_B_CFG1_CHB_EN field. */
#define BR_ADC_CH_B_CFG1_CHB_EN(x) (HW_ADC_CH_B_CFG1(x).B.CHB_EN)

/*! @brief Format value for bitfield ADC_CH_B_CFG1_CHB_EN. */
#define BF_ADC_CH_B_CFG1_CHB_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG1_CHB_EN) & BM_ADC_CH_B_CFG1_CHB_EN)

/*! @brief Set the CHB_EN field to a new value. */
#define BW_ADC_CH_B_CFG1_CHB_EN(x, v) (HW_ADC_CH_B_CFG1_WR(x, (HW_ADC_CH_B_CFG1_RD(x) & ~BM_ADC_CH_B_CFG1_CHB_EN) | BF_ADC_CH_B_CFG1_CHB_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_B_CFG2 - Channel B Configuration 2
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_B_CFG2 - Channel B Configuration 2 (RW)
 *
 * Reset value: 0x00008000U
 *
 * CH_B_CFG2 defines the functions of channel B. Channel B has the second
 * highest priority of all four channels.
 */
typedef union _hw_adc_ch_b_cfg2
{
    uint32_t U;
    struct _hw_adc_ch_b_cfg2_bitfields
    {
        uint32_t CHB_LOW_THRES : 12;   /*!< [11:0] Channel B Low Threshold
                                        * Value */
        uint32_t CHB_AVG_NUMBER : 2;   /*!< [13:12] Channel B Average Number */
        uint32_t RESERVED0 : 1;        /*!< [14] This field is reserved. */
        uint32_t CHB_AUTO_DIS : 1;     /*!< [15] Channel B Auto Disable */
        uint32_t CHB_HIGH_THRES : 12;  /*!< [27:16] Channel B High Threshold
                                        * Value */
        uint32_t RESERVED1 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHB_CMP_MODE : 3;     /*!< [31:29] Channel B Compare Mode */
    } B;
} hw_adc_ch_b_cfg2_t;

/*!
 * @name Constants and macros for entire ADC_CH_B_CFG2 register
 */
/*@{*/
#define HW_ADC_CH_B_CFG2_ADDR(x) ((uintptr_t)(x) + 0x30U)

#define HW_ADC_CH_B_CFG2(x)      (*(__IO hw_adc_ch_b_cfg2_t *) HW_ADC_CH_B_CFG2_ADDR(x))
#define HW_ADC_CH_B_CFG2_RD(x)   (HW_ADC_CH_B_CFG2(x).U)
#define HW_ADC_CH_B_CFG2_WR(x, v) (HW_ADC_CH_B_CFG2(x).U = (v))
#define HW_ADC_CH_B_CFG2_SET(x, v) (HW_ADC_CH_B_CFG2_WR(x, HW_ADC_CH_B_CFG2_RD(x) |  (v)))
#define HW_ADC_CH_B_CFG2_CLR(x, v) (HW_ADC_CH_B_CFG2_WR(x, HW_ADC_CH_B_CFG2_RD(x) & ~(v)))
#define HW_ADC_CH_B_CFG2_TOG(x, v) (HW_ADC_CH_B_CFG2_WR(x, HW_ADC_CH_B_CFG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_B_CFG2 bitfields
 */

/*!
 * @name Register ADC_CH_B_CFG2, field CHB_LOW_THRES[11:0] (RW)
 *
 * Contains the smaller compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_B_CFG2_CHB_LOW_THRES (0U) /*!< Bit position for ADC_CH_B_CFG2_CHB_LOW_THRES. */
#define BM_ADC_CH_B_CFG2_CHB_LOW_THRES (0x00000FFFU) /*!< Bit mask for ADC_CH_B_CFG2_CHB_LOW_THRES. */
#define BS_ADC_CH_B_CFG2_CHB_LOW_THRES (12U) /*!< Bit field size in bits for ADC_CH_B_CFG2_CHB_LOW_THRES. */

/*! @brief Read current value of the ADC_CH_B_CFG2_CHB_LOW_THRES field. */
#define BR_ADC_CH_B_CFG2_CHB_LOW_THRES(x) (HW_ADC_CH_B_CFG2(x).B.CHB_LOW_THRES)

/*! @brief Format value for bitfield ADC_CH_B_CFG2_CHB_LOW_THRES. */
#define BF_ADC_CH_B_CFG2_CHB_LOW_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG2_CHB_LOW_THRES) & BM_ADC_CH_B_CFG2_CHB_LOW_THRES)

/*! @brief Set the CHB_LOW_THRES field to a new value. */
#define BW_ADC_CH_B_CFG2_CHB_LOW_THRES(x, v) (HW_ADC_CH_B_CFG2_WR(x, (HW_ADC_CH_B_CFG2_RD(x) & ~BM_ADC_CH_B_CFG2_CHB_LOW_THRES) | BF_ADC_CH_B_CFG2_CHB_LOW_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG2, field CHB_AVG_NUMBER[13:12] (RW)
 *
 * If enable average function, this bit contains channel B average number.
 *
 * Values:
 * - 00 - Average number = 4
 * - 01 - Average number = 8
 * - 10 - Average number = 16
 * - 11 - Average number = 32
 */
/*@{*/
#define BP_ADC_CH_B_CFG2_CHB_AVG_NUMBER (12U) /*!< Bit position for ADC_CH_B_CFG2_CHB_AVG_NUMBER. */
#define BM_ADC_CH_B_CFG2_CHB_AVG_NUMBER (0x00003000U) /*!< Bit mask for ADC_CH_B_CFG2_CHB_AVG_NUMBER. */
#define BS_ADC_CH_B_CFG2_CHB_AVG_NUMBER (2U) /*!< Bit field size in bits for ADC_CH_B_CFG2_CHB_AVG_NUMBER. */

/*! @brief Read current value of the ADC_CH_B_CFG2_CHB_AVG_NUMBER field. */
#define BR_ADC_CH_B_CFG2_CHB_AVG_NUMBER(x) (HW_ADC_CH_B_CFG2(x).B.CHB_AVG_NUMBER)

/*! @brief Format value for bitfield ADC_CH_B_CFG2_CHB_AVG_NUMBER. */
#define BF_ADC_CH_B_CFG2_CHB_AVG_NUMBER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG2_CHB_AVG_NUMBER) & BM_ADC_CH_B_CFG2_CHB_AVG_NUMBER)

/*! @brief Set the CHB_AVG_NUMBER field to a new value. */
#define BW_ADC_CH_B_CFG2_CHB_AVG_NUMBER(x, v) (HW_ADC_CH_B_CFG2_WR(x, (HW_ADC_CH_B_CFG2_RD(x) & ~BM_ADC_CH_B_CFG2_CHB_AVG_NUMBER) | BF_ADC_CH_B_CFG2_CHB_AVG_NUMBER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG2, field CHB_AUTO_DIS[15] (RW)
 *
 * During continuous conversion, if compare match a converted result, the ADC
 * checks this bit. If CHB_AUTO_DIS = 1, then channel B stops continuous
 * conversion, if CHB_AUTO_DIS = 0, then channel B keeps continuous working, and the
 * conversion result overwrites the result registers. The default value is 1.
 */
/*@{*/
#define BP_ADC_CH_B_CFG2_CHB_AUTO_DIS (15U) /*!< Bit position for ADC_CH_B_CFG2_CHB_AUTO_DIS. */
#define BM_ADC_CH_B_CFG2_CHB_AUTO_DIS (0x00008000U) /*!< Bit mask for ADC_CH_B_CFG2_CHB_AUTO_DIS. */
#define BS_ADC_CH_B_CFG2_CHB_AUTO_DIS (1U) /*!< Bit field size in bits for ADC_CH_B_CFG2_CHB_AUTO_DIS. */

/*! @brief Read current value of the ADC_CH_B_CFG2_CHB_AUTO_DIS field. */
#define BR_ADC_CH_B_CFG2_CHB_AUTO_DIS(x) (HW_ADC_CH_B_CFG2(x).B.CHB_AUTO_DIS)

/*! @brief Format value for bitfield ADC_CH_B_CFG2_CHB_AUTO_DIS. */
#define BF_ADC_CH_B_CFG2_CHB_AUTO_DIS(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG2_CHB_AUTO_DIS) & BM_ADC_CH_B_CFG2_CHB_AUTO_DIS)

/*! @brief Set the CHB_AUTO_DIS field to a new value. */
#define BW_ADC_CH_B_CFG2_CHB_AUTO_DIS(x, v) (HW_ADC_CH_B_CFG2_WR(x, (HW_ADC_CH_B_CFG2_RD(x) & ~BM_ADC_CH_B_CFG2_CHB_AUTO_DIS) | BF_ADC_CH_B_CFG2_CHB_AUTO_DIS(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG2, field CHB_HIGH_THRES[27:16] (RW)
 *
 * Contains the bigger compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_B_CFG2_CHB_HIGH_THRES (16U) /*!< Bit position for ADC_CH_B_CFG2_CHB_HIGH_THRES. */
#define BM_ADC_CH_B_CFG2_CHB_HIGH_THRES (0x0FFF0000U) /*!< Bit mask for ADC_CH_B_CFG2_CHB_HIGH_THRES. */
#define BS_ADC_CH_B_CFG2_CHB_HIGH_THRES (12U) /*!< Bit field size in bits for ADC_CH_B_CFG2_CHB_HIGH_THRES. */

/*! @brief Read current value of the ADC_CH_B_CFG2_CHB_HIGH_THRES field. */
#define BR_ADC_CH_B_CFG2_CHB_HIGH_THRES(x) (HW_ADC_CH_B_CFG2(x).B.CHB_HIGH_THRES)

/*! @brief Format value for bitfield ADC_CH_B_CFG2_CHB_HIGH_THRES. */
#define BF_ADC_CH_B_CFG2_CHB_HIGH_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG2_CHB_HIGH_THRES) & BM_ADC_CH_B_CFG2_CHB_HIGH_THRES)

/*! @brief Set the CHB_HIGH_THRES field to a new value. */
#define BW_ADC_CH_B_CFG2_CHB_HIGH_THRES(x, v) (HW_ADC_CH_B_CFG2_WR(x, (HW_ADC_CH_B_CFG2_RD(x) & ~BM_ADC_CH_B_CFG2_CHB_HIGH_THRES) | BF_ADC_CH_B_CFG2_CHB_HIGH_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_B_CFG2, field CHB_CMP_MODE[31:29] (RW)
 *
 * Select which compare mode the conversion result will take for channel B.
 *
 * Values:
 * - 001 - If channel B conversion result is greater than CHB_LOW_THRES, then an
 *     interrupt will be generated and the channel B flag will be set if they
 *     are enabled.
 * - 010 - If channel B conversion result is less than or equal to
 *     CHB_LOW_THRES, then an interrupt will be generated and channel B flag will be set if
 *     they are enabled.
 * - 011 - If channel B conversion result is greater than CHB_LOW_THRES and less
 *     than CHB_HIGH_THRES, then an interrupt will be generated and channel B
 *     flag will be set if they are enabled.
 * - 101 - If channel B conversion result is greater than or equal to
 *     CHB_HIGH_THRES, then an interrupt will be generated and channel B flag will be set
 *     if they are enabled.
 * - 110 - If channel B conversion result is less than CHB_HIGH_THRES, then an
 *     interrupt will be generated and channel B flag will be set if they are
 *     enabled.
 * - 111 - If channel B conversion result is less than or equal to
 *     CHB_LOW_THRES, and at the same time, is greater than or equal to CHB_HIGH_THRES, then
 *     an interrupt will be generated and channel B flag will be set.
 */
/*@{*/
#define BP_ADC_CH_B_CFG2_CHB_CMP_MODE (29U) /*!< Bit position for ADC_CH_B_CFG2_CHB_CMP_MODE. */
#define BM_ADC_CH_B_CFG2_CHB_CMP_MODE (0xE0000000U) /*!< Bit mask for ADC_CH_B_CFG2_CHB_CMP_MODE. */
#define BS_ADC_CH_B_CFG2_CHB_CMP_MODE (3U) /*!< Bit field size in bits for ADC_CH_B_CFG2_CHB_CMP_MODE. */

/*! @brief Read current value of the ADC_CH_B_CFG2_CHB_CMP_MODE field. */
#define BR_ADC_CH_B_CFG2_CHB_CMP_MODE(x) (HW_ADC_CH_B_CFG2(x).B.CHB_CMP_MODE)

/*! @brief Format value for bitfield ADC_CH_B_CFG2_CHB_CMP_MODE. */
#define BF_ADC_CH_B_CFG2_CHB_CMP_MODE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_B_CFG2_CHB_CMP_MODE) & BM_ADC_CH_B_CFG2_CHB_CMP_MODE)

/*! @brief Set the CHB_CMP_MODE field to a new value. */
#define BW_ADC_CH_B_CFG2_CHB_CMP_MODE(x, v) (HW_ADC_CH_B_CFG2_WR(x, (HW_ADC_CH_B_CFG2_RD(x) & ~BM_ADC_CH_B_CFG2_CHB_CMP_MODE) | BF_ADC_CH_B_CFG2_CHB_CMP_MODE(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_C_CFG1 - Channel C Configuration 1
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_C_CFG1 - Channel C Configuration 1 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_ch_c_cfg1
{
    uint32_t U;
    struct _hw_adc_ch_c_cfg1_bitfields
    {
        uint32_t CHC_TIMER : 24;       /*!< [23:0] Channel C Timer */
        uint32_t CHC_SEL : 4;          /*!< [27:24] Channel C Select */
        uint32_t RESERVED0 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHC_AVG_EN : 1;       /*!< [29] Channel C Average Enable */
        uint32_t CHC_SINGLE : 1;       /*!< [30] Channel C Single Conversion Start
                                        * a single conversion from logical channel C. Switch between single and
                                        * continuous conversion, it must disable CHC_EN. When both CHC_EN and
                                        * CHC_SINGLE are enabled, CHC_SIGNAL set CHC_EN to 0 and reset itself to 0. */
        uint32_t CHC_EN : 1;           /*!< [31] Channel C Enable */
    } B;
} hw_adc_ch_c_cfg1_t;

/*!
 * @name Constants and macros for entire ADC_CH_C_CFG1 register
 */
/*@{*/
#define HW_ADC_CH_C_CFG1_ADDR(x) ((uintptr_t)(x) + 0x40U)

#define HW_ADC_CH_C_CFG1(x)      (*(__IO hw_adc_ch_c_cfg1_t *) HW_ADC_CH_C_CFG1_ADDR(x))
#define HW_ADC_CH_C_CFG1_RD(x)   (HW_ADC_CH_C_CFG1(x).U)
#define HW_ADC_CH_C_CFG1_WR(x, v) (HW_ADC_CH_C_CFG1(x).U = (v))
#define HW_ADC_CH_C_CFG1_SET(x, v) (HW_ADC_CH_C_CFG1_WR(x, HW_ADC_CH_C_CFG1_RD(x) |  (v)))
#define HW_ADC_CH_C_CFG1_CLR(x, v) (HW_ADC_CH_C_CFG1_WR(x, HW_ADC_CH_C_CFG1_RD(x) & ~(v)))
#define HW_ADC_CH_C_CFG1_TOG(x, v) (HW_ADC_CH_C_CFG1_WR(x, HW_ADC_CH_C_CFG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_C_CFG1 bitfields
 */

/*!
 * @name Register ADC_CH_C_CFG1, field CHC_TIMER[23:0] (RW)
 *
 * This timer is for continuous conversion. The conversion rate = (CHC_TIMER +
 * 1) times sample rate + offset. The offset is due to channel C has lower
 * priority than channel A and channel B. In worst condition, all channel C conversions
 * are blocked by channel A and channel B's. 0x000 to 0xFFF timer value, every
 * CHC_TIMER + 1 times sample rate + offset, the ADC converts one data.
 */
/*@{*/
#define BP_ADC_CH_C_CFG1_CHC_TIMER (0U)    /*!< Bit position for ADC_CH_C_CFG1_CHC_TIMER. */
#define BM_ADC_CH_C_CFG1_CHC_TIMER (0x00FFFFFFU) /*!< Bit mask for ADC_CH_C_CFG1_CHC_TIMER. */
#define BS_ADC_CH_C_CFG1_CHC_TIMER (24U)   /*!< Bit field size in bits for ADC_CH_C_CFG1_CHC_TIMER. */

/*! @brief Read current value of the ADC_CH_C_CFG1_CHC_TIMER field. */
#define BR_ADC_CH_C_CFG1_CHC_TIMER(x) (HW_ADC_CH_C_CFG1(x).B.CHC_TIMER)

/*! @brief Format value for bitfield ADC_CH_C_CFG1_CHC_TIMER. */
#define BF_ADC_CH_C_CFG1_CHC_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG1_CHC_TIMER) & BM_ADC_CH_C_CFG1_CHC_TIMER)

/*! @brief Set the CHC_TIMER field to a new value. */
#define BW_ADC_CH_C_CFG1_CHC_TIMER(x, v) (HW_ADC_CH_C_CFG1_WR(x, (HW_ADC_CH_C_CFG1_RD(x) & ~BM_ADC_CH_C_CFG1_CHC_TIMER) | BF_ADC_CH_C_CFG1_CHC_TIMER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG1, field CHC_SEL[27:24] (RW)
 *
 * Select input channel (from 16 channels) for the logical channel C.
 *
 * Values:
 * - 0000 - Channel 0
 * - 0001 - Channel 1
 * - 0010 - Channel 2
 * - 0011 - Channel 3
 * - 0100 - Channel 4
 * - 0101 - Channel 5
 * - 0110 - Channel 6
 * - 0111 - Channel 7
 * - 1000 - Channel 8
 * - 1001 - Channel 9
 * - 1010 - Channel 10
 * - 1011 - Channel 11
 * - 1100 - Channel 12
 * - 1101 - Channel 13
 * - 1110 - Channel 14
 * - 1111 - Channel 15
 */
/*@{*/
#define BP_ADC_CH_C_CFG1_CHC_SEL (24U)     /*!< Bit position for ADC_CH_C_CFG1_CHC_SEL. */
#define BM_ADC_CH_C_CFG1_CHC_SEL (0x0F000000U) /*!< Bit mask for ADC_CH_C_CFG1_CHC_SEL. */
#define BS_ADC_CH_C_CFG1_CHC_SEL (4U)      /*!< Bit field size in bits for ADC_CH_C_CFG1_CHC_SEL. */

/*! @brief Read current value of the ADC_CH_C_CFG1_CHC_SEL field. */
#define BR_ADC_CH_C_CFG1_CHC_SEL(x) (HW_ADC_CH_C_CFG1(x).B.CHC_SEL)

/*! @brief Format value for bitfield ADC_CH_C_CFG1_CHC_SEL. */
#define BF_ADC_CH_C_CFG1_CHC_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG1_CHC_SEL) & BM_ADC_CH_C_CFG1_CHC_SEL)

/*! @brief Set the CHC_SEL field to a new value. */
#define BW_ADC_CH_C_CFG1_CHC_SEL(x, v) (HW_ADC_CH_C_CFG1_WR(x, (HW_ADC_CH_C_CFG1_RD(x) & ~BM_ADC_CH_C_CFG1_CHC_SEL) | BF_ADC_CH_C_CFG1_CHC_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG1, field CHC_AVG_EN[29] (RW)
 *
 * If enable this bit, channel C will do average for each conversion.
 *
 * Values:
 * - 1 - Enable average function.
 * - 0 - Disable average function.
 */
/*@{*/
#define BP_ADC_CH_C_CFG1_CHC_AVG_EN (29U)  /*!< Bit position for ADC_CH_C_CFG1_CHC_AVG_EN. */
#define BM_ADC_CH_C_CFG1_CHC_AVG_EN (0x20000000U) /*!< Bit mask for ADC_CH_C_CFG1_CHC_AVG_EN. */
#define BS_ADC_CH_C_CFG1_CHC_AVG_EN (1U)   /*!< Bit field size in bits for ADC_CH_C_CFG1_CHC_AVG_EN. */

/*! @brief Read current value of the ADC_CH_C_CFG1_CHC_AVG_EN field. */
#define BR_ADC_CH_C_CFG1_CHC_AVG_EN(x) (HW_ADC_CH_C_CFG1(x).B.CHC_AVG_EN)

/*! @brief Format value for bitfield ADC_CH_C_CFG1_CHC_AVG_EN. */
#define BF_ADC_CH_C_CFG1_CHC_AVG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG1_CHC_AVG_EN) & BM_ADC_CH_C_CFG1_CHC_AVG_EN)

/*! @brief Set the CHC_AVG_EN field to a new value. */
#define BW_ADC_CH_C_CFG1_CHC_AVG_EN(x, v) (HW_ADC_CH_C_CFG1_WR(x, (HW_ADC_CH_C_CFG1_RD(x) & ~BM_ADC_CH_C_CFG1_CHC_AVG_EN) | BF_ADC_CH_C_CFG1_CHC_AVG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG1, field CHC_SINGLE[30] (RW)
 *
 * Controls the usable of logical channel C.
 *
 * Values:
 * - 1 - Start a single conversion. Continuous conversion must stop.
 * - 0 - No single conversion. Continuous conversion can start.
 */
/*@{*/
#define BP_ADC_CH_C_CFG1_CHC_SINGLE (30U)  /*!< Bit position for ADC_CH_C_CFG1_CHC_SINGLE. */
#define BM_ADC_CH_C_CFG1_CHC_SINGLE (0x40000000U) /*!< Bit mask for ADC_CH_C_CFG1_CHC_SINGLE. */
#define BS_ADC_CH_C_CFG1_CHC_SINGLE (1U)   /*!< Bit field size in bits for ADC_CH_C_CFG1_CHC_SINGLE. */

/*! @brief Read current value of the ADC_CH_C_CFG1_CHC_SINGLE field. */
#define BR_ADC_CH_C_CFG1_CHC_SINGLE(x) (HW_ADC_CH_C_CFG1(x).B.CHC_SINGLE)

/*! @brief Format value for bitfield ADC_CH_C_CFG1_CHC_SINGLE. */
#define BF_ADC_CH_C_CFG1_CHC_SINGLE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG1_CHC_SINGLE) & BM_ADC_CH_C_CFG1_CHC_SINGLE)

/*! @brief Set the CHC_SINGLE field to a new value. */
#define BW_ADC_CH_C_CFG1_CHC_SINGLE(x, v) (HW_ADC_CH_C_CFG1_WR(x, (HW_ADC_CH_C_CFG1_RD(x) & ~BM_ADC_CH_C_CFG1_CHC_SINGLE) | BF_ADC_CH_C_CFG1_CHC_SINGLE(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG1, field CHC_EN[31] (RW)
 *
 * Controls the usable of logical channel C.
 *
 * Values:
 * - 1 - Enable logical channel C. Logical channel C will work.
 * - 0 - Disable logical channel C. Prevent logical channel C from working.
 */
/*@{*/
#define BP_ADC_CH_C_CFG1_CHC_EN (31U)      /*!< Bit position for ADC_CH_C_CFG1_CHC_EN. */
#define BM_ADC_CH_C_CFG1_CHC_EN (0x80000000U) /*!< Bit mask for ADC_CH_C_CFG1_CHC_EN. */
#define BS_ADC_CH_C_CFG1_CHC_EN (1U)       /*!< Bit field size in bits for ADC_CH_C_CFG1_CHC_EN. */

/*! @brief Read current value of the ADC_CH_C_CFG1_CHC_EN field. */
#define BR_ADC_CH_C_CFG1_CHC_EN(x) (HW_ADC_CH_C_CFG1(x).B.CHC_EN)

/*! @brief Format value for bitfield ADC_CH_C_CFG1_CHC_EN. */
#define BF_ADC_CH_C_CFG1_CHC_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG1_CHC_EN) & BM_ADC_CH_C_CFG1_CHC_EN)

/*! @brief Set the CHC_EN field to a new value. */
#define BW_ADC_CH_C_CFG1_CHC_EN(x, v) (HW_ADC_CH_C_CFG1_WR(x, (HW_ADC_CH_C_CFG1_RD(x) & ~BM_ADC_CH_C_CFG1_CHC_EN) | BF_ADC_CH_C_CFG1_CHC_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_C_CFG2 - Channel C Configuration 2
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_C_CFG2 - Channel C Configuration 2 (RW)
 *
 * Reset value: 0x00008000U
 */
typedef union _hw_adc_ch_c_cfg2
{
    uint32_t U;
    struct _hw_adc_ch_c_cfg2_bitfields
    {
        uint32_t CHC_LOW_THRES : 12;   /*!< [11:0] Channel C Low Threshold
                                        * Value */
        uint32_t CHC_AVG_NUMBER : 2;   /*!< [13:12] Channel C Average Number */
        uint32_t RESERVED0 : 1;        /*!< [14] This field is reserved. */
        uint32_t CHC_AUTO_DIS : 1;     /*!< [15] Channel C Auto Disable */
        uint32_t CHC_HIGH_THRES : 12;  /*!< [27:16] Channel C High Threshold
                                        * Value */
        uint32_t RESERVED1 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHC_CMP_MODE : 3;     /*!< [31:29] Channel C Compare Mode */
    } B;
} hw_adc_ch_c_cfg2_t;

/*!
 * @name Constants and macros for entire ADC_CH_C_CFG2 register
 */
/*@{*/
#define HW_ADC_CH_C_CFG2_ADDR(x) ((uintptr_t)(x) + 0x50U)

#define HW_ADC_CH_C_CFG2(x)      (*(__IO hw_adc_ch_c_cfg2_t *) HW_ADC_CH_C_CFG2_ADDR(x))
#define HW_ADC_CH_C_CFG2_RD(x)   (HW_ADC_CH_C_CFG2(x).U)
#define HW_ADC_CH_C_CFG2_WR(x, v) (HW_ADC_CH_C_CFG2(x).U = (v))
#define HW_ADC_CH_C_CFG2_SET(x, v) (HW_ADC_CH_C_CFG2_WR(x, HW_ADC_CH_C_CFG2_RD(x) |  (v)))
#define HW_ADC_CH_C_CFG2_CLR(x, v) (HW_ADC_CH_C_CFG2_WR(x, HW_ADC_CH_C_CFG2_RD(x) & ~(v)))
#define HW_ADC_CH_C_CFG2_TOG(x, v) (HW_ADC_CH_C_CFG2_WR(x, HW_ADC_CH_C_CFG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_C_CFG2 bitfields
 */

/*!
 * @name Register ADC_CH_C_CFG2, field CHC_LOW_THRES[11:0] (RW)
 *
 * Contains the smaller compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_C_CFG2_CHC_LOW_THRES (0U) /*!< Bit position for ADC_CH_C_CFG2_CHC_LOW_THRES. */
#define BM_ADC_CH_C_CFG2_CHC_LOW_THRES (0x00000FFFU) /*!< Bit mask for ADC_CH_C_CFG2_CHC_LOW_THRES. */
#define BS_ADC_CH_C_CFG2_CHC_LOW_THRES (12U) /*!< Bit field size in bits for ADC_CH_C_CFG2_CHC_LOW_THRES. */

/*! @brief Read current value of the ADC_CH_C_CFG2_CHC_LOW_THRES field. */
#define BR_ADC_CH_C_CFG2_CHC_LOW_THRES(x) (HW_ADC_CH_C_CFG2(x).B.CHC_LOW_THRES)

/*! @brief Format value for bitfield ADC_CH_C_CFG2_CHC_LOW_THRES. */
#define BF_ADC_CH_C_CFG2_CHC_LOW_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG2_CHC_LOW_THRES) & BM_ADC_CH_C_CFG2_CHC_LOW_THRES)

/*! @brief Set the CHC_LOW_THRES field to a new value. */
#define BW_ADC_CH_C_CFG2_CHC_LOW_THRES(x, v) (HW_ADC_CH_C_CFG2_WR(x, (HW_ADC_CH_C_CFG2_RD(x) & ~BM_ADC_CH_C_CFG2_CHC_LOW_THRES) | BF_ADC_CH_C_CFG2_CHC_LOW_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG2, field CHC_AVG_NUMBER[13:12] (RW)
 *
 * If enable average function, this bit contains channel C average number.
 *
 * Values:
 * - 00 - Average number = 4
 * - 01 - Average number = 8
 * - 10 - Average number = 16
 * - 11 - Average number = 32
 */
/*@{*/
#define BP_ADC_CH_C_CFG2_CHC_AVG_NUMBER (12U) /*!< Bit position for ADC_CH_C_CFG2_CHC_AVG_NUMBER. */
#define BM_ADC_CH_C_CFG2_CHC_AVG_NUMBER (0x00003000U) /*!< Bit mask for ADC_CH_C_CFG2_CHC_AVG_NUMBER. */
#define BS_ADC_CH_C_CFG2_CHC_AVG_NUMBER (2U) /*!< Bit field size in bits for ADC_CH_C_CFG2_CHC_AVG_NUMBER. */

/*! @brief Read current value of the ADC_CH_C_CFG2_CHC_AVG_NUMBER field. */
#define BR_ADC_CH_C_CFG2_CHC_AVG_NUMBER(x) (HW_ADC_CH_C_CFG2(x).B.CHC_AVG_NUMBER)

/*! @brief Format value for bitfield ADC_CH_C_CFG2_CHC_AVG_NUMBER. */
#define BF_ADC_CH_C_CFG2_CHC_AVG_NUMBER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG2_CHC_AVG_NUMBER) & BM_ADC_CH_C_CFG2_CHC_AVG_NUMBER)

/*! @brief Set the CHC_AVG_NUMBER field to a new value. */
#define BW_ADC_CH_C_CFG2_CHC_AVG_NUMBER(x, v) (HW_ADC_CH_C_CFG2_WR(x, (HW_ADC_CH_C_CFG2_RD(x) & ~BM_ADC_CH_C_CFG2_CHC_AVG_NUMBER) | BF_ADC_CH_C_CFG2_CHC_AVG_NUMBER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG2, field CHC_AUTO_DIS[15] (RW)
 *
 * During continuous conversion, if compare match a converted result, the ADC
 * checks this bit. If CHC_AUTO_DIS = 1, then channel C stops continuous
 * conversion, if CHC_AUTO_DIS = 0, then channel C keeps continuous working, and the
 * conversion result overwrites the result registers. The default value is 1.
 */
/*@{*/
#define BP_ADC_CH_C_CFG2_CHC_AUTO_DIS (15U) /*!< Bit position for ADC_CH_C_CFG2_CHC_AUTO_DIS. */
#define BM_ADC_CH_C_CFG2_CHC_AUTO_DIS (0x00008000U) /*!< Bit mask for ADC_CH_C_CFG2_CHC_AUTO_DIS. */
#define BS_ADC_CH_C_CFG2_CHC_AUTO_DIS (1U) /*!< Bit field size in bits for ADC_CH_C_CFG2_CHC_AUTO_DIS. */

/*! @brief Read current value of the ADC_CH_C_CFG2_CHC_AUTO_DIS field. */
#define BR_ADC_CH_C_CFG2_CHC_AUTO_DIS(x) (HW_ADC_CH_C_CFG2(x).B.CHC_AUTO_DIS)

/*! @brief Format value for bitfield ADC_CH_C_CFG2_CHC_AUTO_DIS. */
#define BF_ADC_CH_C_CFG2_CHC_AUTO_DIS(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG2_CHC_AUTO_DIS) & BM_ADC_CH_C_CFG2_CHC_AUTO_DIS)

/*! @brief Set the CHC_AUTO_DIS field to a new value. */
#define BW_ADC_CH_C_CFG2_CHC_AUTO_DIS(x, v) (HW_ADC_CH_C_CFG2_WR(x, (HW_ADC_CH_C_CFG2_RD(x) & ~BM_ADC_CH_C_CFG2_CHC_AUTO_DIS) | BF_ADC_CH_C_CFG2_CHC_AUTO_DIS(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG2, field CHC_HIGH_THRES[27:16] (RW)
 *
 * Contains the bigger compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_C_CFG2_CHC_HIGH_THRES (16U) /*!< Bit position for ADC_CH_C_CFG2_CHC_HIGH_THRES. */
#define BM_ADC_CH_C_CFG2_CHC_HIGH_THRES (0x0FFF0000U) /*!< Bit mask for ADC_CH_C_CFG2_CHC_HIGH_THRES. */
#define BS_ADC_CH_C_CFG2_CHC_HIGH_THRES (12U) /*!< Bit field size in bits for ADC_CH_C_CFG2_CHC_HIGH_THRES. */

/*! @brief Read current value of the ADC_CH_C_CFG2_CHC_HIGH_THRES field. */
#define BR_ADC_CH_C_CFG2_CHC_HIGH_THRES(x) (HW_ADC_CH_C_CFG2(x).B.CHC_HIGH_THRES)

/*! @brief Format value for bitfield ADC_CH_C_CFG2_CHC_HIGH_THRES. */
#define BF_ADC_CH_C_CFG2_CHC_HIGH_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG2_CHC_HIGH_THRES) & BM_ADC_CH_C_CFG2_CHC_HIGH_THRES)

/*! @brief Set the CHC_HIGH_THRES field to a new value. */
#define BW_ADC_CH_C_CFG2_CHC_HIGH_THRES(x, v) (HW_ADC_CH_C_CFG2_WR(x, (HW_ADC_CH_C_CFG2_RD(x) & ~BM_ADC_CH_C_CFG2_CHC_HIGH_THRES) | BF_ADC_CH_C_CFG2_CHC_HIGH_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_C_CFG2, field CHC_CMP_MODE[31:29] (RW)
 *
 * Select which compare mode the conversion result will take (for channel C).
 *
 * Values:
 * - 001 - If channel C conversion result bigger than CHC_LOW_THRES, then an
 *     interrupt will be generated and the channel C flag will be set if they are
 *     enabled.
 * - 010 - If channel C conversion result smaller or equal to CHC_LOW_THRES,
 *     then an interrupt will be generated and channel C flag will be set if they
 *     are enabled.
 * - 011 - If channel C conversion result bigger than CHC_LOW_THRES and smaller
 *     than CHC_HIGH_THRES, then an interrupt will be generated and channel C
 *     flag will be set if they are enabled.
 * - 101 - If channel C conversion result bigger or equal to CHC_HIGH_THRES,
 *     then an interrupt will be generated and channel C flag will be set if they
 *     are enabled.
 * - 110 - If channel C conversion result smaller than CHC_HIGH_THRES, then an
 *     interrupt will be generated and channel C flag will be set if they are
 *     enabled.
 * - 111 - If channel C conversion result smaller or equal to CHC_LOW_THRES, and
 *     at the same time, bigger or equal to CHC_HIGH_THRES, then an interrupt
 *     will be generated and channel C flag will be set if they are enabled.
 */
/*@{*/
#define BP_ADC_CH_C_CFG2_CHC_CMP_MODE (29U) /*!< Bit position for ADC_CH_C_CFG2_CHC_CMP_MODE. */
#define BM_ADC_CH_C_CFG2_CHC_CMP_MODE (0xE0000000U) /*!< Bit mask for ADC_CH_C_CFG2_CHC_CMP_MODE. */
#define BS_ADC_CH_C_CFG2_CHC_CMP_MODE (3U) /*!< Bit field size in bits for ADC_CH_C_CFG2_CHC_CMP_MODE. */

/*! @brief Read current value of the ADC_CH_C_CFG2_CHC_CMP_MODE field. */
#define BR_ADC_CH_C_CFG2_CHC_CMP_MODE(x) (HW_ADC_CH_C_CFG2(x).B.CHC_CMP_MODE)

/*! @brief Format value for bitfield ADC_CH_C_CFG2_CHC_CMP_MODE. */
#define BF_ADC_CH_C_CFG2_CHC_CMP_MODE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_C_CFG2_CHC_CMP_MODE) & BM_ADC_CH_C_CFG2_CHC_CMP_MODE)

/*! @brief Set the CHC_CMP_MODE field to a new value. */
#define BW_ADC_CH_C_CFG2_CHC_CMP_MODE(x, v) (HW_ADC_CH_C_CFG2_WR(x, (HW_ADC_CH_C_CFG2_RD(x) & ~BM_ADC_CH_C_CFG2_CHC_CMP_MODE) | BF_ADC_CH_C_CFG2_CHC_CMP_MODE(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_D_CFG1 - Channel D Configuration 1
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_D_CFG1 - Channel D Configuration 1 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_ch_d_cfg1
{
    uint32_t U;
    struct _hw_adc_ch_d_cfg1_bitfields
    {
        uint32_t CHD_TIMER : 24;       /*!< [23:0] Channel D Timer */
        uint32_t CHD_SEL : 4;          /*!< [27:24] Channel D Select */
        uint32_t RESERVED0 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHD_AVG_EN : 1;       /*!< [29] Channel D Average Enable */
        uint32_t CHD_SINGLE : 1;       /*!< [30] Channel D Single Conversion */
        uint32_t CHD_EN : 1;           /*!< [31] Channel D Enable */
    } B;
} hw_adc_ch_d_cfg1_t;

/*!
 * @name Constants and macros for entire ADC_CH_D_CFG1 register
 */
/*@{*/
#define HW_ADC_CH_D_CFG1_ADDR(x) ((uintptr_t)(x) + 0x60U)

#define HW_ADC_CH_D_CFG1(x)      (*(__IO hw_adc_ch_d_cfg1_t *) HW_ADC_CH_D_CFG1_ADDR(x))
#define HW_ADC_CH_D_CFG1_RD(x)   (HW_ADC_CH_D_CFG1(x).U)
#define HW_ADC_CH_D_CFG1_WR(x, v) (HW_ADC_CH_D_CFG1(x).U = (v))
#define HW_ADC_CH_D_CFG1_SET(x, v) (HW_ADC_CH_D_CFG1_WR(x, HW_ADC_CH_D_CFG1_RD(x) |  (v)))
#define HW_ADC_CH_D_CFG1_CLR(x, v) (HW_ADC_CH_D_CFG1_WR(x, HW_ADC_CH_D_CFG1_RD(x) & ~(v)))
#define HW_ADC_CH_D_CFG1_TOG(x, v) (HW_ADC_CH_D_CFG1_WR(x, HW_ADC_CH_D_CFG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_D_CFG1 bitfields
 */

/*!
 * @name Register ADC_CH_D_CFG1, field CHD_TIMER[23:0] (RW)
 *
 * This timer is for continuous conversion. The conversion rate = (CHD_TIMER +
 * 1) times sample rate + offset. The offset is due to channel D has lower
 * priority than Channel A, B, and C. In worst case, all channel D's conversion are
 * blocked by channel A, channel B and channel C's. 0x000 to 0xFFF timer value, every
 * CHD_TIMER + 1 times sample rate + offset, the ADC converts one data.
 */
/*@{*/
#define BP_ADC_CH_D_CFG1_CHD_TIMER (0U)    /*!< Bit position for ADC_CH_D_CFG1_CHD_TIMER. */
#define BM_ADC_CH_D_CFG1_CHD_TIMER (0x00FFFFFFU) /*!< Bit mask for ADC_CH_D_CFG1_CHD_TIMER. */
#define BS_ADC_CH_D_CFG1_CHD_TIMER (24U)   /*!< Bit field size in bits for ADC_CH_D_CFG1_CHD_TIMER. */

/*! @brief Read current value of the ADC_CH_D_CFG1_CHD_TIMER field. */
#define BR_ADC_CH_D_CFG1_CHD_TIMER(x) (HW_ADC_CH_D_CFG1(x).B.CHD_TIMER)

/*! @brief Format value for bitfield ADC_CH_D_CFG1_CHD_TIMER. */
#define BF_ADC_CH_D_CFG1_CHD_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG1_CHD_TIMER) & BM_ADC_CH_D_CFG1_CHD_TIMER)

/*! @brief Set the CHD_TIMER field to a new value. */
#define BW_ADC_CH_D_CFG1_CHD_TIMER(x, v) (HW_ADC_CH_D_CFG1_WR(x, (HW_ADC_CH_D_CFG1_RD(x) & ~BM_ADC_CH_D_CFG1_CHD_TIMER) | BF_ADC_CH_D_CFG1_CHD_TIMER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG1, field CHD_SEL[27:24] (RW)
 *
 * Select input channel (from 16 channels) for the logical channel D.
 *
 * Values:
 * - 0000 - Channel 0
 * - 0001 - Channel 1
 * - 0010 - Channel 2
 * - 0011 - Channel 3
 * - 0100 - Channel 4
 * - 0101 - Channel 5
 * - 0110 - Channel 6
 * - 0111 - Channel 7
 * - 1000 - Channel 8
 * - 1001 - Channel 9
 * - 1010 - Channel 10
 * - 1011 - Channel 11
 * - 1100 - Channel 12
 * - 1101 - Channel 13
 * - 1110 - Channel 14
 * - 1111 - Channel 15
 */
/*@{*/
#define BP_ADC_CH_D_CFG1_CHD_SEL (24U)     /*!< Bit position for ADC_CH_D_CFG1_CHD_SEL. */
#define BM_ADC_CH_D_CFG1_CHD_SEL (0x0F000000U) /*!< Bit mask for ADC_CH_D_CFG1_CHD_SEL. */
#define BS_ADC_CH_D_CFG1_CHD_SEL (4U)      /*!< Bit field size in bits for ADC_CH_D_CFG1_CHD_SEL. */

/*! @brief Read current value of the ADC_CH_D_CFG1_CHD_SEL field. */
#define BR_ADC_CH_D_CFG1_CHD_SEL(x) (HW_ADC_CH_D_CFG1(x).B.CHD_SEL)

/*! @brief Format value for bitfield ADC_CH_D_CFG1_CHD_SEL. */
#define BF_ADC_CH_D_CFG1_CHD_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG1_CHD_SEL) & BM_ADC_CH_D_CFG1_CHD_SEL)

/*! @brief Set the CHD_SEL field to a new value. */
#define BW_ADC_CH_D_CFG1_CHD_SEL(x, v) (HW_ADC_CH_D_CFG1_WR(x, (HW_ADC_CH_D_CFG1_RD(x) & ~BM_ADC_CH_D_CFG1_CHD_SEL) | BF_ADC_CH_D_CFG1_CHD_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG1, field CHD_AVG_EN[29] (RW)
 *
 * If enable this bit, channel D will do average for each conversion.
 *
 * Values:
 * - 1 - Enable average function.
 * - 0 - Disable average function.
 */
/*@{*/
#define BP_ADC_CH_D_CFG1_CHD_AVG_EN (29U)  /*!< Bit position for ADC_CH_D_CFG1_CHD_AVG_EN. */
#define BM_ADC_CH_D_CFG1_CHD_AVG_EN (0x20000000U) /*!< Bit mask for ADC_CH_D_CFG1_CHD_AVG_EN. */
#define BS_ADC_CH_D_CFG1_CHD_AVG_EN (1U)   /*!< Bit field size in bits for ADC_CH_D_CFG1_CHD_AVG_EN. */

/*! @brief Read current value of the ADC_CH_D_CFG1_CHD_AVG_EN field. */
#define BR_ADC_CH_D_CFG1_CHD_AVG_EN(x) (HW_ADC_CH_D_CFG1(x).B.CHD_AVG_EN)

/*! @brief Format value for bitfield ADC_CH_D_CFG1_CHD_AVG_EN. */
#define BF_ADC_CH_D_CFG1_CHD_AVG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG1_CHD_AVG_EN) & BM_ADC_CH_D_CFG1_CHD_AVG_EN)

/*! @brief Set the CHD_AVG_EN field to a new value. */
#define BW_ADC_CH_D_CFG1_CHD_AVG_EN(x, v) (HW_ADC_CH_D_CFG1_WR(x, (HW_ADC_CH_D_CFG1_RD(x) & ~BM_ADC_CH_D_CFG1_CHD_AVG_EN) | BF_ADC_CH_D_CFG1_CHD_AVG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG1, field CHD_SINGLE[30] (RW)
 *
 * Start a single conversion from logical channel D. Switch between single and
 * continuous conversion, it must disable channel D first. When both CHD_EN and
 * CHD_SINGLE are enabled, CHD_SIGNAL set CHD_EN to 0 and reset itself to 0.
 *
 * Values:
 * - 1 - Start a single conversion. Continuous conversion must stop.
 * - 0 - No single conversion. Continuous conversion can start.
 */
/*@{*/
#define BP_ADC_CH_D_CFG1_CHD_SINGLE (30U)  /*!< Bit position for ADC_CH_D_CFG1_CHD_SINGLE. */
#define BM_ADC_CH_D_CFG1_CHD_SINGLE (0x40000000U) /*!< Bit mask for ADC_CH_D_CFG1_CHD_SINGLE. */
#define BS_ADC_CH_D_CFG1_CHD_SINGLE (1U)   /*!< Bit field size in bits for ADC_CH_D_CFG1_CHD_SINGLE. */

/*! @brief Read current value of the ADC_CH_D_CFG1_CHD_SINGLE field. */
#define BR_ADC_CH_D_CFG1_CHD_SINGLE(x) (HW_ADC_CH_D_CFG1(x).B.CHD_SINGLE)

/*! @brief Format value for bitfield ADC_CH_D_CFG1_CHD_SINGLE. */
#define BF_ADC_CH_D_CFG1_CHD_SINGLE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG1_CHD_SINGLE) & BM_ADC_CH_D_CFG1_CHD_SINGLE)

/*! @brief Set the CHD_SINGLE field to a new value. */
#define BW_ADC_CH_D_CFG1_CHD_SINGLE(x, v) (HW_ADC_CH_D_CFG1_WR(x, (HW_ADC_CH_D_CFG1_RD(x) & ~BM_ADC_CH_D_CFG1_CHD_SINGLE) | BF_ADC_CH_D_CFG1_CHD_SINGLE(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG1, field CHD_EN[31] (RW)
 *
 * Controls the usable of logical channel D.
 *
 * Values:
 * - 1 - Enable logical channel D. Logical channel D will work.
 * - 0 - Disable logical channel D. Prevent logical channel D from working.
 */
/*@{*/
#define BP_ADC_CH_D_CFG1_CHD_EN (31U)      /*!< Bit position for ADC_CH_D_CFG1_CHD_EN. */
#define BM_ADC_CH_D_CFG1_CHD_EN (0x80000000U) /*!< Bit mask for ADC_CH_D_CFG1_CHD_EN. */
#define BS_ADC_CH_D_CFG1_CHD_EN (1U)       /*!< Bit field size in bits for ADC_CH_D_CFG1_CHD_EN. */

/*! @brief Read current value of the ADC_CH_D_CFG1_CHD_EN field. */
#define BR_ADC_CH_D_CFG1_CHD_EN(x) (HW_ADC_CH_D_CFG1(x).B.CHD_EN)

/*! @brief Format value for bitfield ADC_CH_D_CFG1_CHD_EN. */
#define BF_ADC_CH_D_CFG1_CHD_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG1_CHD_EN) & BM_ADC_CH_D_CFG1_CHD_EN)

/*! @brief Set the CHD_EN field to a new value. */
#define BW_ADC_CH_D_CFG1_CHD_EN(x, v) (HW_ADC_CH_D_CFG1_WR(x, (HW_ADC_CH_D_CFG1_RD(x) & ~BM_ADC_CH_D_CFG1_CHD_EN) | BF_ADC_CH_D_CFG1_CHD_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_D_CFG2 - Channel D Configuration 2
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_D_CFG2 - Channel D Configuration 2 (RW)
 *
 * Reset value: 0x00008000U
 */
typedef union _hw_adc_ch_d_cfg2
{
    uint32_t U;
    struct _hw_adc_ch_d_cfg2_bitfields
    {
        uint32_t CHD_LOW_THRES : 12;   /*!< [11:0] Channel D Low Threshold
                                        * Value */
        uint32_t CHD_AVG_NUMBER : 2;   /*!< [13:12] Channel D Average Number */
        uint32_t RESERVED0 : 1;        /*!< [14] This field is reserved. */
        uint32_t CHD_AUTO_DIS : 1;     /*!< [15] Channel D Auto Disable */
        uint32_t CHD_HIGH_THRES : 12;  /*!< [27:16] Channel D High Threshold
                                        * Value */
        uint32_t RESERVED1 : 1;        /*!< [28] This field is reserved. */
        uint32_t CHD_CMP_MODE : 3;     /*!< [31:29] Channel D Compare Mode */
    } B;
} hw_adc_ch_d_cfg2_t;

/*!
 * @name Constants and macros for entire ADC_CH_D_CFG2 register
 */
/*@{*/
#define HW_ADC_CH_D_CFG2_ADDR(x) ((uintptr_t)(x) + 0x70U)

#define HW_ADC_CH_D_CFG2(x)      (*(__IO hw_adc_ch_d_cfg2_t *) HW_ADC_CH_D_CFG2_ADDR(x))
#define HW_ADC_CH_D_CFG2_RD(x)   (HW_ADC_CH_D_CFG2(x).U)
#define HW_ADC_CH_D_CFG2_WR(x, v) (HW_ADC_CH_D_CFG2(x).U = (v))
#define HW_ADC_CH_D_CFG2_SET(x, v) (HW_ADC_CH_D_CFG2_WR(x, HW_ADC_CH_D_CFG2_RD(x) |  (v)))
#define HW_ADC_CH_D_CFG2_CLR(x, v) (HW_ADC_CH_D_CFG2_WR(x, HW_ADC_CH_D_CFG2_RD(x) & ~(v)))
#define HW_ADC_CH_D_CFG2_TOG(x, v) (HW_ADC_CH_D_CFG2_WR(x, HW_ADC_CH_D_CFG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_D_CFG2 bitfields
 */

/*!
 * @name Register ADC_CH_D_CFG2, field CHD_LOW_THRES[11:0] (RW)
 *
 * Contains the smaller compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_D_CFG2_CHD_LOW_THRES (0U) /*!< Bit position for ADC_CH_D_CFG2_CHD_LOW_THRES. */
#define BM_ADC_CH_D_CFG2_CHD_LOW_THRES (0x00000FFFU) /*!< Bit mask for ADC_CH_D_CFG2_CHD_LOW_THRES. */
#define BS_ADC_CH_D_CFG2_CHD_LOW_THRES (12U) /*!< Bit field size in bits for ADC_CH_D_CFG2_CHD_LOW_THRES. */

/*! @brief Read current value of the ADC_CH_D_CFG2_CHD_LOW_THRES field. */
#define BR_ADC_CH_D_CFG2_CHD_LOW_THRES(x) (HW_ADC_CH_D_CFG2(x).B.CHD_LOW_THRES)

/*! @brief Format value for bitfield ADC_CH_D_CFG2_CHD_LOW_THRES. */
#define BF_ADC_CH_D_CFG2_CHD_LOW_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG2_CHD_LOW_THRES) & BM_ADC_CH_D_CFG2_CHD_LOW_THRES)

/*! @brief Set the CHD_LOW_THRES field to a new value. */
#define BW_ADC_CH_D_CFG2_CHD_LOW_THRES(x, v) (HW_ADC_CH_D_CFG2_WR(x, (HW_ADC_CH_D_CFG2_RD(x) & ~BM_ADC_CH_D_CFG2_CHD_LOW_THRES) | BF_ADC_CH_D_CFG2_CHD_LOW_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG2, field CHD_AVG_NUMBER[13:12] (RW)
 *
 * If enable average function, this bit contains channel D average number.
 *
 * Values:
 * - 00 - Average number = 4
 * - 01 - Average number = 8
 * - 10 - Average number = 16
 * - 11 - Average number = 32
 */
/*@{*/
#define BP_ADC_CH_D_CFG2_CHD_AVG_NUMBER (12U) /*!< Bit position for ADC_CH_D_CFG2_CHD_AVG_NUMBER. */
#define BM_ADC_CH_D_CFG2_CHD_AVG_NUMBER (0x00003000U) /*!< Bit mask for ADC_CH_D_CFG2_CHD_AVG_NUMBER. */
#define BS_ADC_CH_D_CFG2_CHD_AVG_NUMBER (2U) /*!< Bit field size in bits for ADC_CH_D_CFG2_CHD_AVG_NUMBER. */

/*! @brief Read current value of the ADC_CH_D_CFG2_CHD_AVG_NUMBER field. */
#define BR_ADC_CH_D_CFG2_CHD_AVG_NUMBER(x) (HW_ADC_CH_D_CFG2(x).B.CHD_AVG_NUMBER)

/*! @brief Format value for bitfield ADC_CH_D_CFG2_CHD_AVG_NUMBER. */
#define BF_ADC_CH_D_CFG2_CHD_AVG_NUMBER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG2_CHD_AVG_NUMBER) & BM_ADC_CH_D_CFG2_CHD_AVG_NUMBER)

/*! @brief Set the CHD_AVG_NUMBER field to a new value. */
#define BW_ADC_CH_D_CFG2_CHD_AVG_NUMBER(x, v) (HW_ADC_CH_D_CFG2_WR(x, (HW_ADC_CH_D_CFG2_RD(x) & ~BM_ADC_CH_D_CFG2_CHD_AVG_NUMBER) | BF_ADC_CH_D_CFG2_CHD_AVG_NUMBER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG2, field CHD_AUTO_DIS[15] (RW)
 *
 * During continuous conversion, if compare match a converted result, the ADC
 * checks this bit. If CHD_AUTO_DIS = 1, then channel D stops continuous
 * conversion, if CHD_AUTO_DIS = 0, then channel D keeps continuous working, and the
 * conversion result overwrites the result registers. The default value is 1.
 */
/*@{*/
#define BP_ADC_CH_D_CFG2_CHD_AUTO_DIS (15U) /*!< Bit position for ADC_CH_D_CFG2_CHD_AUTO_DIS. */
#define BM_ADC_CH_D_CFG2_CHD_AUTO_DIS (0x00008000U) /*!< Bit mask for ADC_CH_D_CFG2_CHD_AUTO_DIS. */
#define BS_ADC_CH_D_CFG2_CHD_AUTO_DIS (1U) /*!< Bit field size in bits for ADC_CH_D_CFG2_CHD_AUTO_DIS. */

/*! @brief Read current value of the ADC_CH_D_CFG2_CHD_AUTO_DIS field. */
#define BR_ADC_CH_D_CFG2_CHD_AUTO_DIS(x) (HW_ADC_CH_D_CFG2(x).B.CHD_AUTO_DIS)

/*! @brief Format value for bitfield ADC_CH_D_CFG2_CHD_AUTO_DIS. */
#define BF_ADC_CH_D_CFG2_CHD_AUTO_DIS(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG2_CHD_AUTO_DIS) & BM_ADC_CH_D_CFG2_CHD_AUTO_DIS)

/*! @brief Set the CHD_AUTO_DIS field to a new value. */
#define BW_ADC_CH_D_CFG2_CHD_AUTO_DIS(x, v) (HW_ADC_CH_D_CFG2_WR(x, (HW_ADC_CH_D_CFG2_RD(x) & ~BM_ADC_CH_D_CFG2_CHD_AUTO_DIS) | BF_ADC_CH_D_CFG2_CHD_AUTO_DIS(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG2, field CHD_HIGH_THRES[27:16] (RW)
 *
 * Contains the bigger compare value to compare with the conversion result when
 * a compare mode has been selected.
 */
/*@{*/
#define BP_ADC_CH_D_CFG2_CHD_HIGH_THRES (16U) /*!< Bit position for ADC_CH_D_CFG2_CHD_HIGH_THRES. */
#define BM_ADC_CH_D_CFG2_CHD_HIGH_THRES (0x0FFF0000U) /*!< Bit mask for ADC_CH_D_CFG2_CHD_HIGH_THRES. */
#define BS_ADC_CH_D_CFG2_CHD_HIGH_THRES (12U) /*!< Bit field size in bits for ADC_CH_D_CFG2_CHD_HIGH_THRES. */

/*! @brief Read current value of the ADC_CH_D_CFG2_CHD_HIGH_THRES field. */
#define BR_ADC_CH_D_CFG2_CHD_HIGH_THRES(x) (HW_ADC_CH_D_CFG2(x).B.CHD_HIGH_THRES)

/*! @brief Format value for bitfield ADC_CH_D_CFG2_CHD_HIGH_THRES. */
#define BF_ADC_CH_D_CFG2_CHD_HIGH_THRES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG2_CHD_HIGH_THRES) & BM_ADC_CH_D_CFG2_CHD_HIGH_THRES)

/*! @brief Set the CHD_HIGH_THRES field to a new value. */
#define BW_ADC_CH_D_CFG2_CHD_HIGH_THRES(x, v) (HW_ADC_CH_D_CFG2_WR(x, (HW_ADC_CH_D_CFG2_RD(x) & ~BM_ADC_CH_D_CFG2_CHD_HIGH_THRES) | BF_ADC_CH_D_CFG2_CHD_HIGH_THRES(v)))
/*@}*/

/*!
 * @name Register ADC_CH_D_CFG2, field CHD_CMP_MODE[31:29] (RW)
 *
 * Select which compare mode the conversion result will take (for channel D).
 *
 * Values:
 * - 001 - If channel D conversion result bigger than CHD_LOW_THRES, then an
 *     interrupt will be generated and the channel D flag will be set if they are
 *     enabled.
 * - 010 - If channel D conversion result smaller or equal to CHD_LOW_THRES,
 *     then an interrupt will be generated and channel D flag will be set if they
 *     are enabled.
 * - 011 - If channel D conversion result bigger than CHD_LOW_THRES and smaller
 *     than CHD_HIGH_THRES, then an interrupt will be generated and channel D
 *     flag will be set if they are enabled.
 * - 101 - If channel D conversion result bigger or equal to CHD_HIGH_THRES,
 *     then an interrupt will be generated and channel D flag will be set if they
 *     are enabled.
 * - 110 - If channel D conversion result smaller than CHD_HIGH_THRES, then an
 *     interrupt will be generated and channel D flag will be set if they are
 *     enabled.
 * - 111 - If channel D conversion result smaller or equal to CHD_LOW_THRES, and
 *     at the same time, bigger or equal to CHD_HIGH_THRES, then an interrupt
 *     will be generated and channel D flag will be set if they are enabled.
 */
/*@{*/
#define BP_ADC_CH_D_CFG2_CHD_CMP_MODE (29U) /*!< Bit position for ADC_CH_D_CFG2_CHD_CMP_MODE. */
#define BM_ADC_CH_D_CFG2_CHD_CMP_MODE (0xE0000000U) /*!< Bit mask for ADC_CH_D_CFG2_CHD_CMP_MODE. */
#define BS_ADC_CH_D_CFG2_CHD_CMP_MODE (3U) /*!< Bit field size in bits for ADC_CH_D_CFG2_CHD_CMP_MODE. */

/*! @brief Read current value of the ADC_CH_D_CFG2_CHD_CMP_MODE field. */
#define BR_ADC_CH_D_CFG2_CHD_CMP_MODE(x) (HW_ADC_CH_D_CFG2(x).B.CHD_CMP_MODE)

/*! @brief Format value for bitfield ADC_CH_D_CFG2_CHD_CMP_MODE. */
#define BF_ADC_CH_D_CFG2_CHD_CMP_MODE(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_D_CFG2_CHD_CMP_MODE) & BM_ADC_CH_D_CFG2_CHD_CMP_MODE)

/*! @brief Set the CHD_CMP_MODE field to a new value. */
#define BW_ADC_CH_D_CFG2_CHD_CMP_MODE(x, v) (HW_ADC_CH_D_CFG2_WR(x, (HW_ADC_CH_D_CFG2_RD(x) & ~BM_ADC_CH_D_CFG2_CHD_CMP_MODE) | BF_ADC_CH_D_CFG2_CHD_CMP_MODE(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_SW_CFG - Channel Software Configuration
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_SW_CFG - Channel Software Configuration (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_ch_sw_cfg
{
    uint32_t U;
    struct _hw_adc_ch_sw_cfg_bitfields
    {
        uint32_t RESERVED0 : 21;       /*!< [20:0] This field is reserved. */
        uint32_t CH_SW_AVG_NUMBER : 2; /*!< [22:21] Channel Software Average
                                        * Number */
        uint32_t CH_SW_AVG_EN : 1;     /*!< [23] Channel Software Average Enable
                                        * */
        uint32_t CH_SW_SEL : 4;        /*!< [27:24] Software Trigger Channel Select
                                        * */
        uint32_t RESERVED1 : 3;        /*!< [30:28] This field is reserved. */
        uint32_t START_CONV : 1;       /*!< [31] Start Software Trigger Conversion
                                        * */
    } B;
} hw_adc_ch_sw_cfg_t;

/*!
 * @name Constants and macros for entire ADC_CH_SW_CFG register
 */
/*@{*/
#define HW_ADC_CH_SW_CFG_ADDR(x) ((uintptr_t)(x) + 0x80U)

#define HW_ADC_CH_SW_CFG(x)      (*(__IO hw_adc_ch_sw_cfg_t *) HW_ADC_CH_SW_CFG_ADDR(x))
#define HW_ADC_CH_SW_CFG_RD(x)   (HW_ADC_CH_SW_CFG(x).U)
#define HW_ADC_CH_SW_CFG_WR(x, v) (HW_ADC_CH_SW_CFG(x).U = (v))
#define HW_ADC_CH_SW_CFG_SET(x, v) (HW_ADC_CH_SW_CFG_WR(x, HW_ADC_CH_SW_CFG_RD(x) |  (v)))
#define HW_ADC_CH_SW_CFG_CLR(x, v) (HW_ADC_CH_SW_CFG_WR(x, HW_ADC_CH_SW_CFG_RD(x) & ~(v)))
#define HW_ADC_CH_SW_CFG_TOG(x, v) (HW_ADC_CH_SW_CFG_WR(x, HW_ADC_CH_SW_CFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_SW_CFG bitfields
 */

/*!
 * @name Register ADC_CH_SW_CFG, field CH_SW_AVG_NUMBER[22:21] (RW)
 *
 * If enable average function, this bit contains channel Software average number.
 *
 * Values:
 * - 00 - Average number = 4
 * - 01 - Average number = 8
 * - 10 - Average number = 16
 * - 11 - Average number = 32
 */
/*@{*/
#define BP_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER (21U) /*!< Bit position for ADC_CH_SW_CFG_CH_SW_AVG_NUMBER. */
#define BM_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER (0x00600000U) /*!< Bit mask for ADC_CH_SW_CFG_CH_SW_AVG_NUMBER. */
#define BS_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER (2U) /*!< Bit field size in bits for ADC_CH_SW_CFG_CH_SW_AVG_NUMBER. */

/*! @brief Read current value of the ADC_CH_SW_CFG_CH_SW_AVG_NUMBER field. */
#define BR_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER(x) (HW_ADC_CH_SW_CFG(x).B.CH_SW_AVG_NUMBER)

/*! @brief Format value for bitfield ADC_CH_SW_CFG_CH_SW_AVG_NUMBER. */
#define BF_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER) & BM_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER)

/*! @brief Set the CH_SW_AVG_NUMBER field to a new value. */
#define BW_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER(x, v) (HW_ADC_CH_SW_CFG_WR(x, (HW_ADC_CH_SW_CFG_RD(x) & ~BM_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER) | BF_ADC_CH_SW_CFG_CH_SW_AVG_NUMBER(v)))
/*@}*/

/*!
 * @name Register ADC_CH_SW_CFG, field CH_SW_AVG_EN[23] (RW)
 *
 * If enable this bit, channel Software will do average for each conversion.
 *
 * Values:
 * - 1 - Enable average function.
 * - 0 - Disable average function.
 */
/*@{*/
#define BP_ADC_CH_SW_CFG_CH_SW_AVG_EN (23U) /*!< Bit position for ADC_CH_SW_CFG_CH_SW_AVG_EN. */
#define BM_ADC_CH_SW_CFG_CH_SW_AVG_EN (0x00800000U) /*!< Bit mask for ADC_CH_SW_CFG_CH_SW_AVG_EN. */
#define BS_ADC_CH_SW_CFG_CH_SW_AVG_EN (1U) /*!< Bit field size in bits for ADC_CH_SW_CFG_CH_SW_AVG_EN. */

/*! @brief Read current value of the ADC_CH_SW_CFG_CH_SW_AVG_EN field. */
#define BR_ADC_CH_SW_CFG_CH_SW_AVG_EN(x) (HW_ADC_CH_SW_CFG(x).B.CH_SW_AVG_EN)

/*! @brief Format value for bitfield ADC_CH_SW_CFG_CH_SW_AVG_EN. */
#define BF_ADC_CH_SW_CFG_CH_SW_AVG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_SW_CFG_CH_SW_AVG_EN) & BM_ADC_CH_SW_CFG_CH_SW_AVG_EN)

/*! @brief Set the CH_SW_AVG_EN field to a new value. */
#define BW_ADC_CH_SW_CFG_CH_SW_AVG_EN(x, v) (HW_ADC_CH_SW_CFG_WR(x, (HW_ADC_CH_SW_CFG_RD(x) & ~BM_ADC_CH_SW_CFG_CH_SW_AVG_EN) | BF_ADC_CH_SW_CFG_CH_SW_AVG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_CH_SW_CFG, field CH_SW_SEL[27:24] (RW)
 *
 * Select 1 from 16 (physical) channels to be the software trigger channel.
 *
 * Values:
 * - 0000 - Channel 0
 * - 0001 - Channel 1
 * - 0010 - Channel 2
 * - 0011 - Channel 3
 * - 0100 - Channel 4
 * - 0101 - Channel 5
 * - 0110 - Channel 6
 * - 0111 - Channel 7
 * - 1000 - Channel 8
 * - 1001 - Channel 9
 * - 1010 - Channel 10
 * - 1011 - Channel 11
 * - 1100 - Channel 12
 * - 1101 - Channel 13
 * - 1110 - Channel 14
 * - 1111 - Channel 15
 */
/*@{*/
#define BP_ADC_CH_SW_CFG_CH_SW_SEL (24U)   /*!< Bit position for ADC_CH_SW_CFG_CH_SW_SEL. */
#define BM_ADC_CH_SW_CFG_CH_SW_SEL (0x0F000000U) /*!< Bit mask for ADC_CH_SW_CFG_CH_SW_SEL. */
#define BS_ADC_CH_SW_CFG_CH_SW_SEL (4U)    /*!< Bit field size in bits for ADC_CH_SW_CFG_CH_SW_SEL. */

/*! @brief Read current value of the ADC_CH_SW_CFG_CH_SW_SEL field. */
#define BR_ADC_CH_SW_CFG_CH_SW_SEL(x) (HW_ADC_CH_SW_CFG(x).B.CH_SW_SEL)

/*! @brief Format value for bitfield ADC_CH_SW_CFG_CH_SW_SEL. */
#define BF_ADC_CH_SW_CFG_CH_SW_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_SW_CFG_CH_SW_SEL) & BM_ADC_CH_SW_CFG_CH_SW_SEL)

/*! @brief Set the CH_SW_SEL field to a new value. */
#define BW_ADC_CH_SW_CFG_CH_SW_SEL(x, v) (HW_ADC_CH_SW_CFG_WR(x, (HW_ADC_CH_SW_CFG_RD(x) & ~BM_ADC_CH_SW_CFG_CH_SW_SEL) | BF_ADC_CH_SW_CFG_CH_SW_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_CH_SW_CFG, field START_CONV[31] (RW)
 *
 * To start a software trigger, it must wait until the last software trigger
 * finish.
 *
 * Values:
 * - 0 - Not start a new software trigger conversion.
 * - 1 - Start a new software trigger conversion.
 */
/*@{*/
#define BP_ADC_CH_SW_CFG_START_CONV (31U)  /*!< Bit position for ADC_CH_SW_CFG_START_CONV. */
#define BM_ADC_CH_SW_CFG_START_CONV (0x80000000U) /*!< Bit mask for ADC_CH_SW_CFG_START_CONV. */
#define BS_ADC_CH_SW_CFG_START_CONV (1U)   /*!< Bit field size in bits for ADC_CH_SW_CFG_START_CONV. */

/*! @brief Read current value of the ADC_CH_SW_CFG_START_CONV field. */
#define BR_ADC_CH_SW_CFG_START_CONV(x) (HW_ADC_CH_SW_CFG(x).B.START_CONV)

/*! @brief Format value for bitfield ADC_CH_SW_CFG_START_CONV. */
#define BF_ADC_CH_SW_CFG_START_CONV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_SW_CFG_START_CONV) & BM_ADC_CH_SW_CFG_START_CONV)

/*! @brief Set the START_CONV field to a new value. */
#define BW_ADC_CH_SW_CFG_START_CONV(x, v) (HW_ADC_CH_SW_CFG_WR(x, (HW_ADC_CH_SW_CFG_RD(x) & ~BM_ADC_CH_SW_CFG_START_CONV) | BF_ADC_CH_SW_CFG_START_CONV(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_TIMER_UNIT - Timer Unit
 ******************************************************************************/

/*!
 * @brief HW_ADC_TIMER_UNIT - Timer Unit (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_timer_unit
{
    uint32_t U;
    struct _hw_adc_timer_unit_bitfields
    {
        uint32_t CORE_TIMER_UNIT : 5;  /*!< [4:0] Core_Timer_Unit */
        uint32_t RESERVED0 : 24;       /*!< [28:5] This field is reserved. */
        uint32_t PRE_DIV : 3;          /*!< [31:29] Pre-divide */
    } B;
} hw_adc_timer_unit_t;

/*!
 * @name Constants and macros for entire ADC_TIMER_UNIT register
 */
/*@{*/
#define HW_ADC_TIMER_UNIT_ADDR(x) ((uintptr_t)(x) + 0x90U)

#define HW_ADC_TIMER_UNIT(x)     (*(__IO hw_adc_timer_unit_t *) HW_ADC_TIMER_UNIT_ADDR(x))
#define HW_ADC_TIMER_UNIT_RD(x)  (HW_ADC_TIMER_UNIT(x).U)
#define HW_ADC_TIMER_UNIT_WR(x, v) (HW_ADC_TIMER_UNIT(x).U = (v))
#define HW_ADC_TIMER_UNIT_SET(x, v) (HW_ADC_TIMER_UNIT_WR(x, HW_ADC_TIMER_UNIT_RD(x) |  (v)))
#define HW_ADC_TIMER_UNIT_CLR(x, v) (HW_ADC_TIMER_UNIT_WR(x, HW_ADC_TIMER_UNIT_RD(x) & ~(v)))
#define HW_ADC_TIMER_UNIT_TOG(x, v) (HW_ADC_TIMER_UNIT_WR(x, HW_ADC_TIMER_UNIT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_TIMER_UNIT bitfields
 */

/*!
 * @name Register ADC_TIMER_UNIT, field CORE_TIMER_UNIT[4:0] (RW)
 *
 * This parameter defines sample rate. The maximum sample rate is 1/6 ADC
 * analogue core clock. Sample rate = analogue core clock frequency (MHz) * 1 /(
 * (CORE_TIMER_UNIT + 1) * 6). If changing SAMPLE_RATE, please disable logical channel
 * A, B, C, and D. Otherwise, the first A, B, C, and D conversion after change
 * the sample rate may not follow exact sample rate interval.
 */
/*@{*/
#define BP_ADC_TIMER_UNIT_CORE_TIMER_UNIT (0U) /*!< Bit position for ADC_TIMER_UNIT_CORE_TIMER_UNIT. */
#define BM_ADC_TIMER_UNIT_CORE_TIMER_UNIT (0x0000001FU) /*!< Bit mask for ADC_TIMER_UNIT_CORE_TIMER_UNIT. */
#define BS_ADC_TIMER_UNIT_CORE_TIMER_UNIT (5U) /*!< Bit field size in bits for ADC_TIMER_UNIT_CORE_TIMER_UNIT. */

/*! @brief Read current value of the ADC_TIMER_UNIT_CORE_TIMER_UNIT field. */
#define BR_ADC_TIMER_UNIT_CORE_TIMER_UNIT(x) (HW_ADC_TIMER_UNIT(x).B.CORE_TIMER_UNIT)

/*! @brief Format value for bitfield ADC_TIMER_UNIT_CORE_TIMER_UNIT. */
#define BF_ADC_TIMER_UNIT_CORE_TIMER_UNIT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_TIMER_UNIT_CORE_TIMER_UNIT) & BM_ADC_TIMER_UNIT_CORE_TIMER_UNIT)

/*! @brief Set the CORE_TIMER_UNIT field to a new value. */
#define BW_ADC_TIMER_UNIT_CORE_TIMER_UNIT(x, v) (HW_ADC_TIMER_UNIT_WR(x, (HW_ADC_TIMER_UNIT_RD(x) & ~BM_ADC_TIMER_UNIT_CORE_TIMER_UNIT) | BF_ADC_TIMER_UNIT_CORE_TIMER_UNIT(v)))
/*@}*/

/*!
 * @name Register ADC_TIMER_UNIT, field PRE_DIV[31:29] (RW)
 *
 * The ADC analogue core clock can vary from 300 kHz to 6 MHz. This parameter
 * defines ADC core clock (and sample rate). The ADC analogue clock is default 1/4
 * of ADC digital input clock. All pre-divide is 1/4 ADC digital input clock.
 * Warning: Before set this parameter, make sure analogue clock is from 300 kHz to 6
 * MHz.
 *
 * Values:
 * - 000 - No divide, analogue clock = 1/4 ADC digital input clock
 * - 001 - Divide 2, analogue clock = 1/8 ADC digital input clock
 * - 010 - Divide 4, analogue clock = 1/16 ADC digital input clock
 * - 011 - Divide 8, analogue clock = 1/32 ADC digital input clock
 * - 100 - Divide 16, analogue clock = 1/64 ADC digital input clock
 * - 101 - Divide 32, analogue clock = 1/128 ADC digital input clock
 */
/*@{*/
#define BP_ADC_TIMER_UNIT_PRE_DIV (29U)    /*!< Bit position for ADC_TIMER_UNIT_PRE_DIV. */
#define BM_ADC_TIMER_UNIT_PRE_DIV (0xE0000000U) /*!< Bit mask for ADC_TIMER_UNIT_PRE_DIV. */
#define BS_ADC_TIMER_UNIT_PRE_DIV (3U)     /*!< Bit field size in bits for ADC_TIMER_UNIT_PRE_DIV. */

/*! @brief Read current value of the ADC_TIMER_UNIT_PRE_DIV field. */
#define BR_ADC_TIMER_UNIT_PRE_DIV(x) (HW_ADC_TIMER_UNIT(x).B.PRE_DIV)

/*! @brief Format value for bitfield ADC_TIMER_UNIT_PRE_DIV. */
#define BF_ADC_TIMER_UNIT_PRE_DIV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_TIMER_UNIT_PRE_DIV) & BM_ADC_TIMER_UNIT_PRE_DIV)

/*! @brief Set the PRE_DIV field to a new value. */
#define BW_ADC_TIMER_UNIT_PRE_DIV(x, v) (HW_ADC_TIMER_UNIT_WR(x, (HW_ADC_TIMER_UNIT_RD(x) & ~BM_ADC_TIMER_UNIT_PRE_DIV) | BF_ADC_TIMER_UNIT_PRE_DIV(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_DMA_FIFO - DMA FIFO
 ******************************************************************************/

/*!
 * @brief HW_ADC_DMA_FIFO - DMA FIFO (RW)
 *
 * Reset value: 0x0000010FU
 */
typedef union _hw_adc_dma_fifo
{
    uint32_t U;
    struct _hw_adc_dma_fifo_bitfields
    {
        uint32_t DMA_WM_LVL : 5;       /*!< [4:0] DMA Water Mark Level */
        uint32_t DMA_CH_SEL : 2;       /*!< [6:5] DMA Channel Select */
        uint32_t DMA_EN : 1;           /*!< [7] DMA Enable */
        uint32_t DMA_FIFO_EN : 1;      /*!< [8] DMA FIFO Enable */
        uint32_t DMA_RST : 1;          /*!< [9] DMA Reset */
        uint32_t RESERVED0 : 22;       /*!< [31:10] This field is reserved. */
    } B;
} hw_adc_dma_fifo_t;

/*!
 * @name Constants and macros for entire ADC_DMA_FIFO register
 */
/*@{*/
#define HW_ADC_DMA_FIFO_ADDR(x)  ((uintptr_t)(x) + 0xA0U)

#define HW_ADC_DMA_FIFO(x)       (*(__IO hw_adc_dma_fifo_t *) HW_ADC_DMA_FIFO_ADDR(x))
#define HW_ADC_DMA_FIFO_RD(x)    (HW_ADC_DMA_FIFO(x).U)
#define HW_ADC_DMA_FIFO_WR(x, v) (HW_ADC_DMA_FIFO(x).U = (v))
#define HW_ADC_DMA_FIFO_SET(x, v) (HW_ADC_DMA_FIFO_WR(x, HW_ADC_DMA_FIFO_RD(x) |  (v)))
#define HW_ADC_DMA_FIFO_CLR(x, v) (HW_ADC_DMA_FIFO_WR(x, HW_ADC_DMA_FIFO_RD(x) & ~(v)))
#define HW_ADC_DMA_FIFO_TOG(x, v) (HW_ADC_DMA_FIFO_WR(x, HW_ADC_DMA_FIFO_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_DMA_FIFO bitfields
 */

/*!
 * @name Register ADC_DMA_FIFO, field DMA_WM_LVL[4:0] (RW)
 *
 * Once the DMA FIFO data reach water mark level, a DMA request or interrupt is
 * generated (if enabled), and transfer data through DMA or CPU. 00000-11111
 * represents DMA water mark level value
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DMA_WM_LVL (0U)    /*!< Bit position for ADC_DMA_FIFO_DMA_WM_LVL. */
#define BM_ADC_DMA_FIFO_DMA_WM_LVL (0x0000001FU) /*!< Bit mask for ADC_DMA_FIFO_DMA_WM_LVL. */
#define BS_ADC_DMA_FIFO_DMA_WM_LVL (5U)    /*!< Bit field size in bits for ADC_DMA_FIFO_DMA_WM_LVL. */

/*! @brief Read current value of the ADC_DMA_FIFO_DMA_WM_LVL field. */
#define BR_ADC_DMA_FIFO_DMA_WM_LVL(x) (HW_ADC_DMA_FIFO(x).B.DMA_WM_LVL)

/*! @brief Format value for bitfield ADC_DMA_FIFO_DMA_WM_LVL. */
#define BF_ADC_DMA_FIFO_DMA_WM_LVL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_DMA_FIFO_DMA_WM_LVL) & BM_ADC_DMA_FIFO_DMA_WM_LVL)

/*! @brief Set the DMA_WM_LVL field to a new value. */
#define BW_ADC_DMA_FIFO_DMA_WM_LVL(x, v) (HW_ADC_DMA_FIFO_WR(x, (HW_ADC_DMA_FIFO_RD(x) & ~BM_ADC_DMA_FIFO_DMA_WM_LVL) | BF_ADC_DMA_FIFO_DMA_WM_LVL(v)))
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO, field DMA_CH_SEL[6:5] (RW)
 *
 * Select DMA FIFO source from Channel A, Channel B, Channel C, and Channel D.
 *
 * Values:
 * - 00 - Channel A
 * - 01 - Channel B
 * - 10 - Channel C
 * - 11 - Channel D
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DMA_CH_SEL (5U)    /*!< Bit position for ADC_DMA_FIFO_DMA_CH_SEL. */
#define BM_ADC_DMA_FIFO_DMA_CH_SEL (0x00000060U) /*!< Bit mask for ADC_DMA_FIFO_DMA_CH_SEL. */
#define BS_ADC_DMA_FIFO_DMA_CH_SEL (2U)    /*!< Bit field size in bits for ADC_DMA_FIFO_DMA_CH_SEL. */

/*! @brief Read current value of the ADC_DMA_FIFO_DMA_CH_SEL field. */
#define BR_ADC_DMA_FIFO_DMA_CH_SEL(x) (HW_ADC_DMA_FIFO(x).B.DMA_CH_SEL)

/*! @brief Format value for bitfield ADC_DMA_FIFO_DMA_CH_SEL. */
#define BF_ADC_DMA_FIFO_DMA_CH_SEL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_DMA_FIFO_DMA_CH_SEL) & BM_ADC_DMA_FIFO_DMA_CH_SEL)

/*! @brief Set the DMA_CH_SEL field to a new value. */
#define BW_ADC_DMA_FIFO_DMA_CH_SEL(x, v) (HW_ADC_DMA_FIFO_WR(x, (HW_ADC_DMA_FIFO_RD(x) & ~BM_ADC_DMA_FIFO_DMA_CH_SEL) | BF_ADC_DMA_FIFO_DMA_CH_SEL(v)))
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO, field DMA_EN[7] (RW)
 *
 * This bit defines data in DMA FIFO is moved by SDMA or moved by CPU.
 *
 * Values:
 * - 0 - Disable DMA, the data in DMA FIFO can only move by CPU.
 * - 1 - Enable DMA, the data in DMA FIFO should move by SDMA.
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DMA_EN (7U)        /*!< Bit position for ADC_DMA_FIFO_DMA_EN. */
#define BM_ADC_DMA_FIFO_DMA_EN (0x00000080U) /*!< Bit mask for ADC_DMA_FIFO_DMA_EN. */
#define BS_ADC_DMA_FIFO_DMA_EN (1U)        /*!< Bit field size in bits for ADC_DMA_FIFO_DMA_EN. */

/*! @brief Read current value of the ADC_DMA_FIFO_DMA_EN field. */
#define BR_ADC_DMA_FIFO_DMA_EN(x) (HW_ADC_DMA_FIFO(x).B.DMA_EN)

/*! @brief Format value for bitfield ADC_DMA_FIFO_DMA_EN. */
#define BF_ADC_DMA_FIFO_DMA_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_DMA_FIFO_DMA_EN) & BM_ADC_DMA_FIFO_DMA_EN)

/*! @brief Set the DMA_EN field to a new value. */
#define BW_ADC_DMA_FIFO_DMA_EN(x, v) (HW_ADC_DMA_FIFO_WR(x, (HW_ADC_DMA_FIFO_RD(x) & ~BM_ADC_DMA_FIFO_DMA_EN) | BF_ADC_DMA_FIFO_DMA_EN(v)))
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO, field DMA_FIFO_EN[8] (RW)
 *
 * If enable DMA_FIFO_EN, ADC conversion result can store into DMA FIFO. If
 * disable, no ADC conversion result will store in DMA FIFO.
 *
 * Values:
 * - 0 - Disable DMA FIFO.
 * - 1 - Enable DMA FIFO.
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DMA_FIFO_EN (8U)   /*!< Bit position for ADC_DMA_FIFO_DMA_FIFO_EN. */
#define BM_ADC_DMA_FIFO_DMA_FIFO_EN (0x00000100U) /*!< Bit mask for ADC_DMA_FIFO_DMA_FIFO_EN. */
#define BS_ADC_DMA_FIFO_DMA_FIFO_EN (1U)   /*!< Bit field size in bits for ADC_DMA_FIFO_DMA_FIFO_EN. */

/*! @brief Read current value of the ADC_DMA_FIFO_DMA_FIFO_EN field. */
#define BR_ADC_DMA_FIFO_DMA_FIFO_EN(x) (HW_ADC_DMA_FIFO(x).B.DMA_FIFO_EN)

/*! @brief Format value for bitfield ADC_DMA_FIFO_DMA_FIFO_EN. */
#define BF_ADC_DMA_FIFO_DMA_FIFO_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_DMA_FIFO_DMA_FIFO_EN) & BM_ADC_DMA_FIFO_DMA_FIFO_EN)

/*! @brief Set the DMA_FIFO_EN field to a new value. */
#define BW_ADC_DMA_FIFO_DMA_FIFO_EN(x, v) (HW_ADC_DMA_FIFO_WR(x, (HW_ADC_DMA_FIFO_RD(x) & ~BM_ADC_DMA_FIFO_DMA_FIFO_EN) | BF_ADC_DMA_FIFO_DMA_FIFO_EN(v)))
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO, field DMA_RST[9] (RW)
 *
 * This bit contains reset information. If reset, the DMA and DMA FIFO return to
 * its reset value. The DMA FIFO data is lost.
 *
 * Values:
 * - 0 - Not reset
 * - 1 - Reset
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DMA_RST (9U)       /*!< Bit position for ADC_DMA_FIFO_DMA_RST. */
#define BM_ADC_DMA_FIFO_DMA_RST (0x00000200U) /*!< Bit mask for ADC_DMA_FIFO_DMA_RST. */
#define BS_ADC_DMA_FIFO_DMA_RST (1U)       /*!< Bit field size in bits for ADC_DMA_FIFO_DMA_RST. */

/*! @brief Read current value of the ADC_DMA_FIFO_DMA_RST field. */
#define BR_ADC_DMA_FIFO_DMA_RST(x) (HW_ADC_DMA_FIFO(x).B.DMA_RST)

/*! @brief Format value for bitfield ADC_DMA_FIFO_DMA_RST. */
#define BF_ADC_DMA_FIFO_DMA_RST(v) ((uint32_t)((uint32_t)(v) << BP_ADC_DMA_FIFO_DMA_RST) & BM_ADC_DMA_FIFO_DMA_RST)

/*! @brief Set the DMA_RST field to a new value. */
#define BW_ADC_DMA_FIFO_DMA_RST(x, v) (HW_ADC_DMA_FIFO_WR(x, (HW_ADC_DMA_FIFO_RD(x) & ~BM_ADC_DMA_FIFO_DMA_RST) | BF_ADC_DMA_FIFO_DMA_RST(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_FIFO_STATUS - FIFO Status
 ******************************************************************************/

/*!
 * @brief HW_ADC_FIFO_STATUS - FIFO Status (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_fifo_status
{
    uint32_t U;
    struct _hw_adc_fifo_status_bitfields
    {
        uint32_t FIFO_ENTRIES : 6;     /*!< [5:0] FIFO Entries */
        uint32_t RESERVED0 : 2;        /*!< [7:6] This field is reserved. */
        uint32_t FIFO_EMPTY : 1;       /*!< [8] FIFO Empty */
        uint32_t FIFO_FULL : 1;        /*!< [9]  */
        uint32_t RESERVED1 : 22;       /*!< [31:10] This field is reserved. */
    } B;
} hw_adc_fifo_status_t;

/*!
 * @name Constants and macros for entire ADC_FIFO_STATUS register
 */
/*@{*/
#define HW_ADC_FIFO_STATUS_ADDR(x) ((uintptr_t)(x) + 0xB0U)

#define HW_ADC_FIFO_STATUS(x)    (*(__IO hw_adc_fifo_status_t *) HW_ADC_FIFO_STATUS_ADDR(x))
#define HW_ADC_FIFO_STATUS_RD(x) (HW_ADC_FIFO_STATUS(x).U)
#define HW_ADC_FIFO_STATUS_WR(x, v) (HW_ADC_FIFO_STATUS(x).U = (v))
#define HW_ADC_FIFO_STATUS_SET(x, v) (HW_ADC_FIFO_STATUS_WR(x, HW_ADC_FIFO_STATUS_RD(x) |  (v)))
#define HW_ADC_FIFO_STATUS_CLR(x, v) (HW_ADC_FIFO_STATUS_WR(x, HW_ADC_FIFO_STATUS_RD(x) & ~(v)))
#define HW_ADC_FIFO_STATUS_TOG(x, v) (HW_ADC_FIFO_STATUS_WR(x, HW_ADC_FIFO_STATUS_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_FIFO_STATUS bitfields
 */

/*!
 * @name Register ADC_FIFO_STATUS, field FIFO_ENTRIES[5:0] (RW)
 *
 * This read-only bit represents the numbers of data in DMA FIFO. 00000 to 11111
 * The numbers of data stored in DMA FIFO.
 */
/*@{*/
#define BP_ADC_FIFO_STATUS_FIFO_ENTRIES (0U) /*!< Bit position for ADC_FIFO_STATUS_FIFO_ENTRIES. */
#define BM_ADC_FIFO_STATUS_FIFO_ENTRIES (0x0000003FU) /*!< Bit mask for ADC_FIFO_STATUS_FIFO_ENTRIES. */
#define BS_ADC_FIFO_STATUS_FIFO_ENTRIES (6U) /*!< Bit field size in bits for ADC_FIFO_STATUS_FIFO_ENTRIES. */

/*! @brief Read current value of the ADC_FIFO_STATUS_FIFO_ENTRIES field. */
#define BR_ADC_FIFO_STATUS_FIFO_ENTRIES(x) (HW_ADC_FIFO_STATUS(x).B.FIFO_ENTRIES)

/*! @brief Format value for bitfield ADC_FIFO_STATUS_FIFO_ENTRIES. */
#define BF_ADC_FIFO_STATUS_FIFO_ENTRIES(v) ((uint32_t)((uint32_t)(v) << BP_ADC_FIFO_STATUS_FIFO_ENTRIES) & BM_ADC_FIFO_STATUS_FIFO_ENTRIES)

/*! @brief Set the FIFO_ENTRIES field to a new value. */
#define BW_ADC_FIFO_STATUS_FIFO_ENTRIES(x, v) (HW_ADC_FIFO_STATUS_WR(x, (HW_ADC_FIFO_STATUS_RD(x) & ~BM_ADC_FIFO_STATUS_FIFO_ENTRIES) | BF_ADC_FIFO_STATUS_FIFO_ENTRIES(v)))
/*@}*/

/*!
 * @name Register ADC_FIFO_STATUS, field FIFO_EMPTY[8] (RW)
 *
 * This read-only bit represents the status of DMA FIFO. If FIFO is empty, the
 * DMA stops pop data, set this bit, and generates an interrupt.
 *
 * Values:
 * - 0 - FIFO is not empty.
 * - 1 - FIFO is empty.
 */
/*@{*/
#define BP_ADC_FIFO_STATUS_FIFO_EMPTY (8U) /*!< Bit position for ADC_FIFO_STATUS_FIFO_EMPTY. */
#define BM_ADC_FIFO_STATUS_FIFO_EMPTY (0x00000100U) /*!< Bit mask for ADC_FIFO_STATUS_FIFO_EMPTY. */
#define BS_ADC_FIFO_STATUS_FIFO_EMPTY (1U) /*!< Bit field size in bits for ADC_FIFO_STATUS_FIFO_EMPTY. */

/*! @brief Read current value of the ADC_FIFO_STATUS_FIFO_EMPTY field. */
#define BR_ADC_FIFO_STATUS_FIFO_EMPTY(x) (HW_ADC_FIFO_STATUS(x).B.FIFO_EMPTY)

/*! @brief Format value for bitfield ADC_FIFO_STATUS_FIFO_EMPTY. */
#define BF_ADC_FIFO_STATUS_FIFO_EMPTY(v) ((uint32_t)((uint32_t)(v) << BP_ADC_FIFO_STATUS_FIFO_EMPTY) & BM_ADC_FIFO_STATUS_FIFO_EMPTY)

/*! @brief Set the FIFO_EMPTY field to a new value. */
#define BW_ADC_FIFO_STATUS_FIFO_EMPTY(x, v) (HW_ADC_FIFO_STATUS_WR(x, (HW_ADC_FIFO_STATUS_RD(x) & ~BM_ADC_FIFO_STATUS_FIFO_EMPTY) | BF_ADC_FIFO_STATUS_FIFO_EMPTY(v)))
/*@}*/

/*!
 * @name Register ADC_FIFO_STATUS, field FIFO_FULL[9] (RW)
 *
 * This read-only bit represents the status of DMA FIFO. If FIFO is full, the
 * DMA stop pushing data, set this bit, and generates an interrupt.
 *
 * Values:
 * - 0 - FIFO is not full.
 * - 1 - FIFIO is full.
 */
/*@{*/
#define BP_ADC_FIFO_STATUS_FIFO_FULL (9U)  /*!< Bit position for ADC_FIFO_STATUS_FIFO_FULL. */
#define BM_ADC_FIFO_STATUS_FIFO_FULL (0x00000200U) /*!< Bit mask for ADC_FIFO_STATUS_FIFO_FULL. */
#define BS_ADC_FIFO_STATUS_FIFO_FULL (1U)  /*!< Bit field size in bits for ADC_FIFO_STATUS_FIFO_FULL. */

/*! @brief Read current value of the ADC_FIFO_STATUS_FIFO_FULL field. */
#define BR_ADC_FIFO_STATUS_FIFO_FULL(x) (HW_ADC_FIFO_STATUS(x).B.FIFO_FULL)

/*! @brief Format value for bitfield ADC_FIFO_STATUS_FIFO_FULL. */
#define BF_ADC_FIFO_STATUS_FIFO_FULL(v) ((uint32_t)((uint32_t)(v) << BP_ADC_FIFO_STATUS_FIFO_FULL) & BM_ADC_FIFO_STATUS_FIFO_FULL)

/*! @brief Set the FIFO_FULL field to a new value. */
#define BW_ADC_FIFO_STATUS_FIFO_FULL(x, v) (HW_ADC_FIFO_STATUS_WR(x, (HW_ADC_FIFO_STATUS_RD(x) & ~BM_ADC_FIFO_STATUS_FIFO_FULL) | BF_ADC_FIFO_STATUS_FIFO_FULL(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_INT_SIG_EN -
 ******************************************************************************/

/*!
 * @brief HW_ADC_INT_SIG_EN -  (RW)
 *
 * Reset value: 0x001F1FCFU
 */
typedef union _hw_adc_int_sig_en
{
    uint32_t U;
    struct _hw_adc_int_sig_en_bitfields
    {
        uint32_t CHA_CMP_INT_SIG_EN : 1; /*!< [0] Channel A Compare Interrupt
                                        * Signal Enable */
        uint32_t CHB_CMP_INT_SIG_EN : 1; /*!< [1] Channel B Compare Interrupt
                                        * Signal Enable */
        uint32_t CHC_CMP_INT_SIG_EN : 1; /*!< [2] Channel C Compare Interrupt
                                        * Signal Enable */
        uint32_t CHD_CMP_INT_SIG_EN : 1; /*!< [3] Channel D Compare Interrupt
                                        * Signal Enable */
        uint32_t RESERVED0 : 1;        /*!< [4] This field is reserved. */
        uint32_t DMA_REACH_WM_INT_SIG_EN : 1; /*!< [5] DMA Reach Watermark
                                        * Level Interrupt Signal (Flag) Enable */
        uint32_t FIFO_UNDERRUN_INT_SIG_EN : 1; /*!< [6] FIFO Underrrun
                                        * Interrupt Signal Enable */
        uint32_t FIFO_OVRRUN_INT_SIG_EN : 1; /*!< [7] FIFO overrun Interrupt
                                        * Signal Enable */
        uint32_t CHA_COV_INT_SIG_EN : 1; /*!< [8] Channel A Conversion
                                        * Interrupt Signal Enable */
        uint32_t CHB_COV_INT_SIG_EN : 1; /*!< [9] Channel B Conversion
                                        * Interrupt Signal Enable */
        uint32_t CHC_COV_INT_SIG_EN : 1; /*!< [10] Channel C Conversion
                                        * Interrupt Signal Enable */
        uint32_t CHD_COV_INT_SIG_EN : 1; /*!< [11] Channel D Conversion
                                        * Interrupt Signal Enable */
        uint32_t SW_CH_COV_INT_SIG_EN : 1; /*!< [12] Software Channel
                                        * Conversion Interrupt Signal Enable */
        uint32_t RESERVED1 : 3;        /*!< [15:13] This field is reserved. */
        uint32_t CHA_COV_TO_INT_SIG_EN : 1; /*!< [16] Channel A Conversion
                                        * Time Out Interrupt Signal Enable */
        uint32_t CHB_COV_TO_INT_SIG_EN : 1; /*!< [17] Channel B Conversion
                                        * Time Out Interrupt Signal Enable */
        uint32_t CHC_COV_TO_INT_SIG_EN : 1; /*!< [18] Channel C Conversion
                                        * Time Out Interrupt Signal Enable */
        uint32_t CHD_COV_TO_INT_SIG_EN : 1; /*!< [19] Channel D Conversion
                                        * Time Out Interrupt Signal Enable */
        uint32_t SW_CH_COV_TO_INT_SIG_EN : 1; /*!< [20] Software Channel
                                        * Conversion Time Out Interrupt Signal Enable */
        uint32_t LAST_FIFO_DATA_READ_SIG_EN : 1; /*!< [21] Last FIFO Data
                                        * Read Signal Enable */
        uint32_t RESERVED2 : 10;       /*!< [31:22] This field is reserved. */
    } B;
} hw_adc_int_sig_en_t;

/*!
 * @name Constants and macros for entire ADC_INT_SIG_EN register
 */
/*@{*/
#define HW_ADC_INT_SIG_EN_ADDR(x) ((uintptr_t)(x) + 0xC0U)

#define HW_ADC_INT_SIG_EN(x)     (*(__IO hw_adc_int_sig_en_t *) HW_ADC_INT_SIG_EN_ADDR(x))
#define HW_ADC_INT_SIG_EN_RD(x)  (HW_ADC_INT_SIG_EN(x).U)
#define HW_ADC_INT_SIG_EN_WR(x, v) (HW_ADC_INT_SIG_EN(x).U = (v))
#define HW_ADC_INT_SIG_EN_SET(x, v) (HW_ADC_INT_SIG_EN_WR(x, HW_ADC_INT_SIG_EN_RD(x) |  (v)))
#define HW_ADC_INT_SIG_EN_CLR(x, v) (HW_ADC_INT_SIG_EN_WR(x, HW_ADC_INT_SIG_EN_RD(x) & ~(v)))
#define HW_ADC_INT_SIG_EN_TOG(x, v) (HW_ADC_INT_SIG_EN_WR(x, HW_ADC_INT_SIG_EN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_INT_SIG_EN bitfields
 */

/*!
 * @name Register ADC_INT_SIG_EN, field CHA_CMP_INT_SIG_EN[0] (RW)
 *
 * Define whether channel A compare interrupt flag is enabled. If enable the
 * interrupt flag, an interrupt is set once channel A conversion result matches the
 * compare region.
 *
 * Values:
 * - 0 - Disable Channel A Compare Interrupt flag.
 * - 1 - Enable Channel A Compare Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN (0U) /*!< Bit position for ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN (0x00000001U) /*!< Bit mask for ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHA_CMP_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN)

/*! @brief Set the CHA_CMP_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHA_CMP_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHB_CMP_INT_SIG_EN[1] (RW)
 *
 * Define whether channel B compare interrupt flag is enabled. If enable the
 * interrupt flag, an interrupt flag is set once channel B conversion result matches
 * the compare region.
 *
 * Values:
 * - 0 - Disable Channel B Compare Interrupt flag.
 * - 1 - Enable Channel B Compare Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN (1U) /*!< Bit position for ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN (0x00000002U) /*!< Bit mask for ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHB_CMP_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN)

/*! @brief Set the CHB_CMP_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHB_CMP_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHC_CMP_INT_SIG_EN[2] (RW)
 *
 * Define whether channel C compare interrupt flag is enabled. If enable the
 * interrupt flag, an interrupt flag is set once channel C conversion result matches
 * the compare region.
 *
 * Values:
 * - 0 - Disable Channel C Compare Interrupt flag.
 * - 1 - Enable Channel C Compare Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN (2U) /*!< Bit position for ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN (0x00000004U) /*!< Bit mask for ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHC_CMP_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN)

/*! @brief Set the CHC_CMP_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHC_CMP_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHD_CMP_INT_SIG_EN[3] (RW)
 *
 * Define whether channel D compare interrupt flag is enabled. If enable the
 * interrupt flag, an interrupt flag is set once channel D conversion result matches
 * the compare region.
 *
 * Values:
 * - 0 - Disable Channel D Compare Interrupt flag
 * - 1 - Enable Channel D Compare Interrupt flag
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN (3U) /*!< Bit position for ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN (0x00000008U) /*!< Bit mask for ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHD_CMP_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN)

/*! @brief Set the CHD_CMP_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHD_CMP_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field DMA_REACH_WM_INT_SIG_EN[5] (RW)
 *
 * Define whether the number of data in DMA FIFO is greater than DMA watermark
 * level. If it is greater, then a flag is set.
 *
 * Values:
 * - 0 - Enable DMA watermark level interrupt signal (flag).
 * - 1 - Disable DMA watermark level interrupt signal (flag).
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN (5U) /*!< Bit position for ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN (0x00000020U) /*!< Bit mask for ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.DMA_REACH_WM_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN) & BM_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN)

/*! @brief Set the DMA_REACH_WM_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN) | BF_ADC_INT_SIG_EN_DMA_REACH_WM_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field FIFO_UNDERRUN_INT_SIG_EN[6] (RW)
 *
 * Define whether DMA FIFO underrun interrupt flag is enabled. If DMA FIFO
 * underrun interrupt flag is enabled and DMA FIFO has underrun condition, then an
 * interrupt flag is generated.
 *
 * Values:
 * - 0 - Enable FIFO underrun Interrupt flag
 * - 1 - Disable FIFO underrun Interrupt flag
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN (6U) /*!< Bit position for ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN (0x00000040U) /*!< Bit mask for ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.FIFO_UNDERRUN_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN) & BM_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN)

/*! @brief Set the FIFO_UNDERRUN_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN) | BF_ADC_INT_SIG_EN_FIFO_UNDERRUN_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field FIFO_OVRRUN_INT_SIG_EN[7] (RW)
 *
 * Define whether DMA FIFO overrun interrupt flag is enabled. If DMA FIFO
 * overrun interrupt flag enabled and DMA FIFO has overrun condition, then an interrupt
 * flag is generated.
 *
 * Values:
 * - 0 - Enable FIFO Interrupt flag.
 * - 1 - Disable FIFO Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN (7U) /*!< Bit position for ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN (0x00000080U) /*!< Bit mask for ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.FIFO_OVRRUN_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN) & BM_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN)

/*! @brief Set the FIFO_OVRRUN_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN) | BF_ADC_INT_SIG_EN_FIFO_OVRRUN_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHA_COV_INT_SIG_EN[8] (RW)
 *
 * Define whether channel A round conversion interrupt flag enable. If enable
 * interrupt flag, an interrupt flag is generated once Channel A finish a new
 * conversion.
 *
 * Values:
 * - 0 - Disable channel A conversion Interrupt flag.
 * - 1 - Enable channel A conversion Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN (8U) /*!< Bit position for ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN (0x00000100U) /*!< Bit mask for ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHA_COV_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN)

/*! @brief Set the CHA_COV_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHA_COV_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHB_COV_INT_SIG_EN[9] (RW)
 *
 * Define whether channel B conversion interrupt flag is enabled. If enable
 * interrupt flag, an interrupt flag is generated once Channel B finish a new
 * conversion.
 *
 * Values:
 * - 0 - Disable channel B conversion Interrupt flag.
 * - 1 - Enable channel B conversion Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN (9U) /*!< Bit position for ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN (0x00000200U) /*!< Bit mask for ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHB_COV_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN)

/*! @brief Set the CHB_COV_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHB_COV_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHC_COV_INT_SIG_EN[10] (RW)
 *
 * Define whether channel C conversion interrupt flag is enabled. If enable
 * interrupt flag, an interrupt flag is set once Channel C finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel C conversion Interrupt flag.
 * - 1 - Enable channel C conversion Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN (10U) /*!< Bit position for ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN (0x00000400U) /*!< Bit mask for ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHC_COV_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN)

/*! @brief Set the CHC_COV_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHC_COV_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHD_COV_INT_SIG_EN[11] (RW)
 *
 * Define whether channel D conversion interrupt flag is enabled. If enable
 * interrupt flag, an interrupt flag is set once Channel D finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel D conversion Interrupt flag.
 * - 1 - Enable channel D conversion Interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN (11U) /*!< Bit position for ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN (0x00000800U) /*!< Bit mask for ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHD_COV_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN)

/*! @brief Set the CHD_COV_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHD_COV_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field SW_CH_COV_INT_SIG_EN[12] (RW)
 *
 * Define whether software trigger interrupt flag is enabled.
 *
 * Values:
 * - 0 - Disable software channel conversion signal interrupt flag.
 * - 1 - Enable software channel conversion signal interrupt flag.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN (12U) /*!< Bit position for ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN (0x00001000U) /*!< Bit mask for ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.SW_CH_COV_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN) & BM_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN)

/*! @brief Set the SW_CH_COV_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN) | BF_ADC_INT_SIG_EN_SW_CH_COV_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHA_COV_TO_INT_SIG_EN[16] (RW)
 *
 * Define whether logical channel A conversion time out interrupt signal is
 * enabled.
 *
 * Values:
 * - 0 - Disable logical channel A conversion time out interrupt signal.
 * - 1 - Enable logical channel A conversion time out interrupt signal.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN (16U) /*!< Bit position for ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN (0x00010000U) /*!< Bit mask for ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHA_COV_TO_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN)

/*! @brief Set the CHA_COV_TO_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHA_COV_TO_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHB_COV_TO_INT_SIG_EN[17] (RW)
 *
 * Define whether logical channel B conversion time out interrupt signal is
 * enabled.
 *
 * Values:
 * - 0 - Disable logical channel B conversion time out interrupt signal.
 * - 1 - Enable logical channel B conversion time out interrupt signal.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN (17U) /*!< Bit position for ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN (0x00020000U) /*!< Bit mask for ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHB_COV_TO_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN)

/*! @brief Set the CHB_COV_TO_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHB_COV_TO_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHC_COV_TO_INT_SIG_EN[18] (RW)
 *
 * Define whether logical channel C conversion time out interrupt signal is
 * enabled.
 *
 * Values:
 * - 0 - Disable logical channel C conversion time out interrupt signal.
 * - 1 - Enable logical channel C conversion time out interrupt signal.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN (18U) /*!< Bit position for ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN (0x00040000U) /*!< Bit mask for ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHC_COV_TO_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN)

/*! @brief Set the CHC_COV_TO_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHC_COV_TO_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field CHD_COV_TO_INT_SIG_EN[19] (RW)
 *
 * Define whether logical channel D conversion time out interrupt signal is
 * enabled.
 *
 * Values:
 * - 0 - Disable logical channel D conversion time out interrupt signal.
 * - 1 - Enable logical channel D conversion time out interrupt signal.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN (19U) /*!< Bit position for ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN (0x00080000U) /*!< Bit mask for ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.CHD_COV_TO_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN) & BM_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN)

/*! @brief Set the CHD_COV_TO_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN) | BF_ADC_INT_SIG_EN_CHD_COV_TO_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field SW_CH_COV_TO_INT_SIG_EN[20] (RW)
 *
 * Define whether software channel conversion time out interrupt signal is
 * enabled.
 *
 * Values:
 * - 0 - Disable software channel conversion time out interrupt signal.
 * - 1 - Enable software channel conversion time out interrupt signal.
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN (20U) /*!< Bit position for ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN. */
#define BM_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN (0x00100000U) /*!< Bit mask for ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN. */
#define BS_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.SW_CH_COV_TO_INT_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN. */
#define BF_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN) & BM_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN)

/*! @brief Set the SW_CH_COV_TO_INT_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN) | BF_ADC_INT_SIG_EN_SW_CH_COV_TO_INT_SIG_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_SIG_EN, field LAST_FIFO_DATA_READ_SIG_EN[21] (RW)
 *
 * Define whether enable flag when the last data read out of FIFO (the last of
 * whole continuous result)
 *
 * Values:
 * - 0 - Disable last FIFO read signal enable
 * - 1 - Enable last FIFO read signal enable
 */
/*@{*/
#define BP_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN (21U) /*!< Bit position for ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN. */
#define BM_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN (0x00200000U) /*!< Bit mask for ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN. */
#define BS_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN (1U) /*!< Bit field size in bits for ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN. */

/*! @brief Read current value of the ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN field. */
#define BR_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN(x) (HW_ADC_INT_SIG_EN(x).B.LAST_FIFO_DATA_READ_SIG_EN)

/*! @brief Format value for bitfield ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN. */
#define BF_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN) & BM_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN)

/*! @brief Set the LAST_FIFO_DATA_READ_SIG_EN field to a new value. */
#define BW_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN(x, v) (HW_ADC_INT_SIG_EN_WR(x, (HW_ADC_INT_SIG_EN_RD(x) & ~BM_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN) | BF_ADC_INT_SIG_EN_LAST_FIFO_DATA_READ_SIG_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_INT_EN - Interrupt Enable
 ******************************************************************************/

/*!
 * @brief HW_ADC_INT_EN - Interrupt Enable (RW)
 *
 * Reset value: 0x000000F0U
 */
typedef union _hw_adc_int_en
{
    uint32_t U;
    struct _hw_adc_int_en_bitfields
    {
        uint32_t CHA_CMP_INT_EN : 1;   /*!< [0] Channel A Compare Interrupt
                                        * Enable */
        uint32_t CHB_CMP_INT_EN : 1;   /*!< [1] Channel B Compare Interrupt
                                        * Enable */
        uint32_t CHC_CMP_INT_EN : 1;   /*!< [2] Channel C Compare Interrupt
                                        * Enable */
        uint32_t CHD_CMP_INT_EN : 1;   /*!< [3] Channel D Compare Interrupt
                                        * Enable */
        uint32_t RESERVED0 : 1;        /*!< [4] This field is reserved. */
        uint32_t DMA_REACH_WM_INT_EN : 1; /*!< [5] DMA Reach Watermark Level
                                        * Interrupt Enable */
        uint32_t FIFO_UNDERRUN_INT_EN : 1; /*!< [6] FIFO underrun Interrupt
                                        * Enable */
        uint32_t FIFO_OVERRUN_INT_EN : 1; /*!< [7] FIFO overrun Interrupt
                                        * Enable */
        uint32_t CHA_COV_INT_EN : 1;   /*!< [8] Channel A Conversion Interrupt
                                        * Enable */
        uint32_t CHB_COV_INT_EN : 1;   /*!< [9] Channel B Conversion Interrupt
                                        * Enable */
        uint32_t CHC_COV_INT_EN : 1;   /*!< [10] Channel C Conversion Interrupt
                                        * Enable */
        uint32_t CHD_COV_INT_EN : 1;   /*!< [11] Channel D Conversion Interrupt
                                        * Enable */
        uint32_t SW_CH_COV_INT_EN : 1; /*!< [12] Software Channel Conversion
                                        * Interrupt Enable */
        uint32_t RESERVED1 : 3;        /*!< [15:13] This field is reserved. */
        uint32_t CHA_COV_TO_INT_EN : 1; /*!< [16] Channel A Conversion Time
                                        * Out Interrupt Enable */
        uint32_t CHB_COV_TO_INT_EN : 1; /*!< [17] Channel B Conversion Time
                                        * Out Interrupt Enable */
        uint32_t CHC_COV_TO_INT_EN : 1; /*!< [18] Channel C Conversion Time
                                        * Out Interrupt Enable */
        uint32_t CHD_COV_TO_INT_EN : 1; /*!< [19] Channel D Conversion Time
                                        * Out Interrupt Enable */
        uint32_t SW_CH_COV_TO_INT_EN : 1; /*!< [20] Software Channel
                                        * Conversion Time Out Interrupt Enable */
        uint32_t LAST_FIFO_DATA_READ_EN : 1; /*!< [21] Last FIFO Data Read
                                        * Enable */
        uint32_t RESERVED2 : 10;       /*!< [31:22] This field is reserved. */
    } B;
} hw_adc_int_en_t;

/*!
 * @name Constants and macros for entire ADC_INT_EN register
 */
/*@{*/
#define HW_ADC_INT_EN_ADDR(x)    ((uintptr_t)(x) + 0xD0U)

#define HW_ADC_INT_EN(x)         (*(__IO hw_adc_int_en_t *) HW_ADC_INT_EN_ADDR(x))
#define HW_ADC_INT_EN_RD(x)      (HW_ADC_INT_EN(x).U)
#define HW_ADC_INT_EN_WR(x, v)   (HW_ADC_INT_EN(x).U = (v))
#define HW_ADC_INT_EN_SET(x, v)  (HW_ADC_INT_EN_WR(x, HW_ADC_INT_EN_RD(x) |  (v)))
#define HW_ADC_INT_EN_CLR(x, v)  (HW_ADC_INT_EN_WR(x, HW_ADC_INT_EN_RD(x) & ~(v)))
#define HW_ADC_INT_EN_TOG(x, v)  (HW_ADC_INT_EN_WR(x, HW_ADC_INT_EN_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_INT_EN bitfields
 */

/*!
 * @name Register ADC_INT_EN, field CHA_CMP_INT_EN[0] (RW)
 *
 * Define whether channel A compare interrupt is enabled. If enable the
 * interrupt, an interrupt is set once channel A conversion result matches the compare
 * region.
 *
 * Values:
 * - 0 - Disable Channel A Compare Interrupt.
 * - 1 - Enable Channel A Compare Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHA_CMP_INT_EN (0U)  /*!< Bit position for ADC_INT_EN_CHA_CMP_INT_EN. */
#define BM_ADC_INT_EN_CHA_CMP_INT_EN (0x00000001U) /*!< Bit mask for ADC_INT_EN_CHA_CMP_INT_EN. */
#define BS_ADC_INT_EN_CHA_CMP_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHA_CMP_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHA_CMP_INT_EN field. */
#define BR_ADC_INT_EN_CHA_CMP_INT_EN(x) (HW_ADC_INT_EN(x).B.CHA_CMP_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHA_CMP_INT_EN. */
#define BF_ADC_INT_EN_CHA_CMP_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHA_CMP_INT_EN) & BM_ADC_INT_EN_CHA_CMP_INT_EN)

/*! @brief Set the CHA_CMP_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHA_CMP_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHA_CMP_INT_EN) | BF_ADC_INT_EN_CHA_CMP_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHB_CMP_INT_EN[1] (RW)
 *
 * Define whether channel B compare interrupt is enabled. If enable the
 * interrupt, an interrupt is set once channel B conversion result matches the compare
 * region.
 *
 * Values:
 * - 0 - Disable Channel B Compare Interrupt.
 * - 1 - Enable Channel B Compare Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHB_CMP_INT_EN (1U)  /*!< Bit position for ADC_INT_EN_CHB_CMP_INT_EN. */
#define BM_ADC_INT_EN_CHB_CMP_INT_EN (0x00000002U) /*!< Bit mask for ADC_INT_EN_CHB_CMP_INT_EN. */
#define BS_ADC_INT_EN_CHB_CMP_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHB_CMP_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHB_CMP_INT_EN field. */
#define BR_ADC_INT_EN_CHB_CMP_INT_EN(x) (HW_ADC_INT_EN(x).B.CHB_CMP_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHB_CMP_INT_EN. */
#define BF_ADC_INT_EN_CHB_CMP_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHB_CMP_INT_EN) & BM_ADC_INT_EN_CHB_CMP_INT_EN)

/*! @brief Set the CHB_CMP_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHB_CMP_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHB_CMP_INT_EN) | BF_ADC_INT_EN_CHB_CMP_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHC_CMP_INT_EN[2] (RW)
 *
 * Define whether channel C compare interrupt is enabled. If enable the
 * interrupt, an interrupt is set once channel C conversion result matches the compare
 * region.
 *
 * Values:
 * - 0 - Disable Channel C Compare Interrupt.
 * - 1 - Enable Channel C Compare Interrupt .
 */
/*@{*/
#define BP_ADC_INT_EN_CHC_CMP_INT_EN (2U)  /*!< Bit position for ADC_INT_EN_CHC_CMP_INT_EN. */
#define BM_ADC_INT_EN_CHC_CMP_INT_EN (0x00000004U) /*!< Bit mask for ADC_INT_EN_CHC_CMP_INT_EN. */
#define BS_ADC_INT_EN_CHC_CMP_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHC_CMP_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHC_CMP_INT_EN field. */
#define BR_ADC_INT_EN_CHC_CMP_INT_EN(x) (HW_ADC_INT_EN(x).B.CHC_CMP_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHC_CMP_INT_EN. */
#define BF_ADC_INT_EN_CHC_CMP_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHC_CMP_INT_EN) & BM_ADC_INT_EN_CHC_CMP_INT_EN)

/*! @brief Set the CHC_CMP_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHC_CMP_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHC_CMP_INT_EN) | BF_ADC_INT_EN_CHC_CMP_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHD_CMP_INT_EN[3] (RW)
 *
 * Define whether channel D compare interrupt is enabled. If enable the
 * interrupt, an interrupt is set once channel D conversion result matches the compare
 * region.
 *
 * Values:
 * - 0 - Disable Channel D Compare Interrupt.
 * - 1 - Enable Channel D Compare Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHD_CMP_INT_EN (3U)  /*!< Bit position for ADC_INT_EN_CHD_CMP_INT_EN. */
#define BM_ADC_INT_EN_CHD_CMP_INT_EN (0x00000008U) /*!< Bit mask for ADC_INT_EN_CHD_CMP_INT_EN. */
#define BS_ADC_INT_EN_CHD_CMP_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHD_CMP_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHD_CMP_INT_EN field. */
#define BR_ADC_INT_EN_CHD_CMP_INT_EN(x) (HW_ADC_INT_EN(x).B.CHD_CMP_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHD_CMP_INT_EN. */
#define BF_ADC_INT_EN_CHD_CMP_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHD_CMP_INT_EN) & BM_ADC_INT_EN_CHD_CMP_INT_EN)

/*! @brief Set the CHD_CMP_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHD_CMP_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHD_CMP_INT_EN) | BF_ADC_INT_EN_CHD_CMP_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field DMA_REACH_WM_INT_EN[5] (RW)
 *
 * Define whether DMA watermark level interrupt is enabled. If enable the
 * interrupt, an interrupt is generated. This signal is for software read DMA FIFO. If
 * SDMA read data, turn off both interrupt enable and signal (flag) enable.
 *
 * Values:
 * - 0 - Enable DMA reach watermark level interrupt.
 * - 1 - Disable DMA reach watermark level interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_DMA_REACH_WM_INT_EN (5U) /*!< Bit position for ADC_INT_EN_DMA_REACH_WM_INT_EN. */
#define BM_ADC_INT_EN_DMA_REACH_WM_INT_EN (0x00000020U) /*!< Bit mask for ADC_INT_EN_DMA_REACH_WM_INT_EN. */
#define BS_ADC_INT_EN_DMA_REACH_WM_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_DMA_REACH_WM_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_DMA_REACH_WM_INT_EN field. */
#define BR_ADC_INT_EN_DMA_REACH_WM_INT_EN(x) (HW_ADC_INT_EN(x).B.DMA_REACH_WM_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_DMA_REACH_WM_INT_EN. */
#define BF_ADC_INT_EN_DMA_REACH_WM_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_DMA_REACH_WM_INT_EN) & BM_ADC_INT_EN_DMA_REACH_WM_INT_EN)

/*! @brief Set the DMA_REACH_WM_INT_EN field to a new value. */
#define BW_ADC_INT_EN_DMA_REACH_WM_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_DMA_REACH_WM_INT_EN) | BF_ADC_INT_EN_DMA_REACH_WM_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field FIFO_UNDERRUN_INT_EN[6] (RW)
 *
 * Define whether DMA FIFO underrun interrupt is enabled. If DMA FIFO underrun
 * interrupt is enabled and DMA FIFO has underrun condition, then an interrupt is
 * generated.
 *
 * Values:
 * - 0 - Enable FIFO underrun Interrupt.
 * - 1 - Disable FIFO underrun Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_FIFO_UNDERRUN_INT_EN (6U) /*!< Bit position for ADC_INT_EN_FIFO_UNDERRUN_INT_EN. */
#define BM_ADC_INT_EN_FIFO_UNDERRUN_INT_EN (0x00000040U) /*!< Bit mask for ADC_INT_EN_FIFO_UNDERRUN_INT_EN. */
#define BS_ADC_INT_EN_FIFO_UNDERRUN_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_FIFO_UNDERRUN_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_FIFO_UNDERRUN_INT_EN field. */
#define BR_ADC_INT_EN_FIFO_UNDERRUN_INT_EN(x) (HW_ADC_INT_EN(x).B.FIFO_UNDERRUN_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_FIFO_UNDERRUN_INT_EN. */
#define BF_ADC_INT_EN_FIFO_UNDERRUN_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_FIFO_UNDERRUN_INT_EN) & BM_ADC_INT_EN_FIFO_UNDERRUN_INT_EN)

/*! @brief Set the FIFO_UNDERRUN_INT_EN field to a new value. */
#define BW_ADC_INT_EN_FIFO_UNDERRUN_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_FIFO_UNDERRUN_INT_EN) | BF_ADC_INT_EN_FIFO_UNDERRUN_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field FIFO_OVERRUN_INT_EN[7] (RW)
 *
 * Define whether DMA FIFO overrun interrupt is enabled. If DMA FIFO overrun
 * interrupt is enabled and DMA FIFO has overrun condition, then an interrupt is
 * generated.
 *
 * Values:
 * - 0 - Enable FIFO Interrupt.
 * - 1 - Disable FIFO Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_FIFO_OVERRUN_INT_EN (7U) /*!< Bit position for ADC_INT_EN_FIFO_OVERRUN_INT_EN. */
#define BM_ADC_INT_EN_FIFO_OVERRUN_INT_EN (0x00000080U) /*!< Bit mask for ADC_INT_EN_FIFO_OVERRUN_INT_EN. */
#define BS_ADC_INT_EN_FIFO_OVERRUN_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_FIFO_OVERRUN_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_FIFO_OVERRUN_INT_EN field. */
#define BR_ADC_INT_EN_FIFO_OVERRUN_INT_EN(x) (HW_ADC_INT_EN(x).B.FIFO_OVERRUN_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_FIFO_OVERRUN_INT_EN. */
#define BF_ADC_INT_EN_FIFO_OVERRUN_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_FIFO_OVERRUN_INT_EN) & BM_ADC_INT_EN_FIFO_OVERRUN_INT_EN)

/*! @brief Set the FIFO_OVERRUN_INT_EN field to a new value. */
#define BW_ADC_INT_EN_FIFO_OVERRUN_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_FIFO_OVERRUN_INT_EN) | BF_ADC_INT_EN_FIFO_OVERRUN_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHA_COV_INT_EN[8] (RW)
 *
 * Define whether channel A conversion interrupt is enabled. If enable
 * interrupt, an interrupt is generated once Channel A finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel A conversion Interrupt.
 * - 1 - Enable channel A conversion Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHA_COV_INT_EN (8U)  /*!< Bit position for ADC_INT_EN_CHA_COV_INT_EN. */
#define BM_ADC_INT_EN_CHA_COV_INT_EN (0x00000100U) /*!< Bit mask for ADC_INT_EN_CHA_COV_INT_EN. */
#define BS_ADC_INT_EN_CHA_COV_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHA_COV_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHA_COV_INT_EN field. */
#define BR_ADC_INT_EN_CHA_COV_INT_EN(x) (HW_ADC_INT_EN(x).B.CHA_COV_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHA_COV_INT_EN. */
#define BF_ADC_INT_EN_CHA_COV_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHA_COV_INT_EN) & BM_ADC_INT_EN_CHA_COV_INT_EN)

/*! @brief Set the CHA_COV_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHA_COV_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHA_COV_INT_EN) | BF_ADC_INT_EN_CHA_COV_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHB_COV_INT_EN[9] (RW)
 *
 * Define whether channel B conversion interrupt is enabled. If enable
 * interrupt, an interrupt is generated once Channel B finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel B conversion Interrupt.
 * - 1 - Enable channel B conversion Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHB_COV_INT_EN (9U)  /*!< Bit position for ADC_INT_EN_CHB_COV_INT_EN. */
#define BM_ADC_INT_EN_CHB_COV_INT_EN (0x00000200U) /*!< Bit mask for ADC_INT_EN_CHB_COV_INT_EN. */
#define BS_ADC_INT_EN_CHB_COV_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHB_COV_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHB_COV_INT_EN field. */
#define BR_ADC_INT_EN_CHB_COV_INT_EN(x) (HW_ADC_INT_EN(x).B.CHB_COV_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHB_COV_INT_EN. */
#define BF_ADC_INT_EN_CHB_COV_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHB_COV_INT_EN) & BM_ADC_INT_EN_CHB_COV_INT_EN)

/*! @brief Set the CHB_COV_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHB_COV_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHB_COV_INT_EN) | BF_ADC_INT_EN_CHB_COV_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHC_COV_INT_EN[10] (RW)
 *
 * Define whether channel C conversion interrupt is enabled. If enable
 * interrupt, an interrupt is generated once Channel C finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel C conversion Interrupt.
 * - 1 - Enable channel C conversion Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHC_COV_INT_EN (10U) /*!< Bit position for ADC_INT_EN_CHC_COV_INT_EN. */
#define BM_ADC_INT_EN_CHC_COV_INT_EN (0x00000400U) /*!< Bit mask for ADC_INT_EN_CHC_COV_INT_EN. */
#define BS_ADC_INT_EN_CHC_COV_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHC_COV_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHC_COV_INT_EN field. */
#define BR_ADC_INT_EN_CHC_COV_INT_EN(x) (HW_ADC_INT_EN(x).B.CHC_COV_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHC_COV_INT_EN. */
#define BF_ADC_INT_EN_CHC_COV_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHC_COV_INT_EN) & BM_ADC_INT_EN_CHC_COV_INT_EN)

/*! @brief Set the CHC_COV_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHC_COV_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHC_COV_INT_EN) | BF_ADC_INT_EN_CHC_COV_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHD_COV_INT_EN[11] (RW)
 *
 * Define whether channel D conversion interrupt is enabled. If enable
 * interrupt, an interrupt is generated once Channel D finish a new conversion.
 *
 * Values:
 * - 0 - Disable channel D conversion Interrupt.
 * - 1 - Enable channel D conversion Interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHD_COV_INT_EN (11U) /*!< Bit position for ADC_INT_EN_CHD_COV_INT_EN. */
#define BM_ADC_INT_EN_CHD_COV_INT_EN (0x00000800U) /*!< Bit mask for ADC_INT_EN_CHD_COV_INT_EN. */
#define BS_ADC_INT_EN_CHD_COV_INT_EN (1U)  /*!< Bit field size in bits for ADC_INT_EN_CHD_COV_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHD_COV_INT_EN field. */
#define BR_ADC_INT_EN_CHD_COV_INT_EN(x) (HW_ADC_INT_EN(x).B.CHD_COV_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHD_COV_INT_EN. */
#define BF_ADC_INT_EN_CHD_COV_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHD_COV_INT_EN) & BM_ADC_INT_EN_CHD_COV_INT_EN)

/*! @brief Set the CHD_COV_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHD_COV_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHD_COV_INT_EN) | BF_ADC_INT_EN_CHD_COV_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field SW_CH_COV_INT_EN[12] (RW)
 *
 * Define whether software trigger interrupt is enabled.
 *
 * Values:
 * - 0 - Disable software channel conversion interrupt.
 * - 1 - Enable software channel conversion interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_SW_CH_COV_INT_EN (12U) /*!< Bit position for ADC_INT_EN_SW_CH_COV_INT_EN. */
#define BM_ADC_INT_EN_SW_CH_COV_INT_EN (0x00001000U) /*!< Bit mask for ADC_INT_EN_SW_CH_COV_INT_EN. */
#define BS_ADC_INT_EN_SW_CH_COV_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_SW_CH_COV_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_SW_CH_COV_INT_EN field. */
#define BR_ADC_INT_EN_SW_CH_COV_INT_EN(x) (HW_ADC_INT_EN(x).B.SW_CH_COV_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_SW_CH_COV_INT_EN. */
#define BF_ADC_INT_EN_SW_CH_COV_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_SW_CH_COV_INT_EN) & BM_ADC_INT_EN_SW_CH_COV_INT_EN)

/*! @brief Set the SW_CH_COV_INT_EN field to a new value. */
#define BW_ADC_INT_EN_SW_CH_COV_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_SW_CH_COV_INT_EN) | BF_ADC_INT_EN_SW_CH_COV_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHA_COV_TO_INT_EN[16] (RW)
 *
 * Define whether logical channel A conversion time out interrupt is enabled.
 *
 * Values:
 * - 0 - Disable logical channel A conversion time out interrupt.
 * - 1 - Enable logical channel A conversion time out interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHA_COV_TO_INT_EN (16U) /*!< Bit position for ADC_INT_EN_CHA_COV_TO_INT_EN. */
#define BM_ADC_INT_EN_CHA_COV_TO_INT_EN (0x00010000U) /*!< Bit mask for ADC_INT_EN_CHA_COV_TO_INT_EN. */
#define BS_ADC_INT_EN_CHA_COV_TO_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_CHA_COV_TO_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHA_COV_TO_INT_EN field. */
#define BR_ADC_INT_EN_CHA_COV_TO_INT_EN(x) (HW_ADC_INT_EN(x).B.CHA_COV_TO_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHA_COV_TO_INT_EN. */
#define BF_ADC_INT_EN_CHA_COV_TO_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHA_COV_TO_INT_EN) & BM_ADC_INT_EN_CHA_COV_TO_INT_EN)

/*! @brief Set the CHA_COV_TO_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHA_COV_TO_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHA_COV_TO_INT_EN) | BF_ADC_INT_EN_CHA_COV_TO_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHB_COV_TO_INT_EN[17] (RW)
 *
 * Define whether logical channel B conversion time out interrupt is enabled.
 *
 * Values:
 * - 0 - Disable logical channel B conversion time out interrupt.
 * - 1 - Enable logical channel B conversion time out interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHB_COV_TO_INT_EN (17U) /*!< Bit position for ADC_INT_EN_CHB_COV_TO_INT_EN. */
#define BM_ADC_INT_EN_CHB_COV_TO_INT_EN (0x00020000U) /*!< Bit mask for ADC_INT_EN_CHB_COV_TO_INT_EN. */
#define BS_ADC_INT_EN_CHB_COV_TO_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_CHB_COV_TO_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHB_COV_TO_INT_EN field. */
#define BR_ADC_INT_EN_CHB_COV_TO_INT_EN(x) (HW_ADC_INT_EN(x).B.CHB_COV_TO_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHB_COV_TO_INT_EN. */
#define BF_ADC_INT_EN_CHB_COV_TO_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHB_COV_TO_INT_EN) & BM_ADC_INT_EN_CHB_COV_TO_INT_EN)

/*! @brief Set the CHB_COV_TO_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHB_COV_TO_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHB_COV_TO_INT_EN) | BF_ADC_INT_EN_CHB_COV_TO_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHC_COV_TO_INT_EN[18] (RW)
 *
 * Define whether logical channel C conversion time out interrupt is enabled.
 *
 * Values:
 * - 0 - Disable logical channel C conversion time out interrupt.
 * - 1 - Enable logical channel C conversion time out interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHC_COV_TO_INT_EN (18U) /*!< Bit position for ADC_INT_EN_CHC_COV_TO_INT_EN. */
#define BM_ADC_INT_EN_CHC_COV_TO_INT_EN (0x00040000U) /*!< Bit mask for ADC_INT_EN_CHC_COV_TO_INT_EN. */
#define BS_ADC_INT_EN_CHC_COV_TO_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_CHC_COV_TO_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHC_COV_TO_INT_EN field. */
#define BR_ADC_INT_EN_CHC_COV_TO_INT_EN(x) (HW_ADC_INT_EN(x).B.CHC_COV_TO_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHC_COV_TO_INT_EN. */
#define BF_ADC_INT_EN_CHC_COV_TO_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHC_COV_TO_INT_EN) & BM_ADC_INT_EN_CHC_COV_TO_INT_EN)

/*! @brief Set the CHC_COV_TO_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHC_COV_TO_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHC_COV_TO_INT_EN) | BF_ADC_INT_EN_CHC_COV_TO_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field CHD_COV_TO_INT_EN[19] (RW)
 *
 * Define whether logical channel D conversion time out interrupt is enabled.
 *
 * Values:
 * - 0 - Disable logical channel D conversion time out interrupt.
 * - 1 - Enable logical channel D conversion time out interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_CHD_COV_TO_INT_EN (19U) /*!< Bit position for ADC_INT_EN_CHD_COV_TO_INT_EN. */
#define BM_ADC_INT_EN_CHD_COV_TO_INT_EN (0x00080000U) /*!< Bit mask for ADC_INT_EN_CHD_COV_TO_INT_EN. */
#define BS_ADC_INT_EN_CHD_COV_TO_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_CHD_COV_TO_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_CHD_COV_TO_INT_EN field. */
#define BR_ADC_INT_EN_CHD_COV_TO_INT_EN(x) (HW_ADC_INT_EN(x).B.CHD_COV_TO_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_CHD_COV_TO_INT_EN. */
#define BF_ADC_INT_EN_CHD_COV_TO_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_CHD_COV_TO_INT_EN) & BM_ADC_INT_EN_CHD_COV_TO_INT_EN)

/*! @brief Set the CHD_COV_TO_INT_EN field to a new value. */
#define BW_ADC_INT_EN_CHD_COV_TO_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_CHD_COV_TO_INT_EN) | BF_ADC_INT_EN_CHD_COV_TO_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field SW_CH_COV_TO_INT_EN[20] (RW)
 *
 * Define whether software channel conversion time out interrupt is enabled.
 *
 * Values:
 * - 0 - Disable software channel conversion time out interrupt.
 * - 1 - Enable software channel conversion time out interrupt.
 */
/*@{*/
#define BP_ADC_INT_EN_SW_CH_COV_TO_INT_EN (20U) /*!< Bit position for ADC_INT_EN_SW_CH_COV_TO_INT_EN. */
#define BM_ADC_INT_EN_SW_CH_COV_TO_INT_EN (0x00100000U) /*!< Bit mask for ADC_INT_EN_SW_CH_COV_TO_INT_EN. */
#define BS_ADC_INT_EN_SW_CH_COV_TO_INT_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_SW_CH_COV_TO_INT_EN. */

/*! @brief Read current value of the ADC_INT_EN_SW_CH_COV_TO_INT_EN field. */
#define BR_ADC_INT_EN_SW_CH_COV_TO_INT_EN(x) (HW_ADC_INT_EN(x).B.SW_CH_COV_TO_INT_EN)

/*! @brief Format value for bitfield ADC_INT_EN_SW_CH_COV_TO_INT_EN. */
#define BF_ADC_INT_EN_SW_CH_COV_TO_INT_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_SW_CH_COV_TO_INT_EN) & BM_ADC_INT_EN_SW_CH_COV_TO_INT_EN)

/*! @brief Set the SW_CH_COV_TO_INT_EN field to a new value. */
#define BW_ADC_INT_EN_SW_CH_COV_TO_INT_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_SW_CH_COV_TO_INT_EN) | BF_ADC_INT_EN_SW_CH_COV_TO_INT_EN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_EN, field LAST_FIFO_DATA_READ_EN[21] (RW)
 *
 * Define whether generate an interrupt when the last data read out of FIFO (the
 * last of whole continuous result)
 *
 * Values:
 * - 0 - Disable last FIFO read enable
 * - 1 - Enable last FIFO read enable
 */
/*@{*/
#define BP_ADC_INT_EN_LAST_FIFO_DATA_READ_EN (21U) /*!< Bit position for ADC_INT_EN_LAST_FIFO_DATA_READ_EN. */
#define BM_ADC_INT_EN_LAST_FIFO_DATA_READ_EN (0x00200000U) /*!< Bit mask for ADC_INT_EN_LAST_FIFO_DATA_READ_EN. */
#define BS_ADC_INT_EN_LAST_FIFO_DATA_READ_EN (1U) /*!< Bit field size in bits for ADC_INT_EN_LAST_FIFO_DATA_READ_EN. */

/*! @brief Read current value of the ADC_INT_EN_LAST_FIFO_DATA_READ_EN field. */
#define BR_ADC_INT_EN_LAST_FIFO_DATA_READ_EN(x) (HW_ADC_INT_EN(x).B.LAST_FIFO_DATA_READ_EN)

/*! @brief Format value for bitfield ADC_INT_EN_LAST_FIFO_DATA_READ_EN. */
#define BF_ADC_INT_EN_LAST_FIFO_DATA_READ_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_EN_LAST_FIFO_DATA_READ_EN) & BM_ADC_INT_EN_LAST_FIFO_DATA_READ_EN)

/*! @brief Set the LAST_FIFO_DATA_READ_EN field to a new value. */
#define BW_ADC_INT_EN_LAST_FIFO_DATA_READ_EN(x, v) (HW_ADC_INT_EN_WR(x, (HW_ADC_INT_EN_RD(x) & ~BM_ADC_INT_EN_LAST_FIFO_DATA_READ_EN) | BF_ADC_INT_EN_LAST_FIFO_DATA_READ_EN(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_INT_STATUS -
 ******************************************************************************/

/*!
 * @brief HW_ADC_INT_STATUS -  (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_int_status
{
    uint32_t U;
    struct _hw_adc_int_status_bitfields
    {
        uint32_t CBA_CMP : 1;          /*!< [0] Channel A Compare (Flag) */
        uint32_t CHB_CMP : 1;          /*!< [1] Channel B Compare (Flag) */
        uint32_t CHC_CMP : 1;          /*!< [2] Channel C Compare (Flag) */
        uint32_t CHD_CMP : 1;          /*!< [3] Channel D Compare (Flag) */
        uint32_t RESERVED0 : 1;        /*!< [4] This field is reserved. */
        uint32_t DMA_REACH_WM : 1;     /*!< [5] DMA Reach Watermark Level (Flag)
                                        * */
        uint32_t FIFO_UNDERRUN : 1;    /*!< [6] FIFO Underrun (Flag) */
        uint32_t FIFO_OVERRUN : 1;     /*!< [7] FIFO Overrun (Flag) */
        uint32_t CHA_COV : 1;          /*!< [8] Channel A Conversion (Flag) */
        uint32_t CHB_COV : 1;          /*!< [9] Channel B Conversion (Flag) */
        uint32_t CHC_COV : 1;          /*!< [10] Channel C Conversion (Flag) */
        uint32_t CHD_COV : 1;          /*!< [11] Channel D Conversion (Flag) */
        uint32_t SW_CH_COV : 1;        /*!< [12] Software Channel Conversion (Flag)
                                        * */
        uint32_t RESERVED1 : 3;        /*!< [15:13] This field is reserved. */
        uint32_t CHA_COV_TO : 1;       /*!< [16] Channel A Conversion Time Out */
        uint32_t CHB_COV_TO : 1;       /*!< [17] Channel B Conversion Time Out */
        uint32_t CHC_COV_TO : 1;       /*!< [18] Channel C Conversion Time Out */
        uint32_t CHD_COV_TO : 1;       /*!< [19] Channel D Conversion Time Out */
        uint32_t SW_CH_COV_TO : 1;     /*!< [20] Software Channel Conversion Time
                                        * Out */
        uint32_t LAST_FIFO_DATA_READ : 1; /*!< [21] Last FIFO Data Read */
        uint32_t RESERVED2 : 10;       /*!< [31:22] This field is reserved. */
    } B;
} hw_adc_int_status_t;

/*!
 * @name Constants and macros for entire ADC_INT_STATUS register
 */
/*@{*/
#define HW_ADC_INT_STATUS_ADDR(x) ((uintptr_t)(x) + 0xE0U)

#define HW_ADC_INT_STATUS(x)     (*(__IO hw_adc_int_status_t *) HW_ADC_INT_STATUS_ADDR(x))
#define HW_ADC_INT_STATUS_RD(x)  (HW_ADC_INT_STATUS(x).U)
#define HW_ADC_INT_STATUS_WR(x, v) (HW_ADC_INT_STATUS(x).U = (v))
#define HW_ADC_INT_STATUS_SET(x, v) (HW_ADC_INT_STATUS_WR(x, HW_ADC_INT_STATUS_RD(x) |  (v)))
#define HW_ADC_INT_STATUS_CLR(x, v) (HW_ADC_INT_STATUS_WR(x, HW_ADC_INT_STATUS_RD(x) & ~(v)))
#define HW_ADC_INT_STATUS_TOG(x, v) (HW_ADC_INT_STATUS_WR(x, HW_ADC_INT_STATUS_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_INT_STATUS bitfields
 */

/*!
 * @name Register ADC_INT_STATUS, field CBA_CMP[0] (RW)
 *
 * This is the flag of channel A compare. If CHA_CMP_INT_SIG_EN is enabled and
 * channel A conversion result matches the compare region, the CHA_CMP (Flag) is
 * set.
 *
 * Values:
 * - 0 - Disable Channel A Compare (Flag).
 * - 1 - Enable Channel A Compare (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CBA_CMP (0U)     /*!< Bit position for ADC_INT_STATUS_CBA_CMP. */
#define BM_ADC_INT_STATUS_CBA_CMP (0x00000001U) /*!< Bit mask for ADC_INT_STATUS_CBA_CMP. */
#define BS_ADC_INT_STATUS_CBA_CMP (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CBA_CMP. */

/*! @brief Read current value of the ADC_INT_STATUS_CBA_CMP field. */
#define BR_ADC_INT_STATUS_CBA_CMP(x) (HW_ADC_INT_STATUS(x).B.CBA_CMP)

/*! @brief Format value for bitfield ADC_INT_STATUS_CBA_CMP. */
#define BF_ADC_INT_STATUS_CBA_CMP(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CBA_CMP) & BM_ADC_INT_STATUS_CBA_CMP)

/*! @brief Set the CBA_CMP field to a new value. */
#define BW_ADC_INT_STATUS_CBA_CMP(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CBA_CMP) | BF_ADC_INT_STATUS_CBA_CMP(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHB_CMP[1] (RW)
 *
 * This is the flag of channel B compare. If CHB_CMP_INT_SIG_EN is enabled and
 * channel B conversion result matches the compare region, the CHB_CMP (Flag) is
 * set.
 *
 * Values:
 * - 0 - Disable Channel B Compare (Flag).
 * - 1 - Enable Channel B Compare (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHB_CMP (1U)     /*!< Bit position for ADC_INT_STATUS_CHB_CMP. */
#define BM_ADC_INT_STATUS_CHB_CMP (0x00000002U) /*!< Bit mask for ADC_INT_STATUS_CHB_CMP. */
#define BS_ADC_INT_STATUS_CHB_CMP (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHB_CMP. */

/*! @brief Read current value of the ADC_INT_STATUS_CHB_CMP field. */
#define BR_ADC_INT_STATUS_CHB_CMP(x) (HW_ADC_INT_STATUS(x).B.CHB_CMP)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHB_CMP. */
#define BF_ADC_INT_STATUS_CHB_CMP(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHB_CMP) & BM_ADC_INT_STATUS_CHB_CMP)

/*! @brief Set the CHB_CMP field to a new value. */
#define BW_ADC_INT_STATUS_CHB_CMP(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHB_CMP) | BF_ADC_INT_STATUS_CHB_CMP(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHC_CMP[2] (RW)
 *
 * This is the flag of channel C compare. If CHC_CMP_INT_SIG_EN is enabled and
 * channel C conversion result matches the compare region, the CHC_CMP (Flag) is
 * set.
 *
 * Values:
 * - 0 - Disable Channel C Compare (Flag).
 * - 1 - Enable Channel C Compare (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHC_CMP (2U)     /*!< Bit position for ADC_INT_STATUS_CHC_CMP. */
#define BM_ADC_INT_STATUS_CHC_CMP (0x00000004U) /*!< Bit mask for ADC_INT_STATUS_CHC_CMP. */
#define BS_ADC_INT_STATUS_CHC_CMP (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHC_CMP. */

/*! @brief Read current value of the ADC_INT_STATUS_CHC_CMP field. */
#define BR_ADC_INT_STATUS_CHC_CMP(x) (HW_ADC_INT_STATUS(x).B.CHC_CMP)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHC_CMP. */
#define BF_ADC_INT_STATUS_CHC_CMP(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHC_CMP) & BM_ADC_INT_STATUS_CHC_CMP)

/*! @brief Set the CHC_CMP field to a new value. */
#define BW_ADC_INT_STATUS_CHC_CMP(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHC_CMP) | BF_ADC_INT_STATUS_CHC_CMP(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHD_CMP[3] (RW)
 *
 * This is the flag of channel D compare. If CHD_CMP_INT_SIG_EN is enabled and
 * channel D conversion result matches the compare region, the CHD_CMP (Flag) is
 * set.
 *
 * Values:
 * - 0 - Disable Channel D Compare (Flag).
 * - 1 - Enable Channel D Compare (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHD_CMP (3U)     /*!< Bit position for ADC_INT_STATUS_CHD_CMP. */
#define BM_ADC_INT_STATUS_CHD_CMP (0x00000008U) /*!< Bit mask for ADC_INT_STATUS_CHD_CMP. */
#define BS_ADC_INT_STATUS_CHD_CMP (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHD_CMP. */

/*! @brief Read current value of the ADC_INT_STATUS_CHD_CMP field. */
#define BR_ADC_INT_STATUS_CHD_CMP(x) (HW_ADC_INT_STATUS(x).B.CHD_CMP)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHD_CMP. */
#define BF_ADC_INT_STATUS_CHD_CMP(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHD_CMP) & BM_ADC_INT_STATUS_CHD_CMP)

/*! @brief Set the CHD_CMP field to a new value. */
#define BW_ADC_INT_STATUS_CHD_CMP(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHD_CMP) | BF_ADC_INT_STATUS_CHD_CMP(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field DMA_REACH_WM[5] (RW)
 *
 * This is the flag of DMA reach watermark level. Setting this flag indicates
 * the number of data in the DMA FIFO reach the watermark level. This bit is for
 * software read DMA FIFO, if SDMA read DMA FIFO, please disable both interrupt and
 * interrupt signal (flag).
 *
 * Values:
 * - 0 - The numbers of data in DMA FIFO has not reach the watermark level.
 * - 1 - The numbers of data in DMA FIFO has reach the watermark level. Software
 *     clear / clear signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_DMA_REACH_WM (5U) /*!< Bit position for ADC_INT_STATUS_DMA_REACH_WM. */
#define BM_ADC_INT_STATUS_DMA_REACH_WM (0x00000020U) /*!< Bit mask for ADC_INT_STATUS_DMA_REACH_WM. */
#define BS_ADC_INT_STATUS_DMA_REACH_WM (1U) /*!< Bit field size in bits for ADC_INT_STATUS_DMA_REACH_WM. */

/*! @brief Read current value of the ADC_INT_STATUS_DMA_REACH_WM field. */
#define BR_ADC_INT_STATUS_DMA_REACH_WM(x) (HW_ADC_INT_STATUS(x).B.DMA_REACH_WM)

/*! @brief Format value for bitfield ADC_INT_STATUS_DMA_REACH_WM. */
#define BF_ADC_INT_STATUS_DMA_REACH_WM(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_DMA_REACH_WM) & BM_ADC_INT_STATUS_DMA_REACH_WM)

/*! @brief Set the DMA_REACH_WM field to a new value. */
#define BW_ADC_INT_STATUS_DMA_REACH_WM(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_DMA_REACH_WM) | BF_ADC_INT_STATUS_DMA_REACH_WM(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field FIFO_UNDERRUN[6] (RW)
 *
 * This is the flag of FIFO underrun. If FIFO_UNDERRUN_INT_SIG_EN is enabled and
 * FIFO underrun happens, the FIFO_UNDERRUN (flag) is set.
 *
 * Values:
 * - 0 - Do not exist FIFO underrun (Flag).
 * - 1 - Exist FIFO underrun (Flag). Software clear / clear signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_FIFO_UNDERRUN (6U) /*!< Bit position for ADC_INT_STATUS_FIFO_UNDERRUN. */
#define BM_ADC_INT_STATUS_FIFO_UNDERRUN (0x00000040U) /*!< Bit mask for ADC_INT_STATUS_FIFO_UNDERRUN. */
#define BS_ADC_INT_STATUS_FIFO_UNDERRUN (1U) /*!< Bit field size in bits for ADC_INT_STATUS_FIFO_UNDERRUN. */

/*! @brief Read current value of the ADC_INT_STATUS_FIFO_UNDERRUN field. */
#define BR_ADC_INT_STATUS_FIFO_UNDERRUN(x) (HW_ADC_INT_STATUS(x).B.FIFO_UNDERRUN)

/*! @brief Format value for bitfield ADC_INT_STATUS_FIFO_UNDERRUN. */
#define BF_ADC_INT_STATUS_FIFO_UNDERRUN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_FIFO_UNDERRUN) & BM_ADC_INT_STATUS_FIFO_UNDERRUN)

/*! @brief Set the FIFO_UNDERRUN field to a new value. */
#define BW_ADC_INT_STATUS_FIFO_UNDERRUN(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_FIFO_UNDERRUN) | BF_ADC_INT_STATUS_FIFO_UNDERRUN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field FIFO_OVERRUN[7] (RW)
 *
 * This is the flag of FIFO overrun. If FIFO_OVERRUN_INT_SIG_EN is enabled and
 * FIFO overrun happens, the FIFO_OVERRUN (flag) is set.
 *
 * Values:
 * - 0 - Disable FIFO overrun (Flag).
 * - 1 - Enable FIFO overrun (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_FIFO_OVERRUN (7U) /*!< Bit position for ADC_INT_STATUS_FIFO_OVERRUN. */
#define BM_ADC_INT_STATUS_FIFO_OVERRUN (0x00000080U) /*!< Bit mask for ADC_INT_STATUS_FIFO_OVERRUN. */
#define BS_ADC_INT_STATUS_FIFO_OVERRUN (1U) /*!< Bit field size in bits for ADC_INT_STATUS_FIFO_OVERRUN. */

/*! @brief Read current value of the ADC_INT_STATUS_FIFO_OVERRUN field. */
#define BR_ADC_INT_STATUS_FIFO_OVERRUN(x) (HW_ADC_INT_STATUS(x).B.FIFO_OVERRUN)

/*! @brief Format value for bitfield ADC_INT_STATUS_FIFO_OVERRUN. */
#define BF_ADC_INT_STATUS_FIFO_OVERRUN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_FIFO_OVERRUN) & BM_ADC_INT_STATUS_FIFO_OVERRUN)

/*! @brief Set the FIFO_OVERRUN field to a new value. */
#define BW_ADC_INT_STATUS_FIFO_OVERRUN(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_FIFO_OVERRUN) | BF_ADC_INT_STATUS_FIFO_OVERRUN(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHA_COV[8] (RW)
 *
 * This is the flag of channel A conversion. If CHA_COV_INT_SIG_EN is enabled
 * and channel A ADC conversion is finished, the CHA_CONV (flag) is set.
 *
 * Values:
 * - 0 - Disable channel A conversion (Flag).
 * - 1 - Enable channel A conversion (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHA_COV (8U)     /*!< Bit position for ADC_INT_STATUS_CHA_COV. */
#define BM_ADC_INT_STATUS_CHA_COV (0x00000100U) /*!< Bit mask for ADC_INT_STATUS_CHA_COV. */
#define BS_ADC_INT_STATUS_CHA_COV (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHA_COV. */

/*! @brief Read current value of the ADC_INT_STATUS_CHA_COV field. */
#define BR_ADC_INT_STATUS_CHA_COV(x) (HW_ADC_INT_STATUS(x).B.CHA_COV)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHA_COV. */
#define BF_ADC_INT_STATUS_CHA_COV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHA_COV) & BM_ADC_INT_STATUS_CHA_COV)

/*! @brief Set the CHA_COV field to a new value. */
#define BW_ADC_INT_STATUS_CHA_COV(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHA_COV) | BF_ADC_INT_STATUS_CHA_COV(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHB_COV[9] (RW)
 *
 * This is the flag of channel B conversion. If CHB_COV_INT_SIG_EN is enabled
 * and channel B ADC conversion is finished, the CHB_COV (flag) is set.
 *
 * Values:
 * - 0 - Disable channel B conversion (Flag).
 * - 1 - Enable channel B conversion (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHB_COV (9U)     /*!< Bit position for ADC_INT_STATUS_CHB_COV. */
#define BM_ADC_INT_STATUS_CHB_COV (0x00000200U) /*!< Bit mask for ADC_INT_STATUS_CHB_COV. */
#define BS_ADC_INT_STATUS_CHB_COV (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHB_COV. */

/*! @brief Read current value of the ADC_INT_STATUS_CHB_COV field. */
#define BR_ADC_INT_STATUS_CHB_COV(x) (HW_ADC_INT_STATUS(x).B.CHB_COV)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHB_COV. */
#define BF_ADC_INT_STATUS_CHB_COV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHB_COV) & BM_ADC_INT_STATUS_CHB_COV)

/*! @brief Set the CHB_COV field to a new value. */
#define BW_ADC_INT_STATUS_CHB_COV(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHB_COV) | BF_ADC_INT_STATUS_CHB_COV(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHC_COV[10] (RW)
 *
 * This is the flag of channel C conversion. If CHC_COV_INT_SIG_EN is enabled
 * and channel C ADC conversion is finished, the CHC_COV (flag) is set.
 *
 * Values:
 * - 0 - Disable channel C conversion (Flag).
 * - 1 - Enable channel C conversion (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHC_COV (10U)    /*!< Bit position for ADC_INT_STATUS_CHC_COV. */
#define BM_ADC_INT_STATUS_CHC_COV (0x00000400U) /*!< Bit mask for ADC_INT_STATUS_CHC_COV. */
#define BS_ADC_INT_STATUS_CHC_COV (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHC_COV. */

/*! @brief Read current value of the ADC_INT_STATUS_CHC_COV field. */
#define BR_ADC_INT_STATUS_CHC_COV(x) (HW_ADC_INT_STATUS(x).B.CHC_COV)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHC_COV. */
#define BF_ADC_INT_STATUS_CHC_COV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHC_COV) & BM_ADC_INT_STATUS_CHC_COV)

/*! @brief Set the CHC_COV field to a new value. */
#define BW_ADC_INT_STATUS_CHC_COV(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHC_COV) | BF_ADC_INT_STATUS_CHC_COV(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHD_COV[11] (RW)
 *
 * This is the flag of channel D conversion. If CHD_COV_INT_SIG_EN is enabled
 * and channel D ADC conversion is finished, the CHD_COV (flag) is set.
 *
 * Values:
 * - 0 - Disable channel D conversion (Flag).
 * - 1 - Enable channel D conversion (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHD_COV (11U)    /*!< Bit position for ADC_INT_STATUS_CHD_COV. */
#define BM_ADC_INT_STATUS_CHD_COV (0x00000800U) /*!< Bit mask for ADC_INT_STATUS_CHD_COV. */
#define BS_ADC_INT_STATUS_CHD_COV (1U)     /*!< Bit field size in bits for ADC_INT_STATUS_CHD_COV. */

/*! @brief Read current value of the ADC_INT_STATUS_CHD_COV field. */
#define BR_ADC_INT_STATUS_CHD_COV(x) (HW_ADC_INT_STATUS(x).B.CHD_COV)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHD_COV. */
#define BF_ADC_INT_STATUS_CHD_COV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHD_COV) & BM_ADC_INT_STATUS_CHD_COV)

/*! @brief Set the CHD_COV field to a new value. */
#define BW_ADC_INT_STATUS_CHD_COV(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHD_COV) | BF_ADC_INT_STATUS_CHD_COV(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field SW_CH_COV[12] (RW)
 *
 * This is the flag of software trigger. If SW_CH_COV_INT_SIG_EN is enabled and
 * software trigger ADC conversion is finished, the SW_CH_COV (flag) is set.
 *
 * Values:
 * - 0 - Disable software channel conversion (Flag).
 * - 1 - Enable software channel conversion (Flag).
 */
/*@{*/
#define BP_ADC_INT_STATUS_SW_CH_COV (12U)  /*!< Bit position for ADC_INT_STATUS_SW_CH_COV. */
#define BM_ADC_INT_STATUS_SW_CH_COV (0x00001000U) /*!< Bit mask for ADC_INT_STATUS_SW_CH_COV. */
#define BS_ADC_INT_STATUS_SW_CH_COV (1U)   /*!< Bit field size in bits for ADC_INT_STATUS_SW_CH_COV. */

/*! @brief Read current value of the ADC_INT_STATUS_SW_CH_COV field. */
#define BR_ADC_INT_STATUS_SW_CH_COV(x) (HW_ADC_INT_STATUS(x).B.SW_CH_COV)

/*! @brief Format value for bitfield ADC_INT_STATUS_SW_CH_COV. */
#define BF_ADC_INT_STATUS_SW_CH_COV(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_SW_CH_COV) & BM_ADC_INT_STATUS_SW_CH_COV)

/*! @brief Set the SW_CH_COV field to a new value. */
#define BW_ADC_INT_STATUS_SW_CH_COV(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_SW_CH_COV) | BF_ADC_INT_STATUS_SW_CH_COV(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHA_COV_TO[16] (RW)
 *
 * Represent whether logical channel A conversion time exist.
 *
 * Values:
 * - 0 - Logical channel A conversion time out does not exist.
 * - 1 - Exist logical channel A conversion time out. Software clear / clear
 *     signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHA_COV_TO (16U) /*!< Bit position for ADC_INT_STATUS_CHA_COV_TO. */
#define BM_ADC_INT_STATUS_CHA_COV_TO (0x00010000U) /*!< Bit mask for ADC_INT_STATUS_CHA_COV_TO. */
#define BS_ADC_INT_STATUS_CHA_COV_TO (1U)  /*!< Bit field size in bits for ADC_INT_STATUS_CHA_COV_TO. */

/*! @brief Read current value of the ADC_INT_STATUS_CHA_COV_TO field. */
#define BR_ADC_INT_STATUS_CHA_COV_TO(x) (HW_ADC_INT_STATUS(x).B.CHA_COV_TO)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHA_COV_TO. */
#define BF_ADC_INT_STATUS_CHA_COV_TO(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHA_COV_TO) & BM_ADC_INT_STATUS_CHA_COV_TO)

/*! @brief Set the CHA_COV_TO field to a new value. */
#define BW_ADC_INT_STATUS_CHA_COV_TO(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHA_COV_TO) | BF_ADC_INT_STATUS_CHA_COV_TO(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHB_COV_TO[17] (RW)
 *
 * Represent whether logical channel B conversion time out exist.
 *
 * Values:
 * - 0 - Logical channel B conversion time out exist.
 * - 1 - Exist logical channel B conversion time out. Software clear/clear
 *     signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHB_COV_TO (17U) /*!< Bit position for ADC_INT_STATUS_CHB_COV_TO. */
#define BM_ADC_INT_STATUS_CHB_COV_TO (0x00020000U) /*!< Bit mask for ADC_INT_STATUS_CHB_COV_TO. */
#define BS_ADC_INT_STATUS_CHB_COV_TO (1U)  /*!< Bit field size in bits for ADC_INT_STATUS_CHB_COV_TO. */

/*! @brief Read current value of the ADC_INT_STATUS_CHB_COV_TO field. */
#define BR_ADC_INT_STATUS_CHB_COV_TO(x) (HW_ADC_INT_STATUS(x).B.CHB_COV_TO)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHB_COV_TO. */
#define BF_ADC_INT_STATUS_CHB_COV_TO(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHB_COV_TO) & BM_ADC_INT_STATUS_CHB_COV_TO)

/*! @brief Set the CHB_COV_TO field to a new value. */
#define BW_ADC_INT_STATUS_CHB_COV_TO(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHB_COV_TO) | BF_ADC_INT_STATUS_CHB_COV_TO(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHC_COV_TO[18] (RW)
 *
 * Represent whether logical channel C conversion time out exist.
 *
 * Values:
 * - 0 - Logical channel C conversion time out does not exist.
 * - 1 - Exist logical channel C conversion time out. Software clear / clear
 *     signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHC_COV_TO (18U) /*!< Bit position for ADC_INT_STATUS_CHC_COV_TO. */
#define BM_ADC_INT_STATUS_CHC_COV_TO (0x00040000U) /*!< Bit mask for ADC_INT_STATUS_CHC_COV_TO. */
#define BS_ADC_INT_STATUS_CHC_COV_TO (1U)  /*!< Bit field size in bits for ADC_INT_STATUS_CHC_COV_TO. */

/*! @brief Read current value of the ADC_INT_STATUS_CHC_COV_TO field. */
#define BR_ADC_INT_STATUS_CHC_COV_TO(x) (HW_ADC_INT_STATUS(x).B.CHC_COV_TO)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHC_COV_TO. */
#define BF_ADC_INT_STATUS_CHC_COV_TO(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHC_COV_TO) & BM_ADC_INT_STATUS_CHC_COV_TO)

/*! @brief Set the CHC_COV_TO field to a new value. */
#define BW_ADC_INT_STATUS_CHC_COV_TO(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHC_COV_TO) | BF_ADC_INT_STATUS_CHC_COV_TO(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field CHD_COV_TO[19] (RW)
 *
 * Represent whether logical channel D conversion time out exist.
 *
 * Values:
 * - 0 - Logical channel D conversion time out does not exist.
 * - 1 - Exist logical channel D conversion time out. Software clear / clear
 *     signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_CHD_COV_TO (19U) /*!< Bit position for ADC_INT_STATUS_CHD_COV_TO. */
#define BM_ADC_INT_STATUS_CHD_COV_TO (0x00080000U) /*!< Bit mask for ADC_INT_STATUS_CHD_COV_TO. */
#define BS_ADC_INT_STATUS_CHD_COV_TO (1U)  /*!< Bit field size in bits for ADC_INT_STATUS_CHD_COV_TO. */

/*! @brief Read current value of the ADC_INT_STATUS_CHD_COV_TO field. */
#define BR_ADC_INT_STATUS_CHD_COV_TO(x) (HW_ADC_INT_STATUS(x).B.CHD_COV_TO)

/*! @brief Format value for bitfield ADC_INT_STATUS_CHD_COV_TO. */
#define BF_ADC_INT_STATUS_CHD_COV_TO(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_CHD_COV_TO) & BM_ADC_INT_STATUS_CHD_COV_TO)

/*! @brief Set the CHD_COV_TO field to a new value. */
#define BW_ADC_INT_STATUS_CHD_COV_TO(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_CHD_COV_TO) | BF_ADC_INT_STATUS_CHD_COV_TO(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field SW_CH_COV_TO[20] (RW)
 *
 * Represents whether software channel conversion time out exist.
 *
 * Values:
 * - 0 - Software channel conversion time out does not exist.
 * - 1 - Exist software channel conversion time out. Software clear / clear
 *     signal enable.
 */
/*@{*/
#define BP_ADC_INT_STATUS_SW_CH_COV_TO (20U) /*!< Bit position for ADC_INT_STATUS_SW_CH_COV_TO. */
#define BM_ADC_INT_STATUS_SW_CH_COV_TO (0x00100000U) /*!< Bit mask for ADC_INT_STATUS_SW_CH_COV_TO. */
#define BS_ADC_INT_STATUS_SW_CH_COV_TO (1U) /*!< Bit field size in bits for ADC_INT_STATUS_SW_CH_COV_TO. */

/*! @brief Read current value of the ADC_INT_STATUS_SW_CH_COV_TO field. */
#define BR_ADC_INT_STATUS_SW_CH_COV_TO(x) (HW_ADC_INT_STATUS(x).B.SW_CH_COV_TO)

/*! @brief Format value for bitfield ADC_INT_STATUS_SW_CH_COV_TO. */
#define BF_ADC_INT_STATUS_SW_CH_COV_TO(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_SW_CH_COV_TO) & BM_ADC_INT_STATUS_SW_CH_COV_TO)

/*! @brief Set the SW_CH_COV_TO field to a new value. */
#define BW_ADC_INT_STATUS_SW_CH_COV_TO(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_SW_CH_COV_TO) | BF_ADC_INT_STATUS_SW_CH_COV_TO(v)))
/*@}*/

/*!
 * @name Register ADC_INT_STATUS, field LAST_FIFO_DATA_READ[21] (RW)
 *
 * Represents whether the last data read out of FIFO (the last of whole
 * continuous result)
 *
 * Values:
 * - 0 - Last FIFO data has not been read out
 * - 1 - Last FIFO data has been read out
 */
/*@{*/
#define BP_ADC_INT_STATUS_LAST_FIFO_DATA_READ (21U) /*!< Bit position for ADC_INT_STATUS_LAST_FIFO_DATA_READ. */
#define BM_ADC_INT_STATUS_LAST_FIFO_DATA_READ (0x00200000U) /*!< Bit mask for ADC_INT_STATUS_LAST_FIFO_DATA_READ. */
#define BS_ADC_INT_STATUS_LAST_FIFO_DATA_READ (1U) /*!< Bit field size in bits for ADC_INT_STATUS_LAST_FIFO_DATA_READ. */

/*! @brief Read current value of the ADC_INT_STATUS_LAST_FIFO_DATA_READ field. */
#define BR_ADC_INT_STATUS_LAST_FIFO_DATA_READ(x) (HW_ADC_INT_STATUS(x).B.LAST_FIFO_DATA_READ)

/*! @brief Format value for bitfield ADC_INT_STATUS_LAST_FIFO_DATA_READ. */
#define BF_ADC_INT_STATUS_LAST_FIFO_DATA_READ(v) ((uint32_t)((uint32_t)(v) << BP_ADC_INT_STATUS_LAST_FIFO_DATA_READ) & BM_ADC_INT_STATUS_LAST_FIFO_DATA_READ)

/*! @brief Set the LAST_FIFO_DATA_READ field to a new value. */
#define BW_ADC_INT_STATUS_LAST_FIFO_DATA_READ(x, v) (HW_ADC_INT_STATUS_WR(x, (HW_ADC_INT_STATUS_RD(x) & ~BM_ADC_INT_STATUS_LAST_FIFO_DATA_READ) | BF_ADC_INT_STATUS_LAST_FIFO_DATA_READ(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CHA_B_CNV_RSLT - Channel A and B Conversion Result
 ******************************************************************************/

/*!
 * @brief HW_ADC_CHA_B_CNV_RSLT - Channel A and B Conversion Result (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_cha_b_cnv_rslt
{
    uint32_t U;
    struct _hw_adc_cha_b_cnv_rslt_bitfields
    {
        uint32_t CHA_CNV_RSLT : 12;    /*!< [11:0] Channel A Conversion Result */
        uint32_t RESERVED0 : 4;        /*!< [15:12] This field is reserved. */
        uint32_t CHB_CNV_RSLT : 12;    /*!< [27:16] Channel B Conversion Result
                                        * */
        uint32_t RESERVED1 : 4;        /*!< [31:28] This field is reserved. */
    } B;
} hw_adc_cha_b_cnv_rslt_t;

/*!
 * @name Constants and macros for entire ADC_CHA_B_CNV_RSLT register
 */
/*@{*/
#define HW_ADC_CHA_B_CNV_RSLT_ADDR(x) ((uintptr_t)(x) + 0xF0U)

#define HW_ADC_CHA_B_CNV_RSLT(x) (*(__IO hw_adc_cha_b_cnv_rslt_t *) HW_ADC_CHA_B_CNV_RSLT_ADDR(x))
#define HW_ADC_CHA_B_CNV_RSLT_RD(x) (HW_ADC_CHA_B_CNV_RSLT(x).U)
#define HW_ADC_CHA_B_CNV_RSLT_WR(x, v) (HW_ADC_CHA_B_CNV_RSLT(x).U = (v))
#define HW_ADC_CHA_B_CNV_RSLT_SET(x, v) (HW_ADC_CHA_B_CNV_RSLT_WR(x, HW_ADC_CHA_B_CNV_RSLT_RD(x) |  (v)))
#define HW_ADC_CHA_B_CNV_RSLT_CLR(x, v) (HW_ADC_CHA_B_CNV_RSLT_WR(x, HW_ADC_CHA_B_CNV_RSLT_RD(x) & ~(v)))
#define HW_ADC_CHA_B_CNV_RSLT_TOG(x, v) (HW_ADC_CHA_B_CNV_RSLT_WR(x, HW_ADC_CHA_B_CNV_RSLT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CHA_B_CNV_RSLT bitfields
 */

/*!
 * @name Register ADC_CHA_B_CNV_RSLT, field CHA_CNV_RSLT[11:0] (RW)
 *
 * Channel A conversion result stores in this field.
 */
/*@{*/
#define BP_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT (0U) /*!< Bit position for ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT. */
#define BM_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT (0x00000FFFU) /*!< Bit mask for ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT. */
#define BS_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT (12U) /*!< Bit field size in bits for ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT. */

/*! @brief Read current value of the ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT field. */
#define BR_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT(x) (HW_ADC_CHA_B_CNV_RSLT(x).B.CHA_CNV_RSLT)

/*! @brief Format value for bitfield ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT. */
#define BF_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT) & BM_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT)

/*! @brief Set the CHA_CNV_RSLT field to a new value. */
#define BW_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT(x, v) (HW_ADC_CHA_B_CNV_RSLT_WR(x, (HW_ADC_CHA_B_CNV_RSLT_RD(x) & ~BM_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT) | BF_ADC_CHA_B_CNV_RSLT_CHA_CNV_RSLT(v)))
/*@}*/

/*!
 * @name Register ADC_CHA_B_CNV_RSLT, field CHB_CNV_RSLT[27:16] (RW)
 *
 * Channel B conversion result stores in this field.
 */
/*@{*/
#define BP_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT (16U) /*!< Bit position for ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT. */
#define BM_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT (0x0FFF0000U) /*!< Bit mask for ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT. */
#define BS_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT (12U) /*!< Bit field size in bits for ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT. */

/*! @brief Read current value of the ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT field. */
#define BR_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT(x) (HW_ADC_CHA_B_CNV_RSLT(x).B.CHB_CNV_RSLT)

/*! @brief Format value for bitfield ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT. */
#define BF_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT) & BM_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT)

/*! @brief Set the CHB_CNV_RSLT field to a new value. */
#define BW_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT(x, v) (HW_ADC_CHA_B_CNV_RSLT_WR(x, (HW_ADC_CHA_B_CNV_RSLT_RD(x) & ~BM_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT) | BF_ADC_CHA_B_CNV_RSLT_CHB_CNV_RSLT(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CHC_D_CNV_RSLT - Channel C and D Conversion Result
 ******************************************************************************/

/*!
 * @brief HW_ADC_CHC_D_CNV_RSLT - Channel C and D Conversion Result (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_chc_d_cnv_rslt
{
    uint32_t U;
    struct _hw_adc_chc_d_cnv_rslt_bitfields
    {
        uint32_t CHC_CNV_RSLT : 12;    /*!< [11:0] Channel C Conversion Result */
        uint32_t RESERVED0 : 4;        /*!< [15:12] This field is reserved. */
        uint32_t CHD_CNV_RSLT : 12;    /*!< [27:16] Channel D Conversion Result
                                        * */
        uint32_t RESERVED1 : 4;        /*!< [31:28] This field is reserved. */
    } B;
} hw_adc_chc_d_cnv_rslt_t;

/*!
 * @name Constants and macros for entire ADC_CHC_D_CNV_RSLT register
 */
/*@{*/
#define HW_ADC_CHC_D_CNV_RSLT_ADDR(x) ((uintptr_t)(x) + 0x100U)

#define HW_ADC_CHC_D_CNV_RSLT(x) (*(__IO hw_adc_chc_d_cnv_rslt_t *) HW_ADC_CHC_D_CNV_RSLT_ADDR(x))
#define HW_ADC_CHC_D_CNV_RSLT_RD(x) (HW_ADC_CHC_D_CNV_RSLT(x).U)
#define HW_ADC_CHC_D_CNV_RSLT_WR(x, v) (HW_ADC_CHC_D_CNV_RSLT(x).U = (v))
#define HW_ADC_CHC_D_CNV_RSLT_SET(x, v) (HW_ADC_CHC_D_CNV_RSLT_WR(x, HW_ADC_CHC_D_CNV_RSLT_RD(x) |  (v)))
#define HW_ADC_CHC_D_CNV_RSLT_CLR(x, v) (HW_ADC_CHC_D_CNV_RSLT_WR(x, HW_ADC_CHC_D_CNV_RSLT_RD(x) & ~(v)))
#define HW_ADC_CHC_D_CNV_RSLT_TOG(x, v) (HW_ADC_CHC_D_CNV_RSLT_WR(x, HW_ADC_CHC_D_CNV_RSLT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CHC_D_CNV_RSLT bitfields
 */

/*!
 * @name Register ADC_CHC_D_CNV_RSLT, field CHC_CNV_RSLT[11:0] (RW)
 *
 * Channel C conversion result stores in this field.
 */
/*@{*/
#define BP_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT (0U) /*!< Bit position for ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT. */
#define BM_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT (0x00000FFFU) /*!< Bit mask for ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT. */
#define BS_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT (12U) /*!< Bit field size in bits for ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT. */

/*! @brief Read current value of the ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT field. */
#define BR_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT(x) (HW_ADC_CHC_D_CNV_RSLT(x).B.CHC_CNV_RSLT)

/*! @brief Format value for bitfield ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT. */
#define BF_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT) & BM_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT)

/*! @brief Set the CHC_CNV_RSLT field to a new value. */
#define BW_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT(x, v) (HW_ADC_CHC_D_CNV_RSLT_WR(x, (HW_ADC_CHC_D_CNV_RSLT_RD(x) & ~BM_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT) | BF_ADC_CHC_D_CNV_RSLT_CHC_CNV_RSLT(v)))
/*@}*/

/*!
 * @name Register ADC_CHC_D_CNV_RSLT, field CHD_CNV_RSLT[27:16] (RW)
 *
 * Channel D conversion result stores in this field.
 */
/*@{*/
#define BP_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT (16U) /*!< Bit position for ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT. */
#define BM_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT (0x0FFF0000U) /*!< Bit mask for ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT. */
#define BS_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT (12U) /*!< Bit field size in bits for ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT. */

/*! @brief Read current value of the ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT field. */
#define BR_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT(x) (HW_ADC_CHC_D_CNV_RSLT(x).B.CHD_CNV_RSLT)

/*! @brief Format value for bitfield ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT. */
#define BF_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT) & BM_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT)

/*! @brief Set the CHD_CNV_RSLT field to a new value. */
#define BW_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT(x, v) (HW_ADC_CHC_D_CNV_RSLT_WR(x, (HW_ADC_CHC_D_CNV_RSLT_RD(x) & ~BM_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT) | BF_ADC_CHC_D_CNV_RSLT_CHD_CNV_RSLT(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_CH_SW_CNV_RSLT - Channel Software Conversion Result
 ******************************************************************************/

/*!
 * @brief HW_ADC_CH_SW_CNV_RSLT - Channel Software Conversion Result (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_ch_sw_cnv_rslt
{
    uint32_t U;
    struct _hw_adc_ch_sw_cnv_rslt_bitfields
    {
        uint32_t CH_SW_CNV_RSLT : 12;  /*!< [11:0] Channel Software Conversion
                                        * Result */
        uint32_t RESERVED0 : 20;       /*!< [31:12] This field is reserved. */
    } B;
} hw_adc_ch_sw_cnv_rslt_t;

/*!
 * @name Constants and macros for entire ADC_CH_SW_CNV_RSLT register
 */
/*@{*/
#define HW_ADC_CH_SW_CNV_RSLT_ADDR(x) ((uintptr_t)(x) + 0x110U)

#define HW_ADC_CH_SW_CNV_RSLT(x) (*(__IO hw_adc_ch_sw_cnv_rslt_t *) HW_ADC_CH_SW_CNV_RSLT_ADDR(x))
#define HW_ADC_CH_SW_CNV_RSLT_RD(x) (HW_ADC_CH_SW_CNV_RSLT(x).U)
#define HW_ADC_CH_SW_CNV_RSLT_WR(x, v) (HW_ADC_CH_SW_CNV_RSLT(x).U = (v))
#define HW_ADC_CH_SW_CNV_RSLT_SET(x, v) (HW_ADC_CH_SW_CNV_RSLT_WR(x, HW_ADC_CH_SW_CNV_RSLT_RD(x) |  (v)))
#define HW_ADC_CH_SW_CNV_RSLT_CLR(x, v) (HW_ADC_CH_SW_CNV_RSLT_WR(x, HW_ADC_CH_SW_CNV_RSLT_RD(x) & ~(v)))
#define HW_ADC_CH_SW_CNV_RSLT_TOG(x, v) (HW_ADC_CH_SW_CNV_RSLT_WR(x, HW_ADC_CH_SW_CNV_RSLT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_CH_SW_CNV_RSLT bitfields
 */

/*!
 * @name Register ADC_CH_SW_CNV_RSLT, field CH_SW_CNV_RSLT[11:0] (RW)
 *
 * Channel Software trigger conversion result stores in this field.
 */
/*@{*/
#define BP_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT (0U) /*!< Bit position for ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT. */
#define BM_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT (0x00000FFFU) /*!< Bit mask for ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT. */
#define BS_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT (12U) /*!< Bit field size in bits for ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT. */

/*! @brief Read current value of the ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT field. */
#define BR_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT(x) (HW_ADC_CH_SW_CNV_RSLT(x).B.CH_SW_CNV_RSLT)

/*! @brief Format value for bitfield ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT. */
#define BF_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT(v) ((uint32_t)((uint32_t)(v) << BP_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT) & BM_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT)

/*! @brief Set the CH_SW_CNV_RSLT field to a new value. */
#define BW_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT(x, v) (HW_ADC_CH_SW_CNV_RSLT_WR(x, (HW_ADC_CH_SW_CNV_RSLT_RD(x) & ~BM_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT) | BF_ADC_CH_SW_CNV_RSLT_CH_SW_CNV_RSLT(v)))
/*@}*/

/*******************************************************************************
 * HW_ADC_DMA_FIFO_DAT - DMA FIFO Data
 ******************************************************************************/

/*!
 * @brief HW_ADC_DMA_FIFO_DAT - DMA FIFO Data (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_adc_dma_fifo_dat
{
    uint32_t U;
    struct _hw_adc_dma_fifo_dat_bitfields
    {
        uint32_t DMA_FIFO_0 : 12;      /*!< [11:0]  */
        uint32_t RESERVED0 : 2;        /*!< [13:12] This field is reserved. */
        uint32_t DAT1_FLAG : 2;        /*!< [15:14] Data 1 Flag */
        uint32_t DMA_FIFO_1 : 12;      /*!< [27:16]  */
        uint32_t RESERVED1 : 2;        /*!< [29:28] This field is reserved. */
        uint32_t DAT2_FLAG : 2;        /*!< [31:30] Data 2 Flag */
    } B;
} hw_adc_dma_fifo_dat_t;

/*!
 * @name Constants and macros for entire ADC_DMA_FIFO_DAT register
 */
/*@{*/
#define HW_ADC_DMA_FIFO_DAT_ADDR(x) ((uintptr_t)(x) + 0x120U)

#define HW_ADC_DMA_FIFO_DAT(x)   (*(__I hw_adc_dma_fifo_dat_t *) HW_ADC_DMA_FIFO_DAT_ADDR(x))
#define HW_ADC_DMA_FIFO_DAT_RD(x) (HW_ADC_DMA_FIFO_DAT(x).U)
/*@}*/

/*
 * Constants & macros for individual ADC_DMA_FIFO_DAT bitfields
 */

/*!
 * @name Register ADC_DMA_FIFO_DAT, field DMA_FIFO_0[11:0] (RO)
 *
 * The even number of data is in this field. This field is read-only
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DAT_DMA_FIFO_0 (0U) /*!< Bit position for ADC_DMA_FIFO_DAT_DMA_FIFO_0. */
#define BM_ADC_DMA_FIFO_DAT_DMA_FIFO_0 (0x00000FFFU) /*!< Bit mask for ADC_DMA_FIFO_DAT_DMA_FIFO_0. */
#define BS_ADC_DMA_FIFO_DAT_DMA_FIFO_0 (12U) /*!< Bit field size in bits for ADC_DMA_FIFO_DAT_DMA_FIFO_0. */

/*! @brief Read current value of the ADC_DMA_FIFO_DAT_DMA_FIFO_0 field. */
#define BR_ADC_DMA_FIFO_DAT_DMA_FIFO_0(x) (HW_ADC_DMA_FIFO_DAT(x).B.DMA_FIFO_0)
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO_DAT, field DAT1_FLAG[15:14] (RO)
 *
 * The flag defines the status of data 1.
 *
 * Values:
 * - 00 - Default
 * - 01 - Valid Data. Indicate the data 1 is a valid data.
 * - 10 - Last Data. Indicate the last the data of a continuous batch.
 * - 11 - Invalid Data. Indicate the data 1 is a invalid data.
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DAT_DAT1_FLAG (14U) /*!< Bit position for ADC_DMA_FIFO_DAT_DAT1_FLAG. */
#define BM_ADC_DMA_FIFO_DAT_DAT1_FLAG (0x0000C000U) /*!< Bit mask for ADC_DMA_FIFO_DAT_DAT1_FLAG. */
#define BS_ADC_DMA_FIFO_DAT_DAT1_FLAG (2U) /*!< Bit field size in bits for ADC_DMA_FIFO_DAT_DAT1_FLAG. */

/*! @brief Read current value of the ADC_DMA_FIFO_DAT_DAT1_FLAG field. */
#define BR_ADC_DMA_FIFO_DAT_DAT1_FLAG(x) (HW_ADC_DMA_FIFO_DAT(x).B.DAT1_FLAG)
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO_DAT, field DMA_FIFO_1[27:16] (RO)
 *
 * The even number of data is in this field. This field is read-only
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DAT_DMA_FIFO_1 (16U) /*!< Bit position for ADC_DMA_FIFO_DAT_DMA_FIFO_1. */
#define BM_ADC_DMA_FIFO_DAT_DMA_FIFO_1 (0x0FFF0000U) /*!< Bit mask for ADC_DMA_FIFO_DAT_DMA_FIFO_1. */
#define BS_ADC_DMA_FIFO_DAT_DMA_FIFO_1 (12U) /*!< Bit field size in bits for ADC_DMA_FIFO_DAT_DMA_FIFO_1. */

/*! @brief Read current value of the ADC_DMA_FIFO_DAT_DMA_FIFO_1 field. */
#define BR_ADC_DMA_FIFO_DAT_DMA_FIFO_1(x) (HW_ADC_DMA_FIFO_DAT(x).B.DMA_FIFO_1)
/*@}*/

/*!
 * @name Register ADC_DMA_FIFO_DAT, field DAT2_FLAG[31:30] (RO)
 *
 * The flag defines the status of data 2.
 *
 * Values:
 * - 00 - Default
 * - 01 - Valid Data. Indicate the data 2 is a valid data.
 * - 10 - Last Data. Indicate the last the data of a continuous batch.
 * - 11 - Invalid Data. Indicate the data 2 is a invalid data.
 */
/*@{*/
#define BP_ADC_DMA_FIFO_DAT_DAT2_FLAG (30U) /*!< Bit position for ADC_DMA_FIFO_DAT_DAT2_FLAG. */
#define BM_ADC_DMA_FIFO_DAT_DAT2_FLAG (0xC0000000U) /*!< Bit mask for ADC_DMA_FIFO_DAT_DAT2_FLAG. */
#define BS_ADC_DMA_FIFO_DAT_DAT2_FLAG (2U) /*!< Bit field size in bits for ADC_DMA_FIFO_DAT_DAT2_FLAG. */

/*! @brief Read current value of the ADC_DMA_FIFO_DAT_DAT2_FLAG field. */
#define BR_ADC_DMA_FIFO_DAT_DAT2_FLAG(x) (HW_ADC_DMA_FIFO_DAT(x).B.DAT2_FLAG)
/*@}*/

/*******************************************************************************
 * HW_ADC_ADC_CFG - ADC Configuration
 ******************************************************************************/

/*!
 * @brief HW_ADC_ADC_CFG - ADC Configuration (RW)
 *
 * Reset value: 0x00000001U
 */
typedef union _hw_adc_adc_cfg
{
    uint32_t U;
    struct _hw_adc_adc_cfg_bitfields
    {
        uint32_t ADC_EN : 1;           /*!< [0] ADC Level Shifter Enable */
        uint32_t ADC_PD : 1;           /*!< [1] ADC Power Down */
        uint32_t RESERVED0 : 5;        /*!< [6:2] This field is reserved. */
        uint32_t ADC_PD_OK : 1;        /*!< [7] ADC Power Down OK */
        uint32_t RESERVED1 : 23;       /*!< [30:8] This field is reserved. */
        uint32_t ADC_CLK_DOWN : 1;     /*!< [31] ADC Clock Down */
    } B;
} hw_adc_adc_cfg_t;

/*!
 * @name Constants and macros for entire ADC_ADC_CFG register
 */
/*@{*/
#define HW_ADC_ADC_CFG_ADDR(x)   ((uintptr_t)(x) + 0x130U)

#define HW_ADC_ADC_CFG(x)        (*(__IO hw_adc_adc_cfg_t *) HW_ADC_ADC_CFG_ADDR(x))
#define HW_ADC_ADC_CFG_RD(x)     (HW_ADC_ADC_CFG(x).U)
#define HW_ADC_ADC_CFG_WR(x, v)  (HW_ADC_ADC_CFG(x).U = (v))
#define HW_ADC_ADC_CFG_SET(x, v) (HW_ADC_ADC_CFG_WR(x, HW_ADC_ADC_CFG_RD(x) |  (v)))
#define HW_ADC_ADC_CFG_CLR(x, v) (HW_ADC_ADC_CFG_WR(x, HW_ADC_ADC_CFG_RD(x) & ~(v)))
#define HW_ADC_ADC_CFG_TOG(x, v) (HW_ADC_ADC_CFG_WR(x, HW_ADC_ADC_CFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual ADC_ADC_CFG bitfields
 */

/*!
 * @name Register ADC_ADC_CFG, field ADC_EN[0] (RW)
 *
 * The level shifter provides 1.8 V to 1.1 V converter. The level shifter is
 * embedded in ADC analogue. The ADC analogue ports voltage level must same with ADC
 * digital part ports voltage level. During low power mode, also reset this bit
 * to 1'b0 to save power.
 *
 * Values:
 * - 0 - Disable level shifter, the ADC analogue core ports using 1.8 V voltage
 *     level.
 * - 1 - Enable level shifter, the ADC analogue core ports using 1.1 V voltage
 *     level.
 */
/*@{*/
#define BP_ADC_ADC_CFG_ADC_EN (0U)         /*!< Bit position for ADC_ADC_CFG_ADC_EN. */
#define BM_ADC_ADC_CFG_ADC_EN (0x00000001U) /*!< Bit mask for ADC_ADC_CFG_ADC_EN. */
#define BS_ADC_ADC_CFG_ADC_EN (1U)         /*!< Bit field size in bits for ADC_ADC_CFG_ADC_EN. */

/*! @brief Read current value of the ADC_ADC_CFG_ADC_EN field. */
#define BR_ADC_ADC_CFG_ADC_EN(x) (HW_ADC_ADC_CFG(x).B.ADC_EN)

/*! @brief Format value for bitfield ADC_ADC_CFG_ADC_EN. */
#define BF_ADC_ADC_CFG_ADC_EN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_ADC_CFG_ADC_EN) & BM_ADC_ADC_CFG_ADC_EN)

/*! @brief Set the ADC_EN field to a new value. */
#define BW_ADC_ADC_CFG_ADC_EN(x, v) (HW_ADC_ADC_CFG_WR(x, (HW_ADC_ADC_CFG_RD(x) & ~BM_ADC_ADC_CFG_ADC_EN) | BF_ADC_ADC_CFG_ADC_EN(v)))
/*@}*/

/*!
 * @name Register ADC_ADC_CFG, field ADC_PD[1] (RW)
 *
 * Power Down ADC analogue core. Before entering into stop-mode, power down ADC
 * analogue core first.
 *
 * Values:
 * - 0 - Do not power down the ADC analogue core.
 * - 1 - Power down the ADC analogue core.
 */
/*@{*/
#define BP_ADC_ADC_CFG_ADC_PD (1U)         /*!< Bit position for ADC_ADC_CFG_ADC_PD. */
#define BM_ADC_ADC_CFG_ADC_PD (0x00000002U) /*!< Bit mask for ADC_ADC_CFG_ADC_PD. */
#define BS_ADC_ADC_CFG_ADC_PD (1U)         /*!< Bit field size in bits for ADC_ADC_CFG_ADC_PD. */

/*! @brief Read current value of the ADC_ADC_CFG_ADC_PD field. */
#define BR_ADC_ADC_CFG_ADC_PD(x) (HW_ADC_ADC_CFG(x).B.ADC_PD)

/*! @brief Format value for bitfield ADC_ADC_CFG_ADC_PD. */
#define BF_ADC_ADC_CFG_ADC_PD(v) ((uint32_t)((uint32_t)(v) << BP_ADC_ADC_CFG_ADC_PD) & BM_ADC_ADC_CFG_ADC_PD)

/*! @brief Set the ADC_PD field to a new value. */
#define BW_ADC_ADC_CFG_ADC_PD(x, v) (HW_ADC_ADC_CFG_WR(x, (HW_ADC_ADC_CFG_RD(x) & ~BM_ADC_ADC_CFG_ADC_PD) | BF_ADC_ADC_CFG_ADC_PD(v)))
/*@}*/

/*!
 * @name Register ADC_ADC_CFG, field ADC_PD_OK[7] (RW)
 *
 * This bit represents whether power down or to start conversion. After power up
 * the ADC analogue core, system has to wait ADC_PD_OK = 1 before start a
 * conversion or power down again. If violate this rule, the ADC may enter an unknown
 * state. Clock cannot stop until this bit equals to 0. This bit will
 * automatically set to 1 if ADC_PD = 0 and ADC_EN = 0 for the specific time period.
 *
 * Values:
 * - 0 - ADC has not power up completely. Cannot start a conversion.
 * - 1 - ADC power up completely. Can start a conversion.
 */
/*@{*/
#define BP_ADC_ADC_CFG_ADC_PD_OK (7U)      /*!< Bit position for ADC_ADC_CFG_ADC_PD_OK. */
#define BM_ADC_ADC_CFG_ADC_PD_OK (0x00000080U) /*!< Bit mask for ADC_ADC_CFG_ADC_PD_OK. */
#define BS_ADC_ADC_CFG_ADC_PD_OK (1U)      /*!< Bit field size in bits for ADC_ADC_CFG_ADC_PD_OK. */

/*! @brief Read current value of the ADC_ADC_CFG_ADC_PD_OK field. */
#define BR_ADC_ADC_CFG_ADC_PD_OK(x) (HW_ADC_ADC_CFG(x).B.ADC_PD_OK)

/*! @brief Format value for bitfield ADC_ADC_CFG_ADC_PD_OK. */
#define BF_ADC_ADC_CFG_ADC_PD_OK(v) ((uint32_t)((uint32_t)(v) << BP_ADC_ADC_CFG_ADC_PD_OK) & BM_ADC_ADC_CFG_ADC_PD_OK)

/*! @brief Set the ADC_PD_OK field to a new value. */
#define BW_ADC_ADC_CFG_ADC_PD_OK(x, v) (HW_ADC_ADC_CFG_WR(x, (HW_ADC_ADC_CFG_RD(x) & ~BM_ADC_ADC_CFG_ADC_PD_OK) | BF_ADC_ADC_CFG_ADC_PD_OK(v)))
/*@}*/

/*!
 * @name Register ADC_ADC_CFG, field ADC_CLK_DOWN[31] (RW)
 *
 * This bit is for low power design. Set this bit to stop all digital part
 * power. Warning: Before set this bit, all conversion must be finished.
 *
 * Values:
 * - 0 - Clock running.
 * - 1 - Clock down, no clock.
 */
/*@{*/
#define BP_ADC_ADC_CFG_ADC_CLK_DOWN (31U)  /*!< Bit position for ADC_ADC_CFG_ADC_CLK_DOWN. */
#define BM_ADC_ADC_CFG_ADC_CLK_DOWN (0x80000000U) /*!< Bit mask for ADC_ADC_CFG_ADC_CLK_DOWN. */
#define BS_ADC_ADC_CFG_ADC_CLK_DOWN (1U)   /*!< Bit field size in bits for ADC_ADC_CFG_ADC_CLK_DOWN. */

/*! @brief Read current value of the ADC_ADC_CFG_ADC_CLK_DOWN field. */
#define BR_ADC_ADC_CFG_ADC_CLK_DOWN(x) (HW_ADC_ADC_CFG(x).B.ADC_CLK_DOWN)

/*! @brief Format value for bitfield ADC_ADC_CFG_ADC_CLK_DOWN. */
#define BF_ADC_ADC_CFG_ADC_CLK_DOWN(v) ((uint32_t)((uint32_t)(v) << BP_ADC_ADC_CFG_ADC_CLK_DOWN) & BM_ADC_ADC_CFG_ADC_CLK_DOWN)

/*! @brief Set the ADC_CLK_DOWN field to a new value. */
#define BW_ADC_ADC_CFG_ADC_CLK_DOWN(x, v) (HW_ADC_ADC_CFG_WR(x, (HW_ADC_ADC_CFG_RD(x) & ~BM_ADC_ADC_CFG_ADC_CLK_DOWN) | BF_ADC_ADC_CFG_ADC_CLK_DOWN(v)))
/*@}*/

/*******************************************************************************
 * hw_adc_t - module struct
 ******************************************************************************/
/*!
 * @brief All ADC module registers.
 */
#pragma pack(1)
typedef struct _hw_adc
{
    __IO hw_adc_ch_a_cfg1_t CH_A_CFG1;     /*!< [0x0] Channel A configuration 1 */
    uint8_t _reserved0[12];
    __IO hw_adc_ch_a_cfg2_t CH_A_CFG2;     /*!< [0x10] Channel A configuration 2 */
    uint8_t _reserved1[12];
    __IO hw_adc_ch_b_cfg1_t CH_B_CFG1;     /*!< [0x20]  */
    uint8_t _reserved2[12];
    __IO hw_adc_ch_b_cfg2_t CH_B_CFG2;     /*!< [0x30] Channel B Configuration 2 */
    uint8_t _reserved3[12];
    __IO hw_adc_ch_c_cfg1_t CH_C_CFG1;     /*!< [0x40] Channel C Configuration 1 */
    uint8_t _reserved4[12];
    __IO hw_adc_ch_c_cfg2_t CH_C_CFG2;     /*!< [0x50] Channel C Configuration 2 */
    uint8_t _reserved5[12];
    __IO hw_adc_ch_d_cfg1_t CH_D_CFG1;     /*!< [0x60] Channel D Configuration 1 */
    uint8_t _reserved6[12];
    __IO hw_adc_ch_d_cfg2_t CH_D_CFG2;     /*!< [0x70] Channel D Configuration 2 */
    uint8_t _reserved7[12];
    __IO hw_adc_ch_sw_cfg_t CH_SW_CFG;     /*!< [0x80] Channel Software Configuration */
    uint8_t _reserved8[12];
    __IO hw_adc_timer_unit_t TIMER_UNIT;   /*!< [0x90] Timer Unit */
    uint8_t _reserved9[12];
    __IO hw_adc_dma_fifo_t DMA_FIFO;       /*!< [0xA0] DMA FIFO */
    uint8_t _reserved10[12];
    __IO hw_adc_fifo_status_t FIFO_STATUS; /*!< [0xB0] FIFO Status */
    uint8_t _reserved11[12];
    __IO hw_adc_int_sig_en_t INT_SIG_EN;   /*!< [0xC0]  */
    uint8_t _reserved12[12];
    __IO hw_adc_int_en_t INT_EN;           /*!< [0xD0] Interrupt Enable */
    uint8_t _reserved13[12];
    __IO hw_adc_int_status_t INT_STATUS;   /*!< [0xE0]  */
    uint8_t _reserved14[12];
    __IO hw_adc_cha_b_cnv_rslt_t CHA_B_CNV_RSLT; /*!< [0xF0] Channel A and B Conversion Result */
    uint8_t _reserved15[12];
    __IO hw_adc_chc_d_cnv_rslt_t CHC_D_CNV_RSLT; /*!< [0x100] Channel C and D Conversion Result */
    uint8_t _reserved16[12];
    __IO hw_adc_ch_sw_cnv_rslt_t CH_SW_CNV_RSLT; /*!< [0x110] Channel Software Conversion Result */
    uint8_t _reserved17[12];
    __I hw_adc_dma_fifo_dat_t DMA_FIFO_DAT; /*!< [0x120] DMA FIFO Data */
    uint8_t _reserved18[12];
    __IO hw_adc_adc_cfg_t ADC_CFG;         /*!< [0x130] ADC Configuration */
} hw_adc_t;
#pragma pack()

/*! @brief Macro to access all ADC registers. */
/*! @param x ADC module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_ADC_REGS(ADC1_BASE)</code>. */
#define HW_ADC_REGS(x) (*(hw_adc_t *)(x))

/*
 * iMX7S APBH
 *
 * APBH Register Reference Index
 *
 * Registers defined in this header file:
 * - HW_APBH_CTRL0 - AHB to APBH Bridge Control and Status Register 0
 * - HW_APBH_CTRL1 - AHB to APBH Bridge Control and Status Register 1
 * - HW_APBH_CTRL2 - AHB to APBH Bridge Control and Status Register 2
 * - HW_APBH_CHANNEL_CTRL - AHB to APBH Bridge Channel Register
 * - HW_APBH_DEVSEL - AHB to APBH DMA Device Assignment Register
 * - HW_APBH_DMA_BURST_SIZE - AHB to APBH DMA burst size
 * - HW_APBH_DEBUG - AHB to APBH DMA Debug Register
 * - HW_APBH_CHn_CURCMDAR - APBH DMA Channel n Current Command Address Register
 * - HW_APBH_CHn_NXTCMDAR - APBH DMA Channel n Next Command Address Register
 * - HW_APBH_CHn_CMD - APBH DMA Channel n Command Register
 * - HW_APBH_CHn_BAR - APBH DMA Channel n Buffer Address Register
 * - HW_APBH_CHn_SEMA - APBH DMA Channel n Semaphore Register
 * - HW_APBH_CHn_DEBUG1 - AHB to APBH DMA Channel n Debug Information
 * - HW_APBH_CHn_DEBUG2 - AHB to APBH DMA Channel n Debug Information
 * - HW_APBH_VERSION - APBH Bridge Version Register
 *
 * - hw_apbh_t - Struct containing all module registers.
 */

#define HW_APBH_INSTANCE_COUNT (1U) /*!< Number of instances of the APBH module. */
#define HW_APBH (0U) /*!< Instance number for APBH. */
#define APBH_BASE             (0x33000000U) /*!< Base address for APBH. */
/*! Array initializer of APBH base addresses. */
#define APBH_BASE_ADDRS       { APBH_BASE }

/*******************************************************************************
 * HW_APBH_CTRL0 - AHB to APBH Bridge Control and Status Register 0
 ******************************************************************************/

/*!
 * @brief HW_APBH_CTRL0 - AHB to APBH Bridge Control and Status Register 0 (RW)
 *
 * Reset value: 0xE0000000U
 *
 * The APBH CTRL 0 provides overall control of the AHB to APBH bridge and DMA.
 * This register contains module softreset, clock gating, channel clock
 * gating/freeze bits.
 */
typedef union _hw_apbh_ctrl0
{
    uint32_t U;
    struct _hw_apbh_ctrl0_bitfields
    {
        uint32_t CLKGATE_CHANNEL : 16; /*!< [15:0]  */
        uint32_t RSVD0 : 12;           /*!< [27:16]  */
        uint32_t APB_BURST_EN : 1;     /*!< [28]  */
        uint32_t AHB_BURST8_EN : 1;    /*!< [29]  */
        uint32_t CLKGATE : 1;          /*!< [30]  */
        uint32_t SFTRST : 1;           /*!< [31]  */
    } B;
} hw_apbh_ctrl0_t;

/*!
 * @name Constants and macros for entire APBH_CTRL0 register
 */
/*@{*/
#define HW_APBH_CTRL0_ADDR(x)    ((uintptr_t)(x) + 0x0U)
#define HW_APBH_CTRL0_SET_ADDR(x) (HW_APBH_CTRL0_ADDR(x) + 0x4U)
#define HW_APBH_CTRL0_CLR_ADDR(x) (HW_APBH_CTRL0_ADDR(x) + 0x8U)
#define HW_APBH_CTRL0_TOG_ADDR(x) (HW_APBH_CTRL0_ADDR(x) + 0xCU)

#define HW_APBH_CTRL0(x)         (*(__IO hw_apbh_ctrl0_t *) HW_APBH_CTRL0_ADDR(x))
#define HW_APBH_CTRL0_RD(x)      (HW_APBH_CTRL0(x).U)
#define HW_APBH_CTRL0_WR(x, v)   (HW_APBH_CTRL0(x).U = (v))
#define HW_APBH_CTRL0_SET(x, v)  ((*(uint32_t *) HW_APBH_CTRL0_SET_ADDR(x)) = (v))
#define HW_APBH_CTRL0_CLR(x, v)  ((*(uint32_t *) HW_APBH_CTRL0_CLR_ADDR(x)) = (v))
#define HW_APBH_CTRL0_TOG(x, v)  ((*(uint32_t *) HW_APBH_CTRL0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual APBH_CTRL0 bitfields
 */

/*!
 * @name Register APBH_CTRL0, field CLKGATE_CHANNEL[15:0] (RW)
 *
 * These bits must be set to zero for normal operation of each channel. When set
 * to one they gate off the individual clocks to the channels.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 * - 10000 -
 * - 100000 -
 * - 1000000 -
 * - 10000000 -
 * - 100000000 -
 */
/*@{*/
#define BP_APBH_CTRL0_CLKGATE_CHANNEL (0U) /*!< Bit position for APBH_CTRL0_CLKGATE_CHANNEL. */
#define BM_APBH_CTRL0_CLKGATE_CHANNEL (0x0000FFFFU) /*!< Bit mask for APBH_CTRL0_CLKGATE_CHANNEL. */
#define BS_APBH_CTRL0_CLKGATE_CHANNEL (16U) /*!< Bit field size in bits for APBH_CTRL0_CLKGATE_CHANNEL. */

#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND0 (0x1U)   /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND1 (0x2U)   /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND2 (0x4U)   /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND3 (0x8U)   /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND4 (0x10U)  /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND5 (0x20U)  /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND6 (0x40U)  /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_NAND7 (0x80U)  /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */
#define BV_APBH_CTRL0_CLKGATE_CHANNEL_SSP (0x100U)   /*!< Bit field value for APBH_CTRL0_CLKGATE_CHANNEL:  */

/*! @brief Read current value of the APBH_CTRL0_CLKGATE_CHANNEL field. */
#define BR_APBH_CTRL0_CLKGATE_CHANNEL(x) (HW_APBH_CTRL0(x).B.CLKGATE_CHANNEL)

/*! @brief Format value for bitfield APBH_CTRL0_CLKGATE_CHANNEL. */
#define BF_APBH_CTRL0_CLKGATE_CHANNEL(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL0_CLKGATE_CHANNEL) & BM_APBH_CTRL0_CLKGATE_CHANNEL)

/*! @brief Set the CLKGATE_CHANNEL field to a new value. */
#define BW_APBH_CTRL0_CLKGATE_CHANNEL(x, v) (HW_APBH_CTRL0_WR(x, (HW_APBH_CTRL0_RD(x) & ~BM_APBH_CTRL0_CLKGATE_CHANNEL) | BF_APBH_CTRL0_CLKGATE_CHANNEL(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL0, field RSVD0[27:16] (RU)
 *
 * Reserved, always set to zero.
 */
/*@{*/
#define BP_APBH_CTRL0_RSVD0  (16U)         /*!< Bit position for APBH_CTRL0_RSVD0. */
#define BM_APBH_CTRL0_RSVD0  (0x0FFF0000U) /*!< Bit mask for APBH_CTRL0_RSVD0. */
#define BS_APBH_CTRL0_RSVD0  (12U)         /*!< Bit field size in bits for APBH_CTRL0_RSVD0. */
/*@}*/

/*!
 * @name Register APBH_CTRL0, field APB_BURST_EN[28] (RW)
 *
 * Set this bit to one to enable apb master do a continous transfers when a
 * device request a burst dma. Set to zero will treat a burst dma request as 4/8
 * individual requests.
 */
/*@{*/
#define BP_APBH_CTRL0_APB_BURST_EN (28U)   /*!< Bit position for APBH_CTRL0_APB_BURST_EN. */
#define BM_APBH_CTRL0_APB_BURST_EN (0x10000000U) /*!< Bit mask for APBH_CTRL0_APB_BURST_EN. */
#define BS_APBH_CTRL0_APB_BURST_EN (1U)    /*!< Bit field size in bits for APBH_CTRL0_APB_BURST_EN. */

/*! @brief Read current value of the APBH_CTRL0_APB_BURST_EN field. */
#define BR_APBH_CTRL0_APB_BURST_EN(x) (HW_APBH_CTRL0(x).B.APB_BURST_EN)

/*! @brief Format value for bitfield APBH_CTRL0_APB_BURST_EN. */
#define BF_APBH_CTRL0_APB_BURST_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL0_APB_BURST_EN) & BM_APBH_CTRL0_APB_BURST_EN)

/*! @brief Set the APB_BURST_EN field to a new value. */
#define BW_APBH_CTRL0_APB_BURST_EN(x, v) (HW_APBH_CTRL0_WR(x, (HW_APBH_CTRL0_RD(x) & ~BM_APBH_CTRL0_APB_BURST_EN) | BF_APBH_CTRL0_APB_BURST_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL0, field AHB_BURST8_EN[29] (RW)
 *
 * Set this bit to one (default) to enable AHB 8-beat burst. Set to zero to
 * disable 8-beat burst on AHB interface.
 */
/*@{*/
#define BP_APBH_CTRL0_AHB_BURST8_EN (29U)  /*!< Bit position for APBH_CTRL0_AHB_BURST8_EN. */
#define BM_APBH_CTRL0_AHB_BURST8_EN (0x20000000U) /*!< Bit mask for APBH_CTRL0_AHB_BURST8_EN. */
#define BS_APBH_CTRL0_AHB_BURST8_EN (1U)   /*!< Bit field size in bits for APBH_CTRL0_AHB_BURST8_EN. */

/*! @brief Read current value of the APBH_CTRL0_AHB_BURST8_EN field. */
#define BR_APBH_CTRL0_AHB_BURST8_EN(x) (HW_APBH_CTRL0(x).B.AHB_BURST8_EN)

/*! @brief Format value for bitfield APBH_CTRL0_AHB_BURST8_EN. */
#define BF_APBH_CTRL0_AHB_BURST8_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL0_AHB_BURST8_EN) & BM_APBH_CTRL0_AHB_BURST8_EN)

/*! @brief Set the AHB_BURST8_EN field to a new value. */
#define BW_APBH_CTRL0_AHB_BURST8_EN(x, v) (HW_APBH_CTRL0_WR(x, (HW_APBH_CTRL0_RD(x) & ~BM_APBH_CTRL0_AHB_BURST8_EN) | BF_APBH_CTRL0_AHB_BURST8_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL0, field CLKGATE[30] (RW)
 *
 * This bit must be set to zero for normal operation. When set to one it gates
 * off the clocks to the block.
 */
/*@{*/
#define BP_APBH_CTRL0_CLKGATE (30U)        /*!< Bit position for APBH_CTRL0_CLKGATE. */
#define BM_APBH_CTRL0_CLKGATE (0x40000000U) /*!< Bit mask for APBH_CTRL0_CLKGATE. */
#define BS_APBH_CTRL0_CLKGATE (1U)         /*!< Bit field size in bits for APBH_CTRL0_CLKGATE. */

/*! @brief Read current value of the APBH_CTRL0_CLKGATE field. */
#define BR_APBH_CTRL0_CLKGATE(x) (HW_APBH_CTRL0(x).B.CLKGATE)

/*! @brief Format value for bitfield APBH_CTRL0_CLKGATE. */
#define BF_APBH_CTRL0_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL0_CLKGATE) & BM_APBH_CTRL0_CLKGATE)

/*! @brief Set the CLKGATE field to a new value. */
#define BW_APBH_CTRL0_CLKGATE(x, v) (HW_APBH_CTRL0_WR(x, (HW_APBH_CTRL0_RD(x) & ~BM_APBH_CTRL0_CLKGATE) | BF_APBH_CTRL0_CLKGATE(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL0, field SFTRST[31] (RW)
 *
 * Set this bit to zero to enable normal APBH DMA operation. Set this bit to one
 * (default) to disable clocking with the APBH DMA and hold it in its reset
 * (lowest power) state. This bit can be turned on and then off to reset the APBH DMA
 * block to its default state.
 */
/*@{*/
#define BP_APBH_CTRL0_SFTRST (31U)         /*!< Bit position for APBH_CTRL0_SFTRST. */
#define BM_APBH_CTRL0_SFTRST (0x80000000U) /*!< Bit mask for APBH_CTRL0_SFTRST. */
#define BS_APBH_CTRL0_SFTRST (1U)          /*!< Bit field size in bits for APBH_CTRL0_SFTRST. */

/*! @brief Read current value of the APBH_CTRL0_SFTRST field. */
#define BR_APBH_CTRL0_SFTRST(x) (HW_APBH_CTRL0(x).B.SFTRST)

/*! @brief Format value for bitfield APBH_CTRL0_SFTRST. */
#define BF_APBH_CTRL0_SFTRST(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL0_SFTRST) & BM_APBH_CTRL0_SFTRST)

/*! @brief Set the SFTRST field to a new value. */
#define BW_APBH_CTRL0_SFTRST(x, v) (HW_APBH_CTRL0_WR(x, (HW_APBH_CTRL0_RD(x) & ~BM_APBH_CTRL0_SFTRST) | BF_APBH_CTRL0_SFTRST(v)))
/*@}*/




/*******************************************************************************
 * HW_APBH_CTRL1 - AHB to APBH Bridge Control and Status Register 1
 ******************************************************************************/

/*!
 * @brief HW_APBH_CTRL1 - AHB to APBH Bridge Control and Status Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The APBH CTRL one provides overall control of the interrupts generated by the
 * AHB to APBH DMA. This register contains the per channel interrupt status bits
 * and the per channel interrupt enable bits. Each channel has a dedicated
 * interrupt vector in the vectored interrupt controller. EXAMPLE BF_WR(APBH_CTRL1,
 * CH5_CMDCMPLT_IRQ, 0); // use bitfield write macro BF_APBH_CTRL1.CH5_CMDCMPLT_IRQ
 * = 0; // or, assign to register struct's bitfield
 */
typedef union _hw_apbh_ctrl1
{
    uint32_t U;
    struct _hw_apbh_ctrl1_bitfields
    {
        uint32_t CH0_CMDCMPLT_IRQ : 1; /*!< [0]  */
        uint32_t CH1_CMDCMPLT_IRQ : 1; /*!< [1]  */
        uint32_t CH2_CMDCMPLT_IRQ : 1; /*!< [2]  */
        uint32_t CH3_CMDCMPLT_IRQ : 1; /*!< [3]  */
        uint32_t CH4_CMDCMPLT_IRQ : 1; /*!< [4]  */
        uint32_t CH5_CMDCMPLT_IRQ : 1; /*!< [5]  */
        uint32_t CH6_CMDCMPLT_IRQ : 1; /*!< [6]  */
        uint32_t CH7_CMDCMPLT_IRQ : 1; /*!< [7]  */
        uint32_t CH8_CMDCMPLT_IRQ : 1; /*!< [8]  */
        uint32_t CH9_CMDCMPLT_IRQ : 1; /*!< [9]  */
        uint32_t CH10_CMDCMPLT_IRQ : 1; /*!< [10]  */
        uint32_t CH11_CMDCMPLT_IRQ : 1; /*!< [11]  */
        uint32_t CH12_CMDCMPLT_IRQ : 1; /*!< [12]  */
        uint32_t CH13_CMDCMPLT_IRQ : 1; /*!< [13]  */
        uint32_t CH14_CMDCMPLT_IRQ : 1; /*!< [14]  */
        uint32_t CH15_CMDCMPLT_IRQ : 1; /*!< [15]  */
        uint32_t CH0_CMDCMPLT_IRQ_EN : 1; /*!< [16]  */
        uint32_t CH1_CMDCMPLT_IRQ_EN : 1; /*!< [17]  */
        uint32_t CH2_CMDCMPLT_IRQ_EN : 1; /*!< [18]  */
        uint32_t CH3_CMDCMPLT_IRQ_EN : 1; /*!< [19]  */
        uint32_t CH4_CMDCMPLT_IRQ_EN : 1; /*!< [20]  */
        uint32_t CH5_CMDCMPLT_IRQ_EN : 1; /*!< [21]  */
        uint32_t CH6_CMDCMPLT_IRQ_EN : 1; /*!< [22]  */
        uint32_t CH7_CMDCMPLT_IRQ_EN : 1; /*!< [23]  */
        uint32_t CH8_CMDCMPLT_IRQ_EN : 1; /*!< [24]  */
        uint32_t CH9_CMDCMPLT_IRQ_EN : 1; /*!< [25]  */
        uint32_t CH10_CMDCMPLT_IRQ_EN : 1; /*!< [26]  */
        uint32_t CH11_CMDCMPLT_IRQ_EN : 1; /*!< [27]  */
        uint32_t CH12_CMDCMPLT_IRQ_EN : 1; /*!< [28]  */
        uint32_t CH13_CMDCMPLT_IRQ_EN : 1; /*!< [29]  */
        uint32_t CH14_CMDCMPLT_IRQ_EN : 1; /*!< [30]  */
        uint32_t CH15_CMDCMPLT_IRQ_EN : 1; /*!< [31]  */
    } B;
} hw_apbh_ctrl1_t;

/*!
 * @name Constants and macros for entire APBH_CTRL1 register
 */
/*@{*/
#define HW_APBH_CTRL1_ADDR(x)    ((uintptr_t)(x) + 0x10U)
#define HW_APBH_CTRL1_SET_ADDR(x) (HW_APBH_CTRL1_ADDR(x) + 0x4U)
#define HW_APBH_CTRL1_CLR_ADDR(x) (HW_APBH_CTRL1_ADDR(x) + 0x8U)
#define HW_APBH_CTRL1_TOG_ADDR(x) (HW_APBH_CTRL1_ADDR(x) + 0xCU)

#define HW_APBH_CTRL1(x)         (*(__IO hw_apbh_ctrl1_t *) HW_APBH_CTRL1_ADDR(x))
#define HW_APBH_CTRL1_RD(x)      (HW_APBH_CTRL1(x).U)
#define HW_APBH_CTRL1_WR(x, v)   (HW_APBH_CTRL1(x).U = (v))
#define HW_APBH_CTRL1_SET(x, v)  ((*(uint32_t *) HW_APBH_CTRL1_SET_ADDR(x)) = (v))
#define HW_APBH_CTRL1_CLR(x, v)  ((*(uint32_t *) HW_APBH_CTRL1_CLR_ADDR(x)) = (v))
#define HW_APBH_CTRL1_TOG(x, v)  ((*(uint32_t *) HW_APBH_CTRL1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual APBH_CTRL1 bitfields
 */

/*!
 * @name Register APBH_CTRL1, field CH0_CMDCMPLT_IRQ[0] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 0. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH0_CMDCMPLT_IRQ (0U) /*!< Bit position for APBH_CTRL1_CH0_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ (0x00000001U) /*!< Bit mask for APBH_CTRL1_CH0_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH0_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH0_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH0_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH0_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH0_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH0_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH0_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH0_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ)

/*! @brief Set the CH0_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH0_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH0_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH1_CMDCMPLT_IRQ[1] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 1. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH1_CMDCMPLT_IRQ (1U) /*!< Bit position for APBH_CTRL1_CH1_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ (0x00000002U) /*!< Bit mask for APBH_CTRL1_CH1_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH1_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH1_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH1_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH1_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH1_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH1_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH1_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH1_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ)

/*! @brief Set the CH1_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH1_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH1_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH2_CMDCMPLT_IRQ[2] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 2. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH2_CMDCMPLT_IRQ (2U) /*!< Bit position for APBH_CTRL1_CH2_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ (0x00000004U) /*!< Bit mask for APBH_CTRL1_CH2_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH2_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH2_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH2_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH2_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH2_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH2_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH2_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH2_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ)

/*! @brief Set the CH2_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH2_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH2_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH3_CMDCMPLT_IRQ[3] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 3. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH3_CMDCMPLT_IRQ (3U) /*!< Bit position for APBH_CTRL1_CH3_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ (0x00000008U) /*!< Bit mask for APBH_CTRL1_CH3_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH3_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH3_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH3_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH3_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH3_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH3_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH3_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH3_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ)

/*! @brief Set the CH3_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH3_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH3_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH4_CMDCMPLT_IRQ[4] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 4. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH4_CMDCMPLT_IRQ (4U) /*!< Bit position for APBH_CTRL1_CH4_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ (0x00000010U) /*!< Bit mask for APBH_CTRL1_CH4_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH4_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH4_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH4_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH4_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH4_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH4_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH4_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH4_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ)

/*! @brief Set the CH4_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH4_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH4_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH5_CMDCMPLT_IRQ[5] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 5. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH5_CMDCMPLT_IRQ (5U) /*!< Bit position for APBH_CTRL1_CH5_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ (0x00000020U) /*!< Bit mask for APBH_CTRL1_CH5_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH5_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH5_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH5_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH5_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH5_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH5_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH5_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH5_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ)

/*! @brief Set the CH5_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH5_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH5_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH6_CMDCMPLT_IRQ[6] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 6. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH6_CMDCMPLT_IRQ (6U) /*!< Bit position for APBH_CTRL1_CH6_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ (0x00000040U) /*!< Bit mask for APBH_CTRL1_CH6_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH6_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH6_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH6_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH6_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH6_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH6_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH6_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH6_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ)

/*! @brief Set the CH6_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH6_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH6_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH7_CMDCMPLT_IRQ[7] (RW)
 *
 * Interrupt request status bit for APBH DMA channel 7. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH7_CMDCMPLT_IRQ (7U) /*!< Bit position for APBH_CTRL1_CH7_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ (0x00000080U) /*!< Bit mask for APBH_CTRL1_CH7_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH7_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH7_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH7_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH7_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH7_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH7_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH7_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH7_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ)

/*! @brief Set the CH7_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH7_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH7_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH8_CMDCMPLT_IRQ[8] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 8. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH8_CMDCMPLT_IRQ (8U) /*!< Bit position for APBH_CTRL1_CH8_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ (0x00000100U) /*!< Bit mask for APBH_CTRL1_CH8_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH8_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH8_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH8_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH8_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH8_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH8_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH8_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH8_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ)

/*! @brief Set the CH8_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH8_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH8_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH9_CMDCMPLT_IRQ[9] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 9. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH9_CMDCMPLT_IRQ (9U) /*!< Bit position for APBH_CTRL1_CH9_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ (0x00000200U) /*!< Bit mask for APBH_CTRL1_CH9_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH9_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH9_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH9_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH9_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH9_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH9_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH9_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH9_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ)

/*! @brief Set the CH9_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH9_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH9_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH10_CMDCMPLT_IRQ[10] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 10. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH10_CMDCMPLT_IRQ (10U) /*!< Bit position for APBH_CTRL1_CH10_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ (0x00000400U) /*!< Bit mask for APBH_CTRL1_CH10_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH10_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH10_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH10_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH10_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH10_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH10_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH10_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH10_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ)

/*! @brief Set the CH10_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH10_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH10_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH11_CMDCMPLT_IRQ[11] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 11. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH11_CMDCMPLT_IRQ (11U) /*!< Bit position for APBH_CTRL1_CH11_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ (0x00000800U) /*!< Bit mask for APBH_CTRL1_CH11_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH11_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH11_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH11_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH11_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH11_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH11_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH11_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH11_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ)

/*! @brief Set the CH11_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH11_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH11_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH12_CMDCMPLT_IRQ[12] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 12. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH12_CMDCMPLT_IRQ (12U) /*!< Bit position for APBH_CTRL1_CH12_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ (0x00001000U) /*!< Bit mask for APBH_CTRL1_CH12_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH12_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH12_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH12_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH12_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH12_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH12_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH12_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH12_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ)

/*! @brief Set the CH12_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH12_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH12_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH13_CMDCMPLT_IRQ[13] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 13. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH13_CMDCMPLT_IRQ (13U) /*!< Bit position for APBH_CTRL1_CH13_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ (0x00002000U) /*!< Bit mask for APBH_CTRL1_CH13_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH13_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH13_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH13_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH13_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH13_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH13_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH13_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH13_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ)

/*! @brief Set the CH13_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH13_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH13_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH14_CMDCMPLT_IRQ[14] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 14. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH14_CMDCMPLT_IRQ (14U) /*!< Bit position for APBH_CTRL1_CH14_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ (0x00004000U) /*!< Bit mask for APBH_CTRL1_CH14_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH14_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH14_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH14_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH14_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH14_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH14_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH14_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH14_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ)

/*! @brief Set the CH14_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH14_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH14_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH15_CMDCMPLT_IRQ[15] (RW)
 *
 * Interrupt request status bit for APBH DMA Channel 15. This sticky bit is set
 * by DMA hardware and reset by software. It is ANDed with its corresponding
 * enable bit to generate an interrupt.
 */
/*@{*/
#define BP_APBH_CTRL1_CH15_CMDCMPLT_IRQ (15U) /*!< Bit position for APBH_CTRL1_CH15_CMDCMPLT_IRQ. */
#define BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ (0x00008000U) /*!< Bit mask for APBH_CTRL1_CH15_CMDCMPLT_IRQ. */
#define BS_APBH_CTRL1_CH15_CMDCMPLT_IRQ (1U) /*!< Bit field size in bits for APBH_CTRL1_CH15_CMDCMPLT_IRQ. */

/*! @brief Read current value of the APBH_CTRL1_CH15_CMDCMPLT_IRQ field. */
#define BR_APBH_CTRL1_CH15_CMDCMPLT_IRQ(x) (HW_APBH_CTRL1(x).B.CH15_CMDCMPLT_IRQ)

/*! @brief Format value for bitfield APBH_CTRL1_CH15_CMDCMPLT_IRQ. */
#define BF_APBH_CTRL1_CH15_CMDCMPLT_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH15_CMDCMPLT_IRQ) & BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ)

/*! @brief Set the CH15_CMDCMPLT_IRQ field to a new value. */
#define BW_APBH_CTRL1_CH15_CMDCMPLT_IRQ(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ) | BF_APBH_CTRL1_CH15_CMDCMPLT_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH0_CMDCMPLT_IRQ_EN[16] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 0.
 */
/*@{*/
#define BP_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN (16U) /*!< Bit position for APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN (0x00010000U) /*!< Bit mask for APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH0_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH0_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH0_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH1_CMDCMPLT_IRQ_EN[17] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 1.
 */
/*@{*/
#define BP_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN (17U) /*!< Bit position for APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN (0x00020000U) /*!< Bit mask for APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH1_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH1_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH1_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH2_CMDCMPLT_IRQ_EN[18] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 2.
 */
/*@{*/
#define BP_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN (18U) /*!< Bit position for APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN (0x00040000U) /*!< Bit mask for APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH2_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH2_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH2_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH3_CMDCMPLT_IRQ_EN[19] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 3.
 */
/*@{*/
#define BP_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN (19U) /*!< Bit position for APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN (0x00080000U) /*!< Bit mask for APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH3_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH3_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH3_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH4_CMDCMPLT_IRQ_EN[20] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 4.
 */
/*@{*/
#define BP_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN (20U) /*!< Bit position for APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN (0x00100000U) /*!< Bit mask for APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH4_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH4_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH4_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH5_CMDCMPLT_IRQ_EN[21] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 5.
 */
/*@{*/
#define BP_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN (21U) /*!< Bit position for APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN (0x00200000U) /*!< Bit mask for APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH5_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH5_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH5_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH6_CMDCMPLT_IRQ_EN[22] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 6.
 */
/*@{*/
#define BP_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN (22U) /*!< Bit position for APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN (0x00400000U) /*!< Bit mask for APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH6_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH6_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH6_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH7_CMDCMPLT_IRQ_EN[23] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 7.
 */
/*@{*/
#define BP_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN (23U) /*!< Bit position for APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN (0x00800000U) /*!< Bit mask for APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH7_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH7_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH7_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH8_CMDCMPLT_IRQ_EN[24] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 8.
 */
/*@{*/
#define BP_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN (24U) /*!< Bit position for APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN (0x01000000U) /*!< Bit mask for APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH8_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH8_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH8_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH9_CMDCMPLT_IRQ_EN[25] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 9.
 */
/*@{*/
#define BP_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN (25U) /*!< Bit position for APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN (0x02000000U) /*!< Bit mask for APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH9_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH9_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH9_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH10_CMDCMPLT_IRQ_EN[26] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 10.
 */
/*@{*/
#define BP_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN (26U) /*!< Bit position for APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN (0x04000000U) /*!< Bit mask for APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH10_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH10_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH10_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH11_CMDCMPLT_IRQ_EN[27] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 11.
 */
/*@{*/
#define BP_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN (27U) /*!< Bit position for APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN (0x08000000U) /*!< Bit mask for APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH11_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH11_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH11_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH12_CMDCMPLT_IRQ_EN[28] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 12.
 */
/*@{*/
#define BP_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN (28U) /*!< Bit position for APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN (0x10000000U) /*!< Bit mask for APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH12_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH12_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH12_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH13_CMDCMPLT_IRQ_EN[29] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 13.
 */
/*@{*/
#define BP_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN (29U) /*!< Bit position for APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN (0x20000000U) /*!< Bit mask for APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH13_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH13_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH13_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH14_CMDCMPLT_IRQ_EN[30] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 14.
 */
/*@{*/
#define BP_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN (30U) /*!< Bit position for APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN (0x40000000U) /*!< Bit mask for APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH14_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH14_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH14_CMDCMPLT_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL1, field CH15_CMDCMPLT_IRQ_EN[31] (RW)
 *
 * Setting this bit enables the generation of an interrupt request for APBH DMA
 * channel 15.
 */
/*@{*/
#define BP_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN (31U) /*!< Bit position for APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN. */
#define BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN (0x80000000U) /*!< Bit mask for APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN. */
#define BS_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN (1U) /*!< Bit field size in bits for APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN. */

/*! @brief Read current value of the APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN field. */
#define BR_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(x) (HW_APBH_CTRL1(x).B.CH15_CMDCMPLT_IRQ_EN)

/*! @brief Format value for bitfield APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN. */
#define BF_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN) & BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN)

/*! @brief Set the CH15_CMDCMPLT_IRQ_EN field to a new value. */
#define BW_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(x, v) (HW_APBH_CTRL1_WR(x, (HW_APBH_CTRL1_RD(x) & ~BM_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN) | BF_APBH_CTRL1_CH15_CMDCMPLT_IRQ_EN(v)))
/*@}*/




/*******************************************************************************
 * HW_APBH_CTRL2 - AHB to APBH Bridge Control and Status Register 2
 ******************************************************************************/

/*!
 * @brief HW_APBH_CTRL2 - AHB to APBH Bridge Control and Status Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The APBH CTRL 2 provides channel error interrupts generated by the AHB to
 * APBH DMA. This register contains the per channel interrupt status bits and the
 * per channel interrupt enable bits. Each channel has a dedicated interrupt vector
 * in the vectored interrupt controller. EXAMPLE BF_WR(APBH_CTRL1,
 * CH5_CMDCMPLT_IRQ, 0); // use bitfield write macro BF_APBH_CTRL1.CH5_CMDCMPLT_IRQ = 0; //
 * or, assign to register struct's bitfield
 */
typedef union _hw_apbh_ctrl2
{
    uint32_t U;
    struct _hw_apbh_ctrl2_bitfields
    {
        uint32_t CH0_ERROR_IRQ : 1;    /*!< [0]  */
        uint32_t CH1_ERROR_IRQ : 1;    /*!< [1]  */
        uint32_t CH2_ERROR_IRQ : 1;    /*!< [2]  */
        uint32_t CH3_ERROR_IRQ : 1;    /*!< [3]  */
        uint32_t CH4_ERROR_IRQ : 1;    /*!< [4]  */
        uint32_t CH5_ERROR_IRQ : 1;    /*!< [5]  */
        uint32_t CH6_ERROR_IRQ : 1;    /*!< [6]  */
        uint32_t CH7_ERROR_IRQ : 1;    /*!< [7]  */
        uint32_t CH8_ERROR_IRQ : 1;    /*!< [8]  */
        uint32_t CH9_ERROR_IRQ : 1;    /*!< [9]  */
        uint32_t CH10_ERROR_IRQ : 1;   /*!< [10]  */
        uint32_t CH11_ERROR_IRQ : 1;   /*!< [11]  */
        uint32_t CH12_ERROR_IRQ : 1;   /*!< [12]  */
        uint32_t CH13_ERROR_IRQ : 1;   /*!< [13]  */
        uint32_t CH14_ERROR_IRQ : 1;   /*!< [14]  */
        uint32_t CH15_ERROR_IRQ : 1;   /*!< [15]  */
        uint32_t CH0_ERROR_STATUS : 1; /*!< [16]  */
        uint32_t CH1_ERROR_STATUS : 1; /*!< [17]  */
        uint32_t CH2_ERROR_STATUS : 1; /*!< [18]  */
        uint32_t CH3_ERROR_STATUS : 1; /*!< [19]  */
        uint32_t CH4_ERROR_STATUS : 1; /*!< [20]  */
        uint32_t CH5_ERROR_STATUS : 1; /*!< [21]  */
        uint32_t CH6_ERROR_STATUS : 1; /*!< [22]  */
        uint32_t CH7_ERROR_STATUS : 1; /*!< [23]  */
        uint32_t CH8_ERROR_STATUS : 1; /*!< [24]  */
        uint32_t CH9_ERROR_STATUS : 1; /*!< [25]  */
        uint32_t CH10_ERROR_STATUS : 1; /*!< [26]  */
        uint32_t CH11_ERROR_STATUS : 1; /*!< [27]  */
        uint32_t CH12_ERROR_STATUS : 1; /*!< [28]  */
        uint32_t CH13_ERROR_STATUS : 1; /*!< [29]  */
        uint32_t CH14_ERROR_STATUS : 1; /*!< [30]  */
        uint32_t CH15_ERROR_STATUS : 1; /*!< [31]  */
    } B;
} hw_apbh_ctrl2_t;

/*!
 * @name Constants and macros for entire APBH_CTRL2 register
 */
/*@{*/
#define HW_APBH_CTRL2_ADDR(x)    ((uintptr_t)(x) + 0x20U)
#define HW_APBH_CTRL2_SET_ADDR(x) (HW_APBH_CTRL2_ADDR(x) + 0x4U)
#define HW_APBH_CTRL2_CLR_ADDR(x) (HW_APBH_CTRL2_ADDR(x) + 0x8U)
#define HW_APBH_CTRL2_TOG_ADDR(x) (HW_APBH_CTRL2_ADDR(x) + 0xCU)

#define HW_APBH_CTRL2(x)         (*(__IO hw_apbh_ctrl2_t *) HW_APBH_CTRL2_ADDR(x))
#define HW_APBH_CTRL2_RD(x)      (HW_APBH_CTRL2(x).U)
#define HW_APBH_CTRL2_WR(x, v)   (HW_APBH_CTRL2(x).U = (v))
#define HW_APBH_CTRL2_SET(x, v)  ((*(uint32_t *) HW_APBH_CTRL2_SET_ADDR(x)) = (v))
#define HW_APBH_CTRL2_CLR(x, v)  ((*(uint32_t *) HW_APBH_CTRL2_CLR_ADDR(x)) = (v))
#define HW_APBH_CTRL2_TOG(x, v)  ((*(uint32_t *) HW_APBH_CTRL2_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual APBH_CTRL2 bitfields
 */

/*!
 * @name Register APBH_CTRL2, field CH0_ERROR_IRQ[0] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 0. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH0_ERROR_IRQ (0U)   /*!< Bit position for APBH_CTRL2_CH0_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH0_ERROR_IRQ (0x00000001U) /*!< Bit mask for APBH_CTRL2_CH0_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH0_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH0_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH0_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH0_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH0_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH0_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH0_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH0_ERROR_IRQ) & BM_APBH_CTRL2_CH0_ERROR_IRQ)

/*! @brief Set the CH0_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH0_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH0_ERROR_IRQ) | BF_APBH_CTRL2_CH0_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH1_ERROR_IRQ[1] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 1. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH1_ERROR_IRQ (1U)   /*!< Bit position for APBH_CTRL2_CH1_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH1_ERROR_IRQ (0x00000002U) /*!< Bit mask for APBH_CTRL2_CH1_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH1_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH1_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH1_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH1_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH1_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH1_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH1_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH1_ERROR_IRQ) & BM_APBH_CTRL2_CH1_ERROR_IRQ)

/*! @brief Set the CH1_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH1_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH1_ERROR_IRQ) | BF_APBH_CTRL2_CH1_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH2_ERROR_IRQ[2] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 2. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH2_ERROR_IRQ (2U)   /*!< Bit position for APBH_CTRL2_CH2_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH2_ERROR_IRQ (0x00000004U) /*!< Bit mask for APBH_CTRL2_CH2_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH2_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH2_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH2_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH2_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH2_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH2_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH2_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH2_ERROR_IRQ) & BM_APBH_CTRL2_CH2_ERROR_IRQ)

/*! @brief Set the CH2_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH2_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH2_ERROR_IRQ) | BF_APBH_CTRL2_CH2_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH3_ERROR_IRQ[3] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 3. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH3_ERROR_IRQ (3U)   /*!< Bit position for APBH_CTRL2_CH3_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH3_ERROR_IRQ (0x00000008U) /*!< Bit mask for APBH_CTRL2_CH3_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH3_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH3_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH3_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH3_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH3_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH3_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH3_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH3_ERROR_IRQ) & BM_APBH_CTRL2_CH3_ERROR_IRQ)

/*! @brief Set the CH3_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH3_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH3_ERROR_IRQ) | BF_APBH_CTRL2_CH3_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH4_ERROR_IRQ[4] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 4. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH4_ERROR_IRQ (4U)   /*!< Bit position for APBH_CTRL2_CH4_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH4_ERROR_IRQ (0x00000010U) /*!< Bit mask for APBH_CTRL2_CH4_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH4_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH4_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH4_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH4_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH4_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH4_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH4_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH4_ERROR_IRQ) & BM_APBH_CTRL2_CH4_ERROR_IRQ)

/*! @brief Set the CH4_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH4_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH4_ERROR_IRQ) | BF_APBH_CTRL2_CH4_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH5_ERROR_IRQ[5] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 5. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH5_ERROR_IRQ (5U)   /*!< Bit position for APBH_CTRL2_CH5_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH5_ERROR_IRQ (0x00000020U) /*!< Bit mask for APBH_CTRL2_CH5_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH5_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH5_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH5_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH5_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH5_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH5_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH5_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH5_ERROR_IRQ) & BM_APBH_CTRL2_CH5_ERROR_IRQ)

/*! @brief Set the CH5_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH5_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH5_ERROR_IRQ) | BF_APBH_CTRL2_CH5_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH6_ERROR_IRQ[6] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 6. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH6_ERROR_IRQ (6U)   /*!< Bit position for APBH_CTRL2_CH6_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH6_ERROR_IRQ (0x00000040U) /*!< Bit mask for APBH_CTRL2_CH6_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH6_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH6_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH6_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH6_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH6_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH6_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH6_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH6_ERROR_IRQ) & BM_APBH_CTRL2_CH6_ERROR_IRQ)

/*! @brief Set the CH6_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH6_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH6_ERROR_IRQ) | BF_APBH_CTRL2_CH6_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH7_ERROR_IRQ[7] (RW)
 *
 * Error interrupt status bit for APBX DMA Channel 7. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH7_ERROR_IRQ (7U)   /*!< Bit position for APBH_CTRL2_CH7_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH7_ERROR_IRQ (0x00000080U) /*!< Bit mask for APBH_CTRL2_CH7_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH7_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH7_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH7_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH7_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH7_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH7_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH7_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH7_ERROR_IRQ) & BM_APBH_CTRL2_CH7_ERROR_IRQ)

/*! @brief Set the CH7_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH7_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH7_ERROR_IRQ) | BF_APBH_CTRL2_CH7_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH8_ERROR_IRQ[8] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 8. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH8_ERROR_IRQ (8U)   /*!< Bit position for APBH_CTRL2_CH8_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH8_ERROR_IRQ (0x00000100U) /*!< Bit mask for APBH_CTRL2_CH8_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH8_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH8_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH8_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH8_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH8_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH8_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH8_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH8_ERROR_IRQ) & BM_APBH_CTRL2_CH8_ERROR_IRQ)

/*! @brief Set the CH8_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH8_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH8_ERROR_IRQ) | BF_APBH_CTRL2_CH8_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH9_ERROR_IRQ[9] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 9. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding cmdcmplt
 * irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH9_ERROR_IRQ (9U)   /*!< Bit position for APBH_CTRL2_CH9_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH9_ERROR_IRQ (0x00000200U) /*!< Bit mask for APBH_CTRL2_CH9_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH9_ERROR_IRQ (1U)   /*!< Bit field size in bits for APBH_CTRL2_CH9_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH9_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH9_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH9_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH9_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH9_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH9_ERROR_IRQ) & BM_APBH_CTRL2_CH9_ERROR_IRQ)

/*! @brief Set the CH9_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH9_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH9_ERROR_IRQ) | BF_APBH_CTRL2_CH9_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH10_ERROR_IRQ[10] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 10. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH10_ERROR_IRQ (10U) /*!< Bit position for APBH_CTRL2_CH10_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH10_ERROR_IRQ (0x00000400U) /*!< Bit mask for APBH_CTRL2_CH10_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH10_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH10_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH10_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH10_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH10_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH10_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH10_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH10_ERROR_IRQ) & BM_APBH_CTRL2_CH10_ERROR_IRQ)

/*! @brief Set the CH10_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH10_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH10_ERROR_IRQ) | BF_APBH_CTRL2_CH10_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH11_ERROR_IRQ[11] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 11. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH11_ERROR_IRQ (11U) /*!< Bit position for APBH_CTRL2_CH11_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH11_ERROR_IRQ (0x00000800U) /*!< Bit mask for APBH_CTRL2_CH11_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH11_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH11_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH11_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH11_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH11_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH11_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH11_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH11_ERROR_IRQ) & BM_APBH_CTRL2_CH11_ERROR_IRQ)

/*! @brief Set the CH11_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH11_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH11_ERROR_IRQ) | BF_APBH_CTRL2_CH11_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH12_ERROR_IRQ[12] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 12. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH12_ERROR_IRQ (12U) /*!< Bit position for APBH_CTRL2_CH12_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH12_ERROR_IRQ (0x00001000U) /*!< Bit mask for APBH_CTRL2_CH12_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH12_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH12_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH12_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH12_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH12_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH12_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH12_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH12_ERROR_IRQ) & BM_APBH_CTRL2_CH12_ERROR_IRQ)

/*! @brief Set the CH12_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH12_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH12_ERROR_IRQ) | BF_APBH_CTRL2_CH12_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH13_ERROR_IRQ[13] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 13. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH13_ERROR_IRQ (13U) /*!< Bit position for APBH_CTRL2_CH13_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH13_ERROR_IRQ (0x00002000U) /*!< Bit mask for APBH_CTRL2_CH13_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH13_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH13_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH13_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH13_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH13_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH13_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH13_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH13_ERROR_IRQ) & BM_APBH_CTRL2_CH13_ERROR_IRQ)

/*! @brief Set the CH13_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH13_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH13_ERROR_IRQ) | BF_APBH_CTRL2_CH13_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH14_ERROR_IRQ[14] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 14. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH14_ERROR_IRQ (14U) /*!< Bit position for APBH_CTRL2_CH14_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH14_ERROR_IRQ (0x00004000U) /*!< Bit mask for APBH_CTRL2_CH14_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH14_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH14_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH14_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH14_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH14_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH14_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH14_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH14_ERROR_IRQ) & BM_APBH_CTRL2_CH14_ERROR_IRQ)

/*! @brief Set the CH14_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH14_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH14_ERROR_IRQ) | BF_APBH_CTRL2_CH14_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH15_ERROR_IRQ[15] (RW)
 *
 * Error interrupt status bit for APBH DMA Channel 15. This sticky bit is set by
 * DMA hardware and reset by software. It is ORed with the corresponding
 * cmdcmplt irq to generate an irq to ARM.
 */
/*@{*/
#define BP_APBH_CTRL2_CH15_ERROR_IRQ (15U) /*!< Bit position for APBH_CTRL2_CH15_ERROR_IRQ. */
#define BM_APBH_CTRL2_CH15_ERROR_IRQ (0x00008000U) /*!< Bit mask for APBH_CTRL2_CH15_ERROR_IRQ. */
#define BS_APBH_CTRL2_CH15_ERROR_IRQ (1U)  /*!< Bit field size in bits for APBH_CTRL2_CH15_ERROR_IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH15_ERROR_IRQ field. */
#define BR_APBH_CTRL2_CH15_ERROR_IRQ(x) (HW_APBH_CTRL2(x).B.CH15_ERROR_IRQ)

/*! @brief Format value for bitfield APBH_CTRL2_CH15_ERROR_IRQ. */
#define BF_APBH_CTRL2_CH15_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CTRL2_CH15_ERROR_IRQ) & BM_APBH_CTRL2_CH15_ERROR_IRQ)

/*! @brief Set the CH15_ERROR_IRQ field to a new value. */
#define BW_APBH_CTRL2_CH15_ERROR_IRQ(x, v) (HW_APBH_CTRL2_WR(x, (HW_APBH_CTRL2_RD(x) & ~BM_APBH_CTRL2_CH15_ERROR_IRQ) | BF_APBH_CTRL2_CH15_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH0_ERROR_STATUS[16] (RO)
 *
 * Error status bit for APBX DMA Channel 0. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH0_ERROR_STATUS (16U) /*!< Bit position for APBH_CTRL2_CH0_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH0_ERROR_STATUS (0x00010000U) /*!< Bit mask for APBH_CTRL2_CH0_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH0_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH0_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH0_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH0_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH0_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH0_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH0_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH0_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH0_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH1_ERROR_STATUS[17] (RO)
 *
 * Error status bit for APBX DMA Channel 1. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH1_ERROR_STATUS (17U) /*!< Bit position for APBH_CTRL2_CH1_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH1_ERROR_STATUS (0x00020000U) /*!< Bit mask for APBH_CTRL2_CH1_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH1_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH1_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH1_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH1_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH1_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH1_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH1_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH1_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH1_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH2_ERROR_STATUS[18] (RO)
 *
 * Error status bit for APBX DMA Channel 2. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH2_ERROR_STATUS (18U) /*!< Bit position for APBH_CTRL2_CH2_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH2_ERROR_STATUS (0x00040000U) /*!< Bit mask for APBH_CTRL2_CH2_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH2_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH2_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH2_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH2_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH2_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH2_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH2_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH2_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH2_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH3_ERROR_STATUS[19] (RO)
 *
 * Error status bit for APBX DMA Channel 3. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH3_ERROR_STATUS (19U) /*!< Bit position for APBH_CTRL2_CH3_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH3_ERROR_STATUS (0x00080000U) /*!< Bit mask for APBH_CTRL2_CH3_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH3_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH3_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH3_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH3_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH3_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH3_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH3_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH3_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH3_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH4_ERROR_STATUS[20] (RO)
 *
 * Error status bit for APBX DMA Channel 4. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH4_ERROR_STATUS (20U) /*!< Bit position for APBH_CTRL2_CH4_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH4_ERROR_STATUS (0x00100000U) /*!< Bit mask for APBH_CTRL2_CH4_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH4_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH4_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH4_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH4_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH4_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH4_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH4_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH4_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH4_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH5_ERROR_STATUS[21] (RO)
 *
 * Error status bit for APBX DMA Channel 5. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH5_ERROR_STATUS (21U) /*!< Bit position for APBH_CTRL2_CH5_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH5_ERROR_STATUS (0x00200000U) /*!< Bit mask for APBH_CTRL2_CH5_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH5_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH5_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH5_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH5_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH5_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH5_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH5_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH5_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH5_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH6_ERROR_STATUS[22] (RO)
 *
 * Error status bit for APBX DMA Channel 6. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH6_ERROR_STATUS (22U) /*!< Bit position for APBH_CTRL2_CH6_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH6_ERROR_STATUS (0x00400000U) /*!< Bit mask for APBH_CTRL2_CH6_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH6_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH6_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH6_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH6_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH6_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH6_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH6_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH6_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH6_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH7_ERROR_STATUS[23] (RO)
 *
 * Error status bit for APBX DMA Channel 7. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH7_ERROR_STATUS (23U) /*!< Bit position for APBH_CTRL2_CH7_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH7_ERROR_STATUS (0x00800000U) /*!< Bit mask for APBH_CTRL2_CH7_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH7_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH7_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH7_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH7_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH7_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH7_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH7_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH7_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH7_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH8_ERROR_STATUS[24] (RO)
 *
 * Error status bit for APBH DMA Channel 8. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH8_ERROR_STATUS (24U) /*!< Bit position for APBH_CTRL2_CH8_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH8_ERROR_STATUS (0x01000000U) /*!< Bit mask for APBH_CTRL2_CH8_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH8_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH8_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH8_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH8_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH8_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH8_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH8_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH8_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH8_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH9_ERROR_STATUS[25] (RO)
 *
 * Error status bit for APBH DMA Channel 9. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH9_ERROR_STATUS (25U) /*!< Bit position for APBH_CTRL2_CH9_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH9_ERROR_STATUS (0x02000000U) /*!< Bit mask for APBH_CTRL2_CH9_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH9_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH9_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH9_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH9_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH9_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH9_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH9_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH9_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH9_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH10_ERROR_STATUS[26] (RO)
 *
 * Error status bit for APBH DMA Channel 10. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH10_ERROR_STATUS (26U) /*!< Bit position for APBH_CTRL2_CH10_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH10_ERROR_STATUS (0x04000000U) /*!< Bit mask for APBH_CTRL2_CH10_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH10_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH10_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH10_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH10_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH10_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH10_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH10_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH10_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH10_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH11_ERROR_STATUS[27] (RO)
 *
 * Error status bit for APBH DMA Channel 11. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH11_ERROR_STATUS (27U) /*!< Bit position for APBH_CTRL2_CH11_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH11_ERROR_STATUS (0x08000000U) /*!< Bit mask for APBH_CTRL2_CH11_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH11_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH11_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH11_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH11_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH11_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH11_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH11_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH11_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH11_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH12_ERROR_STATUS[28] (RO)
 *
 * Error status bit for APBH DMA Channel 12. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH12_ERROR_STATUS (28U) /*!< Bit position for APBH_CTRL2_CH12_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH12_ERROR_STATUS (0x10000000U) /*!< Bit mask for APBH_CTRL2_CH12_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH12_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH12_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH12_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH12_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH12_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH12_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH12_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH12_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH12_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH13_ERROR_STATUS[29] (RO)
 *
 * Error status bit for APBH DMA Channel 13. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH13_ERROR_STATUS (29U) /*!< Bit position for APBH_CTRL2_CH13_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH13_ERROR_STATUS (0x20000000U) /*!< Bit mask for APBH_CTRL2_CH13_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH13_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH13_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH13_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH13_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH13_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH13_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH13_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH13_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH13_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH14_ERROR_STATUS[30] (RO)
 *
 * Error status bit for APBH DMA Channel 14. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH14_ERROR_STATUS (30U) /*!< Bit position for APBH_CTRL2_CH14_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH14_ERROR_STATUS (0x40000000U) /*!< Bit mask for APBH_CTRL2_CH14_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH14_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH14_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH14_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH14_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH14_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH14_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH14_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH14_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH14_ERROR_STATUS)
/*@}*/

/*!
 * @name Register APBH_CTRL2, field CH15_ERROR_STATUS[31] (RO)
 *
 * Error status bit for APBH DMA Channel 15. Valid when corresponding Error IRQ
 * is set. 1 - AHB bus error 0 - channel early termination.
 *
 * Values:
 * - 0 - An early termination from the device causes error IRQ.
 * - 1 - An AHB bus error causes error IRQ.
 */
/*@{*/
#define BP_APBH_CTRL2_CH15_ERROR_STATUS (31U) /*!< Bit position for APBH_CTRL2_CH15_ERROR_STATUS. */
#define BM_APBH_CTRL2_CH15_ERROR_STATUS (0x80000000U) /*!< Bit mask for APBH_CTRL2_CH15_ERROR_STATUS. */
#define BS_APBH_CTRL2_CH15_ERROR_STATUS (1U) /*!< Bit field size in bits for APBH_CTRL2_CH15_ERROR_STATUS. */

#define BV_APBH_CTRL2_CH15_ERROR_STATUS_TERMINATION (0U) /*!< Bit field value for APBH_CTRL2_CH15_ERROR_STATUS: An early termination from the device causes error IRQ. */
#define BV_APBH_CTRL2_CH15_ERROR_STATUS_BUS_ERROR (0x1U) /*!< Bit field value for APBH_CTRL2_CH15_ERROR_STATUS: An AHB bus error causes error IRQ. */

/*! @brief Read current value of the APBH_CTRL2_CH15_ERROR_STATUS field. */
#define BR_APBH_CTRL2_CH15_ERROR_STATUS(x) (HW_APBH_CTRL2(x).B.CH15_ERROR_STATUS)
/*@}*/




/*******************************************************************************
 * HW_APBH_CHANNEL_CTRL - AHB to APBH Bridge Channel Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHANNEL_CTRL - AHB to APBH Bridge Channel Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The APBH CHANNEL CTRL provides reset/freeze control of each DMA channel. This
 * register contains individual channel reset/freeze bits.
 */
typedef union _hw_apbh_channel_ctrl
{
    uint32_t U;
    struct _hw_apbh_channel_ctrl_bitfields
    {
        uint32_t FREEZE_CHANNEL : 16;  /*!< [15:0]  */
        uint32_t RESET_CHANNEL : 16;   /*!< [31:16]  */
    } B;
} hw_apbh_channel_ctrl_t;

/*!
 * @name Constants and macros for entire APBH_CHANNEL_CTRL register
 */
/*@{*/
#define HW_APBH_CHANNEL_CTRL_ADDR(x) ((uintptr_t)(x) + 0x30U)
#define HW_APBH_CHANNEL_CTRL_SET_ADDR(x) (HW_APBH_CHANNEL_CTRL_ADDR(x) + 0x4U)
#define HW_APBH_CHANNEL_CTRL_CLR_ADDR(x) (HW_APBH_CHANNEL_CTRL_ADDR(x) + 0x8U)
#define HW_APBH_CHANNEL_CTRL_TOG_ADDR(x) (HW_APBH_CHANNEL_CTRL_ADDR(x) + 0xCU)

#define HW_APBH_CHANNEL_CTRL(x)  (*(__IO hw_apbh_channel_ctrl_t *) HW_APBH_CHANNEL_CTRL_ADDR(x))
#define HW_APBH_CHANNEL_CTRL_RD(x) (HW_APBH_CHANNEL_CTRL(x).U)
#define HW_APBH_CHANNEL_CTRL_WR(x, v) (HW_APBH_CHANNEL_CTRL(x).U = (v))
#define HW_APBH_CHANNEL_CTRL_SET(x, v) ((*(uint32_t *) HW_APBH_CHANNEL_CTRL_SET_ADDR(x)) = (v))
#define HW_APBH_CHANNEL_CTRL_CLR(x, v) ((*(uint32_t *) HW_APBH_CHANNEL_CTRL_CLR_ADDR(x)) = (v))
#define HW_APBH_CHANNEL_CTRL_TOG(x, v) ((*(uint32_t *) HW_APBH_CHANNEL_CTRL_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual APBH_CHANNEL_CTRL bitfields
 */

/*!
 * @name Register APBH_CHANNEL_CTRL, field FREEZE_CHANNEL[15:0] (RW)
 *
 * Setting a bit in this field will freeze the DMA channel associated with it.
 * This field is a direct input to the DMA channel arbiter. When frozen, the
 * channel is deined access to the central DMA resources.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 * - 10000 -
 * - 100000 -
 * - 1000000 -
 * - 10000000 -
 * - 100000000 -
 */
/*@{*/
#define BP_APBH_CHANNEL_CTRL_FREEZE_CHANNEL (0U) /*!< Bit position for APBH_CHANNEL_CTRL_FREEZE_CHANNEL. */
#define BM_APBH_CHANNEL_CTRL_FREEZE_CHANNEL (0x0000FFFFU) /*!< Bit mask for APBH_CHANNEL_CTRL_FREEZE_CHANNEL. */
#define BS_APBH_CHANNEL_CTRL_FREEZE_CHANNEL (16U) /*!< Bit field size in bits for APBH_CHANNEL_CTRL_FREEZE_CHANNEL. */

#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND0 (0x1U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND1 (0x2U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND2 (0x4U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND3 (0x8U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND4 (0x10U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND5 (0x20U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND6 (0x40U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_NAND7 (0x80U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_FREEZE_CHANNEL_SSP (0x100U) /*!< Bit field value for APBH_CHANNEL_CTRL_FREEZE_CHANNEL:  */

/*! @brief Read current value of the APBH_CHANNEL_CTRL_FREEZE_CHANNEL field. */
#define BR_APBH_CHANNEL_CTRL_FREEZE_CHANNEL(x) (HW_APBH_CHANNEL_CTRL(x).B.FREEZE_CHANNEL)

/*! @brief Format value for bitfield APBH_CHANNEL_CTRL_FREEZE_CHANNEL. */
#define BF_APBH_CHANNEL_CTRL_FREEZE_CHANNEL(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CHANNEL_CTRL_FREEZE_CHANNEL) & BM_APBH_CHANNEL_CTRL_FREEZE_CHANNEL)

/*! @brief Set the FREEZE_CHANNEL field to a new value. */
#define BW_APBH_CHANNEL_CTRL_FREEZE_CHANNEL(x, v) (HW_APBH_CHANNEL_CTRL_WR(x, (HW_APBH_CHANNEL_CTRL_RD(x) & ~BM_APBH_CHANNEL_CTRL_FREEZE_CHANNEL) | BF_APBH_CHANNEL_CTRL_FREEZE_CHANNEL(v)))
/*@}*/

/*!
 * @name Register APBH_CHANNEL_CTRL, field RESET_CHANNEL[31:16] (RW)
 *
 * Setting a bit in this field causes the DMA controller to take the
 * corresponding channel through its reset state. The bit is reset after the channel
 * resources are cleared.
 *
 * Values:
 * - 1 -
 * - 10 -
 * - 100 -
 * - 1000 -
 * - 10000 -
 * - 100000 -
 * - 1000000 -
 * - 10000000 -
 * - 100000000 -
 */
/*@{*/
#define BP_APBH_CHANNEL_CTRL_RESET_CHANNEL (16U) /*!< Bit position for APBH_CHANNEL_CTRL_RESET_CHANNEL. */
#define BM_APBH_CHANNEL_CTRL_RESET_CHANNEL (0xFFFF0000U) /*!< Bit mask for APBH_CHANNEL_CTRL_RESET_CHANNEL. */
#define BS_APBH_CHANNEL_CTRL_RESET_CHANNEL (16U) /*!< Bit field size in bits for APBH_CHANNEL_CTRL_RESET_CHANNEL. */

#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND0 (0x1U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND1 (0x2U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND2 (0x4U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND3 (0x8U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND4 (0x10U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND5 (0x20U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND6 (0x40U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_NAND7 (0x80U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */
#define BV_APBH_CHANNEL_CTRL_RESET_CHANNEL_SSP (0x100U) /*!< Bit field value for APBH_CHANNEL_CTRL_RESET_CHANNEL:  */

/*! @brief Read current value of the APBH_CHANNEL_CTRL_RESET_CHANNEL field. */
#define BR_APBH_CHANNEL_CTRL_RESET_CHANNEL(x) (HW_APBH_CHANNEL_CTRL(x).B.RESET_CHANNEL)

/*! @brief Format value for bitfield APBH_CHANNEL_CTRL_RESET_CHANNEL. */
#define BF_APBH_CHANNEL_CTRL_RESET_CHANNEL(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CHANNEL_CTRL_RESET_CHANNEL) & BM_APBH_CHANNEL_CTRL_RESET_CHANNEL)

/*! @brief Set the RESET_CHANNEL field to a new value. */
#define BW_APBH_CHANNEL_CTRL_RESET_CHANNEL(x, v) (HW_APBH_CHANNEL_CTRL_WR(x, (HW_APBH_CHANNEL_CTRL_RD(x) & ~BM_APBH_CHANNEL_CTRL_RESET_CHANNEL) | BF_APBH_CHANNEL_CTRL_RESET_CHANNEL(v)))
/*@}*/




/*******************************************************************************
 * HW_APBH_DEVSEL - AHB to APBH DMA Device Assignment Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_DEVSEL - AHB to APBH DMA Device Assignment Register (RU)
 *
 * Reset value: 0x00000000U
 *
 * This register allows reassignment of the APBH device connected to the DMA
 * Channels. In this chip, APBH DMA channel resource is enough for high speed
 * peripherals, so this register is of no use and reserved.
 */
typedef union _hw_apbh_devsel
{
    uint32_t U;
    struct _hw_apbh_devsel_bitfields
    {
        uint32_t CH0 : 2;              /*!< [1:0]  */
        uint32_t CH1 : 2;              /*!< [3:2]  */
        uint32_t CH2 : 2;              /*!< [5:4]  */
        uint32_t CH3 : 2;              /*!< [7:6]  */
        uint32_t CH4 : 2;              /*!< [9:8]  */
        uint32_t CH5 : 2;              /*!< [11:10]  */
        uint32_t CH6 : 2;              /*!< [13:12]  */
        uint32_t CH7 : 2;              /*!< [15:14]  */
        uint32_t CH8 : 2;              /*!< [17:16]  */
        uint32_t CH9 : 2;              /*!< [19:18]  */
        uint32_t CH10 : 2;             /*!< [21:20]  */
        uint32_t CH11 : 2;             /*!< [23:22]  */
        uint32_t CH12 : 2;             /*!< [25:24]  */
        uint32_t CH13 : 2;             /*!< [27:26]  */
        uint32_t CH14 : 2;             /*!< [29:28]  */
        uint32_t CH15 : 2;             /*!< [31:30]  */
    } B;
} hw_apbh_devsel_t;

/*!
 * @name Constants and macros for entire APBH_DEVSEL register
 */
/*@{*/
#define HW_APBH_DEVSEL_ADDR(x)   ((uintptr_t)(x) + 0x40U)
#define HW_APBH_DEVSEL(x)        (*(__I hw_apbh_devsel_t *) HW_APBH_DEVSEL_ADDR(x))
/*@}*/

/*
 * Constants & macros for individual APBH_DEVSEL bitfields
 */

/*!
 * @name Register APBH_DEVSEL, field CH0[1:0] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH0   (0U)          /*!< Bit position for APBH_DEVSEL_CH0. */
#define BM_APBH_DEVSEL_CH0   (0x00000003U) /*!< Bit mask for APBH_DEVSEL_CH0. */
#define BS_APBH_DEVSEL_CH0   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH0. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH1[3:2] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH1   (2U)          /*!< Bit position for APBH_DEVSEL_CH1. */
#define BM_APBH_DEVSEL_CH1   (0x0000000CU) /*!< Bit mask for APBH_DEVSEL_CH1. */
#define BS_APBH_DEVSEL_CH1   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH1. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH2[5:4] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH2   (4U)          /*!< Bit position for APBH_DEVSEL_CH2. */
#define BM_APBH_DEVSEL_CH2   (0x00000030U) /*!< Bit mask for APBH_DEVSEL_CH2. */
#define BS_APBH_DEVSEL_CH2   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH2. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH3[7:6] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH3   (6U)          /*!< Bit position for APBH_DEVSEL_CH3. */
#define BM_APBH_DEVSEL_CH3   (0x000000C0U) /*!< Bit mask for APBH_DEVSEL_CH3. */
#define BS_APBH_DEVSEL_CH3   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH3. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH4[9:8] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH4   (8U)          /*!< Bit position for APBH_DEVSEL_CH4. */
#define BM_APBH_DEVSEL_CH4   (0x00000300U) /*!< Bit mask for APBH_DEVSEL_CH4. */
#define BS_APBH_DEVSEL_CH4   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH4. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH5[11:10] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH5   (10U)         /*!< Bit position for APBH_DEVSEL_CH5. */
#define BM_APBH_DEVSEL_CH5   (0x00000C00U) /*!< Bit mask for APBH_DEVSEL_CH5. */
#define BS_APBH_DEVSEL_CH5   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH5. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH6[13:12] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH6   (12U)         /*!< Bit position for APBH_DEVSEL_CH6. */
#define BM_APBH_DEVSEL_CH6   (0x00003000U) /*!< Bit mask for APBH_DEVSEL_CH6. */
#define BS_APBH_DEVSEL_CH6   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH6. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH7[15:14] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH7   (14U)         /*!< Bit position for APBH_DEVSEL_CH7. */
#define BM_APBH_DEVSEL_CH7   (0x0000C000U) /*!< Bit mask for APBH_DEVSEL_CH7. */
#define BS_APBH_DEVSEL_CH7   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH7. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH8[17:16] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH8   (16U)         /*!< Bit position for APBH_DEVSEL_CH8. */
#define BM_APBH_DEVSEL_CH8   (0x00030000U) /*!< Bit mask for APBH_DEVSEL_CH8. */
#define BS_APBH_DEVSEL_CH8   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH8. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH9[19:18] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH9   (18U)         /*!< Bit position for APBH_DEVSEL_CH9. */
#define BM_APBH_DEVSEL_CH9   (0x000C0000U) /*!< Bit mask for APBH_DEVSEL_CH9. */
#define BS_APBH_DEVSEL_CH9   (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH9. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH10[21:20] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH10  (20U)         /*!< Bit position for APBH_DEVSEL_CH10. */
#define BM_APBH_DEVSEL_CH10  (0x00300000U) /*!< Bit mask for APBH_DEVSEL_CH10. */
#define BS_APBH_DEVSEL_CH10  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH10. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH11[23:22] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH11  (22U)         /*!< Bit position for APBH_DEVSEL_CH11. */
#define BM_APBH_DEVSEL_CH11  (0x00C00000U) /*!< Bit mask for APBH_DEVSEL_CH11. */
#define BS_APBH_DEVSEL_CH11  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH11. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH12[25:24] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH12  (24U)         /*!< Bit position for APBH_DEVSEL_CH12. */
#define BM_APBH_DEVSEL_CH12  (0x03000000U) /*!< Bit mask for APBH_DEVSEL_CH12. */
#define BS_APBH_DEVSEL_CH12  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH12. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH13[27:26] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH13  (26U)         /*!< Bit position for APBH_DEVSEL_CH13. */
#define BM_APBH_DEVSEL_CH13  (0x0C000000U) /*!< Bit mask for APBH_DEVSEL_CH13. */
#define BS_APBH_DEVSEL_CH13  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH13. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH14[29:28] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH14  (28U)         /*!< Bit position for APBH_DEVSEL_CH14. */
#define BM_APBH_DEVSEL_CH14  (0x30000000U) /*!< Bit mask for APBH_DEVSEL_CH14. */
#define BS_APBH_DEVSEL_CH14  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH14. */
/*@}*/

/*!
 * @name Register APBH_DEVSEL, field CH15[31:30] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DEVSEL_CH15  (30U)         /*!< Bit position for APBH_DEVSEL_CH15. */
#define BM_APBH_DEVSEL_CH15  (0xC0000000U) /*!< Bit mask for APBH_DEVSEL_CH15. */
#define BS_APBH_DEVSEL_CH15  (2U)          /*!< Bit field size in bits for APBH_DEVSEL_CH15. */
/*@}*/

/*******************************************************************************
 * HW_APBH_DMA_BURST_SIZE - AHB to APBH DMA burst size
 ******************************************************************************/

/*!
 * @brief HW_APBH_DMA_BURST_SIZE - AHB to APBH DMA burst size (RW)
 *
 * Reset value: 0x00555555U
 *
 * This register programs the apbh burst size of the APBH DMA devices when a DMA
 * burst request is issued. This register provides a mechanism for assigning the
 * device.
 */
typedef union _hw_apbh_dma_burst_size
{
    uint32_t U;
    struct _hw_apbh_dma_burst_size_bitfields
    {
        uint32_t CH0 : 2;              /*!< [1:0]  */
        uint32_t CH1 : 2;              /*!< [3:2]  */
        uint32_t CH2 : 2;              /*!< [5:4]  */
        uint32_t CH3 : 2;              /*!< [7:6]  */
        uint32_t CH4 : 2;              /*!< [9:8]  */
        uint32_t CH5 : 2;              /*!< [11:10]  */
        uint32_t CH6 : 2;              /*!< [13:12]  */
        uint32_t CH7 : 2;              /*!< [15:14]  */
        uint32_t CH8 : 2;              /*!< [17:16]  */
        uint32_t CH9 : 2;              /*!< [19:18]  */
        uint32_t CH10 : 2;             /*!< [21:20]  */
        uint32_t CH11 : 2;             /*!< [23:22]  */
        uint32_t CH12 : 2;             /*!< [25:24]  */
        uint32_t CH13 : 2;             /*!< [27:26]  */
        uint32_t CH14 : 2;             /*!< [29:28]  */
        uint32_t CH15 : 2;             /*!< [31:30]  */
    } B;
} hw_apbh_dma_burst_size_t;

/*!
 * @name Constants and macros for entire APBH_DMA_BURST_SIZE register
 */
/*@{*/
#define HW_APBH_DMA_BURST_SIZE_ADDR(x) ((uintptr_t)(x) + 0x50U)

#define HW_APBH_DMA_BURST_SIZE(x) (*(__IO hw_apbh_dma_burst_size_t *) HW_APBH_DMA_BURST_SIZE_ADDR(x))
#define HW_APBH_DMA_BURST_SIZE_RD(x) (HW_APBH_DMA_BURST_SIZE(x).U)
#define HW_APBH_DMA_BURST_SIZE_WR(x, v) (HW_APBH_DMA_BURST_SIZE(x).U = (v))
#define HW_APBH_DMA_BURST_SIZE_SET(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, HW_APBH_DMA_BURST_SIZE_RD(x) |  (v)))
#define HW_APBH_DMA_BURST_SIZE_CLR(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, HW_APBH_DMA_BURST_SIZE_RD(x) & ~(v)))
#define HW_APBH_DMA_BURST_SIZE_TOG(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, HW_APBH_DMA_BURST_SIZE_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual APBH_DMA_BURST_SIZE bitfields
 */

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH0[1:0] (RW)
 *
 * DMA burst size for GPMI channel 0. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH0 (0U)    /*!< Bit position for APBH_DMA_BURST_SIZE_CH0. */
#define BM_APBH_DMA_BURST_SIZE_CH0 (0x00000003U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH0. */
#define BS_APBH_DMA_BURST_SIZE_CH0 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH0. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH0 field. */
#define BR_APBH_DMA_BURST_SIZE_CH0(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH0)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH0. */
#define BF_APBH_DMA_BURST_SIZE_CH0(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH0) & BM_APBH_DMA_BURST_SIZE_CH0)

/*! @brief Set the CH0 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH0(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH0) | BF_APBH_DMA_BURST_SIZE_CH0(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH1[3:2] (RW)
 *
 * DMA burst size for GPMI channel 1. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH1 (2U)    /*!< Bit position for APBH_DMA_BURST_SIZE_CH1. */
#define BM_APBH_DMA_BURST_SIZE_CH1 (0x0000000CU) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH1. */
#define BS_APBH_DMA_BURST_SIZE_CH1 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH1. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH1 field. */
#define BR_APBH_DMA_BURST_SIZE_CH1(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH1)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH1. */
#define BF_APBH_DMA_BURST_SIZE_CH1(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH1) & BM_APBH_DMA_BURST_SIZE_CH1)

/*! @brief Set the CH1 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH1(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH1) | BF_APBH_DMA_BURST_SIZE_CH1(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH2[5:4] (RW)
 *
 * DMA burst size for GPMI channel 2. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH2 (4U)    /*!< Bit position for APBH_DMA_BURST_SIZE_CH2. */
#define BM_APBH_DMA_BURST_SIZE_CH2 (0x00000030U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH2. */
#define BS_APBH_DMA_BURST_SIZE_CH2 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH2. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH2 field. */
#define BR_APBH_DMA_BURST_SIZE_CH2(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH2)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH2. */
#define BF_APBH_DMA_BURST_SIZE_CH2(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH2) & BM_APBH_DMA_BURST_SIZE_CH2)

/*! @brief Set the CH2 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH2(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH2) | BF_APBH_DMA_BURST_SIZE_CH2(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH3[7:6] (RW)
 *
 * DMA burst size for GPMI channel 3. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH3 (6U)    /*!< Bit position for APBH_DMA_BURST_SIZE_CH3. */
#define BM_APBH_DMA_BURST_SIZE_CH3 (0x000000C0U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH3. */
#define BS_APBH_DMA_BURST_SIZE_CH3 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH3. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH3 field. */
#define BR_APBH_DMA_BURST_SIZE_CH3(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH3)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH3. */
#define BF_APBH_DMA_BURST_SIZE_CH3(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH3) & BM_APBH_DMA_BURST_SIZE_CH3)

/*! @brief Set the CH3 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH3(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH3) | BF_APBH_DMA_BURST_SIZE_CH3(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH4[9:8] (RW)
 *
 * DMA burst size for GPMI channel 4. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH4 (8U)    /*!< Bit position for APBH_DMA_BURST_SIZE_CH4. */
#define BM_APBH_DMA_BURST_SIZE_CH4 (0x00000300U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH4. */
#define BS_APBH_DMA_BURST_SIZE_CH4 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH4. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH4 field. */
#define BR_APBH_DMA_BURST_SIZE_CH4(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH4)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH4. */
#define BF_APBH_DMA_BURST_SIZE_CH4(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH4) & BM_APBH_DMA_BURST_SIZE_CH4)

/*! @brief Set the CH4 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH4(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH4) | BF_APBH_DMA_BURST_SIZE_CH4(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH5[11:10] (RW)
 *
 * DMA burst size for GPMI channel 5. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH5 (10U)   /*!< Bit position for APBH_DMA_BURST_SIZE_CH5. */
#define BM_APBH_DMA_BURST_SIZE_CH5 (0x00000C00U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH5. */
#define BS_APBH_DMA_BURST_SIZE_CH5 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH5. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH5 field. */
#define BR_APBH_DMA_BURST_SIZE_CH5(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH5)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH5. */
#define BF_APBH_DMA_BURST_SIZE_CH5(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH5) & BM_APBH_DMA_BURST_SIZE_CH5)

/*! @brief Set the CH5 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH5(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH5) | BF_APBH_DMA_BURST_SIZE_CH5(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH6[13:12] (RW)
 *
 * DMA burst size for GPMI channel 6. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH6 (12U)   /*!< Bit position for APBH_DMA_BURST_SIZE_CH6. */
#define BM_APBH_DMA_BURST_SIZE_CH6 (0x00003000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH6. */
#define BS_APBH_DMA_BURST_SIZE_CH6 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH6. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH6 field. */
#define BR_APBH_DMA_BURST_SIZE_CH6(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH6)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH6. */
#define BF_APBH_DMA_BURST_SIZE_CH6(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH6) & BM_APBH_DMA_BURST_SIZE_CH6)

/*! @brief Set the CH6 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH6(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH6) | BF_APBH_DMA_BURST_SIZE_CH6(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH7[15:14] (RW)
 *
 * DMA burst size for GPMI channel 7. Do not change. GPMI only support burst
 * size 4.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH7 (14U)   /*!< Bit position for APBH_DMA_BURST_SIZE_CH7. */
#define BM_APBH_DMA_BURST_SIZE_CH7 (0x0000C000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH7. */
#define BS_APBH_DMA_BURST_SIZE_CH7 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH7. */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH7 field. */
#define BR_APBH_DMA_BURST_SIZE_CH7(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH7)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH7. */
#define BF_APBH_DMA_BURST_SIZE_CH7(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH7) & BM_APBH_DMA_BURST_SIZE_CH7)

/*! @brief Set the CH7 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH7(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH7) | BF_APBH_DMA_BURST_SIZE_CH7(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH8[17:16] (RW)
 *
 * DMA burst size for SSP.
 *
 * Values:
 * - 0 -
 * - 1 -
 * - 10 -
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH8 (16U)   /*!< Bit position for APBH_DMA_BURST_SIZE_CH8. */
#define BM_APBH_DMA_BURST_SIZE_CH8 (0x00030000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH8. */
#define BS_APBH_DMA_BURST_SIZE_CH8 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH8. */

#define BV_APBH_DMA_BURST_SIZE_CH8_BURST0 (0U)       /*!< Bit field value for APBH_DMA_BURST_SIZE_CH8:  */
#define BV_APBH_DMA_BURST_SIZE_CH8_BURST4 (0x1U)     /*!< Bit field value for APBH_DMA_BURST_SIZE_CH8:  */
#define BV_APBH_DMA_BURST_SIZE_CH8_BURST8 (0x2U)     /*!< Bit field value for APBH_DMA_BURST_SIZE_CH8:  */

/*! @brief Read current value of the APBH_DMA_BURST_SIZE_CH8 field. */
#define BR_APBH_DMA_BURST_SIZE_CH8(x) (HW_APBH_DMA_BURST_SIZE(x).B.CH8)

/*! @brief Format value for bitfield APBH_DMA_BURST_SIZE_CH8. */
#define BF_APBH_DMA_BURST_SIZE_CH8(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DMA_BURST_SIZE_CH8) & BM_APBH_DMA_BURST_SIZE_CH8)

/*! @brief Set the CH8 field to a new value. */
#define BW_APBH_DMA_BURST_SIZE_CH8(x, v) (HW_APBH_DMA_BURST_SIZE_WR(x, (HW_APBH_DMA_BURST_SIZE_RD(x) & ~BM_APBH_DMA_BURST_SIZE_CH8) | BF_APBH_DMA_BURST_SIZE_CH8(v)))
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH9[19:18] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH9 (18U)   /*!< Bit position for APBH_DMA_BURST_SIZE_CH9. */
#define BM_APBH_DMA_BURST_SIZE_CH9 (0x000C0000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH9. */
#define BS_APBH_DMA_BURST_SIZE_CH9 (2U)    /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH9. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH10[21:20] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH10 (20U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH10. */
#define BM_APBH_DMA_BURST_SIZE_CH10 (0x00300000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH10. */
#define BS_APBH_DMA_BURST_SIZE_CH10 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH10. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH11[23:22] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH11 (22U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH11. */
#define BM_APBH_DMA_BURST_SIZE_CH11 (0x00C00000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH11. */
#define BS_APBH_DMA_BURST_SIZE_CH11 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH11. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH12[25:24] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH12 (24U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH12. */
#define BM_APBH_DMA_BURST_SIZE_CH12 (0x03000000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH12. */
#define BS_APBH_DMA_BURST_SIZE_CH12 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH12. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH13[27:26] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH13 (26U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH13. */
#define BM_APBH_DMA_BURST_SIZE_CH13 (0x0C000000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH13. */
#define BS_APBH_DMA_BURST_SIZE_CH13 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH13. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH14[29:28] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH14 (28U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH14. */
#define BM_APBH_DMA_BURST_SIZE_CH14 (0x30000000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH14. */
#define BS_APBH_DMA_BURST_SIZE_CH14 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH14. */
/*@}*/

/*!
 * @name Register APBH_DMA_BURST_SIZE, field CH15[31:30] (RU)
 *
 * Reserved.
 */
/*@{*/
#define BP_APBH_DMA_BURST_SIZE_CH15 (30U)  /*!< Bit position for APBH_DMA_BURST_SIZE_CH15. */
#define BM_APBH_DMA_BURST_SIZE_CH15 (0xC0000000U) /*!< Bit mask for APBH_DMA_BURST_SIZE_CH15. */
#define BS_APBH_DMA_BURST_SIZE_CH15 (2U)   /*!< Bit field size in bits for APBH_DMA_BURST_SIZE_CH15. */
/*@}*/

/*******************************************************************************
 * HW_APBH_DEBUG - AHB to APBH DMA Debug Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_DEBUG - AHB to APBH DMA Debug Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is for debug purpose. The debug register is for internal use
 * only. Not recommend for customer useage.
 */
typedef union _hw_apbh_debug
{
    uint32_t U;
    struct _hw_apbh_debug_bitfields
    {
        uint32_t GPMI_ONE_FIFO : 1;    /*!< [0]  */
        uint32_t RESERVED0 : 31;       /*!< [31:1]  */
    } B;
} hw_apbh_debug_t;

/*!
 * @name Constants and macros for entire APBH_DEBUG register
 */
/*@{*/
#define HW_APBH_DEBUG_ADDR(x)    ((uintptr_t)(x) + 0x60U)

#define HW_APBH_DEBUG(x)         (*(__IO hw_apbh_debug_t *) HW_APBH_DEBUG_ADDR(x))
#define HW_APBH_DEBUG_RD(x)      (HW_APBH_DEBUG(x).U)
#define HW_APBH_DEBUG_WR(x, v)   (HW_APBH_DEBUG(x).U = (v))
#define HW_APBH_DEBUG_SET(x, v)  (HW_APBH_DEBUG_WR(x, HW_APBH_DEBUG_RD(x) |  (v)))
#define HW_APBH_DEBUG_CLR(x, v)  (HW_APBH_DEBUG_WR(x, HW_APBH_DEBUG_RD(x) & ~(v)))
#define HW_APBH_DEBUG_TOG(x, v)  (HW_APBH_DEBUG_WR(x, HW_APBH_DEBUG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual APBH_DEBUG bitfields
 */

/*!
 * @name Register APBH_DEBUG, field GPMI_ONE_FIFO[0] (RW)
 *
 * Set to 0ne and the 8 GPMI channels will share the DMA FIFO, and when set to
 * zero, the 8 GPMI channels will use its own DMA FIFO.
 */
/*@{*/
#define BP_APBH_DEBUG_GPMI_ONE_FIFO (0U)   /*!< Bit position for APBH_DEBUG_GPMI_ONE_FIFO. */
#define BM_APBH_DEBUG_GPMI_ONE_FIFO (0x00000001U) /*!< Bit mask for APBH_DEBUG_GPMI_ONE_FIFO. */
#define BS_APBH_DEBUG_GPMI_ONE_FIFO (1U)   /*!< Bit field size in bits for APBH_DEBUG_GPMI_ONE_FIFO. */

/*! @brief Read current value of the APBH_DEBUG_GPMI_ONE_FIFO field. */
#define BR_APBH_DEBUG_GPMI_ONE_FIFO(x) (HW_APBH_DEBUG(x).B.GPMI_ONE_FIFO)

/*! @brief Format value for bitfield APBH_DEBUG_GPMI_ONE_FIFO. */
#define BF_APBH_DEBUG_GPMI_ONE_FIFO(v) ((uint32_t)((uint32_t)(v) << BP_APBH_DEBUG_GPMI_ONE_FIFO) & BM_APBH_DEBUG_GPMI_ONE_FIFO)

/*! @brief Set the GPMI_ONE_FIFO field to a new value. */
#define BW_APBH_DEBUG_GPMI_ONE_FIFO(x, v) (HW_APBH_DEBUG_WR(x, (HW_APBH_DEBUG_RD(x) & ~BM_APBH_DEBUG_GPMI_ONE_FIFO) | BF_APBH_DEBUG_GPMI_ONE_FIFO(v)))
/*@}*/

/*******************************************************************************
 * HW_APBH_CHn_CURCMDAR - APBH DMA Channel n Current Command Address Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_CURCMDAR - APBH DMA Channel n Current Command Address Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The APBH DMA channel n current command address register points to the
 * multiword command that is currently being executed. Commands are threaded on the
 * command address. APBH DMA Channel n is controlled by a variable sized command
 * structure. This register points to the command structure currently being executed.
 * EXAMPLE pCurCmd = (apbh_chn_cmd_t *) APBH_CHn_CURCMDAR_RD(0); // read the
 * whole register, since there is only one field pCurCmd = (apbh_chn_cmd_t *)
 * BF_RDn(APBH_CHn_CURCMDAR, 0, CMD_ADDR); // or, use multi-register bitfield read
 * macro pCurCmd = (apbh_chn_cmd_t *) APBH_CHn_CURCMDAR(0).CMD_ADDR; // or, assign
 * from bitfield of indexed register's struct
 */
typedef union _hw_apbh_chn_curcmdar
{
    uint32_t U;
    struct _hw_apbh_chn_curcmdar_bitfields
    {
        uint32_t CMD_ADDR : 32;        /*!< [31:0]  */
    } B;
} hw_apbh_chn_curcmdar_t;

/*!
 * @name Constants and macros for entire APBH_CHn_CURCMDAR register
 */
/*@{*/
#define HW_APBH_CHn_CURCMDAR_COUNT (16U)

#define HW_APBH_CHn_CURCMDAR_ADDR(x, n) ((uintptr_t)(x) + 0x100U + (0x70U * (n)))

#define HW_APBH_CHn_CURCMDAR(x, n) (*(__I hw_apbh_chn_curcmdar_t *) HW_APBH_CHn_CURCMDAR_ADDR(x, n))
#define HW_APBH_CHn_CURCMDAR_RD(x, n) (HW_APBH_CHn_CURCMDAR(x, n).U)
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_CURCMDAR bitfields
 */

/*!
 * @name Register APBH_CHn_CURCMDAR, field CMD_ADDR[31:0] (RO)
 *
 * Pointer to command structure currently being processed for channel n.
 */
/*@{*/
#define BP_APBH_CHn_CURCMDAR_CMD_ADDR (0U) /*!< Bit position for APBH_CHn_CURCMDAR_CMD_ADDR. */
#define BM_APBH_CHn_CURCMDAR_CMD_ADDR (0xFFFFFFFFU) /*!< Bit mask for APBH_CHn_CURCMDAR_CMD_ADDR. */
#define BS_APBH_CHn_CURCMDAR_CMD_ADDR (32U) /*!< Bit field size in bits for APBH_CHn_CURCMDAR_CMD_ADDR. */

/*! @brief Read current value of the APBH_CHn_CURCMDAR_CMD_ADDR field. */
#define BR_APBH_CHn_CURCMDAR_CMD_ADDR(x, n) (HW_APBH_CHn_CURCMDAR(x, n).U)
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_NXTCMDAR - APBH DMA Channel n Next Command Address Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_NXTCMDAR - APBH DMA Channel n Next Command Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The APBH DMA Channel n Next Command Address register contains the address of
 * the next multiword command to be executed. Commands are threaded on the
 * command address. Set CHAIN to 1 in the DMA command word to process command lists.
 * APBH DMA Channel n is controlled by a variable sized command structure. Software
 * loads this register with the address of the first command structure to
 * process and increments the Channel n semaphore to start processing. This register
 * points to the next command structure to be executed when the current command is
 * completed. EXAMPLE APBH_CHn_NXTCMDAR_WR(0, (reg32_t) pCommandTwoStructure); //
 * write the entire register, since there is only one field
 * BF_WRn(APBH_CHn_NXTCMDAR, 0, (reg32_t) pCommandTwoStructure); // or, use multi-register bitfield
 * write macro APBH_CHn_NXTCMDAR(0).CMD_ADDR = (reg32_t) pCommandTwoStructure; //
 * or, assign to bitfield of indexed register's struct
 */
typedef union _hw_apbh_chn_nxtcmdar
{
    uint32_t U;
    struct _hw_apbh_chn_nxtcmdar_bitfields
    {
        uint32_t CMD_ADDR : 32;        /*!< [31:0]  */
    } B;
} hw_apbh_chn_nxtcmdar_t;

/*!
 * @name Constants and macros for entire APBH_CHn_NXTCMDAR register
 */
/*@{*/
#define HW_APBH_CHn_NXTCMDAR_COUNT (16U)

#define HW_APBH_CHn_NXTCMDAR_ADDR(x, n) ((uintptr_t)(x) + 0x110U + (0x70U * (n)))

#define HW_APBH_CHn_NXTCMDAR(x, n) (*(__IO hw_apbh_chn_nxtcmdar_t *) HW_APBH_CHn_NXTCMDAR_ADDR(x, n))
#define HW_APBH_CHn_NXTCMDAR_RD(x, n) (HW_APBH_CHn_NXTCMDAR(x, n).U)
#define HW_APBH_CHn_NXTCMDAR_WR(x, n, v) (HW_APBH_CHn_NXTCMDAR(x, n).U = (v))
#define HW_APBH_CHn_NXTCMDAR_SET(x, n, v) (HW_APBH_CHn_NXTCMDAR_WR(x, n, HW_APBH_CHn_NXTCMDAR_RD(x, n) |  (v)))
#define HW_APBH_CHn_NXTCMDAR_CLR(x, n, v) (HW_APBH_CHn_NXTCMDAR_WR(x, n, HW_APBH_CHn_NXTCMDAR_RD(x, n) & ~(v)))
#define HW_APBH_CHn_NXTCMDAR_TOG(x, n, v) (HW_APBH_CHn_NXTCMDAR_WR(x, n, HW_APBH_CHn_NXTCMDAR_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_NXTCMDAR bitfields
 */

/*!
 * @name Register APBH_CHn_NXTCMDAR, field CMD_ADDR[31:0] (RW)
 *
 * Pointer to next command structure for channel n.
 */
/*@{*/
#define BP_APBH_CHn_NXTCMDAR_CMD_ADDR (0U) /*!< Bit position for APBH_CHn_NXTCMDAR_CMD_ADDR. */
#define BM_APBH_CHn_NXTCMDAR_CMD_ADDR (0xFFFFFFFFU) /*!< Bit mask for APBH_CHn_NXTCMDAR_CMD_ADDR. */
#define BS_APBH_CHn_NXTCMDAR_CMD_ADDR (32U) /*!< Bit field size in bits for APBH_CHn_NXTCMDAR_CMD_ADDR. */

/*! @brief Read current value of the APBH_CHn_NXTCMDAR_CMD_ADDR field. */
#define BR_APBH_CHn_NXTCMDAR_CMD_ADDR(x, n) (HW_APBH_CHn_NXTCMDAR(x, n).U)

/*! @brief Format value for bitfield APBH_CHn_NXTCMDAR_CMD_ADDR. */
#define BF_APBH_CHn_NXTCMDAR_CMD_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CHn_NXTCMDAR_CMD_ADDR) & BM_APBH_CHn_NXTCMDAR_CMD_ADDR)

/*! @brief Set the CMD_ADDR field to a new value. */
#define BW_APBH_CHn_NXTCMDAR_CMD_ADDR(x, n, v) (HW_APBH_CHn_NXTCMDAR_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_CMD - APBH DMA Channel n Command Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_CMD - APBH DMA Channel n Command Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The APBH DMA Channel n command register specifies the DMA transaction to
 * perform for the current command chain item. The command register controls the
 * overall operation of each DMA command for this channel. It includes the number of
 * bytes to transfer to or from the device, the number of APB PIO command words
 * included with this command structure, whether to interrupt at command
 * completion, whether to chain an additional command to the end of this one and whether
 * this transfer is a read or write DMA transfer. EXAMPLE apbh_chn_cmd_t dma_cmd;
 * dma_cmd.XFER_COUNT = 512; // transfer 512 bytes dma_cmd.COMMAND =
 * BV_APBH_CHn_CMD_COMMAND__DMA_WRITE; // transfer to system memory from peripheral device
 * dma_cmd.CHAIN = 1; // chain an additional command structure on to the list
 * dma_cmd.IRQONCMPLT = 1; // generate an interrupt on completion of this command
 * structure
 */
typedef union _hw_apbh_chn_cmd
{
    uint32_t U;
    struct _hw_apbh_chn_cmd_bitfields
    {
        uint32_t COMMAND : 2;          /*!< [1:0]  */
        uint32_t CHAIN : 1;            /*!< [2]  */
        uint32_t IRQONCMPLT : 1;       /*!< [3]  */
        uint32_t NANDLOCK : 1;         /*!< [4]  */
        uint32_t NANDWAIT4READY : 1;   /*!< [5]  */
        uint32_t SEMAPHORE : 1;        /*!< [6]  */
        uint32_t WAIT4ENDCMD : 1;      /*!< [7]  */
        uint32_t HALTONTERMINATE : 1;  /*!< [8]  */
        uint32_t RESERVED0 : 3;        /*!< [11:9]  */
        uint32_t CMDWORDS : 4;         /*!< [15:12]  */
        uint32_t XFER_COUNT : 16;      /*!< [31:16]  */
    } B;
} hw_apbh_chn_cmd_t;

/*!
 * @name Constants and macros for entire APBH_CHn_CMD register
 */
/*@{*/
#define HW_APBH_CHn_CMD_COUNT (16U)

#define HW_APBH_CHn_CMD_ADDR(x, n) ((uintptr_t)(x) + 0x120U + (0x70U * (n)))

#define HW_APBH_CHn_CMD(x, n)    (*(__I hw_apbh_chn_cmd_t *) HW_APBH_CHn_CMD_ADDR(x, n))
#define HW_APBH_CHn_CMD_RD(x, n) (HW_APBH_CHn_CMD(x, n).U)
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_CMD bitfields
 */

/*!
 * @name Register APBH_CHn_CMD, field COMMAND[1:0] (RO)
 *
 * This bitfield indicates the type of current command:
 *
 * Values:
 * - 0 - Perform any requested PIO word transfers but terminate command before
 *     any DMA transfer.
 * - 1 - Perform any requested PIO word transfers and then perform a DMA
 *     transfer from the peripheral for the specified number of bytes.
 * - 10 - Perform any requested PIO word transfers and then perform a DMA
 *     transfer to the peripheral for the specified number of bytes.
 * - 11 - Perform any requested PIO word transfers and then perform a
 *     conditional branch to the next chained device. Follow the NEXCMD_ADDR pointer if the
 *     perpheral sense is true. Follow the BUFFER_ADDRESS as a chain pointer if
 *     the peripheral sense line is false.
 */
/*@{*/
#define BP_APBH_CHn_CMD_COMMAND (0U)       /*!< Bit position for APBH_CHn_CMD_COMMAND. */
#define BM_APBH_CHn_CMD_COMMAND (0x00000003U) /*!< Bit mask for APBH_CHn_CMD_COMMAND. */
#define BS_APBH_CHn_CMD_COMMAND (2U)       /*!< Bit field size in bits for APBH_CHn_CMD_COMMAND. */

#define BV_APBH_CHn_CMD_COMMAND_NO_DMA_XFER (0U)     /*!< Bit field value for APBH_CHn_CMD_COMMAND: Perform any requested PIO word transfers but terminate command before any DMA transfer. */
#define BV_APBH_CHn_CMD_COMMAND_DMA_WRITE (0x1U)     /*!< Bit field value for APBH_CHn_CMD_COMMAND: Perform any requested PIO word transfers and then perform a DMA transfer from the peripheral for the specified number of bytes. */
#define BV_APBH_CHn_CMD_COMMAND_DMA_READ (0x2U)      /*!< Bit field value for APBH_CHn_CMD_COMMAND: Perform any requested PIO word transfers and then perform a DMA transfer to the peripheral for the specified number of bytes. */
#define BV_APBH_CHn_CMD_COMMAND_DMA_SENSE (0x3U)     /*!< Bit field value for APBH_CHn_CMD_COMMAND: Perform any requested PIO word transfers and then perform a conditional branch to the next chained device. Follow the NEXCMD_ADDR pointer if the perpheral sense is true. Follow the BUFFER_ADDRESS as a chain pointer if the peripheral sense line is false. */

/*! @brief Read current value of the APBH_CHn_CMD_COMMAND field. */
#define BR_APBH_CHn_CMD_COMMAND(x, n) (HW_APBH_CHn_CMD(x, n).B.COMMAND)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field CHAIN[2] (RO)
 *
 * A value of one indicates that another command is chained onto the end of the
 * current command structure. At the completion of the current command, this
 * channel will follow the pointer in APBH_CHn_CMDAR to find the next command.
 */
/*@{*/
#define BP_APBH_CHn_CMD_CHAIN (2U)         /*!< Bit position for APBH_CHn_CMD_CHAIN. */
#define BM_APBH_CHn_CMD_CHAIN (0x00000004U) /*!< Bit mask for APBH_CHn_CMD_CHAIN. */
#define BS_APBH_CHn_CMD_CHAIN (1U)         /*!< Bit field size in bits for APBH_CHn_CMD_CHAIN. */

/*! @brief Read current value of the APBH_CHn_CMD_CHAIN field. */
#define BR_APBH_CHn_CMD_CHAIN(x, n) (HW_APBH_CHn_CMD(x, n).B.CHAIN)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field IRQONCMPLT[3] (RO)
 *
 * A value of one indicates that the channel will cause the interrupt status bit
 * to be set upon completion of the current command, i.e. after the DMA transfer
 * is complete.
 */
/*@{*/
#define BP_APBH_CHn_CMD_IRQONCMPLT (3U)    /*!< Bit position for APBH_CHn_CMD_IRQONCMPLT. */
#define BM_APBH_CHn_CMD_IRQONCMPLT (0x00000008U) /*!< Bit mask for APBH_CHn_CMD_IRQONCMPLT. */
#define BS_APBH_CHn_CMD_IRQONCMPLT (1U)    /*!< Bit field size in bits for APBH_CHn_CMD_IRQONCMPLT. */

/*! @brief Read current value of the APBH_CHn_CMD_IRQONCMPLT field. */
#define BR_APBH_CHn_CMD_IRQONCMPLT(x, n) (HW_APBH_CHn_CMD(x, n).B.IRQONCMPLT)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field NANDLOCK[4] (RO)
 *
 * A value of one indicates that the NAND DMA channel will remain "locked" in
 * the arbiter at the expense of other NAND DMA channels. It is ignored for
 * non-NAND DMA channels.
 */
/*@{*/
#define BP_APBH_CHn_CMD_NANDLOCK (4U)      /*!< Bit position for APBH_CHn_CMD_NANDLOCK. */
#define BM_APBH_CHn_CMD_NANDLOCK (0x00000010U) /*!< Bit mask for APBH_CHn_CMD_NANDLOCK. */
#define BS_APBH_CHn_CMD_NANDLOCK (1U)      /*!< Bit field size in bits for APBH_CHn_CMD_NANDLOCK. */

/*! @brief Read current value of the APBH_CHn_CMD_NANDLOCK field. */
#define BR_APBH_CHn_CMD_NANDLOCK(x, n) (HW_APBH_CHn_CMD(x, n).B.NANDLOCK)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field NANDWAIT4READY[5] (RO)
 *
 * A value of one indicates that the NAND DMA channel will will wait until the
 * NAND device reports "ready" before executing the command. It is ignored for
 * non-NAND DMA channels.
 */
/*@{*/
#define BP_APBH_CHn_CMD_NANDWAIT4READY (5U) /*!< Bit position for APBH_CHn_CMD_NANDWAIT4READY. */
#define BM_APBH_CHn_CMD_NANDWAIT4READY (0x00000020U) /*!< Bit mask for APBH_CHn_CMD_NANDWAIT4READY. */
#define BS_APBH_CHn_CMD_NANDWAIT4READY (1U) /*!< Bit field size in bits for APBH_CHn_CMD_NANDWAIT4READY. */

/*! @brief Read current value of the APBH_CHn_CMD_NANDWAIT4READY field. */
#define BR_APBH_CHn_CMD_NANDWAIT4READY(x, n) (HW_APBH_CHn_CMD(x, n).B.NANDWAIT4READY)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field SEMAPHORE[6] (RO)
 *
 * A value of one indicates that the channel will decrement its semaphore at the
 * completion of the current command structure. If the semaphore decrements to
 * zero, then this channel stalls until software increments it again.
 */
/*@{*/
#define BP_APBH_CHn_CMD_SEMAPHORE (6U)     /*!< Bit position for APBH_CHn_CMD_SEMAPHORE. */
#define BM_APBH_CHn_CMD_SEMAPHORE (0x00000040U) /*!< Bit mask for APBH_CHn_CMD_SEMAPHORE. */
#define BS_APBH_CHn_CMD_SEMAPHORE (1U)     /*!< Bit field size in bits for APBH_CHn_CMD_SEMAPHORE. */

/*! @brief Read current value of the APBH_CHn_CMD_SEMAPHORE field. */
#define BR_APBH_CHn_CMD_SEMAPHORE(x, n) (HW_APBH_CHn_CMD(x, n).B.SEMAPHORE)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field WAIT4ENDCMD[7] (RO)
 *
 * A value of one indicates that the channel will wait for the end of command
 * signal to be sent from the APBH device to the DMA before starting the next DMA
 * command.
 */
/*@{*/
#define BP_APBH_CHn_CMD_WAIT4ENDCMD (7U)   /*!< Bit position for APBH_CHn_CMD_WAIT4ENDCMD. */
#define BM_APBH_CHn_CMD_WAIT4ENDCMD (0x00000080U) /*!< Bit mask for APBH_CHn_CMD_WAIT4ENDCMD. */
#define BS_APBH_CHn_CMD_WAIT4ENDCMD (1U)   /*!< Bit field size in bits for APBH_CHn_CMD_WAIT4ENDCMD. */

/*! @brief Read current value of the APBH_CHn_CMD_WAIT4ENDCMD field. */
#define BR_APBH_CHn_CMD_WAIT4ENDCMD(x, n) (HW_APBH_CHn_CMD(x, n).B.WAIT4ENDCMD)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field HALTONTERMINATE[8] (RO)
 *
 * A value of one indicates that the channel will immeditately terminate the
 * current descriptor and halt the DMA channel if a terminate signal is set. A value
 * of 0 will still cause an immediate terminate of the channel if the terminate
 * signal is set, but the channel will continue as if the count had been
 * exhausted, meaning it will honor IRQONCMPLT, CHAIN, SEMAPHORE, and WAIT4ENDCMD.
 */
/*@{*/
#define BP_APBH_CHn_CMD_HALTONTERMINATE (8U) /*!< Bit position for APBH_CHn_CMD_HALTONTERMINATE. */
#define BM_APBH_CHn_CMD_HALTONTERMINATE (0x00000100U) /*!< Bit mask for APBH_CHn_CMD_HALTONTERMINATE. */
#define BS_APBH_CHn_CMD_HALTONTERMINATE (1U) /*!< Bit field size in bits for APBH_CHn_CMD_HALTONTERMINATE. */

/*! @brief Read current value of the APBH_CHn_CMD_HALTONTERMINATE field. */
#define BR_APBH_CHn_CMD_HALTONTERMINATE(x, n) (HW_APBH_CHn_CMD(x, n).B.HALTONTERMINATE)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field CMDWORDS[15:12] (RO)
 *
 * This field indicates the number of command words to send to the GPMI0,
 * starting with the base PIO address of the GPMI0 control register and incrementing
 * from there. Zero means transfer NO command words
 */
/*@{*/
#define BP_APBH_CHn_CMD_CMDWORDS (12U)     /*!< Bit position for APBH_CHn_CMD_CMDWORDS. */
#define BM_APBH_CHn_CMD_CMDWORDS (0x0000F000U) /*!< Bit mask for APBH_CHn_CMD_CMDWORDS. */
#define BS_APBH_CHn_CMD_CMDWORDS (4U)      /*!< Bit field size in bits for APBH_CHn_CMD_CMDWORDS. */

/*! @brief Read current value of the APBH_CHn_CMD_CMDWORDS field. */
#define BR_APBH_CHn_CMD_CMDWORDS(x, n) (HW_APBH_CHn_CMD(x, n).B.CMDWORDS)
/*@}*/

/*!
 * @name Register APBH_CHn_CMD, field XFER_COUNT[31:16] (RO)
 *
 * This field indicates the number of bytes to transfer to or from the
 * appropriate PIO register in the GPMI0 device. A value of 0 indicates a 64 KBytes
 * transfer.
 */
/*@{*/
#define BP_APBH_CHn_CMD_XFER_COUNT (16U)   /*!< Bit position for APBH_CHn_CMD_XFER_COUNT. */
#define BM_APBH_CHn_CMD_XFER_COUNT (0xFFFF0000U) /*!< Bit mask for APBH_CHn_CMD_XFER_COUNT. */
#define BS_APBH_CHn_CMD_XFER_COUNT (16U)   /*!< Bit field size in bits for APBH_CHn_CMD_XFER_COUNT. */

/*! @brief Read current value of the APBH_CHn_CMD_XFER_COUNT field. */
#define BR_APBH_CHn_CMD_XFER_COUNT(x, n) (HW_APBH_CHn_CMD(x, n).B.XFER_COUNT)
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_BAR - APBH DMA Channel n Buffer Address Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_BAR - APBH DMA Channel n Buffer Address Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The APBH DMA Channel n buffer address register contains a pointer to the data
 * buffer for the transfer. For immediate forms, the data is taken from this
 * register. This is a byte address which means transfers can start on any byte
 * boundary. This register holds a pointer to the data buffer in system memory. After
 * the command values have been read into the DMA controller and the device
 * controlled by this channel, then the DMA transfer will begin, to or from the
 * buffer pointed to by this register. EXAMPLE apbh_chn_bar_t dma_data;
 * dma_data.ADDRESS = (reg32_t) pDataBuffer;
 */
typedef union _hw_apbh_chn_bar
{
    uint32_t U;
    struct _hw_apbh_chn_bar_bitfields
    {
        uint32_t ADDRESS : 32;         /*!< [31:0]  */
    } B;
} hw_apbh_chn_bar_t;

/*!
 * @name Constants and macros for entire APBH_CHn_BAR register
 */
/*@{*/
#define HW_APBH_CHn_BAR_COUNT (16U)

#define HW_APBH_CHn_BAR_ADDR(x, n) ((uintptr_t)(x) + 0x130U + (0x70U * (n)))

#define HW_APBH_CHn_BAR(x, n)    (*(__I hw_apbh_chn_bar_t *) HW_APBH_CHn_BAR_ADDR(x, n))
#define HW_APBH_CHn_BAR_RD(x, n) (HW_APBH_CHn_BAR(x, n).U)
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_BAR bitfields
 */

/*!
 * @name Register APBH_CHn_BAR, field ADDRESS[31:0] (RO)
 *
 * Address of system memory buffer to be read or written over the AHB bus.
 */
/*@{*/
#define BP_APBH_CHn_BAR_ADDRESS (0U)       /*!< Bit position for APBH_CHn_BAR_ADDRESS. */
#define BM_APBH_CHn_BAR_ADDRESS (0xFFFFFFFFU) /*!< Bit mask for APBH_CHn_BAR_ADDRESS. */
#define BS_APBH_CHn_BAR_ADDRESS (32U)      /*!< Bit field size in bits for APBH_CHn_BAR_ADDRESS. */

/*! @brief Read current value of the APBH_CHn_BAR_ADDRESS field. */
#define BR_APBH_CHn_BAR_ADDRESS(x, n) (HW_APBH_CHn_BAR(x, n).U)
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_SEMA - APBH DMA Channel n Semaphore Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_SEMA - APBH DMA Channel n Semaphore Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The APBH DMA Channel n semaphore register is used to synchronize the ARM
 * platform instruction stream and the DMA chain processing state. Each DMA channel
 * has an 8 bit counting semaphore that is used to synchronize between the program
 * stream and and the DMA chain processing. DMA processing continues until the
 * DMA attempts to decrement a semaphore that has already reached a value of zero.
 * When the attempt is made, the DMA channel is stalled until software
 * increments the semaphore count. EXAMPLE BF_WR(APBH_CHn_SEMA, 0, INCREMENT_SEMA, 2); //
 * increment semaphore by two current_sema = BF_RD(APBH_CHn_SEMA, 0, PHORE); //
 * get instantaneous value
 */
typedef union _hw_apbh_chn_sema
{
    uint32_t U;
    struct _hw_apbh_chn_sema_bitfields
    {
        uint32_t INCREMENT_SEMA : 8;   /*!< [7:0]  */
        uint32_t RESERVED0 : 8;        /*!< [15:8]  */
        uint32_t PHORE : 8;            /*!< [23:16]  */
        uint32_t RESERVED1 : 8;        /*!< [31:24]  */
    } B;
} hw_apbh_chn_sema_t;

/*!
 * @name Constants and macros for entire APBH_CHn_SEMA register
 */
/*@{*/
#define HW_APBH_CHn_SEMA_COUNT (16U)

#define HW_APBH_CHn_SEMA_ADDR(x, n) ((uintptr_t)(x) + 0x140U + (0x70U * (n)))

#define HW_APBH_CHn_SEMA(x, n)   (*(__IO hw_apbh_chn_sema_t *) HW_APBH_CHn_SEMA_ADDR(x, n))
#define HW_APBH_CHn_SEMA_RD(x, n) (HW_APBH_CHn_SEMA(x, n).U)
#define HW_APBH_CHn_SEMA_WR(x, n, v) (HW_APBH_CHn_SEMA(x, n).U = (v))
#define HW_APBH_CHn_SEMA_SET(x, n, v) (HW_APBH_CHn_SEMA_WR(x, n, HW_APBH_CHn_SEMA_RD(x, n) |  (v)))
#define HW_APBH_CHn_SEMA_CLR(x, n, v) (HW_APBH_CHn_SEMA_WR(x, n, HW_APBH_CHn_SEMA_RD(x, n) & ~(v)))
#define HW_APBH_CHn_SEMA_TOG(x, n, v) (HW_APBH_CHn_SEMA_WR(x, n, HW_APBH_CHn_SEMA_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_SEMA bitfields
 */

/*!
 * @name Register APBH_CHn_SEMA, field INCREMENT_SEMA[7:0] (RW)
 *
 * The value written to this field is added to the semaphore count in an atomic
 * way such that simultaneous software adds and DMA hardware substracts happening
 * on the same clock are protected. This bit field reads back a value of 0x00.
 * Writing a value of 0x02 increments the semaphore count by two, unless the DMA
 * channel decrements the count on the same clock, then the count is incremented
 * by a net one.
 */
/*@{*/
#define BP_APBH_CHn_SEMA_INCREMENT_SEMA (0U) /*!< Bit position for APBH_CHn_SEMA_INCREMENT_SEMA. */
#define BM_APBH_CHn_SEMA_INCREMENT_SEMA (0x000000FFU) /*!< Bit mask for APBH_CHn_SEMA_INCREMENT_SEMA. */
#define BS_APBH_CHn_SEMA_INCREMENT_SEMA (8U) /*!< Bit field size in bits for APBH_CHn_SEMA_INCREMENT_SEMA. */

/*! @brief Read current value of the APBH_CHn_SEMA_INCREMENT_SEMA field. */
#define BR_APBH_CHn_SEMA_INCREMENT_SEMA(x, n) (HW_APBH_CHn_SEMA(x, n).B.INCREMENT_SEMA)

/*! @brief Format value for bitfield APBH_CHn_SEMA_INCREMENT_SEMA. */
#define BF_APBH_CHn_SEMA_INCREMENT_SEMA(v) ((uint32_t)((uint32_t)(v) << BP_APBH_CHn_SEMA_INCREMENT_SEMA) & BM_APBH_CHn_SEMA_INCREMENT_SEMA)

/*! @brief Set the INCREMENT_SEMA field to a new value. */
#define BW_APBH_CHn_SEMA_INCREMENT_SEMA(x, n, v) (HW_APBH_CHn_SEMA_WR(x, n, (HW_APBH_CHn_SEMA_RD(x, n) & ~BM_APBH_CHn_SEMA_INCREMENT_SEMA) | BF_APBH_CHn_SEMA_INCREMENT_SEMA(v)))
/*@}*/

/*!
 * @name Register APBH_CHn_SEMA, field PHORE[23:16] (RO)
 *
 * This read-only field shows the current (instantaneous) value of the semaphore
 * counter.
 */
/*@{*/
#define BP_APBH_CHn_SEMA_PHORE (16U)       /*!< Bit position for APBH_CHn_SEMA_PHORE. */
#define BM_APBH_CHn_SEMA_PHORE (0x00FF0000U) /*!< Bit mask for APBH_CHn_SEMA_PHORE. */
#define BS_APBH_CHn_SEMA_PHORE (8U)        /*!< Bit field size in bits for APBH_CHn_SEMA_PHORE. */

/*! @brief Read current value of the APBH_CHn_SEMA_PHORE field. */
#define BR_APBH_CHn_SEMA_PHORE(x, n) (HW_APBH_CHn_SEMA(x, n).B.PHORE)
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_DEBUG1 - AHB to APBH DMA Channel n Debug Information
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_DEBUG1 - AHB to APBH DMA Channel n Debug Information (RO)
 *
 * Reset value: 0x00A00000U
 *
 * This register gives debug visibility into the APBH DMA Channel n state
 * machine and controls. This register allows debug visibility of the APBH DMA Channel
 * n.
 */
typedef union _hw_apbh_chn_debug1
{
    uint32_t U;
    struct _hw_apbh_chn_debug1_bitfields
    {
        uint32_t STATEMACHINE : 5;     /*!< [4:0]  */
        uint32_t RSVD1 : 15;           /*!< [19:5]  */
        uint32_t WR_FIFO_FULL : 1;     /*!< [20]  */
        uint32_t WR_FIFO_EMPTY : 1;    /*!< [21]  */
        uint32_t RD_FIFO_FULL : 1;     /*!< [22]  */
        uint32_t RD_FIFO_EMPTY : 1;    /*!< [23]  */
        uint32_t NEXTCMDADDRVALID : 1; /*!< [24]  */
        uint32_t LOCK : 1;             /*!< [25]  */
        uint32_t READY : 1;            /*!< [26]  */
        uint32_t SENSE : 1;            /*!< [27]  */
        uint32_t END : 1;              /*!< [28]  */
        uint32_t KICK : 1;             /*!< [29]  */
        uint32_t BURST : 1;            /*!< [30]  */
        uint32_t REQ : 1;              /*!< [31]  */
    } B;
} hw_apbh_chn_debug1_t;

/*!
 * @name Constants and macros for entire APBH_CHn_DEBUG1 register
 */
/*@{*/
#define HW_APBH_CHn_DEBUG1_COUNT (16U)

#define HW_APBH_CHn_DEBUG1_ADDR(x, n) ((uintptr_t)(x) + 0x150U + (0x70U * (n)))

#define HW_APBH_CHn_DEBUG1(x, n) (*(__I hw_apbh_chn_debug1_t *) HW_APBH_CHn_DEBUG1_ADDR(x, n))
#define HW_APBH_CHn_DEBUG1_RD(x, n) (HW_APBH_CHn_DEBUG1(x, n).U)
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_DEBUG1 bitfields
 */

/*!
 * @name Register APBH_CHn_DEBUG1, field STATEMACHINE[4:0] (RO)
 *
 * PIO Display of the DMA Channel n state machine state.
 *
 * Values:
 * - 0 - This is the idle state of the DMA state machine.
 * - 1 - State in which the DMA is waiting to receive the first word of a
 *     command.
 * - 10 - State in which the DMA is waiting to receive the third word of a
 *     command.
 * - 11 - State in which the DMA is waiting to receive the second word of a
 *     command.
 * - 100 - The state machine processes the descriptor command field in this
 *     state and branches accordingly.
 * - 101 - The state machine waits in this state for the PIO APB cycles to
 *     complete.
 * - 110 - State in which the DMA is waiting to receive the fourth word of a
 *     command, or waiting to receive the PIO words when PIO count is greater than 1.
 * - 111 - This state determines whether another PIO cycle needs to occur before
 *     starting DMA transfers.
 * - 1000 - During a read transfers, the state machine enters this state waiting
 *     for the last bytes to be pushed out on the APB.
 * - 1001 - When an AHB read request occurs, the state machine waits in this
 *     state for the AHB transfer to complete.
 * - 1100 - During DMA Write transfers, the state machine waits in this state
 *     until the AHB master arbiter accepts the request from this channel.
 * - 1101 - During DMA Read transfers, the state machine waits in this state
 *     until the AHB master arbiter accepts the request from this channel.
 * - 1110 - Upon completion of the DMA transfers, this state checks the value of
 *     the Chain bit and branches accordingly.
 * - 1111 - The state machine goes to this state after the DMA transfers are
 *     complete, and determines what step to take next.
 * - 10100 - When a terminate signal is set, the state machine enters this state
 *     until the current AHB transfer is completed.
 * - 10101 - When the Wait for Command End bit is set, the state machine enters
 *     this state until the DMA device indicates that the command is complete.
 * - 11100 - During DMA Write transfers, the state machine waits in this state
 *     until the AHB master completes the write to the AHB memory space.
 * - 11101 - If HALTONTERMINATE is set and a terminate signal is set, the state
 *     machine enters this state and effectively halts. A channel reset is
 *     required to exit this state
 * - 11110 - If the Chain bit is a 0, the state machine enters this state and
 *     effectively halts.
 * - 11111 - When the NAND Wait for Ready bit is set, the state machine enters
 *     this state until the GPMI device indicates that the external device is
 *     ready.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_STATEMACHINE (0U) /*!< Bit position for APBH_CHn_DEBUG1_STATEMACHINE. */
#define BM_APBH_CHn_DEBUG1_STATEMACHINE (0x0000001FU) /*!< Bit mask for APBH_CHn_DEBUG1_STATEMACHINE. */
#define BS_APBH_CHn_DEBUG1_STATEMACHINE (5U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_STATEMACHINE. */

#define BV_APBH_CHn_DEBUG1_STATEMACHINE_IDLE (0U)    /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: This is the idle state of the DMA state machine. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_REQ_CMD1 (0x1U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: State in which the DMA is waiting to receive the first word of a command. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_REQ_CMD3 (0x2U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: State in which the DMA is waiting to receive the third word of a command. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_REQ_CMD2 (0x3U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: State in which the DMA is waiting to receive the second word of a command. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_XFER_DECODE (0x4U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: The state machine processes the descriptor command field in this state and branches accordingly. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_REQ_WAIT (0x5U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: The state machine waits in this state for the PIO APB cycles to complete. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_REQ_CMD4 (0x6U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: State in which the DMA is waiting to receive the fourth word of a command, or waiting to receive the PIO words when PIO count is greater than 1. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_PIO_REQ (0x7U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: This state determines whether another PIO cycle needs to occur before starting DMA transfers. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_READ_FLUSH (0x8U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: During a read transfers, the state machine enters this state waiting for the last bytes to be pushed out on the APB. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_READ_WAIT (0x9U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: When an AHB read request occurs, the state machine waits in this state for the AHB transfer to complete. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_WRITE (0xCU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: During DMA Write transfers, the state machine waits in this state until the AHB master arbiter accepts the request from this channel. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_READ_REQ (0xDU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: During DMA Read transfers, the state machine waits in this state until the AHB master arbiter accepts the request from this channel. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_CHECK_CHAIN (0xEU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: Upon completion of the DMA transfers, this state checks the value of the Chain bit and branches accordingly. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_XFER_COMPLETE (0xFU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: The state machine goes to this state after the DMA transfers are complete, and determines what step to take next. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_TERMINATE (0x14U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: When a terminate signal is set, the state machine enters this state until the current AHB transfer is completed. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_WAIT_END (0x15U) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: When the Wait for Command End bit is set, the state machine enters this state until the DMA device indicates that the command is complete. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_WRITE_WAIT (0x1CU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: During DMA Write transfers, the state machine waits in this state until the AHB master completes the write to the AHB memory space. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_HALT_AFTER_TERM (0x1DU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: If HALTONTERMINATE is set and a terminate signal is set, the state machine enters this state and effectively halts. A channel reset is required to exit this state */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_CHECK_WAIT (0x1EU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: If the Chain bit is a 0, the state machine enters this state and effectively halts. */
#define BV_APBH_CHn_DEBUG1_STATEMACHINE_WAIT_READY (0x1FU) /*!< Bit field value for APBH_CHn_DEBUG1_STATEMACHINE: When the NAND Wait for Ready bit is set, the state machine enters this state until the GPMI device indicates that the external device is ready. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_STATEMACHINE field. */
#define BR_APBH_CHn_DEBUG1_STATEMACHINE(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.STATEMACHINE)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field RSVD1[19:5] (RU)
 *
 * Reserved
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_RSVD1 (5U)      /*!< Bit position for APBH_CHn_DEBUG1_RSVD1. */
#define BM_APBH_CHn_DEBUG1_RSVD1 (0x000FFFE0U) /*!< Bit mask for APBH_CHn_DEBUG1_RSVD1. */
#define BS_APBH_CHn_DEBUG1_RSVD1 (15U)     /*!< Bit field size in bits for APBH_CHn_DEBUG1_RSVD1. */
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field WR_FIFO_FULL[20] (RO)
 *
 * This bit reflects the current state of the DMA Channel's Write FIFO Full
 * signal.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_WR_FIFO_FULL (20U) /*!< Bit position for APBH_CHn_DEBUG1_WR_FIFO_FULL. */
#define BM_APBH_CHn_DEBUG1_WR_FIFO_FULL (0x00100000U) /*!< Bit mask for APBH_CHn_DEBUG1_WR_FIFO_FULL. */
#define BS_APBH_CHn_DEBUG1_WR_FIFO_FULL (1U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_WR_FIFO_FULL. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_WR_FIFO_FULL field. */
#define BR_APBH_CHn_DEBUG1_WR_FIFO_FULL(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.WR_FIFO_FULL)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field WR_FIFO_EMPTY[21] (RO)
 *
 * This bit reflects the current state of the DMA Channel's Write FIFO Empty
 * signal.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_WR_FIFO_EMPTY (21U) /*!< Bit position for APBH_CHn_DEBUG1_WR_FIFO_EMPTY. */
#define BM_APBH_CHn_DEBUG1_WR_FIFO_EMPTY (0x00200000U) /*!< Bit mask for APBH_CHn_DEBUG1_WR_FIFO_EMPTY. */
#define BS_APBH_CHn_DEBUG1_WR_FIFO_EMPTY (1U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_WR_FIFO_EMPTY. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_WR_FIFO_EMPTY field. */
#define BR_APBH_CHn_DEBUG1_WR_FIFO_EMPTY(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.WR_FIFO_EMPTY)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field RD_FIFO_FULL[22] (RO)
 *
 * This bit reflects the current state of the DMA Channel's Read FIFO Full
 * signal.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_RD_FIFO_FULL (22U) /*!< Bit position for APBH_CHn_DEBUG1_RD_FIFO_FULL. */
#define BM_APBH_CHn_DEBUG1_RD_FIFO_FULL (0x00400000U) /*!< Bit mask for APBH_CHn_DEBUG1_RD_FIFO_FULL. */
#define BS_APBH_CHn_DEBUG1_RD_FIFO_FULL (1U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_RD_FIFO_FULL. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_RD_FIFO_FULL field. */
#define BR_APBH_CHn_DEBUG1_RD_FIFO_FULL(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.RD_FIFO_FULL)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field RD_FIFO_EMPTY[23] (RO)
 *
 * This bit reflects the current state of the DMA Channel's Read FIFO Empty
 * signal.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_RD_FIFO_EMPTY (23U) /*!< Bit position for APBH_CHn_DEBUG1_RD_FIFO_EMPTY. */
#define BM_APBH_CHn_DEBUG1_RD_FIFO_EMPTY (0x00800000U) /*!< Bit mask for APBH_CHn_DEBUG1_RD_FIFO_EMPTY. */
#define BS_APBH_CHn_DEBUG1_RD_FIFO_EMPTY (1U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_RD_FIFO_EMPTY. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_RD_FIFO_EMPTY field. */
#define BR_APBH_CHn_DEBUG1_RD_FIFO_EMPTY(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.RD_FIFO_EMPTY)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field NEXTCMDADDRVALID[24] (RO)
 *
 * This bit reflects the internal bit which indicates whether the channel's next
 * command address is valid.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_NEXTCMDADDRVALID (24U) /*!< Bit position for APBH_CHn_DEBUG1_NEXTCMDADDRVALID. */
#define BM_APBH_CHn_DEBUG1_NEXTCMDADDRVALID (0x01000000U) /*!< Bit mask for APBH_CHn_DEBUG1_NEXTCMDADDRVALID. */
#define BS_APBH_CHn_DEBUG1_NEXTCMDADDRVALID (1U) /*!< Bit field size in bits for APBH_CHn_DEBUG1_NEXTCMDADDRVALID. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_NEXTCMDADDRVALID field. */
#define BR_APBH_CHn_DEBUG1_NEXTCMDADDRVALID(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.NEXTCMDADDRVALID)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field LOCK[25] (RU)
 *
 * This bit is reserved for this Channel and always reads 0.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_LOCK (25U)      /*!< Bit position for APBH_CHn_DEBUG1_LOCK. */
#define BM_APBH_CHn_DEBUG1_LOCK (0x02000000U) /*!< Bit mask for APBH_CHn_DEBUG1_LOCK. */
#define BS_APBH_CHn_DEBUG1_LOCK (1U)       /*!< Bit field size in bits for APBH_CHn_DEBUG1_LOCK. */
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field READY[26] (RO)
 *
 * This bit is reserved for this DMA Channel and always reads 0.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_READY (26U)     /*!< Bit position for APBH_CHn_DEBUG1_READY. */
#define BM_APBH_CHn_DEBUG1_READY (0x04000000U) /*!< Bit mask for APBH_CHn_DEBUG1_READY. */
#define BS_APBH_CHn_DEBUG1_READY (1U)      /*!< Bit field size in bits for APBH_CHn_DEBUG1_READY. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_READY field. */
#define BR_APBH_CHn_DEBUG1_READY(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.READY)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field SENSE[27] (RU)
 *
 * This bit is reserved for this DMA Channel and always reads 0.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_SENSE (27U)     /*!< Bit position for APBH_CHn_DEBUG1_SENSE. */
#define BM_APBH_CHn_DEBUG1_SENSE (0x08000000U) /*!< Bit mask for APBH_CHn_DEBUG1_SENSE. */
#define BS_APBH_CHn_DEBUG1_SENSE (1U)      /*!< Bit field size in bits for APBH_CHn_DEBUG1_SENSE. */
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field END[28] (RO)
 *
 * This bit reflects the current state of the DMA End Command Signal sent from
 * the APB Device
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_END (28U)       /*!< Bit position for APBH_CHn_DEBUG1_END. */
#define BM_APBH_CHn_DEBUG1_END (0x10000000U) /*!< Bit mask for APBH_CHn_DEBUG1_END. */
#define BS_APBH_CHn_DEBUG1_END (1U)        /*!< Bit field size in bits for APBH_CHn_DEBUG1_END. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_END field. */
#define BR_APBH_CHn_DEBUG1_END(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.END)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field KICK[29] (RO)
 *
 * This bit reflects the current state of the DMA Kick Signal sent to the APB
 * Device
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_KICK (29U)      /*!< Bit position for APBH_CHn_DEBUG1_KICK. */
#define BM_APBH_CHn_DEBUG1_KICK (0x20000000U) /*!< Bit mask for APBH_CHn_DEBUG1_KICK. */
#define BS_APBH_CHn_DEBUG1_KICK (1U)       /*!< Bit field size in bits for APBH_CHn_DEBUG1_KICK. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_KICK field. */
#define BR_APBH_CHn_DEBUG1_KICK(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.KICK)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field BURST[30] (RO)
 *
 * This bit reflects the current state of the DMA Burst Signal from the APB
 * device
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_BURST (30U)     /*!< Bit position for APBH_CHn_DEBUG1_BURST. */
#define BM_APBH_CHn_DEBUG1_BURST (0x40000000U) /*!< Bit mask for APBH_CHn_DEBUG1_BURST. */
#define BS_APBH_CHn_DEBUG1_BURST (1U)      /*!< Bit field size in bits for APBH_CHn_DEBUG1_BURST. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_BURST field. */
#define BR_APBH_CHn_DEBUG1_BURST(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.BURST)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG1, field REQ[31] (RO)
 *
 * This bit reflects the current state of the DMA Request Signal from the APB
 * device
 */
/*@{*/
#define BP_APBH_CHn_DEBUG1_REQ (31U)       /*!< Bit position for APBH_CHn_DEBUG1_REQ. */
#define BM_APBH_CHn_DEBUG1_REQ (0x80000000U) /*!< Bit mask for APBH_CHn_DEBUG1_REQ. */
#define BS_APBH_CHn_DEBUG1_REQ (1U)        /*!< Bit field size in bits for APBH_CHn_DEBUG1_REQ. */

/*! @brief Read current value of the APBH_CHn_DEBUG1_REQ field. */
#define BR_APBH_CHn_DEBUG1_REQ(x, n) (HW_APBH_CHn_DEBUG1(x, n).B.REQ)
/*@}*/
/*******************************************************************************
 * HW_APBH_CHn_DEBUG2 - AHB to APBH DMA Channel n Debug Information
 ******************************************************************************/

/*!
 * @brief HW_APBH_CHn_DEBUG2 - AHB to APBH DMA Channel n Debug Information (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register gives debug visibility for the APB and AHB byte counts for DMA
 * Channel n. This register allows debug visibility of the APBH DMA Channel n.
 */
typedef union _hw_apbh_chn_debug2
{
    uint32_t U;
    struct _hw_apbh_chn_debug2_bitfields
    {
        uint32_t AHB_BYTES : 16;       /*!< [15:0]  */
        uint32_t APB_BYTES : 16;       /*!< [31:16]  */
    } B;
} hw_apbh_chn_debug2_t;

/*!
 * @name Constants and macros for entire APBH_CHn_DEBUG2 register
 */
/*@{*/
#define HW_APBH_CHn_DEBUG2_COUNT (16U)

#define HW_APBH_CHn_DEBUG2_ADDR(x, n) ((uintptr_t)(x) + 0x160U + (0x70U * (n)))

#define HW_APBH_CHn_DEBUG2(x, n) (*(__I hw_apbh_chn_debug2_t *) HW_APBH_CHn_DEBUG2_ADDR(x, n))
#define HW_APBH_CHn_DEBUG2_RD(x, n) (HW_APBH_CHn_DEBUG2(x, n).U)
/*@}*/

/*
 * Constants & macros for individual APBH_CHn_DEBUG2 bitfields
 */

/*!
 * @name Register APBH_CHn_DEBUG2, field AHB_BYTES[15:0] (RO)
 *
 * This value reflects the current number of AHB bytes remaining to be
 * transfered in the current transfer.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG2_AHB_BYTES (0U)  /*!< Bit position for APBH_CHn_DEBUG2_AHB_BYTES. */
#define BM_APBH_CHn_DEBUG2_AHB_BYTES (0x0000FFFFU) /*!< Bit mask for APBH_CHn_DEBUG2_AHB_BYTES. */
#define BS_APBH_CHn_DEBUG2_AHB_BYTES (16U) /*!< Bit field size in bits for APBH_CHn_DEBUG2_AHB_BYTES. */

/*! @brief Read current value of the APBH_CHn_DEBUG2_AHB_BYTES field. */
#define BR_APBH_CHn_DEBUG2_AHB_BYTES(x, n) (HW_APBH_CHn_DEBUG2(x, n).B.AHB_BYTES)
/*@}*/

/*!
 * @name Register APBH_CHn_DEBUG2, field APB_BYTES[31:16] (RO)
 *
 * This value reflects the current number of APB bytes remaining to be
 * transfered in the current transfer.
 */
/*@{*/
#define BP_APBH_CHn_DEBUG2_APB_BYTES (16U) /*!< Bit position for APBH_CHn_DEBUG2_APB_BYTES. */
#define BM_APBH_CHn_DEBUG2_APB_BYTES (0xFFFF0000U) /*!< Bit mask for APBH_CHn_DEBUG2_APB_BYTES. */
#define BS_APBH_CHn_DEBUG2_APB_BYTES (16U) /*!< Bit field size in bits for APBH_CHn_DEBUG2_APB_BYTES. */

/*! @brief Read current value of the APBH_CHn_DEBUG2_APB_BYTES field. */
#define BR_APBH_CHn_DEBUG2_APB_BYTES(x, n) (HW_APBH_CHn_DEBUG2(x, n).B.APB_BYTES)
/*@}*/

/*******************************************************************************
 * HW_APBH_VERSION - APBH Bridge Version Register
 ******************************************************************************/

/*!
 * @brief HW_APBH_VERSION - APBH Bridge Version Register (RO)
 *
 * Reset value: 0x03010000U
 *
 * This register always returns a known read value for debug purposes it
 * indicates the version of the block. This register indicates the RTL version in use.
 * EXAMPLE if (APBH_VERSION.B.MAJOR != 3) Error();
 */
typedef union _hw_apbh_version
{
    uint32_t U;
    struct _hw_apbh_version_bitfields
    {
        uint32_t STEP : 16;            /*!< [15:0]  */
        uint32_t MINOR : 8;            /*!< [23:16]  */
        uint32_t MAJOR : 8;            /*!< [31:24]  */
    } B;
} hw_apbh_version_t;

/*!
 * @name Constants and macros for entire APBH_VERSION register
 */
/*@{*/
#define HW_APBH_VERSION_ADDR(x)  ((uintptr_t)(x) + 0x800U)

#define HW_APBH_VERSION(x)       (*(__I hw_apbh_version_t *) HW_APBH_VERSION_ADDR(x))
#define HW_APBH_VERSION_RD(x)    (HW_APBH_VERSION(x).U)
/*@}*/

/*
 * Constants & macros for individual APBH_VERSION bitfields
 */

/*!
 * @name Register APBH_VERSION, field STEP[15:0] (RO)
 *
 * Fixed read-only value reflecting the stepping of the RTL version.
 */
/*@{*/
#define BP_APBH_VERSION_STEP (0U)          /*!< Bit position for APBH_VERSION_STEP. */
#define BM_APBH_VERSION_STEP (0x0000FFFFU) /*!< Bit mask for APBH_VERSION_STEP. */
#define BS_APBH_VERSION_STEP (16U)         /*!< Bit field size in bits for APBH_VERSION_STEP. */

/*! @brief Read current value of the APBH_VERSION_STEP field. */
#define BR_APBH_VERSION_STEP(x) (HW_APBH_VERSION(x).B.STEP)
/*@}*/

/*!
 * @name Register APBH_VERSION, field MINOR[23:16] (RO)
 *
 * Fixed read-only value reflecting the MINOR field of the RTL version.
 */
/*@{*/
#define BP_APBH_VERSION_MINOR (16U)        /*!< Bit position for APBH_VERSION_MINOR. */
#define BM_APBH_VERSION_MINOR (0x00FF0000U) /*!< Bit mask for APBH_VERSION_MINOR. */
#define BS_APBH_VERSION_MINOR (8U)         /*!< Bit field size in bits for APBH_VERSION_MINOR. */

/*! @brief Read current value of the APBH_VERSION_MINOR field. */
#define BR_APBH_VERSION_MINOR(x) (HW_APBH_VERSION(x).B.MINOR)
/*@}*/

/*!
 * @name Register APBH_VERSION, field MAJOR[31:24] (RO)
 *
 * Fixed read-only value reflecting the MAJOR field of the RTL version.
 */
/*@{*/
#define BP_APBH_VERSION_MAJOR (24U)        /*!< Bit position for APBH_VERSION_MAJOR. */
#define BM_APBH_VERSION_MAJOR (0xFF000000U) /*!< Bit mask for APBH_VERSION_MAJOR. */
#define BS_APBH_VERSION_MAJOR (8U)         /*!< Bit field size in bits for APBH_VERSION_MAJOR. */

/*! @brief Read current value of the APBH_VERSION_MAJOR field. */
#define BR_APBH_VERSION_MAJOR(x) (HW_APBH_VERSION(x).B.MAJOR)
/*@}*/

/*******************************************************************************
 * hw_apbh_t - module struct
 ******************************************************************************/
/*!
 * @brief All APBH module registers.
 */
#pragma pack(1)
typedef struct _hw_apbh
{
    __IO hw_apbh_ctrl0_t CTRL0;            /*!< [0x0] AHB to APBH Bridge Control and Status Register 0 */
    uint8_t _reserved0[12];
    __IO hw_apbh_ctrl1_t CTRL1;            /*!< [0x10] AHB to APBH Bridge Control and Status Register 1 */
    uint8_t _reserved1[12];
    __IO hw_apbh_ctrl2_t CTRL2;            /*!< [0x20] AHB to APBH Bridge Control and Status Register 2 */
    uint8_t _reserved2[12];
    __IO hw_apbh_channel_ctrl_t CHANNEL_CTRL; /*!< [0x30] AHB to APBH Bridge Channel Register */
    uint8_t _reserved3[12];
    __I hw_apbh_devsel_t DEVSEL;           /*!< [0x40] AHB to APBH DMA Device Assignment Register */
    uint8_t _reserved4[12];
    __IO hw_apbh_dma_burst_size_t DMA_BURST_SIZE; /*!< [0x50] AHB to APBH DMA burst size */
    uint8_t _reserved5[12];
    __IO hw_apbh_debug_t DEBUGr;           /*!< [0x60] AHB to APBH DMA Debug Register */
    uint8_t _reserved6[156];
    struct {
        __I hw_apbh_chn_curcmdar_t CHn_CURCMDAR; /*!< [0x100] APBH DMA Channel n Current Command Address Register */
        uint8_t _reserved0[12];
        __IO hw_apbh_chn_nxtcmdar_t CHn_NXTCMDAR; /*!< [0x110] APBH DMA Channel n Next Command Address Register */
        uint8_t _reserved1[12];
        __I hw_apbh_chn_cmd_t CHn_CMD;     /*!< [0x120] APBH DMA Channel n Command Register */
        uint8_t _reserved2[12];
        __I hw_apbh_chn_bar_t CHn_BAR;     /*!< [0x130] APBH DMA Channel n Buffer Address Register */
        uint8_t _reserved3[12];
        __IO hw_apbh_chn_sema_t CHn_SEMA;  /*!< [0x140] APBH DMA Channel n Semaphore Register */
        uint8_t _reserved4[12];
        __I hw_apbh_chn_debug1_t CHn_DEBUG1; /*!< [0x150] AHB to APBH DMA Channel n Debug Information */
        uint8_t _reserved5[12];
        __I hw_apbh_chn_debug2_t CHn_DEBUG2; /*!< [0x160] AHB to APBH DMA Channel n Debug Information */
        uint8_t _reserved6[12];
    } CH[16];
    __I hw_apbh_version_t VERSION;         /*!< [0x800] APBH Bridge Version Register */
} hw_apbh_t;
#pragma pack()

/*! @brief Macro to access all APBH registers. */
/*! @param x APBH module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_APBH_REGS(APBH_BASE)</code>. */
#define HW_APBH_REGS(x) (*(hw_apbh_t *)(x))

/*
 * iMX7S BCH
 *
 * BCH Register Reference Index
 *
 * Registers defined in this header file:
 * - HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register
 * - HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0
 * - HW_BCH_MODE - Hardware ECC Accelerator Mode Register
 * - HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register
 * - HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register
 * - HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register
 * - HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register
 * - HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register
 * - HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register
 * - HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register
 * - HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register
 * - HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register
 * - HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register
 * - HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register
 * - HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register
 * - HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0
 * - HW_BCH_DBGKESREAD - KES Debug Read Register
 * - HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register
 * - HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register
 * - HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register
 * - HW_BCH_BLOCKNAME - Block Name Register
 * - HW_BCH_VERSION - BCH Version Register
 * - HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1
 *
 * - hw_bch_t - Struct containing all module registers.
 */

#define HW_BCH_INSTANCE_COUNT (1U) /*!< Number of instances of the BCH module. */
#define HW_BCH (0U) /*!< Instance number for BCH. */
#define BCH_BASE              (0x33004000U) /*!< Base address for BCH. */
/*! Array initializer of BCH base addresses. */
#define BCH_BASE_ADDRS        { BCH_BASE }

/*******************************************************************************
 * HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_CTRL - Hardware BCH ECC Accelerator Control Register (RW)
 *
 * Reset value: 0xC0000000U
 *
 * The BCH CTRL provides overall control of the hardware ECC accelerator
 */
typedef union _hw_bch_ctrl
{
    uint32_t U;
    struct _hw_bch_ctrl_bitfields
    {
        uint32_t COMPLETE_IRQ : 1;     /*!< [0]  */
        uint32_t RSVD0 : 1;            /*!< [1] This field is reserved. */
        uint32_t DEBUG_STALL_IRQ : 1;  /*!< [2]  */
        uint32_t BM_ERROR_IRQ : 1;     /*!< [3]  */
        uint32_t RSVD1 : 4;            /*!< [7:4] This field is reserved. */
        uint32_t COMPLETE_IRQ_EN : 1;  /*!< [8]  */
        uint32_t RSVD2 : 1;            /*!< [9] This field is reserved. */
        uint32_t DEBUG_STALL_IRQ_EN : 1; /*!< [10]  */
        uint32_t RSVD3 : 5;            /*!< [15:11] This field is reserved. */
        uint32_t M2M_ENABLE : 1;       /*!< [16]  */
        uint32_t M2M_ENCODE : 1;       /*!< [17]  */
        uint32_t M2M_LAYOUT : 2;       /*!< [19:18]  */
        uint32_t RSVD4 : 2;            /*!< [21:20] This field is reserved. */
        uint32_t DEBUGSYNDROME : 1;    /*!< [22]  */
        uint32_t RSVD5 : 7;            /*!< [29:23] This field is reserved. */
        uint32_t CLKGATE : 1;          /*!< [30]  */
        uint32_t SFTRST : 1;           /*!< [31]  */
    } B;
} hw_bch_ctrl_t;

/*!
 * @name Constants and macros for entire BCH_CTRL register
 */
/*@{*/
#define HW_BCH_CTRL_ADDR(x)      ((uintptr_t)(x) + 0x0U)
#define HW_BCH_CTRL_SET_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0x4U)
#define HW_BCH_CTRL_CLR_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0x8U)
#define HW_BCH_CTRL_TOG_ADDR(x)  (HW_BCH_CTRL_ADDR(x) + 0xCU)

#define HW_BCH_CTRL(x)           (*(__IO hw_bch_ctrl_t *) HW_BCH_CTRL_ADDR(x))
#define HW_BCH_CTRL_RD(x)        (HW_BCH_CTRL(x).U)
#define HW_BCH_CTRL_WR(x, v)     (HW_BCH_CTRL(x).U = (v))
#define HW_BCH_CTRL_SET(x, v)    ((*(uint32_t *) HW_BCH_CTRL_SET_ADDR(x)) = (v))
#define HW_BCH_CTRL_CLR(x, v)    ((*(uint32_t *) HW_BCH_CTRL_CLR_ADDR(x)) = (v))
#define HW_BCH_CTRL_TOG(x, v)    ((*(uint32_t *) HW_BCH_CTRL_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_CTRL bitfields
 */

/*!
 * @name Register BCH_CTRL, field COMPLETE_IRQ[0] (RW)
 *
 * This bit indicates the state of the external interrupt line. Write a 1 to the
 * SCT clear address to clear the interrupt status bit. NOTE: subsequent ECC
 * completions will be held off as long as this bit is set. Be sure to read the data
 * from BCH_STATUS0, 1 before clearing this interrupt bit.
 */
/*@{*/
#define BP_BCH_CTRL_COMPLETE_IRQ (0U)      /*!< Bit position for BCH_CTRL_COMPLETE_IRQ. */
#define BM_BCH_CTRL_COMPLETE_IRQ (0x00000001U) /*!< Bit mask for BCH_CTRL_COMPLETE_IRQ. */
#define BS_BCH_CTRL_COMPLETE_IRQ (1U)      /*!< Bit field size in bits for BCH_CTRL_COMPLETE_IRQ. */

/*! @brief Read current value of the BCH_CTRL_COMPLETE_IRQ field. */
#define BR_BCH_CTRL_COMPLETE_IRQ(x) (HW_BCH_CTRL(x).B.COMPLETE_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_COMPLETE_IRQ. */
#define BF_BCH_CTRL_COMPLETE_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_COMPLETE_IRQ) & BM_BCH_CTRL_COMPLETE_IRQ)

/*! @brief Set the COMPLETE_IRQ field to a new value. */
#define BW_BCH_CTRL_COMPLETE_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_COMPLETE_IRQ) | BF_BCH_CTRL_COMPLETE_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD0[1] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD0    (1U)          /*!< Bit position for BCH_CTRL_RSVD0. */
#define BM_BCH_CTRL_RSVD0    (0x00000002U) /*!< Bit mask for BCH_CTRL_RSVD0. */
#define BS_BCH_CTRL_RSVD0    (1U)          /*!< Bit field size in bits for BCH_CTRL_RSVD0. */

/*! @brief Read current value of the BCH_CTRL_RSVD0 field. */
#define BR_BCH_CTRL_RSVD0(x) (HW_BCH_CTRL(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUG_STALL_IRQ[2] (RW)
 *
 * DEBUG STALL Interrupt Status. Write a 1 to the SCT clear address to clear the
 * interrupt status bit.
 */
/*@{*/
#define BP_BCH_CTRL_DEBUG_STALL_IRQ (2U)   /*!< Bit position for BCH_CTRL_DEBUG_STALL_IRQ. */
#define BM_BCH_CTRL_DEBUG_STALL_IRQ (0x00000004U) /*!< Bit mask for BCH_CTRL_DEBUG_STALL_IRQ. */
#define BS_BCH_CTRL_DEBUG_STALL_IRQ (1U)   /*!< Bit field size in bits for BCH_CTRL_DEBUG_STALL_IRQ. */

/*! @brief Read current value of the BCH_CTRL_DEBUG_STALL_IRQ field. */
#define BR_BCH_CTRL_DEBUG_STALL_IRQ(x) (HW_BCH_CTRL(x).B.DEBUG_STALL_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_DEBUG_STALL_IRQ. */
#define BF_BCH_CTRL_DEBUG_STALL_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUG_STALL_IRQ) & BM_BCH_CTRL_DEBUG_STALL_IRQ)

/*! @brief Set the DEBUG_STALL_IRQ field to a new value. */
#define BW_BCH_CTRL_DEBUG_STALL_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUG_STALL_IRQ) | BF_BCH_CTRL_DEBUG_STALL_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field BM_ERROR_IRQ[3] (RW)
 *
 * AHB Bus interface Error Interrupt Status. Write a 1 to the SCT clear address
 * to clear the interrupt status bit.
 */
/*@{*/
#define BP_BCH_CTRL_BM_ERROR_IRQ (3U)      /*!< Bit position for BCH_CTRL_BM_ERROR_IRQ. */
#define BM_BCH_CTRL_BM_ERROR_IRQ (0x00000008U) /*!< Bit mask for BCH_CTRL_BM_ERROR_IRQ. */
#define BS_BCH_CTRL_BM_ERROR_IRQ (1U)      /*!< Bit field size in bits for BCH_CTRL_BM_ERROR_IRQ. */

/*! @brief Read current value of the BCH_CTRL_BM_ERROR_IRQ field. */
#define BR_BCH_CTRL_BM_ERROR_IRQ(x) (HW_BCH_CTRL(x).B.BM_ERROR_IRQ)

/*! @brief Format value for bitfield BCH_CTRL_BM_ERROR_IRQ. */
#define BF_BCH_CTRL_BM_ERROR_IRQ(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_BM_ERROR_IRQ) & BM_BCH_CTRL_BM_ERROR_IRQ)

/*! @brief Set the BM_ERROR_IRQ field to a new value. */
#define BW_BCH_CTRL_BM_ERROR_IRQ(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_BM_ERROR_IRQ) | BF_BCH_CTRL_BM_ERROR_IRQ(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD1[7:4] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD1    (4U)          /*!< Bit position for BCH_CTRL_RSVD1. */
#define BM_BCH_CTRL_RSVD1    (0x000000F0U) /*!< Bit mask for BCH_CTRL_RSVD1. */
#define BS_BCH_CTRL_RSVD1    (4U)          /*!< Bit field size in bits for BCH_CTRL_RSVD1. */

/*! @brief Read current value of the BCH_CTRL_RSVD1 field. */
#define BR_BCH_CTRL_RSVD1(x) (HW_BCH_CTRL(x).B.RSVD1)
/*@}*/

/*!
 * @name Register BCH_CTRL, field COMPLETE_IRQ_EN[8] (RW)
 *
 * 1 = interrupt on completion of correction is enabled.
 */
/*@{*/
#define BP_BCH_CTRL_COMPLETE_IRQ_EN (8U)   /*!< Bit position for BCH_CTRL_COMPLETE_IRQ_EN. */
#define BM_BCH_CTRL_COMPLETE_IRQ_EN (0x00000100U) /*!< Bit mask for BCH_CTRL_COMPLETE_IRQ_EN. */
#define BS_BCH_CTRL_COMPLETE_IRQ_EN (1U)   /*!< Bit field size in bits for BCH_CTRL_COMPLETE_IRQ_EN. */

/*! @brief Read current value of the BCH_CTRL_COMPLETE_IRQ_EN field. */
#define BR_BCH_CTRL_COMPLETE_IRQ_EN(x) (HW_BCH_CTRL(x).B.COMPLETE_IRQ_EN)

/*! @brief Format value for bitfield BCH_CTRL_COMPLETE_IRQ_EN. */
#define BF_BCH_CTRL_COMPLETE_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_COMPLETE_IRQ_EN) & BM_BCH_CTRL_COMPLETE_IRQ_EN)

/*! @brief Set the COMPLETE_IRQ_EN field to a new value. */
#define BW_BCH_CTRL_COMPLETE_IRQ_EN(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_COMPLETE_IRQ_EN) | BF_BCH_CTRL_COMPLETE_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD2[9] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD2    (9U)          /*!< Bit position for BCH_CTRL_RSVD2. */
#define BM_BCH_CTRL_RSVD2    (0x00000200U) /*!< Bit mask for BCH_CTRL_RSVD2. */
#define BS_BCH_CTRL_RSVD2    (1U)          /*!< Bit field size in bits for BCH_CTRL_RSVD2. */

/*! @brief Read current value of the BCH_CTRL_RSVD2 field. */
#define BR_BCH_CTRL_RSVD2(x) (HW_BCH_CTRL(x).B.RSVD2)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUG_STALL_IRQ_EN[10] (RW)
 *
 * 1 = interrupt on debug stall mode is enabled. The IRQ is raised on every block
 */
/*@{*/
#define BP_BCH_CTRL_DEBUG_STALL_IRQ_EN (10U) /*!< Bit position for BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BM_BCH_CTRL_DEBUG_STALL_IRQ_EN (0x00000400U) /*!< Bit mask for BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BS_BCH_CTRL_DEBUG_STALL_IRQ_EN (1U) /*!< Bit field size in bits for BCH_CTRL_DEBUG_STALL_IRQ_EN. */

/*! @brief Read current value of the BCH_CTRL_DEBUG_STALL_IRQ_EN field. */
#define BR_BCH_CTRL_DEBUG_STALL_IRQ_EN(x) (HW_BCH_CTRL(x).B.DEBUG_STALL_IRQ_EN)

/*! @brief Format value for bitfield BCH_CTRL_DEBUG_STALL_IRQ_EN. */
#define BF_BCH_CTRL_DEBUG_STALL_IRQ_EN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUG_STALL_IRQ_EN) & BM_BCH_CTRL_DEBUG_STALL_IRQ_EN)

/*! @brief Set the DEBUG_STALL_IRQ_EN field to a new value. */
#define BW_BCH_CTRL_DEBUG_STALL_IRQ_EN(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUG_STALL_IRQ_EN) | BF_BCH_CTRL_DEBUG_STALL_IRQ_EN(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD3[15:11] (RO)
 *
 * This read-only field is reserved and always has the value 0
 */
/*@{*/
#define BP_BCH_CTRL_RSVD3    (11U)         /*!< Bit position for BCH_CTRL_RSVD3. */
#define BM_BCH_CTRL_RSVD3    (0x0000F800U) /*!< Bit mask for BCH_CTRL_RSVD3. */
#define BS_BCH_CTRL_RSVD3    (5U)          /*!< Bit field size in bits for BCH_CTRL_RSVD3. */

/*! @brief Read current value of the BCH_CTRL_RSVD3 field. */
#define BR_BCH_CTRL_RSVD3(x) (HW_BCH_CTRL(x).B.RSVD3)
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_ENABLE[16] (RW)
 *
 * NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION. The BCH module
 * must be inactive (not processing data from the GPMI) when this bit is set.
 * The M2M_ENCODE and M2M_LAYOUT bits as well as the ENCODEPTR, DATAPTR, and
 * METAPTR registers are used for memory-to-memory operations and must be correctly
 * programmed before writing this bit.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_ENABLE (16U)       /*!< Bit position for BCH_CTRL_M2M_ENABLE. */
#define BM_BCH_CTRL_M2M_ENABLE (0x00010000U) /*!< Bit mask for BCH_CTRL_M2M_ENABLE. */
#define BS_BCH_CTRL_M2M_ENABLE (1U)        /*!< Bit field size in bits for BCH_CTRL_M2M_ENABLE. */

/*! @brief Read current value of the BCH_CTRL_M2M_ENABLE field. */
#define BR_BCH_CTRL_M2M_ENABLE(x) (HW_BCH_CTRL(x).B.M2M_ENABLE)

/*! @brief Format value for bitfield BCH_CTRL_M2M_ENABLE. */
#define BF_BCH_CTRL_M2M_ENABLE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_ENABLE) & BM_BCH_CTRL_M2M_ENABLE)

/*! @brief Set the M2M_ENABLE field to a new value. */
#define BW_BCH_CTRL_M2M_ENABLE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_ENABLE) | BF_BCH_CTRL_M2M_ENABLE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_ENCODE[17] (RW)
 *
 * Selects encode (parity generation) or decode (correction) mode for
 * memory-to-memory operations.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_ENCODE (17U)       /*!< Bit position for BCH_CTRL_M2M_ENCODE. */
#define BM_BCH_CTRL_M2M_ENCODE (0x00020000U) /*!< Bit mask for BCH_CTRL_M2M_ENCODE. */
#define BS_BCH_CTRL_M2M_ENCODE (1U)        /*!< Bit field size in bits for BCH_CTRL_M2M_ENCODE. */

/*! @brief Read current value of the BCH_CTRL_M2M_ENCODE field. */
#define BR_BCH_CTRL_M2M_ENCODE(x) (HW_BCH_CTRL(x).B.M2M_ENCODE)

/*! @brief Format value for bitfield BCH_CTRL_M2M_ENCODE. */
#define BF_BCH_CTRL_M2M_ENCODE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_ENCODE) & BM_BCH_CTRL_M2M_ENCODE)

/*! @brief Set the M2M_ENCODE field to a new value. */
#define BW_BCH_CTRL_M2M_ENCODE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_ENCODE) | BF_BCH_CTRL_M2M_ENCODE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field M2M_LAYOUT[19:18] (RW)
 *
 * Selects the flash page format for memory-to-memory operations.
 */
/*@{*/
#define BP_BCH_CTRL_M2M_LAYOUT (18U)       /*!< Bit position for BCH_CTRL_M2M_LAYOUT. */
#define BM_BCH_CTRL_M2M_LAYOUT (0x000C0000U) /*!< Bit mask for BCH_CTRL_M2M_LAYOUT. */
#define BS_BCH_CTRL_M2M_LAYOUT (2U)        /*!< Bit field size in bits for BCH_CTRL_M2M_LAYOUT. */

/*! @brief Read current value of the BCH_CTRL_M2M_LAYOUT field. */
#define BR_BCH_CTRL_M2M_LAYOUT(x) (HW_BCH_CTRL(x).B.M2M_LAYOUT)

/*! @brief Format value for bitfield BCH_CTRL_M2M_LAYOUT. */
#define BF_BCH_CTRL_M2M_LAYOUT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_M2M_LAYOUT) & BM_BCH_CTRL_M2M_LAYOUT)

/*! @brief Set the M2M_LAYOUT field to a new value. */
#define BW_BCH_CTRL_M2M_LAYOUT(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_M2M_LAYOUT) | BF_BCH_CTRL_M2M_LAYOUT(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD4[21:20] (RO)
 *
 * This read-only field is reserved and always has the value 0
 */
/*@{*/
#define BP_BCH_CTRL_RSVD4    (20U)         /*!< Bit position for BCH_CTRL_RSVD4. */
#define BM_BCH_CTRL_RSVD4    (0x00300000U) /*!< Bit mask for BCH_CTRL_RSVD4. */
#define BS_BCH_CTRL_RSVD4    (2U)          /*!< Bit field size in bits for BCH_CTRL_RSVD4. */

/*! @brief Read current value of the BCH_CTRL_RSVD4 field. */
#define BR_BCH_CTRL_RSVD4(x) (HW_BCH_CTRL(x).B.RSVD4)
/*@}*/

/*!
 * @name Register BCH_CTRL, field DEBUGSYNDROME[22] (RW)
 *
 * (For debug purposes only). Enable write of computed syndromes to memory on
 * BCH decode operations. Computed syndromes will be written to the auxiliary
 * buffer after the status block. Syndromes will be written as padded 16-bit values.
 */
/*@{*/
#define BP_BCH_CTRL_DEBUGSYNDROME (22U)    /*!< Bit position for BCH_CTRL_DEBUGSYNDROME. */
#define BM_BCH_CTRL_DEBUGSYNDROME (0x00400000U) /*!< Bit mask for BCH_CTRL_DEBUGSYNDROME. */
#define BS_BCH_CTRL_DEBUGSYNDROME (1U)     /*!< Bit field size in bits for BCH_CTRL_DEBUGSYNDROME. */

/*! @brief Read current value of the BCH_CTRL_DEBUGSYNDROME field. */
#define BR_BCH_CTRL_DEBUGSYNDROME(x) (HW_BCH_CTRL(x).B.DEBUGSYNDROME)

/*! @brief Format value for bitfield BCH_CTRL_DEBUGSYNDROME. */
#define BF_BCH_CTRL_DEBUGSYNDROME(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_DEBUGSYNDROME) & BM_BCH_CTRL_DEBUGSYNDROME)

/*! @brief Set the DEBUGSYNDROME field to a new value. */
#define BW_BCH_CTRL_DEBUGSYNDROME(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_DEBUGSYNDROME) | BF_BCH_CTRL_DEBUGSYNDROME(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field RSVD5[29:23] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_CTRL_RSVD5    (23U)         /*!< Bit position for BCH_CTRL_RSVD5. */
#define BM_BCH_CTRL_RSVD5    (0x3F800000U) /*!< Bit mask for BCH_CTRL_RSVD5. */
#define BS_BCH_CTRL_RSVD5    (7U)          /*!< Bit field size in bits for BCH_CTRL_RSVD5. */

/*! @brief Read current value of the BCH_CTRL_RSVD5 field. */
#define BR_BCH_CTRL_RSVD5(x) (HW_BCH_CTRL(x).B.RSVD5)
/*@}*/

/*!
 * @name Register BCH_CTRL, field CLKGATE[30] (RW)
 *
 * This bit must be set to 0 for normal operation. When set to 1 it gates off
 * the clocks to the block.
 *
 * Values:
 * - 0 - Allow BCH to operate normally.
 * - 1 - Do not clock BCH gates in order to minimize power consumption.
 */
/*@{*/
#define BP_BCH_CTRL_CLKGATE  (30U)         /*!< Bit position for BCH_CTRL_CLKGATE. */
#define BM_BCH_CTRL_CLKGATE  (0x40000000U) /*!< Bit mask for BCH_CTRL_CLKGATE. */
#define BS_BCH_CTRL_CLKGATE  (1U)          /*!< Bit field size in bits for BCH_CTRL_CLKGATE. */

#define BV_BCH_CTRL_CLKGATE_RUN        (0U)          /*!< Bit field value for BCH_CTRL_CLKGATE: Allow BCH to operate normally. */
#define BV_BCH_CTRL_CLKGATE_NO_CLKS    (0x1U)        /*!< Bit field value for BCH_CTRL_CLKGATE: Do not clock BCH gates in order to minimize power consumption. */

/*! @brief Read current value of the BCH_CTRL_CLKGATE field. */
#define BR_BCH_CTRL_CLKGATE(x) (HW_BCH_CTRL(x).B.CLKGATE)

/*! @brief Format value for bitfield BCH_CTRL_CLKGATE. */
#define BF_BCH_CTRL_CLKGATE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_CLKGATE) & BM_BCH_CTRL_CLKGATE)

/*! @brief Set the CLKGATE field to a new value. */
#define BW_BCH_CTRL_CLKGATE(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_CLKGATE) | BF_BCH_CTRL_CLKGATE(v)))
/*@}*/

/*!
 * @name Register BCH_CTRL, field SFTRST[31] (RW)
 *
 * Set this bit to 0 to enable normal BCH operation. Set this bit to 1 (default)
 * to disable clocking with the BCH and hold it in its reset (lowest power)
 * state. This bit can be turned on and then off to reset the BCH block to its
 * default state. This bit resets all state machines except for the AHB master state
 * machine
 *
 * Values:
 * - 0 - Allow BCH to operate normally.
 * - 1 - Hold BCH in reset.
 */
/*@{*/
#define BP_BCH_CTRL_SFTRST   (31U)         /*!< Bit position for BCH_CTRL_SFTRST. */
#define BM_BCH_CTRL_SFTRST   (0x80000000U) /*!< Bit mask for BCH_CTRL_SFTRST. */
#define BS_BCH_CTRL_SFTRST   (1U)          /*!< Bit field size in bits for BCH_CTRL_SFTRST. */

#define BV_BCH_CTRL_SFTRST_RUN         (0U)          /*!< Bit field value for BCH_CTRL_SFTRST: Allow BCH to operate normally. */
#define BV_BCH_CTRL_SFTRST_RESET       (0x1U)        /*!< Bit field value for BCH_CTRL_SFTRST: Hold BCH in reset. */

/*! @brief Read current value of the BCH_CTRL_SFTRST field. */
#define BR_BCH_CTRL_SFTRST(x) (HW_BCH_CTRL(x).B.SFTRST)

/*! @brief Format value for bitfield BCH_CTRL_SFTRST. */
#define BF_BCH_CTRL_SFTRST(v) ((uint32_t)((uint32_t)(v) << BP_BCH_CTRL_SFTRST) & BM_BCH_CTRL_SFTRST)

/*! @brief Set the SFTRST field to a new value. */
#define BW_BCH_CTRL_SFTRST(x, v) (HW_BCH_CTRL_WR(x, (HW_BCH_CTRL_RD(x) & ~BM_BCH_CTRL_SFTRST) | BF_BCH_CTRL_SFTRST(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0
 ******************************************************************************/

/*!
 * @brief HW_BCH_STATUS0 - Hardware ECC Accelerator Status Register 0 (RO)
 *
 * Reset value: 0x00000010U
 *
 * The BCH STAT register provides visibility into the run-time status of the BCH
 * and status information when processing is complete. It provides overall
 * status of the hardware ECC accelerator.
 */
typedef union _hw_bch_status0
{
    uint32_t U;
    struct _hw_bch_status0_bitfields
    {
        uint32_t RSVD0 : 2;            /*!< [1:0] This field is reserved. */
        uint32_t UNCORRECTABLE : 1;    /*!< [2]  */
        uint32_t CORRECTED : 1;        /*!< [3]  */
        uint32_t ALLONES : 1;          /*!< [4]  */
        uint32_t RSVD1 : 3;            /*!< [7:5] This field is reserved. */
        uint32_t STATUS_BLK0 : 8;      /*!< [15:8]  */
        uint32_t COMPLETED_CE : 4;     /*!< [19:16]  */
        uint32_t HANDLE : 12;          /*!< [31:20]  */
    } B;
} hw_bch_status0_t;

/*!
 * @name Constants and macros for entire BCH_STATUS0 register
 */
/*@{*/
#define HW_BCH_STATUS0_ADDR(x)   ((uintptr_t)(x) + 0x10U)
#define HW_BCH_STATUS0_SET_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0x4U)
#define HW_BCH_STATUS0_CLR_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0x8U)
#define HW_BCH_STATUS0_TOG_ADDR(x) (HW_BCH_STATUS0_ADDR(x) + 0xCU)

#define HW_BCH_STATUS0(x)        (*(__I hw_bch_status0_t *) HW_BCH_STATUS0_ADDR(x))
#define HW_BCH_STATUS0_RD(x)     (HW_BCH_STATUS0(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_STATUS0 bitfields
 */

/*!
 * @name Register BCH_STATUS0, field RSVD0[1:0] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_STATUS0_RSVD0 (0U)          /*!< Bit position for BCH_STATUS0_RSVD0. */
#define BM_BCH_STATUS0_RSVD0 (0x00000003U) /*!< Bit mask for BCH_STATUS0_RSVD0. */
#define BS_BCH_STATUS0_RSVD0 (2U)          /*!< Bit field size in bits for BCH_STATUS0_RSVD0. */

/*! @brief Read current value of the BCH_STATUS0_RSVD0 field. */
#define BR_BCH_STATUS0_RSVD0(x) (HW_BCH_STATUS0(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field UNCORRECTABLE[2] (RO)
 *
 * 1 = Uncorrectable error encountered during last processing cycle.
 */
/*@{*/
#define BP_BCH_STATUS0_UNCORRECTABLE (2U)  /*!< Bit position for BCH_STATUS0_UNCORRECTABLE. */
#define BM_BCH_STATUS0_UNCORRECTABLE (0x00000004U) /*!< Bit mask for BCH_STATUS0_UNCORRECTABLE. */
#define BS_BCH_STATUS0_UNCORRECTABLE (1U)  /*!< Bit field size in bits for BCH_STATUS0_UNCORRECTABLE. */

/*! @brief Read current value of the BCH_STATUS0_UNCORRECTABLE field. */
#define BR_BCH_STATUS0_UNCORRECTABLE(x) (HW_BCH_STATUS0(x).B.UNCORRECTABLE)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field CORRECTED[3] (RO)
 *
 * 1 = At least one correctable error encountered during last processing cycle.
 */
/*@{*/
#define BP_BCH_STATUS0_CORRECTED (3U)      /*!< Bit position for BCH_STATUS0_CORRECTED. */
#define BM_BCH_STATUS0_CORRECTED (0x00000008U) /*!< Bit mask for BCH_STATUS0_CORRECTED. */
#define BS_BCH_STATUS0_CORRECTED (1U)      /*!< Bit field size in bits for BCH_STATUS0_CORRECTED. */

/*! @brief Read current value of the BCH_STATUS0_CORRECTED field. */
#define BR_BCH_STATUS0_CORRECTED(x) (HW_BCH_STATUS0(x).B.CORRECTED)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field ALLONES[4] (RO)
 *
 * 1 = All data bits of this transaction are ONE.
 */
/*@{*/
#define BP_BCH_STATUS0_ALLONES (4U)        /*!< Bit position for BCH_STATUS0_ALLONES. */
#define BM_BCH_STATUS0_ALLONES (0x00000010U) /*!< Bit mask for BCH_STATUS0_ALLONES. */
#define BS_BCH_STATUS0_ALLONES (1U)        /*!< Bit field size in bits for BCH_STATUS0_ALLONES. */

/*! @brief Read current value of the BCH_STATUS0_ALLONES field. */
#define BR_BCH_STATUS0_ALLONES(x) (HW_BCH_STATUS0(x).B.ALLONES)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field RSVD1[7:5] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_STATUS0_RSVD1 (5U)          /*!< Bit position for BCH_STATUS0_RSVD1. */
#define BM_BCH_STATUS0_RSVD1 (0x000000E0U) /*!< Bit mask for BCH_STATUS0_RSVD1. */
#define BS_BCH_STATUS0_RSVD1 (3U)          /*!< Bit field size in bits for BCH_STATUS0_RSVD1. */

/*! @brief Read current value of the BCH_STATUS0_RSVD1 field. */
#define BR_BCH_STATUS0_RSVD1(x) (HW_BCH_STATUS0(x).B.RSVD1)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field STATUS_BLK0[15:8] (RO)
 *
 * Count of symbols in error during processing of first block of flash (metadata
 * block). The number of errors reported will be in the range of 0 to the ECC
 * correction level for block 0.
 *
 * Values:
 * - 0 - No errors found on block.
 * - 1 - One error found on block.
 * - 10 - One errors found on block.
 * - 11 - One errors found on block.
 * - 100 - One errors found on block.
 * - 11111110 - Block exhibited uncorrectable errors.
 * - 11111111 - Page is erased.
 */
/*@{*/
#define BP_BCH_STATUS0_STATUS_BLK0 (8U)    /*!< Bit position for BCH_STATUS0_STATUS_BLK0. */
#define BM_BCH_STATUS0_STATUS_BLK0 (0x0000FF00U) /*!< Bit mask for BCH_STATUS0_STATUS_BLK0. */
#define BS_BCH_STATUS0_STATUS_BLK0 (8U)    /*!< Bit field size in bits for BCH_STATUS0_STATUS_BLK0. */

#define BV_BCH_STATUS0_STATUS_BLK0_ZERO (0U)         /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: No errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR1 (0x1U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One error found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR2 (0x2U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR3 (0x3U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERROR4 (0x4U)     /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: One errors found on block. */
#define BV_BCH_STATUS0_STATUS_BLK0_UNCORRECTABLE (0xFEU) /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: Block exhibited uncorrectable errors. */
#define BV_BCH_STATUS0_STATUS_BLK0_ERASED (0xFFU)    /*!< Bit field value for BCH_STATUS0_STATUS_BLK0: Page is erased. */

/*! @brief Read current value of the BCH_STATUS0_STATUS_BLK0 field. */
#define BR_BCH_STATUS0_STATUS_BLK0(x) (HW_BCH_STATUS0(x).B.STATUS_BLK0)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field COMPLETED_CE[19:16] (RO)
 *
 * This is the chip enable number corresponding to the NAND device from which
 * this data came.
 */
/*@{*/
#define BP_BCH_STATUS0_COMPLETED_CE (16U)  /*!< Bit position for BCH_STATUS0_COMPLETED_CE. */
#define BM_BCH_STATUS0_COMPLETED_CE (0x000F0000U) /*!< Bit mask for BCH_STATUS0_COMPLETED_CE. */
#define BS_BCH_STATUS0_COMPLETED_CE (4U)   /*!< Bit field size in bits for BCH_STATUS0_COMPLETED_CE. */

/*! @brief Read current value of the BCH_STATUS0_COMPLETED_CE field. */
#define BR_BCH_STATUS0_COMPLETED_CE(x) (HW_BCH_STATUS0(x).B.COMPLETED_CE)
/*@}*/

/*!
 * @name Register BCH_STATUS0, field HANDLE[31:20] (RO)
 *
 * Software supplies a 12 bit handle for this transfer as part of the GPMI DMA
 * PIO operation that started the transaction. That handle passes down the
 * pipeline and ends up here at the time the BCH interrupt is signaled.
 */
/*@{*/
#define BP_BCH_STATUS0_HANDLE (20U)        /*!< Bit position for BCH_STATUS0_HANDLE. */
#define BM_BCH_STATUS0_HANDLE (0xFFF00000U) /*!< Bit mask for BCH_STATUS0_HANDLE. */
#define BS_BCH_STATUS0_HANDLE (12U)        /*!< Bit field size in bits for BCH_STATUS0_HANDLE. */

/*! @brief Read current value of the BCH_STATUS0_HANDLE field. */
#define BR_BCH_STATUS0_HANDLE(x) (HW_BCH_STATUS0(x).B.HANDLE)
/*@}*/




/*******************************************************************************
 * HW_BCH_MODE - Hardware ECC Accelerator Mode Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_MODE - Hardware ECC Accelerator Mode Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The BCH MODE register provides additional mode controls. Contains additional
 * global mode controls for the BCH engine.
 */
typedef union _hw_bch_mode
{
    uint32_t U;
    struct _hw_bch_mode_bitfields
    {
        uint32_t ERASE_THRESHOLD : 8;  /*!< [7:0]  */
        uint32_t RSVD : 24;            /*!< [31:8] This field is reserved. */
    } B;
} hw_bch_mode_t;

/*!
 * @name Constants and macros for entire BCH_MODE register
 */
/*@{*/
#define HW_BCH_MODE_ADDR(x)      ((uintptr_t)(x) + 0x20U)
#define HW_BCH_MODE_SET_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0x4U)
#define HW_BCH_MODE_CLR_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0x8U)
#define HW_BCH_MODE_TOG_ADDR(x)  (HW_BCH_MODE_ADDR(x) + 0xCU)

#define HW_BCH_MODE(x)           (*(__IO hw_bch_mode_t *) HW_BCH_MODE_ADDR(x))
#define HW_BCH_MODE_RD(x)        (HW_BCH_MODE(x).U)
#define HW_BCH_MODE_WR(x, v)     (HW_BCH_MODE(x).U = (v))
#define HW_BCH_MODE_SET(x, v)    ((*(uint32_t *) HW_BCH_MODE_SET_ADDR(x)) = (v))
#define HW_BCH_MODE_CLR(x, v)    ((*(uint32_t *) HW_BCH_MODE_CLR_ADDR(x)) = (v))
#define HW_BCH_MODE_TOG(x, v)    ((*(uint32_t *) HW_BCH_MODE_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_MODE bitfields
 */

/*!
 * @name Register BCH_MODE, field ERASE_THRESHOLD[7:0] (RW)
 *
 * This value indicates the maximum number of zero bits on a flash subpage for
 * it to be considered erased. For SLC NAND devices, this value should be
 * programmed to 0 (meaning that the entire page should consist of bytes of 0xFF. For MLC
 * NAND devices, bit errors may occur on reads (even on blank pages), so this
 * threshold can be used to tune the erased page checking algorithm.
 */
/*@{*/
#define BP_BCH_MODE_ERASE_THRESHOLD (0U)   /*!< Bit position for BCH_MODE_ERASE_THRESHOLD. */
#define BM_BCH_MODE_ERASE_THRESHOLD (0x000000FFU) /*!< Bit mask for BCH_MODE_ERASE_THRESHOLD. */
#define BS_BCH_MODE_ERASE_THRESHOLD (8U)   /*!< Bit field size in bits for BCH_MODE_ERASE_THRESHOLD. */

/*! @brief Read current value of the BCH_MODE_ERASE_THRESHOLD field. */
#define BR_BCH_MODE_ERASE_THRESHOLD(x) (HW_BCH_MODE(x).B.ERASE_THRESHOLD)

/*! @brief Format value for bitfield BCH_MODE_ERASE_THRESHOLD. */
#define BF_BCH_MODE_ERASE_THRESHOLD(v) ((uint32_t)((uint32_t)(v) << BP_BCH_MODE_ERASE_THRESHOLD) & BM_BCH_MODE_ERASE_THRESHOLD)

/*! @brief Set the ERASE_THRESHOLD field to a new value. */
#define BW_BCH_MODE_ERASE_THRESHOLD(x, v) (HW_BCH_MODE_WR(x, (HW_BCH_MODE_RD(x) & ~BM_BCH_MODE_ERASE_THRESHOLD) | BF_BCH_MODE_ERASE_THRESHOLD(v)))
/*@}*/

/*!
 * @name Register BCH_MODE, field RSVD[31:8] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_MODE_RSVD     (8U)          /*!< Bit position for BCH_MODE_RSVD. */
#define BM_BCH_MODE_RSVD     (0xFFFFFF00U) /*!< Bit mask for BCH_MODE_RSVD. */
#define BS_BCH_MODE_RSVD     (24U)         /*!< Bit field size in bits for BCH_MODE_RSVD. */

/*! @brief Read current value of the BCH_MODE_RSVD field. */
#define BR_BCH_MODE_RSVD(x)  (HW_BCH_MODE(x).B.RSVD)
/*@}*/




/*******************************************************************************
 * HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_ENCODEPTR - Hardware BCH ECC Loopback Encode Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * encode buffer. This register should be programmed before writing a 1 to the
 * M2M_ENABLE bit in the CTRL register. For memory to memory operations, this register
 * is used as the pointer to the encoded data, which is an output when encoding
 * and an input while decoding.
 */
typedef union _hw_bch_encodeptr
{
    uint32_t U;
    struct _hw_bch_encodeptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_encodeptr_t;

/*!
 * @name Constants and macros for entire BCH_ENCODEPTR register
 */
/*@{*/
#define HW_BCH_ENCODEPTR_ADDR(x) ((uintptr_t)(x) + 0x30U)
#define HW_BCH_ENCODEPTR_SET_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0x4U)
#define HW_BCH_ENCODEPTR_CLR_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0x8U)
#define HW_BCH_ENCODEPTR_TOG_ADDR(x) (HW_BCH_ENCODEPTR_ADDR(x) + 0xCU)

#define HW_BCH_ENCODEPTR(x)      (*(__IO hw_bch_encodeptr_t *) HW_BCH_ENCODEPTR_ADDR(x))
#define HW_BCH_ENCODEPTR_RD(x)   (HW_BCH_ENCODEPTR(x).U)
#define HW_BCH_ENCODEPTR_WR(x, v) (HW_BCH_ENCODEPTR(x).U = (v))
#define HW_BCH_ENCODEPTR_SET(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_SET_ADDR(x)) = (v))
#define HW_BCH_ENCODEPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_ENCODEPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_ENCODEPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_ENCODEPTR bitfields
 */

/*!
 * @name Register BCH_ENCODEPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to encode buffer. This is the source for decode operations
 * and the destination for encode operations. This value must be aligned on a 4
 * bytes boundary.
 */
/*@{*/
#define BP_BCH_ENCODEPTR_ADDR (0U)         /*!< Bit position for BCH_ENCODEPTR_ADDR. */
#define BM_BCH_ENCODEPTR_ADDR (0xFFFFFFFFU) /*!< Bit mask for BCH_ENCODEPTR_ADDR. */
#define BS_BCH_ENCODEPTR_ADDR (32U)        /*!< Bit field size in bits for BCH_ENCODEPTR_ADDR. */

/*! @brief Read current value of the BCH_ENCODEPTR_ADDR field. */
#define BR_BCH_ENCODEPTR_ADDR(x) (HW_BCH_ENCODEPTR(x).U)

/*! @brief Format value for bitfield BCH_ENCODEPTR_ADDR. */
#define BF_BCH_ENCODEPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_ENCODEPTR_ADDR) & BM_BCH_ENCODEPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_ENCODEPTR_ADDR(x, v) (HW_BCH_ENCODEPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DATAPTR - Hardware BCH ECC Loopback Data Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * data buffer. For memory to memory operations, this register is used as the
 * pointer to the data to encode or the destination buffer for decode operations.
 */
typedef union _hw_bch_dataptr
{
    uint32_t U;
    struct _hw_bch_dataptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_dataptr_t;

/*!
 * @name Constants and macros for entire BCH_DATAPTR register
 */
/*@{*/
#define HW_BCH_DATAPTR_ADDR(x)   ((uintptr_t)(x) + 0x40U)
#define HW_BCH_DATAPTR_SET_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0x4U)
#define HW_BCH_DATAPTR_CLR_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0x8U)
#define HW_BCH_DATAPTR_TOG_ADDR(x) (HW_BCH_DATAPTR_ADDR(x) + 0xCU)

#define HW_BCH_DATAPTR(x)        (*(__IO hw_bch_dataptr_t *) HW_BCH_DATAPTR_ADDR(x))
#define HW_BCH_DATAPTR_RD(x)     (HW_BCH_DATAPTR(x).U)
#define HW_BCH_DATAPTR_WR(x, v)  (HW_BCH_DATAPTR(x).U = (v))
#define HW_BCH_DATAPTR_SET(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_SET_ADDR(x)) = (v))
#define HW_BCH_DATAPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_DATAPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_DATAPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DATAPTR bitfields
 */

/*!
 * @name Register BCH_DATAPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to data buffer. This is the source for encode operations and
 * the destination for decode operations. This register should be programmed
 * before writing a 1 to the M2M_ENABLE bit in the CTRL register. This value must be
 * aligned on a 4 byte boundary.
 */
/*@{*/
#define BP_BCH_DATAPTR_ADDR  (0U)          /*!< Bit position for BCH_DATAPTR_ADDR. */
#define BM_BCH_DATAPTR_ADDR  (0xFFFFFFFFU) /*!< Bit mask for BCH_DATAPTR_ADDR. */
#define BS_BCH_DATAPTR_ADDR  (32U)         /*!< Bit field size in bits for BCH_DATAPTR_ADDR. */

/*! @brief Read current value of the BCH_DATAPTR_ADDR field. */
#define BR_BCH_DATAPTR_ADDR(x) (HW_BCH_DATAPTR(x).U)

/*! @brief Format value for bitfield BCH_DATAPTR_ADDR. */
#define BF_BCH_DATAPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DATAPTR_ADDR) & BM_BCH_DATAPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_DATAPTR_ADDR(x, v) (HW_BCH_DATAPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_METAPTR - Hardware BCH ECC Loopback Metadata Buffer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When performing memory to memory operations, indicates the address of the
 * metadata buffer. For memory to memory operations, this register is used as the
 * pointer to the metadata to encode or the extracted metadata for decode
 * operations.
 */
typedef union _hw_bch_metaptr
{
    uint32_t U;
    struct _hw_bch_metaptr_bitfields
    {
        uint32_t ADDR : 32;            /*!< [31:0]  */
    } B;
} hw_bch_metaptr_t;

/*!
 * @name Constants and macros for entire BCH_METAPTR register
 */
/*@{*/
#define HW_BCH_METAPTR_ADDR(x)   ((uintptr_t)(x) + 0x50U)
#define HW_BCH_METAPTR_SET_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0x4U)
#define HW_BCH_METAPTR_CLR_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0x8U)
#define HW_BCH_METAPTR_TOG_ADDR(x) (HW_BCH_METAPTR_ADDR(x) + 0xCU)

#define HW_BCH_METAPTR(x)        (*(__IO hw_bch_metaptr_t *) HW_BCH_METAPTR_ADDR(x))
#define HW_BCH_METAPTR_RD(x)     (HW_BCH_METAPTR(x).U)
#define HW_BCH_METAPTR_WR(x, v)  (HW_BCH_METAPTR(x).U = (v))
#define HW_BCH_METAPTR_SET(x, v) ((*(uint32_t *) HW_BCH_METAPTR_SET_ADDR(x)) = (v))
#define HW_BCH_METAPTR_CLR(x, v) ((*(uint32_t *) HW_BCH_METAPTR_CLR_ADDR(x)) = (v))
#define HW_BCH_METAPTR_TOG(x, v) ((*(uint32_t *) HW_BCH_METAPTR_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_METAPTR bitfields
 */

/*!
 * @name Register BCH_METAPTR, field ADDR[31:0] (RW)
 *
 * Address pointer to metadata buffer. This is the source for encode metadata
 * read operations and the destination for metadata decode operations. This
 * register should be programmed before writing a 1 to the M2M_ENABLE bit in the CTRL
 * register. This value must be aligned on a 4 bytes boundary.
 */
/*@{*/
#define BP_BCH_METAPTR_ADDR  (0U)          /*!< Bit position for BCH_METAPTR_ADDR. */
#define BM_BCH_METAPTR_ADDR  (0xFFFFFFFFU) /*!< Bit mask for BCH_METAPTR_ADDR. */
#define BS_BCH_METAPTR_ADDR  (32U)         /*!< Bit field size in bits for BCH_METAPTR_ADDR. */

/*! @brief Read current value of the BCH_METAPTR_ADDR field. */
#define BR_BCH_METAPTR_ADDR(x) (HW_BCH_METAPTR(x).U)

/*! @brief Format value for bitfield BCH_METAPTR_ADDR. */
#define BF_BCH_METAPTR_ADDR(v) ((uint32_t)((uint32_t)(v) << BP_BCH_METAPTR_ADDR) & BM_BCH_METAPTR_ADDR)

/*! @brief Set the ADDR field to a new value. */
#define BW_BCH_METAPTR_ADDR(x, v) (HW_BCH_METAPTR_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_LAYOUTSELECT - Hardware ECC Accelerator Layout Select Register (RW)
 *
 * Reset value: 0xE4E4E4E4U
 *
 * The BCH LAYOUTSELECT register provides a mapping of chip selects to layout
 * registers. When the BCH engine receives a request to process a data block from
 * the GPMI interface, it will use this register to map the incoming chip select
 * to one of the four possible flash layout registers
 */
typedef union _hw_bch_layoutselect
{
    uint32_t U;
    struct _hw_bch_layoutselect_bitfields
    {
        uint32_t CS0_SELECT : 2;       /*!< [1:0]  */
        uint32_t CS1_SELECT : 2;       /*!< [3:2]  */
        uint32_t CS2_SELECT : 2;       /*!< [5:4]  */
        uint32_t CS3_SELECT : 2;       /*!< [7:6]  */
        uint32_t CS4_SELECT : 2;       /*!< [9:8]  */
        uint32_t CS5_SELECT : 2;       /*!< [11:10]  */
        uint32_t CS6_SELECT : 2;       /*!< [13:12]  */
        uint32_t CS7_SELECT : 2;       /*!< [15:14]  */
        uint32_t CS8_SELECT : 2;       /*!< [17:16]  */
        uint32_t CS9_SELECT : 2;       /*!< [19:18]  */
        uint32_t CS10_SELECT : 2;      /*!< [21:20]  */
        uint32_t CS11_SELECT : 2;      /*!< [23:22]  */
        uint32_t CS12_SELECT : 2;      /*!< [25:24]  */
        uint32_t CS13_SELECT : 2;      /*!< [27:26]  */
        uint32_t CS14_SELECT : 2;      /*!< [29:28]  */
        uint32_t CS15_SELECT : 2;      /*!< [31:30]  */
    } B;
} hw_bch_layoutselect_t;

/*!
 * @name Constants and macros for entire BCH_LAYOUTSELECT register
 */
/*@{*/
#define HW_BCH_LAYOUTSELECT_ADDR(x) ((uintptr_t)(x) + 0x70U)
#define HW_BCH_LAYOUTSELECT_SET_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0x4U)
#define HW_BCH_LAYOUTSELECT_CLR_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0x8U)
#define HW_BCH_LAYOUTSELECT_TOG_ADDR(x) (HW_BCH_LAYOUTSELECT_ADDR(x) + 0xCU)

#define HW_BCH_LAYOUTSELECT(x)   (*(__IO hw_bch_layoutselect_t *) HW_BCH_LAYOUTSELECT_ADDR(x))
#define HW_BCH_LAYOUTSELECT_RD(x) (HW_BCH_LAYOUTSELECT(x).U)
#define HW_BCH_LAYOUTSELECT_WR(x, v) (HW_BCH_LAYOUTSELECT(x).U = (v))
#define HW_BCH_LAYOUTSELECT_SET(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_SET_ADDR(x)) = (v))
#define HW_BCH_LAYOUTSELECT_CLR(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_CLR_ADDR(x)) = (v))
#define HW_BCH_LAYOUTSELECT_TOG(x, v) ((*(uint32_t *) HW_BCH_LAYOUTSELECT_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_LAYOUTSELECT bitfields
 */

/*!
 * @name Register BCH_LAYOUTSELECT, field CS0_SELECT[1:0] (RW)
 *
 * Selects which layout is used for chip select 0.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS0_SELECT (0U) /*!< Bit position for BCH_LAYOUTSELECT_CS0_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS0_SELECT (0x00000003U) /*!< Bit mask for BCH_LAYOUTSELECT_CS0_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS0_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS0_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS0_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS0_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS0_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS0_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS0_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS0_SELECT) & BM_BCH_LAYOUTSELECT_CS0_SELECT)

/*! @brief Set the CS0_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS0_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS0_SELECT) | BF_BCH_LAYOUTSELECT_CS0_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS1_SELECT[3:2] (RW)
 *
 * Selects which layout is used for chip select 1.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS1_SELECT (2U) /*!< Bit position for BCH_LAYOUTSELECT_CS1_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS1_SELECT (0x0000000CU) /*!< Bit mask for BCH_LAYOUTSELECT_CS1_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS1_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS1_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS1_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS1_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS1_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS1_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS1_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS1_SELECT) & BM_BCH_LAYOUTSELECT_CS1_SELECT)

/*! @brief Set the CS1_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS1_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS1_SELECT) | BF_BCH_LAYOUTSELECT_CS1_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS2_SELECT[5:4] (RW)
 *
 * Selects which layout is used for chip select 2.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS2_SELECT (4U) /*!< Bit position for BCH_LAYOUTSELECT_CS2_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS2_SELECT (0x00000030U) /*!< Bit mask for BCH_LAYOUTSELECT_CS2_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS2_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS2_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS2_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS2_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS2_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS2_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS2_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS2_SELECT) & BM_BCH_LAYOUTSELECT_CS2_SELECT)

/*! @brief Set the CS2_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS2_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS2_SELECT) | BF_BCH_LAYOUTSELECT_CS2_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS3_SELECT[7:6] (RW)
 *
 * Selects which layout is used for chip select 3.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS3_SELECT (6U) /*!< Bit position for BCH_LAYOUTSELECT_CS3_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS3_SELECT (0x000000C0U) /*!< Bit mask for BCH_LAYOUTSELECT_CS3_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS3_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS3_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS3_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS3_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS3_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS3_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS3_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS3_SELECT) & BM_BCH_LAYOUTSELECT_CS3_SELECT)

/*! @brief Set the CS3_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS3_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS3_SELECT) | BF_BCH_LAYOUTSELECT_CS3_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS4_SELECT[9:8] (RW)
 *
 * Selects which layout is used for chip select 4.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS4_SELECT (8U) /*!< Bit position for BCH_LAYOUTSELECT_CS4_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS4_SELECT (0x00000300U) /*!< Bit mask for BCH_LAYOUTSELECT_CS4_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS4_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS4_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS4_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS4_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS4_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS4_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS4_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS4_SELECT) & BM_BCH_LAYOUTSELECT_CS4_SELECT)

/*! @brief Set the CS4_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS4_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS4_SELECT) | BF_BCH_LAYOUTSELECT_CS4_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS5_SELECT[11:10] (RW)
 *
 * Selects which layout is used for chip select 5.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS5_SELECT (10U) /*!< Bit position for BCH_LAYOUTSELECT_CS5_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS5_SELECT (0x00000C00U) /*!< Bit mask for BCH_LAYOUTSELECT_CS5_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS5_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS5_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS5_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS5_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS5_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS5_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS5_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS5_SELECT) & BM_BCH_LAYOUTSELECT_CS5_SELECT)

/*! @brief Set the CS5_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS5_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS5_SELECT) | BF_BCH_LAYOUTSELECT_CS5_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS6_SELECT[13:12] (RW)
 *
 * Selects which layout is used for chip select 6.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS6_SELECT (12U) /*!< Bit position for BCH_LAYOUTSELECT_CS6_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS6_SELECT (0x00003000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS6_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS6_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS6_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS6_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS6_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS6_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS6_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS6_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS6_SELECT) & BM_BCH_LAYOUTSELECT_CS6_SELECT)

/*! @brief Set the CS6_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS6_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS6_SELECT) | BF_BCH_LAYOUTSELECT_CS6_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS7_SELECT[15:14] (RW)
 *
 * Selects which layout is used for chip select 7.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS7_SELECT (14U) /*!< Bit position for BCH_LAYOUTSELECT_CS7_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS7_SELECT (0x0000C000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS7_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS7_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS7_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS7_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS7_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS7_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS7_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS7_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS7_SELECT) & BM_BCH_LAYOUTSELECT_CS7_SELECT)

/*! @brief Set the CS7_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS7_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS7_SELECT) | BF_BCH_LAYOUTSELECT_CS7_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS8_SELECT[17:16] (RW)
 *
 * Selects which layout is used for chip select 8.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS8_SELECT (16U) /*!< Bit position for BCH_LAYOUTSELECT_CS8_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS8_SELECT (0x00030000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS8_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS8_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS8_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS8_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS8_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS8_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS8_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS8_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS8_SELECT) & BM_BCH_LAYOUTSELECT_CS8_SELECT)

/*! @brief Set the CS8_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS8_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS8_SELECT) | BF_BCH_LAYOUTSELECT_CS8_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS9_SELECT[19:18] (RW)
 *
 * Selects which layout is used for chip select 9.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS9_SELECT (18U) /*!< Bit position for BCH_LAYOUTSELECT_CS9_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS9_SELECT (0x000C0000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS9_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS9_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS9_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS9_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS9_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS9_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS9_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS9_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS9_SELECT) & BM_BCH_LAYOUTSELECT_CS9_SELECT)

/*! @brief Set the CS9_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS9_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS9_SELECT) | BF_BCH_LAYOUTSELECT_CS9_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS10_SELECT[21:20] (RW)
 *
 * Selects which layout is used for chip select 10.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS10_SELECT (20U) /*!< Bit position for BCH_LAYOUTSELECT_CS10_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS10_SELECT (0x00300000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS10_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS10_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS10_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS10_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS10_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS10_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS10_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS10_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS10_SELECT) & BM_BCH_LAYOUTSELECT_CS10_SELECT)

/*! @brief Set the CS10_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS10_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS10_SELECT) | BF_BCH_LAYOUTSELECT_CS10_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS11_SELECT[23:22] (RW)
 *
 * Selects which layout is used for chip select 11.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS11_SELECT (22U) /*!< Bit position for BCH_LAYOUTSELECT_CS11_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS11_SELECT (0x00C00000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS11_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS11_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS11_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS11_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS11_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS11_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS11_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS11_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS11_SELECT) & BM_BCH_LAYOUTSELECT_CS11_SELECT)

/*! @brief Set the CS11_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS11_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS11_SELECT) | BF_BCH_LAYOUTSELECT_CS11_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS12_SELECT[25:24] (RW)
 *
 * Selects which layout is used for chip select 12.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS12_SELECT (24U) /*!< Bit position for BCH_LAYOUTSELECT_CS12_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS12_SELECT (0x03000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS12_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS12_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS12_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS12_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS12_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS12_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS12_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS12_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS12_SELECT) & BM_BCH_LAYOUTSELECT_CS12_SELECT)

/*! @brief Set the CS12_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS12_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS12_SELECT) | BF_BCH_LAYOUTSELECT_CS12_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS13_SELECT[27:26] (RW)
 *
 * Selects which layout is used for chip select 13.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS13_SELECT (26U) /*!< Bit position for BCH_LAYOUTSELECT_CS13_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS13_SELECT (0x0C000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS13_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS13_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS13_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS13_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS13_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS13_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS13_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS13_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS13_SELECT) & BM_BCH_LAYOUTSELECT_CS13_SELECT)

/*! @brief Set the CS13_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS13_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS13_SELECT) | BF_BCH_LAYOUTSELECT_CS13_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS14_SELECT[29:28] (RW)
 *
 * Selects which layout is used for chip select 14.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS14_SELECT (28U) /*!< Bit position for BCH_LAYOUTSELECT_CS14_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS14_SELECT (0x30000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS14_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS14_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS14_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS14_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS14_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS14_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS14_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS14_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS14_SELECT) & BM_BCH_LAYOUTSELECT_CS14_SELECT)

/*! @brief Set the CS14_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS14_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS14_SELECT) | BF_BCH_LAYOUTSELECT_CS14_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_LAYOUTSELECT, field CS15_SELECT[31:30] (RW)
 *
 * Selects which layout is used for chip select 15.
 */
/*@{*/
#define BP_BCH_LAYOUTSELECT_CS15_SELECT (30U) /*!< Bit position for BCH_LAYOUTSELECT_CS15_SELECT. */
#define BM_BCH_LAYOUTSELECT_CS15_SELECT (0xC0000000U) /*!< Bit mask for BCH_LAYOUTSELECT_CS15_SELECT. */
#define BS_BCH_LAYOUTSELECT_CS15_SELECT (2U) /*!< Bit field size in bits for BCH_LAYOUTSELECT_CS15_SELECT. */

/*! @brief Read current value of the BCH_LAYOUTSELECT_CS15_SELECT field. */
#define BR_BCH_LAYOUTSELECT_CS15_SELECT(x) (HW_BCH_LAYOUTSELECT(x).B.CS15_SELECT)

/*! @brief Format value for bitfield BCH_LAYOUTSELECT_CS15_SELECT. */
#define BF_BCH_LAYOUTSELECT_CS15_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_LAYOUTSELECT_CS15_SELECT) & BM_BCH_LAYOUTSELECT_CS15_SELECT)

/*! @brief Set the CS15_SELECT field to a new value. */
#define BW_BCH_LAYOUTSELECT_CS15_SELECT(x, v) (HW_BCH_LAYOUTSELECT_WR(x, (HW_BCH_LAYOUTSELECT_RD(x) & ~BM_BCH_LAYOUTSELECT_CS15_SELECT) | BF_BCH_LAYOUTSELECT_CS15_SELECT(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH0LAYOUT0 - Hardware BCH ECC Flash 0 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH0LAYOUT1 register to control the format for the devices selecting layout 0 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash0layout0
{
    uint32_t U;
    struct _hw_bch_flash0layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash0layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH0LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH0LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0x80U)
#define HW_BCH_FLASH0LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH0LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH0LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH0LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH0LAYOUT0(x)  (*(__IO hw_bch_flash0layout0_t *) HW_BCH_FLASH0LAYOUT0_ADDR(x))
#define HW_BCH_FLASH0LAYOUT0_RD(x) (HW_BCH_FLASH0LAYOUT0(x).U)
#define HW_BCH_FLASH0LAYOUT0_WR(x, v) (HW_BCH_FLASH0LAYOUT0(x).U = (v))
#define HW_BCH_FLASH0LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH0LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH0LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block only contains metadata.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH0LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH0LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH0LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH0LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH0LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH0LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH0LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH0LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH0LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH0LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH0LAYOUT0_ECC0. */
#define BM_BCH_FLASH0LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH0LAYOUT0_ECC0. */
#define BS_BCH_FLASH0LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_ECC0. */

#define BV_BCH_FLASH0LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH0LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH0LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH0LAYOUT0_ECC0(x) (HW_BCH_FLASH0LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_ECC0. */
#define BF_BCH_FLASH0LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_ECC0) & BM_BCH_FLASH0LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_ECC0(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_ECC0) | BF_BCH_FLASH0LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH0LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH0LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH0LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH0LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH0LAYOUT0_META_SIZE(x) (HW_BCH_FLASH0LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH0LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_META_SIZE) & BM_BCH_FLASH0LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_META_SIZE) | BF_BCH_FLASH0LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH0LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH0LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH0LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH0LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH0LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH0LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT0_NBLOCKS) & BM_BCH_FLASH0LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH0LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH0LAYOUT0_WR(x, (HW_BCH_FLASH0LAYOUT0_RD(x) & ~BM_BCH_FLASH0LAYOUT0_NBLOCKS) | BF_BCH_FLASH0LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH0LAYOUT1 - Hardware BCH ECC Flash 0 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH0LAYOUT0 register to control the format for the device selecting layout 0 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash0layout1
{
    uint32_t U;
    struct _hw_bch_flash0layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash0layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH0LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH0LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0x90U)
#define HW_BCH_FLASH0LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH0LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH0LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH0LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH0LAYOUT1(x)  (*(__IO hw_bch_flash0layout1_t *) HW_BCH_FLASH0LAYOUT1_ADDR(x))
#define HW_BCH_FLASH0LAYOUT1_RD(x) (HW_BCH_FLASH0LAYOUT1(x).U)
#define HW_BCH_FLASH0LAYOUT1_WR(x, v) (HW_BCH_FLASH0LAYOUT1(x).U = (v))
#define HW_BCH_FLASH0LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH0LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH0LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH0LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH0LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH0LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH0LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH0LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH0LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH0LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH0LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH0LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH0LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH0LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH0LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH0LAYOUT1_ECCN. */
#define BM_BCH_FLASH0LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH0LAYOUT1_ECCN. */
#define BS_BCH_FLASH0LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_ECCN. */

#define BV_BCH_FLASH0LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH0LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH0LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_ECCN field. */
#define BR_BCH_FLASH0LAYOUT1_ECCN(x) (HW_BCH_FLASH0LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_ECCN. */
#define BF_BCH_FLASH0LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_ECCN) & BM_BCH_FLASH0LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_ECCN(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_ECCN) | BF_BCH_FLASH0LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH0LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH0LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH0LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH0LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH0LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH0LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH0LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH0LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH0LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH0LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH0LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH0LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH0LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH0LAYOUT1_WR(x, (HW_BCH_FLASH0LAYOUT1_RD(x) & ~BM_BCH_FLASH0LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH0LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH1LAYOUT0 - Hardware BCH ECC Flash 1 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH1LAYOUT1 register to control the format for the devices selecting layout 1 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash1layout0
{
    uint32_t U;
    struct _hw_bch_flash1layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash1layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH1LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH1LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xA0U)
#define HW_BCH_FLASH1LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH1LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH1LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH1LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH1LAYOUT0(x)  (*(__IO hw_bch_flash1layout0_t *) HW_BCH_FLASH1LAYOUT0_ADDR(x))
#define HW_BCH_FLASH1LAYOUT0_RD(x) (HW_BCH_FLASH1LAYOUT0(x).U)
#define HW_BCH_FLASH1LAYOUT0_WR(x, v) (HW_BCH_FLASH1LAYOUT0(x).U = (v))
#define HW_BCH_FLASH1LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH1LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH1LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will contains metadata.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH1LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH1LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH1LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH1LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH1LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH1LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH1LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH1LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH1LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH1LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH1LAYOUT0_ECC0. */
#define BM_BCH_FLASH1LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH1LAYOUT0_ECC0. */
#define BS_BCH_FLASH1LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_ECC0. */

#define BV_BCH_FLASH1LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH1LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH1LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH1LAYOUT0_ECC0(x) (HW_BCH_FLASH1LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_ECC0. */
#define BF_BCH_FLASH1LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_ECC0) & BM_BCH_FLASH1LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_ECC0(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_ECC0) | BF_BCH_FLASH1LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design supports from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data is in block
 * 0. If the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are
 * programmed with non-zero values, the first block will contain both portions of data
 * and covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH1LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH1LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH1LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH1LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH1LAYOUT0_META_SIZE(x) (HW_BCH_FLASH1LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH1LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_META_SIZE) & BM_BCH_FLASH1LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_META_SIZE) | BF_BCH_FLASH1LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH1LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH1LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH1LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH1LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH1LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH1LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT0_NBLOCKS) & BM_BCH_FLASH1LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH1LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH1LAYOUT0_WR(x, (HW_BCH_FLASH1LAYOUT0_RD(x) & ~BM_BCH_FLASH1LAYOUT0_NBLOCKS) | BF_BCH_FLASH1LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH1LAYOUT1 - Hardware BCH ECC Flash 1 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH1LAYOUT0 register to control the format for the device selecting layout 1 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash1layout1
{
    uint32_t U;
    struct _hw_bch_flash1layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash1layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH1LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH1LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xB0U)
#define HW_BCH_FLASH1LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH1LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH1LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH1LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH1LAYOUT1(x)  (*(__IO hw_bch_flash1layout1_t *) HW_BCH_FLASH1LAYOUT1_ADDR(x))
#define HW_BCH_FLASH1LAYOUT1_RD(x) (HW_BCH_FLASH1LAYOUT1(x).U)
#define HW_BCH_FLASH1LAYOUT1_WR(x, v) (HW_BCH_FLASH1LAYOUT1(x).U = (v))
#define HW_BCH_FLASH1LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH1LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH1LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH1LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH1LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH1LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH1LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH1LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH1LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH1LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH1LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH1LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH1LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH1LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH1LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH1LAYOUT1_ECCN. */
#define BM_BCH_FLASH1LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH1LAYOUT1_ECCN. */
#define BS_BCH_FLASH1LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_ECCN. */

#define BV_BCH_FLASH1LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH1LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH1LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_ECCN field. */
#define BR_BCH_FLASH1LAYOUT1_ECCN(x) (HW_BCH_FLASH1LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_ECCN. */
#define BF_BCH_FLASH1LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_ECCN) & BM_BCH_FLASH1LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_ECCN(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_ECCN) | BF_BCH_FLASH1LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH1LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH1LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH1LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH1LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH1LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH1LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH1LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH1LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH1LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH1LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH1LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH1LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH1LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH1LAYOUT1_WR(x, (HW_BCH_FLASH1LAYOUT1_RD(x) & ~BM_BCH_FLASH1LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH1LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH2LAYOUT0 - Hardware BCH ECC Flash 2 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH2LAYOUT1 register to control the format for the devices selecting layout 2 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash2layout0
{
    uint32_t U;
    struct _hw_bch_flash2layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash2layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH2LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH2LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xC0U)
#define HW_BCH_FLASH2LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH2LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH2LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH2LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH2LAYOUT0(x)  (*(__IO hw_bch_flash2layout0_t *) HW_BCH_FLASH2LAYOUT0_ADDR(x))
#define HW_BCH_FLASH2LAYOUT0_RD(x) (HW_BCH_FLASH2LAYOUT0(x).U)
#define HW_BCH_FLASH2LAYOUT0_WR(x, v) (HW_BCH_FLASH2LAYOUT0(x).U = (v))
#define HW_BCH_FLASH2LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH2LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH2LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will only contain metadata.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH2LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH2LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH2LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH2LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH2LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH2LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH2LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH2LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH2LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH2LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH2LAYOUT0_ECC0. */
#define BM_BCH_FLASH2LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH2LAYOUT0_ECC0. */
#define BS_BCH_FLASH2LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_ECC0. */

#define BV_BCH_FLASH2LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH2LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH2LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH2LAYOUT0_ECC0(x) (HW_BCH_FLASH2LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_ECC0. */
#define BF_BCH_FLASH2LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_ECC0) & BM_BCH_FLASH2LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_ECC0(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_ECC0) | BF_BCH_FLASH2LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * will be covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH2LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH2LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH2LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH2LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH2LAYOUT0_META_SIZE(x) (HW_BCH_FLASH2LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH2LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_META_SIZE) & BM_BCH_FLASH2LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_META_SIZE) | BF_BCH_FLASH2LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that eight subsequent blocks are present for a total of nine blocks on
 * the flash (including the DATA0 block). Any values from 0 to 255 are supported
 * by the hardware.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH2LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH2LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH2LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH2LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH2LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH2LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT0_NBLOCKS) & BM_BCH_FLASH2LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH2LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH2LAYOUT0_WR(x, (HW_BCH_FLASH2LAYOUT0_RD(x) & ~BM_BCH_FLASH2LAYOUT0_NBLOCKS) | BF_BCH_FLASH2LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH2LAYOUT1 - Hardware BCH ECC Flash 2 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH2LAYOUT0 register to control the format for the device selecting layout 2 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash2layout1
{
    uint32_t U;
    struct _hw_bch_flash2layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash2layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH2LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH2LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xD0U)
#define HW_BCH_FLASH2LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH2LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH2LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH2LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH2LAYOUT1(x)  (*(__IO hw_bch_flash2layout1_t *) HW_BCH_FLASH2LAYOUT1_ADDR(x))
#define HW_BCH_FLASH2LAYOUT1_RD(x) (HW_BCH_FLASH2LAYOUT1(x).U)
#define HW_BCH_FLASH2LAYOUT1_WR(x, v) (HW_BCH_FLASH2LAYOUT1(x).U = (v))
#define HW_BCH_FLASH2LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH2LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH2LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH2LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH2LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH2LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH2LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH2LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH2LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH2LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH2LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH2LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH2LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH2LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH2LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH2LAYOUT1_ECCN. */
#define BM_BCH_FLASH2LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH2LAYOUT1_ECCN. */
#define BS_BCH_FLASH2LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_ECCN. */

#define BV_BCH_FLASH2LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH2LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH2LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_ECCN field. */
#define BR_BCH_FLASH2LAYOUT1_ECCN(x) (HW_BCH_FLASH2LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_ECCN. */
#define BF_BCH_FLASH2LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_ECCN) & BM_BCH_FLASH2LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_ECCN(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_ECCN) | BF_BCH_FLASH2LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH2LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH2LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH2LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH2LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH2LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH2LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH2LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH2LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH2LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH2LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH2LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH2LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH2LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH2LAYOUT1_WR(x, (HW_BCH_FLASH2LAYOUT1_RD(x) & ~BM_BCH_FLASH2LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH2LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH3LAYOUT0 - Hardware BCH ECC Flash 3 Layout 0 Register (RW)
 *
 * Reset value: 0x070A4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH3LAYOUT1 register to control the format for the devices selecting layout 3 in the
 * LAYOUTSELECT register. Each pair of layout registers describes one of four
 * supported flash configurations. Software should program the LAYOUTSELECT register
 * for each supported GPMI chip select to select from one of the four layout
 * values. Each pair of registers contains settings that are used by the BCH block
 * while reading / writing the flash page to control data, metadata, and flash
 * page sizes as well as the ECC correction level. The first block written to flash
 * can be programmed to have different ECC, metadata, and data sizes from
 * subsequent data blocks on the device. In addition, the number of blocks stored on a
 * page of flash is not fixed, but instead is determined by the number of bytes
 * consumed by the initial (block 0) and subsequent data blocks. See the BCH
 * programming reference manual for more information on setting up the flash layout
 * registers.
 */
typedef union _hw_bch_flash3layout0
{
    uint32_t U;
    struct _hw_bch_flash3layout0_bitfields
    {
        uint32_t DATA0_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECC0 : 5;             /*!< [15:11]  */
        uint32_t META_SIZE : 8;        /*!< [23:16]  */
        uint32_t NBLOCKS : 8;          /*!< [31:24]  */
    } B;
} hw_bch_flash3layout0_t;

/*!
 * @name Constants and macros for entire BCH_FLASH3LAYOUT0 register
 */
/*@{*/
#define HW_BCH_FLASH3LAYOUT0_ADDR(x) ((uintptr_t)(x) + 0xE0U)
#define HW_BCH_FLASH3LAYOUT0_SET_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0x4U)
#define HW_BCH_FLASH3LAYOUT0_CLR_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0x8U)
#define HW_BCH_FLASH3LAYOUT0_TOG_ADDR(x) (HW_BCH_FLASH3LAYOUT0_ADDR(x) + 0xCU)

#define HW_BCH_FLASH3LAYOUT0(x)  (*(__IO hw_bch_flash3layout0_t *) HW_BCH_FLASH3LAYOUT0_ADDR(x))
#define HW_BCH_FLASH3LAYOUT0_RD(x) (HW_BCH_FLASH3LAYOUT0(x).U)
#define HW_BCH_FLASH3LAYOUT0_WR(x, v) (HW_BCH_FLASH3LAYOUT0(x).U = (v))
#define HW_BCH_FLASH3LAYOUT0_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT0_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT0_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH3LAYOUT0 bitfields
 */

/*!
 * @name Register BCH_FLASH3LAYOUT0, field DATA0_SIZE[9:0] (RW)
 *
 * Indicates the size of the data 0 block (in DWORDS / four bytes) to be stored
 * on the flash page. If set to 0, the first block will only contain metadata.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_DATA0_SIZE (0U) /*!< Bit position for BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BM_BCH_FLASH3LAYOUT0_DATA0_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BS_BCH_FLASH3LAYOUT0_DATA0_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_DATA0_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_DATA0_SIZE field. */
#define BR_BCH_FLASH3LAYOUT0_DATA0_SIZE(x) (HW_BCH_FLASH3LAYOUT0(x).B.DATA0_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_DATA0_SIZE. */
#define BF_BCH_FLASH3LAYOUT0_DATA0_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_DATA0_SIZE) & BM_BCH_FLASH3LAYOUT0_DATA0_SIZE)

/*! @brief Set the DATA0_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_DATA0_SIZE(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_DATA0_SIZE) | BF_BCH_FLASH3LAYOUT0_DATA0_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BS_BCH_FLASH3LAYOUT0_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x) (HW_BCH_FLASH3LAYOUT0(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_GF13_0_GF14_1. */
#define BF_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_GF13_0_GF14_1) & BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_GF13_0_GF14_1) | BF_BCH_FLASH3LAYOUT0_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field ECC0[15:11] (RW)
 *
 * Indicates the ECC level for the first block on the flash page. The first
 * block covers metadata plus the associated data from the DATA0_SIZE field.
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_ECC0 (11U)    /*!< Bit position for BCH_FLASH3LAYOUT0_ECC0. */
#define BM_BCH_FLASH3LAYOUT0_ECC0 (0x0000F800U) /*!< Bit mask for BCH_FLASH3LAYOUT0_ECC0. */
#define BS_BCH_FLASH3LAYOUT0_ECC0 (5U)     /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_ECC0. */

#define BV_BCH_FLASH3LAYOUT0_ECC0_NONE (0U)          /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: No ECC to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 2 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 4 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 60 to be performed */
#define BV_BCH_FLASH3LAYOUT0_ECC0_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH3LAYOUT0_ECC0: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_ECC0 field. */
#define BR_BCH_FLASH3LAYOUT0_ECC0(x) (HW_BCH_FLASH3LAYOUT0(x).B.ECC0)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_ECC0. */
#define BF_BCH_FLASH3LAYOUT0_ECC0(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_ECC0) & BM_BCH_FLASH3LAYOUT0_ECC0)

/*! @brief Set the ECC0 field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_ECC0(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_ECC0) | BF_BCH_FLASH3LAYOUT0_ECC0(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field META_SIZE[23:16] (RW)
 *
 * Indicates the size of the metadata (in bytes) to be stored on a flash page.
 * The BCH design support from 0 to 255 bytes for metadata-if set to 0, no
 * metadata will be stored. Metadata is stored before the associated data in block 0. If
 * the DATA0_SIZE field is programmed to a 0, then metadata effectively be
 * stored with its own parity. When both the metadata and data0 fields are programmed
 * with non-zero values, the first block will contain both portions of data and
 * will be covered by a single parity block.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_META_SIZE (16U) /*!< Bit position for BCH_FLASH3LAYOUT0_META_SIZE. */
#define BM_BCH_FLASH3LAYOUT0_META_SIZE (0x00FF0000U) /*!< Bit mask for BCH_FLASH3LAYOUT0_META_SIZE. */
#define BS_BCH_FLASH3LAYOUT0_META_SIZE (8U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_META_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_META_SIZE field. */
#define BR_BCH_FLASH3LAYOUT0_META_SIZE(x) (HW_BCH_FLASH3LAYOUT0(x).B.META_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_META_SIZE. */
#define BF_BCH_FLASH3LAYOUT0_META_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_META_SIZE) & BM_BCH_FLASH3LAYOUT0_META_SIZE)

/*! @brief Set the META_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_META_SIZE(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_META_SIZE) | BF_BCH_FLASH3LAYOUT0_META_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT0, field NBLOCKS[31:24] (RW)
 *
 * Number of subsequent blocks on the flash page (excluding the data0 block). A
 * value of 0 indicates that only the DATA0 block is present and a value of 8
 * indicates that 8 subsequent blocks are present for a total of 9 blocks on the
 * flash (including the DATA0 block). Any values from 0 to 255 are supported by the
 * hardware.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT0_NBLOCKS (24U) /*!< Bit position for BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BM_BCH_FLASH3LAYOUT0_NBLOCKS (0xFF000000U) /*!< Bit mask for BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BS_BCH_FLASH3LAYOUT0_NBLOCKS (8U)  /*!< Bit field size in bits for BCH_FLASH3LAYOUT0_NBLOCKS. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT0_NBLOCKS field. */
#define BR_BCH_FLASH3LAYOUT0_NBLOCKS(x) (HW_BCH_FLASH3LAYOUT0(x).B.NBLOCKS)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT0_NBLOCKS. */
#define BF_BCH_FLASH3LAYOUT0_NBLOCKS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT0_NBLOCKS) & BM_BCH_FLASH3LAYOUT0_NBLOCKS)

/*! @brief Set the NBLOCKS field to a new value. */
#define BW_BCH_FLASH3LAYOUT0_NBLOCKS(x, v) (HW_BCH_FLASH3LAYOUT0_WR(x, (HW_BCH_FLASH3LAYOUT0_RD(x) & ~BM_BCH_FLASH3LAYOUT0_NBLOCKS) | BF_BCH_FLASH3LAYOUT0_NBLOCKS(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_FLASH3LAYOUT1 - Hardware BCH ECC Flash 3 Layout 1 Register (RW)
 *
 * Reset value: 0x10DA4080U
 *
 * The flash format register contains a description of the logical layout of
 * data on the flash device. This register is used in conjunction with the
 * FLASH3LAYOUT0 register to control the format for the device selecting layout 3 in the
 * LAYOUTSELECT register.
 */
typedef union _hw_bch_flash3layout1
{
    uint32_t U;
    struct _hw_bch_flash3layout1_bitfields
    {
        uint32_t DATAN_SIZE : 10;      /*!< [9:0]  */
        uint32_t GF13_0_GF14_1 : 1;    /*!< [10]  */
        uint32_t ECCN : 5;             /*!< [15:11]  */
        uint32_t PAGE_SIZE : 16;       /*!< [31:16]  */
    } B;
} hw_bch_flash3layout1_t;

/*!
 * @name Constants and macros for entire BCH_FLASH3LAYOUT1 register
 */
/*@{*/
#define HW_BCH_FLASH3LAYOUT1_ADDR(x) ((uintptr_t)(x) + 0xF0U)
#define HW_BCH_FLASH3LAYOUT1_SET_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0x4U)
#define HW_BCH_FLASH3LAYOUT1_CLR_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0x8U)
#define HW_BCH_FLASH3LAYOUT1_TOG_ADDR(x) (HW_BCH_FLASH3LAYOUT1_ADDR(x) + 0xCU)

#define HW_BCH_FLASH3LAYOUT1(x)  (*(__IO hw_bch_flash3layout1_t *) HW_BCH_FLASH3LAYOUT1_ADDR(x))
#define HW_BCH_FLASH3LAYOUT1_RD(x) (HW_BCH_FLASH3LAYOUT1(x).U)
#define HW_BCH_FLASH3LAYOUT1_WR(x, v) (HW_BCH_FLASH3LAYOUT1(x).U = (v))
#define HW_BCH_FLASH3LAYOUT1_SET(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_SET_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT1_CLR(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_CLR_ADDR(x)) = (v))
#define HW_BCH_FLASH3LAYOUT1_TOG(x, v) ((*(uint32_t *) HW_BCH_FLASH3LAYOUT1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_FLASH3LAYOUT1 bitfields
 */

/*!
 * @name Register BCH_FLASH3LAYOUT1, field DATAN_SIZE[9:0] (RW)
 *
 * Indicates the size of the subsequent data blocks (in DWORDS / four bytes) to
 * be stored on the flash page. The size of subsequent data blocks does not have
 * to match the data size for block 0, which is important when metadata is stored
 * separately or for balancing the amount of data stored in each block.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_DATAN_SIZE (0U) /*!< Bit position for BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BM_BCH_FLASH3LAYOUT1_DATAN_SIZE (0x000003FFU) /*!< Bit mask for BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BS_BCH_FLASH3LAYOUT1_DATAN_SIZE (10U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_DATAN_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_DATAN_SIZE field. */
#define BR_BCH_FLASH3LAYOUT1_DATAN_SIZE(x) (HW_BCH_FLASH3LAYOUT1(x).B.DATAN_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_DATAN_SIZE. */
#define BF_BCH_FLASH3LAYOUT1_DATAN_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_DATAN_SIZE) & BM_BCH_FLASH3LAYOUT1_DATAN_SIZE)

/*! @brief Set the DATAN_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_DATAN_SIZE(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_DATAN_SIZE) | BF_BCH_FLASH3LAYOUT1_DATAN_SIZE(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field GF13_0_GF14_1[10] (RW)
 *
 * Select GF13 or GF14: 0-GF13; 1-GF14
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (10U) /*!< Bit position for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (0x00000400U) /*!< Bit mask for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BS_BCH_FLASH3LAYOUT1_GF13_0_GF14_1 (1U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_GF13_0_GF14_1 field. */
#define BR_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x) (HW_BCH_FLASH3LAYOUT1(x).B.GF13_0_GF14_1)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_GF13_0_GF14_1. */
#define BF_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_GF13_0_GF14_1) & BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1)

/*! @brief Set the GF13_0_GF14_1 field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_GF13_0_GF14_1) | BF_BCH_FLASH3LAYOUT1_GF13_0_GF14_1(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field ECCN[15:11] (RW)
 *
 * Indicates the ECC level for the subsequent blocks on the flash page (blocks
 * 1-n). Subsequent blocks only contain data (no metadata).
 *
 * Values:
 * - 0 - No ECC to be performed
 * - 1 - ECC 2 to be performed
 * - 10 - ECC 4 to be performed
 * - 11110 - ECC 60 to be performed
 * - 11111 - ECC 62 to be performed
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_ECCN (11U)    /*!< Bit position for BCH_FLASH3LAYOUT1_ECCN. */
#define BM_BCH_FLASH3LAYOUT1_ECCN (0x0000F800U) /*!< Bit mask for BCH_FLASH3LAYOUT1_ECCN. */
#define BS_BCH_FLASH3LAYOUT1_ECCN (5U)     /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_ECCN. */

#define BV_BCH_FLASH3LAYOUT1_ECCN_NONE (0U)          /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: No ECC to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC2 (0x1U)        /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 2 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC4 (0x2U)        /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 4 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC60 (0x1EU)      /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 60 to be performed */
#define BV_BCH_FLASH3LAYOUT1_ECCN_ECC62 (0x1FU)      /*!< Bit field value for BCH_FLASH3LAYOUT1_ECCN: ECC 62 to be performed */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_ECCN field. */
#define BR_BCH_FLASH3LAYOUT1_ECCN(x) (HW_BCH_FLASH3LAYOUT1(x).B.ECCN)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_ECCN. */
#define BF_BCH_FLASH3LAYOUT1_ECCN(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_ECCN) & BM_BCH_FLASH3LAYOUT1_ECCN)

/*! @brief Set the ECCN field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_ECCN(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_ECCN) | BF_BCH_FLASH3LAYOUT1_ECCN(v)))
/*@}*/

/*!
 * @name Register BCH_FLASH3LAYOUT1, field PAGE_SIZE[31:16] (RW)
 *
 * Indicates the total size of the flash page (in bytes). This should be set to
 * the page size including spare area. The page size is programmable to
 * accomodate different flash configurations that may be available in the future.
 */
/*@{*/
#define BP_BCH_FLASH3LAYOUT1_PAGE_SIZE (16U) /*!< Bit position for BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BM_BCH_FLASH3LAYOUT1_PAGE_SIZE (0xFFFF0000U) /*!< Bit mask for BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BS_BCH_FLASH3LAYOUT1_PAGE_SIZE (16U) /*!< Bit field size in bits for BCH_FLASH3LAYOUT1_PAGE_SIZE. */

/*! @brief Read current value of the BCH_FLASH3LAYOUT1_PAGE_SIZE field. */
#define BR_BCH_FLASH3LAYOUT1_PAGE_SIZE(x) (HW_BCH_FLASH3LAYOUT1(x).B.PAGE_SIZE)

/*! @brief Format value for bitfield BCH_FLASH3LAYOUT1_PAGE_SIZE. */
#define BF_BCH_FLASH3LAYOUT1_PAGE_SIZE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_FLASH3LAYOUT1_PAGE_SIZE) & BM_BCH_FLASH3LAYOUT1_PAGE_SIZE)

/*! @brief Set the PAGE_SIZE field to a new value. */
#define BW_BCH_FLASH3LAYOUT1_PAGE_SIZE(x, v) (HW_BCH_FLASH3LAYOUT1_WR(x, (HW_BCH_FLASH3LAYOUT1_RD(x) & ~BM_BCH_FLASH3LAYOUT1_PAGE_SIZE) | BF_BCH_FLASH3LAYOUT1_PAGE_SIZE(v)))
/*@}*/




/*******************************************************************************
 * HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0
 ******************************************************************************/

/*!
 * @brief HW_BCH_DEBUG0 - Hardware BCH ECC Debug Register0 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH accelerator internal state machines and signals can be seen
 * in the ECC debug register. The BCH_DEBUG0 register provides access to various
 * internal state information which might prove useful during hardware debug and
 * validation.
 */
typedef union _hw_bch_debug0
{
    uint32_t U;
    struct _hw_bch_debug0_bitfields
    {
        uint32_t DEBUG_REG_SELECT : 6; /*!< [5:0]  */
        uint32_t RSVD0 : 2;            /*!< [7:6] This field is reserved. */
        uint32_t BM_KES_TEST_BYPASS : 1; /*!< [8]  */
        uint32_t KES_DEBUG_STALL : 1;  /*!< [9]  */
        uint32_t KES_DEBUG_STEP : 1;   /*!< [10]  */
        uint32_t KES_STANDALONE : 1;   /*!< [11]  */
        uint32_t KES_DEBUG_KICK : 1;   /*!< [12]  */
        uint32_t KES_DEBUG_MODE4K : 1; /*!< [13]  */
        uint32_t KES_DEBUG_PAYLOAD_FLAG : 1; /*!< [14]  */
        uint32_t KES_DEBUG_SHIFT_SYND : 1; /*!< [15]  */
        uint32_t KES_DEBUG_SYNDROME_SYMBOL : 9; /*!< [24:16]  */
        uint32_t RSVD1 : 7;            /*!< [31:25] This field is reserved. */
    } B;
} hw_bch_debug0_t;

/*!
 * @name Constants and macros for entire BCH_DEBUG0 register
 */
/*@{*/
#define HW_BCH_DEBUG0_ADDR(x)    ((uintptr_t)(x) + 0x100U)
#define HW_BCH_DEBUG0_SET_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0x4U)
#define HW_BCH_DEBUG0_CLR_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0x8U)
#define HW_BCH_DEBUG0_TOG_ADDR(x) (HW_BCH_DEBUG0_ADDR(x) + 0xCU)

#define HW_BCH_DEBUG0(x)         (*(__IO hw_bch_debug0_t *) HW_BCH_DEBUG0_ADDR(x))
#define HW_BCH_DEBUG0_RD(x)      (HW_BCH_DEBUG0(x).U)
#define HW_BCH_DEBUG0_WR(x, v)   (HW_BCH_DEBUG0(x).U = (v))
#define HW_BCH_DEBUG0_SET(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_SET_ADDR(x)) = (v))
#define HW_BCH_DEBUG0_CLR(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_CLR_ADDR(x)) = (v))
#define HW_BCH_DEBUG0_TOG(x, v)  ((*(uint32_t *) HW_BCH_DEBUG0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DEBUG0 bitfields
 */

/*!
 * @name Register BCH_DEBUG0, field DEBUG_REG_SELECT[5:0] (RW)
 *
 * The value loaded in this bit field is used to select the internal register
 * state view of KES engine or the Chien search engine.
 */
/*@{*/
#define BP_BCH_DEBUG0_DEBUG_REG_SELECT (0U) /*!< Bit position for BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BM_BCH_DEBUG0_DEBUG_REG_SELECT (0x0000003FU) /*!< Bit mask for BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BS_BCH_DEBUG0_DEBUG_REG_SELECT (6U) /*!< Bit field size in bits for BCH_DEBUG0_DEBUG_REG_SELECT. */

/*! @brief Read current value of the BCH_DEBUG0_DEBUG_REG_SELECT field. */
#define BR_BCH_DEBUG0_DEBUG_REG_SELECT(x) (HW_BCH_DEBUG0(x).B.DEBUG_REG_SELECT)

/*! @brief Format value for bitfield BCH_DEBUG0_DEBUG_REG_SELECT. */
#define BF_BCH_DEBUG0_DEBUG_REG_SELECT(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_DEBUG_REG_SELECT) & BM_BCH_DEBUG0_DEBUG_REG_SELECT)

/*! @brief Set the DEBUG_REG_SELECT field to a new value. */
#define BW_BCH_DEBUG0_DEBUG_REG_SELECT(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_DEBUG_REG_SELECT) | BF_BCH_DEBUG0_DEBUG_REG_SELECT(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field RSVD0[7:6] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG0_RSVD0  (6U)          /*!< Bit position for BCH_DEBUG0_RSVD0. */
#define BM_BCH_DEBUG0_RSVD0  (0x000000C0U) /*!< Bit mask for BCH_DEBUG0_RSVD0. */
#define BS_BCH_DEBUG0_RSVD0  (2U)          /*!< Bit field size in bits for BCH_DEBUG0_RSVD0. */

/*! @brief Read current value of the BCH_DEBUG0_RSVD0 field. */
#define BR_BCH_DEBUG0_RSVD0(x) (HW_BCH_DEBUG0(x).B.RSVD0)
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field BM_KES_TEST_BYPASS[8] (RW)
 *
 * 1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIARY
 * block so that diagnostics can preload all payload, parity bytes and computed
 * syndrome bytes for test the KES engine.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_BM_KES_TEST_BYPASS (8U) /*!< Bit position for BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BM_BCH_DEBUG0_BM_KES_TEST_BYPASS (0x00000100U) /*!< Bit mask for BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BS_BCH_DEBUG0_BM_KES_TEST_BYPASS (1U) /*!< Bit field size in bits for BCH_DEBUG0_BM_KES_TEST_BYPASS. */

#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS_NORMAL (0U) /*!< Bit field value for BCH_DEBUG0_BM_KES_TEST_BYPASS: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_BM_KES_TEST_BYPASS_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_BM_KES_TEST_BYPASS: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_BM_KES_TEST_BYPASS field. */
#define BR_BCH_DEBUG0_BM_KES_TEST_BYPASS(x) (HW_BCH_DEBUG0(x).B.BM_KES_TEST_BYPASS)

/*! @brief Format value for bitfield BCH_DEBUG0_BM_KES_TEST_BYPASS. */
#define BF_BCH_DEBUG0_BM_KES_TEST_BYPASS(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_BM_KES_TEST_BYPASS) & BM_BCH_DEBUG0_BM_KES_TEST_BYPASS)

/*! @brief Set the BM_KES_TEST_BYPASS field to a new value. */
#define BW_BCH_DEBUG0_BM_KES_TEST_BYPASS(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_BM_KES_TEST_BYPASS) | BF_BCH_DEBUG0_BM_KES_TEST_BYPASS(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_STALL[9] (RW)
 *
 * Set to one to cause KES FSM to stall after notifying Chien search engine to
 * start processing its block but before notifying the bus master that the KES
 * computation is complete. This allows a diagnostic to stall the FSM after each
 * blocks key equations are solved. This also has the effect of stalling the CSFE
 * search engine so it's state can be examined after it finishes processing the KES
 * stalled block.
 *
 * Values:
 * - 0 - KES FSM proceeds to next block supplied by bus master.
 * - 1 - KES FSM waits after current equations are solved and the search engine
 *     is started.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_STALL (9U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_STALL. */
#define BM_BCH_DEBUG0_KES_DEBUG_STALL (0x00000200U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_STALL. */
#define BS_BCH_DEBUG0_KES_DEBUG_STALL (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_STALL. */

#define BV_BCH_DEBUG0_KES_DEBUG_STALL_NORMAL (0U)    /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_STALL: KES FSM proceeds to next block supplied by bus master. */
#define BV_BCH_DEBUG0_KES_DEBUG_STALL_WAIT (0x1U)    /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_STALL: KES FSM waits after current equations are solved and the search engine is started. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_STALL field. */
#define BR_BCH_DEBUG0_KES_DEBUG_STALL(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_STALL)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_STALL. */
#define BF_BCH_DEBUG0_KES_DEBUG_STALL(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_STALL) & BM_BCH_DEBUG0_KES_DEBUG_STALL)

/*! @brief Set the KES_DEBUG_STALL field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_STALL(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_STALL) | BF_BCH_DEBUG0_KES_DEBUG_STALL(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_STEP[10] (RW)
 *
 * Toggling this bit causes the KES FSM to skip passed the stall state if it is
 * in DEBUG_STALL mode and completed processing a block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_STEP (10U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_STEP. */
#define BM_BCH_DEBUG0_KES_DEBUG_STEP (0x00000400U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_STEP. */
#define BS_BCH_DEBUG0_KES_DEBUG_STEP (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_STEP. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_STEP field. */
#define BR_BCH_DEBUG0_KES_DEBUG_STEP(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_STEP)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_STEP. */
#define BF_BCH_DEBUG0_KES_DEBUG_STEP(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_STEP) & BM_BCH_DEBUG0_KES_DEBUG_STEP)

/*! @brief Set the KES_DEBUG_STEP field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_STEP(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_STEP) | BF_BCH_DEBUG0_KES_DEBUG_STEP(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_STANDALONE[11] (RW)
 *
 * Set to one, cause the KES engine to suppress toggling the KES_BM_DONE signal
 * to the bus master and suppress toggling the CF_BM_DONE signal by the CF engine.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_STANDALONE (11U) /*!< Bit position for BCH_DEBUG0_KES_STANDALONE. */
#define BM_BCH_DEBUG0_KES_STANDALONE (0x00000800U) /*!< Bit mask for BCH_DEBUG0_KES_STANDALONE. */
#define BS_BCH_DEBUG0_KES_STANDALONE (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_STANDALONE. */

#define BV_BCH_DEBUG0_KES_STANDALONE_NORMAL (0U)     /*!< Bit field value for BCH_DEBUG0_KES_STANDALONE: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_KES_STANDALONE_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_STANDALONE: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_STANDALONE field. */
#define BR_BCH_DEBUG0_KES_STANDALONE(x) (HW_BCH_DEBUG0(x).B.KES_STANDALONE)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_STANDALONE. */
#define BF_BCH_DEBUG0_KES_STANDALONE(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_STANDALONE) & BM_BCH_DEBUG0_KES_STANDALONE)

/*! @brief Set the KES_STANDALONE field to a new value. */
#define BW_BCH_DEBUG0_KES_STANDALONE(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_STANDALONE) | BF_BCH_DEBUG0_KES_STANDALONE(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_KICK[12] (RW)
 *
 * Toggling causes KES engine FSM to start as if kick by the Bus Master. This
 * allows stand alone testing of the KES and Chien Search engines. Be sure to set
 * KES_BCH_DEBUG0_KES_STANDALONE mode to 1 before kicking.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_KICK (12U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_KICK. */
#define BM_BCH_DEBUG0_KES_DEBUG_KICK (0x00001000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_KICK. */
#define BS_BCH_DEBUG0_KES_DEBUG_KICK (1U)  /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_KICK. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_KICK field. */
#define BR_BCH_DEBUG0_KES_DEBUG_KICK(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_KICK)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_KICK. */
#define BF_BCH_DEBUG0_KES_DEBUG_KICK(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_KICK) & BM_BCH_DEBUG0_KES_DEBUG_KICK)

/*! @brief Set the KES_DEBUG_KICK field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_KICK(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_KICK) | BF_BCH_DEBUG0_KES_DEBUG_KICK(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_MODE4K[13] (RW)
 *
 * When running the stand alone debug mode on the error calculator, the state of
 * this bit is presented to the KES engine as the input mode (4K or 2K pages).
 *
 * Values:
 * - 1 - Mode is set for 4K NAND pages.
 * - 1 - Mode is set for 2K NAND pages.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_MODE4K (13U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BM_BCH_DEBUG0_KES_DEBUG_MODE4K (0x00002000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BS_BCH_DEBUG0_KES_DEBUG_MODE4K (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_MODE4K. */

#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K_4k (0x1U)     /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_MODE4K: Mode is set for 4K NAND pages. */
#define BV_BCH_DEBUG0_KES_DEBUG_MODE4K_2k (0x1U)     /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_MODE4K: Mode is set for 2K NAND pages. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_MODE4K field. */
#define BR_BCH_DEBUG0_KES_DEBUG_MODE4K(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_MODE4K)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_MODE4K. */
#define BF_BCH_DEBUG0_KES_DEBUG_MODE4K(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_MODE4K) & BM_BCH_DEBUG0_KES_DEBUG_MODE4K)

/*! @brief Set the KES_DEBUG_MODE4K field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_MODE4K(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_MODE4K) | BF_BCH_DEBUG0_KES_DEBUG_MODE4K(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_PAYLOAD_FLAG[14] (RW)
 *
 * When running the stand alone debug mode on the error calculator, the state of
 * this bit is presented to the KES engine as the input payload flag.
 *
 * Values:
 * - 1 - Payload is set for 512 bytes data block.
 * - 1 - Payload is set for 65 or 19 bytes auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (14U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (0x00004000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BS_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */

#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_DATA (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG: Payload is set for 512 bytes data block. */
#define BV_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG_AUX (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG: Payload is set for 65 or 19 bytes auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG field. */
#define BR_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_PAYLOAD_FLAG)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG. */
#define BF_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG) & BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG)

/*! @brief Set the KES_DEBUG_PAYLOAD_FLAG field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG) | BF_BCH_DEBUG0_KES_DEBUG_PAYLOAD_FLAG(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_SHIFT_SYND[15] (RW)
 *
 * Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL to be
 * shift into the syndrome register array at the input to the KES engine. After
 * shifting in 16 symbols, one can kick off both KES and CF cycles by toggling
 * BCH_DEBUG0_KES_DEBUG_KICK. Make sure that set KES_BCH_DEBUG0_KES_STANDALONE mode to
 * 1 before kicking.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (15U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (0x00008000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BS_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND (1U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_SHIFT_SYND field. */
#define BR_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_SHIFT_SYND)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_SHIFT_SYND. */
#define BF_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND) & BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND)

/*! @brief Set the KES_DEBUG_SHIFT_SYND field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND) | BF_BCH_DEBUG0_KES_DEBUG_SHIFT_SYND(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field KES_DEBUG_SYNDROME_SYMBOL[24:16] (RW)
 *
 * The 9 bit value in this bit field shifts into the syndrome register array at
 * the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT_SYND is
 * toggled.
 *
 * Values:
 * - 0 - Bus master address generator for SYND_GEN writes operates normally.
 * - 1 - Bus master address generator always addresses last four bytes in
 *     Auxiliary block.
 */
/*@{*/
#define BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (16U) /*!< Bit position for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (0x01FF0000U) /*!< Bit mask for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BS_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL (9U) /*!< Bit field size in bits for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */

#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_NORMAL (0U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL: Bus master address generator for SYND_GEN writes operates normally. */
#define BV_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL_TEST_MODE (0x1U) /*!< Bit field value for BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL: Bus master address generator always addresses last four bytes in Auxiliary block. */

/*! @brief Read current value of the BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL field. */
#define BR_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x) (HW_BCH_DEBUG0(x).B.KES_DEBUG_SYNDROME_SYMBOL)

/*! @brief Format value for bitfield BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL. */
#define BF_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL) & BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL)

/*! @brief Set the KES_DEBUG_SYNDROME_SYMBOL field to a new value. */
#define BW_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(x, v) (HW_BCH_DEBUG0_WR(x, (HW_BCH_DEBUG0_RD(x) & ~BM_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL) | BF_BCH_DEBUG0_KES_DEBUG_SYNDROME_SYMBOL(v)))
/*@}*/

/*!
 * @name Register BCH_DEBUG0, field RSVD1[31:25] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG0_RSVD1  (25U)         /*!< Bit position for BCH_DEBUG0_RSVD1. */
#define BM_BCH_DEBUG0_RSVD1  (0xFE000000U) /*!< Bit mask for BCH_DEBUG0_RSVD1. */
#define BS_BCH_DEBUG0_RSVD1  (7U)          /*!< Bit field size in bits for BCH_DEBUG0_RSVD1. */

/*! @brief Read current value of the BCH_DEBUG0_RSVD1 field. */
#define BR_BCH_DEBUG0_RSVD1(x) (HW_BCH_DEBUG0(x).B.RSVD1)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGKESREAD - KES Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGKESREAD - KES Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator key equation solver internal state machines
 * and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgkesread
{
    uint32_t U;
    struct _hw_bch_dbgkesread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgkesread_t;

/*!
 * @name Constants and macros for entire BCH_DBGKESREAD register
 */
/*@{*/
#define HW_BCH_DBGKESREAD_ADDR(x) ((uintptr_t)(x) + 0x110U)
#define HW_BCH_DBGKESREAD_SET_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGKESREAD_CLR_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGKESREAD_TOG_ADDR(x) (HW_BCH_DBGKESREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGKESREAD(x)     (*(__I hw_bch_dbgkesread_t *) HW_BCH_DBGKESREAD_ADDR(x))
#define HW_BCH_DBGKESREAD_RD(x)  (HW_BCH_DBGKESREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGKESREAD bitfields
 */

/*!
 * @name Register BCH_DBGKESREAD, field VALUES[31:0] (RO)
 *
 * This register returns the ROM BIST CRC value after a BIST test.
 */
/*@{*/
#define BP_BCH_DBGKESREAD_VALUES (0U)      /*!< Bit position for BCH_DBGKESREAD_VALUES. */
#define BM_BCH_DBGKESREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGKESREAD_VALUES. */
#define BS_BCH_DBGKESREAD_VALUES (32U)     /*!< Bit field size in bits for BCH_DBGKESREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGKESREAD_VALUES field. */
#define BR_BCH_DBGKESREAD_VALUES(x) (HW_BCH_DBGKESREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGCSFEREAD - Chien Search Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator Chien Search internal state machines and
 * signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgcsferead
{
    uint32_t U;
    struct _hw_bch_dbgcsferead_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgcsferead_t;

/*!
 * @name Constants and macros for entire BCH_DBGCSFEREAD register
 */
/*@{*/
#define HW_BCH_DBGCSFEREAD_ADDR(x) ((uintptr_t)(x) + 0x120U)
#define HW_BCH_DBGCSFEREAD_SET_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGCSFEREAD_CLR_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGCSFEREAD_TOG_ADDR(x) (HW_BCH_DBGCSFEREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGCSFEREAD(x)    (*(__I hw_bch_dbgcsferead_t *) HW_BCH_DBGCSFEREAD_ADDR(x))
#define HW_BCH_DBGCSFEREAD_RD(x) (HW_BCH_DBGCSFEREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGCSFEREAD bitfields
 */

/*!
 * @name Register BCH_DBGCSFEREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGCSFEREAD_VALUES (0U)     /*!< Bit position for BCH_DBGCSFEREAD_VALUES. */
#define BM_BCH_DBGCSFEREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGCSFEREAD_VALUES. */
#define BS_BCH_DBGCSFEREAD_VALUES (32U)    /*!< Bit field size in bits for BCH_DBGCSFEREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGCSFEREAD_VALUES field. */
#define BR_BCH_DBGCSFEREAD_VALUES(x) (HW_BCH_DBGCSFEREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGSYNDGENREAD - Syndrome Generator Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator syndrome generator internal state machines
 * and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgsyndgenread
{
    uint32_t U;
    struct _hw_bch_dbgsyndgenread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgsyndgenread_t;

/*!
 * @name Constants and macros for entire BCH_DBGSYNDGENREAD register
 */
/*@{*/
#define HW_BCH_DBGSYNDGENREAD_ADDR(x) ((uintptr_t)(x) + 0x130U)
#define HW_BCH_DBGSYNDGENREAD_SET_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGSYNDGENREAD_CLR_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGSYNDGENREAD_TOG_ADDR(x) (HW_BCH_DBGSYNDGENREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGSYNDGENREAD(x) (*(__I hw_bch_dbgsyndgenread_t *) HW_BCH_DBGSYNDGENREAD_ADDR(x))
#define HW_BCH_DBGSYNDGENREAD_RD(x) (HW_BCH_DBGSYNDGENREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGSYNDGENREAD bitfields
 */

/*!
 * @name Register BCH_DBGSYNDGENREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGSYNDGENREAD_VALUES (0U)  /*!< Bit position for BCH_DBGSYNDGENREAD_VALUES. */
#define BM_BCH_DBGSYNDGENREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGSYNDGENREAD_VALUES. */
#define BS_BCH_DBGSYNDGENREAD_VALUES (32U) /*!< Bit field size in bits for BCH_DBGSYNDGENREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGSYNDGENREAD_VALUES field. */
#define BR_BCH_DBGSYNDGENREAD_VALUES(x) (HW_BCH_DBGSYNDGENREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_DBGAHBMREAD - Bus Master and ECC Controller Debug Read Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The hardware BCH ECC accelerator bus master, ECC controller internal state
 * machines, and signals can be seen in the ECC debug registers.
 */
typedef union _hw_bch_dbgahbmread
{
    uint32_t U;
    struct _hw_bch_dbgahbmread_bitfields
    {
        uint32_t VALUES : 32;          /*!< [31:0]  */
    } B;
} hw_bch_dbgahbmread_t;

/*!
 * @name Constants and macros for entire BCH_DBGAHBMREAD register
 */
/*@{*/
#define HW_BCH_DBGAHBMREAD_ADDR(x) ((uintptr_t)(x) + 0x140U)
#define HW_BCH_DBGAHBMREAD_SET_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0x4U)
#define HW_BCH_DBGAHBMREAD_CLR_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0x8U)
#define HW_BCH_DBGAHBMREAD_TOG_ADDR(x) (HW_BCH_DBGAHBMREAD_ADDR(x) + 0xCU)

#define HW_BCH_DBGAHBMREAD(x)    (*(__I hw_bch_dbgahbmread_t *) HW_BCH_DBGAHBMREAD_ADDR(x))
#define HW_BCH_DBGAHBMREAD_RD(x) (HW_BCH_DBGAHBMREAD(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_DBGAHBMREAD bitfields
 */

/*!
 * @name Register BCH_DBGAHBMREAD, field VALUES[31:0] (RO)
 *
 * Reserved
 */
/*@{*/
#define BP_BCH_DBGAHBMREAD_VALUES (0U)     /*!< Bit position for BCH_DBGAHBMREAD_VALUES. */
#define BM_BCH_DBGAHBMREAD_VALUES (0xFFFFFFFFU) /*!< Bit mask for BCH_DBGAHBMREAD_VALUES. */
#define BS_BCH_DBGAHBMREAD_VALUES (32U)    /*!< Bit field size in bits for BCH_DBGAHBMREAD_VALUES. */

/*! @brief Read current value of the BCH_DBGAHBMREAD_VALUES field. */
#define BR_BCH_DBGAHBMREAD_VALUES(x) (HW_BCH_DBGAHBMREAD(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_BLOCKNAME - Block Name Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_BLOCKNAME - Block Name Register (RO)
 *
 * Reset value: 0x20484342U
 *
 * Read only view of the block name string BCH. Fixed pattern read only value is
 * for test purposes. It can be read as an ASCII string with the zero
 * termination coming from the first byte of the BLOCKVERSION register.
 */
typedef union _hw_bch_blockname
{
    uint32_t U;
    struct _hw_bch_blockname_bitfields
    {
        uint32_t NAME : 32;            /*!< [31:0]  */
    } B;
} hw_bch_blockname_t;

/*!
 * @name Constants and macros for entire BCH_BLOCKNAME register
 */
/*@{*/
#define HW_BCH_BLOCKNAME_ADDR(x) ((uintptr_t)(x) + 0x150U)
#define HW_BCH_BLOCKNAME_SET_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0x4U)
#define HW_BCH_BLOCKNAME_CLR_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0x8U)
#define HW_BCH_BLOCKNAME_TOG_ADDR(x) (HW_BCH_BLOCKNAME_ADDR(x) + 0xCU)

#define HW_BCH_BLOCKNAME(x)      (*(__I hw_bch_blockname_t *) HW_BCH_BLOCKNAME_ADDR(x))
#define HW_BCH_BLOCKNAME_RD(x)   (HW_BCH_BLOCKNAME(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_BLOCKNAME bitfields
 */

/*!
 * @name Register BCH_BLOCKNAME, field NAME[31:0] (RO)
 *
 * The name is in the ASCII characters BCH (0x20, H, C, B).
 */
/*@{*/
#define BP_BCH_BLOCKNAME_NAME (0U)         /*!< Bit position for BCH_BLOCKNAME_NAME. */
#define BM_BCH_BLOCKNAME_NAME (0xFFFFFFFFU) /*!< Bit mask for BCH_BLOCKNAME_NAME. */
#define BS_BCH_BLOCKNAME_NAME (32U)        /*!< Bit field size in bits for BCH_BLOCKNAME_NAME. */

/*! @brief Read current value of the BCH_BLOCKNAME_NAME field. */
#define BR_BCH_BLOCKNAME_NAME(x) (HW_BCH_BLOCKNAME(x).U)
/*@}*/




/*******************************************************************************
 * HW_BCH_VERSION - BCH Version Register
 ******************************************************************************/

/*!
 * @brief HW_BCH_VERSION - BCH Version Register (RO)
 *
 * Reset value: 0x01000000U
 *
 * This register always returns a known read value for debug purposes and
 * indicates the version of the block and RTL version in use.
 */
typedef union _hw_bch_version
{
    uint32_t U;
    struct _hw_bch_version_bitfields
    {
        uint32_t STEP : 16;            /*!< [15:0]  */
        uint32_t MINOR : 8;            /*!< [23:16]  */
        uint32_t MAJOR : 8;            /*!< [31:24]  */
    } B;
} hw_bch_version_t;

/*!
 * @name Constants and macros for entire BCH_VERSION register
 */
/*@{*/
#define HW_BCH_VERSION_ADDR(x)   ((uintptr_t)(x) + 0x160U)
#define HW_BCH_VERSION_SET_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0x4U)
#define HW_BCH_VERSION_CLR_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0x8U)
#define HW_BCH_VERSION_TOG_ADDR(x) (HW_BCH_VERSION_ADDR(x) + 0xCU)

#define HW_BCH_VERSION(x)        (*(__I hw_bch_version_t *) HW_BCH_VERSION_ADDR(x))
#define HW_BCH_VERSION_RD(x)     (HW_BCH_VERSION(x).U)
/*@}*/

/*
 * Constants & macros for individual BCH_VERSION bitfields
 */

/*!
 * @name Register BCH_VERSION, field STEP[15:0] (RO)
 *
 * Fixed read-only value reflecting the stepping of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_STEP  (0U)          /*!< Bit position for BCH_VERSION_STEP. */
#define BM_BCH_VERSION_STEP  (0x0000FFFFU) /*!< Bit mask for BCH_VERSION_STEP. */
#define BS_BCH_VERSION_STEP  (16U)         /*!< Bit field size in bits for BCH_VERSION_STEP. */

/*! @brief Read current value of the BCH_VERSION_STEP field. */
#define BR_BCH_VERSION_STEP(x) (HW_BCH_VERSION(x).B.STEP)
/*@}*/

/*!
 * @name Register BCH_VERSION, field MINOR[23:16] (RO)
 *
 * Fixed read-only value indicates the MINOR field of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_MINOR (16U)         /*!< Bit position for BCH_VERSION_MINOR. */
#define BM_BCH_VERSION_MINOR (0x00FF0000U) /*!< Bit mask for BCH_VERSION_MINOR. */
#define BS_BCH_VERSION_MINOR (8U)          /*!< Bit field size in bits for BCH_VERSION_MINOR. */

/*! @brief Read current value of the BCH_VERSION_MINOR field. */
#define BR_BCH_VERSION_MINOR(x) (HW_BCH_VERSION(x).B.MINOR)
/*@}*/

/*!
 * @name Register BCH_VERSION, field MAJOR[31:24] (RO)
 *
 * Fixed read-only value indicates the MAJOR field of the RTL version.
 */
/*@{*/
#define BP_BCH_VERSION_MAJOR (24U)         /*!< Bit position for BCH_VERSION_MAJOR. */
#define BM_BCH_VERSION_MAJOR (0xFF000000U) /*!< Bit mask for BCH_VERSION_MAJOR. */
#define BS_BCH_VERSION_MAJOR (8U)          /*!< Bit field size in bits for BCH_VERSION_MAJOR. */

/*! @brief Read current value of the BCH_VERSION_MAJOR field. */
#define BR_BCH_VERSION_MAJOR(x) (HW_BCH_VERSION(x).B.MAJOR)
/*@}*/




/*******************************************************************************
 * HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1
 ******************************************************************************/

/*!
 * @brief HW_BCH_DEBUG1 - Hardware BCH ECC Debug Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The BCH_DEBUG1 register provides erased zero count information and pre-erase
 * check.
 */
typedef union _hw_bch_debug1
{
    uint32_t U;
    struct _hw_bch_debug1_bitfields
    {
        uint32_t ERASED_ZERO_COUNT : 9; /*!< [8:0]  */
        uint32_t RSVD : 22;            /*!< [30:9] This field is reserved. */
        uint32_t DEBUG1_PREERASECHK : 1; /*!< [31]  */
    } B;
} hw_bch_debug1_t;

/*!
 * @name Constants and macros for entire BCH_DEBUG1 register
 */
/*@{*/
#define HW_BCH_DEBUG1_ADDR(x)    ((uintptr_t)(x) + 0x170U)
#define HW_BCH_DEBUG1_SET_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0x4U)
#define HW_BCH_DEBUG1_CLR_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0x8U)
#define HW_BCH_DEBUG1_TOG_ADDR(x) (HW_BCH_DEBUG1_ADDR(x) + 0xCU)

#define HW_BCH_DEBUG1(x)         (*(__IO hw_bch_debug1_t *) HW_BCH_DEBUG1_ADDR(x))
#define HW_BCH_DEBUG1_RD(x)      (HW_BCH_DEBUG1(x).U)
#define HW_BCH_DEBUG1_WR(x, v)   (HW_BCH_DEBUG1(x).U = (v))
#define HW_BCH_DEBUG1_SET(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_SET_ADDR(x)) = (v))
#define HW_BCH_DEBUG1_CLR(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_CLR_ADDR(x)) = (v))
#define HW_BCH_DEBUG1_TOG(x, v)  ((*(uint32_t *) HW_BCH_DEBUG1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual BCH_DEBUG1 bitfields
 */

/*!
 * @name Register BCH_DEBUG1, field ERASED_ZERO_COUNT[8:0] (RO)
 *
 * The zero counts on one page.
 */
/*@{*/
#define BP_BCH_DEBUG1_ERASED_ZERO_COUNT (0U) /*!< Bit position for BCH_DEBUG1_ERASED_ZERO_COUNT. */
#define BM_BCH_DEBUG1_ERASED_ZERO_COUNT (0x000001FFU) /*!< Bit mask for BCH_DEBUG1_ERASED_ZERO_COUNT. */
#define BS_BCH_DEBUG1_ERASED_ZERO_COUNT (9U) /*!< Bit field size in bits for BCH_DEBUG1_ERASED_ZERO_COUNT. */

/*! @brief Read current value of the BCH_DEBUG1_ERASED_ZERO_COUNT field. */
#define BR_BCH_DEBUG1_ERASED_ZERO_COUNT(x) (HW_BCH_DEBUG1(x).B.ERASED_ZERO_COUNT)
/*@}*/

/*!
 * @name Register BCH_DEBUG1, field RSVD[30:9] (RO)
 *
 * This read-only field is reserved and always has the value 0.
 */
/*@{*/
#define BP_BCH_DEBUG1_RSVD   (9U)          /*!< Bit position for BCH_DEBUG1_RSVD. */
#define BM_BCH_DEBUG1_RSVD   (0x7FFFFE00U) /*!< Bit mask for BCH_DEBUG1_RSVD. */
#define BS_BCH_DEBUG1_RSVD   (22U)         /*!< Bit field size in bits for BCH_DEBUG1_RSVD. */

/*! @brief Read current value of the BCH_DEBUG1_RSVD field. */
#define BR_BCH_DEBUG1_RSVD(x) (HW_BCH_DEBUG1(x).B.RSVD)
/*@}*/

/*!
 * @name Register BCH_DEBUG1, field DEBUG1_PREERASECHK[31] (RW)
 *
 * Blank page enables pre-erase check.
 *
 * Values:
 * - 0 - Turn off pre-erase check
 * - 1 - Turn on pre-erase check
 */
/*@{*/
#define BP_BCH_DEBUG1_DEBUG1_PREERASECHK (31U) /*!< Bit position for BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BM_BCH_DEBUG1_DEBUG1_PREERASECHK (0x80000000U) /*!< Bit mask for BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BS_BCH_DEBUG1_DEBUG1_PREERASECHK (1U) /*!< Bit field size in bits for BCH_DEBUG1_DEBUG1_PREERASECHK. */

/*! @brief Read current value of the BCH_DEBUG1_DEBUG1_PREERASECHK field. */
#define BR_BCH_DEBUG1_DEBUG1_PREERASECHK(x) (HW_BCH_DEBUG1(x).B.DEBUG1_PREERASECHK)

/*! @brief Format value for bitfield BCH_DEBUG1_DEBUG1_PREERASECHK. */
#define BF_BCH_DEBUG1_DEBUG1_PREERASECHK(v) ((uint32_t)((uint32_t)(v) << BP_BCH_DEBUG1_DEBUG1_PREERASECHK) & BM_BCH_DEBUG1_DEBUG1_PREERASECHK)

/*! @brief Set the DEBUG1_PREERASECHK field to a new value. */
#define BW_BCH_DEBUG1_DEBUG1_PREERASECHK(x, v) (HW_BCH_DEBUG1_WR(x, (HW_BCH_DEBUG1_RD(x) & ~BM_BCH_DEBUG1_DEBUG1_PREERASECHK) | BF_BCH_DEBUG1_DEBUG1_PREERASECHK(v)))
/*@}*/




/*******************************************************************************
 * hw_bch_t - module struct
 ******************************************************************************/
/*!
 * @brief All BCH module registers.
 */
#pragma pack(1)
typedef struct _hw_bch
{
    __IO hw_bch_ctrl_t CTRL;               /*!< [0x0] Hardware BCH ECC Accelerator Control Register */
    uint8_t _reserved0[12];
    __I hw_bch_status0_t STATUS0;          /*!< [0x10] Hardware ECC Accelerator Status Register 0 */
    uint8_t _reserved1[12];
    __IO hw_bch_mode_t MODE;               /*!< [0x20] Hardware ECC Accelerator Mode Register */
    uint8_t _reserved2[12];
    __IO hw_bch_encodeptr_t ENCODEPTR;     /*!< [0x30] Hardware BCH ECC Loopback Encode Buffer Register */
    uint8_t _reserved3[12];
    __IO hw_bch_dataptr_t DATAPTR;         /*!< [0x40] Hardware BCH ECC Loopback Data Buffer Register */
    uint8_t _reserved4[12];
    __IO hw_bch_metaptr_t METAPTR;         /*!< [0x50] Hardware BCH ECC Loopback Metadata Buffer Register */
    uint8_t _reserved5[28];
    __IO hw_bch_layoutselect_t LAYOUTSELECT; /*!< [0x70] Hardware ECC Accelerator Layout Select Register */
    uint8_t _reserved6[12];
    __IO hw_bch_flash0layout0_t FLASH0LAYOUT0; /*!< [0x80] Hardware BCH ECC Flash 0 Layout 0 Register */
    uint8_t _reserved7[12];
    __IO hw_bch_flash0layout1_t FLASH0LAYOUT1; /*!< [0x90] Hardware BCH ECC Flash 0 Layout 1 Register */
    uint8_t _reserved8[12];
    __IO hw_bch_flash1layout0_t FLASH1LAYOUT0; /*!< [0xA0] Hardware BCH ECC Flash 1 Layout 0 Register */
    uint8_t _reserved9[12];
    __IO hw_bch_flash1layout1_t FLASH1LAYOUT1; /*!< [0xB0] Hardware BCH ECC Flash 1 Layout 1 Register */
    uint8_t _reserved10[12];
    __IO hw_bch_flash2layout0_t FLASH2LAYOUT0; /*!< [0xC0] Hardware BCH ECC Flash 2 Layout 0 Register */
    uint8_t _reserved11[12];
    __IO hw_bch_flash2layout1_t FLASH2LAYOUT1; /*!< [0xD0] Hardware BCH ECC Flash 2 Layout 1 Register */
    uint8_t _reserved12[12];
    __IO hw_bch_flash3layout0_t FLASH3LAYOUT0; /*!< [0xE0] Hardware BCH ECC Flash 3 Layout 0 Register */
    uint8_t _reserved13[12];
    __IO hw_bch_flash3layout1_t FLASH3LAYOUT1; /*!< [0xF0] Hardware BCH ECC Flash 3 Layout 1 Register */
    uint8_t _reserved14[12];
    __IO hw_bch_debug0_t DEBUG0;           /*!< [0x100] Hardware BCH ECC Debug Register0 */
    uint8_t _reserved15[12];
    __I hw_bch_dbgkesread_t DBGKESREAD;    /*!< [0x110] KES Debug Read Register */
    uint8_t _reserved16[12];
    __I hw_bch_dbgcsferead_t DBGCSFEREAD;  /*!< [0x120] Chien Search Debug Read Register */
    uint8_t _reserved17[12];
    __I hw_bch_dbgsyndgenread_t DBGSYNDGENREAD; /*!< [0x130] Syndrome Generator Debug Read Register */
    uint8_t _reserved18[12];
    __I hw_bch_dbgahbmread_t DBGAHBMREAD;  /*!< [0x140] Bus Master and ECC Controller Debug Read Register */
    uint8_t _reserved19[12];
    __I hw_bch_blockname_t BLOCKNAME;      /*!< [0x150] Block Name Register */
    uint8_t _reserved20[12];
    __I hw_bch_version_t VERSION;          /*!< [0x160] BCH Version Register */
    uint8_t _reserved21[12];
    __IO hw_bch_debug1_t DEBUG1;           /*!< [0x170] Hardware BCH ECC Debug Register 1 */
} hw_bch_t;
#pragma pack()

/*! @brief Macro to access all BCH registers. */
/*! @param x BCH module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_BCH_REGS(BCH_BASE)</code>. */
#define HW_BCH_REGS(x) (*(hw_bch_t *)(x))

/*
 * iMX7S CAN
 *
 * FLEXCAN
 *
 * Registers defined in this header file:
 * - HW_CAN_MCR - Module Configuration Register
 * - HW_CAN_CTRL1 - Control 1 Register
 * - HW_CAN_TIMER - Free Running Timer Register
 * - HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 * - HW_CAN_RX14MASK - Rx Buffer 14 Mask Register
 * - HW_CAN_RX15MASK - Rx Buffer 15 Mask Register
 * - HW_CAN_ECR - Error Counter Register
 * - HW_CAN_ESR1 - Error and Status 1 Register
 * - HW_CAN_IMASK2 - Interrupt Masks 2 Register
 * - HW_CAN_IMASK1 - Interrupt Masks 1 Register
 * - HW_CAN_IFLAG2 - Interrupt Flags 2 Register
 * - HW_CAN_IFLAG1 - Interrupt Flags 1 Register
 * - HW_CAN_CTRL2 - Control 2 Register
 * - HW_CAN_ESR2 - Error and Status 2 Register
 * - HW_CAN_CRCR - CRC Register
 * - HW_CAN_RXFGMASK - Rx FIFO Global Mask Register
 * - HW_CAN_RXFIR - Rx FIFO Information Register
 * - HW_CAN_CSn - Message Buffer 0 CS Register
 * - HW_CAN_IDn - Message Buffer 0 ID Register
 * - HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 * - HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 * - HW_CAN_RXIMRn - RXIMR
 * - HW_CAN_GFWR - Glitch Filter Width Registers
 *
 * - hw_can_t - Struct containing all module registers.
 */

#define HW_CAN_INSTANCE_COUNT (2U) /*!< Number of instances of the CAN module. */
#define HW_CAN1 (0U) /*!< Instance number for CAN1. */
#define HW_CAN2 (1U) /*!< Instance number for CAN2. */
#define CAN1_BASE             (0x30A00000U) /*!< Base address for CAN1. */
#define CAN2_BASE             (0x30A10000U) /*!< Base address for CAN2. */
/*! Array initializer of CAN base addresses. */
#define CAN_BASE_ADDRS        { CAN1_BASE, CAN2_BASE }

/*******************************************************************************
 * HW_CAN_MCR - Module Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_MCR - Module Configuration Register (RW)
 *
 * Reset value: 0x5980000FU
 *
 * This register defines global system configurations, such as the module
 * operation mode (e.g., low power) and maximum message buffer configuration.
 */
typedef union _hw_can_mcr
{
    uint32_t U;
    struct _hw_can_mcr_bitfields
    {
        uint32_t MAXMB : 7;            /*!< [6:0]  */
        uint32_t RESERVED0 : 1;        /*!< [7]  */
        uint32_t IDAM : 2;             /*!< [9:8]  */
        uint32_t RESERVED1 : 2;        /*!< [11:10]  */
        uint32_t AEN : 1;              /*!< [12]  */
        uint32_t LPRIO_EN : 1;         /*!< [13]  */
        uint32_t RESERVED2 : 2;        /*!< [15:14]  */
        uint32_t IRMQ : 1;             /*!< [16]  */
        uint32_t SRX_DIS : 1;          /*!< [17]  */
        uint32_t RESERVED3 : 1;        /*!< [18]  */
        uint32_t WAK_SRC : 1;          /*!< [19]  */
        uint32_t LPM_ACK : 1;          /*!< [20]  */
        uint32_t WRN_EN : 1;           /*!< [21]  */
        uint32_t SLF_WAK : 1;          /*!< [22]  */
        uint32_t SUPV : 1;             /*!< [23]  */
        uint32_t FRZ_ACK : 1;          /*!< [24]  */
        uint32_t SOFT_RST : 1;         /*!< [25]  */
        uint32_t WAK_MSK : 1;          /*!< [26]  */
        uint32_t NOT_RDY : 1;          /*!< [27]  */
        uint32_t HALT : 1;             /*!< [28]  */
        uint32_t RFEN : 1;             /*!< [29]  */
        uint32_t FRZ : 1;              /*!< [30]  */
        uint32_t MDIS : 1;             /*!< [31]  */
    } B;
} hw_can_mcr_t;

/*!
 * @name Constants and macros for entire CAN_MCR register
 */
/*@{*/
#define HW_CAN_MCR_ADDR(x)       ((uintptr_t)(x) + 0x0U)

#define HW_CAN_MCR(x)            (*(__IO hw_can_mcr_t *) HW_CAN_MCR_ADDR(x))
#define HW_CAN_MCR_RD(x)         (HW_CAN_MCR(x).U)
#define HW_CAN_MCR_WR(x, v)      (HW_CAN_MCR(x).U = (v))
#define HW_CAN_MCR_SET(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) |  (v)))
#define HW_CAN_MCR_CLR(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) & ~(v)))
#define HW_CAN_MCR_TOG(x, v)     (HW_CAN_MCR_WR(x, HW_CAN_MCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_MCR bitfields
 */

/*!
 * @name Register CAN_MCR, field MAXMB[6:0] (RW)
 *
 * This 7-bit field defines the number of the last Message Buffers that will
 * take part in the matching and arbitration processes. The reset value (0x0F) is
 * equivalent to 16 MB configuration. This field can only be written in Freeze Mode
 * as it is blocked by hardware in other modes Number of the last MB = MAXMB.
 * Additionally, the value of MAXMB must encompass the FIFO size defined by
 * CTRL2[RFFN] MAXMB also impacts the definition of the minimum number of peripheral
 * clocks per CAN bit as described in (see Arbitration and Matching Timing).
 */
/*@{*/
#define BP_CAN_MCR_MAXMB     (0U)          /*!< Bit position for CAN_MCR_MAXMB. */
#define BM_CAN_MCR_MAXMB     (0x0000007FU) /*!< Bit mask for CAN_MCR_MAXMB. */
#define BS_CAN_MCR_MAXMB     (7U)          /*!< Bit field size in bits for CAN_MCR_MAXMB. */

/*! @brief Read current value of the CAN_MCR_MAXMB field. */
#define BR_CAN_MCR_MAXMB(x)  (HW_CAN_MCR(x).B.MAXMB)

/*! @brief Format value for bitfield CAN_MCR_MAXMB. */
#define BF_CAN_MCR_MAXMB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MAXMB) & BM_CAN_MCR_MAXMB)

/*! @brief Set the MAXMB field to a new value. */
#define BW_CAN_MCR_MAXMB(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_MAXMB) | BF_CAN_MCR_MAXMB(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field IDAM[9:8] (RW)
 *
 * This 2-bit field identifies the format of the elements of the Rx FIFO filter
 * table, as shown below. Note that all elements of the table are configured at
 * the same time by this field (they are all the same format). See Rx FIFO
 * StructureWhen the MCR[RFEN] bit is set, the memory area from $80 to $DC (which is
 * normally occupied by MBs 0 to 5) is used by the reception FIFO engine. . This bit
 * can only be written in Freeze mode as it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 00 - Format A One full ID (standard or extended) per ID filter Table
 *     element.
 * - 01 - Format B Two full standard IDs or two partial 14-bit extended IDs per
 *     ID filter Table element.
 * - 10 - Format C Four partial 8-bit IDs (standard or extended) per ID filter
 *     Table element.
 * - 11 - Format D All frames rejected.
 */
/*@{*/
#define BP_CAN_MCR_IDAM      (8U)          /*!< Bit position for CAN_MCR_IDAM. */
#define BM_CAN_MCR_IDAM      (0x00000300U) /*!< Bit mask for CAN_MCR_IDAM. */
#define BS_CAN_MCR_IDAM      (2U)          /*!< Bit field size in bits for CAN_MCR_IDAM. */

/*! @brief Read current value of the CAN_MCR_IDAM field. */
#define BR_CAN_MCR_IDAM(x)   (HW_CAN_MCR(x).B.IDAM)

/*! @brief Format value for bitfield CAN_MCR_IDAM. */
#define BF_CAN_MCR_IDAM(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IDAM) & BM_CAN_MCR_IDAM)

/*! @brief Set the IDAM field to a new value. */
#define BW_CAN_MCR_IDAM(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_IDAM) | BF_CAN_MCR_IDAM(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field AEN[12] (RW)
 *
 * This bit is supplied for backwards compatibility reasons. When asserted, it
 * enables the Tx abort feature. This feature guarantees a safe procedure for
 * aborting a pending transmission, so that no frame is sent in the CAN bus without
 * notification. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.Write Abort code into Rx Mailboxes can cause
 * unpredictable results when the MCR[AEN] is asserted.
 *
 * Values:
 * - 1 - Abort enabled
 * - 0 - Abort disabled
 */
/*@{*/
#define BP_CAN_MCR_AEN       (12U)         /*!< Bit position for CAN_MCR_AEN. */
#define BM_CAN_MCR_AEN       (0x00001000U) /*!< Bit mask for CAN_MCR_AEN. */
#define BS_CAN_MCR_AEN       (1U)          /*!< Bit field size in bits for CAN_MCR_AEN. */

/*! @brief Read current value of the CAN_MCR_AEN field. */
#define BR_CAN_MCR_AEN(x)    (HW_CAN_MCR(x).B.AEN)

/*! @brief Format value for bitfield CAN_MCR_AEN. */
#define BF_CAN_MCR_AEN(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_AEN) & BM_CAN_MCR_AEN)

/*! @brief Set the AEN field to a new value. */
#define BW_CAN_MCR_AEN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_AEN) | BF_CAN_MCR_AEN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPRIO_EN[13] (RW)
 *
 * This bit is provided for backwards compatibility reasons. It controls whether
 * the local priority feature is enabled or not. It is used to extend the ID
 * used during the arbitration process. With this extended ID concept, the
 * arbitration process is done based on the full 32-bit word, but the actual transmitted
 * ID still has 11-bit for standard frames and 29-bit for extended frames.This bit
 * can only be written in Freeze mode as it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 1 - Local Priority enabled
 * - 0 - Local Priority disabled
 */
/*@{*/
#define BP_CAN_MCR_LPRIO_EN  (13U)         /*!< Bit position for CAN_MCR_LPRIO_EN. */
#define BM_CAN_MCR_LPRIO_EN  (0x00002000U) /*!< Bit mask for CAN_MCR_LPRIO_EN. */
#define BS_CAN_MCR_LPRIO_EN  (1U)          /*!< Bit field size in bits for CAN_MCR_LPRIO_EN. */

/*! @brief Read current value of the CAN_MCR_LPRIO_EN field. */
#define BR_CAN_MCR_LPRIO_EN(x) (HW_CAN_MCR(x).B.LPRIO_EN)

/*! @brief Format value for bitfield CAN_MCR_LPRIO_EN. */
#define BF_CAN_MCR_LPRIO_EN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_LPRIO_EN) & BM_CAN_MCR_LPRIO_EN)

/*! @brief Set the LPRIO_EN field to a new value. */
#define BW_CAN_MCR_LPRIO_EN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_LPRIO_EN) | BF_CAN_MCR_LPRIO_EN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field IRMQ[16] (RW)
 *
 * This bit indicates whether Rx matching process will be based either on
 * individual masking and queue or on masking scheme with RXMGMASK, RX14MASK and
 * RX15MASK, RXFGMASK. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Individual Rx masking and queue feature are enabled.
 * - 0 - Individual Rx masking and queue feature are disabled.For backward
 *     compatibility, the reading of C/S word locks the MB even if it is EMPTY.
 */
/*@{*/
#define BP_CAN_MCR_IRMQ      (16U)         /*!< Bit position for CAN_MCR_IRMQ. */
#define BM_CAN_MCR_IRMQ      (0x00010000U) /*!< Bit mask for CAN_MCR_IRMQ. */
#define BS_CAN_MCR_IRMQ      (1U)          /*!< Bit field size in bits for CAN_MCR_IRMQ. */

/*! @brief Read current value of the CAN_MCR_IRMQ field. */
#define BR_CAN_MCR_IRMQ(x)   (HW_CAN_MCR(x).B.IRMQ)

/*! @brief Format value for bitfield CAN_MCR_IRMQ. */
#define BF_CAN_MCR_IRMQ(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_IRMQ) & BM_CAN_MCR_IRMQ)

/*! @brief Set the IRMQ field to a new value. */
#define BW_CAN_MCR_IRMQ(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_IRMQ) | BF_CAN_MCR_IRMQ(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SRX_DIS[17] (RW)
 *
 * This bit defines whether FlexCAN is allowed to receive frames transmitted by
 * itself. If this bit is asserted, frames transmitted by the module will not be
 * stored in any MB, regardless if the MB is programmed with an ID that matches
 * the transmitted frame, and no interrupt flag or interrupt signal will be
 * generated due to the frame reception. This bit can only be written in Freeze mode as
 * it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Self reception disabled
 * - 0 - Self reception enabled
 */
/*@{*/
#define BP_CAN_MCR_SRX_DIS   (17U)         /*!< Bit position for CAN_MCR_SRX_DIS. */
#define BM_CAN_MCR_SRX_DIS   (0x00020000U) /*!< Bit mask for CAN_MCR_SRX_DIS. */
#define BS_CAN_MCR_SRX_DIS   (1U)          /*!< Bit field size in bits for CAN_MCR_SRX_DIS. */

/*! @brief Read current value of the CAN_MCR_SRX_DIS field. */
#define BR_CAN_MCR_SRX_DIS(x) (HW_CAN_MCR(x).B.SRX_DIS)

/*! @brief Format value for bitfield CAN_MCR_SRX_DIS. */
#define BF_CAN_MCR_SRX_DIS(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SRX_DIS) & BM_CAN_MCR_SRX_DIS)

/*! @brief Set the SRX_DIS field to a new value. */
#define BW_CAN_MCR_SRX_DIS(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SRX_DIS) | BF_CAN_MCR_SRX_DIS(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAK_SRC[19] (RW)
 *
 * This bit defines whether the integrated low-pass filter is applied to protect
 * the FLEXCAN_RX input from spurious wake up. See Stop ModeThis is a system low
 * power mode in which system clocks can be stopped for maximum power savings..
 * To enter stop mode, the CPU should manually assert a global Stop Mode request
 * (see the CAN1_STOP_REQ and CAN2_STOP_REQ bit in the register IOMUXC_GPR4)and
 * check the acknowledgement asserted by the FlexCAN (see the CAN1_STOP_ACK and
 * CAN2_STOP_ACK in the register IOMUXC_GPR4) . The CPU must only consider the
 * FlexCAN in Stop Mode when both request and acknowledgement conditions are
 * satisfied. for more information. This bit can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FLEXCAN uses the filtered FLEXCAN_RX input to detect recessive to
 *     dominant edges on the CAN bus
 * - 0 - FLEXCAN uses the unfiltered FLEXCAN_RX input to detect recessive to
 *     dominant edges on the CAN bus.
 */
/*@{*/
#define BP_CAN_MCR_WAK_SRC   (19U)         /*!< Bit position for CAN_MCR_WAK_SRC. */
#define BM_CAN_MCR_WAK_SRC   (0x00080000U) /*!< Bit mask for CAN_MCR_WAK_SRC. */
#define BS_CAN_MCR_WAK_SRC   (1U)          /*!< Bit field size in bits for CAN_MCR_WAK_SRC. */

/*! @brief Read current value of the CAN_MCR_WAK_SRC field. */
#define BR_CAN_MCR_WAK_SRC(x) (HW_CAN_MCR(x).B.WAK_SRC)

/*! @brief Format value for bitfield CAN_MCR_WAK_SRC. */
#define BF_CAN_MCR_WAK_SRC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAK_SRC) & BM_CAN_MCR_WAK_SRC)

/*! @brief Set the WAK_SRC field to a new value. */
#define BW_CAN_MCR_WAK_SRC(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WAK_SRC) | BF_CAN_MCR_WAK_SRC(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPM_ACK[20] (RO)
 *
 * This read-only bit indicates that FLEXCAN is either in Disable Mode or Stop
 * Mode. Either of these low power modes can not be entered until all current
 * transmission or reception processes have finished, so the ARM can poll the LPM_ACK
 * bit to know when FLEXCAN has actually entered low power mode. See Module
 * Disable ModeThis low power mode is normally used to temporarily disable a complete
 * FlexCAN block, with no power consumption. It is requested by the ARM through
 * the assertion of the MDIS bit in the MCR Register and the acknowledgement is
 * obtained through the assertion by the FlexCAN of the LPM_ACK bit in the same
 * register. The ARM must only consider the FlexCAN in Disable Mode when both
 * request and acknowledgement conditions are satisfied. , and Stop ModeThis is a
 * system low power mode in which system clocks can be stopped for maximum power
 * savings.. To enter stop mode, the CPU should manually assert a global Stop Mode
 * request (see the CAN1_STOP_REQ and CAN2_STOP_REQ bit in the register
 * IOMUXC_GPR4)and check the acknowledgement asserted by the FlexCAN (see the CAN1_STOP_ACK
 * and CAN2_STOP_ACK in the register IOMUXC_GPR4) . The CPU must only consider
 * the FlexCAN in Stop Mode when both request and acknowledgement conditions are
 * satisfied. for more information
 *
 * Values:
 * - 1 - FLEXCAN is either in Disable Mode, or Stop mode
 * - 0 - FLEXCAN not in any of the low power modes
 */
/*@{*/
#define BP_CAN_MCR_LPM_ACK   (20U)         /*!< Bit position for CAN_MCR_LPM_ACK. */
#define BM_CAN_MCR_LPM_ACK   (0x00100000U) /*!< Bit mask for CAN_MCR_LPM_ACK. */
#define BS_CAN_MCR_LPM_ACK   (1U)          /*!< Bit field size in bits for CAN_MCR_LPM_ACK. */

/*! @brief Read current value of the CAN_MCR_LPM_ACK field. */
#define BR_CAN_MCR_LPM_ACK(x) (HW_CAN_MCR(x).B.LPM_ACK)
/*@}*/

/*!
 * @name Register CAN_MCR, field WRN_EN[21] (RW)
 *
 * When asserted, this bit enables the generation of the TWRN_INT and RWRN_INT
 * flags in the Error and Status Register. If WRN_EN is negated, the TWRN_INT and
 * RWRN_INT flags will always be zero, independent of the values of the error
 * counters, and no warning interrupt will ever be generated.This bit can only be
 * written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - TWRN_INT and RWRN_INT bits are set when the respective error counter
 *     transition from <96 to >= 96.
 * - 0 - TWRN_INT and RWRN_INT bits are zero, independent of the values in the
 *     error counters.
 */
/*@{*/
#define BP_CAN_MCR_WRN_EN    (21U)         /*!< Bit position for CAN_MCR_WRN_EN. */
#define BM_CAN_MCR_WRN_EN    (0x00200000U) /*!< Bit mask for CAN_MCR_WRN_EN. */
#define BS_CAN_MCR_WRN_EN    (1U)          /*!< Bit field size in bits for CAN_MCR_WRN_EN. */

/*! @brief Read current value of the CAN_MCR_WRN_EN field. */
#define BR_CAN_MCR_WRN_EN(x) (HW_CAN_MCR(x).B.WRN_EN)

/*! @brief Format value for bitfield CAN_MCR_WRN_EN. */
#define BF_CAN_MCR_WRN_EN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WRN_EN) & BM_CAN_MCR_WRN_EN)

/*! @brief Set the WRN_EN field to a new value. */
#define BW_CAN_MCR_WRN_EN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WRN_EN) | BF_CAN_MCR_WRN_EN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SLF_WAK[22] (RW)
 *
 * This bit enables the Self Wake Up feature when FLEXCAN is in Stop Mode. If
 * this bit had been asserted by the time FLEXCAN entered Stop Mode, then FLEXCAN
 * will look for a recessive to dominant transition on the bus during these modes.
 * If a transition from recessive to dominant is detected during Stop Mode, then
 * FLEXCAN generates, if enabled to do so, a Wake Up interrupt to the ARM so
 * that it can resume the clocks globally and FlexCAN can request to resume the
 * clocks. This bit can not be written while the module is in Stop Mode.
 *
 * Values:
 * - 1 - FLEXCAN Self Wake Up feature is enabled
 * - 0 - FLEXCAN Self Wake Up feature is disabled
 */
/*@{*/
#define BP_CAN_MCR_SLF_WAK   (22U)         /*!< Bit position for CAN_MCR_SLF_WAK. */
#define BM_CAN_MCR_SLF_WAK   (0x00400000U) /*!< Bit mask for CAN_MCR_SLF_WAK. */
#define BS_CAN_MCR_SLF_WAK   (1U)          /*!< Bit field size in bits for CAN_MCR_SLF_WAK. */

/*! @brief Read current value of the CAN_MCR_SLF_WAK field. */
#define BR_CAN_MCR_SLF_WAK(x) (HW_CAN_MCR(x).B.SLF_WAK)

/*! @brief Format value for bitfield CAN_MCR_SLF_WAK. */
#define BF_CAN_MCR_SLF_WAK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SLF_WAK) & BM_CAN_MCR_SLF_WAK)

/*! @brief Set the SLF_WAK field to a new value. */
#define BW_CAN_MCR_SLF_WAK(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SLF_WAK) | BF_CAN_MCR_SLF_WAK(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field SUPV[23] (RW)
 *
 * This bit configures some of the FLEXCAN registers to be either in Supervisor
 * or User Mode. Reset value of this bit is '1', so the affected registers start
 * with Supervisor access allowance only. This bit can only be written in Freeze
 * mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FlexCAN is in Supervisor Mode. Affected registers allow only Supervisor
 *     access. Unrestricted access behaves as though the access was done to an
 *     unimplemented register location
 * - 0 - FlexCAN is in User Mode. Affected registers allow both Supervisor and
 *     Unrestricted accesses
 */
/*@{*/
#define BP_CAN_MCR_SUPV      (23U)         /*!< Bit position for CAN_MCR_SUPV. */
#define BM_CAN_MCR_SUPV      (0x00800000U) /*!< Bit mask for CAN_MCR_SUPV. */
#define BS_CAN_MCR_SUPV      (1U)          /*!< Bit field size in bits for CAN_MCR_SUPV. */

/*! @brief Read current value of the CAN_MCR_SUPV field. */
#define BR_CAN_MCR_SUPV(x)   (HW_CAN_MCR(x).B.SUPV)

/*! @brief Format value for bitfield CAN_MCR_SUPV. */
#define BF_CAN_MCR_SUPV(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SUPV) & BM_CAN_MCR_SUPV)

/*! @brief Set the SUPV field to a new value. */
#define BW_CAN_MCR_SUPV(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SUPV) | BF_CAN_MCR_SUPV(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ_ACK[24] (RO)
 *
 * This read-only bit indicates that FLEXCAN is in Freeze Mode and its prescaler
 * is stopped. The Freeze Mode request cannot be granted until current
 * transmission or reception processes have finished. Therefore the software can poll the
 * FRZ_ACK bit to know when FLEXCAN has actually entered Freeze Mode. If Freeze
 * Mode request is negated, then this bit is negated once the FLEXCAN prescaler is
 * running again. If Freeze Mode is requested while FLEXCAN is in any of the low
 * power modes, then the FRZ_ACK bit will only be set when the low power mode is
 * exited. See Freeze ModeThis mode is requested by ARM through the assertion of
 * the HALT bit in the MCR Register or when the MCU is put into Debug Mode . In
 * both cases it is also necessary that the FRZ bit is asserted in the MCR
 * Register and the module is not in any of the low power modes (Disable, Stop). The
 * acknowledgement is obtained through the assertion by the FlexCAN of FRZ_ACK bit
 * in the same register. The ARM must only consider the FlexCAN in Freeze Mode
 * when both request and acknowledgement conditions are satisfied. for more
 * information
 *
 * Values:
 * - 1 - FLEXCAN in Freeze Mode, prescaler stopped
 * - 0 - FLEXCAN not in Freeze Mode, prescaler running
 */
/*@{*/
#define BP_CAN_MCR_FRZ_ACK   (24U)         /*!< Bit position for CAN_MCR_FRZ_ACK. */
#define BM_CAN_MCR_FRZ_ACK   (0x01000000U) /*!< Bit mask for CAN_MCR_FRZ_ACK. */
#define BS_CAN_MCR_FRZ_ACK   (1U)          /*!< Bit field size in bits for CAN_MCR_FRZ_ACK. */

/*! @brief Read current value of the CAN_MCR_FRZ_ACK field. */
#define BR_CAN_MCR_FRZ_ACK(x) (HW_CAN_MCR(x).B.FRZ_ACK)
/*@}*/

/*!
 * @name Register CAN_MCR, field SOFT_RST[25] (RW)
 *
 * When this bit is asserted, FlexCAN resets its internal state machines and
 * some of the memory mapped registers. The following registers are reset: MCR
 * (except the MDIS bit), TIMER, ECR, ESR1, ESR2, IMASK1, IMASK2, IFLAG1, IFLAG2 and
 * CRCR. Configuration registers that control the interface to the CAN bus are not
 * affected by soft reset. The following registers are unaffected: CTRL1, CTRL2,
 * RXIMR0_RXIMR63, RXGMASK, RX14MASK, RX15MASK, RXFGMASK, RXFIR and all Message
 * Buffers The SOFT_RST bit can be asserted directly by the ARM when it writes to
 * the MCR Register. It may take some time to fully propagate its effect. The
 * SOFT_RST bit remains asserted while reset is pending, and is automatically
 * negated when reset completes. Therefore, software can poll this bit to know when
 * the soft reset has completed. Soft reset cannot be applied while clocks are shut
 * down in any of the low power modes. The module should be first removed from
 * low power mode, and then soft reset can be applied.
 *
 * Values:
 * - 1 - Reset the registers
 * - 0 - No reset request
 */
/*@{*/
#define BP_CAN_MCR_SOFT_RST  (25U)         /*!< Bit position for CAN_MCR_SOFT_RST. */
#define BM_CAN_MCR_SOFT_RST  (0x02000000U) /*!< Bit mask for CAN_MCR_SOFT_RST. */
#define BS_CAN_MCR_SOFT_RST  (1U)          /*!< Bit field size in bits for CAN_MCR_SOFT_RST. */

/*! @brief Read current value of the CAN_MCR_SOFT_RST field. */
#define BR_CAN_MCR_SOFT_RST(x) (HW_CAN_MCR(x).B.SOFT_RST)

/*! @brief Format value for bitfield CAN_MCR_SOFT_RST. */
#define BF_CAN_MCR_SOFT_RST(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_SOFT_RST) & BM_CAN_MCR_SOFT_RST)

/*! @brief Set the SOFT_RST field to a new value. */
#define BW_CAN_MCR_SOFT_RST(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_SOFT_RST) | BF_CAN_MCR_SOFT_RST(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAK_MSK[26] (RW)
 *
 * This bit enables the Wake Up Interrupt generation.
 *
 * Values:
 * - 1 - Wake Up Interrupt is enabled
 * - 0 - Wake Up Interrupt is disabled
 */
/*@{*/
#define BP_CAN_MCR_WAK_MSK   (26U)         /*!< Bit position for CAN_MCR_WAK_MSK. */
#define BM_CAN_MCR_WAK_MSK   (0x04000000U) /*!< Bit mask for CAN_MCR_WAK_MSK. */
#define BS_CAN_MCR_WAK_MSK   (1U)          /*!< Bit field size in bits for CAN_MCR_WAK_MSK. */

/*! @brief Read current value of the CAN_MCR_WAK_MSK field. */
#define BR_CAN_MCR_WAK_MSK(x) (HW_CAN_MCR(x).B.WAK_MSK)

/*! @brief Format value for bitfield CAN_MCR_WAK_MSK. */
#define BF_CAN_MCR_WAK_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_WAK_MSK) & BM_CAN_MCR_WAK_MSK)

/*! @brief Set the WAK_MSK field to a new value. */
#define BW_CAN_MCR_WAK_MSK(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_WAK_MSK) | BF_CAN_MCR_WAK_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field NOT_RDY[27] (RO)
 *
 * This read-only bit indicates that FLEXCAN is either in Disable Mode, Stop
 * Mode or Freeze Mode. It is negated once FLEXCAN has exited these modes.
 *
 * Values:
 * - 1 - FLEXCAN module is either in Disable Mode, Stop Mode or Freeze Mode
 * - 0 - FLEXCAN module is either in Normal Mode, Listen-Only Mode or Loop-Back
 *     Mode
 */
/*@{*/
#define BP_CAN_MCR_NOT_RDY   (27U)         /*!< Bit position for CAN_MCR_NOT_RDY. */
#define BM_CAN_MCR_NOT_RDY   (0x08000000U) /*!< Bit mask for CAN_MCR_NOT_RDY. */
#define BS_CAN_MCR_NOT_RDY   (1U)          /*!< Bit field size in bits for CAN_MCR_NOT_RDY. */

/*! @brief Read current value of the CAN_MCR_NOT_RDY field. */
#define BR_CAN_MCR_NOT_RDY(x) (HW_CAN_MCR(x).B.NOT_RDY)
/*@}*/

/*!
 * @name Register CAN_MCR, field HALT[28] (RW)
 *
 * Assertion of this bit puts the FLEXCAN module into Freeze Mode. The ARM
 * should clear it after initializing the Message Buffers and Control Register. No
 * reception or transmission is performed by FLEXCAN before this bit is cleared.
 * Freeze Mode can not be entered while FLEXCAN is in any of the low power modes.See
 * Freeze ModeThis mode is requested by ARM through the assertion of the HALT
 * bit in the MCR Register or when the MCU is put into Debug Mode . In both cases
 * it is also necessary that the FRZ bit is asserted in the MCR Register and the
 * module is not in any of the low power modes (Disable, Stop). The
 * acknowledgement is obtained through the assertion by the FlexCAN of FRZ_ACK bit in the same
 * register. The ARM must only consider the FlexCAN in Freeze Mode when both
 * request and acknowledgement conditions are satisfied. for more information
 *
 * Values:
 * - 1 - Enters Freeze Mode if the FRZ bit is asserted.
 * - 0 - No Freeze Mode request.
 */
/*@{*/
#define BP_CAN_MCR_HALT      (28U)         /*!< Bit position for CAN_MCR_HALT. */
#define BM_CAN_MCR_HALT      (0x10000000U) /*!< Bit mask for CAN_MCR_HALT. */
#define BS_CAN_MCR_HALT      (1U)          /*!< Bit field size in bits for CAN_MCR_HALT. */

/*! @brief Read current value of the CAN_MCR_HALT field. */
#define BR_CAN_MCR_HALT(x)   (HW_CAN_MCR(x).B.HALT)

/*! @brief Format value for bitfield CAN_MCR_HALT. */
#define BF_CAN_MCR_HALT(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_HALT) & BM_CAN_MCR_HALT)

/*! @brief Set the HALT field to a new value. */
#define BW_CAN_MCR_HALT(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_HALT) | BF_CAN_MCR_HALT(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field RFEN[29] (RW)
 *
 * This bit controls whether the Rx FIFO feature is enabled or not. When RFEN is
 * set, MBs 0 to 5 cannot be used for normal reception and transmission because
 * the corresponding memory region (0x80-0xDC) is used by the FIFO engine as well
 * as additional MBs (up to 32, depending on CTRL2[RFFN] setting) which are used
 * as Rx FIFO ID Filter Table elements.RFEN also impacts the definition of the
 * minimum number of peripheral clocks per CAN bit as described in (see
 * Arbitration and Matching Timing).This bit can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 1 - FIFO enabled
 * - 0 - FIFO not enabled
 */
/*@{*/
#define BP_CAN_MCR_RFEN      (29U)         /*!< Bit position for CAN_MCR_RFEN. */
#define BM_CAN_MCR_RFEN      (0x20000000U) /*!< Bit mask for CAN_MCR_RFEN. */
#define BS_CAN_MCR_RFEN      (1U)          /*!< Bit field size in bits for CAN_MCR_RFEN. */

/*! @brief Read current value of the CAN_MCR_RFEN field. */
#define BR_CAN_MCR_RFEN(x)   (HW_CAN_MCR(x).B.RFEN)

/*! @brief Format value for bitfield CAN_MCR_RFEN. */
#define BF_CAN_MCR_RFEN(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_RFEN) & BM_CAN_MCR_RFEN)

/*! @brief Set the RFEN field to a new value. */
#define BW_CAN_MCR_RFEN(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_RFEN) | BF_CAN_MCR_RFEN(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ[30] (RW)
 *
 * The FRZ bit specifies the FLEXCAN behavior when the HALT bit in the MCR
 * Register is set or when Debug Mode is requested at ARM level. When FRZ is asserted,
 * FLEXCAN is enabled to enter Freeze Mode. Negation of this bit field causes
 * FLEXCAN to exit from Freeze Mode.
 *
 * Values:
 * - 1 - Enabled to enter Freeze Mode
 * - 0 - Not enabled to enter Freeze Mode
 */
/*@{*/
#define BP_CAN_MCR_FRZ       (30U)         /*!< Bit position for CAN_MCR_FRZ. */
#define BM_CAN_MCR_FRZ       (0x40000000U) /*!< Bit mask for CAN_MCR_FRZ. */
#define BS_CAN_MCR_FRZ       (1U)          /*!< Bit field size in bits for CAN_MCR_FRZ. */

/*! @brief Read current value of the CAN_MCR_FRZ field. */
#define BR_CAN_MCR_FRZ(x)    (HW_CAN_MCR(x).B.FRZ)

/*! @brief Format value for bitfield CAN_MCR_FRZ. */
#define BF_CAN_MCR_FRZ(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_FRZ) & BM_CAN_MCR_FRZ)

/*! @brief Set the FRZ field to a new value. */
#define BW_CAN_MCR_FRZ(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_FRZ) | BF_CAN_MCR_FRZ(v)))
/*@}*/

/*!
 * @name Register CAN_MCR, field MDIS[31] (RW)
 *
 * This bit controls whether FLEXCAN is enabled or not. When disabled, FLEXCAN
 * shuts down the clocks to the CAN Protocol Interface and Message Buffer
 * Management sub-modules. This is the only bit in MCR not affected by soft reset. See
 * Module Disable ModeThis low power mode is normally used to temporarily disable a
 * complete FlexCAN block, with no power consumption. It is requested by the ARM
 * through the assertion of the MDIS bit in the MCR Register and the
 * acknowledgement is obtained through the assertion by the FlexCAN of the LPM_ACK bit in
 * the same register. The ARM must only consider the FlexCAN in Disable Mode when
 * both request and acknowledgement conditions are satisfied. for more information.
 *
 * Values:
 * - 1 - Disable the FLEXCAN module
 * - 0 - Enable the FLEXCAN module
 */
/*@{*/
#define BP_CAN_MCR_MDIS      (31U)         /*!< Bit position for CAN_MCR_MDIS. */
#define BM_CAN_MCR_MDIS      (0x80000000U) /*!< Bit mask for CAN_MCR_MDIS. */
#define BS_CAN_MCR_MDIS      (1U)          /*!< Bit field size in bits for CAN_MCR_MDIS. */

/*! @brief Read current value of the CAN_MCR_MDIS field. */
#define BR_CAN_MCR_MDIS(x)   (HW_CAN_MCR(x).B.MDIS)

/*! @brief Format value for bitfield CAN_MCR_MDIS. */
#define BF_CAN_MCR_MDIS(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_MCR_MDIS) & BM_CAN_MCR_MDIS)

/*! @brief Set the MDIS field to a new value. */
#define BW_CAN_MCR_MDIS(x, v) (HW_CAN_MCR_WR(x, (HW_CAN_MCR_RD(x) & ~BM_CAN_MCR_MDIS) | BF_CAN_MCR_MDIS(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL1 - Control 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL1 - Control 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is defined for specific FLEXCAN control features related to the
 * CAN bus, such as bit-rate, programmable sampling point within an Rx bit, Loop
 * Back Mode, Listen Only Mode, Bus Off recovery behavior and interrupt enabling
 * (Bus-Off, Error, Warning). It also determines the Division Factor for the
 * clock prescaler.
 */
typedef union _hw_can_ctrl1
{
    uint32_t U;
    struct _hw_can_ctrl1_bitfields
    {
        uint32_t PROP_SEG : 3;         /*!< [2:0]  */
        uint32_t LOM : 1;              /*!< [3]  */
        uint32_t LBUF : 1;             /*!< [4]  */
        uint32_t TSYN : 1;             /*!< [5]  */
        uint32_t BOFF_REC : 1;         /*!< [6]  */
        uint32_t SMP : 1;              /*!< [7]  */
        uint32_t RESERVED0 : 2;        /*!< [9:8]  */
        uint32_t RWRN_MSK : 1;         /*!< [10]  */
        uint32_t TWRN_MSK : 1;         /*!< [11]  */
        uint32_t LPB : 1;              /*!< [12]  */
        uint32_t RESERVED1 : 1;        /*!< [13]  */
        uint32_t ERR_MSK : 1;          /*!< [14]  */
        uint32_t BOFF_MSK : 1;         /*!< [15]  */
        uint32_t PSEG2 : 3;            /*!< [18:16]  */
        uint32_t PSEG1 : 3;            /*!< [21:19]  */
        uint32_t RJW : 2;              /*!< [23:22]  */
        uint32_t PRESDIV : 8;          /*!< [31:24]  */
    } B;
} hw_can_ctrl1_t;

/*!
 * @name Constants and macros for entire CAN_CTRL1 register
 */
/*@{*/
#define HW_CAN_CTRL1_ADDR(x)     ((uintptr_t)(x) + 0x4U)

#define HW_CAN_CTRL1(x)          (*(__IO hw_can_ctrl1_t *) HW_CAN_CTRL1_ADDR(x))
#define HW_CAN_CTRL1_RD(x)       (HW_CAN_CTRL1(x).U)
#define HW_CAN_CTRL1_WR(x, v)    (HW_CAN_CTRL1(x).U = (v))
#define HW_CAN_CTRL1_SET(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) |  (v)))
#define HW_CAN_CTRL1_CLR(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) & ~(v)))
#define HW_CAN_CTRL1_TOG(x, v)   (HW_CAN_CTRL1_WR(x, HW_CAN_CTRL1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL1 bitfields
 */

/*!
 * @name Register CAN_CTRL1, field PROP_SEG[2:0] (RW)
 *
 * This 3-bit field defines the length of the Propagation Segment in the bit
 * time. The valid programmable values are 0-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Propagation Segment Time
 * = (PROPSEG + 1) * Time-Quanta. Time-Quantum = one Sclock period.
 */
/*@{*/
#define BP_CAN_CTRL1_PROP_SEG (0U)         /*!< Bit position for CAN_CTRL1_PROP_SEG. */
#define BM_CAN_CTRL1_PROP_SEG (0x00000007U) /*!< Bit mask for CAN_CTRL1_PROP_SEG. */
#define BS_CAN_CTRL1_PROP_SEG (3U)         /*!< Bit field size in bits for CAN_CTRL1_PROP_SEG. */

/*! @brief Read current value of the CAN_CTRL1_PROP_SEG field. */
#define BR_CAN_CTRL1_PROP_SEG(x) (HW_CAN_CTRL1(x).B.PROP_SEG)

/*! @brief Format value for bitfield CAN_CTRL1_PROP_SEG. */
#define BF_CAN_CTRL1_PROP_SEG(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PROP_SEG) & BM_CAN_CTRL1_PROP_SEG)

/*! @brief Set the PROP_SEG field to a new value. */
#define BW_CAN_CTRL1_PROP_SEG(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PROP_SEG) | BF_CAN_CTRL1_PROP_SEG(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LOM[3] (RW)
 *
 * This bit configures FLEXCAN to operate in Listen Only Mode. In this mode,
 * transmission is disabled, all error counters are frozen and the module operates
 * in a CAN Error Passive mode. Only messages acknowledged by another CAN station
 * will be received. If FLEXCAN detects a message that has not been acknowledged,
 * it will flag a BIT0 error (without changing the REC), as if it was trying to
 * acknowledge the message. Listen-Only Mode acknowledgement can be obtained by
 * the state of ESR1[FLT_CONF] field which is Passive Error when Listen-Only Mode
 * is entered. There can be some delay between the Listen-Only Mode request and
 * acknowledge. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - FLEXCAN module operates in Listen Only Mode
 * - 0 - Listen Only Mode is deactivated
 */
/*@{*/
#define BP_CAN_CTRL1_LOM     (3U)          /*!< Bit position for CAN_CTRL1_LOM. */
#define BM_CAN_CTRL1_LOM     (0x00000008U) /*!< Bit mask for CAN_CTRL1_LOM. */
#define BS_CAN_CTRL1_LOM     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LOM. */

/*! @brief Read current value of the CAN_CTRL1_LOM field. */
#define BR_CAN_CTRL1_LOM(x)  (HW_CAN_CTRL1(x).B.LOM)

/*! @brief Format value for bitfield CAN_CTRL1_LOM. */
#define BF_CAN_CTRL1_LOM(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LOM) & BM_CAN_CTRL1_LOM)

/*! @brief Set the LOM field to a new value. */
#define BW_CAN_CTRL1_LOM(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LOM) | BF_CAN_CTRL1_LOM(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LBUF[4] (RW)
 *
 * This bit defines the ordering mechanism for Message Buffer transmission. When
 * asserted, the LPRIO_EN bit does not affect the priority arbitration.This bit
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Lowest number buffer is transmitted first
 * - 0 - Buffer with highest priority is transmitted first
 */
/*@{*/
#define BP_CAN_CTRL1_LBUF    (4U)          /*!< Bit position for CAN_CTRL1_LBUF. */
#define BM_CAN_CTRL1_LBUF    (0x00000010U) /*!< Bit mask for CAN_CTRL1_LBUF. */
#define BS_CAN_CTRL1_LBUF    (1U)          /*!< Bit field size in bits for CAN_CTRL1_LBUF. */

/*! @brief Read current value of the CAN_CTRL1_LBUF field. */
#define BR_CAN_CTRL1_LBUF(x) (HW_CAN_CTRL1(x).B.LBUF)

/*! @brief Format value for bitfield CAN_CTRL1_LBUF. */
#define BF_CAN_CTRL1_LBUF(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LBUF) & BM_CAN_CTRL1_LBUF)

/*! @brief Set the LBUF field to a new value. */
#define BW_CAN_CTRL1_LBUF(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LBUF) | BF_CAN_CTRL1_LBUF(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TSYN[5] (RW)
 *
 * This bit enables a mechanism that resets the free-running timer each time a
 * message is received in Message Buffer 0. This feature provides means to
 * synchronize multiple FLEXCAN stations with a special "SYNC" message (i.e., global
 * network time). If the RFEN bit in MCR is set (FIFO enabled), the first available
 * Mailbox, according to CTRL2[RFFN] setting, is used for timer synchronization
 * instead of MB0.This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Timer Sync feature enabled
 * - 0 - Timer Sync feature disabled
 */
/*@{*/
#define BP_CAN_CTRL1_TSYN    (5U)          /*!< Bit position for CAN_CTRL1_TSYN. */
#define BM_CAN_CTRL1_TSYN    (0x00000020U) /*!< Bit mask for CAN_CTRL1_TSYN. */
#define BS_CAN_CTRL1_TSYN    (1U)          /*!< Bit field size in bits for CAN_CTRL1_TSYN. */

/*! @brief Read current value of the CAN_CTRL1_TSYN field. */
#define BR_CAN_CTRL1_TSYN(x) (HW_CAN_CTRL1(x).B.TSYN)

/*! @brief Format value for bitfield CAN_CTRL1_TSYN. */
#define BF_CAN_CTRL1_TSYN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TSYN) & BM_CAN_CTRL1_TSYN)

/*! @brief Set the TSYN field to a new value. */
#define BW_CAN_CTRL1_TSYN(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_TSYN) | BF_CAN_CTRL1_TSYN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFF_REC[6] (RW)
 *
 * This bit defines how FLEXCAN recovers from Bus Off state. If this bit is
 * negated, automatic recovering from Bus Off state occurs according to the CAN
 * Specification 2.0B. If the bit is asserted, automatic recovering from Bus Off is
 * disabled and the module remains in Bus Off state until the bit is negated by the
 * user. If the negation occurs before 128 sequences of 11 recessive bits are
 * detected on the CAN bus, then Bus Off recovery happens as if the BOFF_REC bit
 * had never been asserted. If the negation occurs after 128 sequences of 11
 * recessive bits occurred, then FLEXCAN will re-synchronize to the bus by waiting for
 * 11 recessive bits before joining the bus. After negation, the BOFF_REC bit can
 * be re-asserted again during Bus Off, but it will only be effective the next
 * time the module enters Bus Off. If BOFF_REC was negated when the module entered
 * Bus Off, asserting it during Bus Off will not be effective for the current
 * Bus Off recovery.
 *
 * Values:
 * - 1 - Automatic recovering from Bus Off state disabled
 * - 0 - Automatic recovering from Bus Off state enabled, according to CAN Spec
 *     2.0 part B
 */
/*@{*/
#define BP_CAN_CTRL1_BOFF_REC (6U)         /*!< Bit position for CAN_CTRL1_BOFF_REC. */
#define BM_CAN_CTRL1_BOFF_REC (0x00000040U) /*!< Bit mask for CAN_CTRL1_BOFF_REC. */
#define BS_CAN_CTRL1_BOFF_REC (1U)         /*!< Bit field size in bits for CAN_CTRL1_BOFF_REC. */

/*! @brief Read current value of the CAN_CTRL1_BOFF_REC field. */
#define BR_CAN_CTRL1_BOFF_REC(x) (HW_CAN_CTRL1(x).B.BOFF_REC)

/*! @brief Format value for bitfield CAN_CTRL1_BOFF_REC. */
#define BF_CAN_CTRL1_BOFF_REC(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFF_REC) & BM_CAN_CTRL1_BOFF_REC)

/*! @brief Set the BOFF_REC field to a new value. */
#define BW_CAN_CTRL1_BOFF_REC(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_BOFF_REC) | BF_CAN_CTRL1_BOFF_REC(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field SMP[7] (RW)
 *
 * This bit defines the sampling mode of CAN bits at the FLEXCAN_RX. This bit
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Three samples are used to determine the value of the received bit: the
 *     regular one (sample point) and 2 preceding samples, a majority rule is used
 * - 0 - Just one sample is used to determine the bit value
 */
/*@{*/
#define BP_CAN_CTRL1_SMP     (7U)          /*!< Bit position for CAN_CTRL1_SMP. */
#define BM_CAN_CTRL1_SMP     (0x00000080U) /*!< Bit mask for CAN_CTRL1_SMP. */
#define BS_CAN_CTRL1_SMP     (1U)          /*!< Bit field size in bits for CAN_CTRL1_SMP. */

/*! @brief Read current value of the CAN_CTRL1_SMP field. */
#define BR_CAN_CTRL1_SMP(x)  (HW_CAN_CTRL1(x).B.SMP)

/*! @brief Format value for bitfield CAN_CTRL1_SMP. */
#define BF_CAN_CTRL1_SMP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_SMP) & BM_CAN_CTRL1_SMP)

/*! @brief Set the SMP field to a new value. */
#define BW_CAN_CTRL1_SMP(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_SMP) | BF_CAN_CTRL1_SMP(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RWRN_MSK[10] (RW)
 *
 * This bit provides a mask for the Rx Warning Interrupt associated with the
 * RWRN_INT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRN_EN] bit is negated. This bit can only be written if MCR[WRN_EN] bit is
 * asserted.
 *
 * Values:
 * - 1 - Rx Warning Interrupt enabled
 * - 0 - Rx Warning Interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_RWRN_MSK (10U)        /*!< Bit position for CAN_CTRL1_RWRN_MSK. */
#define BM_CAN_CTRL1_RWRN_MSK (0x00000400U) /*!< Bit mask for CAN_CTRL1_RWRN_MSK. */
#define BS_CAN_CTRL1_RWRN_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_RWRN_MSK. */

/*! @brief Read current value of the CAN_CTRL1_RWRN_MSK field. */
#define BR_CAN_CTRL1_RWRN_MSK(x) (HW_CAN_CTRL1(x).B.RWRN_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_RWRN_MSK. */
#define BF_CAN_CTRL1_RWRN_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RWRN_MSK) & BM_CAN_CTRL1_RWRN_MSK)

/*! @brief Set the RWRN_MSK field to a new value. */
#define BW_CAN_CTRL1_RWRN_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_RWRN_MSK) | BF_CAN_CTRL1_RWRN_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TWRN_MSK[11] (RW)
 *
 * This bit provides a mask for the Tx Warning Interrupt associated with the
 * TWRN_INT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRN_EN] bit is negated. This bit can only be written if MCR[WRN_EN] bit is
 * asserted.
 *
 * Values:
 * - 1 - Tx Warning Interrupt enabled
 * - 0 - Tx Warning Interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_TWRN_MSK (11U)        /*!< Bit position for CAN_CTRL1_TWRN_MSK. */
#define BM_CAN_CTRL1_TWRN_MSK (0x00000800U) /*!< Bit mask for CAN_CTRL1_TWRN_MSK. */
#define BS_CAN_CTRL1_TWRN_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_TWRN_MSK. */

/*! @brief Read current value of the CAN_CTRL1_TWRN_MSK field. */
#define BR_CAN_CTRL1_TWRN_MSK(x) (HW_CAN_CTRL1(x).B.TWRN_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_TWRN_MSK. */
#define BF_CAN_CTRL1_TWRN_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_TWRN_MSK) & BM_CAN_CTRL1_TWRN_MSK)

/*! @brief Set the TWRN_MSK field to a new value. */
#define BW_CAN_CTRL1_TWRN_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_TWRN_MSK) | BF_CAN_CTRL1_TWRN_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LPB[12] (RW)
 *
 * This bit configures FlexCAN to operate in Loop-Back Mode. In this mode,
 * FlexCAN performs an internal loop back that can be used for self test operation.
 * The bit stream output of the transmitter is fed back internally to the receiver
 * input. The FLEXCAN_RX input pin is ignored and the FLEXCAN_TX output goes to
 * the recessive state (logic '1'). FlexCAN behaves as it normally does when
 * transmitting, and treats its own transmitted message as a message received from a
 * remote node. In this mode, FlexCAN ignores the bit sent during the ACK slot in
 * the CAN frame acknowledge field, generating an internal acknowledge bit to
 * ensure proper reception of its own message. Both transmit and receive interrupts
 * are generated. This bit can only be written in Freeze mode as it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 1 - Loop Back enabled
 * - 0 - Loop Back disabled
 */
/*@{*/
#define BP_CAN_CTRL1_LPB     (12U)         /*!< Bit position for CAN_CTRL1_LPB. */
#define BM_CAN_CTRL1_LPB     (0x00001000U) /*!< Bit mask for CAN_CTRL1_LPB. */
#define BS_CAN_CTRL1_LPB     (1U)          /*!< Bit field size in bits for CAN_CTRL1_LPB. */

/*! @brief Read current value of the CAN_CTRL1_LPB field. */
#define BR_CAN_CTRL1_LPB(x)  (HW_CAN_CTRL1(x).B.LPB)

/*! @brief Format value for bitfield CAN_CTRL1_LPB. */
#define BF_CAN_CTRL1_LPB(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_LPB) & BM_CAN_CTRL1_LPB)

/*! @brief Set the LPB field to a new value. */
#define BW_CAN_CTRL1_LPB(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_LPB) | BF_CAN_CTRL1_LPB(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field ERR_MSK[14] (RW)
 *
 * This bit provides a mask for the Error Interrupt.
 *
 * Values:
 * - 1 - Error interrupt enabled
 * - 0 - Error interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_ERR_MSK (14U)         /*!< Bit position for CAN_CTRL1_ERR_MSK. */
#define BM_CAN_CTRL1_ERR_MSK (0x00004000U) /*!< Bit mask for CAN_CTRL1_ERR_MSK. */
#define BS_CAN_CTRL1_ERR_MSK (1U)          /*!< Bit field size in bits for CAN_CTRL1_ERR_MSK. */

/*! @brief Read current value of the CAN_CTRL1_ERR_MSK field. */
#define BR_CAN_CTRL1_ERR_MSK(x) (HW_CAN_CTRL1(x).B.ERR_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_ERR_MSK. */
#define BF_CAN_CTRL1_ERR_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_ERR_MSK) & BM_CAN_CTRL1_ERR_MSK)

/*! @brief Set the ERR_MSK field to a new value. */
#define BW_CAN_CTRL1_ERR_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_ERR_MSK) | BF_CAN_CTRL1_ERR_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFF_MSK[15] (RW)
 *
 * This bit provides a mask for the Bus Off Interrupt.
 *
 * Values:
 * - 1 - Bus Off interrupt enabled
 * - 0 - Bus Off interrupt disabled
 */
/*@{*/
#define BP_CAN_CTRL1_BOFF_MSK (15U)        /*!< Bit position for CAN_CTRL1_BOFF_MSK. */
#define BM_CAN_CTRL1_BOFF_MSK (0x00008000U) /*!< Bit mask for CAN_CTRL1_BOFF_MSK. */
#define BS_CAN_CTRL1_BOFF_MSK (1U)         /*!< Bit field size in bits for CAN_CTRL1_BOFF_MSK. */

/*! @brief Read current value of the CAN_CTRL1_BOFF_MSK field. */
#define BR_CAN_CTRL1_BOFF_MSK(x) (HW_CAN_CTRL1(x).B.BOFF_MSK)

/*! @brief Format value for bitfield CAN_CTRL1_BOFF_MSK. */
#define BF_CAN_CTRL1_BOFF_MSK(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_BOFF_MSK) & BM_CAN_CTRL1_BOFF_MSK)

/*! @brief Set the BOFF_MSK field to a new value. */
#define BW_CAN_CTRL1_BOFF_MSK(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_BOFF_MSK) | BF_CAN_CTRL1_BOFF_MSK(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG2[18:16] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 2 in the bit
 * time. The valid programmable values are 1-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Phase Buffer Segment 2 =
 * (PSEG2 + 1) x Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG2   (16U)         /*!< Bit position for CAN_CTRL1_PSEG2. */
#define BM_CAN_CTRL1_PSEG2   (0x00070000U) /*!< Bit mask for CAN_CTRL1_PSEG2. */
#define BS_CAN_CTRL1_PSEG2   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG2. */

/*! @brief Read current value of the CAN_CTRL1_PSEG2 field. */
#define BR_CAN_CTRL1_PSEG2(x) (HW_CAN_CTRL1(x).B.PSEG2)

/*! @brief Format value for bitfield CAN_CTRL1_PSEG2. */
#define BF_CAN_CTRL1_PSEG2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG2) & BM_CAN_CTRL1_PSEG2)

/*! @brief Set the PSEG2 field to a new value. */
#define BW_CAN_CTRL1_PSEG2(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG2) | BF_CAN_CTRL1_PSEG2(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG1[21:19] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 1 in the bit
 * time. The valid programmable values are 0-7. This field can only be written in
 * Freeze mode as it is blocked by hardware in other modes Phase Buffer Segment 1 =
 * (PSEG1 + 1) x Time-Quanta.
 */
/*@{*/
#define BP_CAN_CTRL1_PSEG1   (19U)         /*!< Bit position for CAN_CTRL1_PSEG1. */
#define BM_CAN_CTRL1_PSEG1   (0x00380000U) /*!< Bit mask for CAN_CTRL1_PSEG1. */
#define BS_CAN_CTRL1_PSEG1   (3U)          /*!< Bit field size in bits for CAN_CTRL1_PSEG1. */

/*! @brief Read current value of the CAN_CTRL1_PSEG1 field. */
#define BR_CAN_CTRL1_PSEG1(x) (HW_CAN_CTRL1(x).B.PSEG1)

/*! @brief Format value for bitfield CAN_CTRL1_PSEG1. */
#define BF_CAN_CTRL1_PSEG1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PSEG1) & BM_CAN_CTRL1_PSEG1)

/*! @brief Set the PSEG1 field to a new value. */
#define BW_CAN_CTRL1_PSEG1(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PSEG1) | BF_CAN_CTRL1_PSEG1(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RJW[23:22] (RW)
 *
 * This 2-bit field defines the maximum number of time quanta One time quantum
 * is equal to the Sclock period. that a bit time can be changed by one
 * re-synchronization. The valid programmable values are 0-3. This field can only be
 * written in Freeze mode as it is blocked by hardware in other modes Resync Jump Width
 * = RJW + 1.
 */
/*@{*/
#define BP_CAN_CTRL1_RJW     (22U)         /*!< Bit position for CAN_CTRL1_RJW. */
#define BM_CAN_CTRL1_RJW     (0x00C00000U) /*!< Bit mask for CAN_CTRL1_RJW. */
#define BS_CAN_CTRL1_RJW     (2U)          /*!< Bit field size in bits for CAN_CTRL1_RJW. */

/*! @brief Read current value of the CAN_CTRL1_RJW field. */
#define BR_CAN_CTRL1_RJW(x)  (HW_CAN_CTRL1(x).B.RJW)

/*! @brief Format value for bitfield CAN_CTRL1_RJW. */
#define BF_CAN_CTRL1_RJW(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_RJW) & BM_CAN_CTRL1_RJW)

/*! @brief Set the RJW field to a new value. */
#define BW_CAN_CTRL1_RJW(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_RJW) | BF_CAN_CTRL1_RJW(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PRESDIV[31:24] (RW)
 *
 * This 8-bit field defines the ratio between the PE clock frequency and the
 * Serial Clock (Sclock) frequency. The Sclock period defines the time quantum of
 * the CAN protocol. For the reset value, the Sclock frequency is equal to the PE
 * clock frequency. The Maximum value of this register is 0xFF, that gives a
 * minimum Sclock frequency equal to the PE clock frequency divided by 256.For more
 * information refer to Protocol Timing. This field can only be written in Freeze
 * mode as it is blocked by hardware in other modes. Sclock frequency = CPI clock
 * frequency / (PRESDIV+1)
 */
/*@{*/
#define BP_CAN_CTRL1_PRESDIV (24U)         /*!< Bit position for CAN_CTRL1_PRESDIV. */
#define BM_CAN_CTRL1_PRESDIV (0xFF000000U) /*!< Bit mask for CAN_CTRL1_PRESDIV. */
#define BS_CAN_CTRL1_PRESDIV (8U)          /*!< Bit field size in bits for CAN_CTRL1_PRESDIV. */

/*! @brief Read current value of the CAN_CTRL1_PRESDIV field. */
#define BR_CAN_CTRL1_PRESDIV(x) (HW_CAN_CTRL1(x).B.PRESDIV)

/*! @brief Format value for bitfield CAN_CTRL1_PRESDIV. */
#define BF_CAN_CTRL1_PRESDIV(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL1_PRESDIV) & BM_CAN_CTRL1_PRESDIV)

/*! @brief Set the PRESDIV field to a new value. */
#define BW_CAN_CTRL1_PRESDIV(x, v) (HW_CAN_CTRL1_WR(x, (HW_CAN_CTRL1_RD(x) & ~BM_CAN_CTRL1_PRESDIV) | BF_CAN_CTRL1_PRESDIV(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_TIMER - Free Running Timer Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_TIMER - Free Running Timer Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register represents a 16-bit free running counter that can be read and
 * written by the ARM. The timer starts from $0000 after Reset, counts linearly to
 * $FFFF, and wraps around. The timer is clocked by the FLEXCAN bit-clock (which
 * defines the baud rate on the CAN bus). During a message
 * transmission/reception, it increments by one for each bit that is received or transmitted. When
 * there is no message on the bus, it counts using the previously programmed baud
 * rate. During Freeze Mode, disable, and stop mode, the timer is not incremented.
 * The timer value is captured at the beginning of the identifier field of any
 * frame on the CAN bus. This captured value is written into the Time Stamp entry
 * in a message buffer after a successful reception or transmission of a message.
 * If bit CTRL1[TSYN] is asserted the Timer is reset whenever a message is
 * received in the first available Mailbox, according to CTRL2[RFFN] setting. ARM can
 * write to this register anytime. However, if the write occurs at the same time
 * that the Timer is being reset by a reception in the first Mailbox, then the
 * write value is discarded. Reading this register affects the Mailbox Unlocking
 * procedure. For additional details, refer to Message Buffer Lock MechanismBesides
 * MB inactivation, FlexCAN has another data coherence mechanism for the receive
 * process. When ARM reads the Control and Status word of an Rx MB with codes
 * FULL or OVERRUN, FlexCAN assumes that ARM wants to read the whole MB in an atomic
 * operation, and thus it sets an internal lock flag for that MB. The lock is
 * released when ARM reads the Free Running Timer (global unlock operation), or
 * when it reads the Control and Status word of another MB regardless of its code or
 * when ARM writes into C/S word from locked MB. The MB locking is done to
 * prevent a new frame to be written into the MB while ARM is reading it. .
 */
typedef union _hw_can_timer
{
    uint32_t U;
    struct _hw_can_timer_bitfields
    {
        uint32_t TIMER : 16;           /*!< [15:0]  */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_timer_t;

/*!
 * @name Constants and macros for entire CAN_TIMER register
 */
/*@{*/
#define HW_CAN_TIMER_ADDR(x)     ((uintptr_t)(x) + 0x8U)

#define HW_CAN_TIMER(x)          (*(__IO hw_can_timer_t *) HW_CAN_TIMER_ADDR(x))
#define HW_CAN_TIMER_RD(x)       (HW_CAN_TIMER(x).U)
#define HW_CAN_TIMER_WR(x, v)    (HW_CAN_TIMER(x).U = (v))
#define HW_CAN_TIMER_SET(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) |  (v)))
#define HW_CAN_TIMER_CLR(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) & ~(v)))
#define HW_CAN_TIMER_TOG(x, v)   (HW_CAN_TIMER_WR(x, HW_CAN_TIMER_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_TIMER bitfields
 */

/*!
 * @name Register CAN_TIMER, field TIMER[15:0] (RW)
 *
 * TIMER
 */
/*@{*/
#define BP_CAN_TIMER_TIMER   (0U)          /*!< Bit position for CAN_TIMER_TIMER. */
#define BM_CAN_TIMER_TIMER   (0x0000FFFFU) /*!< Bit mask for CAN_TIMER_TIMER. */
#define BS_CAN_TIMER_TIMER   (16U)         /*!< Bit field size in bits for CAN_TIMER_TIMER. */

/*! @brief Read current value of the CAN_TIMER_TIMER field. */
#define BR_CAN_TIMER_TIMER(x) (HW_CAN_TIMER(x).B.TIMER)

/*! @brief Format value for bitfield CAN_TIMER_TIMER. */
#define BF_CAN_TIMER_TIMER(v) ((uint32_t)((uint32_t)(v) << BP_CAN_TIMER_TIMER) & BM_CAN_TIMER_TIMER)

/*! @brief Set the TIMER field to a new value. */
#define BW_CAN_TIMER_TIMER(x, v) (HW_CAN_TIMER_WR(x, (HW_CAN_TIMER_RD(x) & ~BM_CAN_TIMER_TIMER) | BF_CAN_TIMER_TIMER(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXMGMASK - Rx Mailboxes Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RXMGMASK is provided for legacy support. Asserting the MCR[IRMQ] bit causes
 * the RXMGMASK Register to have no effect on the module operation. RXMGMASK is
 * used to mask the filter fields of all Rx MBs, excluding MBs 14-15, which have
 * individual mask registers. This register can only be written in Freeze mode as
 * it is blocked by hardware in other modes. Rx Mailboxes Global Mask usage
 * SMB[RTR]RTR bit of the Incoming Frame. It is saved into an auxiliary MB called Rx
 * Serial Message Buffer (Rx SMB). CTRL2[RRS] CTRL2[EACEN] Mailbox filter fields
 * MB[RTR] MB[IDE] MB[ID] reserved 0 - 0 - NoteIf CTRL2[EACEN] bit is negated the
 * RTR bit of Mailbox is never compared with the RTR bit of the Incoming Frame (Rx
 * SMB[RTR]). - NoteIf CTRL2[EACEN] bit is negated the IDE bit of Mailbox is
 * always compared with the IDE bit of the Incoming Frame (Rx SMB[IDE]). MG[28:0]
 * MG[31:29] 0 - 1 MG[31] MG[30] MG[28:0] MG[29] 1 0 - - - - MG[31:0] 1 1 0 - -
 * MG[28:0] MG[31:29] 1 1 1 MG[31] MG[30] MG[28:0] MG[29]
 */
typedef union _hw_can_rxmgmask
{
    uint32_t U;
    struct _hw_can_rxmgmask_bitfields
    {
        uint32_t MG31_MG0 : 32;        /*!< [31:0]  */
    } B;
} hw_can_rxmgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXMGMASK register
 */
/*@{*/
#define HW_CAN_RXMGMASK_ADDR(x)  ((uintptr_t)(x) + 0x10U)

#define HW_CAN_RXMGMASK(x)       (*(__IO hw_can_rxmgmask_t *) HW_CAN_RXMGMASK_ADDR(x))
#define HW_CAN_RXMGMASK_RD(x)    (HW_CAN_RXMGMASK(x).U)
#define HW_CAN_RXMGMASK_WR(x, v) (HW_CAN_RXMGMASK(x).U = (v))
#define HW_CAN_RXMGMASK_SET(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) |  (v)))
#define HW_CAN_RXMGMASK_CLR(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) & ~(v)))
#define HW_CAN_RXMGMASK_TOG(x, v) (HW_CAN_RXMGMASK_WR(x, HW_CAN_RXMGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXMGMASK bitfields
 */

/*!
 * @name Register CAN_RXMGMASK, field MG31_MG0[31:0] (RW)
 *
 * These bits mask the Mailbox filter bits as shown in the figure above. Note
 * that the alignment with the ID word of the Mailbox is not perfect as the two
 * most significant MG bits affect the fields RTR and IDE which are located in the
 * Control and Status word of the Mailbox. RXMGMASKRx Mailboxes Global Mask
 * Register shows in detail which MG bits mask each Mailbox filter field.
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked against the one received
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RXMGMASK_MG31_MG0 (0U)      /*!< Bit position for CAN_RXMGMASK_MG31_MG0. */
#define BM_CAN_RXMGMASK_MG31_MG0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RXMGMASK_MG31_MG0. */
#define BS_CAN_RXMGMASK_MG31_MG0 (32U)     /*!< Bit field size in bits for CAN_RXMGMASK_MG31_MG0. */

/*! @brief Read current value of the CAN_RXMGMASK_MG31_MG0 field. */
#define BR_CAN_RXMGMASK_MG31_MG0(x) (HW_CAN_RXMGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXMGMASK_MG31_MG0. */
#define BF_CAN_RXMGMASK_MG31_MG0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXMGMASK_MG31_MG0) & BM_CAN_RXMGMASK_MG31_MG0)

/*! @brief Set the MG31_MG0 field to a new value. */
#define BW_CAN_RXMGMASK_MG31_MG0(x, v) (HW_CAN_RXMGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX14MASK - Rx Buffer 14 Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX14MASK - Rx Buffer 14 Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RX14MASK is provided for legacy support, asserting the MCR[IRMQ] bit causes
 * the RX14MASK to have no effect on the module operation. RX14MASK is used to
 * mask the filter fields of Message Buffer 14. This register can only be programmed
 * while the module is in Freeze Mode as it is blocked by hardware in other
 * modes.
 */
typedef union _hw_can_rx14mask
{
    uint32_t U;
    struct _hw_can_rx14mask_bitfields
    {
        uint32_t RX14M31_RX14M0 : 32;  /*!< [31:0]  */
    } B;
} hw_can_rx14mask_t;

/*!
 * @name Constants and macros for entire CAN_RX14MASK register
 */
/*@{*/
#define HW_CAN_RX14MASK_ADDR(x)  ((uintptr_t)(x) + 0x14U)

#define HW_CAN_RX14MASK(x)       (*(__IO hw_can_rx14mask_t *) HW_CAN_RX14MASK_ADDR(x))
#define HW_CAN_RX14MASK_RD(x)    (HW_CAN_RX14MASK(x).U)
#define HW_CAN_RX14MASK_WR(x, v) (HW_CAN_RX14MASK(x).U = (v))
#define HW_CAN_RX14MASK_SET(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) |  (v)))
#define HW_CAN_RX14MASK_CLR(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) & ~(v)))
#define HW_CAN_RX14MASK_TOG(x, v) (HW_CAN_RX14MASK_WR(x, HW_CAN_RX14MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX14MASK bitfields
 */

/*!
 * @name Register CAN_RX14MASK, field RX14M31_RX14M0[31:0] (RW)
 *
 * These bits mask Mailbox 14 filter bits in the same fashion as RXMGMASK masks
 * other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask Register )
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RX14MASK_RX14M31_RX14M0 (0U) /*!< Bit position for CAN_RX14MASK_RX14M31_RX14M0. */
#define BM_CAN_RX14MASK_RX14M31_RX14M0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RX14MASK_RX14M31_RX14M0. */
#define BS_CAN_RX14MASK_RX14M31_RX14M0 (32U) /*!< Bit field size in bits for CAN_RX14MASK_RX14M31_RX14M0. */

/*! @brief Read current value of the CAN_RX14MASK_RX14M31_RX14M0 field. */
#define BR_CAN_RX14MASK_RX14M31_RX14M0(x) (HW_CAN_RX14MASK(x).U)

/*! @brief Format value for bitfield CAN_RX14MASK_RX14M31_RX14M0. */
#define BF_CAN_RX14MASK_RX14M31_RX14M0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX14MASK_RX14M31_RX14M0) & BM_CAN_RX14MASK_RX14M31_RX14M0)

/*! @brief Set the RX14M31_RX14M0 field to a new value. */
#define BW_CAN_RX14MASK_RX14M31_RX14M0(x, v) (HW_CAN_RX14MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RX15MASK - Rx Buffer 15 Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RX15MASK - Rx Buffer 15 Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * RX15MASK is provided for legacy support, asserting the MCR[IRMQ] bit causes
 * the RX15MASK Register to have no effect on the module operation. RX15MASK is
 * used to mask the filter fields of Message Buffer 15. This register can only be
 * programmed while the module is in Freeze Mode as it is blocked by hardware in
 * other modes.
 */
typedef union _hw_can_rx15mask
{
    uint32_t U;
    struct _hw_can_rx15mask_bitfields
    {
        uint32_t RX15M31_RX15M0 : 32;  /*!< [31:0]  */
    } B;
} hw_can_rx15mask_t;

/*!
 * @name Constants and macros for entire CAN_RX15MASK register
 */
/*@{*/
#define HW_CAN_RX15MASK_ADDR(x)  ((uintptr_t)(x) + 0x18U)

#define HW_CAN_RX15MASK(x)       (*(__IO hw_can_rx15mask_t *) HW_CAN_RX15MASK_ADDR(x))
#define HW_CAN_RX15MASK_RD(x)    (HW_CAN_RX15MASK(x).U)
#define HW_CAN_RX15MASK_WR(x, v) (HW_CAN_RX15MASK(x).U = (v))
#define HW_CAN_RX15MASK_SET(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) |  (v)))
#define HW_CAN_RX15MASK_CLR(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) & ~(v)))
#define HW_CAN_RX15MASK_TOG(x, v) (HW_CAN_RX15MASK_WR(x, HW_CAN_RX15MASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RX15MASK bitfields
 */

/*!
 * @name Register CAN_RX15MASK, field RX15M31_RX15M0[31:0] (RW)
 *
 * These bits mask Mailbox 15 filter bits in the same fashion as RXMGMASK masks
 * other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask Register ).
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - the corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RX15MASK_RX15M31_RX15M0 (0U) /*!< Bit position for CAN_RX15MASK_RX15M31_RX15M0. */
#define BM_CAN_RX15MASK_RX15M31_RX15M0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RX15MASK_RX15M31_RX15M0. */
#define BS_CAN_RX15MASK_RX15M31_RX15M0 (32U) /*!< Bit field size in bits for CAN_RX15MASK_RX15M31_RX15M0. */

/*! @brief Read current value of the CAN_RX15MASK_RX15M31_RX15M0 field. */
#define BR_CAN_RX15MASK_RX15M31_RX15M0(x) (HW_CAN_RX15MASK(x).U)

/*! @brief Format value for bitfield CAN_RX15MASK_RX15M31_RX15M0. */
#define BF_CAN_RX15MASK_RX15M31_RX15M0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RX15MASK_RX15M31_RX15M0) & BM_CAN_RX15MASK_RX15M31_RX15M0)

/*! @brief Set the RX15M31_RX15M0 field to a new value. */
#define BW_CAN_RX15MASK_RX15M31_RX15M0(x, v) (HW_CAN_RX15MASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_ECR - Error Counter Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ECR - Error Counter Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register has 2 8-bit fields reflecting the value of two FLEXCAN error
 * counters: Transmit Error Counter (Tx_Err_Counter field) and Receive Error
 * Counter (Rx_Err_Counter field). The rules for increasing and decreasing these
 * counters are described in the CAN protocol and are completely implemented in the
 * FLEXCAN module. Both counters are read only except in Freeze Mode, where they can
 * be written by the ARM. FLEXCAN responds to any bus state as described in the
 * protocol, e.g. transmit 'Error Active' or 'Error Passive' flag, delay its
 * transmission start time ('Error Passive') and avoid any influence on the bus when
 * in 'Bus Off' state. The following are the basic rules for FLEXCAN bus state
 * transitions. If the value of Tx_Err_Counter or Rx_Err_Counter increases to be
 * greater than or equal to 128, the FLT_CONF field in the Error and Status
 * Register is updated to reflect 'Error Passive' state. If the FLEXCAN state is 'Error
 * Passive', and either Tx_Err_Counter or Rx_Err_Counter decrements to a value
 * less than or equal to 127 while the other already satisfies this condition, the
 * FLT_CONF field in the Error and Status Register is updated to reflect 'Error
 * Active' state. If the value of Tx_Err_Counter increases to be greater than 255,
 * the FLT_CONF field in the Error and Status Register is updated to reflect
 * 'Bus Off' state, and an interrupt may be issued. The value of Tx_Err_Counter is
 * then reset to zero. If FLEXCAN is in 'Bus Off' state, then Tx_Err_Counter is
 * cascaded together with another internal counter to count the 128th occurrences
 * of 11 consecutive recessive bits on the bus. Hence, Tx_Err_Counter is reset to
 * zero and counts in a manner where the internal counter counts 11 such bits and
 * then wraps around while incrementing the Tx_Err_Counter. When Tx_Err_Counter
 * reaches the value of 128, the FLT_CONF field in the Error and Status Register
 * is updated to be 'Error Active' and both error counters are reset to zero. At
 * any instance of dominant bit following a stream of less than 11 consecutive
 * recessive bits, the internal counter resets itself to zero without affecting the
 * Tx_Err_Counter value. If during system start-up, only one node is operating,
 * then its Tx_Err_Counter increases in each message it is trying to transmit, as
 * a result of acknowledge errors (indicated by the ACK_ERR bit in the Error and
 * Status Register). After the transition to 'Error Passive' state, the
 * Tx_Err_Counter does not increment anymore by acknowledge errors. Therefore the device
 * never goes to the 'Bus Off' state. If the Rx_Err_Counter increases to a value
 * greater than 127, it is not incremented further, even if more errors are
 * detected while being a receiver. At the next successful message reception, the
 * counter is set to a value between 119 and 127 to resume to 'Error Active' state.
 */
typedef union _hw_can_ecr
{
    uint32_t U;
    struct _hw_can_ecr_bitfields
    {
        uint32_t Tx_Err_Counter : 8;   /*!< [7:0]  */
        uint32_t Rx_Err_Counter : 8;   /*!< [15:8]  */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_can_ecr_t;

/*!
 * @name Constants and macros for entire CAN_ECR register
 */
/*@{*/
#define HW_CAN_ECR_ADDR(x)       ((uintptr_t)(x) + 0x1CU)

#define HW_CAN_ECR(x)            (*(__IO hw_can_ecr_t *) HW_CAN_ECR_ADDR(x))
#define HW_CAN_ECR_RD(x)         (HW_CAN_ECR(x).U)
#define HW_CAN_ECR_WR(x, v)      (HW_CAN_ECR(x).U = (v))
#define HW_CAN_ECR_SET(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) |  (v)))
#define HW_CAN_ECR_CLR(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) & ~(v)))
#define HW_CAN_ECR_TOG(x, v)     (HW_CAN_ECR_WR(x, HW_CAN_ECR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ECR bitfields
 */

/*!
 * @name Register CAN_ECR, field Tx_Err_Counter[7:0] (RW)
 *
 * Tx_Err_Counter
 */
/*@{*/
#define BP_CAN_ECR_Tx_Err_Counter (0U)     /*!< Bit position for CAN_ECR_Tx_Err_Counter. */
#define BM_CAN_ECR_Tx_Err_Counter (0x000000FFU) /*!< Bit mask for CAN_ECR_Tx_Err_Counter. */
#define BS_CAN_ECR_Tx_Err_Counter (8U)     /*!< Bit field size in bits for CAN_ECR_Tx_Err_Counter. */

/*! @brief Read current value of the CAN_ECR_Tx_Err_Counter field. */
#define BR_CAN_ECR_Tx_Err_Counter(x) (HW_CAN_ECR(x).B.Tx_Err_Counter)

/*! @brief Format value for bitfield CAN_ECR_Tx_Err_Counter. */
#define BF_CAN_ECR_Tx_Err_Counter(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_Tx_Err_Counter) & BM_CAN_ECR_Tx_Err_Counter)

/*! @brief Set the Tx_Err_Counter field to a new value. */
#define BW_CAN_ECR_Tx_Err_Counter(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_Tx_Err_Counter) | BF_CAN_ECR_Tx_Err_Counter(v)))
/*@}*/

/*!
 * @name Register CAN_ECR, field Rx_Err_Counter[15:8] (RW)
 *
 * Rx_Err_Counter
 */
/*@{*/
#define BP_CAN_ECR_Rx_Err_Counter (8U)     /*!< Bit position for CAN_ECR_Rx_Err_Counter. */
#define BM_CAN_ECR_Rx_Err_Counter (0x0000FF00U) /*!< Bit mask for CAN_ECR_Rx_Err_Counter. */
#define BS_CAN_ECR_Rx_Err_Counter (8U)     /*!< Bit field size in bits for CAN_ECR_Rx_Err_Counter. */

/*! @brief Read current value of the CAN_ECR_Rx_Err_Counter field. */
#define BR_CAN_ECR_Rx_Err_Counter(x) (HW_CAN_ECR(x).B.Rx_Err_Counter)

/*! @brief Format value for bitfield CAN_ECR_Rx_Err_Counter. */
#define BF_CAN_ECR_Rx_Err_Counter(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ECR_Rx_Err_Counter) & BM_CAN_ECR_Rx_Err_Counter)

/*! @brief Set the Rx_Err_Counter field to a new value. */
#define BW_CAN_ECR_Rx_Err_Counter(x, v) (HW_CAN_ECR_WR(x, (HW_CAN_ECR_RD(x) & ~BM_CAN_ECR_Rx_Err_Counter) | BF_CAN_ECR_Rx_Err_Counter(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR1 - Error and Status 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR1 - Error and Status 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various error conditions, some general status of the
 * device and it is the source of four interrupts to the ARM. The ARM read action
 * clears bits 15-10, therefore the reported error conditions (bits 15-10) are
 * those that occurred since the last time the ARM read this register. Bits 9-3 are
 * status bits. Some bits in this register are read-only and some are not.
 * FlexCAN State SYNCH IDLE TX RX FlexCAN state 0 0 0 0 Not synchronized to CAN bus 1
 * 1 x x Idle 1 0 1 0 Transmitting 1 0 0 1 Receiving other combinations Reserved
 */
typedef union _hw_can_esr1
{
    uint32_t U;
    struct _hw_can_esr1_bitfields
    {
        uint32_t WAK_INT : 1;          /*!< [0]  */
        uint32_t ERR_INT : 1;          /*!< [1]  */
        uint32_t BOFF_INT : 1;         /*!< [2]  */
        uint32_t RX : 1;               /*!< [3]  */
        uint32_t FLT_CONF : 2;         /*!< [5:4]  */
        uint32_t TX : 1;               /*!< [6]  */
        uint32_t IDLE : 1;             /*!< [7]  */
        uint32_t RX_WRN : 1;           /*!< [8]  */
        uint32_t TX_WRN : 1;           /*!< [9]  */
        uint32_t STF_ERR : 1;          /*!< [10]  */
        uint32_t FRM_ERR : 1;          /*!< [11]  */
        uint32_t CRC_ERR : 1;          /*!< [12]  */
        uint32_t ACK_ERR : 1;          /*!< [13]  */
        uint32_t BIT0_ERR : 1;         /*!< [14]  */
        uint32_t BIT1_ERR : 1;         /*!< [15]  */
        uint32_t RWRN_INT : 1;         /*!< [16]  */
        uint32_t TWRN_INT : 1;         /*!< [17]  */
        uint32_t SYNCH : 1;            /*!< [18]  */
        uint32_t RESERVED0 : 13;       /*!< [31:19]  */
    } B;
} hw_can_esr1_t;

/*!
 * @name Constants and macros for entire CAN_ESR1 register
 */
/*@{*/
#define HW_CAN_ESR1_ADDR(x)      ((uintptr_t)(x) + 0x20U)

#define HW_CAN_ESR1(x)           (*(__IO hw_can_esr1_t *) HW_CAN_ESR1_ADDR(x))
#define HW_CAN_ESR1_RD(x)        (HW_CAN_ESR1(x).U)
#define HW_CAN_ESR1_WR(x, v)     (HW_CAN_ESR1(x).U = (v))
#define HW_CAN_ESR1_SET(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) |  (v)))
#define HW_CAN_ESR1_CLR(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) & ~(v)))
#define HW_CAN_ESR1_TOG(x, v)    (HW_CAN_ESR1_WR(x, HW_CAN_ESR1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR1 bitfields
 */

/*!
 * @name Register CAN_ESR1, field WAK_INT[0] (RW)
 *
 * When FLEXCAN is Stop Mode and a recessive to dominant transition is detected
 * on the CAN bus and if the WAK_MSK bit in the MCR Register is set, an interrupt
 * is generated to the ARM. This bit is cleared by writing it to '1'. When
 * SLF_WAK is negated, this flag is masked. ARM must clear this flag before disabling
 * the bit. Otherwise it will be set when the SLF_WAK is set again. Writing '0'
 * has no effect
 *
 * Values:
 * - 1 - Indicates a recessive to dominant transition received on the CAN bus
 *     when the FLEXCAN module is in Stop Mode
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_WAK_INT  (0U)          /*!< Bit position for CAN_ESR1_WAK_INT. */
#define BM_CAN_ESR1_WAK_INT  (0x00000001U) /*!< Bit mask for CAN_ESR1_WAK_INT. */
#define BS_CAN_ESR1_WAK_INT  (1U)          /*!< Bit field size in bits for CAN_ESR1_WAK_INT. */

/*! @brief Read current value of the CAN_ESR1_WAK_INT field. */
#define BR_CAN_ESR1_WAK_INT(x) (HW_CAN_ESR1(x).B.WAK_INT)

/*! @brief Format value for bitfield CAN_ESR1_WAK_INT. */
#define BF_CAN_ESR1_WAK_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_WAK_INT) & BM_CAN_ESR1_WAK_INT)

/*! @brief Set the WAK_INT field to a new value. */
#define BW_CAN_ESR1_WAK_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_WAK_INT) | BF_CAN_ESR1_WAK_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ERR_INT[1] (RW)
 *
 * This bit indicates that at least one of the Error Bits (bits 15-10) is set.
 * If the corresponding mask bit in the Control Register (ERR_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to
 * '1'.Writing '0' has no effect.
 *
 * Values:
 * - 1 - Indicates setting of any Error Bit in the Error and Status Register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_ERR_INT  (1U)          /*!< Bit position for CAN_ESR1_ERR_INT. */
#define BM_CAN_ESR1_ERR_INT  (0x00000002U) /*!< Bit mask for CAN_ESR1_ERR_INT. */
#define BS_CAN_ESR1_ERR_INT  (1U)          /*!< Bit field size in bits for CAN_ESR1_ERR_INT. */

/*! @brief Read current value of the CAN_ESR1_ERR_INT field. */
#define BR_CAN_ESR1_ERR_INT(x) (HW_CAN_ESR1(x).B.ERR_INT)

/*! @brief Format value for bitfield CAN_ESR1_ERR_INT. */
#define BF_CAN_ESR1_ERR_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_ERR_INT) & BM_CAN_ESR1_ERR_INT)

/*! @brief Set the ERR_INT field to a new value. */
#define BW_CAN_ESR1_ERR_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_ERR_INT) | BF_CAN_ESR1_ERR_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BOFF_INT[2] (RW)
 *
 * This bit is set when FLEXCAN enters 'Bus Off' state. If the corresponding
 * mask bit in the Control Register (BOFF_MSK) is set, an interrupt is generated to
 * the ARM. This bit is cleared by writing it to '1'. Writing '0' has no effect.
 *
 * Values:
 * - 1 - FLEXCAN module entered 'Bus Off' state
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BOFF_INT (2U)          /*!< Bit position for CAN_ESR1_BOFF_INT. */
#define BM_CAN_ESR1_BOFF_INT (0x00000004U) /*!< Bit mask for CAN_ESR1_BOFF_INT. */
#define BS_CAN_ESR1_BOFF_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_BOFF_INT. */

/*! @brief Read current value of the CAN_ESR1_BOFF_INT field. */
#define BR_CAN_ESR1_BOFF_INT(x) (HW_CAN_ESR1(x).B.BOFF_INT)

/*! @brief Format value for bitfield CAN_ESR1_BOFF_INT. */
#define BF_CAN_ESR1_BOFF_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_BOFF_INT) & BM_CAN_ESR1_BOFF_INT)

/*! @brief Set the BOFF_INT field to a new value. */
#define BW_CAN_ESR1_BOFF_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_BOFF_INT) | BF_CAN_ESR1_BOFF_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX[3] (RO)
 *
 * This bit indicates if FlexCAN is receiving a message. Refer to .
 *
 * Values:
 * - 1 - FLEXCAN is transmitting a message
 * - 0 - FLEXCAN is receiving a message
 */
/*@{*/
#define BP_CAN_ESR1_RX       (3U)          /*!< Bit position for CAN_ESR1_RX. */
#define BM_CAN_ESR1_RX       (0x00000008U) /*!< Bit mask for CAN_ESR1_RX. */
#define BS_CAN_ESR1_RX       (1U)          /*!< Bit field size in bits for CAN_ESR1_RX. */

/*! @brief Read current value of the CAN_ESR1_RX field. */
#define BR_CAN_ESR1_RX(x)    (HW_CAN_ESR1(x).B.RX)
/*@}*/

/*!
 * @name Register CAN_ESR1, field FLT_CONF[5:4] (RO)
 *
 * If the LOM bit in the Control Register is asserted, after some delay that
 * depends on the CAN bit timing the FLT_CONF field will indicate "Error Passive".
 * The very same delay affects the way how FLT_CONF reflects an update to ECR
 * register by the ARM. It may be necessary up to one CAN bit time to get them
 * coherent again. Since the Control Register is not affected by soft reset, the
 * FLT_CONF field will not be affected by soft reset if the LOM bit is asserted. This
 * 2-bit field indicates the Confinement State of the FLEXCAN module, as shown in
 * below:
 *
 * Values:
 * - 00 - Error Active
 * - 01 - Error Passive
 * - 1x - Bus off
 */
/*@{*/
#define BP_CAN_ESR1_FLT_CONF (4U)          /*!< Bit position for CAN_ESR1_FLT_CONF. */
#define BM_CAN_ESR1_FLT_CONF (0x00000030U) /*!< Bit mask for CAN_ESR1_FLT_CONF. */
#define BS_CAN_ESR1_FLT_CONF (2U)          /*!< Bit field size in bits for CAN_ESR1_FLT_CONF. */

/*! @brief Read current value of the CAN_ESR1_FLT_CONF field. */
#define BR_CAN_ESR1_FLT_CONF(x) (HW_CAN_ESR1(x).B.FLT_CONF)
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX[6] (RO)
 *
 * This bit indicates if FLEXCAN is transmitting a message.Refer to .
 *
 * Values:
 * - 1 - FLEXCAN is transmitting a message
 * - 0 - FLEXCAN is receiving a message
 */
/*@{*/
#define BP_CAN_ESR1_TX       (6U)          /*!< Bit position for CAN_ESR1_TX. */
#define BM_CAN_ESR1_TX       (0x00000040U) /*!< Bit mask for CAN_ESR1_TX. */
#define BS_CAN_ESR1_TX       (1U)          /*!< Bit field size in bits for CAN_ESR1_TX. */

/*! @brief Read current value of the CAN_ESR1_TX field. */
#define BR_CAN_ESR1_TX(x)    (HW_CAN_ESR1(x).B.TX)
/*@}*/

/*!
 * @name Register CAN_ESR1, field IDLE[7] (RO)
 *
 * This bit indicates when CAN bus is in IDLE state.Refer to .
 *
 * Values:
 * - 1 - CAN bus is now IDLE
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_IDLE     (7U)          /*!< Bit position for CAN_ESR1_IDLE. */
#define BM_CAN_ESR1_IDLE     (0x00000080U) /*!< Bit mask for CAN_ESR1_IDLE. */
#define BS_CAN_ESR1_IDLE     (1U)          /*!< Bit field size in bits for CAN_ESR1_IDLE. */

/*! @brief Read current value of the CAN_ESR1_IDLE field. */
#define BR_CAN_ESR1_IDLE(x)  (HW_CAN_ESR1(x).B.IDLE)
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX_WRN[8] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * reception.
 *
 * Values:
 * - 1 - Rx_Err_Counter >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_RX_WRN   (8U)          /*!< Bit position for CAN_ESR1_RX_WRN. */
#define BM_CAN_ESR1_RX_WRN   (0x00000100U) /*!< Bit mask for CAN_ESR1_RX_WRN. */
#define BS_CAN_ESR1_RX_WRN   (1U)          /*!< Bit field size in bits for CAN_ESR1_RX_WRN. */

/*! @brief Read current value of the CAN_ESR1_RX_WRN field. */
#define BR_CAN_ESR1_RX_WRN(x) (HW_CAN_ESR1(x).B.RX_WRN)
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX_WRN[9] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * transmission.
 *
 * Values:
 * - 1 - TX_Err_Counter >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_TX_WRN   (9U)          /*!< Bit position for CAN_ESR1_TX_WRN. */
#define BM_CAN_ESR1_TX_WRN   (0x00000200U) /*!< Bit mask for CAN_ESR1_TX_WRN. */
#define BS_CAN_ESR1_TX_WRN   (1U)          /*!< Bit field size in bits for CAN_ESR1_TX_WRN. */

/*! @brief Read current value of the CAN_ESR1_TX_WRN field. */
#define BR_CAN_ESR1_TX_WRN(x) (HW_CAN_ESR1(x).B.TX_WRN)
/*@}*/

/*!
 * @name Register CAN_ESR1, field STF_ERR[10] (RO)
 *
 * This bit indicates that a Stuffing Error has been detected.
 *
 * Values:
 * - 1 - A Stuffing Error occurred since last read of this register.
 * - 0 - No such occurrence.
 */
/*@{*/
#define BP_CAN_ESR1_STF_ERR  (10U)         /*!< Bit position for CAN_ESR1_STF_ERR. */
#define BM_CAN_ESR1_STF_ERR  (0x00000400U) /*!< Bit mask for CAN_ESR1_STF_ERR. */
#define BS_CAN_ESR1_STF_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_STF_ERR. */

/*! @brief Read current value of the CAN_ESR1_STF_ERR field. */
#define BR_CAN_ESR1_STF_ERR(x) (HW_CAN_ESR1(x).B.STF_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field FRM_ERR[11] (RO)
 *
 * This bit indicates that a Form Error has been detected by the receiver node,
 * i.e., a fixed-form bit field contains at least one illegal bit.
 *
 * Values:
 * - 1 - A Form Error occurred since last read of this register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_FRM_ERR  (11U)         /*!< Bit position for CAN_ESR1_FRM_ERR. */
#define BM_CAN_ESR1_FRM_ERR  (0x00000800U) /*!< Bit mask for CAN_ESR1_FRM_ERR. */
#define BS_CAN_ESR1_FRM_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_FRM_ERR. */

/*! @brief Read current value of the CAN_ESR1_FRM_ERR field. */
#define BR_CAN_ESR1_FRM_ERR(x) (HW_CAN_ESR1(x).B.FRM_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field CRC_ERR[12] (RO)
 *
 * This bit indicates that a CRC Error has been detected by the receiver node,
 * i.e., the calculated CRC is different from the received.
 *
 * Values:
 * - 1 - A CRC error occurred since last read of this register.
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_CRC_ERR  (12U)         /*!< Bit position for CAN_ESR1_CRC_ERR. */
#define BM_CAN_ESR1_CRC_ERR  (0x00001000U) /*!< Bit mask for CAN_ESR1_CRC_ERR. */
#define BS_CAN_ESR1_CRC_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_CRC_ERR. */

/*! @brief Read current value of the CAN_ESR1_CRC_ERR field. */
#define BR_CAN_ESR1_CRC_ERR(x) (HW_CAN_ESR1(x).B.CRC_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field ACK_ERR[13] (RO)
 *
 * This bit indicates that an Acknowledge Error has been detected by the
 * transmitter node, i.e., a dominant bit has not been detected during the ACK SLOT.
 *
 * Values:
 * - 1 - An ACK error occurred since last read of this register
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_ACK_ERR  (13U)         /*!< Bit position for CAN_ESR1_ACK_ERR. */
#define BM_CAN_ESR1_ACK_ERR  (0x00002000U) /*!< Bit mask for CAN_ESR1_ACK_ERR. */
#define BS_CAN_ESR1_ACK_ERR  (1U)          /*!< Bit field size in bits for CAN_ESR1_ACK_ERR. */

/*! @brief Read current value of the CAN_ESR1_ACK_ERR field. */
#define BR_CAN_ESR1_ACK_ERR(x) (HW_CAN_ESR1(x).B.ACK_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT0_ERR[14] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message.
 *
 * Values:
 * - 1 - At least one bit sent as dominant is received as recessive
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BIT0_ERR (14U)         /*!< Bit position for CAN_ESR1_BIT0_ERR. */
#define BM_CAN_ESR1_BIT0_ERR (0x00004000U) /*!< Bit mask for CAN_ESR1_BIT0_ERR. */
#define BS_CAN_ESR1_BIT0_ERR (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT0_ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT0_ERR field. */
#define BR_CAN_ESR1_BIT0_ERR(x) (HW_CAN_ESR1(x).B.BIT0_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT1_ERR[15] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message. This bit is not set by a transmitter in case of
 * arbitration field or ACK slot, or in case of a node sending a passive error
 * flag that detects dominant bits.
 *
 * Values:
 * - 1 - At least one bit sent as recessive is received as dominant
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_BIT1_ERR (15U)         /*!< Bit position for CAN_ESR1_BIT1_ERR. */
#define BM_CAN_ESR1_BIT1_ERR (0x00008000U) /*!< Bit mask for CAN_ESR1_BIT1_ERR. */
#define BS_CAN_ESR1_BIT1_ERR (1U)          /*!< Bit field size in bits for CAN_ESR1_BIT1_ERR. */

/*! @brief Read current value of the CAN_ESR1_BIT1_ERR field. */
#define BR_CAN_ESR1_BIT1_ERR(x) (HW_CAN_ESR1(x).B.BIT1_ERR)
/*@}*/

/*!
 * @name Register CAN_ESR1, field RWRN_INT[16] (RW)
 *
 * If the WRN_EN bit in MCR is asserted, the RWRN_INT bit is set when the RX_WRN
 * flag transition from '0' to '1', meaning that the Rx error counters reached
 * 96. If the corresponding mask bit in the Control Register (RWRN_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to '1'.
 * When WRN_EN is negated, this flag is masked. ARM must clear this flag before
 * disabling the bit. Otherwise it will be set when the WRN_EN is set again.
 * Writing '0' has no effect. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 1 - The Rx error counter transition from < 96 to >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_RWRN_INT (16U)         /*!< Bit position for CAN_ESR1_RWRN_INT. */
#define BM_CAN_ESR1_RWRN_INT (0x00010000U) /*!< Bit mask for CAN_ESR1_RWRN_INT. */
#define BS_CAN_ESR1_RWRN_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_RWRN_INT. */

/*! @brief Read current value of the CAN_ESR1_RWRN_INT field. */
#define BR_CAN_ESR1_RWRN_INT(x) (HW_CAN_ESR1(x).B.RWRN_INT)

/*! @brief Format value for bitfield CAN_ESR1_RWRN_INT. */
#define BF_CAN_ESR1_RWRN_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_RWRN_INT) & BM_CAN_ESR1_RWRN_INT)

/*! @brief Set the RWRN_INT field to a new value. */
#define BW_CAN_ESR1_RWRN_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_RWRN_INT) | BF_CAN_ESR1_RWRN_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TWRN_INT[17] (RW)
 *
 * If the WRN_EN bit in MCR is asserted, the TWRN_INT bit is set when the TX_WRN
 * flag transition from '0' to '1', meaning that the Tx error counter reached
 * 96. If the corresponding mask bit in the Control Register (TWRN_MSK) is set, an
 * interrupt is generated to the ARM. This bit is cleared by writing it to '1'.
 * When WRN_EN is negated, this flag is masked. ARM must clear this flag before
 * disabling the bit. Otherwise it will be set when the WRN_EN is set again.
 * Writing '0' has no effect. This flag is not generated during "Bus Off" state. This
 * bit is not updated during Freeze mode.
 *
 * Values:
 * - 1 - The Tx error counter transition from < 96 to >= 96
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_ESR1_TWRN_INT (17U)         /*!< Bit position for CAN_ESR1_TWRN_INT. */
#define BM_CAN_ESR1_TWRN_INT (0x00020000U) /*!< Bit mask for CAN_ESR1_TWRN_INT. */
#define BS_CAN_ESR1_TWRN_INT (1U)          /*!< Bit field size in bits for CAN_ESR1_TWRN_INT. */

/*! @brief Read current value of the CAN_ESR1_TWRN_INT field. */
#define BR_CAN_ESR1_TWRN_INT(x) (HW_CAN_ESR1(x).B.TWRN_INT)

/*! @brief Format value for bitfield CAN_ESR1_TWRN_INT. */
#define BF_CAN_ESR1_TWRN_INT(v) ((uint32_t)((uint32_t)(v) << BP_CAN_ESR1_TWRN_INT) & BM_CAN_ESR1_TWRN_INT)

/*! @brief Set the TWRN_INT field to a new value. */
#define BW_CAN_ESR1_TWRN_INT(x, v) (HW_CAN_ESR1_WR(x, (HW_CAN_ESR1_RD(x) & ~BM_CAN_ESR1_TWRN_INT) | BF_CAN_ESR1_TWRN_INT(v)))
/*@}*/

/*!
 * @name Register CAN_ESR1, field SYNCH[18] (RO)
 *
 * This read-only flag indicates whether the FlexCAN is synchronized to the CAN
 * bus and able to participate in the communication process. It is set and
 * cleared by the FlexCAN. Refer to
 *
 * Values:
 * - 1 - FlexCAN is synchronized to the CAN bus
 * - 0 - FlexCAN is not synchronized to the CAN bus
 */
/*@{*/
#define BP_CAN_ESR1_SYNCH    (18U)         /*!< Bit position for CAN_ESR1_SYNCH. */
#define BM_CAN_ESR1_SYNCH    (0x00040000U) /*!< Bit mask for CAN_ESR1_SYNCH. */
#define BS_CAN_ESR1_SYNCH    (1U)          /*!< Bit field size in bits for CAN_ESR1_SYNCH. */

/*! @brief Read current value of the CAN_ESR1_SYNCH field. */
#define BR_CAN_ESR1_SYNCH(x) (HW_CAN_ESR1(x).B.SYNCH)
/*@}*/

/*******************************************************************************
 * HW_CAN_IMASK2 - Interrupt Masks 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IMASK2 - Interrupt Masks 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows any number of a range of 32 Message Buffer Interrupts to
 * be enabled or disabled. It contains one interrupt mask bit per buffer,
 * enabling the ARM to determine which buffer generates an interrupt after a successful
 * transmission or reception (i.e. when the corresponding IFLAG2 bit is set).
 */
typedef union _hw_can_imask2
{
    uint32_t U;
    struct _hw_can_imask2_bitfields
    {
        uint32_t BUF63M_BUF32M : 32;   /*!< [31:0]  */
    } B;
} hw_can_imask2_t;

/*!
 * @name Constants and macros for entire CAN_IMASK2 register
 */
/*@{*/
#define HW_CAN_IMASK2_ADDR(x)    ((uintptr_t)(x) + 0x24U)

#define HW_CAN_IMASK2(x)         (*(__IO hw_can_imask2_t *) HW_CAN_IMASK2_ADDR(x))
#define HW_CAN_IMASK2_RD(x)      (HW_CAN_IMASK2(x).U)
#define HW_CAN_IMASK2_WR(x, v)   (HW_CAN_IMASK2(x).U = (v))
#define HW_CAN_IMASK2_SET(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) |  (v)))
#define HW_CAN_IMASK2_CLR(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) & ~(v)))
#define HW_CAN_IMASK2_TOG(x, v)  (HW_CAN_IMASK2_WR(x, HW_CAN_IMASK2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IMASK2 bitfields
 */

/*!
 * @name Register CAN_IMASK2, field BUF63M_BUF32M[31:0] (RW)
 *
 * Each bit enables or disables the respective FLEXCAN Message Buffer (MB32 to
 * MB63) Interrupt. Setting or clearing a bit in the IMASK2 Register can assert or
 * negate an interrupt request, if the corresponding IFLAG2 bit is set.
 *
 * Values:
 * - 1 - The corresponding buffer Interrupt is enabled
 * - 0 - The corresponding buffer Interrupt is disabled
 */
/*@{*/
#define BP_CAN_IMASK2_BUF63M_BUF32M (0U)   /*!< Bit position for CAN_IMASK2_BUF63M_BUF32M. */
#define BM_CAN_IMASK2_BUF63M_BUF32M (0xFFFFFFFFU) /*!< Bit mask for CAN_IMASK2_BUF63M_BUF32M. */
#define BS_CAN_IMASK2_BUF63M_BUF32M (32U)  /*!< Bit field size in bits for CAN_IMASK2_BUF63M_BUF32M. */

/*! @brief Read current value of the CAN_IMASK2_BUF63M_BUF32M field. */
#define BR_CAN_IMASK2_BUF63M_BUF32M(x) (HW_CAN_IMASK2(x).U)

/*! @brief Format value for bitfield CAN_IMASK2_BUF63M_BUF32M. */
#define BF_CAN_IMASK2_BUF63M_BUF32M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IMASK2_BUF63M_BUF32M) & BM_CAN_IMASK2_BUF63M_BUF32M)

/*! @brief Set the BUF63M_BUF32M field to a new value. */
#define BW_CAN_IMASK2_BUF63M_BUF32M(x, v) (HW_CAN_IMASK2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IMASK1 - Interrupt Masks 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IMASK1 - Interrupt Masks 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows to enable or disable any number of a range of 32 Message
 * Buffer Interrupts. It contains one interrupt mask bit per buffer, enabling
 * the ARM to determine which buffer generates an interrupt after a successful
 * transmission or reception (i.e., when the corresponding IFLAG1 bit is set).
 */
typedef union _hw_can_imask1
{
    uint32_t U;
    struct _hw_can_imask1_bitfields
    {
        uint32_t BUF31M_BUF0M : 32;    /*!< [31:0]  */
    } B;
} hw_can_imask1_t;

/*!
 * @name Constants and macros for entire CAN_IMASK1 register
 */
/*@{*/
#define HW_CAN_IMASK1_ADDR(x)    ((uintptr_t)(x) + 0x28U)

#define HW_CAN_IMASK1(x)         (*(__IO hw_can_imask1_t *) HW_CAN_IMASK1_ADDR(x))
#define HW_CAN_IMASK1_RD(x)      (HW_CAN_IMASK1(x).U)
#define HW_CAN_IMASK1_WR(x, v)   (HW_CAN_IMASK1(x).U = (v))
#define HW_CAN_IMASK1_SET(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) |  (v)))
#define HW_CAN_IMASK1_CLR(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) & ~(v)))
#define HW_CAN_IMASK1_TOG(x, v)  (HW_CAN_IMASK1_WR(x, HW_CAN_IMASK1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IMASK1 bitfields
 */

/*!
 * @name Register CAN_IMASK1, field BUF31M_BUF0M[31:0] (RW)
 *
 * Each bit enables or disables the respective FLEXCAN Message Buffer (MB0 to
 * MB31) Interrupt. Setting or clearing a bit in the IMASK1 Register can assert or
 * negate an interrupt request, if the corresponding IFLAG1 bit is set
 *
 * Values:
 * - 1 - The corresponding buffer Interrupt is enabled
 * - 0 - The corresponding buffer Interrupt is disabled
 */
/*@{*/
#define BP_CAN_IMASK1_BUF31M_BUF0M (0U)    /*!< Bit position for CAN_IMASK1_BUF31M_BUF0M. */
#define BM_CAN_IMASK1_BUF31M_BUF0M (0xFFFFFFFFU) /*!< Bit mask for CAN_IMASK1_BUF31M_BUF0M. */
#define BS_CAN_IMASK1_BUF31M_BUF0M (32U)   /*!< Bit field size in bits for CAN_IMASK1_BUF31M_BUF0M. */

/*! @brief Read current value of the CAN_IMASK1_BUF31M_BUF0M field. */
#define BR_CAN_IMASK1_BUF31M_BUF0M(x) (HW_CAN_IMASK1(x).U)

/*! @brief Format value for bitfield CAN_IMASK1_BUF31M_BUF0M. */
#define BF_CAN_IMASK1_BUF31M_BUF0M(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IMASK1_BUF31M_BUF0M) & BM_CAN_IMASK1_BUF31M_BUF0M)

/*! @brief Set the BUF31M_BUF0M field to a new value. */
#define BW_CAN_IMASK1_BUF31M_BUF0M(x, v) (HW_CAN_IMASK1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IFLAG2 - Interrupt Flags 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IFLAG2 - Interrupt Flags 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for 32 Message Buffer interrupts. It contains
 * one interrupt flag bit per buffer. Each successful transmission or reception
 * sets the corresponding IFLAG2 bit. If the corresponding IMASK2 bit is set, an
 * interrupt will be generated. The interrupt flag must be cleared by writing it
 * to '1'. Writing '0' has no effect.Before updating MCR[MAXMB] field, ARM must
 * treat the IFLAG2 bits which MB value is greater than the MCR[MAXMB] to be
 * updated, otherwise they will keep set and be inconsistent with the amount of MBs
 * available.
 */
typedef union _hw_can_iflag2
{
    uint32_t U;
    struct _hw_can_iflag2_bitfields
    {
        uint32_t BUF63I_BUF32I : 32;   /*!< [31:0]  */
    } B;
} hw_can_iflag2_t;

/*!
 * @name Constants and macros for entire CAN_IFLAG2 register
 */
/*@{*/
#define HW_CAN_IFLAG2_ADDR(x)    ((uintptr_t)(x) + 0x2CU)

#define HW_CAN_IFLAG2(x)         (*(__IO hw_can_iflag2_t *) HW_CAN_IFLAG2_ADDR(x))
#define HW_CAN_IFLAG2_RD(x)      (HW_CAN_IFLAG2(x).U)
#define HW_CAN_IFLAG2_WR(x, v)   (HW_CAN_IFLAG2(x).U = (v))
#define HW_CAN_IFLAG2_SET(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) |  (v)))
#define HW_CAN_IFLAG2_CLR(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) & ~(v)))
#define HW_CAN_IFLAG2_TOG(x, v)  (HW_CAN_IFLAG2_WR(x, HW_CAN_IFLAG2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG2 bitfields
 */

/*!
 * @name Register CAN_IFLAG2, field BUF63I_BUF32I[31:0] (RW)
 *
 * Each bit flags the respective FLEXCAN Message Buffer (MB32 to MB63) interrupt.
 *
 * Values:
 * - 1 - The corresponding buffer has successfully completed transmission or
 *     reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG2_BUF63I_BUF32I (0U)   /*!< Bit position for CAN_IFLAG2_BUF63I_BUF32I. */
#define BM_CAN_IFLAG2_BUF63I_BUF32I (0xFFFFFFFFU) /*!< Bit mask for CAN_IFLAG2_BUF63I_BUF32I. */
#define BS_CAN_IFLAG2_BUF63I_BUF32I (32U)  /*!< Bit field size in bits for CAN_IFLAG2_BUF63I_BUF32I. */

/*! @brief Read current value of the CAN_IFLAG2_BUF63I_BUF32I field. */
#define BR_CAN_IFLAG2_BUF63I_BUF32I(x) (HW_CAN_IFLAG2(x).U)

/*! @brief Format value for bitfield CAN_IFLAG2_BUF63I_BUF32I. */
#define BF_CAN_IFLAG2_BUF63I_BUF32I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG2_BUF63I_BUF32I) & BM_CAN_IFLAG2_BUF63I_BUF32I)

/*! @brief Set the BUF63I_BUF32I field to a new value. */
#define BW_CAN_IFLAG2_BUF63I_BUF32I(x, v) (HW_CAN_IFLAG2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_IFLAG1 - Interrupt Flags 1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IFLAG1 - Interrupt Flags 1 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for 32 Message Buffer interrupts and FIFO
 * interrupts. It contains one interrupt flag bit per buffer. Each successful
 * transmission or reception sets the corresponding IFLAG1 bit. If the corresponding
 * IMASK1 bit is set, an interrupt will be generated. The Interrupt flag must be
 * cleared by writing it to '1'. Writing '0' has no effect. When the RFEN bit in
 * the MCR is set (Rx FIFO enabled), the function of the 8 least significant
 * interrupt flags (BUF7I - BUF0I) is changed to support the FIFO operation. BUF7I,
 * BUF6I and BUF5I indicate operating conditions of the FIFO, while BUF4I to BUF0I
 * are not used. Before enabling the RFEN, ARM must service the IFLAGS asserted in
 * the Rx FIFO region (see Rx FIFOThe receive-only FIFO is enabled by asserting
 * the RFEN bit in the MCR. ). Otherwise, these IFLAGS will mistakenly show the
 * related MBs now belonging to FIFO as having contents to be serviced. When the
 * RFEN is negated, the FIFO flags must be cleared. The same care must be taken
 * when a RFFN value is selected extending Rx FIFO filters beyond MB7 (see
 * CTRL2Control 2 Register ). For example, when RFFN is 0x8, the MB0-23 range is occupied
 * by Rx FIFO filters and related IFLAGS must be cleared. Before updating
 * MCR[MAXMB] field, ARM must service the IFLAG1 which MB value is greater than the
 * MCR[MAXMB] to be updated, otherwise they will keep set and be inconsistent with
 * the amount of MBs available.
 */
typedef union _hw_can_iflag1
{
    uint32_t U;
    struct _hw_can_iflag1_bitfields
    {
        uint32_t BUF4I_BUF0I : 5;      /*!< [4:0]  */
        uint32_t BUF5I : 1;            /*!< [5]  */
        uint32_t BUF6I : 1;            /*!< [6]  */
        uint32_t BUF7I : 1;            /*!< [7]  */
        uint32_t BUF31I_BUF8I : 24;    /*!< [31:8]  */
    } B;
} hw_can_iflag1_t;

/*!
 * @name Constants and macros for entire CAN_IFLAG1 register
 */
/*@{*/
#define HW_CAN_IFLAG1_ADDR(x)    ((uintptr_t)(x) + 0x30U)

#define HW_CAN_IFLAG1(x)         (*(__IO hw_can_iflag1_t *) HW_CAN_IFLAG1_ADDR(x))
#define HW_CAN_IFLAG1_RD(x)      (HW_CAN_IFLAG1(x).U)
#define HW_CAN_IFLAG1_WR(x, v)   (HW_CAN_IFLAG1(x).U = (v))
#define HW_CAN_IFLAG1_SET(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) |  (v)))
#define HW_CAN_IFLAG1_CLR(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) & ~(v)))
#define HW_CAN_IFLAG1_TOG(x, v)  (HW_CAN_IFLAG1_WR(x, HW_CAN_IFLAG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG1 bitfields
 */

/*!
 * @name Register CAN_IFLAG1, field BUF4I_BUF0I[4:0] (RW)
 *
 * If the Rx FIFO is not enabled, these bits flag the interrupts for MB0 to MB4.
 * If the Rx FIFO is enabled, these flags are not used and must be considered as
 * reserved locations. These flags are cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - Corresponding MB completed transmission/reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF4I_BUF0I (0U)     /*!< Bit position for CAN_IFLAG1_BUF4I_BUF0I. */
#define BM_CAN_IFLAG1_BUF4I_BUF0I (0x0000001FU) /*!< Bit mask for CAN_IFLAG1_BUF4I_BUF0I. */
#define BS_CAN_IFLAG1_BUF4I_BUF0I (5U)     /*!< Bit field size in bits for CAN_IFLAG1_BUF4I_BUF0I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF4I_BUF0I field. */
#define BR_CAN_IFLAG1_BUF4I_BUF0I(x) (HW_CAN_IFLAG1(x).B.BUF4I_BUF0I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF4I_BUF0I. */
#define BF_CAN_IFLAG1_BUF4I_BUF0I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF4I_BUF0I) & BM_CAN_IFLAG1_BUF4I_BUF0I)

/*! @brief Set the BUF4I_BUF0I field to a new value. */
#define BW_CAN_IFLAG1_BUF4I_BUF0I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF4I_BUF0I) | BF_CAN_IFLAG1_BUF4I_BUF0I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF5I[5] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB5. If the
 * Rx FIFO is enabled, this flag indicates that at least one frame is available to
 * be read from the Rx FIFO. This flag is cleared by the FlexCAN whenever the
 * bit MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - MB5 completed transmission/reception or frames available in the FIFO
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF5I  (5U)          /*!< Bit position for CAN_IFLAG1_BUF5I. */
#define BM_CAN_IFLAG1_BUF5I  (0x00000020U) /*!< Bit mask for CAN_IFLAG1_BUF5I. */
#define BS_CAN_IFLAG1_BUF5I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF5I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF5I field. */
#define BR_CAN_IFLAG1_BUF5I(x) (HW_CAN_IFLAG1(x).B.BUF5I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF5I. */
#define BF_CAN_IFLAG1_BUF5I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF5I) & BM_CAN_IFLAG1_BUF5I)

/*! @brief Set the BUF5I field to a new value. */
#define BW_CAN_IFLAG1_BUF5I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF5I) | BF_CAN_IFLAG1_BUF5I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF6I[6] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB6. If the
 * MCR[RFEN] bit is asserted, this flag indicates when the number of unread
 * messages within the Rx FIFO is increased to 5 from 4 due to the reception of a new
 * one, meaning that the Rx FIFO is almost full. Note that if the flag is cleared
 * while the number of unread messages is greater than 4 it will not assert again
 * until the number of unread messages within the Rx FIFO is decreased to equal
 * or less than 4. This flag is cleared by the FlexCAN whenever the bit MCR[RFEN]
 * is changed by ARM writes.
 *
 * Values:
 * - 1 - MB6 completed transmission/reception or FIFO almost full
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF6I  (6U)          /*!< Bit position for CAN_IFLAG1_BUF6I. */
#define BM_CAN_IFLAG1_BUF6I  (0x00000040U) /*!< Bit mask for CAN_IFLAG1_BUF6I. */
#define BS_CAN_IFLAG1_BUF6I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF6I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF6I field. */
#define BR_CAN_IFLAG1_BUF6I(x) (HW_CAN_IFLAG1(x).B.BUF6I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF6I. */
#define BF_CAN_IFLAG1_BUF6I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF6I) & BM_CAN_IFLAG1_BUF6I)

/*! @brief Set the BUF6I field to a new value. */
#define BW_CAN_IFLAG1_BUF6I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF6I) | BF_CAN_IFLAG1_BUF6I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF7I[7] (RW)
 *
 * If the Rx FIFO is not enabled, this bit flags the interrupt for MB7. If the
 * MCR[RFEN] bit is asserted, this flag indicates that a message was lost because
 * Rx FIFO is full. Note that the flag will not be asserted when the Rx FIFO is
 * full and the message was captured by a Mailbox. This flag is cleared by the
 * FlexCAN whenever the bit MCR[RFEN] is changed by ARM writes.
 *
 * Values:
 * - 1 - MB7 completed transmission/reception or FIFO overflow
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF7I  (7U)          /*!< Bit position for CAN_IFLAG1_BUF7I. */
#define BM_CAN_IFLAG1_BUF7I  (0x00000080U) /*!< Bit mask for CAN_IFLAG1_BUF7I. */
#define BS_CAN_IFLAG1_BUF7I  (1U)          /*!< Bit field size in bits for CAN_IFLAG1_BUF7I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF7I field. */
#define BR_CAN_IFLAG1_BUF7I(x) (HW_CAN_IFLAG1(x).B.BUF7I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF7I. */
#define BF_CAN_IFLAG1_BUF7I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF7I) & BM_CAN_IFLAG1_BUF7I)

/*! @brief Set the BUF7I field to a new value. */
#define BW_CAN_IFLAG1_BUF7I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF7I) | BF_CAN_IFLAG1_BUF7I(v)))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF31I_BUF8I[31:8] (RW)
 *
 * Each bit flags the respective FLEXCAN Message Buffer (MB8 to MB31) interrupt.
 *
 * Values:
 * - 1 - The corresponding MB has successfully completed transmission or
 *     reception
 * - 0 - No such occurrence
 */
/*@{*/
#define BP_CAN_IFLAG1_BUF31I_BUF8I (8U)    /*!< Bit position for CAN_IFLAG1_BUF31I_BUF8I. */
#define BM_CAN_IFLAG1_BUF31I_BUF8I (0xFFFFFF00U) /*!< Bit mask for CAN_IFLAG1_BUF31I_BUF8I. */
#define BS_CAN_IFLAG1_BUF31I_BUF8I (24U)   /*!< Bit field size in bits for CAN_IFLAG1_BUF31I_BUF8I. */

/*! @brief Read current value of the CAN_IFLAG1_BUF31I_BUF8I field. */
#define BR_CAN_IFLAG1_BUF31I_BUF8I(x) (HW_CAN_IFLAG1(x).B.BUF31I_BUF8I)

/*! @brief Format value for bitfield CAN_IFLAG1_BUF31I_BUF8I. */
#define BF_CAN_IFLAG1_BUF31I_BUF8I(v) ((uint32_t)((uint32_t)(v) << BP_CAN_IFLAG1_BUF31I_BUF8I) & BM_CAN_IFLAG1_BUF31I_BUF8I)

/*! @brief Set the BUF31I_BUF8I field to a new value. */
#define BW_CAN_IFLAG1_BUF31I_BUF8I(x, v) (HW_CAN_IFLAG1_WR(x, (HW_CAN_IFLAG1_RD(x) & ~BM_CAN_IFLAG1_BUF31I_BUF8I) | BF_CAN_IFLAG1_BUF31I_BUF8I(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_CTRL2 - Control 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CTRL2 - Control 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains control bits for CAN errors, FIFO features and mode
 * selection. Rx FIFO Filters RFFN[3:0] Number of Rx FIFO filters Message Buffers
 * occupied by Rx FIFO and ID Filter Table Remaining Available Mailboxes The
 * number of the last remaining available mailboxes is defined by the MCR[MAXMB]
 * field. Rx FIFO ID Filter Table Elements Affected by Rx Individual Masks If Rx
 * Individual Mask Registers are not enabled then all Rx FIFO filters are affected by
 * the Rx FIFO Global Mask. Rx FIFO ID Filter Table Elements Affected by Rx FIFO
 * Global Mask 0x0 8 MB 0-7 MB 8-63 Elements 0-7 none 0x1 16 MB 0-9 MB 10-63
 * Elements 0-9 Elements 10-15 0x2 24 MB 0-11 MB 12-63 Elements 0-11 Elements 12-23
 * 0x3 32 MB 0-13 MB 14-63 Elements 0-13 Elements 14-31 0x4 40 MB 0-15 MB 16-63
 * Elements 0-15 Elements 16-39 0x5 48 MB 0-17 MB 18-63 Elements 0-17 Elements
 * 18-47 0x6 56 MB 0-19 MB 20-63 Elements 0-19 Elements 20-55 0x7 64 MB 0-21 MB 22-63
 * Elements 0-21 Elements 22-63 0x8 72 MB 0-23 MB 24-63 Elements 0-23 Elements
 * 24-71 0x9 80 MB 0-25 MB 26-63 Elements 0-25 Elements 26-79 0xA 88 MB 0-27 MB
 * 28-63 Elements 0-27 Elements 28-87 0xB 96 MB 0-29 MB 30-63 Elements 0-29
 * Elements 30-95 0xC 104 MB 0-31 MB 32-63 Elements 0-31 Elements 32-103 0xD 112 MB 0-33
 * MB 34-63 Elements 0-31 Elements 32-111 0xE 120 MB 0-35 MB 36-63 Elements 0-31
 * Elements 32-119 0xF 128 MB 0-37 MB 38-63 Elements 0-31 Elements 32-127 Each
 * group of eight filters occupies a memory space equivalent to two Message
 * Buffers which means that the more filters are implemented the less Mailboxes will be
 * available. Considering that the Rx FIFO occupies the memory space originally
 * reserved for MB0-5, RFFN should be programmed with a value corresponding to a
 * number of filters not greater than the number of available memory words which
 * can be calculated as follows: where SETUP_MB is MAXMB. The number of remaining
 * Mailboxes available will be: If the Number of Rx FIFO Filters programmed
 * through RFFN exceeds the SETUP_MB value, the exceeding ones will not be
 * functional.Unshaded regions in indicate the valid combinations of MAXMB, RFEN and RFFN,
 * shaded regions are not functional. Valid Combinations of MAXMB, RFEN and RFFN
 * RFFN 0 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 RFEN 0 1 1 1 1 1 1 1 1 1 1 1 1 1
 * 1 1 1 MAXMB 0 - 6 7 - 8 9 - 10 11 - 12 13 -14 15 - 16 17 -18 19 - 20 21 - 22
 * 23 - 24 25 - 26 27 - 28 29 -30 31 - 32 33 - 34 35 - 36 37 - 63
 */
typedef union _hw_can_ctrl2
{
    uint32_t U;
    struct _hw_can_ctrl2_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t EACEN : 1;            /*!< [16]  */
        uint32_t RRS : 1;              /*!< [17]  */
        uint32_t MRP : 1;              /*!< [18]  */
        uint32_t TASD : 5;             /*!< [23:19]  */
        uint32_t RFFN : 4;             /*!< [27:24]  */
        uint32_t WRMFRZ : 1;           /*!< [28]  */
        uint32_t RESERVED1 : 3;        /*!< [31:29]  */
    } B;
} hw_can_ctrl2_t;

/*!
 * @name Constants and macros for entire CAN_CTRL2 register
 */
/*@{*/
#define HW_CAN_CTRL2_ADDR(x)     ((uintptr_t)(x) + 0x34U)

#define HW_CAN_CTRL2(x)          (*(__IO hw_can_ctrl2_t *) HW_CAN_CTRL2_ADDR(x))
#define HW_CAN_CTRL2_RD(x)       (HW_CAN_CTRL2(x).U)
#define HW_CAN_CTRL2_WR(x, v)    (HW_CAN_CTRL2(x).U = (v))
#define HW_CAN_CTRL2_SET(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) |  (v)))
#define HW_CAN_CTRL2_CLR(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) & ~(v)))
#define HW_CAN_CTRL2_TOG(x, v)   (HW_CAN_CTRL2_WR(x, HW_CAN_CTRL2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL2 bitfields
 */

/*!
 * @name Register CAN_CTRL2, field EACEN[16] (RW)
 *
 * This bit controls the comparison of IDE and RTR bits within Rx Mailboxes
 * filters with their corresponding bits in the incoming frame by the matching
 * process. This bit does not affect matching for Rx FIFO. This bit can only be written
 * in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Enables the comparison of both Rx Mailbox filter's IDE and RTR bit with
 *     their corresponding bits within the incoming frame. Mask bits do apply.
 * - 0 - Rx Mailbox filter's IDE bit is always compared and RTR is never
 *     compared despite mask bits.
 */
/*@{*/
#define BP_CAN_CTRL2_EACEN   (16U)         /*!< Bit position for CAN_CTRL2_EACEN. */
#define BM_CAN_CTRL2_EACEN   (0x00010000U) /*!< Bit mask for CAN_CTRL2_EACEN. */
#define BS_CAN_CTRL2_EACEN   (1U)          /*!< Bit field size in bits for CAN_CTRL2_EACEN. */

/*! @brief Read current value of the CAN_CTRL2_EACEN field. */
#define BR_CAN_CTRL2_EACEN(x) (HW_CAN_CTRL2(x).B.EACEN)

/*! @brief Format value for bitfield CAN_CTRL2_EACEN. */
#define BF_CAN_CTRL2_EACEN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_EACEN) & BM_CAN_CTRL2_EACEN)

/*! @brief Set the EACEN field to a new value. */
#define BW_CAN_CTRL2_EACEN(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_EACEN) | BF_CAN_CTRL2_EACEN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RRS[17] (RW)
 *
 * If this bit is asserted Remote Request Frame is submitted to a matching
 * process and stored in the corresponding Message Buffer in the same fashion of a
 * Data Frame. No automatic Remote Response Frame will be generated. If this bit is
 * negated the Remote Request Frame is submitted to a matching process and an
 * automatic Remote Response Frame is generated if a Message Buffer with CODE=0b1010
 * is found with the same ID. This bit can only be written in Freeze mode as it
 * is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Remote Request Frame is stored
 * - 0 - Remote Response Frame is generated
 */
/*@{*/
#define BP_CAN_CTRL2_RRS     (17U)         /*!< Bit position for CAN_CTRL2_RRS. */
#define BM_CAN_CTRL2_RRS     (0x00020000U) /*!< Bit mask for CAN_CTRL2_RRS. */
#define BS_CAN_CTRL2_RRS     (1U)          /*!< Bit field size in bits for CAN_CTRL2_RRS. */

/*! @brief Read current value of the CAN_CTRL2_RRS field. */
#define BR_CAN_CTRL2_RRS(x)  (HW_CAN_CTRL2(x).B.RRS)

/*! @brief Format value for bitfield CAN_CTRL2_RRS. */
#define BF_CAN_CTRL2_RRS(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RRS) & BM_CAN_CTRL2_RRS)

/*! @brief Set the RRS field to a new value. */
#define BW_CAN_CTRL2_RRS(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_RRS) | BF_CAN_CTRL2_RRS(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field MRP[18] (RW)
 *
 * If this bit is set the matching process starts from the Mailboxes and if no
 * match occurs the matching continues on the Rx FIFO. This bit can only be
 * written in Freeze mode as it is blocked by hardware in other modes.
 *
 * Values:
 * - 1 - Matching starts from Mailboxes and continues on Rx FIFO
 * - 0 - Matching starts from Rx FIFO and continues on Mailboxes
 */
/*@{*/
#define BP_CAN_CTRL2_MRP     (18U)         /*!< Bit position for CAN_CTRL2_MRP. */
#define BM_CAN_CTRL2_MRP     (0x00040000U) /*!< Bit mask for CAN_CTRL2_MRP. */
#define BS_CAN_CTRL2_MRP     (1U)          /*!< Bit field size in bits for CAN_CTRL2_MRP. */

/*! @brief Read current value of the CAN_CTRL2_MRP field. */
#define BR_CAN_CTRL2_MRP(x)  (HW_CAN_CTRL2(x).B.MRP)

/*! @brief Format value for bitfield CAN_CTRL2_MRP. */
#define BF_CAN_CTRL2_MRP(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_MRP) & BM_CAN_CTRL2_MRP)

/*! @brief Set the MRP field to a new value. */
#define BW_CAN_CTRL2_MRP(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_MRP) | BF_CAN_CTRL2_MRP(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field TASD[23:19] (RW)
 *
 * This 5-bit field indicates how many CAN bits the Tx arbitration process start
 * point can be delayed from the first bit of CRC field on CAN bus. This field
 * can only be written in Freeze mode as it is blocked by hardware in other modes.
 * This field is useful to optimize the transmit performance based on factors
 * such as: peripheral/serial clock ratio, CAN bit timing and number of MBs. The
 * duration of an arbitration process, in terms of CAN bits, is directly
 * proportional to the number of available MBs and CAN baud rate and inversely proportional
 * to the peripheral clock frequency. The optimal arbitration timing is that in
 * which the last MB is scanned right before the first bit of the Intermission
 * field of a CAN frame. Therefore, if there are few MBs and the system/serial
 * clock ratio is high and the CAN baud rate is low then the arbitration can be
 * delayed and vice-versa. If TASD is 0 then the arbitration start is not delayed,
 * thus ARM has less time to configure a Tx MB for the next arbitration, but more
 * time is reserved for arbitration. In the other hand, if TASD is 24 then ARM can
 * configure a Tx MB later and less time is reserved for arbitration. If too
 * little time is reserved for arbitration the FlexCAN may be not able to find winner
 * MBs in time to compete with other nodes for the CAN bus. If the arbitration
 * ends too much time before the first bit of Intermission field then there is a
 * chance that ARM reconfigure some Tx MBs and the winner MB is not the best to be
 * transmitted. The reset value is different on various platforms, according to
 * their peripheral clock frequency, number of MBs and target CAN baud rate. The
 * optimal configuration for TASD can be calculated as: where: fCANCLK is the
 * Protocol Engine (PE) Clock in Hz; PE clock is derrived from CAN_CLK_ROOT in CCM.
 * See Clock Root GeneratorThe Clock Root Generator (CCM_CLK_ROOT_GEN) sub-module
 * generates the root clocks to be delivered to LPCG. fSYS is the peripheral
 * clock in Hz; MAXMB is the value in CTRL1[MAXMB] field; RFEN is the value in
 * CTRL1[RFEN] bit; RFFN is the value in CTRL2[RFFN] field; PSEG1 is the value in
 * CTRL1[PSEG1] field; PSEG2 is the value in CTRL1[PSEG2] field; PROPSEG is the value
 * in CTRL1[PROPSEG] field; PRESDIV is the value in CTRL1[PRESDIV] field. Please
 * refer to Arbitration processThe arbitration process scans the Mailboxes
 * searching the Tx one that holds the message to be sent in the next opportunity.
 * This Mailbox is called the arbitration winner. and Protocol Timing for more
 * details.
 */
/*@{*/
#define BP_CAN_CTRL2_TASD    (19U)         /*!< Bit position for CAN_CTRL2_TASD. */
#define BM_CAN_CTRL2_TASD    (0x00F80000U) /*!< Bit mask for CAN_CTRL2_TASD. */
#define BS_CAN_CTRL2_TASD    (5U)          /*!< Bit field size in bits for CAN_CTRL2_TASD. */

/*! @brief Read current value of the CAN_CTRL2_TASD field. */
#define BR_CAN_CTRL2_TASD(x) (HW_CAN_CTRL2(x).B.TASD)

/*! @brief Format value for bitfield CAN_CTRL2_TASD. */
#define BF_CAN_CTRL2_TASD(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_TASD) & BM_CAN_CTRL2_TASD)

/*! @brief Set the TASD field to a new value. */
#define BW_CAN_CTRL2_TASD(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_TASD) | BF_CAN_CTRL2_TASD(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RFFN[27:24] (RW)
 *
 * This 4-bit field defines the number of Rx FIFO filters according to . The
 * maximum selectable number of filters is determined by the ARM. This field can
 * only be written in Freeze mode as it is blocked by hardware in other modes. RFFN
 * defines a number of Message Buffers occupied by Rx FIFO and ID Filter (see )
 * that may not e xceed the number of available Mailboxes present in module,
 * defined by MCR[MAXMB].Default RFFN value is 0x0, which leads to a total of 8 Rx
 * FIFO filters, occupies the first 8 Message Buffers (MB 0-7) and makes available
 * the next Message Buffers (MB 8-63) for Mailboxes. As a second example, when
 * RFFN is set to 0xD, there will be 112 Rx FIFO filters, located in MB 0-33, and MB
 * 34-63 are available for Mailboxes. Notice that, in this case, individual
 * masks (RXIMR) will just cover Rx FIFO filters in 0-31 range, and filters 32-111
 * will use RXFGMASK. In case of reducing the number of last Message Buffers,
 * MCR[MAXMB] (see MCRModule Configuration Register ) can be adjusted by the
 * application to minimum of 33, in order to give room to the Rx FIFO and its ID Filter
 * Table defined by RFFN. On the contrary, if the application sets MCR[MAXMB] to
 * 16, for instance, the maximum RFFN is limited to 0x4. RFFN also impacts the
 * definition of the minimum number of peripheral clocks per CAN bit as described in
 * (see Arbitration and Matching Timing).
 */
/*@{*/
#define BP_CAN_CTRL2_RFFN    (24U)         /*!< Bit position for CAN_CTRL2_RFFN. */
#define BM_CAN_CTRL2_RFFN    (0x0F000000U) /*!< Bit mask for CAN_CTRL2_RFFN. */
#define BS_CAN_CTRL2_RFFN    (4U)          /*!< Bit field size in bits for CAN_CTRL2_RFFN. */

/*! @brief Read current value of the CAN_CTRL2_RFFN field. */
#define BR_CAN_CTRL2_RFFN(x) (HW_CAN_CTRL2(x).B.RFFN)

/*! @brief Format value for bitfield CAN_CTRL2_RFFN. */
#define BF_CAN_CTRL2_RFFN(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_RFFN) & BM_CAN_CTRL2_RFFN)

/*! @brief Set the RFFN field to a new value. */
#define BW_CAN_CTRL2_RFFN(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_RFFN) | BF_CAN_CTRL2_RFFN(v)))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field WRMFRZ[28] (RW)
 *
 * Enable unrestricted write access to FlexCAN memory in Freeze mode. This bit
 * can only be written in Freeze mode and has no effect out of Freeze mode.
 *
 * Values:
 * - 1 - Enable unrestricted write access to FlexCAN memory
 * - 0 - Keep the write access restricted in some regions of FlexCAN memory
 */
/*@{*/
#define BP_CAN_CTRL2_WRMFRZ  (28U)         /*!< Bit position for CAN_CTRL2_WRMFRZ. */
#define BM_CAN_CTRL2_WRMFRZ  (0x10000000U) /*!< Bit mask for CAN_CTRL2_WRMFRZ. */
#define BS_CAN_CTRL2_WRMFRZ  (1U)          /*!< Bit field size in bits for CAN_CTRL2_WRMFRZ. */

/*! @brief Read current value of the CAN_CTRL2_WRMFRZ field. */
#define BR_CAN_CTRL2_WRMFRZ(x) (HW_CAN_CTRL2(x).B.WRMFRZ)

/*! @brief Format value for bitfield CAN_CTRL2_WRMFRZ. */
#define BF_CAN_CTRL2_WRMFRZ(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CTRL2_WRMFRZ) & BM_CAN_CTRL2_WRMFRZ)

/*! @brief Set the WRMFRZ field to a new value. */
#define BW_CAN_CTRL2_WRMFRZ(x, v) (HW_CAN_CTRL2_WR(x, (HW_CAN_CTRL2_RD(x) & ~BM_CAN_CTRL2_WRMFRZ) | BF_CAN_CTRL2_WRMFRZ(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_ESR2 - Error and Status 2 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_ESR2 - Error and Status 2 Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various interrupt flags and some general status.
 */
typedef union _hw_can_esr2
{
    uint32_t U;
    struct _hw_can_esr2_bitfields
    {
        uint32_t RESERVED0 : 13;       /*!< [12:0]  */
        uint32_t IMB : 1;              /*!< [13]  */
        uint32_t VPS : 1;              /*!< [14]  */
        uint32_t RESERVED1 : 1;        /*!< [15]  */
        uint32_t LPTM : 7;             /*!< [22:16]  */
        uint32_t RESERVED2 : 9;        /*!< [31:23]  */
    } B;
} hw_can_esr2_t;

/*!
 * @name Constants and macros for entire CAN_ESR2 register
 */
/*@{*/
#define HW_CAN_ESR2_ADDR(x)      ((uintptr_t)(x) + 0x38U)

#define HW_CAN_ESR2(x)           (*(__I hw_can_esr2_t *) HW_CAN_ESR2_ADDR(x))
#define HW_CAN_ESR2_RD(x)        (HW_CAN_ESR2(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_ESR2 bitfields
 */

/*!
 * @name Register CAN_ESR2, field IMB[13] (RO)
 *
 * If ESR2[VPS] is asserted, this bit indicates whether there is any inactive
 * Mailbox (CODE field is either 0b1000 or 0b0000). This bit is asserted in the
 * following cases: (1) During arbitration, if a LPTM is found and it is inactive.
 * (2) If IMB is not asserted and a frame is transmitted successfully. (3) This
 * bit is cleared in all start of arbitration (see Arbitration processThe
 * arbitration process scans the Mailboxes searching the Tx one that holds the message to
 * be sent in the next opportunity. This Mailbox is called the arbitration
 * winner. ). LPTM mechanism have the following behavior: if a MB is successfully
 * transmitted and ESR2[IMB]=0 (no inactive Mailbox), then ESR2[VPS] and ESR2[IMB] are
 * asserted and the index related to the MB just transmitted is loaded into
 * ESR2[LPTM].
 *
 * Values:
 * - 1 - If ESR2[VPS] is asserted, there is at least one inactive Mailbox. LPTM
 *     content is the number of the first one.
 * - 0 - If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
 */
/*@{*/
#define BP_CAN_ESR2_IMB      (13U)         /*!< Bit position for CAN_ESR2_IMB. */
#define BM_CAN_ESR2_IMB      (0x00002000U) /*!< Bit mask for CAN_ESR2_IMB. */
#define BS_CAN_ESR2_IMB      (1U)          /*!< Bit field size in bits for CAN_ESR2_IMB. */

/*! @brief Read current value of the CAN_ESR2_IMB field. */
#define BR_CAN_ESR2_IMB(x)   (HW_CAN_ESR2(x).B.IMB)
/*@}*/

/*!
 * @name Register CAN_ESR2, field VPS[14] (RO)
 *
 * This bit indicates whether IMB and LPTM contents are currently valid or not.
 * VPS is asserted upon every complete Tx arbitration process unless the ARM
 * writes to Control and Status word of a Mailbox that has already been scanned (i.e.
 * it is behind Tx Arbitration Pointer) during the Tx arbitration process. If
 * there is no inactive Mailbox and only one Tx Mailbox which is being transmitted
 * then VPS is not asserted. VPS is negated upon the start of every Tx
 * arbitration process or upon a write to Control and Status word of any Mailbox.ESR2[VPS]
 * is not affected by any ARM write into Control Status (C/S) of a MB which is
 * blocked by abort mechanism. When MCR[AEN] is asserted, the abort code write in
 * C/S of a MB that is been transmitted (pending abort), or any write attempt into
 * a Tx MB with IFLAG set is blocked.
 *
 * Values:
 * - 1 - Contents of IMB and LPTM are valid
 * - 0 - Contents of IMB and LPTM are invalid
 */
/*@{*/
#define BP_CAN_ESR2_VPS      (14U)         /*!< Bit position for CAN_ESR2_VPS. */
#define BM_CAN_ESR2_VPS      (0x00004000U) /*!< Bit mask for CAN_ESR2_VPS. */
#define BS_CAN_ESR2_VPS      (1U)          /*!< Bit field size in bits for CAN_ESR2_VPS. */

/*! @brief Read current value of the CAN_ESR2_VPS field. */
#define BR_CAN_ESR2_VPS(x)   (HW_CAN_ESR2(x).B.VPS)
/*@}*/

/*!
 * @name Register CAN_ESR2, field LPTM[22:16] (RO)
 *
 * If ESR2[VPS] is asserted, his 7-bit field indicates the lowest number
 * inactive Mailbox (refer to IMB bit description). If there is no inactive Mailbox then
 * the Mailbox indicated depends on CTRL1[LBUF] bit value. If CTRL1[LBUF] bit is
 * negated then the Mailbox indicated is the one which has the greatest
 * arbitration value (see Highest Mailbox priority firstIf CTRL1[LBUF] bit is negated
 * then the arbitration process searches the active Tx Mailbox with the highest
 * priority, and this Mailbox would have a higher probability to win the arbitration
 * on CAN bus. ). If CTRL1[LBUF] bit is asserted then the Mailbox indicated is
 * the highest number active Tx Mailbox. If a Tx Mailbox is being transmitted it is
 * not considered in LPTM calculation. If ESR2[IMB] is not asserted and a frame
 * is transmitted successfully, LPTM is updated with its Mailbox number.
 */
/*@{*/
#define BP_CAN_ESR2_LPTM     (16U)         /*!< Bit position for CAN_ESR2_LPTM. */
#define BM_CAN_ESR2_LPTM     (0x007F0000U) /*!< Bit mask for CAN_ESR2_LPTM. */
#define BS_CAN_ESR2_LPTM     (7U)          /*!< Bit field size in bits for CAN_ESR2_LPTM. */

/*! @brief Read current value of the CAN_ESR2_LPTM field. */
#define BR_CAN_ESR2_LPTM(x)  (HW_CAN_ESR2(x).B.LPTM)
/*@}*/

/*******************************************************************************
 * HW_CAN_CRCR - CRC Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CRCR - CRC Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register provides information about the CRC of transmitted messages
 */
typedef union _hw_can_crcr
{
    uint32_t U;
    struct _hw_can_crcr_bitfields
    {
        uint32_t TXCRC : 15;           /*!< [14:0]  */
        uint32_t RESERVED0 : 1;        /*!< [15]  */
        uint32_t MBCRC : 7;            /*!< [22:16]  */
        uint32_t RESERVED1 : 9;        /*!< [31:23]  */
    } B;
} hw_can_crcr_t;

/*!
 * @name Constants and macros for entire CAN_CRCR register
 */
/*@{*/
#define HW_CAN_CRCR_ADDR(x)      ((uintptr_t)(x) + 0x44U)

#define HW_CAN_CRCR(x)           (*(__I hw_can_crcr_t *) HW_CAN_CRCR_ADDR(x))
#define HW_CAN_CRCR_RD(x)        (HW_CAN_CRCR(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_CRCR bitfields
 */

/*!
 * @name Register CAN_CRCR, field TXCRC[14:0] (RO)
 *
 * This field indicates the CRC value of the last message transmitted. This
 * field is updated at the same time the Tx Interrupt Flag is asserted.
 */
/*@{*/
#define BP_CAN_CRCR_TXCRC    (0U)          /*!< Bit position for CAN_CRCR_TXCRC. */
#define BM_CAN_CRCR_TXCRC    (0x00007FFFU) /*!< Bit mask for CAN_CRCR_TXCRC. */
#define BS_CAN_CRCR_TXCRC    (15U)         /*!< Bit field size in bits for CAN_CRCR_TXCRC. */

/*! @brief Read current value of the CAN_CRCR_TXCRC field. */
#define BR_CAN_CRCR_TXCRC(x) (HW_CAN_CRCR(x).B.TXCRC)
/*@}*/

/*!
 * @name Register CAN_CRCR, field MBCRC[22:16] (RO)
 *
 * This field indicates the number of the Mailbox corresponding to the value in
 * TXCRC field.
 */
/*@{*/
#define BP_CAN_CRCR_MBCRC    (16U)         /*!< Bit position for CAN_CRCR_MBCRC. */
#define BM_CAN_CRCR_MBCRC    (0x007F0000U) /*!< Bit mask for CAN_CRCR_MBCRC. */
#define BS_CAN_CRCR_MBCRC    (7U)          /*!< Bit field size in bits for CAN_CRCR_MBCRC. */

/*! @brief Read current value of the CAN_CRCR_MBCRC field. */
#define BR_CAN_CRCR_MBCRC(x) (HW_CAN_CRCR(x).B.MBCRC)
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFGMASK - Rx FIFO Global Mask Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFGMASK - Rx FIFO Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * If Rx FIFO is enabled RXFGMASK is used to mask the Rx FIFO ID Filter Table
 * elements that do not have a corresponding RXIMR according to CTRL2[RFFN] field
 * setting. This register can only be written in Freeze Mode as it is blocked by
 * hardware in other modes. Rx FIFO Global Mask usage Rx FIFO ID Filter Table
 * Elements Format (MCR[IDAM]) Identifier Acceptance Filter fields RTR IDE RXIDA
 * RXIDB RXIDC reserved A FGM[31] FGM[30] FGM[29:1] - - FGM[0] B FGM[31] FGM[15]
 * FGM[30] FGM[14] - FGM[29:16] FGM[13:0] If MCR[IDAM] field is equivalent to the
 * format B only the fourteen most significant bits of the Identifier of the
 * incoming frame are compared with the Rx FIFO filter. - C - - - FGM[31:24] FGM[23:16]
 * FGM[15:8] FGM[7:0] If MCR[IDAM] field is equivalent to the format C only the
 * eight most significant bits of the Identifier of the incoming frame are
 * compared with the Rx FIFO filter.
 */
typedef union _hw_can_rxfgmask
{
    uint32_t U;
    struct _hw_can_rxfgmask_bitfields
    {
        uint32_t FGM31_FGM0 : 32;      /*!< [31:0]  */
    } B;
} hw_can_rxfgmask_t;

/*!
 * @name Constants and macros for entire CAN_RXFGMASK register
 */
/*@{*/
#define HW_CAN_RXFGMASK_ADDR(x)  ((uintptr_t)(x) + 0x48U)

#define HW_CAN_RXFGMASK(x)       (*(__IO hw_can_rxfgmask_t *) HW_CAN_RXFGMASK_ADDR(x))
#define HW_CAN_RXFGMASK_RD(x)    (HW_CAN_RXFGMASK(x).U)
#define HW_CAN_RXFGMASK_WR(x, v) (HW_CAN_RXFGMASK(x).U = (v))
#define HW_CAN_RXFGMASK_SET(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) |  (v)))
#define HW_CAN_RXFGMASK_CLR(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) & ~(v)))
#define HW_CAN_RXFGMASK_TOG(x, v) (HW_CAN_RXFGMASK_WR(x, HW_CAN_RXFGMASK_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXFGMASK bitfields
 */

/*!
 * @name Register CAN_RXFGMASK, field FGM31_FGM0[31:0] (RW)
 *
 * These bits mask the ID Filter Table elements bits in a perfect
 * alignment.RXFGMASKRx FIFO Global Mask Register shows in detail which FGM bits mask each IDAF
 * field. Clear this register has the effect of disabling the ID Filter.
 *
 * Values:
 * - 1 - The corresponding bit in the filter is checked
 * - 0 - The corresponding bit in the filter is "don't care"
 */
/*@{*/
#define BP_CAN_RXFGMASK_FGM31_FGM0 (0U)    /*!< Bit position for CAN_RXFGMASK_FGM31_FGM0. */
#define BM_CAN_RXFGMASK_FGM31_FGM0 (0xFFFFFFFFU) /*!< Bit mask for CAN_RXFGMASK_FGM31_FGM0. */
#define BS_CAN_RXFGMASK_FGM31_FGM0 (32U)   /*!< Bit field size in bits for CAN_RXFGMASK_FGM31_FGM0. */

/*! @brief Read current value of the CAN_RXFGMASK_FGM31_FGM0 field. */
#define BR_CAN_RXFGMASK_FGM31_FGM0(x) (HW_CAN_RXFGMASK(x).U)

/*! @brief Format value for bitfield CAN_RXFGMASK_FGM31_FGM0. */
#define BF_CAN_RXFGMASK_FGM31_FGM0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_RXFGMASK_FGM31_FGM0) & BM_CAN_RXFGMASK_FGM31_FGM0)

/*! @brief Set the FGM31_FGM0 field to a new value. */
#define BW_CAN_RXFGMASK_FGM31_FGM0(x, v) (HW_CAN_RXFGMASK_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXFIR - Rx FIFO Information Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXFIR - Rx FIFO Information Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * RXFIR provides information on Rx FIFO. This register is the port through
 * which ARM accesses the output of the RXFIR FIFO located in RAM. The RXFIR FIFO is
 * written by the FlexCAN whenever a new message is moved into the Rx FIFO as
 * well as its output is updated whenever the output of the Rx FIFO is updated with
 * the next message. Refer to Rx FIFOThe receive-only FIFO is enabled by
 * asserting the RFEN bit in the MCR. to find instructions on reading this register.
 */
typedef union _hw_can_rxfir
{
    uint32_t U;
    struct _hw_can_rxfir_bitfields
    {
        uint32_t IDHIT : 9;            /*!< [8:0]  */
        uint32_t RESERVED0 : 23;       /*!< [31:9]  */
    } B;
} hw_can_rxfir_t;

/*!
 * @name Constants and macros for entire CAN_RXFIR register
 */
/*@{*/
#define HW_CAN_RXFIR_ADDR(x)     ((uintptr_t)(x) + 0x4CU)

#define HW_CAN_RXFIR(x)          (*(__I hw_can_rxfir_t *) HW_CAN_RXFIR_ADDR(x))
#define HW_CAN_RXFIR_RD(x)       (HW_CAN_RXFIR(x).U)
/*@}*/

/*
 * Constants & macros for individual CAN_RXFIR bitfields
 */

/*!
 * @name Register CAN_RXFIR, field IDHIT[8:0] (RO)
 *
 * This 9-bit field indicates which Identifier Acceptance Filter (see Rx FIFO
 * StructureWhen the MCR[RFEN] bit is set, the memory area from $80 to $DC (which
 * is normally occupied by MBs 0 to 5) is used by the reception FIFO engine. ) was
 * hit by the received message that is in the output of the Rx FIFO. (refer to
 * Rx FIFOThe receive-only FIFO is enabled by asserting the RFEN bit in the MCR.
 * for details) If multiple filters match the incoming message ID then the first
 * matching IDAF found (lowest number) by the matching process is indicated. This
 * field is valid only while the IFLAG[BUF5I] is asserted.
 */
/*@{*/
#define BP_CAN_RXFIR_IDHIT   (0U)          /*!< Bit position for CAN_RXFIR_IDHIT. */
#define BM_CAN_RXFIR_IDHIT   (0x000001FFU) /*!< Bit mask for CAN_RXFIR_IDHIT. */
#define BS_CAN_RXFIR_IDHIT   (9U)          /*!< Bit field size in bits for CAN_RXFIR_IDHIT. */

/*! @brief Read current value of the CAN_RXFIR_IDHIT field. */
#define BR_CAN_RXFIR_IDHIT(x) (HW_CAN_RXFIR(x).B.IDHIT)
/*@}*/

/*******************************************************************************
 * HW_CAN_CSn - Message Buffer 0 CS Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_CSn - Message Buffer 0 CS Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_csn
{
    uint32_t U;
    struct _hw_can_csn_bitfields
    {
        uint32_t TIME_STAMP : 16;      /*!< [15:0] Free-Running Counter Time
                                        * stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx
                                        * and Rx frames at the time when the beginning of the Identifier field
                                        * appears on the CAN bus. */
        uint32_t DLC : 4;              /*!< [19:16] Length of the data to be
                                        * stored/transmitted. */
        uint32_t RTR : 1;              /*!< [20] Remote Transmission Request. One/zero for
                                        * remote/data frame. */
        uint32_t IDE : 1;              /*!< [21] ID Extended. One/zero for
                                        * extended/standard format frame. */
        uint32_t SRR : 1;              /*!< [22] Substitute Remote Request. Contains a
                                        * fixed recessive bit. */
        uint32_t RESERVED0 : 1;        /*!< [23] Reserved */
        uint32_t CODE : 4;             /*!< [27:24] Reserved */
        uint32_t RESERVED1 : 4;        /*!< [31:28] Reserved */
    } B;
} hw_can_csn_t;

/*!
 * @name Constants and macros for entire CAN_CSn register
 */
/*@{*/
#define HW_CAN_CSn_COUNT (64U)

#define HW_CAN_CSn_ADDR(x, n)    ((uintptr_t)(x) + 0x80U + (0x10U * (n)))

#define HW_CAN_CSn(x, n)         (*(__IO hw_can_csn_t *) HW_CAN_CSn_ADDR(x, n))
#define HW_CAN_CSn_RD(x, n)      (HW_CAN_CSn(x, n).U)
#define HW_CAN_CSn_WR(x, n, v)   (HW_CAN_CSn(x, n).U = (v))
#define HW_CAN_CSn_SET(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) |  (v)))
#define HW_CAN_CSn_CLR(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) & ~(v)))
#define HW_CAN_CSn_TOG(x, n, v)  (HW_CAN_CSn_WR(x, n, HW_CAN_CSn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_CSn bitfields
 */

/*!
 * @name Register CAN_CSn, field TIME_STAMP[15:0] (RW)
 */
/*@{*/
#define BP_CAN_CSn_TIME_STAMP (0U)         /*!< Bit position for CAN_CSn_TIME_STAMP. */
#define BM_CAN_CSn_TIME_STAMP (0x0000FFFFU) /*!< Bit mask for CAN_CSn_TIME_STAMP. */
#define BS_CAN_CSn_TIME_STAMP (16U)        /*!< Bit field size in bits for CAN_CSn_TIME_STAMP. */

/*! @brief Read current value of the CAN_CSn_TIME_STAMP field. */
#define BR_CAN_CSn_TIME_STAMP(x, n) (HW_CAN_CSn(x, n).B.TIME_STAMP)

/*! @brief Format value for bitfield CAN_CSn_TIME_STAMP. */
#define BF_CAN_CSn_TIME_STAMP(v) ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_TIME_STAMP) & BM_CAN_CSn_TIME_STAMP)

/*! @brief Set the TIME_STAMP field to a new value. */
#define BW_CAN_CSn_TIME_STAMP(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_TIME_STAMP) | BF_CAN_CSn_TIME_STAMP(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field DLC[19:16] (RW)
 */
/*@{*/
#define BP_CAN_CSn_DLC       (16U)         /*!< Bit position for CAN_CSn_DLC. */
#define BM_CAN_CSn_DLC       (0x000F0000U) /*!< Bit mask for CAN_CSn_DLC. */
#define BS_CAN_CSn_DLC       (4U)          /*!< Bit field size in bits for CAN_CSn_DLC. */

/*! @brief Read current value of the CAN_CSn_DLC field. */
#define BR_CAN_CSn_DLC(x, n) (HW_CAN_CSn(x, n).B.DLC)

/*! @brief Format value for bitfield CAN_CSn_DLC. */
#define BF_CAN_CSn_DLC(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_DLC) & BM_CAN_CSn_DLC)

/*! @brief Set the DLC field to a new value. */
#define BW_CAN_CSn_DLC(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_DLC) | BF_CAN_CSn_DLC(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field RTR[20] (RW)
 */
/*@{*/
#define BP_CAN_CSn_RTR       (20U)         /*!< Bit position for CAN_CSn_RTR. */
#define BM_CAN_CSn_RTR       (0x00100000U) /*!< Bit mask for CAN_CSn_RTR. */
#define BS_CAN_CSn_RTR       (1U)          /*!< Bit field size in bits for CAN_CSn_RTR. */

/*! @brief Read current value of the CAN_CSn_RTR field. */
#define BR_CAN_CSn_RTR(x, n) (HW_CAN_CSn(x, n).B.RTR)

/*! @brief Format value for bitfield CAN_CSn_RTR. */
#define BF_CAN_CSn_RTR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_RTR) & BM_CAN_CSn_RTR)

/*! @brief Set the RTR field to a new value. */
#define BW_CAN_CSn_RTR(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_RTR) | BF_CAN_CSn_RTR(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field IDE[21] (RW)
 */
/*@{*/
#define BP_CAN_CSn_IDE       (21U)         /*!< Bit position for CAN_CSn_IDE. */
#define BM_CAN_CSn_IDE       (0x00200000U) /*!< Bit mask for CAN_CSn_IDE. */
#define BS_CAN_CSn_IDE       (1U)          /*!< Bit field size in bits for CAN_CSn_IDE. */

/*! @brief Read current value of the CAN_CSn_IDE field. */
#define BR_CAN_CSn_IDE(x, n) (HW_CAN_CSn(x, n).B.IDE)

/*! @brief Format value for bitfield CAN_CSn_IDE. */
#define BF_CAN_CSn_IDE(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_IDE) & BM_CAN_CSn_IDE)

/*! @brief Set the IDE field to a new value. */
#define BW_CAN_CSn_IDE(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_IDE) | BF_CAN_CSn_IDE(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field SRR[22] (RW)
 */
/*@{*/
#define BP_CAN_CSn_SRR       (22U)         /*!< Bit position for CAN_CSn_SRR. */
#define BM_CAN_CSn_SRR       (0x00400000U) /*!< Bit mask for CAN_CSn_SRR. */
#define BS_CAN_CSn_SRR       (1U)          /*!< Bit field size in bits for CAN_CSn_SRR. */

/*! @brief Read current value of the CAN_CSn_SRR field. */
#define BR_CAN_CSn_SRR(x, n) (HW_CAN_CSn(x, n).B.SRR)

/*! @brief Format value for bitfield CAN_CSn_SRR. */
#define BF_CAN_CSn_SRR(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_SRR) & BM_CAN_CSn_SRR)

/*! @brief Set the SRR field to a new value. */
#define BW_CAN_CSn_SRR(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_SRR) | BF_CAN_CSn_SRR(v)))
/*@}*/

/*!
 * @name Register CAN_CSn, field CODE[27:24] (RW)
 */
/*@{*/
#define BP_CAN_CSn_CODE      (24U)         /*!< Bit position for CAN_CSn_CODE. */
#define BM_CAN_CSn_CODE      (0x0F000000U) /*!< Bit mask for CAN_CSn_CODE. */
#define BS_CAN_CSn_CODE      (4U)          /*!< Bit field size in bits for CAN_CSn_CODE. */

/*! @brief Read current value of the CAN_CSn_CODE field. */
#define BR_CAN_CSn_CODE(x, n) (HW_CAN_CSn(x, n).B.CODE)

/*! @brief Format value for bitfield CAN_CSn_CODE. */
#define BF_CAN_CSn_CODE(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_CSn_CODE) & BM_CAN_CSn_CODE)

/*! @brief Set the CODE field to a new value. */
#define BW_CAN_CSn_CODE(x, n, v) (HW_CAN_CSn_WR(x, n, (HW_CAN_CSn_RD(x, n) & ~BM_CAN_CSn_CODE) | BF_CAN_CSn_CODE(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_IDn - Message Buffer 0 ID Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_IDn - Message Buffer 0 ID Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_idn
{
    uint32_t U;
    struct _hw_can_idn_bitfields
    {
        uint32_t EXT : 18;             /*!< [17:0] Contains extended (LOW word)
                                        * identifier of message buffer. */
        uint32_t STD : 11;             /*!< [28:18] Contains standard/extended (HIGH
                                        * word) identifier of message buffer. */
        uint32_t PRIO : 3;             /*!< [31:29] Local priority. This 3-bit fieldis
                                        * only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx
                                        * buffers. These bits are not transmitted. They are appended to the regular
                                        * ID to define the transmission priority. */
    } B;
} hw_can_idn_t;

/*!
 * @name Constants and macros for entire CAN_IDn register
 */
/*@{*/
#define HW_CAN_IDn_COUNT (64U)

#define HW_CAN_IDn_ADDR(x, n)    ((uintptr_t)(x) + 0x84U + (0x10U * (n)))

#define HW_CAN_IDn(x, n)         (*(__IO hw_can_idn_t *) HW_CAN_IDn_ADDR(x, n))
#define HW_CAN_IDn_RD(x, n)      (HW_CAN_IDn(x, n).U)
#define HW_CAN_IDn_WR(x, n, v)   (HW_CAN_IDn(x, n).U = (v))
#define HW_CAN_IDn_SET(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) |  (v)))
#define HW_CAN_IDn_CLR(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) & ~(v)))
#define HW_CAN_IDn_TOG(x, n, v)  (HW_CAN_IDn_WR(x, n, HW_CAN_IDn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_IDn bitfields
 */

/*!
 * @name Register CAN_IDn, field EXT[17:0] (RW)
 */
/*@{*/
#define BP_CAN_IDn_EXT       (0U)          /*!< Bit position for CAN_IDn_EXT. */
#define BM_CAN_IDn_EXT       (0x0003FFFFU) /*!< Bit mask for CAN_IDn_EXT. */
#define BS_CAN_IDn_EXT       (18U)         /*!< Bit field size in bits for CAN_IDn_EXT. */

/*! @brief Read current value of the CAN_IDn_EXT field. */
#define BR_CAN_IDn_EXT(x, n) (HW_CAN_IDn(x, n).B.EXT)

/*! @brief Format value for bitfield CAN_IDn_EXT. */
#define BF_CAN_IDn_EXT(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_EXT) & BM_CAN_IDn_EXT)

/*! @brief Set the EXT field to a new value. */
#define BW_CAN_IDn_EXT(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_EXT) | BF_CAN_IDn_EXT(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field STD[28:18] (RW)
 */
/*@{*/
#define BP_CAN_IDn_STD       (18U)         /*!< Bit position for CAN_IDn_STD. */
#define BM_CAN_IDn_STD       (0x1FFC0000U) /*!< Bit mask for CAN_IDn_STD. */
#define BS_CAN_IDn_STD       (11U)         /*!< Bit field size in bits for CAN_IDn_STD. */

/*! @brief Read current value of the CAN_IDn_STD field. */
#define BR_CAN_IDn_STD(x, n) (HW_CAN_IDn(x, n).B.STD)

/*! @brief Format value for bitfield CAN_IDn_STD. */
#define BF_CAN_IDn_STD(v)    ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_STD) & BM_CAN_IDn_STD)

/*! @brief Set the STD field to a new value. */
#define BW_CAN_IDn_STD(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_STD) | BF_CAN_IDn_STD(v)))
/*@}*/

/*!
 * @name Register CAN_IDn, field PRIO[31:29] (RW)
 */
/*@{*/
#define BP_CAN_IDn_PRIO      (29U)         /*!< Bit position for CAN_IDn_PRIO. */
#define BM_CAN_IDn_PRIO      (0xE0000000U) /*!< Bit mask for CAN_IDn_PRIO. */
#define BS_CAN_IDn_PRIO      (3U)          /*!< Bit field size in bits for CAN_IDn_PRIO. */

/*! @brief Read current value of the CAN_IDn_PRIO field. */
#define BR_CAN_IDn_PRIO(x, n) (HW_CAN_IDn(x, n).B.PRIO)

/*! @brief Format value for bitfield CAN_IDn_PRIO. */
#define BF_CAN_IDn_PRIO(v)   ((uint32_t)((uint32_t)(v) << BP_CAN_IDn_PRIO) & BM_CAN_IDn_PRIO)

/*! @brief Set the PRIO field to a new value. */
#define BW_CAN_IDn_PRIO(x, n, v) (HW_CAN_IDn_WR(x, n, (HW_CAN_IDn_RD(x, n) & ~BM_CAN_IDn_PRIO) | BF_CAN_IDn_PRIO(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD0n - Message Buffer 0 WORD0 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD0n - Message Buffer 0 WORD0 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word0n
{
    uint32_t U;
    struct _hw_can_word0n_bitfields
    {
        uint32_t DATA_BYTE_3 : 8;      /*!< [7:0] Data byte 3 of Rx/Tx frame. */
        uint32_t DATA_BYTE_2 : 8;      /*!< [15:8] Data byte 2 of Rx/Tx frame. */
        uint32_t DATA_BYTE_1 : 8;      /*!< [23:16] Data byte 1 of Rx/Tx frame. */
        uint32_t DATA_BYTE_0 : 8;      /*!< [31:24] Data byte 0 of Rx/Tx frame. */
    } B;
} hw_can_word0n_t;

/*!
 * @name Constants and macros for entire CAN_WORD0n register
 */
/*@{*/
#define HW_CAN_WORD0n_COUNT (64U)

#define HW_CAN_WORD0n_ADDR(x, n) ((uintptr_t)(x) + 0x88U + (0x10U * (n)))

#define HW_CAN_WORD0n(x, n)      (*(__IO hw_can_word0n_t *) HW_CAN_WORD0n_ADDR(x, n))
#define HW_CAN_WORD0n_RD(x, n)   (HW_CAN_WORD0n(x, n).U)
#define HW_CAN_WORD0n_WR(x, n, v) (HW_CAN_WORD0n(x, n).U = (v))
#define HW_CAN_WORD0n_SET(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) |  (v)))
#define HW_CAN_WORD0n_CLR(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) & ~(v)))
#define HW_CAN_WORD0n_TOG(x, n, v) (HW_CAN_WORD0n_WR(x, n, HW_CAN_WORD0n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD0n bitfields
 */

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_3[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_3 (0U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_3. */
#define BM_CAN_WORD0n_DATA_BYTE_3 (0x000000FFU) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_3. */
#define BS_CAN_WORD0n_DATA_BYTE_3 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_3. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_3 field. */
#define BR_CAN_WORD0n_DATA_BYTE_3(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_3)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_3. */
#define BF_CAN_WORD0n_DATA_BYTE_3(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_3) & BM_CAN_WORD0n_DATA_BYTE_3)

/*! @brief Set the DATA_BYTE_3 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_3(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_3) | BF_CAN_WORD0n_DATA_BYTE_3(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_2[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit position for CAN_WORD0n_DATA_BYTE_2. */
#define BM_CAN_WORD0n_DATA_BYTE_2 (0x0000FF00U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_2. */
#define BS_CAN_WORD0n_DATA_BYTE_2 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_2. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_2 field. */
#define BR_CAN_WORD0n_DATA_BYTE_2(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_2)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_2. */
#define BF_CAN_WORD0n_DATA_BYTE_2(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_2) & BM_CAN_WORD0n_DATA_BYTE_2)

/*! @brief Set the DATA_BYTE_2 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_2(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_2) | BF_CAN_WORD0n_DATA_BYTE_2(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_1[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_1 (16U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_1. */
#define BM_CAN_WORD0n_DATA_BYTE_1 (0x00FF0000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_1. */
#define BS_CAN_WORD0n_DATA_BYTE_1 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_1. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_1 field. */
#define BR_CAN_WORD0n_DATA_BYTE_1(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_1)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_1. */
#define BF_CAN_WORD0n_DATA_BYTE_1(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_1) & BM_CAN_WORD0n_DATA_BYTE_1)

/*! @brief Set the DATA_BYTE_1 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_1(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_1) | BF_CAN_WORD0n_DATA_BYTE_1(v)))
/*@}*/

/*!
 * @name Register CAN_WORD0n, field DATA_BYTE_0[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD0n_DATA_BYTE_0 (24U)    /*!< Bit position for CAN_WORD0n_DATA_BYTE_0. */
#define BM_CAN_WORD0n_DATA_BYTE_0 (0xFF000000U) /*!< Bit mask for CAN_WORD0n_DATA_BYTE_0. */
#define BS_CAN_WORD0n_DATA_BYTE_0 (8U)     /*!< Bit field size in bits for CAN_WORD0n_DATA_BYTE_0. */

/*! @brief Read current value of the CAN_WORD0n_DATA_BYTE_0 field. */
#define BR_CAN_WORD0n_DATA_BYTE_0(x, n) (HW_CAN_WORD0n(x, n).B.DATA_BYTE_0)

/*! @brief Format value for bitfield CAN_WORD0n_DATA_BYTE_0. */
#define BF_CAN_WORD0n_DATA_BYTE_0(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD0n_DATA_BYTE_0) & BM_CAN_WORD0n_DATA_BYTE_0)

/*! @brief Set the DATA_BYTE_0 field to a new value. */
#define BW_CAN_WORD0n_DATA_BYTE_0(x, n, v) (HW_CAN_WORD0n_WR(x, n, (HW_CAN_WORD0n_RD(x, n) & ~BM_CAN_WORD0n_DATA_BYTE_0) | BF_CAN_WORD0n_DATA_BYTE_0(v)))
/*@}*/
/*******************************************************************************
 * HW_CAN_WORD1n - Message Buffer 0 WORD1 Register
 ******************************************************************************/

/*!
 * @brief HW_CAN_WORD1n - Message Buffer 0 WORD1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_word1n
{
    uint32_t U;
    struct _hw_can_word1n_bitfields
    {
        uint32_t DATA_BYTE_7 : 8;      /*!< [7:0] Data byte 7 of Rx/Tx frame. */
        uint32_t DATA_BYTE_6 : 8;      /*!< [15:8] Data byte 6 of Rx/Tx frame. */
        uint32_t DATA_BYTE_5 : 8;      /*!< [23:16] Data byte 5 of Rx/Tx frame. */
        uint32_t DATA_BYTE_4 : 8;      /*!< [31:24] Data byte 4 of Rx/Tx frame. */
    } B;
} hw_can_word1n_t;

/*!
 * @name Constants and macros for entire CAN_WORD1n register
 */
/*@{*/
#define HW_CAN_WORD1n_COUNT (64U)

#define HW_CAN_WORD1n_ADDR(x, n) ((uintptr_t)(x) + 0x8CU + (0x10U * (n)))

#define HW_CAN_WORD1n(x, n)      (*(__IO hw_can_word1n_t *) HW_CAN_WORD1n_ADDR(x, n))
#define HW_CAN_WORD1n_RD(x, n)   (HW_CAN_WORD1n(x, n).U)
#define HW_CAN_WORD1n_WR(x, n, v) (HW_CAN_WORD1n(x, n).U = (v))
#define HW_CAN_WORD1n_SET(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) |  (v)))
#define HW_CAN_WORD1n_CLR(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) & ~(v)))
#define HW_CAN_WORD1n_TOG(x, n, v) (HW_CAN_WORD1n_WR(x, n, HW_CAN_WORD1n_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD1n bitfields
 */

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_7[7:0] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_7 (0U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_7. */
#define BM_CAN_WORD1n_DATA_BYTE_7 (0x000000FFU) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_7. */
#define BS_CAN_WORD1n_DATA_BYTE_7 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_7. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_7 field. */
#define BR_CAN_WORD1n_DATA_BYTE_7(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_7)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_7. */
#define BF_CAN_WORD1n_DATA_BYTE_7(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_7) & BM_CAN_WORD1n_DATA_BYTE_7)

/*! @brief Set the DATA_BYTE_7 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_7(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_7) | BF_CAN_WORD1n_DATA_BYTE_7(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_6[15:8] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit position for CAN_WORD1n_DATA_BYTE_6. */
#define BM_CAN_WORD1n_DATA_BYTE_6 (0x0000FF00U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_6. */
#define BS_CAN_WORD1n_DATA_BYTE_6 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_6. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_6 field. */
#define BR_CAN_WORD1n_DATA_BYTE_6(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_6)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_6. */
#define BF_CAN_WORD1n_DATA_BYTE_6(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_6) & BM_CAN_WORD1n_DATA_BYTE_6)

/*! @brief Set the DATA_BYTE_6 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_6(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_6) | BF_CAN_WORD1n_DATA_BYTE_6(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_5[23:16] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_5 (16U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_5. */
#define BM_CAN_WORD1n_DATA_BYTE_5 (0x00FF0000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_5. */
#define BS_CAN_WORD1n_DATA_BYTE_5 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_5. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_5 field. */
#define BR_CAN_WORD1n_DATA_BYTE_5(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_5)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_5. */
#define BF_CAN_WORD1n_DATA_BYTE_5(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_5) & BM_CAN_WORD1n_DATA_BYTE_5)

/*! @brief Set the DATA_BYTE_5 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_5(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_5) | BF_CAN_WORD1n_DATA_BYTE_5(v)))
/*@}*/

/*!
 * @name Register CAN_WORD1n, field DATA_BYTE_4[31:24] (RW)
 */
/*@{*/
#define BP_CAN_WORD1n_DATA_BYTE_4 (24U)    /*!< Bit position for CAN_WORD1n_DATA_BYTE_4. */
#define BM_CAN_WORD1n_DATA_BYTE_4 (0xFF000000U) /*!< Bit mask for CAN_WORD1n_DATA_BYTE_4. */
#define BS_CAN_WORD1n_DATA_BYTE_4 (8U)     /*!< Bit field size in bits for CAN_WORD1n_DATA_BYTE_4. */

/*! @brief Read current value of the CAN_WORD1n_DATA_BYTE_4 field. */
#define BR_CAN_WORD1n_DATA_BYTE_4(x, n) (HW_CAN_WORD1n(x, n).B.DATA_BYTE_4)

/*! @brief Format value for bitfield CAN_WORD1n_DATA_BYTE_4. */
#define BF_CAN_WORD1n_DATA_BYTE_4(v) ((uint32_t)((uint32_t)(v) << BP_CAN_WORD1n_DATA_BYTE_4) & BM_CAN_WORD1n_DATA_BYTE_4)

/*! @brief Set the DATA_BYTE_4 field to a new value. */
#define BW_CAN_WORD1n_DATA_BYTE_4(x, n, v) (HW_CAN_WORD1n_WR(x, n, (HW_CAN_WORD1n_RD(x, n) & ~BM_CAN_WORD1n_DATA_BYTE_4) | BF_CAN_WORD1n_DATA_BYTE_4(v)))
/*@}*/

/*******************************************************************************
 * HW_CAN_RXIMRn - RXIMR
 ******************************************************************************/

/*!
 * @brief HW_CAN_RXIMRn - RXIMR (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_can_rximrn
{
    uint32_t U;
    struct _hw_can_rximrn_bitfields
    {
        uint32_t MI : 32;              /*!< [31:0] MI */
    } B;
} hw_can_rximrn_t;

/*!
 * @name Constants and macros for entire CAN_RXIMRn register
 */
/*@{*/
#define HW_CAN_RXIMRn_COUNT (64U)

#define HW_CAN_RXIMRn_ADDR(x, n) ((uintptr_t)(x) + 0x880U + (0x4U * (n)))

#define HW_CAN_RXIMRn(x, n)      (*(__IO hw_can_rximrn_t *) HW_CAN_RXIMRn_ADDR(x, n))
#define HW_CAN_RXIMRn_RD(x, n)   (HW_CAN_RXIMRn(x, n).U)
#define HW_CAN_RXIMRn_WR(x, n, v) (HW_CAN_RXIMRn(x, n).U = (v))
#define HW_CAN_RXIMRn_SET(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) |  (v)))
#define HW_CAN_RXIMRn_CLR(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) & ~(v)))
#define HW_CAN_RXIMRn_TOG(x, n, v) (HW_CAN_RXIMRn_WR(x, n, HW_CAN_RXIMRn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_RXIMRn bitfields
 */

/*!
 * @name Register CAN_RXIMRn, field MI[31:0] (RW)
 */
/*@{*/
#define BP_CAN_RXIMRn_MI     (0U)          /*!< Bit position for CAN_RXIMRn_MI. */
#define BM_CAN_RXIMRn_MI     (0xFFFFFFFFU) /*!< Bit mask for CAN_RXIMRn_MI. */
#define BS_CAN_RXIMRn_MI     (32U)         /*!< Bit field size in bits for CAN_RXIMRn_MI. */

/*! @brief Read current value of the CAN_RXIMRn_MI field. */
#define BR_CAN_RXIMRn_MI(x, n) (HW_CAN_RXIMRn(x, n).U)

/*! @brief Format value for bitfield CAN_RXIMRn_MI. */
#define BF_CAN_RXIMRn_MI(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_RXIMRn_MI) & BM_CAN_RXIMRn_MI)

/*! @brief Set the MI field to a new value. */
#define BW_CAN_RXIMRn_MI(x, n, v) (HW_CAN_RXIMRn_WR(x, n, v))
/*@}*/

/*******************************************************************************
 * HW_CAN_GFWR - Glitch Filter Width Registers
 ******************************************************************************/

/*!
 * @brief HW_CAN_GFWR - Glitch Filter Width Registers (RW)
 *
 * Reset value: 0x0000007FU
 *
 * The Glitch Filter just takes effects when FLEXCAN enters the STOP mode.
 */
typedef union _hw_can_gfwr
{
    uint32_t U;
    struct _hw_can_gfwr_bitfields
    {
        uint32_t GFWR : 8;             /*!< [7:0]  */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_can_gfwr_t;

/*!
 * @name Constants and macros for entire CAN_GFWR register
 */
/*@{*/
#define HW_CAN_GFWR_ADDR(x)      ((uintptr_t)(x) + 0x9E0U)

#define HW_CAN_GFWR(x)           (*(__IO hw_can_gfwr_t *) HW_CAN_GFWR_ADDR(x))
#define HW_CAN_GFWR_RD(x)        (HW_CAN_GFWR(x).U)
#define HW_CAN_GFWR_WR(x, v)     (HW_CAN_GFWR(x).U = (v))
#define HW_CAN_GFWR_SET(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) |  (v)))
#define HW_CAN_GFWR_CLR(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) & ~(v)))
#define HW_CAN_GFWR_TOG(x, v)    (HW_CAN_GFWR_WR(x, HW_CAN_GFWR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual CAN_GFWR bitfields
 */

/*!
 * @name Register CAN_GFWR, field GFWR[7:0] (RW)
 *
 * It determines the Glitch Filter Width. The width will be divided from
 * Oscillator clock by GFWR values. By default, it is 5.33 us when the oscillator is 24
 * MHz. Filter Pulse Width = [(GFWR FIELD + 1) x (1 / Osc. Frequency)]
 */
/*@{*/
#define BP_CAN_GFWR_GFWR     (0U)          /*!< Bit position for CAN_GFWR_GFWR. */
#define BM_CAN_GFWR_GFWR     (0x000000FFU) /*!< Bit mask for CAN_GFWR_GFWR. */
#define BS_CAN_GFWR_GFWR     (8U)          /*!< Bit field size in bits for CAN_GFWR_GFWR. */

/*! @brief Read current value of the CAN_GFWR_GFWR field. */
#define BR_CAN_GFWR_GFWR(x)  (HW_CAN_GFWR(x).B.GFWR)

/*! @brief Format value for bitfield CAN_GFWR_GFWR. */
#define BF_CAN_GFWR_GFWR(v)  ((uint32_t)((uint32_t)(v) << BP_CAN_GFWR_GFWR) & BM_CAN_GFWR_GFWR)

/*! @brief Set the GFWR field to a new value. */
#define BW_CAN_GFWR_GFWR(x, v) (HW_CAN_GFWR_WR(x, (HW_CAN_GFWR_RD(x) & ~BM_CAN_GFWR_GFWR) | BF_CAN_GFWR_GFWR(v)))
/*@}*/

/*******************************************************************************
 * hw_can_t - module struct
 ******************************************************************************/
/*!
 * @brief All CAN module registers.
 */
#pragma pack(1)
typedef struct _hw_can
{
    __IO hw_can_mcr_t MCR;                 /*!< [0x0] Module Configuration Register */
    __IO hw_can_ctrl1_t CTRL1;             /*!< [0x4] Control 1 Register */
    __IO hw_can_timer_t TIMER;             /*!< [0x8] Free Running Timer Register */
    uint8_t _reserved0[4];
    __IO hw_can_rxmgmask_t RXMGMASK;       /*!< [0x10] Rx Mailboxes Global Mask Register */
    __IO hw_can_rx14mask_t RX14MASK;       /*!< [0x14] Rx Buffer 14 Mask Register */
    __IO hw_can_rx15mask_t RX15MASK;       /*!< [0x18] Rx Buffer 15 Mask Register */
    __IO hw_can_ecr_t ECR;                 /*!< [0x1C] Error Counter Register */
    __IO hw_can_esr1_t ESR1;               /*!< [0x20] Error and Status 1 Register */
    __IO hw_can_imask2_t IMASK2;           /*!< [0x24] Interrupt Masks 2 Register */
    __IO hw_can_imask1_t IMASK1;           /*!< [0x28] Interrupt Masks 1 Register */
    __IO hw_can_iflag2_t IFLAG2;           /*!< [0x2C] Interrupt Flags 2 Register */
    __IO hw_can_iflag1_t IFLAG1;           /*!< [0x30] Interrupt Flags 1 Register */
    __IO hw_can_ctrl2_t CTRL2;             /*!< [0x34] Control 2 Register */
    __I hw_can_esr2_t ESR2;                /*!< [0x38] Error and Status 2 Register */
    uint8_t _reserved1[8];
    __I hw_can_crcr_t CRCR;                /*!< [0x44] CRC Register */
    __IO hw_can_rxfgmask_t RXFGMASK;       /*!< [0x48] Rx FIFO Global Mask Register */
    __I hw_can_rxfir_t RXFIR;              /*!< [0x4C] Rx FIFO Information Register */
    uint8_t _reserved2[48];
    struct {
        __IO hw_can_csn_t CSn;             /*!< [0x80] Message Buffer 0 CS Register */
        __IO hw_can_idn_t IDn;             /*!< [0x84] Message Buffer 0 ID Register */
        __IO hw_can_word0n_t WORD0n;       /*!< [0x88] Message Buffer 0 WORD0 Register */
        __IO hw_can_word1n_t WORD1n;       /*!< [0x8C] Message Buffer 0 WORD1 Register */
    } MB[64];
    uint8_t _reserved3[1024];
    __IO hw_can_rximrn_t RXIMRn[64];       /*!< [0x880] RXIMR */
    uint8_t _reserved4[96];
    __IO hw_can_gfwr_t GFWR;               /*!< [0x9E0] Glitch Filter Width Registers */
} hw_can_t;
#pragma pack()

/*! @brief Macro to access all CAN registers. */
/*! @param x CAN module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_CAN_REGS(CAN1_BASE)</code>. */
#define HW_CAN_REGS(x) (*(hw_can_t *)(x))

/*
 * iMX7S CCM
 *
 * CCM_UNIFIED
 *
 * Registers defined in this header file:
 * - HW_CCM_GPR0 - General Purpose Register
 * - HW_CCM_PLL_CTRL0 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL1 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL2 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL3 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL4 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL5 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL6 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL7 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL8 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL9 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL10 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL11 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL12 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL13 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL14 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL15 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL16 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL17 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL18 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL19 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL20 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL21 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL22 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL23 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL24 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL25 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL26 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL27 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL28 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL29 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL30 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL31 - CCM PLL Control Register
 * - HW_CCM_PLL_CTRL32 - CCM PLL Control Register
 * - HW_CCM_CCGR0 - CCM Clock Gating Register
 * - HW_CCM_CCGR1 - CCM Clock Gating Register
 * - HW_CCM_CCGR2 - CCM Clock Gating Register
 * - HW_CCM_CCGR3 - CCM Clock Gating Register
 * - HW_CCM_CCGR4 - CCM Clock Gating Register
 * - HW_CCM_CCGR5 - CCM Clock Gating Register
 * - HW_CCM_CCGR6 - CCM Clock Gating Register
 * - HW_CCM_CCGR7 - CCM Clock Gating Register
 * - HW_CCM_CCGR8 - CCM Clock Gating Register
 * - HW_CCM_CCGR9 - CCM Clock Gating Register
 * - HW_CCM_CCGR10 - CCM Clock Gating Register
 * - HW_CCM_CCGR11 - CCM Clock Gating Register
 * - HW_CCM_CCGR12 - CCM Clock Gating Register
 * - HW_CCM_CCGR13 - CCM Clock Gating Register
 * - HW_CCM_CCGR14 - CCM Clock Gating Register
 * - HW_CCM_CCGR15 - CCM Clock Gating Register
 * - HW_CCM_CCGR16 - CCM Clock Gating Register
 * - HW_CCM_CCGR17 - CCM Clock Gating Register
 * - HW_CCM_CCGR18 - CCM Clock Gating Register
 * - HW_CCM_CCGR19 - CCM Clock Gating Register
 * - HW_CCM_CCGR20 - CCM Clock Gating Register
 * - HW_CCM_CCGR21 - CCM Clock Gating Register
 * - HW_CCM_CCGR22 - CCM Clock Gating Register
 * - HW_CCM_CCGR23 - CCM Clock Gating Register
 * - HW_CCM_CCGR24 - CCM Clock Gating Register
 * - HW_CCM_CCGR25 - CCM Clock Gating Register
 * - HW_CCM_CCGR26 - CCM Clock Gating Register
 * - HW_CCM_CCGR27 - CCM Clock Gating Register
 * - HW_CCM_CCGR28 - CCM Clock Gating Register
 * - HW_CCM_CCGR29 - CCM Clock Gating Register
 * - HW_CCM_CCGR30 - CCM Clock Gating Register
 * - HW_CCM_CCGR31 - CCM Clock Gating Register
 * - HW_CCM_CCGR32 - CCM Clock Gating Register
 * - HW_CCM_CCGR33 - CCM Clock Gating Register
 * - HW_CCM_CCGR34 - CCM Clock Gating Register
 * - HW_CCM_CCGR35 - CCM Clock Gating Register
 * - HW_CCM_CCGR36 - CCM Clock Gating Register
 * - HW_CCM_CCGR37 - CCM Clock Gating Register
 * - HW_CCM_CCGR38 - CCM Clock Gating Register
 * - HW_CCM_CCGR39 - CCM Clock Gating Register
 * - HW_CCM_CCGR40 - CCM Clock Gating Register
 * - HW_CCM_CCGR41 - CCM Clock Gating Register
 * - HW_CCM_CCGR42 - CCM Clock Gating Register
 * - HW_CCM_CCGR43 - CCM Clock Gating Register
 * - HW_CCM_CCGR44 - CCM Clock Gating Register
 * - HW_CCM_CCGR45 - CCM Clock Gating Register
 * - HW_CCM_CCGR46 - CCM Clock Gating Register
 * - HW_CCM_CCGR47 - CCM Clock Gating Register
 * - HW_CCM_CCGR48 - CCM Clock Gating Register
 * - HW_CCM_CCGR49 - CCM Clock Gating Register
 * - HW_CCM_CCGR50 - CCM Clock Gating Register
 * - HW_CCM_CCGR51 - CCM Clock Gating Register
 * - HW_CCM_CCGR52 - CCM Clock Gating Register
 * - HW_CCM_CCGR53 - CCM Clock Gating Register
 * - HW_CCM_CCGR54 - CCM Clock Gating Register
 * - HW_CCM_CCGR55 - CCM Clock Gating Register
 * - HW_CCM_CCGR56 - CCM Clock Gating Register
 * - HW_CCM_CCGR57 - CCM Clock Gating Register
 * - HW_CCM_CCGR58 - CCM Clock Gating Register
 * - HW_CCM_CCGR59 - CCM Clock Gating Register
 * - HW_CCM_CCGR60 - CCM Clock Gating Register
 * - HW_CCM_CCGR61 - CCM Clock Gating Register
 * - HW_CCM_CCGR62 - CCM Clock Gating Register
 * - HW_CCM_CCGR63 - CCM Clock Gating Register
 * - HW_CCM_CCGR64 - CCM Clock Gating Register
 * - HW_CCM_CCGR65 - CCM Clock Gating Register
 * - HW_CCM_CCGR66 - CCM Clock Gating Register
 * - HW_CCM_CCGR67 - CCM Clock Gating Register
 * - HW_CCM_CCGR68 - CCM Clock Gating Register
 * - HW_CCM_CCGR69 - CCM Clock Gating Register
 * - HW_CCM_CCGR70 - CCM Clock Gating Register
 * - HW_CCM_CCGR71 - CCM Clock Gating Register
 * - HW_CCM_CCGR72 - CCM Clock Gating Register
 * - HW_CCM_CCGR73 - CCM Clock Gating Register
 * - HW_CCM_CCGR74 - CCM Clock Gating Register
 * - HW_CCM_CCGR75 - CCM Clock Gating Register
 * - HW_CCM_CCGR76 - CCM Clock Gating Register
 * - HW_CCM_CCGR77 - CCM Clock Gating Register
 * - HW_CCM_CCGR78 - CCM Clock Gating Register
 * - HW_CCM_CCGR79 - CCM Clock Gating Register
 * - HW_CCM_CCGR80 - CCM Clock Gating Register
 * - HW_CCM_CCGR81 - CCM Clock Gating Register
 * - HW_CCM_CCGR82 - CCM Clock Gating Register
 * - HW_CCM_CCGR83 - CCM Clock Gating Register
 * - HW_CCM_CCGR84 - CCM Clock Gating Register
 * - HW_CCM_CCGR85 - CCM Clock Gating Register
 * - HW_CCM_CCGR86 - CCM Clock Gating Register
 * - HW_CCM_CCGR87 - CCM Clock Gating Register
 * - HW_CCM_CCGR88 - CCM Clock Gating Register
 * - HW_CCM_CCGR89 - CCM Clock Gating Register
 * - HW_CCM_CCGR90 - CCM Clock Gating Register
 * - HW_CCM_CCGR91 - CCM Clock Gating Register
 * - HW_CCM_CCGR92 - CCM Clock Gating Register
 * - HW_CCM_CCGR93 - CCM Clock Gating Register
 * - HW_CCM_CCGR94 - CCM Clock Gating Register
 * - HW_CCM_CCGR95 - CCM Clock Gating Register
 * - HW_CCM_CCGR96 - CCM Clock Gating Register
 * - HW_CCM_CCGR97 - CCM Clock Gating Register
 * - HW_CCM_CCGR98 - CCM Clock Gating Register
 * - HW_CCM_CCGR99 - CCM Clock Gating Register
 * - HW_CCM_CCGR100 - CCM Clock Gating Register
 * - HW_CCM_CCGR101 - CCM Clock Gating Register
 * - HW_CCM_CCGR102 - CCM Clock Gating Register
 * - HW_CCM_CCGR103 - CCM Clock Gating Register
 * - HW_CCM_CCGR104 - CCM Clock Gating Register
 * - HW_CCM_CCGR105 - CCM Clock Gating Register
 * - HW_CCM_CCGR106 - CCM Clock Gating Register
 * - HW_CCM_CCGR107 - CCM Clock Gating Register
 * - HW_CCM_CCGR108 - CCM Clock Gating Register
 * - HW_CCM_CCGR109 - CCM Clock Gating Register
 * - HW_CCM_CCGR110 - CCM Clock Gating Register
 * - HW_CCM_CCGR111 - CCM Clock Gating Register
 * - HW_CCM_CCGR112 - CCM Clock Gating Register
 * - HW_CCM_CCGR113 - CCM Clock Gating Register
 * - HW_CCM_CCGR114 - CCM Clock Gating Register
 * - HW_CCM_CCGR115 - CCM Clock Gating Register
 * - HW_CCM_CCGR116 - CCM Clock Gating Register
 * - HW_CCM_CCGR117 - CCM Clock Gating Register
 * - HW_CCM_CCGR118 - CCM Clock Gating Register
 * - HW_CCM_CCGR119 - CCM Clock Gating Register
 * - HW_CCM_CCGR120 - CCM Clock Gating Register
 * - HW_CCM_CCGR121 - CCM Clock Gating Register
 * - HW_CCM_CCGR122 - CCM Clock Gating Register
 * - HW_CCM_CCGR123 - CCM Clock Gating Register
 * - HW_CCM_CCGR124 - CCM Clock Gating Register
 * - HW_CCM_CCGR125 - CCM Clock Gating Register
 * - HW_CCM_CCGR126 - CCM Clock Gating Register
 * - HW_CCM_CCGR127 - CCM Clock Gating Register
 * - HW_CCM_CCGR128 - CCM Clock Gating Register
 * - HW_CCM_CCGR129 - CCM Clock Gating Register
 * - HW_CCM_CCGR130 - CCM Clock Gating Register
 * - HW_CCM_CCGR131 - CCM Clock Gating Register
 * - HW_CCM_CCGR132 - CCM Clock Gating Register
 * - HW_CCM_CCGR133 - CCM Clock Gating Register
 * - HW_CCM_CCGR134 - CCM Clock Gating Register
 * - HW_CCM_CCGR135 - CCM Clock Gating Register
 * - HW_CCM_CCGR136 - CCM Clock Gating Register
 * - HW_CCM_CCGR137 - CCM Clock Gating Register
 * - HW_CCM_CCGR138 - CCM Clock Gating Register
 * - HW_CCM_CCGR139 - CCM Clock Gating Register
 * - HW_CCM_CCGR140 - CCM Clock Gating Register
 * - HW_CCM_CCGR141 - CCM Clock Gating Register
 * - HW_CCM_CCGR142 - CCM Clock Gating Register
 * - HW_CCM_CCGR143 - CCM Clock Gating Register
 * - HW_CCM_CCGR144 - CCM Clock Gating Register
 * - HW_CCM_CCGR145 - CCM Clock Gating Register
 * - HW_CCM_CCGR146 - CCM Clock Gating Register
 * - HW_CCM_CCGR147 - CCM Clock Gating Register
 * - HW_CCM_CCGR148 - CCM Clock Gating Register
 * - HW_CCM_CCGR149 - CCM Clock Gating Register
 * - HW_CCM_CCGR150 - CCM Clock Gating Register
 * - HW_CCM_CCGR151 - CCM Clock Gating Register
 * - HW_CCM_CCGR152 - CCM Clock Gating Register
 * - HW_CCM_CCGR153 - CCM Clock Gating Register
 * - HW_CCM_CCGR154 - CCM Clock Gating Register
 * - HW_CCM_CCGR155 - CCM Clock Gating Register
 * - HW_CCM_CCGR156 - CCM Clock Gating Register
 * - HW_CCM_CCGR157 - CCM Clock Gating Register
 * - HW_CCM_CCGR158 - CCM Clock Gating Register
 * - HW_CCM_CCGR159 - CCM Clock Gating Register
 * - HW_CCM_CCGR160 - CCM Clock Gating Register
 * - HW_CCM_CCGR161 - CCM Clock Gating Register
 * - HW_CCM_CCGR162 - CCM Clock Gating Register
 * - HW_CCM_CCGR163 - CCM Clock Gating Register
 * - HW_CCM_CCGR164 - CCM Clock Gating Register
 * - HW_CCM_CCGR165 - CCM Clock Gating Register
 * - HW_CCM_CCGR166 - CCM Clock Gating Register
 * - HW_CCM_CCGR167 - CCM Clock Gating Register
 * - HW_CCM_CCGR168 - CCM Clock Gating Register
 * - HW_CCM_CCGR169 - CCM Clock Gating Register
 * - HW_CCM_CCGR170 - CCM Clock Gating Register
 * - HW_CCM_CCGR171 - CCM Clock Gating Register
 * - HW_CCM_CCGR172 - CCM Clock Gating Register
 * - HW_CCM_CCGR173 - CCM Clock Gating Register
 * - HW_CCM_CCGR174 - CCM Clock Gating Register
 * - HW_CCM_CCGR175 - CCM Clock Gating Register
 * - HW_CCM_CCGR176 - CCM Clock Gating Register
 * - HW_CCM_CCGR177 - CCM Clock Gating Register
 * - HW_CCM_CCGR178 - CCM Clock Gating Register
 * - HW_CCM_CCGR179 - CCM Clock Gating Register
 * - HW_CCM_CCGR180 - CCM Clock Gating Register
 * - HW_CCM_CCGR181 - CCM Clock Gating Register
 * - HW_CCM_CCGR182 - CCM Clock Gating Register
 * - HW_CCM_CCGR183 - CCM Clock Gating Register
 * - HW_CCM_CCGR184 - CCM Clock Gating Register
 * - HW_CCM_CCGR185 - CCM Clock Gating Register
 * - HW_CCM_CCGR186 - CCM Clock Gating Register
 * - HW_CCM_CCGR187 - CCM Clock Gating Register
 * - HW_CCM_CCGR188 - CCM Clock Gating Register
 * - HW_CCM_CCGR189 - CCM Clock Gating Register
 * - HW_CCM_CCGR190 - CCM Clock Gating Register
 * - HW_CCM_TARGET_ROOTn - Target Register
 * - HW_CCM_MISCn - Miscellaneous Register
 * - HW_CCM_POSTn - Post Divider Register
 * - HW_CCM_PREn - Pre Divider Register
 * - HW_CCM_ACCESS_CTRLn - Access Control Register
 *
 * - hw_ccm_t - Struct containing all module registers.
 */

#define HW_CCM_INSTANCE_COUNT (1U) /*!< Number of instances of the CCM module. */
#define HW_CCM (0U) /*!< Instance number for CCM. */
#define CCM_BASE              (0x30380000U) /*!< Base address for CCM. */
/*! Array initializer of CCM base addresses. */
#define CCM_BASE_ADDRS        { CCM_BASE }

/*******************************************************************************
 * HW_CCM_GPR0 - General Purpose Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_GPR0 - General Purpose Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * GPR0
 */
typedef union _hw_ccm_gpr0
{
    uint32_t U;
    struct _hw_ccm_gpr0_bitfields
    {
        uint32_t GP0 : 32;             /*!< [31:0]  */
    } B;
} hw_ccm_gpr0_t;

/*!
 * @name Constants and macros for entire CCM_GPR0 register
 */
/*@{*/
#define HW_CCM_GPR0_ADDR(x)      ((uintptr_t)(x) + 0x0U)
#define HW_CCM_GPR0_SET_ADDR(x)  (HW_CCM_GPR0_ADDR(x) + 0x4U)
#define HW_CCM_GPR0_CLR_ADDR(x)  (HW_CCM_GPR0_ADDR(x) + 0x8U)
#define HW_CCM_GPR0_TOG_ADDR(x)  (HW_CCM_GPR0_ADDR(x) + 0xCU)

#define HW_CCM_GPR0(x)           (*(__IO hw_ccm_gpr0_t *) HW_CCM_GPR0_ADDR(x))
#define HW_CCM_GPR0_RD(x)        (HW_CCM_GPR0(x).U)
#define HW_CCM_GPR0_WR(x, v)     (HW_CCM_GPR0(x).U = (v))
#define HW_CCM_GPR0_SET(x, v)    ((*(uint32_t *) HW_CCM_GPR0_SET_ADDR(x)) = (v))
#define HW_CCM_GPR0_CLR(x, v)    ((*(uint32_t *) HW_CCM_GPR0_CLR_ADDR(x)) = (v))
#define HW_CCM_GPR0_TOG(x, v)    ((*(uint32_t *) HW_CCM_GPR0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_GPR0 bitfields
 */

/*!
 * @name Register CCM_GPR0, field GP0[31:0] (RW)
 *
 * Timeout cycle count of ipg_clk, when perform read and write.
 */
/*@{*/
#define BP_CCM_GPR0_GP0      (0U)          /*!< Bit position for CCM_GPR0_GP0. */
#define BM_CCM_GPR0_GP0      (0xFFFFFFFFU) /*!< Bit mask for CCM_GPR0_GP0. */
#define BS_CCM_GPR0_GP0      (32U)         /*!< Bit field size in bits for CCM_GPR0_GP0. */

/*! @brief Read current value of the CCM_GPR0_GP0 field. */
#define BR_CCM_GPR0_GP0(x)   (HW_CCM_GPR0(x).U)

/*! @brief Format value for bitfield CCM_GPR0_GP0. */
#define BF_CCM_GPR0_GP0(v)   ((uint32_t)((uint32_t)(v) << BP_CCM_GPR0_GP0) & BM_CCM_GPR0_GP0)

/*! @brief Set the GP0 field to a new value. */
#define BW_CCM_GPR0_GP0(x, v) (HW_CCM_GPR0_WR(x, v))
/*@}*/




/*******************************************************************************
 * HW_CCM_PLL_CTRL0 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL0 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl0
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl0_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl0_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL0 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL0_ADDR(x) ((uintptr_t)(x) + 0x800U)
#define HW_CCM_PLL_CTRL0_SET_ADDR(x) (HW_CCM_PLL_CTRL0_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL0_CLR_ADDR(x) (HW_CCM_PLL_CTRL0_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL0_TOG_ADDR(x) (HW_CCM_PLL_CTRL0_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL0(x)      (*(__IO hw_ccm_pll_ctrl0_t *) HW_CCM_PLL_CTRL0_ADDR(x))
#define HW_CCM_PLL_CTRL0_RD(x)   (HW_CCM_PLL_CTRL0(x).U)
#define HW_CCM_PLL_CTRL0_WR(x, v) (HW_CCM_PLL_CTRL0(x).U = (v))
#define HW_CCM_PLL_CTRL0_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL0_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL0_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL0_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL0_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL0 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL0, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL0_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL0_SETTING0. */
#define BM_CCM_PLL_CTRL0_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL0_SETTING0. */
#define BS_CCM_PLL_CTRL0_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL0_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL0_SETTING0 field. */
#define BR_CCM_PLL_CTRL0_SETTING0(x) (HW_CCM_PLL_CTRL0(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL0_SETTING0. */
#define BF_CCM_PLL_CTRL0_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL0_SETTING0) & BM_CCM_PLL_CTRL0_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL0_SETTING0(x, v) (HW_CCM_PLL_CTRL0_WR(x, (HW_CCM_PLL_CTRL0_RD(x) & ~BM_CCM_PLL_CTRL0_SETTING0) | BF_CCM_PLL_CTRL0_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL0, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL0_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL0_SETTING1. */
#define BM_CCM_PLL_CTRL0_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL0_SETTING1. */
#define BS_CCM_PLL_CTRL0_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL0_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL0_SETTING1 field. */
#define BR_CCM_PLL_CTRL0_SETTING1(x) (HW_CCM_PLL_CTRL0(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL0_SETTING1. */
#define BF_CCM_PLL_CTRL0_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL0_SETTING1) & BM_CCM_PLL_CTRL0_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL0_SETTING1(x, v) (HW_CCM_PLL_CTRL0_WR(x, (HW_CCM_PLL_CTRL0_RD(x) & ~BM_CCM_PLL_CTRL0_SETTING1) | BF_CCM_PLL_CTRL0_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL0, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL0_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL0_SETTING2. */
#define BM_CCM_PLL_CTRL0_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL0_SETTING2. */
#define BS_CCM_PLL_CTRL0_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL0_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL0_SETTING2 field. */
#define BR_CCM_PLL_CTRL0_SETTING2(x) (HW_CCM_PLL_CTRL0(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL0_SETTING2. */
#define BF_CCM_PLL_CTRL0_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL0_SETTING2) & BM_CCM_PLL_CTRL0_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL0_SETTING2(x, v) (HW_CCM_PLL_CTRL0_WR(x, (HW_CCM_PLL_CTRL0_RD(x) & ~BM_CCM_PLL_CTRL0_SETTING2) | BF_CCM_PLL_CTRL0_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL0, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL0_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL0_SETTING3. */
#define BM_CCM_PLL_CTRL0_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL0_SETTING3. */
#define BS_CCM_PLL_CTRL0_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL0_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL0_SETTING3 field. */
#define BR_CCM_PLL_CTRL0_SETTING3(x) (HW_CCM_PLL_CTRL0(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL0_SETTING3. */
#define BF_CCM_PLL_CTRL0_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL0_SETTING3) & BM_CCM_PLL_CTRL0_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL0_SETTING3(x, v) (HW_CCM_PLL_CTRL0_WR(x, (HW_CCM_PLL_CTRL0_RD(x) & ~BM_CCM_PLL_CTRL0_SETTING3) | BF_CCM_PLL_CTRL0_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL1 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL1 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl1
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl1_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl1_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL1 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL1_ADDR(x) ((uintptr_t)(x) + 0x810U)
#define HW_CCM_PLL_CTRL1_SET_ADDR(x) (HW_CCM_PLL_CTRL1_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL1_CLR_ADDR(x) (HW_CCM_PLL_CTRL1_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL1_TOG_ADDR(x) (HW_CCM_PLL_CTRL1_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL1(x)      (*(__IO hw_ccm_pll_ctrl1_t *) HW_CCM_PLL_CTRL1_ADDR(x))
#define HW_CCM_PLL_CTRL1_RD(x)   (HW_CCM_PLL_CTRL1(x).U)
#define HW_CCM_PLL_CTRL1_WR(x, v) (HW_CCM_PLL_CTRL1(x).U = (v))
#define HW_CCM_PLL_CTRL1_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL1_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL1_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL1_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL1_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL1 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL1, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL1_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL1_SETTING0. */
#define BM_CCM_PLL_CTRL1_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL1_SETTING0. */
#define BS_CCM_PLL_CTRL1_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL1_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL1_SETTING0 field. */
#define BR_CCM_PLL_CTRL1_SETTING0(x) (HW_CCM_PLL_CTRL1(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL1_SETTING0. */
#define BF_CCM_PLL_CTRL1_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL1_SETTING0) & BM_CCM_PLL_CTRL1_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL1_SETTING0(x, v) (HW_CCM_PLL_CTRL1_WR(x, (HW_CCM_PLL_CTRL1_RD(x) & ~BM_CCM_PLL_CTRL1_SETTING0) | BF_CCM_PLL_CTRL1_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL1, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL1_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL1_SETTING1. */
#define BM_CCM_PLL_CTRL1_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL1_SETTING1. */
#define BS_CCM_PLL_CTRL1_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL1_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL1_SETTING1 field. */
#define BR_CCM_PLL_CTRL1_SETTING1(x) (HW_CCM_PLL_CTRL1(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL1_SETTING1. */
#define BF_CCM_PLL_CTRL1_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL1_SETTING1) & BM_CCM_PLL_CTRL1_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL1_SETTING1(x, v) (HW_CCM_PLL_CTRL1_WR(x, (HW_CCM_PLL_CTRL1_RD(x) & ~BM_CCM_PLL_CTRL1_SETTING1) | BF_CCM_PLL_CTRL1_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL1, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL1_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL1_SETTING2. */
#define BM_CCM_PLL_CTRL1_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL1_SETTING2. */
#define BS_CCM_PLL_CTRL1_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL1_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL1_SETTING2 field. */
#define BR_CCM_PLL_CTRL1_SETTING2(x) (HW_CCM_PLL_CTRL1(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL1_SETTING2. */
#define BF_CCM_PLL_CTRL1_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL1_SETTING2) & BM_CCM_PLL_CTRL1_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL1_SETTING2(x, v) (HW_CCM_PLL_CTRL1_WR(x, (HW_CCM_PLL_CTRL1_RD(x) & ~BM_CCM_PLL_CTRL1_SETTING2) | BF_CCM_PLL_CTRL1_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL1, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL1_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL1_SETTING3. */
#define BM_CCM_PLL_CTRL1_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL1_SETTING3. */
#define BS_CCM_PLL_CTRL1_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL1_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL1_SETTING3 field. */
#define BR_CCM_PLL_CTRL1_SETTING3(x) (HW_CCM_PLL_CTRL1(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL1_SETTING3. */
#define BF_CCM_PLL_CTRL1_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL1_SETTING3) & BM_CCM_PLL_CTRL1_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL1_SETTING3(x, v) (HW_CCM_PLL_CTRL1_WR(x, (HW_CCM_PLL_CTRL1_RD(x) & ~BM_CCM_PLL_CTRL1_SETTING3) | BF_CCM_PLL_CTRL1_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL2 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL2 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl2
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl2_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl2_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL2 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL2_ADDR(x) ((uintptr_t)(x) + 0x820U)
#define HW_CCM_PLL_CTRL2_SET_ADDR(x) (HW_CCM_PLL_CTRL2_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL2_CLR_ADDR(x) (HW_CCM_PLL_CTRL2_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL2_TOG_ADDR(x) (HW_CCM_PLL_CTRL2_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL2(x)      (*(__IO hw_ccm_pll_ctrl2_t *) HW_CCM_PLL_CTRL2_ADDR(x))
#define HW_CCM_PLL_CTRL2_RD(x)   (HW_CCM_PLL_CTRL2(x).U)
#define HW_CCM_PLL_CTRL2_WR(x, v) (HW_CCM_PLL_CTRL2(x).U = (v))
#define HW_CCM_PLL_CTRL2_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL2_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL2_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL2_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL2_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL2_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL2 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL2, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL2_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL2_SETTING0. */
#define BM_CCM_PLL_CTRL2_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL2_SETTING0. */
#define BS_CCM_PLL_CTRL2_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL2_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL2_SETTING0 field. */
#define BR_CCM_PLL_CTRL2_SETTING0(x) (HW_CCM_PLL_CTRL2(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL2_SETTING0. */
#define BF_CCM_PLL_CTRL2_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL2_SETTING0) & BM_CCM_PLL_CTRL2_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL2_SETTING0(x, v) (HW_CCM_PLL_CTRL2_WR(x, (HW_CCM_PLL_CTRL2_RD(x) & ~BM_CCM_PLL_CTRL2_SETTING0) | BF_CCM_PLL_CTRL2_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL2, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL2_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL2_SETTING1. */
#define BM_CCM_PLL_CTRL2_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL2_SETTING1. */
#define BS_CCM_PLL_CTRL2_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL2_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL2_SETTING1 field. */
#define BR_CCM_PLL_CTRL2_SETTING1(x) (HW_CCM_PLL_CTRL2(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL2_SETTING1. */
#define BF_CCM_PLL_CTRL2_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL2_SETTING1) & BM_CCM_PLL_CTRL2_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL2_SETTING1(x, v) (HW_CCM_PLL_CTRL2_WR(x, (HW_CCM_PLL_CTRL2_RD(x) & ~BM_CCM_PLL_CTRL2_SETTING1) | BF_CCM_PLL_CTRL2_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL2, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL2_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL2_SETTING2. */
#define BM_CCM_PLL_CTRL2_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL2_SETTING2. */
#define BS_CCM_PLL_CTRL2_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL2_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL2_SETTING2 field. */
#define BR_CCM_PLL_CTRL2_SETTING2(x) (HW_CCM_PLL_CTRL2(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL2_SETTING2. */
#define BF_CCM_PLL_CTRL2_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL2_SETTING2) & BM_CCM_PLL_CTRL2_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL2_SETTING2(x, v) (HW_CCM_PLL_CTRL2_WR(x, (HW_CCM_PLL_CTRL2_RD(x) & ~BM_CCM_PLL_CTRL2_SETTING2) | BF_CCM_PLL_CTRL2_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL2, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL2_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL2_SETTING3. */
#define BM_CCM_PLL_CTRL2_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL2_SETTING3. */
#define BS_CCM_PLL_CTRL2_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL2_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL2_SETTING3 field. */
#define BR_CCM_PLL_CTRL2_SETTING3(x) (HW_CCM_PLL_CTRL2(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL2_SETTING3. */
#define BF_CCM_PLL_CTRL2_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL2_SETTING3) & BM_CCM_PLL_CTRL2_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL2_SETTING3(x, v) (HW_CCM_PLL_CTRL2_WR(x, (HW_CCM_PLL_CTRL2_RD(x) & ~BM_CCM_PLL_CTRL2_SETTING3) | BF_CCM_PLL_CTRL2_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL3 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL3 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl3
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl3_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl3_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL3 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL3_ADDR(x) ((uintptr_t)(x) + 0x830U)
#define HW_CCM_PLL_CTRL3_SET_ADDR(x) (HW_CCM_PLL_CTRL3_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL3_CLR_ADDR(x) (HW_CCM_PLL_CTRL3_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL3_TOG_ADDR(x) (HW_CCM_PLL_CTRL3_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL3(x)      (*(__IO hw_ccm_pll_ctrl3_t *) HW_CCM_PLL_CTRL3_ADDR(x))
#define HW_CCM_PLL_CTRL3_RD(x)   (HW_CCM_PLL_CTRL3(x).U)
#define HW_CCM_PLL_CTRL3_WR(x, v) (HW_CCM_PLL_CTRL3(x).U = (v))
#define HW_CCM_PLL_CTRL3_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL3_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL3_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL3_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL3_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL3_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL3 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL3, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL3_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL3_SETTING0. */
#define BM_CCM_PLL_CTRL3_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL3_SETTING0. */
#define BS_CCM_PLL_CTRL3_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL3_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL3_SETTING0 field. */
#define BR_CCM_PLL_CTRL3_SETTING0(x) (HW_CCM_PLL_CTRL3(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL3_SETTING0. */
#define BF_CCM_PLL_CTRL3_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL3_SETTING0) & BM_CCM_PLL_CTRL3_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL3_SETTING0(x, v) (HW_CCM_PLL_CTRL3_WR(x, (HW_CCM_PLL_CTRL3_RD(x) & ~BM_CCM_PLL_CTRL3_SETTING0) | BF_CCM_PLL_CTRL3_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL3, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL3_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL3_SETTING1. */
#define BM_CCM_PLL_CTRL3_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL3_SETTING1. */
#define BS_CCM_PLL_CTRL3_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL3_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL3_SETTING1 field. */
#define BR_CCM_PLL_CTRL3_SETTING1(x) (HW_CCM_PLL_CTRL3(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL3_SETTING1. */
#define BF_CCM_PLL_CTRL3_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL3_SETTING1) & BM_CCM_PLL_CTRL3_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL3_SETTING1(x, v) (HW_CCM_PLL_CTRL3_WR(x, (HW_CCM_PLL_CTRL3_RD(x) & ~BM_CCM_PLL_CTRL3_SETTING1) | BF_CCM_PLL_CTRL3_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL3, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL3_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL3_SETTING2. */
#define BM_CCM_PLL_CTRL3_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL3_SETTING2. */
#define BS_CCM_PLL_CTRL3_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL3_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL3_SETTING2 field. */
#define BR_CCM_PLL_CTRL3_SETTING2(x) (HW_CCM_PLL_CTRL3(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL3_SETTING2. */
#define BF_CCM_PLL_CTRL3_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL3_SETTING2) & BM_CCM_PLL_CTRL3_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL3_SETTING2(x, v) (HW_CCM_PLL_CTRL3_WR(x, (HW_CCM_PLL_CTRL3_RD(x) & ~BM_CCM_PLL_CTRL3_SETTING2) | BF_CCM_PLL_CTRL3_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL3, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL3_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL3_SETTING3. */
#define BM_CCM_PLL_CTRL3_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL3_SETTING3. */
#define BS_CCM_PLL_CTRL3_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL3_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL3_SETTING3 field. */
#define BR_CCM_PLL_CTRL3_SETTING3(x) (HW_CCM_PLL_CTRL3(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL3_SETTING3. */
#define BF_CCM_PLL_CTRL3_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL3_SETTING3) & BM_CCM_PLL_CTRL3_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL3_SETTING3(x, v) (HW_CCM_PLL_CTRL3_WR(x, (HW_CCM_PLL_CTRL3_RD(x) & ~BM_CCM_PLL_CTRL3_SETTING3) | BF_CCM_PLL_CTRL3_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL4 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL4 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl4
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl4_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl4_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL4 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL4_ADDR(x) ((uintptr_t)(x) + 0x840U)
#define HW_CCM_PLL_CTRL4_SET_ADDR(x) (HW_CCM_PLL_CTRL4_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL4_CLR_ADDR(x) (HW_CCM_PLL_CTRL4_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL4_TOG_ADDR(x) (HW_CCM_PLL_CTRL4_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL4(x)      (*(__IO hw_ccm_pll_ctrl4_t *) HW_CCM_PLL_CTRL4_ADDR(x))
#define HW_CCM_PLL_CTRL4_RD(x)   (HW_CCM_PLL_CTRL4(x).U)
#define HW_CCM_PLL_CTRL4_WR(x, v) (HW_CCM_PLL_CTRL4(x).U = (v))
#define HW_CCM_PLL_CTRL4_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL4_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL4_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL4_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL4_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL4_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL4 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL4, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL4_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL4_SETTING0. */
#define BM_CCM_PLL_CTRL4_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL4_SETTING0. */
#define BS_CCM_PLL_CTRL4_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL4_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL4_SETTING0 field. */
#define BR_CCM_PLL_CTRL4_SETTING0(x) (HW_CCM_PLL_CTRL4(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL4_SETTING0. */
#define BF_CCM_PLL_CTRL4_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL4_SETTING0) & BM_CCM_PLL_CTRL4_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL4_SETTING0(x, v) (HW_CCM_PLL_CTRL4_WR(x, (HW_CCM_PLL_CTRL4_RD(x) & ~BM_CCM_PLL_CTRL4_SETTING0) | BF_CCM_PLL_CTRL4_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL4, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL4_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL4_SETTING1. */
#define BM_CCM_PLL_CTRL4_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL4_SETTING1. */
#define BS_CCM_PLL_CTRL4_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL4_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL4_SETTING1 field. */
#define BR_CCM_PLL_CTRL4_SETTING1(x) (HW_CCM_PLL_CTRL4(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL4_SETTING1. */
#define BF_CCM_PLL_CTRL4_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL4_SETTING1) & BM_CCM_PLL_CTRL4_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL4_SETTING1(x, v) (HW_CCM_PLL_CTRL4_WR(x, (HW_CCM_PLL_CTRL4_RD(x) & ~BM_CCM_PLL_CTRL4_SETTING1) | BF_CCM_PLL_CTRL4_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL4, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL4_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL4_SETTING2. */
#define BM_CCM_PLL_CTRL4_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL4_SETTING2. */
#define BS_CCM_PLL_CTRL4_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL4_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL4_SETTING2 field. */
#define BR_CCM_PLL_CTRL4_SETTING2(x) (HW_CCM_PLL_CTRL4(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL4_SETTING2. */
#define BF_CCM_PLL_CTRL4_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL4_SETTING2) & BM_CCM_PLL_CTRL4_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL4_SETTING2(x, v) (HW_CCM_PLL_CTRL4_WR(x, (HW_CCM_PLL_CTRL4_RD(x) & ~BM_CCM_PLL_CTRL4_SETTING2) | BF_CCM_PLL_CTRL4_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL4, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL4_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL4_SETTING3. */
#define BM_CCM_PLL_CTRL4_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL4_SETTING3. */
#define BS_CCM_PLL_CTRL4_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL4_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL4_SETTING3 field. */
#define BR_CCM_PLL_CTRL4_SETTING3(x) (HW_CCM_PLL_CTRL4(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL4_SETTING3. */
#define BF_CCM_PLL_CTRL4_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL4_SETTING3) & BM_CCM_PLL_CTRL4_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL4_SETTING3(x, v) (HW_CCM_PLL_CTRL4_WR(x, (HW_CCM_PLL_CTRL4_RD(x) & ~BM_CCM_PLL_CTRL4_SETTING3) | BF_CCM_PLL_CTRL4_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL5 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL5 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl5
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl5_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl5_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL5 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL5_ADDR(x) ((uintptr_t)(x) + 0x850U)
#define HW_CCM_PLL_CTRL5_SET_ADDR(x) (HW_CCM_PLL_CTRL5_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL5_CLR_ADDR(x) (HW_CCM_PLL_CTRL5_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL5_TOG_ADDR(x) (HW_CCM_PLL_CTRL5_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL5(x)      (*(__IO hw_ccm_pll_ctrl5_t *) HW_CCM_PLL_CTRL5_ADDR(x))
#define HW_CCM_PLL_CTRL5_RD(x)   (HW_CCM_PLL_CTRL5(x).U)
#define HW_CCM_PLL_CTRL5_WR(x, v) (HW_CCM_PLL_CTRL5(x).U = (v))
#define HW_CCM_PLL_CTRL5_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL5_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL5_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL5_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL5_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL5_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL5 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL5, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL5_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL5_SETTING0. */
#define BM_CCM_PLL_CTRL5_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL5_SETTING0. */
#define BS_CCM_PLL_CTRL5_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL5_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL5_SETTING0 field. */
#define BR_CCM_PLL_CTRL5_SETTING0(x) (HW_CCM_PLL_CTRL5(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL5_SETTING0. */
#define BF_CCM_PLL_CTRL5_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL5_SETTING0) & BM_CCM_PLL_CTRL5_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL5_SETTING0(x, v) (HW_CCM_PLL_CTRL5_WR(x, (HW_CCM_PLL_CTRL5_RD(x) & ~BM_CCM_PLL_CTRL5_SETTING0) | BF_CCM_PLL_CTRL5_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL5, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL5_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL5_SETTING1. */
#define BM_CCM_PLL_CTRL5_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL5_SETTING1. */
#define BS_CCM_PLL_CTRL5_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL5_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL5_SETTING1 field. */
#define BR_CCM_PLL_CTRL5_SETTING1(x) (HW_CCM_PLL_CTRL5(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL5_SETTING1. */
#define BF_CCM_PLL_CTRL5_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL5_SETTING1) & BM_CCM_PLL_CTRL5_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL5_SETTING1(x, v) (HW_CCM_PLL_CTRL5_WR(x, (HW_CCM_PLL_CTRL5_RD(x) & ~BM_CCM_PLL_CTRL5_SETTING1) | BF_CCM_PLL_CTRL5_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL5, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL5_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL5_SETTING2. */
#define BM_CCM_PLL_CTRL5_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL5_SETTING2. */
#define BS_CCM_PLL_CTRL5_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL5_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL5_SETTING2 field. */
#define BR_CCM_PLL_CTRL5_SETTING2(x) (HW_CCM_PLL_CTRL5(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL5_SETTING2. */
#define BF_CCM_PLL_CTRL5_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL5_SETTING2) & BM_CCM_PLL_CTRL5_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL5_SETTING2(x, v) (HW_CCM_PLL_CTRL5_WR(x, (HW_CCM_PLL_CTRL5_RD(x) & ~BM_CCM_PLL_CTRL5_SETTING2) | BF_CCM_PLL_CTRL5_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL5, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL5_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL5_SETTING3. */
#define BM_CCM_PLL_CTRL5_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL5_SETTING3. */
#define BS_CCM_PLL_CTRL5_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL5_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL5_SETTING3 field. */
#define BR_CCM_PLL_CTRL5_SETTING3(x) (HW_CCM_PLL_CTRL5(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL5_SETTING3. */
#define BF_CCM_PLL_CTRL5_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL5_SETTING3) & BM_CCM_PLL_CTRL5_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL5_SETTING3(x, v) (HW_CCM_PLL_CTRL5_WR(x, (HW_CCM_PLL_CTRL5_RD(x) & ~BM_CCM_PLL_CTRL5_SETTING3) | BF_CCM_PLL_CTRL5_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL6 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL6 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl6
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl6_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl6_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL6 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL6_ADDR(x) ((uintptr_t)(x) + 0x860U)
#define HW_CCM_PLL_CTRL6_SET_ADDR(x) (HW_CCM_PLL_CTRL6_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL6_CLR_ADDR(x) (HW_CCM_PLL_CTRL6_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL6_TOG_ADDR(x) (HW_CCM_PLL_CTRL6_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL6(x)      (*(__IO hw_ccm_pll_ctrl6_t *) HW_CCM_PLL_CTRL6_ADDR(x))
#define HW_CCM_PLL_CTRL6_RD(x)   (HW_CCM_PLL_CTRL6(x).U)
#define HW_CCM_PLL_CTRL6_WR(x, v) (HW_CCM_PLL_CTRL6(x).U = (v))
#define HW_CCM_PLL_CTRL6_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL6_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL6_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL6_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL6_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL6_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL6 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL6, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL6_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL6_SETTING0. */
#define BM_CCM_PLL_CTRL6_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL6_SETTING0. */
#define BS_CCM_PLL_CTRL6_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL6_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL6_SETTING0 field. */
#define BR_CCM_PLL_CTRL6_SETTING0(x) (HW_CCM_PLL_CTRL6(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL6_SETTING0. */
#define BF_CCM_PLL_CTRL6_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL6_SETTING0) & BM_CCM_PLL_CTRL6_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL6_SETTING0(x, v) (HW_CCM_PLL_CTRL6_WR(x, (HW_CCM_PLL_CTRL6_RD(x) & ~BM_CCM_PLL_CTRL6_SETTING0) | BF_CCM_PLL_CTRL6_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL6, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL6_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL6_SETTING1. */
#define BM_CCM_PLL_CTRL6_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL6_SETTING1. */
#define BS_CCM_PLL_CTRL6_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL6_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL6_SETTING1 field. */
#define BR_CCM_PLL_CTRL6_SETTING1(x) (HW_CCM_PLL_CTRL6(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL6_SETTING1. */
#define BF_CCM_PLL_CTRL6_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL6_SETTING1) & BM_CCM_PLL_CTRL6_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL6_SETTING1(x, v) (HW_CCM_PLL_CTRL6_WR(x, (HW_CCM_PLL_CTRL6_RD(x) & ~BM_CCM_PLL_CTRL6_SETTING1) | BF_CCM_PLL_CTRL6_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL6, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL6_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL6_SETTING2. */
#define BM_CCM_PLL_CTRL6_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL6_SETTING2. */
#define BS_CCM_PLL_CTRL6_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL6_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL6_SETTING2 field. */
#define BR_CCM_PLL_CTRL6_SETTING2(x) (HW_CCM_PLL_CTRL6(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL6_SETTING2. */
#define BF_CCM_PLL_CTRL6_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL6_SETTING2) & BM_CCM_PLL_CTRL6_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL6_SETTING2(x, v) (HW_CCM_PLL_CTRL6_WR(x, (HW_CCM_PLL_CTRL6_RD(x) & ~BM_CCM_PLL_CTRL6_SETTING2) | BF_CCM_PLL_CTRL6_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL6, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL6_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL6_SETTING3. */
#define BM_CCM_PLL_CTRL6_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL6_SETTING3. */
#define BS_CCM_PLL_CTRL6_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL6_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL6_SETTING3 field. */
#define BR_CCM_PLL_CTRL6_SETTING3(x) (HW_CCM_PLL_CTRL6(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL6_SETTING3. */
#define BF_CCM_PLL_CTRL6_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL6_SETTING3) & BM_CCM_PLL_CTRL6_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL6_SETTING3(x, v) (HW_CCM_PLL_CTRL6_WR(x, (HW_CCM_PLL_CTRL6_RD(x) & ~BM_CCM_PLL_CTRL6_SETTING3) | BF_CCM_PLL_CTRL6_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL7 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL7 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl7
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl7_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl7_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL7 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL7_ADDR(x) ((uintptr_t)(x) + 0x870U)
#define HW_CCM_PLL_CTRL7_SET_ADDR(x) (HW_CCM_PLL_CTRL7_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL7_CLR_ADDR(x) (HW_CCM_PLL_CTRL7_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL7_TOG_ADDR(x) (HW_CCM_PLL_CTRL7_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL7(x)      (*(__IO hw_ccm_pll_ctrl7_t *) HW_CCM_PLL_CTRL7_ADDR(x))
#define HW_CCM_PLL_CTRL7_RD(x)   (HW_CCM_PLL_CTRL7(x).U)
#define HW_CCM_PLL_CTRL7_WR(x, v) (HW_CCM_PLL_CTRL7(x).U = (v))
#define HW_CCM_PLL_CTRL7_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL7_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL7_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL7_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL7_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL7_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL7 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL7, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL7_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL7_SETTING0. */
#define BM_CCM_PLL_CTRL7_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL7_SETTING0. */
#define BS_CCM_PLL_CTRL7_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL7_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL7_SETTING0 field. */
#define BR_CCM_PLL_CTRL7_SETTING0(x) (HW_CCM_PLL_CTRL7(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL7_SETTING0. */
#define BF_CCM_PLL_CTRL7_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL7_SETTING0) & BM_CCM_PLL_CTRL7_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL7_SETTING0(x, v) (HW_CCM_PLL_CTRL7_WR(x, (HW_CCM_PLL_CTRL7_RD(x) & ~BM_CCM_PLL_CTRL7_SETTING0) | BF_CCM_PLL_CTRL7_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL7, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL7_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL7_SETTING1. */
#define BM_CCM_PLL_CTRL7_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL7_SETTING1. */
#define BS_CCM_PLL_CTRL7_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL7_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL7_SETTING1 field. */
#define BR_CCM_PLL_CTRL7_SETTING1(x) (HW_CCM_PLL_CTRL7(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL7_SETTING1. */
#define BF_CCM_PLL_CTRL7_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL7_SETTING1) & BM_CCM_PLL_CTRL7_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL7_SETTING1(x, v) (HW_CCM_PLL_CTRL7_WR(x, (HW_CCM_PLL_CTRL7_RD(x) & ~BM_CCM_PLL_CTRL7_SETTING1) | BF_CCM_PLL_CTRL7_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL7, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL7_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL7_SETTING2. */
#define BM_CCM_PLL_CTRL7_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL7_SETTING2. */
#define BS_CCM_PLL_CTRL7_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL7_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL7_SETTING2 field. */
#define BR_CCM_PLL_CTRL7_SETTING2(x) (HW_CCM_PLL_CTRL7(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL7_SETTING2. */
#define BF_CCM_PLL_CTRL7_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL7_SETTING2) & BM_CCM_PLL_CTRL7_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL7_SETTING2(x, v) (HW_CCM_PLL_CTRL7_WR(x, (HW_CCM_PLL_CTRL7_RD(x) & ~BM_CCM_PLL_CTRL7_SETTING2) | BF_CCM_PLL_CTRL7_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL7, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL7_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL7_SETTING3. */
#define BM_CCM_PLL_CTRL7_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL7_SETTING3. */
#define BS_CCM_PLL_CTRL7_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL7_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL7_SETTING3 field. */
#define BR_CCM_PLL_CTRL7_SETTING3(x) (HW_CCM_PLL_CTRL7(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL7_SETTING3. */
#define BF_CCM_PLL_CTRL7_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL7_SETTING3) & BM_CCM_PLL_CTRL7_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL7_SETTING3(x, v) (HW_CCM_PLL_CTRL7_WR(x, (HW_CCM_PLL_CTRL7_RD(x) & ~BM_CCM_PLL_CTRL7_SETTING3) | BF_CCM_PLL_CTRL7_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL8 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL8 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl8
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl8_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl8_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL8 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL8_ADDR(x) ((uintptr_t)(x) + 0x880U)
#define HW_CCM_PLL_CTRL8_SET_ADDR(x) (HW_CCM_PLL_CTRL8_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL8_CLR_ADDR(x) (HW_CCM_PLL_CTRL8_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL8_TOG_ADDR(x) (HW_CCM_PLL_CTRL8_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL8(x)      (*(__IO hw_ccm_pll_ctrl8_t *) HW_CCM_PLL_CTRL8_ADDR(x))
#define HW_CCM_PLL_CTRL8_RD(x)   (HW_CCM_PLL_CTRL8(x).U)
#define HW_CCM_PLL_CTRL8_WR(x, v) (HW_CCM_PLL_CTRL8(x).U = (v))
#define HW_CCM_PLL_CTRL8_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL8_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL8_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL8_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL8_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL8_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL8 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL8, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL8_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL8_SETTING0. */
#define BM_CCM_PLL_CTRL8_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL8_SETTING0. */
#define BS_CCM_PLL_CTRL8_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL8_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL8_SETTING0 field. */
#define BR_CCM_PLL_CTRL8_SETTING0(x) (HW_CCM_PLL_CTRL8(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL8_SETTING0. */
#define BF_CCM_PLL_CTRL8_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL8_SETTING0) & BM_CCM_PLL_CTRL8_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL8_SETTING0(x, v) (HW_CCM_PLL_CTRL8_WR(x, (HW_CCM_PLL_CTRL8_RD(x) & ~BM_CCM_PLL_CTRL8_SETTING0) | BF_CCM_PLL_CTRL8_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL8, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL8_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL8_SETTING1. */
#define BM_CCM_PLL_CTRL8_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL8_SETTING1. */
#define BS_CCM_PLL_CTRL8_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL8_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL8_SETTING1 field. */
#define BR_CCM_PLL_CTRL8_SETTING1(x) (HW_CCM_PLL_CTRL8(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL8_SETTING1. */
#define BF_CCM_PLL_CTRL8_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL8_SETTING1) & BM_CCM_PLL_CTRL8_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL8_SETTING1(x, v) (HW_CCM_PLL_CTRL8_WR(x, (HW_CCM_PLL_CTRL8_RD(x) & ~BM_CCM_PLL_CTRL8_SETTING1) | BF_CCM_PLL_CTRL8_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL8, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL8_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL8_SETTING2. */
#define BM_CCM_PLL_CTRL8_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL8_SETTING2. */
#define BS_CCM_PLL_CTRL8_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL8_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL8_SETTING2 field. */
#define BR_CCM_PLL_CTRL8_SETTING2(x) (HW_CCM_PLL_CTRL8(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL8_SETTING2. */
#define BF_CCM_PLL_CTRL8_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL8_SETTING2) & BM_CCM_PLL_CTRL8_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL8_SETTING2(x, v) (HW_CCM_PLL_CTRL8_WR(x, (HW_CCM_PLL_CTRL8_RD(x) & ~BM_CCM_PLL_CTRL8_SETTING2) | BF_CCM_PLL_CTRL8_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL8, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL8_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL8_SETTING3. */
#define BM_CCM_PLL_CTRL8_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL8_SETTING3. */
#define BS_CCM_PLL_CTRL8_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL8_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL8_SETTING3 field. */
#define BR_CCM_PLL_CTRL8_SETTING3(x) (HW_CCM_PLL_CTRL8(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL8_SETTING3. */
#define BF_CCM_PLL_CTRL8_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL8_SETTING3) & BM_CCM_PLL_CTRL8_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL8_SETTING3(x, v) (HW_CCM_PLL_CTRL8_WR(x, (HW_CCM_PLL_CTRL8_RD(x) & ~BM_CCM_PLL_CTRL8_SETTING3) | BF_CCM_PLL_CTRL8_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL9 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL9 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl9
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl9_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl9_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL9 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL9_ADDR(x) ((uintptr_t)(x) + 0x890U)
#define HW_CCM_PLL_CTRL9_SET_ADDR(x) (HW_CCM_PLL_CTRL9_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL9_CLR_ADDR(x) (HW_CCM_PLL_CTRL9_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL9_TOG_ADDR(x) (HW_CCM_PLL_CTRL9_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL9(x)      (*(__IO hw_ccm_pll_ctrl9_t *) HW_CCM_PLL_CTRL9_ADDR(x))
#define HW_CCM_PLL_CTRL9_RD(x)   (HW_CCM_PLL_CTRL9(x).U)
#define HW_CCM_PLL_CTRL9_WR(x, v) (HW_CCM_PLL_CTRL9(x).U = (v))
#define HW_CCM_PLL_CTRL9_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL9_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL9_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL9_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL9_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL9_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL9 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL9, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL9_SETTING0 (0U)     /*!< Bit position for CCM_PLL_CTRL9_SETTING0. */
#define BM_CCM_PLL_CTRL9_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL9_SETTING0. */
#define BS_CCM_PLL_CTRL9_SETTING0 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL9_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL9_SETTING0 field. */
#define BR_CCM_PLL_CTRL9_SETTING0(x) (HW_CCM_PLL_CTRL9(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL9_SETTING0. */
#define BF_CCM_PLL_CTRL9_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL9_SETTING0) & BM_CCM_PLL_CTRL9_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL9_SETTING0(x, v) (HW_CCM_PLL_CTRL9_WR(x, (HW_CCM_PLL_CTRL9_RD(x) & ~BM_CCM_PLL_CTRL9_SETTING0) | BF_CCM_PLL_CTRL9_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL9, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL9_SETTING1 (4U)     /*!< Bit position for CCM_PLL_CTRL9_SETTING1. */
#define BM_CCM_PLL_CTRL9_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL9_SETTING1. */
#define BS_CCM_PLL_CTRL9_SETTING1 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL9_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL9_SETTING1 field. */
#define BR_CCM_PLL_CTRL9_SETTING1(x) (HW_CCM_PLL_CTRL9(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL9_SETTING1. */
#define BF_CCM_PLL_CTRL9_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL9_SETTING1) & BM_CCM_PLL_CTRL9_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL9_SETTING1(x, v) (HW_CCM_PLL_CTRL9_WR(x, (HW_CCM_PLL_CTRL9_RD(x) & ~BM_CCM_PLL_CTRL9_SETTING1) | BF_CCM_PLL_CTRL9_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL9, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL9_SETTING2 (8U)     /*!< Bit position for CCM_PLL_CTRL9_SETTING2. */
#define BM_CCM_PLL_CTRL9_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL9_SETTING2. */
#define BS_CCM_PLL_CTRL9_SETTING2 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL9_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL9_SETTING2 field. */
#define BR_CCM_PLL_CTRL9_SETTING2(x) (HW_CCM_PLL_CTRL9(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL9_SETTING2. */
#define BF_CCM_PLL_CTRL9_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL9_SETTING2) & BM_CCM_PLL_CTRL9_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL9_SETTING2(x, v) (HW_CCM_PLL_CTRL9_WR(x, (HW_CCM_PLL_CTRL9_RD(x) & ~BM_CCM_PLL_CTRL9_SETTING2) | BF_CCM_PLL_CTRL9_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL9, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL9_SETTING3 (12U)    /*!< Bit position for CCM_PLL_CTRL9_SETTING3. */
#define BM_CCM_PLL_CTRL9_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL9_SETTING3. */
#define BS_CCM_PLL_CTRL9_SETTING3 (2U)     /*!< Bit field size in bits for CCM_PLL_CTRL9_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL9_SETTING3 field. */
#define BR_CCM_PLL_CTRL9_SETTING3(x) (HW_CCM_PLL_CTRL9(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL9_SETTING3. */
#define BF_CCM_PLL_CTRL9_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL9_SETTING3) & BM_CCM_PLL_CTRL9_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL9_SETTING3(x, v) (HW_CCM_PLL_CTRL9_WR(x, (HW_CCM_PLL_CTRL9_RD(x) & ~BM_CCM_PLL_CTRL9_SETTING3) | BF_CCM_PLL_CTRL9_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL10 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL10 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl10
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl10_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl10_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL10 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL10_ADDR(x) ((uintptr_t)(x) + 0x8A0U)
#define HW_CCM_PLL_CTRL10_SET_ADDR(x) (HW_CCM_PLL_CTRL10_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL10_CLR_ADDR(x) (HW_CCM_PLL_CTRL10_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL10_TOG_ADDR(x) (HW_CCM_PLL_CTRL10_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL10(x)     (*(__IO hw_ccm_pll_ctrl10_t *) HW_CCM_PLL_CTRL10_ADDR(x))
#define HW_CCM_PLL_CTRL10_RD(x)  (HW_CCM_PLL_CTRL10(x).U)
#define HW_CCM_PLL_CTRL10_WR(x, v) (HW_CCM_PLL_CTRL10(x).U = (v))
#define HW_CCM_PLL_CTRL10_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL10_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL10_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL10_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL10_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL10_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL10 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL10, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL10_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL10_SETTING0. */
#define BM_CCM_PLL_CTRL10_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL10_SETTING0. */
#define BS_CCM_PLL_CTRL10_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL10_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL10_SETTING0 field. */
#define BR_CCM_PLL_CTRL10_SETTING0(x) (HW_CCM_PLL_CTRL10(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL10_SETTING0. */
#define BF_CCM_PLL_CTRL10_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL10_SETTING0) & BM_CCM_PLL_CTRL10_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL10_SETTING0(x, v) (HW_CCM_PLL_CTRL10_WR(x, (HW_CCM_PLL_CTRL10_RD(x) & ~BM_CCM_PLL_CTRL10_SETTING0) | BF_CCM_PLL_CTRL10_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL10, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL10_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL10_SETTING1. */
#define BM_CCM_PLL_CTRL10_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL10_SETTING1. */
#define BS_CCM_PLL_CTRL10_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL10_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL10_SETTING1 field. */
#define BR_CCM_PLL_CTRL10_SETTING1(x) (HW_CCM_PLL_CTRL10(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL10_SETTING1. */
#define BF_CCM_PLL_CTRL10_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL10_SETTING1) & BM_CCM_PLL_CTRL10_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL10_SETTING1(x, v) (HW_CCM_PLL_CTRL10_WR(x, (HW_CCM_PLL_CTRL10_RD(x) & ~BM_CCM_PLL_CTRL10_SETTING1) | BF_CCM_PLL_CTRL10_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL10, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL10_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL10_SETTING2. */
#define BM_CCM_PLL_CTRL10_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL10_SETTING2. */
#define BS_CCM_PLL_CTRL10_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL10_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL10_SETTING2 field. */
#define BR_CCM_PLL_CTRL10_SETTING2(x) (HW_CCM_PLL_CTRL10(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL10_SETTING2. */
#define BF_CCM_PLL_CTRL10_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL10_SETTING2) & BM_CCM_PLL_CTRL10_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL10_SETTING2(x, v) (HW_CCM_PLL_CTRL10_WR(x, (HW_CCM_PLL_CTRL10_RD(x) & ~BM_CCM_PLL_CTRL10_SETTING2) | BF_CCM_PLL_CTRL10_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL10, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL10_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL10_SETTING3. */
#define BM_CCM_PLL_CTRL10_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL10_SETTING3. */
#define BS_CCM_PLL_CTRL10_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL10_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL10_SETTING3 field. */
#define BR_CCM_PLL_CTRL10_SETTING3(x) (HW_CCM_PLL_CTRL10(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL10_SETTING3. */
#define BF_CCM_PLL_CTRL10_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL10_SETTING3) & BM_CCM_PLL_CTRL10_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL10_SETTING3(x, v) (HW_CCM_PLL_CTRL10_WR(x, (HW_CCM_PLL_CTRL10_RD(x) & ~BM_CCM_PLL_CTRL10_SETTING3) | BF_CCM_PLL_CTRL10_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL11 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL11 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl11
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl11_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl11_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL11 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL11_ADDR(x) ((uintptr_t)(x) + 0x8B0U)
#define HW_CCM_PLL_CTRL11_SET_ADDR(x) (HW_CCM_PLL_CTRL11_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL11_CLR_ADDR(x) (HW_CCM_PLL_CTRL11_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL11_TOG_ADDR(x) (HW_CCM_PLL_CTRL11_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL11(x)     (*(__IO hw_ccm_pll_ctrl11_t *) HW_CCM_PLL_CTRL11_ADDR(x))
#define HW_CCM_PLL_CTRL11_RD(x)  (HW_CCM_PLL_CTRL11(x).U)
#define HW_CCM_PLL_CTRL11_WR(x, v) (HW_CCM_PLL_CTRL11(x).U = (v))
#define HW_CCM_PLL_CTRL11_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL11_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL11_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL11_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL11_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL11_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL11 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL11, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL11_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL11_SETTING0. */
#define BM_CCM_PLL_CTRL11_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL11_SETTING0. */
#define BS_CCM_PLL_CTRL11_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL11_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL11_SETTING0 field. */
#define BR_CCM_PLL_CTRL11_SETTING0(x) (HW_CCM_PLL_CTRL11(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL11_SETTING0. */
#define BF_CCM_PLL_CTRL11_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL11_SETTING0) & BM_CCM_PLL_CTRL11_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL11_SETTING0(x, v) (HW_CCM_PLL_CTRL11_WR(x, (HW_CCM_PLL_CTRL11_RD(x) & ~BM_CCM_PLL_CTRL11_SETTING0) | BF_CCM_PLL_CTRL11_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL11, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL11_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL11_SETTING1. */
#define BM_CCM_PLL_CTRL11_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL11_SETTING1. */
#define BS_CCM_PLL_CTRL11_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL11_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL11_SETTING1 field. */
#define BR_CCM_PLL_CTRL11_SETTING1(x) (HW_CCM_PLL_CTRL11(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL11_SETTING1. */
#define BF_CCM_PLL_CTRL11_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL11_SETTING1) & BM_CCM_PLL_CTRL11_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL11_SETTING1(x, v) (HW_CCM_PLL_CTRL11_WR(x, (HW_CCM_PLL_CTRL11_RD(x) & ~BM_CCM_PLL_CTRL11_SETTING1) | BF_CCM_PLL_CTRL11_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL11, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL11_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL11_SETTING2. */
#define BM_CCM_PLL_CTRL11_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL11_SETTING2. */
#define BS_CCM_PLL_CTRL11_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL11_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL11_SETTING2 field. */
#define BR_CCM_PLL_CTRL11_SETTING2(x) (HW_CCM_PLL_CTRL11(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL11_SETTING2. */
#define BF_CCM_PLL_CTRL11_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL11_SETTING2) & BM_CCM_PLL_CTRL11_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL11_SETTING2(x, v) (HW_CCM_PLL_CTRL11_WR(x, (HW_CCM_PLL_CTRL11_RD(x) & ~BM_CCM_PLL_CTRL11_SETTING2) | BF_CCM_PLL_CTRL11_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL11, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL11_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL11_SETTING3. */
#define BM_CCM_PLL_CTRL11_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL11_SETTING3. */
#define BS_CCM_PLL_CTRL11_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL11_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL11_SETTING3 field. */
#define BR_CCM_PLL_CTRL11_SETTING3(x) (HW_CCM_PLL_CTRL11(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL11_SETTING3. */
#define BF_CCM_PLL_CTRL11_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL11_SETTING3) & BM_CCM_PLL_CTRL11_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL11_SETTING3(x, v) (HW_CCM_PLL_CTRL11_WR(x, (HW_CCM_PLL_CTRL11_RD(x) & ~BM_CCM_PLL_CTRL11_SETTING3) | BF_CCM_PLL_CTRL11_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL12 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL12 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl12
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl12_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl12_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL12 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL12_ADDR(x) ((uintptr_t)(x) + 0x8C0U)
#define HW_CCM_PLL_CTRL12_SET_ADDR(x) (HW_CCM_PLL_CTRL12_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL12_CLR_ADDR(x) (HW_CCM_PLL_CTRL12_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL12_TOG_ADDR(x) (HW_CCM_PLL_CTRL12_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL12(x)     (*(__IO hw_ccm_pll_ctrl12_t *) HW_CCM_PLL_CTRL12_ADDR(x))
#define HW_CCM_PLL_CTRL12_RD(x)  (HW_CCM_PLL_CTRL12(x).U)
#define HW_CCM_PLL_CTRL12_WR(x, v) (HW_CCM_PLL_CTRL12(x).U = (v))
#define HW_CCM_PLL_CTRL12_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL12_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL12_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL12_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL12_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL12_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL12 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL12, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL12_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL12_SETTING0. */
#define BM_CCM_PLL_CTRL12_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL12_SETTING0. */
#define BS_CCM_PLL_CTRL12_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL12_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL12_SETTING0 field. */
#define BR_CCM_PLL_CTRL12_SETTING0(x) (HW_CCM_PLL_CTRL12(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL12_SETTING0. */
#define BF_CCM_PLL_CTRL12_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL12_SETTING0) & BM_CCM_PLL_CTRL12_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL12_SETTING0(x, v) (HW_CCM_PLL_CTRL12_WR(x, (HW_CCM_PLL_CTRL12_RD(x) & ~BM_CCM_PLL_CTRL12_SETTING0) | BF_CCM_PLL_CTRL12_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL12, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL12_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL12_SETTING1. */
#define BM_CCM_PLL_CTRL12_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL12_SETTING1. */
#define BS_CCM_PLL_CTRL12_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL12_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL12_SETTING1 field. */
#define BR_CCM_PLL_CTRL12_SETTING1(x) (HW_CCM_PLL_CTRL12(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL12_SETTING1. */
#define BF_CCM_PLL_CTRL12_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL12_SETTING1) & BM_CCM_PLL_CTRL12_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL12_SETTING1(x, v) (HW_CCM_PLL_CTRL12_WR(x, (HW_CCM_PLL_CTRL12_RD(x) & ~BM_CCM_PLL_CTRL12_SETTING1) | BF_CCM_PLL_CTRL12_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL12, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL12_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL12_SETTING2. */
#define BM_CCM_PLL_CTRL12_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL12_SETTING2. */
#define BS_CCM_PLL_CTRL12_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL12_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL12_SETTING2 field. */
#define BR_CCM_PLL_CTRL12_SETTING2(x) (HW_CCM_PLL_CTRL12(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL12_SETTING2. */
#define BF_CCM_PLL_CTRL12_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL12_SETTING2) & BM_CCM_PLL_CTRL12_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL12_SETTING2(x, v) (HW_CCM_PLL_CTRL12_WR(x, (HW_CCM_PLL_CTRL12_RD(x) & ~BM_CCM_PLL_CTRL12_SETTING2) | BF_CCM_PLL_CTRL12_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL12, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL12_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL12_SETTING3. */
#define BM_CCM_PLL_CTRL12_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL12_SETTING3. */
#define BS_CCM_PLL_CTRL12_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL12_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL12_SETTING3 field. */
#define BR_CCM_PLL_CTRL12_SETTING3(x) (HW_CCM_PLL_CTRL12(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL12_SETTING3. */
#define BF_CCM_PLL_CTRL12_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL12_SETTING3) & BM_CCM_PLL_CTRL12_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL12_SETTING3(x, v) (HW_CCM_PLL_CTRL12_WR(x, (HW_CCM_PLL_CTRL12_RD(x) & ~BM_CCM_PLL_CTRL12_SETTING3) | BF_CCM_PLL_CTRL12_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL13 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL13 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl13
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl13_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl13_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL13 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL13_ADDR(x) ((uintptr_t)(x) + 0x8D0U)
#define HW_CCM_PLL_CTRL13_SET_ADDR(x) (HW_CCM_PLL_CTRL13_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL13_CLR_ADDR(x) (HW_CCM_PLL_CTRL13_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL13_TOG_ADDR(x) (HW_CCM_PLL_CTRL13_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL13(x)     (*(__IO hw_ccm_pll_ctrl13_t *) HW_CCM_PLL_CTRL13_ADDR(x))
#define HW_CCM_PLL_CTRL13_RD(x)  (HW_CCM_PLL_CTRL13(x).U)
#define HW_CCM_PLL_CTRL13_WR(x, v) (HW_CCM_PLL_CTRL13(x).U = (v))
#define HW_CCM_PLL_CTRL13_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL13_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL13_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL13_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL13_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL13_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL13 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL13, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL13_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL13_SETTING0. */
#define BM_CCM_PLL_CTRL13_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL13_SETTING0. */
#define BS_CCM_PLL_CTRL13_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL13_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL13_SETTING0 field. */
#define BR_CCM_PLL_CTRL13_SETTING0(x) (HW_CCM_PLL_CTRL13(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL13_SETTING0. */
#define BF_CCM_PLL_CTRL13_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL13_SETTING0) & BM_CCM_PLL_CTRL13_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL13_SETTING0(x, v) (HW_CCM_PLL_CTRL13_WR(x, (HW_CCM_PLL_CTRL13_RD(x) & ~BM_CCM_PLL_CTRL13_SETTING0) | BF_CCM_PLL_CTRL13_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL13, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL13_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL13_SETTING1. */
#define BM_CCM_PLL_CTRL13_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL13_SETTING1. */
#define BS_CCM_PLL_CTRL13_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL13_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL13_SETTING1 field. */
#define BR_CCM_PLL_CTRL13_SETTING1(x) (HW_CCM_PLL_CTRL13(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL13_SETTING1. */
#define BF_CCM_PLL_CTRL13_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL13_SETTING1) & BM_CCM_PLL_CTRL13_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL13_SETTING1(x, v) (HW_CCM_PLL_CTRL13_WR(x, (HW_CCM_PLL_CTRL13_RD(x) & ~BM_CCM_PLL_CTRL13_SETTING1) | BF_CCM_PLL_CTRL13_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL13, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL13_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL13_SETTING2. */
#define BM_CCM_PLL_CTRL13_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL13_SETTING2. */
#define BS_CCM_PLL_CTRL13_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL13_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL13_SETTING2 field. */
#define BR_CCM_PLL_CTRL13_SETTING2(x) (HW_CCM_PLL_CTRL13(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL13_SETTING2. */
#define BF_CCM_PLL_CTRL13_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL13_SETTING2) & BM_CCM_PLL_CTRL13_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL13_SETTING2(x, v) (HW_CCM_PLL_CTRL13_WR(x, (HW_CCM_PLL_CTRL13_RD(x) & ~BM_CCM_PLL_CTRL13_SETTING2) | BF_CCM_PLL_CTRL13_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL13, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL13_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL13_SETTING3. */
#define BM_CCM_PLL_CTRL13_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL13_SETTING3. */
#define BS_CCM_PLL_CTRL13_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL13_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL13_SETTING3 field. */
#define BR_CCM_PLL_CTRL13_SETTING3(x) (HW_CCM_PLL_CTRL13(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL13_SETTING3. */
#define BF_CCM_PLL_CTRL13_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL13_SETTING3) & BM_CCM_PLL_CTRL13_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL13_SETTING3(x, v) (HW_CCM_PLL_CTRL13_WR(x, (HW_CCM_PLL_CTRL13_RD(x) & ~BM_CCM_PLL_CTRL13_SETTING3) | BF_CCM_PLL_CTRL13_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL14 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL14 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl14
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl14_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl14_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL14 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL14_ADDR(x) ((uintptr_t)(x) + 0x8E0U)
#define HW_CCM_PLL_CTRL14_SET_ADDR(x) (HW_CCM_PLL_CTRL14_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL14_CLR_ADDR(x) (HW_CCM_PLL_CTRL14_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL14_TOG_ADDR(x) (HW_CCM_PLL_CTRL14_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL14(x)     (*(__IO hw_ccm_pll_ctrl14_t *) HW_CCM_PLL_CTRL14_ADDR(x))
#define HW_CCM_PLL_CTRL14_RD(x)  (HW_CCM_PLL_CTRL14(x).U)
#define HW_CCM_PLL_CTRL14_WR(x, v) (HW_CCM_PLL_CTRL14(x).U = (v))
#define HW_CCM_PLL_CTRL14_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL14_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL14_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL14_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL14_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL14_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL14 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL14, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL14_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL14_SETTING0. */
#define BM_CCM_PLL_CTRL14_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL14_SETTING0. */
#define BS_CCM_PLL_CTRL14_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL14_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL14_SETTING0 field. */
#define BR_CCM_PLL_CTRL14_SETTING0(x) (HW_CCM_PLL_CTRL14(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL14_SETTING0. */
#define BF_CCM_PLL_CTRL14_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL14_SETTING0) & BM_CCM_PLL_CTRL14_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL14_SETTING0(x, v) (HW_CCM_PLL_CTRL14_WR(x, (HW_CCM_PLL_CTRL14_RD(x) & ~BM_CCM_PLL_CTRL14_SETTING0) | BF_CCM_PLL_CTRL14_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL14, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL14_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL14_SETTING1. */
#define BM_CCM_PLL_CTRL14_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL14_SETTING1. */
#define BS_CCM_PLL_CTRL14_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL14_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL14_SETTING1 field. */
#define BR_CCM_PLL_CTRL14_SETTING1(x) (HW_CCM_PLL_CTRL14(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL14_SETTING1. */
#define BF_CCM_PLL_CTRL14_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL14_SETTING1) & BM_CCM_PLL_CTRL14_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL14_SETTING1(x, v) (HW_CCM_PLL_CTRL14_WR(x, (HW_CCM_PLL_CTRL14_RD(x) & ~BM_CCM_PLL_CTRL14_SETTING1) | BF_CCM_PLL_CTRL14_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL14, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL14_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL14_SETTING2. */
#define BM_CCM_PLL_CTRL14_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL14_SETTING2. */
#define BS_CCM_PLL_CTRL14_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL14_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL14_SETTING2 field. */
#define BR_CCM_PLL_CTRL14_SETTING2(x) (HW_CCM_PLL_CTRL14(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL14_SETTING2. */
#define BF_CCM_PLL_CTRL14_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL14_SETTING2) & BM_CCM_PLL_CTRL14_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL14_SETTING2(x, v) (HW_CCM_PLL_CTRL14_WR(x, (HW_CCM_PLL_CTRL14_RD(x) & ~BM_CCM_PLL_CTRL14_SETTING2) | BF_CCM_PLL_CTRL14_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL14, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL14_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL14_SETTING3. */
#define BM_CCM_PLL_CTRL14_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL14_SETTING3. */
#define BS_CCM_PLL_CTRL14_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL14_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL14_SETTING3 field. */
#define BR_CCM_PLL_CTRL14_SETTING3(x) (HW_CCM_PLL_CTRL14(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL14_SETTING3. */
#define BF_CCM_PLL_CTRL14_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL14_SETTING3) & BM_CCM_PLL_CTRL14_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL14_SETTING3(x, v) (HW_CCM_PLL_CTRL14_WR(x, (HW_CCM_PLL_CTRL14_RD(x) & ~BM_CCM_PLL_CTRL14_SETTING3) | BF_CCM_PLL_CTRL14_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL15 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL15 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl15
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl15_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl15_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL15 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL15_ADDR(x) ((uintptr_t)(x) + 0x8F0U)
#define HW_CCM_PLL_CTRL15_SET_ADDR(x) (HW_CCM_PLL_CTRL15_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL15_CLR_ADDR(x) (HW_CCM_PLL_CTRL15_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL15_TOG_ADDR(x) (HW_CCM_PLL_CTRL15_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL15(x)     (*(__IO hw_ccm_pll_ctrl15_t *) HW_CCM_PLL_CTRL15_ADDR(x))
#define HW_CCM_PLL_CTRL15_RD(x)  (HW_CCM_PLL_CTRL15(x).U)
#define HW_CCM_PLL_CTRL15_WR(x, v) (HW_CCM_PLL_CTRL15(x).U = (v))
#define HW_CCM_PLL_CTRL15_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL15_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL15_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL15_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL15_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL15_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL15 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL15, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL15_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL15_SETTING0. */
#define BM_CCM_PLL_CTRL15_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL15_SETTING0. */
#define BS_CCM_PLL_CTRL15_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL15_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL15_SETTING0 field. */
#define BR_CCM_PLL_CTRL15_SETTING0(x) (HW_CCM_PLL_CTRL15(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL15_SETTING0. */
#define BF_CCM_PLL_CTRL15_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL15_SETTING0) & BM_CCM_PLL_CTRL15_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL15_SETTING0(x, v) (HW_CCM_PLL_CTRL15_WR(x, (HW_CCM_PLL_CTRL15_RD(x) & ~BM_CCM_PLL_CTRL15_SETTING0) | BF_CCM_PLL_CTRL15_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL15, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL15_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL15_SETTING1. */
#define BM_CCM_PLL_CTRL15_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL15_SETTING1. */
#define BS_CCM_PLL_CTRL15_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL15_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL15_SETTING1 field. */
#define BR_CCM_PLL_CTRL15_SETTING1(x) (HW_CCM_PLL_CTRL15(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL15_SETTING1. */
#define BF_CCM_PLL_CTRL15_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL15_SETTING1) & BM_CCM_PLL_CTRL15_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL15_SETTING1(x, v) (HW_CCM_PLL_CTRL15_WR(x, (HW_CCM_PLL_CTRL15_RD(x) & ~BM_CCM_PLL_CTRL15_SETTING1) | BF_CCM_PLL_CTRL15_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL15, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL15_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL15_SETTING2. */
#define BM_CCM_PLL_CTRL15_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL15_SETTING2. */
#define BS_CCM_PLL_CTRL15_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL15_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL15_SETTING2 field. */
#define BR_CCM_PLL_CTRL15_SETTING2(x) (HW_CCM_PLL_CTRL15(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL15_SETTING2. */
#define BF_CCM_PLL_CTRL15_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL15_SETTING2) & BM_CCM_PLL_CTRL15_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL15_SETTING2(x, v) (HW_CCM_PLL_CTRL15_WR(x, (HW_CCM_PLL_CTRL15_RD(x) & ~BM_CCM_PLL_CTRL15_SETTING2) | BF_CCM_PLL_CTRL15_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL15, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL15_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL15_SETTING3. */
#define BM_CCM_PLL_CTRL15_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL15_SETTING3. */
#define BS_CCM_PLL_CTRL15_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL15_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL15_SETTING3 field. */
#define BR_CCM_PLL_CTRL15_SETTING3(x) (HW_CCM_PLL_CTRL15(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL15_SETTING3. */
#define BF_CCM_PLL_CTRL15_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL15_SETTING3) & BM_CCM_PLL_CTRL15_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL15_SETTING3(x, v) (HW_CCM_PLL_CTRL15_WR(x, (HW_CCM_PLL_CTRL15_RD(x) & ~BM_CCM_PLL_CTRL15_SETTING3) | BF_CCM_PLL_CTRL15_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL16 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL16 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl16
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl16_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl16_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL16 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL16_ADDR(x) ((uintptr_t)(x) + 0x900U)
#define HW_CCM_PLL_CTRL16_SET_ADDR(x) (HW_CCM_PLL_CTRL16_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL16_CLR_ADDR(x) (HW_CCM_PLL_CTRL16_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL16_TOG_ADDR(x) (HW_CCM_PLL_CTRL16_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL16(x)     (*(__IO hw_ccm_pll_ctrl16_t *) HW_CCM_PLL_CTRL16_ADDR(x))
#define HW_CCM_PLL_CTRL16_RD(x)  (HW_CCM_PLL_CTRL16(x).U)
#define HW_CCM_PLL_CTRL16_WR(x, v) (HW_CCM_PLL_CTRL16(x).U = (v))
#define HW_CCM_PLL_CTRL16_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL16_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL16_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL16_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL16_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL16_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL16 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL16, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL16_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL16_SETTING0. */
#define BM_CCM_PLL_CTRL16_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL16_SETTING0. */
#define BS_CCM_PLL_CTRL16_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL16_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL16_SETTING0 field. */
#define BR_CCM_PLL_CTRL16_SETTING0(x) (HW_CCM_PLL_CTRL16(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL16_SETTING0. */
#define BF_CCM_PLL_CTRL16_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL16_SETTING0) & BM_CCM_PLL_CTRL16_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL16_SETTING0(x, v) (HW_CCM_PLL_CTRL16_WR(x, (HW_CCM_PLL_CTRL16_RD(x) & ~BM_CCM_PLL_CTRL16_SETTING0) | BF_CCM_PLL_CTRL16_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL16, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL16_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL16_SETTING1. */
#define BM_CCM_PLL_CTRL16_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL16_SETTING1. */
#define BS_CCM_PLL_CTRL16_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL16_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL16_SETTING1 field. */
#define BR_CCM_PLL_CTRL16_SETTING1(x) (HW_CCM_PLL_CTRL16(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL16_SETTING1. */
#define BF_CCM_PLL_CTRL16_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL16_SETTING1) & BM_CCM_PLL_CTRL16_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL16_SETTING1(x, v) (HW_CCM_PLL_CTRL16_WR(x, (HW_CCM_PLL_CTRL16_RD(x) & ~BM_CCM_PLL_CTRL16_SETTING1) | BF_CCM_PLL_CTRL16_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL16, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL16_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL16_SETTING2. */
#define BM_CCM_PLL_CTRL16_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL16_SETTING2. */
#define BS_CCM_PLL_CTRL16_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL16_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL16_SETTING2 field. */
#define BR_CCM_PLL_CTRL16_SETTING2(x) (HW_CCM_PLL_CTRL16(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL16_SETTING2. */
#define BF_CCM_PLL_CTRL16_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL16_SETTING2) & BM_CCM_PLL_CTRL16_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL16_SETTING2(x, v) (HW_CCM_PLL_CTRL16_WR(x, (HW_CCM_PLL_CTRL16_RD(x) & ~BM_CCM_PLL_CTRL16_SETTING2) | BF_CCM_PLL_CTRL16_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL16, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL16_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL16_SETTING3. */
#define BM_CCM_PLL_CTRL16_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL16_SETTING3. */
#define BS_CCM_PLL_CTRL16_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL16_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL16_SETTING3 field. */
#define BR_CCM_PLL_CTRL16_SETTING3(x) (HW_CCM_PLL_CTRL16(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL16_SETTING3. */
#define BF_CCM_PLL_CTRL16_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL16_SETTING3) & BM_CCM_PLL_CTRL16_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL16_SETTING3(x, v) (HW_CCM_PLL_CTRL16_WR(x, (HW_CCM_PLL_CTRL16_RD(x) & ~BM_CCM_PLL_CTRL16_SETTING3) | BF_CCM_PLL_CTRL16_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL17 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL17 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl17
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl17_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl17_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL17 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL17_ADDR(x) ((uintptr_t)(x) + 0x910U)
#define HW_CCM_PLL_CTRL17_SET_ADDR(x) (HW_CCM_PLL_CTRL17_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL17_CLR_ADDR(x) (HW_CCM_PLL_CTRL17_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL17_TOG_ADDR(x) (HW_CCM_PLL_CTRL17_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL17(x)     (*(__IO hw_ccm_pll_ctrl17_t *) HW_CCM_PLL_CTRL17_ADDR(x))
#define HW_CCM_PLL_CTRL17_RD(x)  (HW_CCM_PLL_CTRL17(x).U)
#define HW_CCM_PLL_CTRL17_WR(x, v) (HW_CCM_PLL_CTRL17(x).U = (v))
#define HW_CCM_PLL_CTRL17_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL17_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL17_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL17_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL17_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL17_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL17 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL17, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL17_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL17_SETTING0. */
#define BM_CCM_PLL_CTRL17_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL17_SETTING0. */
#define BS_CCM_PLL_CTRL17_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL17_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL17_SETTING0 field. */
#define BR_CCM_PLL_CTRL17_SETTING0(x) (HW_CCM_PLL_CTRL17(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL17_SETTING0. */
#define BF_CCM_PLL_CTRL17_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL17_SETTING0) & BM_CCM_PLL_CTRL17_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL17_SETTING0(x, v) (HW_CCM_PLL_CTRL17_WR(x, (HW_CCM_PLL_CTRL17_RD(x) & ~BM_CCM_PLL_CTRL17_SETTING0) | BF_CCM_PLL_CTRL17_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL17, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL17_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL17_SETTING1. */
#define BM_CCM_PLL_CTRL17_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL17_SETTING1. */
#define BS_CCM_PLL_CTRL17_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL17_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL17_SETTING1 field. */
#define BR_CCM_PLL_CTRL17_SETTING1(x) (HW_CCM_PLL_CTRL17(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL17_SETTING1. */
#define BF_CCM_PLL_CTRL17_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL17_SETTING1) & BM_CCM_PLL_CTRL17_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL17_SETTING1(x, v) (HW_CCM_PLL_CTRL17_WR(x, (HW_CCM_PLL_CTRL17_RD(x) & ~BM_CCM_PLL_CTRL17_SETTING1) | BF_CCM_PLL_CTRL17_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL17, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL17_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL17_SETTING2. */
#define BM_CCM_PLL_CTRL17_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL17_SETTING2. */
#define BS_CCM_PLL_CTRL17_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL17_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL17_SETTING2 field. */
#define BR_CCM_PLL_CTRL17_SETTING2(x) (HW_CCM_PLL_CTRL17(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL17_SETTING2. */
#define BF_CCM_PLL_CTRL17_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL17_SETTING2) & BM_CCM_PLL_CTRL17_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL17_SETTING2(x, v) (HW_CCM_PLL_CTRL17_WR(x, (HW_CCM_PLL_CTRL17_RD(x) & ~BM_CCM_PLL_CTRL17_SETTING2) | BF_CCM_PLL_CTRL17_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL17, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL17_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL17_SETTING3. */
#define BM_CCM_PLL_CTRL17_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL17_SETTING3. */
#define BS_CCM_PLL_CTRL17_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL17_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL17_SETTING3 field. */
#define BR_CCM_PLL_CTRL17_SETTING3(x) (HW_CCM_PLL_CTRL17(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL17_SETTING3. */
#define BF_CCM_PLL_CTRL17_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL17_SETTING3) & BM_CCM_PLL_CTRL17_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL17_SETTING3(x, v) (HW_CCM_PLL_CTRL17_WR(x, (HW_CCM_PLL_CTRL17_RD(x) & ~BM_CCM_PLL_CTRL17_SETTING3) | BF_CCM_PLL_CTRL17_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL18 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL18 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl18
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl18_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl18_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL18 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL18_ADDR(x) ((uintptr_t)(x) + 0x920U)
#define HW_CCM_PLL_CTRL18_SET_ADDR(x) (HW_CCM_PLL_CTRL18_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL18_CLR_ADDR(x) (HW_CCM_PLL_CTRL18_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL18_TOG_ADDR(x) (HW_CCM_PLL_CTRL18_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL18(x)     (*(__IO hw_ccm_pll_ctrl18_t *) HW_CCM_PLL_CTRL18_ADDR(x))
#define HW_CCM_PLL_CTRL18_RD(x)  (HW_CCM_PLL_CTRL18(x).U)
#define HW_CCM_PLL_CTRL18_WR(x, v) (HW_CCM_PLL_CTRL18(x).U = (v))
#define HW_CCM_PLL_CTRL18_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL18_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL18_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL18_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL18_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL18_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL18 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL18, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL18_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL18_SETTING0. */
#define BM_CCM_PLL_CTRL18_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL18_SETTING0. */
#define BS_CCM_PLL_CTRL18_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL18_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL18_SETTING0 field. */
#define BR_CCM_PLL_CTRL18_SETTING0(x) (HW_CCM_PLL_CTRL18(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL18_SETTING0. */
#define BF_CCM_PLL_CTRL18_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL18_SETTING0) & BM_CCM_PLL_CTRL18_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL18_SETTING0(x, v) (HW_CCM_PLL_CTRL18_WR(x, (HW_CCM_PLL_CTRL18_RD(x) & ~BM_CCM_PLL_CTRL18_SETTING0) | BF_CCM_PLL_CTRL18_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL18, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL18_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL18_SETTING1. */
#define BM_CCM_PLL_CTRL18_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL18_SETTING1. */
#define BS_CCM_PLL_CTRL18_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL18_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL18_SETTING1 field. */
#define BR_CCM_PLL_CTRL18_SETTING1(x) (HW_CCM_PLL_CTRL18(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL18_SETTING1. */
#define BF_CCM_PLL_CTRL18_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL18_SETTING1) & BM_CCM_PLL_CTRL18_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL18_SETTING1(x, v) (HW_CCM_PLL_CTRL18_WR(x, (HW_CCM_PLL_CTRL18_RD(x) & ~BM_CCM_PLL_CTRL18_SETTING1) | BF_CCM_PLL_CTRL18_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL18, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL18_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL18_SETTING2. */
#define BM_CCM_PLL_CTRL18_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL18_SETTING2. */
#define BS_CCM_PLL_CTRL18_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL18_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL18_SETTING2 field. */
#define BR_CCM_PLL_CTRL18_SETTING2(x) (HW_CCM_PLL_CTRL18(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL18_SETTING2. */
#define BF_CCM_PLL_CTRL18_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL18_SETTING2) & BM_CCM_PLL_CTRL18_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL18_SETTING2(x, v) (HW_CCM_PLL_CTRL18_WR(x, (HW_CCM_PLL_CTRL18_RD(x) & ~BM_CCM_PLL_CTRL18_SETTING2) | BF_CCM_PLL_CTRL18_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL18, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL18_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL18_SETTING3. */
#define BM_CCM_PLL_CTRL18_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL18_SETTING3. */
#define BS_CCM_PLL_CTRL18_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL18_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL18_SETTING3 field. */
#define BR_CCM_PLL_CTRL18_SETTING3(x) (HW_CCM_PLL_CTRL18(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL18_SETTING3. */
#define BF_CCM_PLL_CTRL18_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL18_SETTING3) & BM_CCM_PLL_CTRL18_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL18_SETTING3(x, v) (HW_CCM_PLL_CTRL18_WR(x, (HW_CCM_PLL_CTRL18_RD(x) & ~BM_CCM_PLL_CTRL18_SETTING3) | BF_CCM_PLL_CTRL18_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL19 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL19 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl19
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl19_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl19_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL19 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL19_ADDR(x) ((uintptr_t)(x) + 0x930U)
#define HW_CCM_PLL_CTRL19_SET_ADDR(x) (HW_CCM_PLL_CTRL19_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL19_CLR_ADDR(x) (HW_CCM_PLL_CTRL19_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL19_TOG_ADDR(x) (HW_CCM_PLL_CTRL19_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL19(x)     (*(__IO hw_ccm_pll_ctrl19_t *) HW_CCM_PLL_CTRL19_ADDR(x))
#define HW_CCM_PLL_CTRL19_RD(x)  (HW_CCM_PLL_CTRL19(x).U)
#define HW_CCM_PLL_CTRL19_WR(x, v) (HW_CCM_PLL_CTRL19(x).U = (v))
#define HW_CCM_PLL_CTRL19_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL19_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL19_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL19_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL19_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL19_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL19 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL19, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL19_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL19_SETTING0. */
#define BM_CCM_PLL_CTRL19_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL19_SETTING0. */
#define BS_CCM_PLL_CTRL19_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL19_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL19_SETTING0 field. */
#define BR_CCM_PLL_CTRL19_SETTING0(x) (HW_CCM_PLL_CTRL19(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL19_SETTING0. */
#define BF_CCM_PLL_CTRL19_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL19_SETTING0) & BM_CCM_PLL_CTRL19_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL19_SETTING0(x, v) (HW_CCM_PLL_CTRL19_WR(x, (HW_CCM_PLL_CTRL19_RD(x) & ~BM_CCM_PLL_CTRL19_SETTING0) | BF_CCM_PLL_CTRL19_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL19, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL19_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL19_SETTING1. */
#define BM_CCM_PLL_CTRL19_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL19_SETTING1. */
#define BS_CCM_PLL_CTRL19_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL19_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL19_SETTING1 field. */
#define BR_CCM_PLL_CTRL19_SETTING1(x) (HW_CCM_PLL_CTRL19(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL19_SETTING1. */
#define BF_CCM_PLL_CTRL19_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL19_SETTING1) & BM_CCM_PLL_CTRL19_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL19_SETTING1(x, v) (HW_CCM_PLL_CTRL19_WR(x, (HW_CCM_PLL_CTRL19_RD(x) & ~BM_CCM_PLL_CTRL19_SETTING1) | BF_CCM_PLL_CTRL19_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL19, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL19_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL19_SETTING2. */
#define BM_CCM_PLL_CTRL19_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL19_SETTING2. */
#define BS_CCM_PLL_CTRL19_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL19_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL19_SETTING2 field. */
#define BR_CCM_PLL_CTRL19_SETTING2(x) (HW_CCM_PLL_CTRL19(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL19_SETTING2. */
#define BF_CCM_PLL_CTRL19_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL19_SETTING2) & BM_CCM_PLL_CTRL19_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL19_SETTING2(x, v) (HW_CCM_PLL_CTRL19_WR(x, (HW_CCM_PLL_CTRL19_RD(x) & ~BM_CCM_PLL_CTRL19_SETTING2) | BF_CCM_PLL_CTRL19_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL19, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL19_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL19_SETTING3. */
#define BM_CCM_PLL_CTRL19_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL19_SETTING3. */
#define BS_CCM_PLL_CTRL19_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL19_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL19_SETTING3 field. */
#define BR_CCM_PLL_CTRL19_SETTING3(x) (HW_CCM_PLL_CTRL19(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL19_SETTING3. */
#define BF_CCM_PLL_CTRL19_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL19_SETTING3) & BM_CCM_PLL_CTRL19_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL19_SETTING3(x, v) (HW_CCM_PLL_CTRL19_WR(x, (HW_CCM_PLL_CTRL19_RD(x) & ~BM_CCM_PLL_CTRL19_SETTING3) | BF_CCM_PLL_CTRL19_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL20 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL20 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl20
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl20_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl20_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL20 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL20_ADDR(x) ((uintptr_t)(x) + 0x940U)
#define HW_CCM_PLL_CTRL20_SET_ADDR(x) (HW_CCM_PLL_CTRL20_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL20_CLR_ADDR(x) (HW_CCM_PLL_CTRL20_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL20_TOG_ADDR(x) (HW_CCM_PLL_CTRL20_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL20(x)     (*(__IO hw_ccm_pll_ctrl20_t *) HW_CCM_PLL_CTRL20_ADDR(x))
#define HW_CCM_PLL_CTRL20_RD(x)  (HW_CCM_PLL_CTRL20(x).U)
#define HW_CCM_PLL_CTRL20_WR(x, v) (HW_CCM_PLL_CTRL20(x).U = (v))
#define HW_CCM_PLL_CTRL20_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL20_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL20_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL20_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL20_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL20_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL20 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL20, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL20_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL20_SETTING0. */
#define BM_CCM_PLL_CTRL20_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL20_SETTING0. */
#define BS_CCM_PLL_CTRL20_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL20_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL20_SETTING0 field. */
#define BR_CCM_PLL_CTRL20_SETTING0(x) (HW_CCM_PLL_CTRL20(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL20_SETTING0. */
#define BF_CCM_PLL_CTRL20_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL20_SETTING0) & BM_CCM_PLL_CTRL20_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL20_SETTING0(x, v) (HW_CCM_PLL_CTRL20_WR(x, (HW_CCM_PLL_CTRL20_RD(x) & ~BM_CCM_PLL_CTRL20_SETTING0) | BF_CCM_PLL_CTRL20_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL20, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL20_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL20_SETTING1. */
#define BM_CCM_PLL_CTRL20_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL20_SETTING1. */
#define BS_CCM_PLL_CTRL20_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL20_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL20_SETTING1 field. */
#define BR_CCM_PLL_CTRL20_SETTING1(x) (HW_CCM_PLL_CTRL20(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL20_SETTING1. */
#define BF_CCM_PLL_CTRL20_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL20_SETTING1) & BM_CCM_PLL_CTRL20_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL20_SETTING1(x, v) (HW_CCM_PLL_CTRL20_WR(x, (HW_CCM_PLL_CTRL20_RD(x) & ~BM_CCM_PLL_CTRL20_SETTING1) | BF_CCM_PLL_CTRL20_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL20, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL20_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL20_SETTING2. */
#define BM_CCM_PLL_CTRL20_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL20_SETTING2. */
#define BS_CCM_PLL_CTRL20_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL20_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL20_SETTING2 field. */
#define BR_CCM_PLL_CTRL20_SETTING2(x) (HW_CCM_PLL_CTRL20(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL20_SETTING2. */
#define BF_CCM_PLL_CTRL20_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL20_SETTING2) & BM_CCM_PLL_CTRL20_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL20_SETTING2(x, v) (HW_CCM_PLL_CTRL20_WR(x, (HW_CCM_PLL_CTRL20_RD(x) & ~BM_CCM_PLL_CTRL20_SETTING2) | BF_CCM_PLL_CTRL20_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL20, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL20_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL20_SETTING3. */
#define BM_CCM_PLL_CTRL20_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL20_SETTING3. */
#define BS_CCM_PLL_CTRL20_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL20_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL20_SETTING3 field. */
#define BR_CCM_PLL_CTRL20_SETTING3(x) (HW_CCM_PLL_CTRL20(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL20_SETTING3. */
#define BF_CCM_PLL_CTRL20_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL20_SETTING3) & BM_CCM_PLL_CTRL20_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL20_SETTING3(x, v) (HW_CCM_PLL_CTRL20_WR(x, (HW_CCM_PLL_CTRL20_RD(x) & ~BM_CCM_PLL_CTRL20_SETTING3) | BF_CCM_PLL_CTRL20_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL21 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL21 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl21
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl21_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl21_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL21 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL21_ADDR(x) ((uintptr_t)(x) + 0x950U)
#define HW_CCM_PLL_CTRL21_SET_ADDR(x) (HW_CCM_PLL_CTRL21_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL21_CLR_ADDR(x) (HW_CCM_PLL_CTRL21_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL21_TOG_ADDR(x) (HW_CCM_PLL_CTRL21_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL21(x)     (*(__IO hw_ccm_pll_ctrl21_t *) HW_CCM_PLL_CTRL21_ADDR(x))
#define HW_CCM_PLL_CTRL21_RD(x)  (HW_CCM_PLL_CTRL21(x).U)
#define HW_CCM_PLL_CTRL21_WR(x, v) (HW_CCM_PLL_CTRL21(x).U = (v))
#define HW_CCM_PLL_CTRL21_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL21_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL21_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL21_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL21_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL21_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL21 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL21, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL21_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL21_SETTING0. */
#define BM_CCM_PLL_CTRL21_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL21_SETTING0. */
#define BS_CCM_PLL_CTRL21_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL21_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL21_SETTING0 field. */
#define BR_CCM_PLL_CTRL21_SETTING0(x) (HW_CCM_PLL_CTRL21(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL21_SETTING0. */
#define BF_CCM_PLL_CTRL21_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL21_SETTING0) & BM_CCM_PLL_CTRL21_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL21_SETTING0(x, v) (HW_CCM_PLL_CTRL21_WR(x, (HW_CCM_PLL_CTRL21_RD(x) & ~BM_CCM_PLL_CTRL21_SETTING0) | BF_CCM_PLL_CTRL21_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL21, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL21_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL21_SETTING1. */
#define BM_CCM_PLL_CTRL21_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL21_SETTING1. */
#define BS_CCM_PLL_CTRL21_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL21_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL21_SETTING1 field. */
#define BR_CCM_PLL_CTRL21_SETTING1(x) (HW_CCM_PLL_CTRL21(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL21_SETTING1. */
#define BF_CCM_PLL_CTRL21_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL21_SETTING1) & BM_CCM_PLL_CTRL21_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL21_SETTING1(x, v) (HW_CCM_PLL_CTRL21_WR(x, (HW_CCM_PLL_CTRL21_RD(x) & ~BM_CCM_PLL_CTRL21_SETTING1) | BF_CCM_PLL_CTRL21_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL21, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL21_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL21_SETTING2. */
#define BM_CCM_PLL_CTRL21_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL21_SETTING2. */
#define BS_CCM_PLL_CTRL21_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL21_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL21_SETTING2 field. */
#define BR_CCM_PLL_CTRL21_SETTING2(x) (HW_CCM_PLL_CTRL21(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL21_SETTING2. */
#define BF_CCM_PLL_CTRL21_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL21_SETTING2) & BM_CCM_PLL_CTRL21_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL21_SETTING2(x, v) (HW_CCM_PLL_CTRL21_WR(x, (HW_CCM_PLL_CTRL21_RD(x) & ~BM_CCM_PLL_CTRL21_SETTING2) | BF_CCM_PLL_CTRL21_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL21, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL21_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL21_SETTING3. */
#define BM_CCM_PLL_CTRL21_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL21_SETTING3. */
#define BS_CCM_PLL_CTRL21_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL21_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL21_SETTING3 field. */
#define BR_CCM_PLL_CTRL21_SETTING3(x) (HW_CCM_PLL_CTRL21(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL21_SETTING3. */
#define BF_CCM_PLL_CTRL21_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL21_SETTING3) & BM_CCM_PLL_CTRL21_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL21_SETTING3(x, v) (HW_CCM_PLL_CTRL21_WR(x, (HW_CCM_PLL_CTRL21_RD(x) & ~BM_CCM_PLL_CTRL21_SETTING3) | BF_CCM_PLL_CTRL21_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL22 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL22 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl22
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl22_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl22_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL22 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL22_ADDR(x) ((uintptr_t)(x) + 0x960U)
#define HW_CCM_PLL_CTRL22_SET_ADDR(x) (HW_CCM_PLL_CTRL22_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL22_CLR_ADDR(x) (HW_CCM_PLL_CTRL22_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL22_TOG_ADDR(x) (HW_CCM_PLL_CTRL22_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL22(x)     (*(__IO hw_ccm_pll_ctrl22_t *) HW_CCM_PLL_CTRL22_ADDR(x))
#define HW_CCM_PLL_CTRL22_RD(x)  (HW_CCM_PLL_CTRL22(x).U)
#define HW_CCM_PLL_CTRL22_WR(x, v) (HW_CCM_PLL_CTRL22(x).U = (v))
#define HW_CCM_PLL_CTRL22_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL22_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL22_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL22_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL22_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL22_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL22 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL22, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL22_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL22_SETTING0. */
#define BM_CCM_PLL_CTRL22_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL22_SETTING0. */
#define BS_CCM_PLL_CTRL22_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL22_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL22_SETTING0 field. */
#define BR_CCM_PLL_CTRL22_SETTING0(x) (HW_CCM_PLL_CTRL22(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL22_SETTING0. */
#define BF_CCM_PLL_CTRL22_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL22_SETTING0) & BM_CCM_PLL_CTRL22_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL22_SETTING0(x, v) (HW_CCM_PLL_CTRL22_WR(x, (HW_CCM_PLL_CTRL22_RD(x) & ~BM_CCM_PLL_CTRL22_SETTING0) | BF_CCM_PLL_CTRL22_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL22, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL22_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL22_SETTING1. */
#define BM_CCM_PLL_CTRL22_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL22_SETTING1. */
#define BS_CCM_PLL_CTRL22_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL22_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL22_SETTING1 field. */
#define BR_CCM_PLL_CTRL22_SETTING1(x) (HW_CCM_PLL_CTRL22(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL22_SETTING1. */
#define BF_CCM_PLL_CTRL22_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL22_SETTING1) & BM_CCM_PLL_CTRL22_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL22_SETTING1(x, v) (HW_CCM_PLL_CTRL22_WR(x, (HW_CCM_PLL_CTRL22_RD(x) & ~BM_CCM_PLL_CTRL22_SETTING1) | BF_CCM_PLL_CTRL22_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL22, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL22_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL22_SETTING2. */
#define BM_CCM_PLL_CTRL22_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL22_SETTING2. */
#define BS_CCM_PLL_CTRL22_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL22_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL22_SETTING2 field. */
#define BR_CCM_PLL_CTRL22_SETTING2(x) (HW_CCM_PLL_CTRL22(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL22_SETTING2. */
#define BF_CCM_PLL_CTRL22_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL22_SETTING2) & BM_CCM_PLL_CTRL22_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL22_SETTING2(x, v) (HW_CCM_PLL_CTRL22_WR(x, (HW_CCM_PLL_CTRL22_RD(x) & ~BM_CCM_PLL_CTRL22_SETTING2) | BF_CCM_PLL_CTRL22_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL22, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL22_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL22_SETTING3. */
#define BM_CCM_PLL_CTRL22_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL22_SETTING3. */
#define BS_CCM_PLL_CTRL22_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL22_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL22_SETTING3 field. */
#define BR_CCM_PLL_CTRL22_SETTING3(x) (HW_CCM_PLL_CTRL22(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL22_SETTING3. */
#define BF_CCM_PLL_CTRL22_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL22_SETTING3) & BM_CCM_PLL_CTRL22_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL22_SETTING3(x, v) (HW_CCM_PLL_CTRL22_WR(x, (HW_CCM_PLL_CTRL22_RD(x) & ~BM_CCM_PLL_CTRL22_SETTING3) | BF_CCM_PLL_CTRL22_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL23 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL23 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl23
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl23_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl23_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL23 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL23_ADDR(x) ((uintptr_t)(x) + 0x970U)
#define HW_CCM_PLL_CTRL23_SET_ADDR(x) (HW_CCM_PLL_CTRL23_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL23_CLR_ADDR(x) (HW_CCM_PLL_CTRL23_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL23_TOG_ADDR(x) (HW_CCM_PLL_CTRL23_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL23(x)     (*(__IO hw_ccm_pll_ctrl23_t *) HW_CCM_PLL_CTRL23_ADDR(x))
#define HW_CCM_PLL_CTRL23_RD(x)  (HW_CCM_PLL_CTRL23(x).U)
#define HW_CCM_PLL_CTRL23_WR(x, v) (HW_CCM_PLL_CTRL23(x).U = (v))
#define HW_CCM_PLL_CTRL23_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL23_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL23_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL23_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL23_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL23_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL23 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL23, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL23_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL23_SETTING0. */
#define BM_CCM_PLL_CTRL23_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL23_SETTING0. */
#define BS_CCM_PLL_CTRL23_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL23_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL23_SETTING0 field. */
#define BR_CCM_PLL_CTRL23_SETTING0(x) (HW_CCM_PLL_CTRL23(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL23_SETTING0. */
#define BF_CCM_PLL_CTRL23_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL23_SETTING0) & BM_CCM_PLL_CTRL23_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL23_SETTING0(x, v) (HW_CCM_PLL_CTRL23_WR(x, (HW_CCM_PLL_CTRL23_RD(x) & ~BM_CCM_PLL_CTRL23_SETTING0) | BF_CCM_PLL_CTRL23_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL23, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL23_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL23_SETTING1. */
#define BM_CCM_PLL_CTRL23_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL23_SETTING1. */
#define BS_CCM_PLL_CTRL23_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL23_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL23_SETTING1 field. */
#define BR_CCM_PLL_CTRL23_SETTING1(x) (HW_CCM_PLL_CTRL23(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL23_SETTING1. */
#define BF_CCM_PLL_CTRL23_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL23_SETTING1) & BM_CCM_PLL_CTRL23_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL23_SETTING1(x, v) (HW_CCM_PLL_CTRL23_WR(x, (HW_CCM_PLL_CTRL23_RD(x) & ~BM_CCM_PLL_CTRL23_SETTING1) | BF_CCM_PLL_CTRL23_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL23, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL23_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL23_SETTING2. */
#define BM_CCM_PLL_CTRL23_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL23_SETTING2. */
#define BS_CCM_PLL_CTRL23_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL23_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL23_SETTING2 field. */
#define BR_CCM_PLL_CTRL23_SETTING2(x) (HW_CCM_PLL_CTRL23(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL23_SETTING2. */
#define BF_CCM_PLL_CTRL23_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL23_SETTING2) & BM_CCM_PLL_CTRL23_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL23_SETTING2(x, v) (HW_CCM_PLL_CTRL23_WR(x, (HW_CCM_PLL_CTRL23_RD(x) & ~BM_CCM_PLL_CTRL23_SETTING2) | BF_CCM_PLL_CTRL23_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL23, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL23_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL23_SETTING3. */
#define BM_CCM_PLL_CTRL23_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL23_SETTING3. */
#define BS_CCM_PLL_CTRL23_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL23_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL23_SETTING3 field. */
#define BR_CCM_PLL_CTRL23_SETTING3(x) (HW_CCM_PLL_CTRL23(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL23_SETTING3. */
#define BF_CCM_PLL_CTRL23_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL23_SETTING3) & BM_CCM_PLL_CTRL23_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL23_SETTING3(x, v) (HW_CCM_PLL_CTRL23_WR(x, (HW_CCM_PLL_CTRL23_RD(x) & ~BM_CCM_PLL_CTRL23_SETTING3) | BF_CCM_PLL_CTRL23_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL24 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL24 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl24
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl24_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl24_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL24 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL24_ADDR(x) ((uintptr_t)(x) + 0x980U)
#define HW_CCM_PLL_CTRL24_SET_ADDR(x) (HW_CCM_PLL_CTRL24_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL24_CLR_ADDR(x) (HW_CCM_PLL_CTRL24_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL24_TOG_ADDR(x) (HW_CCM_PLL_CTRL24_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL24(x)     (*(__IO hw_ccm_pll_ctrl24_t *) HW_CCM_PLL_CTRL24_ADDR(x))
#define HW_CCM_PLL_CTRL24_RD(x)  (HW_CCM_PLL_CTRL24(x).U)
#define HW_CCM_PLL_CTRL24_WR(x, v) (HW_CCM_PLL_CTRL24(x).U = (v))
#define HW_CCM_PLL_CTRL24_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL24_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL24_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL24_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL24_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL24_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL24 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL24, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL24_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL24_SETTING0. */
#define BM_CCM_PLL_CTRL24_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL24_SETTING0. */
#define BS_CCM_PLL_CTRL24_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL24_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL24_SETTING0 field. */
#define BR_CCM_PLL_CTRL24_SETTING0(x) (HW_CCM_PLL_CTRL24(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL24_SETTING0. */
#define BF_CCM_PLL_CTRL24_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL24_SETTING0) & BM_CCM_PLL_CTRL24_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL24_SETTING0(x, v) (HW_CCM_PLL_CTRL24_WR(x, (HW_CCM_PLL_CTRL24_RD(x) & ~BM_CCM_PLL_CTRL24_SETTING0) | BF_CCM_PLL_CTRL24_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL24, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL24_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL24_SETTING1. */
#define BM_CCM_PLL_CTRL24_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL24_SETTING1. */
#define BS_CCM_PLL_CTRL24_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL24_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL24_SETTING1 field. */
#define BR_CCM_PLL_CTRL24_SETTING1(x) (HW_CCM_PLL_CTRL24(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL24_SETTING1. */
#define BF_CCM_PLL_CTRL24_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL24_SETTING1) & BM_CCM_PLL_CTRL24_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL24_SETTING1(x, v) (HW_CCM_PLL_CTRL24_WR(x, (HW_CCM_PLL_CTRL24_RD(x) & ~BM_CCM_PLL_CTRL24_SETTING1) | BF_CCM_PLL_CTRL24_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL24, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL24_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL24_SETTING2. */
#define BM_CCM_PLL_CTRL24_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL24_SETTING2. */
#define BS_CCM_PLL_CTRL24_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL24_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL24_SETTING2 field. */
#define BR_CCM_PLL_CTRL24_SETTING2(x) (HW_CCM_PLL_CTRL24(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL24_SETTING2. */
#define BF_CCM_PLL_CTRL24_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL24_SETTING2) & BM_CCM_PLL_CTRL24_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL24_SETTING2(x, v) (HW_CCM_PLL_CTRL24_WR(x, (HW_CCM_PLL_CTRL24_RD(x) & ~BM_CCM_PLL_CTRL24_SETTING2) | BF_CCM_PLL_CTRL24_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL24, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL24_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL24_SETTING3. */
#define BM_CCM_PLL_CTRL24_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL24_SETTING3. */
#define BS_CCM_PLL_CTRL24_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL24_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL24_SETTING3 field. */
#define BR_CCM_PLL_CTRL24_SETTING3(x) (HW_CCM_PLL_CTRL24(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL24_SETTING3. */
#define BF_CCM_PLL_CTRL24_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL24_SETTING3) & BM_CCM_PLL_CTRL24_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL24_SETTING3(x, v) (HW_CCM_PLL_CTRL24_WR(x, (HW_CCM_PLL_CTRL24_RD(x) & ~BM_CCM_PLL_CTRL24_SETTING3) | BF_CCM_PLL_CTRL24_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL25 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL25 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl25
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl25_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl25_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL25 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL25_ADDR(x) ((uintptr_t)(x) + 0x990U)
#define HW_CCM_PLL_CTRL25_SET_ADDR(x) (HW_CCM_PLL_CTRL25_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL25_CLR_ADDR(x) (HW_CCM_PLL_CTRL25_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL25_TOG_ADDR(x) (HW_CCM_PLL_CTRL25_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL25(x)     (*(__IO hw_ccm_pll_ctrl25_t *) HW_CCM_PLL_CTRL25_ADDR(x))
#define HW_CCM_PLL_CTRL25_RD(x)  (HW_CCM_PLL_CTRL25(x).U)
#define HW_CCM_PLL_CTRL25_WR(x, v) (HW_CCM_PLL_CTRL25(x).U = (v))
#define HW_CCM_PLL_CTRL25_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL25_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL25_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL25_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL25_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL25_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL25 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL25, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL25_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL25_SETTING0. */
#define BM_CCM_PLL_CTRL25_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL25_SETTING0. */
#define BS_CCM_PLL_CTRL25_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL25_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL25_SETTING0 field. */
#define BR_CCM_PLL_CTRL25_SETTING0(x) (HW_CCM_PLL_CTRL25(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL25_SETTING0. */
#define BF_CCM_PLL_CTRL25_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL25_SETTING0) & BM_CCM_PLL_CTRL25_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL25_SETTING0(x, v) (HW_CCM_PLL_CTRL25_WR(x, (HW_CCM_PLL_CTRL25_RD(x) & ~BM_CCM_PLL_CTRL25_SETTING0) | BF_CCM_PLL_CTRL25_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL25, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL25_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL25_SETTING1. */
#define BM_CCM_PLL_CTRL25_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL25_SETTING1. */
#define BS_CCM_PLL_CTRL25_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL25_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL25_SETTING1 field. */
#define BR_CCM_PLL_CTRL25_SETTING1(x) (HW_CCM_PLL_CTRL25(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL25_SETTING1. */
#define BF_CCM_PLL_CTRL25_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL25_SETTING1) & BM_CCM_PLL_CTRL25_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL25_SETTING1(x, v) (HW_CCM_PLL_CTRL25_WR(x, (HW_CCM_PLL_CTRL25_RD(x) & ~BM_CCM_PLL_CTRL25_SETTING1) | BF_CCM_PLL_CTRL25_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL25, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL25_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL25_SETTING2. */
#define BM_CCM_PLL_CTRL25_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL25_SETTING2. */
#define BS_CCM_PLL_CTRL25_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL25_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL25_SETTING2 field. */
#define BR_CCM_PLL_CTRL25_SETTING2(x) (HW_CCM_PLL_CTRL25(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL25_SETTING2. */
#define BF_CCM_PLL_CTRL25_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL25_SETTING2) & BM_CCM_PLL_CTRL25_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL25_SETTING2(x, v) (HW_CCM_PLL_CTRL25_WR(x, (HW_CCM_PLL_CTRL25_RD(x) & ~BM_CCM_PLL_CTRL25_SETTING2) | BF_CCM_PLL_CTRL25_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL25, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL25_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL25_SETTING3. */
#define BM_CCM_PLL_CTRL25_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL25_SETTING3. */
#define BS_CCM_PLL_CTRL25_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL25_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL25_SETTING3 field. */
#define BR_CCM_PLL_CTRL25_SETTING3(x) (HW_CCM_PLL_CTRL25(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL25_SETTING3. */
#define BF_CCM_PLL_CTRL25_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL25_SETTING3) & BM_CCM_PLL_CTRL25_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL25_SETTING3(x, v) (HW_CCM_PLL_CTRL25_WR(x, (HW_CCM_PLL_CTRL25_RD(x) & ~BM_CCM_PLL_CTRL25_SETTING3) | BF_CCM_PLL_CTRL25_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL26 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL26 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl26
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl26_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl26_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL26 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL26_ADDR(x) ((uintptr_t)(x) + 0x9A0U)
#define HW_CCM_PLL_CTRL26_SET_ADDR(x) (HW_CCM_PLL_CTRL26_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL26_CLR_ADDR(x) (HW_CCM_PLL_CTRL26_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL26_TOG_ADDR(x) (HW_CCM_PLL_CTRL26_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL26(x)     (*(__IO hw_ccm_pll_ctrl26_t *) HW_CCM_PLL_CTRL26_ADDR(x))
#define HW_CCM_PLL_CTRL26_RD(x)  (HW_CCM_PLL_CTRL26(x).U)
#define HW_CCM_PLL_CTRL26_WR(x, v) (HW_CCM_PLL_CTRL26(x).U = (v))
#define HW_CCM_PLL_CTRL26_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL26_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL26_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL26_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL26_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL26_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL26 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL26, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL26_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL26_SETTING0. */
#define BM_CCM_PLL_CTRL26_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL26_SETTING0. */
#define BS_CCM_PLL_CTRL26_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL26_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL26_SETTING0 field. */
#define BR_CCM_PLL_CTRL26_SETTING0(x) (HW_CCM_PLL_CTRL26(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL26_SETTING0. */
#define BF_CCM_PLL_CTRL26_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL26_SETTING0) & BM_CCM_PLL_CTRL26_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL26_SETTING0(x, v) (HW_CCM_PLL_CTRL26_WR(x, (HW_CCM_PLL_CTRL26_RD(x) & ~BM_CCM_PLL_CTRL26_SETTING0) | BF_CCM_PLL_CTRL26_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL26, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL26_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL26_SETTING1. */
#define BM_CCM_PLL_CTRL26_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL26_SETTING1. */
#define BS_CCM_PLL_CTRL26_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL26_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL26_SETTING1 field. */
#define BR_CCM_PLL_CTRL26_SETTING1(x) (HW_CCM_PLL_CTRL26(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL26_SETTING1. */
#define BF_CCM_PLL_CTRL26_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL26_SETTING1) & BM_CCM_PLL_CTRL26_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL26_SETTING1(x, v) (HW_CCM_PLL_CTRL26_WR(x, (HW_CCM_PLL_CTRL26_RD(x) & ~BM_CCM_PLL_CTRL26_SETTING1) | BF_CCM_PLL_CTRL26_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL26, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL26_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL26_SETTING2. */
#define BM_CCM_PLL_CTRL26_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL26_SETTING2. */
#define BS_CCM_PLL_CTRL26_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL26_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL26_SETTING2 field. */
#define BR_CCM_PLL_CTRL26_SETTING2(x) (HW_CCM_PLL_CTRL26(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL26_SETTING2. */
#define BF_CCM_PLL_CTRL26_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL26_SETTING2) & BM_CCM_PLL_CTRL26_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL26_SETTING2(x, v) (HW_CCM_PLL_CTRL26_WR(x, (HW_CCM_PLL_CTRL26_RD(x) & ~BM_CCM_PLL_CTRL26_SETTING2) | BF_CCM_PLL_CTRL26_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL26, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL26_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL26_SETTING3. */
#define BM_CCM_PLL_CTRL26_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL26_SETTING3. */
#define BS_CCM_PLL_CTRL26_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL26_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL26_SETTING3 field. */
#define BR_CCM_PLL_CTRL26_SETTING3(x) (HW_CCM_PLL_CTRL26(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL26_SETTING3. */
#define BF_CCM_PLL_CTRL26_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL26_SETTING3) & BM_CCM_PLL_CTRL26_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL26_SETTING3(x, v) (HW_CCM_PLL_CTRL26_WR(x, (HW_CCM_PLL_CTRL26_RD(x) & ~BM_CCM_PLL_CTRL26_SETTING3) | BF_CCM_PLL_CTRL26_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL27 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL27 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl27
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl27_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl27_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL27 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL27_ADDR(x) ((uintptr_t)(x) + 0x9B0U)
#define HW_CCM_PLL_CTRL27_SET_ADDR(x) (HW_CCM_PLL_CTRL27_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL27_CLR_ADDR(x) (HW_CCM_PLL_CTRL27_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL27_TOG_ADDR(x) (HW_CCM_PLL_CTRL27_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL27(x)     (*(__IO hw_ccm_pll_ctrl27_t *) HW_CCM_PLL_CTRL27_ADDR(x))
#define HW_CCM_PLL_CTRL27_RD(x)  (HW_CCM_PLL_CTRL27(x).U)
#define HW_CCM_PLL_CTRL27_WR(x, v) (HW_CCM_PLL_CTRL27(x).U = (v))
#define HW_CCM_PLL_CTRL27_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL27_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL27_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL27_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL27_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL27_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL27 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL27, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL27_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL27_SETTING0. */
#define BM_CCM_PLL_CTRL27_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL27_SETTING0. */
#define BS_CCM_PLL_CTRL27_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL27_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL27_SETTING0 field. */
#define BR_CCM_PLL_CTRL27_SETTING0(x) (HW_CCM_PLL_CTRL27(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL27_SETTING0. */
#define BF_CCM_PLL_CTRL27_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL27_SETTING0) & BM_CCM_PLL_CTRL27_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL27_SETTING0(x, v) (HW_CCM_PLL_CTRL27_WR(x, (HW_CCM_PLL_CTRL27_RD(x) & ~BM_CCM_PLL_CTRL27_SETTING0) | BF_CCM_PLL_CTRL27_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL27, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL27_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL27_SETTING1. */
#define BM_CCM_PLL_CTRL27_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL27_SETTING1. */
#define BS_CCM_PLL_CTRL27_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL27_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL27_SETTING1 field. */
#define BR_CCM_PLL_CTRL27_SETTING1(x) (HW_CCM_PLL_CTRL27(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL27_SETTING1. */
#define BF_CCM_PLL_CTRL27_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL27_SETTING1) & BM_CCM_PLL_CTRL27_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL27_SETTING1(x, v) (HW_CCM_PLL_CTRL27_WR(x, (HW_CCM_PLL_CTRL27_RD(x) & ~BM_CCM_PLL_CTRL27_SETTING1) | BF_CCM_PLL_CTRL27_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL27, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL27_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL27_SETTING2. */
#define BM_CCM_PLL_CTRL27_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL27_SETTING2. */
#define BS_CCM_PLL_CTRL27_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL27_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL27_SETTING2 field. */
#define BR_CCM_PLL_CTRL27_SETTING2(x) (HW_CCM_PLL_CTRL27(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL27_SETTING2. */
#define BF_CCM_PLL_CTRL27_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL27_SETTING2) & BM_CCM_PLL_CTRL27_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL27_SETTING2(x, v) (HW_CCM_PLL_CTRL27_WR(x, (HW_CCM_PLL_CTRL27_RD(x) & ~BM_CCM_PLL_CTRL27_SETTING2) | BF_CCM_PLL_CTRL27_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL27, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL27_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL27_SETTING3. */
#define BM_CCM_PLL_CTRL27_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL27_SETTING3. */
#define BS_CCM_PLL_CTRL27_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL27_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL27_SETTING3 field. */
#define BR_CCM_PLL_CTRL27_SETTING3(x) (HW_CCM_PLL_CTRL27(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL27_SETTING3. */
#define BF_CCM_PLL_CTRL27_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL27_SETTING3) & BM_CCM_PLL_CTRL27_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL27_SETTING3(x, v) (HW_CCM_PLL_CTRL27_WR(x, (HW_CCM_PLL_CTRL27_RD(x) & ~BM_CCM_PLL_CTRL27_SETTING3) | BF_CCM_PLL_CTRL27_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL28 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL28 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl28
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl28_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl28_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL28 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL28_ADDR(x) ((uintptr_t)(x) + 0x9C0U)
#define HW_CCM_PLL_CTRL28_SET_ADDR(x) (HW_CCM_PLL_CTRL28_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL28_CLR_ADDR(x) (HW_CCM_PLL_CTRL28_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL28_TOG_ADDR(x) (HW_CCM_PLL_CTRL28_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL28(x)     (*(__IO hw_ccm_pll_ctrl28_t *) HW_CCM_PLL_CTRL28_ADDR(x))
#define HW_CCM_PLL_CTRL28_RD(x)  (HW_CCM_PLL_CTRL28(x).U)
#define HW_CCM_PLL_CTRL28_WR(x, v) (HW_CCM_PLL_CTRL28(x).U = (v))
#define HW_CCM_PLL_CTRL28_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL28_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL28_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL28_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL28_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL28_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL28 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL28, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL28_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL28_SETTING0. */
#define BM_CCM_PLL_CTRL28_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL28_SETTING0. */
#define BS_CCM_PLL_CTRL28_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL28_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL28_SETTING0 field. */
#define BR_CCM_PLL_CTRL28_SETTING0(x) (HW_CCM_PLL_CTRL28(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL28_SETTING0. */
#define BF_CCM_PLL_CTRL28_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL28_SETTING0) & BM_CCM_PLL_CTRL28_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL28_SETTING0(x, v) (HW_CCM_PLL_CTRL28_WR(x, (HW_CCM_PLL_CTRL28_RD(x) & ~BM_CCM_PLL_CTRL28_SETTING0) | BF_CCM_PLL_CTRL28_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL28, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL28_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL28_SETTING1. */
#define BM_CCM_PLL_CTRL28_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL28_SETTING1. */
#define BS_CCM_PLL_CTRL28_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL28_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL28_SETTING1 field. */
#define BR_CCM_PLL_CTRL28_SETTING1(x) (HW_CCM_PLL_CTRL28(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL28_SETTING1. */
#define BF_CCM_PLL_CTRL28_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL28_SETTING1) & BM_CCM_PLL_CTRL28_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL28_SETTING1(x, v) (HW_CCM_PLL_CTRL28_WR(x, (HW_CCM_PLL_CTRL28_RD(x) & ~BM_CCM_PLL_CTRL28_SETTING1) | BF_CCM_PLL_CTRL28_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL28, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL28_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL28_SETTING2. */
#define BM_CCM_PLL_CTRL28_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL28_SETTING2. */
#define BS_CCM_PLL_CTRL28_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL28_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL28_SETTING2 field. */
#define BR_CCM_PLL_CTRL28_SETTING2(x) (HW_CCM_PLL_CTRL28(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL28_SETTING2. */
#define BF_CCM_PLL_CTRL28_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL28_SETTING2) & BM_CCM_PLL_CTRL28_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL28_SETTING2(x, v) (HW_CCM_PLL_CTRL28_WR(x, (HW_CCM_PLL_CTRL28_RD(x) & ~BM_CCM_PLL_CTRL28_SETTING2) | BF_CCM_PLL_CTRL28_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL28, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL28_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL28_SETTING3. */
#define BM_CCM_PLL_CTRL28_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL28_SETTING3. */
#define BS_CCM_PLL_CTRL28_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL28_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL28_SETTING3 field. */
#define BR_CCM_PLL_CTRL28_SETTING3(x) (HW_CCM_PLL_CTRL28(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL28_SETTING3. */
#define BF_CCM_PLL_CTRL28_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL28_SETTING3) & BM_CCM_PLL_CTRL28_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL28_SETTING3(x, v) (HW_CCM_PLL_CTRL28_WR(x, (HW_CCM_PLL_CTRL28_RD(x) & ~BM_CCM_PLL_CTRL28_SETTING3) | BF_CCM_PLL_CTRL28_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL29 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL29 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl29
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl29_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl29_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL29 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL29_ADDR(x) ((uintptr_t)(x) + 0x9D0U)
#define HW_CCM_PLL_CTRL29_SET_ADDR(x) (HW_CCM_PLL_CTRL29_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL29_CLR_ADDR(x) (HW_CCM_PLL_CTRL29_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL29_TOG_ADDR(x) (HW_CCM_PLL_CTRL29_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL29(x)     (*(__IO hw_ccm_pll_ctrl29_t *) HW_CCM_PLL_CTRL29_ADDR(x))
#define HW_CCM_PLL_CTRL29_RD(x)  (HW_CCM_PLL_CTRL29(x).U)
#define HW_CCM_PLL_CTRL29_WR(x, v) (HW_CCM_PLL_CTRL29(x).U = (v))
#define HW_CCM_PLL_CTRL29_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL29_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL29_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL29_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL29_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL29_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL29 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL29, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL29_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL29_SETTING0. */
#define BM_CCM_PLL_CTRL29_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL29_SETTING0. */
#define BS_CCM_PLL_CTRL29_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL29_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL29_SETTING0 field. */
#define BR_CCM_PLL_CTRL29_SETTING0(x) (HW_CCM_PLL_CTRL29(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL29_SETTING0. */
#define BF_CCM_PLL_CTRL29_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL29_SETTING0) & BM_CCM_PLL_CTRL29_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL29_SETTING0(x, v) (HW_CCM_PLL_CTRL29_WR(x, (HW_CCM_PLL_CTRL29_RD(x) & ~BM_CCM_PLL_CTRL29_SETTING0) | BF_CCM_PLL_CTRL29_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL29, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL29_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL29_SETTING1. */
#define BM_CCM_PLL_CTRL29_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL29_SETTING1. */
#define BS_CCM_PLL_CTRL29_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL29_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL29_SETTING1 field. */
#define BR_CCM_PLL_CTRL29_SETTING1(x) (HW_CCM_PLL_CTRL29(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL29_SETTING1. */
#define BF_CCM_PLL_CTRL29_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL29_SETTING1) & BM_CCM_PLL_CTRL29_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL29_SETTING1(x, v) (HW_CCM_PLL_CTRL29_WR(x, (HW_CCM_PLL_CTRL29_RD(x) & ~BM_CCM_PLL_CTRL29_SETTING1) | BF_CCM_PLL_CTRL29_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL29, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL29_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL29_SETTING2. */
#define BM_CCM_PLL_CTRL29_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL29_SETTING2. */
#define BS_CCM_PLL_CTRL29_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL29_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL29_SETTING2 field. */
#define BR_CCM_PLL_CTRL29_SETTING2(x) (HW_CCM_PLL_CTRL29(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL29_SETTING2. */
#define BF_CCM_PLL_CTRL29_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL29_SETTING2) & BM_CCM_PLL_CTRL29_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL29_SETTING2(x, v) (HW_CCM_PLL_CTRL29_WR(x, (HW_CCM_PLL_CTRL29_RD(x) & ~BM_CCM_PLL_CTRL29_SETTING2) | BF_CCM_PLL_CTRL29_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL29, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL29_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL29_SETTING3. */
#define BM_CCM_PLL_CTRL29_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL29_SETTING3. */
#define BS_CCM_PLL_CTRL29_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL29_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL29_SETTING3 field. */
#define BR_CCM_PLL_CTRL29_SETTING3(x) (HW_CCM_PLL_CTRL29(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL29_SETTING3. */
#define BF_CCM_PLL_CTRL29_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL29_SETTING3) & BM_CCM_PLL_CTRL29_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL29_SETTING3(x, v) (HW_CCM_PLL_CTRL29_WR(x, (HW_CCM_PLL_CTRL29_RD(x) & ~BM_CCM_PLL_CTRL29_SETTING3) | BF_CCM_PLL_CTRL29_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL30 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL30 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl30
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl30_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl30_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL30 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL30_ADDR(x) ((uintptr_t)(x) + 0x9E0U)
#define HW_CCM_PLL_CTRL30_SET_ADDR(x) (HW_CCM_PLL_CTRL30_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL30_CLR_ADDR(x) (HW_CCM_PLL_CTRL30_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL30_TOG_ADDR(x) (HW_CCM_PLL_CTRL30_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL30(x)     (*(__IO hw_ccm_pll_ctrl30_t *) HW_CCM_PLL_CTRL30_ADDR(x))
#define HW_CCM_PLL_CTRL30_RD(x)  (HW_CCM_PLL_CTRL30(x).U)
#define HW_CCM_PLL_CTRL30_WR(x, v) (HW_CCM_PLL_CTRL30(x).U = (v))
#define HW_CCM_PLL_CTRL30_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL30_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL30_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL30_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL30_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL30_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL30 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL30, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL30_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL30_SETTING0. */
#define BM_CCM_PLL_CTRL30_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL30_SETTING0. */
#define BS_CCM_PLL_CTRL30_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL30_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL30_SETTING0 field. */
#define BR_CCM_PLL_CTRL30_SETTING0(x) (HW_CCM_PLL_CTRL30(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL30_SETTING0. */
#define BF_CCM_PLL_CTRL30_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL30_SETTING0) & BM_CCM_PLL_CTRL30_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL30_SETTING0(x, v) (HW_CCM_PLL_CTRL30_WR(x, (HW_CCM_PLL_CTRL30_RD(x) & ~BM_CCM_PLL_CTRL30_SETTING0) | BF_CCM_PLL_CTRL30_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL30, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL30_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL30_SETTING1. */
#define BM_CCM_PLL_CTRL30_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL30_SETTING1. */
#define BS_CCM_PLL_CTRL30_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL30_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL30_SETTING1 field. */
#define BR_CCM_PLL_CTRL30_SETTING1(x) (HW_CCM_PLL_CTRL30(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL30_SETTING1. */
#define BF_CCM_PLL_CTRL30_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL30_SETTING1) & BM_CCM_PLL_CTRL30_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL30_SETTING1(x, v) (HW_CCM_PLL_CTRL30_WR(x, (HW_CCM_PLL_CTRL30_RD(x) & ~BM_CCM_PLL_CTRL30_SETTING1) | BF_CCM_PLL_CTRL30_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL30, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL30_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL30_SETTING2. */
#define BM_CCM_PLL_CTRL30_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL30_SETTING2. */
#define BS_CCM_PLL_CTRL30_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL30_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL30_SETTING2 field. */
#define BR_CCM_PLL_CTRL30_SETTING2(x) (HW_CCM_PLL_CTRL30(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL30_SETTING2. */
#define BF_CCM_PLL_CTRL30_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL30_SETTING2) & BM_CCM_PLL_CTRL30_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL30_SETTING2(x, v) (HW_CCM_PLL_CTRL30_WR(x, (HW_CCM_PLL_CTRL30_RD(x) & ~BM_CCM_PLL_CTRL30_SETTING2) | BF_CCM_PLL_CTRL30_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL30, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL30_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL30_SETTING3. */
#define BM_CCM_PLL_CTRL30_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL30_SETTING3. */
#define BS_CCM_PLL_CTRL30_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL30_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL30_SETTING3 field. */
#define BR_CCM_PLL_CTRL30_SETTING3(x) (HW_CCM_PLL_CTRL30(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL30_SETTING3. */
#define BF_CCM_PLL_CTRL30_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL30_SETTING3) & BM_CCM_PLL_CTRL30_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL30_SETTING3(x, v) (HW_CCM_PLL_CTRL30_WR(x, (HW_CCM_PLL_CTRL30_RD(x) & ~BM_CCM_PLL_CTRL30_SETTING3) | BF_CCM_PLL_CTRL30_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL31 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL31 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl31
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl31_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl31_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL31 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL31_ADDR(x) ((uintptr_t)(x) + 0x9F0U)
#define HW_CCM_PLL_CTRL31_SET_ADDR(x) (HW_CCM_PLL_CTRL31_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL31_CLR_ADDR(x) (HW_CCM_PLL_CTRL31_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL31_TOG_ADDR(x) (HW_CCM_PLL_CTRL31_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL31(x)     (*(__IO hw_ccm_pll_ctrl31_t *) HW_CCM_PLL_CTRL31_ADDR(x))
#define HW_CCM_PLL_CTRL31_RD(x)  (HW_CCM_PLL_CTRL31(x).U)
#define HW_CCM_PLL_CTRL31_WR(x, v) (HW_CCM_PLL_CTRL31(x).U = (v))
#define HW_CCM_PLL_CTRL31_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL31_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL31_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL31_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL31_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL31_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL31 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL31, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL31_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL31_SETTING0. */
#define BM_CCM_PLL_CTRL31_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL31_SETTING0. */
#define BS_CCM_PLL_CTRL31_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL31_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL31_SETTING0 field. */
#define BR_CCM_PLL_CTRL31_SETTING0(x) (HW_CCM_PLL_CTRL31(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL31_SETTING0. */
#define BF_CCM_PLL_CTRL31_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL31_SETTING0) & BM_CCM_PLL_CTRL31_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL31_SETTING0(x, v) (HW_CCM_PLL_CTRL31_WR(x, (HW_CCM_PLL_CTRL31_RD(x) & ~BM_CCM_PLL_CTRL31_SETTING0) | BF_CCM_PLL_CTRL31_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL31, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL31_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL31_SETTING1. */
#define BM_CCM_PLL_CTRL31_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL31_SETTING1. */
#define BS_CCM_PLL_CTRL31_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL31_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL31_SETTING1 field. */
#define BR_CCM_PLL_CTRL31_SETTING1(x) (HW_CCM_PLL_CTRL31(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL31_SETTING1. */
#define BF_CCM_PLL_CTRL31_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL31_SETTING1) & BM_CCM_PLL_CTRL31_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL31_SETTING1(x, v) (HW_CCM_PLL_CTRL31_WR(x, (HW_CCM_PLL_CTRL31_RD(x) & ~BM_CCM_PLL_CTRL31_SETTING1) | BF_CCM_PLL_CTRL31_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL31, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL31_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL31_SETTING2. */
#define BM_CCM_PLL_CTRL31_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL31_SETTING2. */
#define BS_CCM_PLL_CTRL31_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL31_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL31_SETTING2 field. */
#define BR_CCM_PLL_CTRL31_SETTING2(x) (HW_CCM_PLL_CTRL31(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL31_SETTING2. */
#define BF_CCM_PLL_CTRL31_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL31_SETTING2) & BM_CCM_PLL_CTRL31_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL31_SETTING2(x, v) (HW_CCM_PLL_CTRL31_WR(x, (HW_CCM_PLL_CTRL31_RD(x) & ~BM_CCM_PLL_CTRL31_SETTING2) | BF_CCM_PLL_CTRL31_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL31, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL31_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL31_SETTING3. */
#define BM_CCM_PLL_CTRL31_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL31_SETTING3. */
#define BS_CCM_PLL_CTRL31_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL31_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL31_SETTING3 field. */
#define BR_CCM_PLL_CTRL31_SETTING3(x) (HW_CCM_PLL_CTRL31(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL31_SETTING3. */
#define BF_CCM_PLL_CTRL31_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL31_SETTING3) & BM_CCM_PLL_CTRL31_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL31_SETTING3(x, v) (HW_CCM_PLL_CTRL31_WR(x, (HW_CCM_PLL_CTRL31_RD(x) & ~BM_CCM_PLL_CTRL31_SETTING3) | BF_CCM_PLL_CTRL31_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_PLL_CTRL32 - CCM PLL Control Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_PLL_CTRL32 - CCM PLL Control Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * See Input Clocks for PLL control mapping. For the SoC to correctly power up
 * after entering DSM, CCM_PLL_CTRLx must not be set to 0x0 or 0x3 for any domain
 * in use.
 */
typedef union _hw_ccm_pll_ctrl32
{
    uint32_t U;
    struct _hw_ccm_pll_ctrl32_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_pll_ctrl32_t;

/*!
 * @name Constants and macros for entire CCM_PLL_CTRL32 register
 */
/*@{*/
#define HW_CCM_PLL_CTRL32_ADDR(x) ((uintptr_t)(x) + 0xA00U)
#define HW_CCM_PLL_CTRL32_SET_ADDR(x) (HW_CCM_PLL_CTRL32_ADDR(x) + 0x4U)
#define HW_CCM_PLL_CTRL32_CLR_ADDR(x) (HW_CCM_PLL_CTRL32_ADDR(x) + 0x8U)
#define HW_CCM_PLL_CTRL32_TOG_ADDR(x) (HW_CCM_PLL_CTRL32_ADDR(x) + 0xCU)

#define HW_CCM_PLL_CTRL32(x)     (*(__IO hw_ccm_pll_ctrl32_t *) HW_CCM_PLL_CTRL32_ADDR(x))
#define HW_CCM_PLL_CTRL32_RD(x)  (HW_CCM_PLL_CTRL32(x).U)
#define HW_CCM_PLL_CTRL32_WR(x, v) (HW_CCM_PLL_CTRL32(x).U = (v))
#define HW_CCM_PLL_CTRL32_SET(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL32_SET_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL32_CLR(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL32_CLR_ADDR(x)) = (v))
#define HW_CCM_PLL_CTRL32_TOG(x, v) ((*(uint32_t *) HW_CCM_PLL_CTRL32_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_PLL_CTRL32 bitfields
 */

/*!
 * @name Register CCM_PLL_CTRL32, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL32_SETTING0 (0U)    /*!< Bit position for CCM_PLL_CTRL32_SETTING0. */
#define BM_CCM_PLL_CTRL32_SETTING0 (0x00000003U) /*!< Bit mask for CCM_PLL_CTRL32_SETTING0. */
#define BS_CCM_PLL_CTRL32_SETTING0 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL32_SETTING0. */

/*! @brief Read current value of the CCM_PLL_CTRL32_SETTING0 field. */
#define BR_CCM_PLL_CTRL32_SETTING0(x) (HW_CCM_PLL_CTRL32(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_PLL_CTRL32_SETTING0. */
#define BF_CCM_PLL_CTRL32_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL32_SETTING0) & BM_CCM_PLL_CTRL32_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_PLL_CTRL32_SETTING0(x, v) (HW_CCM_PLL_CTRL32_WR(x, (HW_CCM_PLL_CTRL32_RD(x) & ~BM_CCM_PLL_CTRL32_SETTING0) | BF_CCM_PLL_CTRL32_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL32, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL32_SETTING1 (4U)    /*!< Bit position for CCM_PLL_CTRL32_SETTING1. */
#define BM_CCM_PLL_CTRL32_SETTING1 (0x00000030U) /*!< Bit mask for CCM_PLL_CTRL32_SETTING1. */
#define BS_CCM_PLL_CTRL32_SETTING1 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL32_SETTING1. */

/*! @brief Read current value of the CCM_PLL_CTRL32_SETTING1 field. */
#define BR_CCM_PLL_CTRL32_SETTING1(x) (HW_CCM_PLL_CTRL32(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_PLL_CTRL32_SETTING1. */
#define BF_CCM_PLL_CTRL32_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL32_SETTING1) & BM_CCM_PLL_CTRL32_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_PLL_CTRL32_SETTING1(x, v) (HW_CCM_PLL_CTRL32_WR(x, (HW_CCM_PLL_CTRL32_RD(x) & ~BM_CCM_PLL_CTRL32_SETTING1) | BF_CCM_PLL_CTRL32_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL32, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL32_SETTING2 (8U)    /*!< Bit position for CCM_PLL_CTRL32_SETTING2. */
#define BM_CCM_PLL_CTRL32_SETTING2 (0x00000300U) /*!< Bit mask for CCM_PLL_CTRL32_SETTING2. */
#define BS_CCM_PLL_CTRL32_SETTING2 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL32_SETTING2. */

/*! @brief Read current value of the CCM_PLL_CTRL32_SETTING2 field. */
#define BR_CCM_PLL_CTRL32_SETTING2(x) (HW_CCM_PLL_CTRL32(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_PLL_CTRL32_SETTING2. */
#define BF_CCM_PLL_CTRL32_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL32_SETTING2) & BM_CCM_PLL_CTRL32_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_PLL_CTRL32_SETTING2(x, v) (HW_CCM_PLL_CTRL32_WR(x, (HW_CCM_PLL_CTRL32_RD(x) & ~BM_CCM_PLL_CTRL32_SETTING2) | BF_CCM_PLL_CTRL32_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_PLL_CTRL32, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_PLL_CTRL32_SETTING3 (12U)   /*!< Bit position for CCM_PLL_CTRL32_SETTING3. */
#define BM_CCM_PLL_CTRL32_SETTING3 (0x00003000U) /*!< Bit mask for CCM_PLL_CTRL32_SETTING3. */
#define BS_CCM_PLL_CTRL32_SETTING3 (2U)    /*!< Bit field size in bits for CCM_PLL_CTRL32_SETTING3. */

/*! @brief Read current value of the CCM_PLL_CTRL32_SETTING3 field. */
#define BR_CCM_PLL_CTRL32_SETTING3(x) (HW_CCM_PLL_CTRL32(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_PLL_CTRL32_SETTING3. */
#define BF_CCM_PLL_CTRL32_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_PLL_CTRL32_SETTING3) & BM_CCM_PLL_CTRL32_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_PLL_CTRL32_SETTING3(x, v) (HW_CCM_PLL_CTRL32_WR(x, (HW_CCM_PLL_CTRL32_RD(x) & ~BM_CCM_PLL_CTRL32_SETTING3) | BF_CCM_PLL_CTRL32_SETTING3(v)))
/*@}*/

/*******************************************************************************
 * HW_CCM_CCGR0 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR0 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr0
{
    uint32_t U;
    struct _hw_ccm_ccgr0_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr0_t;

/*!
 * @name Constants and macros for entire CCM_CCGR0 register
 */
/*@{*/
#define HW_CCM_CCGR0_ADDR(x)     ((uintptr_t)(x) + 0x4000U)
#define HW_CCM_CCGR0_SET_ADDR(x) (HW_CCM_CCGR0_ADDR(x) + 0x4U)
#define HW_CCM_CCGR0_CLR_ADDR(x) (HW_CCM_CCGR0_ADDR(x) + 0x8U)
#define HW_CCM_CCGR0_TOG_ADDR(x) (HW_CCM_CCGR0_ADDR(x) + 0xCU)

#define HW_CCM_CCGR0(x)          (*(__IO hw_ccm_ccgr0_t *) HW_CCM_CCGR0_ADDR(x))
#define HW_CCM_CCGR0_RD(x)       (HW_CCM_CCGR0(x).U)
#define HW_CCM_CCGR0_WR(x, v)    (HW_CCM_CCGR0(x).U = (v))
#define HW_CCM_CCGR0_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR0_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR0_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR0_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR0_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR0_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR0 bitfields
 */

/*!
 * @name Register CCM_CCGR0, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR0_SETTING0 (0U)         /*!< Bit position for CCM_CCGR0_SETTING0. */
#define BM_CCM_CCGR0_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR0_SETTING0. */
#define BS_CCM_CCGR0_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR0_SETTING0. */

/*! @brief Read current value of the CCM_CCGR0_SETTING0 field. */
#define BR_CCM_CCGR0_SETTING0(x) (HW_CCM_CCGR0(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR0_SETTING0. */
#define BF_CCM_CCGR0_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_SETTING0) & BM_CCM_CCGR0_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR0_SETTING0(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_SETTING0) | BF_CCM_CCGR0_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR0_SETTING1 (4U)         /*!< Bit position for CCM_CCGR0_SETTING1. */
#define BM_CCM_CCGR0_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR0_SETTING1. */
#define BS_CCM_CCGR0_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR0_SETTING1. */

/*! @brief Read current value of the CCM_CCGR0_SETTING1 field. */
#define BR_CCM_CCGR0_SETTING1(x) (HW_CCM_CCGR0(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR0_SETTING1. */
#define BF_CCM_CCGR0_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_SETTING1) & BM_CCM_CCGR0_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR0_SETTING1(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_SETTING1) | BF_CCM_CCGR0_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR0_SETTING2 (8U)         /*!< Bit position for CCM_CCGR0_SETTING2. */
#define BM_CCM_CCGR0_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR0_SETTING2. */
#define BS_CCM_CCGR0_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR0_SETTING2. */

/*! @brief Read current value of the CCM_CCGR0_SETTING2 field. */
#define BR_CCM_CCGR0_SETTING2(x) (HW_CCM_CCGR0(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR0_SETTING2. */
#define BF_CCM_CCGR0_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_SETTING2) & BM_CCM_CCGR0_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR0_SETTING2(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_SETTING2) | BF_CCM_CCGR0_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR0, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR0_SETTING3 (12U)        /*!< Bit position for CCM_CCGR0_SETTING3. */
#define BM_CCM_CCGR0_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR0_SETTING3. */
#define BS_CCM_CCGR0_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR0_SETTING3. */

/*! @brief Read current value of the CCM_CCGR0_SETTING3 field. */
#define BR_CCM_CCGR0_SETTING3(x) (HW_CCM_CCGR0(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR0_SETTING3. */
#define BF_CCM_CCGR0_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR0_SETTING3) & BM_CCM_CCGR0_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR0_SETTING3(x, v) (HW_CCM_CCGR0_WR(x, (HW_CCM_CCGR0_RD(x) & ~BM_CCM_CCGR0_SETTING3) | BF_CCM_CCGR0_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR1 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR1 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr1
{
    uint32_t U;
    struct _hw_ccm_ccgr1_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr1_t;

/*!
 * @name Constants and macros for entire CCM_CCGR1 register
 */
/*@{*/
#define HW_CCM_CCGR1_ADDR(x)     ((uintptr_t)(x) + 0x4010U)
#define HW_CCM_CCGR1_SET_ADDR(x) (HW_CCM_CCGR1_ADDR(x) + 0x4U)
#define HW_CCM_CCGR1_CLR_ADDR(x) (HW_CCM_CCGR1_ADDR(x) + 0x8U)
#define HW_CCM_CCGR1_TOG_ADDR(x) (HW_CCM_CCGR1_ADDR(x) + 0xCU)

#define HW_CCM_CCGR1(x)          (*(__IO hw_ccm_ccgr1_t *) HW_CCM_CCGR1_ADDR(x))
#define HW_CCM_CCGR1_RD(x)       (HW_CCM_CCGR1(x).U)
#define HW_CCM_CCGR1_WR(x, v)    (HW_CCM_CCGR1(x).U = (v))
#define HW_CCM_CCGR1_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR1_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR1_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR1_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR1_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR1_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR1 bitfields
 */

/*!
 * @name Register CCM_CCGR1, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR1_SETTING0 (0U)         /*!< Bit position for CCM_CCGR1_SETTING0. */
#define BM_CCM_CCGR1_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR1_SETTING0. */
#define BS_CCM_CCGR1_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR1_SETTING0. */

/*! @brief Read current value of the CCM_CCGR1_SETTING0 field. */
#define BR_CCM_CCGR1_SETTING0(x) (HW_CCM_CCGR1(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR1_SETTING0. */
#define BF_CCM_CCGR1_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_SETTING0) & BM_CCM_CCGR1_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR1_SETTING0(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_SETTING0) | BF_CCM_CCGR1_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR1_SETTING1 (4U)         /*!< Bit position for CCM_CCGR1_SETTING1. */
#define BM_CCM_CCGR1_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR1_SETTING1. */
#define BS_CCM_CCGR1_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR1_SETTING1. */

/*! @brief Read current value of the CCM_CCGR1_SETTING1 field. */
#define BR_CCM_CCGR1_SETTING1(x) (HW_CCM_CCGR1(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR1_SETTING1. */
#define BF_CCM_CCGR1_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_SETTING1) & BM_CCM_CCGR1_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR1_SETTING1(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_SETTING1) | BF_CCM_CCGR1_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR1_SETTING2 (8U)         /*!< Bit position for CCM_CCGR1_SETTING2. */
#define BM_CCM_CCGR1_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR1_SETTING2. */
#define BS_CCM_CCGR1_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR1_SETTING2. */

/*! @brief Read current value of the CCM_CCGR1_SETTING2 field. */
#define BR_CCM_CCGR1_SETTING2(x) (HW_CCM_CCGR1(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR1_SETTING2. */
#define BF_CCM_CCGR1_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_SETTING2) & BM_CCM_CCGR1_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR1_SETTING2(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_SETTING2) | BF_CCM_CCGR1_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR1, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR1_SETTING3 (12U)        /*!< Bit position for CCM_CCGR1_SETTING3. */
#define BM_CCM_CCGR1_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR1_SETTING3. */
#define BS_CCM_CCGR1_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR1_SETTING3. */

/*! @brief Read current value of the CCM_CCGR1_SETTING3 field. */
#define BR_CCM_CCGR1_SETTING3(x) (HW_CCM_CCGR1(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR1_SETTING3. */
#define BF_CCM_CCGR1_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR1_SETTING3) & BM_CCM_CCGR1_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR1_SETTING3(x, v) (HW_CCM_CCGR1_WR(x, (HW_CCM_CCGR1_RD(x) & ~BM_CCM_CCGR1_SETTING3) | BF_CCM_CCGR1_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR2 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR2 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr2
{
    uint32_t U;
    struct _hw_ccm_ccgr2_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr2_t;

/*!
 * @name Constants and macros for entire CCM_CCGR2 register
 */
/*@{*/
#define HW_CCM_CCGR2_ADDR(x)     ((uintptr_t)(x) + 0x4020U)
#define HW_CCM_CCGR2_SET_ADDR(x) (HW_CCM_CCGR2_ADDR(x) + 0x4U)
#define HW_CCM_CCGR2_CLR_ADDR(x) (HW_CCM_CCGR2_ADDR(x) + 0x8U)
#define HW_CCM_CCGR2_TOG_ADDR(x) (HW_CCM_CCGR2_ADDR(x) + 0xCU)

#define HW_CCM_CCGR2(x)          (*(__IO hw_ccm_ccgr2_t *) HW_CCM_CCGR2_ADDR(x))
#define HW_CCM_CCGR2_RD(x)       (HW_CCM_CCGR2(x).U)
#define HW_CCM_CCGR2_WR(x, v)    (HW_CCM_CCGR2(x).U = (v))
#define HW_CCM_CCGR2_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR2_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR2_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR2_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR2_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR2_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR2 bitfields
 */

/*!
 * @name Register CCM_CCGR2, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR2_SETTING0 (0U)         /*!< Bit position for CCM_CCGR2_SETTING0. */
#define BM_CCM_CCGR2_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR2_SETTING0. */
#define BS_CCM_CCGR2_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR2_SETTING0. */

/*! @brief Read current value of the CCM_CCGR2_SETTING0 field. */
#define BR_CCM_CCGR2_SETTING0(x) (HW_CCM_CCGR2(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR2_SETTING0. */
#define BF_CCM_CCGR2_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_SETTING0) & BM_CCM_CCGR2_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR2_SETTING0(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_SETTING0) | BF_CCM_CCGR2_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR2_SETTING1 (4U)         /*!< Bit position for CCM_CCGR2_SETTING1. */
#define BM_CCM_CCGR2_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR2_SETTING1. */
#define BS_CCM_CCGR2_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR2_SETTING1. */

/*! @brief Read current value of the CCM_CCGR2_SETTING1 field. */
#define BR_CCM_CCGR2_SETTING1(x) (HW_CCM_CCGR2(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR2_SETTING1. */
#define BF_CCM_CCGR2_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_SETTING1) & BM_CCM_CCGR2_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR2_SETTING1(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_SETTING1) | BF_CCM_CCGR2_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR2_SETTING2 (8U)         /*!< Bit position for CCM_CCGR2_SETTING2. */
#define BM_CCM_CCGR2_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR2_SETTING2. */
#define BS_CCM_CCGR2_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR2_SETTING2. */

/*! @brief Read current value of the CCM_CCGR2_SETTING2 field. */
#define BR_CCM_CCGR2_SETTING2(x) (HW_CCM_CCGR2(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR2_SETTING2. */
#define BF_CCM_CCGR2_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_SETTING2) & BM_CCM_CCGR2_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR2_SETTING2(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_SETTING2) | BF_CCM_CCGR2_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR2, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR2_SETTING3 (12U)        /*!< Bit position for CCM_CCGR2_SETTING3. */
#define BM_CCM_CCGR2_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR2_SETTING3. */
#define BS_CCM_CCGR2_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR2_SETTING3. */

/*! @brief Read current value of the CCM_CCGR2_SETTING3 field. */
#define BR_CCM_CCGR2_SETTING3(x) (HW_CCM_CCGR2(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR2_SETTING3. */
#define BF_CCM_CCGR2_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR2_SETTING3) & BM_CCM_CCGR2_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR2_SETTING3(x, v) (HW_CCM_CCGR2_WR(x, (HW_CCM_CCGR2_RD(x) & ~BM_CCM_CCGR2_SETTING3) | BF_CCM_CCGR2_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR3 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR3 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr3
{
    uint32_t U;
    struct _hw_ccm_ccgr3_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr3_t;

/*!
 * @name Constants and macros for entire CCM_CCGR3 register
 */
/*@{*/
#define HW_CCM_CCGR3_ADDR(x)     ((uintptr_t)(x) + 0x4030U)
#define HW_CCM_CCGR3_SET_ADDR(x) (HW_CCM_CCGR3_ADDR(x) + 0x4U)
#define HW_CCM_CCGR3_CLR_ADDR(x) (HW_CCM_CCGR3_ADDR(x) + 0x8U)
#define HW_CCM_CCGR3_TOG_ADDR(x) (HW_CCM_CCGR3_ADDR(x) + 0xCU)

#define HW_CCM_CCGR3(x)          (*(__IO hw_ccm_ccgr3_t *) HW_CCM_CCGR3_ADDR(x))
#define HW_CCM_CCGR3_RD(x)       (HW_CCM_CCGR3(x).U)
#define HW_CCM_CCGR3_WR(x, v)    (HW_CCM_CCGR3(x).U = (v))
#define HW_CCM_CCGR3_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR3_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR3_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR3_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR3_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR3_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR3 bitfields
 */

/*!
 * @name Register CCM_CCGR3, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR3_SETTING0 (0U)         /*!< Bit position for CCM_CCGR3_SETTING0. */
#define BM_CCM_CCGR3_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR3_SETTING0. */
#define BS_CCM_CCGR3_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR3_SETTING0. */

/*! @brief Read current value of the CCM_CCGR3_SETTING0 field. */
#define BR_CCM_CCGR3_SETTING0(x) (HW_CCM_CCGR3(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR3_SETTING0. */
#define BF_CCM_CCGR3_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_SETTING0) & BM_CCM_CCGR3_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR3_SETTING0(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_SETTING0) | BF_CCM_CCGR3_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR3_SETTING1 (4U)         /*!< Bit position for CCM_CCGR3_SETTING1. */
#define BM_CCM_CCGR3_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR3_SETTING1. */
#define BS_CCM_CCGR3_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR3_SETTING1. */

/*! @brief Read current value of the CCM_CCGR3_SETTING1 field. */
#define BR_CCM_CCGR3_SETTING1(x) (HW_CCM_CCGR3(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR3_SETTING1. */
#define BF_CCM_CCGR3_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_SETTING1) & BM_CCM_CCGR3_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR3_SETTING1(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_SETTING1) | BF_CCM_CCGR3_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR3_SETTING2 (8U)         /*!< Bit position for CCM_CCGR3_SETTING2. */
#define BM_CCM_CCGR3_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR3_SETTING2. */
#define BS_CCM_CCGR3_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR3_SETTING2. */

/*! @brief Read current value of the CCM_CCGR3_SETTING2 field. */
#define BR_CCM_CCGR3_SETTING2(x) (HW_CCM_CCGR3(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR3_SETTING2. */
#define BF_CCM_CCGR3_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_SETTING2) & BM_CCM_CCGR3_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR3_SETTING2(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_SETTING2) | BF_CCM_CCGR3_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR3, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR3_SETTING3 (12U)        /*!< Bit position for CCM_CCGR3_SETTING3. */
#define BM_CCM_CCGR3_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR3_SETTING3. */
#define BS_CCM_CCGR3_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR3_SETTING3. */

/*! @brief Read current value of the CCM_CCGR3_SETTING3 field. */
#define BR_CCM_CCGR3_SETTING3(x) (HW_CCM_CCGR3(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR3_SETTING3. */
#define BF_CCM_CCGR3_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR3_SETTING3) & BM_CCM_CCGR3_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR3_SETTING3(x, v) (HW_CCM_CCGR3_WR(x, (HW_CCM_CCGR3_RD(x) & ~BM_CCM_CCGR3_SETTING3) | BF_CCM_CCGR3_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR4 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR4 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr4
{
    uint32_t U;
    struct _hw_ccm_ccgr4_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr4_t;

/*!
 * @name Constants and macros for entire CCM_CCGR4 register
 */
/*@{*/
#define HW_CCM_CCGR4_ADDR(x)     ((uintptr_t)(x) + 0x4040U)
#define HW_CCM_CCGR4_SET_ADDR(x) (HW_CCM_CCGR4_ADDR(x) + 0x4U)
#define HW_CCM_CCGR4_CLR_ADDR(x) (HW_CCM_CCGR4_ADDR(x) + 0x8U)
#define HW_CCM_CCGR4_TOG_ADDR(x) (HW_CCM_CCGR4_ADDR(x) + 0xCU)

#define HW_CCM_CCGR4(x)          (*(__IO hw_ccm_ccgr4_t *) HW_CCM_CCGR4_ADDR(x))
#define HW_CCM_CCGR4_RD(x)       (HW_CCM_CCGR4(x).U)
#define HW_CCM_CCGR4_WR(x, v)    (HW_CCM_CCGR4(x).U = (v))
#define HW_CCM_CCGR4_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR4_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR4_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR4_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR4_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR4_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR4 bitfields
 */

/*!
 * @name Register CCM_CCGR4, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR4_SETTING0 (0U)         /*!< Bit position for CCM_CCGR4_SETTING0. */
#define BM_CCM_CCGR4_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR4_SETTING0. */
#define BS_CCM_CCGR4_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR4_SETTING0. */

/*! @brief Read current value of the CCM_CCGR4_SETTING0 field. */
#define BR_CCM_CCGR4_SETTING0(x) (HW_CCM_CCGR4(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR4_SETTING0. */
#define BF_CCM_CCGR4_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_SETTING0) & BM_CCM_CCGR4_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR4_SETTING0(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_SETTING0) | BF_CCM_CCGR4_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR4_SETTING1 (4U)         /*!< Bit position for CCM_CCGR4_SETTING1. */
#define BM_CCM_CCGR4_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR4_SETTING1. */
#define BS_CCM_CCGR4_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR4_SETTING1. */

/*! @brief Read current value of the CCM_CCGR4_SETTING1 field. */
#define BR_CCM_CCGR4_SETTING1(x) (HW_CCM_CCGR4(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR4_SETTING1. */
#define BF_CCM_CCGR4_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_SETTING1) & BM_CCM_CCGR4_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR4_SETTING1(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_SETTING1) | BF_CCM_CCGR4_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR4_SETTING2 (8U)         /*!< Bit position for CCM_CCGR4_SETTING2. */
#define BM_CCM_CCGR4_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR4_SETTING2. */
#define BS_CCM_CCGR4_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR4_SETTING2. */

/*! @brief Read current value of the CCM_CCGR4_SETTING2 field. */
#define BR_CCM_CCGR4_SETTING2(x) (HW_CCM_CCGR4(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR4_SETTING2. */
#define BF_CCM_CCGR4_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_SETTING2) & BM_CCM_CCGR4_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR4_SETTING2(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_SETTING2) | BF_CCM_CCGR4_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR4, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR4_SETTING3 (12U)        /*!< Bit position for CCM_CCGR4_SETTING3. */
#define BM_CCM_CCGR4_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR4_SETTING3. */
#define BS_CCM_CCGR4_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR4_SETTING3. */

/*! @brief Read current value of the CCM_CCGR4_SETTING3 field. */
#define BR_CCM_CCGR4_SETTING3(x) (HW_CCM_CCGR4(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR4_SETTING3. */
#define BF_CCM_CCGR4_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR4_SETTING3) & BM_CCM_CCGR4_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR4_SETTING3(x, v) (HW_CCM_CCGR4_WR(x, (HW_CCM_CCGR4_RD(x) & ~BM_CCM_CCGR4_SETTING3) | BF_CCM_CCGR4_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR5 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR5 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr5
{
    uint32_t U;
    struct _hw_ccm_ccgr5_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr5_t;

/*!
 * @name Constants and macros for entire CCM_CCGR5 register
 */
/*@{*/
#define HW_CCM_CCGR5_ADDR(x)     ((uintptr_t)(x) + 0x4050U)
#define HW_CCM_CCGR5_SET_ADDR(x) (HW_CCM_CCGR5_ADDR(x) + 0x4U)
#define HW_CCM_CCGR5_CLR_ADDR(x) (HW_CCM_CCGR5_ADDR(x) + 0x8U)
#define HW_CCM_CCGR5_TOG_ADDR(x) (HW_CCM_CCGR5_ADDR(x) + 0xCU)

#define HW_CCM_CCGR5(x)          (*(__IO hw_ccm_ccgr5_t *) HW_CCM_CCGR5_ADDR(x))
#define HW_CCM_CCGR5_RD(x)       (HW_CCM_CCGR5(x).U)
#define HW_CCM_CCGR5_WR(x, v)    (HW_CCM_CCGR5(x).U = (v))
#define HW_CCM_CCGR5_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR5_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR5_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR5_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR5_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR5_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR5 bitfields
 */

/*!
 * @name Register CCM_CCGR5, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR5_SETTING0 (0U)         /*!< Bit position for CCM_CCGR5_SETTING0. */
#define BM_CCM_CCGR5_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR5_SETTING0. */
#define BS_CCM_CCGR5_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR5_SETTING0. */

/*! @brief Read current value of the CCM_CCGR5_SETTING0 field. */
#define BR_CCM_CCGR5_SETTING0(x) (HW_CCM_CCGR5(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR5_SETTING0. */
#define BF_CCM_CCGR5_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_SETTING0) & BM_CCM_CCGR5_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR5_SETTING0(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_SETTING0) | BF_CCM_CCGR5_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR5_SETTING1 (4U)         /*!< Bit position for CCM_CCGR5_SETTING1. */
#define BM_CCM_CCGR5_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR5_SETTING1. */
#define BS_CCM_CCGR5_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR5_SETTING1. */

/*! @brief Read current value of the CCM_CCGR5_SETTING1 field. */
#define BR_CCM_CCGR5_SETTING1(x) (HW_CCM_CCGR5(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR5_SETTING1. */
#define BF_CCM_CCGR5_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_SETTING1) & BM_CCM_CCGR5_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR5_SETTING1(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_SETTING1) | BF_CCM_CCGR5_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR5_SETTING2 (8U)         /*!< Bit position for CCM_CCGR5_SETTING2. */
#define BM_CCM_CCGR5_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR5_SETTING2. */
#define BS_CCM_CCGR5_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR5_SETTING2. */

/*! @brief Read current value of the CCM_CCGR5_SETTING2 field. */
#define BR_CCM_CCGR5_SETTING2(x) (HW_CCM_CCGR5(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR5_SETTING2. */
#define BF_CCM_CCGR5_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_SETTING2) & BM_CCM_CCGR5_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR5_SETTING2(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_SETTING2) | BF_CCM_CCGR5_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR5, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR5_SETTING3 (12U)        /*!< Bit position for CCM_CCGR5_SETTING3. */
#define BM_CCM_CCGR5_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR5_SETTING3. */
#define BS_CCM_CCGR5_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR5_SETTING3. */

/*! @brief Read current value of the CCM_CCGR5_SETTING3 field. */
#define BR_CCM_CCGR5_SETTING3(x) (HW_CCM_CCGR5(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR5_SETTING3. */
#define BF_CCM_CCGR5_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR5_SETTING3) & BM_CCM_CCGR5_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR5_SETTING3(x, v) (HW_CCM_CCGR5_WR(x, (HW_CCM_CCGR5_RD(x) & ~BM_CCM_CCGR5_SETTING3) | BF_CCM_CCGR5_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR6 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR6 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr6
{
    uint32_t U;
    struct _hw_ccm_ccgr6_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr6_t;

/*!
 * @name Constants and macros for entire CCM_CCGR6 register
 */
/*@{*/
#define HW_CCM_CCGR6_ADDR(x)     ((uintptr_t)(x) + 0x4060U)
#define HW_CCM_CCGR6_SET_ADDR(x) (HW_CCM_CCGR6_ADDR(x) + 0x4U)
#define HW_CCM_CCGR6_CLR_ADDR(x) (HW_CCM_CCGR6_ADDR(x) + 0x8U)
#define HW_CCM_CCGR6_TOG_ADDR(x) (HW_CCM_CCGR6_ADDR(x) + 0xCU)

#define HW_CCM_CCGR6(x)          (*(__IO hw_ccm_ccgr6_t *) HW_CCM_CCGR6_ADDR(x))
#define HW_CCM_CCGR6_RD(x)       (HW_CCM_CCGR6(x).U)
#define HW_CCM_CCGR6_WR(x, v)    (HW_CCM_CCGR6(x).U = (v))
#define HW_CCM_CCGR6_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR6_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR6_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR6_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR6_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR6_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR6 bitfields
 */

/*!
 * @name Register CCM_CCGR6, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR6_SETTING0 (0U)         /*!< Bit position for CCM_CCGR6_SETTING0. */
#define BM_CCM_CCGR6_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR6_SETTING0. */
#define BS_CCM_CCGR6_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR6_SETTING0. */

/*! @brief Read current value of the CCM_CCGR6_SETTING0 field. */
#define BR_CCM_CCGR6_SETTING0(x) (HW_CCM_CCGR6(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR6_SETTING0. */
#define BF_CCM_CCGR6_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_SETTING0) & BM_CCM_CCGR6_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR6_SETTING0(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_SETTING0) | BF_CCM_CCGR6_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR6_SETTING1 (4U)         /*!< Bit position for CCM_CCGR6_SETTING1. */
#define BM_CCM_CCGR6_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR6_SETTING1. */
#define BS_CCM_CCGR6_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR6_SETTING1. */

/*! @brief Read current value of the CCM_CCGR6_SETTING1 field. */
#define BR_CCM_CCGR6_SETTING1(x) (HW_CCM_CCGR6(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR6_SETTING1. */
#define BF_CCM_CCGR6_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_SETTING1) & BM_CCM_CCGR6_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR6_SETTING1(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_SETTING1) | BF_CCM_CCGR6_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR6_SETTING2 (8U)         /*!< Bit position for CCM_CCGR6_SETTING2. */
#define BM_CCM_CCGR6_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR6_SETTING2. */
#define BS_CCM_CCGR6_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR6_SETTING2. */

/*! @brief Read current value of the CCM_CCGR6_SETTING2 field. */
#define BR_CCM_CCGR6_SETTING2(x) (HW_CCM_CCGR6(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR6_SETTING2. */
#define BF_CCM_CCGR6_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_SETTING2) & BM_CCM_CCGR6_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR6_SETTING2(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_SETTING2) | BF_CCM_CCGR6_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR6, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR6_SETTING3 (12U)        /*!< Bit position for CCM_CCGR6_SETTING3. */
#define BM_CCM_CCGR6_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR6_SETTING3. */
#define BS_CCM_CCGR6_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR6_SETTING3. */

/*! @brief Read current value of the CCM_CCGR6_SETTING3 field. */
#define BR_CCM_CCGR6_SETTING3(x) (HW_CCM_CCGR6(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR6_SETTING3. */
#define BF_CCM_CCGR6_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR6_SETTING3) & BM_CCM_CCGR6_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR6_SETTING3(x, v) (HW_CCM_CCGR6_WR(x, (HW_CCM_CCGR6_RD(x) & ~BM_CCM_CCGR6_SETTING3) | BF_CCM_CCGR6_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR7 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR7 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr7
{
    uint32_t U;
    struct _hw_ccm_ccgr7_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr7_t;

/*!
 * @name Constants and macros for entire CCM_CCGR7 register
 */
/*@{*/
#define HW_CCM_CCGR7_ADDR(x)     ((uintptr_t)(x) + 0x4070U)
#define HW_CCM_CCGR7_SET_ADDR(x) (HW_CCM_CCGR7_ADDR(x) + 0x4U)
#define HW_CCM_CCGR7_CLR_ADDR(x) (HW_CCM_CCGR7_ADDR(x) + 0x8U)
#define HW_CCM_CCGR7_TOG_ADDR(x) (HW_CCM_CCGR7_ADDR(x) + 0xCU)

#define HW_CCM_CCGR7(x)          (*(__IO hw_ccm_ccgr7_t *) HW_CCM_CCGR7_ADDR(x))
#define HW_CCM_CCGR7_RD(x)       (HW_CCM_CCGR7(x).U)
#define HW_CCM_CCGR7_WR(x, v)    (HW_CCM_CCGR7(x).U = (v))
#define HW_CCM_CCGR7_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR7_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR7_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR7_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR7_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR7_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR7 bitfields
 */

/*!
 * @name Register CCM_CCGR7, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR7_SETTING0 (0U)         /*!< Bit position for CCM_CCGR7_SETTING0. */
#define BM_CCM_CCGR7_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR7_SETTING0. */
#define BS_CCM_CCGR7_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR7_SETTING0. */

/*! @brief Read current value of the CCM_CCGR7_SETTING0 field. */
#define BR_CCM_CCGR7_SETTING0(x) (HW_CCM_CCGR7(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR7_SETTING0. */
#define BF_CCM_CCGR7_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR7_SETTING0) & BM_CCM_CCGR7_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR7_SETTING0(x, v) (HW_CCM_CCGR7_WR(x, (HW_CCM_CCGR7_RD(x) & ~BM_CCM_CCGR7_SETTING0) | BF_CCM_CCGR7_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR7, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR7_SETTING1 (4U)         /*!< Bit position for CCM_CCGR7_SETTING1. */
#define BM_CCM_CCGR7_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR7_SETTING1. */
#define BS_CCM_CCGR7_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR7_SETTING1. */

/*! @brief Read current value of the CCM_CCGR7_SETTING1 field. */
#define BR_CCM_CCGR7_SETTING1(x) (HW_CCM_CCGR7(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR7_SETTING1. */
#define BF_CCM_CCGR7_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR7_SETTING1) & BM_CCM_CCGR7_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR7_SETTING1(x, v) (HW_CCM_CCGR7_WR(x, (HW_CCM_CCGR7_RD(x) & ~BM_CCM_CCGR7_SETTING1) | BF_CCM_CCGR7_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR7, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR7_SETTING2 (8U)         /*!< Bit position for CCM_CCGR7_SETTING2. */
#define BM_CCM_CCGR7_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR7_SETTING2. */
#define BS_CCM_CCGR7_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR7_SETTING2. */

/*! @brief Read current value of the CCM_CCGR7_SETTING2 field. */
#define BR_CCM_CCGR7_SETTING2(x) (HW_CCM_CCGR7(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR7_SETTING2. */
#define BF_CCM_CCGR7_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR7_SETTING2) & BM_CCM_CCGR7_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR7_SETTING2(x, v) (HW_CCM_CCGR7_WR(x, (HW_CCM_CCGR7_RD(x) & ~BM_CCM_CCGR7_SETTING2) | BF_CCM_CCGR7_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR7, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR7_SETTING3 (12U)        /*!< Bit position for CCM_CCGR7_SETTING3. */
#define BM_CCM_CCGR7_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR7_SETTING3. */
#define BS_CCM_CCGR7_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR7_SETTING3. */

/*! @brief Read current value of the CCM_CCGR7_SETTING3 field. */
#define BR_CCM_CCGR7_SETTING3(x) (HW_CCM_CCGR7(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR7_SETTING3. */
#define BF_CCM_CCGR7_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR7_SETTING3) & BM_CCM_CCGR7_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR7_SETTING3(x, v) (HW_CCM_CCGR7_WR(x, (HW_CCM_CCGR7_RD(x) & ~BM_CCM_CCGR7_SETTING3) | BF_CCM_CCGR7_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR8 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR8 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr8
{
    uint32_t U;
    struct _hw_ccm_ccgr8_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr8_t;

/*!
 * @name Constants and macros for entire CCM_CCGR8 register
 */
/*@{*/
#define HW_CCM_CCGR8_ADDR(x)     ((uintptr_t)(x) + 0x4080U)
#define HW_CCM_CCGR8_SET_ADDR(x) (HW_CCM_CCGR8_ADDR(x) + 0x4U)
#define HW_CCM_CCGR8_CLR_ADDR(x) (HW_CCM_CCGR8_ADDR(x) + 0x8U)
#define HW_CCM_CCGR8_TOG_ADDR(x) (HW_CCM_CCGR8_ADDR(x) + 0xCU)

#define HW_CCM_CCGR8(x)          (*(__IO hw_ccm_ccgr8_t *) HW_CCM_CCGR8_ADDR(x))
#define HW_CCM_CCGR8_RD(x)       (HW_CCM_CCGR8(x).U)
#define HW_CCM_CCGR8_WR(x, v)    (HW_CCM_CCGR8(x).U = (v))
#define HW_CCM_CCGR8_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR8_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR8_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR8_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR8_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR8_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR8 bitfields
 */

/*!
 * @name Register CCM_CCGR8, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR8_SETTING0 (0U)         /*!< Bit position for CCM_CCGR8_SETTING0. */
#define BM_CCM_CCGR8_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR8_SETTING0. */
#define BS_CCM_CCGR8_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR8_SETTING0. */

/*! @brief Read current value of the CCM_CCGR8_SETTING0 field. */
#define BR_CCM_CCGR8_SETTING0(x) (HW_CCM_CCGR8(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR8_SETTING0. */
#define BF_CCM_CCGR8_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR8_SETTING0) & BM_CCM_CCGR8_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR8_SETTING0(x, v) (HW_CCM_CCGR8_WR(x, (HW_CCM_CCGR8_RD(x) & ~BM_CCM_CCGR8_SETTING0) | BF_CCM_CCGR8_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR8, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR8_SETTING1 (4U)         /*!< Bit position for CCM_CCGR8_SETTING1. */
#define BM_CCM_CCGR8_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR8_SETTING1. */
#define BS_CCM_CCGR8_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR8_SETTING1. */

/*! @brief Read current value of the CCM_CCGR8_SETTING1 field. */
#define BR_CCM_CCGR8_SETTING1(x) (HW_CCM_CCGR8(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR8_SETTING1. */
#define BF_CCM_CCGR8_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR8_SETTING1) & BM_CCM_CCGR8_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR8_SETTING1(x, v) (HW_CCM_CCGR8_WR(x, (HW_CCM_CCGR8_RD(x) & ~BM_CCM_CCGR8_SETTING1) | BF_CCM_CCGR8_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR8, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR8_SETTING2 (8U)         /*!< Bit position for CCM_CCGR8_SETTING2. */
#define BM_CCM_CCGR8_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR8_SETTING2. */
#define BS_CCM_CCGR8_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR8_SETTING2. */

/*! @brief Read current value of the CCM_CCGR8_SETTING2 field. */
#define BR_CCM_CCGR8_SETTING2(x) (HW_CCM_CCGR8(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR8_SETTING2. */
#define BF_CCM_CCGR8_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR8_SETTING2) & BM_CCM_CCGR8_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR8_SETTING2(x, v) (HW_CCM_CCGR8_WR(x, (HW_CCM_CCGR8_RD(x) & ~BM_CCM_CCGR8_SETTING2) | BF_CCM_CCGR8_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR8, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR8_SETTING3 (12U)        /*!< Bit position for CCM_CCGR8_SETTING3. */
#define BM_CCM_CCGR8_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR8_SETTING3. */
#define BS_CCM_CCGR8_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR8_SETTING3. */

/*! @brief Read current value of the CCM_CCGR8_SETTING3 field. */
#define BR_CCM_CCGR8_SETTING3(x) (HW_CCM_CCGR8(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR8_SETTING3. */
#define BF_CCM_CCGR8_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR8_SETTING3) & BM_CCM_CCGR8_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR8_SETTING3(x, v) (HW_CCM_CCGR8_WR(x, (HW_CCM_CCGR8_RD(x) & ~BM_CCM_CCGR8_SETTING3) | BF_CCM_CCGR8_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR9 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR9 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr9
{
    uint32_t U;
    struct _hw_ccm_ccgr9_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr9_t;

/*!
 * @name Constants and macros for entire CCM_CCGR9 register
 */
/*@{*/
#define HW_CCM_CCGR9_ADDR(x)     ((uintptr_t)(x) + 0x4090U)
#define HW_CCM_CCGR9_SET_ADDR(x) (HW_CCM_CCGR9_ADDR(x) + 0x4U)
#define HW_CCM_CCGR9_CLR_ADDR(x) (HW_CCM_CCGR9_ADDR(x) + 0x8U)
#define HW_CCM_CCGR9_TOG_ADDR(x) (HW_CCM_CCGR9_ADDR(x) + 0xCU)

#define HW_CCM_CCGR9(x)          (*(__IO hw_ccm_ccgr9_t *) HW_CCM_CCGR9_ADDR(x))
#define HW_CCM_CCGR9_RD(x)       (HW_CCM_CCGR9(x).U)
#define HW_CCM_CCGR9_WR(x, v)    (HW_CCM_CCGR9(x).U = (v))
#define HW_CCM_CCGR9_SET(x, v)   ((*(uint32_t *) HW_CCM_CCGR9_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR9_CLR(x, v)   ((*(uint32_t *) HW_CCM_CCGR9_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR9_TOG(x, v)   ((*(uint32_t *) HW_CCM_CCGR9_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR9 bitfields
 */

/*!
 * @name Register CCM_CCGR9, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR9_SETTING0 (0U)         /*!< Bit position for CCM_CCGR9_SETTING0. */
#define BM_CCM_CCGR9_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR9_SETTING0. */
#define BS_CCM_CCGR9_SETTING0 (2U)         /*!< Bit field size in bits for CCM_CCGR9_SETTING0. */

/*! @brief Read current value of the CCM_CCGR9_SETTING0 field. */
#define BR_CCM_CCGR9_SETTING0(x) (HW_CCM_CCGR9(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR9_SETTING0. */
#define BF_CCM_CCGR9_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR9_SETTING0) & BM_CCM_CCGR9_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR9_SETTING0(x, v) (HW_CCM_CCGR9_WR(x, (HW_CCM_CCGR9_RD(x) & ~BM_CCM_CCGR9_SETTING0) | BF_CCM_CCGR9_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR9, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR9_SETTING1 (4U)         /*!< Bit position for CCM_CCGR9_SETTING1. */
#define BM_CCM_CCGR9_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR9_SETTING1. */
#define BS_CCM_CCGR9_SETTING1 (2U)         /*!< Bit field size in bits for CCM_CCGR9_SETTING1. */

/*! @brief Read current value of the CCM_CCGR9_SETTING1 field. */
#define BR_CCM_CCGR9_SETTING1(x) (HW_CCM_CCGR9(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR9_SETTING1. */
#define BF_CCM_CCGR9_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR9_SETTING1) & BM_CCM_CCGR9_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR9_SETTING1(x, v) (HW_CCM_CCGR9_WR(x, (HW_CCM_CCGR9_RD(x) & ~BM_CCM_CCGR9_SETTING1) | BF_CCM_CCGR9_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR9, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR9_SETTING2 (8U)         /*!< Bit position for CCM_CCGR9_SETTING2. */
#define BM_CCM_CCGR9_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR9_SETTING2. */
#define BS_CCM_CCGR9_SETTING2 (2U)         /*!< Bit field size in bits for CCM_CCGR9_SETTING2. */

/*! @brief Read current value of the CCM_CCGR9_SETTING2 field. */
#define BR_CCM_CCGR9_SETTING2(x) (HW_CCM_CCGR9(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR9_SETTING2. */
#define BF_CCM_CCGR9_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR9_SETTING2) & BM_CCM_CCGR9_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR9_SETTING2(x, v) (HW_CCM_CCGR9_WR(x, (HW_CCM_CCGR9_RD(x) & ~BM_CCM_CCGR9_SETTING2) | BF_CCM_CCGR9_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR9, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR9_SETTING3 (12U)        /*!< Bit position for CCM_CCGR9_SETTING3. */
#define BM_CCM_CCGR9_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR9_SETTING3. */
#define BS_CCM_CCGR9_SETTING3 (2U)         /*!< Bit field size in bits for CCM_CCGR9_SETTING3. */

/*! @brief Read current value of the CCM_CCGR9_SETTING3 field. */
#define BR_CCM_CCGR9_SETTING3(x) (HW_CCM_CCGR9(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR9_SETTING3. */
#define BF_CCM_CCGR9_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR9_SETTING3) & BM_CCM_CCGR9_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR9_SETTING3(x, v) (HW_CCM_CCGR9_WR(x, (HW_CCM_CCGR9_RD(x) & ~BM_CCM_CCGR9_SETTING3) | BF_CCM_CCGR9_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR10 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR10 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr10
{
    uint32_t U;
    struct _hw_ccm_ccgr10_bitfields
    {
        uint32_t SETTING0 : 2;         /*!< [1:0]  */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t SETTING1 : 2;         /*!< [5:4]  */
        uint32_t RESERVED1 : 2;        /*!< [7:6]  */
        uint32_t SETTING2 : 2;         /*!< [9:8]  */
        uint32_t RESERVED2 : 2;        /*!< [11:10]  */
        uint32_t SETTING3 : 2;         /*!< [13:12]  */
        uint32_t RESERVED3 : 18;       /*!< [31:14]  */
    } B;
} hw_ccm_ccgr10_t;

/*!
 * @name Constants and macros for entire CCM_CCGR10 register
 */
/*@{*/
#define HW_CCM_CCGR10_ADDR(x)    ((uintptr_t)(x) + 0x40A0U)
#define HW_CCM_CCGR10_SET_ADDR(x) (HW_CCM_CCGR10_ADDR(x) + 0x4U)
#define HW_CCM_CCGR10_CLR_ADDR(x) (HW_CCM_CCGR10_ADDR(x) + 0x8U)
#define HW_CCM_CCGR10_TOG_ADDR(x) (HW_CCM_CCGR10_ADDR(x) + 0xCU)

#define HW_CCM_CCGR10(x)         (*(__IO hw_ccm_ccgr10_t *) HW_CCM_CCGR10_ADDR(x))
#define HW_CCM_CCGR10_RD(x)      (HW_CCM_CCGR10(x).U)
#define HW_CCM_CCGR10_WR(x, v)   (HW_CCM_CCGR10(x).U = (v))
#define HW_CCM_CCGR10_SET(x, v)  ((*(uint32_t *) HW_CCM_CCGR10_SET_ADDR(x)) = (v))
#define HW_CCM_CCGR10_CLR(x, v)  ((*(uint32_t *) HW_CCM_CCGR10_CLR_ADDR(x)) = (v))
#define HW_CCM_CCGR10_TOG(x, v)  ((*(uint32_t *) HW_CCM_CCGR10_TOG_ADDR(x)) = (v))
/*@}*/

/*
 * Constants & macros for individual CCM_CCGR10 bitfields
 */

/*!
 * @name Register CCM_CCGR10, field SETTING0[1:0] (RW)
 *
 * Clock gate control setting for domain 0. This field can only be written by
 * domain 0.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR10_SETTING0 (0U)        /*!< Bit position for CCM_CCGR10_SETTING0. */
#define BM_CCM_CCGR10_SETTING0 (0x00000003U) /*!< Bit mask for CCM_CCGR10_SETTING0. */
#define BS_CCM_CCGR10_SETTING0 (2U)        /*!< Bit field size in bits for CCM_CCGR10_SETTING0. */

/*! @brief Read current value of the CCM_CCGR10_SETTING0 field. */
#define BR_CCM_CCGR10_SETTING0(x) (HW_CCM_CCGR10(x).B.SETTING0)

/*! @brief Format value for bitfield CCM_CCGR10_SETTING0. */
#define BF_CCM_CCGR10_SETTING0(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR10_SETTING0) & BM_CCM_CCGR10_SETTING0)

/*! @brief Set the SETTING0 field to a new value. */
#define BW_CCM_CCGR10_SETTING0(x, v) (HW_CCM_CCGR10_WR(x, (HW_CCM_CCGR10_RD(x) & ~BM_CCM_CCGR10_SETTING0) | BF_CCM_CCGR10_SETTING0(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR10, field SETTING1[5:4] (RW)
 *
 * Clock gate control setting for domain 1. This field can only be written by
 * domain 1.
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR10_SETTING1 (4U)        /*!< Bit position for CCM_CCGR10_SETTING1. */
#define BM_CCM_CCGR10_SETTING1 (0x00000030U) /*!< Bit mask for CCM_CCGR10_SETTING1. */
#define BS_CCM_CCGR10_SETTING1 (2U)        /*!< Bit field size in bits for CCM_CCGR10_SETTING1. */

/*! @brief Read current value of the CCM_CCGR10_SETTING1 field. */
#define BR_CCM_CCGR10_SETTING1(x) (HW_CCM_CCGR10(x).B.SETTING1)

/*! @brief Format value for bitfield CCM_CCGR10_SETTING1. */
#define BF_CCM_CCGR10_SETTING1(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR10_SETTING1) & BM_CCM_CCGR10_SETTING1)

/*! @brief Set the SETTING1 field to a new value. */
#define BW_CCM_CCGR10_SETTING1(x, v) (HW_CCM_CCGR10_WR(x, (HW_CCM_CCGR10_RD(x) & ~BM_CCM_CCGR10_SETTING1) | BF_CCM_CCGR10_SETTING1(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR10, field SETTING2[9:8] (RW)
 *
 * Clock gate control setting for domain 2. This field can only be written by
 * domain 2
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR10_SETTING2 (8U)        /*!< Bit position for CCM_CCGR10_SETTING2. */
#define BM_CCM_CCGR10_SETTING2 (0x00000300U) /*!< Bit mask for CCM_CCGR10_SETTING2. */
#define BS_CCM_CCGR10_SETTING2 (2U)        /*!< Bit field size in bits for CCM_CCGR10_SETTING2. */

/*! @brief Read current value of the CCM_CCGR10_SETTING2 field. */
#define BR_CCM_CCGR10_SETTING2(x) (HW_CCM_CCGR10(x).B.SETTING2)

/*! @brief Format value for bitfield CCM_CCGR10_SETTING2. */
#define BF_CCM_CCGR10_SETTING2(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR10_SETTING2) & BM_CCM_CCGR10_SETTING2)

/*! @brief Set the SETTING2 field to a new value. */
#define BW_CCM_CCGR10_SETTING2(x, v) (HW_CCM_CCGR10_WR(x, (HW_CCM_CCGR10_RD(x) & ~BM_CCM_CCGR10_SETTING2) | BF_CCM_CCGR10_SETTING2(v)))
/*@}*/

/*!
 * @name Register CCM_CCGR10, field SETTING3[13:12] (RW)
 *
 * Clock gate control setting for domain 3. This field can only be written by
 * domain 3
 *
 * Values:
 * - 00 - Domain clocks not needed
 * - 01 - Domain clocks needed when in RUN
 * - 10 - Domain clocks needed when in RUN and WAIT
 * - 11 - Domain clocks needed all the time
 */
/*@{*/
#define BP_CCM_CCGR10_SETTING3 (12U)       /*!< Bit position for CCM_CCGR10_SETTING3. */
#define BM_CCM_CCGR10_SETTING3 (0x00003000U) /*!< Bit mask for CCM_CCGR10_SETTING3. */
#define BS_CCM_CCGR10_SETTING3 (2U)        /*!< Bit field size in bits for CCM_CCGR10_SETTING3. */

/*! @brief Read current value of the CCM_CCGR10_SETTING3 field. */
#define BR_CCM_CCGR10_SETTING3(x) (HW_CCM_CCGR10(x).B.SETTING3)

/*! @brief Format value for bitfield CCM_CCGR10_SETTING3. */
#define BF_CCM_CCGR10_SETTING3(v) ((uint32_t)((uint32_t)(v) << BP_CCM_CCGR10_SETTING3) & BM_CCM_CCGR10_SETTING3)

/*! @brief Set the SETTING3 field to a new value. */
#define BW_CCM_CCGR10_SETTING3(x, v) (HW_CCM_CCGR10_WR(x, (HW_CCM_CCGR10_RD(x) & ~BM_CCM_CCGR10_SETTING3) | BF_CCM_CCGR10_SETTING3(v)))
/*@}*/
/*******************************************************************************
 * HW_CCM_CCGR11 - CCM Clock Gating Register
 ******************************************************************************/

/*!
 * @brief HW_CCM_CCGR11 - CCM Clock Gating Register (RW)
 *
 * Reset value: 0x00000002U
 *
 * Not all CCGRs are mapped. See CCGR Interface for CCGR mapping and clock
 * gating information.
 */
typedef union _hw_ccm_ccgr11
{
    uint32_t U;
    struct _hw_ccm_ccgr11_