/* Coldfire C Header File
 * Copyright Freescale Semiconductor Inc
 * All rights reserved.
 *
 * 2007/03/19 Revision: 0.91
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#ifndef __MCF5213_H__
#define __MCF5213_H__


#ifdef __cplusplus
extern "C" {
#endif

#pragma define_section system ".system" far_absolute RW

/***
 * MCF5213 Derivative Memory map definitions from linker command files:
 * __IPSBAR, __RAMBAR, __RAMBAR_SIZE, __FLASHBAR, __FLASHBAR_SIZE linker
 * symbols must be defined in the linker command file.
 */

extern __declspec(system)  uint8 __IPSBAR[];
extern __declspec(system)  uint8 __RAMBAR[];
extern __declspec(system)  uint8 __RAMBAR_SIZE[];
extern __declspec(system)  uint8 __FLASHBAR[];
extern __declspec(system)  uint8 __FLASHBAR_SIZE[];

#define IPSBAR_ADDRESS   (uint32)__IPSBAR
#define RAMBAR_ADDRESS   (uint32)__RAMBAR
#define RAMBAR_SIZE      (uint32)__RAMBAR_SIZE
#define FLASHBAR_ADDRESS (uint32)__FLASHBAR
#define FLASHBAR_SIZE    (uint32)__FLASHBAR_SIZE


#include "mcf5213_scm.h"
#include "mcf5213_dma.h"
#include "mcf5213_uart.h"
#include "mcf5213_i2c.h"
#include "mcf5213_qspi.h"
#include "mcf5213_dtim.h"
#include "mcf5213_intc.h"
#include "mcf5213_gpio.h"
#include "mcf5213_pad.h"
#include "mcf5213_rcm.h"
#include "mcf5213_ccm.h"
#include "mcf5213_pmm.h"
#include "mcf5213_clock.h"
#include "mcf5213_eport.h"
#include "mcf5213_pit.h"
#include "mcf5213_adc.h"
#include "mcf5213_gpt.h"
#include "mcf5213_pwm.h"
#include "mcf5213_can.h"
#include "mcf5213_cfm.h"


#ifdef __cplusplus
}
#endif


#endif /* __MCF5213_H__ */
