/*
 * File:        m5213evb.h
 * Purpose:     Evaluation board definitions and memory map information
 *
 * Notes:
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#ifndef __M5213EVB_H__
#define __M5213EVB_H__

/********************************************************************/

/* System Clock Info */ 
#define REF_CLK_MHZ         (8)
#define SYS_CLK_MHZ         (80)
#define REF_CLK_KHZ         (REF_CLK_MHZ * 1000)
#define SYS_CLK_KHZ         (SYS_CLK_MHZ * 1000)

extern int sys_clk_khz;
extern int sys_clk_mhz;

/* Serial Port Info */
#define TERMINAL_PORT       (0)
#define TERMINAL_BAUD       (19200)
#undef  HW_FLOW_CONTROL

/* 
 * Memory map definitions from linker command files 
 */
extern uint8 __IPSBAR[];
extern uint8 __SRAM[];
extern uint8 __SRAM_SIZE[];
extern uint8 __FLASH[];
extern uint8 __FLASH_SIZE[];

/* 
 * Memory Map Info 
 */
#define IPSBAR_ADDRESS      (uint32)__IPSBAR

#define SRAM_ADDRESS        (uint32)__SRAM
#define SRAM_SIZE           (uint32)__SRAM_SIZE

#define FLASH_ADDRESS       (uint32)__FLASH
#define FLASH_SIZE          (uint32)__FLASH_SIZE

/*
 * Board specific function prototypes
 */
void board_sysinit (void);
void board_handle_interrupt (int);
void board_led_display (int);

/********************************************************************/

#endif /* __M5213EVB_H__ */
