#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


void busclk_init() {						

	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			//FBUS = FPLL/2.   FBUS = 16MHz, 
	
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		//FREF=4/(1+1) = 2MHZ	
	
	CPMUSYNR_VCOFRQ = 0x0;          //FVCO is between 32MHZ and 48MHZ	
	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 32MHZ 
	
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags
	  
	ECLKCTL_NECLK = 0;				// BUSCLock by PS3 enabled	
	}



void main(void) {
	
	busclk_init();
    EnableInterrupts;  
	 
	/********************************************/
	/*********** GPIO INITIALIZATION ************/
	/********************************************/

	//Use PP6 as output for LED
	DDRP_DDRP5 = 1;

	/********************************************/
	/************ API INITIALIZATION ************/
	/********************************************/
	
	CPMUAPICTL_APICLK=0; //Use Autonomous Clock as source
	CPMUACLKTR=0b01111100; //highest
	CPMUAPICTL_APIE=1; //API interrupt will be requested whenever APIF is set.
	
	CPMUAPIRH=0x7F;  //Modify this register to change the wakeup freq.
	CPMUAPIRL=0xFF;
	
	CPMUAPICTL_APIFE=1; //Autonomous periodical interrupt is enabled and timer starts running.
	
	
	/********************************************/
	/**************** STOP MODE *****************/
	/********************************************/
 
  for(;;) {
	  
	  
	  /*MCU is always in stop mode until interrupt happen*/
	  __RESET_WATCHDOG();	/* feeds the dog */ 
	  
	  /*Stop Mode*/
	  	// Enter STOP mode
	  	    asm(CLI);
	  	    asm(andcc #0x7f);
	  	    asm(stop);
	  
	 // asm(WAI);         	/* Set wait mode */		
	 //Counters keeps on running on wait mode, unless TSWAI in TSCR1 is set to 1.
	  
	       
  } /* loop forever */

}

void interrupt VectorNumber_Vapi Api_interrupt(){

	//clear timer flag
	CPMUAPICTL_APIF=1; //Clear API flag
	
	//change LED state
	PTP_PTP5 ^= 1;
}

