#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void busclk_init() {						

	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			//FBUS = FPLL/2.   FBUS = 16MHz, 
	
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		//FREF=4/(1+1) = 2MHZ	
	
	CPMUSYNR_VCOFRQ = 0x0;          //FVCO is between 32MHZ and 48MHZ	
	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 32MHZ 
	
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags
	  
	ECLKCTL_NECLK = 0;				// BUSCLock by PS3 enabled	
	}



void main(void) {

	busclk_init();
	EnableInterrupts;
	  /********************************************/
 	  /************ PWM INITIALIZATION ************/
 	  /********************************************/
 	  
 	  //1. Select 8 bit (CONxx=0) or 16 bit (CONxx=1) operation. **Register for concatenation**
 	  PWMCTL = 0;
 	  
 	  //2. Select the clock source (PWMCLK register).
 	  PWMCLK_PCLK0 = 1;		// Clock SA
 	  PWMCLK_PCLK1 = 0;		// Clock A
 	  PWMCLK_PCLK3 = 0;		// Clock B
 	  PWMCLK_PCLK5 = 0;		// Clock A

 	  
 	  //3. Configure prescaler clock (PWMPRCLK register).
 	  PWMPRCLK = 0x44;		// Prescaler Select for Clock A-B, CLKPWM = BUS_CLK/16 = 16Mhz/16 = 1MHz
 	  	  	  	  	  	  	// 0b1000100= Clock A: busclock/16
 	  	  	  	  	  	  	//  	  	  Clock B: busclick/16
 	  
 	  PWMSCLA = 2;			// Clock SA = ClockA/(2*PWMSCLA) = 1MHz/(2*2) = 250kHz
 		
 	  
 	  //4. Configure duty (PWMDTYx) and period (PWMPERx).
 	  PWMPER0 = 50;		    // PWM0_PER = (1/ClockSA)*PWMPER0 =  50 usec  -> 20.0kHz
 	  PWMPER1 = 200;		// PWM1_PER = (1/Clock A)*PWMPER1 = 200 usec  -> 5.00kHz
 	  PWMPER3 = 200;		// PWM3_PER = (1/Clock B)*PWMPER3 = 200 usec  -> 5.00kHz
 	  PWMPER5 = 200;		// PWM5_PER = (1/Clock A)*PWMPER5 = 200 usec  -> 5.00kHz
 	  PWMPER7 = 200;		// PWM5_PER = (1/Clock A)*PWMPER5 = 200 usec  -> 5.00kHz
 	  
 	  // PWM duty cycle starts at 0%
 	  PWMDTY0 = 0;
 	  PWMDTY1 = 0;
 	  PWMDTY3 = 0;
 	  PWMDTY5 = 0;
 	  PWMDTY7 = 0;
 	  
 	  //5. Select the PWM polarity (PWMPOL).
 	  PWMPOL_PPOL0 = 0;     // Output is low at the beginning of the period
 	  PWMPOL_PPOL1 = 1;		// Output is high at the beginning of the period
 	  PWMPOL_PPOL3 = 1;
 	  PWMPOL_PPOL5 = 1;
 	  PWMPOL_PPOL7 = 1;
 	  
 	  //6. Select left aligned (CAEx=0) or center aligned (CAEx=1) output.
 	  PWMCAE = 0x00;
 	  
 	  //7. Enable the needed channels (PWMEx=1).
 	  PWME_PWME0 = 1;		// Pulse width channel 0 is enabled 
 	  PWME_PWME1 = 1;		// Pulse width channel 1 is enabled 
 	  PWME_PWME3 = 1;		// Pulse width channel 3 is enabled	
 	  PWME_PWME5 = 1;		// Pulse width channel 5 is enabled 
 	  PWME_PWME7 = 1;		// Pulse width channel 7 is enabled
  

  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
  /*  Polarity = 0 (PPOL x =0)
		Duty Cycle = [(PWMPERx-PWMDTYx)/PWMPERx] * 100%
	  Polarity = 1 (PPOLx = 1)
	    Duty Cycle = [PWMDTYx / PWMPERx] * 100%          */
    
	 // PWMDTY0 = 25;    //Duty Cycle= (25/50)*100%   = 50%  //Buzzer output
	  PWMDTY1 = 50;    //Duty Cycle= (50/200)*100%  = 25% 
	  PWMDTY3 = 100;   //Duty Cycle= (100/200)*100% = 50% 
	  PWMDTY5 = 150;   //Duty Cycle= (150/200)*100% = 75% 
	  PWMDTY7 = 200;   //Duty Cycle= (200/200)*100% = 100% 
    
  } /* loop forever */

}
